#!/usr/pkg/bin/python3.10
# coding=utf-8
#
# Copyright (C) 2009 Aurelio A. Heckert, aurium (a) gmail dot com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#

import os
import re
import sys

import inkex
from inkex import Script


class InkWebEffect(inkex.EffectExtension):
    reUpdateJS = "/\\*\\s* inkweb.js [^*]* InkWebEffect:AutoUpdate \\s*\\*/"

    def effect(self):
        pass

    def mustAddInkWebJSCode(self, script):
        if not script.text:
            return True
        if re.search(self.reUpdateJS, script.text):
            return True
        return False

    def addInkWebJSCode(self, script):
        with open(os.path.join(sys.path[0], "inkweb.js")) as js:
            script.set_text("\n/* inkweb.js - InkWebEffect:AutoUpdate */\n" + js.read())

    def ensureInkWebSupport(self):
        # Search for the script tag with the inkweb.js code:
        script = None
        for child in self.svg.xpath("//svg:script"):
            if re.search(self.reUpdateJS, child.text):
                script = child

        if script is None:
            script = Script(id="inkwebjs", type="text/javascript")
            self.svg.insert(0, script)

        if self.mustAddInkWebJSCode(script):
            self.addInkWebJSCode(script)
