#!/usr/pkg/bin/bash

# Exit if anything fails
set -e

which nim > /dev/null || (echo "nim not in PATH"; exit 1)
which gdb > /dev/null || (echo "gdb not in PATH"; exit 1)

if [[ "$(uname -s)" == "Darwin" || "$(uname -s)" == *"BSD" ]]; then
  which greadlink > /dev/null || (echo "readlink not in PATH. Please install coreutils from homebrew."; exit 1)
  READLINK=greadlink
else
  which readlink > /dev/null || (echo "readlink not in PATH."; exit 1)
  READLINK=readlink
fi

# Find out where the pretty printer Python module is
NIM_SYSROOT=$(dirname $(dirname $($READLINK -e $(which nim))))
GDB_PYTHON_MODULE_PATH="$NIM_SYSROOT/tools/nim-gdb.py"

# Run GDB with the additional arguments that load the pretty printers
# Set the environment variable `NIM_GDB` to overwrite the call to a
# different/specific command (defaults to `gdb`).
NIM_GDB="${NIM_GDB:-gdb}"
# exec replaces the new process of bash with gdb. It is always good to
# have fewer processes.
exec "${NIM_GDB}" -eval-command="source $GDB_PYTHON_MODULE_PATH" "$@"
#!/usr/bin/env bash

# Exit if anything fails
set -e

which nim > /dev/null || (echo "nim not in PATH"; exit 1)
which gdb > /dev/null || (echo "gdb not in PATH"; exit 1)
which readlink > /dev/null || (echo "readlink not in PATH."; exit 1)

if [[ "$(uname -s)" == "Darwin" || "(uname -s)" == *"BSD" ]]; then
  NIM_SYSROOT=$(dirname $(dirname $(readlink -f $(which nim))))
else
  NIM_SYSROOT=$(dirname $(dirname $(readlink -e $(which nim))))
fi

# Find out where the pretty printer Python module is
GDB_PYTHON_MODULE_PATH="$NIM_SYSROOT/tools/nim-gdb.py"

# Run GDB with the additional arguments that load the pretty printers
# Set the environment variable `NIM_GDB` to overwrite the call to a
# different/specific command (defaults to `gdb`).
NIM_GDB="${NIM_GDB:-gdb}"
# exec replaces the new process of bash with gdb. It is always good to
# have fewer processes.
exec "${NIM_GDB}" -eval-command="source $GDB_PYTHON_MODULE_PATH" "$@"
