#!/usr/pkg/bin/python3.10
import findrox; findrox.version(1, 9, 8)
import rox
from xml.dom.minidom import getDOMImplementation, parse
import os.path
class AppInfo:
    def __init__(self, path = None):
        if path and os.path.exists(path):
            self.load(path)
        else:
            self.createExNihilo()
    def createExNihilo(self):
        impl = getDOMImplementation()
        self.appInfo = impl.createDocument(None, "AppInfo", None)
        self.topElement = self.appInfo.documentElement

        self.summary = self.appInfo.createElement('Summary')
        self.topElement.appendChild(self.summary)

        self.about = self.appInfo.createElement('About')
        self.topElement.appendChild(self.about)
        
        self.author = self.appInfo.createElement('Author')
        self.about.appendChild(self.author)
        self.comments = self.appInfo.createElement("Comments")
        self.about.appendChild(self.comments)        
        
    def load(self, path):
        try:
            self.appInfo = parse(path)
            self.topElement = self.appInfo.documentElement
        except:
            rox.report_exception()
        self.summary = self.appInfo.getElementsByTagName("Summary").item(0)
        if not self.summary:
            self.summary = self.appInfo.createElement('Summary')
            self.topElement.appendChild(self.summary)
        self.about   = self.appInfo.getElementsByTagName("About").item(0)
        if not self.about:
            self.about = self.appInfo.createElement('About')
            self.topElement.appendChild(self.about)
        self.author  = self.about.getElementsByTagName("Author").item(0)
        if not self.author:
            self.author = self.about.getElementsByTagName("Authors").item(0)
        if not self.author:
            self.author = self.appInfo.createElement('Author')
            self.about.appendChild(self.author)
        self.comments = self.about.getElementsByTagName("Comments").item(0)
        if not self.comments:
            self.comments = self.appInfo.createElement("Comments")
            self.about.appendChild(self.comments)

    def setSummary(self, summary):
        try:
            self.summary.childNodes[0].data = summary
        except IndexError:
            text = self.appInfo.createTextNode(summary)
            self.summary.appendChild(text)  

    def getSummary(self):
        try:
            return self.summary.childNodes[0].data
        except:
            return ""
    def setAuthor(self, author):
        try:
            self.author.childNodes[0].data = author
        except:
            text = self.appInfo.createTextNode(author)
            self.author.appendChild(text)

    def getAuthor(self):
        try:
            return self.author.childNodes[0].data
        except:
            return ""
    
    def setComments(self, comments):
        try:
            self.comments.childNodes[0].data = comments
        except IndexError:
            text = self.appInfo.createTextNode(comments)
            self.comments.appendChild(text)

    def getComments(self):
        try:
            return self.comments.childNodes[0].data
        except:
            return ""
    def toString(self):
        return self.appInfo.toxml()
    def write(self, path):
        try:
            f = open(path, 'w')
            #self.appInfo.writexml(f)
            f.write(self.toString())
            f.close()
        except:
            rox.report_exception()
