require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__AMDGPU_DRM_H__)) {
    eval 'sub __AMDGPU_DRM_H__ () {1;}' unless defined(&__AMDGPU_DRM_H__);
    require './drm/drm.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub DRM_AMDGPU_GEM_CREATE () {0x;}' unless defined(&DRM_AMDGPU_GEM_CREATE);
    eval 'sub DRM_AMDGPU_GEM_MMAP () {0x1;}' unless defined(&DRM_AMDGPU_GEM_MMAP);
    eval 'sub DRM_AMDGPU_CTX () {0x2;}' unless defined(&DRM_AMDGPU_CTX);
    eval 'sub DRM_AMDGPU_BO_LIST () {0x3;}' unless defined(&DRM_AMDGPU_BO_LIST);
    eval 'sub DRM_AMDGPU_CS () {0x4;}' unless defined(&DRM_AMDGPU_CS);
    eval 'sub DRM_AMDGPU_INFO () {0x5;}' unless defined(&DRM_AMDGPU_INFO);
    eval 'sub DRM_AMDGPU_GEM_METADATA () {0x6;}' unless defined(&DRM_AMDGPU_GEM_METADATA);
    eval 'sub DRM_AMDGPU_GEM_WAIT_IDLE () {0x7;}' unless defined(&DRM_AMDGPU_GEM_WAIT_IDLE);
    eval 'sub DRM_AMDGPU_GEM_VA () {0x8;}' unless defined(&DRM_AMDGPU_GEM_VA);
    eval 'sub DRM_AMDGPU_WAIT_CS () {0x9;}' unless defined(&DRM_AMDGPU_WAIT_CS);
    eval 'sub DRM_AMDGPU_GEM_OP () {0x10;}' unless defined(&DRM_AMDGPU_GEM_OP);
    eval 'sub DRM_AMDGPU_GEM_USERPTR () {0x11;}' unless defined(&DRM_AMDGPU_GEM_USERPTR);
    eval 'sub DRM_AMDGPU_WAIT_FENCES () {0x12;}' unless defined(&DRM_AMDGPU_WAIT_FENCES);
    eval 'sub DRM_AMDGPU_VM () {0x13;}' unless defined(&DRM_AMDGPU_VM);
    eval 'sub DRM_AMDGPU_FENCE_TO_HANDLE () {0x14;}' unless defined(&DRM_AMDGPU_FENCE_TO_HANDLE);
    eval 'sub DRM_AMDGPU_SCHED () {0x15;}' unless defined(&DRM_AMDGPU_SCHED);
    eval 'sub DRM_IOCTL_AMDGPU_GEM_CREATE () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_GEM_CREATE, \'union drm_amdgpu_gem_create\');}' unless defined(&DRM_IOCTL_AMDGPU_GEM_CREATE);
    eval 'sub DRM_IOCTL_AMDGPU_GEM_MMAP () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_GEM_MMAP, \'union drm_amdgpu_gem_mmap\');}' unless defined(&DRM_IOCTL_AMDGPU_GEM_MMAP);
    eval 'sub DRM_IOCTL_AMDGPU_CTX () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_CTX, \'union drm_amdgpu_ctx\');}' unless defined(&DRM_IOCTL_AMDGPU_CTX);
    eval 'sub DRM_IOCTL_AMDGPU_BO_LIST () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_BO_LIST, \'union drm_amdgpu_bo_list\');}' unless defined(&DRM_IOCTL_AMDGPU_BO_LIST);
    eval 'sub DRM_IOCTL_AMDGPU_CS () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_CS, \'union drm_amdgpu_cs\');}' unless defined(&DRM_IOCTL_AMDGPU_CS);
    eval 'sub DRM_IOCTL_AMDGPU_INFO () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_AMDGPU_INFO, \'struct drm_amdgpu_info\');}' unless defined(&DRM_IOCTL_AMDGPU_INFO);
    eval 'sub DRM_IOCTL_AMDGPU_GEM_METADATA () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_GEM_METADATA, \'struct drm_amdgpu_gem_metadata\');}' unless defined(&DRM_IOCTL_AMDGPU_GEM_METADATA);
    eval 'sub DRM_IOCTL_AMDGPU_GEM_WAIT_IDLE () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_GEM_WAIT_IDLE, \'union drm_amdgpu_gem_wait_idle\');}' unless defined(&DRM_IOCTL_AMDGPU_GEM_WAIT_IDLE);
    eval 'sub DRM_IOCTL_AMDGPU_GEM_VA () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_AMDGPU_GEM_VA, \'struct drm_amdgpu_gem_va\');}' unless defined(&DRM_IOCTL_AMDGPU_GEM_VA);
    eval 'sub DRM_IOCTL_AMDGPU_WAIT_CS () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_WAIT_CS, \'union drm_amdgpu_wait_cs\');}' unless defined(&DRM_IOCTL_AMDGPU_WAIT_CS);
    eval 'sub DRM_IOCTL_AMDGPU_GEM_OP () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_GEM_OP, \'struct drm_amdgpu_gem_op\');}' unless defined(&DRM_IOCTL_AMDGPU_GEM_OP);
    eval 'sub DRM_IOCTL_AMDGPU_GEM_USERPTR () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_GEM_USERPTR, \'struct drm_amdgpu_gem_userptr\');}' unless defined(&DRM_IOCTL_AMDGPU_GEM_USERPTR);
    eval 'sub DRM_IOCTL_AMDGPU_WAIT_FENCES () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_WAIT_FENCES, \'union drm_amdgpu_wait_fences\');}' unless defined(&DRM_IOCTL_AMDGPU_WAIT_FENCES);
    eval 'sub DRM_IOCTL_AMDGPU_VM () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_VM, \'union drm_amdgpu_vm\');}' unless defined(&DRM_IOCTL_AMDGPU_VM);
    eval 'sub DRM_IOCTL_AMDGPU_FENCE_TO_HANDLE () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_AMDGPU_FENCE_TO_HANDLE, \'union drm_amdgpu_fence_to_handle\');}' unless defined(&DRM_IOCTL_AMDGPU_FENCE_TO_HANDLE);
    eval 'sub DRM_IOCTL_AMDGPU_SCHED () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_AMDGPU_SCHED, \'union drm_amdgpu_sched\');}' unless defined(&DRM_IOCTL_AMDGPU_SCHED);
    eval 'sub AMDGPU_GEM_DOMAIN_CPU () {0x1;}' unless defined(&AMDGPU_GEM_DOMAIN_CPU);
    eval 'sub AMDGPU_GEM_DOMAIN_GTT () {0x2;}' unless defined(&AMDGPU_GEM_DOMAIN_GTT);
    eval 'sub AMDGPU_GEM_DOMAIN_VRAM () {0x4;}' unless defined(&AMDGPU_GEM_DOMAIN_VRAM);
    eval 'sub AMDGPU_GEM_DOMAIN_GDS () {0x8;}' unless defined(&AMDGPU_GEM_DOMAIN_GDS);
    eval 'sub AMDGPU_GEM_DOMAIN_GWS () {0x10;}' unless defined(&AMDGPU_GEM_DOMAIN_GWS);
    eval 'sub AMDGPU_GEM_DOMAIN_OA () {0x20;}' unless defined(&AMDGPU_GEM_DOMAIN_OA);
    eval 'sub AMDGPU_GEM_DOMAIN_MASK () {( &AMDGPU_GEM_DOMAIN_CPU |  &AMDGPU_GEM_DOMAIN_GTT |  &AMDGPU_GEM_DOMAIN_VRAM |  &AMDGPU_GEM_DOMAIN_GDS |  &AMDGPU_GEM_DOMAIN_GWS |  &AMDGPU_GEM_DOMAIN_OA);}' unless defined(&AMDGPU_GEM_DOMAIN_MASK);
    eval 'sub AMDGPU_GEM_CREATE_CPU_ACCESS_REQUIRED () {(1<< 0);}' unless defined(&AMDGPU_GEM_CREATE_CPU_ACCESS_REQUIRED);
    eval 'sub AMDGPU_GEM_CREATE_NO_CPU_ACCESS () {(1<< 1);}' unless defined(&AMDGPU_GEM_CREATE_NO_CPU_ACCESS);
    eval 'sub AMDGPU_GEM_CREATE_CPU_GTT_USWC () {(1<< 2);}' unless defined(&AMDGPU_GEM_CREATE_CPU_GTT_USWC);
    eval 'sub AMDGPU_GEM_CREATE_VRAM_CLEARED () {(1<< 3);}' unless defined(&AMDGPU_GEM_CREATE_VRAM_CLEARED);
    eval 'sub AMDGPU_GEM_CREATE_VRAM_CONTIGUOUS () {(1<< 5);}' unless defined(&AMDGPU_GEM_CREATE_VRAM_CONTIGUOUS);
    eval 'sub AMDGPU_GEM_CREATE_VM_ALWAYS_VALID () {(1<< 6);}' unless defined(&AMDGPU_GEM_CREATE_VM_ALWAYS_VALID);
    eval 'sub AMDGPU_GEM_CREATE_EXPLICIT_SYNC () {(1<< 7);}' unless defined(&AMDGPU_GEM_CREATE_EXPLICIT_SYNC);
    eval 'sub AMDGPU_GEM_CREATE_CP_MQD_GFX9 () {(1<< 8);}' unless defined(&AMDGPU_GEM_CREATE_CP_MQD_GFX9);
    eval 'sub AMDGPU_GEM_CREATE_VRAM_WIPE_ON_RELEASE () {(1<< 9);}' unless defined(&AMDGPU_GEM_CREATE_VRAM_WIPE_ON_RELEASE);
    eval 'sub AMDGPU_GEM_CREATE_ENCRYPTED () {(1<< 10);}' unless defined(&AMDGPU_GEM_CREATE_ENCRYPTED);
    eval 'sub AMDGPU_GEM_CREATE_PREEMPTIBLE () {(1<< 11);}' unless defined(&AMDGPU_GEM_CREATE_PREEMPTIBLE);
    eval 'sub AMDGPU_GEM_CREATE_DISCARDABLE () {(1<< 12);}' unless defined(&AMDGPU_GEM_CREATE_DISCARDABLE);
    eval 'sub AMDGPU_BO_LIST_OP_CREATE () {0;}' unless defined(&AMDGPU_BO_LIST_OP_CREATE);
    eval 'sub AMDGPU_BO_LIST_OP_DESTROY () {1;}' unless defined(&AMDGPU_BO_LIST_OP_DESTROY);
    eval 'sub AMDGPU_BO_LIST_OP_UPDATE () {2;}' unless defined(&AMDGPU_BO_LIST_OP_UPDATE);
    eval 'sub AMDGPU_CTX_OP_ALLOC_CTX () {1;}' unless defined(&AMDGPU_CTX_OP_ALLOC_CTX);
    eval 'sub AMDGPU_CTX_OP_FREE_CTX () {2;}' unless defined(&AMDGPU_CTX_OP_FREE_CTX);
    eval 'sub AMDGPU_CTX_OP_QUERY_STATE () {3;}' unless defined(&AMDGPU_CTX_OP_QUERY_STATE);
    eval 'sub AMDGPU_CTX_OP_QUERY_STATE2 () {4;}' unless defined(&AMDGPU_CTX_OP_QUERY_STATE2);
    eval 'sub AMDGPU_CTX_OP_GET_STABLE_PSTATE () {5;}' unless defined(&AMDGPU_CTX_OP_GET_STABLE_PSTATE);
    eval 'sub AMDGPU_CTX_OP_SET_STABLE_PSTATE () {6;}' unless defined(&AMDGPU_CTX_OP_SET_STABLE_PSTATE);
    eval 'sub AMDGPU_CTX_NO_RESET () {0;}' unless defined(&AMDGPU_CTX_NO_RESET);
    eval 'sub AMDGPU_CTX_GUILTY_RESET () {1;}' unless defined(&AMDGPU_CTX_GUILTY_RESET);
    eval 'sub AMDGPU_CTX_INNOCENT_RESET () {2;}' unless defined(&AMDGPU_CTX_INNOCENT_RESET);
    eval 'sub AMDGPU_CTX_UNKNOWN_RESET () {3;}' unless defined(&AMDGPU_CTX_UNKNOWN_RESET);
    eval 'sub AMDGPU_CTX_QUERY2_FLAGS_RESET () {(1<<0);}' unless defined(&AMDGPU_CTX_QUERY2_FLAGS_RESET);
    eval 'sub AMDGPU_CTX_QUERY2_FLAGS_VRAMLOST () {(1<<1);}' unless defined(&AMDGPU_CTX_QUERY2_FLAGS_VRAMLOST);
    eval 'sub AMDGPU_CTX_QUERY2_FLAGS_GUILTY () {(1<<2);}' unless defined(&AMDGPU_CTX_QUERY2_FLAGS_GUILTY);
    eval 'sub AMDGPU_CTX_QUERY2_FLAGS_RAS_CE () {(1<<3);}' unless defined(&AMDGPU_CTX_QUERY2_FLAGS_RAS_CE);
    eval 'sub AMDGPU_CTX_QUERY2_FLAGS_RAS_UE () {(1<<4);}' unless defined(&AMDGPU_CTX_QUERY2_FLAGS_RAS_UE);
    eval 'sub AMDGPU_CTX_PRIORITY_UNSET () {-2048;}' unless defined(&AMDGPU_CTX_PRIORITY_UNSET);
    eval 'sub AMDGPU_CTX_PRIORITY_VERY_LOW () {-1023;}' unless defined(&AMDGPU_CTX_PRIORITY_VERY_LOW);
    eval 'sub AMDGPU_CTX_PRIORITY_LOW () {-512;}' unless defined(&AMDGPU_CTX_PRIORITY_LOW);
    eval 'sub AMDGPU_CTX_PRIORITY_NORMAL () {0;}' unless defined(&AMDGPU_CTX_PRIORITY_NORMAL);
    eval 'sub AMDGPU_CTX_PRIORITY_HIGH () {512;}' unless defined(&AMDGPU_CTX_PRIORITY_HIGH);
    eval 'sub AMDGPU_CTX_PRIORITY_VERY_HIGH () {1023;}' unless defined(&AMDGPU_CTX_PRIORITY_VERY_HIGH);
    eval 'sub AMDGPU_CTX_STABLE_PSTATE_FLAGS_MASK () {0xf;}' unless defined(&AMDGPU_CTX_STABLE_PSTATE_FLAGS_MASK);
    eval 'sub AMDGPU_CTX_STABLE_PSTATE_NONE () {0;}' unless defined(&AMDGPU_CTX_STABLE_PSTATE_NONE);
    eval 'sub AMDGPU_CTX_STABLE_PSTATE_STANDARD () {1;}' unless defined(&AMDGPU_CTX_STABLE_PSTATE_STANDARD);
    eval 'sub AMDGPU_CTX_STABLE_PSTATE_MIN_SCLK () {2;}' unless defined(&AMDGPU_CTX_STABLE_PSTATE_MIN_SCLK);
    eval 'sub AMDGPU_CTX_STABLE_PSTATE_MIN_MCLK () {3;}' unless defined(&AMDGPU_CTX_STABLE_PSTATE_MIN_MCLK);
    eval 'sub AMDGPU_CTX_STABLE_PSTATE_PEAK () {4;}' unless defined(&AMDGPU_CTX_STABLE_PSTATE_PEAK);
    eval 'sub AMDGPU_VM_OP_RESERVE_VMID () {1;}' unless defined(&AMDGPU_VM_OP_RESERVE_VMID);
    eval 'sub AMDGPU_VM_OP_UNRESERVE_VMID () {2;}' unless defined(&AMDGPU_VM_OP_UNRESERVE_VMID);
    eval 'sub AMDGPU_SCHED_OP_PROCESS_PRIORITY_OVERRIDE () {1;}' unless defined(&AMDGPU_SCHED_OP_PROCESS_PRIORITY_OVERRIDE);
    eval 'sub AMDGPU_SCHED_OP_CONTEXT_PRIORITY_OVERRIDE () {2;}' unless defined(&AMDGPU_SCHED_OP_CONTEXT_PRIORITY_OVERRIDE);
    eval 'sub AMDGPU_GEM_USERPTR_READONLY () {(1<< 0);}' unless defined(&AMDGPU_GEM_USERPTR_READONLY);
    eval 'sub AMDGPU_GEM_USERPTR_ANONONLY () {(1<< 1);}' unless defined(&AMDGPU_GEM_USERPTR_ANONONLY);
    eval 'sub AMDGPU_GEM_USERPTR_VALIDATE () {(1<< 2);}' unless defined(&AMDGPU_GEM_USERPTR_VALIDATE);
    eval 'sub AMDGPU_GEM_USERPTR_REGISTER () {(1<< 3);}' unless defined(&AMDGPU_GEM_USERPTR_REGISTER);
    eval 'sub AMDGPU_TILING_ARRAY_MODE_SHIFT () {0;}' unless defined(&AMDGPU_TILING_ARRAY_MODE_SHIFT);
    eval 'sub AMDGPU_TILING_ARRAY_MODE_MASK () {0xf;}' unless defined(&AMDGPU_TILING_ARRAY_MODE_MASK);
    eval 'sub AMDGPU_TILING_PIPE_CONFIG_SHIFT () {4;}' unless defined(&AMDGPU_TILING_PIPE_CONFIG_SHIFT);
    eval 'sub AMDGPU_TILING_PIPE_CONFIG_MASK () {0x1f;}' unless defined(&AMDGPU_TILING_PIPE_CONFIG_MASK);
    eval 'sub AMDGPU_TILING_TILE_SPLIT_SHIFT () {9;}' unless defined(&AMDGPU_TILING_TILE_SPLIT_SHIFT);
    eval 'sub AMDGPU_TILING_TILE_SPLIT_MASK () {0x7;}' unless defined(&AMDGPU_TILING_TILE_SPLIT_MASK);
    eval 'sub AMDGPU_TILING_MICRO_TILE_MODE_SHIFT () {12;}' unless defined(&AMDGPU_TILING_MICRO_TILE_MODE_SHIFT);
    eval 'sub AMDGPU_TILING_MICRO_TILE_MODE_MASK () {0x7;}' unless defined(&AMDGPU_TILING_MICRO_TILE_MODE_MASK);
    eval 'sub AMDGPU_TILING_BANK_WIDTH_SHIFT () {15;}' unless defined(&AMDGPU_TILING_BANK_WIDTH_SHIFT);
    eval 'sub AMDGPU_TILING_BANK_WIDTH_MASK () {0x3;}' unless defined(&AMDGPU_TILING_BANK_WIDTH_MASK);
    eval 'sub AMDGPU_TILING_BANK_HEIGHT_SHIFT () {17;}' unless defined(&AMDGPU_TILING_BANK_HEIGHT_SHIFT);
    eval 'sub AMDGPU_TILING_BANK_HEIGHT_MASK () {0x3;}' unless defined(&AMDGPU_TILING_BANK_HEIGHT_MASK);
    eval 'sub AMDGPU_TILING_MACRO_TILE_ASPECT_SHIFT () {19;}' unless defined(&AMDGPU_TILING_MACRO_TILE_ASPECT_SHIFT);
    eval 'sub AMDGPU_TILING_MACRO_TILE_ASPECT_MASK () {0x3;}' unless defined(&AMDGPU_TILING_MACRO_TILE_ASPECT_MASK);
    eval 'sub AMDGPU_TILING_NUM_BANKS_SHIFT () {21;}' unless defined(&AMDGPU_TILING_NUM_BANKS_SHIFT);
    eval 'sub AMDGPU_TILING_NUM_BANKS_MASK () {0x3;}' unless defined(&AMDGPU_TILING_NUM_BANKS_MASK);
    eval 'sub AMDGPU_TILING_SWIZZLE_MODE_SHIFT () {0;}' unless defined(&AMDGPU_TILING_SWIZZLE_MODE_SHIFT);
    eval 'sub AMDGPU_TILING_SWIZZLE_MODE_MASK () {0x1f;}' unless defined(&AMDGPU_TILING_SWIZZLE_MODE_MASK);
    eval 'sub AMDGPU_TILING_DCC_OFFSET_256B_SHIFT () {5;}' unless defined(&AMDGPU_TILING_DCC_OFFSET_256B_SHIFT);
    eval 'sub AMDGPU_TILING_DCC_OFFSET_256B_MASK () {0xffffff;}' unless defined(&AMDGPU_TILING_DCC_OFFSET_256B_MASK);
    eval 'sub AMDGPU_TILING_DCC_PITCH_MAX_SHIFT () {29;}' unless defined(&AMDGPU_TILING_DCC_PITCH_MAX_SHIFT);
    eval 'sub AMDGPU_TILING_DCC_PITCH_MAX_MASK () {0x3fff;}' unless defined(&AMDGPU_TILING_DCC_PITCH_MAX_MASK);
    eval 'sub AMDGPU_TILING_DCC_INDEPENDENT_64B_SHIFT () {43;}' unless defined(&AMDGPU_TILING_DCC_INDEPENDENT_64B_SHIFT);
    eval 'sub AMDGPU_TILING_DCC_INDEPENDENT_64B_MASK () {0x1;}' unless defined(&AMDGPU_TILING_DCC_INDEPENDENT_64B_MASK);
    eval 'sub AMDGPU_TILING_DCC_INDEPENDENT_128B_SHIFT () {44;}' unless defined(&AMDGPU_TILING_DCC_INDEPENDENT_128B_SHIFT);
    eval 'sub AMDGPU_TILING_DCC_INDEPENDENT_128B_MASK () {0x1;}' unless defined(&AMDGPU_TILING_DCC_INDEPENDENT_128B_MASK);
    eval 'sub AMDGPU_TILING_SCANOUT_SHIFT () {63;}' unless defined(&AMDGPU_TILING_SCANOUT_SHIFT);
    eval 'sub AMDGPU_TILING_SCANOUT_MASK () {0x1;}' unless defined(&AMDGPU_TILING_SCANOUT_MASK);
    eval 'sub AMDGPU_TILING_SET {
        my($field, $value) = @_;
	    eval q(((( &__u64)($value) &  &AMDGPU_TILING_$field &_MASK) <<  &AMDGPU_TILING_$field &_SHIFT));
    }' unless defined(&AMDGPU_TILING_SET);
    eval 'sub AMDGPU_TILING_GET {
        my($value, $field) = @_;
	    eval q(((( &__u64)($value) >>  &AMDGPU_TILING_$field &_SHIFT) &  &AMDGPU_TILING_$field &_MASK));
    }' unless defined(&AMDGPU_TILING_GET);
    eval 'sub AMDGPU_GEM_METADATA_OP_SET_METADATA () {1;}' unless defined(&AMDGPU_GEM_METADATA_OP_SET_METADATA);
    eval 'sub AMDGPU_GEM_METADATA_OP_GET_METADATA () {2;}' unless defined(&AMDGPU_GEM_METADATA_OP_GET_METADATA);
    eval 'sub AMDGPU_GEM_OP_GET_GEM_CREATE_INFO () {0;}' unless defined(&AMDGPU_GEM_OP_GET_GEM_CREATE_INFO);
    eval 'sub AMDGPU_GEM_OP_SET_PLACEMENT () {1;}' unless defined(&AMDGPU_GEM_OP_SET_PLACEMENT);
    eval 'sub AMDGPU_VA_OP_MAP () {1;}' unless defined(&AMDGPU_VA_OP_MAP);
    eval 'sub AMDGPU_VA_OP_UNMAP () {2;}' unless defined(&AMDGPU_VA_OP_UNMAP);
    eval 'sub AMDGPU_VA_OP_CLEAR () {3;}' unless defined(&AMDGPU_VA_OP_CLEAR);
    eval 'sub AMDGPU_VA_OP_REPLACE () {4;}' unless defined(&AMDGPU_VA_OP_REPLACE);
    eval 'sub AMDGPU_VM_DELAY_UPDATE () {(1<< 0);}' unless defined(&AMDGPU_VM_DELAY_UPDATE);
    eval 'sub AMDGPU_VM_PAGE_READABLE () {(1<< 1);}' unless defined(&AMDGPU_VM_PAGE_READABLE);
    eval 'sub AMDGPU_VM_PAGE_WRITEABLE () {(1<< 2);}' unless defined(&AMDGPU_VM_PAGE_WRITEABLE);
    eval 'sub AMDGPU_VM_PAGE_EXECUTABLE () {(1<< 3);}' unless defined(&AMDGPU_VM_PAGE_EXECUTABLE);
    eval 'sub AMDGPU_VM_PAGE_PRT () {(1<< 4);}' unless defined(&AMDGPU_VM_PAGE_PRT);
    eval 'sub AMDGPU_VM_MTYPE_MASK () {(0xf << 5);}' unless defined(&AMDGPU_VM_MTYPE_MASK);
    eval 'sub AMDGPU_VM_MTYPE_DEFAULT () {(0<< 5);}' unless defined(&AMDGPU_VM_MTYPE_DEFAULT);
    eval 'sub AMDGPU_VM_MTYPE_NC () {(1<< 5);}' unless defined(&AMDGPU_VM_MTYPE_NC);
    eval 'sub AMDGPU_VM_MTYPE_WC () {(2<< 5);}' unless defined(&AMDGPU_VM_MTYPE_WC);
    eval 'sub AMDGPU_VM_MTYPE_CC () {(3<< 5);}' unless defined(&AMDGPU_VM_MTYPE_CC);
    eval 'sub AMDGPU_VM_MTYPE_UC () {(4<< 5);}' unless defined(&AMDGPU_VM_MTYPE_UC);
    eval 'sub AMDGPU_VM_MTYPE_RW () {(5<< 5);}' unless defined(&AMDGPU_VM_MTYPE_RW);
    eval 'sub AMDGPU_VM_PAGE_NOALLOC () {(1<< 9);}' unless defined(&AMDGPU_VM_PAGE_NOALLOC);
    eval 'sub AMDGPU_HW_IP_GFX () {0;}' unless defined(&AMDGPU_HW_IP_GFX);
    eval 'sub AMDGPU_HW_IP_COMPUTE () {1;}' unless defined(&AMDGPU_HW_IP_COMPUTE);
    eval 'sub AMDGPU_HW_IP_DMA () {2;}' unless defined(&AMDGPU_HW_IP_DMA);
    eval 'sub AMDGPU_HW_IP_UVD () {3;}' unless defined(&AMDGPU_HW_IP_UVD);
    eval 'sub AMDGPU_HW_IP_VCE () {4;}' unless defined(&AMDGPU_HW_IP_VCE);
    eval 'sub AMDGPU_HW_IP_UVD_ENC () {5;}' unless defined(&AMDGPU_HW_IP_UVD_ENC);
    eval 'sub AMDGPU_HW_IP_VCN_DEC () {6;}' unless defined(&AMDGPU_HW_IP_VCN_DEC);
    eval 'sub AMDGPU_HW_IP_VCN_ENC () {7;}' unless defined(&AMDGPU_HW_IP_VCN_ENC);
    eval 'sub AMDGPU_HW_IP_VCN_JPEG () {8;}' unless defined(&AMDGPU_HW_IP_VCN_JPEG);
    eval 'sub AMDGPU_HW_IP_NUM () {9;}' unless defined(&AMDGPU_HW_IP_NUM);
    eval 'sub AMDGPU_HW_IP_INSTANCE_MAX_COUNT () {1;}' unless defined(&AMDGPU_HW_IP_INSTANCE_MAX_COUNT);
    eval 'sub AMDGPU_CHUNK_ID_IB () {0x1;}' unless defined(&AMDGPU_CHUNK_ID_IB);
    eval 'sub AMDGPU_CHUNK_ID_FENCE () {0x2;}' unless defined(&AMDGPU_CHUNK_ID_FENCE);
    eval 'sub AMDGPU_CHUNK_ID_DEPENDENCIES () {0x3;}' unless defined(&AMDGPU_CHUNK_ID_DEPENDENCIES);
    eval 'sub AMDGPU_CHUNK_ID_SYNCOBJ_IN () {0x4;}' unless defined(&AMDGPU_CHUNK_ID_SYNCOBJ_IN);
    eval 'sub AMDGPU_CHUNK_ID_SYNCOBJ_OUT () {0x5;}' unless defined(&AMDGPU_CHUNK_ID_SYNCOBJ_OUT);
    eval 'sub AMDGPU_CHUNK_ID_BO_HANDLES () {0x6;}' unless defined(&AMDGPU_CHUNK_ID_BO_HANDLES);
    eval 'sub AMDGPU_CHUNK_ID_SCHEDULED_DEPENDENCIES () {0x7;}' unless defined(&AMDGPU_CHUNK_ID_SCHEDULED_DEPENDENCIES);
    eval 'sub AMDGPU_CHUNK_ID_SYNCOBJ_TIMELINE_WAIT () {0x8;}' unless defined(&AMDGPU_CHUNK_ID_SYNCOBJ_TIMELINE_WAIT);
    eval 'sub AMDGPU_CHUNK_ID_SYNCOBJ_TIMELINE_SIGNAL () {0x9;}' unless defined(&AMDGPU_CHUNK_ID_SYNCOBJ_TIMELINE_SIGNAL);
    eval 'sub AMDGPU_IB_FLAG_CE () {(1<<0);}' unless defined(&AMDGPU_IB_FLAG_CE);
    eval 'sub AMDGPU_IB_FLAG_PREAMBLE () {(1<<1);}' unless defined(&AMDGPU_IB_FLAG_PREAMBLE);
    eval 'sub AMDGPU_IB_FLAG_PREEMPT () {(1<<2);}' unless defined(&AMDGPU_IB_FLAG_PREEMPT);
    eval 'sub AMDGPU_IB_FLAG_TC_WB_NOT_INVALIDATE () {(1<< 3);}' unless defined(&AMDGPU_IB_FLAG_TC_WB_NOT_INVALIDATE);
    eval 'sub AMDGPU_IB_FLAG_RESET_GDS_MAX_WAVE_ID () {(1<< 4);}' unless defined(&AMDGPU_IB_FLAG_RESET_GDS_MAX_WAVE_ID);
    eval 'sub AMDGPU_IB_FLAGS_SECURE () {(1<< 5);}' unless defined(&AMDGPU_IB_FLAGS_SECURE);
    eval 'sub AMDGPU_IB_FLAG_EMIT_MEM_SYNC () {(1<< 6);}' unless defined(&AMDGPU_IB_FLAG_EMIT_MEM_SYNC);
    eval 'sub AMDGPU_FENCE_TO_HANDLE_GET_SYNCOBJ () {0;}' unless defined(&AMDGPU_FENCE_TO_HANDLE_GET_SYNCOBJ);
    eval 'sub AMDGPU_FENCE_TO_HANDLE_GET_SYNCOBJ_FD () {1;}' unless defined(&AMDGPU_FENCE_TO_HANDLE_GET_SYNCOBJ_FD);
    eval 'sub AMDGPU_FENCE_TO_HANDLE_GET_SYNC_FILE_FD () {2;}' unless defined(&AMDGPU_FENCE_TO_HANDLE_GET_SYNC_FILE_FD);
    eval 'sub AMDGPU_IDS_FLAGS_FUSION () {0x1;}' unless defined(&AMDGPU_IDS_FLAGS_FUSION);
    eval 'sub AMDGPU_IDS_FLAGS_PREEMPTION () {0x2;}' unless defined(&AMDGPU_IDS_FLAGS_PREEMPTION);
    eval 'sub AMDGPU_IDS_FLAGS_TMZ () {0x4;}' unless defined(&AMDGPU_IDS_FLAGS_TMZ);
    eval 'sub AMDGPU_INFO_ACCEL_WORKING () {0x;}' unless defined(&AMDGPU_INFO_ACCEL_WORKING);
    eval 'sub AMDGPU_INFO_CRTC_FROM_ID () {0x1;}' unless defined(&AMDGPU_INFO_CRTC_FROM_ID);
    eval 'sub AMDGPU_INFO_HW_IP_INFO () {0x2;}' unless defined(&AMDGPU_INFO_HW_IP_INFO);
    eval 'sub AMDGPU_INFO_HW_IP_COUNT () {0x3;}' unless defined(&AMDGPU_INFO_HW_IP_COUNT);
    eval 'sub AMDGPU_INFO_TIMESTAMP () {0x5;}' unless defined(&AMDGPU_INFO_TIMESTAMP);
    eval 'sub AMDGPU_INFO_FW_VERSION () {0xe;}' unless defined(&AMDGPU_INFO_FW_VERSION);
    eval 'sub AMDGPU_INFO_FW_VCE () {0x1;}' unless defined(&AMDGPU_INFO_FW_VCE);
    eval 'sub AMDGPU_INFO_FW_UVD () {0x2;}' unless defined(&AMDGPU_INFO_FW_UVD);
    eval 'sub AMDGPU_INFO_FW_GMC () {0x3;}' unless defined(&AMDGPU_INFO_FW_GMC);
    eval 'sub AMDGPU_INFO_FW_GFX_ME () {0x4;}' unless defined(&AMDGPU_INFO_FW_GFX_ME);
    eval 'sub AMDGPU_INFO_FW_GFX_PFP () {0x5;}' unless defined(&AMDGPU_INFO_FW_GFX_PFP);
    eval 'sub AMDGPU_INFO_FW_GFX_CE () {0x6;}' unless defined(&AMDGPU_INFO_FW_GFX_CE);
    eval 'sub AMDGPU_INFO_FW_GFX_RLC () {0x7;}' unless defined(&AMDGPU_INFO_FW_GFX_RLC);
    eval 'sub AMDGPU_INFO_FW_GFX_MEC () {0x8;}' unless defined(&AMDGPU_INFO_FW_GFX_MEC);
    eval 'sub AMDGPU_INFO_FW_SMC () {0xa;}' unless defined(&AMDGPU_INFO_FW_SMC);
    eval 'sub AMDGPU_INFO_FW_SDMA () {0xb;}' unless defined(&AMDGPU_INFO_FW_SDMA);
    eval 'sub AMDGPU_INFO_FW_SOS () {0xc;}' unless defined(&AMDGPU_INFO_FW_SOS);
    eval 'sub AMDGPU_INFO_FW_ASD () {0xd;}' unless defined(&AMDGPU_INFO_FW_ASD);
    eval 'sub AMDGPU_INFO_FW_VCN () {0xe;}' unless defined(&AMDGPU_INFO_FW_VCN);
    eval 'sub AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_CNTL () {0xf;}' unless defined(&AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_CNTL);
    eval 'sub AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_GPM_MEM () {0x10;}' unless defined(&AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_GPM_MEM);
    eval 'sub AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_SRM_MEM () {0x11;}' unless defined(&AMDGPU_INFO_FW_GFX_RLC_RESTORE_LIST_SRM_MEM);
    eval 'sub AMDGPU_INFO_FW_DMCU () {0x12;}' unless defined(&AMDGPU_INFO_FW_DMCU);
    eval 'sub AMDGPU_INFO_FW_TA () {0x13;}' unless defined(&AMDGPU_INFO_FW_TA);
    eval 'sub AMDGPU_INFO_FW_DMCUB () {0x14;}' unless defined(&AMDGPU_INFO_FW_DMCUB);
    eval 'sub AMDGPU_INFO_FW_TOC () {0x15;}' unless defined(&AMDGPU_INFO_FW_TOC);
    eval 'sub AMDGPU_INFO_FW_CAP () {0x16;}' unless defined(&AMDGPU_INFO_FW_CAP);
    eval 'sub AMDGPU_INFO_NUM_BYTES_MOVED () {0xf;}' unless defined(&AMDGPU_INFO_NUM_BYTES_MOVED);
    eval 'sub AMDGPU_INFO_VRAM_USAGE () {0x10;}' unless defined(&AMDGPU_INFO_VRAM_USAGE);
    eval 'sub AMDGPU_INFO_GTT_USAGE () {0x11;}' unless defined(&AMDGPU_INFO_GTT_USAGE);
    eval 'sub AMDGPU_INFO_GDS_CONFIG () {0x13;}' unless defined(&AMDGPU_INFO_GDS_CONFIG);
    eval 'sub AMDGPU_INFO_VRAM_GTT () {0x14;}' unless defined(&AMDGPU_INFO_VRAM_GTT);
    eval 'sub AMDGPU_INFO_READ_MMR_REG () {0x15;}' unless defined(&AMDGPU_INFO_READ_MMR_REG);
    eval 'sub AMDGPU_INFO_DEV_INFO () {0x16;}' unless defined(&AMDGPU_INFO_DEV_INFO);
    eval 'sub AMDGPU_INFO_VIS_VRAM_USAGE () {0x17;}' unless defined(&AMDGPU_INFO_VIS_VRAM_USAGE);
    eval 'sub AMDGPU_INFO_NUM_EVICTIONS () {0x18;}' unless defined(&AMDGPU_INFO_NUM_EVICTIONS);
    eval 'sub AMDGPU_INFO_MEMORY () {0x19;}' unless defined(&AMDGPU_INFO_MEMORY);
    eval 'sub AMDGPU_INFO_VCE_CLOCK_TABLE () {0x1a;}' unless defined(&AMDGPU_INFO_VCE_CLOCK_TABLE);
    eval 'sub AMDGPU_INFO_VBIOS () {0x1b;}' unless defined(&AMDGPU_INFO_VBIOS);
    eval 'sub AMDGPU_INFO_VBIOS_SIZE () {0x1;}' unless defined(&AMDGPU_INFO_VBIOS_SIZE);
    eval 'sub AMDGPU_INFO_VBIOS_IMAGE () {0x2;}' unless defined(&AMDGPU_INFO_VBIOS_IMAGE);
    eval 'sub AMDGPU_INFO_VBIOS_INFO () {0x3;}' unless defined(&AMDGPU_INFO_VBIOS_INFO);
    eval 'sub AMDGPU_INFO_NUM_HANDLES () {0x1c;}' unless defined(&AMDGPU_INFO_NUM_HANDLES);
    eval 'sub AMDGPU_INFO_SENSOR () {0x1d;}' unless defined(&AMDGPU_INFO_SENSOR);
    eval 'sub AMDGPU_INFO_SENSOR_GFX_SCLK () {0x1;}' unless defined(&AMDGPU_INFO_SENSOR_GFX_SCLK);
    eval 'sub AMDGPU_INFO_SENSOR_GFX_MCLK () {0x2;}' unless defined(&AMDGPU_INFO_SENSOR_GFX_MCLK);
    eval 'sub AMDGPU_INFO_SENSOR_GPU_TEMP () {0x3;}' unless defined(&AMDGPU_INFO_SENSOR_GPU_TEMP);
    eval 'sub AMDGPU_INFO_SENSOR_GPU_LOAD () {0x4;}' unless defined(&AMDGPU_INFO_SENSOR_GPU_LOAD);
    eval 'sub AMDGPU_INFO_SENSOR_GPU_AVG_POWER () {0x5;}' unless defined(&AMDGPU_INFO_SENSOR_GPU_AVG_POWER);
    eval 'sub AMDGPU_INFO_SENSOR_VDDNB () {0x6;}' unless defined(&AMDGPU_INFO_SENSOR_VDDNB);
    eval 'sub AMDGPU_INFO_SENSOR_VDDGFX () {0x7;}' unless defined(&AMDGPU_INFO_SENSOR_VDDGFX);
    eval 'sub AMDGPU_INFO_SENSOR_STABLE_PSTATE_GFX_SCLK () {0x8;}' unless defined(&AMDGPU_INFO_SENSOR_STABLE_PSTATE_GFX_SCLK);
    eval 'sub AMDGPU_INFO_SENSOR_STABLE_PSTATE_GFX_MCLK () {0x9;}' unless defined(&AMDGPU_INFO_SENSOR_STABLE_PSTATE_GFX_MCLK);
    eval 'sub AMDGPU_INFO_NUM_VRAM_CPU_PAGE_FAULTS () {0x1e;}' unless defined(&AMDGPU_INFO_NUM_VRAM_CPU_PAGE_FAULTS);
    eval 'sub AMDGPU_INFO_VRAM_LOST_COUNTER () {0x1f;}' unless defined(&AMDGPU_INFO_VRAM_LOST_COUNTER);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_FEATURES () {0x20;}' unless defined(&AMDGPU_INFO_RAS_ENABLED_FEATURES);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_UMC () {(1<< 0);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_UMC);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_SDMA () {(1<< 1);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_SDMA);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_GFX () {(1<< 2);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_GFX);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_MMHUB () {(1<< 3);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_MMHUB);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_ATHUB () {(1<< 4);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_ATHUB);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_PCIE () {(1<< 5);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_PCIE);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_HDP () {(1<< 6);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_HDP);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_XGMI () {(1<< 7);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_XGMI);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_DF () {(1<< 8);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_DF);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_SMN () {(1<< 9);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_SMN);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_SEM () {(1<< 10);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_SEM);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_MP0 () {(1<< 11);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_MP0);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_MP1 () {(1<< 12);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_MP1);
    eval 'sub AMDGPU_INFO_RAS_ENABLED_FUSE () {(1<< 13);}' unless defined(&AMDGPU_INFO_RAS_ENABLED_FUSE);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS () {0x21;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_DECODE () {0;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_DECODE);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_ENCODE () {1;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_ENCODE);
    eval 'sub AMDGPU_INFO_MMR_SE_INDEX_SHIFT () {0;}' unless defined(&AMDGPU_INFO_MMR_SE_INDEX_SHIFT);
    eval 'sub AMDGPU_INFO_MMR_SE_INDEX_MASK () {0xff;}' unless defined(&AMDGPU_INFO_MMR_SE_INDEX_MASK);
    eval 'sub AMDGPU_INFO_MMR_SH_INDEX_SHIFT () {8;}' unless defined(&AMDGPU_INFO_MMR_SH_INDEX_SHIFT);
    eval 'sub AMDGPU_INFO_MMR_SH_INDEX_MASK () {0xff;}' unless defined(&AMDGPU_INFO_MMR_SH_INDEX_MASK);
    eval 'sub AMDGPU_VRAM_TYPE_UNKNOWN () {0;}' unless defined(&AMDGPU_VRAM_TYPE_UNKNOWN);
    eval 'sub AMDGPU_VRAM_TYPE_GDDR1 () {1;}' unless defined(&AMDGPU_VRAM_TYPE_GDDR1);
    eval 'sub AMDGPU_VRAM_TYPE_DDR2 () {2;}' unless defined(&AMDGPU_VRAM_TYPE_DDR2);
    eval 'sub AMDGPU_VRAM_TYPE_GDDR3 () {3;}' unless defined(&AMDGPU_VRAM_TYPE_GDDR3);
    eval 'sub AMDGPU_VRAM_TYPE_GDDR4 () {4;}' unless defined(&AMDGPU_VRAM_TYPE_GDDR4);
    eval 'sub AMDGPU_VRAM_TYPE_GDDR5 () {5;}' unless defined(&AMDGPU_VRAM_TYPE_GDDR5);
    eval 'sub AMDGPU_VRAM_TYPE_HBM () {6;}' unless defined(&AMDGPU_VRAM_TYPE_HBM);
    eval 'sub AMDGPU_VRAM_TYPE_DDR3 () {7;}' unless defined(&AMDGPU_VRAM_TYPE_DDR3);
    eval 'sub AMDGPU_VRAM_TYPE_DDR4 () {8;}' unless defined(&AMDGPU_VRAM_TYPE_DDR4);
    eval 'sub AMDGPU_VRAM_TYPE_GDDR6 () {9;}' unless defined(&AMDGPU_VRAM_TYPE_GDDR6);
    eval 'sub AMDGPU_VRAM_TYPE_DDR5 () {10;}' unless defined(&AMDGPU_VRAM_TYPE_DDR5);
    eval 'sub AMDGPU_VRAM_TYPE_LPDDR4 () {11;}' unless defined(&AMDGPU_VRAM_TYPE_LPDDR4);
    eval 'sub AMDGPU_VRAM_TYPE_LPDDR5 () {12;}' unless defined(&AMDGPU_VRAM_TYPE_LPDDR5);
    eval 'sub AMDGPU_VCE_CLOCK_TABLE_ENTRIES () {6;}' unless defined(&AMDGPU_VCE_CLOCK_TABLE_ENTRIES);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG2 () {0;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG2);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG4 () {1;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG4);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_VC1 () {2;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_VC1);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG4_AVC () {3;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_MPEG4_AVC);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_HEVC () {4;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_HEVC);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_JPEG () {5;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_JPEG);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_VP9 () {6;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_VP9);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_AV1 () {7;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_AV1);
    eval 'sub AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_COUNT () {8;}' unless defined(&AMDGPU_INFO_VIDEO_CAPS_CODEC_IDX_COUNT);
    eval 'sub AMDGPU_FAMILY_UNKNOWN () {0;}' unless defined(&AMDGPU_FAMILY_UNKNOWN);
    eval 'sub AMDGPU_FAMILY_SI () {110;}' unless defined(&AMDGPU_FAMILY_SI);
    eval 'sub AMDGPU_FAMILY_CI () {120;}' unless defined(&AMDGPU_FAMILY_CI);
    eval 'sub AMDGPU_FAMILY_KV () {125;}' unless defined(&AMDGPU_FAMILY_KV);
    eval 'sub AMDGPU_FAMILY_VI () {130;}' unless defined(&AMDGPU_FAMILY_VI);
    eval 'sub AMDGPU_FAMILY_CZ () {135;}' unless defined(&AMDGPU_FAMILY_CZ);
    eval 'sub AMDGPU_FAMILY_AI () {141;}' unless defined(&AMDGPU_FAMILY_AI);
    eval 'sub AMDGPU_FAMILY_RV () {142;}' unless defined(&AMDGPU_FAMILY_RV);
    eval 'sub AMDGPU_FAMILY_NV () {143;}' unless defined(&AMDGPU_FAMILY_NV);
    eval 'sub AMDGPU_FAMILY_VGH () {144;}' unless defined(&AMDGPU_FAMILY_VGH);
    eval 'sub AMDGPU_FAMILY_GC_11_0_0 () {145;}' unless defined(&AMDGPU_FAMILY_GC_11_0_0);
    eval 'sub AMDGPU_FAMILY_YC () {146;}' unless defined(&AMDGPU_FAMILY_YC);
    eval 'sub AMDGPU_FAMILY_GC_11_0_1 () {148;}' unless defined(&AMDGPU_FAMILY_GC_11_0_1);
    eval 'sub AMDGPU_FAMILY_GC_10_3_6 () {149;}' unless defined(&AMDGPU_FAMILY_GC_10_3_6);
    eval 'sub AMDGPU_FAMILY_GC_10_3_7 () {151;}' unless defined(&AMDGPU_FAMILY_GC_10_3_7);
    if(defined(&__cplusplus)) {
    }
}
1;
