require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&DRM_FOURCC_H)) {
    eval 'sub DRM_FOURCC_H () {1;}' unless defined(&DRM_FOURCC_H);
    require './drm/drm.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub fourcc_code {
        my($a, $b, $c, $d) = @_;
	    eval q((( &__u32)($a) | (( &__u32)($b) << 8) | (( &__u32)($c) << 16) | (( &__u32)($d) << 24)));
    }' unless defined(&fourcc_code);
    eval 'sub DRM_FORMAT_BIG_ENDIAN () {(1<<31);}' unless defined(&DRM_FORMAT_BIG_ENDIAN);
    eval 'sub DRM_FORMAT_INVALID () {0;}' unless defined(&DRM_FORMAT_INVALID);
    eval 'sub DRM_FORMAT_C8 () { &fourcc_code(ord(\'C\', \'8\', \' \', \' \'));}' unless defined(&DRM_FORMAT_C8);
    eval 'sub DRM_FORMAT_R8 () { &fourcc_code(ord(\'R\', \'8\', \' \', \' \'));}' unless defined(&DRM_FORMAT_R8);
    eval 'sub DRM_FORMAT_R10 () { &fourcc_code(ord(\'R\', \'1\', \'0\', \' \'));}' unless defined(&DRM_FORMAT_R10);
    eval 'sub DRM_FORMAT_R12 () { &fourcc_code(ord(\'R\', \'1\', \'2\', \' \'));}' unless defined(&DRM_FORMAT_R12);
    eval 'sub DRM_FORMAT_R16 () { &fourcc_code(ord(\'R\', \'1\', \'6\', \' \'));}' unless defined(&DRM_FORMAT_R16);
    eval 'sub DRM_FORMAT_RG88 () { &fourcc_code(ord(\'R\', \'G\', \'8\', \'8\'));}' unless defined(&DRM_FORMAT_RG88);
    eval 'sub DRM_FORMAT_GR88 () { &fourcc_code(ord(\'G\', \'R\', \'8\', \'8\'));}' unless defined(&DRM_FORMAT_GR88);
    eval 'sub DRM_FORMAT_RG1616 () { &fourcc_code(ord(\'R\', \'G\', \'3\', \'2\'));}' unless defined(&DRM_FORMAT_RG1616);
    eval 'sub DRM_FORMAT_GR1616 () { &fourcc_code(ord(\'G\', \'R\', \'3\', \'2\'));}' unless defined(&DRM_FORMAT_GR1616);
    eval 'sub DRM_FORMAT_RGB332 () { &fourcc_code(ord(\'R\', \'G\', \'B\', \'8\'));}' unless defined(&DRM_FORMAT_RGB332);
    eval 'sub DRM_FORMAT_BGR233 () { &fourcc_code(ord(\'B\', \'G\', \'R\', \'8\'));}' unless defined(&DRM_FORMAT_BGR233);
    eval 'sub DRM_FORMAT_XRGB4444 () { &fourcc_code(ord(\'X\', \'R\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_XRGB4444);
    eval 'sub DRM_FORMAT_XBGR4444 () { &fourcc_code(ord(\'X\', \'B\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_XBGR4444);
    eval 'sub DRM_FORMAT_RGBX4444 () { &fourcc_code(ord(\'R\', \'X\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_RGBX4444);
    eval 'sub DRM_FORMAT_BGRX4444 () { &fourcc_code(ord(\'B\', \'X\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_BGRX4444);
    eval 'sub DRM_FORMAT_ARGB4444 () { &fourcc_code(ord(\'A\', \'R\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_ARGB4444);
    eval 'sub DRM_FORMAT_ABGR4444 () { &fourcc_code(ord(\'A\', \'B\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_ABGR4444);
    eval 'sub DRM_FORMAT_RGBA4444 () { &fourcc_code(ord(\'R\', \'A\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_RGBA4444);
    eval 'sub DRM_FORMAT_BGRA4444 () { &fourcc_code(ord(\'B\', \'A\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_BGRA4444);
    eval 'sub DRM_FORMAT_XRGB1555 () { &fourcc_code(ord(\'X\', \'R\', \'1\', \'5\'));}' unless defined(&DRM_FORMAT_XRGB1555);
    eval 'sub DRM_FORMAT_XBGR1555 () { &fourcc_code(ord(\'X\', \'B\', \'1\', \'5\'));}' unless defined(&DRM_FORMAT_XBGR1555);
    eval 'sub DRM_FORMAT_RGBX5551 () { &fourcc_code(ord(\'R\', \'X\', \'1\', \'5\'));}' unless defined(&DRM_FORMAT_RGBX5551);
    eval 'sub DRM_FORMAT_BGRX5551 () { &fourcc_code(ord(\'B\', \'X\', \'1\', \'5\'));}' unless defined(&DRM_FORMAT_BGRX5551);
    eval 'sub DRM_FORMAT_ARGB1555 () { &fourcc_code(ord(\'A\', \'R\', \'1\', \'5\'));}' unless defined(&DRM_FORMAT_ARGB1555);
    eval 'sub DRM_FORMAT_ABGR1555 () { &fourcc_code(ord(\'A\', \'B\', \'1\', \'5\'));}' unless defined(&DRM_FORMAT_ABGR1555);
    eval 'sub DRM_FORMAT_RGBA5551 () { &fourcc_code(ord(\'R\', \'A\', \'1\', \'5\'));}' unless defined(&DRM_FORMAT_RGBA5551);
    eval 'sub DRM_FORMAT_BGRA5551 () { &fourcc_code(ord(\'B\', \'A\', \'1\', \'5\'));}' unless defined(&DRM_FORMAT_BGRA5551);
    eval 'sub DRM_FORMAT_RGB565 () { &fourcc_code(ord(\'R\', \'G\', \'1\', \'6\'));}' unless defined(&DRM_FORMAT_RGB565);
    eval 'sub DRM_FORMAT_BGR565 () { &fourcc_code(ord(\'B\', \'G\', \'1\', \'6\'));}' unless defined(&DRM_FORMAT_BGR565);
    eval 'sub DRM_FORMAT_RGB888 () { &fourcc_code(ord(\'R\', \'G\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_RGB888);
    eval 'sub DRM_FORMAT_BGR888 () { &fourcc_code(ord(\'B\', \'G\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_BGR888);
    eval 'sub DRM_FORMAT_XRGB8888 () { &fourcc_code(ord(\'X\', \'R\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_XRGB8888);
    eval 'sub DRM_FORMAT_XBGR8888 () { &fourcc_code(ord(\'X\', \'B\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_XBGR8888);
    eval 'sub DRM_FORMAT_RGBX8888 () { &fourcc_code(ord(\'R\', \'X\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_RGBX8888);
    eval 'sub DRM_FORMAT_BGRX8888 () { &fourcc_code(ord(\'B\', \'X\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_BGRX8888);
    eval 'sub DRM_FORMAT_ARGB8888 () { &fourcc_code(ord(\'A\', \'R\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_ARGB8888);
    eval 'sub DRM_FORMAT_ABGR8888 () { &fourcc_code(ord(\'A\', \'B\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_ABGR8888);
    eval 'sub DRM_FORMAT_RGBA8888 () { &fourcc_code(ord(\'R\', \'A\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_RGBA8888);
    eval 'sub DRM_FORMAT_BGRA8888 () { &fourcc_code(ord(\'B\', \'A\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_BGRA8888);
    eval 'sub DRM_FORMAT_XRGB2101010 () { &fourcc_code(ord(\'X\', \'R\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_XRGB2101010);
    eval 'sub DRM_FORMAT_XBGR2101010 () { &fourcc_code(ord(\'X\', \'B\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_XBGR2101010);
    eval 'sub DRM_FORMAT_RGBX1010102 () { &fourcc_code(ord(\'R\', \'X\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_RGBX1010102);
    eval 'sub DRM_FORMAT_BGRX1010102 () { &fourcc_code(ord(\'B\', \'X\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_BGRX1010102);
    eval 'sub DRM_FORMAT_ARGB2101010 () { &fourcc_code(ord(\'A\', \'R\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_ARGB2101010);
    eval 'sub DRM_FORMAT_ABGR2101010 () { &fourcc_code(ord(\'A\', \'B\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_ABGR2101010);
    eval 'sub DRM_FORMAT_RGBA1010102 () { &fourcc_code(ord(\'R\', \'A\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_RGBA1010102);
    eval 'sub DRM_FORMAT_BGRA1010102 () { &fourcc_code(ord(\'B\', \'A\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_BGRA1010102);
    eval 'sub DRM_FORMAT_XRGB16161616 () { &fourcc_code(ord(\'X\', \'R\', \'4\', \'8\'));}' unless defined(&DRM_FORMAT_XRGB16161616);
    eval 'sub DRM_FORMAT_XBGR16161616 () { &fourcc_code(ord(\'X\', \'B\', \'4\', \'8\'));}' unless defined(&DRM_FORMAT_XBGR16161616);
    eval 'sub DRM_FORMAT_ARGB16161616 () { &fourcc_code(ord(\'A\', \'R\', \'4\', \'8\'));}' unless defined(&DRM_FORMAT_ARGB16161616);
    eval 'sub DRM_FORMAT_ABGR16161616 () { &fourcc_code(ord(\'A\', \'B\', \'4\', \'8\'));}' unless defined(&DRM_FORMAT_ABGR16161616);
    eval 'sub DRM_FORMAT_XRGB16161616F () { &fourcc_code(ord(\'X\', \'R\', \'4\', \'H\'));}' unless defined(&DRM_FORMAT_XRGB16161616F);
    eval 'sub DRM_FORMAT_XBGR16161616F () { &fourcc_code(ord(\'X\', \'B\', \'4\', \'H\'));}' unless defined(&DRM_FORMAT_XBGR16161616F);
    eval 'sub DRM_FORMAT_ARGB16161616F () { &fourcc_code(ord(\'A\', \'R\', \'4\', \'H\'));}' unless defined(&DRM_FORMAT_ARGB16161616F);
    eval 'sub DRM_FORMAT_ABGR16161616F () { &fourcc_code(ord(\'A\', \'B\', \'4\', \'H\'));}' unless defined(&DRM_FORMAT_ABGR16161616F);
    eval 'sub DRM_FORMAT_AXBXGXRX106106106106 () { &fourcc_code(ord(\'A\', \'B\', \'1\', \'0\'));}' unless defined(&DRM_FORMAT_AXBXGXRX106106106106);
    eval 'sub DRM_FORMAT_YUYV () { &fourcc_code(ord(\'Y\', \'U\', \'Y\', \'V\'));}' unless defined(&DRM_FORMAT_YUYV);
    eval 'sub DRM_FORMAT_YVYU () { &fourcc_code(ord(\'Y\', \'V\', \'Y\', \'U\'));}' unless defined(&DRM_FORMAT_YVYU);
    eval 'sub DRM_FORMAT_UYVY () { &fourcc_code(ord(\'U\', \'Y\', \'V\', \'Y\'));}' unless defined(&DRM_FORMAT_UYVY);
    eval 'sub DRM_FORMAT_VYUY () { &fourcc_code(ord(\'V\', \'Y\', \'U\', \'Y\'));}' unless defined(&DRM_FORMAT_VYUY);
    eval 'sub DRM_FORMAT_AYUV () { &fourcc_code(ord(\'A\', \'Y\', \'U\', \'V\'));}' unless defined(&DRM_FORMAT_AYUV);
    eval 'sub DRM_FORMAT_XYUV8888 () { &fourcc_code(ord(\'X\', \'Y\', \'U\', \'V\'));}' unless defined(&DRM_FORMAT_XYUV8888);
    eval 'sub DRM_FORMAT_VUY888 () { &fourcc_code(ord(\'V\', \'U\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_VUY888);
    eval 'sub DRM_FORMAT_VUY101010 () { &fourcc_code(ord(\'V\', \'U\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_VUY101010);
    eval 'sub DRM_FORMAT_Y210 () { &fourcc_code(ord(\'Y\', \'2\', \'1\', \'0\'));}' unless defined(&DRM_FORMAT_Y210);
    eval 'sub DRM_FORMAT_Y212 () { &fourcc_code(ord(\'Y\', \'2\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_Y212);
    eval 'sub DRM_FORMAT_Y216 () { &fourcc_code(ord(\'Y\', \'2\', \'1\', \'6\'));}' unless defined(&DRM_FORMAT_Y216);
    eval 'sub DRM_FORMAT_Y410 () { &fourcc_code(ord(\'Y\', \'4\', \'1\', \'0\'));}' unless defined(&DRM_FORMAT_Y410);
    eval 'sub DRM_FORMAT_Y412 () { &fourcc_code(ord(\'Y\', \'4\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_Y412);
    eval 'sub DRM_FORMAT_Y416 () { &fourcc_code(ord(\'Y\', \'4\', \'1\', \'6\'));}' unless defined(&DRM_FORMAT_Y416);
    eval 'sub DRM_FORMAT_XVYU2101010 () { &fourcc_code(ord(\'X\', \'V\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_XVYU2101010);
    eval 'sub DRM_FORMAT_XVYU12_16161616 () { &fourcc_code(ord(\'X\', \'V\', \'3\', \'6\'));}' unless defined(&DRM_FORMAT_XVYU12_16161616);
    eval 'sub DRM_FORMAT_XVYU16161616 () { &fourcc_code(ord(\'X\', \'V\', \'4\', \'8\'));}' unless defined(&DRM_FORMAT_XVYU16161616);
    eval 'sub DRM_FORMAT_Y0L0 () { &fourcc_code(ord(\'Y\', \'0\', \'L\', \'0\'));}' unless defined(&DRM_FORMAT_Y0L0);
    eval 'sub DRM_FORMAT_X0L0 () { &fourcc_code(ord(\'X\', \'0\', \'L\', \'0\'));}' unless defined(&DRM_FORMAT_X0L0);
    eval 'sub DRM_FORMAT_Y0L2 () { &fourcc_code(ord(\'Y\', \'0\', \'L\', \'2\'));}' unless defined(&DRM_FORMAT_Y0L2);
    eval 'sub DRM_FORMAT_X0L2 () { &fourcc_code(ord(\'X\', \'0\', \'L\', \'2\'));}' unless defined(&DRM_FORMAT_X0L2);
    eval 'sub DRM_FORMAT_YUV420_8BIT () { &fourcc_code(ord(\'Y\', \'U\', \'0\', \'8\'));}' unless defined(&DRM_FORMAT_YUV420_8BIT);
    eval 'sub DRM_FORMAT_YUV420_10BIT () { &fourcc_code(ord(\'Y\', \'U\', \'1\', \'0\'));}' unless defined(&DRM_FORMAT_YUV420_10BIT);
    eval 'sub DRM_FORMAT_XRGB8888_A8 () { &fourcc_code(ord(\'X\', \'R\', \'A\', \'8\'));}' unless defined(&DRM_FORMAT_XRGB8888_A8);
    eval 'sub DRM_FORMAT_XBGR8888_A8 () { &fourcc_code(ord(\'X\', \'B\', \'A\', \'8\'));}' unless defined(&DRM_FORMAT_XBGR8888_A8);
    eval 'sub DRM_FORMAT_RGBX8888_A8 () { &fourcc_code(ord(\'R\', \'X\', \'A\', \'8\'));}' unless defined(&DRM_FORMAT_RGBX8888_A8);
    eval 'sub DRM_FORMAT_BGRX8888_A8 () { &fourcc_code(ord(\'B\', \'X\', \'A\', \'8\'));}' unless defined(&DRM_FORMAT_BGRX8888_A8);
    eval 'sub DRM_FORMAT_RGB888_A8 () { &fourcc_code(ord(\'R\', \'8\', \'A\', \'8\'));}' unless defined(&DRM_FORMAT_RGB888_A8);
    eval 'sub DRM_FORMAT_BGR888_A8 () { &fourcc_code(ord(\'B\', \'8\', \'A\', \'8\'));}' unless defined(&DRM_FORMAT_BGR888_A8);
    eval 'sub DRM_FORMAT_RGB565_A8 () { &fourcc_code(ord(\'R\', \'5\', \'A\', \'8\'));}' unless defined(&DRM_FORMAT_RGB565_A8);
    eval 'sub DRM_FORMAT_BGR565_A8 () { &fourcc_code(ord(\'B\', \'5\', \'A\', \'8\'));}' unless defined(&DRM_FORMAT_BGR565_A8);
    eval 'sub DRM_FORMAT_NV12 () { &fourcc_code(ord(\'N\', \'V\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_NV12);
    eval 'sub DRM_FORMAT_NV21 () { &fourcc_code(ord(\'N\', \'V\', \'2\', \'1\'));}' unless defined(&DRM_FORMAT_NV21);
    eval 'sub DRM_FORMAT_NV16 () { &fourcc_code(ord(\'N\', \'V\', \'1\', \'6\'));}' unless defined(&DRM_FORMAT_NV16);
    eval 'sub DRM_FORMAT_NV61 () { &fourcc_code(ord(\'N\', \'V\', \'6\', \'1\'));}' unless defined(&DRM_FORMAT_NV61);
    eval 'sub DRM_FORMAT_NV24 () { &fourcc_code(ord(\'N\', \'V\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_NV24);
    eval 'sub DRM_FORMAT_NV42 () { &fourcc_code(ord(\'N\', \'V\', \'4\', \'2\'));}' unless defined(&DRM_FORMAT_NV42);
    eval 'sub DRM_FORMAT_NV15 () { &fourcc_code(ord(\'N\', \'V\', \'1\', \'5\'));}' unless defined(&DRM_FORMAT_NV15);
    eval 'sub DRM_FORMAT_P210 () { &fourcc_code(ord(\'P\', \'2\', \'1\', \'0\'));}' unless defined(&DRM_FORMAT_P210);
    eval 'sub DRM_FORMAT_P010 () { &fourcc_code(ord(\'P\', \'0\', \'1\', \'0\'));}' unless defined(&DRM_FORMAT_P010);
    eval 'sub DRM_FORMAT_P012 () { &fourcc_code(ord(\'P\', \'0\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_P012);
    eval 'sub DRM_FORMAT_P016 () { &fourcc_code(ord(\'P\', \'0\', \'1\', \'6\'));}' unless defined(&DRM_FORMAT_P016);
    eval 'sub DRM_FORMAT_P030 () { &fourcc_code(ord(\'P\', \'0\', \'3\', \'0\'));}' unless defined(&DRM_FORMAT_P030);
    eval 'sub DRM_FORMAT_Q410 () { &fourcc_code(ord(\'Q\', \'4\', \'1\', \'0\'));}' unless defined(&DRM_FORMAT_Q410);
    eval 'sub DRM_FORMAT_Q401 () { &fourcc_code(ord(\'Q\', \'4\', \'0\', \'1\'));}' unless defined(&DRM_FORMAT_Q401);
    eval 'sub DRM_FORMAT_YUV410 () { &fourcc_code(ord(\'Y\', \'U\', \'V\', \'9\'));}' unless defined(&DRM_FORMAT_YUV410);
    eval 'sub DRM_FORMAT_YVU410 () { &fourcc_code(ord(\'Y\', \'V\', \'U\', \'9\'));}' unless defined(&DRM_FORMAT_YVU410);
    eval 'sub DRM_FORMAT_YUV411 () { &fourcc_code(ord(\'Y\', \'U\', \'1\', \'1\'));}' unless defined(&DRM_FORMAT_YUV411);
    eval 'sub DRM_FORMAT_YVU411 () { &fourcc_code(ord(\'Y\', \'V\', \'1\', \'1\'));}' unless defined(&DRM_FORMAT_YVU411);
    eval 'sub DRM_FORMAT_YUV420 () { &fourcc_code(ord(\'Y\', \'U\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_YUV420);
    eval 'sub DRM_FORMAT_YVU420 () { &fourcc_code(ord(\'Y\', \'V\', \'1\', \'2\'));}' unless defined(&DRM_FORMAT_YVU420);
    eval 'sub DRM_FORMAT_YUV422 () { &fourcc_code(ord(\'Y\', \'U\', \'1\', \'6\'));}' unless defined(&DRM_FORMAT_YUV422);
    eval 'sub DRM_FORMAT_YVU422 () { &fourcc_code(ord(\'Y\', \'V\', \'1\', \'6\'));}' unless defined(&DRM_FORMAT_YVU422);
    eval 'sub DRM_FORMAT_YUV444 () { &fourcc_code(ord(\'Y\', \'U\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_YUV444);
    eval 'sub DRM_FORMAT_YVU444 () { &fourcc_code(ord(\'Y\', \'V\', \'2\', \'4\'));}' unless defined(&DRM_FORMAT_YVU444);
    eval 'sub DRM_FORMAT_MOD_VENDOR_NONE () {0;}' unless defined(&DRM_FORMAT_MOD_VENDOR_NONE);
    eval 'sub DRM_FORMAT_MOD_VENDOR_INTEL () {0x1;}' unless defined(&DRM_FORMAT_MOD_VENDOR_INTEL);
    eval 'sub DRM_FORMAT_MOD_VENDOR_AMD () {0x2;}' unless defined(&DRM_FORMAT_MOD_VENDOR_AMD);
    eval 'sub DRM_FORMAT_MOD_VENDOR_NVIDIA () {0x3;}' unless defined(&DRM_FORMAT_MOD_VENDOR_NVIDIA);
    eval 'sub DRM_FORMAT_MOD_VENDOR_SAMSUNG () {0x4;}' unless defined(&DRM_FORMAT_MOD_VENDOR_SAMSUNG);
    eval 'sub DRM_FORMAT_MOD_VENDOR_QCOM () {0x5;}' unless defined(&DRM_FORMAT_MOD_VENDOR_QCOM);
    eval 'sub DRM_FORMAT_MOD_VENDOR_VIVANTE () {0x6;}' unless defined(&DRM_FORMAT_MOD_VENDOR_VIVANTE);
    eval 'sub DRM_FORMAT_MOD_VENDOR_BROADCOM () {0x7;}' unless defined(&DRM_FORMAT_MOD_VENDOR_BROADCOM);
    eval 'sub DRM_FORMAT_MOD_VENDOR_ARM () {0x8;}' unless defined(&DRM_FORMAT_MOD_VENDOR_ARM);
    eval 'sub DRM_FORMAT_MOD_VENDOR_ALLWINNER () {0x9;}' unless defined(&DRM_FORMAT_MOD_VENDOR_ALLWINNER);
    eval 'sub DRM_FORMAT_MOD_VENDOR_AMLOGIC () {0xa;}' unless defined(&DRM_FORMAT_MOD_VENDOR_AMLOGIC);
    eval 'sub DRM_FORMAT_RESERVED () {((1 << 56) - 1);}' unless defined(&DRM_FORMAT_RESERVED);
    eval 'sub fourcc_mod_get_vendor {
        my($modifier) = @_;
	    eval q(((($modifier) >> 56) & 0xff));
    }' unless defined(&fourcc_mod_get_vendor);
    eval 'sub fourcc_mod_is_vendor {
        my($modifier, $vendor) = @_;
	    eval q(( &fourcc_mod_get_vendor($modifier) ==  &DRM_FORMAT_MOD_VENDOR_ $vendor));
    }' unless defined(&fourcc_mod_is_vendor);
    eval 'sub fourcc_mod_code {
        my($vendor, $val) = @_;
	    eval q((((( &__u64) &DRM_FORMAT_MOD_VENDOR_ $vendor) << 56) | (($val) & 0xffffffffffffff)));
    }' unless defined(&fourcc_mod_code);
    eval 'sub DRM_FORMAT_MOD_GENERIC_16_16_TILE () { &DRM_FORMAT_MOD_SAMSUNG_16_16_TILE;}' unless defined(&DRM_FORMAT_MOD_GENERIC_16_16_TILE);
    eval 'sub DRM_FORMAT_MOD_INVALID () { &fourcc_mod_code( &NONE,  &DRM_FORMAT_RESERVED);}' unless defined(&DRM_FORMAT_MOD_INVALID);
    eval 'sub DRM_FORMAT_MOD_LINEAR () { &fourcc_mod_code( &NONE, 0);}' unless defined(&DRM_FORMAT_MOD_LINEAR);
    eval 'sub DRM_FORMAT_MOD_NONE () {0;}' unless defined(&DRM_FORMAT_MOD_NONE);
    eval 'sub I915_FORMAT_MOD_X_TILED () { &fourcc_mod_code( &INTEL, 1);}' unless defined(&I915_FORMAT_MOD_X_TILED);
    eval 'sub I915_FORMAT_MOD_Y_TILED () { &fourcc_mod_code( &INTEL, 2);}' unless defined(&I915_FORMAT_MOD_Y_TILED);
    eval 'sub I915_FORMAT_MOD_Yf_TILED () { &fourcc_mod_code( &INTEL, 3);}' unless defined(&I915_FORMAT_MOD_Yf_TILED);
    eval 'sub I915_FORMAT_MOD_Y_TILED_CCS () { &fourcc_mod_code( &INTEL, 4);}' unless defined(&I915_FORMAT_MOD_Y_TILED_CCS);
    eval 'sub I915_FORMAT_MOD_Yf_TILED_CCS () { &fourcc_mod_code( &INTEL, 5);}' unless defined(&I915_FORMAT_MOD_Yf_TILED_CCS);
    eval 'sub I915_FORMAT_MOD_Y_TILED_GEN12_RC_CCS () { &fourcc_mod_code( &INTEL, 6);}' unless defined(&I915_FORMAT_MOD_Y_TILED_GEN12_RC_CCS);
    eval 'sub I915_FORMAT_MOD_Y_TILED_GEN12_MC_CCS () { &fourcc_mod_code( &INTEL, 7);}' unless defined(&I915_FORMAT_MOD_Y_TILED_GEN12_MC_CCS);
    eval 'sub I915_FORMAT_MOD_Y_TILED_GEN12_RC_CCS_CC () { &fourcc_mod_code( &INTEL, 8);}' unless defined(&I915_FORMAT_MOD_Y_TILED_GEN12_RC_CCS_CC);
    eval 'sub I915_FORMAT_MOD_4_TILED () { &fourcc_mod_code( &INTEL, 9);}' unless defined(&I915_FORMAT_MOD_4_TILED);
    eval 'sub I915_FORMAT_MOD_4_TILED_DG2_RC_CCS () { &fourcc_mod_code( &INTEL, 10);}' unless defined(&I915_FORMAT_MOD_4_TILED_DG2_RC_CCS);
    eval 'sub I915_FORMAT_MOD_4_TILED_DG2_MC_CCS () { &fourcc_mod_code( &INTEL, 11);}' unless defined(&I915_FORMAT_MOD_4_TILED_DG2_MC_CCS);
    eval 'sub I915_FORMAT_MOD_4_TILED_DG2_RC_CCS_CC () { &fourcc_mod_code( &INTEL, 12);}' unless defined(&I915_FORMAT_MOD_4_TILED_DG2_RC_CCS_CC);
    eval 'sub DRM_FORMAT_MOD_SAMSUNG_64_32_TILE () { &fourcc_mod_code( &SAMSUNG, 1);}' unless defined(&DRM_FORMAT_MOD_SAMSUNG_64_32_TILE);
    eval 'sub DRM_FORMAT_MOD_SAMSUNG_16_16_TILE () { &fourcc_mod_code( &SAMSUNG, 2);}' unless defined(&DRM_FORMAT_MOD_SAMSUNG_16_16_TILE);
    eval 'sub DRM_FORMAT_MOD_QCOM_COMPRESSED () { &fourcc_mod_code( &QCOM, 1);}' unless defined(&DRM_FORMAT_MOD_QCOM_COMPRESSED);
    eval 'sub DRM_FORMAT_MOD_QCOM_TILED3 () { &fourcc_mod_code( &QCOM, 3);}' unless defined(&DRM_FORMAT_MOD_QCOM_TILED3);
    eval 'sub DRM_FORMAT_MOD_QCOM_TILED2 () { &fourcc_mod_code( &QCOM, 2);}' unless defined(&DRM_FORMAT_MOD_QCOM_TILED2);
    eval 'sub DRM_FORMAT_MOD_VIVANTE_TILED () { &fourcc_mod_code( &VIVANTE, 1);}' unless defined(&DRM_FORMAT_MOD_VIVANTE_TILED);
    eval 'sub DRM_FORMAT_MOD_VIVANTE_SUPER_TILED () { &fourcc_mod_code( &VIVANTE, 2);}' unless defined(&DRM_FORMAT_MOD_VIVANTE_SUPER_TILED);
    eval 'sub DRM_FORMAT_MOD_VIVANTE_SPLIT_TILED () { &fourcc_mod_code( &VIVANTE, 3);}' unless defined(&DRM_FORMAT_MOD_VIVANTE_SPLIT_TILED);
    eval 'sub DRM_FORMAT_MOD_VIVANTE_SPLIT_SUPER_TILED () { &fourcc_mod_code( &VIVANTE, 4);}' unless defined(&DRM_FORMAT_MOD_VIVANTE_SPLIT_SUPER_TILED);
    eval 'sub DRM_FORMAT_MOD_NVIDIA_TEGRA_TILED () { &fourcc_mod_code( &NVIDIA, 1);}' unless defined(&DRM_FORMAT_MOD_NVIDIA_TEGRA_TILED);
    eval 'sub DRM_FORMAT_MOD_NVIDIA_BLOCK_LINEAR_2D {
        my($c, $s, $g, $k, $h) = @_;
	    eval q( &fourcc_mod_code( &NVIDIA, (0x10 | (($h) & 0xf) | ((($k) & 0xff) << 12) | ((($g) & 0x3) << 20) | ((($s) & 0x1) << 22) | ((($c) & 0x7) << 23))));
    }' unless defined(&DRM_FORMAT_MOD_NVIDIA_BLOCK_LINEAR_2D);
    eval 'sub DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK {
        my($v) = @_;
	    eval q( &DRM_FORMAT_MOD_NVIDIA_BLOCK_LINEAR_2D(0, 0, 0, 0, ($v)));
    }' unless defined(&DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK);
    eval 'sub DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_ONE_GOB () { &DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK(0);}' unless defined(&DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_ONE_GOB);
    eval 'sub DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_TWO_GOB () { &DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK(1);}' unless defined(&DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_TWO_GOB);
    eval 'sub DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_FOUR_GOB () { &DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK(2);}' unless defined(&DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_FOUR_GOB);
    eval 'sub DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_EIGHT_GOB () { &DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK(3);}' unless defined(&DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_EIGHT_GOB);
    eval 'sub DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_SIXTEEN_GOB () { &DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK(4);}' unless defined(&DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_SIXTEEN_GOB);
    eval 'sub DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_THIRTYTWO_GOB () { &DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK(5);}' unless defined(&DRM_FORMAT_MOD_NVIDIA_16BX2_BLOCK_THIRTYTWO_GOB);
    eval 'sub __fourcc_mod_broadcom_param_shift () {8;}' unless defined(&__fourcc_mod_broadcom_param_shift);
    eval 'sub __fourcc_mod_broadcom_param_bits () {48;}' unless defined(&__fourcc_mod_broadcom_param_bits);
    eval 'sub fourcc_mod_broadcom_code {
        my($val, $params) = @_;
	    eval q( &fourcc_mod_code( &BROADCOM, (((( &__u64)$params) <<  &__fourcc_mod_broadcom_param_shift) | $val)));
    }' unless defined(&fourcc_mod_broadcom_code);
    eval 'sub fourcc_mod_broadcom_param {
        my($m) = @_;
	    eval q((((($m) >>  &__fourcc_mod_broadcom_param_shift) & ((1 <<  &__fourcc_mod_broadcom_param_bits) - 1))));
    }' unless defined(&fourcc_mod_broadcom_param);
    eval 'sub fourcc_mod_broadcom_mod {
        my($m) = @_;
	    eval q((($m) & ~(((1 <<  &__fourcc_mod_broadcom_param_bits) - 1) <<  &__fourcc_mod_broadcom_param_shift)));
    }' unless defined(&fourcc_mod_broadcom_mod);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_VC4_T_TILED () { &fourcc_mod_code( &BROADCOM, 1);}' unless defined(&DRM_FORMAT_MOD_BROADCOM_VC4_T_TILED);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_SAND32_COL_HEIGHT {
        my($v) = @_;
	    eval q( &fourcc_mod_broadcom_code(2, $v));
    }' unless defined(&DRM_FORMAT_MOD_BROADCOM_SAND32_COL_HEIGHT);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_SAND64_COL_HEIGHT {
        my($v) = @_;
	    eval q( &fourcc_mod_broadcom_code(3, $v));
    }' unless defined(&DRM_FORMAT_MOD_BROADCOM_SAND64_COL_HEIGHT);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_SAND128_COL_HEIGHT {
        my($v) = @_;
	    eval q( &fourcc_mod_broadcom_code(4, $v));
    }' unless defined(&DRM_FORMAT_MOD_BROADCOM_SAND128_COL_HEIGHT);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_SAND256_COL_HEIGHT {
        my($v) = @_;
	    eval q( &fourcc_mod_broadcom_code(5, $v));
    }' unless defined(&DRM_FORMAT_MOD_BROADCOM_SAND256_COL_HEIGHT);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_SAND32 () { &DRM_FORMAT_MOD_BROADCOM_SAND32_COL_HEIGHT(0);}' unless defined(&DRM_FORMAT_MOD_BROADCOM_SAND32);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_SAND64 () { &DRM_FORMAT_MOD_BROADCOM_SAND64_COL_HEIGHT(0);}' unless defined(&DRM_FORMAT_MOD_BROADCOM_SAND64);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_SAND128 () { &DRM_FORMAT_MOD_BROADCOM_SAND128_COL_HEIGHT(0);}' unless defined(&DRM_FORMAT_MOD_BROADCOM_SAND128);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_SAND256 () { &DRM_FORMAT_MOD_BROADCOM_SAND256_COL_HEIGHT(0);}' unless defined(&DRM_FORMAT_MOD_BROADCOM_SAND256);
    eval 'sub DRM_FORMAT_MOD_BROADCOM_UIF () { &fourcc_mod_code( &BROADCOM, 6);}' unless defined(&DRM_FORMAT_MOD_BROADCOM_UIF);
    eval 'sub DRM_FORMAT_MOD_ARM_CODE {
        my($__type, $__val) = @_;
	    eval q( &fourcc_mod_code( &ARM, (( &__u64)($__type) << 52) | (($__val) & 0xfffffffffffff)));
    }' unless defined(&DRM_FORMAT_MOD_ARM_CODE);
    eval 'sub DRM_FORMAT_MOD_ARM_TYPE_AFBC () {0x;}' unless defined(&DRM_FORMAT_MOD_ARM_TYPE_AFBC);
    eval 'sub DRM_FORMAT_MOD_ARM_TYPE_MISC () {0x1;}' unless defined(&DRM_FORMAT_MOD_ARM_TYPE_MISC);
    eval 'sub DRM_FORMAT_MOD_ARM_AFBC {
        my($__afbc_mode) = @_;
	    eval q( &DRM_FORMAT_MOD_ARM_CODE( &DRM_FORMAT_MOD_ARM_TYPE_AFBC, $__afbc_mode));
    }' unless defined(&DRM_FORMAT_MOD_ARM_AFBC);
    eval 'sub AFBC_FORMAT_MOD_BLOCK_SIZE_MASK () {0xf;}' unless defined(&AFBC_FORMAT_MOD_BLOCK_SIZE_MASK);
    eval 'sub AFBC_FORMAT_MOD_BLOCK_SIZE_16x16 () {(1);}' unless defined(&AFBC_FORMAT_MOD_BLOCK_SIZE_16x16);
    eval 'sub AFBC_FORMAT_MOD_BLOCK_SIZE_32x8 () {(2);}' unless defined(&AFBC_FORMAT_MOD_BLOCK_SIZE_32x8);
    eval 'sub AFBC_FORMAT_MOD_BLOCK_SIZE_64x4 () {(3);}' unless defined(&AFBC_FORMAT_MOD_BLOCK_SIZE_64x4);
    eval 'sub AFBC_FORMAT_MOD_BLOCK_SIZE_32x8_64x4 () {(4);}' unless defined(&AFBC_FORMAT_MOD_BLOCK_SIZE_32x8_64x4);
    eval 'sub AFBC_FORMAT_MOD_YTR () {(1 << 4);}' unless defined(&AFBC_FORMAT_MOD_YTR);
    eval 'sub AFBC_FORMAT_MOD_SPLIT () {(1 << 5);}' unless defined(&AFBC_FORMAT_MOD_SPLIT);
    eval 'sub AFBC_FORMAT_MOD_SPARSE () {(1 << 6);}' unless defined(&AFBC_FORMAT_MOD_SPARSE);
    eval 'sub AFBC_FORMAT_MOD_CBR () {(1 << 7);}' unless defined(&AFBC_FORMAT_MOD_CBR);
    eval 'sub AFBC_FORMAT_MOD_TILED () {(1 << 8);}' unless defined(&AFBC_FORMAT_MOD_TILED);
    eval 'sub AFBC_FORMAT_MOD_SC () {(1 << 9);}' unless defined(&AFBC_FORMAT_MOD_SC);
    eval 'sub AFBC_FORMAT_MOD_DB () {(1 << 10);}' unless defined(&AFBC_FORMAT_MOD_DB);
    eval 'sub AFBC_FORMAT_MOD_BCH () {(1 << 11);}' unless defined(&AFBC_FORMAT_MOD_BCH);
    eval 'sub AFBC_FORMAT_MOD_USM () {(1 << 12);}' unless defined(&AFBC_FORMAT_MOD_USM);
    eval 'sub DRM_FORMAT_MOD_ARM_TYPE_AFRC () {0x2;}' unless defined(&DRM_FORMAT_MOD_ARM_TYPE_AFRC);
    eval 'sub DRM_FORMAT_MOD_ARM_AFRC {
        my($__afrc_mode) = @_;
	    eval q( &DRM_FORMAT_MOD_ARM_CODE( &DRM_FORMAT_MOD_ARM_TYPE_AFRC, $__afrc_mode));
    }' unless defined(&DRM_FORMAT_MOD_ARM_AFRC);
    eval 'sub AFRC_FORMAT_MOD_CU_SIZE_MASK () {0xf;}' unless defined(&AFRC_FORMAT_MOD_CU_SIZE_MASK);
    eval 'sub AFRC_FORMAT_MOD_CU_SIZE_16 () {(1);}' unless defined(&AFRC_FORMAT_MOD_CU_SIZE_16);
    eval 'sub AFRC_FORMAT_MOD_CU_SIZE_24 () {(2);}' unless defined(&AFRC_FORMAT_MOD_CU_SIZE_24);
    eval 'sub AFRC_FORMAT_MOD_CU_SIZE_32 () {(3);}' unless defined(&AFRC_FORMAT_MOD_CU_SIZE_32);
    eval 'sub AFRC_FORMAT_MOD_CU_SIZE_P0 {
        my($__afrc_cu_size) = @_;
	    eval q(($__afrc_cu_size));
    }' unless defined(&AFRC_FORMAT_MOD_CU_SIZE_P0);
    eval 'sub AFRC_FORMAT_MOD_CU_SIZE_P12 {
        my($__afrc_cu_size) = @_;
	    eval q((($__afrc_cu_size) << 4));
    }' unless defined(&AFRC_FORMAT_MOD_CU_SIZE_P12);
    eval 'sub AFRC_FORMAT_MOD_LAYOUT_SCAN () {(1 << 8);}' unless defined(&AFRC_FORMAT_MOD_LAYOUT_SCAN);
    eval 'sub DRM_FORMAT_MOD_ARM_16X16_BLOCK_U_INTERLEAVED () { &DRM_FORMAT_MOD_ARM_CODE( &DRM_FORMAT_MOD_ARM_TYPE_MISC, 1);}' unless defined(&DRM_FORMAT_MOD_ARM_16X16_BLOCK_U_INTERLEAVED);
    eval 'sub DRM_FORMAT_MOD_ALLWINNER_TILED () { &fourcc_mod_code( &ALLWINNER, 1);}' unless defined(&DRM_FORMAT_MOD_ALLWINNER_TILED);
    eval 'sub __fourcc_mod_amlogic_layout_mask () {0xff;}' unless defined(&__fourcc_mod_amlogic_layout_mask);
    eval 'sub __fourcc_mod_amlogic_options_shift () {8;}' unless defined(&__fourcc_mod_amlogic_options_shift);
    eval 'sub __fourcc_mod_amlogic_options_mask () {0xff;}' unless defined(&__fourcc_mod_amlogic_options_mask);
    eval 'sub DRM_FORMAT_MOD_AMLOGIC_FBC {
        my($__layout, $__options) = @_;
	    eval q( &fourcc_mod_code( &AMLOGIC, (($__layout) &  &__fourcc_mod_amlogic_layout_mask) | ((($__options) &  &__fourcc_mod_amlogic_options_mask) <<  &__fourcc_mod_amlogic_options_shift)));
    }' unless defined(&DRM_FORMAT_MOD_AMLOGIC_FBC);
    eval 'sub AMLOGIC_FBC_LAYOUT_BASIC () {(1);}' unless defined(&AMLOGIC_FBC_LAYOUT_BASIC);
    eval 'sub AMLOGIC_FBC_LAYOUT_SCATTER () {(2);}' unless defined(&AMLOGIC_FBC_LAYOUT_SCATTER);
    eval 'sub AMLOGIC_FBC_OPTION_MEM_SAVING () {(1 << 0);}' unless defined(&AMLOGIC_FBC_OPTION_MEM_SAVING);
    eval 'sub AMD_FMT_MOD () { &fourcc_mod_code( &AMD, 0);}' unless defined(&AMD_FMT_MOD);
    eval 'sub IS_AMD_FMT_MOD {
        my($val) = @_;
	    eval q(((($val) >> 56) ==  &DRM_FORMAT_MOD_VENDOR_AMD));
    }' unless defined(&IS_AMD_FMT_MOD);
    eval 'sub AMD_FMT_MOD_TILE_VER_GFX9 () {1;}' unless defined(&AMD_FMT_MOD_TILE_VER_GFX9);
    eval 'sub AMD_FMT_MOD_TILE_VER_GFX10 () {2;}' unless defined(&AMD_FMT_MOD_TILE_VER_GFX10);
    eval 'sub AMD_FMT_MOD_TILE_VER_GFX10_RBPLUS () {3;}' unless defined(&AMD_FMT_MOD_TILE_VER_GFX10_RBPLUS);
    eval 'sub AMD_FMT_MOD_TILE_VER_GFX11 () {4;}' unless defined(&AMD_FMT_MOD_TILE_VER_GFX11);
    eval 'sub AMD_FMT_MOD_TILE_GFX9_64K_S () {9;}' unless defined(&AMD_FMT_MOD_TILE_GFX9_64K_S);
    eval 'sub AMD_FMT_MOD_TILE_GFX9_64K_D () {10;}' unless defined(&AMD_FMT_MOD_TILE_GFX9_64K_D);
    eval 'sub AMD_FMT_MOD_TILE_GFX9_64K_S_X () {25;}' unless defined(&AMD_FMT_MOD_TILE_GFX9_64K_S_X);
    eval 'sub AMD_FMT_MOD_TILE_GFX9_64K_D_X () {26;}' unless defined(&AMD_FMT_MOD_TILE_GFX9_64K_D_X);
    eval 'sub AMD_FMT_MOD_TILE_GFX9_64K_R_X () {27;}' unless defined(&AMD_FMT_MOD_TILE_GFX9_64K_R_X);
    eval 'sub AMD_FMT_MOD_TILE_GFX11_256K_R_X () {31;}' unless defined(&AMD_FMT_MOD_TILE_GFX11_256K_R_X);
    eval 'sub AMD_FMT_MOD_DCC_BLOCK_64B () {0;}' unless defined(&AMD_FMT_MOD_DCC_BLOCK_64B);
    eval 'sub AMD_FMT_MOD_DCC_BLOCK_128B () {1;}' unless defined(&AMD_FMT_MOD_DCC_BLOCK_128B);
    eval 'sub AMD_FMT_MOD_DCC_BLOCK_256B () {2;}' unless defined(&AMD_FMT_MOD_DCC_BLOCK_256B);
    eval 'sub AMD_FMT_MOD_TILE_VERSION_SHIFT () {0;}' unless defined(&AMD_FMT_MOD_TILE_VERSION_SHIFT);
    eval 'sub AMD_FMT_MOD_TILE_VERSION_MASK () {0xff;}' unless defined(&AMD_FMT_MOD_TILE_VERSION_MASK);
    eval 'sub AMD_FMT_MOD_TILE_SHIFT () {8;}' unless defined(&AMD_FMT_MOD_TILE_SHIFT);
    eval 'sub AMD_FMT_MOD_TILE_MASK () {0x1f;}' unless defined(&AMD_FMT_MOD_TILE_MASK);
    eval 'sub AMD_FMT_MOD_DCC_SHIFT () {13;}' unless defined(&AMD_FMT_MOD_DCC_SHIFT);
    eval 'sub AMD_FMT_MOD_DCC_MASK () {0x1;}' unless defined(&AMD_FMT_MOD_DCC_MASK);
    eval 'sub AMD_FMT_MOD_DCC_RETILE_SHIFT () {14;}' unless defined(&AMD_FMT_MOD_DCC_RETILE_SHIFT);
    eval 'sub AMD_FMT_MOD_DCC_RETILE_MASK () {0x1;}' unless defined(&AMD_FMT_MOD_DCC_RETILE_MASK);
    eval 'sub AMD_FMT_MOD_DCC_PIPE_ALIGN_SHIFT () {15;}' unless defined(&AMD_FMT_MOD_DCC_PIPE_ALIGN_SHIFT);
    eval 'sub AMD_FMT_MOD_DCC_PIPE_ALIGN_MASK () {0x1;}' unless defined(&AMD_FMT_MOD_DCC_PIPE_ALIGN_MASK);
    eval 'sub AMD_FMT_MOD_DCC_INDEPENDENT_64B_SHIFT () {16;}' unless defined(&AMD_FMT_MOD_DCC_INDEPENDENT_64B_SHIFT);
    eval 'sub AMD_FMT_MOD_DCC_INDEPENDENT_64B_MASK () {0x1;}' unless defined(&AMD_FMT_MOD_DCC_INDEPENDENT_64B_MASK);
    eval 'sub AMD_FMT_MOD_DCC_INDEPENDENT_128B_SHIFT () {17;}' unless defined(&AMD_FMT_MOD_DCC_INDEPENDENT_128B_SHIFT);
    eval 'sub AMD_FMT_MOD_DCC_INDEPENDENT_128B_MASK () {0x1;}' unless defined(&AMD_FMT_MOD_DCC_INDEPENDENT_128B_MASK);
    eval 'sub AMD_FMT_MOD_DCC_MAX_COMPRESSED_BLOCK_SHIFT () {18;}' unless defined(&AMD_FMT_MOD_DCC_MAX_COMPRESSED_BLOCK_SHIFT);
    eval 'sub AMD_FMT_MOD_DCC_MAX_COMPRESSED_BLOCK_MASK () {0x3;}' unless defined(&AMD_FMT_MOD_DCC_MAX_COMPRESSED_BLOCK_MASK);
    eval 'sub AMD_FMT_MOD_DCC_CONSTANT_ENCODE_SHIFT () {20;}' unless defined(&AMD_FMT_MOD_DCC_CONSTANT_ENCODE_SHIFT);
    eval 'sub AMD_FMT_MOD_DCC_CONSTANT_ENCODE_MASK () {0x1;}' unless defined(&AMD_FMT_MOD_DCC_CONSTANT_ENCODE_MASK);
    eval 'sub AMD_FMT_MOD_PIPE_XOR_BITS_SHIFT () {21;}' unless defined(&AMD_FMT_MOD_PIPE_XOR_BITS_SHIFT);
    eval 'sub AMD_FMT_MOD_PIPE_XOR_BITS_MASK () {0x7;}' unless defined(&AMD_FMT_MOD_PIPE_XOR_BITS_MASK);
    eval 'sub AMD_FMT_MOD_BANK_XOR_BITS_SHIFT () {24;}' unless defined(&AMD_FMT_MOD_BANK_XOR_BITS_SHIFT);
    eval 'sub AMD_FMT_MOD_BANK_XOR_BITS_MASK () {0x7;}' unless defined(&AMD_FMT_MOD_BANK_XOR_BITS_MASK);
    eval 'sub AMD_FMT_MOD_PACKERS_SHIFT () {27;}' unless defined(&AMD_FMT_MOD_PACKERS_SHIFT);
    eval 'sub AMD_FMT_MOD_PACKERS_MASK () {0x7;}' unless defined(&AMD_FMT_MOD_PACKERS_MASK);
    eval 'sub AMD_FMT_MOD_RB_SHIFT () {30;}' unless defined(&AMD_FMT_MOD_RB_SHIFT);
    eval 'sub AMD_FMT_MOD_RB_MASK () {0x7;}' unless defined(&AMD_FMT_MOD_RB_MASK);
    eval 'sub AMD_FMT_MOD_PIPE_SHIFT () {33;}' unless defined(&AMD_FMT_MOD_PIPE_SHIFT);
    eval 'sub AMD_FMT_MOD_PIPE_MASK () {0x7;}' unless defined(&AMD_FMT_MOD_PIPE_MASK);
    eval 'sub AMD_FMT_MOD_SET {
        my($field, $value) = @_;
	    eval q((( &__u64)($value) <<  &AMD_FMT_MOD_$field &_SHIFT));
    }' unless defined(&AMD_FMT_MOD_SET);
    eval 'sub AMD_FMT_MOD_GET {
        my($field, $value) = @_;
	    eval q(((($value) >>  &AMD_FMT_MOD_$field &_SHIFT) &  &AMD_FMT_MOD_$field &_MASK));
    }' unless defined(&AMD_FMT_MOD_GET);
    eval 'sub AMD_FMT_MOD_CLEAR {
        my($field) = @_;
	    eval q((~(( &__u64) &AMD_FMT_MOD_$field &_MASK <<  &AMD_FMT_MOD_$field &_SHIFT)));
    }' unless defined(&AMD_FMT_MOD_CLEAR);
    if(defined(&__cplusplus)) {
    }
}
1;
