require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_I915_DRM_H_)) {
    eval 'sub _I915_DRM_H_ () {1;}' unless defined(&_I915_DRM_H_);
    require './drm/drm.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub I915_L3_PARITY_UEVENT () {"L3_PARITY_ERROR";}' unless defined(&I915_L3_PARITY_UEVENT);
    eval 'sub I915_ERROR_UEVENT () {"ERROR";}' unless defined(&I915_ERROR_UEVENT);
    eval 'sub I915_RESET_UEVENT () {"RESET";}' unless defined(&I915_RESET_UEVENT);
    eval("sub I915_MOCS_UNCACHED () { 0; }") unless defined(&I915_MOCS_UNCACHED);
    eval("sub I915_MOCS_PTE () { 1; }") unless defined(&I915_MOCS_PTE);
    eval("sub I915_MOCS_CACHED () { 2; }") unless defined(&I915_MOCS_CACHED);
    eval("sub I915_ENGINE_CLASS_RENDER () { 0; }") unless defined(&I915_ENGINE_CLASS_RENDER);
    eval("sub I915_ENGINE_CLASS_COPY () { 1; }") unless defined(&I915_ENGINE_CLASS_COPY);
    eval("sub I915_ENGINE_CLASS_VIDEO () { 2; }") unless defined(&I915_ENGINE_CLASS_VIDEO);
    eval("sub I915_ENGINE_CLASS_VIDEO_ENHANCE () { 3; }") unless defined(&I915_ENGINE_CLASS_VIDEO_ENHANCE);
    eval("sub I915_ENGINE_CLASS_COMPUTE () { 4; }") unless defined(&I915_ENGINE_CLASS_COMPUTE);
    eval("sub I915_ENGINE_CLASS_INVALID () { -1; }") unless defined(&I915_ENGINE_CLASS_INVALID);
    eval 'sub I915_ENGINE_CLASS_INVALID_NONE () {-1;}' unless defined(&I915_ENGINE_CLASS_INVALID_NONE);
    eval 'sub I915_ENGINE_CLASS_INVALID_VIRTUAL () {-2;}' unless defined(&I915_ENGINE_CLASS_INVALID_VIRTUAL);
    eval("sub I915_SAMPLE_BUSY () { 0; }") unless defined(&I915_SAMPLE_BUSY);
    eval("sub I915_SAMPLE_WAIT () { 1; }") unless defined(&I915_SAMPLE_WAIT);
    eval("sub I915_SAMPLE_SEMA () { 2; }") unless defined(&I915_SAMPLE_SEMA);
    eval 'sub I915_PMU_SAMPLE_BITS () {(4);}' unless defined(&I915_PMU_SAMPLE_BITS);
    eval 'sub I915_PMU_SAMPLE_MASK () {(0xf);}' unless defined(&I915_PMU_SAMPLE_MASK);
    eval 'sub I915_PMU_SAMPLE_INSTANCE_BITS () {(8);}' unless defined(&I915_PMU_SAMPLE_INSTANCE_BITS);
    eval 'sub I915_PMU_CLASS_SHIFT () {( &I915_PMU_SAMPLE_BITS +  &I915_PMU_SAMPLE_INSTANCE_BITS);}' unless defined(&I915_PMU_CLASS_SHIFT);
    eval 'sub __I915_PMU_ENGINE {
        my($class, $instance, $sample) = @_;
	    eval q((($class) <<  &I915_PMU_CLASS_SHIFT | ($instance) <<  &I915_PMU_SAMPLE_BITS | ($sample)));
    }' unless defined(&__I915_PMU_ENGINE);
    eval 'sub I915_PMU_ENGINE_BUSY {
        my($class, $instance) = @_;
	    eval q( &__I915_PMU_ENGINE($class, $instance,  &I915_SAMPLE_BUSY));
    }' unless defined(&I915_PMU_ENGINE_BUSY);
    eval 'sub I915_PMU_ENGINE_WAIT {
        my($class, $instance) = @_;
	    eval q( &__I915_PMU_ENGINE($class, $instance,  &I915_SAMPLE_WAIT));
    }' unless defined(&I915_PMU_ENGINE_WAIT);
    eval 'sub I915_PMU_ENGINE_SEMA {
        my($class, $instance) = @_;
	    eval q( &__I915_PMU_ENGINE($class, $instance,  &I915_SAMPLE_SEMA));
    }' unless defined(&I915_PMU_ENGINE_SEMA);
    eval 'sub __I915_PMU_OTHER {
        my($x) = @_;
	    eval q(( &__I915_PMU_ENGINE(0xff, 0xff, 0xf) + 1+ ($x)));
    }' unless defined(&__I915_PMU_OTHER);
    eval 'sub I915_PMU_ACTUAL_FREQUENCY () { &__I915_PMU_OTHER(0);}' unless defined(&I915_PMU_ACTUAL_FREQUENCY);
    eval 'sub I915_PMU_REQUESTED_FREQUENCY () { &__I915_PMU_OTHER(1);}' unless defined(&I915_PMU_REQUESTED_FREQUENCY);
    eval 'sub I915_PMU_INTERRUPTS () { &__I915_PMU_OTHER(2);}' unless defined(&I915_PMU_INTERRUPTS);
    eval 'sub I915_PMU_RC6_RESIDENCY () { &__I915_PMU_OTHER(3);}' unless defined(&I915_PMU_RC6_RESIDENCY);
    eval 'sub I915_PMU_SOFTWARE_GT_AWAKE_TIME () { &__I915_PMU_OTHER(4);}' unless defined(&I915_PMU_SOFTWARE_GT_AWAKE_TIME);
    eval 'sub I915_PMU_LAST () { &I915_PMU_RC6_RESIDENCY;}' unless defined(&I915_PMU_LAST);
    eval 'sub I915_NR_TEX_REGIONS () {255;}' unless defined(&I915_NR_TEX_REGIONS);
    eval 'sub I915_LOG_MIN_TEX_REGION_SIZE () {14;}' unless defined(&I915_LOG_MIN_TEX_REGION_SIZE);
    eval("sub I915_INIT_DMA () { 0x01; }") unless defined(&I915_INIT_DMA);
    eval("sub I915_CLEANUP_DMA () { 0x02; }") unless defined(&I915_CLEANUP_DMA);
    eval("sub I915_RESUME_DMA () { 0x03; }") unless defined(&I915_RESUME_DMA);
    eval 'sub planeA_x () { &pipeA_x;}' unless defined(&planeA_x);
    eval 'sub planeA_y () { &pipeA_y;}' unless defined(&planeA_y);
    eval 'sub planeA_w () { &pipeA_w;}' unless defined(&planeA_w);
    eval 'sub planeA_h () { &pipeA_h;}' unless defined(&planeA_h);
    eval 'sub planeB_x () { &pipeB_x;}' unless defined(&planeB_x);
    eval 'sub planeB_y () { &pipeB_y;}' unless defined(&planeB_y);
    eval 'sub planeB_w () { &pipeB_w;}' unless defined(&planeB_w);
    eval 'sub planeB_h () { &pipeB_h;}' unless defined(&planeB_h);
    eval 'sub I915_BOX_RING_EMPTY () {0x1;}' unless defined(&I915_BOX_RING_EMPTY);
    eval 'sub I915_BOX_FLIP () {0x2;}' unless defined(&I915_BOX_FLIP);
    eval 'sub I915_BOX_WAIT () {0x4;}' unless defined(&I915_BOX_WAIT);
    eval 'sub I915_BOX_TEXTURE_LOAD () {0x8;}' unless defined(&I915_BOX_TEXTURE_LOAD);
    eval 'sub I915_BOX_LOST_CONTEXT () {0x10;}' unless defined(&I915_BOX_LOST_CONTEXT);
    eval 'sub DRM_I915_INIT () {0x;}' unless defined(&DRM_I915_INIT);
    eval 'sub DRM_I915_FLUSH () {0x1;}' unless defined(&DRM_I915_FLUSH);
    eval 'sub DRM_I915_FLIP () {0x2;}' unless defined(&DRM_I915_FLIP);
    eval 'sub DRM_I915_BATCHBUFFER () {0x3;}' unless defined(&DRM_I915_BATCHBUFFER);
    eval 'sub DRM_I915_IRQ_EMIT () {0x4;}' unless defined(&DRM_I915_IRQ_EMIT);
    eval 'sub DRM_I915_IRQ_WAIT () {0x5;}' unless defined(&DRM_I915_IRQ_WAIT);
    eval 'sub DRM_I915_GETPARAM () {0x6;}' unless defined(&DRM_I915_GETPARAM);
    eval 'sub DRM_I915_SETPARAM () {0x7;}' unless defined(&DRM_I915_SETPARAM);
    eval 'sub DRM_I915_ALLOC () {0x8;}' unless defined(&DRM_I915_ALLOC);
    eval 'sub DRM_I915_FREE () {0x9;}' unless defined(&DRM_I915_FREE);
    eval 'sub DRM_I915_INIT_HEAP () {0xa;}' unless defined(&DRM_I915_INIT_HEAP);
    eval 'sub DRM_I915_CMDBUFFER () {0xb;}' unless defined(&DRM_I915_CMDBUFFER);
    eval 'sub DRM_I915_DESTROY_HEAP () {0xc;}' unless defined(&DRM_I915_DESTROY_HEAP);
    eval 'sub DRM_I915_SET_VBLANK_PIPE () {0xd;}' unless defined(&DRM_I915_SET_VBLANK_PIPE);
    eval 'sub DRM_I915_GET_VBLANK_PIPE () {0xe;}' unless defined(&DRM_I915_GET_VBLANK_PIPE);
    eval 'sub DRM_I915_VBLANK_SWAP () {0xf;}' unless defined(&DRM_I915_VBLANK_SWAP);
    eval 'sub DRM_I915_HWS_ADDR () {0x11;}' unless defined(&DRM_I915_HWS_ADDR);
    eval 'sub DRM_I915_GEM_INIT () {0x13;}' unless defined(&DRM_I915_GEM_INIT);
    eval 'sub DRM_I915_GEM_EXECBUFFER () {0x14;}' unless defined(&DRM_I915_GEM_EXECBUFFER);
    eval 'sub DRM_I915_GEM_PIN () {0x15;}' unless defined(&DRM_I915_GEM_PIN);
    eval 'sub DRM_I915_GEM_UNPIN () {0x16;}' unless defined(&DRM_I915_GEM_UNPIN);
    eval 'sub DRM_I915_GEM_BUSY () {0x17;}' unless defined(&DRM_I915_GEM_BUSY);
    eval 'sub DRM_I915_GEM_THROTTLE () {0x18;}' unless defined(&DRM_I915_GEM_THROTTLE);
    eval 'sub DRM_I915_GEM_ENTERVT () {0x19;}' unless defined(&DRM_I915_GEM_ENTERVT);
    eval 'sub DRM_I915_GEM_LEAVEVT () {0x1a;}' unless defined(&DRM_I915_GEM_LEAVEVT);
    eval 'sub DRM_I915_GEM_CREATE () {0x1b;}' unless defined(&DRM_I915_GEM_CREATE);
    eval 'sub DRM_I915_GEM_PREAD () {0x1c;}' unless defined(&DRM_I915_GEM_PREAD);
    eval 'sub DRM_I915_GEM_PWRITE () {0x1d;}' unless defined(&DRM_I915_GEM_PWRITE);
    eval 'sub DRM_I915_GEM_MMAP () {0x1e;}' unless defined(&DRM_I915_GEM_MMAP);
    eval 'sub DRM_I915_GEM_SET_DOMAIN () {0x1f;}' unless defined(&DRM_I915_GEM_SET_DOMAIN);
    eval 'sub DRM_I915_GEM_SW_FINISH () {0x20;}' unless defined(&DRM_I915_GEM_SW_FINISH);
    eval 'sub DRM_I915_GEM_SET_TILING () {0x21;}' unless defined(&DRM_I915_GEM_SET_TILING);
    eval 'sub DRM_I915_GEM_GET_TILING () {0x22;}' unless defined(&DRM_I915_GEM_GET_TILING);
    eval 'sub DRM_I915_GEM_GET_APERTURE () {0x23;}' unless defined(&DRM_I915_GEM_GET_APERTURE);
    eval 'sub DRM_I915_GEM_MMAP_GTT () {0x24;}' unless defined(&DRM_I915_GEM_MMAP_GTT);
    eval 'sub DRM_I915_GET_PIPE_FROM_CRTC_ID () {0x25;}' unless defined(&DRM_I915_GET_PIPE_FROM_CRTC_ID);
    eval 'sub DRM_I915_GEM_MADVISE () {0x26;}' unless defined(&DRM_I915_GEM_MADVISE);
    eval 'sub DRM_I915_OVERLAY_PUT_IMAGE () {0x27;}' unless defined(&DRM_I915_OVERLAY_PUT_IMAGE);
    eval 'sub DRM_I915_OVERLAY_ATTRS () {0x28;}' unless defined(&DRM_I915_OVERLAY_ATTRS);
    eval 'sub DRM_I915_GEM_EXECBUFFER2 () {0x29;}' unless defined(&DRM_I915_GEM_EXECBUFFER2);
    eval 'sub DRM_I915_GEM_EXECBUFFER2_WR () { &DRM_I915_GEM_EXECBUFFER2;}' unless defined(&DRM_I915_GEM_EXECBUFFER2_WR);
    eval 'sub DRM_I915_GET_SPRITE_COLORKEY () {0x2a;}' unless defined(&DRM_I915_GET_SPRITE_COLORKEY);
    eval 'sub DRM_I915_SET_SPRITE_COLORKEY () {0x2b;}' unless defined(&DRM_I915_SET_SPRITE_COLORKEY);
    eval 'sub DRM_I915_GEM_WAIT () {0x2c;}' unless defined(&DRM_I915_GEM_WAIT);
    eval 'sub DRM_I915_GEM_CONTEXT_CREATE () {0x2d;}' unless defined(&DRM_I915_GEM_CONTEXT_CREATE);
    eval 'sub DRM_I915_GEM_CONTEXT_DESTROY () {0x2e;}' unless defined(&DRM_I915_GEM_CONTEXT_DESTROY);
    eval 'sub DRM_I915_GEM_SET_CACHING () {0x2f;}' unless defined(&DRM_I915_GEM_SET_CACHING);
    eval 'sub DRM_I915_GEM_GET_CACHING () {0x30;}' unless defined(&DRM_I915_GEM_GET_CACHING);
    eval 'sub DRM_I915_REG_READ () {0x31;}' unless defined(&DRM_I915_REG_READ);
    eval 'sub DRM_I915_GET_RESET_STATS () {0x32;}' unless defined(&DRM_I915_GET_RESET_STATS);
    eval 'sub DRM_I915_GEM_USERPTR () {0x33;}' unless defined(&DRM_I915_GEM_USERPTR);
    eval 'sub DRM_I915_GEM_CONTEXT_GETPARAM () {0x34;}' unless defined(&DRM_I915_GEM_CONTEXT_GETPARAM);
    eval 'sub DRM_I915_GEM_CONTEXT_SETPARAM () {0x35;}' unless defined(&DRM_I915_GEM_CONTEXT_SETPARAM);
    eval 'sub DRM_I915_PERF_OPEN () {0x36;}' unless defined(&DRM_I915_PERF_OPEN);
    eval 'sub DRM_I915_PERF_ADD_CONFIG () {0x37;}' unless defined(&DRM_I915_PERF_ADD_CONFIG);
    eval 'sub DRM_I915_PERF_REMOVE_CONFIG () {0x38;}' unless defined(&DRM_I915_PERF_REMOVE_CONFIG);
    eval 'sub DRM_I915_QUERY () {0x39;}' unless defined(&DRM_I915_QUERY);
    eval 'sub DRM_I915_GEM_VM_CREATE () {0x3a;}' unless defined(&DRM_I915_GEM_VM_CREATE);
    eval 'sub DRM_I915_GEM_VM_DESTROY () {0x3b;}' unless defined(&DRM_I915_GEM_VM_DESTROY);
    eval 'sub DRM_I915_GEM_CREATE_EXT () {0x3c;}' unless defined(&DRM_I915_GEM_CREATE_EXT);
    eval 'sub DRM_IOCTL_I915_INIT () { &DRM_IOW(  &DRM_COMMAND_BASE +  &DRM_I915_INIT,  &drm_i915_init_t);}' unless defined(&DRM_IOCTL_I915_INIT);
    eval 'sub DRM_IOCTL_I915_FLUSH () { &DRM_IO (  &DRM_COMMAND_BASE +  &DRM_I915_FLUSH);}' unless defined(&DRM_IOCTL_I915_FLUSH);
    eval 'sub DRM_IOCTL_I915_FLIP () { &DRM_IO (  &DRM_COMMAND_BASE +  &DRM_I915_FLIP);}' unless defined(&DRM_IOCTL_I915_FLIP);
    eval 'sub DRM_IOCTL_I915_BATCHBUFFER () { &DRM_IOW(  &DRM_COMMAND_BASE +  &DRM_I915_BATCHBUFFER,  &drm_i915_batchbuffer_t);}' unless defined(&DRM_IOCTL_I915_BATCHBUFFER);
    eval 'sub DRM_IOCTL_I915_IRQ_EMIT () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_IRQ_EMIT,  &drm_i915_irq_emit_t);}' unless defined(&DRM_IOCTL_I915_IRQ_EMIT);
    eval 'sub DRM_IOCTL_I915_IRQ_WAIT () { &DRM_IOW(  &DRM_COMMAND_BASE +  &DRM_I915_IRQ_WAIT,  &drm_i915_irq_wait_t);}' unless defined(&DRM_IOCTL_I915_IRQ_WAIT);
    eval 'sub DRM_IOCTL_I915_GETPARAM () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GETPARAM,  &drm_i915_getparam_t);}' unless defined(&DRM_IOCTL_I915_GETPARAM);
    eval 'sub DRM_IOCTL_I915_SETPARAM () { &DRM_IOW(  &DRM_COMMAND_BASE +  &DRM_I915_SETPARAM,  &drm_i915_setparam_t);}' unless defined(&DRM_IOCTL_I915_SETPARAM);
    eval 'sub DRM_IOCTL_I915_ALLOC () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_ALLOC,  &drm_i915_mem_alloc_t);}' unless defined(&DRM_IOCTL_I915_ALLOC);
    eval 'sub DRM_IOCTL_I915_FREE () { &DRM_IOW(  &DRM_COMMAND_BASE +  &DRM_I915_FREE,  &drm_i915_mem_free_t);}' unless defined(&DRM_IOCTL_I915_FREE);
    eval 'sub DRM_IOCTL_I915_INIT_HEAP () { &DRM_IOW(  &DRM_COMMAND_BASE +  &DRM_I915_INIT_HEAP,  &drm_i915_mem_init_heap_t);}' unless defined(&DRM_IOCTL_I915_INIT_HEAP);
    eval 'sub DRM_IOCTL_I915_CMDBUFFER () { &DRM_IOW(  &DRM_COMMAND_BASE +  &DRM_I915_CMDBUFFER,  &drm_i915_cmdbuffer_t);}' unless defined(&DRM_IOCTL_I915_CMDBUFFER);
    eval 'sub DRM_IOCTL_I915_DESTROY_HEAP () { &DRM_IOW(  &DRM_COMMAND_BASE +  &DRM_I915_DESTROY_HEAP,  &drm_i915_mem_destroy_heap_t);}' unless defined(&DRM_IOCTL_I915_DESTROY_HEAP);
    eval 'sub DRM_IOCTL_I915_SET_VBLANK_PIPE () { &DRM_IOW(  &DRM_COMMAND_BASE +  &DRM_I915_SET_VBLANK_PIPE,  &drm_i915_vblank_pipe_t);}' unless defined(&DRM_IOCTL_I915_SET_VBLANK_PIPE);
    eval 'sub DRM_IOCTL_I915_GET_VBLANK_PIPE () { &DRM_IOR(  &DRM_COMMAND_BASE +  &DRM_I915_GET_VBLANK_PIPE,  &drm_i915_vblank_pipe_t);}' unless defined(&DRM_IOCTL_I915_GET_VBLANK_PIPE);
    eval 'sub DRM_IOCTL_I915_VBLANK_SWAP () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_VBLANK_SWAP,  &drm_i915_vblank_swap_t);}' unless defined(&DRM_IOCTL_I915_VBLANK_SWAP);
    eval 'sub DRM_IOCTL_I915_HWS_ADDR () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_HWS_ADDR, \'struct drm_i915_gem_init\');}' unless defined(&DRM_IOCTL_I915_HWS_ADDR);
    eval 'sub DRM_IOCTL_I915_GEM_INIT () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_GEM_INIT, \'struct drm_i915_gem_init\');}' unless defined(&DRM_IOCTL_I915_GEM_INIT);
    eval 'sub DRM_IOCTL_I915_GEM_EXECBUFFER () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_GEM_EXECBUFFER, \'struct drm_i915_gem_execbuffer\');}' unless defined(&DRM_IOCTL_I915_GEM_EXECBUFFER);
    eval 'sub DRM_IOCTL_I915_GEM_EXECBUFFER2 () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_GEM_EXECBUFFER2, \'struct drm_i915_gem_execbuffer2\');}' unless defined(&DRM_IOCTL_I915_GEM_EXECBUFFER2);
    eval 'sub DRM_IOCTL_I915_GEM_EXECBUFFER2_WR () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_EXECBUFFER2_WR, \'struct drm_i915_gem_execbuffer2\');}' unless defined(&DRM_IOCTL_I915_GEM_EXECBUFFER2_WR);
    eval 'sub DRM_IOCTL_I915_GEM_PIN () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_PIN, \'struct drm_i915_gem_pin\');}' unless defined(&DRM_IOCTL_I915_GEM_PIN);
    eval 'sub DRM_IOCTL_I915_GEM_UNPIN () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_GEM_UNPIN, \'struct drm_i915_gem_unpin\');}' unless defined(&DRM_IOCTL_I915_GEM_UNPIN);
    eval 'sub DRM_IOCTL_I915_GEM_BUSY () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_BUSY, \'struct drm_i915_gem_busy\');}' unless defined(&DRM_IOCTL_I915_GEM_BUSY);
    eval 'sub DRM_IOCTL_I915_GEM_SET_CACHING () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_GEM_SET_CACHING, \'struct drm_i915_gem_caching\');}' unless defined(&DRM_IOCTL_I915_GEM_SET_CACHING);
    eval 'sub DRM_IOCTL_I915_GEM_GET_CACHING () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_GET_CACHING, \'struct drm_i915_gem_caching\');}' unless defined(&DRM_IOCTL_I915_GEM_GET_CACHING);
    eval 'sub DRM_IOCTL_I915_GEM_THROTTLE () { &DRM_IO (  &DRM_COMMAND_BASE +  &DRM_I915_GEM_THROTTLE);}' unless defined(&DRM_IOCTL_I915_GEM_THROTTLE);
    eval 'sub DRM_IOCTL_I915_GEM_ENTERVT () { &DRM_IO( &DRM_COMMAND_BASE +  &DRM_I915_GEM_ENTERVT);}' unless defined(&DRM_IOCTL_I915_GEM_ENTERVT);
    eval 'sub DRM_IOCTL_I915_GEM_LEAVEVT () { &DRM_IO( &DRM_COMMAND_BASE +  &DRM_I915_GEM_LEAVEVT);}' unless defined(&DRM_IOCTL_I915_GEM_LEAVEVT);
    eval 'sub DRM_IOCTL_I915_GEM_CREATE () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_CREATE, \'struct drm_i915_gem_create\');}' unless defined(&DRM_IOCTL_I915_GEM_CREATE);
    eval 'sub DRM_IOCTL_I915_GEM_CREATE_EXT () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_CREATE_EXT, \'struct drm_i915_gem_create_ext\');}' unless defined(&DRM_IOCTL_I915_GEM_CREATE_EXT);
    eval 'sub DRM_IOCTL_I915_GEM_PREAD () { &DRM_IOW ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_PREAD, \'struct drm_i915_gem_pread\');}' unless defined(&DRM_IOCTL_I915_GEM_PREAD);
    eval 'sub DRM_IOCTL_I915_GEM_PWRITE () { &DRM_IOW ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_PWRITE, \'struct drm_i915_gem_pwrite\');}' unless defined(&DRM_IOCTL_I915_GEM_PWRITE);
    eval 'sub DRM_IOCTL_I915_GEM_MMAP () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_MMAP, \'struct drm_i915_gem_mmap\');}' unless defined(&DRM_IOCTL_I915_GEM_MMAP);
    eval 'sub DRM_IOCTL_I915_GEM_MMAP_GTT () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_MMAP_GTT, \'struct drm_i915_gem_mmap_gtt\');}' unless defined(&DRM_IOCTL_I915_GEM_MMAP_GTT);
    eval 'sub DRM_IOCTL_I915_GEM_MMAP_OFFSET () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_MMAP_GTT, \'struct drm_i915_gem_mmap_offset\');}' unless defined(&DRM_IOCTL_I915_GEM_MMAP_OFFSET);
    eval 'sub DRM_IOCTL_I915_GEM_SET_DOMAIN () { &DRM_IOW ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_SET_DOMAIN, \'struct drm_i915_gem_set_domain\');}' unless defined(&DRM_IOCTL_I915_GEM_SET_DOMAIN);
    eval 'sub DRM_IOCTL_I915_GEM_SW_FINISH () { &DRM_IOW ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_SW_FINISH, \'struct drm_i915_gem_sw_finish\');}' unless defined(&DRM_IOCTL_I915_GEM_SW_FINISH);
    eval 'sub DRM_IOCTL_I915_GEM_SET_TILING () { &DRM_IOWR ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_SET_TILING, \'struct drm_i915_gem_set_tiling\');}' unless defined(&DRM_IOCTL_I915_GEM_SET_TILING);
    eval 'sub DRM_IOCTL_I915_GEM_GET_TILING () { &DRM_IOWR ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_GET_TILING, \'struct drm_i915_gem_get_tiling\');}' unless defined(&DRM_IOCTL_I915_GEM_GET_TILING);
    eval 'sub DRM_IOCTL_I915_GEM_GET_APERTURE () { &DRM_IOR ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_GET_APERTURE, \'struct drm_i915_gem_get_aperture\');}' unless defined(&DRM_IOCTL_I915_GEM_GET_APERTURE);
    eval 'sub DRM_IOCTL_I915_GET_PIPE_FROM_CRTC_ID () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GET_PIPE_FROM_CRTC_ID, \'struct drm_i915_get_pipe_from_crtc_id\');}' unless defined(&DRM_IOCTL_I915_GET_PIPE_FROM_CRTC_ID);
    eval 'sub DRM_IOCTL_I915_GEM_MADVISE () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_MADVISE, \'struct drm_i915_gem_madvise\');}' unless defined(&DRM_IOCTL_I915_GEM_MADVISE);
    eval 'sub DRM_IOCTL_I915_OVERLAY_PUT_IMAGE () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_OVERLAY_PUT_IMAGE, \'struct drm_intel_overlay_put_image\');}' unless defined(&DRM_IOCTL_I915_OVERLAY_PUT_IMAGE);
    eval 'sub DRM_IOCTL_I915_OVERLAY_ATTRS () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_OVERLAY_ATTRS, \'struct drm_intel_overlay_attrs\');}' unless defined(&DRM_IOCTL_I915_OVERLAY_ATTRS);
    eval 'sub DRM_IOCTL_I915_SET_SPRITE_COLORKEY () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_SET_SPRITE_COLORKEY, \'struct drm_intel_sprite_colorkey\');}' unless defined(&DRM_IOCTL_I915_SET_SPRITE_COLORKEY);
    eval 'sub DRM_IOCTL_I915_GET_SPRITE_COLORKEY () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GET_SPRITE_COLORKEY, \'struct drm_intel_sprite_colorkey\');}' unless defined(&DRM_IOCTL_I915_GET_SPRITE_COLORKEY);
    eval 'sub DRM_IOCTL_I915_GEM_WAIT () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_WAIT, \'struct drm_i915_gem_wait\');}' unless defined(&DRM_IOCTL_I915_GEM_WAIT);
    eval 'sub DRM_IOCTL_I915_GEM_CONTEXT_CREATE () { &DRM_IOWR ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_CONTEXT_CREATE, \'struct drm_i915_gem_context_create\');}' unless defined(&DRM_IOCTL_I915_GEM_CONTEXT_CREATE);
    eval 'sub DRM_IOCTL_I915_GEM_CONTEXT_CREATE_EXT () { &DRM_IOWR ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_CONTEXT_CREATE, \'struct drm_i915_gem_context_create_ext\');}' unless defined(&DRM_IOCTL_I915_GEM_CONTEXT_CREATE_EXT);
    eval 'sub DRM_IOCTL_I915_GEM_CONTEXT_DESTROY () { &DRM_IOW ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_CONTEXT_DESTROY, \'struct drm_i915_gem_context_destroy\');}' unless defined(&DRM_IOCTL_I915_GEM_CONTEXT_DESTROY);
    eval 'sub DRM_IOCTL_I915_REG_READ () { &DRM_IOWR ( &DRM_COMMAND_BASE +  &DRM_I915_REG_READ, \'struct drm_i915_reg_read\');}' unless defined(&DRM_IOCTL_I915_REG_READ);
    eval 'sub DRM_IOCTL_I915_GET_RESET_STATS () { &DRM_IOWR ( &DRM_COMMAND_BASE +  &DRM_I915_GET_RESET_STATS, \'struct drm_i915_reset_stats\');}' unless defined(&DRM_IOCTL_I915_GET_RESET_STATS);
    eval 'sub DRM_IOCTL_I915_GEM_USERPTR () { &DRM_IOWR ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_USERPTR, \'struct drm_i915_gem_userptr\');}' unless defined(&DRM_IOCTL_I915_GEM_USERPTR);
    eval 'sub DRM_IOCTL_I915_GEM_CONTEXT_GETPARAM () { &DRM_IOWR ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_CONTEXT_GETPARAM, \'struct drm_i915_gem_context_param\');}' unless defined(&DRM_IOCTL_I915_GEM_CONTEXT_GETPARAM);
    eval 'sub DRM_IOCTL_I915_GEM_CONTEXT_SETPARAM () { &DRM_IOWR ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_CONTEXT_SETPARAM, \'struct drm_i915_gem_context_param\');}' unless defined(&DRM_IOCTL_I915_GEM_CONTEXT_SETPARAM);
    eval 'sub DRM_IOCTL_I915_PERF_OPEN () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_PERF_OPEN, \'struct drm_i915_perf_open_param\');}' unless defined(&DRM_IOCTL_I915_PERF_OPEN);
    eval 'sub DRM_IOCTL_I915_PERF_ADD_CONFIG () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_PERF_ADD_CONFIG, \'struct drm_i915_perf_oa_config\');}' unless defined(&DRM_IOCTL_I915_PERF_ADD_CONFIG);
    eval 'sub DRM_IOCTL_I915_PERF_REMOVE_CONFIG () { &DRM_IOW( &DRM_COMMAND_BASE +  &DRM_I915_PERF_REMOVE_CONFIG,  &__u64);}' unless defined(&DRM_IOCTL_I915_PERF_REMOVE_CONFIG);
    eval 'sub DRM_IOCTL_I915_QUERY () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_QUERY, \'struct drm_i915_query\');}' unless defined(&DRM_IOCTL_I915_QUERY);
    eval 'sub DRM_IOCTL_I915_GEM_VM_CREATE () { &DRM_IOWR( &DRM_COMMAND_BASE +  &DRM_I915_GEM_VM_CREATE, \'struct drm_i915_gem_vm_control\');}' unless defined(&DRM_IOCTL_I915_GEM_VM_CREATE);
    eval 'sub DRM_IOCTL_I915_GEM_VM_DESTROY () { &DRM_IOW ( &DRM_COMMAND_BASE +  &DRM_I915_GEM_VM_DESTROY, \'struct drm_i915_gem_vm_control\');}' unless defined(&DRM_IOCTL_I915_GEM_VM_DESTROY);
    eval 'sub I915_GEM_PPGTT_NONE () {0;}' unless defined(&I915_GEM_PPGTT_NONE);
    eval 'sub I915_GEM_PPGTT_ALIASING () {1;}' unless defined(&I915_GEM_PPGTT_ALIASING);
    eval 'sub I915_GEM_PPGTT_FULL () {2;}' unless defined(&I915_GEM_PPGTT_FULL);
    eval 'sub I915_PARAM_IRQ_ACTIVE () {1;}' unless defined(&I915_PARAM_IRQ_ACTIVE);
    eval 'sub I915_PARAM_ALLOW_BATCHBUFFER () {2;}' unless defined(&I915_PARAM_ALLOW_BATCHBUFFER);
    eval 'sub I915_PARAM_LAST_DISPATCH () {3;}' unless defined(&I915_PARAM_LAST_DISPATCH);
    eval 'sub I915_PARAM_CHIPSET_ID () {4;}' unless defined(&I915_PARAM_CHIPSET_ID);
    eval 'sub I915_PARAM_HAS_GEM () {5;}' unless defined(&I915_PARAM_HAS_GEM);
    eval 'sub I915_PARAM_NUM_FENCES_AVAIL () {6;}' unless defined(&I915_PARAM_NUM_FENCES_AVAIL);
    eval 'sub I915_PARAM_HAS_OVERLAY () {7;}' unless defined(&I915_PARAM_HAS_OVERLAY);
    eval 'sub I915_PARAM_HAS_PAGEFLIPPING () {8;}' unless defined(&I915_PARAM_HAS_PAGEFLIPPING);
    eval 'sub I915_PARAM_HAS_EXECBUF2 () {9;}' unless defined(&I915_PARAM_HAS_EXECBUF2);
    eval 'sub I915_PARAM_HAS_BSD () {10;}' unless defined(&I915_PARAM_HAS_BSD);
    eval 'sub I915_PARAM_HAS_BLT () {11;}' unless defined(&I915_PARAM_HAS_BLT);
    eval 'sub I915_PARAM_HAS_RELAXED_FENCING () {12;}' unless defined(&I915_PARAM_HAS_RELAXED_FENCING);
    eval 'sub I915_PARAM_HAS_COHERENT_RINGS () {13;}' unless defined(&I915_PARAM_HAS_COHERENT_RINGS);
    eval 'sub I915_PARAM_HAS_EXEC_CONSTANTS () {14;}' unless defined(&I915_PARAM_HAS_EXEC_CONSTANTS);
    eval 'sub I915_PARAM_HAS_RELAXED_DELTA () {15;}' unless defined(&I915_PARAM_HAS_RELAXED_DELTA);
    eval 'sub I915_PARAM_HAS_GEN7_SOL_RESET () {16;}' unless defined(&I915_PARAM_HAS_GEN7_SOL_RESET);
    eval 'sub I915_PARAM_HAS_LLC () {17;}' unless defined(&I915_PARAM_HAS_LLC);
    eval 'sub I915_PARAM_HAS_ALIASING_PPGTT () {18;}' unless defined(&I915_PARAM_HAS_ALIASING_PPGTT);
    eval 'sub I915_PARAM_HAS_WAIT_TIMEOUT () {19;}' unless defined(&I915_PARAM_HAS_WAIT_TIMEOUT);
    eval 'sub I915_PARAM_HAS_SEMAPHORES () {20;}' unless defined(&I915_PARAM_HAS_SEMAPHORES);
    eval 'sub I915_PARAM_HAS_PRIME_VMAP_FLUSH () {21;}' unless defined(&I915_PARAM_HAS_PRIME_VMAP_FLUSH);
    eval 'sub I915_PARAM_HAS_VEBOX () {22;}' unless defined(&I915_PARAM_HAS_VEBOX);
    eval 'sub I915_PARAM_HAS_SECURE_BATCHES () {23;}' unless defined(&I915_PARAM_HAS_SECURE_BATCHES);
    eval 'sub I915_PARAM_HAS_PINNED_BATCHES () {24;}' unless defined(&I915_PARAM_HAS_PINNED_BATCHES);
    eval 'sub I915_PARAM_HAS_EXEC_NO_RELOC () {25;}' unless defined(&I915_PARAM_HAS_EXEC_NO_RELOC);
    eval 'sub I915_PARAM_HAS_EXEC_HANDLE_LUT () {26;}' unless defined(&I915_PARAM_HAS_EXEC_HANDLE_LUT);
    eval 'sub I915_PARAM_HAS_WT () {27;}' unless defined(&I915_PARAM_HAS_WT);
    eval 'sub I915_PARAM_CMD_PARSER_VERSION () {28;}' unless defined(&I915_PARAM_CMD_PARSER_VERSION);
    eval 'sub I915_PARAM_HAS_COHERENT_PHYS_GTT () {29;}' unless defined(&I915_PARAM_HAS_COHERENT_PHYS_GTT);
    eval 'sub I915_PARAM_MMAP_VERSION () {30;}' unless defined(&I915_PARAM_MMAP_VERSION);
    eval 'sub I915_PARAM_HAS_BSD2 () {31;}' unless defined(&I915_PARAM_HAS_BSD2);
    eval 'sub I915_PARAM_REVISION () {32;}' unless defined(&I915_PARAM_REVISION);
    eval 'sub I915_PARAM_SUBSLICE_TOTAL () {33;}' unless defined(&I915_PARAM_SUBSLICE_TOTAL);
    eval 'sub I915_PARAM_EU_TOTAL () {34;}' unless defined(&I915_PARAM_EU_TOTAL);
    eval 'sub I915_PARAM_HAS_GPU_RESET () {35;}' unless defined(&I915_PARAM_HAS_GPU_RESET);
    eval 'sub I915_PARAM_HAS_RESOURCE_STREAMER () {36;}' unless defined(&I915_PARAM_HAS_RESOURCE_STREAMER);
    eval 'sub I915_PARAM_HAS_EXEC_SOFTPIN () {37;}' unless defined(&I915_PARAM_HAS_EXEC_SOFTPIN);
    eval 'sub I915_PARAM_HAS_POOLED_EU () {38;}' unless defined(&I915_PARAM_HAS_POOLED_EU);
    eval 'sub I915_PARAM_MIN_EU_IN_POOL () {39;}' unless defined(&I915_PARAM_MIN_EU_IN_POOL);
    eval 'sub I915_PARAM_MMAP_GTT_VERSION () {40;}' unless defined(&I915_PARAM_MMAP_GTT_VERSION);
    eval 'sub I915_PARAM_HAS_SCHEDULER () {41;}' unless defined(&I915_PARAM_HAS_SCHEDULER);
    eval 'sub I915_SCHEDULER_CAP_ENABLED () {(1 << 0);}' unless defined(&I915_SCHEDULER_CAP_ENABLED);
    eval 'sub I915_SCHEDULER_CAP_PRIORITY () {(1 << 1);}' unless defined(&I915_SCHEDULER_CAP_PRIORITY);
    eval 'sub I915_SCHEDULER_CAP_PREEMPTION () {(1 << 2);}' unless defined(&I915_SCHEDULER_CAP_PREEMPTION);
    eval 'sub I915_SCHEDULER_CAP_SEMAPHORES () {(1 << 3);}' unless defined(&I915_SCHEDULER_CAP_SEMAPHORES);
    eval 'sub I915_SCHEDULER_CAP_ENGINE_BUSY_STATS () {(1 << 4);}' unless defined(&I915_SCHEDULER_CAP_ENGINE_BUSY_STATS);
    eval 'sub I915_SCHEDULER_CAP_STATIC_PRIORITY_MAP () {(1 << 5);}' unless defined(&I915_SCHEDULER_CAP_STATIC_PRIORITY_MAP);
    eval 'sub I915_PARAM_HUC_STATUS () {42;}' unless defined(&I915_PARAM_HUC_STATUS);
    eval 'sub I915_PARAM_HAS_EXEC_ASYNC () {43;}' unless defined(&I915_PARAM_HAS_EXEC_ASYNC);
    eval 'sub I915_PARAM_HAS_EXEC_FENCE () {44;}' unless defined(&I915_PARAM_HAS_EXEC_FENCE);
    eval 'sub I915_PARAM_HAS_EXEC_CAPTURE () {45;}' unless defined(&I915_PARAM_HAS_EXEC_CAPTURE);
    eval 'sub I915_PARAM_SLICE_MASK () {46;}' unless defined(&I915_PARAM_SLICE_MASK);
    eval 'sub I915_PARAM_SUBSLICE_MASK () {47;}' unless defined(&I915_PARAM_SUBSLICE_MASK);
    eval 'sub I915_PARAM_HAS_EXEC_BATCH_FIRST () {48;}' unless defined(&I915_PARAM_HAS_EXEC_BATCH_FIRST);
    eval 'sub I915_PARAM_HAS_EXEC_FENCE_ARRAY () {49;}' unless defined(&I915_PARAM_HAS_EXEC_FENCE_ARRAY);
    eval 'sub I915_PARAM_HAS_CONTEXT_ISOLATION () {50;}' unless defined(&I915_PARAM_HAS_CONTEXT_ISOLATION);
    eval 'sub I915_PARAM_CS_TIMESTAMP_FREQUENCY () {51;}' unless defined(&I915_PARAM_CS_TIMESTAMP_FREQUENCY);
    eval 'sub I915_PARAM_MMAP_GTT_COHERENT () {52;}' unless defined(&I915_PARAM_MMAP_GTT_COHERENT);
    eval 'sub I915_PARAM_HAS_EXEC_SUBMIT_FENCE () {53;}' unless defined(&I915_PARAM_HAS_EXEC_SUBMIT_FENCE);
    eval 'sub I915_PARAM_PERF_REVISION () {54;}' unless defined(&I915_PARAM_PERF_REVISION);
    eval 'sub I915_PARAM_HAS_EXEC_TIMELINE_FENCES () {55;}' unless defined(&I915_PARAM_HAS_EXEC_TIMELINE_FENCES);
    eval 'sub I915_PARAM_HAS_USERPTR_PROBE () {56;}' unless defined(&I915_PARAM_HAS_USERPTR_PROBE);
    eval 'sub I915_SETPARAM_USE_MI_BATCHBUFFER_START () {1;}' unless defined(&I915_SETPARAM_USE_MI_BATCHBUFFER_START);
    eval 'sub I915_SETPARAM_TEX_LRU_LOG_GRANULARITY () {2;}' unless defined(&I915_SETPARAM_TEX_LRU_LOG_GRANULARITY);
    eval 'sub I915_SETPARAM_ALLOW_BATCHBUFFER () {3;}' unless defined(&I915_SETPARAM_ALLOW_BATCHBUFFER);
    eval 'sub I915_SETPARAM_NUM_USED_FENCES () {4;}' unless defined(&I915_SETPARAM_NUM_USED_FENCES);
    eval 'sub I915_MEM_REGION_AGP () {1;}' unless defined(&I915_MEM_REGION_AGP);
    eval 'sub DRM_I915_VBLANK_PIPE_A () {1;}' unless defined(&DRM_I915_VBLANK_PIPE_A);
    eval 'sub DRM_I915_VBLANK_PIPE_B () {2;}' unless defined(&DRM_I915_VBLANK_PIPE_B);
    eval 'sub I915_MMAP_WC () {0x1;}' unless defined(&I915_MMAP_WC);
    eval 'sub I915_MMAP_OFFSET_GTT () {0;}' unless defined(&I915_MMAP_OFFSET_GTT);
    eval 'sub I915_MMAP_OFFSET_WC () {1;}' unless defined(&I915_MMAP_OFFSET_WC);
    eval 'sub I915_MMAP_OFFSET_WB () {2;}' unless defined(&I915_MMAP_OFFSET_WB);
    eval 'sub I915_MMAP_OFFSET_UC () {3;}' unless defined(&I915_MMAP_OFFSET_UC);
    eval 'sub I915_MMAP_OFFSET_FIXED () {4;}' unless defined(&I915_MMAP_OFFSET_FIXED);
    eval 'sub I915_GEM_DOMAIN_CPU () {0x1;}' unless defined(&I915_GEM_DOMAIN_CPU);
    eval 'sub I915_GEM_DOMAIN_RENDER () {0x2;}' unless defined(&I915_GEM_DOMAIN_RENDER);
    eval 'sub I915_GEM_DOMAIN_SAMPLER () {0x4;}' unless defined(&I915_GEM_DOMAIN_SAMPLER);
    eval 'sub I915_GEM_DOMAIN_COMMAND () {0x8;}' unless defined(&I915_GEM_DOMAIN_COMMAND);
    eval 'sub I915_GEM_DOMAIN_INSTRUCTION () {0x10;}' unless defined(&I915_GEM_DOMAIN_INSTRUCTION);
    eval 'sub I915_GEM_DOMAIN_VERTEX () {0x20;}' unless defined(&I915_GEM_DOMAIN_VERTEX);
    eval 'sub I915_GEM_DOMAIN_GTT () {0x40;}' unless defined(&I915_GEM_DOMAIN_GTT);
    eval 'sub I915_GEM_DOMAIN_WC () {0x80;}' unless defined(&I915_GEM_DOMAIN_WC);
    eval 'sub EXEC_OBJECT_NEEDS_FENCE () {(1<<0);}' unless defined(&EXEC_OBJECT_NEEDS_FENCE);
    eval 'sub EXEC_OBJECT_NEEDS_GTT () {(1<<1);}' unless defined(&EXEC_OBJECT_NEEDS_GTT);
    eval 'sub EXEC_OBJECT_WRITE () {(1<<2);}' unless defined(&EXEC_OBJECT_WRITE);
    eval 'sub EXEC_OBJECT_SUPPORTS_48B_ADDRESS () {(1<<3);}' unless defined(&EXEC_OBJECT_SUPPORTS_48B_ADDRESS);
    eval 'sub EXEC_OBJECT_PINNED () {(1<<4);}' unless defined(&EXEC_OBJECT_PINNED);
    eval 'sub EXEC_OBJECT_PAD_TO_SIZE () {(1<<5);}' unless defined(&EXEC_OBJECT_PAD_TO_SIZE);
    eval 'sub EXEC_OBJECT_ASYNC () {(1<<6);}' unless defined(&EXEC_OBJECT_ASYNC);
    eval 'sub EXEC_OBJECT_CAPTURE () {(1<<7);}' unless defined(&EXEC_OBJECT_CAPTURE);
    eval 'sub __EXEC_OBJECT_UNKNOWN_FLAGS () {-( &EXEC_OBJECT_CAPTURE<<1);}' unless defined(&__EXEC_OBJECT_UNKNOWN_FLAGS);
    eval 'sub I915_EXEC_FENCE_WAIT () {(1<<0);}' unless defined(&I915_EXEC_FENCE_WAIT);
    eval 'sub I915_EXEC_FENCE_SIGNAL () {(1<<1);}' unless defined(&I915_EXEC_FENCE_SIGNAL);
    eval 'sub __I915_EXEC_FENCE_UNKNOWN_FLAGS () {(-( &I915_EXEC_FENCE_SIGNAL << 1));}' unless defined(&__I915_EXEC_FENCE_UNKNOWN_FLAGS);
    eval 'sub DRM_I915_GEM_EXECBUFFER_EXT_TIMELINE_FENCES () {0;}' unless defined(&DRM_I915_GEM_EXECBUFFER_EXT_TIMELINE_FENCES);
    eval 'sub I915_EXEC_RING_MASK () {(0x3f);}' unless defined(&I915_EXEC_RING_MASK);
    eval 'sub I915_EXEC_DEFAULT () {(0<<0);}' unless defined(&I915_EXEC_DEFAULT);
    eval 'sub I915_EXEC_RENDER () {(1<<0);}' unless defined(&I915_EXEC_RENDER);
    eval 'sub I915_EXEC_BSD () {(2<<0);}' unless defined(&I915_EXEC_BSD);
    eval 'sub I915_EXEC_BLT () {(3<<0);}' unless defined(&I915_EXEC_BLT);
    eval 'sub I915_EXEC_VEBOX () {(4<<0);}' unless defined(&I915_EXEC_VEBOX);
    eval 'sub I915_EXEC_CONSTANTS_MASK () {(3<<6);}' unless defined(&I915_EXEC_CONSTANTS_MASK);
    eval 'sub I915_EXEC_CONSTANTS_REL_GENERAL () {(0<<6);}' unless defined(&I915_EXEC_CONSTANTS_REL_GENERAL);
    eval 'sub I915_EXEC_CONSTANTS_ABSOLUTE () {(1<<6);}' unless defined(&I915_EXEC_CONSTANTS_ABSOLUTE);
    eval 'sub I915_EXEC_CONSTANTS_REL_SURFACE () {(2<<6);}' unless defined(&I915_EXEC_CONSTANTS_REL_SURFACE);
    eval 'sub I915_EXEC_GEN7_SOL_RESET () {(1<<8);}' unless defined(&I915_EXEC_GEN7_SOL_RESET);
    eval 'sub I915_EXEC_SECURE () {(1<<9);}' unless defined(&I915_EXEC_SECURE);
    eval 'sub I915_EXEC_IS_PINNED () {(1<<10);}' unless defined(&I915_EXEC_IS_PINNED);
    eval 'sub I915_EXEC_NO_RELOC () {(1<<11);}' unless defined(&I915_EXEC_NO_RELOC);
    eval 'sub I915_EXEC_HANDLE_LUT () {(1<<12);}' unless defined(&I915_EXEC_HANDLE_LUT);
    eval 'sub I915_EXEC_BSD_SHIFT () {(13);}' unless defined(&I915_EXEC_BSD_SHIFT);
    eval 'sub I915_EXEC_BSD_MASK () {(3<<  &I915_EXEC_BSD_SHIFT);}' unless defined(&I915_EXEC_BSD_MASK);
    eval 'sub I915_EXEC_BSD_DEFAULT () {(0<<  &I915_EXEC_BSD_SHIFT);}' unless defined(&I915_EXEC_BSD_DEFAULT);
    eval 'sub I915_EXEC_BSD_RING1 () {(1<<  &I915_EXEC_BSD_SHIFT);}' unless defined(&I915_EXEC_BSD_RING1);
    eval 'sub I915_EXEC_BSD_RING2 () {(2<<  &I915_EXEC_BSD_SHIFT);}' unless defined(&I915_EXEC_BSD_RING2);
    eval 'sub I915_EXEC_RESOURCE_STREAMER () {(1<<15);}' unless defined(&I915_EXEC_RESOURCE_STREAMER);
    eval 'sub I915_EXEC_FENCE_IN () {(1<<16);}' unless defined(&I915_EXEC_FENCE_IN);
    eval 'sub I915_EXEC_FENCE_OUT () {(1<<17);}' unless defined(&I915_EXEC_FENCE_OUT);
    eval 'sub I915_EXEC_BATCH_FIRST () {(1<<18);}' unless defined(&I915_EXEC_BATCH_FIRST);
    eval 'sub I915_EXEC_FENCE_ARRAY () {(1<<19);}' unless defined(&I915_EXEC_FENCE_ARRAY);
    eval 'sub I915_EXEC_FENCE_SUBMIT () {(1<< 20);}' unless defined(&I915_EXEC_FENCE_SUBMIT);
    eval 'sub I915_EXEC_USE_EXTENSIONS () {(1<< 21);}' unless defined(&I915_EXEC_USE_EXTENSIONS);
    eval 'sub __I915_EXEC_UNKNOWN_FLAGS () {(-( &I915_EXEC_USE_EXTENSIONS << 1));}' unless defined(&__I915_EXEC_UNKNOWN_FLAGS);
    eval 'sub I915_EXEC_CONTEXT_ID_MASK () {(0xffffffff);}' unless defined(&I915_EXEC_CONTEXT_ID_MASK);
    eval 'sub i915_execbuffer2_set_context_id {
        my($eb2, $context) = @_;
	    eval q(($eb2). &rsvd1 = $context &  &I915_EXEC_CONTEXT_ID_MASK);
    }' unless defined(&i915_execbuffer2_set_context_id);
    eval 'sub i915_execbuffer2_get_context_id {
        my($eb2) = @_;
	    eval q((($eb2). &rsvd1 &  &I915_EXEC_CONTEXT_ID_MASK));
    }' unless defined(&i915_execbuffer2_get_context_id);
    eval 'sub I915_CACHING_NONE () {0;}' unless defined(&I915_CACHING_NONE);
    eval 'sub I915_CACHING_CACHED () {1;}' unless defined(&I915_CACHING_CACHED);
    eval 'sub I915_CACHING_DISPLAY () {2;}' unless defined(&I915_CACHING_DISPLAY);
    eval 'sub I915_TILING_NONE () {0;}' unless defined(&I915_TILING_NONE);
    eval 'sub I915_TILING_X () {1;}' unless defined(&I915_TILING_X);
    eval 'sub I915_TILING_Y () {2;}' unless defined(&I915_TILING_Y);
    eval 'sub I915_TILING_LAST () { &I915_TILING_Y;}' unless defined(&I915_TILING_LAST);
    eval 'sub I915_BIT_6_SWIZZLE_NONE () {0;}' unless defined(&I915_BIT_6_SWIZZLE_NONE);
    eval 'sub I915_BIT_6_SWIZZLE_9 () {1;}' unless defined(&I915_BIT_6_SWIZZLE_9);
    eval 'sub I915_BIT_6_SWIZZLE_9_10 () {2;}' unless defined(&I915_BIT_6_SWIZZLE_9_10);
    eval 'sub I915_BIT_6_SWIZZLE_9_11 () {3;}' unless defined(&I915_BIT_6_SWIZZLE_9_11);
    eval 'sub I915_BIT_6_SWIZZLE_9_10_11 () {4;}' unless defined(&I915_BIT_6_SWIZZLE_9_10_11);
    eval 'sub I915_BIT_6_SWIZZLE_UNKNOWN () {5;}' unless defined(&I915_BIT_6_SWIZZLE_UNKNOWN);
    eval 'sub I915_BIT_6_SWIZZLE_9_17 () {6;}' unless defined(&I915_BIT_6_SWIZZLE_9_17);
    eval 'sub I915_BIT_6_SWIZZLE_9_10_17 () {7;}' unless defined(&I915_BIT_6_SWIZZLE_9_10_17);
    eval 'sub I915_MADV_WILLNEED () {0;}' unless defined(&I915_MADV_WILLNEED);
    eval 'sub I915_MADV_DONTNEED () {1;}' unless defined(&I915_MADV_DONTNEED);
    eval 'sub __I915_MADV_PURGED () {2;}' unless defined(&__I915_MADV_PURGED);
    eval 'sub I915_OVERLAY_TYPE_MASK () {0xff;}' unless defined(&I915_OVERLAY_TYPE_MASK);
    eval 'sub I915_OVERLAY_YUV_PLANAR () {0x1;}' unless defined(&I915_OVERLAY_YUV_PLANAR);
    eval 'sub I915_OVERLAY_YUV_PACKED () {0x2;}' unless defined(&I915_OVERLAY_YUV_PACKED);
    eval 'sub I915_OVERLAY_RGB () {0x3;}' unless defined(&I915_OVERLAY_RGB);
    eval 'sub I915_OVERLAY_DEPTH_MASK () {0xff00;}' unless defined(&I915_OVERLAY_DEPTH_MASK);
    eval 'sub I915_OVERLAY_RGB24 () {0x1000;}' unless defined(&I915_OVERLAY_RGB24);
    eval 'sub I915_OVERLAY_RGB16 () {0x2000;}' unless defined(&I915_OVERLAY_RGB16);
    eval 'sub I915_OVERLAY_RGB15 () {0x3000;}' unless defined(&I915_OVERLAY_RGB15);
    eval 'sub I915_OVERLAY_YUV422 () {0x100;}' unless defined(&I915_OVERLAY_YUV422);
    eval 'sub I915_OVERLAY_YUV411 () {0x200;}' unless defined(&I915_OVERLAY_YUV411);
    eval 'sub I915_OVERLAY_YUV420 () {0x300;}' unless defined(&I915_OVERLAY_YUV420);
    eval 'sub I915_OVERLAY_YUV410 () {0x400;}' unless defined(&I915_OVERLAY_YUV410);
    eval 'sub I915_OVERLAY_SWAP_MASK () {0xff0000;}' unless defined(&I915_OVERLAY_SWAP_MASK);
    eval 'sub I915_OVERLAY_NO_SWAP () {0x;}' unless defined(&I915_OVERLAY_NO_SWAP);
    eval 'sub I915_OVERLAY_UV_SWAP () {0x10000;}' unless defined(&I915_OVERLAY_UV_SWAP);
    eval 'sub I915_OVERLAY_Y_SWAP () {0x20000;}' unless defined(&I915_OVERLAY_Y_SWAP);
    eval 'sub I915_OVERLAY_Y_AND_UV_SWAP () {0x30000;}' unless defined(&I915_OVERLAY_Y_AND_UV_SWAP);
    eval 'sub I915_OVERLAY_FLAGS_MASK () {0xff000000;}' unless defined(&I915_OVERLAY_FLAGS_MASK);
    eval 'sub I915_OVERLAY_ENABLE () {0x1000000;}' unless defined(&I915_OVERLAY_ENABLE);
    eval 'sub I915_OVERLAY_UPDATE_ATTRS () {(1<<0);}' unless defined(&I915_OVERLAY_UPDATE_ATTRS);
    eval 'sub I915_OVERLAY_UPDATE_GAMMA () {(1<<1);}' unless defined(&I915_OVERLAY_UPDATE_GAMMA);
    eval 'sub I915_OVERLAY_DISABLE_DEST_COLORKEY () {(1<<2);}' unless defined(&I915_OVERLAY_DISABLE_DEST_COLORKEY);
    eval 'sub I915_SET_COLORKEY_NONE () {(1<<0);}' unless defined(&I915_SET_COLORKEY_NONE);
    eval 'sub I915_SET_COLORKEY_DESTINATION () {(1<<1);}' unless defined(&I915_SET_COLORKEY_DESTINATION);
    eval 'sub I915_SET_COLORKEY_SOURCE () {(1<<2);}' unless defined(&I915_SET_COLORKEY_SOURCE);
    eval 'sub I915_CONTEXT_CREATE_FLAGS_USE_EXTENSIONS () {(1 << 0);}' unless defined(&I915_CONTEXT_CREATE_FLAGS_USE_EXTENSIONS);
    eval 'sub I915_CONTEXT_CREATE_FLAGS_SINGLE_TIMELINE () {(1 << 1);}' unless defined(&I915_CONTEXT_CREATE_FLAGS_SINGLE_TIMELINE);
    eval 'sub I915_CONTEXT_CREATE_FLAGS_UNKNOWN () {(-( &I915_CONTEXT_CREATE_FLAGS_SINGLE_TIMELINE << 1));}' unless defined(&I915_CONTEXT_CREATE_FLAGS_UNKNOWN);
    eval 'sub I915_CONTEXT_CREATE_EXT_SETPARAM () {0;}' unless defined(&I915_CONTEXT_CREATE_EXT_SETPARAM);
    eval 'sub I915_CONTEXT_CREATE_EXT_CLONE () {1;}' unless defined(&I915_CONTEXT_CREATE_EXT_CLONE);
    eval 'sub I915_CONTEXT_PARAM_BAN_PERIOD () {0x1;}' unless defined(&I915_CONTEXT_PARAM_BAN_PERIOD);
    eval 'sub I915_CONTEXT_PARAM_NO_ZEROMAP () {0x2;}' unless defined(&I915_CONTEXT_PARAM_NO_ZEROMAP);
    eval 'sub I915_CONTEXT_PARAM_GTT_SIZE () {0x3;}' unless defined(&I915_CONTEXT_PARAM_GTT_SIZE);
    eval 'sub I915_CONTEXT_PARAM_NO_ERROR_CAPTURE () {0x4;}' unless defined(&I915_CONTEXT_PARAM_NO_ERROR_CAPTURE);
    eval 'sub I915_CONTEXT_PARAM_BANNABLE () {0x5;}' unless defined(&I915_CONTEXT_PARAM_BANNABLE);
    eval 'sub I915_CONTEXT_PARAM_PRIORITY () {0x6;}' unless defined(&I915_CONTEXT_PARAM_PRIORITY);
    eval 'sub I915_CONTEXT_MAX_USER_PRIORITY () {1023;}' unless defined(&I915_CONTEXT_MAX_USER_PRIORITY);
    eval 'sub I915_CONTEXT_DEFAULT_PRIORITY () {0;}' unless defined(&I915_CONTEXT_DEFAULT_PRIORITY);
    eval 'sub I915_CONTEXT_MIN_USER_PRIORITY () {-1023;}' unless defined(&I915_CONTEXT_MIN_USER_PRIORITY);
    eval 'sub I915_CONTEXT_PARAM_SSEU () {0x7;}' unless defined(&I915_CONTEXT_PARAM_SSEU);
    eval 'sub I915_CONTEXT_PARAM_RECOVERABLE () {0x8;}' unless defined(&I915_CONTEXT_PARAM_RECOVERABLE);
    eval 'sub I915_CONTEXT_PARAM_VM () {0x9;}' unless defined(&I915_CONTEXT_PARAM_VM);
    eval 'sub I915_CONTEXT_PARAM_ENGINES () {0xa;}' unless defined(&I915_CONTEXT_PARAM_ENGINES);
    eval 'sub I915_CONTEXT_PARAM_PERSISTENCE () {0xb;}' unless defined(&I915_CONTEXT_PARAM_PERSISTENCE);
    eval 'sub I915_CONTEXT_PARAM_RINGSIZE () {0xc;}' unless defined(&I915_CONTEXT_PARAM_RINGSIZE);
    eval 'sub I915_CONTEXT_PARAM_PROTECTED_CONTENT () {0xd;}' unless defined(&I915_CONTEXT_PARAM_PROTECTED_CONTENT);
    eval 'sub I915_CONTEXT_SSEU_FLAG_ENGINE_INDEX () {(1 << 0);}' unless defined(&I915_CONTEXT_SSEU_FLAG_ENGINE_INDEX);
    eval 'sub I915_DEFINE_CONTEXT_ENGINES_LOAD_BALANCE {
        my($name__, $N__) = @_;
	    eval q(\'struct struct\' { \'struct i915_user_extension\'  &base;  &__u16  &engine_index;  &__u16  &num_siblings;  &__u32  &flags;  &__u64  &mbz64; \'struct i915_engine_class_instance\'  $engines[$N__]; }  &__attribute__(( &packed)) $name__);
    }' unless defined(&I915_DEFINE_CONTEXT_ENGINES_LOAD_BALANCE);
    eval 'sub I915_DEFINE_CONTEXT_ENGINES_BOND {
        my($name__, $N__) = @_;
	    eval q(\'struct struct\' { \'struct i915_user_extension\'  &base; \'struct i915_engine_class_instance\'  &master;  &__u16  &virtual_index;  &__u16  &num_bonds;  &__u64  &flags;  &__u64  $mbz64[4]; \'struct i915_engine_class_instance\'  $engines[$N__]; }  &__attribute__(( &packed)) $name__);
    }' unless defined(&I915_DEFINE_CONTEXT_ENGINES_BOND);
    eval 'sub I915_DEFINE_CONTEXT_ENGINES_PARALLEL_SUBMIT {
        my($name__, $N__) = @_;
	    eval q(\'struct struct\' { \'struct i915_user_extension\'  &base;  &__u16  &engine_index;  &__u16  &width;  &__u16  &num_siblings;  &__u16  &mbz16;  &__u64  &flags;  &__u64  $mbz64[3]; \'struct i915_engine_class_instance\'  $engines[$N__]; }  &__attribute__(( &packed)) $name__);
    }' unless defined(&I915_DEFINE_CONTEXT_ENGINES_PARALLEL_SUBMIT);
    eval 'sub I915_CONTEXT_ENGINES_EXT_LOAD_BALANCE () {0;}' unless defined(&I915_CONTEXT_ENGINES_EXT_LOAD_BALANCE);
    eval 'sub I915_CONTEXT_ENGINES_EXT_BOND () {1;}' unless defined(&I915_CONTEXT_ENGINES_EXT_BOND);
    eval 'sub I915_CONTEXT_ENGINES_EXT_PARALLEL_SUBMIT () {2;}' unless defined(&I915_CONTEXT_ENGINES_EXT_PARALLEL_SUBMIT);
    eval 'sub I915_DEFINE_CONTEXT_PARAM_ENGINES {
        my($name__, $N__) = @_;
	    eval q(\'struct struct\' {  &__u64  &extensions; \'struct i915_engine_class_instance\'  $engines[$N__]; }  &__attribute__(( &packed)) $name__);
    }' unless defined(&I915_DEFINE_CONTEXT_PARAM_ENGINES);
    eval 'sub I915_REG_READ_8B_WA () {(1 << 0);}' unless defined(&I915_REG_READ_8B_WA);
    eval 'sub I915_USERPTR_READ_ONLY () {0x1;}' unless defined(&I915_USERPTR_READ_ONLY);
    eval 'sub I915_USERPTR_PROBE () {0x2;}' unless defined(&I915_USERPTR_PROBE);
    eval 'sub I915_USERPTR_UNSYNCHRONIZED () {0x80000000;}' unless defined(&I915_USERPTR_UNSYNCHRONIZED);
    eval("sub I915_OA_FORMAT_A13 () { 1; }") unless defined(&I915_OA_FORMAT_A13);
    eval("sub I915_OA_FORMAT_A29 () { 2; }") unless defined(&I915_OA_FORMAT_A29);
    eval("sub I915_OA_FORMAT_A13_B8_C8 () { 3; }") unless defined(&I915_OA_FORMAT_A13_B8_C8);
    eval("sub I915_OA_FORMAT_B4_C8 () { 4; }") unless defined(&I915_OA_FORMAT_B4_C8);
    eval("sub I915_OA_FORMAT_A45_B8_C8 () { 5; }") unless defined(&I915_OA_FORMAT_A45_B8_C8);
    eval("sub I915_OA_FORMAT_B4_C8_A16 () { 6; }") unless defined(&I915_OA_FORMAT_B4_C8_A16);
    eval("sub I915_OA_FORMAT_C4_B8 () { 7; }") unless defined(&I915_OA_FORMAT_C4_B8);
    eval("sub I915_OA_FORMAT_A12 () { 8; }") unless defined(&I915_OA_FORMAT_A12);
    eval("sub I915_OA_FORMAT_A12_B8_C8 () { 9; }") unless defined(&I915_OA_FORMAT_A12_B8_C8);
    eval("sub I915_OA_FORMAT_A32u40_A4u32_B8_C8 () { 10; }") unless defined(&I915_OA_FORMAT_A32u40_A4u32_B8_C8);
    eval("sub I915_OA_FORMAT_MAX () { 11; }") unless defined(&I915_OA_FORMAT_MAX);
    eval("sub DRM_I915_PERF_PROP_CTX_HANDLE () { 1; }") unless defined(&DRM_I915_PERF_PROP_CTX_HANDLE);
    eval("sub DRM_I915_PERF_PROP_SAMPLE_OA () { 2; }") unless defined(&DRM_I915_PERF_PROP_SAMPLE_OA);
    eval("sub DRM_I915_PERF_PROP_OA_METRICS_SET () { 3; }") unless defined(&DRM_I915_PERF_PROP_OA_METRICS_SET);
    eval("sub DRM_I915_PERF_PROP_OA_FORMAT () { 4; }") unless defined(&DRM_I915_PERF_PROP_OA_FORMAT);
    eval("sub DRM_I915_PERF_PROP_OA_EXPONENT () { 5; }") unless defined(&DRM_I915_PERF_PROP_OA_EXPONENT);
    eval("sub DRM_I915_PERF_PROP_HOLD_PREEMPTION () { 6; }") unless defined(&DRM_I915_PERF_PROP_HOLD_PREEMPTION);
    eval("sub DRM_I915_PERF_PROP_GLOBAL_SSEU () { 7; }") unless defined(&DRM_I915_PERF_PROP_GLOBAL_SSEU);
    eval("sub DRM_I915_PERF_PROP_POLL_OA_PERIOD () { 8; }") unless defined(&DRM_I915_PERF_PROP_POLL_OA_PERIOD);
    eval("sub DRM_I915_PERF_PROP_MAX () { 9; }") unless defined(&DRM_I915_PERF_PROP_MAX);
    eval 'sub I915_PERF_FLAG_FD_CLOEXEC () {(1<<0);}' unless defined(&I915_PERF_FLAG_FD_CLOEXEC);
    eval 'sub I915_PERF_FLAG_FD_NONBLOCK () {(1<<1);}' unless defined(&I915_PERF_FLAG_FD_NONBLOCK);
    eval 'sub I915_PERF_FLAG_DISABLED () {(1<<2);}' unless defined(&I915_PERF_FLAG_DISABLED);
    eval 'sub I915_PERF_IOCTL_ENABLE () { &_IO(ord(\'i\'), 0x);}' unless defined(&I915_PERF_IOCTL_ENABLE);
    eval 'sub I915_PERF_IOCTL_DISABLE () { &_IO(ord(\'i\'), 0x1);}' unless defined(&I915_PERF_IOCTL_DISABLE);
    eval 'sub I915_PERF_IOCTL_CONFIG () { &_IO(ord(\'i\'), 0x2);}' unless defined(&I915_PERF_IOCTL_CONFIG);
    eval("sub DRM_I915_PERF_RECORD_SAMPLE () { 1; }") unless defined(&DRM_I915_PERF_RECORD_SAMPLE);
    eval("sub DRM_I915_PERF_RECORD_OA_REPORT_LOST () { 2; }") unless defined(&DRM_I915_PERF_RECORD_OA_REPORT_LOST);
    eval("sub DRM_I915_PERF_RECORD_OA_BUFFER_LOST () { 3; }") unless defined(&DRM_I915_PERF_RECORD_OA_BUFFER_LOST);
    eval("sub DRM_I915_PERF_RECORD_MAX () { 4; }") unless defined(&DRM_I915_PERF_RECORD_MAX);
    eval 'sub DRM_I915_QUERY_TOPOLOGY_INFO () {1;}' unless defined(&DRM_I915_QUERY_TOPOLOGY_INFO);
    eval 'sub DRM_I915_QUERY_ENGINE_INFO () {2;}' unless defined(&DRM_I915_QUERY_ENGINE_INFO);
    eval 'sub DRM_I915_QUERY_PERF_CONFIG () {3;}' unless defined(&DRM_I915_QUERY_PERF_CONFIG);
    eval 'sub DRM_I915_QUERY_MEMORY_REGIONS () {4;}' unless defined(&DRM_I915_QUERY_MEMORY_REGIONS);
    eval 'sub DRM_I915_QUERY_HWCONFIG_BLOB () {5;}' unless defined(&DRM_I915_QUERY_HWCONFIG_BLOB);
    eval 'sub DRM_I915_QUERY_GEOMETRY_SUBSLICES () {6;}' unless defined(&DRM_I915_QUERY_GEOMETRY_SUBSLICES);
    eval 'sub DRM_I915_QUERY_PERF_CONFIG_LIST () {1;}' unless defined(&DRM_I915_QUERY_PERF_CONFIG_LIST);
    eval 'sub DRM_I915_QUERY_PERF_CONFIG_DATA_FOR_UUID () {2;}' unless defined(&DRM_I915_QUERY_PERF_CONFIG_DATA_FOR_UUID);
    eval 'sub DRM_I915_QUERY_PERF_CONFIG_DATA_FOR_ID () {3;}' unless defined(&DRM_I915_QUERY_PERF_CONFIG_DATA_FOR_ID);
    eval 'sub I915_ENGINE_INFO_HAS_LOGICAL_INSTANCE () {(1<< 0);}' unless defined(&I915_ENGINE_INFO_HAS_LOGICAL_INSTANCE);
    eval 'sub I915_VIDEO_CLASS_CAPABILITY_HEVC () {(1<< 0);}' unless defined(&I915_VIDEO_CLASS_CAPABILITY_HEVC);
    eval 'sub I915_VIDEO_AND_ENHANCE_CLASS_CAPABILITY_SFC () {(1<< 1);}' unless defined(&I915_VIDEO_AND_ENHANCE_CLASS_CAPABILITY_SFC);
    eval("sub I915_MEMORY_CLASS_SYSTEM () { 0; }") unless defined(&I915_MEMORY_CLASS_SYSTEM);
    eval("sub I915_MEMORY_CLASS_DEVICE () { 1; }") unless defined(&I915_MEMORY_CLASS_DEVICE);
    eval 'sub I915_GEM_CREATE_EXT_FLAG_NEEDS_CPU_ACCESS () {(1<< 0);}' unless defined(&I915_GEM_CREATE_EXT_FLAG_NEEDS_CPU_ACCESS);
    eval 'sub I915_GEM_CREATE_EXT_MEMORY_REGIONS () {0;}' unless defined(&I915_GEM_CREATE_EXT_MEMORY_REGIONS);
    eval 'sub I915_GEM_CREATE_EXT_PROTECTED_CONTENT () {1;}' unless defined(&I915_GEM_CREATE_EXT_PROTECTED_CONTENT);
    eval 'sub I915_PROTECTED_CONTENT_DEFAULT_SESSION () {0xf;}' unless defined(&I915_PROTECTED_CONTENT_DEFAULT_SESSION);
    if(defined(&__cplusplus)) {
    }
}
1;
