require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_EXT2_FS_H)) {
    eval 'sub _LINUX_EXT2_FS_H () {1;}' unless defined(&_LINUX_EXT2_FS_H);
    require 'ext2fs/ext2_types.ph';
    unless(defined(&__GNUC_PREREQ)) {
	if(defined(&__GNUC__)  && defined(&__GNUC_MINOR__)) {
	    eval 'sub __GNUC_PREREQ {
	        my($maj, $min) = @_;
    		eval q((( &__GNUC__ << 16) +  &__GNUC_MINOR__ >= (($maj) << 16) + ($min)));
	    }' unless defined(&__GNUC_PREREQ);
	} else {
	    eval 'sub __GNUC_PREREQ {
	        my($maj, $min) = @_;
    		eval q(0);
	    }' unless defined(&__GNUC_PREREQ);
	}
    }
    unless(defined(&__nonstring)) {
	if(defined(&__has_attribute)) {
	    if( &__has_attribute((defined(&__nonstring__) ? &__nonstring__ : undef))) {
		eval 'sub __nonstring () { &__attribute__(( &__nonstring__));}' unless defined(&__nonstring);
	    } else {
		eval 'sub __nonstring () {1;}' unless defined(&__nonstring);
	    }
	} else {
	    eval 'sub __nonstring () {1;}' unless defined(&__nonstring);
	}
    }
    undef(&EXT2FS_DEBUG) if defined(&EXT2FS_DEBUG);
    eval 'sub EXT2_PREALLOCATE () {1;}' unless defined(&EXT2_PREALLOCATE);
    eval 'sub EXT2_DEFAULT_PREALLOC_BLOCKS () {8;}' unless defined(&EXT2_DEFAULT_PREALLOC_BLOCKS);
    eval 'sub EXT2FS_DATE () {"95/08/09";}' unless defined(&EXT2FS_DATE);
    eval 'sub EXT2FS_VERSION () {"0.5b";}' unless defined(&EXT2FS_VERSION);
    eval 'sub EXT2_BAD_INO () {1;}' unless defined(&EXT2_BAD_INO);
    eval 'sub EXT2_ROOT_INO () {2;}' unless defined(&EXT2_ROOT_INO);
    eval 'sub EXT4_USR_QUOTA_INO () {3;}' unless defined(&EXT4_USR_QUOTA_INO);
    eval 'sub EXT4_GRP_QUOTA_INO () {4;}' unless defined(&EXT4_GRP_QUOTA_INO);
    eval 'sub EXT2_BOOT_LOADER_INO () {5;}' unless defined(&EXT2_BOOT_LOADER_INO);
    eval 'sub EXT2_UNDEL_DIR_INO () {6;}' unless defined(&EXT2_UNDEL_DIR_INO);
    eval 'sub EXT2_RESIZE_INO () {7;}' unless defined(&EXT2_RESIZE_INO);
    eval 'sub EXT2_JOURNAL_INO () {8;}' unless defined(&EXT2_JOURNAL_INO);
    eval 'sub EXT2_EXCLUDE_INO () {9;}' unless defined(&EXT2_EXCLUDE_INO);
    eval 'sub EXT4_REPLICA_INO () {10;}' unless defined(&EXT4_REPLICA_INO);
    eval 'sub EXT2_GOOD_OLD_FIRST_INO () {11;}' unless defined(&EXT2_GOOD_OLD_FIRST_INO);
    eval 'sub EXT2_SUPER_MAGIC () {0xef53;}' unless defined(&EXT2_SUPER_MAGIC);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT2_SB {
	    my($sb) = @_;
    	    eval q(((($sb)-> ($u->{ext2_sb}))));
	}' unless defined(&EXT2_SB);
    } else {
	eval 'sub EXT2_SB {
	    my($sb) = @_;
    	    eval q(($sb));
	}' unless defined(&EXT2_SB);
    }
    eval 'sub EXT2_LINK_MAX () {65000;}' unless defined(&EXT2_LINK_MAX);
    eval 'sub EXT2_MIN_BLOCK_LOG_SIZE () {10;}' unless defined(&EXT2_MIN_BLOCK_LOG_SIZE);
    eval 'sub EXT2_MAX_BLOCK_LOG_SIZE () {16;}' unless defined(&EXT2_MAX_BLOCK_LOG_SIZE);
    eval 'sub EXT2_MIN_BLOCK_SIZE () {(1<<  &EXT2_MIN_BLOCK_LOG_SIZE);}' unless defined(&EXT2_MIN_BLOCK_SIZE);
    eval 'sub EXT2_MAX_BLOCK_SIZE () {(1<<  &EXT2_MAX_BLOCK_LOG_SIZE);}' unless defined(&EXT2_MAX_BLOCK_SIZE);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT2_BLOCK_SIZE {
	    my($s) = @_;
    	    eval q((($s)-> &s_blocksize));
	}' unless defined(&EXT2_BLOCK_SIZE);
	eval 'sub EXT2_BLOCK_SIZE_BITS {
	    my($s) = @_;
    	    eval q((($s)-> &s_blocksize_bits));
	}' unless defined(&EXT2_BLOCK_SIZE_BITS);
	eval 'sub EXT2_ADDR_PER_BLOCK_BITS {
	    my($s) = @_;
    	    eval q(( &EXT2_SB($s)-> &addr_per_block_bits));
	}' unless defined(&EXT2_ADDR_PER_BLOCK_BITS);
	eval 'sub EXT2_INODE_SIZE {
	    my($s) = @_;
    	    eval q(( &EXT2_SB($s)-> &s_inode_size));
	}' unless defined(&EXT2_INODE_SIZE);
	eval 'sub EXT2_FIRST_INO {
	    my($s) = @_;
    	    eval q(( &EXT2_SB($s)-> &s_first_ino));
	}' unless defined(&EXT2_FIRST_INO);
    } else {
	eval 'sub EXT2_BLOCK_SIZE {
	    my($s) = @_;
    	    eval q(( &EXT2_MIN_BLOCK_SIZE << ($s)-> &s_log_block_size));
	}' unless defined(&EXT2_BLOCK_SIZE);
	eval 'sub EXT2_BLOCK_SIZE_BITS {
	    my($s) = @_;
    	    eval q((($s)-> &s_log_block_size + 10));
	}' unless defined(&EXT2_BLOCK_SIZE_BITS);
	eval 'sub EXT2_INODE_SIZE {
	    my($s) = @_;
    	    eval q(((($s)-> &s_rev_level ==  &EXT2_GOOD_OLD_REV) ?  &EXT2_GOOD_OLD_INODE_SIZE : ($s)-> &s_inode_size));
	}' unless defined(&EXT2_INODE_SIZE);
	eval 'sub EXT2_FIRST_INO {
	    my($s) = @_;
    	    eval q(((($s)-> &s_rev_level ==  &EXT2_GOOD_OLD_REV) ?  &EXT2_GOOD_OLD_FIRST_INO : ($s)-> &s_first_ino));
	}' unless defined(&EXT2_FIRST_INO);
    }
    eval 'sub EXT2_ADDR_PER_BLOCK {
        my($s) = @_;
	    eval q(( &EXT2_BLOCK_SIZE($s) / $sizeof{ &__u32}));
    }' unless defined(&EXT2_ADDR_PER_BLOCK);
    eval 'sub EXT2_MIN_CLUSTER_LOG_SIZE () { &EXT2_MIN_BLOCK_LOG_SIZE;}' unless defined(&EXT2_MIN_CLUSTER_LOG_SIZE);
    eval 'sub EXT2_MAX_CLUSTER_LOG_SIZE () {29;}' unless defined(&EXT2_MAX_CLUSTER_LOG_SIZE);
    eval 'sub EXT2_MIN_CLUSTER_SIZE () { &EXT2_MIN_BLOCK_SIZE;}' unless defined(&EXT2_MIN_CLUSTER_SIZE);
    eval 'sub EXT2_MAX_CLUSTER_SIZE () {(1<<  &EXT2_MAX_CLUSTER_LOG_SIZE);}' unless defined(&EXT2_MAX_CLUSTER_SIZE);
    eval 'sub EXT2_CLUSTER_SIZE {
        my($s) = @_;
	    eval q(( &EXT2_MIN_BLOCK_SIZE << ($s)-> &s_log_cluster_size));
    }' unless defined(&EXT2_CLUSTER_SIZE);
    eval 'sub EXT2_CLUSTER_SIZE_BITS {
        my($s) = @_;
	    eval q((($s)-> &s_log_cluster_size + 10));
    }' unless defined(&EXT2_CLUSTER_SIZE_BITS);
    eval 'sub EXT2_MIN_FRAG_SIZE () { &EXT2_MIN_BLOCK_SIZE;}' unless defined(&EXT2_MIN_FRAG_SIZE);
    eval 'sub EXT2_MAX_FRAG_SIZE () { &EXT2_MAX_BLOCK_SIZE;}' unless defined(&EXT2_MAX_FRAG_SIZE);
    eval 'sub EXT2_MIN_FRAG_LOG_SIZE () { &EXT2_MIN_BLOCK_LOG_SIZE;}' unless defined(&EXT2_MIN_FRAG_LOG_SIZE);
    eval 'sub EXT2_FRAG_SIZE {
        my($s) = @_;
	    eval q( &EXT2_BLOCK_SIZE($s));
    }' unless defined(&EXT2_FRAG_SIZE);
    eval 'sub EXT2_FRAGS_PER_BLOCK {
        my($s) = @_;
	    eval q(1);
    }' unless defined(&EXT2_FRAGS_PER_BLOCK);
    eval 'sub EXT4_BG_INODE_BITMAP_CSUM_HI_END () {( &offsetof(\'struct ext4_group_desc\',  &bg_inode_bitmap_csum_hi) + $sizeof{ &__u16});}' unless defined(&EXT4_BG_INODE_BITMAP_CSUM_HI_END);
    eval 'sub EXT4_BG_BLOCK_BITMAP_CSUM_HI_LOCATION () {( &offsetof(\'struct ext4_group_desc\',  &bg_block_bitmap_csum_hi) + $sizeof{ &__u16});}' unless defined(&EXT4_BG_BLOCK_BITMAP_CSUM_HI_LOCATION);
    eval 'sub EXT2_BG_INODE_UNINIT () {0x1;}' unless defined(&EXT2_BG_INODE_UNINIT);
    eval 'sub EXT2_BG_BLOCK_UNINIT () {0x2;}' unless defined(&EXT2_BG_BLOCK_UNINIT);
    eval 'sub EXT2_BG_INODE_ZEROED () {0x4;}' unless defined(&EXT2_BG_INODE_ZEROED);
    eval 'sub EXT2_HASH_LEGACY () {0;}' unless defined(&EXT2_HASH_LEGACY);
    eval 'sub EXT2_HASH_HALF_MD4 () {1;}' unless defined(&EXT2_HASH_HALF_MD4);
    eval 'sub EXT2_HASH_TEA () {2;}' unless defined(&EXT2_HASH_TEA);
    eval 'sub EXT2_HASH_LEGACY_UNSIGNED () {3;}' unless defined(&EXT2_HASH_LEGACY_UNSIGNED);
    eval 'sub EXT2_HASH_HALF_MD4_UNSIGNED () {4;}' unless defined(&EXT2_HASH_HALF_MD4_UNSIGNED);
    eval 'sub EXT2_HASH_TEA_UNSIGNED () {5;}' unless defined(&EXT2_HASH_TEA_UNSIGNED);
    eval 'sub EXT2_HASH_SIPHASH () {6;}' unless defined(&EXT2_HASH_SIPHASH);
    eval 'sub EXT2_HASH_FLAG_INCOMPAT () {0x1;}' unless defined(&EXT2_HASH_FLAG_INCOMPAT);
    eval 'sub EXT4_DX_BLOCK_MASK () {0xfffffff;}' unless defined(&EXT4_DX_BLOCK_MASK);
    eval 'sub EXT2_MIN_DESC_SIZE () {32;}' unless defined(&EXT2_MIN_DESC_SIZE);
    eval 'sub EXT2_MIN_DESC_SIZE_64BIT () {64;}' unless defined(&EXT2_MIN_DESC_SIZE_64BIT);
    eval 'sub EXT2_MAX_DESC_SIZE () { &EXT2_MIN_BLOCK_SIZE;}' unless defined(&EXT2_MAX_DESC_SIZE);
    eval 'sub EXT2_DESC_SIZE {
        my($s) = @_;
	    eval q(( &ext2fs_has_feature_64bit($s) ? ($s)-> &s_desc_size :  &EXT2_MIN_DESC_SIZE));
    }' unless defined(&EXT2_DESC_SIZE);
    eval 'sub EXT2_BLOCKS_PER_GROUP {
        my($s) = @_;
	    eval q(( &EXT2_SB($s)-> &s_blocks_per_group));
    }' unless defined(&EXT2_BLOCKS_PER_GROUP);
    eval 'sub EXT2_INODES_PER_GROUP {
        my($s) = @_;
	    eval q(( &EXT2_SB($s)-> &s_inodes_per_group));
    }' unless defined(&EXT2_INODES_PER_GROUP);
    eval 'sub EXT2_CLUSTERS_PER_GROUP {
        my($s) = @_;
	    eval q(( &EXT2_SB($s)-> &s_clusters_per_group));
    }' unless defined(&EXT2_CLUSTERS_PER_GROUP);
    eval 'sub EXT2_INODES_PER_BLOCK {
        my($s) = @_;
	    eval q(( &EXT2_BLOCK_SIZE($s)/ &EXT2_INODE_SIZE($s)));
    }' unless defined(&EXT2_INODES_PER_BLOCK);
    eval 'sub EXT2_MAX_BLOCKS_PER_GROUP {
        my($s) = @_;
	    eval q(((( 1<< 16) - 8) * ( &EXT2_CLUSTER_SIZE($s) /  &EXT2_BLOCK_SIZE($s))));
    }' unless defined(&EXT2_MAX_BLOCKS_PER_GROUP);
    eval 'sub EXT2_MAX_CLUSTERS_PER_GROUP {
        my($s) = @_;
	    eval q((( 1<< 16) - 8));
    }' unless defined(&EXT2_MAX_CLUSTERS_PER_GROUP);
    eval 'sub EXT2_MAX_INODES_PER_GROUP {
        my($s) = @_;
	    eval q((( 1<< 16) -  &EXT2_INODES_PER_BLOCK($s)));
    }' unless defined(&EXT2_MAX_INODES_PER_GROUP);
    if(defined(&__KERNEL__)) {
	eval 'sub EXT2_DESC_PER_BLOCK {
	    my($s) = @_;
    	    eval q(( &EXT2_SB($s)-> &s_desc_per_block));
	}' unless defined(&EXT2_DESC_PER_BLOCK);
	eval 'sub EXT2_DESC_PER_BLOCK_BITS {
	    my($s) = @_;
    	    eval q(( &EXT2_SB($s)-> &s_desc_per_block_bits));
	}' unless defined(&EXT2_DESC_PER_BLOCK_BITS);
    } else {
	eval 'sub EXT2_DESC_PER_BLOCK {
	    my($s) = @_;
    	    eval q(( &EXT2_BLOCK_SIZE($s) /  &EXT2_DESC_SIZE($s)));
	}' unless defined(&EXT2_DESC_PER_BLOCK);
    }
    eval 'sub EXT2_GROUPS_TO_BLOCKS {
        my($s, $g) = @_;
	    eval q((( &blk64_t)  &EXT2_BLOCKS_PER_GROUP($s) * ($g)));
    }' unless defined(&EXT2_GROUPS_TO_BLOCKS);
    eval 'sub EXT2_GROUPS_TO_CLUSTERS {
        my($s, $g) = @_;
	    eval q((( &blk64_t)  &EXT2_CLUSTERS_PER_GROUP($s) * ($g)));
    }' unless defined(&EXT2_GROUPS_TO_CLUSTERS);
    eval 'sub EXT2_NDIR_BLOCKS () {12;}' unless defined(&EXT2_NDIR_BLOCKS);
    eval 'sub EXT2_IND_BLOCK () { &EXT2_NDIR_BLOCKS;}' unless defined(&EXT2_IND_BLOCK);
    eval 'sub EXT2_DIND_BLOCK () {( &EXT2_IND_BLOCK + 1);}' unless defined(&EXT2_DIND_BLOCK);
    eval 'sub EXT2_TIND_BLOCK () {( &EXT2_DIND_BLOCK + 1);}' unless defined(&EXT2_TIND_BLOCK);
    eval 'sub EXT2_N_BLOCKS () {( &EXT2_TIND_BLOCK + 1);}' unless defined(&EXT2_N_BLOCKS);
    eval 'sub EXT2_SECRM_FL () {0x1;}' unless defined(&EXT2_SECRM_FL);
    eval 'sub EXT2_UNRM_FL () {0x2;}' unless defined(&EXT2_UNRM_FL);
    eval 'sub EXT2_COMPR_FL () {0x4;}' unless defined(&EXT2_COMPR_FL);
    eval 'sub EXT2_SYNC_FL () {0x8;}' unless defined(&EXT2_SYNC_FL);
    eval 'sub EXT2_IMMUTABLE_FL () {0x10;}' unless defined(&EXT2_IMMUTABLE_FL);
    eval 'sub EXT2_APPEND_FL () {0x20;}' unless defined(&EXT2_APPEND_FL);
    eval 'sub EXT2_NODUMP_FL () {0x40;}' unless defined(&EXT2_NODUMP_FL);
    eval 'sub EXT2_NOATIME_FL () {0x80;}' unless defined(&EXT2_NOATIME_FL);
    eval 'sub EXT2_DIRTY_FL () {0x100;}' unless defined(&EXT2_DIRTY_FL);
    eval 'sub EXT2_COMPRBLK_FL () {0x200;}' unless defined(&EXT2_COMPRBLK_FL);
    eval 'sub EXT2_NOCOMPR_FL () {0x400;}' unless defined(&EXT2_NOCOMPR_FL);
    eval 'sub EXT4_ENCRYPT_FL () {0x800;}' unless defined(&EXT4_ENCRYPT_FL);
    eval 'sub EXT2_BTREE_FL () {0x1000;}' unless defined(&EXT2_BTREE_FL);
    eval 'sub EXT2_INDEX_FL () {0x1000;}' unless defined(&EXT2_INDEX_FL);
    eval 'sub EXT2_IMAGIC_FL () {0x2000;}' unless defined(&EXT2_IMAGIC_FL);
    eval 'sub EXT3_JOURNAL_DATA_FL () {0x4000;}' unless defined(&EXT3_JOURNAL_DATA_FL);
    eval 'sub EXT2_NOTAIL_FL () {0x8000;}' unless defined(&EXT2_NOTAIL_FL);
    eval 'sub EXT2_DIRSYNC_FL () {0x10000;}' unless defined(&EXT2_DIRSYNC_FL);
    eval 'sub EXT2_TOPDIR_FL () {0x20000;}' unless defined(&EXT2_TOPDIR_FL);
    eval 'sub EXT4_HUGE_FILE_FL () {0x40000;}' unless defined(&EXT4_HUGE_FILE_FL);
    eval 'sub EXT4_EXTENTS_FL () {0x80000;}' unless defined(&EXT4_EXTENTS_FL);
    eval 'sub EXT4_VERITY_FL () {0x100000;}' unless defined(&EXT4_VERITY_FL);
    eval 'sub EXT4_EA_INODE_FL () {0x200000;}' unless defined(&EXT4_EA_INODE_FL);
    eval 'sub FS_NOCOW_FL () {0x800000;}' unless defined(&FS_NOCOW_FL);
    eval 'sub EXT4_SNAPFILE_FL () {0x1000000;}' unless defined(&EXT4_SNAPFILE_FL);
    eval 'sub FS_DAX_FL () {0x2000000;}' unless defined(&FS_DAX_FL);
    eval 'sub EXT4_SNAPFILE_DELETED_FL () {0x4000000;}' unless defined(&EXT4_SNAPFILE_DELETED_FL);
    eval 'sub EXT4_SNAPFILE_SHRUNK_FL () {0x8000000;}' unless defined(&EXT4_SNAPFILE_SHRUNK_FL);
    eval 'sub EXT4_INLINE_DATA_FL () {0x10000000;}' unless defined(&EXT4_INLINE_DATA_FL);
    eval 'sub EXT4_PROJINHERIT_FL () {0x20000000;}' unless defined(&EXT4_PROJINHERIT_FL);
    eval 'sub EXT4_CASEFOLD_FL () {0x40000000;}' unless defined(&EXT4_CASEFOLD_FL);
    eval 'sub EXT2_RESERVED_FL () {0x80000000;}' unless defined(&EXT2_RESERVED_FL);
    eval 'sub EXT2_FL_USER_VISIBLE () {0x604bdfff;}' unless defined(&EXT2_FL_USER_VISIBLE);
    eval 'sub EXT2_FL_USER_MODIFIABLE () {0x604b80ff;}' unless defined(&EXT2_FL_USER_MODIFIABLE);
    if(defined(&__GNU__)) {
	eval 'sub _IOT_ext2_new_group_input () { &_IOT ( &_IOTS( &__u32), 5,  &_IOTS( &__u16), 2, 0, 0);}' unless defined(&_IOT_ext2_new_group_input);
    }
    eval 'sub EXT2_IOC_GETFLAGS () { &_IOR(ord(\'f\'), 1, \'long\');}' unless defined(&EXT2_IOC_GETFLAGS);
    eval 'sub EXT2_IOC_SETFLAGS () { &_IOW(ord(\'f\'), 2, \'long\');}' unless defined(&EXT2_IOC_SETFLAGS);
    eval 'sub EXT2_IOC_GETVERSION () { &_IOR(ord(\'v\'), 1, \'long\');}' unless defined(&EXT2_IOC_GETVERSION);
    eval 'sub EXT2_IOC_SETVERSION () { &_IOW(ord(\'v\'), 2, \'long\');}' unless defined(&EXT2_IOC_SETVERSION);
    eval 'sub EXT2_IOC_GETVERSION_NEW () { &_IOR(ord(\'f\'), 3, \'long\');}' unless defined(&EXT2_IOC_GETVERSION_NEW);
    eval 'sub EXT2_IOC_SETVERSION_NEW () { &_IOW(ord(\'f\'), 4, \'long\');}' unless defined(&EXT2_IOC_SETVERSION_NEW);
    eval 'sub EXT2_IOC_GROUP_EXTEND () { &_IOW(ord(\'f\'), 7, \'unsigned long\');}' unless defined(&EXT2_IOC_GROUP_EXTEND);
    eval 'sub EXT2_IOC_GROUP_ADD () { &_IOW(ord(\'f\'), 8,\'struct ext2_new_group_input\');}' unless defined(&EXT2_IOC_GROUP_ADD);
    eval 'sub EXT4_IOC_GROUP_ADD () { &_IOW(ord(\'f\'), 8,\'struct ext4_new_group_input\');}' unless defined(&EXT4_IOC_GROUP_ADD);
    eval 'sub EXT4_IOC_RESIZE_FS () { &_IOW(ord(\'f\'), 16,  &__u64);}' unless defined(&EXT4_IOC_RESIZE_FS);
    eval 'sub EXT4_INODE_CSUM_HI_EXTRA_END () {( &offsetof(\'struct ext2_inode_large\',  &i_checksum_hi) + $sizeof{ &__u16} -  &EXT2_GOOD_OLD_INODE_SIZE);}' unless defined(&EXT4_INODE_CSUM_HI_EXTRA_END);
    eval 'sub EXT4_EPOCH_BITS () {2;}' unless defined(&EXT4_EPOCH_BITS);
    eval 'sub EXT4_EPOCH_MASK () {((1<<  &EXT4_EPOCH_BITS) - 1);}' unless defined(&EXT4_EPOCH_MASK);
    eval 'sub i_checksum_lo () { ($osd2->{linux2}->{l_i_checksum_lo});}' unless defined(&i_checksum_lo);
    eval 'sub inode_includes {
        my($size, $field) = @_;
	    eval q(($size >= ($sizeof{(0)->$field} +  &offsetof(\'struct ext2_inode_large\', $field))));
    }' unless defined(&inode_includes);
    if(defined(&__KERNEL__) || defined(&__linux__)) {
	eval 'sub i_reserved1 () { ($osd1->{linux1}->{l_i_reserved1});}' unless defined(&i_reserved1);
	eval 'sub i_frag () { ($osd2->{linux2}->{l_i_frag});}' unless defined(&i_frag);
	eval 'sub i_fsize () { ($osd2->{linux2}->{l_i_fsize});}' unless defined(&i_fsize);
	eval 'sub i_uid_low () { &i_uid;}' unless defined(&i_uid_low);
	eval 'sub i_gid_low () { &i_gid;}' unless defined(&i_gid_low);
	eval 'sub i_uid_high () { ($osd2->{linux2}->{l_i_uid_high});}' unless defined(&i_uid_high);
	eval 'sub i_gid_high () { ($osd2->{linux2}->{l_i_gid_high});}' unless defined(&i_gid_high);
    } else {
	if(defined(&__GNU__)) {
	    eval 'sub i_translator () { ($osd1->{hurd1}->{h_i_translator});}' unless defined(&i_translator);
	    eval 'sub i_frag () { ($osd2->{hurd2}->{h_i_frag});;}' unless defined(&i_frag);
	    eval 'sub i_fsize () { ($osd2->{hurd2}->{h_i_fsize});;}' unless defined(&i_fsize);
	    eval 'sub i_uid_high () { ($osd2->{hurd2}->{h_i_uid_high});}' unless defined(&i_uid_high);
	    eval 'sub i_gid_high () { ($osd2->{hurd2}->{h_i_gid_high});}' unless defined(&i_gid_high);
	    eval 'sub i_author () { ($osd2->{hurd2}->{h_i_author});}' unless defined(&i_author);
	}
    }
    eval 'sub inode_uid {
        my($inode) = @_;
	    eval q((. &i_uid | ($inode). ($osd2->{linux2}->{l_i_uid_high}) << 16));
    }' unless defined(&inode_uid);
    eval 'sub inode_gid {
        my($inode) = @_;
	    eval q((. &i_gid | ($inode). ($osd2->{linux2}->{l_i_gid_high}) << 16));
    }' unless defined(&inode_gid);
    eval 'sub inode_projid {
        my($inode) = @_;
	    eval q((($inode). &i_projid));
    }' unless defined(&inode_projid);
    eval 'sub ext2fs_set_i_uid_high {
        my($inode,$x) = @_;
	    eval q((($inode). ($osd2->{linux2}->{l_i_uid_high}) = ($x)));
    }' unless defined(&ext2fs_set_i_uid_high);
    eval 'sub ext2fs_set_i_gid_high {
        my($inode,$x) = @_;
	    eval q((($inode). ($osd2->{linux2}->{l_i_gid_high}) = ($x)));
    }' unless defined(&ext2fs_set_i_gid_high);
    eval 'sub EXT2_VALID_FS () {0x1;}' unless defined(&EXT2_VALID_FS);
    eval 'sub EXT2_ERROR_FS () {0x2;}' unless defined(&EXT2_ERROR_FS);
    eval 'sub EXT3_ORPHAN_FS () {0x4;}' unless defined(&EXT3_ORPHAN_FS);
    eval 'sub EXT4_FC_REPLAY () {0x20;}' unless defined(&EXT4_FC_REPLAY);
    eval 'sub EXT2_FLAGS_SIGNED_HASH () {0x1;}' unless defined(&EXT2_FLAGS_SIGNED_HASH);
    eval 'sub EXT2_FLAGS_UNSIGNED_HASH () {0x2;}' unless defined(&EXT2_FLAGS_UNSIGNED_HASH);
    eval 'sub EXT2_FLAGS_TEST_FILESYS () {0x4;}' unless defined(&EXT2_FLAGS_TEST_FILESYS);
    eval 'sub EXT2_FLAGS_IS_SNAPSHOT () {0x10;}' unless defined(&EXT2_FLAGS_IS_SNAPSHOT);
    eval 'sub EXT2_FLAGS_FIX_SNAPSHOT () {0x20;}' unless defined(&EXT2_FLAGS_FIX_SNAPSHOT);
    eval 'sub EXT2_FLAGS_FIX_EXCLUDE () {0x40;}' unless defined(&EXT2_FLAGS_FIX_EXCLUDE);
    eval 'sub EXT2_MOUNT_CHECK () {0x1;}' unless defined(&EXT2_MOUNT_CHECK);
    eval 'sub EXT2_MOUNT_GRPID () {0x4;}' unless defined(&EXT2_MOUNT_GRPID);
    eval 'sub EXT2_MOUNT_DEBUG () {0x8;}' unless defined(&EXT2_MOUNT_DEBUG);
    eval 'sub EXT2_MOUNT_ERRORS_CONT () {0x10;}' unless defined(&EXT2_MOUNT_ERRORS_CONT);
    eval 'sub EXT2_MOUNT_ERRORS_RO () {0x20;}' unless defined(&EXT2_MOUNT_ERRORS_RO);
    eval 'sub EXT2_MOUNT_ERRORS_PANIC () {0x40;}' unless defined(&EXT2_MOUNT_ERRORS_PANIC);
    eval 'sub EXT2_MOUNT_MINIX_DF () {0x80;}' unless defined(&EXT2_MOUNT_MINIX_DF);
    eval 'sub EXT2_MOUNT_NO_UID32 () {0x200;}' unless defined(&EXT2_MOUNT_NO_UID32);
    eval 'sub clear_opt {
        my($o, $opt) = @_;
	    eval q($o &= ~ &EXT2_MOUNT_$opt);
    }' unless defined(&clear_opt);
    eval 'sub set_opt {
        my($o, $opt) = @_;
	    eval q($o |=  &EXT2_MOUNT_$opt);
    }' unless defined(&set_opt);
    eval 'sub test_opt {
        my($sb, $opt) = @_;
	    eval q(( &EXT2_SB($sb)-> &s_mount_opt &  &EXT2_MOUNT_$opt));
    }' unless defined(&test_opt);
    eval 'sub EXT2_DFL_MAX_MNT_COUNT () {20;}' unless defined(&EXT2_DFL_MAX_MNT_COUNT);
    eval 'sub EXT2_DFL_CHECKINTERVAL () {0;}' unless defined(&EXT2_DFL_CHECKINTERVAL);
    eval 'sub EXT2_ERRORS_CONTINUE () {1;}' unless defined(&EXT2_ERRORS_CONTINUE);
    eval 'sub EXT2_ERRORS_RO () {2;}' unless defined(&EXT2_ERRORS_RO);
    eval 'sub EXT2_ERRORS_PANIC () {3;}' unless defined(&EXT2_ERRORS_PANIC);
    eval 'sub EXT2_ERRORS_DEFAULT () { &EXT2_ERRORS_CONTINUE;}' unless defined(&EXT2_ERRORS_DEFAULT);
    if(((defined(&__GNUC__) ? &__GNUC__ : undef) >= 4)) {
	eval 'sub ext4_offsetof {
	    my($TYPE,$MEMBER) = @_;
    	    eval q( &__builtin_offsetof($TYPE,$MEMBER));
	}' unless defined(&ext4_offsetof);
    } else {
	eval 'sub ext4_offsetof {
	    my($TYPE, $MEMBER) = @_;
    	    eval q(( (($TYPE *)0)->$MEMBER));
	}' unless defined(&ext4_offsetof);
    }
    eval 'sub EXT2_CRC32C_CHKSUM () {1;}' unless defined(&EXT2_CRC32C_CHKSUM);
    eval 'sub EXT4_ENCRYPTION_MODE_INVALID () {0;}' unless defined(&EXT4_ENCRYPTION_MODE_INVALID);
    eval 'sub EXT4_ENCRYPTION_MODE_AES_256_XTS () {1;}' unless defined(&EXT4_ENCRYPTION_MODE_AES_256_XTS);
    eval 'sub EXT4_ENCRYPTION_MODE_AES_256_GCM () {2;}' unless defined(&EXT4_ENCRYPTION_MODE_AES_256_GCM);
    eval 'sub EXT4_ENCRYPTION_MODE_AES_256_CBC () {3;}' unless defined(&EXT4_ENCRYPTION_MODE_AES_256_CBC);
    eval 'sub EXT4_ENCRYPTION_MODE_AES_256_CTS () {4;}' unless defined(&EXT4_ENCRYPTION_MODE_AES_256_CTS);
    eval 'sub EXT4_AES_256_XTS_KEY_SIZE () {64;}' unless defined(&EXT4_AES_256_XTS_KEY_SIZE);
    eval 'sub EXT4_AES_256_GCM_KEY_SIZE () {32;}' unless defined(&EXT4_AES_256_GCM_KEY_SIZE);
    eval 'sub EXT4_AES_256_CBC_KEY_SIZE () {32;}' unless defined(&EXT4_AES_256_CBC_KEY_SIZE);
    eval 'sub EXT4_AES_256_CTS_KEY_SIZE () {32;}' unless defined(&EXT4_AES_256_CTS_KEY_SIZE);
    eval 'sub EXT4_MAX_KEY_SIZE () {64;}' unless defined(&EXT4_MAX_KEY_SIZE);
    eval 'sub EXT4_KEY_DESCRIPTOR_SIZE () {8;}' unless defined(&EXT4_KEY_DESCRIPTOR_SIZE);
    eval 'sub EXT4_CRYPTO_BLOCK_SIZE () {16;}' unless defined(&EXT4_CRYPTO_BLOCK_SIZE);
    eval 'sub EXT4_MAX_PASSPHRASE_SIZE () {1024;}' unless defined(&EXT4_MAX_PASSPHRASE_SIZE);
    eval 'sub EXT4_MAX_SALT_SIZE () {256;}' unless defined(&EXT4_MAX_SALT_SIZE);
    eval 'sub EXT4_PBKDF2_ITERATIONS () {0xffff;}' unless defined(&EXT4_PBKDF2_ITERATIONS);
    eval 'sub EXT2_LABEL_LEN () {16;}' unless defined(&EXT2_LABEL_LEN);
    eval 'sub EXT4_S_ERR_START () { &ext4_offsetof(\'struct ext2_super_block\',  &s_error_count);}' unless defined(&EXT4_S_ERR_START);
    eval 'sub EXT4_S_ERR_END () { &ext4_offsetof(\'struct ext2_super_block\',  &s_mount_opts);}' unless defined(&EXT4_S_ERR_END);
    eval 'sub EXT4_S_ERR_LEN () {( &EXT4_S_ERR_END -  &EXT4_S_ERR_START);}' unless defined(&EXT4_S_ERR_LEN);
    eval 'sub EXT2_LEN_STR {
        my($buf) = @_;
	    eval q($sizeof{$buf}, $buf);
    }' unless defined(&EXT2_LEN_STR);
    eval 'sub EXT2_OS_LINUX () {0;}' unless defined(&EXT2_OS_LINUX);
    eval 'sub EXT2_OS_HURD () {1;}' unless defined(&EXT2_OS_HURD);
    eval 'sub EXT2_OBSO_OS_MASIX () {2;}' unless defined(&EXT2_OBSO_OS_MASIX);
    eval 'sub EXT2_OS_FREEBSD () {3;}' unless defined(&EXT2_OS_FREEBSD);
    eval 'sub EXT2_OS_LITES () {4;}' unless defined(&EXT2_OS_LITES);
    eval 'sub EXT2_GOOD_OLD_REV () {0;}' unless defined(&EXT2_GOOD_OLD_REV);
    eval 'sub EXT2_DYNAMIC_REV () {1;}' unless defined(&EXT2_DYNAMIC_REV);
    eval 'sub EXT2_CURRENT_REV () { &EXT2_GOOD_OLD_REV;}' unless defined(&EXT2_CURRENT_REV);
    eval 'sub EXT2_MAX_SUPP_REV () { &EXT2_DYNAMIC_REV;}' unless defined(&EXT2_MAX_SUPP_REV);
    eval 'sub EXT2_GOOD_OLD_INODE_SIZE () {128;}' unless defined(&EXT2_GOOD_OLD_INODE_SIZE);
    eval 'sub EXT3_JNL_BACKUP_BLOCKS () {1;}' unless defined(&EXT3_JNL_BACKUP_BLOCKS);
    eval 'sub EXT2_HAS_COMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q((  &EXT2_SB($sb)-> &s_feature_compat & ($mask) ));
    }' unless defined(&EXT2_HAS_COMPAT_FEATURE);
    eval 'sub EXT2_HAS_RO_COMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q((  &EXT2_SB($sb)-> &s_feature_ro_compat & ($mask) ));
    }' unless defined(&EXT2_HAS_RO_COMPAT_FEATURE);
    eval 'sub EXT2_HAS_INCOMPAT_FEATURE {
        my($sb,$mask) = @_;
	    eval q((  &EXT2_SB($sb)-> &s_feature_incompat & ($mask) ));
    }' unless defined(&EXT2_HAS_INCOMPAT_FEATURE);
    eval 'sub EXT2_FEATURE_COMPAT_DIR_PREALLOC () {0x1;}' unless defined(&EXT2_FEATURE_COMPAT_DIR_PREALLOC);
    eval 'sub EXT2_FEATURE_COMPAT_IMAGIC_INODES () {0x2;}' unless defined(&EXT2_FEATURE_COMPAT_IMAGIC_INODES);
    eval 'sub EXT3_FEATURE_COMPAT_HAS_JOURNAL () {0x4;}' unless defined(&EXT3_FEATURE_COMPAT_HAS_JOURNAL);
    eval 'sub EXT2_FEATURE_COMPAT_EXT_ATTR () {0x8;}' unless defined(&EXT2_FEATURE_COMPAT_EXT_ATTR);
    eval 'sub EXT2_FEATURE_COMPAT_RESIZE_INODE () {0x10;}' unless defined(&EXT2_FEATURE_COMPAT_RESIZE_INODE);
    eval 'sub EXT2_FEATURE_COMPAT_DIR_INDEX () {0x20;}' unless defined(&EXT2_FEATURE_COMPAT_DIR_INDEX);
    eval 'sub EXT2_FEATURE_COMPAT_LAZY_BG () {0x40;}' unless defined(&EXT2_FEATURE_COMPAT_LAZY_BG);
    eval 'sub EXT2_FEATURE_COMPAT_EXCLUDE_BITMAP () {0x100;}' unless defined(&EXT2_FEATURE_COMPAT_EXCLUDE_BITMAP);
    eval 'sub EXT4_FEATURE_COMPAT_SPARSE_SUPER2 () {0x200;}' unless defined(&EXT4_FEATURE_COMPAT_SPARSE_SUPER2);
    eval 'sub EXT4_FEATURE_COMPAT_FAST_COMMIT () {0x400;}' unless defined(&EXT4_FEATURE_COMPAT_FAST_COMMIT);
    eval 'sub EXT4_FEATURE_COMPAT_STABLE_INODES () {0x800;}' unless defined(&EXT4_FEATURE_COMPAT_STABLE_INODES);
    eval 'sub EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER () {0x1;}' unless defined(&EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER);
    eval 'sub EXT2_FEATURE_RO_COMPAT_LARGE_FILE () {0x2;}' unless defined(&EXT2_FEATURE_RO_COMPAT_LARGE_FILE);
    eval 'sub EXT4_FEATURE_RO_COMPAT_HUGE_FILE () {0x8;}' unless defined(&EXT4_FEATURE_RO_COMPAT_HUGE_FILE);
    eval 'sub EXT4_FEATURE_RO_COMPAT_GDT_CSUM () {0x10;}' unless defined(&EXT4_FEATURE_RO_COMPAT_GDT_CSUM);
    eval 'sub EXT4_FEATURE_RO_COMPAT_DIR_NLINK () {0x20;}' unless defined(&EXT4_FEATURE_RO_COMPAT_DIR_NLINK);
    eval 'sub EXT4_FEATURE_RO_COMPAT_EXTRA_ISIZE () {0x40;}' unless defined(&EXT4_FEATURE_RO_COMPAT_EXTRA_ISIZE);
    eval 'sub EXT4_FEATURE_RO_COMPAT_HAS_SNAPSHOT () {0x80;}' unless defined(&EXT4_FEATURE_RO_COMPAT_HAS_SNAPSHOT);
    eval 'sub EXT4_FEATURE_RO_COMPAT_QUOTA () {0x100;}' unless defined(&EXT4_FEATURE_RO_COMPAT_QUOTA);
    eval 'sub EXT4_FEATURE_RO_COMPAT_BIGALLOC () {0x200;}' unless defined(&EXT4_FEATURE_RO_COMPAT_BIGALLOC);
    eval 'sub EXT4_FEATURE_RO_COMPAT_METADATA_CSUM () {0x400;}' unless defined(&EXT4_FEATURE_RO_COMPAT_METADATA_CSUM);
    eval 'sub EXT4_FEATURE_RO_COMPAT_REPLICA () {0x800;}' unless defined(&EXT4_FEATURE_RO_COMPAT_REPLICA);
    eval 'sub EXT4_FEATURE_RO_COMPAT_READONLY () {0x1000;}' unless defined(&EXT4_FEATURE_RO_COMPAT_READONLY);
    eval 'sub EXT4_FEATURE_RO_COMPAT_PROJECT () {0x2000;}' unless defined(&EXT4_FEATURE_RO_COMPAT_PROJECT);
    eval 'sub EXT4_FEATURE_RO_COMPAT_SHARED_BLOCKS () {0x4000;}' unless defined(&EXT4_FEATURE_RO_COMPAT_SHARED_BLOCKS);
    eval 'sub EXT4_FEATURE_RO_COMPAT_VERITY () {0x8000;}' unless defined(&EXT4_FEATURE_RO_COMPAT_VERITY);
    eval 'sub EXT2_FEATURE_INCOMPAT_COMPRESSION () {0x1;}' unless defined(&EXT2_FEATURE_INCOMPAT_COMPRESSION);
    eval 'sub EXT2_FEATURE_INCOMPAT_FILETYPE () {0x2;}' unless defined(&EXT2_FEATURE_INCOMPAT_FILETYPE);
    eval 'sub EXT3_FEATURE_INCOMPAT_RECOVER () {0x4;}' unless defined(&EXT3_FEATURE_INCOMPAT_RECOVER);
    eval 'sub EXT3_FEATURE_INCOMPAT_JOURNAL_DEV () {0x8;}' unless defined(&EXT3_FEATURE_INCOMPAT_JOURNAL_DEV);
    eval 'sub EXT2_FEATURE_INCOMPAT_META_BG () {0x10;}' unless defined(&EXT2_FEATURE_INCOMPAT_META_BG);
    eval 'sub EXT3_FEATURE_INCOMPAT_EXTENTS () {0x40;}' unless defined(&EXT3_FEATURE_INCOMPAT_EXTENTS);
    eval 'sub EXT4_FEATURE_INCOMPAT_64BIT () {0x80;}' unless defined(&EXT4_FEATURE_INCOMPAT_64BIT);
    eval 'sub EXT4_FEATURE_INCOMPAT_MMP () {0x100;}' unless defined(&EXT4_FEATURE_INCOMPAT_MMP);
    eval 'sub EXT4_FEATURE_INCOMPAT_FLEX_BG () {0x200;}' unless defined(&EXT4_FEATURE_INCOMPAT_FLEX_BG);
    eval 'sub EXT4_FEATURE_INCOMPAT_EA_INODE () {0x400;}' unless defined(&EXT4_FEATURE_INCOMPAT_EA_INODE);
    eval 'sub EXT4_FEATURE_INCOMPAT_DIRDATA () {0x1000;}' unless defined(&EXT4_FEATURE_INCOMPAT_DIRDATA);
    eval 'sub EXT4_FEATURE_INCOMPAT_CSUM_SEED () {0x2000;}' unless defined(&EXT4_FEATURE_INCOMPAT_CSUM_SEED);
    eval 'sub EXT4_FEATURE_INCOMPAT_LARGEDIR () {0x4000;}' unless defined(&EXT4_FEATURE_INCOMPAT_LARGEDIR);
    eval 'sub EXT4_FEATURE_INCOMPAT_INLINE_DATA () {0x8000;}' unless defined(&EXT4_FEATURE_INCOMPAT_INLINE_DATA);
    eval 'sub EXT4_FEATURE_INCOMPAT_ENCRYPT () {0x10000;}' unless defined(&EXT4_FEATURE_INCOMPAT_ENCRYPT);
    eval 'sub EXT4_FEATURE_INCOMPAT_CASEFOLD () {0x20000;}' unless defined(&EXT4_FEATURE_INCOMPAT_CASEFOLD);
    eval 'sub EXT4_FEATURE_COMPAT_FUNCS {
        my($name, $ver, $flagname) = @_;
	    eval q( &static  &inline \'int\'  &ext2fs_has_feature_$name(\'struct ext2_super_block\' * &sb) {  &return (( &EXT2_SB( &sb)-> &s_feature_compat &  &EXT$ver &_FEATURE_COMPAT_$flagname) != 0); }  &static  &inline  &void  &ext2fs_set_feature_$name(\'struct ext2_super_block\' * &sb) {  &EXT2_SB( &sb)-> &s_feature_compat |=  &EXT$ver &_FEATURE_COMPAT_$flagname; }  &static  &inline  &void  &ext2fs_clear_feature_$name(\'struct ext2_super_block\' * &sb) {  &EXT2_SB( &sb)-> &s_feature_compat &= ~ &EXT$ver &_FEATURE_COMPAT_$flagname; });
    }' unless defined(&EXT4_FEATURE_COMPAT_FUNCS);
    eval 'sub EXT4_FEATURE_RO_COMPAT_FUNCS {
        my($name, $ver, $flagname) = @_;
	    eval q( &static  &inline \'int\'  &ext2fs_has_feature_$name(\'struct ext2_super_block\' * &sb) {  &return (( &EXT2_SB( &sb)-> &s_feature_ro_compat &  &EXT$ver &_FEATURE_RO_COMPAT_$flagname) != 0); }  &static  &inline  &void  &ext2fs_set_feature_$name(\'struct ext2_super_block\' * &sb) {  &EXT2_SB( &sb)-> &s_feature_ro_compat |=  &EXT$ver &_FEATURE_RO_COMPAT_$flagname; }  &static  &inline  &void  &ext2fs_clear_feature_$name(\'struct ext2_super_block\' * &sb) {  &EXT2_SB( &sb)-> &s_feature_ro_compat &= ~ &EXT$ver &_FEATURE_RO_COMPAT_$flagname; });
    }' unless defined(&EXT4_FEATURE_RO_COMPAT_FUNCS);
    eval 'sub EXT4_FEATURE_INCOMPAT_FUNCS {
        my($name, $ver, $flagname) = @_;
	    eval q( &static  &inline \'int\'  &ext2fs_has_feature_$name(\'struct ext2_super_block\' * &sb) {  &return (( &EXT2_SB( &sb)-> &s_feature_incompat &  &EXT$ver &_FEATURE_INCOMPAT_$flagname) != 0); }  &static  &inline  &void  &ext2fs_set_feature_$name(\'struct ext2_super_block\' * &sb) {  &EXT2_SB( &sb)-> &s_feature_incompat |=  &EXT$ver &_FEATURE_INCOMPAT_$flagname; }  &static  &inline  &void  &ext2fs_clear_feature_$name(\'struct ext2_super_block\' * &sb) {  &EXT2_SB( &sb)-> &s_feature_incompat &= ~ &EXT$ver &_FEATURE_INCOMPAT_$flagname; });
    }' unless defined(&EXT4_FEATURE_INCOMPAT_FUNCS);
    eval 'sub EXT2_FEATURE_COMPAT_SUPP () {0;}' unless defined(&EXT2_FEATURE_COMPAT_SUPP);
    eval 'sub EXT2_FEATURE_INCOMPAT_SUPP () {( &EXT2_FEATURE_INCOMPAT_FILETYPE|  &EXT4_FEATURE_INCOMPAT_MMP|  &EXT4_FEATURE_INCOMPAT_LARGEDIR|  &EXT4_FEATURE_INCOMPAT_EA_INODE);}' unless defined(&EXT2_FEATURE_INCOMPAT_SUPP);
    eval 'sub EXT2_FEATURE_RO_COMPAT_SUPP () {( &EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER|  &EXT2_FEATURE_RO_COMPAT_LARGE_FILE|  &EXT4_FEATURE_RO_COMPAT_DIR_NLINK|  &EXT2_FEATURE_RO_COMPAT_BTREE_DIR|  &EXT4_FEATURE_RO_COMPAT_VERITY);}' unless defined(&EXT2_FEATURE_RO_COMPAT_SUPP);
    eval 'sub EXT2_DEF_RESUID () {0;}' unless defined(&EXT2_DEF_RESUID);
    eval 'sub EXT2_DEF_RESGID () {0;}' unless defined(&EXT2_DEF_RESGID);
    eval 'sub EXT2_DEFM_DEBUG () {0x1;}' unless defined(&EXT2_DEFM_DEBUG);
    eval 'sub EXT2_DEFM_BSDGROUPS () {0x2;}' unless defined(&EXT2_DEFM_BSDGROUPS);
    eval 'sub EXT2_DEFM_XATTR_USER () {0x4;}' unless defined(&EXT2_DEFM_XATTR_USER);
    eval 'sub EXT2_DEFM_ACL () {0x8;}' unless defined(&EXT2_DEFM_ACL);
    eval 'sub EXT2_DEFM_UID16 () {0x10;}' unless defined(&EXT2_DEFM_UID16);
    eval 'sub EXT3_DEFM_JMODE () {0x60;}' unless defined(&EXT3_DEFM_JMODE);
    eval 'sub EXT3_DEFM_JMODE_DATA () {0x20;}' unless defined(&EXT3_DEFM_JMODE_DATA);
    eval 'sub EXT3_DEFM_JMODE_ORDERED () {0x40;}' unless defined(&EXT3_DEFM_JMODE_ORDERED);
    eval 'sub EXT3_DEFM_JMODE_WBACK () {0x60;}' unless defined(&EXT3_DEFM_JMODE_WBACK);
    eval 'sub EXT4_DEFM_NOBARRIER () {0x100;}' unless defined(&EXT4_DEFM_NOBARRIER);
    eval 'sub EXT4_DEFM_BLOCK_VALIDITY () {0x200;}' unless defined(&EXT4_DEFM_BLOCK_VALIDITY);
    eval 'sub EXT4_DEFM_DISCARD () {0x400;}' unless defined(&EXT4_DEFM_DISCARD);
    eval 'sub EXT4_DEFM_NODELALLOC () {0x800;}' unless defined(&EXT4_DEFM_NODELALLOC);
    eval 'sub ext4_hash_in_dirent {
        my($inode) = @_;
	    eval q({ ( ($inode->{i_flags}) &  &EXT4_ENCRYPT_FL)  && ( ($inode->{i_flags}) &  &EXT4_CASEFOLD_FL); });
    }' unless defined(&ext4_hash_in_dirent);
    eval 'sub EXT2_NAME_LEN () {255;}' unless defined(&EXT2_NAME_LEN);
    eval 'sub EXT2_DIRENT_HASHES {
        my($entry) = @_;
	    eval q((  ($entry->{name[		(ext2fs_dirent_name_len($entry) + 			EXT2_DIR_ROUND) & ~EXT2_DIR_ROUND]})));
    }' unless defined(&EXT2_DIRENT_HASHES);
    eval 'sub EXT2_DIRENT_HASH {
        my($entry) = @_;
	    eval q( &ext2fs_le32_to_cpu( &EXT2_DIRENT_HASHES($entry)-> &hash));
    }' unless defined(&EXT2_DIRENT_HASH);
    eval 'sub EXT2_DIRENT_MINOR_HASH {
        my($entry) = @_;
	    eval q( &ext2fs_le32_to_cpu( &EXT2_DIRENT_HASHES($entry)-> &minor_hash));
    }' unless defined(&EXT2_DIRENT_MINOR_HASH);
    eval 'sub EXT2_FT_UNKNOWN () {0;}' unless defined(&EXT2_FT_UNKNOWN);
    eval 'sub EXT2_FT_REG_FILE () {1;}' unless defined(&EXT2_FT_REG_FILE);
    eval 'sub EXT2_FT_DIR () {2;}' unless defined(&EXT2_FT_DIR);
    eval 'sub EXT2_FT_CHRDEV () {3;}' unless defined(&EXT2_FT_CHRDEV);
    eval 'sub EXT2_FT_BLKDEV () {4;}' unless defined(&EXT2_FT_BLKDEV);
    eval 'sub EXT2_FT_FIFO () {5;}' unless defined(&EXT2_FT_FIFO);
    eval 'sub EXT2_FT_SOCK () {6;}' unless defined(&EXT2_FT_SOCK);
    eval 'sub EXT2_FT_SYMLINK () {7;}' unless defined(&EXT2_FT_SYMLINK);
    eval 'sub EXT2_FT_MAX () {8;}' unless defined(&EXT2_FT_MAX);
    eval 'sub EXT2_DIR_NAME_LEN_CSUM () {0xde00;}' unless defined(&EXT2_DIR_NAME_LEN_CSUM);
    eval 'sub EXT2_DIR_ENTRY_HEADER_LEN () {8;}' unless defined(&EXT2_DIR_ENTRY_HEADER_LEN);
    eval 'sub EXT2_DIR_ENTRY_HASH_LEN () {8;}' unless defined(&EXT2_DIR_ENTRY_HASH_LEN);
    eval 'sub EXT2_DIR_PAD () {4;}' unless defined(&EXT2_DIR_PAD);
    eval 'sub EXT2_DIR_ROUND () {( &EXT2_DIR_PAD - 1);}' unless defined(&EXT2_DIR_ROUND);
    eval 'sub EXT2_DIR_REC_LEN {
        my($name_len) = @_;
	    eval q( &ext2fs_dir_rec_len($name_len, 0));
    }' unless defined(&EXT2_DIR_REC_LEN);
    eval 'sub ext2fs_dir_rec_len {
        my($name_len,$extended) = @_;
	    eval q({ \'int\'  &rec_len = ($name_len +  &EXT2_DIR_ENTRY_HEADER_LEN +  &EXT2_DIR_ROUND);  &rec_len &= ~ &EXT2_DIR_ROUND;  &if ($extended)  &rec_len +=  &EXT2_DIR_ENTRY_HASH_LEN;  &rec_len; });
    }' unless defined(&ext2fs_dir_rec_len);
    eval 'sub EXT4_EPOCH_BITS () {2;}' unless defined(&EXT4_EPOCH_BITS);
    eval 'sub EXT4_EPOCH_MASK () {((1<<  &EXT4_EPOCH_BITS) - 1);}' unless defined(&EXT4_EPOCH_MASK);
    eval 'sub EXT4_NSEC_MASK () {(~0 <<  &EXT4_EPOCH_BITS);}' unless defined(&EXT4_NSEC_MASK);
    eval 'sub EXT4_MMP_MAGIC () {0x4d4d50;}' unless defined(&EXT4_MMP_MAGIC);
    eval 'sub EXT4_MMP_SEQ_CLEAN () {0xff4d4d50;}' unless defined(&EXT4_MMP_SEQ_CLEAN);
    eval 'sub EXT4_MMP_SEQ_FSCK () {0xe24d4d50;}' unless defined(&EXT4_MMP_SEQ_FSCK);
    eval 'sub EXT4_MMP_SEQ_MAX () {0xe24d4d4f;}' unless defined(&EXT4_MMP_SEQ_MAX);
    eval 'sub EXT4_MMP_UPDATE_INTERVAL () {5;}' unless defined(&EXT4_MMP_UPDATE_INTERVAL);
    eval 'sub EXT4_MMP_MAX_UPDATE_INTERVAL () {300;}' unless defined(&EXT4_MMP_MAX_UPDATE_INTERVAL);
    eval 'sub EXT4_MMP_MIN_CHECK_INTERVAL () {5;}' unless defined(&EXT4_MMP_MIN_CHECK_INTERVAL);
    eval 'sub EXT4_MIN_INLINE_DATA_SIZE () {(($sizeof{ &__u32} *  &EXT2_N_BLOCKS));}' unless defined(&EXT4_MIN_INLINE_DATA_SIZE);
    eval 'sub EXT4_INLINE_DATA_DOTDOT_SIZE () {(4);}' unless defined(&EXT4_INLINE_DATA_DOTDOT_SIZE);
    eval 'sub EXT4_ENC_UTF8_12_1 () {1;}' unless defined(&EXT4_ENC_UTF8_12_1);
    eval 'sub EXT4_ENC_STRICT_MODE_FL () {(1<< 0);}' unless defined(&EXT4_ENC_STRICT_MODE_FL);
}
1;
