require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_EXT2FS_EXT2FS_H)) {
    eval 'sub _EXT2FS_EXT2FS_H () {1;}' unless defined(&_EXT2FS_EXT2FS_H);
    if(defined(&__GNUC__)) {
	eval 'sub EXT2FS_ATTR {
	    my($x) = @_;
    	    eval q( &__attribute__($x));
	}' unless defined(&EXT2FS_ATTR);
    } else {
	eval 'sub EXT2FS_ATTR {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&EXT2FS_ATTR);
    }
    unless(defined(&__nonstring)) {
	if(defined(&__has_attribute)) {
	    if( &__has_attribute((defined(&__nonstring__) ? &__nonstring__ : undef))) {
		eval 'sub __nonstring () { &__attribute__(( &__nonstring__));}' unless defined(&__nonstring);
	    } else {
		eval 'sub __nonstring () {1;}' unless defined(&__nonstring);
	    }
	} else {
	    eval 'sub __nonstring () {1;}' unless defined(&__nonstring);
	}
    }
    if(defined(&CONFIG_TDB)) {
	eval 'sub EXT2FS_NO_TDB_UNUSED () {1;}' unless defined(&EXT2FS_NO_TDB_UNUSED);
    } else {
	eval 'sub EXT2FS_NO_TDB_UNUSED () { &EXT2FS_ATTR(( &unused));}' unless defined(&EXT2FS_NO_TDB_UNUSED);
    }
    if(defined(&__cplusplus)) {
    }
    if((!defined(&__GNUC__)  && !defined(&__WATCOMC__))) {
	eval 'sub NO_INLINE_FUNCS () {1;}' unless defined(&NO_INLINE_FUNCS);
    }
    eval 'sub SUPERBLOCK_OFFSET () {1024;}' unless defined(&SUPERBLOCK_OFFSET);
    eval 'sub SUPERBLOCK_SIZE () {1024;}' unless defined(&SUPERBLOCK_SIZE);
    eval 'sub UUID_STR_SIZE () {37;}' unless defined(&UUID_STR_SIZE);
    eval 'sub EXT2_LIB_CURRENT_REV () { &EXT2_DYNAMIC_REV;}' unless defined(&EXT2_LIB_CURRENT_REV);
    if(defined(&HAVE_SYS_TYPES_H)) {
	require 'sys/types.ph';
    }
    require 'stdio.ph';
    require 'stdlib.ph';
    require 'string.ph';
    require 'time.ph';
    require 'errno.ph';
    if((defined(&EXT2_FLAT_INCLUDES) ? &EXT2_FLAT_INCLUDES : undef)) {
	require './ext2fs/e2_types.ph';
	require './ext2fs/ext2_fs.ph';
	require './ext2fs/ext3_extents.ph';
    } else {
	require 'ext2fs/ext2_types.ph';
	require 'ext2fs/ext2_fs.ph';
	require 'ext2fs/ext3_extents.ph';
    }
    if((defined(&EXT2_FLAT_INCLUDES) ? &EXT2_FLAT_INCLUDES : undef)) {
	require './ext2fs/com_err.ph';
	require './ext2fs/ext2_io.ph';
	require './ext2fs/ext2_err.ph';
	require './ext2fs/ext2_ext_attr.ph';
    } else {
	require 'et/com_err.ph';
	require 'ext2fs/ext2_io.ph';
	require 'ext2fs/ext2_err.ph';
	require 'ext2fs/ext2_ext_attr.ph';
    }
    require './ext2fs/hashmap.ph';
    if(defined(&_MSC_VER)) {
	eval 'sub EXT2_QSORT_TYPE () {\'int\'  &__cdecl;}' unless defined(&EXT2_QSORT_TYPE);
    } else {
	eval 'sub EXT2_QSORT_TYPE () {\'int\';}' unless defined(&EXT2_QSORT_TYPE);
    }
    eval 'sub EXT2FS_MARK_ERROR () {0;}' unless defined(&EXT2FS_MARK_ERROR);
    eval 'sub EXT2FS_UNMARK_ERROR () {1;}' unless defined(&EXT2FS_UNMARK_ERROR);
    eval 'sub EXT2FS_TEST_ERROR () {2;}' unless defined(&EXT2FS_TEST_ERROR);
    eval 'sub EXT2_FIRST_INODE {
        my($s) = @_;
	    eval q( &EXT2_FIRST_INO($s));
    }' unless defined(&EXT2_FIRST_INODE);
    eval 'sub BADBLOCKS_FLAG_DIRTY () {1;}' unless defined(&BADBLOCKS_FLAG_DIRTY);
    eval 'sub DBLIST_ABORT () {1;}' unless defined(&DBLIST_ABORT);
    eval 'sub EXT2_FILE_WRITE () {0x1;}' unless defined(&EXT2_FILE_WRITE);
    eval 'sub EXT2_FILE_CREATE () {0x2;}' unless defined(&EXT2_FILE_CREATE);
    eval 'sub EXT2_FILE_MASK () {0xff;}' unless defined(&EXT2_FILE_MASK);
    eval 'sub EXT2_FILE_BUF_DIRTY () {0x4000;}' unless defined(&EXT2_FILE_BUF_DIRTY);
    eval 'sub EXT2_FILE_BUF_VALID () {0x2000;}' unless defined(&EXT2_FILE_BUF_VALID);
    eval 'sub EXT2_SEEK_SET () {0;}' unless defined(&EXT2_SEEK_SET);
    eval 'sub EXT2_SEEK_CUR () {1;}' unless defined(&EXT2_SEEK_CUR);
    eval 'sub EXT2_SEEK_END () {2;}' unless defined(&EXT2_SEEK_END);
    eval 'sub EXT2_FLAG_RW () {0x1;}' unless defined(&EXT2_FLAG_RW);
    eval 'sub EXT2_FLAG_CHANGED () {0x2;}' unless defined(&EXT2_FLAG_CHANGED);
    eval 'sub EXT2_FLAG_DIRTY () {0x4;}' unless defined(&EXT2_FLAG_DIRTY);
    eval 'sub EXT2_FLAG_VALID () {0x8;}' unless defined(&EXT2_FLAG_VALID);
    eval 'sub EXT2_FLAG_IB_DIRTY () {0x10;}' unless defined(&EXT2_FLAG_IB_DIRTY);
    eval 'sub EXT2_FLAG_BB_DIRTY () {0x20;}' unless defined(&EXT2_FLAG_BB_DIRTY);
    eval 'sub EXT2_FLAG_SWAP_BYTES () {0x40;}' unless defined(&EXT2_FLAG_SWAP_BYTES);
    eval 'sub EXT2_FLAG_SWAP_BYTES_READ () {0x80;}' unless defined(&EXT2_FLAG_SWAP_BYTES_READ);
    eval 'sub EXT2_FLAG_SWAP_BYTES_WRITE () {0x100;}' unless defined(&EXT2_FLAG_SWAP_BYTES_WRITE);
    eval 'sub EXT2_FLAG_MASTER_SB_ONLY () {0x200;}' unless defined(&EXT2_FLAG_MASTER_SB_ONLY);
    eval 'sub EXT2_FLAG_FORCE () {0x400;}' unless defined(&EXT2_FLAG_FORCE);
    eval 'sub EXT2_FLAG_SUPER_ONLY () {0x800;}' unless defined(&EXT2_FLAG_SUPER_ONLY);
    eval 'sub EXT2_FLAG_JOURNAL_DEV_OK () {0x1000;}' unless defined(&EXT2_FLAG_JOURNAL_DEV_OK);
    eval 'sub EXT2_FLAG_IMAGE_FILE () {0x2000;}' unless defined(&EXT2_FLAG_IMAGE_FILE);
    eval 'sub EXT2_FLAG_EXCLUSIVE () {0x4000;}' unless defined(&EXT2_FLAG_EXCLUSIVE);
    eval 'sub EXT2_FLAG_SOFTSUPP_FEATURES () {0x8000;}' unless defined(&EXT2_FLAG_SOFTSUPP_FEATURES);
    eval 'sub EXT2_FLAG_NOFREE_ON_ERROR () {0x10000;}' unless defined(&EXT2_FLAG_NOFREE_ON_ERROR);
    eval 'sub EXT2_FLAG_64BITS () {0x20000;}' unless defined(&EXT2_FLAG_64BITS);
    eval 'sub EXT2_FLAG_PRINT_PROGRESS () {0x40000;}' unless defined(&EXT2_FLAG_PRINT_PROGRESS);
    eval 'sub EXT2_FLAG_DIRECT_IO () {0x80000;}' unless defined(&EXT2_FLAG_DIRECT_IO);
    eval 'sub EXT2_FLAG_SKIP_MMP () {0x100000;}' unless defined(&EXT2_FLAG_SKIP_MMP);
    eval 'sub EXT2_FLAG_IGNORE_CSUM_ERRORS () {0x200000;}' unless defined(&EXT2_FLAG_IGNORE_CSUM_ERRORS);
    eval 'sub EXT2_FLAG_SHARE_DUP () {0x400000;}' unless defined(&EXT2_FLAG_SHARE_DUP);
    eval 'sub EXT2_FLAG_IGNORE_SB_ERRORS () {0x800000;}' unless defined(&EXT2_FLAG_IGNORE_SB_ERRORS);
    eval 'sub EXT2_FLAG_BBITMAP_TAIL_PROBLEM () {0x1000000;}' unless defined(&EXT2_FLAG_BBITMAP_TAIL_PROBLEM);
    eval 'sub EXT2_FLAG_IBITMAP_TAIL_PROBLEM () {0x2000000;}' unless defined(&EXT2_FLAG_IBITMAP_TAIL_PROBLEM);
    eval 'sub EXT2_FLAG_THREADS () {0x4000000;}' unless defined(&EXT2_FLAG_THREADS);
    eval 'sub EXT2_NEW_INODE_FL () {0x80000000;}' unless defined(&EXT2_NEW_INODE_FL);
    eval 'sub EXT2_MKJOURNAL_V1_SUPER () {0x1;}' unless defined(&EXT2_MKJOURNAL_V1_SUPER);
    eval 'sub EXT2_MKJOURNAL_LAZYINIT () {0x2;}' unless defined(&EXT2_MKJOURNAL_LAZYINIT);
    eval 'sub EXT2_MKJOURNAL_NO_MNT_CHECK () {0x4;}' unless defined(&EXT2_MKJOURNAL_NO_MNT_CHECK);
    eval 'sub EXT2_JOURNAL_TO_FC_BLKS_RATIO () {64;}' unless defined(&EXT2_JOURNAL_TO_FC_BLKS_RATIO);
    if((defined(&EXT2_FLAT_INCLUDES) ? &EXT2_FLAT_INCLUDES : undef)) {
	require './ext2fs/e2_bitops.ph';
    } else {
	require 'ext2fs/bitops.ph';
    }
    eval 'sub EXT2FS_BMAP64_BITARRAY () {1;}' unless defined(&EXT2FS_BMAP64_BITARRAY);
    eval 'sub EXT2FS_BMAP64_RBTREE () {2;}' unless defined(&EXT2FS_BMAP64_RBTREE);
    eval 'sub EXT2FS_BMAP64_AUTODIR () {3;}' unless defined(&EXT2FS_BMAP64_AUTODIR);
    eval 'sub BLOCK_CHANGED () {1;}' unless defined(&BLOCK_CHANGED);
    eval 'sub BLOCK_ABORT () {2;}' unless defined(&BLOCK_ABORT);
    eval 'sub BLOCK_ERROR () {4;}' unless defined(&BLOCK_ERROR);
    eval 'sub BLOCK_INLINE_DATA_CHANGED () {8;}' unless defined(&BLOCK_INLINE_DATA_CHANGED);
    eval 'sub BLOCK_FLAG_APPEND () {1;}' unless defined(&BLOCK_FLAG_APPEND);
    eval 'sub BLOCK_FLAG_HOLE () {1;}' unless defined(&BLOCK_FLAG_HOLE);
    eval 'sub BLOCK_FLAG_DEPTH_TRAVERSE () {2;}' unless defined(&BLOCK_FLAG_DEPTH_TRAVERSE);
    eval 'sub BLOCK_FLAG_DATA_ONLY () {4;}' unless defined(&BLOCK_FLAG_DATA_ONLY);
    eval 'sub BLOCK_FLAG_READ_ONLY () {8;}' unless defined(&BLOCK_FLAG_READ_ONLY);
    eval 'sub BLOCK_FLAG_NO_LARGE () {0x1000;}' unless defined(&BLOCK_FLAG_NO_LARGE);
    eval 'sub BLOCK_COUNT_IND () {(-1);}' unless defined(&BLOCK_COUNT_IND);
    eval 'sub BLOCK_COUNT_DIND () {(-2);}' unless defined(&BLOCK_COUNT_DIND);
    eval 'sub BLOCK_COUNT_TIND () {(-3);}' unless defined(&BLOCK_COUNT_TIND);
    eval 'sub BLOCK_COUNT_TRANSLATOR () {(-4);}' unless defined(&BLOCK_COUNT_TRANSLATOR);
    eval 'sub BLOCK_ALLOC_UNKNOWN () {0;}' unless defined(&BLOCK_ALLOC_UNKNOWN);
    eval 'sub BLOCK_ALLOC_DATA () {1;}' unless defined(&BLOCK_ALLOC_DATA);
    eval 'sub BLOCK_ALLOC_METADATA () {2;}' unless defined(&BLOCK_ALLOC_METADATA);
    if(0) {
	eval 'sub EXT2_BMOVE_GET_DBLIST () {0x1;}' unless defined(&EXT2_BMOVE_GET_DBLIST);
	eval 'sub EXT2_BMOVE_DEBUG () {0x2;}' unless defined(&EXT2_BMOVE_DEBUG);
    }
    eval 'sub EXT2_EXTENT_FLAGS_LEAF () {0x1;}' unless defined(&EXT2_EXTENT_FLAGS_LEAF);
    eval 'sub EXT2_EXTENT_FLAGS_UNINIT () {0x2;}' unless defined(&EXT2_EXTENT_FLAGS_UNINIT);
    eval 'sub EXT2_EXTENT_FLAGS_SECOND_VISIT () {0x4;}' unless defined(&EXT2_EXTENT_FLAGS_SECOND_VISIT);
    eval 'sub EXT2_EXTENT_CURRENT () {0x;}' unless defined(&EXT2_EXTENT_CURRENT);
    eval 'sub EXT2_EXTENT_MOVE_MASK () {0xf;}' unless defined(&EXT2_EXTENT_MOVE_MASK);
    eval 'sub EXT2_EXTENT_ROOT () {0x1;}' unless defined(&EXT2_EXTENT_ROOT);
    eval 'sub EXT2_EXTENT_LAST_LEAF () {0x2;}' unless defined(&EXT2_EXTENT_LAST_LEAF);
    eval 'sub EXT2_EXTENT_FIRST_SIB () {0x3;}' unless defined(&EXT2_EXTENT_FIRST_SIB);
    eval 'sub EXT2_EXTENT_LAST_SIB () {0x4;}' unless defined(&EXT2_EXTENT_LAST_SIB);
    eval 'sub EXT2_EXTENT_NEXT_SIB () {0x5;}' unless defined(&EXT2_EXTENT_NEXT_SIB);
    eval 'sub EXT2_EXTENT_PREV_SIB () {0x6;}' unless defined(&EXT2_EXTENT_PREV_SIB);
    eval 'sub EXT2_EXTENT_NEXT_LEAF () {0x7;}' unless defined(&EXT2_EXTENT_NEXT_LEAF);
    eval 'sub EXT2_EXTENT_PREV_LEAF () {0x8;}' unless defined(&EXT2_EXTENT_PREV_LEAF);
    eval 'sub EXT2_EXTENT_NEXT () {0x9;}' unless defined(&EXT2_EXTENT_NEXT);
    eval 'sub EXT2_EXTENT_PREV () {0xa;}' unless defined(&EXT2_EXTENT_PREV);
    eval 'sub EXT2_EXTENT_UP () {0xb;}' unless defined(&EXT2_EXTENT_UP);
    eval 'sub EXT2_EXTENT_DOWN () {0xc;}' unless defined(&EXT2_EXTENT_DOWN);
    eval 'sub EXT2_EXTENT_DOWN_AND_LAST () {0xd;}' unless defined(&EXT2_EXTENT_DOWN_AND_LAST);
    eval 'sub EXT2_EXTENT_INSERT_AFTER () {0x1;}' unless defined(&EXT2_EXTENT_INSERT_AFTER);
    eval 'sub EXT2_EXTENT_INSERT_NOSPLIT () {0x2;}' unless defined(&EXT2_EXTENT_INSERT_NOSPLIT);
    eval 'sub EXT2_EXTENT_DELETE_KEEP_EMPTY () {0x1;}' unless defined(&EXT2_EXTENT_DELETE_KEEP_EMPTY);
    eval 'sub EXT2_EXTENT_SET_BMAP_UNINIT () {0x1;}' unless defined(&EXT2_EXTENT_SET_BMAP_UNINIT);
    eval 'sub EXT2_DIRBLOCK_V2_STRUCT () {0x1;}' unless defined(&EXT2_DIRBLOCK_V2_STRUCT);
    eval 'sub DIRENT_CHANGED () {1;}' unless defined(&DIRENT_CHANGED);
    eval 'sub DIRENT_ABORT () {2;}' unless defined(&DIRENT_ABORT);
    eval 'sub DIRENT_ERROR () {3;}' unless defined(&DIRENT_ERROR);
    eval 'sub DIRENT_FLAG_INCLUDE_EMPTY () {1;}' unless defined(&DIRENT_FLAG_INCLUDE_EMPTY);
    eval 'sub DIRENT_FLAG_INCLUDE_REMOVED () {2;}' unless defined(&DIRENT_FLAG_INCLUDE_REMOVED);
    eval 'sub DIRENT_FLAG_INCLUDE_CSUM () {4;}' unless defined(&DIRENT_FLAG_INCLUDE_CSUM);
    eval 'sub DIRENT_FLAG_INCLUDE_INLINE_DATA () {8;}' unless defined(&DIRENT_FLAG_INCLUDE_INLINE_DATA);
    eval 'sub DIRENT_DOT_FILE () {1;}' unless defined(&DIRENT_DOT_FILE);
    eval 'sub DIRENT_DOT_DOT_FILE () {2;}' unless defined(&DIRENT_DOT_DOT_FILE);
    eval 'sub DIRENT_OTHER_FILE () {3;}' unless defined(&DIRENT_OTHER_FILE);
    eval 'sub DIRENT_DELETED_FILE () {4;}' unless defined(&DIRENT_DELETED_FILE);
    eval 'sub DIRENT_CHECKSUM () {5;}' unless defined(&DIRENT_CHECKSUM);
    eval 'sub EXT2_SF_CHK_BADBLOCKS () {0x1;}' unless defined(&EXT2_SF_CHK_BADBLOCKS);
    eval 'sub EXT2_SF_BAD_INODE_BLK () {0x2;}' unless defined(&EXT2_SF_BAD_INODE_BLK);
    eval 'sub EXT2_SF_BAD_EXTRA_BYTES () {0x4;}' unless defined(&EXT2_SF_BAD_EXTRA_BYTES);
    eval 'sub EXT2_SF_SKIP_MISSING_ITABLE () {0x8;}' unless defined(&EXT2_SF_SKIP_MISSING_ITABLE);
    eval 'sub EXT2_SF_DO_LAZY () {0x10;}' unless defined(&EXT2_SF_DO_LAZY);
    eval 'sub EXT2_SF_WARN_GARBAGE_INODES () {0x20;}' unless defined(&EXT2_SF_WARN_GARBAGE_INODES);
    eval 'sub EXT2_MF_MOUNTED () {1;}' unless defined(&EXT2_MF_MOUNTED);
    eval 'sub EXT2_MF_ISROOT () {2;}' unless defined(&EXT2_MF_ISROOT);
    eval 'sub EXT2_MF_READONLY () {4;}' unless defined(&EXT2_MF_READONLY);
    eval 'sub EXT2_MF_SWAP () {8;}' unless defined(&EXT2_MF_SWAP);
    eval 'sub EXT2_MF_BUSY () {16;}' unless defined(&EXT2_MF_BUSY);
    eval 'sub LINUX_S_IFMT () {00170000;}' unless defined(&LINUX_S_IFMT);
    eval 'sub LINUX_S_IFSOCK () {0140000;}' unless defined(&LINUX_S_IFSOCK);
    eval 'sub LINUX_S_IFLNK () {0120000;}' unless defined(&LINUX_S_IFLNK);
    eval 'sub LINUX_S_IFREG () {0100000;}' unless defined(&LINUX_S_IFREG);
    eval 'sub LINUX_S_IFBLK () {0060000;}' unless defined(&LINUX_S_IFBLK);
    eval 'sub LINUX_S_IFDIR () {0040000;}' unless defined(&LINUX_S_IFDIR);
    eval 'sub LINUX_S_IFCHR () {0020000;}' unless defined(&LINUX_S_IFCHR);
    eval 'sub LINUX_S_IFIFO () {0010000;}' unless defined(&LINUX_S_IFIFO);
    eval 'sub LINUX_S_ISUID () {0004000;}' unless defined(&LINUX_S_ISUID);
    eval 'sub LINUX_S_ISGID () {0002000;}' unless defined(&LINUX_S_ISGID);
    eval 'sub LINUX_S_ISVTX () {0001000;}' unless defined(&LINUX_S_ISVTX);
    eval 'sub LINUX_S_IRWXU () {00700;}' unless defined(&LINUX_S_IRWXU);
    eval 'sub LINUX_S_IRUSR () {00400;}' unless defined(&LINUX_S_IRUSR);
    eval 'sub LINUX_S_IWUSR () {00200;}' unless defined(&LINUX_S_IWUSR);
    eval 'sub LINUX_S_IXUSR () {00100;}' unless defined(&LINUX_S_IXUSR);
    eval 'sub LINUX_S_IRWXG () {00070;}' unless defined(&LINUX_S_IRWXG);
    eval 'sub LINUX_S_IRGRP () {00040;}' unless defined(&LINUX_S_IRGRP);
    eval 'sub LINUX_S_IWGRP () {00020;}' unless defined(&LINUX_S_IWGRP);
    eval 'sub LINUX_S_IXGRP () {00010;}' unless defined(&LINUX_S_IXGRP);
    eval 'sub LINUX_S_IRWXO () {00007;}' unless defined(&LINUX_S_IRWXO);
    eval 'sub LINUX_S_IROTH () {00004;}' unless defined(&LINUX_S_IROTH);
    eval 'sub LINUX_S_IWOTH () {00002;}' unless defined(&LINUX_S_IWOTH);
    eval 'sub LINUX_S_IXOTH () {00001;}' unless defined(&LINUX_S_IXOTH);
    eval 'sub LINUX_S_ISLNK {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFLNK));
    }' unless defined(&LINUX_S_ISLNK);
    eval 'sub LINUX_S_ISREG {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFREG));
    }' unless defined(&LINUX_S_ISREG);
    eval 'sub LINUX_S_ISDIR {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFDIR));
    }' unless defined(&LINUX_S_ISDIR);
    eval 'sub LINUX_S_ISCHR {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFCHR));
    }' unless defined(&LINUX_S_ISCHR);
    eval 'sub LINUX_S_ISBLK {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFBLK));
    }' unless defined(&LINUX_S_ISBLK);
    eval 'sub LINUX_S_ISFIFO {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFIFO));
    }' unless defined(&LINUX_S_ISFIFO);
    eval 'sub LINUX_S_ISSOCK {
        my($m) = @_;
	    eval q(((($m) &  &LINUX_S_IFMT) ==  &LINUX_S_IFSOCK));
    }' unless defined(&LINUX_S_ISSOCK);
    eval 'sub EXT2_I_SIZE {
        my($i) = @_;
	    eval q((($i)-> &i_size | (( &__u64) ($i)-> &i_size_high << 32)));
    }' unless defined(&EXT2_I_SIZE);
    eval 'sub EXT2_ICOUNT_OPT_INCREMENT () {0x1;}' unless defined(&EXT2_ICOUNT_OPT_INCREMENT);
    eval 'sub EXT2_ICOUNT_OPT_FULLMAP () {0x2;}' unless defined(&EXT2_ICOUNT_OPT_FULLMAP);
    eval 'sub BMAP_ALLOC () {0x1;}' unless defined(&BMAP_ALLOC);
    eval 'sub BMAP_SET () {0x2;}' unless defined(&BMAP_SET);
    eval 'sub BMAP_UNINIT () {0x4;}' unless defined(&BMAP_UNINIT);
    eval 'sub BMAP_ZERO () {0x8;}' unless defined(&BMAP_ZERO);
    eval 'sub BMAP_RET_UNINIT () {0x1;}' unless defined(&BMAP_RET_UNINIT);
    eval 'sub READ_INODE_NOCSUM () {0x1;}' unless defined(&READ_INODE_NOCSUM);
    eval 'sub WRITE_INODE_NOCSUM () {0x1;}' unless defined(&WRITE_INODE_NOCSUM);
    eval 'sub IMAGER_FLAG_INODEMAP () {1;}' unless defined(&IMAGER_FLAG_INODEMAP);
    eval 'sub IMAGER_FLAG_SPARSEWRITE () {2;}' unless defined(&IMAGER_FLAG_SPARSEWRITE);
    eval 'sub EXT2_CHECK_MAGIC {
        my($struct, $code) = @_;
	    eval q( &if (-> &magic != ($code))  &return ($code));
    }' unless defined(&EXT2_CHECK_MAGIC);
    eval 'sub EXT2_LIB_FEATURE_COMPAT_SUPP () {( &EXT2_FEATURE_COMPAT_DIR_PREALLOC|  &EXT2_FEATURE_COMPAT_IMAGIC_INODES|  &EXT3_FEATURE_COMPAT_HAS_JOURNAL|  &EXT2_FEATURE_COMPAT_RESIZE_INODE|  &EXT2_FEATURE_COMPAT_DIR_INDEX|  &EXT2_FEATURE_COMPAT_EXT_ATTR|  &EXT4_FEATURE_COMPAT_SPARSE_SUPER2|  &EXT4_FEATURE_COMPAT_FAST_COMMIT|  &EXT4_FEATURE_COMPAT_STABLE_INODES);}' unless defined(&EXT2_LIB_FEATURE_COMPAT_SUPP);
    if(defined(&CONFIG_MMP)) {
	eval 'sub EXT4_LIB_INCOMPAT_MMP () { &EXT4_FEATURE_INCOMPAT_MMP;}' unless defined(&EXT4_LIB_INCOMPAT_MMP);
    } else {
	eval 'sub EXT4_LIB_INCOMPAT_MMP () {(0);}' unless defined(&EXT4_LIB_INCOMPAT_MMP);
    }
    eval 'sub EXT2_LIB_FEATURE_INCOMPAT_SUPP () {( &EXT2_FEATURE_INCOMPAT_FILETYPE|  &EXT3_FEATURE_INCOMPAT_JOURNAL_DEV|  &EXT2_FEATURE_INCOMPAT_META_BG|  &EXT3_FEATURE_INCOMPAT_RECOVER|  &EXT3_FEATURE_INCOMPAT_EXTENTS|  &EXT4_FEATURE_INCOMPAT_FLEX_BG|  &EXT4_FEATURE_INCOMPAT_EA_INODE|  &EXT4_LIB_INCOMPAT_MMP|  &EXT4_FEATURE_INCOMPAT_64BIT|  &EXT4_FEATURE_INCOMPAT_INLINE_DATA|  &EXT4_FEATURE_INCOMPAT_ENCRYPT|  &EXT4_FEATURE_INCOMPAT_CASEFOLD|  &EXT4_FEATURE_INCOMPAT_CSUM_SEED|  &EXT4_FEATURE_INCOMPAT_LARGEDIR);}' unless defined(&EXT2_LIB_FEATURE_INCOMPAT_SUPP);
    eval 'sub EXT2_LIB_FEATURE_RO_COMPAT_SUPP () {( &EXT2_FEATURE_RO_COMPAT_SPARSE_SUPER|  &EXT4_FEATURE_RO_COMPAT_HUGE_FILE|  &EXT2_FEATURE_RO_COMPAT_LARGE_FILE|  &EXT4_FEATURE_RO_COMPAT_DIR_NLINK|  &EXT4_FEATURE_RO_COMPAT_EXTRA_ISIZE|  &EXT4_FEATURE_RO_COMPAT_GDT_CSUM|  &EXT4_FEATURE_RO_COMPAT_BIGALLOC|  &EXT4_FEATURE_RO_COMPAT_QUOTA|  &EXT4_FEATURE_RO_COMPAT_METADATA_CSUM|  &EXT4_FEATURE_RO_COMPAT_READONLY |  &EXT4_FEATURE_RO_COMPAT_PROJECT |  &EXT4_FEATURE_RO_COMPAT_SHARED_BLOCKS |  &EXT4_FEATURE_RO_COMPAT_VERITY);}' unless defined(&EXT2_LIB_FEATURE_RO_COMPAT_SUPP);
    eval 'sub EXT2_LIB_SOFTSUPP_INCOMPAT () {(0);}' unless defined(&EXT2_LIB_SOFTSUPP_INCOMPAT);
    eval 'sub EXT2_LIB_SOFTSUPP_RO_COMPAT () {( &EXT4_FEATURE_RO_COMPAT_REPLICA);}' unless defined(&EXT2_LIB_SOFTSUPP_RO_COMPAT);
    eval 'sub EXT2FS_CLUSTER_RATIO {
        my($fs) = @_;
	    eval q((1<< ($fs)-> &cluster_ratio_bits));
    }' unless defined(&EXT2FS_CLUSTER_RATIO);
    eval 'sub EXT2FS_CLUSTER_MASK {
        my($fs) = @_;
	    eval q(( &EXT2FS_CLUSTER_RATIO($fs) - 1));
    }' unless defined(&EXT2FS_CLUSTER_MASK);
    eval 'sub EXT2FS_B2C {
        my($fs, $blk) = @_;
	    eval q((($blk) >> ($fs)-> &cluster_ratio_bits));
    }' unless defined(&EXT2FS_B2C);
    eval 'sub EXT2FS_C2B {
        my($fs, $cluster) = @_;
	    eval q((($cluster) << ($fs)-> &cluster_ratio_bits));
    }' unless defined(&EXT2FS_C2B);
    eval 'sub EXT2FS_NUM_B2C {
        my($fs, $blks) = @_;
	    eval q(((($blks) +  &EXT2FS_CLUSTER_MASK($fs)) >> ($fs)-> &cluster_ratio_bits));
    }' unless defined(&EXT2FS_NUM_B2C);
    if(defined(&HAVE_FSTAT64)  && !defined(&__OSX_AVAILABLE_BUT_DEPRECATED)) {
    } else {
    }
    eval 'sub EXT2_FLAG_FLUSH_NO_SYNC () {1;}' unless defined(&EXT2_FLAG_FLUSH_NO_SYNC);
    eval 'sub XATTR_ABORT () {1;}' unless defined(&XATTR_ABORT);
    eval 'sub XATTR_CHANGED () {2;}' unless defined(&XATTR_CHANGED);
    eval 'sub EXT2FS_BITMAPS_WRITE () {0x1;}' unless defined(&EXT2FS_BITMAPS_WRITE);
    eval 'sub EXT2FS_BITMAPS_BLOCK () {0x2;}' unless defined(&EXT2FS_BITMAPS_BLOCK);
    eval 'sub EXT2FS_BITMAPS_INODE () {0x4;}' unless defined(&EXT2FS_BITMAPS_INODE);
    eval 'sub EXT2FS_BITMAPS_VALID_FLAGS () {0x7;}' unless defined(&EXT2FS_BITMAPS_VALID_FLAGS);
    eval 'sub EXT2_NEWRANGE_FIXED_GOAL () {(0x1);}' unless defined(&EXT2_NEWRANGE_FIXED_GOAL);
    eval 'sub EXT2_NEWRANGE_MIN_LENGTH () {(0x2);}' unless defined(&EXT2_NEWRANGE_MIN_LENGTH);
    eval 'sub EXT2_NEWRANGE_ALL_FLAGS () {(0x3);}' unless defined(&EXT2_NEWRANGE_ALL_FLAGS);
    eval 'sub EXT2_ALLOCRANGE_FIXED_GOAL () {(0x1);}' unless defined(&EXT2_ALLOCRANGE_FIXED_GOAL);
    eval 'sub EXT2_ALLOCRANGE_ZERO_BLOCKS () {(0x2);}' unless defined(&EXT2_ALLOCRANGE_ZERO_BLOCKS);
    eval 'sub EXT2_ALLOCRANGE_ALL_FLAGS () {(0x3);}' unless defined(&EXT2_ALLOCRANGE_ALL_FLAGS);
    if(0) {
    }
    eval 'sub EXT2_DIRENT_TAIL {
        my($block, $blocksize) = @_;
	    eval q((((($block)) + ($blocksize) - $sizeof{\'struct ext2_dir_entry_tail\'})));
    }' unless defined(&EXT2_DIRENT_TAIL);
    if(0) {
	eval 'sub EXT2FS_DIGEST_SIZE () { &EXT2FS_SHA256_LENGTH;}' unless defined(&EXT2FS_DIGEST_SIZE);
    }
    eval 'sub XATTR_HANDLE_FLAG_RAW () {0x1;}' unless defined(&XATTR_HANDLE_FLAG_RAW);
    eval 'sub EXT2_FALLOCATE_ZERO_BLOCKS () {(0x1);}' unless defined(&EXT2_FALLOCATE_ZERO_BLOCKS);
    eval 'sub EXT2_FALLOCATE_FORCE_INIT () {(0x2);}' unless defined(&EXT2_FALLOCATE_FORCE_INIT);
    eval 'sub EXT2_FALLOCATE_FORCE_UNINIT () {(0x4);}' unless defined(&EXT2_FALLOCATE_FORCE_UNINIT);
    eval 'sub EXT2_FALLOCATE_INIT_BEYOND_EOF () {(0x8);}' unless defined(&EXT2_FALLOCATE_INIT_BEYOND_EOF);
    eval 'sub EXT2_FALLOCATE_ALL_FLAGS () {(0xf);}' unless defined(&EXT2_FALLOCATE_ALL_FLAGS);
    eval 'sub EXT2_INODE_SCAN_DEFAULT_BUFFER_BLOCKS () {8;}' unless defined(&EXT2_INODE_SCAN_DEFAULT_BUFFER_BLOCKS);
    eval 'sub EXT2FS_UNLINK_FORCE () {0x1;}' unless defined(&EXT2FS_UNLINK_FORCE);
    eval 'sub EXT2FS_SHA256_LENGTH () {32;}' unless defined(&EXT2FS_SHA256_LENGTH);
    if(0) {
    }
    eval 'sub EXT2FS_SHA512_LENGTH () {64;}' unless defined(&EXT2FS_SHA512_LENGTH);
    if(defined(&NO_INLINE_FUNCS)) {
    }
    if((defined(&INCLUDE_INLINE_FUNCS) || !defined(&NO_INLINE_FUNCS))) {
	if(defined(&INCLUDE_INLINE_FUNCS)) {
	    eval 'sub _INLINE_ () { &extern;}' unless defined(&_INLINE_);
	} else {
	    if(((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : undef) >= 199901)) {
		eval 'sub _INLINE_ () { &inline;}' unless defined(&_INLINE_);
	    } else {
		if(defined(&__GNUC__)) {
		    eval 'sub _INLINE_ () { &extern  &__inline__;}' unless defined(&_INLINE_);
		} else {
		    eval 'sub _INLINE_ () { &extern  &inline;}' unless defined(&_INLINE_);
		}
	    }
	}
	unless(defined(&EXT2_CUSTOM_MEMORY_ROUTINES)) {
	    require 'string.ph';
	}
	undef(&_INLINE_) if defined(&_INLINE_);
    }
    eval 'sub EXT4_HTREE_LEVEL_COMPAT () {2;}' unless defined(&EXT4_HTREE_LEVEL_COMPAT);
    eval 'sub EXT4_HTREE_LEVEL () {3;}' unless defined(&EXT4_HTREE_LEVEL);
    eval 'sub ext2_dir_htree_level {
        my($fs) = @_;
	    eval q({  &if ( &ext2fs_has_feature_largedir( ($fs->{super})))  &EXT4_HTREE_LEVEL;  &EXT4_HTREE_LEVEL_COMPAT; });
    }' unless defined(&ext2_dir_htree_level);
    if(defined(&__cplusplus)) {
    }
}
1;
