require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_CEC_UAPI_H)) {
    eval 'sub _CEC_UAPI_H () {1;}' unless defined(&_CEC_UAPI_H);
    require 'linux/types.ph';
    require 'linux/string.ph';
    eval 'sub CEC_MAX_MSG_SIZE () {16;}' unless defined(&CEC_MAX_MSG_SIZE);
    eval 'sub CEC_MSG_FL_REPLY_TO_FOLLOWERS () {(1<< 0);}' unless defined(&CEC_MSG_FL_REPLY_TO_FOLLOWERS);
    eval 'sub CEC_MSG_FL_RAW () {(1<< 1);}' unless defined(&CEC_MSG_FL_RAW);
    eval 'sub CEC_TX_STATUS_OK () {(1<< 0);}' unless defined(&CEC_TX_STATUS_OK);
    eval 'sub CEC_TX_STATUS_ARB_LOST () {(1<< 1);}' unless defined(&CEC_TX_STATUS_ARB_LOST);
    eval 'sub CEC_TX_STATUS_NACK () {(1<< 2);}' unless defined(&CEC_TX_STATUS_NACK);
    eval 'sub CEC_TX_STATUS_LOW_DRIVE () {(1<< 3);}' unless defined(&CEC_TX_STATUS_LOW_DRIVE);
    eval 'sub CEC_TX_STATUS_ERROR () {(1<< 4);}' unless defined(&CEC_TX_STATUS_ERROR);
    eval 'sub CEC_TX_STATUS_MAX_RETRIES () {(1<< 5);}' unless defined(&CEC_TX_STATUS_MAX_RETRIES);
    eval 'sub CEC_TX_STATUS_ABORTED () {(1<< 6);}' unless defined(&CEC_TX_STATUS_ABORTED);
    eval 'sub CEC_TX_STATUS_TIMEOUT () {(1<< 7);}' unless defined(&CEC_TX_STATUS_TIMEOUT);
    eval 'sub CEC_RX_STATUS_OK () {(1<< 0);}' unless defined(&CEC_RX_STATUS_OK);
    eval 'sub CEC_RX_STATUS_TIMEOUT () {(1<< 1);}' unless defined(&CEC_RX_STATUS_TIMEOUT);
    eval 'sub CEC_RX_STATUS_FEATURE_ABORT () {(1<< 2);}' unless defined(&CEC_RX_STATUS_FEATURE_ABORT);
    eval 'sub CEC_RX_STATUS_ABORTED () {(1<< 3);}' unless defined(&CEC_RX_STATUS_ABORTED);
    eval 'sub cec_msg_status_is_ok {
        my($msg) = @_;
	    eval q({  &if ( ($msg->{tx_status})  && !( ($msg->{tx_status}) &  &CEC_TX_STATUS_OK)) 0;  &if ( ($msg->{rx_status})  && !( ($msg->{rx_status}) &  &CEC_RX_STATUS_OK)) 0;  &if (! ($msg->{tx_status})  && ! ($msg->{rx_status})) 0; !( ($msg->{rx_status}) &  &CEC_RX_STATUS_FEATURE_ABORT); });
    }' unless defined(&cec_msg_status_is_ok);
    eval 'sub CEC_LOG_ADDR_INVALID () {0xff;}' unless defined(&CEC_LOG_ADDR_INVALID);
    eval 'sub CEC_PHYS_ADDR_INVALID () {0xffff;}' unless defined(&CEC_PHYS_ADDR_INVALID);
    eval 'sub CEC_MAX_LOG_ADDRS () {4;}' unless defined(&CEC_MAX_LOG_ADDRS);
    eval 'sub CEC_LOG_ADDR_TV () {0;}' unless defined(&CEC_LOG_ADDR_TV);
    eval 'sub CEC_LOG_ADDR_RECORD_1 () {1;}' unless defined(&CEC_LOG_ADDR_RECORD_1);
    eval 'sub CEC_LOG_ADDR_RECORD_2 () {2;}' unless defined(&CEC_LOG_ADDR_RECORD_2);
    eval 'sub CEC_LOG_ADDR_TUNER_1 () {3;}' unless defined(&CEC_LOG_ADDR_TUNER_1);
    eval 'sub CEC_LOG_ADDR_PLAYBACK_1 () {4;}' unless defined(&CEC_LOG_ADDR_PLAYBACK_1);
    eval 'sub CEC_LOG_ADDR_AUDIOSYSTEM () {5;}' unless defined(&CEC_LOG_ADDR_AUDIOSYSTEM);
    eval 'sub CEC_LOG_ADDR_TUNER_2 () {6;}' unless defined(&CEC_LOG_ADDR_TUNER_2);
    eval 'sub CEC_LOG_ADDR_TUNER_3 () {7;}' unless defined(&CEC_LOG_ADDR_TUNER_3);
    eval 'sub CEC_LOG_ADDR_PLAYBACK_2 () {8;}' unless defined(&CEC_LOG_ADDR_PLAYBACK_2);
    eval 'sub CEC_LOG_ADDR_RECORD_3 () {9;}' unless defined(&CEC_LOG_ADDR_RECORD_3);
    eval 'sub CEC_LOG_ADDR_TUNER_4 () {10;}' unless defined(&CEC_LOG_ADDR_TUNER_4);
    eval 'sub CEC_LOG_ADDR_PLAYBACK_3 () {11;}' unless defined(&CEC_LOG_ADDR_PLAYBACK_3);
    eval 'sub CEC_LOG_ADDR_BACKUP_1 () {12;}' unless defined(&CEC_LOG_ADDR_BACKUP_1);
    eval 'sub CEC_LOG_ADDR_BACKUP_2 () {13;}' unless defined(&CEC_LOG_ADDR_BACKUP_2);
    eval 'sub CEC_LOG_ADDR_SPECIFIC () {14;}' unless defined(&CEC_LOG_ADDR_SPECIFIC);
    eval 'sub CEC_LOG_ADDR_UNREGISTERED () {15;}' unless defined(&CEC_LOG_ADDR_UNREGISTERED);
    eval 'sub CEC_LOG_ADDR_BROADCAST () {15;}' unless defined(&CEC_LOG_ADDR_BROADCAST);
    eval 'sub CEC_LOG_ADDR_TYPE_TV () {0;}' unless defined(&CEC_LOG_ADDR_TYPE_TV);
    eval 'sub CEC_LOG_ADDR_TYPE_RECORD () {1;}' unless defined(&CEC_LOG_ADDR_TYPE_RECORD);
    eval 'sub CEC_LOG_ADDR_TYPE_TUNER () {2;}' unless defined(&CEC_LOG_ADDR_TYPE_TUNER);
    eval 'sub CEC_LOG_ADDR_TYPE_PLAYBACK () {3;}' unless defined(&CEC_LOG_ADDR_TYPE_PLAYBACK);
    eval 'sub CEC_LOG_ADDR_TYPE_AUDIOSYSTEM () {4;}' unless defined(&CEC_LOG_ADDR_TYPE_AUDIOSYSTEM);
    eval 'sub CEC_LOG_ADDR_TYPE_SPECIFIC () {5;}' unless defined(&CEC_LOG_ADDR_TYPE_SPECIFIC);
    eval 'sub CEC_LOG_ADDR_TYPE_UNREGISTERED () {6;}' unless defined(&CEC_LOG_ADDR_TYPE_UNREGISTERED);
    eval 'sub CEC_LOG_ADDR_MASK_TV () {(1<<  &CEC_LOG_ADDR_TV);}' unless defined(&CEC_LOG_ADDR_MASK_TV);
    eval 'sub CEC_LOG_ADDR_MASK_RECORD () {((1<<  &CEC_LOG_ADDR_RECORD_1) | (1<<  &CEC_LOG_ADDR_RECORD_2) | (1<<  &CEC_LOG_ADDR_RECORD_3));}' unless defined(&CEC_LOG_ADDR_MASK_RECORD);
    eval 'sub CEC_LOG_ADDR_MASK_TUNER () {((1<<  &CEC_LOG_ADDR_TUNER_1) | (1<<  &CEC_LOG_ADDR_TUNER_2) | (1<<  &CEC_LOG_ADDR_TUNER_3) | (1<<  &CEC_LOG_ADDR_TUNER_4));}' unless defined(&CEC_LOG_ADDR_MASK_TUNER);
    eval 'sub CEC_LOG_ADDR_MASK_PLAYBACK () {((1<<  &CEC_LOG_ADDR_PLAYBACK_1) | (1<<  &CEC_LOG_ADDR_PLAYBACK_2) | (1<<  &CEC_LOG_ADDR_PLAYBACK_3));}' unless defined(&CEC_LOG_ADDR_MASK_PLAYBACK);
    eval 'sub CEC_LOG_ADDR_MASK_AUDIOSYSTEM () {(1<<  &CEC_LOG_ADDR_AUDIOSYSTEM);}' unless defined(&CEC_LOG_ADDR_MASK_AUDIOSYSTEM);
    eval 'sub CEC_LOG_ADDR_MASK_BACKUP () {((1<<  &CEC_LOG_ADDR_BACKUP_1) | (1<<  &CEC_LOG_ADDR_BACKUP_2));}' unless defined(&CEC_LOG_ADDR_MASK_BACKUP);
    eval 'sub CEC_LOG_ADDR_MASK_SPECIFIC () {(1<<  &CEC_LOG_ADDR_SPECIFIC);}' unless defined(&CEC_LOG_ADDR_MASK_SPECIFIC);
    eval 'sub CEC_LOG_ADDR_MASK_UNREGISTERED () {(1<<  &CEC_LOG_ADDR_UNREGISTERED);}' unless defined(&CEC_LOG_ADDR_MASK_UNREGISTERED);
    eval 'sub cec_has_tv {
        my($log_addr_mask) = @_;
	    eval q({ $log_addr_mask &  &CEC_LOG_ADDR_MASK_TV; });
    }' unless defined(&cec_has_tv);
    eval 'sub cec_has_record {
        my($log_addr_mask) = @_;
	    eval q({ $log_addr_mask &  &CEC_LOG_ADDR_MASK_RECORD; });
    }' unless defined(&cec_has_record);
    eval 'sub cec_has_tuner {
        my($log_addr_mask) = @_;
	    eval q({ $log_addr_mask &  &CEC_LOG_ADDR_MASK_TUNER; });
    }' unless defined(&cec_has_tuner);
    eval 'sub cec_has_playback {
        my($log_addr_mask) = @_;
	    eval q({ $log_addr_mask &  &CEC_LOG_ADDR_MASK_PLAYBACK; });
    }' unless defined(&cec_has_playback);
    eval 'sub cec_has_audiosystem {
        my($log_addr_mask) = @_;
	    eval q({ $log_addr_mask &  &CEC_LOG_ADDR_MASK_AUDIOSYSTEM; });
    }' unless defined(&cec_has_audiosystem);
    eval 'sub cec_has_backup {
        my($log_addr_mask) = @_;
	    eval q({ $log_addr_mask &  &CEC_LOG_ADDR_MASK_BACKUP; });
    }' unless defined(&cec_has_backup);
    eval 'sub cec_has_specific {
        my($log_addr_mask) = @_;
	    eval q({ $log_addr_mask &  &CEC_LOG_ADDR_MASK_SPECIFIC; });
    }' unless defined(&cec_has_specific);
    eval 'sub cec_is_unregistered {
        my($log_addr_mask) = @_;
	    eval q({ $log_addr_mask &  &CEC_LOG_ADDR_MASK_UNREGISTERED; });
    }' unless defined(&cec_is_unregistered);
    eval 'sub cec_is_unconfigured {
        my($log_addr_mask) = @_;
	    eval q({ $log_addr_mask == 0; });
    }' unless defined(&cec_is_unconfigured);
    eval 'sub CEC_VENDOR_ID_NONE () {0xffffffff;}' unless defined(&CEC_VENDOR_ID_NONE);
    eval 'sub CEC_MODE_NO_INITIATOR () {(0x << 0);}' unless defined(&CEC_MODE_NO_INITIATOR);
    eval 'sub CEC_MODE_INITIATOR () {(0x1 << 0);}' unless defined(&CEC_MODE_INITIATOR);
    eval 'sub CEC_MODE_EXCL_INITIATOR () {(0x2 << 0);}' unless defined(&CEC_MODE_EXCL_INITIATOR);
    eval 'sub CEC_MODE_INITIATOR_MSK () {0xf;}' unless defined(&CEC_MODE_INITIATOR_MSK);
    eval 'sub CEC_MODE_NO_FOLLOWER () {(0x << 4);}' unless defined(&CEC_MODE_NO_FOLLOWER);
    eval 'sub CEC_MODE_FOLLOWER () {(0x1 << 4);}' unless defined(&CEC_MODE_FOLLOWER);
    eval 'sub CEC_MODE_EXCL_FOLLOWER () {(0x2 << 4);}' unless defined(&CEC_MODE_EXCL_FOLLOWER);
    eval 'sub CEC_MODE_EXCL_FOLLOWER_PASSTHRU () {(0x3 << 4);}' unless defined(&CEC_MODE_EXCL_FOLLOWER_PASSTHRU);
    eval 'sub CEC_MODE_MONITOR_PIN () {(0xd << 4);}' unless defined(&CEC_MODE_MONITOR_PIN);
    eval 'sub CEC_MODE_MONITOR () {(0xe << 4);}' unless defined(&CEC_MODE_MONITOR);
    eval 'sub CEC_MODE_MONITOR_ALL () {(0xf << 4);}' unless defined(&CEC_MODE_MONITOR_ALL);
    eval 'sub CEC_MODE_FOLLOWER_MSK () {0xf0;}' unless defined(&CEC_MODE_FOLLOWER_MSK);
    eval 'sub CEC_CAP_PHYS_ADDR () {(1<< 0);}' unless defined(&CEC_CAP_PHYS_ADDR);
    eval 'sub CEC_CAP_LOG_ADDRS () {(1<< 1);}' unless defined(&CEC_CAP_LOG_ADDRS);
    eval 'sub CEC_CAP_TRANSMIT () {(1<< 2);}' unless defined(&CEC_CAP_TRANSMIT);
    eval 'sub CEC_CAP_PASSTHROUGH () {(1<< 3);}' unless defined(&CEC_CAP_PASSTHROUGH);
    eval 'sub CEC_CAP_RC () {(1<< 4);}' unless defined(&CEC_CAP_RC);
    eval 'sub CEC_CAP_MONITOR_ALL () {(1<< 5);}' unless defined(&CEC_CAP_MONITOR_ALL);
    eval 'sub CEC_CAP_NEEDS_HPD () {(1<< 6);}' unless defined(&CEC_CAP_NEEDS_HPD);
    eval 'sub CEC_CAP_MONITOR_PIN () {(1<< 7);}' unless defined(&CEC_CAP_MONITOR_PIN);
    eval 'sub CEC_CAP_CONNECTOR_INFO () {(1<< 8);}' unless defined(&CEC_CAP_CONNECTOR_INFO);
    eval 'sub CEC_LOG_ADDRS_FL_ALLOW_UNREG_FALLBACK () {(1<< 0);}' unless defined(&CEC_LOG_ADDRS_FL_ALLOW_UNREG_FALLBACK);
    eval 'sub CEC_LOG_ADDRS_FL_ALLOW_RC_PASSTHRU () {(1<< 1);}' unless defined(&CEC_LOG_ADDRS_FL_ALLOW_RC_PASSTHRU);
    eval 'sub CEC_LOG_ADDRS_FL_CDC_ONLY () {(1<< 2);}' unless defined(&CEC_LOG_ADDRS_FL_CDC_ONLY);
    eval 'sub CEC_CONNECTOR_TYPE_NO_CONNECTOR () {0;}' unless defined(&CEC_CONNECTOR_TYPE_NO_CONNECTOR);
    eval 'sub CEC_CONNECTOR_TYPE_DRM () {1;}' unless defined(&CEC_CONNECTOR_TYPE_DRM);
    eval 'sub CEC_EVENT_STATE_CHANGE () {1;}' unless defined(&CEC_EVENT_STATE_CHANGE);
    eval 'sub CEC_EVENT_LOST_MSGS () {2;}' unless defined(&CEC_EVENT_LOST_MSGS);
    eval 'sub CEC_EVENT_PIN_CEC_LOW () {3;}' unless defined(&CEC_EVENT_PIN_CEC_LOW);
    eval 'sub CEC_EVENT_PIN_CEC_HIGH () {4;}' unless defined(&CEC_EVENT_PIN_CEC_HIGH);
    eval 'sub CEC_EVENT_PIN_HPD_LOW () {5;}' unless defined(&CEC_EVENT_PIN_HPD_LOW);
    eval 'sub CEC_EVENT_PIN_HPD_HIGH () {6;}' unless defined(&CEC_EVENT_PIN_HPD_HIGH);
    eval 'sub CEC_EVENT_PIN_5V_LOW () {7;}' unless defined(&CEC_EVENT_PIN_5V_LOW);
    eval 'sub CEC_EVENT_PIN_5V_HIGH () {8;}' unless defined(&CEC_EVENT_PIN_5V_HIGH);
    eval 'sub CEC_EVENT_FL_INITIAL_STATE () {(1<< 0);}' unless defined(&CEC_EVENT_FL_INITIAL_STATE);
    eval 'sub CEC_EVENT_FL_DROPPED_EVENTS () {(1<< 1);}' unless defined(&CEC_EVENT_FL_DROPPED_EVENTS);
    eval 'sub CEC_ADAP_G_CAPS () { &_IOWR(ord(\'a\'), 0, \'struct cec_caps\');}' unless defined(&CEC_ADAP_G_CAPS);
    eval 'sub CEC_ADAP_G_PHYS_ADDR () { &_IOR(ord(\'a\'), 1,  &__u16);}' unless defined(&CEC_ADAP_G_PHYS_ADDR);
    eval 'sub CEC_ADAP_S_PHYS_ADDR () { &_IOW(ord(\'a\'), 2,  &__u16);}' unless defined(&CEC_ADAP_S_PHYS_ADDR);
    eval 'sub CEC_ADAP_G_LOG_ADDRS () { &_IOR(ord(\'a\'), 3, \'struct cec_log_addrs\');}' unless defined(&CEC_ADAP_G_LOG_ADDRS);
    eval 'sub CEC_ADAP_S_LOG_ADDRS () { &_IOWR(ord(\'a\'), 4, \'struct cec_log_addrs\');}' unless defined(&CEC_ADAP_S_LOG_ADDRS);
    eval 'sub CEC_TRANSMIT () { &_IOWR(ord(\'a\'), 5, \'struct cec_msg\');}' unless defined(&CEC_TRANSMIT);
    eval 'sub CEC_RECEIVE () { &_IOWR(ord(\'a\'), 6, \'struct cec_msg\');}' unless defined(&CEC_RECEIVE);
    eval 'sub CEC_DQEVENT () { &_IOWR(ord(\'a\'), 7, \'struct cec_event\');}' unless defined(&CEC_DQEVENT);
    eval 'sub CEC_G_MODE () { &_IOR(ord(\'a\'), 8,  &__u32);}' unless defined(&CEC_G_MODE);
    eval 'sub CEC_S_MODE () { &_IOW(ord(\'a\'), 9,  &__u32);}' unless defined(&CEC_S_MODE);
    eval 'sub CEC_ADAP_G_CONNECTOR_INFO () { &_IOR(ord(\'a\'), 10, \'struct cec_connector_info\');}' unless defined(&CEC_ADAP_G_CONNECTOR_INFO);
    eval 'sub CEC_MSG_ACTIVE_SOURCE () {0x82;}' unless defined(&CEC_MSG_ACTIVE_SOURCE);
    eval 'sub CEC_MSG_IMAGE_VIEW_ON () {0x4;}' unless defined(&CEC_MSG_IMAGE_VIEW_ON);
    eval 'sub CEC_MSG_TEXT_VIEW_ON () {0xd;}' unless defined(&CEC_MSG_TEXT_VIEW_ON);
    eval 'sub CEC_MSG_INACTIVE_SOURCE () {0x9d;}' unless defined(&CEC_MSG_INACTIVE_SOURCE);
    eval 'sub CEC_MSG_REQUEST_ACTIVE_SOURCE () {0x85;}' unless defined(&CEC_MSG_REQUEST_ACTIVE_SOURCE);
    eval 'sub CEC_MSG_ROUTING_CHANGE () {0x80;}' unless defined(&CEC_MSG_ROUTING_CHANGE);
    eval 'sub CEC_MSG_ROUTING_INFORMATION () {0x81;}' unless defined(&CEC_MSG_ROUTING_INFORMATION);
    eval 'sub CEC_MSG_SET_STREAM_PATH () {0x86;}' unless defined(&CEC_MSG_SET_STREAM_PATH);
    eval 'sub CEC_MSG_STANDBY () {0x36;}' unless defined(&CEC_MSG_STANDBY);
    eval 'sub CEC_MSG_RECORD_OFF () {0xb;}' unless defined(&CEC_MSG_RECORD_OFF);
    eval 'sub CEC_MSG_RECORD_ON () {0x9;}' unless defined(&CEC_MSG_RECORD_ON);
    eval 'sub CEC_OP_RECORD_SRC_OWN () {1;}' unless defined(&CEC_OP_RECORD_SRC_OWN);
    eval 'sub CEC_OP_RECORD_SRC_DIGITAL () {2;}' unless defined(&CEC_OP_RECORD_SRC_DIGITAL);
    eval 'sub CEC_OP_RECORD_SRC_ANALOG () {3;}' unless defined(&CEC_OP_RECORD_SRC_ANALOG);
    eval 'sub CEC_OP_RECORD_SRC_EXT_PLUG () {4;}' unless defined(&CEC_OP_RECORD_SRC_EXT_PLUG);
    eval 'sub CEC_OP_RECORD_SRC_EXT_PHYS_ADDR () {5;}' unless defined(&CEC_OP_RECORD_SRC_EXT_PHYS_ADDR);
    eval 'sub CEC_OP_SERVICE_ID_METHOD_BY_DIG_ID () {0;}' unless defined(&CEC_OP_SERVICE_ID_METHOD_BY_DIG_ID);
    eval 'sub CEC_OP_SERVICE_ID_METHOD_BY_CHANNEL () {1;}' unless defined(&CEC_OP_SERVICE_ID_METHOD_BY_CHANNEL);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ARIB_GEN () {0x;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ARIB_GEN);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_GEN () {0x1;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_GEN);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_GEN () {0x2;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_GEN);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ARIB_BS () {0x8;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ARIB_BS);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ARIB_CS () {0x9;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ARIB_CS);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ARIB_T () {0xa;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ARIB_T);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_CABLE () {0x10;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_CABLE);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_SAT () {0x11;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_SAT);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_T () {0x12;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_ATSC_T);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_C () {0x18;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_C);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_S () {0x19;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_S);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_S2 () {0x1a;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_S2);
    eval 'sub CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_T () {0x1b;}' unless defined(&CEC_OP_DIG_SERVICE_BCAST_SYSTEM_DVB_T);
    eval 'sub CEC_OP_ANA_BCAST_TYPE_CABLE () {0;}' unless defined(&CEC_OP_ANA_BCAST_TYPE_CABLE);
    eval 'sub CEC_OP_ANA_BCAST_TYPE_SATELLITE () {1;}' unless defined(&CEC_OP_ANA_BCAST_TYPE_SATELLITE);
    eval 'sub CEC_OP_ANA_BCAST_TYPE_TERRESTRIAL () {2;}' unless defined(&CEC_OP_ANA_BCAST_TYPE_TERRESTRIAL);
    eval 'sub CEC_OP_BCAST_SYSTEM_PAL_BG () {0x;}' unless defined(&CEC_OP_BCAST_SYSTEM_PAL_BG);
    eval 'sub CEC_OP_BCAST_SYSTEM_SECAM_LQ () {0x1;}' unless defined(&CEC_OP_BCAST_SYSTEM_SECAM_LQ);
    eval 'sub CEC_OP_BCAST_SYSTEM_PAL_M () {0x2;}' unless defined(&CEC_OP_BCAST_SYSTEM_PAL_M);
    eval 'sub CEC_OP_BCAST_SYSTEM_NTSC_M () {0x3;}' unless defined(&CEC_OP_BCAST_SYSTEM_NTSC_M);
    eval 'sub CEC_OP_BCAST_SYSTEM_PAL_I () {0x4;}' unless defined(&CEC_OP_BCAST_SYSTEM_PAL_I);
    eval 'sub CEC_OP_BCAST_SYSTEM_SECAM_DK () {0x5;}' unless defined(&CEC_OP_BCAST_SYSTEM_SECAM_DK);
    eval 'sub CEC_OP_BCAST_SYSTEM_SECAM_BG () {0x6;}' unless defined(&CEC_OP_BCAST_SYSTEM_SECAM_BG);
    eval 'sub CEC_OP_BCAST_SYSTEM_SECAM_L () {0x7;}' unless defined(&CEC_OP_BCAST_SYSTEM_SECAM_L);
    eval 'sub CEC_OP_BCAST_SYSTEM_PAL_DK () {0x8;}' unless defined(&CEC_OP_BCAST_SYSTEM_PAL_DK);
    eval 'sub CEC_OP_BCAST_SYSTEM_OTHER () {0x1f;}' unless defined(&CEC_OP_BCAST_SYSTEM_OTHER);
    eval 'sub CEC_OP_CHANNEL_NUMBER_FMT_1_PART () {0x1;}' unless defined(&CEC_OP_CHANNEL_NUMBER_FMT_1_PART);
    eval 'sub CEC_OP_CHANNEL_NUMBER_FMT_2_PART () {0x2;}' unless defined(&CEC_OP_CHANNEL_NUMBER_FMT_2_PART);
    eval 'sub CEC_MSG_RECORD_STATUS () {0xa;}' unless defined(&CEC_MSG_RECORD_STATUS);
    eval 'sub CEC_OP_RECORD_STATUS_CUR_SRC () {0x1;}' unless defined(&CEC_OP_RECORD_STATUS_CUR_SRC);
    eval 'sub CEC_OP_RECORD_STATUS_DIG_SERVICE () {0x2;}' unless defined(&CEC_OP_RECORD_STATUS_DIG_SERVICE);
    eval 'sub CEC_OP_RECORD_STATUS_ANA_SERVICE () {0x3;}' unless defined(&CEC_OP_RECORD_STATUS_ANA_SERVICE);
    eval 'sub CEC_OP_RECORD_STATUS_EXT_INPUT () {0x4;}' unless defined(&CEC_OP_RECORD_STATUS_EXT_INPUT);
    eval 'sub CEC_OP_RECORD_STATUS_NO_DIG_SERVICE () {0x5;}' unless defined(&CEC_OP_RECORD_STATUS_NO_DIG_SERVICE);
    eval 'sub CEC_OP_RECORD_STATUS_NO_ANA_SERVICE () {0x6;}' unless defined(&CEC_OP_RECORD_STATUS_NO_ANA_SERVICE);
    eval 'sub CEC_OP_RECORD_STATUS_NO_SERVICE () {0x7;}' unless defined(&CEC_OP_RECORD_STATUS_NO_SERVICE);
    eval 'sub CEC_OP_RECORD_STATUS_INVALID_EXT_PLUG () {0x9;}' unless defined(&CEC_OP_RECORD_STATUS_INVALID_EXT_PLUG);
    eval 'sub CEC_OP_RECORD_STATUS_INVALID_EXT_PHYS_ADDR () {0xa;}' unless defined(&CEC_OP_RECORD_STATUS_INVALID_EXT_PHYS_ADDR);
    eval 'sub CEC_OP_RECORD_STATUS_UNSUP_CA () {0xb;}' unless defined(&CEC_OP_RECORD_STATUS_UNSUP_CA);
    eval 'sub CEC_OP_RECORD_STATUS_NO_CA_ENTITLEMENTS () {0xc;}' unless defined(&CEC_OP_RECORD_STATUS_NO_CA_ENTITLEMENTS);
    eval 'sub CEC_OP_RECORD_STATUS_CANT_COPY_SRC () {0xd;}' unless defined(&CEC_OP_RECORD_STATUS_CANT_COPY_SRC);
    eval 'sub CEC_OP_RECORD_STATUS_NO_MORE_COPIES () {0xe;}' unless defined(&CEC_OP_RECORD_STATUS_NO_MORE_COPIES);
    eval 'sub CEC_OP_RECORD_STATUS_NO_MEDIA () {0x10;}' unless defined(&CEC_OP_RECORD_STATUS_NO_MEDIA);
    eval 'sub CEC_OP_RECORD_STATUS_PLAYING () {0x11;}' unless defined(&CEC_OP_RECORD_STATUS_PLAYING);
    eval 'sub CEC_OP_RECORD_STATUS_ALREADY_RECORDING () {0x12;}' unless defined(&CEC_OP_RECORD_STATUS_ALREADY_RECORDING);
    eval 'sub CEC_OP_RECORD_STATUS_MEDIA_PROT () {0x13;}' unless defined(&CEC_OP_RECORD_STATUS_MEDIA_PROT);
    eval 'sub CEC_OP_RECORD_STATUS_NO_SIGNAL () {0x14;}' unless defined(&CEC_OP_RECORD_STATUS_NO_SIGNAL);
    eval 'sub CEC_OP_RECORD_STATUS_MEDIA_PROBLEM () {0x15;}' unless defined(&CEC_OP_RECORD_STATUS_MEDIA_PROBLEM);
    eval 'sub CEC_OP_RECORD_STATUS_NO_SPACE () {0x16;}' unless defined(&CEC_OP_RECORD_STATUS_NO_SPACE);
    eval 'sub CEC_OP_RECORD_STATUS_PARENTAL_LOCK () {0x17;}' unless defined(&CEC_OP_RECORD_STATUS_PARENTAL_LOCK);
    eval 'sub CEC_OP_RECORD_STATUS_TERMINATED_OK () {0x1a;}' unless defined(&CEC_OP_RECORD_STATUS_TERMINATED_OK);
    eval 'sub CEC_OP_RECORD_STATUS_ALREADY_TERM () {0x1b;}' unless defined(&CEC_OP_RECORD_STATUS_ALREADY_TERM);
    eval 'sub CEC_OP_RECORD_STATUS_OTHER () {0x1f;}' unless defined(&CEC_OP_RECORD_STATUS_OTHER);
    eval 'sub CEC_MSG_RECORD_TV_SCREEN () {0xf;}' unless defined(&CEC_MSG_RECORD_TV_SCREEN);
    eval 'sub CEC_MSG_CLEAR_ANALOGUE_TIMER () {0x33;}' unless defined(&CEC_MSG_CLEAR_ANALOGUE_TIMER);
    eval 'sub CEC_OP_REC_SEQ_SUNDAY () {0x1;}' unless defined(&CEC_OP_REC_SEQ_SUNDAY);
    eval 'sub CEC_OP_REC_SEQ_MONDAY () {0x2;}' unless defined(&CEC_OP_REC_SEQ_MONDAY);
    eval 'sub CEC_OP_REC_SEQ_TUESDAY () {0x4;}' unless defined(&CEC_OP_REC_SEQ_TUESDAY);
    eval 'sub CEC_OP_REC_SEQ_WEDNESDAY () {0x8;}' unless defined(&CEC_OP_REC_SEQ_WEDNESDAY);
    eval 'sub CEC_OP_REC_SEQ_THURSDAY () {0x10;}' unless defined(&CEC_OP_REC_SEQ_THURSDAY);
    eval 'sub CEC_OP_REC_SEQ_FRIDAY () {0x20;}' unless defined(&CEC_OP_REC_SEQ_FRIDAY);
    eval 'sub CEC_OP_REC_SEQ_SATURDAY () {0x40;}' unless defined(&CEC_OP_REC_SEQ_SATURDAY);
    eval 'sub CEC_OP_REC_SEQ_ONCE_ONLY () {0x;}' unless defined(&CEC_OP_REC_SEQ_ONCE_ONLY);
    eval 'sub CEC_MSG_CLEAR_DIGITAL_TIMER () {0x99;}' unless defined(&CEC_MSG_CLEAR_DIGITAL_TIMER);
    eval 'sub CEC_MSG_CLEAR_EXT_TIMER () {0xa1;}' unless defined(&CEC_MSG_CLEAR_EXT_TIMER);
    eval 'sub CEC_OP_EXT_SRC_PLUG () {0x4;}' unless defined(&CEC_OP_EXT_SRC_PLUG);
    eval 'sub CEC_OP_EXT_SRC_PHYS_ADDR () {0x5;}' unless defined(&CEC_OP_EXT_SRC_PHYS_ADDR);
    eval 'sub CEC_MSG_SET_ANALOGUE_TIMER () {0x34;}' unless defined(&CEC_MSG_SET_ANALOGUE_TIMER);
    eval 'sub CEC_MSG_SET_DIGITAL_TIMER () {0x97;}' unless defined(&CEC_MSG_SET_DIGITAL_TIMER);
    eval 'sub CEC_MSG_SET_EXT_TIMER () {0xa2;}' unless defined(&CEC_MSG_SET_EXT_TIMER);
    eval 'sub CEC_MSG_SET_TIMER_PROGRAM_TITLE () {0x67;}' unless defined(&CEC_MSG_SET_TIMER_PROGRAM_TITLE);
    eval 'sub CEC_MSG_TIMER_CLEARED_STATUS () {0x43;}' unless defined(&CEC_MSG_TIMER_CLEARED_STATUS);
    eval 'sub CEC_OP_TIMER_CLR_STAT_RECORDING () {0x;}' unless defined(&CEC_OP_TIMER_CLR_STAT_RECORDING);
    eval 'sub CEC_OP_TIMER_CLR_STAT_NO_MATCHING () {0x1;}' unless defined(&CEC_OP_TIMER_CLR_STAT_NO_MATCHING);
    eval 'sub CEC_OP_TIMER_CLR_STAT_NO_INFO () {0x2;}' unless defined(&CEC_OP_TIMER_CLR_STAT_NO_INFO);
    eval 'sub CEC_OP_TIMER_CLR_STAT_CLEARED () {0x80;}' unless defined(&CEC_OP_TIMER_CLR_STAT_CLEARED);
    eval 'sub CEC_MSG_TIMER_STATUS () {0x35;}' unless defined(&CEC_MSG_TIMER_STATUS);
    eval 'sub CEC_OP_TIMER_OVERLAP_WARNING_NO_OVERLAP () {0;}' unless defined(&CEC_OP_TIMER_OVERLAP_WARNING_NO_OVERLAP);
    eval 'sub CEC_OP_TIMER_OVERLAP_WARNING_OVERLAP () {1;}' unless defined(&CEC_OP_TIMER_OVERLAP_WARNING_OVERLAP);
    eval 'sub CEC_OP_MEDIA_INFO_UNPROT_MEDIA () {0;}' unless defined(&CEC_OP_MEDIA_INFO_UNPROT_MEDIA);
    eval 'sub CEC_OP_MEDIA_INFO_PROT_MEDIA () {1;}' unless defined(&CEC_OP_MEDIA_INFO_PROT_MEDIA);
    eval 'sub CEC_OP_MEDIA_INFO_NO_MEDIA () {2;}' unless defined(&CEC_OP_MEDIA_INFO_NO_MEDIA);
    eval 'sub CEC_OP_PROG_IND_NOT_PROGRAMMED () {0;}' unless defined(&CEC_OP_PROG_IND_NOT_PROGRAMMED);
    eval 'sub CEC_OP_PROG_IND_PROGRAMMED () {1;}' unless defined(&CEC_OP_PROG_IND_PROGRAMMED);
    eval 'sub CEC_OP_PROG_INFO_ENOUGH_SPACE () {0x8;}' unless defined(&CEC_OP_PROG_INFO_ENOUGH_SPACE);
    eval 'sub CEC_OP_PROG_INFO_NOT_ENOUGH_SPACE () {0x9;}' unless defined(&CEC_OP_PROG_INFO_NOT_ENOUGH_SPACE);
    eval 'sub CEC_OP_PROG_INFO_MIGHT_NOT_BE_ENOUGH_SPACE () {0xb;}' unless defined(&CEC_OP_PROG_INFO_MIGHT_NOT_BE_ENOUGH_SPACE);
    eval 'sub CEC_OP_PROG_INFO_NONE_AVAILABLE () {0xa;}' unless defined(&CEC_OP_PROG_INFO_NONE_AVAILABLE);
    eval 'sub CEC_OP_PROG_ERROR_NO_FREE_TIMER () {0x1;}' unless defined(&CEC_OP_PROG_ERROR_NO_FREE_TIMER);
    eval 'sub CEC_OP_PROG_ERROR_DATE_OUT_OF_RANGE () {0x2;}' unless defined(&CEC_OP_PROG_ERROR_DATE_OUT_OF_RANGE);
    eval 'sub CEC_OP_PROG_ERROR_REC_SEQ_ERROR () {0x3;}' unless defined(&CEC_OP_PROG_ERROR_REC_SEQ_ERROR);
    eval 'sub CEC_OP_PROG_ERROR_INV_EXT_PLUG () {0x4;}' unless defined(&CEC_OP_PROG_ERROR_INV_EXT_PLUG);
    eval 'sub CEC_OP_PROG_ERROR_INV_EXT_PHYS_ADDR () {0x5;}' unless defined(&CEC_OP_PROG_ERROR_INV_EXT_PHYS_ADDR);
    eval 'sub CEC_OP_PROG_ERROR_CA_UNSUPP () {0x6;}' unless defined(&CEC_OP_PROG_ERROR_CA_UNSUPP);
    eval 'sub CEC_OP_PROG_ERROR_INSUF_CA_ENTITLEMENTS () {0x7;}' unless defined(&CEC_OP_PROG_ERROR_INSUF_CA_ENTITLEMENTS);
    eval 'sub CEC_OP_PROG_ERROR_RESOLUTION_UNSUPP () {0x8;}' unless defined(&CEC_OP_PROG_ERROR_RESOLUTION_UNSUPP);
    eval 'sub CEC_OP_PROG_ERROR_PARENTAL_LOCK () {0x9;}' unless defined(&CEC_OP_PROG_ERROR_PARENTAL_LOCK);
    eval 'sub CEC_OP_PROG_ERROR_CLOCK_FAILURE () {0xa;}' unless defined(&CEC_OP_PROG_ERROR_CLOCK_FAILURE);
    eval 'sub CEC_OP_PROG_ERROR_DUPLICATE () {0xe;}' unless defined(&CEC_OP_PROG_ERROR_DUPLICATE);
    eval 'sub CEC_MSG_CEC_VERSION () {0x9e;}' unless defined(&CEC_MSG_CEC_VERSION);
    eval 'sub CEC_OP_CEC_VERSION_1_3A () {4;}' unless defined(&CEC_OP_CEC_VERSION_1_3A);
    eval 'sub CEC_OP_CEC_VERSION_1_4 () {5;}' unless defined(&CEC_OP_CEC_VERSION_1_4);
    eval 'sub CEC_OP_CEC_VERSION_2_0 () {6;}' unless defined(&CEC_OP_CEC_VERSION_2_0);
    eval 'sub CEC_MSG_GET_CEC_VERSION () {0x9f;}' unless defined(&CEC_MSG_GET_CEC_VERSION);
    eval 'sub CEC_MSG_GIVE_PHYSICAL_ADDR () {0x83;}' unless defined(&CEC_MSG_GIVE_PHYSICAL_ADDR);
    eval 'sub CEC_MSG_GET_MENU_LANGUAGE () {0x91;}' unless defined(&CEC_MSG_GET_MENU_LANGUAGE);
    eval 'sub CEC_MSG_REPORT_PHYSICAL_ADDR () {0x84;}' unless defined(&CEC_MSG_REPORT_PHYSICAL_ADDR);
    eval 'sub CEC_OP_PRIM_DEVTYPE_TV () {0;}' unless defined(&CEC_OP_PRIM_DEVTYPE_TV);
    eval 'sub CEC_OP_PRIM_DEVTYPE_RECORD () {1;}' unless defined(&CEC_OP_PRIM_DEVTYPE_RECORD);
    eval 'sub CEC_OP_PRIM_DEVTYPE_TUNER () {3;}' unless defined(&CEC_OP_PRIM_DEVTYPE_TUNER);
    eval 'sub CEC_OP_PRIM_DEVTYPE_PLAYBACK () {4;}' unless defined(&CEC_OP_PRIM_DEVTYPE_PLAYBACK);
    eval 'sub CEC_OP_PRIM_DEVTYPE_AUDIOSYSTEM () {5;}' unless defined(&CEC_OP_PRIM_DEVTYPE_AUDIOSYSTEM);
    eval 'sub CEC_OP_PRIM_DEVTYPE_SWITCH () {6;}' unless defined(&CEC_OP_PRIM_DEVTYPE_SWITCH);
    eval 'sub CEC_OP_PRIM_DEVTYPE_PROCESSOR () {7;}' unless defined(&CEC_OP_PRIM_DEVTYPE_PROCESSOR);
    eval 'sub CEC_MSG_SET_MENU_LANGUAGE () {0x32;}' unless defined(&CEC_MSG_SET_MENU_LANGUAGE);
    eval 'sub CEC_MSG_REPORT_FEATURES () {0xa6;}' unless defined(&CEC_MSG_REPORT_FEATURES);
    eval 'sub CEC_OP_ALL_DEVTYPE_TV () {0x80;}' unless defined(&CEC_OP_ALL_DEVTYPE_TV);
    eval 'sub CEC_OP_ALL_DEVTYPE_RECORD () {0x40;}' unless defined(&CEC_OP_ALL_DEVTYPE_RECORD);
    eval 'sub CEC_OP_ALL_DEVTYPE_TUNER () {0x20;}' unless defined(&CEC_OP_ALL_DEVTYPE_TUNER);
    eval 'sub CEC_OP_ALL_DEVTYPE_PLAYBACK () {0x10;}' unless defined(&CEC_OP_ALL_DEVTYPE_PLAYBACK);
    eval 'sub CEC_OP_ALL_DEVTYPE_AUDIOSYSTEM () {0x8;}' unless defined(&CEC_OP_ALL_DEVTYPE_AUDIOSYSTEM);
    eval 'sub CEC_OP_ALL_DEVTYPE_SWITCH () {0x4;}' unless defined(&CEC_OP_ALL_DEVTYPE_SWITCH);
    eval 'sub CEC_OP_FEAT_EXT () {0x80;}' unless defined(&CEC_OP_FEAT_EXT);
    eval 'sub CEC_OP_FEAT_RC_TV_PROFILE_NONE () {0x;}' unless defined(&CEC_OP_FEAT_RC_TV_PROFILE_NONE);
    eval 'sub CEC_OP_FEAT_RC_TV_PROFILE_1 () {0x2;}' unless defined(&CEC_OP_FEAT_RC_TV_PROFILE_1);
    eval 'sub CEC_OP_FEAT_RC_TV_PROFILE_2 () {0x6;}' unless defined(&CEC_OP_FEAT_RC_TV_PROFILE_2);
    eval 'sub CEC_OP_FEAT_RC_TV_PROFILE_3 () {0xa;}' unless defined(&CEC_OP_FEAT_RC_TV_PROFILE_3);
    eval 'sub CEC_OP_FEAT_RC_TV_PROFILE_4 () {0xe;}' unless defined(&CEC_OP_FEAT_RC_TV_PROFILE_4);
    eval 'sub CEC_OP_FEAT_RC_SRC_HAS_DEV_ROOT_MENU () {0x50;}' unless defined(&CEC_OP_FEAT_RC_SRC_HAS_DEV_ROOT_MENU);
    eval 'sub CEC_OP_FEAT_RC_SRC_HAS_DEV_SETUP_MENU () {0x48;}' unless defined(&CEC_OP_FEAT_RC_SRC_HAS_DEV_SETUP_MENU);
    eval 'sub CEC_OP_FEAT_RC_SRC_HAS_CONTENTS_MENU () {0x44;}' unless defined(&CEC_OP_FEAT_RC_SRC_HAS_CONTENTS_MENU);
    eval 'sub CEC_OP_FEAT_RC_SRC_HAS_MEDIA_TOP_MENU () {0x42;}' unless defined(&CEC_OP_FEAT_RC_SRC_HAS_MEDIA_TOP_MENU);
    eval 'sub CEC_OP_FEAT_RC_SRC_HAS_MEDIA_CONTEXT_MENU () {0x41;}' unless defined(&CEC_OP_FEAT_RC_SRC_HAS_MEDIA_CONTEXT_MENU);
    eval 'sub CEC_OP_FEAT_DEV_HAS_RECORD_TV_SCREEN () {0x40;}' unless defined(&CEC_OP_FEAT_DEV_HAS_RECORD_TV_SCREEN);
    eval 'sub CEC_OP_FEAT_DEV_HAS_SET_OSD_STRING () {0x20;}' unless defined(&CEC_OP_FEAT_DEV_HAS_SET_OSD_STRING);
    eval 'sub CEC_OP_FEAT_DEV_HAS_DECK_CONTROL () {0x10;}' unless defined(&CEC_OP_FEAT_DEV_HAS_DECK_CONTROL);
    eval 'sub CEC_OP_FEAT_DEV_HAS_SET_AUDIO_RATE () {0x8;}' unless defined(&CEC_OP_FEAT_DEV_HAS_SET_AUDIO_RATE);
    eval 'sub CEC_OP_FEAT_DEV_SINK_HAS_ARC_TX () {0x4;}' unless defined(&CEC_OP_FEAT_DEV_SINK_HAS_ARC_TX);
    eval 'sub CEC_OP_FEAT_DEV_SOURCE_HAS_ARC_RX () {0x2;}' unless defined(&CEC_OP_FEAT_DEV_SOURCE_HAS_ARC_RX);
    eval 'sub CEC_MSG_GIVE_FEATURES () {0xa5;}' unless defined(&CEC_MSG_GIVE_FEATURES);
    eval 'sub CEC_MSG_DECK_CONTROL () {0x42;}' unless defined(&CEC_MSG_DECK_CONTROL);
    eval 'sub CEC_OP_DECK_CTL_MODE_SKIP_FWD () {1;}' unless defined(&CEC_OP_DECK_CTL_MODE_SKIP_FWD);
    eval 'sub CEC_OP_DECK_CTL_MODE_SKIP_REV () {2;}' unless defined(&CEC_OP_DECK_CTL_MODE_SKIP_REV);
    eval 'sub CEC_OP_DECK_CTL_MODE_STOP () {3;}' unless defined(&CEC_OP_DECK_CTL_MODE_STOP);
    eval 'sub CEC_OP_DECK_CTL_MODE_EJECT () {4;}' unless defined(&CEC_OP_DECK_CTL_MODE_EJECT);
    eval 'sub CEC_MSG_DECK_STATUS () {0x1b;}' unless defined(&CEC_MSG_DECK_STATUS);
    eval 'sub CEC_OP_DECK_INFO_PLAY () {0x11;}' unless defined(&CEC_OP_DECK_INFO_PLAY);
    eval 'sub CEC_OP_DECK_INFO_RECORD () {0x12;}' unless defined(&CEC_OP_DECK_INFO_RECORD);
    eval 'sub CEC_OP_DECK_INFO_PLAY_REV () {0x13;}' unless defined(&CEC_OP_DECK_INFO_PLAY_REV);
    eval 'sub CEC_OP_DECK_INFO_STILL () {0x14;}' unless defined(&CEC_OP_DECK_INFO_STILL);
    eval 'sub CEC_OP_DECK_INFO_SLOW () {0x15;}' unless defined(&CEC_OP_DECK_INFO_SLOW);
    eval 'sub CEC_OP_DECK_INFO_SLOW_REV () {0x16;}' unless defined(&CEC_OP_DECK_INFO_SLOW_REV);
    eval 'sub CEC_OP_DECK_INFO_FAST_FWD () {0x17;}' unless defined(&CEC_OP_DECK_INFO_FAST_FWD);
    eval 'sub CEC_OP_DECK_INFO_FAST_REV () {0x18;}' unless defined(&CEC_OP_DECK_INFO_FAST_REV);
    eval 'sub CEC_OP_DECK_INFO_NO_MEDIA () {0x19;}' unless defined(&CEC_OP_DECK_INFO_NO_MEDIA);
    eval 'sub CEC_OP_DECK_INFO_STOP () {0x1a;}' unless defined(&CEC_OP_DECK_INFO_STOP);
    eval 'sub CEC_OP_DECK_INFO_SKIP_FWD () {0x1b;}' unless defined(&CEC_OP_DECK_INFO_SKIP_FWD);
    eval 'sub CEC_OP_DECK_INFO_SKIP_REV () {0x1c;}' unless defined(&CEC_OP_DECK_INFO_SKIP_REV);
    eval 'sub CEC_OP_DECK_INFO_INDEX_SEARCH_FWD () {0x1d;}' unless defined(&CEC_OP_DECK_INFO_INDEX_SEARCH_FWD);
    eval 'sub CEC_OP_DECK_INFO_INDEX_SEARCH_REV () {0x1e;}' unless defined(&CEC_OP_DECK_INFO_INDEX_SEARCH_REV);
    eval 'sub CEC_OP_DECK_INFO_OTHER () {0x1f;}' unless defined(&CEC_OP_DECK_INFO_OTHER);
    eval 'sub CEC_MSG_GIVE_DECK_STATUS () {0x1a;}' unless defined(&CEC_MSG_GIVE_DECK_STATUS);
    eval 'sub CEC_OP_STATUS_REQ_ON () {1;}' unless defined(&CEC_OP_STATUS_REQ_ON);
    eval 'sub CEC_OP_STATUS_REQ_OFF () {2;}' unless defined(&CEC_OP_STATUS_REQ_OFF);
    eval 'sub CEC_OP_STATUS_REQ_ONCE () {3;}' unless defined(&CEC_OP_STATUS_REQ_ONCE);
    eval 'sub CEC_MSG_PLAY () {0x41;}' unless defined(&CEC_MSG_PLAY);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_FWD () {0x24;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_FWD);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_REV () {0x20;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_REV);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_STILL () {0x25;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_STILL);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_FAST_FWD_MIN () {0x5;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_FAST_FWD_MIN);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_FAST_FWD_MED () {0x6;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_FAST_FWD_MED);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_FAST_FWD_MAX () {0x7;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_FAST_FWD_MAX);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_FAST_REV_MIN () {0x9;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_FAST_REV_MIN);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_FAST_REV_MED () {0xa;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_FAST_REV_MED);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_FAST_REV_MAX () {0xb;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_FAST_REV_MAX);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_SLOW_FWD_MIN () {0x15;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_SLOW_FWD_MIN);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_SLOW_FWD_MED () {0x16;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_SLOW_FWD_MED);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_SLOW_FWD_MAX () {0x17;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_SLOW_FWD_MAX);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_SLOW_REV_MIN () {0x19;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_SLOW_REV_MIN);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_SLOW_REV_MED () {0x1a;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_SLOW_REV_MED);
    eval 'sub CEC_OP_PLAY_MODE_PLAY_SLOW_REV_MAX () {0x1b;}' unless defined(&CEC_OP_PLAY_MODE_PLAY_SLOW_REV_MAX);
    eval 'sub CEC_MSG_GIVE_TUNER_DEVICE_STATUS () {0x8;}' unless defined(&CEC_MSG_GIVE_TUNER_DEVICE_STATUS);
    eval 'sub CEC_MSG_SELECT_ANALOGUE_SERVICE () {0x92;}' unless defined(&CEC_MSG_SELECT_ANALOGUE_SERVICE);
    eval 'sub CEC_MSG_SELECT_DIGITAL_SERVICE () {0x93;}' unless defined(&CEC_MSG_SELECT_DIGITAL_SERVICE);
    eval 'sub CEC_MSG_TUNER_DEVICE_STATUS () {0x7;}' unless defined(&CEC_MSG_TUNER_DEVICE_STATUS);
    eval 'sub CEC_OP_REC_FLAG_NOT_USED () {0;}' unless defined(&CEC_OP_REC_FLAG_NOT_USED);
    eval 'sub CEC_OP_REC_FLAG_USED () {1;}' unless defined(&CEC_OP_REC_FLAG_USED);
    eval 'sub CEC_OP_TUNER_DISPLAY_INFO_DIGITAL () {0;}' unless defined(&CEC_OP_TUNER_DISPLAY_INFO_DIGITAL);
    eval 'sub CEC_OP_TUNER_DISPLAY_INFO_NONE () {1;}' unless defined(&CEC_OP_TUNER_DISPLAY_INFO_NONE);
    eval 'sub CEC_OP_TUNER_DISPLAY_INFO_ANALOGUE () {2;}' unless defined(&CEC_OP_TUNER_DISPLAY_INFO_ANALOGUE);
    eval 'sub CEC_MSG_TUNER_STEP_DECREMENT () {0x6;}' unless defined(&CEC_MSG_TUNER_STEP_DECREMENT);
    eval 'sub CEC_MSG_TUNER_STEP_INCREMENT () {0x5;}' unless defined(&CEC_MSG_TUNER_STEP_INCREMENT);
    eval 'sub CEC_MSG_DEVICE_VENDOR_ID () {0x87;}' unless defined(&CEC_MSG_DEVICE_VENDOR_ID);
    eval 'sub CEC_MSG_GIVE_DEVICE_VENDOR_ID () {0x8c;}' unless defined(&CEC_MSG_GIVE_DEVICE_VENDOR_ID);
    eval 'sub CEC_MSG_VENDOR_COMMAND () {0x89;}' unless defined(&CEC_MSG_VENDOR_COMMAND);
    eval 'sub CEC_MSG_VENDOR_COMMAND_WITH_ID () {0xa0;}' unless defined(&CEC_MSG_VENDOR_COMMAND_WITH_ID);
    eval 'sub CEC_MSG_VENDOR_REMOTE_BUTTON_DOWN () {0x8a;}' unless defined(&CEC_MSG_VENDOR_REMOTE_BUTTON_DOWN);
    eval 'sub CEC_MSG_VENDOR_REMOTE_BUTTON_UP () {0x8b;}' unless defined(&CEC_MSG_VENDOR_REMOTE_BUTTON_UP);
    eval 'sub CEC_MSG_SET_OSD_STRING () {0x64;}' unless defined(&CEC_MSG_SET_OSD_STRING);
    eval 'sub CEC_OP_DISP_CTL_DEFAULT () {0x;}' unless defined(&CEC_OP_DISP_CTL_DEFAULT);
    eval 'sub CEC_OP_DISP_CTL_UNTIL_CLEARED () {0x40;}' unless defined(&CEC_OP_DISP_CTL_UNTIL_CLEARED);
    eval 'sub CEC_OP_DISP_CTL_CLEAR () {0x80;}' unless defined(&CEC_OP_DISP_CTL_CLEAR);
    eval 'sub CEC_MSG_GIVE_OSD_NAME () {0x46;}' unless defined(&CEC_MSG_GIVE_OSD_NAME);
    eval 'sub CEC_MSG_SET_OSD_NAME () {0x47;}' unless defined(&CEC_MSG_SET_OSD_NAME);
    eval 'sub CEC_MSG_MENU_REQUEST () {0x8d;}' unless defined(&CEC_MSG_MENU_REQUEST);
    eval 'sub CEC_OP_MENU_REQUEST_ACTIVATE () {0x;}' unless defined(&CEC_OP_MENU_REQUEST_ACTIVATE);
    eval 'sub CEC_OP_MENU_REQUEST_DEACTIVATE () {0x1;}' unless defined(&CEC_OP_MENU_REQUEST_DEACTIVATE);
    eval 'sub CEC_OP_MENU_REQUEST_QUERY () {0x2;}' unless defined(&CEC_OP_MENU_REQUEST_QUERY);
    eval 'sub CEC_MSG_MENU_STATUS () {0x8e;}' unless defined(&CEC_MSG_MENU_STATUS);
    eval 'sub CEC_OP_MENU_STATE_ACTIVATED () {0x;}' unless defined(&CEC_OP_MENU_STATE_ACTIVATED);
    eval 'sub CEC_OP_MENU_STATE_DEACTIVATED () {0x1;}' unless defined(&CEC_OP_MENU_STATE_DEACTIVATED);
    eval 'sub CEC_MSG_USER_CONTROL_PRESSED () {0x44;}' unless defined(&CEC_MSG_USER_CONTROL_PRESSED);
    eval 'sub CEC_OP_UI_CMD_SELECT () {0x;}' unless defined(&CEC_OP_UI_CMD_SELECT);
    eval 'sub CEC_OP_UI_CMD_UP () {0x1;}' unless defined(&CEC_OP_UI_CMD_UP);
    eval 'sub CEC_OP_UI_CMD_DOWN () {0x2;}' unless defined(&CEC_OP_UI_CMD_DOWN);
    eval 'sub CEC_OP_UI_CMD_LEFT () {0x3;}' unless defined(&CEC_OP_UI_CMD_LEFT);
    eval 'sub CEC_OP_UI_CMD_RIGHT () {0x4;}' unless defined(&CEC_OP_UI_CMD_RIGHT);
    eval 'sub CEC_OP_UI_CMD_RIGHT_UP () {0x5;}' unless defined(&CEC_OP_UI_CMD_RIGHT_UP);
    eval 'sub CEC_OP_UI_CMD_RIGHT_DOWN () {0x6;}' unless defined(&CEC_OP_UI_CMD_RIGHT_DOWN);
    eval 'sub CEC_OP_UI_CMD_LEFT_UP () {0x7;}' unless defined(&CEC_OP_UI_CMD_LEFT_UP);
    eval 'sub CEC_OP_UI_CMD_LEFT_DOWN () {0x8;}' unless defined(&CEC_OP_UI_CMD_LEFT_DOWN);
    eval 'sub CEC_OP_UI_CMD_DEVICE_ROOT_MENU () {0x9;}' unless defined(&CEC_OP_UI_CMD_DEVICE_ROOT_MENU);
    eval 'sub CEC_OP_UI_CMD_DEVICE_SETUP_MENU () {0xa;}' unless defined(&CEC_OP_UI_CMD_DEVICE_SETUP_MENU);
    eval 'sub CEC_OP_UI_CMD_CONTENTS_MENU () {0xb;}' unless defined(&CEC_OP_UI_CMD_CONTENTS_MENU);
    eval 'sub CEC_OP_UI_CMD_FAVORITE_MENU () {0xc;}' unless defined(&CEC_OP_UI_CMD_FAVORITE_MENU);
    eval 'sub CEC_OP_UI_CMD_BACK () {0xd;}' unless defined(&CEC_OP_UI_CMD_BACK);
    eval 'sub CEC_OP_UI_CMD_MEDIA_TOP_MENU () {0x10;}' unless defined(&CEC_OP_UI_CMD_MEDIA_TOP_MENU);
    eval 'sub CEC_OP_UI_CMD_MEDIA_CONTEXT_SENSITIVE_MENU () {0x11;}' unless defined(&CEC_OP_UI_CMD_MEDIA_CONTEXT_SENSITIVE_MENU);
    eval 'sub CEC_OP_UI_CMD_NUMBER_ENTRY_MODE () {0x1d;}' unless defined(&CEC_OP_UI_CMD_NUMBER_ENTRY_MODE);
    eval 'sub CEC_OP_UI_CMD_NUMBER_11 () {0x1e;}' unless defined(&CEC_OP_UI_CMD_NUMBER_11);
    eval 'sub CEC_OP_UI_CMD_NUMBER_12 () {0x1f;}' unless defined(&CEC_OP_UI_CMD_NUMBER_12);
    eval 'sub CEC_OP_UI_CMD_NUMBER_0_OR_NUMBER_10 () {0x20;}' unless defined(&CEC_OP_UI_CMD_NUMBER_0_OR_NUMBER_10);
    eval 'sub CEC_OP_UI_CMD_NUMBER_1 () {0x21;}' unless defined(&CEC_OP_UI_CMD_NUMBER_1);
    eval 'sub CEC_OP_UI_CMD_NUMBER_2 () {0x22;}' unless defined(&CEC_OP_UI_CMD_NUMBER_2);
    eval 'sub CEC_OP_UI_CMD_NUMBER_3 () {0x23;}' unless defined(&CEC_OP_UI_CMD_NUMBER_3);
    eval 'sub CEC_OP_UI_CMD_NUMBER_4 () {0x24;}' unless defined(&CEC_OP_UI_CMD_NUMBER_4);
    eval 'sub CEC_OP_UI_CMD_NUMBER_5 () {0x25;}' unless defined(&CEC_OP_UI_CMD_NUMBER_5);
    eval 'sub CEC_OP_UI_CMD_NUMBER_6 () {0x26;}' unless defined(&CEC_OP_UI_CMD_NUMBER_6);
    eval 'sub CEC_OP_UI_CMD_NUMBER_7 () {0x27;}' unless defined(&CEC_OP_UI_CMD_NUMBER_7);
    eval 'sub CEC_OP_UI_CMD_NUMBER_8 () {0x28;}' unless defined(&CEC_OP_UI_CMD_NUMBER_8);
    eval 'sub CEC_OP_UI_CMD_NUMBER_9 () {0x29;}' unless defined(&CEC_OP_UI_CMD_NUMBER_9);
    eval 'sub CEC_OP_UI_CMD_DOT () {0x2a;}' unless defined(&CEC_OP_UI_CMD_DOT);
    eval 'sub CEC_OP_UI_CMD_ENTER () {0x2b;}' unless defined(&CEC_OP_UI_CMD_ENTER);
    eval 'sub CEC_OP_UI_CMD_CLEAR () {0x2c;}' unless defined(&CEC_OP_UI_CMD_CLEAR);
    eval 'sub CEC_OP_UI_CMD_NEXT_FAVORITE () {0x2f;}' unless defined(&CEC_OP_UI_CMD_NEXT_FAVORITE);
    eval 'sub CEC_OP_UI_CMD_CHANNEL_UP () {0x30;}' unless defined(&CEC_OP_UI_CMD_CHANNEL_UP);
    eval 'sub CEC_OP_UI_CMD_CHANNEL_DOWN () {0x31;}' unless defined(&CEC_OP_UI_CMD_CHANNEL_DOWN);
    eval 'sub CEC_OP_UI_CMD_PREVIOUS_CHANNEL () {0x32;}' unless defined(&CEC_OP_UI_CMD_PREVIOUS_CHANNEL);
    eval 'sub CEC_OP_UI_CMD_SOUND_SELECT () {0x33;}' unless defined(&CEC_OP_UI_CMD_SOUND_SELECT);
    eval 'sub CEC_OP_UI_CMD_INPUT_SELECT () {0x34;}' unless defined(&CEC_OP_UI_CMD_INPUT_SELECT);
    eval 'sub CEC_OP_UI_CMD_DISPLAY_INFORMATION () {0x35;}' unless defined(&CEC_OP_UI_CMD_DISPLAY_INFORMATION);
    eval 'sub CEC_OP_UI_CMD_HELP () {0x36;}' unless defined(&CEC_OP_UI_CMD_HELP);
    eval 'sub CEC_OP_UI_CMD_PAGE_UP () {0x37;}' unless defined(&CEC_OP_UI_CMD_PAGE_UP);
    eval 'sub CEC_OP_UI_CMD_PAGE_DOWN () {0x38;}' unless defined(&CEC_OP_UI_CMD_PAGE_DOWN);
    eval 'sub CEC_OP_UI_CMD_POWER () {0x40;}' unless defined(&CEC_OP_UI_CMD_POWER);
    eval 'sub CEC_OP_UI_CMD_VOLUME_UP () {0x41;}' unless defined(&CEC_OP_UI_CMD_VOLUME_UP);
    eval 'sub CEC_OP_UI_CMD_VOLUME_DOWN () {0x42;}' unless defined(&CEC_OP_UI_CMD_VOLUME_DOWN);
    eval 'sub CEC_OP_UI_CMD_MUTE () {0x43;}' unless defined(&CEC_OP_UI_CMD_MUTE);
    eval 'sub CEC_OP_UI_CMD_PLAY () {0x44;}' unless defined(&CEC_OP_UI_CMD_PLAY);
    eval 'sub CEC_OP_UI_CMD_STOP () {0x45;}' unless defined(&CEC_OP_UI_CMD_STOP);
    eval 'sub CEC_OP_UI_CMD_PAUSE () {0x46;}' unless defined(&CEC_OP_UI_CMD_PAUSE);
    eval 'sub CEC_OP_UI_CMD_RECORD () {0x47;}' unless defined(&CEC_OP_UI_CMD_RECORD);
    eval 'sub CEC_OP_UI_CMD_REWIND () {0x48;}' unless defined(&CEC_OP_UI_CMD_REWIND);
    eval 'sub CEC_OP_UI_CMD_FAST_FORWARD () {0x49;}' unless defined(&CEC_OP_UI_CMD_FAST_FORWARD);
    eval 'sub CEC_OP_UI_CMD_EJECT () {0x4a;}' unless defined(&CEC_OP_UI_CMD_EJECT);
    eval 'sub CEC_OP_UI_CMD_SKIP_FORWARD () {0x4b;}' unless defined(&CEC_OP_UI_CMD_SKIP_FORWARD);
    eval 'sub CEC_OP_UI_CMD_SKIP_BACKWARD () {0x4c;}' unless defined(&CEC_OP_UI_CMD_SKIP_BACKWARD);
    eval 'sub CEC_OP_UI_CMD_STOP_RECORD () {0x4d;}' unless defined(&CEC_OP_UI_CMD_STOP_RECORD);
    eval 'sub CEC_OP_UI_CMD_PAUSE_RECORD () {0x4e;}' unless defined(&CEC_OP_UI_CMD_PAUSE_RECORD);
    eval 'sub CEC_OP_UI_CMD_ANGLE () {0x50;}' unless defined(&CEC_OP_UI_CMD_ANGLE);
    eval 'sub CEC_OP_UI_CMD_SUB_PICTURE () {0x51;}' unless defined(&CEC_OP_UI_CMD_SUB_PICTURE);
    eval 'sub CEC_OP_UI_CMD_VIDEO_ON_DEMAND () {0x52;}' unless defined(&CEC_OP_UI_CMD_VIDEO_ON_DEMAND);
    eval 'sub CEC_OP_UI_CMD_ELECTRONIC_PROGRAM_GUIDE () {0x53;}' unless defined(&CEC_OP_UI_CMD_ELECTRONIC_PROGRAM_GUIDE);
    eval 'sub CEC_OP_UI_CMD_TIMER_PROGRAMMING () {0x54;}' unless defined(&CEC_OP_UI_CMD_TIMER_PROGRAMMING);
    eval 'sub CEC_OP_UI_CMD_INITIAL_CONFIGURATION () {0x55;}' unless defined(&CEC_OP_UI_CMD_INITIAL_CONFIGURATION);
    eval 'sub CEC_OP_UI_CMD_SELECT_BROADCAST_TYPE () {0x56;}' unless defined(&CEC_OP_UI_CMD_SELECT_BROADCAST_TYPE);
    eval 'sub CEC_OP_UI_CMD_SELECT_SOUND_PRESENTATION () {0x57;}' unless defined(&CEC_OP_UI_CMD_SELECT_SOUND_PRESENTATION);
    eval 'sub CEC_OP_UI_CMD_AUDIO_DESCRIPTION () {0x58;}' unless defined(&CEC_OP_UI_CMD_AUDIO_DESCRIPTION);
    eval 'sub CEC_OP_UI_CMD_INTERNET () {0x59;}' unless defined(&CEC_OP_UI_CMD_INTERNET);
    eval 'sub CEC_OP_UI_CMD_3D_MODE () {0x5a;}' unless defined(&CEC_OP_UI_CMD_3D_MODE);
    eval 'sub CEC_OP_UI_CMD_PLAY_FUNCTION () {0x60;}' unless defined(&CEC_OP_UI_CMD_PLAY_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_PAUSE_PLAY_FUNCTION () {0x61;}' unless defined(&CEC_OP_UI_CMD_PAUSE_PLAY_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_RECORD_FUNCTION () {0x62;}' unless defined(&CEC_OP_UI_CMD_RECORD_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_PAUSE_RECORD_FUNCTION () {0x63;}' unless defined(&CEC_OP_UI_CMD_PAUSE_RECORD_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_STOP_FUNCTION () {0x64;}' unless defined(&CEC_OP_UI_CMD_STOP_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_MUTE_FUNCTION () {0x65;}' unless defined(&CEC_OP_UI_CMD_MUTE_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_RESTORE_VOLUME_FUNCTION () {0x66;}' unless defined(&CEC_OP_UI_CMD_RESTORE_VOLUME_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_TUNE_FUNCTION () {0x67;}' unless defined(&CEC_OP_UI_CMD_TUNE_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_SELECT_MEDIA_FUNCTION () {0x68;}' unless defined(&CEC_OP_UI_CMD_SELECT_MEDIA_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_SELECT_AV_INPUT_FUNCTION () {0x69;}' unless defined(&CEC_OP_UI_CMD_SELECT_AV_INPUT_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_SELECT_AUDIO_INPUT_FUNCTION () {0x6a;}' unless defined(&CEC_OP_UI_CMD_SELECT_AUDIO_INPUT_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_POWER_TOGGLE_FUNCTION () {0x6b;}' unless defined(&CEC_OP_UI_CMD_POWER_TOGGLE_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_POWER_OFF_FUNCTION () {0x6c;}' unless defined(&CEC_OP_UI_CMD_POWER_OFF_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_POWER_ON_FUNCTION () {0x6d;}' unless defined(&CEC_OP_UI_CMD_POWER_ON_FUNCTION);
    eval 'sub CEC_OP_UI_CMD_F1_BLUE () {0x71;}' unless defined(&CEC_OP_UI_CMD_F1_BLUE);
    eval 'sub CEC_OP_UI_CMD_F2_RED () {0x72;}' unless defined(&CEC_OP_UI_CMD_F2_RED);
    eval 'sub CEC_OP_UI_CMD_F3_GREEN () {0x73;}' unless defined(&CEC_OP_UI_CMD_F3_GREEN);
    eval 'sub CEC_OP_UI_CMD_F4_YELLOW () {0x74;}' unless defined(&CEC_OP_UI_CMD_F4_YELLOW);
    eval 'sub CEC_OP_UI_CMD_F5 () {0x75;}' unless defined(&CEC_OP_UI_CMD_F5);
    eval 'sub CEC_OP_UI_CMD_DATA () {0x76;}' unless defined(&CEC_OP_UI_CMD_DATA);
    eval 'sub CEC_OP_UI_BCAST_TYPE_TOGGLE_ALL () {0x;}' unless defined(&CEC_OP_UI_BCAST_TYPE_TOGGLE_ALL);
    eval 'sub CEC_OP_UI_BCAST_TYPE_TOGGLE_DIG_ANA () {0x1;}' unless defined(&CEC_OP_UI_BCAST_TYPE_TOGGLE_DIG_ANA);
    eval 'sub CEC_OP_UI_BCAST_TYPE_ANALOGUE () {0x10;}' unless defined(&CEC_OP_UI_BCAST_TYPE_ANALOGUE);
    eval 'sub CEC_OP_UI_BCAST_TYPE_ANALOGUE_T () {0x20;}' unless defined(&CEC_OP_UI_BCAST_TYPE_ANALOGUE_T);
    eval 'sub CEC_OP_UI_BCAST_TYPE_ANALOGUE_CABLE () {0x30;}' unless defined(&CEC_OP_UI_BCAST_TYPE_ANALOGUE_CABLE);
    eval 'sub CEC_OP_UI_BCAST_TYPE_ANALOGUE_SAT () {0x40;}' unless defined(&CEC_OP_UI_BCAST_TYPE_ANALOGUE_SAT);
    eval 'sub CEC_OP_UI_BCAST_TYPE_DIGITAL () {0x50;}' unless defined(&CEC_OP_UI_BCAST_TYPE_DIGITAL);
    eval 'sub CEC_OP_UI_BCAST_TYPE_DIGITAL_T () {0x60;}' unless defined(&CEC_OP_UI_BCAST_TYPE_DIGITAL_T);
    eval 'sub CEC_OP_UI_BCAST_TYPE_DIGITAL_CABLE () {0x70;}' unless defined(&CEC_OP_UI_BCAST_TYPE_DIGITAL_CABLE);
    eval 'sub CEC_OP_UI_BCAST_TYPE_DIGITAL_SAT () {0x80;}' unless defined(&CEC_OP_UI_BCAST_TYPE_DIGITAL_SAT);
    eval 'sub CEC_OP_UI_BCAST_TYPE_DIGITAL_COM_SAT () {0x90;}' unless defined(&CEC_OP_UI_BCAST_TYPE_DIGITAL_COM_SAT);
    eval 'sub CEC_OP_UI_BCAST_TYPE_DIGITAL_COM_SAT2 () {0x91;}' unless defined(&CEC_OP_UI_BCAST_TYPE_DIGITAL_COM_SAT2);
    eval 'sub CEC_OP_UI_BCAST_TYPE_IP () {0xa0;}' unless defined(&CEC_OP_UI_BCAST_TYPE_IP);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_DUAL_MONO () {0x10;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_DUAL_MONO);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_KARAOKE () {0x20;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_KARAOKE);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_DOWNMIX () {0x80;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_DOWNMIX);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_REVERB () {0x90;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_REVERB);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_EQUALIZER () {0xa0;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_EQUALIZER);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_BASS_UP () {0xb1;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_BASS_UP);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_BASS_NEUTRAL () {0xb2;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_BASS_NEUTRAL);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_BASS_DOWN () {0xb3;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_BASS_DOWN);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_TREBLE_UP () {0xc1;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_TREBLE_UP);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_TREBLE_NEUTRAL () {0xc2;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_TREBLE_NEUTRAL);
    eval 'sub CEC_OP_UI_SND_PRES_CTL_TREBLE_DOWN () {0xc3;}' unless defined(&CEC_OP_UI_SND_PRES_CTL_TREBLE_DOWN);
    eval 'sub CEC_MSG_USER_CONTROL_RELEASED () {0x45;}' unless defined(&CEC_MSG_USER_CONTROL_RELEASED);
    eval 'sub CEC_MSG_GIVE_DEVICE_POWER_STATUS () {0x8f;}' unless defined(&CEC_MSG_GIVE_DEVICE_POWER_STATUS);
    eval 'sub CEC_MSG_REPORT_POWER_STATUS () {0x90;}' unless defined(&CEC_MSG_REPORT_POWER_STATUS);
    eval 'sub CEC_OP_POWER_STATUS_ON () {0;}' unless defined(&CEC_OP_POWER_STATUS_ON);
    eval 'sub CEC_OP_POWER_STATUS_STANDBY () {1;}' unless defined(&CEC_OP_POWER_STATUS_STANDBY);
    eval 'sub CEC_OP_POWER_STATUS_TO_ON () {2;}' unless defined(&CEC_OP_POWER_STATUS_TO_ON);
    eval 'sub CEC_OP_POWER_STATUS_TO_STANDBY () {3;}' unless defined(&CEC_OP_POWER_STATUS_TO_STANDBY);
    eval 'sub CEC_MSG_FEATURE_ABORT () {0x;}' unless defined(&CEC_MSG_FEATURE_ABORT);
    eval 'sub CEC_OP_ABORT_UNRECOGNIZED_OP () {0;}' unless defined(&CEC_OP_ABORT_UNRECOGNIZED_OP);
    eval 'sub CEC_OP_ABORT_INCORRECT_MODE () {1;}' unless defined(&CEC_OP_ABORT_INCORRECT_MODE);
    eval 'sub CEC_OP_ABORT_NO_SOURCE () {2;}' unless defined(&CEC_OP_ABORT_NO_SOURCE);
    eval 'sub CEC_OP_ABORT_INVALID_OP () {3;}' unless defined(&CEC_OP_ABORT_INVALID_OP);
    eval 'sub CEC_OP_ABORT_REFUSED () {4;}' unless defined(&CEC_OP_ABORT_REFUSED);
    eval 'sub CEC_OP_ABORT_UNDETERMINED () {5;}' unless defined(&CEC_OP_ABORT_UNDETERMINED);
    eval 'sub CEC_MSG_ABORT () {0xff;}' unless defined(&CEC_MSG_ABORT);
    eval 'sub CEC_MSG_GIVE_AUDIO_STATUS () {0x71;}' unless defined(&CEC_MSG_GIVE_AUDIO_STATUS);
    eval 'sub CEC_MSG_GIVE_SYSTEM_AUDIO_MODE_STATUS () {0x7d;}' unless defined(&CEC_MSG_GIVE_SYSTEM_AUDIO_MODE_STATUS);
    eval 'sub CEC_MSG_REPORT_AUDIO_STATUS () {0x7a;}' unless defined(&CEC_MSG_REPORT_AUDIO_STATUS);
    eval 'sub CEC_OP_AUD_MUTE_STATUS_OFF () {0;}' unless defined(&CEC_OP_AUD_MUTE_STATUS_OFF);
    eval 'sub CEC_OP_AUD_MUTE_STATUS_ON () {1;}' unless defined(&CEC_OP_AUD_MUTE_STATUS_ON);
    eval 'sub CEC_MSG_REPORT_SHORT_AUDIO_DESCRIPTOR () {0xa3;}' unless defined(&CEC_MSG_REPORT_SHORT_AUDIO_DESCRIPTOR);
    eval 'sub CEC_MSG_REQUEST_SHORT_AUDIO_DESCRIPTOR () {0xa4;}' unless defined(&CEC_MSG_REQUEST_SHORT_AUDIO_DESCRIPTOR);
    eval 'sub CEC_MSG_SET_SYSTEM_AUDIO_MODE () {0x72;}' unless defined(&CEC_MSG_SET_SYSTEM_AUDIO_MODE);
    eval 'sub CEC_OP_SYS_AUD_STATUS_OFF () {0;}' unless defined(&CEC_OP_SYS_AUD_STATUS_OFF);
    eval 'sub CEC_OP_SYS_AUD_STATUS_ON () {1;}' unless defined(&CEC_OP_SYS_AUD_STATUS_ON);
    eval 'sub CEC_MSG_SYSTEM_AUDIO_MODE_REQUEST () {0x70;}' unless defined(&CEC_MSG_SYSTEM_AUDIO_MODE_REQUEST);
    eval 'sub CEC_MSG_SYSTEM_AUDIO_MODE_STATUS () {0x7e;}' unless defined(&CEC_MSG_SYSTEM_AUDIO_MODE_STATUS);
    eval 'sub CEC_OP_AUD_FMT_ID_CEA861 () {0;}' unless defined(&CEC_OP_AUD_FMT_ID_CEA861);
    eval 'sub CEC_OP_AUD_FMT_ID_CEA861_CXT () {1;}' unless defined(&CEC_OP_AUD_FMT_ID_CEA861_CXT);
    eval 'sub CEC_MSG_SET_AUDIO_RATE () {0x9a;}' unless defined(&CEC_MSG_SET_AUDIO_RATE);
    eval 'sub CEC_OP_AUD_RATE_OFF () {0;}' unless defined(&CEC_OP_AUD_RATE_OFF);
    eval 'sub CEC_OP_AUD_RATE_WIDE_STD () {1;}' unless defined(&CEC_OP_AUD_RATE_WIDE_STD);
    eval 'sub CEC_OP_AUD_RATE_WIDE_FAST () {2;}' unless defined(&CEC_OP_AUD_RATE_WIDE_FAST);
    eval 'sub CEC_OP_AUD_RATE_WIDE_SLOW () {3;}' unless defined(&CEC_OP_AUD_RATE_WIDE_SLOW);
    eval 'sub CEC_OP_AUD_RATE_NARROW_STD () {4;}' unless defined(&CEC_OP_AUD_RATE_NARROW_STD);
    eval 'sub CEC_OP_AUD_RATE_NARROW_FAST () {5;}' unless defined(&CEC_OP_AUD_RATE_NARROW_FAST);
    eval 'sub CEC_OP_AUD_RATE_NARROW_SLOW () {6;}' unless defined(&CEC_OP_AUD_RATE_NARROW_SLOW);
    eval 'sub CEC_MSG_INITIATE_ARC () {0xc0;}' unless defined(&CEC_MSG_INITIATE_ARC);
    eval 'sub CEC_MSG_REPORT_ARC_INITIATED () {0xc1;}' unless defined(&CEC_MSG_REPORT_ARC_INITIATED);
    eval 'sub CEC_MSG_REPORT_ARC_TERMINATED () {0xc2;}' unless defined(&CEC_MSG_REPORT_ARC_TERMINATED);
    eval 'sub CEC_MSG_REQUEST_ARC_INITIATION () {0xc3;}' unless defined(&CEC_MSG_REQUEST_ARC_INITIATION);
    eval 'sub CEC_MSG_REQUEST_ARC_TERMINATION () {0xc4;}' unless defined(&CEC_MSG_REQUEST_ARC_TERMINATION);
    eval 'sub CEC_MSG_TERMINATE_ARC () {0xc5;}' unless defined(&CEC_MSG_TERMINATE_ARC);
    eval 'sub CEC_MSG_REQUEST_CURRENT_LATENCY () {0xa7;}' unless defined(&CEC_MSG_REQUEST_CURRENT_LATENCY);
    eval 'sub CEC_MSG_REPORT_CURRENT_LATENCY () {0xa8;}' unless defined(&CEC_MSG_REPORT_CURRENT_LATENCY);
    eval 'sub CEC_OP_LOW_LATENCY_MODE_OFF () {0;}' unless defined(&CEC_OP_LOW_LATENCY_MODE_OFF);
    eval 'sub CEC_OP_LOW_LATENCY_MODE_ON () {1;}' unless defined(&CEC_OP_LOW_LATENCY_MODE_ON);
    eval 'sub CEC_OP_AUD_OUT_COMPENSATED_NA () {0;}' unless defined(&CEC_OP_AUD_OUT_COMPENSATED_NA);
    eval 'sub CEC_OP_AUD_OUT_COMPENSATED_DELAY () {1;}' unless defined(&CEC_OP_AUD_OUT_COMPENSATED_DELAY);
    eval 'sub CEC_OP_AUD_OUT_COMPENSATED_NO_DELAY () {2;}' unless defined(&CEC_OP_AUD_OUT_COMPENSATED_NO_DELAY);
    eval 'sub CEC_OP_AUD_OUT_COMPENSATED_PARTIAL_DELAY () {3;}' unless defined(&CEC_OP_AUD_OUT_COMPENSATED_PARTIAL_DELAY);
    eval 'sub CEC_MSG_CDC_MESSAGE () {0xf8;}' unless defined(&CEC_MSG_CDC_MESSAGE);
    eval 'sub CEC_MSG_CDC_HEC_INQUIRE_STATE () {0x;}' unless defined(&CEC_MSG_CDC_HEC_INQUIRE_STATE);
    eval 'sub CEC_MSG_CDC_HEC_REPORT_STATE () {0x1;}' unless defined(&CEC_MSG_CDC_HEC_REPORT_STATE);
    eval 'sub CEC_OP_HEC_FUNC_STATE_NOT_SUPPORTED () {0;}' unless defined(&CEC_OP_HEC_FUNC_STATE_NOT_SUPPORTED);
    eval 'sub CEC_OP_HEC_FUNC_STATE_INACTIVE () {1;}' unless defined(&CEC_OP_HEC_FUNC_STATE_INACTIVE);
    eval 'sub CEC_OP_HEC_FUNC_STATE_ACTIVE () {2;}' unless defined(&CEC_OP_HEC_FUNC_STATE_ACTIVE);
    eval 'sub CEC_OP_HEC_FUNC_STATE_ACTIVATION_FIELD () {3;}' unless defined(&CEC_OP_HEC_FUNC_STATE_ACTIVATION_FIELD);
    eval 'sub CEC_OP_HOST_FUNC_STATE_NOT_SUPPORTED () {0;}' unless defined(&CEC_OP_HOST_FUNC_STATE_NOT_SUPPORTED);
    eval 'sub CEC_OP_HOST_FUNC_STATE_INACTIVE () {1;}' unless defined(&CEC_OP_HOST_FUNC_STATE_INACTIVE);
    eval 'sub CEC_OP_HOST_FUNC_STATE_ACTIVE () {2;}' unless defined(&CEC_OP_HOST_FUNC_STATE_ACTIVE);
    eval 'sub CEC_OP_ENC_FUNC_STATE_EXT_CON_NOT_SUPPORTED () {0;}' unless defined(&CEC_OP_ENC_FUNC_STATE_EXT_CON_NOT_SUPPORTED);
    eval 'sub CEC_OP_ENC_FUNC_STATE_EXT_CON_INACTIVE () {1;}' unless defined(&CEC_OP_ENC_FUNC_STATE_EXT_CON_INACTIVE);
    eval 'sub CEC_OP_ENC_FUNC_STATE_EXT_CON_ACTIVE () {2;}' unless defined(&CEC_OP_ENC_FUNC_STATE_EXT_CON_ACTIVE);
    eval 'sub CEC_OP_CDC_ERROR_CODE_NONE () {0;}' unless defined(&CEC_OP_CDC_ERROR_CODE_NONE);
    eval 'sub CEC_OP_CDC_ERROR_CODE_CAP_UNSUPPORTED () {1;}' unless defined(&CEC_OP_CDC_ERROR_CODE_CAP_UNSUPPORTED);
    eval 'sub CEC_OP_CDC_ERROR_CODE_WRONG_STATE () {2;}' unless defined(&CEC_OP_CDC_ERROR_CODE_WRONG_STATE);
    eval 'sub CEC_OP_CDC_ERROR_CODE_OTHER () {3;}' unless defined(&CEC_OP_CDC_ERROR_CODE_OTHER);
    eval 'sub CEC_OP_HEC_SUPPORT_NO () {0;}' unless defined(&CEC_OP_HEC_SUPPORT_NO);
    eval 'sub CEC_OP_HEC_SUPPORT_YES () {1;}' unless defined(&CEC_OP_HEC_SUPPORT_YES);
    eval 'sub CEC_OP_HEC_ACTIVATION_ON () {0;}' unless defined(&CEC_OP_HEC_ACTIVATION_ON);
    eval 'sub CEC_OP_HEC_ACTIVATION_OFF () {1;}' unless defined(&CEC_OP_HEC_ACTIVATION_OFF);
    eval 'sub CEC_MSG_CDC_HEC_SET_STATE_ADJACENT () {0x2;}' unless defined(&CEC_MSG_CDC_HEC_SET_STATE_ADJACENT);
    eval 'sub CEC_MSG_CDC_HEC_SET_STATE () {0x3;}' unless defined(&CEC_MSG_CDC_HEC_SET_STATE);
    eval 'sub CEC_OP_HEC_SET_STATE_DEACTIVATE () {0;}' unless defined(&CEC_OP_HEC_SET_STATE_DEACTIVATE);
    eval 'sub CEC_OP_HEC_SET_STATE_ACTIVATE () {1;}' unless defined(&CEC_OP_HEC_SET_STATE_ACTIVATE);
    eval 'sub CEC_MSG_CDC_HEC_REQUEST_DEACTIVATION () {0x4;}' unless defined(&CEC_MSG_CDC_HEC_REQUEST_DEACTIVATION);
    eval 'sub CEC_MSG_CDC_HEC_NOTIFY_ALIVE () {0x5;}' unless defined(&CEC_MSG_CDC_HEC_NOTIFY_ALIVE);
    eval 'sub CEC_MSG_CDC_HEC_DISCOVER () {0x6;}' unless defined(&CEC_MSG_CDC_HEC_DISCOVER);
    eval 'sub CEC_MSG_CDC_HPD_SET_STATE () {0x10;}' unless defined(&CEC_MSG_CDC_HPD_SET_STATE);
    eval 'sub CEC_OP_HPD_STATE_CP_EDID_DISABLE () {0;}' unless defined(&CEC_OP_HPD_STATE_CP_EDID_DISABLE);
    eval 'sub CEC_OP_HPD_STATE_CP_EDID_ENABLE () {1;}' unless defined(&CEC_OP_HPD_STATE_CP_EDID_ENABLE);
    eval 'sub CEC_OP_HPD_STATE_CP_EDID_DISABLE_ENABLE () {2;}' unless defined(&CEC_OP_HPD_STATE_CP_EDID_DISABLE_ENABLE);
    eval 'sub CEC_OP_HPD_STATE_EDID_DISABLE () {3;}' unless defined(&CEC_OP_HPD_STATE_EDID_DISABLE);
    eval 'sub CEC_OP_HPD_STATE_EDID_ENABLE () {4;}' unless defined(&CEC_OP_HPD_STATE_EDID_ENABLE);
    eval 'sub CEC_OP_HPD_STATE_EDID_DISABLE_ENABLE () {5;}' unless defined(&CEC_OP_HPD_STATE_EDID_DISABLE_ENABLE);
    eval 'sub CEC_MSG_CDC_HPD_REPORT_STATE () {0x11;}' unless defined(&CEC_MSG_CDC_HPD_REPORT_STATE);
    eval 'sub CEC_OP_HPD_ERROR_NONE () {0;}' unless defined(&CEC_OP_HPD_ERROR_NONE);
    eval 'sub CEC_OP_HPD_ERROR_INITIATOR_NOT_CAPABLE () {1;}' unless defined(&CEC_OP_HPD_ERROR_INITIATOR_NOT_CAPABLE);
    eval 'sub CEC_OP_HPD_ERROR_INITIATOR_WRONG_STATE () {2;}' unless defined(&CEC_OP_HPD_ERROR_INITIATOR_WRONG_STATE);
    eval 'sub CEC_OP_HPD_ERROR_OTHER () {3;}' unless defined(&CEC_OP_HPD_ERROR_OTHER);
    eval 'sub CEC_OP_HPD_ERROR_NONE_NO_VIDEO () {4;}' unless defined(&CEC_OP_HPD_ERROR_NONE_NO_VIDEO);
    eval 'sub cec_is_processor {
        my($las) = @_;
	    eval q({  ($las->{num_log_addrs})  &&  ($las->{log_addr[0]}) >=  &CEC_LOG_ADDR_BACKUP_1  &&  ($las->{primary_device_type[0]}) ==  &CEC_OP_PRIM_DEVTYPE_PROCESSOR; });
    }' unless defined(&cec_is_processor);
    eval 'sub cec_is_switch {
        my($las) = @_;
	    eval q({  ($las->{num_log_addrs}) == 1 &&  ($las->{log_addr[0]}) ==  &CEC_LOG_ADDR_UNREGISTERED  &&  ($las->{primary_device_type[0]}) ==  &CEC_OP_PRIM_DEVTYPE_SWITCH  && !( ($las->{flags}) &  &CEC_LOG_ADDRS_FL_CDC_ONLY); });
    }' unless defined(&cec_is_switch);
    eval 'sub cec_is_cdc_only {
        my($las) = @_;
	    eval q({  ($las->{num_log_addrs}) == 1 &&  ($las->{log_addr[0]}) ==  &CEC_LOG_ADDR_UNREGISTERED  &&  ($las->{primary_device_type[0]}) ==  &CEC_OP_PRIM_DEVTYPE_SWITCH  && ( ($las->{flags}) &  &CEC_LOG_ADDRS_FL_CDC_ONLY); });
    }' unless defined(&cec_is_cdc_only);
}
1;
