require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&KFD_IOCTL_H_INCLUDED)) {
    eval 'sub KFD_IOCTL_H_INCLUDED () {1;}' unless defined(&KFD_IOCTL_H_INCLUDED);
    require 'drm/drm.ph';
    require 'linux/ioctl.ph';
    eval 'sub KFD_IOCTL_MAJOR_VERSION () {1;}' unless defined(&KFD_IOCTL_MAJOR_VERSION);
    eval 'sub KFD_IOCTL_MINOR_VERSION () {11;}' unless defined(&KFD_IOCTL_MINOR_VERSION);
    eval 'sub KFD_IOC_QUEUE_TYPE_COMPUTE () {0x;}' unless defined(&KFD_IOC_QUEUE_TYPE_COMPUTE);
    eval 'sub KFD_IOC_QUEUE_TYPE_SDMA () {0x1;}' unless defined(&KFD_IOC_QUEUE_TYPE_SDMA);
    eval 'sub KFD_IOC_QUEUE_TYPE_COMPUTE_AQL () {0x2;}' unless defined(&KFD_IOC_QUEUE_TYPE_COMPUTE_AQL);
    eval 'sub KFD_IOC_QUEUE_TYPE_SDMA_XGMI () {0x3;}' unless defined(&KFD_IOC_QUEUE_TYPE_SDMA_XGMI);
    eval 'sub KFD_MAX_QUEUE_PERCENTAGE () {100;}' unless defined(&KFD_MAX_QUEUE_PERCENTAGE);
    eval 'sub KFD_MAX_QUEUE_PRIORITY () {15;}' unless defined(&KFD_MAX_QUEUE_PRIORITY);
    eval 'sub KFD_IOC_CACHE_POLICY_COHERENT () {0;}' unless defined(&KFD_IOC_CACHE_POLICY_COHERENT);
    eval 'sub KFD_IOC_CACHE_POLICY_NONCOHERENT () {1;}' unless defined(&KFD_IOC_CACHE_POLICY_NONCOHERENT);
    eval 'sub NUM_OF_SUPPORTED_GPUS () {7;}' unless defined(&NUM_OF_SUPPORTED_GPUS);
    eval 'sub MAX_ALLOWED_NUM_POINTS () {100;}' unless defined(&MAX_ALLOWED_NUM_POINTS);
    eval 'sub MAX_ALLOWED_AW_BUFF_SIZE () {4096;}' unless defined(&MAX_ALLOWED_AW_BUFF_SIZE);
    eval 'sub MAX_ALLOWED_WAC_BUFF_SIZE () {128;}' unless defined(&MAX_ALLOWED_WAC_BUFF_SIZE);
    eval 'sub KFD_INVALID_FD () {0xffffffff;}' unless defined(&KFD_INVALID_FD);
    eval 'sub KFD_IOC_EVENT_SIGNAL () {0;}' unless defined(&KFD_IOC_EVENT_SIGNAL);
    eval 'sub KFD_IOC_EVENT_NODECHANGE () {1;}' unless defined(&KFD_IOC_EVENT_NODECHANGE);
    eval 'sub KFD_IOC_EVENT_DEVICESTATECHANGE () {2;}' unless defined(&KFD_IOC_EVENT_DEVICESTATECHANGE);
    eval 'sub KFD_IOC_EVENT_HW_EXCEPTION () {3;}' unless defined(&KFD_IOC_EVENT_HW_EXCEPTION);
    eval 'sub KFD_IOC_EVENT_SYSTEM_EVENT () {4;}' unless defined(&KFD_IOC_EVENT_SYSTEM_EVENT);
    eval 'sub KFD_IOC_EVENT_DEBUG_EVENT () {5;}' unless defined(&KFD_IOC_EVENT_DEBUG_EVENT);
    eval 'sub KFD_IOC_EVENT_PROFILE_EVENT () {6;}' unless defined(&KFD_IOC_EVENT_PROFILE_EVENT);
    eval 'sub KFD_IOC_EVENT_QUEUE_EVENT () {7;}' unless defined(&KFD_IOC_EVENT_QUEUE_EVENT);
    eval 'sub KFD_IOC_EVENT_MEMORY () {8;}' unless defined(&KFD_IOC_EVENT_MEMORY);
    eval 'sub KFD_IOC_WAIT_RESULT_COMPLETE () {0;}' unless defined(&KFD_IOC_WAIT_RESULT_COMPLETE);
    eval 'sub KFD_IOC_WAIT_RESULT_TIMEOUT () {1;}' unless defined(&KFD_IOC_WAIT_RESULT_TIMEOUT);
    eval 'sub KFD_IOC_WAIT_RESULT_FAIL () {2;}' unless defined(&KFD_IOC_WAIT_RESULT_FAIL);
    eval 'sub KFD_SIGNAL_EVENT_LIMIT () {4096;}' unless defined(&KFD_SIGNAL_EVENT_LIMIT);
    eval 'sub KFD_HW_EXCEPTION_WHOLE_GPU_RESET () {0;}' unless defined(&KFD_HW_EXCEPTION_WHOLE_GPU_RESET);
    eval 'sub KFD_HW_EXCEPTION_PER_ENGINE_RESET () {1;}' unless defined(&KFD_HW_EXCEPTION_PER_ENGINE_RESET);
    eval 'sub KFD_HW_EXCEPTION_GPU_HANG () {0;}' unless defined(&KFD_HW_EXCEPTION_GPU_HANG);
    eval 'sub KFD_HW_EXCEPTION_ECC () {1;}' unless defined(&KFD_HW_EXCEPTION_ECC);
    eval 'sub KFD_MEM_ERR_NO_RAS () {0;}' unless defined(&KFD_MEM_ERR_NO_RAS);
    eval 'sub KFD_MEM_ERR_SRAM_ECC () {1;}' unless defined(&KFD_MEM_ERR_SRAM_ECC);
    eval 'sub KFD_MEM_ERR_POISON_CONSUMED () {2;}' unless defined(&KFD_MEM_ERR_POISON_CONSUMED);
    eval 'sub KFD_MEM_ERR_GPU_HANG () {3;}' unless defined(&KFD_MEM_ERR_GPU_HANG);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_VRAM () {(1<< 0);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_VRAM);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_GTT () {(1<< 1);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_GTT);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_USERPTR () {(1<< 2);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_USERPTR);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_DOORBELL () {(1<< 3);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_DOORBELL);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_MMIO_REMAP () {(1<< 4);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_MMIO_REMAP);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_WRITABLE () {(1<< 31);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_WRITABLE);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_EXECUTABLE () {(1<< 30);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_EXECUTABLE);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_PUBLIC () {(1<< 29);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_PUBLIC);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_NO_SUBSTITUTE () {(1<< 28);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_NO_SUBSTITUTE);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_AQL_QUEUE_MEM () {(1<< 27);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_AQL_QUEUE_MEM);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_COHERENT () {(1<< 26);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_COHERENT);
    eval 'sub KFD_IOC_ALLOC_MEM_FLAGS_UNCACHED () {(1<< 25);}' unless defined(&KFD_IOC_ALLOC_MEM_FLAGS_UNCACHED);
    eval("sub KFD_SMI_EVENT_NONE () { 0; }") unless defined(&KFD_SMI_EVENT_NONE);
    eval("sub KFD_SMI_EVENT_VMFAULT () { 1; }") unless defined(&KFD_SMI_EVENT_VMFAULT);
    eval("sub KFD_SMI_EVENT_THERMAL_THROTTLE () { 2; }") unless defined(&KFD_SMI_EVENT_THERMAL_THROTTLE);
    eval("sub KFD_SMI_EVENT_GPU_PRE_RESET () { 3; }") unless defined(&KFD_SMI_EVENT_GPU_PRE_RESET);
    eval("sub KFD_SMI_EVENT_GPU_POST_RESET () { 4; }") unless defined(&KFD_SMI_EVENT_GPU_POST_RESET);
    eval("sub KFD_SMI_EVENT_MIGRATE_START () { 5; }") unless defined(&KFD_SMI_EVENT_MIGRATE_START);
    eval("sub KFD_SMI_EVENT_MIGRATE_END () { 6; }") unless defined(&KFD_SMI_EVENT_MIGRATE_END);
    eval("sub KFD_SMI_EVENT_PAGE_FAULT_START () { 7; }") unless defined(&KFD_SMI_EVENT_PAGE_FAULT_START);
    eval("sub KFD_SMI_EVENT_PAGE_FAULT_END () { 8; }") unless defined(&KFD_SMI_EVENT_PAGE_FAULT_END);
    eval("sub KFD_SMI_EVENT_QUEUE_EVICTION () { 9; }") unless defined(&KFD_SMI_EVENT_QUEUE_EVICTION);
    eval("sub KFD_SMI_EVENT_QUEUE_RESTORE () { 10; }") unless defined(&KFD_SMI_EVENT_QUEUE_RESTORE);
    eval("sub KFD_SMI_EVENT_UNMAP_FROM_GPU () { 11; }") unless defined(&KFD_SMI_EVENT_UNMAP_FROM_GPU);
    eval("sub KFD_SMI_EVENT_ALL_PROCESS () { 64; }") unless defined(&KFD_SMI_EVENT_ALL_PROCESS);
    eval("sub KFD_MIGRATE_TRIGGER_PREFETCH () { 0; }") unless defined(&KFD_MIGRATE_TRIGGER_PREFETCH);
    eval("sub KFD_MIGRATE_TRIGGER_PAGEFAULT_GPU () { 1; }") unless defined(&KFD_MIGRATE_TRIGGER_PAGEFAULT_GPU);
    eval("sub KFD_MIGRATE_TRIGGER_PAGEFAULT_CPU () { 2; }") unless defined(&KFD_MIGRATE_TRIGGER_PAGEFAULT_CPU);
    eval("sub KFD_MIGRATE_TRIGGER_TTM_EVICTION () { 3; }") unless defined(&KFD_MIGRATE_TRIGGER_TTM_EVICTION);
    eval("sub KFD_QUEUE_EVICTION_TRIGGER_SVM () { 0; }") unless defined(&KFD_QUEUE_EVICTION_TRIGGER_SVM);
    eval("sub KFD_QUEUE_EVICTION_TRIGGER_USERPTR () { 1; }") unless defined(&KFD_QUEUE_EVICTION_TRIGGER_USERPTR);
    eval("sub KFD_QUEUE_EVICTION_TRIGGER_TTM () { 2; }") unless defined(&KFD_QUEUE_EVICTION_TRIGGER_TTM);
    eval("sub KFD_QUEUE_EVICTION_TRIGGER_SUSPEND () { 3; }") unless defined(&KFD_QUEUE_EVICTION_TRIGGER_SUSPEND);
    eval("sub KFD_QUEUE_EVICTION_CRIU_CHECKPOINT () { 4; }") unless defined(&KFD_QUEUE_EVICTION_CRIU_CHECKPOINT);
    eval("sub KFD_QUEUE_EVICTION_CRIU_RESTORE () { 5; }") unless defined(&KFD_QUEUE_EVICTION_CRIU_RESTORE);
    eval("sub KFD_SVM_UNMAP_TRIGGER_MMU_NOTIFY () { 0; }") unless defined(&KFD_SVM_UNMAP_TRIGGER_MMU_NOTIFY);
    eval("sub KFD_SVM_UNMAP_TRIGGER_MMU_NOTIFY_MIGRATE () { 1; }") unless defined(&KFD_SVM_UNMAP_TRIGGER_MMU_NOTIFY_MIGRATE);
    eval("sub KFD_SVM_UNMAP_TRIGGER_UNMAP_FROM_CPU () { 2; }") unless defined(&KFD_SVM_UNMAP_TRIGGER_UNMAP_FROM_CPU);
    eval 'sub KFD_SMI_EVENT_MASK_FROM_INDEX {
        my($i) = @_;
	    eval q((1 << (($i) - 1)));
    }' unless defined(&KFD_SMI_EVENT_MASK_FROM_INDEX);
    eval 'sub KFD_SMI_EVENT_MSG_SIZE () {96;}' unless defined(&KFD_SMI_EVENT_MSG_SIZE);
    eval("sub KFD_CRIU_OP_PROCESS_INFO () { 0; }") unless defined(&KFD_CRIU_OP_PROCESS_INFO);
    eval("sub KFD_CRIU_OP_CHECKPOINT () { 1; }") unless defined(&KFD_CRIU_OP_CHECKPOINT);
    eval("sub KFD_CRIU_OP_UNPAUSE () { 2; }") unless defined(&KFD_CRIU_OP_UNPAUSE);
    eval("sub KFD_CRIU_OP_RESTORE () { 3; }") unless defined(&KFD_CRIU_OP_RESTORE);
    eval("sub KFD_CRIU_OP_RESUME () { 4; }") unless defined(&KFD_CRIU_OP_RESUME);
    eval("sub KFD_MMIO_REMAP_HDP_MEM_FLUSH_CNTL () { 0; }") unless defined(&KFD_MMIO_REMAP_HDP_MEM_FLUSH_CNTL);
    eval("sub KFD_MMIO_REMAP_HDP_REG_FLUSH_CNTL () { 4; }") unless defined(&KFD_MMIO_REMAP_HDP_REG_FLUSH_CNTL);
    eval 'sub KFD_IOCTL_SVM_FLAG_HOST_ACCESS () {0x1;}' unless defined(&KFD_IOCTL_SVM_FLAG_HOST_ACCESS);
    eval 'sub KFD_IOCTL_SVM_FLAG_COHERENT () {0x2;}' unless defined(&KFD_IOCTL_SVM_FLAG_COHERENT);
    eval 'sub KFD_IOCTL_SVM_FLAG_HIVE_LOCAL () {0x4;}' unless defined(&KFD_IOCTL_SVM_FLAG_HIVE_LOCAL);
    eval 'sub KFD_IOCTL_SVM_FLAG_GPU_RO () {0x8;}' unless defined(&KFD_IOCTL_SVM_FLAG_GPU_RO);
    eval 'sub KFD_IOCTL_SVM_FLAG_GPU_EXEC () {0x10;}' unless defined(&KFD_IOCTL_SVM_FLAG_GPU_EXEC);
    eval 'sub KFD_IOCTL_SVM_FLAG_GPU_READ_MOSTLY () {0x20;}' unless defined(&KFD_IOCTL_SVM_FLAG_GPU_READ_MOSTLY);
    eval 'sub KFD_IOCTL_SVM_FLAG_GPU_ALWAYS_MAPPED () {0x40;}' unless defined(&KFD_IOCTL_SVM_FLAG_GPU_ALWAYS_MAPPED);
    eval("sub KFD_IOCTL_SVM_OP_SET_ATTR () { 0; }") unless defined(&KFD_IOCTL_SVM_OP_SET_ATTR);
    eval("sub KFD_IOCTL_SVM_OP_GET_ATTR () { 1; }") unless defined(&KFD_IOCTL_SVM_OP_GET_ATTR);
    eval("sub KFD_IOCTL_SVM_LOCATION_SYSMEM () { 0; }") unless defined(&KFD_IOCTL_SVM_LOCATION_SYSMEM);
    eval("sub KFD_IOCTL_SVM_LOCATION_UNDEFINED () { 0xffffffff; }") unless defined(&KFD_IOCTL_SVM_LOCATION_UNDEFINED);
    eval("sub KFD_IOCTL_SVM_ATTR_PREFERRED_LOC () { 0; }") unless defined(&KFD_IOCTL_SVM_ATTR_PREFERRED_LOC);
    eval("sub KFD_IOCTL_SVM_ATTR_PREFETCH_LOC () { 1; }") unless defined(&KFD_IOCTL_SVM_ATTR_PREFETCH_LOC);
    eval("sub KFD_IOCTL_SVM_ATTR_ACCESS () { 2; }") unless defined(&KFD_IOCTL_SVM_ATTR_ACCESS);
    eval("sub KFD_IOCTL_SVM_ATTR_ACCESS_IN_PLACE () { 3; }") unless defined(&KFD_IOCTL_SVM_ATTR_ACCESS_IN_PLACE);
    eval("sub KFD_IOCTL_SVM_ATTR_NO_ACCESS () { 4; }") unless defined(&KFD_IOCTL_SVM_ATTR_NO_ACCESS);
    eval("sub KFD_IOCTL_SVM_ATTR_SET_FLAGS () { 5; }") unless defined(&KFD_IOCTL_SVM_ATTR_SET_FLAGS);
    eval("sub KFD_IOCTL_SVM_ATTR_CLR_FLAGS () { 6; }") unless defined(&KFD_IOCTL_SVM_ATTR_CLR_FLAGS);
    eval("sub KFD_IOCTL_SVM_ATTR_GRANULARITY () { 7; }") unless defined(&KFD_IOCTL_SVM_ATTR_GRANULARITY);
    eval 'sub AMDKFD_IOCTL_BASE () {ord(\'K\');}' unless defined(&AMDKFD_IOCTL_BASE);
    eval 'sub AMDKFD_IO {
        my($nr) = @_;
	    eval q( &_IO( &AMDKFD_IOCTL_BASE, $nr));
    }' unless defined(&AMDKFD_IO);
    eval 'sub AMDKFD_IOR {
        my($nr, $type) = @_;
	    eval q( &_IOR( &AMDKFD_IOCTL_BASE, $nr, $type));
    }' unless defined(&AMDKFD_IOR);
    eval 'sub AMDKFD_IOW {
        my($nr, $type) = @_;
	    eval q( &_IOW( &AMDKFD_IOCTL_BASE, $nr, $type));
    }' unless defined(&AMDKFD_IOW);
    eval 'sub AMDKFD_IOWR {
        my($nr, $type) = @_;
	    eval q( &_IOWR( &AMDKFD_IOCTL_BASE, $nr, $type));
    }' unless defined(&AMDKFD_IOWR);
    eval 'sub AMDKFD_IOC_GET_VERSION () { &AMDKFD_IOR(0x1, \'struct kfd_ioctl_get_version_args\');}' unless defined(&AMDKFD_IOC_GET_VERSION);
    eval 'sub AMDKFD_IOC_CREATE_QUEUE () { &AMDKFD_IOWR(0x2, \'struct kfd_ioctl_create_queue_args\');}' unless defined(&AMDKFD_IOC_CREATE_QUEUE);
    eval 'sub AMDKFD_IOC_DESTROY_QUEUE () { &AMDKFD_IOWR(0x3, \'struct kfd_ioctl_destroy_queue_args\');}' unless defined(&AMDKFD_IOC_DESTROY_QUEUE);
    eval 'sub AMDKFD_IOC_SET_MEMORY_POLICY () { &AMDKFD_IOW(0x4, \'struct kfd_ioctl_set_memory_policy_args\');}' unless defined(&AMDKFD_IOC_SET_MEMORY_POLICY);
    eval 'sub AMDKFD_IOC_GET_CLOCK_COUNTERS () { &AMDKFD_IOWR(0x5, \'struct kfd_ioctl_get_clock_counters_args\');}' unless defined(&AMDKFD_IOC_GET_CLOCK_COUNTERS);
    eval 'sub AMDKFD_IOC_GET_PROCESS_APERTURES () { &AMDKFD_IOR(0x6, \'struct kfd_ioctl_get_process_apertures_args\');}' unless defined(&AMDKFD_IOC_GET_PROCESS_APERTURES);
    eval 'sub AMDKFD_IOC_UPDATE_QUEUE () { &AMDKFD_IOW(0x7, \'struct kfd_ioctl_update_queue_args\');}' unless defined(&AMDKFD_IOC_UPDATE_QUEUE);
    eval 'sub AMDKFD_IOC_CREATE_EVENT () { &AMDKFD_IOWR(0x8, \'struct kfd_ioctl_create_event_args\');}' unless defined(&AMDKFD_IOC_CREATE_EVENT);
    eval 'sub AMDKFD_IOC_DESTROY_EVENT () { &AMDKFD_IOW(0x9, \'struct kfd_ioctl_destroy_event_args\');}' unless defined(&AMDKFD_IOC_DESTROY_EVENT);
    eval 'sub AMDKFD_IOC_SET_EVENT () { &AMDKFD_IOW(0xa, \'struct kfd_ioctl_set_event_args\');}' unless defined(&AMDKFD_IOC_SET_EVENT);
    eval 'sub AMDKFD_IOC_RESET_EVENT () { &AMDKFD_IOW(0xb, \'struct kfd_ioctl_reset_event_args\');}' unless defined(&AMDKFD_IOC_RESET_EVENT);
    eval 'sub AMDKFD_IOC_WAIT_EVENTS () { &AMDKFD_IOWR(0xc, \'struct kfd_ioctl_wait_events_args\');}' unless defined(&AMDKFD_IOC_WAIT_EVENTS);
    eval 'sub AMDKFD_IOC_DBG_REGISTER_DEPRECATED () { &AMDKFD_IOW(0xd, \'struct kfd_ioctl_dbg_register_args\');}' unless defined(&AMDKFD_IOC_DBG_REGISTER_DEPRECATED);
    eval 'sub AMDKFD_IOC_DBG_UNREGISTER_DEPRECATED () { &AMDKFD_IOW(0xe, \'struct kfd_ioctl_dbg_unregister_args\');}' unless defined(&AMDKFD_IOC_DBG_UNREGISTER_DEPRECATED);
    eval 'sub AMDKFD_IOC_DBG_ADDRESS_WATCH_DEPRECATED () { &AMDKFD_IOW(0xf, \'struct kfd_ioctl_dbg_address_watch_args\');}' unless defined(&AMDKFD_IOC_DBG_ADDRESS_WATCH_DEPRECATED);
    eval 'sub AMDKFD_IOC_DBG_WAVE_CONTROL_DEPRECATED () { &AMDKFD_IOW(0x10, \'struct kfd_ioctl_dbg_wave_control_args\');}' unless defined(&AMDKFD_IOC_DBG_WAVE_CONTROL_DEPRECATED);
    eval 'sub AMDKFD_IOC_SET_SCRATCH_BACKING_VA () { &AMDKFD_IOWR(0x11, \'struct kfd_ioctl_set_scratch_backing_va_args\');}' unless defined(&AMDKFD_IOC_SET_SCRATCH_BACKING_VA);
    eval 'sub AMDKFD_IOC_GET_TILE_CONFIG () { &AMDKFD_IOWR(0x12, \'struct kfd_ioctl_get_tile_config_args\');}' unless defined(&AMDKFD_IOC_GET_TILE_CONFIG);
    eval 'sub AMDKFD_IOC_SET_TRAP_HANDLER () { &AMDKFD_IOW(0x13, \'struct kfd_ioctl_set_trap_handler_args\');}' unless defined(&AMDKFD_IOC_SET_TRAP_HANDLER);
    eval 'sub AMDKFD_IOC_GET_PROCESS_APERTURES_NEW () { &AMDKFD_IOWR(0x14, \'struct kfd_ioctl_get_process_apertures_new_args\');}' unless defined(&AMDKFD_IOC_GET_PROCESS_APERTURES_NEW);
    eval 'sub AMDKFD_IOC_ACQUIRE_VM () { &AMDKFD_IOW(0x15, \'struct kfd_ioctl_acquire_vm_args\');}' unless defined(&AMDKFD_IOC_ACQUIRE_VM);
    eval 'sub AMDKFD_IOC_ALLOC_MEMORY_OF_GPU () { &AMDKFD_IOWR(0x16, \'struct kfd_ioctl_alloc_memory_of_gpu_args\');}' unless defined(&AMDKFD_IOC_ALLOC_MEMORY_OF_GPU);
    eval 'sub AMDKFD_IOC_FREE_MEMORY_OF_GPU () { &AMDKFD_IOW(0x17, \'struct kfd_ioctl_free_memory_of_gpu_args\');}' unless defined(&AMDKFD_IOC_FREE_MEMORY_OF_GPU);
    eval 'sub AMDKFD_IOC_MAP_MEMORY_TO_GPU () { &AMDKFD_IOWR(0x18, \'struct kfd_ioctl_map_memory_to_gpu_args\');}' unless defined(&AMDKFD_IOC_MAP_MEMORY_TO_GPU);
    eval 'sub AMDKFD_IOC_UNMAP_MEMORY_FROM_GPU () { &AMDKFD_IOWR(0x19, \'struct kfd_ioctl_unmap_memory_from_gpu_args\');}' unless defined(&AMDKFD_IOC_UNMAP_MEMORY_FROM_GPU);
    eval 'sub AMDKFD_IOC_SET_CU_MASK () { &AMDKFD_IOW(0x1a, \'struct kfd_ioctl_set_cu_mask_args\');}' unless defined(&AMDKFD_IOC_SET_CU_MASK);
    eval 'sub AMDKFD_IOC_GET_QUEUE_WAVE_STATE () { &AMDKFD_IOWR(0x1b, \'struct kfd_ioctl_get_queue_wave_state_args\');}' unless defined(&AMDKFD_IOC_GET_QUEUE_WAVE_STATE);
    eval 'sub AMDKFD_IOC_GET_DMABUF_INFO () { &AMDKFD_IOWR(0x1c, \'struct kfd_ioctl_get_dmabuf_info_args\');}' unless defined(&AMDKFD_IOC_GET_DMABUF_INFO);
    eval 'sub AMDKFD_IOC_IMPORT_DMABUF () { &AMDKFD_IOWR(0x1d, \'struct kfd_ioctl_import_dmabuf_args\');}' unless defined(&AMDKFD_IOC_IMPORT_DMABUF);
    eval 'sub AMDKFD_IOC_ALLOC_QUEUE_GWS () { &AMDKFD_IOWR(0x1e, \'struct kfd_ioctl_alloc_queue_gws_args\');}' unless defined(&AMDKFD_IOC_ALLOC_QUEUE_GWS);
    eval 'sub AMDKFD_IOC_SMI_EVENTS () { &AMDKFD_IOWR(0x1f, \'struct kfd_ioctl_smi_events_args\');}' unless defined(&AMDKFD_IOC_SMI_EVENTS);
    eval 'sub AMDKFD_IOC_SVM () { &AMDKFD_IOWR(0x20, \'struct kfd_ioctl_svm_args\');}' unless defined(&AMDKFD_IOC_SVM);
    eval 'sub AMDKFD_IOC_SET_XNACK_MODE () { &AMDKFD_IOWR(0x21, \'struct kfd_ioctl_set_xnack_mode_args\');}' unless defined(&AMDKFD_IOC_SET_XNACK_MODE);
    eval 'sub AMDKFD_IOC_CRIU_OP () { &AMDKFD_IOWR(0x22, \'struct kfd_ioctl_criu_args\');}' unless defined(&AMDKFD_IOC_CRIU_OP);
    eval 'sub AMDKFD_IOC_AVAILABLE_MEMORY () { &AMDKFD_IOWR(0x23, \'struct kfd_ioctl_get_available_memory_args\');}' unless defined(&AMDKFD_IOC_AVAILABLE_MEMORY);
    eval 'sub AMDKFD_COMMAND_START () {0x1;}' unless defined(&AMDKFD_COMMAND_START);
    eval 'sub AMDKFD_COMMAND_END () {0x24;}' unless defined(&AMDKFD_COMMAND_END);
}
1;
