require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__MPFR_H)) {
    eval 'sub __MPFR_H () {1;}' unless defined(&__MPFR_H);
    eval 'sub MPFR_VERSION_MAJOR () {4;}' unless defined(&MPFR_VERSION_MAJOR);
    eval 'sub MPFR_VERSION_MINOR () {1;}' unless defined(&MPFR_VERSION_MINOR);
    eval 'sub MPFR_VERSION_PATCHLEVEL () {0;}' unless defined(&MPFR_VERSION_PATCHLEVEL);
    eval 'sub MPFR_VERSION_STRING () {"4.1.0";}' unless defined(&MPFR_VERSION_STRING);
    eval 'sub MPFR_VERSION_NUM {
        my($a,$b,$c) = @_;
	    eval q(((($a) << 16) | (($b) << 8) | ($c)));
    }' unless defined(&MPFR_VERSION_NUM);
    eval 'sub MPFR_VERSION () { &MPFR_VERSION_NUM( &MPFR_VERSION_MAJOR, &MPFR_VERSION_MINOR, &MPFR_VERSION_PATCHLEVEL);}' unless defined(&MPFR_VERSION);
    unless(defined(&MPFR_USE_MINI_GMP)) {
	require 'gmp.ph';
    } else {
	require 'mini-gmp.ph';
    }
    eval 'sub MPFR_FLAGS_UNDERFLOW () {1;}' unless defined(&MPFR_FLAGS_UNDERFLOW);
    eval 'sub MPFR_FLAGS_OVERFLOW () {2;}' unless defined(&MPFR_FLAGS_OVERFLOW);
    eval 'sub MPFR_FLAGS_NAN () {4;}' unless defined(&MPFR_FLAGS_NAN);
    eval 'sub MPFR_FLAGS_INEXACT () {8;}' unless defined(&MPFR_FLAGS_INEXACT);
    eval 'sub MPFR_FLAGS_ERANGE () {16;}' unless defined(&MPFR_FLAGS_ERANGE);
    eval 'sub MPFR_FLAGS_DIVBY0 () {32;}' unless defined(&MPFR_FLAGS_DIVBY0);
    eval 'sub MPFR_FLAGS_ALL () {( &MPFR_FLAGS_UNDERFLOW |  &MPFR_FLAGS_OVERFLOW |  &MPFR_FLAGS_NAN |  &MPFR_FLAGS_INEXACT |  &MPFR_FLAGS_ERANGE |  &MPFR_FLAGS_DIVBY0);}' unless defined(&MPFR_FLAGS_ALL);
    eval("sub MPFR_RNDN () { 0; }") unless defined(&MPFR_RNDN);
    eval("sub MPFR_RNDZ () { 1; }") unless defined(&MPFR_RNDZ);
    eval("sub MPFR_RNDU () { 2; }") unless defined(&MPFR_RNDU);
    eval("sub MPFR_RNDD () { 3; }") unless defined(&MPFR_RNDD);
    eval("sub MPFR_RNDA () { 4; }") unless defined(&MPFR_RNDA);
    eval("sub MPFR_RNDF () { 5; }") unless defined(&MPFR_RNDF);
    eval("sub MPFR_RNDNA () { -1; }") unless defined(&MPFR_RNDNA);
    eval 'sub GMP_RNDN () { &MPFR_RNDN;}' unless defined(&GMP_RNDN);
    eval 'sub GMP_RNDZ () { &MPFR_RNDZ;}' unless defined(&GMP_RNDZ);
    eval 'sub GMP_RNDU () { &MPFR_RNDU;}' unless defined(&GMP_RNDU);
    eval 'sub GMP_RNDD () { &MPFR_RNDD;}' unless defined(&GMP_RNDD);
    unless(defined(&_MPFR_PREC_FORMAT)) {
	if((defined(&__GMP_MP_SIZE_T_INT) ? &__GMP_MP_SIZE_T_INT : undef)) {
	    eval 'sub _MPFR_PREC_FORMAT () {2;}' unless defined(&_MPFR_PREC_FORMAT);
	} else {
	    eval 'sub _MPFR_PREC_FORMAT () {3;}' unless defined(&_MPFR_PREC_FORMAT);
	}
    }
    unless(defined(&_MPFR_EXP_FORMAT)) {
	eval 'sub _MPFR_EXP_FORMAT () { &_MPFR_PREC_FORMAT;}' unless defined(&_MPFR_EXP_FORMAT);
    }
    if((defined(&_MPFR_PREC_FORMAT) ? &_MPFR_PREC_FORMAT : undef) > (defined(&_MPFR_EXP_FORMAT) ? &_MPFR_EXP_FORMAT : undef)) {
	die("mpfr_prec_t must not be larger than mpfr_exp_t");
    }
    if((defined(&_MPFR_PREC_FORMAT) ? &_MPFR_PREC_FORMAT : undef) == 1) {
    }
 elsif((defined(&_MPFR_PREC_FORMAT) ? &_MPFR_PREC_FORMAT : undef) == 2) {
    }
 elsif((defined(&_MPFR_PREC_FORMAT) ? &_MPFR_PREC_FORMAT : undef) == 3) {
    } else {
	die("Invalid MPFR Prec format");
    }
    eval 'sub MPFR_PREC_MIN () {1;}' unless defined(&MPFR_PREC_MIN);
    eval 'sub MPFR_PREC_MAX () {(( &mpfr_prec_t) (((( &mpfr_uprec_t) -1) >> 1) - 256));}' unless defined(&MPFR_PREC_MAX);
    if((defined(&_MPFR_EXP_FORMAT) ? &_MPFR_EXP_FORMAT : undef) == 1) {
    }
 elsif((defined(&_MPFR_EXP_FORMAT) ? &_MPFR_EXP_FORMAT : undef) == 2) {
    }
 elsif((defined(&_MPFR_EXP_FORMAT) ? &_MPFR_EXP_FORMAT : undef) == 3) {
    }
 elsif((defined(&_MPFR_EXP_FORMAT) ? &_MPFR_EXP_FORMAT : undef) == 4) {
    } else {
	die("Invalid MPFR Exp format");
    }
    eval 'sub MPFR_EMAX_DEFAULT () {(( &mpfr_exp_t) (( 1<< 30) - 1));}' unless defined(&MPFR_EMAX_DEFAULT);
    eval 'sub MPFR_EMIN_DEFAULT () {(-( &MPFR_EMAX_DEFAULT));}' unless defined(&MPFR_EMIN_DEFAULT);
    eval 'sub __MPFR_EXP_MAX () {(( &mpfr_exp_t) ((( &mpfr_uexp_t) -1) >> 1));}' unless defined(&__MPFR_EXP_MAX);
    eval 'sub __MPFR_EXP_NAN () {(1-  &__MPFR_EXP_MAX);}' unless defined(&__MPFR_EXP_NAN);
    eval 'sub __MPFR_EXP_ZERO () {(0-  &__MPFR_EXP_MAX);}' unless defined(&__MPFR_EXP_ZERO);
    eval 'sub __MPFR_EXP_INF () {(2-  &__MPFR_EXP_MAX);}' unless defined(&__MPFR_EXP_INF);
    unless(defined(&mp_rnd_t)) {
	eval 'sub mp_rnd_t () { &mpfr_rnd_t;}' unless defined(&mp_rnd_t);
    }
    unless(defined(&mp_prec_t)) {
	eval 'sub mp_prec_t () { &mpfr_prec_t;}' unless defined(&mp_prec_t);
    }
    eval 'sub MPFR_SIGN {
        my($x) = @_;
	    eval q((($x)-> &_mpfr_sign));
    }' unless defined(&MPFR_SIGN);
    eval("sub MPFR_NAN_KIND () { 0; }") unless defined(&MPFR_NAN_KIND);
    eval("sub MPFR_INF_KIND () { 1; }") unless defined(&MPFR_INF_KIND);
    eval("sub MPFR_ZERO_KIND () { 2; }") unless defined(&MPFR_ZERO_KIND);
    eval("sub MPFR_REGULAR_KIND () { 3; }") unless defined(&MPFR_REGULAR_KIND);
    eval("sub MPFR_FREE_LOCAL_CACHE () { 1; }") unless defined(&MPFR_FREE_LOCAL_CACHE);
    eval("sub MPFR_FREE_GLOBAL_CACHE () { 2; }") unless defined(&MPFR_FREE_GLOBAL_CACHE);
    eval 'sub __MPFR_SENTINEL_ATTR () {1;}' unless defined(&__MPFR_SENTINEL_ATTR);
    if(defined (&__GNUC__)) {
	if((defined(&__GNUC__) ? &__GNUC__ : undef) >= 4) {
	    undef(&__MPFR_SENTINEL_ATTR) if defined(&__MPFR_SENTINEL_ATTR);
	    eval 'sub __MPFR_SENTINEL_ATTR () { &__attribute__ (( &__sentinel__));}' unless defined(&__MPFR_SENTINEL_ATTR);
	}
    }
    unless(defined(&MPFR_USE_C99_FEATURE)) {
	if(defined(&__STDC_VERSION__)  && ((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : undef) >= 199901)) {
	    if(defined (&__GNUC__)) {
		if((defined(&__GNUC__) ? &__GNUC__ : undef) >= 3) {
		    eval 'sub MPFR_USE_C99_FEATURE () {1;}' unless defined(&MPFR_USE_C99_FEATURE);
		}
	    }
	}
	unless(defined(&MPFR_USE_C99_FEATURE)) {
	    eval 'sub MPFR_USE_C99_FEATURE () {0;}' unless defined(&MPFR_USE_C99_FEATURE);
	}
    }
    if(defined(&__MPFR_WITHIN_MPFR)  && (defined(&__GMP_LIBGMP_DLL) ? &__GMP_LIBGMP_DLL : undef)) {
	eval 'sub __MPFR_DECLSPEC () { &__GMP_DECLSPEC_EXPORT;}' unless defined(&__MPFR_DECLSPEC);
    } else {
	unless(defined(&__GMP_DECLSPEC)) {
	    eval 'sub __GMP_DECLSPEC () {1;}' unless defined(&__GMP_DECLSPEC);
	}
	eval 'sub __MPFR_DECLSPEC () { &__GMP_DECLSPEC;}' unless defined(&__MPFR_DECLSPEC);
    }
    if(defined(&__GNUC__)  && ((defined(&__GNUC__) ? &__GNUC__ : undef) >= 4|| ((defined(&__GNUC__) ? &__GNUC__ : undef) == 3 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : undef) >= 1))) {
	eval 'sub MPFR_DEPRECATED () { &__attribute__ (( &__deprecated__));}' unless defined(&MPFR_DEPRECATED);
    }
 elsif(defined(&_MSC_VER)  && (defined(&_MSC_VER) ? &_MSC_VER : undef) >= 1300) {
	eval 'sub MPFR_DEPRECATED () { &__declspec( &deprecated);}' unless defined(&MPFR_DEPRECATED);
    } else {
	eval 'sub MPFR_DEPRECATED () {1;}' unless defined(&MPFR_DEPRECATED);
    }
    if(defined(&__GNUC__)  && ((defined(&__GNUC__) ? &__GNUC__ : undef) >= 5|| ((defined(&__GNUC__) ? &__GNUC__ : undef) == 4 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : undef) >= 9))) {
	eval 'sub MPFR_RETURNS_NONNULL () { &__attribute__ (( &__returns_nonnull__));}' unless defined(&MPFR_RETURNS_NONNULL);
    } else {
	eval 'sub MPFR_RETURNS_NONNULL () {1;}' unless defined(&MPFR_RETURNS_NONNULL);
    }
    if(defined (&__cplusplus)) {
    }
    if(defined(&MPFR_WANT_DECIMAL_FLOATS)) {
    }
    if(defined(&MPFR_WANT_FLOAT128)) {
    }
    unless(defined(&MPFR_USE_MINI_GMP)) {
    }
    unless(defined(&MPFR_USE_MINI_GMP)) {
    }
    if(defined(&MPFR_WANT_DECIMAL_FLOATS)) {
    }
    unless(defined(&_MPFR_NO_DEPRECATED_GRANDOM)) {
    }
    unless(defined(&MPFR_USE_MINI_GMP)) {
    }
    unless(defined(&_MPFR_NO_DEPRECATED_ROOT)) {
    }
    if(defined (&__cplusplus)) {
    }
    unless(defined(&MPFR_EXTENSION)) {
	if(defined(&MPFR_USE_EXTENSION)) {
	    eval 'sub MPFR_EXTENSION () { &__extension__;}' unless defined(&MPFR_EXTENSION);
	} else {
	    eval 'sub MPFR_EXTENSION () {1;}' unless defined(&MPFR_EXTENSION);
	}
    }
    eval 'sub MPFR_DECL_INIT {
        my($_x, $_p) = @_;
	    eval q( &MPFR_EXTENSION  &mp_limb_t  &__gmpfr_local_tab_$_x->[(($_p)-1)/ &GMP_NUMB_BITS+1];  &MPFR_EXTENSION  &mpfr_t $_x = {{($_p),1, &__MPFR_EXP_NAN, &__gmpfr_local_tab_$_x}});
    }' unless defined(&MPFR_DECL_INIT);
    if((defined(&MPFR_USE_C99_FEATURE) ? &MPFR_USE_C99_FEATURE : undef)) {
	eval 'sub mpfr_round_nearest_away () {( &func,  &rop, ...) ( &mpfr_round_nearest_away_begin( &rop),  &mpfr_round_nearest_away_end(( &rop),  &func(( &rop),  &__VA_ARGS__,  &MPFR_RNDN)));}' unless defined(&mpfr_round_nearest_away);
    } else {
	eval 'sub mpfr_round_nearest_away {
	    my($func, $rop, $op) = @_;
    	    eval q(( &mpfr_round_nearest_away_begin($rop),  &mpfr_round_nearest_away_end(($rop), $func(($rop), ($op),  &MPFR_RNDN))));
	}' unless defined(&mpfr_round_nearest_away);
    }
    unless(defined(&MPFR_USE_NO_MACRO)) {
	eval 'sub mpfr_nan_p {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_exp ==  &__MPFR_EXP_NAN));
	}' unless defined(&mpfr_nan_p);
	eval 'sub mpfr_inf_p {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_exp ==  &__MPFR_EXP_INF));
	}' unless defined(&mpfr_inf_p);
	eval 'sub mpfr_zero_p {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_exp ==  &__MPFR_EXP_ZERO));
	}' unless defined(&mpfr_zero_p);
	eval 'sub mpfr_regular_p {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_exp >  &__MPFR_EXP_INF));
	}' unless defined(&mpfr_regular_p);
	eval 'sub mpfr_sgn {
	    my($_x) = @_;
    	    eval q((($_x)-> &_mpfr_exp <  &__MPFR_EXP_INF ? ( &mpfr_nan_p ($_x) ?  &mpfr_set_erangeflag () : ( &mpfr_void) 0), 0:  &MPFR_SIGN ($_x)));
	}' unless defined(&mpfr_sgn);
	eval 'sub MPFR_VALUE_OF {
	    my($x) = @_;
    	    eval q((0? ($x) : ($x)));
	}' unless defined(&MPFR_VALUE_OF);
	eval 'sub mpfr_get_prec {
	    my($_x) = @_;
    	    eval q( &MPFR_VALUE_OF(($_x)-> &_mpfr_prec));
	}' unless defined(&mpfr_get_prec);
	eval 'sub mpfr_get_exp {
	    my($_x) = @_;
    	    eval q( &MPFR_VALUE_OF(($_x)-> &_mpfr_exp));
	}' unless defined(&mpfr_get_exp);
	eval 'sub mpfr_round {
	    my($a,$b) = @_;
    	    eval q( &mpfr_rint(($a), ($b),  &MPFR_RNDNA));
	}' unless defined(&mpfr_round);
	eval 'sub mpfr_trunc {
	    my($a,$b) = @_;
    	    eval q( &mpfr_rint(($a), ($b),  &MPFR_RNDZ));
	}' unless defined(&mpfr_trunc);
	eval 'sub mpfr_ceil {
	    my($a,$b) = @_;
    	    eval q( &mpfr_rint(($a), ($b),  &MPFR_RNDU));
	}' unless defined(&mpfr_ceil);
	eval 'sub mpfr_floor {
	    my($a,$b) = @_;
    	    eval q( &mpfr_rint(($a), ($b),  &MPFR_RNDD));
	}' unless defined(&mpfr_floor);
	eval 'sub mpfr_cmp_ui {
	    my($b,$i) = @_;
    	    eval q( &mpfr_cmp_ui_2exp(($b),($i),0));
	}' unless defined(&mpfr_cmp_ui);
	eval 'sub mpfr_cmp_si {
	    my($b,$i) = @_;
    	    eval q( &mpfr_cmp_si_2exp(($b),($i),0));
	}' unless defined(&mpfr_cmp_si);
	eval 'sub mpfr_set {
	    my($a,$b,$r) = @_;
    	    eval q( &mpfr_set4($a,$b,$r, &MPFR_SIGN($b)));
	}' unless defined(&mpfr_set);
	eval 'sub mpfr_abs {
	    my($a,$b,$r) = @_;
    	    eval q( &mpfr_set4($a,$b,$r,1));
	}' unless defined(&mpfr_abs);
	eval 'sub mpfr_copysign {
	    my($a,$b,$c,$r) = @_;
    	    eval q( &mpfr_set4($a,$b,$r, &MPFR_SIGN($c)));
	}' unless defined(&mpfr_copysign);
	eval 'sub mpfr_setsign {
	    my($a,$b,$s,$r) = @_;
    	    eval q( &mpfr_set4($a,$b,$r,($s) ? -1: 1));
	}' unless defined(&mpfr_setsign);
	eval 'sub mpfr_signbit {
	    my($x) = @_;
    	    eval q(( &MPFR_SIGN($x) < 0));
	}' unless defined(&mpfr_signbit);
	eval 'sub mpfr_cmp {
	    my($b, $c) = @_;
    	    eval q( &mpfr_cmp3($b, $c, 1));
	}' unless defined(&mpfr_cmp);
	eval 'sub mpfr_mul_2exp {
	    my($y,$x,$n,$r) = @_;
    	    eval q( &mpfr_mul_2ui(($y),($x),($n),($r)));
	}' unless defined(&mpfr_mul_2exp);
	eval 'sub mpfr_div_2exp {
	    my($y,$x,$n,$r) = @_;
    	    eval q( &mpfr_div_2ui(($y),($x),($n),($r)));
	}' unless defined(&mpfr_div_2exp);
	if(defined (&__GNUC__)  && !defined(&__cplusplus)) {
	    if(((defined(&__GNUC__) ? &__GNUC__ : undef) >= 2)) {
		undef(&mpfr_cmp_ui) if defined(&mpfr_cmp_ui);
		eval 'sub mpfr_cmp_ui {
		    my($_f,$_u) = @_;
    		    eval q(( &__builtin_constant_p  && ($_u) == 0? ( &mpfr_sgn) ($_f) :  &mpfr_cmp_ui_2exp (($_f), ($_u), 0)));
		}' unless defined(&mpfr_cmp_ui);
		undef(&mpfr_cmp_si) if defined(&mpfr_cmp_si);
		eval 'sub mpfr_cmp_si {
		    my($_f,$_s) = @_;
    		    eval q(( &__builtin_constant_p ($_s)  &&  >= 0?  &mpfr_cmp_ui (, ($_s)) :  &mpfr_cmp_si_2exp (($_f), ($_s), 0)));
		}' unless defined(&mpfr_cmp_si);
		if((defined(&__GNUC__) ? &__GNUC__ : undef) > 2|| (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : undef) >= 95) {
		    undef(&mpfr_set_ui) if defined(&mpfr_set_ui);
		    eval 'sub mpfr_set_ui {
		        my($_f,$_u,$_r) = @_;
    			eval q(( &__builtin_constant_p  && ($_u) == 0?  &__extension__ ({  &mpfr_ptr  &_p = ($_f);  ($_p->{_mpfr_sign}) = 1;  ($_p->{_mpfr_exp}) =  &__MPFR_EXP_ZERO; ( &mpfr_void) ($_r); 0; }) :  &mpfr_set_ui_2exp (($_f), ($_u), 0, ($_r))));
		    }' unless defined(&mpfr_set_ui);
		}
		undef(&mpfr_set_si) if defined(&mpfr_set_si);
		eval 'sub mpfr_set_si {
		    my($_f,$_s,$_r) = @_;
    		    eval q(( &__builtin_constant_p  && >= 0?  &mpfr_set_ui (, ($_s), ($_r)) :  &mpfr_set_si_2exp (($_f), ($_s), 0, ($_r))));
		}' unless defined(&mpfr_set_si);
		if((defined(&__GNUC__) ? &__GNUC__ : undef) > 3|| ((defined(&__GNUC__) ? &__GNUC__ : undef) == 3 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : undef) >= 4)) {
		    undef(&mpfr_mul_ui) if defined(&mpfr_mul_ui);
		    eval 'sub mpfr_mul_ui {
		        my($_f, $_g, $_u,$_r) = @_;
    			eval q(( &__builtin_constant_p  && >= 1 && ( & ( ($_u) - 1)) == 0?  &mpfr_mul_2si(($_f), ($_g),  &__builtin_ctzl ($_u), ($_r)) :  &mpfr_mul_ui (($_f), ($_g), ($_u), ($_r))));
		    }' unless defined(&mpfr_mul_ui);
		    undef(&mpfr_div_ui) if defined(&mpfr_div_ui);
		    eval 'sub mpfr_div_ui {
		        my($_f, $_g, $_u,$_r) = @_;
    			eval q(( &__builtin_constant_p  && >= 1 && ( & ( ($_u) - 1)) == 0?  &mpfr_mul_2si(($_f), ($_g), -  &__builtin_ctzl ($_u), ($_r)) :  &mpfr_div_ui (($_f), ($_g), ($_u), ($_r))));
		    }' unless defined(&mpfr_div_ui);
		}
		undef(&mpfr_mul_si) if defined(&mpfr_mul_si);
		eval 'sub mpfr_mul_si {
		    my($_f, $_g, $_s,$_r) = @_;
    		    eval q(( &__builtin_constant_p  && >= 0?  &mpfr_mul_ui (, , ($_s), ($_r)) :  &mpfr_mul_si (($_f), ($_g), ($_s), ($_r))));
		}' unless defined(&mpfr_mul_si);
		undef(&mpfr_div_si) if defined(&mpfr_div_si);
		eval 'sub mpfr_div_si {
		    my($_f, $_g, $_s,$_r) = @_;
    		    eval q(( &__builtin_constant_p  && >= 0?  &mpfr_div_ui (, , ($_s), ($_r)) :  &mpfr_div_si (($_f), ($_g), ($_s), ($_r))));
		}' unless defined(&mpfr_div_si);
	    }
	}
	eval 'sub mpfr_custom_get_size {
	    my($p) = @_;
    	    eval q((( &mpfr_size_t) ((($p)+ &GMP_NUMB_BITS-1)/ &GMP_NUMB_BITS*$sizeof{ &mp_limb_t})));
	}' unless defined(&mpfr_custom_get_size);
	eval 'sub mpfr_custom_init {
	    my($m,$p) = @_;
    	    eval q( &do {}  &while (0));
	}' unless defined(&mpfr_custom_init);
	eval 'sub mpfr_custom_get_significand {
	    my($x) = @_;
    	    eval q((( &mpfr_void*)(($x)-> &_mpfr_d)));
	}' unless defined(&mpfr_custom_get_significand);
	eval 'sub mpfr_custom_get_exp {
	    my($x) = @_;
    	    eval q((($x)-> &_mpfr_exp));
	}' unless defined(&mpfr_custom_get_exp);
	eval 'sub mpfr_custom_move {
	    my($x,$m) = @_;
    	    eval q( &do { (($x)-> &_mpfr_d = ( &mp_limb_t*)($m)); }  &while (0));
	}' unless defined(&mpfr_custom_move);
	eval 'sub mpfr_custom_init_set {
	    my($x,$k,$e,$p,$m) = @_;
    	    eval q( &do {  &mpfr_ptr  &_x = ($x);  &mpfr_exp_t  &_e;  &mpfr_kind_t  &_t;  &mpfr_int  &_s,  &_k;  &_k = ($k);  &if ( &_k >= 0) {  &_t = ( &mpfr_kind_t)  &_k;  &_s = 1; }  &else {  &_t = ( &mpfr_kind_t) -  &_k;  &_s = -1; }  &_e =  &_t ==  &MPFR_REGULAR_KIND ? ($e) :  &_t ==  &MPFR_NAN_KIND ?  &__MPFR_EXP_NAN :  &_t ==  &MPFR_INF_KIND ?  &__MPFR_EXP_INF :  &__MPFR_EXP_ZERO;  ($_$x->{_$mpfr_prec}) = ($p);  ($_$x->{_$mpfr_sign}) =  &_s;  ($_$x->{_$mpfr_exp})  =  &_e;  ($_$x->{_$mpfr_d})  = ( &mp_limb_t*) ($m); }  &while (0));
	}' unless defined(&mpfr_custom_init_set);
	eval 'sub mpfr_custom_get_kind {
	    my($x) = @_;
    	    eval q(( ($x)-> &_mpfr_exp >  &__MPFR_EXP_INF ? ( &mpfr_int)  &MPFR_REGULAR_KIND *  &MPFR_SIGN ($x) : ($x)-> &_mpfr_exp ==  &__MPFR_EXP_INF ? ( &mpfr_int)  &MPFR_INF_KIND *  &MPFR_SIGN ($x) : ($x)-> &_mpfr_exp ==  &__MPFR_EXP_NAN ? ( &mpfr_int)  &MPFR_NAN_KIND : ( &mpfr_int)  &MPFR_ZERO_KIND *  &MPFR_SIGN ($x) ));
	}' unless defined(&mpfr_custom_get_kind);
    }
    eval 'sub mpfr_init_set_si {
        my($x, $i, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_si(($x), ($i), ($rnd)) ));
    }' unless defined(&mpfr_init_set_si);
    eval 'sub mpfr_init_set_ui {
        my($x, $i, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_ui(($x), ($i), ($rnd)) ));
    }' unless defined(&mpfr_init_set_ui);
    eval 'sub mpfr_init_set_d {
        my($x, $d, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_d(($x), ($d), ($rnd)) ));
    }' unless defined(&mpfr_init_set_d);
    eval 'sub mpfr_init_set_ld {
        my($x, $d, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_ld(($x), ($d), ($rnd)) ));
    }' unless defined(&mpfr_init_set_ld);
    eval 'sub mpfr_init_set_z {
        my($x, $i, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set_z(($x), ($i), ($rnd)) ));
    }' unless defined(&mpfr_init_set_z);
    unless(defined(&MPFR_USE_MINI_GMP)) {
	eval 'sub mpfr_init_set_q {
	    my($x, $i, $rnd) = @_;
    	    eval q((  &mpfr_init($x),  &mpfr_set_q(($x), ($i), ($rnd)) ));
	}' unless defined(&mpfr_init_set_q);
	eval 'sub mpfr_init_set_f {
	    my($x, $y, $rnd) = @_;
    	    eval q((  &mpfr_init($x),  &mpfr_set_f(($x), ($y), ($rnd)) ));
	}' unless defined(&mpfr_init_set_f);
    }
    eval 'sub mpfr_init_set {
        my($x, $y, $rnd) = @_;
	    eval q((  &mpfr_init($x),  &mpfr_set(($x), ($y), ($rnd)) ));
    }' unless defined(&mpfr_init_set);
    eval 'sub mpfr_cmp_abs () { &mpfr_cmpabs;}' unless defined(&mpfr_cmp_abs);
    eval 'sub mpfr_round_prec {
        my($x,$r,$p) = @_;
	    eval q( &mpfr_prec_round($x,$p,$r));
    }' unless defined(&mpfr_round_prec);
    eval 'sub __gmp_default_rounding_mode () {( &mpfr_get_default_rounding_mode());}' unless defined(&__gmp_default_rounding_mode);
    eval 'sub __mpfr_emin () {( &mpfr_get_emin());}' unless defined(&__mpfr_emin);
    eval 'sub __mpfr_emax () {( &mpfr_get_emax());}' unless defined(&__mpfr_emax);
    eval 'sub __mpfr_default_fp_bit_precision () {( &mpfr_get_default_fp_bit_precision());}' unless defined(&__mpfr_default_fp_bit_precision);
    eval 'sub MPFR_EMIN_MIN () { &mpfr_get_emin_min();}' unless defined(&MPFR_EMIN_MIN);
    eval 'sub MPFR_EMIN_MAX () { &mpfr_get_emin_max();}' unless defined(&MPFR_EMIN_MAX);
    eval 'sub MPFR_EMAX_MIN () { &mpfr_get_emax_min();}' unless defined(&MPFR_EMAX_MIN);
    eval 'sub MPFR_EMAX_MAX () { &mpfr_get_emax_max();}' unless defined(&MPFR_EMAX_MAX);
    eval 'sub mpfr_version () {( &mpfr_get_version());}' unless defined(&mpfr_version);
    unless(defined(&mpz_set_fr)) {
	eval 'sub mpz_set_fr () { &mpfr_get_z;}' unless defined(&mpz_set_fr);
    }
    eval 'sub mpfr_get_z_exp () { &mpfr_get_z_2exp;}' unless defined(&mpfr_get_z_exp);
    eval 'sub mpfr_custom_get_mantissa () { &mpfr_custom_get_significand;}' unless defined(&mpfr_custom_get_mantissa);
}
if((defined (&INTMAX_C)  && defined (&UINTMAX_C)  && !defined(&__cplusplus)) || defined (&MPFR_USE_INTMAX_T) || defined (&_STDINT_H) || defined (&_STDINT_H_) || defined (&_STDINT) || defined (&_SYS_STDINT_H_) ) {
    unless(defined(&_MPFR_H_HAVE_INTMAX_T)) {
	eval 'sub _MPFR_H_HAVE_INTMAX_T () {1;}' unless defined(&_MPFR_H_HAVE_INTMAX_T);
	if(defined (&__cplusplus)) {
	}
	eval 'sub mpfr_set_sj () { &__gmpfr_set_sj;}' unless defined(&mpfr_set_sj);
	eval 'sub mpfr_set_sj_2exp () { &__gmpfr_set_sj_2exp;}' unless defined(&mpfr_set_sj_2exp);
	eval 'sub mpfr_set_uj () { &__gmpfr_set_uj;}' unless defined(&mpfr_set_uj);
	eval 'sub mpfr_set_uj_2exp () { &__gmpfr_set_uj_2exp;}' unless defined(&mpfr_set_uj_2exp);
	eval 'sub mpfr_get_sj () { &__gmpfr_mpfr_get_sj;}' unless defined(&mpfr_get_sj);
	eval 'sub mpfr_get_uj () { &__gmpfr_mpfr_get_uj;}' unless defined(&mpfr_get_uj);
	if(defined (&__cplusplus)) {
	}
    }
}
if(defined (&_GMP_H_HAVE_FILE) || defined (&MPFR_USE_FILE)) {
    unless(defined(&_MPFR_H_HAVE_FILE)) {
	eval 'sub _MPFR_H_HAVE_FILE () {1;}' unless defined(&_MPFR_H_HAVE_FILE);
	if(defined (&__cplusplus)) {
	}
	eval 'sub mpfr_inp_str () { &__gmpfr_inp_str;}' unless defined(&mpfr_inp_str);
	eval 'sub mpfr_out_str () { &__gmpfr_out_str;}' unless defined(&mpfr_out_str);
	unless(defined(&MPFR_USE_MINI_GMP)) {
	    eval 'sub mpfr_fprintf () { &__gmpfr_fprintf;}' unless defined(&mpfr_fprintf);
	}
	eval 'sub mpfr_fpif_export () { &__gmpfr_fpif_export;}' unless defined(&mpfr_fpif_export);
	eval 'sub mpfr_fpif_import () { &__gmpfr_fpif_import;}' unless defined(&mpfr_fpif_import);
	if(defined (&__cplusplus)) {
	}
    }
}
if(defined (&_GMP_H_HAVE_VA_LIST) || defined (&MPFR_USE_VA_LIST)) {
    unless(defined(&_MPFR_H_HAVE_VA_LIST)) {
	eval 'sub _MPFR_H_HAVE_VA_LIST () {1;}' unless defined(&_MPFR_H_HAVE_VA_LIST);
	if(defined (&__cplusplus)) {
	}
	eval 'sub mpfr_vprintf () { &__gmpfr_vprintf;}' unless defined(&mpfr_vprintf);
	eval 'sub mpfr_vasprintf () { &__gmpfr_vasprintf;}' unless defined(&mpfr_vasprintf);
	eval 'sub mpfr_vsprintf () { &__gmpfr_vsprintf;}' unless defined(&mpfr_vsprintf);
	eval 'sub mpfr_vsnprintf () { &__gmpfr_vsnprintf;}' unless defined(&mpfr_vsnprintf);
	if(defined (&__cplusplus)) {
	}
    }
}
if(defined (&_MPFR_H_HAVE_VA_LIST)  && defined (&_MPFR_H_HAVE_FILE)) {
    unless(defined(&_MPFR_H_HAVE_VA_LIST_FILE)) {
	eval 'sub _MPFR_H_HAVE_VA_LIST_FILE () {1;}' unless defined(&_MPFR_H_HAVE_VA_LIST_FILE);
	if(defined (&__cplusplus)) {
	}
	eval 'sub mpfr_vfprintf () { &__gmpfr_vfprintf;}' unless defined(&mpfr_vfprintf);
	if(defined (&__cplusplus)) {
	}
    }
}
1;
