require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_CMP_H)) {
    eval 'sub OPENSSL_CMP_H () {1;}' unless defined(&OPENSSL_CMP_H);
    require 'openssl/opensslconf.ph';
    unless(defined(&OPENSSL_NO_CMP)) {
	require 'openssl/crmf.ph';
	require 'openssl/cmperr.ph';
	require 'openssl/cmp_util.ph';
	require 'openssl/http.ph';
	require 'openssl/types.ph';
	require 'openssl/safestack.ph';
	require 'openssl/x509.ph';
	require 'openssl/x509v3.ph';
	if(defined(&__cplusplus)) {
	}
	eval 'sub OSSL_CMP_PVNO () {2;}' unless defined(&OSSL_CMP_PVNO);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badAlg () {0;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badAlg);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badMessageCheck () {1;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badMessageCheck);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badRequest () {2;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badRequest);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badTime () {3;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badTime);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badCertId () {4;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badCertId);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badDataFormat () {5;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badDataFormat);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_wrongAuthority () {6;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_wrongAuthority);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_incorrectData () {7;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_incorrectData);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_missingTimeStamp () {8;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_missingTimeStamp);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badPOP () {9;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badPOP);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_certRevoked () {10;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_certRevoked);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_certConfirmed () {11;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_certConfirmed);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_wrongIntegrity () {12;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_wrongIntegrity);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badRecipientNonce () {13;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badRecipientNonce);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_timeNotAvailable () {14;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_timeNotAvailable);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_unacceptedPolicy () {15;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_unacceptedPolicy);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_unacceptedExtension () {16;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_unacceptedExtension);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_addInfoNotAvailable () {17;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_addInfoNotAvailable);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badSenderNonce () {18;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badSenderNonce);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_badCertTemplate () {19;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_badCertTemplate);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_signerNotTrusted () {20;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_signerNotTrusted);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_transactionIdInUse () {21;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_transactionIdInUse);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_unsupportedVersion () {22;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_unsupportedVersion);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_notAuthorized () {23;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_notAuthorized);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_systemUnavail () {24;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_systemUnavail);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_systemFailure () {25;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_systemFailure);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_duplicateCertReq () {26;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_duplicateCertReq);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_MAX () {26;}' unless defined(&OSSL_CMP_PKIFAILUREINFO_MAX);
	eval 'sub OSSL_CMP_PKIFAILUREINFO_MAX_BIT_PATTERN () {((1<< ( &OSSL_CMP_PKIFAILUREINFO_MAX + 1)) - 1);}' unless defined(&OSSL_CMP_PKIFAILUREINFO_MAX_BIT_PATTERN);
	if((defined(&OSSL_CMP_PKIFAILUREINFO_MAX_BIT_PATTERN) ? &OSSL_CMP_PKIFAILUREINFO_MAX_BIT_PATTERN : undef) > (defined(&INT_MAX) ? &INT_MAX : undef)) {
	    die("CMP_PKIFAILUREINFO_MAX\ bit\ pattern\ does\ not\ fit\ in\ type\ int");
	}
	eval 'sub OSSL_CMP_CTX_FAILINFO_badAlg () {(1<< 0);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badAlg);
	eval 'sub OSSL_CMP_CTX_FAILINFO_badMessageCheck () {(1<< 1);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badMessageCheck);
	eval 'sub OSSL_CMP_CTX_FAILINFO_badRequest () {(1<< 2);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badRequest);
	eval 'sub OSSL_CMP_CTX_FAILINFO_badTime () {(1<< 3);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badTime);
	eval 'sub OSSL_CMP_CTX_FAILINFO_badCertId () {(1<< 4);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badCertId);
	eval 'sub OSSL_CMP_CTX_FAILINFO_badDataFormat () {(1<< 5);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badDataFormat);
	eval 'sub OSSL_CMP_CTX_FAILINFO_wrongAuthority () {(1<< 6);}' unless defined(&OSSL_CMP_CTX_FAILINFO_wrongAuthority);
	eval 'sub OSSL_CMP_CTX_FAILINFO_incorrectData () {(1<< 7);}' unless defined(&OSSL_CMP_CTX_FAILINFO_incorrectData);
	eval 'sub OSSL_CMP_CTX_FAILINFO_missingTimeStamp () {(1<< 8);}' unless defined(&OSSL_CMP_CTX_FAILINFO_missingTimeStamp);
	eval 'sub OSSL_CMP_CTX_FAILINFO_badPOP () {(1<< 9);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badPOP);
	eval 'sub OSSL_CMP_CTX_FAILINFO_certRevoked () {(1<< 10);}' unless defined(&OSSL_CMP_CTX_FAILINFO_certRevoked);
	eval 'sub OSSL_CMP_CTX_FAILINFO_certConfirmed () {(1<< 11);}' unless defined(&OSSL_CMP_CTX_FAILINFO_certConfirmed);
	eval 'sub OSSL_CMP_CTX_FAILINFO_wrongIntegrity () {(1<< 12);}' unless defined(&OSSL_CMP_CTX_FAILINFO_wrongIntegrity);
	eval 'sub OSSL_CMP_CTX_FAILINFO_badRecipientNonce () {(1<< 13);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badRecipientNonce);
	eval 'sub OSSL_CMP_CTX_FAILINFO_timeNotAvailable () {(1<< 14);}' unless defined(&OSSL_CMP_CTX_FAILINFO_timeNotAvailable);
	eval 'sub OSSL_CMP_CTX_FAILINFO_unacceptedPolicy () {(1<< 15);}' unless defined(&OSSL_CMP_CTX_FAILINFO_unacceptedPolicy);
	eval 'sub OSSL_CMP_CTX_FAILINFO_unacceptedExtension () {(1<< 16);}' unless defined(&OSSL_CMP_CTX_FAILINFO_unacceptedExtension);
	eval 'sub OSSL_CMP_CTX_FAILINFO_addInfoNotAvailable () {(1<< 17);}' unless defined(&OSSL_CMP_CTX_FAILINFO_addInfoNotAvailable);
	eval 'sub OSSL_CMP_CTX_FAILINFO_badSenderNonce () {(1<< 18);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badSenderNonce);
	eval 'sub OSSL_CMP_CTX_FAILINFO_badCertTemplate () {(1<< 19);}' unless defined(&OSSL_CMP_CTX_FAILINFO_badCertTemplate);
	eval 'sub OSSL_CMP_CTX_FAILINFO_signerNotTrusted () {(1<< 20);}' unless defined(&OSSL_CMP_CTX_FAILINFO_signerNotTrusted);
	eval 'sub OSSL_CMP_CTX_FAILINFO_transactionIdInUse () {(1<< 21);}' unless defined(&OSSL_CMP_CTX_FAILINFO_transactionIdInUse);
	eval 'sub OSSL_CMP_CTX_FAILINFO_unsupportedVersion () {(1<< 22);}' unless defined(&OSSL_CMP_CTX_FAILINFO_unsupportedVersion);
	eval 'sub OSSL_CMP_CTX_FAILINFO_notAuthorized () {(1<< 23);}' unless defined(&OSSL_CMP_CTX_FAILINFO_notAuthorized);
	eval 'sub OSSL_CMP_CTX_FAILINFO_systemUnavail () {(1<< 24);}' unless defined(&OSSL_CMP_CTX_FAILINFO_systemUnavail);
	eval 'sub OSSL_CMP_CTX_FAILINFO_systemFailure () {(1<< 25);}' unless defined(&OSSL_CMP_CTX_FAILINFO_systemFailure);
	eval 'sub OSSL_CMP_CTX_FAILINFO_duplicateCertReq () {(1<< 26);}' unless defined(&OSSL_CMP_CTX_FAILINFO_duplicateCertReq);
	eval 'sub OSSL_CMP_PKISTATUS_accepted () {0;}' unless defined(&OSSL_CMP_PKISTATUS_accepted);
	eval 'sub OSSL_CMP_PKISTATUS_grantedWithMods () {1;}' unless defined(&OSSL_CMP_PKISTATUS_grantedWithMods);
	eval 'sub OSSL_CMP_PKISTATUS_rejection () {2;}' unless defined(&OSSL_CMP_PKISTATUS_rejection);
	eval 'sub OSSL_CMP_PKISTATUS_waiting () {3;}' unless defined(&OSSL_CMP_PKISTATUS_waiting);
	eval 'sub OSSL_CMP_PKISTATUS_revocationWarning () {4;}' unless defined(&OSSL_CMP_PKISTATUS_revocationWarning);
	eval 'sub OSSL_CMP_PKISTATUS_revocationNotification () {5;}' unless defined(&OSSL_CMP_PKISTATUS_revocationNotification);
	eval 'sub OSSL_CMP_PKISTATUS_keyUpdateWarning () {6;}' unless defined(&OSSL_CMP_PKISTATUS_keyUpdateWarning);
	eval 'sub OSSL_CMP_CERTORENCCERT_CERTIFICATE () {0;}' unless defined(&OSSL_CMP_CERTORENCCERT_CERTIFICATE);
	eval 'sub OSSL_CMP_CERTORENCCERT_ENCRYPTEDCERT () {1;}' unless defined(&OSSL_CMP_CERTORENCCERT_ENCRYPTEDCERT);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_OSSL_CMP_CERTSTATUS_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_num);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_value {
	    my($sk, $idx) = @_;
    	    eval q((( &OSSL_CMP_CERTSTATUS *) &OPENSSL_sk_value( &ossl_check_const_OSSL_CMP_CERTSTATUS_sk_type($sk), ($idx))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_value);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTSTATUS) *) &OPENSSL_sk_new( &ossl_check_OSSL_CMP_CERTSTATUS_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_new);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_new_null () {
	    eval q((( &STACK_OF( &OSSL_CMP_CERTSTATUS) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_new_null);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTSTATUS) *) &OPENSSL_sk_new_reserve( &ossl_check_OSSL_CMP_CERTSTATUS_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_new_reserve);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk), ($n)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_reserve);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_free);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_zero);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_delete {
	    my($sk, $i) = @_;
    	    eval q((( &OSSL_CMP_CERTSTATUS *) &OPENSSL_sk_delete( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk), ($i))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_delete);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &OSSL_CMP_CERTSTATUS *) &OPENSSL_sk_delete_ptr( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk),  &ossl_check_OSSL_CMP_CERTSTATUS_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_delete_ptr);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk),  &ossl_check_OSSL_CMP_CERTSTATUS_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_push);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk),  &ossl_check_OSSL_CMP_CERTSTATUS_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_unshift);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_pop {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_CERTSTATUS *) &OPENSSL_sk_pop( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_pop);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_shift {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_CERTSTATUS *) &OPENSSL_sk_shift( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_shift);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk), &ossl_check_OSSL_CMP_CERTSTATUS_freefunc_type($freefunc)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_pop_free);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk),  &ossl_check_OSSL_CMP_CERTSTATUS_type($ptr), ($idx)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_insert);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &OSSL_CMP_CERTSTATUS *) &OPENSSL_sk_set( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk), ($idx),  &ossl_check_OSSL_CMP_CERTSTATUS_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_set);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk),  &ossl_check_OSSL_CMP_CERTSTATUS_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_find);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk),  &ossl_check_OSSL_CMP_CERTSTATUS_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_find_ex);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk),  &ossl_check_OSSL_CMP_CERTSTATUS_type($ptr), $pnum));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_find_all);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_sort);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OSSL_CMP_CERTSTATUS_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_is_sorted);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTSTATUS) *) &OPENSSL_sk_dup( &ossl_check_const_OSSL_CMP_CERTSTATUS_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_dup);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTSTATUS) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OSSL_CMP_CERTSTATUS_sk_type($sk),  &ossl_check_OSSL_CMP_CERTSTATUS_copyfunc_type($copyfunc),  &ossl_check_OSSL_CMP_CERTSTATUS_freefunc_type($freefunc))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_deep_copy);
	eval 'sub sk_OSSL_CMP_CERTSTATUS_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_OSSL_CMP_CERTSTATUS_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OSSL_CMP_CERTSTATUS_sk_type($sk),  &ossl_check_OSSL_CMP_CERTSTATUS_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_CERTSTATUS_set_cmp_func);
	eval 'sub sk_OSSL_CMP_ITAV_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_OSSL_CMP_ITAV_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_ITAV_num);
	eval 'sub sk_OSSL_CMP_ITAV_value {
	    my($sk, $idx) = @_;
    	    eval q((( &OSSL_CMP_ITAV *) &OPENSSL_sk_value( &ossl_check_const_OSSL_CMP_ITAV_sk_type($sk), ($idx))));
	}' unless defined(&sk_OSSL_CMP_ITAV_value);
	eval 'sub sk_OSSL_CMP_ITAV_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_ITAV) *) &OPENSSL_sk_new( &ossl_check_OSSL_CMP_ITAV_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_ITAV_new);
	eval 'sub sk_OSSL_CMP_ITAV_new_null () {
	    eval q((( &STACK_OF( &OSSL_CMP_ITAV) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_OSSL_CMP_ITAV_new_null);
	eval 'sub sk_OSSL_CMP_ITAV_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_ITAV) *) &OPENSSL_sk_new_reserve( &ossl_check_OSSL_CMP_ITAV_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_OSSL_CMP_ITAV_new_reserve);
	eval 'sub sk_OSSL_CMP_ITAV_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_OSSL_CMP_ITAV_sk_type($sk), ($n)));
	}' unless defined(&sk_OSSL_CMP_ITAV_reserve);
	eval 'sub sk_OSSL_CMP_ITAV_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_OSSL_CMP_ITAV_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_ITAV_free);
	eval 'sub sk_OSSL_CMP_ITAV_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_OSSL_CMP_ITAV_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_ITAV_zero);
	eval 'sub sk_OSSL_CMP_ITAV_delete {
	    my($sk, $i) = @_;
    	    eval q((( &OSSL_CMP_ITAV *) &OPENSSL_sk_delete( &ossl_check_OSSL_CMP_ITAV_sk_type($sk), ($i))));
	}' unless defined(&sk_OSSL_CMP_ITAV_delete);
	eval 'sub sk_OSSL_CMP_ITAV_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &OSSL_CMP_ITAV *) &OPENSSL_sk_delete_ptr( &ossl_check_OSSL_CMP_ITAV_sk_type($sk),  &ossl_check_OSSL_CMP_ITAV_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_ITAV_delete_ptr);
	eval 'sub sk_OSSL_CMP_ITAV_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_OSSL_CMP_ITAV_sk_type($sk),  &ossl_check_OSSL_CMP_ITAV_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_ITAV_push);
	eval 'sub sk_OSSL_CMP_ITAV_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_OSSL_CMP_ITAV_sk_type($sk),  &ossl_check_OSSL_CMP_ITAV_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_ITAV_unshift);
	eval 'sub sk_OSSL_CMP_ITAV_pop {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_ITAV *) &OPENSSL_sk_pop( &ossl_check_OSSL_CMP_ITAV_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_ITAV_pop);
	eval 'sub sk_OSSL_CMP_ITAV_shift {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_ITAV *) &OPENSSL_sk_shift( &ossl_check_OSSL_CMP_ITAV_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_ITAV_shift);
	eval 'sub sk_OSSL_CMP_ITAV_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OSSL_CMP_ITAV_sk_type($sk), &ossl_check_OSSL_CMP_ITAV_freefunc_type($freefunc)));
	}' unless defined(&sk_OSSL_CMP_ITAV_pop_free);
	eval 'sub sk_OSSL_CMP_ITAV_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_OSSL_CMP_ITAV_sk_type($sk),  &ossl_check_OSSL_CMP_ITAV_type($ptr), ($idx)));
	}' unless defined(&sk_OSSL_CMP_ITAV_insert);
	eval 'sub sk_OSSL_CMP_ITAV_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &OSSL_CMP_ITAV *) &OPENSSL_sk_set( &ossl_check_OSSL_CMP_ITAV_sk_type($sk), ($idx),  &ossl_check_OSSL_CMP_ITAV_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_ITAV_set);
	eval 'sub sk_OSSL_CMP_ITAV_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_OSSL_CMP_ITAV_sk_type($sk),  &ossl_check_OSSL_CMP_ITAV_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_ITAV_find);
	eval 'sub sk_OSSL_CMP_ITAV_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OSSL_CMP_ITAV_sk_type($sk),  &ossl_check_OSSL_CMP_ITAV_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_ITAV_find_ex);
	eval 'sub sk_OSSL_CMP_ITAV_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_OSSL_CMP_ITAV_sk_type($sk),  &ossl_check_OSSL_CMP_ITAV_type($ptr), $pnum));
	}' unless defined(&sk_OSSL_CMP_ITAV_find_all);
	eval 'sub sk_OSSL_CMP_ITAV_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_OSSL_CMP_ITAV_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_ITAV_sort);
	eval 'sub sk_OSSL_CMP_ITAV_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OSSL_CMP_ITAV_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_ITAV_is_sorted);
	eval 'sub sk_OSSL_CMP_ITAV_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_ITAV) *) &OPENSSL_sk_dup( &ossl_check_const_OSSL_CMP_ITAV_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_ITAV_dup);
	eval 'sub sk_OSSL_CMP_ITAV_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_ITAV) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OSSL_CMP_ITAV_sk_type($sk),  &ossl_check_OSSL_CMP_ITAV_copyfunc_type($copyfunc),  &ossl_check_OSSL_CMP_ITAV_freefunc_type($freefunc))));
	}' unless defined(&sk_OSSL_CMP_ITAV_deep_copy);
	eval 'sub sk_OSSL_CMP_ITAV_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_OSSL_CMP_ITAV_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OSSL_CMP_ITAV_sk_type($sk),  &ossl_check_OSSL_CMP_ITAV_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_ITAV_set_cmp_func);
	eval 'sub sk_OSSL_CMP_PKISI_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_OSSL_CMP_PKISI_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_PKISI_num);
	eval 'sub sk_OSSL_CMP_PKISI_value {
	    my($sk, $idx) = @_;
    	    eval q((( &OSSL_CMP_PKISI *) &OPENSSL_sk_value( &ossl_check_const_OSSL_CMP_PKISI_sk_type($sk), ($idx))));
	}' unless defined(&sk_OSSL_CMP_PKISI_value);
	eval 'sub sk_OSSL_CMP_PKISI_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_PKISI) *) &OPENSSL_sk_new( &ossl_check_OSSL_CMP_PKISI_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_PKISI_new);
	eval 'sub sk_OSSL_CMP_PKISI_new_null () {
	    eval q((( &STACK_OF( &OSSL_CMP_PKISI) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_OSSL_CMP_PKISI_new_null);
	eval 'sub sk_OSSL_CMP_PKISI_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_PKISI) *) &OPENSSL_sk_new_reserve( &ossl_check_OSSL_CMP_PKISI_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_OSSL_CMP_PKISI_new_reserve);
	eval 'sub sk_OSSL_CMP_PKISI_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_OSSL_CMP_PKISI_sk_type($sk), ($n)));
	}' unless defined(&sk_OSSL_CMP_PKISI_reserve);
	eval 'sub sk_OSSL_CMP_PKISI_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_OSSL_CMP_PKISI_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_PKISI_free);
	eval 'sub sk_OSSL_CMP_PKISI_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_OSSL_CMP_PKISI_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_PKISI_zero);
	eval 'sub sk_OSSL_CMP_PKISI_delete {
	    my($sk, $i) = @_;
    	    eval q((( &OSSL_CMP_PKISI *) &OPENSSL_sk_delete( &ossl_check_OSSL_CMP_PKISI_sk_type($sk), ($i))));
	}' unless defined(&sk_OSSL_CMP_PKISI_delete);
	eval 'sub sk_OSSL_CMP_PKISI_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &OSSL_CMP_PKISI *) &OPENSSL_sk_delete_ptr( &ossl_check_OSSL_CMP_PKISI_sk_type($sk),  &ossl_check_OSSL_CMP_PKISI_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_PKISI_delete_ptr);
	eval 'sub sk_OSSL_CMP_PKISI_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_OSSL_CMP_PKISI_sk_type($sk),  &ossl_check_OSSL_CMP_PKISI_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_PKISI_push);
	eval 'sub sk_OSSL_CMP_PKISI_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_OSSL_CMP_PKISI_sk_type($sk),  &ossl_check_OSSL_CMP_PKISI_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_PKISI_unshift);
	eval 'sub sk_OSSL_CMP_PKISI_pop {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_PKISI *) &OPENSSL_sk_pop( &ossl_check_OSSL_CMP_PKISI_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_PKISI_pop);
	eval 'sub sk_OSSL_CMP_PKISI_shift {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_PKISI *) &OPENSSL_sk_shift( &ossl_check_OSSL_CMP_PKISI_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_PKISI_shift);
	eval 'sub sk_OSSL_CMP_PKISI_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OSSL_CMP_PKISI_sk_type($sk), &ossl_check_OSSL_CMP_PKISI_freefunc_type($freefunc)));
	}' unless defined(&sk_OSSL_CMP_PKISI_pop_free);
	eval 'sub sk_OSSL_CMP_PKISI_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_OSSL_CMP_PKISI_sk_type($sk),  &ossl_check_OSSL_CMP_PKISI_type($ptr), ($idx)));
	}' unless defined(&sk_OSSL_CMP_PKISI_insert);
	eval 'sub sk_OSSL_CMP_PKISI_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &OSSL_CMP_PKISI *) &OPENSSL_sk_set( &ossl_check_OSSL_CMP_PKISI_sk_type($sk), ($idx),  &ossl_check_OSSL_CMP_PKISI_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_PKISI_set);
	eval 'sub sk_OSSL_CMP_PKISI_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_OSSL_CMP_PKISI_sk_type($sk),  &ossl_check_OSSL_CMP_PKISI_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_PKISI_find);
	eval 'sub sk_OSSL_CMP_PKISI_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OSSL_CMP_PKISI_sk_type($sk),  &ossl_check_OSSL_CMP_PKISI_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_PKISI_find_ex);
	eval 'sub sk_OSSL_CMP_PKISI_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_OSSL_CMP_PKISI_sk_type($sk),  &ossl_check_OSSL_CMP_PKISI_type($ptr), $pnum));
	}' unless defined(&sk_OSSL_CMP_PKISI_find_all);
	eval 'sub sk_OSSL_CMP_PKISI_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_OSSL_CMP_PKISI_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_PKISI_sort);
	eval 'sub sk_OSSL_CMP_PKISI_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OSSL_CMP_PKISI_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_PKISI_is_sorted);
	eval 'sub sk_OSSL_CMP_PKISI_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_PKISI) *) &OPENSSL_sk_dup( &ossl_check_const_OSSL_CMP_PKISI_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_PKISI_dup);
	eval 'sub sk_OSSL_CMP_PKISI_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_PKISI) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OSSL_CMP_PKISI_sk_type($sk),  &ossl_check_OSSL_CMP_PKISI_copyfunc_type($copyfunc),  &ossl_check_OSSL_CMP_PKISI_freefunc_type($freefunc))));
	}' unless defined(&sk_OSSL_CMP_PKISI_deep_copy);
	eval 'sub sk_OSSL_CMP_PKISI_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_OSSL_CMP_PKISI_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OSSL_CMP_PKISI_sk_type($sk),  &ossl_check_OSSL_CMP_PKISI_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_PKISI_set_cmp_func);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_OSSL_CMP_CERTREPMESSAGE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_num);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_value {
	    my($sk, $idx) = @_;
    	    eval q((( &OSSL_CMP_CERTREPMESSAGE *) &OPENSSL_sk_value( &ossl_check_const_OSSL_CMP_CERTREPMESSAGE_sk_type($sk), ($idx))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_value);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTREPMESSAGE) *) &OPENSSL_sk_new( &ossl_check_OSSL_CMP_CERTREPMESSAGE_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_new);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_new_null () {
	    eval q((( &STACK_OF( &OSSL_CMP_CERTREPMESSAGE) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_new_null);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTREPMESSAGE) *) &OPENSSL_sk_new_reserve( &ossl_check_OSSL_CMP_CERTREPMESSAGE_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_new_reserve);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk), ($n)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_reserve);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_free);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_zero);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_delete {
	    my($sk, $i) = @_;
    	    eval q((( &OSSL_CMP_CERTREPMESSAGE *) &OPENSSL_sk_delete( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk), ($i))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_delete);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &OSSL_CMP_CERTREPMESSAGE *) &OPENSSL_sk_delete_ptr( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_delete_ptr);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_push);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_unshift);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_pop {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_CERTREPMESSAGE *) &OPENSSL_sk_pop( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_pop);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_shift {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_CERTREPMESSAGE *) &OPENSSL_sk_shift( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_shift);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk), &ossl_check_OSSL_CMP_CERTREPMESSAGE_freefunc_type($freefunc)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_pop_free);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_type($ptr), ($idx)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_insert);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &OSSL_CMP_CERTREPMESSAGE *) &OPENSSL_sk_set( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk), ($idx),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_set);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_find);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_find_ex);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_type($ptr), $pnum));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_find_all);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_sort);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OSSL_CMP_CERTREPMESSAGE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_is_sorted);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTREPMESSAGE) *) &OPENSSL_sk_dup( &ossl_check_const_OSSL_CMP_CERTREPMESSAGE_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_dup);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTREPMESSAGE) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OSSL_CMP_CERTREPMESSAGE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_copyfunc_type($copyfunc),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_freefunc_type($freefunc))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_deep_copy);
	eval 'sub sk_OSSL_CMP_CERTREPMESSAGE_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_OSSL_CMP_CERTREPMESSAGE_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OSSL_CMP_CERTREPMESSAGE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTREPMESSAGE_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_CERTREPMESSAGE_set_cmp_func);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_OSSL_CMP_CERTRESPONSE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_num);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_value {
	    my($sk, $idx) = @_;
    	    eval q((( &OSSL_CMP_CERTRESPONSE *) &OPENSSL_sk_value( &ossl_check_const_OSSL_CMP_CERTRESPONSE_sk_type($sk), ($idx))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_value);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTRESPONSE) *) &OPENSSL_sk_new( &ossl_check_OSSL_CMP_CERTRESPONSE_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_new);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_new_null () {
	    eval q((( &STACK_OF( &OSSL_CMP_CERTRESPONSE) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_new_null);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTRESPONSE) *) &OPENSSL_sk_new_reserve( &ossl_check_OSSL_CMP_CERTRESPONSE_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_new_reserve);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk), ($n)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_reserve);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_free);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_zero);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_delete {
	    my($sk, $i) = @_;
    	    eval q((( &OSSL_CMP_CERTRESPONSE *) &OPENSSL_sk_delete( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk), ($i))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_delete);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &OSSL_CMP_CERTRESPONSE *) &OPENSSL_sk_delete_ptr( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTRESPONSE_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_delete_ptr);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTRESPONSE_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_push);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTRESPONSE_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_unshift);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_pop {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_CERTRESPONSE *) &OPENSSL_sk_pop( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_pop);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_shift {
	    my($sk) = @_;
    	    eval q((( &OSSL_CMP_CERTRESPONSE *) &OPENSSL_sk_shift( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_shift);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk), &ossl_check_OSSL_CMP_CERTRESPONSE_freefunc_type($freefunc)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_pop_free);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTRESPONSE_type($ptr), ($idx)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_insert);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &OSSL_CMP_CERTRESPONSE *) &OPENSSL_sk_set( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk), ($idx),  &ossl_check_OSSL_CMP_CERTRESPONSE_type($ptr))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_set);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTRESPONSE_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_find);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTRESPONSE_type($ptr)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_find_ex);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTRESPONSE_type($ptr), $pnum));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_find_all);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_sort);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OSSL_CMP_CERTRESPONSE_sk_type($sk)));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_is_sorted);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTRESPONSE) *) &OPENSSL_sk_dup( &ossl_check_const_OSSL_CMP_CERTRESPONSE_sk_type($sk))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_dup);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &OSSL_CMP_CERTRESPONSE) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OSSL_CMP_CERTRESPONSE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTRESPONSE_copyfunc_type($copyfunc),  &ossl_check_OSSL_CMP_CERTRESPONSE_freefunc_type($freefunc))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_deep_copy);
	eval 'sub sk_OSSL_CMP_CERTRESPONSE_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_OSSL_CMP_CERTRESPONSE_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OSSL_CMP_CERTRESPONSE_sk_type($sk),  &ossl_check_OSSL_CMP_CERTRESPONSE_compfunc_type($cmp))));
	}' unless defined(&sk_OSSL_CMP_CERTRESPONSE_set_cmp_func);
	eval 'sub OSSL_CMP_OPT_LOG_VERBOSITY () {0;}' unless defined(&OSSL_CMP_OPT_LOG_VERBOSITY);
	eval 'sub OSSL_CMP_OPT_KEEP_ALIVE () {10;}' unless defined(&OSSL_CMP_OPT_KEEP_ALIVE);
	eval 'sub OSSL_CMP_OPT_MSG_TIMEOUT () {11;}' unless defined(&OSSL_CMP_OPT_MSG_TIMEOUT);
	eval 'sub OSSL_CMP_OPT_TOTAL_TIMEOUT () {12;}' unless defined(&OSSL_CMP_OPT_TOTAL_TIMEOUT);
	eval 'sub OSSL_CMP_OPT_VALIDITY_DAYS () {20;}' unless defined(&OSSL_CMP_OPT_VALIDITY_DAYS);
	eval 'sub OSSL_CMP_OPT_SUBJECTALTNAME_NODEFAULT () {21;}' unless defined(&OSSL_CMP_OPT_SUBJECTALTNAME_NODEFAULT);
	eval 'sub OSSL_CMP_OPT_SUBJECTALTNAME_CRITICAL () {22;}' unless defined(&OSSL_CMP_OPT_SUBJECTALTNAME_CRITICAL);
	eval 'sub OSSL_CMP_OPT_POLICIES_CRITICAL () {23;}' unless defined(&OSSL_CMP_OPT_POLICIES_CRITICAL);
	eval 'sub OSSL_CMP_OPT_POPO_METHOD () {24;}' unless defined(&OSSL_CMP_OPT_POPO_METHOD);
	eval 'sub OSSL_CMP_OPT_IMPLICIT_CONFIRM () {25;}' unless defined(&OSSL_CMP_OPT_IMPLICIT_CONFIRM);
	eval 'sub OSSL_CMP_OPT_DISABLE_CONFIRM () {26;}' unless defined(&OSSL_CMP_OPT_DISABLE_CONFIRM);
	eval 'sub OSSL_CMP_OPT_REVOCATION_REASON () {27;}' unless defined(&OSSL_CMP_OPT_REVOCATION_REASON);
	eval 'sub OSSL_CMP_OPT_UNPROTECTED_SEND () {30;}' unless defined(&OSSL_CMP_OPT_UNPROTECTED_SEND);
	eval 'sub OSSL_CMP_OPT_UNPROTECTED_ERRORS () {31;}' unless defined(&OSSL_CMP_OPT_UNPROTECTED_ERRORS);
	eval 'sub OSSL_CMP_OPT_OWF_ALGNID () {32;}' unless defined(&OSSL_CMP_OPT_OWF_ALGNID);
	eval 'sub OSSL_CMP_OPT_MAC_ALGNID () {33;}' unless defined(&OSSL_CMP_OPT_MAC_ALGNID);
	eval 'sub OSSL_CMP_OPT_DIGEST_ALGNID () {34;}' unless defined(&OSSL_CMP_OPT_DIGEST_ALGNID);
	eval 'sub OSSL_CMP_OPT_IGNORE_KEYUSAGE () {35;}' unless defined(&OSSL_CMP_OPT_IGNORE_KEYUSAGE);
	eval 'sub OSSL_CMP_OPT_PERMIT_TA_IN_EXTRACERTS_FOR_IR () {36;}' unless defined(&OSSL_CMP_OPT_PERMIT_TA_IN_EXTRACERTS_FOR_IR);
	eval 'sub OSSL_CMP_CTX_set_log_verbosity {
	    my($ctx, $level) = @_;
    	    eval q( &OSSL_CMP_CTX_set_option($ctx,  &OSSL_CMP_OPT_LOG_VERBOSITY, $level));
	}' unless defined(&OSSL_CMP_CTX_set_log_verbosity);
	eval 'sub OSSL_CMP_PKISI_BUFLEN () {1024;}' unless defined(&OSSL_CMP_PKISI_BUFLEN);
	eval 'sub OSSL_CMP_IR () {0;}' unless defined(&OSSL_CMP_IR);
	eval 'sub OSSL_CMP_CR () {2;}' unless defined(&OSSL_CMP_CR);
	eval 'sub OSSL_CMP_P10CR () {4;}' unless defined(&OSSL_CMP_P10CR);
	eval 'sub OSSL_CMP_KUR () {7;}' unless defined(&OSSL_CMP_KUR);
	eval 'sub OSSL_CMP_exec_IR_ses {
	    my($ctx) = @_;
    	    eval q( &OSSL_CMP_exec_certreq($ctx,  &OSSL_CMP_IR,  &NULL));
	}' unless defined(&OSSL_CMP_exec_IR_ses);
	eval 'sub OSSL_CMP_exec_CR_ses {
	    my($ctx) = @_;
    	    eval q( &OSSL_CMP_exec_certreq($ctx,  &OSSL_CMP_CR,  &NULL));
	}' unless defined(&OSSL_CMP_exec_CR_ses);
	eval 'sub OSSL_CMP_exec_P10CR_ses {
	    my($ctx) = @_;
    	    eval q( &OSSL_CMP_exec_certreq($ctx,  &OSSL_CMP_P10CR,  &NULL));
	}' unless defined(&OSSL_CMP_exec_P10CR_ses);
	eval 'sub OSSL_CMP_exec_KUR_ses {
	    my($ctx) = @_;
    	    eval q( &OSSL_CMP_exec_certreq($ctx,  &OSSL_CMP_KUR,  &NULL));
	}' unless defined(&OSSL_CMP_exec_KUR_ses);
	if(defined(&__cplusplus)) {
	}
    }
}
1;
