require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&SKALIBS_BUFFER_H)) {
    eval 'sub SKALIBS_BUFFER_H () {1;}' unless defined(&SKALIBS_BUFFER_H);
    require 'sys/uio.ph';
    require 'skalibs/gccattributes.ph';
    require 'skalibs/allreadwrite.ph';
    require 'skalibs/cbuffer.ph';
    require 'skalibs/functypes.ph';
    eval 'sub BUFFER_ZERO () {{ 0, -1,  &CBUFFER_ZERO };}' unless defined(&BUFFER_ZERO);
    eval 'sub BUFFER_INSIZE () {8192;}' unless defined(&BUFFER_INSIZE);
    eval 'sub BUFFER_OUTSIZE () {8192;}' unless defined(&BUFFER_OUTSIZE);
    eval 'sub BUFFER_ERRSIZE () {1024;}' unless defined(&BUFFER_ERRSIZE);
    eval 'sub BUFFER_INSIZE_SMALL () {512;}' unless defined(&BUFFER_INSIZE_SMALL);
    eval 'sub BUFFER_OUTSIZE_SMALL () {512;}' unless defined(&BUFFER_OUTSIZE_SMALL);
    eval 'sub BUFFER_INIT {
        my($f, $d, $buf, $len) = @_;
	    eval q({ ($f), ($d),  &CBUFFER_INIT($buf, $len) });
    }' unless defined(&BUFFER_INIT);
    eval 'sub buffer_putnoflush {
        my($b, $s, $len) = @_;
	    eval q( &cbuffer_put(($b)-> &c, $s, $len));
    }' unless defined(&buffer_putnoflush);
    eval 'sub buffer_putvnoflush {
        my($b, $v, $n) = @_;
	    eval q( &cbuffer_putv(($b)-> &c, $v, $n));
    }' unless defined(&buffer_putvnoflush);
    eval 'sub buffer_putallflush {
        my($b, $s, $len, $w) = @_;
	    eval q(( &buffer_putall($b, $s, $len, $w)  &&  &buffer_flush($b)));
    }' unless defined(&buffer_putallflush);
    eval 'sub buffer_putvallflush {
        my($b, $v, $n, $w) = @_;
	    eval q(( &buffer_putvall($b, $v, $n, $w)  &&  &buffer_flush($b)));
    }' unless defined(&buffer_putvallflush);
    eval 'sub buffer_unput {
        my($b, $n) = @_;
	    eval q( &cbuffer_unput(($b)-> &c, $n));
    }' unless defined(&buffer_unput);
    eval 'sub buffer_wpeek {
        my($b, $v) = @_;
	    eval q( &cbuffer_wpeek(($b)-> &c, $v));
    }' unless defined(&buffer_wpeek);
    eval 'sub buffer_wseek {
        my($b, $n) = @_;
	    eval q( &cbuffer_wseek(($b)-> &c, $n));
    }' unless defined(&buffer_wseek);
    eval 'sub buffer_getnofill {
        my($b, $s, $len) = @_;
	    eval q( &cbuffer_get(($b)-> &c, $s, $len));
    }' unless defined(&buffer_getnofill);
    eval 'sub buffer_getvnofill {
        my($b, $v, $n) = @_;
	    eval q( &cbuffer_getv(($b)-> &c, $v, $n));
    }' unless defined(&buffer_getvnofill);
    eval 'sub buffer_unget {
        my($b, $n) = @_;
	    eval q( &cbuffer_unget(($b)-> &c, $n));
    }' unless defined(&buffer_unget);
    eval 'sub buffer_rpeek {
        my($b, $v) = @_;
	    eval q( &cbuffer_rpeek(($b)-> &c, $v));
    }' unless defined(&buffer_rpeek);
    eval 'sub buffer_rseek {
        my($b, $n) = @_;
	    eval q( &cbuffer_rseek(($b)-> &c, $n));
    }' unless defined(&buffer_rseek);
    eval 'sub buffer_len {
        my($b) = @_;
	    eval q( &cbuffer_len(($b)-> &c));
    }' unless defined(&buffer_len);
    eval 'sub buffer_available {
        my($b) = @_;
	    eval q( &cbuffer_available(($b)-> &c));
    }' unless defined(&buffer_available);
    eval 'sub buffer_isempty {
        my($b) = @_;
	    eval q( &cbuffer_isempty(($b)-> &c));
    }' unless defined(&buffer_isempty);
    eval 'sub buffer_isfull {
        my($b) = @_;
	    eval q( &cbuffer_isfull(($b)-> &c));
    }' unless defined(&buffer_isfull);
    eval 'sub buffer_fd {
        my($b) = @_;
	    eval q((($b)-> &fd));
    }' unless defined(&buffer_fd);
    eval 'sub buffer_isreadable {
        my($b) = @_;
	    eval q((! &buffer_isfull($b)));
    }' unless defined(&buffer_isreadable);
    eval 'sub buffer_iswritable {
        my($b) = @_;
	    eval q((! &buffer_isempty($b)));
    }' unless defined(&buffer_iswritable);
    eval 'sub buffer_read () { &fd_readv;}' unless defined(&buffer_read);
    eval 'sub buffer_write () { &fd_writev;}' unless defined(&buffer_write);
    eval 'sub buffer_0 () {( &buffer_0_);}' unless defined(&buffer_0);
    eval 'sub buffer_0small () {( &buffer_0small_);}' unless defined(&buffer_0small);
    eval 'sub buffer_0f1 () {( &buffer_0f1_);}' unless defined(&buffer_0f1);
    eval 'sub buffer_1 () {( &buffer_1_);}' unless defined(&buffer_1);
    eval 'sub buffer_1small () {( &buffer_1small_);}' unless defined(&buffer_1small);
    eval 'sub buffer_2 () {( &buffer_2_);}' unless defined(&buffer_2);
}
1;
