require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&SKALIBS_TAI_H)) {
    eval 'sub SKALIBS_TAI_H () {1;}' unless defined(&SKALIBS_TAI_H);
    require 'stdint.ph';
    require 'time.ph';
    require 'sys/time.ph';
    require 'skalibs/gccattributes.ph';
    require 'skalibs/uint64.ph';
    eval 'sub TAI_ZERO () {{ 0};}' unless defined(&TAI_ZERO);
    eval 'sub TAI_MAGIC () {(( &uint64_t)4611686018427387904);}' unless defined(&TAI_MAGIC);
    eval 'sub TAI_EPOCH () {{  &TAI_MAGIC + 10 };}' unless defined(&TAI_EPOCH);
    eval 'sub TAI_INFINITE_RELATIVE () {{ ( &uint64_t)1<< 61};}' unless defined(&TAI_INFINITE_RELATIVE);
    eval 'sub TAI_INFINITE () {{  &TAI_MAGIC + (( &uint64_t)1<< 61) };}' unless defined(&TAI_INFINITE);
    eval 'sub tai_sec {
        my($t) = @_;
	    eval q((($t)-> &x));
    }' unless defined(&tai_sec);
    eval 'sub tai_unix {
        my($t, $u) = @_;
	    eval q( &tai_u64($t, ( &TAI_MAGIC + ($u))));
    }' unless defined(&tai_unix);
    eval 'sub tai_uint {
        my($t, $u) = @_;
	    eval q( &tai_u64($t, ( &uint64_t)($u)));
    }' unless defined(&tai_uint);
    eval 'sub tai_relative_from_time {
        my($t, $u) = @_;
	    eval q((($t)-> &x = ( &uint64_t)($u), 1));
    }' unless defined(&tai_relative_from_time);
    eval 'sub tai_from_time {
        my($t, $u) = @_;
	    eval q( &tai_unix($t, $u));
    }' unless defined(&tai_from_time);
    eval 'sub tai_from_time_sysclock {
        my($t, $u) = @_;
	    eval q( &tai_from_sysclock($t, ( &uint64_t)($u) +  &TAI_MAGIC));
    }' unless defined(&tai_from_time_sysclock);
    eval 'sub tai_approx {
        my($t) = @_;
	    eval q((( &tai_sec($t))));
    }' unless defined(&tai_approx);
    eval 'sub tai_less {
        my($t,$u) = @_;
	    eval q(( &tai_sec($t) <  &tai_sec($u)));
    }' unless defined(&tai_less);
    eval 'sub TAI_PACK () {8;}' unless defined(&TAI_PACK);
    eval 'sub TAIN_ZERO () {{  &TAI_ZERO, 0};}' unless defined(&TAIN_ZERO);
    eval 'sub TAIN_EPOCH () {{  &TAI_EPOCH, 0};}' unless defined(&TAIN_EPOCH);
    eval 'sub TAIN_INFINITE () {{  &TAI_INFINITE, 0};}' unless defined(&TAIN_INFINITE);
    eval 'sub TAIN_INFINITE_RELATIVE () {{  &TAI_INFINITE_RELATIVE, 0};}' unless defined(&TAIN_INFINITE_RELATIVE);
    eval 'sub TAIN_NANO500 () {{  &TAI_ZERO, 500};}' unless defined(&TAIN_NANO500);
    eval 'sub tain_sec {
        my($a) = @_;
	    eval q((($a)-> &sec));
    }' unless defined(&tain_sec);
    eval 'sub tain_secp {
        my($a) = @_;
	    eval q((($a)-> &sec));
    }' unless defined(&tain_secp);
    eval 'sub tain_nano {
        my($a) = @_;
	    eval q((($a)-> &nano));
    }' unless defined(&tain_nano);
    eval 'sub tain_wallclock_read_g () {
        eval q( &tain_wallclock_read( &STAMP));
    }' unless defined(&tain_wallclock_read_g);
    eval 'sub tain_stopwatch_read_g {
        my($cl, $offset) = @_;
	    eval q( &tain_stopwatch_read( &STAMP, ($cl), $offset));
    }' unless defined(&tain_stopwatch_read_g);
    eval 'sub tain_now_g () {
        eval q((* &tain_now)( &STAMP));
    }' unless defined(&tain_now_g);
    eval 'sub tain_copynow {
        my($t) = @_;
	    eval q((*($t) =  &STAMP));
    }' unless defined(&tain_copynow);
    eval 'sub tain_now_set_wallclock_g () {
        eval q( &tain_now_set_wallclock( &STAMP));
    }' unless defined(&tain_now_set_wallclock_g);
    eval 'sub tain_now_set_stopwatch_g () {
        eval q( &tain_now_set_stopwatch( &STAMP));
    }' unless defined(&tain_now_set_stopwatch_g);
    eval 'sub tain_add_g {
        my($deadline, $tto) = @_;
	    eval q( &tain_add($deadline,  &STAMP, $tto));
    }' unless defined(&tain_add_g);
    eval 'sub tain_addsec_g {
        my($deadline, $n) = @_;
	    eval q( &tain_addsec($deadline,  &STAMP, $n));
    }' unless defined(&tain_addsec_g);
    eval 'sub tain_future {
        my($deadline) = @_;
	    eval q( &tain_less( &STAMP, ($deadline)));
    }' unless defined(&tain_future);
    eval 'sub TAIN_PACK () {12;}' unless defined(&TAIN_PACK);
    eval 'sub TAIN_FMT () {25;}' unless defined(&TAIN_FMT);
    eval 'sub TAIN_FMTFRAC () {19;}' unless defined(&TAIN_FMTFRAC);
    eval 'sub tain_uint {
        my($a, $u) = @_;
	    eval q( &tain_ulong($a, $u));
    }' unless defined(&tain_uint);
    eval 'sub TIMESTAMP () {(1+ ( &TAIN_PACK << 1));}' unless defined(&TIMESTAMP);
    eval 'sub timestamp_g {
        my($s) = @_;
	    eval q( &timestamp_fmt(($s),  &STAMP));
    }' unless defined(&timestamp_g);
}
1;
