require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__SOUND_ASOUND_H)) {
    eval 'sub __SOUND_ASOUND_H () {1;}' unless defined(&__SOUND_ASOUND_H);
    if(defined(&__KERNEL__) || defined(&__linux__)) {
	require 'linux/types.ph';
	require 'asm/byteorder.ph';
    } else {
	require 'endian.ph';
	require 'sys/ioctl.ph';
    }
    require 'stdlib.ph';
    require 'time.ph';
    eval 'sub SNDRV_PROTOCOL_VERSION {
        my($major, $minor, $subminor) = @_;
	    eval q(((($major)<<16)|(($minor)<<8)|($subminor)));
    }' unless defined(&SNDRV_PROTOCOL_VERSION);
    eval 'sub SNDRV_PROTOCOL_MAJOR {
        my($version) = @_;
	    eval q(((($version)>>16)&0xffff));
    }' unless defined(&SNDRV_PROTOCOL_MAJOR);
    eval 'sub SNDRV_PROTOCOL_MINOR {
        my($version) = @_;
	    eval q(((($version)>>8)&0xff));
    }' unless defined(&SNDRV_PROTOCOL_MINOR);
    eval 'sub SNDRV_PROTOCOL_MICRO {
        my($version) = @_;
	    eval q((($version)&0xff));
    }' unless defined(&SNDRV_PROTOCOL_MICRO);
    eval 'sub SNDRV_PROTOCOL_INCOMPATIBLE {
        my($kversion, $uversion) = @_;
	    eval q(( &SNDRV_PROTOCOL_MAJOR($kversion) !=  &SNDRV_PROTOCOL_MAJOR($uversion) || ( &SNDRV_PROTOCOL_MAJOR($kversion) ==  &SNDRV_PROTOCOL_MAJOR($uversion)  &&  &SNDRV_PROTOCOL_MINOR($kversion) !=  &SNDRV_PROTOCOL_MINOR($uversion))));
    }' unless defined(&SNDRV_PROTOCOL_INCOMPATIBLE);
    eval 'sub AES_IEC958_STATUS_SIZE () {24;}' unless defined(&AES_IEC958_STATUS_SIZE);
    eval 'sub SNDRV_HWDEP_VERSION () { &SNDRV_PROTOCOL_VERSION(1, 0, 1);}' unless defined(&SNDRV_HWDEP_VERSION);
    eval("sub SNDRV_HWDEP_IFACE_OPL2 () { 0; }") unless defined(&SNDRV_HWDEP_IFACE_OPL2);
    eval("sub SNDRV_HWDEP_IFACE_OPL3 () { 1; }") unless defined(&SNDRV_HWDEP_IFACE_OPL3);
    eval("sub SNDRV_HWDEP_IFACE_OPL4 () { 2; }") unless defined(&SNDRV_HWDEP_IFACE_OPL4);
    eval("sub SNDRV_HWDEP_IFACE_SB16CSP () { 3; }") unless defined(&SNDRV_HWDEP_IFACE_SB16CSP);
    eval("sub SNDRV_HWDEP_IFACE_EMU10K1 () { 4; }") unless defined(&SNDRV_HWDEP_IFACE_EMU10K1);
    eval("sub SNDRV_HWDEP_IFACE_YSS225 () { 5; }") unless defined(&SNDRV_HWDEP_IFACE_YSS225);
    eval("sub SNDRV_HWDEP_IFACE_ICS2115 () { 6; }") unless defined(&SNDRV_HWDEP_IFACE_ICS2115);
    eval("sub SNDRV_HWDEP_IFACE_SSCAPE () { 7; }") unless defined(&SNDRV_HWDEP_IFACE_SSCAPE);
    eval("sub SNDRV_HWDEP_IFACE_VX () { 8; }") unless defined(&SNDRV_HWDEP_IFACE_VX);
    eval("sub SNDRV_HWDEP_IFACE_MIXART () { 9; }") unless defined(&SNDRV_HWDEP_IFACE_MIXART);
    eval("sub SNDRV_HWDEP_IFACE_USX2Y () { 10; }") unless defined(&SNDRV_HWDEP_IFACE_USX2Y);
    eval("sub SNDRV_HWDEP_IFACE_EMUX_WAVETABLE () { 11; }") unless defined(&SNDRV_HWDEP_IFACE_EMUX_WAVETABLE);
    eval("sub SNDRV_HWDEP_IFACE_BLUETOOTH () { 12; }") unless defined(&SNDRV_HWDEP_IFACE_BLUETOOTH);
    eval("sub SNDRV_HWDEP_IFACE_USX2Y_PCM () { 13; }") unless defined(&SNDRV_HWDEP_IFACE_USX2Y_PCM);
    eval("sub SNDRV_HWDEP_IFACE_PCXHR () { 14; }") unless defined(&SNDRV_HWDEP_IFACE_PCXHR);
    eval("sub SNDRV_HWDEP_IFACE_SB_RC () { 15; }") unless defined(&SNDRV_HWDEP_IFACE_SB_RC);
    eval("sub SNDRV_HWDEP_IFACE_HDA () { 16; }") unless defined(&SNDRV_HWDEP_IFACE_HDA);
    eval("sub SNDRV_HWDEP_IFACE_USB_STREAM () { 17; }") unless defined(&SNDRV_HWDEP_IFACE_USB_STREAM);
    eval("sub SNDRV_HWDEP_IFACE_FW_DICE () { 18; }") unless defined(&SNDRV_HWDEP_IFACE_FW_DICE);
    eval("sub SNDRV_HWDEP_IFACE_FW_FIREWORKS () { 19; }") unless defined(&SNDRV_HWDEP_IFACE_FW_FIREWORKS);
    eval("sub SNDRV_HWDEP_IFACE_FW_BEBOB () { 20; }") unless defined(&SNDRV_HWDEP_IFACE_FW_BEBOB);
    eval("sub SNDRV_HWDEP_IFACE_FW_OXFW () { 21; }") unless defined(&SNDRV_HWDEP_IFACE_FW_OXFW);
    eval("sub SNDRV_HWDEP_IFACE_FW_DIGI00X () { 22; }") unless defined(&SNDRV_HWDEP_IFACE_FW_DIGI00X);
    eval("sub SNDRV_HWDEP_IFACE_FW_TASCAM () { 23; }") unless defined(&SNDRV_HWDEP_IFACE_FW_TASCAM);
    eval("sub SNDRV_HWDEP_IFACE_LINE6 () { 24; }") unless defined(&SNDRV_HWDEP_IFACE_LINE6);
    eval("sub SNDRV_HWDEP_IFACE_FW_MOTU () { 25; }") unless defined(&SNDRV_HWDEP_IFACE_FW_MOTU);
    eval("sub SNDRV_HWDEP_IFACE_FW_FIREFACE () { 26; }") unless defined(&SNDRV_HWDEP_IFACE_FW_FIREFACE);
    eval("sub SNDRV_HWDEP_IFACE_LAST () { SNDRV_HWDEP_IFACE_FW_FIREFACE; }") unless defined(&SNDRV_HWDEP_IFACE_LAST);
    eval 'sub SNDRV_HWDEP_IOCTL_PVERSION () { &_IOR (ord(\'H\'), 0x, \'int\');}' unless defined(&SNDRV_HWDEP_IOCTL_PVERSION);
    eval 'sub SNDRV_HWDEP_IOCTL_INFO () { &_IOR (ord(\'H\'), 0x1, \'struct snd_hwdep_info\');}' unless defined(&SNDRV_HWDEP_IOCTL_INFO);
    eval 'sub SNDRV_HWDEP_IOCTL_DSP_STATUS () { &_IOR(ord(\'H\'), 0x2, \'struct snd_hwdep_dsp_status\');}' unless defined(&SNDRV_HWDEP_IOCTL_DSP_STATUS);
    eval 'sub SNDRV_HWDEP_IOCTL_DSP_LOAD () { &_IOW(ord(\'H\'), 0x3, \'struct snd_hwdep_dsp_image\');}' unless defined(&SNDRV_HWDEP_IOCTL_DSP_LOAD);
    eval 'sub SNDRV_PCM_VERSION () { &SNDRV_PROTOCOL_VERSION(2, 0, 15);}' unless defined(&SNDRV_PCM_VERSION);
    eval("sub SNDRV_PCM_CLASS_GENERIC () { 0; }") unless defined(&SNDRV_PCM_CLASS_GENERIC);
    eval("sub SNDRV_PCM_CLASS_MULTI () { 1; }") unless defined(&SNDRV_PCM_CLASS_MULTI);
    eval("sub SNDRV_PCM_CLASS_MODEM () { 2; }") unless defined(&SNDRV_PCM_CLASS_MODEM);
    eval("sub SNDRV_PCM_CLASS_DIGITIZER () { 3; }") unless defined(&SNDRV_PCM_CLASS_DIGITIZER);
    eval("sub SNDRV_PCM_CLASS_LAST () { SNDRV_PCM_CLASS_DIGITIZER; }") unless defined(&SNDRV_PCM_CLASS_LAST);
    eval("sub SNDRV_PCM_SUBCLASS_GENERIC_MIX () { 0; }") unless defined(&SNDRV_PCM_SUBCLASS_GENERIC_MIX);
    eval("sub SNDRV_PCM_SUBCLASS_MULTI_MIX () { 1; }") unless defined(&SNDRV_PCM_SUBCLASS_MULTI_MIX);
    eval("sub SNDRV_PCM_SUBCLASS_LAST () { SNDRV_PCM_SUBCLASS_MULTI_MIX; }") unless defined(&SNDRV_PCM_SUBCLASS_LAST);
    eval("sub SNDRV_PCM_STREAM_PLAYBACK () { 0; }") unless defined(&SNDRV_PCM_STREAM_PLAYBACK);
    eval("sub SNDRV_PCM_STREAM_CAPTURE () { 1; }") unless defined(&SNDRV_PCM_STREAM_CAPTURE);
    eval("sub SNDRV_PCM_STREAM_LAST () { SNDRV_PCM_STREAM_CAPTURE; }") unless defined(&SNDRV_PCM_STREAM_LAST);
    eval 'sub SNDRV_PCM_ACCESS_MMAP_INTERLEAVED () {(( &snd_pcm_access_t) 0);}' unless defined(&SNDRV_PCM_ACCESS_MMAP_INTERLEAVED);
    eval 'sub SNDRV_PCM_ACCESS_MMAP_NONINTERLEAVED () {(( &snd_pcm_access_t) 1);}' unless defined(&SNDRV_PCM_ACCESS_MMAP_NONINTERLEAVED);
    eval 'sub SNDRV_PCM_ACCESS_MMAP_COMPLEX () {(( &snd_pcm_access_t) 2);}' unless defined(&SNDRV_PCM_ACCESS_MMAP_COMPLEX);
    eval 'sub SNDRV_PCM_ACCESS_RW_INTERLEAVED () {(( &snd_pcm_access_t) 3);}' unless defined(&SNDRV_PCM_ACCESS_RW_INTERLEAVED);
    eval 'sub SNDRV_PCM_ACCESS_RW_NONINTERLEAVED () {(( &snd_pcm_access_t) 4);}' unless defined(&SNDRV_PCM_ACCESS_RW_NONINTERLEAVED);
    eval 'sub SNDRV_PCM_ACCESS_LAST () { &SNDRV_PCM_ACCESS_RW_NONINTERLEAVED;}' unless defined(&SNDRV_PCM_ACCESS_LAST);
    eval 'sub SNDRV_PCM_FORMAT_S8 () {(( &snd_pcm_format_t) 0);}' unless defined(&SNDRV_PCM_FORMAT_S8);
    eval 'sub SNDRV_PCM_FORMAT_U8 () {(( &snd_pcm_format_t) 1);}' unless defined(&SNDRV_PCM_FORMAT_U8);
    eval 'sub SNDRV_PCM_FORMAT_S16_LE () {(( &snd_pcm_format_t) 2);}' unless defined(&SNDRV_PCM_FORMAT_S16_LE);
    eval 'sub SNDRV_PCM_FORMAT_S16_BE () {(( &snd_pcm_format_t) 3);}' unless defined(&SNDRV_PCM_FORMAT_S16_BE);
    eval 'sub SNDRV_PCM_FORMAT_U16_LE () {(( &snd_pcm_format_t) 4);}' unless defined(&SNDRV_PCM_FORMAT_U16_LE);
    eval 'sub SNDRV_PCM_FORMAT_U16_BE () {(( &snd_pcm_format_t) 5);}' unless defined(&SNDRV_PCM_FORMAT_U16_BE);
    eval 'sub SNDRV_PCM_FORMAT_S24_LE () {(( &snd_pcm_format_t) 6);}' unless defined(&SNDRV_PCM_FORMAT_S24_LE);
    eval 'sub SNDRV_PCM_FORMAT_S24_BE () {(( &snd_pcm_format_t) 7);}' unless defined(&SNDRV_PCM_FORMAT_S24_BE);
    eval 'sub SNDRV_PCM_FORMAT_U24_LE () {(( &snd_pcm_format_t) 8);}' unless defined(&SNDRV_PCM_FORMAT_U24_LE);
    eval 'sub SNDRV_PCM_FORMAT_U24_BE () {(( &snd_pcm_format_t) 9);}' unless defined(&SNDRV_PCM_FORMAT_U24_BE);
    eval 'sub SNDRV_PCM_FORMAT_S32_LE () {(( &snd_pcm_format_t) 10);}' unless defined(&SNDRV_PCM_FORMAT_S32_LE);
    eval 'sub SNDRV_PCM_FORMAT_S32_BE () {(( &snd_pcm_format_t) 11);}' unless defined(&SNDRV_PCM_FORMAT_S32_BE);
    eval 'sub SNDRV_PCM_FORMAT_U32_LE () {(( &snd_pcm_format_t) 12);}' unless defined(&SNDRV_PCM_FORMAT_U32_LE);
    eval 'sub SNDRV_PCM_FORMAT_U32_BE () {(( &snd_pcm_format_t) 13);}' unless defined(&SNDRV_PCM_FORMAT_U32_BE);
    eval 'sub SNDRV_PCM_FORMAT_FLOAT_LE () {(( &snd_pcm_format_t) 14);}' unless defined(&SNDRV_PCM_FORMAT_FLOAT_LE);
    eval 'sub SNDRV_PCM_FORMAT_FLOAT_BE () {(( &snd_pcm_format_t) 15);}' unless defined(&SNDRV_PCM_FORMAT_FLOAT_BE);
    eval 'sub SNDRV_PCM_FORMAT_FLOAT64_LE () {(( &snd_pcm_format_t) 16);}' unless defined(&SNDRV_PCM_FORMAT_FLOAT64_LE);
    eval 'sub SNDRV_PCM_FORMAT_FLOAT64_BE () {(( &snd_pcm_format_t) 17);}' unless defined(&SNDRV_PCM_FORMAT_FLOAT64_BE);
    eval 'sub SNDRV_PCM_FORMAT_IEC958_SUBFRAME_LE () {(( &snd_pcm_format_t) 18);}' unless defined(&SNDRV_PCM_FORMAT_IEC958_SUBFRAME_LE);
    eval 'sub SNDRV_PCM_FORMAT_IEC958_SUBFRAME_BE () {(( &snd_pcm_format_t) 19);}' unless defined(&SNDRV_PCM_FORMAT_IEC958_SUBFRAME_BE);
    eval 'sub SNDRV_PCM_FORMAT_MU_LAW () {(( &snd_pcm_format_t) 20);}' unless defined(&SNDRV_PCM_FORMAT_MU_LAW);
    eval 'sub SNDRV_PCM_FORMAT_A_LAW () {(( &snd_pcm_format_t) 21);}' unless defined(&SNDRV_PCM_FORMAT_A_LAW);
    eval 'sub SNDRV_PCM_FORMAT_IMA_ADPCM () {(( &snd_pcm_format_t) 22);}' unless defined(&SNDRV_PCM_FORMAT_IMA_ADPCM);
    eval 'sub SNDRV_PCM_FORMAT_MPEG () {(( &snd_pcm_format_t) 23);}' unless defined(&SNDRV_PCM_FORMAT_MPEG);
    eval 'sub SNDRV_PCM_FORMAT_GSM () {(( &snd_pcm_format_t) 24);}' unless defined(&SNDRV_PCM_FORMAT_GSM);
    eval 'sub SNDRV_PCM_FORMAT_S20_LE () {(( &snd_pcm_format_t) 25);}' unless defined(&SNDRV_PCM_FORMAT_S20_LE);
    eval 'sub SNDRV_PCM_FORMAT_S20_BE () {(( &snd_pcm_format_t) 26);}' unless defined(&SNDRV_PCM_FORMAT_S20_BE);
    eval 'sub SNDRV_PCM_FORMAT_U20_LE () {(( &snd_pcm_format_t) 27);}' unless defined(&SNDRV_PCM_FORMAT_U20_LE);
    eval 'sub SNDRV_PCM_FORMAT_U20_BE () {(( &snd_pcm_format_t) 28);}' unless defined(&SNDRV_PCM_FORMAT_U20_BE);
    eval 'sub SNDRV_PCM_FORMAT_SPECIAL () {(( &snd_pcm_format_t) 31);}' unless defined(&SNDRV_PCM_FORMAT_SPECIAL);
    eval 'sub SNDRV_PCM_FORMAT_S24_3LE () {(( &snd_pcm_format_t) 32);}' unless defined(&SNDRV_PCM_FORMAT_S24_3LE);
    eval 'sub SNDRV_PCM_FORMAT_S24_3BE () {(( &snd_pcm_format_t) 33);}' unless defined(&SNDRV_PCM_FORMAT_S24_3BE);
    eval 'sub SNDRV_PCM_FORMAT_U24_3LE () {(( &snd_pcm_format_t) 34);}' unless defined(&SNDRV_PCM_FORMAT_U24_3LE);
    eval 'sub SNDRV_PCM_FORMAT_U24_3BE () {(( &snd_pcm_format_t) 35);}' unless defined(&SNDRV_PCM_FORMAT_U24_3BE);
    eval 'sub SNDRV_PCM_FORMAT_S20_3LE () {(( &snd_pcm_format_t) 36);}' unless defined(&SNDRV_PCM_FORMAT_S20_3LE);
    eval 'sub SNDRV_PCM_FORMAT_S20_3BE () {(( &snd_pcm_format_t) 37);}' unless defined(&SNDRV_PCM_FORMAT_S20_3BE);
    eval 'sub SNDRV_PCM_FORMAT_U20_3LE () {(( &snd_pcm_format_t) 38);}' unless defined(&SNDRV_PCM_FORMAT_U20_3LE);
    eval 'sub SNDRV_PCM_FORMAT_U20_3BE () {(( &snd_pcm_format_t) 39);}' unless defined(&SNDRV_PCM_FORMAT_U20_3BE);
    eval 'sub SNDRV_PCM_FORMAT_S18_3LE () {(( &snd_pcm_format_t) 40);}' unless defined(&SNDRV_PCM_FORMAT_S18_3LE);
    eval 'sub SNDRV_PCM_FORMAT_S18_3BE () {(( &snd_pcm_format_t) 41);}' unless defined(&SNDRV_PCM_FORMAT_S18_3BE);
    eval 'sub SNDRV_PCM_FORMAT_U18_3LE () {(( &snd_pcm_format_t) 42);}' unless defined(&SNDRV_PCM_FORMAT_U18_3LE);
    eval 'sub SNDRV_PCM_FORMAT_U18_3BE () {(( &snd_pcm_format_t) 43);}' unless defined(&SNDRV_PCM_FORMAT_U18_3BE);
    eval 'sub SNDRV_PCM_FORMAT_G723_24 () {(( &snd_pcm_format_t) 44);}' unless defined(&SNDRV_PCM_FORMAT_G723_24);
    eval 'sub SNDRV_PCM_FORMAT_G723_24_1B () {(( &snd_pcm_format_t) 45);}' unless defined(&SNDRV_PCM_FORMAT_G723_24_1B);
    eval 'sub SNDRV_PCM_FORMAT_G723_40 () {(( &snd_pcm_format_t) 46);}' unless defined(&SNDRV_PCM_FORMAT_G723_40);
    eval 'sub SNDRV_PCM_FORMAT_G723_40_1B () {(( &snd_pcm_format_t) 47);}' unless defined(&SNDRV_PCM_FORMAT_G723_40_1B);
    eval 'sub SNDRV_PCM_FORMAT_DSD_U8 () {(( &snd_pcm_format_t) 48);}' unless defined(&SNDRV_PCM_FORMAT_DSD_U8);
    eval 'sub SNDRV_PCM_FORMAT_DSD_U16_LE () {(( &snd_pcm_format_t) 49);}' unless defined(&SNDRV_PCM_FORMAT_DSD_U16_LE);
    eval 'sub SNDRV_PCM_FORMAT_DSD_U32_LE () {(( &snd_pcm_format_t) 50);}' unless defined(&SNDRV_PCM_FORMAT_DSD_U32_LE);
    eval 'sub SNDRV_PCM_FORMAT_DSD_U16_BE () {(( &snd_pcm_format_t) 51);}' unless defined(&SNDRV_PCM_FORMAT_DSD_U16_BE);
    eval 'sub SNDRV_PCM_FORMAT_DSD_U32_BE () {(( &snd_pcm_format_t) 52);}' unless defined(&SNDRV_PCM_FORMAT_DSD_U32_BE);
    eval 'sub SNDRV_PCM_FORMAT_LAST () { &SNDRV_PCM_FORMAT_DSD_U32_BE;}' unless defined(&SNDRV_PCM_FORMAT_LAST);
    eval 'sub SNDRV_PCM_FORMAT_FIRST () { &SNDRV_PCM_FORMAT_S8;}' unless defined(&SNDRV_PCM_FORMAT_FIRST);
    if(defined(&SNDRV_LITTLE_ENDIAN)) {
	eval 'sub SNDRV_PCM_FORMAT_S16 () { &SNDRV_PCM_FORMAT_S16_LE;}' unless defined(&SNDRV_PCM_FORMAT_S16);
	eval 'sub SNDRV_PCM_FORMAT_U16 () { &SNDRV_PCM_FORMAT_U16_LE;}' unless defined(&SNDRV_PCM_FORMAT_U16);
	eval 'sub SNDRV_PCM_FORMAT_S24 () { &SNDRV_PCM_FORMAT_S24_LE;}' unless defined(&SNDRV_PCM_FORMAT_S24);
	eval 'sub SNDRV_PCM_FORMAT_U24 () { &SNDRV_PCM_FORMAT_U24_LE;}' unless defined(&SNDRV_PCM_FORMAT_U24);
	eval 'sub SNDRV_PCM_FORMAT_S32 () { &SNDRV_PCM_FORMAT_S32_LE;}' unless defined(&SNDRV_PCM_FORMAT_S32);
	eval 'sub SNDRV_PCM_FORMAT_U32 () { &SNDRV_PCM_FORMAT_U32_LE;}' unless defined(&SNDRV_PCM_FORMAT_U32);
	eval 'sub SNDRV_PCM_FORMAT_FLOAT () { &SNDRV_PCM_FORMAT_FLOAT_LE;}' unless defined(&SNDRV_PCM_FORMAT_FLOAT);
	eval 'sub SNDRV_PCM_FORMAT_FLOAT64 () { &SNDRV_PCM_FORMAT_FLOAT64_LE;}' unless defined(&SNDRV_PCM_FORMAT_FLOAT64);
	eval 'sub SNDRV_PCM_FORMAT_IEC958_SUBFRAME () { &SNDRV_PCM_FORMAT_IEC958_SUBFRAME_LE;}' unless defined(&SNDRV_PCM_FORMAT_IEC958_SUBFRAME);
	eval 'sub SNDRV_PCM_FORMAT_S20 () { &SNDRV_PCM_FORMAT_S20_LE;}' unless defined(&SNDRV_PCM_FORMAT_S20);
	eval 'sub SNDRV_PCM_FORMAT_U20 () { &SNDRV_PCM_FORMAT_U20_LE;}' unless defined(&SNDRV_PCM_FORMAT_U20);
    }
    if(defined(&SNDRV_BIG_ENDIAN)) {
	eval 'sub SNDRV_PCM_FORMAT_S16 () { &SNDRV_PCM_FORMAT_S16_BE;}' unless defined(&SNDRV_PCM_FORMAT_S16);
	eval 'sub SNDRV_PCM_FORMAT_U16 () { &SNDRV_PCM_FORMAT_U16_BE;}' unless defined(&SNDRV_PCM_FORMAT_U16);
	eval 'sub SNDRV_PCM_FORMAT_S24 () { &SNDRV_PCM_FORMAT_S24_BE;}' unless defined(&SNDRV_PCM_FORMAT_S24);
	eval 'sub SNDRV_PCM_FORMAT_U24 () { &SNDRV_PCM_FORMAT_U24_BE;}' unless defined(&SNDRV_PCM_FORMAT_U24);
	eval 'sub SNDRV_PCM_FORMAT_S32 () { &SNDRV_PCM_FORMAT_S32_BE;}' unless defined(&SNDRV_PCM_FORMAT_S32);
	eval 'sub SNDRV_PCM_FORMAT_U32 () { &SNDRV_PCM_FORMAT_U32_BE;}' unless defined(&SNDRV_PCM_FORMAT_U32);
	eval 'sub SNDRV_PCM_FORMAT_FLOAT () { &SNDRV_PCM_FORMAT_FLOAT_BE;}' unless defined(&SNDRV_PCM_FORMAT_FLOAT);
	eval 'sub SNDRV_PCM_FORMAT_FLOAT64 () { &SNDRV_PCM_FORMAT_FLOAT64_BE;}' unless defined(&SNDRV_PCM_FORMAT_FLOAT64);
	eval 'sub SNDRV_PCM_FORMAT_IEC958_SUBFRAME () { &SNDRV_PCM_FORMAT_IEC958_SUBFRAME_BE;}' unless defined(&SNDRV_PCM_FORMAT_IEC958_SUBFRAME);
	eval 'sub SNDRV_PCM_FORMAT_S20 () { &SNDRV_PCM_FORMAT_S20_BE;}' unless defined(&SNDRV_PCM_FORMAT_S20);
	eval 'sub SNDRV_PCM_FORMAT_U20 () { &SNDRV_PCM_FORMAT_U20_BE;}' unless defined(&SNDRV_PCM_FORMAT_U20);
    }
    eval 'sub SNDRV_PCM_SUBFORMAT_STD () {(( &snd_pcm_subformat_t) 0);}' unless defined(&SNDRV_PCM_SUBFORMAT_STD);
    eval 'sub SNDRV_PCM_SUBFORMAT_LAST () { &SNDRV_PCM_SUBFORMAT_STD;}' unless defined(&SNDRV_PCM_SUBFORMAT_LAST);
    eval 'sub SNDRV_PCM_INFO_MMAP () {0x1;}' unless defined(&SNDRV_PCM_INFO_MMAP);
    eval 'sub SNDRV_PCM_INFO_MMAP_VALID () {0x2;}' unless defined(&SNDRV_PCM_INFO_MMAP_VALID);
    eval 'sub SNDRV_PCM_INFO_DOUBLE () {0x4;}' unless defined(&SNDRV_PCM_INFO_DOUBLE);
    eval 'sub SNDRV_PCM_INFO_BATCH () {0x10;}' unless defined(&SNDRV_PCM_INFO_BATCH);
    eval 'sub SNDRV_PCM_INFO_SYNC_APPLPTR () {0x20;}' unless defined(&SNDRV_PCM_INFO_SYNC_APPLPTR);
    eval 'sub SNDRV_PCM_INFO_INTERLEAVED () {0x100;}' unless defined(&SNDRV_PCM_INFO_INTERLEAVED);
    eval 'sub SNDRV_PCM_INFO_NONINTERLEAVED () {0x200;}' unless defined(&SNDRV_PCM_INFO_NONINTERLEAVED);
    eval 'sub SNDRV_PCM_INFO_COMPLEX () {0x400;}' unless defined(&SNDRV_PCM_INFO_COMPLEX);
    eval 'sub SNDRV_PCM_INFO_BLOCK_TRANSFER () {0x10000;}' unless defined(&SNDRV_PCM_INFO_BLOCK_TRANSFER);
    eval 'sub SNDRV_PCM_INFO_OVERRANGE () {0x20000;}' unless defined(&SNDRV_PCM_INFO_OVERRANGE);
    eval 'sub SNDRV_PCM_INFO_RESUME () {0x40000;}' unless defined(&SNDRV_PCM_INFO_RESUME);
    eval 'sub SNDRV_PCM_INFO_PAUSE () {0x80000;}' unless defined(&SNDRV_PCM_INFO_PAUSE);
    eval 'sub SNDRV_PCM_INFO_HALF_DUPLEX () {0x100000;}' unless defined(&SNDRV_PCM_INFO_HALF_DUPLEX);
    eval 'sub SNDRV_PCM_INFO_JOINT_DUPLEX () {0x200000;}' unless defined(&SNDRV_PCM_INFO_JOINT_DUPLEX);
    eval 'sub SNDRV_PCM_INFO_SYNC_START () {0x400000;}' unless defined(&SNDRV_PCM_INFO_SYNC_START);
    eval 'sub SNDRV_PCM_INFO_NO_PERIOD_WAKEUP () {0x800000;}' unless defined(&SNDRV_PCM_INFO_NO_PERIOD_WAKEUP);
    eval 'sub SNDRV_PCM_INFO_HAS_WALL_CLOCK () {0x1000000;}' unless defined(&SNDRV_PCM_INFO_HAS_WALL_CLOCK);
    eval 'sub SNDRV_PCM_INFO_HAS_LINK_ATIME () {0x1000000;}' unless defined(&SNDRV_PCM_INFO_HAS_LINK_ATIME);
    eval 'sub SNDRV_PCM_INFO_HAS_LINK_ABSOLUTE_ATIME () {0x2000000;}' unless defined(&SNDRV_PCM_INFO_HAS_LINK_ABSOLUTE_ATIME);
    eval 'sub SNDRV_PCM_INFO_HAS_LINK_ESTIMATED_ATIME () {0x4000000;}' unless defined(&SNDRV_PCM_INFO_HAS_LINK_ESTIMATED_ATIME);
    eval 'sub SNDRV_PCM_INFO_HAS_LINK_SYNCHRONIZED_ATIME () {0x8000000;}' unless defined(&SNDRV_PCM_INFO_HAS_LINK_SYNCHRONIZED_ATIME);
    eval 'sub SNDRV_PCM_INFO_EXPLICIT_SYNC () {0x10000000;}' unless defined(&SNDRV_PCM_INFO_EXPLICIT_SYNC);
    eval 'sub SNDRV_PCM_INFO_NO_REWINDS () {0x20000000;}' unless defined(&SNDRV_PCM_INFO_NO_REWINDS);
    eval 'sub SNDRV_PCM_INFO_DRAIN_TRIGGER () {0x40000000;}' unless defined(&SNDRV_PCM_INFO_DRAIN_TRIGGER);
    eval 'sub SNDRV_PCM_INFO_FIFO_IN_FRAMES () {0x80000000;}' unless defined(&SNDRV_PCM_INFO_FIFO_IN_FRAMES);
    if(((defined(&__BITS_PER_LONG) ? &__BITS_PER_LONG : undef) == 32 && defined(&__USE_TIME_BITS64)) || defined (&__KERNEL__)) {
	eval 'sub __SND_STRUCT_TIME64 () {1;}' unless defined(&__SND_STRUCT_TIME64);
    }
    eval 'sub SNDRV_PCM_STATE_OPEN () {(( &snd_pcm_state_t) 0);}' unless defined(&SNDRV_PCM_STATE_OPEN);
    eval 'sub SNDRV_PCM_STATE_SETUP () {(( &snd_pcm_state_t) 1);}' unless defined(&SNDRV_PCM_STATE_SETUP);
    eval 'sub SNDRV_PCM_STATE_PREPARED () {(( &snd_pcm_state_t) 2);}' unless defined(&SNDRV_PCM_STATE_PREPARED);
    eval 'sub SNDRV_PCM_STATE_RUNNING () {(( &snd_pcm_state_t) 3);}' unless defined(&SNDRV_PCM_STATE_RUNNING);
    eval 'sub SNDRV_PCM_STATE_XRUN () {(( &snd_pcm_state_t) 4);}' unless defined(&SNDRV_PCM_STATE_XRUN);
    eval 'sub SNDRV_PCM_STATE_DRAINING () {(( &snd_pcm_state_t) 5);}' unless defined(&SNDRV_PCM_STATE_DRAINING);
    eval 'sub SNDRV_PCM_STATE_PAUSED () {(( &snd_pcm_state_t) 6);}' unless defined(&SNDRV_PCM_STATE_PAUSED);
    eval 'sub SNDRV_PCM_STATE_SUSPENDED () {(( &snd_pcm_state_t) 7);}' unless defined(&SNDRV_PCM_STATE_SUSPENDED);
    eval 'sub SNDRV_PCM_STATE_DISCONNECTED () {(( &snd_pcm_state_t) 8);}' unless defined(&SNDRV_PCM_STATE_DISCONNECTED);
    eval 'sub SNDRV_PCM_STATE_LAST () { &SNDRV_PCM_STATE_DISCONNECTED;}' unless defined(&SNDRV_PCM_STATE_LAST);
    eval("sub SNDRV_PCM_MMAP_OFFSET_DATA () { 0x00000000; }") unless defined(&SNDRV_PCM_MMAP_OFFSET_DATA);
    eval("sub SNDRV_PCM_MMAP_OFFSET_STATUS_OLD () { 0x80000000; }") unless defined(&SNDRV_PCM_MMAP_OFFSET_STATUS_OLD);
    eval("sub SNDRV_PCM_MMAP_OFFSET_CONTROL_OLD () { 0x81000000; }") unless defined(&SNDRV_PCM_MMAP_OFFSET_CONTROL_OLD);
    eval("sub SNDRV_PCM_MMAP_OFFSET_STATUS_NEW () { 0x82000000; }") unless defined(&SNDRV_PCM_MMAP_OFFSET_STATUS_NEW);
    eval("sub SNDRV_PCM_MMAP_OFFSET_CONTROL_NEW () { 0x83000000; }") unless defined(&SNDRV_PCM_MMAP_OFFSET_CONTROL_NEW);
    eval 'sub SNDRV_PCM_HW_PARAM_ACCESS () {0;}' unless defined(&SNDRV_PCM_HW_PARAM_ACCESS);
    eval 'sub SNDRV_PCM_HW_PARAM_FORMAT () {1;}' unless defined(&SNDRV_PCM_HW_PARAM_FORMAT);
    eval 'sub SNDRV_PCM_HW_PARAM_SUBFORMAT () {2;}' unless defined(&SNDRV_PCM_HW_PARAM_SUBFORMAT);
    eval 'sub SNDRV_PCM_HW_PARAM_FIRST_MASK () { &SNDRV_PCM_HW_PARAM_ACCESS;}' unless defined(&SNDRV_PCM_HW_PARAM_FIRST_MASK);
    eval 'sub SNDRV_PCM_HW_PARAM_LAST_MASK () { &SNDRV_PCM_HW_PARAM_SUBFORMAT;}' unless defined(&SNDRV_PCM_HW_PARAM_LAST_MASK);
    eval 'sub SNDRV_PCM_HW_PARAM_SAMPLE_BITS () {8;}' unless defined(&SNDRV_PCM_HW_PARAM_SAMPLE_BITS);
    eval 'sub SNDRV_PCM_HW_PARAM_FRAME_BITS () {9;}' unless defined(&SNDRV_PCM_HW_PARAM_FRAME_BITS);
    eval 'sub SNDRV_PCM_HW_PARAM_CHANNELS () {10;}' unless defined(&SNDRV_PCM_HW_PARAM_CHANNELS);
    eval 'sub SNDRV_PCM_HW_PARAM_RATE () {11;}' unless defined(&SNDRV_PCM_HW_PARAM_RATE);
    eval 'sub SNDRV_PCM_HW_PARAM_PERIOD_TIME () {12;}' unless defined(&SNDRV_PCM_HW_PARAM_PERIOD_TIME);
    eval 'sub SNDRV_PCM_HW_PARAM_PERIOD_SIZE () {13;}' unless defined(&SNDRV_PCM_HW_PARAM_PERIOD_SIZE);
    eval 'sub SNDRV_PCM_HW_PARAM_PERIOD_BYTES () {14;}' unless defined(&SNDRV_PCM_HW_PARAM_PERIOD_BYTES);
    eval 'sub SNDRV_PCM_HW_PARAM_PERIODS () {15;}' unless defined(&SNDRV_PCM_HW_PARAM_PERIODS);
    eval 'sub SNDRV_PCM_HW_PARAM_BUFFER_TIME () {16;}' unless defined(&SNDRV_PCM_HW_PARAM_BUFFER_TIME);
    eval 'sub SNDRV_PCM_HW_PARAM_BUFFER_SIZE () {17;}' unless defined(&SNDRV_PCM_HW_PARAM_BUFFER_SIZE);
    eval 'sub SNDRV_PCM_HW_PARAM_BUFFER_BYTES () {18;}' unless defined(&SNDRV_PCM_HW_PARAM_BUFFER_BYTES);
    eval 'sub SNDRV_PCM_HW_PARAM_TICK_TIME () {19;}' unless defined(&SNDRV_PCM_HW_PARAM_TICK_TIME);
    eval 'sub SNDRV_PCM_HW_PARAM_FIRST_INTERVAL () { &SNDRV_PCM_HW_PARAM_SAMPLE_BITS;}' unless defined(&SNDRV_PCM_HW_PARAM_FIRST_INTERVAL);
    eval 'sub SNDRV_PCM_HW_PARAM_LAST_INTERVAL () { &SNDRV_PCM_HW_PARAM_TICK_TIME;}' unless defined(&SNDRV_PCM_HW_PARAM_LAST_INTERVAL);
    eval 'sub SNDRV_PCM_HW_PARAMS_NORESAMPLE () {(1<<0);}' unless defined(&SNDRV_PCM_HW_PARAMS_NORESAMPLE);
    eval 'sub SNDRV_PCM_HW_PARAMS_EXPORT_BUFFER () {(1<<1);}' unless defined(&SNDRV_PCM_HW_PARAMS_EXPORT_BUFFER);
    eval 'sub SNDRV_PCM_HW_PARAMS_NO_PERIOD_WAKEUP () {(1<<2);}' unless defined(&SNDRV_PCM_HW_PARAMS_NO_PERIOD_WAKEUP);
    eval 'sub SNDRV_MASK_MAX () {256;}' unless defined(&SNDRV_MASK_MAX);
    eval("sub SNDRV_PCM_TSTAMP_NONE () { 0; }") unless defined(&SNDRV_PCM_TSTAMP_NONE);
    eval("sub SNDRV_PCM_TSTAMP_ENABLE () { 1; }") unless defined(&SNDRV_PCM_TSTAMP_ENABLE);
    eval("sub SNDRV_PCM_TSTAMP_LAST () { SNDRV_PCM_TSTAMP_ENABLE; }") unless defined(&SNDRV_PCM_TSTAMP_LAST);
    eval("sub SNDRV_PCM_AUDIO_TSTAMP_TYPE_COMPAT () { 0; }") unless defined(&SNDRV_PCM_AUDIO_TSTAMP_TYPE_COMPAT);
    eval("sub SNDRV_PCM_AUDIO_TSTAMP_TYPE_DEFAULT () { 1; }") unless defined(&SNDRV_PCM_AUDIO_TSTAMP_TYPE_DEFAULT);
    eval("sub SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK () { 2; }") unless defined(&SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK);
    eval("sub SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ABSOLUTE () { 3; }") unless defined(&SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ABSOLUTE);
    eval("sub SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ESTIMATED () { 4; }") unless defined(&SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_ESTIMATED);
    eval("sub SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_SYNCHRONIZED () { 5; }") unless defined(&SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_SYNCHRONIZED);
    eval("sub SNDRV_PCM_AUDIO_TSTAMP_TYPE_LAST () { SNDRV_PCM_AUDIO_TSTAMP_TYPE_LINK_SYNCHRONIZED; }") unless defined(&SNDRV_PCM_AUDIO_TSTAMP_TYPE_LAST);
    if(defined(&__SND_STRUCT_TIME64)) {
	eval 'sub __snd_pcm_mmap_status64 () { &snd_pcm_mmap_status;}' unless defined(&__snd_pcm_mmap_status64);
	eval 'sub __snd_pcm_mmap_control64 () { &snd_pcm_mmap_control;}' unless defined(&__snd_pcm_mmap_control64);
	eval 'sub __snd_pcm_sync_ptr64 () { &snd_pcm_sync_ptr;}' unless defined(&__snd_pcm_sync_ptr64);
	eval 'sub __snd_timespec64 () { &timespec;}' unless defined(&__snd_timespec64);
    } else {
	eval 'sub __snd_pcm_mmap_status () { &snd_pcm_mmap_status;}' unless defined(&__snd_pcm_mmap_status);
	eval 'sub __snd_pcm_mmap_control () { &snd_pcm_mmap_control;}' unless defined(&__snd_pcm_mmap_control);
	eval 'sub __snd_pcm_sync_ptr () { &snd_pcm_sync_ptr;}' unless defined(&__snd_pcm_sync_ptr);
	eval 'sub __snd_timespec () { &timespec;}' unless defined(&__snd_timespec);
    }
    eval 'sub SNDRV_PCM_SYNC_PTR_HWSYNC () {(1<<0);}' unless defined(&SNDRV_PCM_SYNC_PTR_HWSYNC);
    eval 'sub SNDRV_PCM_SYNC_PTR_APPL () {(1<<1);}' unless defined(&SNDRV_PCM_SYNC_PTR_APPL);
    eval 'sub SNDRV_PCM_SYNC_PTR_AVAIL_MIN () {(1<<2);}' unless defined(&SNDRV_PCM_SYNC_PTR_AVAIL_MIN);
    if(defined(&__BYTE_ORDER) ? (defined(&__BYTE_ORDER) ? &__BYTE_ORDER : undef) == (defined(&__BIG_ENDIAN) ? &__BIG_ENDIAN : undef) : defined(&__BIG_ENDIAN)) {
    }
    if(defined(&__BYTE_ORDER) ? (defined(&__BYTE_ORDER) ? &__BYTE_ORDER : undef) == (defined(&__LITTLE_ENDIAN) ? &__LITTLE_ENDIAN : undef) : defined(&__LITTLE_ENDIAN)) {
    }
    eval("sub SNDRV_PCM_TSTAMP_TYPE_GETTIMEOFDAY () { 0; }") unless defined(&SNDRV_PCM_TSTAMP_TYPE_GETTIMEOFDAY);
    eval("sub SNDRV_PCM_TSTAMP_TYPE_MONOTONIC () { 1; }") unless defined(&SNDRV_PCM_TSTAMP_TYPE_MONOTONIC);
    eval("sub SNDRV_PCM_TSTAMP_TYPE_MONOTONIC_RAW () { 2; }") unless defined(&SNDRV_PCM_TSTAMP_TYPE_MONOTONIC_RAW);
    eval("sub SNDRV_PCM_TSTAMP_TYPE_LAST () { SNDRV_PCM_TSTAMP_TYPE_MONOTONIC_RAW; }") unless defined(&SNDRV_PCM_TSTAMP_TYPE_LAST);
    eval("sub SNDRV_CHMAP_UNKNOWN () { 0; }") unless defined(&SNDRV_CHMAP_UNKNOWN);
    eval("sub SNDRV_CHMAP_NA () { 1; }") unless defined(&SNDRV_CHMAP_NA);
    eval("sub SNDRV_CHMAP_MONO () { 2; }") unless defined(&SNDRV_CHMAP_MONO);
    eval("sub SNDRV_CHMAP_FL () { 3; }") unless defined(&SNDRV_CHMAP_FL);
    eval("sub SNDRV_CHMAP_FR () { 4; }") unless defined(&SNDRV_CHMAP_FR);
    eval("sub SNDRV_CHMAP_RL () { 5; }") unless defined(&SNDRV_CHMAP_RL);
    eval("sub SNDRV_CHMAP_RR () { 6; }") unless defined(&SNDRV_CHMAP_RR);
    eval("sub SNDRV_CHMAP_FC () { 7; }") unless defined(&SNDRV_CHMAP_FC);
    eval("sub SNDRV_CHMAP_LFE () { 8; }") unless defined(&SNDRV_CHMAP_LFE);
    eval("sub SNDRV_CHMAP_SL () { 9; }") unless defined(&SNDRV_CHMAP_SL);
    eval("sub SNDRV_CHMAP_SR () { 10; }") unless defined(&SNDRV_CHMAP_SR);
    eval("sub SNDRV_CHMAP_RC () { 11; }") unless defined(&SNDRV_CHMAP_RC);
    eval("sub SNDRV_CHMAP_FLC () { 12; }") unless defined(&SNDRV_CHMAP_FLC);
    eval("sub SNDRV_CHMAP_FRC () { 13; }") unless defined(&SNDRV_CHMAP_FRC);
    eval("sub SNDRV_CHMAP_RLC () { 14; }") unless defined(&SNDRV_CHMAP_RLC);
    eval("sub SNDRV_CHMAP_RRC () { 15; }") unless defined(&SNDRV_CHMAP_RRC);
    eval("sub SNDRV_CHMAP_FLW () { 16; }") unless defined(&SNDRV_CHMAP_FLW);
    eval("sub SNDRV_CHMAP_FRW () { 17; }") unless defined(&SNDRV_CHMAP_FRW);
    eval("sub SNDRV_CHMAP_FLH () { 18; }") unless defined(&SNDRV_CHMAP_FLH);
    eval("sub SNDRV_CHMAP_FCH () { 19; }") unless defined(&SNDRV_CHMAP_FCH);
    eval("sub SNDRV_CHMAP_FRH () { 20; }") unless defined(&SNDRV_CHMAP_FRH);
    eval("sub SNDRV_CHMAP_TC () { 21; }") unless defined(&SNDRV_CHMAP_TC);
    eval("sub SNDRV_CHMAP_TFL () { 22; }") unless defined(&SNDRV_CHMAP_TFL);
    eval("sub SNDRV_CHMAP_TFR () { 23; }") unless defined(&SNDRV_CHMAP_TFR);
    eval("sub SNDRV_CHMAP_TFC () { 24; }") unless defined(&SNDRV_CHMAP_TFC);
    eval("sub SNDRV_CHMAP_TRL () { 25; }") unless defined(&SNDRV_CHMAP_TRL);
    eval("sub SNDRV_CHMAP_TRR () { 26; }") unless defined(&SNDRV_CHMAP_TRR);
    eval("sub SNDRV_CHMAP_TRC () { 27; }") unless defined(&SNDRV_CHMAP_TRC);
    eval("sub SNDRV_CHMAP_TFLC () { 28; }") unless defined(&SNDRV_CHMAP_TFLC);
    eval("sub SNDRV_CHMAP_TFRC () { 29; }") unless defined(&SNDRV_CHMAP_TFRC);
    eval("sub SNDRV_CHMAP_TSL () { 30; }") unless defined(&SNDRV_CHMAP_TSL);
    eval("sub SNDRV_CHMAP_TSR () { 31; }") unless defined(&SNDRV_CHMAP_TSR);
    eval("sub SNDRV_CHMAP_LLFE () { 32; }") unless defined(&SNDRV_CHMAP_LLFE);
    eval("sub SNDRV_CHMAP_RLFE () { 33; }") unless defined(&SNDRV_CHMAP_RLFE);
    eval("sub SNDRV_CHMAP_BC () { 34; }") unless defined(&SNDRV_CHMAP_BC);
    eval("sub SNDRV_CHMAP_BLC () { 35; }") unless defined(&SNDRV_CHMAP_BLC);
    eval("sub SNDRV_CHMAP_BRC () { 36; }") unless defined(&SNDRV_CHMAP_BRC);
    eval("sub SNDRV_CHMAP_LAST () { SNDRV_CHMAP_BRC; }") unless defined(&SNDRV_CHMAP_LAST);
    eval 'sub SNDRV_CHMAP_POSITION_MASK () {0xffff;}' unless defined(&SNDRV_CHMAP_POSITION_MASK);
    eval 'sub SNDRV_CHMAP_PHASE_INVERSE () {(0x1 << 16);}' unless defined(&SNDRV_CHMAP_PHASE_INVERSE);
    eval 'sub SNDRV_CHMAP_DRIVER_SPEC () {(0x2 << 16);}' unless defined(&SNDRV_CHMAP_DRIVER_SPEC);
    eval 'sub SNDRV_PCM_IOCTL_PVERSION () { &_IOR(ord(\'A\'), 0x, \'int\');}' unless defined(&SNDRV_PCM_IOCTL_PVERSION);
    eval 'sub SNDRV_PCM_IOCTL_INFO () { &_IOR(ord(\'A\'), 0x1, \'struct snd_pcm_info\');}' unless defined(&SNDRV_PCM_IOCTL_INFO);
    eval 'sub SNDRV_PCM_IOCTL_TSTAMP () { &_IOW(ord(\'A\'), 0x2, \'int\');}' unless defined(&SNDRV_PCM_IOCTL_TSTAMP);
    eval 'sub SNDRV_PCM_IOCTL_TTSTAMP () { &_IOW(ord(\'A\'), 0x3, \'int\');}' unless defined(&SNDRV_PCM_IOCTL_TTSTAMP);
    eval 'sub SNDRV_PCM_IOCTL_USER_PVERSION () { &_IOW(ord(\'A\'), 0x4, \'int\');}' unless defined(&SNDRV_PCM_IOCTL_USER_PVERSION);
    eval 'sub SNDRV_PCM_IOCTL_HW_REFINE () { &_IOWR(ord(\'A\'), 0x10, \'struct snd_pcm_hw_params\');}' unless defined(&SNDRV_PCM_IOCTL_HW_REFINE);
    eval 'sub SNDRV_PCM_IOCTL_HW_PARAMS () { &_IOWR(ord(\'A\'), 0x11, \'struct snd_pcm_hw_params\');}' unless defined(&SNDRV_PCM_IOCTL_HW_PARAMS);
    eval 'sub SNDRV_PCM_IOCTL_HW_FREE () { &_IO(ord(\'A\'), 0x12);}' unless defined(&SNDRV_PCM_IOCTL_HW_FREE);
    eval 'sub SNDRV_PCM_IOCTL_SW_PARAMS () { &_IOWR(ord(\'A\'), 0x13, \'struct snd_pcm_sw_params\');}' unless defined(&SNDRV_PCM_IOCTL_SW_PARAMS);
    eval 'sub SNDRV_PCM_IOCTL_STATUS () { &_IOR(ord(\'A\'), 0x20, \'struct snd_pcm_status\');}' unless defined(&SNDRV_PCM_IOCTL_STATUS);
    eval 'sub SNDRV_PCM_IOCTL_DELAY () { &_IOR(ord(\'A\'), 0x21,  &snd_pcm_sframes_t);}' unless defined(&SNDRV_PCM_IOCTL_DELAY);
    eval 'sub SNDRV_PCM_IOCTL_HWSYNC () { &_IO(ord(\'A\'), 0x22);}' unless defined(&SNDRV_PCM_IOCTL_HWSYNC);
    eval 'sub __SNDRV_PCM_IOCTL_SYNC_PTR () { &_IOWR(ord(\'A\'), 0x23, \'struct __snd_pcm_sync_ptr\');}' unless defined(&__SNDRV_PCM_IOCTL_SYNC_PTR);
    eval 'sub __SNDRV_PCM_IOCTL_SYNC_PTR64 () { &_IOWR(ord(\'A\'), 0x23, \'struct __snd_pcm_sync_ptr64\');}' unless defined(&__SNDRV_PCM_IOCTL_SYNC_PTR64);
    eval 'sub SNDRV_PCM_IOCTL_SYNC_PTR () { &_IOWR(ord(\'A\'), 0x23, \'struct snd_pcm_sync_ptr\');}' unless defined(&SNDRV_PCM_IOCTL_SYNC_PTR);
    eval 'sub SNDRV_PCM_IOCTL_STATUS_EXT () { &_IOWR(ord(\'A\'), 0x24, \'struct snd_pcm_status\');}' unless defined(&SNDRV_PCM_IOCTL_STATUS_EXT);
    eval 'sub SNDRV_PCM_IOCTL_CHANNEL_INFO () { &_IOR(ord(\'A\'), 0x32, \'struct snd_pcm_channel_info\');}' unless defined(&SNDRV_PCM_IOCTL_CHANNEL_INFO);
    eval 'sub SNDRV_PCM_IOCTL_PREPARE () { &_IO(ord(\'A\'), 0x40);}' unless defined(&SNDRV_PCM_IOCTL_PREPARE);
    eval 'sub SNDRV_PCM_IOCTL_RESET () { &_IO(ord(\'A\'), 0x41);}' unless defined(&SNDRV_PCM_IOCTL_RESET);
    eval 'sub SNDRV_PCM_IOCTL_START () { &_IO(ord(\'A\'), 0x42);}' unless defined(&SNDRV_PCM_IOCTL_START);
    eval 'sub SNDRV_PCM_IOCTL_DROP () { &_IO(ord(\'A\'), 0x43);}' unless defined(&SNDRV_PCM_IOCTL_DROP);
    eval 'sub SNDRV_PCM_IOCTL_DRAIN () { &_IO(ord(\'A\'), 0x44);}' unless defined(&SNDRV_PCM_IOCTL_DRAIN);
    eval 'sub SNDRV_PCM_IOCTL_PAUSE () { &_IOW(ord(\'A\'), 0x45, \'int\');}' unless defined(&SNDRV_PCM_IOCTL_PAUSE);
    eval 'sub SNDRV_PCM_IOCTL_REWIND () { &_IOW(ord(\'A\'), 0x46,  &snd_pcm_uframes_t);}' unless defined(&SNDRV_PCM_IOCTL_REWIND);
    eval 'sub SNDRV_PCM_IOCTL_RESUME () { &_IO(ord(\'A\'), 0x47);}' unless defined(&SNDRV_PCM_IOCTL_RESUME);
    eval 'sub SNDRV_PCM_IOCTL_XRUN () { &_IO(ord(\'A\'), 0x48);}' unless defined(&SNDRV_PCM_IOCTL_XRUN);
    eval 'sub SNDRV_PCM_IOCTL_FORWARD () { &_IOW(ord(\'A\'), 0x49,  &snd_pcm_uframes_t);}' unless defined(&SNDRV_PCM_IOCTL_FORWARD);
    eval 'sub SNDRV_PCM_IOCTL_WRITEI_FRAMES () { &_IOW(ord(\'A\'), 0x50, \'struct snd_xferi\');}' unless defined(&SNDRV_PCM_IOCTL_WRITEI_FRAMES);
    eval 'sub SNDRV_PCM_IOCTL_READI_FRAMES () { &_IOR(ord(\'A\'), 0x51, \'struct snd_xferi\');}' unless defined(&SNDRV_PCM_IOCTL_READI_FRAMES);
    eval 'sub SNDRV_PCM_IOCTL_WRITEN_FRAMES () { &_IOW(ord(\'A\'), 0x52, \'struct snd_xfern\');}' unless defined(&SNDRV_PCM_IOCTL_WRITEN_FRAMES);
    eval 'sub SNDRV_PCM_IOCTL_READN_FRAMES () { &_IOR(ord(\'A\'), 0x53, \'struct snd_xfern\');}' unless defined(&SNDRV_PCM_IOCTL_READN_FRAMES);
    eval 'sub SNDRV_PCM_IOCTL_LINK () { &_IOW(ord(\'A\'), 0x60, \'int\');}' unless defined(&SNDRV_PCM_IOCTL_LINK);
    eval 'sub SNDRV_PCM_IOCTL_UNLINK () { &_IO(ord(\'A\'), 0x61);}' unless defined(&SNDRV_PCM_IOCTL_UNLINK);
    eval 'sub SNDRV_RAWMIDI_VERSION () { &SNDRV_PROTOCOL_VERSION(2, 0, 2);}' unless defined(&SNDRV_RAWMIDI_VERSION);
    eval("sub SNDRV_RAWMIDI_STREAM_OUTPUT () { 0; }") unless defined(&SNDRV_RAWMIDI_STREAM_OUTPUT);
    eval("sub SNDRV_RAWMIDI_STREAM_INPUT () { 1; }") unless defined(&SNDRV_RAWMIDI_STREAM_INPUT);
    eval("sub SNDRV_RAWMIDI_STREAM_LAST () { SNDRV_RAWMIDI_STREAM_INPUT; }") unless defined(&SNDRV_RAWMIDI_STREAM_LAST);
    eval 'sub SNDRV_RAWMIDI_INFO_OUTPUT () {0x1;}' unless defined(&SNDRV_RAWMIDI_INFO_OUTPUT);
    eval 'sub SNDRV_RAWMIDI_INFO_INPUT () {0x2;}' unless defined(&SNDRV_RAWMIDI_INFO_INPUT);
    eval 'sub SNDRV_RAWMIDI_INFO_DUPLEX () {0x4;}' unless defined(&SNDRV_RAWMIDI_INFO_DUPLEX);
    eval 'sub SNDRV_RAWMIDI_MODE_FRAMING_MASK () {(7<<0);}' unless defined(&SNDRV_RAWMIDI_MODE_FRAMING_MASK);
    eval 'sub SNDRV_RAWMIDI_MODE_FRAMING_SHIFT () {0;}' unless defined(&SNDRV_RAWMIDI_MODE_FRAMING_SHIFT);
    eval 'sub SNDRV_RAWMIDI_MODE_FRAMING_NONE () {(0<<0);}' unless defined(&SNDRV_RAWMIDI_MODE_FRAMING_NONE);
    eval 'sub SNDRV_RAWMIDI_MODE_FRAMING_TSTAMP () {(1<<0);}' unless defined(&SNDRV_RAWMIDI_MODE_FRAMING_TSTAMP);
    eval 'sub SNDRV_RAWMIDI_MODE_CLOCK_MASK () {(7<<3);}' unless defined(&SNDRV_RAWMIDI_MODE_CLOCK_MASK);
    eval 'sub SNDRV_RAWMIDI_MODE_CLOCK_SHIFT () {3;}' unless defined(&SNDRV_RAWMIDI_MODE_CLOCK_SHIFT);
    eval 'sub SNDRV_RAWMIDI_MODE_CLOCK_NONE () {(0<<3);}' unless defined(&SNDRV_RAWMIDI_MODE_CLOCK_NONE);
    eval 'sub SNDRV_RAWMIDI_MODE_CLOCK_REALTIME () {(1<<3);}' unless defined(&SNDRV_RAWMIDI_MODE_CLOCK_REALTIME);
    eval 'sub SNDRV_RAWMIDI_MODE_CLOCK_MONOTONIC () {(2<<3);}' unless defined(&SNDRV_RAWMIDI_MODE_CLOCK_MONOTONIC);
    eval 'sub SNDRV_RAWMIDI_MODE_CLOCK_MONOTONIC_RAW () {(3<<3);}' unless defined(&SNDRV_RAWMIDI_MODE_CLOCK_MONOTONIC_RAW);
    eval 'sub SNDRV_RAWMIDI_FRAMING_DATA_LENGTH () {16;}' unless defined(&SNDRV_RAWMIDI_FRAMING_DATA_LENGTH);
    eval 'sub SNDRV_RAWMIDI_IOCTL_PVERSION () { &_IOR(ord(\'W\'), 0x, \'int\');}' unless defined(&SNDRV_RAWMIDI_IOCTL_PVERSION);
    eval 'sub SNDRV_RAWMIDI_IOCTL_INFO () { &_IOR(ord(\'W\'), 0x1, \'struct snd_rawmidi_info\');}' unless defined(&SNDRV_RAWMIDI_IOCTL_INFO);
    eval 'sub SNDRV_RAWMIDI_IOCTL_USER_PVERSION () { &_IOW(ord(\'W\'), 0x2, \'int\');}' unless defined(&SNDRV_RAWMIDI_IOCTL_USER_PVERSION);
    eval 'sub SNDRV_RAWMIDI_IOCTL_PARAMS () { &_IOWR(ord(\'W\'), 0x10, \'struct snd_rawmidi_params\');}' unless defined(&SNDRV_RAWMIDI_IOCTL_PARAMS);
    eval 'sub SNDRV_RAWMIDI_IOCTL_STATUS () { &_IOWR(ord(\'W\'), 0x20, \'struct snd_rawmidi_status\');}' unless defined(&SNDRV_RAWMIDI_IOCTL_STATUS);
    eval 'sub SNDRV_RAWMIDI_IOCTL_DROP () { &_IOW(ord(\'W\'), 0x30, \'int\');}' unless defined(&SNDRV_RAWMIDI_IOCTL_DROP);
    eval 'sub SNDRV_RAWMIDI_IOCTL_DRAIN () { &_IOW(ord(\'W\'), 0x31, \'int\');}' unless defined(&SNDRV_RAWMIDI_IOCTL_DRAIN);
    eval 'sub SNDRV_TIMER_VERSION () { &SNDRV_PROTOCOL_VERSION(2, 0, 7);}' unless defined(&SNDRV_TIMER_VERSION);
    eval("sub SNDRV_TIMER_CLASS_NONE () { -1; }") unless defined(&SNDRV_TIMER_CLASS_NONE);
    eval("sub SNDRV_TIMER_CLASS_SLAVE () { 0; }") unless defined(&SNDRV_TIMER_CLASS_SLAVE);
    eval("sub SNDRV_TIMER_CLASS_GLOBAL () { 1; }") unless defined(&SNDRV_TIMER_CLASS_GLOBAL);
    eval("sub SNDRV_TIMER_CLASS_CARD () { 2; }") unless defined(&SNDRV_TIMER_CLASS_CARD);
    eval("sub SNDRV_TIMER_CLASS_PCM () { 3; }") unless defined(&SNDRV_TIMER_CLASS_PCM);
    eval("sub SNDRV_TIMER_CLASS_LAST () { SNDRV_TIMER_CLASS_PCM; }") unless defined(&SNDRV_TIMER_CLASS_LAST);
    eval("sub SNDRV_TIMER_SCLASS_NONE () { 0; }") unless defined(&SNDRV_TIMER_SCLASS_NONE);
    eval("sub SNDRV_TIMER_SCLASS_APPLICATION () { 1; }") unless defined(&SNDRV_TIMER_SCLASS_APPLICATION);
    eval("sub SNDRV_TIMER_SCLASS_SEQUENCER () { 2; }") unless defined(&SNDRV_TIMER_SCLASS_SEQUENCER);
    eval("sub SNDRV_TIMER_SCLASS_OSS_SEQUENCER () { 3; }") unless defined(&SNDRV_TIMER_SCLASS_OSS_SEQUENCER);
    eval("sub SNDRV_TIMER_SCLASS_LAST () { SNDRV_TIMER_SCLASS_OSS_SEQUENCER; }") unless defined(&SNDRV_TIMER_SCLASS_LAST);
    eval 'sub SNDRV_TIMER_GLOBAL_SYSTEM () {0;}' unless defined(&SNDRV_TIMER_GLOBAL_SYSTEM);
    eval 'sub SNDRV_TIMER_GLOBAL_RTC () {1;}' unless defined(&SNDRV_TIMER_GLOBAL_RTC);
    eval 'sub SNDRV_TIMER_GLOBAL_HPET () {2;}' unless defined(&SNDRV_TIMER_GLOBAL_HPET);
    eval 'sub SNDRV_TIMER_GLOBAL_HRTIMER () {3;}' unless defined(&SNDRV_TIMER_GLOBAL_HRTIMER);
    eval 'sub SNDRV_TIMER_FLG_SLAVE () {(1<<0);}' unless defined(&SNDRV_TIMER_FLG_SLAVE);
    eval 'sub SNDRV_TIMER_PSFLG_AUTO () {(1<<0);}' unless defined(&SNDRV_TIMER_PSFLG_AUTO);
    eval 'sub SNDRV_TIMER_PSFLG_EXCLUSIVE () {(1<<1);}' unless defined(&SNDRV_TIMER_PSFLG_EXCLUSIVE);
    eval 'sub SNDRV_TIMER_PSFLG_EARLY_EVENT () {(1<<2);}' unless defined(&SNDRV_TIMER_PSFLG_EARLY_EVENT);
    eval 'sub SNDRV_TIMER_IOCTL_PVERSION () { &_IOR(ord(\'T\'), 0x, \'int\');}' unless defined(&SNDRV_TIMER_IOCTL_PVERSION);
    eval 'sub SNDRV_TIMER_IOCTL_NEXT_DEVICE () { &_IOWR(ord(\'T\'), 0x1, \'struct snd_timer_id\');}' unless defined(&SNDRV_TIMER_IOCTL_NEXT_DEVICE);
    eval 'sub SNDRV_TIMER_IOCTL_TREAD_OLD () { &_IOW(ord(\'T\'), 0x2, \'int\');}' unless defined(&SNDRV_TIMER_IOCTL_TREAD_OLD);
    eval 'sub SNDRV_TIMER_IOCTL_GINFO () { &_IOWR(ord(\'T\'), 0x3, \'struct snd_timer_ginfo\');}' unless defined(&SNDRV_TIMER_IOCTL_GINFO);
    eval 'sub SNDRV_TIMER_IOCTL_GPARAMS () { &_IOW(ord(\'T\'), 0x4, \'struct snd_timer_gparams\');}' unless defined(&SNDRV_TIMER_IOCTL_GPARAMS);
    eval 'sub SNDRV_TIMER_IOCTL_GSTATUS () { &_IOWR(ord(\'T\'), 0x5, \'struct snd_timer_gstatus\');}' unless defined(&SNDRV_TIMER_IOCTL_GSTATUS);
    eval 'sub SNDRV_TIMER_IOCTL_SELECT () { &_IOW(ord(\'T\'), 0x10, \'struct snd_timer_select\');}' unless defined(&SNDRV_TIMER_IOCTL_SELECT);
    eval 'sub SNDRV_TIMER_IOCTL_INFO () { &_IOR(ord(\'T\'), 0x11, \'struct snd_timer_info\');}' unless defined(&SNDRV_TIMER_IOCTL_INFO);
    eval 'sub SNDRV_TIMER_IOCTL_PARAMS () { &_IOW(ord(\'T\'), 0x12, \'struct snd_timer_params\');}' unless defined(&SNDRV_TIMER_IOCTL_PARAMS);
    eval 'sub SNDRV_TIMER_IOCTL_STATUS () { &_IOR(ord(\'T\'), 0x14, \'struct snd_timer_status\');}' unless defined(&SNDRV_TIMER_IOCTL_STATUS);
    eval 'sub SNDRV_TIMER_IOCTL_START () { &_IO(ord(\'T\'), 0xa0);}' unless defined(&SNDRV_TIMER_IOCTL_START);
    eval 'sub SNDRV_TIMER_IOCTL_STOP () { &_IO(ord(\'T\'), 0xa1);}' unless defined(&SNDRV_TIMER_IOCTL_STOP);
    eval 'sub SNDRV_TIMER_IOCTL_CONTINUE () { &_IO(ord(\'T\'), 0xa2);}' unless defined(&SNDRV_TIMER_IOCTL_CONTINUE);
    eval 'sub SNDRV_TIMER_IOCTL_PAUSE () { &_IO(ord(\'T\'), 0xa3);}' unless defined(&SNDRV_TIMER_IOCTL_PAUSE);
    eval 'sub SNDRV_TIMER_IOCTL_TREAD64 () { &_IOW(ord(\'T\'), 0xa4, \'int\');}' unless defined(&SNDRV_TIMER_IOCTL_TREAD64);
    if((defined(&__BITS_PER_LONG) ? &__BITS_PER_LONG : undef) == 64) {
	eval 'sub SNDRV_TIMER_IOCTL_TREAD () { &SNDRV_TIMER_IOCTL_TREAD_OLD;}' unless defined(&SNDRV_TIMER_IOCTL_TREAD);
    } else {
	eval 'sub SNDRV_TIMER_IOCTL_TREAD () {(($sizeof{\'__kernel_long_t\'} >= $sizeof{ &time_t}) ?  &SNDRV_TIMER_IOCTL_TREAD_OLD :  &SNDRV_TIMER_IOCTL_TREAD64);}' unless defined(&SNDRV_TIMER_IOCTL_TREAD);
    }
    eval("sub SNDRV_TIMER_EVENT_RESOLUTION () { 0; }") unless defined(&SNDRV_TIMER_EVENT_RESOLUTION);
    eval("sub SNDRV_TIMER_EVENT_TICK () { 1; }") unless defined(&SNDRV_TIMER_EVENT_TICK);
    eval("sub SNDRV_TIMER_EVENT_START () { 2; }") unless defined(&SNDRV_TIMER_EVENT_START);
    eval("sub SNDRV_TIMER_EVENT_STOP () { 3; }") unless defined(&SNDRV_TIMER_EVENT_STOP);
    eval("sub SNDRV_TIMER_EVENT_CONTINUE () { 4; }") unless defined(&SNDRV_TIMER_EVENT_CONTINUE);
    eval("sub SNDRV_TIMER_EVENT_PAUSE () { 5; }") unless defined(&SNDRV_TIMER_EVENT_PAUSE);
    eval("sub SNDRV_TIMER_EVENT_EARLY () { 6; }") unless defined(&SNDRV_TIMER_EVENT_EARLY);
    eval("sub SNDRV_TIMER_EVENT_SUSPEND () { 7; }") unless defined(&SNDRV_TIMER_EVENT_SUSPEND);
    eval("sub SNDRV_TIMER_EVENT_RESUME () { 8; }") unless defined(&SNDRV_TIMER_EVENT_RESUME);
    eval("sub SNDRV_TIMER_EVENT_MSTART () { SNDRV_TIMER_EVENT_START+10; }") unless defined(&SNDRV_TIMER_EVENT_MSTART);
    eval("sub SNDRV_TIMER_EVENT_MSTOP () { SNDRV_TIMER_EVENT_STOP+10; }") unless defined(&SNDRV_TIMER_EVENT_MSTOP);
    eval("sub SNDRV_TIMER_EVENT_MCONTINUE () { SNDRV_TIMER_EVENT_CONTINUE+10; }") unless defined(&SNDRV_TIMER_EVENT_MCONTINUE);
    eval("sub SNDRV_TIMER_EVENT_MPAUSE () { SNDRV_TIMER_EVENT_PAUSE+10; }") unless defined(&SNDRV_TIMER_EVENT_MPAUSE);
    eval("sub SNDRV_TIMER_EVENT_MSUSPEND () { SNDRV_TIMER_EVENT_SUSPEND+10; }") unless defined(&SNDRV_TIMER_EVENT_MSUSPEND);
    eval("sub SNDRV_TIMER_EVENT_MRESUME () { SNDRV_TIMER_EVENT_RESUME+10; }") unless defined(&SNDRV_TIMER_EVENT_MRESUME);
    eval 'sub SNDRV_CTL_VERSION () { &SNDRV_PROTOCOL_VERSION(2, 0, 8);}' unless defined(&SNDRV_CTL_VERSION);
    eval 'sub SNDRV_CTL_ELEM_TYPE_NONE () {(( &snd_ctl_elem_type_t) 0);}' unless defined(&SNDRV_CTL_ELEM_TYPE_NONE);
    eval 'sub SNDRV_CTL_ELEM_TYPE_BOOLEAN () {(( &snd_ctl_elem_type_t) 1);}' unless defined(&SNDRV_CTL_ELEM_TYPE_BOOLEAN);
    eval 'sub SNDRV_CTL_ELEM_TYPE_INTEGER () {(( &snd_ctl_elem_type_t) 2);}' unless defined(&SNDRV_CTL_ELEM_TYPE_INTEGER);
    eval 'sub SNDRV_CTL_ELEM_TYPE_ENUMERATED () {(( &snd_ctl_elem_type_t) 3);}' unless defined(&SNDRV_CTL_ELEM_TYPE_ENUMERATED);
    eval 'sub SNDRV_CTL_ELEM_TYPE_BYTES () {(( &snd_ctl_elem_type_t) 4);}' unless defined(&SNDRV_CTL_ELEM_TYPE_BYTES);
    eval 'sub SNDRV_CTL_ELEM_TYPE_IEC958 () {(( &snd_ctl_elem_type_t) 5);}' unless defined(&SNDRV_CTL_ELEM_TYPE_IEC958);
    eval 'sub SNDRV_CTL_ELEM_TYPE_INTEGER64 () {(( &snd_ctl_elem_type_t) 6);}' unless defined(&SNDRV_CTL_ELEM_TYPE_INTEGER64);
    eval 'sub SNDRV_CTL_ELEM_TYPE_LAST () { &SNDRV_CTL_ELEM_TYPE_INTEGER64;}' unless defined(&SNDRV_CTL_ELEM_TYPE_LAST);
    eval 'sub SNDRV_CTL_ELEM_IFACE_CARD () {(( &snd_ctl_elem_iface_t) 0);}' unless defined(&SNDRV_CTL_ELEM_IFACE_CARD);
    eval 'sub SNDRV_CTL_ELEM_IFACE_HWDEP () {(( &snd_ctl_elem_iface_t) 1);}' unless defined(&SNDRV_CTL_ELEM_IFACE_HWDEP);
    eval 'sub SNDRV_CTL_ELEM_IFACE_MIXER () {(( &snd_ctl_elem_iface_t) 2);}' unless defined(&SNDRV_CTL_ELEM_IFACE_MIXER);
    eval 'sub SNDRV_CTL_ELEM_IFACE_PCM () {(( &snd_ctl_elem_iface_t) 3);}' unless defined(&SNDRV_CTL_ELEM_IFACE_PCM);
    eval 'sub SNDRV_CTL_ELEM_IFACE_RAWMIDI () {(( &snd_ctl_elem_iface_t) 4);}' unless defined(&SNDRV_CTL_ELEM_IFACE_RAWMIDI);
    eval 'sub SNDRV_CTL_ELEM_IFACE_TIMER () {(( &snd_ctl_elem_iface_t) 5);}' unless defined(&SNDRV_CTL_ELEM_IFACE_TIMER);
    eval 'sub SNDRV_CTL_ELEM_IFACE_SEQUENCER () {(( &snd_ctl_elem_iface_t) 6);}' unless defined(&SNDRV_CTL_ELEM_IFACE_SEQUENCER);
    eval 'sub SNDRV_CTL_ELEM_IFACE_LAST () { &SNDRV_CTL_ELEM_IFACE_SEQUENCER;}' unless defined(&SNDRV_CTL_ELEM_IFACE_LAST);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_READ () {(1<<0);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_READ);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_WRITE () {(1<<1);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_WRITE);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_READWRITE () {( &SNDRV_CTL_ELEM_ACCESS_READ| &SNDRV_CTL_ELEM_ACCESS_WRITE);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_READWRITE);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_VOLATILE () {(1<<2);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_VOLATILE);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_TLV_READ () {(1<<4);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_TLV_READ);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_TLV_WRITE () {(1<<5);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_TLV_WRITE);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_TLV_READWRITE () {( &SNDRV_CTL_ELEM_ACCESS_TLV_READ| &SNDRV_CTL_ELEM_ACCESS_TLV_WRITE);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_TLV_READWRITE);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_TLV_COMMAND () {(1<<6);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_TLV_COMMAND);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_INACTIVE () {(1<<8);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_INACTIVE);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_LOCK () {(1<<9);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_LOCK);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_OWNER () {(1<<10);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_OWNER);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_TLV_CALLBACK () {(1<<28);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_TLV_CALLBACK);
    eval 'sub SNDRV_CTL_ELEM_ACCESS_USER () {(1<<29);}' unless defined(&SNDRV_CTL_ELEM_ACCESS_USER);
    eval 'sub SNDRV_CTL_POWER_D0 () {0x;}' unless defined(&SNDRV_CTL_POWER_D0);
    eval 'sub SNDRV_CTL_POWER_D1 () {0x100;}' unless defined(&SNDRV_CTL_POWER_D1);
    eval 'sub SNDRV_CTL_POWER_D2 () {0x200;}' unless defined(&SNDRV_CTL_POWER_D2);
    eval 'sub SNDRV_CTL_POWER_D3 () {0x300;}' unless defined(&SNDRV_CTL_POWER_D3);
    eval 'sub SNDRV_CTL_POWER_D3hot () {( &SNDRV_CTL_POWER_D3|0x);}' unless defined(&SNDRV_CTL_POWER_D3hot);
    eval 'sub SNDRV_CTL_POWER_D3cold () {( &SNDRV_CTL_POWER_D3|0x1);}' unless defined(&SNDRV_CTL_POWER_D3cold);
    eval 'sub SNDRV_CTL_ELEM_ID_NAME_MAXLEN () {44;}' unless defined(&SNDRV_CTL_ELEM_ID_NAME_MAXLEN);
    eval 'sub SNDRV_CTL_IOCTL_PVERSION () { &_IOR(ord(\'U\'), 0x, \'int\');}' unless defined(&SNDRV_CTL_IOCTL_PVERSION);
    eval 'sub SNDRV_CTL_IOCTL_CARD_INFO () { &_IOR(ord(\'U\'), 0x1, \'struct snd_ctl_card_info\');}' unless defined(&SNDRV_CTL_IOCTL_CARD_INFO);
    eval 'sub SNDRV_CTL_IOCTL_ELEM_LIST () { &_IOWR(ord(\'U\'), 0x10, \'struct snd_ctl_elem_list\');}' unless defined(&SNDRV_CTL_IOCTL_ELEM_LIST);
    eval 'sub SNDRV_CTL_IOCTL_ELEM_INFO () { &_IOWR(ord(\'U\'), 0x11, \'struct snd_ctl_elem_info\');}' unless defined(&SNDRV_CTL_IOCTL_ELEM_INFO);
    eval 'sub SNDRV_CTL_IOCTL_ELEM_READ () { &_IOWR(ord(\'U\'), 0x12, \'struct snd_ctl_elem_value\');}' unless defined(&SNDRV_CTL_IOCTL_ELEM_READ);
    eval 'sub SNDRV_CTL_IOCTL_ELEM_WRITE () { &_IOWR(ord(\'U\'), 0x13, \'struct snd_ctl_elem_value\');}' unless defined(&SNDRV_CTL_IOCTL_ELEM_WRITE);
    eval 'sub SNDRV_CTL_IOCTL_ELEM_LOCK () { &_IOW(ord(\'U\'), 0x14, \'struct snd_ctl_elem_id\');}' unless defined(&SNDRV_CTL_IOCTL_ELEM_LOCK);
    eval 'sub SNDRV_CTL_IOCTL_ELEM_UNLOCK () { &_IOW(ord(\'U\'), 0x15, \'struct snd_ctl_elem_id\');}' unless defined(&SNDRV_CTL_IOCTL_ELEM_UNLOCK);
    eval 'sub SNDRV_CTL_IOCTL_SUBSCRIBE_EVENTS () { &_IOWR(ord(\'U\'), 0x16, \'int\');}' unless defined(&SNDRV_CTL_IOCTL_SUBSCRIBE_EVENTS);
    eval 'sub SNDRV_CTL_IOCTL_ELEM_ADD () { &_IOWR(ord(\'U\'), 0x17, \'struct snd_ctl_elem_info\');}' unless defined(&SNDRV_CTL_IOCTL_ELEM_ADD);
    eval 'sub SNDRV_CTL_IOCTL_ELEM_REPLACE () { &_IOWR(ord(\'U\'), 0x18, \'struct snd_ctl_elem_info\');}' unless defined(&SNDRV_CTL_IOCTL_ELEM_REPLACE);
    eval 'sub SNDRV_CTL_IOCTL_ELEM_REMOVE () { &_IOWR(ord(\'U\'), 0x19, \'struct snd_ctl_elem_id\');}' unless defined(&SNDRV_CTL_IOCTL_ELEM_REMOVE);
    eval 'sub SNDRV_CTL_IOCTL_TLV_READ () { &_IOWR(ord(\'U\'), 0x1a, \'struct snd_ctl_tlv\');}' unless defined(&SNDRV_CTL_IOCTL_TLV_READ);
    eval 'sub SNDRV_CTL_IOCTL_TLV_WRITE () { &_IOWR(ord(\'U\'), 0x1b, \'struct snd_ctl_tlv\');}' unless defined(&SNDRV_CTL_IOCTL_TLV_WRITE);
    eval 'sub SNDRV_CTL_IOCTL_TLV_COMMAND () { &_IOWR(ord(\'U\'), 0x1c, \'struct snd_ctl_tlv\');}' unless defined(&SNDRV_CTL_IOCTL_TLV_COMMAND);
    eval 'sub SNDRV_CTL_IOCTL_HWDEP_NEXT_DEVICE () { &_IOWR(ord(\'U\'), 0x20, \'int\');}' unless defined(&SNDRV_CTL_IOCTL_HWDEP_NEXT_DEVICE);
    eval 'sub SNDRV_CTL_IOCTL_HWDEP_INFO () { &_IOR(ord(\'U\'), 0x21, \'struct snd_hwdep_info\');}' unless defined(&SNDRV_CTL_IOCTL_HWDEP_INFO);
    eval 'sub SNDRV_CTL_IOCTL_PCM_NEXT_DEVICE () { &_IOR(ord(\'U\'), 0x30, \'int\');}' unless defined(&SNDRV_CTL_IOCTL_PCM_NEXT_DEVICE);
    eval 'sub SNDRV_CTL_IOCTL_PCM_INFO () { &_IOWR(ord(\'U\'), 0x31, \'struct snd_pcm_info\');}' unless defined(&SNDRV_CTL_IOCTL_PCM_INFO);
    eval 'sub SNDRV_CTL_IOCTL_PCM_PREFER_SUBDEVICE () { &_IOW(ord(\'U\'), 0x32, \'int\');}' unless defined(&SNDRV_CTL_IOCTL_PCM_PREFER_SUBDEVICE);
    eval 'sub SNDRV_CTL_IOCTL_RAWMIDI_NEXT_DEVICE () { &_IOWR(ord(\'U\'), 0x40, \'int\');}' unless defined(&SNDRV_CTL_IOCTL_RAWMIDI_NEXT_DEVICE);
    eval 'sub SNDRV_CTL_IOCTL_RAWMIDI_INFO () { &_IOWR(ord(\'U\'), 0x41, \'struct snd_rawmidi_info\');}' unless defined(&SNDRV_CTL_IOCTL_RAWMIDI_INFO);
    eval 'sub SNDRV_CTL_IOCTL_RAWMIDI_PREFER_SUBDEVICE () { &_IOW(ord(\'U\'), 0x42, \'int\');}' unless defined(&SNDRV_CTL_IOCTL_RAWMIDI_PREFER_SUBDEVICE);
    eval 'sub SNDRV_CTL_IOCTL_POWER () { &_IOWR(ord(\'U\'), 0xd0, \'int\');}' unless defined(&SNDRV_CTL_IOCTL_POWER);
    eval 'sub SNDRV_CTL_IOCTL_POWER_STATE () { &_IOR(ord(\'U\'), 0xd1, \'int\');}' unless defined(&SNDRV_CTL_IOCTL_POWER_STATE);
    eval("sub SNDRV_CTL_EVENT_ELEM () { 0; }") unless defined(&SNDRV_CTL_EVENT_ELEM);
    eval("sub SNDRV_CTL_EVENT_LAST () { SNDRV_CTL_EVENT_ELEM; }") unless defined(&SNDRV_CTL_EVENT_LAST);
    eval 'sub SNDRV_CTL_EVENT_MASK_VALUE () {(1<<0);}' unless defined(&SNDRV_CTL_EVENT_MASK_VALUE);
    eval 'sub SNDRV_CTL_EVENT_MASK_INFO () {(1<<1);}' unless defined(&SNDRV_CTL_EVENT_MASK_INFO);
    eval 'sub SNDRV_CTL_EVENT_MASK_ADD () {(1<<2);}' unless defined(&SNDRV_CTL_EVENT_MASK_ADD);
    eval 'sub SNDRV_CTL_EVENT_MASK_TLV () {(1<<3);}' unless defined(&SNDRV_CTL_EVENT_MASK_TLV);
    eval 'sub SNDRV_CTL_EVENT_MASK_REMOVE () {(~0);}' unless defined(&SNDRV_CTL_EVENT_MASK_REMOVE);
    eval 'sub SNDRV_CTL_NAME_NONE () {"";}' unless defined(&SNDRV_CTL_NAME_NONE);
    eval 'sub SNDRV_CTL_NAME_PLAYBACK () {"Playback ";}' unless defined(&SNDRV_CTL_NAME_PLAYBACK);
    eval 'sub SNDRV_CTL_NAME_CAPTURE () {"Capture ";}' unless defined(&SNDRV_CTL_NAME_CAPTURE);
    eval 'sub SNDRV_CTL_NAME_IEC958_NONE () {"";}' unless defined(&SNDRV_CTL_NAME_IEC958_NONE);
    eval 'sub SNDRV_CTL_NAME_IEC958_SWITCH () {"Switch";}' unless defined(&SNDRV_CTL_NAME_IEC958_SWITCH);
    eval 'sub SNDRV_CTL_NAME_IEC958_VOLUME () {"Volume";}' unless defined(&SNDRV_CTL_NAME_IEC958_VOLUME);
    eval 'sub SNDRV_CTL_NAME_IEC958_DEFAULT () {"Default";}' unless defined(&SNDRV_CTL_NAME_IEC958_DEFAULT);
    eval 'sub SNDRV_CTL_NAME_IEC958_MASK () {"Mask";}' unless defined(&SNDRV_CTL_NAME_IEC958_MASK);
    eval 'sub SNDRV_CTL_NAME_IEC958_CON_MASK () {"Con Mask";}' unless defined(&SNDRV_CTL_NAME_IEC958_CON_MASK);
    eval 'sub SNDRV_CTL_NAME_IEC958_PRO_MASK () {"Pro Mask";}' unless defined(&SNDRV_CTL_NAME_IEC958_PRO_MASK);
    eval 'sub SNDRV_CTL_NAME_IEC958_PCM_STREAM () {"PCM Stream";}' unless defined(&SNDRV_CTL_NAME_IEC958_PCM_STREAM);
    eval 'sub SNDRV_CTL_NAME_IEC958 {
        my($expl,$direction,$what) = @_;
	    eval q(\\"IEC958 \\" $expl  &SNDRV_CTL_NAME_$direction  &SNDRV_CTL_NAME_IEC958_$what);
    }' unless defined(&SNDRV_CTL_NAME_IEC958);
}
1;
