# The PEP 484 type hints stub file for the Qwt module.
#
# Generated by SIP 4.19.25


import typing
import sip

from PyQt5 import QtWidgets
from PyQt5 import QtGui
from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QwtAbstractLegend(QtWidgets.QFrame):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def updateLegend(self, itemInfo: typing.Any, data: typing.Iterable['QwtLegendData']) -> None: ...
    def scrollExtent(self, a0: QtCore.Qt.Orientation) -> int: ...
    def isEmpty(self) -> bool: ...
    def renderLegend(self, painter: QtGui.QPainter, rect: QtCore.QRectF, fillBackground: bool) -> None: ...


class QwtLegend(QwtAbstractLegend):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def updateWidget(self, widget: QtWidgets.QWidget, data: 'QwtLegendData') -> None: ...
    def createWidget(self, a0: 'QwtLegendData') -> QtWidgets.QWidget: ...
    def itemChecked(self, a0: bool) -> None: ...
    def itemClicked(self) -> None: ...
    def updateLegend(self, a0: typing.Any, a1: typing.Iterable['QwtLegendData']) -> None: ...
    def checked(self, itemInfo: typing.Any, on: bool, index: int) -> None: ...
    def clicked(self, itemInfo: typing.Any, index: int) -> None: ...
    def scrollExtent(self, a0: QtCore.Qt.Orientation) -> int: ...
    def isEmpty(self) -> bool: ...
    def renderItem(self, a0: QtGui.QPainter, a1: QtWidgets.QWidget, a2: QtCore.QRectF, fillBackground: bool) -> None: ...
    def renderLegend(self, a0: QtGui.QPainter, a1: QtCore.QRectF, fillBackground: bool) -> None: ...
    def verticalScrollBar(self) -> QtWidgets.QScrollBar: ...
    def horizontalScrollBar(self) -> QtWidgets.QScrollBar: ...
    def heightForWidth(self, w: int) -> int: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def itemInfo(self, a0: QtWidgets.QWidget) -> typing.Any: ...
    def legendWidgets(self, a0: typing.Any) -> typing.List[QtWidgets.QWidget]: ...
    def legendWidget(self, a0: typing.Any) -> QtWidgets.QWidget: ...
    def contentsWidget(self) -> QtWidgets.QWidget: ...
    def defaultItemMode(self) -> 'QwtLegendData.Mode': ...
    def setDefaultItemMode(self, a0: 'QwtLegendData.Mode') -> None: ...
    def maxColumns(self) -> int: ...
    def setMaxColumns(self, numColums: int) -> None: ...


class QwtLegendData(sip.wrapper):

    class Role(int): ...
    ModeRole = ... # type: 'QwtLegendData.Role'
    TitleRole = ... # type: 'QwtLegendData.Role'
    IconRole = ... # type: 'QwtLegendData.Role'
    UserRole = ... # type: 'QwtLegendData.Role'

    class Mode(int): ...
    ReadOnly = ... # type: 'QwtLegendData.Mode'
    Clickable = ... # type: 'QwtLegendData.Mode'
    Checkable = ... # type: 'QwtLegendData.Mode'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtLegendData') -> None: ...

    def mode(self) -> 'QwtLegendData.Mode': ...
    def title(self) -> 'QwtText': ...
    def icon(self) -> 'QwtGraphic': ...
    def isValid(self) -> bool: ...
    def hasRole(self, role: int) -> bool: ...
    def value(self, role: int) -> typing.Any: ...
    def setValue(self, role: int, a1: typing.Any) -> None: ...
    def values(self) -> typing.Dict[int, typing.Any]: ...
    def setValues(self, a0: typing.Dict[int, typing.Any]) -> None: ...


class QwtPlotDict(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPlotDict') -> None: ...

    def removeItem(self, a0: 'QwtPlotItem') -> None: ...
    def insertItem(self, a0: 'QwtPlotItem') -> None: ...
    def detachItems(self, rtti: int = ..., autoDelete: bool = ...) -> None: ...
    @typing.overload
    def itemList(self) -> typing.List['QwtPlotItem']: ...
    @typing.overload
    def itemList(self, rtti: int) -> typing.List['QwtPlotItem']: ...
    def autoDelete(self) -> bool: ...
    def setAutoDelete(self, a0: bool) -> None: ...


class QwtPlot(QtWidgets.QFrame, QwtPlotDict):

    class LegendPosition(int): ...
    LeftLegend = ... # type: 'QwtPlot.LegendPosition'
    RightLegend = ... # type: 'QwtPlot.LegendPosition'
    BottomLegend = ... # type: 'QwtPlot.LegendPosition'
    TopLegend = ... # type: 'QwtPlot.LegendPosition'

    class Axis(int): ...
    yLeft = ... # type: 'QwtPlot.Axis'
    yRight = ... # type: 'QwtPlot.Axis'
    xBottom = ... # type: 'QwtPlot.Axis'
    xTop = ... # type: 'QwtPlot.Axis'
    axisCnt = ... # type: 'QwtPlot.Axis'

    @typing.overload
    def __init__(self, a0: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: 'QwtText', a1: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    @staticmethod
    def axisValid(axisId: int) -> bool: ...
    def autoRefresh(self) -> None: ...
    def replot(self) -> None: ...
    def legendDataChanged(self, itemInfo: typing.Any, data: typing.Iterable[QwtLegendData]) -> None: ...
    def itemAttached(self, plotItem: 'QwtPlotItem', on: bool) -> None: ...
    def infoToItem(self, a0: typing.Any) -> 'QwtPlotItem': ...
    def itemToInfo(self, a0: 'QwtPlotItem') -> typing.Any: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def updateCanvasMargins(self) -> None: ...
    def updateAxes(self) -> None: ...
    def drawCanvas(self, a0: QtGui.QPainter) -> None: ...
    def updateLayout(self) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    @typing.overload
    def updateLegend(self) -> None: ...
    @typing.overload
    def updateLegend(self, a0: 'QwtPlotItem') -> None: ...
    def legend(self) -> QwtAbstractLegend: ...
    def insertLegend(self, a0: QwtAbstractLegend, a1: 'QwtPlot.LegendPosition' = ..., ratio: float = ...) -> None: ...
    def axisMaxMajor(self, axisId: int) -> int: ...
    def setAxisMaxMajor(self, axisId: int, maxMajor: int) -> None: ...
    def axisMaxMinor(self, axisId: int) -> int: ...
    def setAxisMaxMinor(self, axisId: int, maxMinor: int) -> None: ...
    def axisTitle(self, axisId: int) -> 'QwtText': ...
    @typing.overload
    def setAxisTitle(self, axisId: int, a1: str) -> None: ...
    @typing.overload
    def setAxisTitle(self, axisId: int, a1: 'QwtText') -> None: ...
    def setAxisLabelRotation(self, axisId: int, rotation: float) -> None: ...
    def setAxisLabelAlignment(self, axisId: int, a1: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def axisWidget(self, axisId: int) -> 'QwtScaleWidget': ...
    def axisScaleDraw(self, axisId: int) -> 'QwtScaleDraw': ...
    def axisScaleDiv(self, axisId: int) -> 'QwtScaleDiv': ...
    def axisInterval(self, axisId: int) -> 'QwtInterval': ...
    def axisStepSize(self, axisId: int) -> float: ...
    def setAxisScaleDraw(self, axisId: int, a1: 'QwtScaleDraw') -> None: ...
    def setAxisScaleDiv(self, axisId: int, a1: 'QwtScaleDiv') -> None: ...
    def setAxisScale(self, axisId: int, min: float, max: float, step: float = ...) -> None: ...
    def axisFont(self, axisId: int) -> QtGui.QFont: ...
    def setAxisFont(self, axisId: int, f: QtGui.QFont) -> None: ...
    def axisEnabled(self, axisId: int) -> bool: ...
    def enableAxis(self, axisId: int, tf: bool = ...) -> None: ...
    def axisAutoScale(self, axisId: int) -> bool: ...
    def setAxisAutoScale(self, axisId: int, on: bool = ...) -> None: ...
    def setAxisScaleEngine(self, axisId: int, a1: 'QwtScaleEngine') -> None: ...
    def axisScaleEngine(self, axisId: int) -> 'QwtScaleEngine': ...
    def transform(self, axisId: int, value: float) -> float: ...
    def invTransform(self, axisId: int, pos: int) -> float: ...
    def canvasMap(self, axisId: int) -> 'QwtScaleMap': ...
    def canvasBackground(self) -> QtGui.QBrush: ...
    def setCanvasBackground(self, a0: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def canvas(self) -> QtWidgets.QWidget: ...
    def setCanvas(self, a0: QtWidgets.QWidget) -> None: ...
    def footerLabel(self) -> 'QwtTextLabel': ...
    def footer(self) -> 'QwtText': ...
    @typing.overload
    def setFooter(self, a0: str) -> None: ...
    @typing.overload
    def setFooter(self, t: 'QwtText') -> None: ...
    def titleLabel(self) -> 'QwtTextLabel': ...
    def title(self) -> 'QwtText': ...
    @typing.overload
    def setTitle(self, a0: str) -> None: ...
    @typing.overload
    def setTitle(self, t: 'QwtText') -> None: ...
    def plotLayout(self) -> 'QwtPlotLayout': ...
    def setPlotLayout(self, a0: 'QwtPlotLayout') -> None: ...
    def autoReplot(self) -> bool: ...
    def setAutoReplot(self, a0: bool = ...) -> None: ...
    def grabProperties(self) -> str: ...
    def applyProperties(self, a0: str) -> None: ...


class QwtPlotItem(sip.wrapper):

    class RenderHint(int): ...
    RenderAntialiased = ... # type: 'QwtPlotItem.RenderHint'

    class ItemInterest(int): ...
    ScaleInterest = ... # type: 'QwtPlotItem.ItemInterest'
    LegendInterest = ... # type: 'QwtPlotItem.ItemInterest'

    class ItemAttribute(int): ...
    Legend = ... # type: 'QwtPlotItem.ItemAttribute'
    AutoScale = ... # type: 'QwtPlotItem.ItemAttribute'
    Margins = ... # type: 'QwtPlotItem.ItemAttribute'

    class RttiValues(int): ...
    Rtti_PlotItem = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotGrid = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotScale = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotLegend = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotMarker = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotCurve = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotSpectroCurve = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotIntervalCurve = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotHistogram = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotSpectrogram = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotSVG = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotTradingCurve = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotBarChart = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotMultiBarChart = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotShape = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotTextLabel = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotZone = ... # type: 'QwtPlotItem.RttiValues'
    Rtti_PlotUserItem = ... # type: 'QwtPlotItem.RttiValues'

    class ItemAttributes(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtPlotItem.ItemAttributes', 'QwtPlotItem.ItemAttribute']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtPlotItem.ItemAttributes') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtPlotItem.ItemAttributes': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    class ItemInterests(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtPlotItem.ItemInterests', 'QwtPlotItem.ItemInterest']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtPlotItem.ItemInterests') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtPlotItem.ItemInterests': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    class RenderHints(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtPlotItem.RenderHints', 'QwtPlotItem.RenderHint']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtPlotItem.RenderHints') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtPlotItem.RenderHints': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    def __init__(self, title: 'QwtText' = ...) -> None: ...

    def legendData(self) -> typing.List[QwtLegendData]: ...
    def paintRect(self, a0: 'QwtScaleMap', a1: 'QwtScaleMap') -> QtCore.QRectF: ...
    def scaleRect(self, a0: 'QwtScaleMap', a1: 'QwtScaleMap') -> QtCore.QRectF: ...
    def updateLegend(self, a0: 'QwtPlotItem', a1: typing.Iterable[QwtLegendData]) -> None: ...
    def updateScaleDiv(self, a0: 'QwtScaleDiv', a1: 'QwtScaleDiv') -> None: ...
    def getCanvasMarginHint(self, xMap: 'QwtScaleMap', yMap: 'QwtScaleMap', canvasSize: QtCore.QRectF) -> typing.Tuple[float, float, float, float]: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def draw(self, painter: QtGui.QPainter, xMap: 'QwtScaleMap', yMap: 'QwtScaleMap', canvasRect: QtCore.QRectF) -> None: ...
    def legendChanged(self) -> None: ...
    def itemChanged(self) -> None: ...
    def yAxis(self) -> int: ...
    def setYAxis(self, axis: int) -> None: ...
    def xAxis(self) -> int: ...
    def setXAxis(self, axis: int) -> None: ...
    def setAxes(self, xAxis: int, yAxis: int) -> None: ...
    def isVisible(self) -> bool: ...
    def setVisible(self, a0: bool) -> None: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
    def setZ(self, z: float) -> None: ...
    def z(self) -> float: ...
    def legendIconSize(self) -> QtCore.QSize: ...
    def setLegendIconSize(self, a0: QtCore.QSize) -> None: ...
    def renderThreadCount(self) -> int: ...
    def setRenderThreadCount(self, numThreads: int) -> None: ...
    def testRenderHint(self, a0: 'QwtPlotItem.RenderHint') -> bool: ...
    def setRenderHint(self, a0: 'QwtPlotItem.RenderHint', on: bool = ...) -> None: ...
    def testItemInterest(self, a0: 'QwtPlotItem.ItemInterest') -> bool: ...
    def setItemInterest(self, a0: 'QwtPlotItem.ItemInterest', on: bool = ...) -> None: ...
    def testItemAttribute(self, a0: 'QwtPlotItem.ItemAttribute') -> bool: ...
    def setItemAttribute(self, a0: 'QwtPlotItem.ItemAttribute', on: bool = ...) -> None: ...
    def rtti(self) -> int: ...
    def title(self) -> 'QwtText': ...
    @typing.overload
    def setTitle(self, title: str) -> None: ...
    @typing.overload
    def setTitle(self, title: 'QwtText') -> None: ...
    def plot(self) -> QwtPlot: ...
    def detach(self) -> None: ...
    def attach(self, plot: QwtPlot) -> None: ...


class QwtPlotLayout(sip.wrapper):

    class Option(int): ...
    AlignScales = ... # type: 'QwtPlotLayout.Option'
    IgnoreScrollbars = ... # type: 'QwtPlotLayout.Option'
    IgnoreFrames = ... # type: 'QwtPlotLayout.Option'
    IgnoreLegend = ... # type: 'QwtPlotLayout.Option'
    IgnoreTitle = ... # type: 'QwtPlotLayout.Option'
    IgnoreFooter = ... # type: 'QwtPlotLayout.Option'

    class LayoutData(sip.wrapper): ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPlotLayout') -> None: ...

    def alignLegend(self, canvasRect: QtCore.QRectF, legendRect: QtCore.QRectF) -> QtCore.QRectF: ...
    def setCanvasRect(self, a0: QtCore.QRectF) -> None: ...
    def setScaleRect(self, axis: int, a1: QtCore.QRectF) -> None: ...
    def setLegendRect(self, a0: QtCore.QRectF) -> None: ...
    def setFooterRect(self, a0: QtCore.QRectF) -> None: ...
    def setTitleRect(self, a0: QtCore.QRectF) -> None: ...
    def canvasRect(self) -> QtCore.QRectF: ...
    def scaleRect(self, axis: int) -> QtCore.QRectF: ...
    def legendRect(self) -> QtCore.QRectF: ...
    def footerRect(self) -> QtCore.QRectF: ...
    def titleRect(self) -> QtCore.QRectF: ...
    def invalidate(self) -> None: ...
    def minimumSizeHint(self, a0: QwtPlot) -> QtCore.QSize: ...
    def legendRatio(self) -> float: ...
    def setLegendRatio(self, ratio: float) -> None: ...
    def legendPosition(self) -> QwtPlot.LegendPosition: ...
    @typing.overload
    def setLegendPosition(self, pos: QwtPlot.LegendPosition, ratio: float) -> None: ...
    @typing.overload
    def setLegendPosition(self, pos: QwtPlot.LegendPosition) -> None: ...
    def spacing(self) -> int: ...
    def setSpacing(self, a0: int) -> None: ...
    def alignCanvasToScale(self, axisId: int) -> bool: ...
    def setAlignCanvasToScale(self, axisId: int, a1: bool) -> None: ...
    def setAlignCanvasToScales(self, a0: bool) -> None: ...
    def canvasMargin(self, axis: int) -> int: ...
    def setCanvasMargin(self, margin: int, axis: int = ...) -> None: ...


class QwtScaleMap(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtScaleMap') -> None: ...

    def isInverting(self) -> bool: ...
    def sDist(self) -> float: ...
    def pDist(self) -> float: ...
    def s2(self) -> float: ...
    def s1(self) -> float: ...
    def p2(self) -> float: ...
    def p1(self) -> float: ...
    @typing.overload
    def invTransform(self, p: float) -> float: ...
    @typing.overload
    @staticmethod
    def invTransform(a0: 'QwtScaleMap', a1: 'QwtScaleMap', a2: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    @staticmethod
    def invTransform(a0: 'QwtScaleMap', a1: 'QwtScaleMap', a2: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def transform(self, s: float) -> float: ...
    @typing.overload
    @staticmethod
    def transform(a0: 'QwtScaleMap', a1: 'QwtScaleMap', a2: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    @staticmethod
    def transform(a0: 'QwtScaleMap', a1: 'QwtScaleMap', a2: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def setScaleInterval(self, s1: float, s2: float) -> None: ...
    def setPaintInterval(self, p1: float, p2: float) -> None: ...


class QwtScaleEngine(sip.wrapper):

    class Attribute(int): ...
    NoAttribute = ... # type: 'QwtScaleEngine.Attribute'
    IncludeReference = ... # type: 'QwtScaleEngine.Attribute'
    Symmetric = ... # type: 'QwtScaleEngine.Attribute'
    Floating = ... # type: 'QwtScaleEngine.Attribute'
    Inverted = ... # type: 'QwtScaleEngine.Attribute'

    @typing.overload
    def __init__(self, base: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtScaleEngine') -> None: ...

    def buildInterval(self, v: float) -> 'QwtInterval': ...
    def divideInterval(self, interval: float, numSteps: int) -> float: ...
    def strip(self, a0: typing.Iterable[float], a1: 'QwtInterval') -> typing.List[float]: ...
    def contains(self, a0: 'QwtInterval', val: float) -> bool: ...
    def transformation(self) -> 'QwtTransform': ...
    def setTransformation(self, a0: 'QwtTransform') -> None: ...
    def divideScale(self, x1: float, x2: float, maxMajorSteps: int, maxMinorSteps: int, stepSize: float = ...) -> 'QwtScaleDiv': ...
    def autoScale(self, maxNumSteps: int) -> typing.Tuple[float, float, float]: ...
    def upperMargin(self) -> float: ...
    def lowerMargin(self) -> float: ...
    def setMargins(self, lower: float, upper: float) -> None: ...
    def reference(self) -> float: ...
    def setReference(self, reference: float) -> None: ...
    def testAttribute(self, a0: 'QwtScaleEngine.Attribute') -> bool: ...
    def setAttribute(self, a0: 'QwtScaleEngine.Attribute', on: bool = ...) -> None: ...
    def base(self) -> int: ...
    def setBase(self, base: int) -> None: ...


class QwtLinearScaleEngine(QwtScaleEngine):

    @typing.overload
    def __init__(self, base: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtLinearScaleEngine') -> None: ...

    def buildMinorTicks(self, majorTicks: typing.Iterable[float], maxMinorSteps: int, stepSize: float, minorTicks: typing.Iterable[float], mediumTicks: typing.Iterable[float]) -> None: ...
    def buildMajorTicks(self, interval: 'QwtInterval', stepSize: float) -> typing.List[float]: ...
    def align(self, a0: 'QwtInterval', stepSize: float) -> 'QwtInterval': ...
    def divideScale(self, x1: float, x2: float, numMajorSteps: int, numMinorSteps: int, stepSize: float = ...) -> 'QwtScaleDiv': ...
    def autoScale(self, maxSteps: int) -> typing.Tuple[float, float, float]: ...


class QwtLogScaleEngine(QwtScaleEngine):

    @typing.overload
    def __init__(self, base: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtLogScaleEngine') -> None: ...

    def buildMinorTicks(self, majorTicks: typing.Iterable[float], maxMinorSteps: int, stepSize: float, minorTicks: typing.Iterable[float], mediumTicks: typing.Iterable[float]) -> None: ...
    def buildMajorTicks(self, interval: 'QwtInterval', stepSize: float) -> typing.List[float]: ...
    def align(self, a0: 'QwtInterval', stepSize: float) -> 'QwtInterval': ...
    def divideScale(self, x1: float, x2: float, numMajorSteps: int, numMinorSteps: int, stepSize: float = ...) -> 'QwtScaleDiv': ...
    def autoScale(self, maxSteps: int) -> typing.Tuple[float, float, float]: ...


class QwtScaleDiv(sip.wrapper):

    class TickType(int): ...
    NoTick = ... # type: 'QwtScaleDiv.TickType'
    MinorTick = ... # type: 'QwtScaleDiv.TickType'
    MediumTick = ... # type: 'QwtScaleDiv.TickType'
    MajorTick = ... # type: 'QwtScaleDiv.TickType'
    NTickTypes = ... # type: 'QwtScaleDiv.TickType'

    @typing.overload
    def __init__(self, lowerBound: float = ..., upperBound: float = ...) -> None: ...
    @typing.overload
    def __init__(self, lowerBound: float, upperBound: float, minorTicks: typing.Iterable[float], mediumTicks: typing.Iterable[float], majorTicks: typing.Iterable[float]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtScaleDiv') -> None: ...

    def bounded(self, lowerBound: float, upperBound: float) -> 'QwtScaleDiv': ...
    def inverted(self) -> 'QwtScaleDiv': ...
    def invert(self) -> None: ...
    def isIncreasing(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def ticks(self, tickType: int) -> typing.List[float]: ...
    def setTicks(self, tickType: int, a1: typing.Iterable[float]) -> None: ...
    def contains(self, value: float) -> bool: ...
    def range(self) -> float: ...
    def upperBound(self) -> float: ...
    def setUpperBound(self, a0: float) -> None: ...
    def lowerBound(self) -> float: ...
    def setLowerBound(self, a0: float) -> None: ...
    def interval(self) -> 'QwtInterval': ...
    @typing.overload
    def setInterval(self, lowerBound: float, upperBound: float) -> None: ...
    @typing.overload
    def setInterval(self, a0: 'QwtInterval') -> None: ...


class QwtAbstractScaleDraw(sip.wrapper):

    class ScaleComponent(int): ...
    Backbone = ... # type: 'QwtAbstractScaleDraw.ScaleComponent'
    Ticks = ... # type: 'QwtAbstractScaleDraw.ScaleComponent'
    Labels = ... # type: 'QwtAbstractScaleDraw.ScaleComponent'

    def __init__(self) -> None: ...

    def invalidateCache(self) -> None: ...
    def drawLabel(self, painter: QtGui.QPainter, value: float) -> None: ...
    def drawBackbone(self, painter: QtGui.QPainter) -> None: ...
    def drawTick(self, painter: QtGui.QPainter, value: float, len: float) -> None: ...
    def minimumExtent(self) -> float: ...
    def setMinimumExtent(self, a0: float) -> None: ...
    def extent(self, font: QtGui.QFont) -> float: ...
    def draw(self, a0: QtGui.QPainter, a1: QtGui.QPalette) -> None: ...
    def penWidth(self) -> int: ...
    def setPenWidth(self, width: int) -> None: ...
    def spacing(self) -> float: ...
    def setSpacing(self, margin: float) -> None: ...
    def maxTickLength(self) -> float: ...
    def tickLength(self, a0: QwtScaleDiv.TickType) -> float: ...
    def setTickLength(self, a0: QwtScaleDiv.TickType, length: float) -> None: ...
    def hasComponent(self, a0: 'QwtAbstractScaleDraw.ScaleComponent') -> bool: ...
    def enableComponent(self, a0: 'QwtAbstractScaleDraw.ScaleComponent', enable: bool = ...) -> None: ...
    def scaleMap(self) -> QwtScaleMap: ...
    def scaleDiv(self) -> QwtScaleDiv: ...
    def setScaleDiv(self, s: QwtScaleDiv) -> None: ...


class QwtScaleDraw(QwtAbstractScaleDraw):

    class Alignment(int): ...
    BottomScale = ... # type: 'QwtScaleDraw.Alignment'
    TopScale = ... # type: 'QwtScaleDraw.Alignment'
    LeftScale = ... # type: 'QwtScaleDraw.Alignment'
    RightScale = ... # type: 'QwtScaleDraw.Alignment'

    def __init__(self) -> None: ...

    def drawLabel(self, a0: QtGui.QPainter, val: float) -> None: ...
    def drawBackbone(self, a0: QtGui.QPainter) -> None: ...
    def drawTick(self, a0: QtGui.QPainter, val: float, len: float) -> None: ...
    def labelTransformation(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint], a1: QtCore.QSizeF) -> QtGui.QTransform: ...
    def boundingLabelRect(self, a0: QtGui.QFont, val: float) -> QtCore.QRect: ...
    def labelSize(self, a0: QtGui.QFont, val: float) -> QtCore.QSizeF: ...
    def labelRect(self, a0: QtGui.QFont, val: float) -> QtCore.QRectF: ...
    def labelPosition(self, val: float) -> QtCore.QPointF: ...
    def maxLabelWidth(self, a0: QtGui.QFont) -> int: ...
    def maxLabelHeight(self, a0: QtGui.QFont) -> int: ...
    def labelRotation(self) -> float: ...
    def setLabelRotation(self, rotation: float) -> None: ...
    def labelAlignment(self) -> QtCore.Qt.Alignment: ...
    def setLabelAlignment(self, a0: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def length(self) -> float: ...
    def pos(self) -> QtCore.QPointF: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setAlignment(self, a0: 'QwtScaleDraw.Alignment') -> None: ...
    def alignment(self) -> 'QwtScaleDraw.Alignment': ...
    def setLength(self, length: float) -> None: ...
    def move(self, x: float, y: float) -> None: ...
    def extent(self, a0: QtGui.QFont) -> float: ...
    def minLength(self, a0: QtGui.QFont) -> int: ...
    def minLabelDist(self, a0: QtGui.QFont) -> int: ...
    def getBorderDistHint(self, a0: QtGui.QFont) -> typing.Tuple[int, int]: ...


class QwtInterval(sip.wrapper):

    class BorderFlag(int): ...
    IncludeBorders = ... # type: 'QwtInterval.BorderFlag'
    ExcludeMinimum = ... # type: 'QwtInterval.BorderFlag'
    ExcludeMaximum = ... # type: 'QwtInterval.BorderFlag'
    ExcludeBorders = ... # type: 'QwtInterval.BorderFlag'

    class BorderFlags(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtInterval.BorderFlags', 'QwtInterval.BorderFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtInterval.BorderFlags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtInterval.BorderFlags': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, minValue: float, maxValue: float, a2: typing.Union['QwtInterval.BorderFlags', 'QwtInterval.BorderFlag'] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtInterval') -> None: ...

    def symmetrize(self, value: float) -> 'QwtInterval': ...
    def invalidate(self) -> None: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def extend(self, value: float) -> 'QwtInterval': ...
    def unite(self, a0: 'QwtInterval') -> 'QwtInterval': ...
    def intersect(self, a0: 'QwtInterval') -> 'QwtInterval': ...
    def intersects(self, a0: 'QwtInterval') -> bool: ...
    def contains(self, value: float) -> bool: ...
    def setMaxValue(self, a0: float) -> None: ...
    def setMinValue(self, a0: float) -> None: ...
    def width(self) -> float: ...
    def maxValue(self) -> float: ...
    def minValue(self) -> float: ...
    def borderFlags(self) -> 'QwtInterval.BorderFlags': ...
    def setBorderFlags(self, a0: typing.Union['QwtInterval.BorderFlags', 'QwtInterval.BorderFlag']) -> None: ...
    def limited(self, minValue: float, maxValue: float) -> 'QwtInterval': ...
    def inverted(self) -> 'QwtInterval': ...
    def normalized(self) -> 'QwtInterval': ...
    def setInterval(self, minValue: float, maxValue: float, a2: typing.Union['QwtInterval.BorderFlags', 'QwtInterval.BorderFlag'] = ...) -> None: ...


class QwtScaleWidget(QtWidgets.QWidget):

    class LayoutFlag(int): ...
    TitleInverted = ... # type: 'QwtScaleWidget.LayoutFlag'

    @typing.overload
    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: QwtScaleDraw.Alignment, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def layoutScale(self, update: bool = ...) -> None: ...
    def scaleChange(self) -> None: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def colorBarRect(self, a0: QtCore.QRectF) -> QtCore.QRectF: ...
    def alignment(self) -> QwtScaleDraw.Alignment: ...
    def setAlignment(self, a0: QwtScaleDraw.Alignment) -> None: ...
    def drawTitle(self, painter: QtGui.QPainter, a1: QwtScaleDraw.Alignment, rect: QtCore.QRectF) -> None: ...
    def drawColorBar(self, painter: QtGui.QPainter, a1: QtCore.QRectF) -> None: ...
    def dimForLength(self, length: int, scaleFont: QtGui.QFont) -> int: ...
    def titleHeightForWidth(self, width: int) -> int: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def colorBarInterval(self) -> QwtInterval: ...
    def setColorMap(self, a0: QwtInterval, a1: 'QwtColorMap') -> None: ...
    def colorBarWidth(self) -> int: ...
    def setColorBarWidth(self, a0: int) -> None: ...
    def isColorBarEnabled(self) -> bool: ...
    def setColorBarEnabled(self, a0: bool) -> None: ...
    def setLabelRotation(self, rotation: float) -> None: ...
    def setLabelAlignment(self, a0: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def scaleDraw(self) -> QwtScaleDraw: ...
    def setScaleDraw(self, a0: QwtScaleDraw) -> None: ...
    def setScaleDiv(self, sd: QwtScaleDiv) -> None: ...
    def spacing(self) -> int: ...
    def setSpacing(self, td: int) -> None: ...
    def margin(self) -> int: ...
    def setMargin(self, a0: int) -> None: ...
    def setMinBorderDist(self, start: int, end: int) -> None: ...
    def getMinBorderDist(self) -> typing.Tuple[int, int]: ...
    def getBorderDistHint(self) -> typing.Tuple[int, int]: ...
    def endBorderDist(self) -> int: ...
    def startBorderDist(self) -> int: ...
    def setBorderDist(self, start: int, end: int) -> None: ...
    def testLayoutFlag(self, a0: 'QwtScaleWidget.LayoutFlag') -> bool: ...
    def setLayoutFlag(self, a0: 'QwtScaleWidget.LayoutFlag', on: bool) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def scaleDivChanged(self) -> None: ...


class QwtText(sip.wrapper):

    class LayoutAttribute(int): ...
    MinimumLayout = ... # type: 'QwtText.LayoutAttribute'

    class PaintAttribute(int): ...
    PaintUsingTextFont = ... # type: 'QwtText.PaintAttribute'
    PaintUsingTextColor = ... # type: 'QwtText.PaintAttribute'
    PaintBackground = ... # type: 'QwtText.PaintAttribute'

    class TextFormat(int): ...
    AutoText = ... # type: 'QwtText.TextFormat'
    PlainText = ... # type: 'QwtText.TextFormat'
    RichText = ... # type: 'QwtText.TextFormat'
    MathMLText = ... # type: 'QwtText.TextFormat'
    TeXText = ... # type: 'QwtText.TextFormat'
    OtherFormat = ... # type: 'QwtText.TextFormat'

    class PaintAttributes(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtText.PaintAttributes', 'QwtText.PaintAttribute']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtText.PaintAttributes') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtText.PaintAttributes': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    class LayoutAttributes(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtText.LayoutAttributes', 'QwtText.LayoutAttribute']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtText.LayoutAttributes') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtText.LayoutAttributes': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, a0: 'QwtText') -> None: ...
    @typing.overload
    def __init__(self, a0: str = ..., textFormat: 'QwtText.TextFormat' = ...) -> None: ...

    @staticmethod
    def setTextEngine(a0: 'QwtText.TextFormat', a1: 'QwtTextEngine') -> None: ...
    @typing.overload
    @staticmethod
    def textEngine(text: str, a1: 'QwtText.TextFormat' = ...) -> 'QwtTextEngine': ...
    @typing.overload
    @staticmethod
    def textEngine(a0: 'QwtText.TextFormat') -> 'QwtTextEngine': ...
    def draw(self, painter: QtGui.QPainter, rect: QtCore.QRectF) -> None: ...
    def textSize(self, a0: QtGui.QFont = ...) -> QtCore.QSizeF: ...
    def heightForWidth(self, width: float, a1: QtGui.QFont = ...) -> float: ...
    def testLayoutAttribute(self, a0: 'QwtText.LayoutAttribute') -> bool: ...
    def setLayoutAttribute(self, a0: 'QwtText.LayoutAttribute', on: bool = ...) -> None: ...
    def testPaintAttribute(self, a0: 'QwtText.PaintAttribute') -> bool: ...
    def setPaintAttribute(self, a0: 'QwtText.PaintAttribute', on: bool = ...) -> None: ...
    def backgroundBrush(self) -> QtGui.QBrush: ...
    def setBackgroundBrush(self, a0: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def borderPen(self) -> QtGui.QPen: ...
    def setBorderPen(self, a0: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def borderRadius(self) -> float: ...
    def setBorderRadius(self, a0: float) -> None: ...
    def usedColor(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> QtGui.QColor: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def renderFlags(self) -> int: ...
    def setRenderFlags(self, flags: int) -> None: ...
    def usedFont(self, a0: QtGui.QFont) -> QtGui.QFont: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, a0: QtGui.QFont) -> None: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def text(self) -> str: ...
    def setText(self, a0: str, textFormat: 'QwtText.TextFormat' = ...) -> None: ...


class QwtTextLabel(QtWidgets.QFrame):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: QwtText, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def drawContents(self, a0: QtGui.QPainter) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def drawText(self, a0: QtGui.QPainter, a1: QtCore.QRectF) -> None: ...
    def textRect(self) -> QtCore.QRect: ...
    def heightForWidth(self, a0: int) -> int: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setMargin(self, a0: int) -> None: ...
    def margin(self) -> int: ...
    def setIndent(self, a0: int) -> None: ...
    def indent(self) -> int: ...
    def text(self) -> QwtText: ...
    def clear(self) -> None: ...
    @typing.overload
    def setText(self, a0: str, textFormat: QwtText.TextFormat = ...) -> None: ...
    @typing.overload
    def setText(self, a0: QwtText) -> None: ...
    def plainText(self) -> str: ...
    def setPlainText(self, a0: str) -> None: ...


class QwtColorMap(sip.wrapper):

    class Format(int): ...
    RGB = ... # type: 'QwtColorMap.Format'
    Indexed = ... # type: 'QwtColorMap.Format'

    @typing.overload
    def __init__(self, a0: 'QwtColorMap.Format' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtColorMap') -> None: ...

    def colorTable(self, a0: QwtInterval) -> typing.List[int]: ...
    def color(self, a0: QwtInterval, value: float) -> QtGui.QColor: ...
    def colorIndex(self, interval: QwtInterval, value: float) -> bytes: ...
    def rgb(self, interval: QwtInterval, value: float) -> int: ...
    def format(self) -> 'QwtColorMap.Format': ...


class QwtLinearColorMap(QwtColorMap):

    class Mode(int): ...
    FixedColors = ... # type: 'QwtLinearColorMap.Mode'
    ScaledColors = ... # type: 'QwtLinearColorMap.Mode'

    class ColorStops(sip.wrapper): ...

    @typing.overload
    def __init__(self, a0: QwtColorMap.Format = ...) -> None: ...
    @typing.overload
    def __init__(self, from_: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], to: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], a2: QwtColorMap.Format = ...) -> None: ...

    def colorIndex(self, a0: QwtInterval, value: float) -> bytes: ...
    def rgb(self, a0: QwtInterval, value: float) -> int: ...
    def color2(self) -> QtGui.QColor: ...
    def color1(self) -> QtGui.QColor: ...
    def colorStops(self) -> typing.List[float]: ...
    def addColorStop(self, value: float, a1: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColorInterval(self, color1: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], color2: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def mode(self) -> 'QwtLinearColorMap.Mode': ...
    def setMode(self, a0: 'QwtLinearColorMap.Mode') -> None: ...


class QwtAlphaColorMap(QwtColorMap):

    def __init__(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...

    def rgb(self, a0: QwtInterval, value: float) -> int: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...


class QwtTextEngine(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtTextEngine') -> None: ...

    def draw(self, painter: QtGui.QPainter, rect: QtCore.QRectF, flags: int, text: str) -> None: ...
    def textMargins(self, font: QtGui.QFont, text: str) -> typing.Tuple[float, float, float, float]: ...
    def mightRender(self, text: str) -> bool: ...
    def textSize(self, font: QtGui.QFont, flags: int, text: str) -> QtCore.QSizeF: ...
    def heightForWidth(self, font: QtGui.QFont, flags: int, text: str, width: float) -> float: ...


class QwtPlainTextEngine(QwtTextEngine):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPlainTextEngine') -> None: ...

    def textMargins(self, a0: QtGui.QFont, a1: str) -> typing.Tuple[float, float, float, float]: ...
    def mightRender(self, a0: str) -> bool: ...
    def draw(self, painter: QtGui.QPainter, rect: QtCore.QRectF, flags: int, text: str) -> None: ...
    def textSize(self, font: QtGui.QFont, flags: int, text: str) -> QtCore.QSizeF: ...
    def heightForWidth(self, font: QtGui.QFont, flags: int, text: str, width: float) -> float: ...


class QwtEventPattern(sip.wrapper):

    class KeyPatternCode(int): ...
    KeySelect1 = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeySelect2 = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeyAbort = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeyLeft = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeyRight = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeyUp = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeyDown = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeyRedo = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeyUndo = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeyHome = ... # type: 'QwtEventPattern.KeyPatternCode'
    KeyPatternCount = ... # type: 'QwtEventPattern.KeyPatternCode'

    class MousePatternCode(int): ...
    MouseSelect1 = ... # type: 'QwtEventPattern.MousePatternCode'
    MouseSelect2 = ... # type: 'QwtEventPattern.MousePatternCode'
    MouseSelect3 = ... # type: 'QwtEventPattern.MousePatternCode'
    MouseSelect4 = ... # type: 'QwtEventPattern.MousePatternCode'
    MouseSelect5 = ... # type: 'QwtEventPattern.MousePatternCode'
    MouseSelect6 = ... # type: 'QwtEventPattern.MousePatternCode'
    MousePatternCount = ... # type: 'QwtEventPattern.MousePatternCode'

    class MousePattern(sip.wrapper):

        button = ... # type: QtCore.Qt.MouseButton
        modifiers = ... # type: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]

        @typing.overload
        def __init__(self, btn: QtCore.Qt.MouseButton = ..., modifierCodes: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtEventPattern.MousePattern') -> None: ...

    class KeyPattern(sip.wrapper):

        key = ... # type: int
        modifiers = ... # type: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]

        @typing.overload
        def __init__(self, keyCode: int = ..., modifierCodes: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtEventPattern.KeyPattern') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtEventPattern') -> None: ...

    @typing.overload
    def keyMatch(self, a0: 'QwtEventPattern.KeyPatternCode', a1: QtGui.QKeyEvent) -> bool: ...
    @typing.overload
    def keyMatch(self, a0: 'QwtEventPattern.KeyPattern', a1: QtGui.QKeyEvent) -> bool: ...
    @typing.overload
    def mouseMatch(self, a0: 'QwtEventPattern.MousePatternCode', a1: QtGui.QMouseEvent) -> bool: ...
    @typing.overload
    def mouseMatch(self, a0: 'QwtEventPattern.MousePattern', a1: QtGui.QMouseEvent) -> bool: ...
    def keyPattern(self) -> typing.List['QwtEventPattern.KeyPattern']: ...
    def mousePattern(self) -> typing.List['QwtEventPattern.MousePattern']: ...
    @typing.overload
    def setKeyPattern(self, a0: 'QwtEventPattern.KeyPatternCode', keyCode: int, modifierCodes: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> None: ...
    @typing.overload
    def setKeyPattern(self, a0: typing.Iterable['QwtEventPattern.KeyPattern']) -> None: ...
    @typing.overload
    def setMousePattern(self, a0: 'QwtEventPattern.MousePatternCode', button: QtCore.Qt.MouseButton, a2: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> None: ...
    @typing.overload
    def setMousePattern(self, a0: typing.Iterable['QwtEventPattern.MousePattern']) -> None: ...
    def initKeyPattern(self) -> None: ...
    def initMousePattern(self, numButtons: int) -> None: ...


class QwtPicker(QtCore.QObject, QwtEventPattern):

    class ResizeMode(int): ...
    Stretch = ... # type: 'QwtPicker.ResizeMode'
    KeepSize = ... # type: 'QwtPicker.ResizeMode'

    class DisplayMode(int): ...
    AlwaysOff = ... # type: 'QwtPicker.DisplayMode'
    AlwaysOn = ... # type: 'QwtPicker.DisplayMode'
    ActiveOnly = ... # type: 'QwtPicker.DisplayMode'

    class RubberBand(int): ...
    NoRubberBand = ... # type: 'QwtPicker.RubberBand'
    HLineRubberBand = ... # type: 'QwtPicker.RubberBand'
    VLineRubberBand = ... # type: 'QwtPicker.RubberBand'
    CrossRubberBand = ... # type: 'QwtPicker.RubberBand'
    RectRubberBand = ... # type: 'QwtPicker.RubberBand'
    EllipseRubberBand = ... # type: 'QwtPicker.RubberBand'
    PolygonRubberBand = ... # type: 'QwtPicker.RubberBand'
    UserRubberBand = ... # type: 'QwtPicker.RubberBand'

    @typing.overload
    def __init__(self, parent: QtWidgets.QWidget) -> None: ...
    @typing.overload
    def __init__(self, rubberBand: 'QwtPicker.RubberBand', trackerMode: 'QwtPicker.DisplayMode', a2: QtWidgets.QWidget) -> None: ...

    def pickedPoints(self) -> QtGui.QPolygon: ...
    def updateDisplay(self) -> None: ...
    def stretchSelection(self, oldSize: QtCore.QSize, newSize: QtCore.QSize) -> None: ...
    def widgetLeaveEvent(self, a0: QtCore.QEvent) -> None: ...
    def widgetEnterEvent(self, a0: QtCore.QEvent) -> None: ...
    def widgetKeyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def widgetKeyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def widgetWheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def widgetMouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def widgetMouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def widgetMouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def widgetMousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def reset(self) -> None: ...
    def accept(self, a0: QtGui.QPolygon) -> bool: ...
    def end(self, ok: bool = ...) -> bool: ...
    def remove(self) -> None: ...
    def move(self, a0: QtCore.QPoint) -> None: ...
    def append(self, a0: QtCore.QPoint) -> None: ...
    def begin(self) -> None: ...
    def transition(self, a0: QtCore.QEvent) -> None: ...
    def adjustedPoints(self, a0: QtGui.QPolygon) -> QtGui.QPolygon: ...
    def changed(self, selection: QtGui.QPolygon) -> None: ...
    def removed(self, pos: QtCore.QPoint) -> None: ...
    def moved(self, pos: QtCore.QPoint) -> None: ...
    def appended(self, pos: QtCore.QPoint) -> None: ...
    def selected(self, polygon: QtGui.QPolygon) -> None: ...
    def activated(self, on: bool) -> None: ...
    def setEnabled(self, a0: bool) -> None: ...
    def selection(self) -> QtGui.QPolygon: ...
    def trackerRect(self, a0: QtGui.QFont) -> QtCore.QRect: ...
    def trackerPosition(self) -> QtCore.QPoint: ...
    def rubberBandMask(self) -> QtGui.QRegion: ...
    def drawTracker(self, a0: QtGui.QPainter) -> None: ...
    def drawRubberBand(self, a0: QtGui.QPainter) -> None: ...
    def pickArea(self) -> QtGui.QPainterPath: ...
    def parentWidget(self) -> QtWidgets.QWidget: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def isActive(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def trackerFont(self) -> QtGui.QFont: ...
    def setTrackerFont(self, a0: QtGui.QFont) -> None: ...
    def trackerPen(self) -> QtGui.QPen: ...
    def setTrackerPen(self, a0: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def rubberBandPen(self) -> QtGui.QPen: ...
    def setRubberBandPen(self, a0: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def resizeMode(self) -> 'QwtPicker.ResizeMode': ...
    def setResizeMode(self, a0: 'QwtPicker.ResizeMode') -> None: ...
    def trackerMode(self) -> 'QwtPicker.DisplayMode': ...
    def setTrackerMode(self, a0: 'QwtPicker.DisplayMode') -> None: ...
    def rubberBand(self) -> 'QwtPicker.RubberBand': ...
    def setRubberBand(self, a0: 'QwtPicker.RubberBand') -> None: ...
    def stateMachine(self) -> 'QwtPickerMachine': ...
    def setStateMachine(self, a0: 'QwtPickerMachine') -> None: ...


class QwtPlotPicker(QwtPicker):

    @typing.overload
    def __init__(self, canvas: QtWidgets.QWidget) -> None: ...
    @typing.overload
    def __init__(self, xAxis: int, yAxis: int, a2: QtWidgets.QWidget) -> None: ...
    @typing.overload
    def __init__(self, xAxis: int, yAxis: int, rubberBand: QwtPicker.RubberBand, trackerMode: QwtPicker.DisplayMode, a4: QtWidgets.QWidget) -> None: ...

    def end(self, ok: bool = ...) -> bool: ...
    def append(self, a0: QtCore.QPoint) -> None: ...
    def move(self, a0: QtCore.QPoint) -> None: ...
    @typing.overload
    def transform(self, a0: QtCore.QRectF) -> QtCore.QRect: ...
    @typing.overload
    def transform(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPoint: ...
    @typing.overload
    def invTransform(self, a0: QtCore.QRect) -> QtCore.QRectF: ...
    @typing.overload
    def invTransform(self, a0: QtCore.QPoint) -> QtCore.QPointF: ...
    def moved(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def appended(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def selected(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def selected(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def selected(self, pa: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    def canvas(self) -> QtWidgets.QWidget: ...
    def plot(self) -> QwtPlot: ...
    def yAxis(self) -> int: ...
    def xAxis(self) -> int: ...
    def setAxis(self, xAxis: int, yAxis: int) -> None: ...


class QwtPlotZoomer(QwtPlotPicker):

    @typing.overload
    def __init__(self, a0: QtWidgets.QWidget, doReplot: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, xAxis: int, yAxis: int, a2: QtWidgets.QWidget, doReplot: bool = ...) -> None: ...

    def accept(self, a0: QtGui.QPolygon) -> bool: ...
    def end(self, ok: bool = ...) -> bool: ...
    def begin(self) -> None: ...
    def widgetKeyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def widgetMouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def minZoomSize(self) -> QtCore.QSizeF: ...
    def rescale(self) -> None: ...
    def zoomed(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def zoom(self, a0: QtCore.QRectF) -> None: ...
    @typing.overload
    def zoom(self, up: int) -> None: ...
    def moveTo(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def moveBy(self, x: float, y: float) -> None: ...
    def zoomRectIndex(self) -> int: ...
    def maxStackDepth(self) -> int: ...
    def setMaxStackDepth(self, a0: int) -> None: ...
    def setAxis(self, xAxis: int, yAxis: int) -> None: ...
    def zoomRect(self) -> QtCore.QRectF: ...
    def zoomBase(self) -> QtCore.QRectF: ...
    @typing.overload
    def setZoomBase(self, doReplot: bool = ...) -> None: ...
    @typing.overload
    def setZoomBase(self, a0: QtCore.QRectF) -> None: ...


class QwtPickerMachine(sip.wrapper):

    class Command(int): ...
    Begin = ... # type: 'QwtPickerMachine.Command'
    Append = ... # type: 'QwtPickerMachine.Command'
    Move = ... # type: 'QwtPickerMachine.Command'
    Remove = ... # type: 'QwtPickerMachine.Command'
    End = ... # type: 'QwtPickerMachine.Command'

    class SelectionType(int): ...
    NoSelection = ... # type: 'QwtPickerMachine.SelectionType'
    PointSelection = ... # type: 'QwtPickerMachine.SelectionType'
    RectSelection = ... # type: 'QwtPickerMachine.SelectionType'
    PolygonSelection = ... # type: 'QwtPickerMachine.SelectionType'

    @typing.overload
    def __init__(self, type: 'QwtPickerMachine.SelectionType') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPickerMachine') -> None: ...

    def selectionType(self) -> 'QwtPickerMachine.SelectionType': ...
    def setState(self, a0: int) -> None: ...
    def state(self) -> int: ...
    def reset(self) -> None: ...
    def transition(self, a0: QwtEventPattern, a1: QtCore.QEvent) -> typing.List['QwtPickerMachine.Command']: ...


class QwtPickerTrackerMachine(QwtPickerMachine):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPickerTrackerMachine') -> None: ...

    def transition(self, a0: QwtEventPattern, a1: QtCore.QEvent) -> typing.List[QwtPickerMachine.Command]: ...


class QwtPickerClickPointMachine(QwtPickerMachine):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPickerClickPointMachine') -> None: ...

    def transition(self, a0: QwtEventPattern, a1: QtCore.QEvent) -> typing.List[QwtPickerMachine.Command]: ...


class QwtPickerDragPointMachine(QwtPickerMachine):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPickerDragPointMachine') -> None: ...

    def transition(self, a0: QwtEventPattern, a1: QtCore.QEvent) -> typing.List[QwtPickerMachine.Command]: ...


class QwtPickerClickRectMachine(QwtPickerMachine):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPickerClickRectMachine') -> None: ...

    def transition(self, a0: QwtEventPattern, a1: QtCore.QEvent) -> typing.List[QwtPickerMachine.Command]: ...


class QwtPickerDragRectMachine(QwtPickerMachine):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPickerDragRectMachine') -> None: ...

    def transition(self, a0: QwtEventPattern, a1: QtCore.QEvent) -> typing.List[QwtPickerMachine.Command]: ...


class QwtPickerDragLineMachine(QwtPickerMachine):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPickerDragLineMachine') -> None: ...

    def transition(self, a0: QwtEventPattern, a1: QtCore.QEvent) -> typing.List[QwtPickerMachine.Command]: ...


class QwtPickerPolygonMachine(QwtPickerMachine):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPickerPolygonMachine') -> None: ...

    def transition(self, a0: QwtEventPattern, a1: QtCore.QEvent) -> typing.List[QwtPickerMachine.Command]: ...


class QwtPlotCanvas(QtWidgets.QFrame):

    class FocusIndicator(int): ...
    NoFocusIndicator = ... # type: 'QwtPlotCanvas.FocusIndicator'
    CanvasFocusIndicator = ... # type: 'QwtPlotCanvas.FocusIndicator'
    ItemFocusIndicator = ... # type: 'QwtPlotCanvas.FocusIndicator'

    class PaintAttribute(int): ...
    BackingStore = ... # type: 'QwtPlotCanvas.PaintAttribute'
    Opaque = ... # type: 'QwtPlotCanvas.PaintAttribute'
    HackStyledBackground = ... # type: 'QwtPlotCanvas.PaintAttribute'
    ImmediatePaint = ... # type: 'QwtPlotCanvas.PaintAttribute'

    def __init__(self, a0: typing.Optional[QwtPlot] = ...) -> None: ...

    def updateStyleSheetInfo(self) -> None: ...
    def drawBorder(self, a0: QtGui.QPainter) -> None: ...
    def drawFocusIndicator(self, a0: QtGui.QPainter) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def replot(self) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def invalidateBackingStore(self) -> None: ...
    def backingStore(self) -> QtGui.QPixmap: ...
    def testPaintAttribute(self, a0: 'QwtPlotCanvas.PaintAttribute') -> bool: ...
    def setPaintAttribute(self, a0: 'QwtPlotCanvas.PaintAttribute', on: bool = ...) -> None: ...
    def borderRadius(self) -> float: ...
    def setBorderRadius(self, a0: float) -> None: ...
    def focusIndicator(self) -> 'QwtPlotCanvas.FocusIndicator': ...
    def setFocusIndicator(self, a0: 'QwtPlotCanvas.FocusIndicator') -> None: ...
    def plot(self) -> QwtPlot: ...


class QwtPlotGrid(QwtPlotItem):

    def __init__(self) -> None: ...

    def updateScaleDiv(self, xMap: QwtScaleDiv, yMap: QwtScaleDiv) -> None: ...
    def draw(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, rect: QtCore.QRectF) -> None: ...
    def minorPen(self) -> QtGui.QPen: ...
    @typing.overload
    def setMinorPen(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], width: float = ..., a2: QtCore.Qt.PenStyle = ...) -> None: ...
    @typing.overload
    def setMinorPen(self, p: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def majorPen(self) -> QtGui.QPen: ...
    @typing.overload
    def setMajorPen(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], width: float = ..., a2: QtCore.Qt.PenStyle = ...) -> None: ...
    @typing.overload
    def setMajorPen(self, a0: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    @typing.overload
    def setPen(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], width: float = ..., a2: QtCore.Qt.PenStyle = ...) -> None: ...
    @typing.overload
    def setPen(self, a0: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def yScaleDiv(self) -> QwtScaleDiv: ...
    def setYDiv(self, sy: QwtScaleDiv) -> None: ...
    def xScaleDiv(self) -> QwtScaleDiv: ...
    def setXDiv(self, sx: QwtScaleDiv) -> None: ...
    def yMinEnabled(self) -> bool: ...
    def enableYMin(self, tf: bool) -> None: ...
    def xMinEnabled(self) -> bool: ...
    def enableXMin(self, tf: bool) -> None: ...
    def yEnabled(self) -> bool: ...
    def enableY(self, tf: bool) -> None: ...
    def xEnabled(self) -> bool: ...
    def enableX(self, tf: bool) -> None: ...
    def rtti(self) -> int: ...


class QwtAbstractSeriesStore(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtAbstractSeriesStore') -> None: ...

    def dataSize(self) -> int: ...
    def dataRect(self) -> QtCore.QRectF: ...
    def setRectOfInterest(self, a0: QtCore.QRectF) -> None: ...
    def dataChanged(self) -> None: ...


class QwtPlotSeriesItem(QwtPlotItem, QwtAbstractSeriesStore):

    def __init__(self, title: str = ...) -> None: ...

    def dataChanged(self) -> None: ...
    def updateScaleDiv(self, a0: QwtScaleDiv, a1: QwtScaleDiv) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def drawSeries(self, painter: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def draw(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, a3: QtCore.QRectF) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...


class QwtSeriesStoreQPointF(QwtAbstractSeriesStore):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSeriesStoreQPointF') -> None: ...

    def swapData(self, series: 'QwtSeriesDataQPointF') -> 'QwtSeriesDataQPointF': ...
    def setRectOfInterest(self, rect: QtCore.QRectF) -> None: ...
    def dataRect(self) -> QtCore.QRectF: ...
    def dataSize(self) -> int: ...
    def sample(self, index: int) -> QtCore.QPointF: ...
    def data(self) -> 'QwtSeriesDataQPointF': ...
    def setData(self, series: 'QwtSeriesDataQPointF') -> None: ...


class QwtPlotCurve(QwtPlotSeriesItem, QwtSeriesStoreQPointF):

    class PaintAttribute(int): ...
    ClipPolygons = ... # type: 'QwtPlotCurve.PaintAttribute'
    FilterPoints = ... # type: 'QwtPlotCurve.PaintAttribute'
    MinimizeMemory = ... # type: 'QwtPlotCurve.PaintAttribute'
    ImageBuffer = ... # type: 'QwtPlotCurve.PaintAttribute'

    class LegendAttribute(int): ...
    LegendNoAttribute = ... # type: 'QwtPlotCurve.LegendAttribute'
    LegendShowLine = ... # type: 'QwtPlotCurve.LegendAttribute'
    LegendShowSymbol = ... # type: 'QwtPlotCurve.LegendAttribute'
    LegendShowBrush = ... # type: 'QwtPlotCurve.LegendAttribute'

    class CurveAttribute(int): ...
    Inverted = ... # type: 'QwtPlotCurve.CurveAttribute'
    Fitted = ... # type: 'QwtPlotCurve.CurveAttribute'

    class CurveStyle(int): ...
    NoCurve = ... # type: 'QwtPlotCurve.CurveStyle'
    Lines = ... # type: 'QwtPlotCurve.CurveStyle'
    Sticks = ... # type: 'QwtPlotCurve.CurveStyle'
    Steps = ... # type: 'QwtPlotCurve.CurveStyle'
    Dots = ... # type: 'QwtPlotCurve.CurveStyle'
    UserCurve = ... # type: 'QwtPlotCurve.CurveStyle'

    @typing.overload
    def __init__(self, title: str = ...) -> None: ...
    @typing.overload
    def __init__(self, title: QwtText) -> None: ...

    def closePolyline(self, a0: QtGui.QPainter, a1: QwtScaleMap, a2: QwtScaleMap, a3: QtGui.QPolygonF) -> None: ...
    def fillCurve(self, a0: QtGui.QPainter, a1: QwtScaleMap, a2: QwtScaleMap, canvasRect: QtCore.QRectF, a4: QtGui.QPolygonF) -> None: ...
    def drawSteps(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def drawDots(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def drawSticks(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def drawLines(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def drawCurve(self, p: QtGui.QPainter, style: int, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def init(self) -> None: ...
    def drawSeries(self, a0: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def curveFitter(self) -> 'QwtCurveFitter': ...
    def setCurveFitter(self, a0: 'QwtCurveFitter') -> None: ...
    def symbol(self) -> 'QwtSymbol': ...
    def setSymbol(self, a0: 'QwtSymbol') -> None: ...
    def style(self) -> 'QwtPlotCurve.CurveStyle': ...
    def setStyle(self, style: 'QwtPlotCurve.CurveStyle') -> None: ...
    def baseline(self) -> float: ...
    def setBaseline(self, a0: float) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, a0: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    @typing.overload
    def setPen(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], width: float = ..., a2: QtCore.Qt.PenStyle = ...) -> None: ...
    @typing.overload
    def setPen(self, a0: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def testCurveAttribute(self, a0: 'QwtPlotCurve.CurveAttribute') -> bool: ...
    def setCurveAttribute(self, a0: 'QwtPlotCurve.CurveAttribute', on: bool = ...) -> None: ...
    def maxYValue(self) -> float: ...
    def minYValue(self) -> float: ...
    def maxXValue(self) -> float: ...
    def minXValue(self) -> float: ...
    def closestPoint(self, pos: QtCore.QPoint) -> typing.Tuple[int, float]: ...
    @typing.overload
    def setSamples(self, xData: float, yData: float, size: int) -> None: ...
    @typing.overload
    def setSamples(self, xData: typing.Iterable[float], yData: typing.Iterable[float]) -> None: ...
    @typing.overload
    def setSamples(self, a0: QtGui.QPolygonF) -> None: ...
    @typing.overload
    def setSamples(self, a0: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    @typing.overload
    def setSamples(self, a0: 'QwtSeriesDataQPointF') -> None: ...
    def setRawSamples(self, xData: float, yData: float, size: int) -> None: ...
    def testLegendAttribute(self, a0: 'QwtPlotCurve.LegendAttribute') -> bool: ...
    def setLegendAttribute(self, a0: 'QwtPlotCurve.LegendAttribute', on: bool = ...) -> None: ...
    def testPaintAttribute(self, a0: 'QwtPlotCurve.PaintAttribute') -> bool: ...
    def setPaintAttribute(self, a0: 'QwtPlotCurve.PaintAttribute', on: bool = ...) -> None: ...
    def rtti(self) -> int: ...


class QwtSeriesStoreQwtIntervalSample(QwtAbstractSeriesStore):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSeriesStoreQwtIntervalSample') -> None: ...

    def swapData(self, series: 'QwtSeriesDataQwtIntervalSample') -> 'QwtSeriesDataQwtIntervalSample': ...
    def setRectOfInterest(self, rect: QtCore.QRectF) -> None: ...
    def dataRect(self) -> QtCore.QRectF: ...
    def dataSize(self) -> int: ...
    def sample(self, index: int) -> 'QwtIntervalSample': ...
    def data(self) -> 'QwtSeriesDataQwtIntervalSample': ...
    def setData(self, series: 'QwtSeriesDataQwtIntervalSample') -> None: ...


class QwtSeriesStoreQwtSetSample(QwtAbstractSeriesStore):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSeriesStoreQwtSetSample') -> None: ...

    def swapData(self, series: 'QwtSeriesDataQwtSetSample') -> 'QwtSeriesDataQwtSetSample': ...
    def setRectOfInterest(self, rect: QtCore.QRectF) -> None: ...
    def dataRect(self) -> QtCore.QRectF: ...
    def dataSize(self) -> int: ...
    def sample(self, index: int) -> 'QwtSetSample': ...
    def data(self) -> 'QwtSeriesDataQwtSetSample': ...
    def setData(self, series: 'QwtSeriesDataQwtSetSample') -> None: ...


class QwtSymbol(sip.wrapper):

    class CachePolicy(int): ...
    NoCache = ... # type: 'QwtSymbol.CachePolicy'
    Cache = ... # type: 'QwtSymbol.CachePolicy'
    AutoCache = ... # type: 'QwtSymbol.CachePolicy'

    class Style(int): ...
    NoSymbol = ... # type: 'QwtSymbol.Style'
    Ellipse = ... # type: 'QwtSymbol.Style'
    Rect = ... # type: 'QwtSymbol.Style'
    Diamond = ... # type: 'QwtSymbol.Style'
    Triangle = ... # type: 'QwtSymbol.Style'
    DTriangle = ... # type: 'QwtSymbol.Style'
    UTriangle = ... # type: 'QwtSymbol.Style'
    LTriangle = ... # type: 'QwtSymbol.Style'
    RTriangle = ... # type: 'QwtSymbol.Style'
    Cross = ... # type: 'QwtSymbol.Style'
    XCross = ... # type: 'QwtSymbol.Style'
    HLine = ... # type: 'QwtSymbol.Style'
    VLine = ... # type: 'QwtSymbol.Style'
    Star1 = ... # type: 'QwtSymbol.Style'
    Star2 = ... # type: 'QwtSymbol.Style'
    Hexagon = ... # type: 'QwtSymbol.Style'
    Path = ... # type: 'QwtSymbol.Style'
    Pixmap = ... # type: 'QwtSymbol.Style'
    Graphic = ... # type: 'QwtSymbol.Style'
    SvgDocument = ... # type: 'QwtSymbol.Style'
    UserStyle = ... # type: 'QwtSymbol.Style'

    @typing.overload
    def __init__(self, a0: 'QwtSymbol.Style' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSymbol.Style', a1: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], a2: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], a3: QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, a0: QtGui.QPainterPath, a1: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], a2: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...

    def renderSymbols(self, a0: QtGui.QPainter, a1: typing.Union[QtCore.QPointF, QtCore.QPoint], numPoints: int) -> None: ...
    def invalidateCache(self) -> None: ...
    def boundingRect(self) -> QtCore.QRect: ...
    @typing.overload
    def drawSymbols(self, a0: QtGui.QPainter, a1: QtGui.QPolygonF) -> None: ...
    @typing.overload
    def drawSymbols(self, a0: QtGui.QPainter, a1: typing.Union[QtCore.QPointF, QtCore.QPoint], numPoints: int) -> None: ...
    @typing.overload
    def drawSymbol(self, a0: QtGui.QPainter, a1: QtCore.QRectF) -> None: ...
    @typing.overload
    def drawSymbol(self, a0: QtGui.QPainter, a1: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def pixmap(self) -> QtGui.QPixmap: ...
    def setPixmap(self, a0: QtGui.QPixmap) -> None: ...
    def path(self) -> QtGui.QPainterPath: ...
    def setPath(self, a0: QtGui.QPainterPath) -> None: ...
    def style(self) -> 'QwtSymbol.Style': ...
    def setStyle(self, a0: 'QwtSymbol.Style') -> None: ...
    def pen(self) -> QtGui.QPen: ...
    @typing.overload
    def setPen(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], width: float = ..., a2: QtCore.Qt.PenStyle = ...) -> None: ...
    @typing.overload
    def setPen(self, a0: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, b: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def isPinPointEnabled(self) -> bool: ...
    def setPinPointEnabled(self, a0: bool) -> None: ...
    def pinPoint(self) -> QtCore.QPointF: ...
    def setPinPoint(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], enable: bool = ...) -> None: ...
    def size(self) -> QtCore.QSize: ...
    @typing.overload
    def setSize(self, a0: QtCore.QSize) -> None: ...
    @typing.overload
    def setSize(self, width: int, height: int = ...) -> None: ...
    def cachePolicy(self) -> 'QwtSymbol.CachePolicy': ...
    def setCachePolicy(self, a0: 'QwtSymbol.CachePolicy') -> None: ...


class QwtCurveFitter(sip.wrapper):

    def __init__(self) -> None: ...

    def fitCurve(self, polygon: QtGui.QPolygonF) -> QtGui.QPolygonF: ...


class QwtSplineCurveFitter(QwtCurveFitter):

    class FitMode(int): ...
    Auto = ... # type: 'QwtSplineCurveFitter.FitMode'
    Spline = ... # type: 'QwtSplineCurveFitter.FitMode'
    ParametricSpline = ... # type: 'QwtSplineCurveFitter.FitMode'

    def __init__(self) -> None: ...

    def fitCurve(self, a0: QtGui.QPolygonF) -> QtGui.QPolygonF: ...
    def splineSize(self) -> int: ...
    def setSplineSize(self, size: int) -> None: ...
    def spline(self) -> 'QwtSpline': ...
    def setSpline(self, a0: 'QwtSpline') -> None: ...
    def fitMode(self) -> 'QwtSplineCurveFitter.FitMode': ...
    def setFitMode(self, a0: 'QwtSplineCurveFitter.FitMode') -> None: ...


class QwtWeedingCurveFitter(QwtCurveFitter):

    def __init__(self, tolerance: float = ...) -> None: ...

    def fitCurve(self, a0: QtGui.QPolygonF) -> QtGui.QPolygonF: ...
    def chunkSize(self) -> int: ...
    def setChunkSize(self, a0: int) -> None: ...
    def tolerance(self) -> float: ...
    def setTolerance(self, a0: float) -> None: ...


class QwtIntervalSample(sip.wrapper):

    interval = ... # type: QwtInterval
    value = ... # type: float

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: float, a1: QwtInterval) -> None: ...
    @typing.overload
    def __init__(self, value: float, min: float, max: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtIntervalSample') -> None: ...


class QwtSetSample(sip.wrapper):

    set = ... # type: typing.Iterable[float]
    value = ... # type: float

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: float, a1: typing.Iterable[float] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSetSample') -> None: ...

    def added(self) -> float: ...


class QwtSeriesDataQPointF(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSeriesDataQPointF') -> None: ...

    def setRectOfInterest(self, rect: QtCore.QRectF) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def sample(self, i: int) -> QtCore.QPointF: ...
    def size(self) -> int: ...


class QwtSeriesDataQwtSetSample(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSeriesDataQwtSetSample') -> None: ...

    def setRectOfInterest(self, rect: QtCore.QRectF) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def sample(self, i: int) -> QwtSetSample: ...
    def size(self) -> int: ...


class QwtSeriesDataQwtIntervalSample(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSeriesDataQwtIntervalSample') -> None: ...

    def setRectOfInterest(self, rect: QtCore.QRectF) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def sample(self, i: int) -> QwtIntervalSample: ...
    def size(self) -> int: ...


class QwtArraySeriesDataQPointF(QwtSeriesDataQPointF):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, samples: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtArraySeriesDataQPointF') -> None: ...

    def sample(self, index: int) -> QtCore.QPointF: ...
    def size(self) -> int: ...
    def samples(self) -> typing.List[QtCore.QPointF]: ...
    def setSamples(self, samples: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...


class QwtSpline(sip.wrapper):

    class SplineType(int): ...
    Natural = ... # type: 'QwtSpline.SplineType'
    Periodic = ... # type: 'QwtSpline.SplineType'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSpline') -> None: ...

    def buildPeriodicSpline(self, a0: QtGui.QPolygonF) -> bool: ...
    def buildNaturalSpline(self, a0: QtGui.QPolygonF) -> bool: ...
    def coefficientsC(self) -> typing.List[float]: ...
    def coefficientsB(self) -> typing.List[float]: ...
    def coefficientsA(self) -> typing.List[float]: ...
    def value(self, x: float) -> float: ...
    def isValid(self) -> bool: ...
    def reset(self) -> None: ...
    def points(self) -> QtGui.QPolygonF: ...
    def setPoints(self, points: QtGui.QPolygonF) -> bool: ...
    def splineType(self) -> 'QwtSpline.SplineType': ...
    def setSplineType(self, a0: 'QwtSpline.SplineType') -> None: ...


class QwtPlotMarker(QwtPlotItem):

    class LineStyle(int): ...
    NoLine = ... # type: 'QwtPlotMarker.LineStyle'
    HLine = ... # type: 'QwtPlotMarker.LineStyle'
    VLine = ... # type: 'QwtPlotMarker.LineStyle'
    Cross = ... # type: 'QwtPlotMarker.LineStyle'

    @typing.overload
    def __init__(self, title: str = ...) -> None: ...
    @typing.overload
    def __init__(self, title: QwtText) -> None: ...

    def drawLabel(self, a0: QtGui.QPainter, a1: QtCore.QRectF, a2: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def drawLines(self, a0: QtGui.QPainter, a1: QtCore.QRectF, a2: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def draw(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, a3: QtCore.QRectF) -> None: ...
    def spacing(self) -> int: ...
    def setSpacing(self, a0: int) -> None: ...
    def labelOrientation(self) -> QtCore.Qt.Orientation: ...
    def setLabelOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...
    def labelAlignment(self) -> QtCore.Qt.Alignment: ...
    def setLabelAlignment(self, a0: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def label(self) -> QwtText: ...
    def setLabel(self, a0: QwtText) -> None: ...
    def symbol(self) -> QwtSymbol: ...
    def setSymbol(self, a0: QwtSymbol) -> None: ...
    def linePen(self) -> QtGui.QPen: ...
    @typing.overload
    def setLinePen(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], width: float = ..., a2: QtCore.Qt.PenStyle = ...) -> None: ...
    @typing.overload
    def setLinePen(self, p: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def lineStyle(self) -> 'QwtPlotMarker.LineStyle': ...
    def setLineStyle(self, st: 'QwtPlotMarker.LineStyle') -> None: ...
    @typing.overload
    def setValue(self, a0: float, a1: float) -> None: ...
    @typing.overload
    def setValue(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setYValue(self, a0: float) -> None: ...
    def setXValue(self, a0: float) -> None: ...
    def value(self) -> QtCore.QPointF: ...
    def yValue(self) -> float: ...
    def xValue(self) -> float: ...
    def rtti(self) -> int: ...


class QwtPanner(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget) -> None: ...

    def grab(self) -> QtGui.QPixmap: ...
    def contentsMask(self) -> QtGui.QBitmap: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def widgetKeyReleaseEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def widgetKeyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def widgetMouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def widgetMouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def widgetMousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def moved(self, dx: int, dy: int) -> None: ...
    def panned(self, dx: int, dy: int) -> None: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def isOrientationEnabled(self, a0: QtCore.Qt.Orientation) -> bool: ...
    def orientations(self) -> QtCore.Qt.Orientations: ...
    def setOrientations(self, a0: typing.Union[QtCore.Qt.Orientations, QtCore.Qt.Orientation]) -> None: ...
    def cursor(self) -> QtGui.QCursor: ...
    def setCursor(self, a0: typing.Union[QtGui.QCursor, QtCore.Qt.CursorShape]) -> None: ...
    def getAbortKey(self, a1: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> int: ...
    def setAbortKey(self, key: int, a1: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> None: ...
    def getMouseButton(self, a1: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> QtCore.Qt.MouseButton: ...
    def setMouseButton(self, a0: QtCore.Qt.MouseButton, a1: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> None: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, a0: bool) -> None: ...


class QwtPlotPanner(QwtPanner):

    def __init__(self, a0: QtWidgets.QWidget) -> None: ...

    def grab(self) -> QtGui.QPixmap: ...
    def contentsMask(self) -> QtGui.QBitmap: ...
    def moveCanvas(self, dx: int, dy: int) -> None: ...
    def isAxisEnabled(self, axis: int) -> bool: ...
    def setAxisEnabled(self, axis: int, on: bool) -> None: ...
    def plot(self) -> QwtPlot: ...
    def canvas(self) -> QtWidgets.QWidget: ...


class QwtCounter(QtWidgets.QWidget):

    class Button(int): ...
    Button1 = ... # type: 'QwtCounter.Button'
    Button2 = ... # type: 'QwtCounter.Button'
    Button3 = ... # type: 'QwtCounter.Button'
    ButtonCnt = ... # type: 'QwtCounter.Button'

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def valueChanged(self, value: float) -> None: ...
    def buttonReleased(self, value: float) -> None: ...
    def setValue(self, a0: float) -> None: ...
    def value(self) -> float: ...
    def stepButton3(self) -> int: ...
    def setStepButton3(self, nSteps: int) -> None: ...
    def stepButton2(self) -> int: ...
    def setStepButton2(self, nSteps: int) -> None: ...
    def stepButton1(self) -> int: ...
    def setStepButton1(self, nSteps: int) -> None: ...
    def setMaximum(self, max: float) -> None: ...
    def maximum(self) -> float: ...
    def setMinimum(self, min: float) -> None: ...
    def minimum(self) -> float: ...
    def setRange(self, min: float, max: float) -> None: ...
    def setSingleStep(self, s: float) -> None: ...
    def singleStep(self) -> float: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def incSteps(self, btn: 'QwtCounter.Button') -> int: ...
    def setIncSteps(self, btn: 'QwtCounter.Button', nSteps: int) -> None: ...
    def numButtons(self) -> int: ...
    def setNumButtons(self, n: int) -> None: ...
    def setReadOnly(self, a0: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def wrapping(self) -> bool: ...
    def setWrapping(self, a0: bool) -> None: ...
    def isValid(self) -> bool: ...
    def setValid(self, a0: bool) -> None: ...


class QwtColumnRect(sip.wrapper):

    class Direction(int): ...
    LeftToRight = ... # type: 'QwtColumnRect.Direction'
    RightToLeft = ... # type: 'QwtColumnRect.Direction'
    BottomToTop = ... # type: 'QwtColumnRect.Direction'
    TopToBottom = ... # type: 'QwtColumnRect.Direction'

    direction = ... # type: 'QwtColumnRect.Direction'
    hInterval = ... # type: QwtInterval
    vInterval = ... # type: QwtInterval

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtColumnRect') -> None: ...

    def orientation(self) -> QtCore.Qt.Orientation: ...
    def toRect(self) -> QtCore.QRectF: ...


class QwtColumnSymbol(sip.wrapper):

    class FrameStyle(int): ...
    NoFrame = ... # type: 'QwtColumnSymbol.FrameStyle'
    Plain = ... # type: 'QwtColumnSymbol.FrameStyle'
    Raised = ... # type: 'QwtColumnSymbol.FrameStyle'

    class Style(int): ...
    NoStyle = ... # type: 'QwtColumnSymbol.Style'
    Box = ... # type: 'QwtColumnSymbol.Style'
    UserStyle = ... # type: 'QwtColumnSymbol.Style'

    @typing.overload
    def __init__(self, a0: 'QwtColumnSymbol.Style' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtColumnSymbol') -> None: ...

    def drawBox(self, a0: QtGui.QPainter, a1: QwtColumnRect) -> None: ...
    def draw(self, a0: QtGui.QPainter, a1: QwtColumnRect) -> None: ...
    def style(self) -> 'QwtColumnSymbol.Style': ...
    def setStyle(self, a0: 'QwtColumnSymbol.Style') -> None: ...
    def palette(self) -> QtGui.QPalette: ...
    def setPalette(self, a0: QtGui.QPalette) -> None: ...
    def lineWidth(self) -> int: ...
    def setLineWidth(self, width: int) -> None: ...
    def frameStyle(self) -> 'QwtColumnSymbol.FrameStyle': ...
    def setFrameStyle(self, style: 'QwtColumnSymbol.FrameStyle') -> None: ...


class QwtPlotHistogram(QwtPlotSeriesItem, QwtSeriesStoreQwtIntervalSample):

    class HistogramStyle(int): ...
    Outline = ... # type: 'QwtPlotHistogram.HistogramStyle'
    Columns = ... # type: 'QwtPlotHistogram.HistogramStyle'
    Lines = ... # type: 'QwtPlotHistogram.HistogramStyle'
    UserStyle = ... # type: 'QwtPlotHistogram.HistogramStyle'

    def __init__(self, title: str = ...) -> None: ...

    def drawLines(self, a0: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, from_: int, to: int) -> None: ...
    def drawOutline(self, a0: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, from_: int, to: int) -> None: ...
    def drawColumns(self, a0: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, from_: int, to: int) -> None: ...
    def drawColumn(self, a0: QtGui.QPainter, a1: QwtColumnRect, a2: QwtIntervalSample) -> None: ...
    def columnRect(self, a0: QwtIntervalSample, a1: QwtScaleMap, a2: QwtScaleMap) -> QwtColumnRect: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def drawSeries(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def symbol(self) -> QwtColumnSymbol: ...
    def setSymbol(self, a0: QwtColumnSymbol) -> None: ...
    def style(self) -> 'QwtPlotHistogram.HistogramStyle': ...
    def setStyle(self, style: 'QwtPlotHistogram.HistogramStyle') -> None: ...
    def baseline(self) -> float: ...
    def setBaseline(self, reference: float) -> None: ...
    @typing.overload
    def setSamples(self, a0: typing.Iterable[QwtIntervalSample]) -> None: ...
    @typing.overload
    def setSamples(self, a0: QwtSeriesDataQwtIntervalSample) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, a0: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    @typing.overload
    def setPen(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], width: float = ..., a2: QtCore.Qt.PenStyle = ...) -> None: ...
    @typing.overload
    def setPen(self, a0: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def rtti(self) -> int: ...


class QwtPlotAbstractBarChart(QwtPlotSeriesItem):

    class LayoutPolicy(int): ...
    AutoAdjustSamples = ... # type: 'QwtPlotAbstractBarChart.LayoutPolicy'
    ScaleSamplesToAxes = ... # type: 'QwtPlotAbstractBarChart.LayoutPolicy'
    ScaleSampleToCanvas = ... # type: 'QwtPlotAbstractBarChart.LayoutPolicy'
    FixedSampleSize = ... # type: 'QwtPlotAbstractBarChart.LayoutPolicy'

    def __init__(self, title: QwtText) -> None: ...

    def sampleWidth(self, map: QwtScaleMap, canvasSize: float, dataSize: float, value: float) -> float: ...
    def getCanvasMarginHint(self, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF) -> typing.Tuple[float, float, float, float]: ...
    def baseline(self) -> float: ...
    def setBaseline(self, a0: float) -> None: ...
    def margin(self) -> int: ...
    def setMargin(self, a0: int) -> None: ...
    def spacing(self) -> int: ...
    def setSpacing(self, a0: int) -> None: ...
    def layoutHint(self) -> float: ...
    def setLayoutHint(self, a0: float) -> None: ...
    def layoutPolicy(self) -> 'QwtPlotAbstractBarChart.LayoutPolicy': ...
    def setLayoutPolicy(self, a0: 'QwtPlotAbstractBarChart.LayoutPolicy') -> None: ...


class QwtPlotBarChart(QwtPlotAbstractBarChart, QwtSeriesStoreQPointF):

    class LegendMode(int): ...
    LegendChartTitle = ... # type: 'QwtPlotBarChart.LegendMode'
    LegendBarTitles = ... # type: 'QwtPlotBarChart.LegendMode'

    @typing.overload
    def __init__(self, title: str = ...) -> None: ...
    @typing.overload
    def __init__(self, title: QwtText) -> None: ...

    def legendIcon(self, index: int, a1: QtCore.QSizeF) -> 'QwtGraphic': ...
    def legendData(self) -> typing.List[QwtLegendData]: ...
    def drawBar(self, a0: QtGui.QPainter, sampleIndex: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint], a3: QwtColumnRect) -> None: ...
    def drawSample(self, painter: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, boundingInterval: QwtInterval, index: int, sample: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def barTitle(self, sampleIndex: int) -> QwtText: ...
    def specialSymbol(self, sampleIndex: int, a1: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QwtColumnSymbol: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def drawSeries(self, painter: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def legendMode(self) -> 'QwtPlotBarChart.LegendMode': ...
    def setLegendMode(self, a0: 'QwtPlotBarChart.LegendMode') -> None: ...
    def symbol(self) -> QwtColumnSymbol: ...
    def setSymbol(self, a0: QwtColumnSymbol) -> None: ...
    @typing.overload
    def setSamples(self, a0: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    @typing.overload
    def setSamples(self, a0: typing.Iterable[float]) -> None: ...
    @typing.overload
    def setSamples(self, series: QwtSeriesDataQPointF) -> None: ...
    def rtti(self) -> int: ...


class QwtPlotMultiBarChart(QwtPlotAbstractBarChart, QwtSeriesStoreQwtSetSample):

    class ChartStyle(int): ...
    Grouped = ... # type: 'QwtPlotMultiBarChart.ChartStyle'
    Stacked = ... # type: 'QwtPlotMultiBarChart.ChartStyle'

    @typing.overload
    def __init__(self, title: str = ...) -> None: ...
    @typing.overload
    def __init__(self, title: QwtText) -> None: ...

    def drawGroupedBars(self, painter: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, index: int, sampleWidth: float, sample: QwtSetSample) -> None: ...
    def drawStackedBars(self, painter: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, index: int, sampleWidth: float, sample: QwtSetSample) -> None: ...
    def drawBar(self, a0: QtGui.QPainter, sampleIndex: int, barIndex: int, a3: QwtColumnRect) -> None: ...
    def drawSample(self, painter: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, boundingInterval: QwtInterval, index: int, sample: QwtSetSample) -> None: ...
    def specialSymbol(self, sampleIndex: int, valueIndex: int) -> QwtColumnSymbol: ...
    def symbol(self, barIndex: int) -> QwtColumnSymbol: ...
    def legendIcon(self, index: int, a1: QtCore.QSizeF) -> 'QwtGraphic': ...
    def legendData(self) -> typing.List[QwtLegendData]: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def drawSeries(self, painter: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, canvasRect: QtCore.QRectF, from_: int, to: int) -> None: ...
    def resetSymbolMap(self) -> None: ...
    def setSymbol(self, barIndex: int, symbol: QwtColumnSymbol) -> None: ...
    def style(self) -> 'QwtPlotMultiBarChart.ChartStyle': ...
    def setStyle(self, style: 'QwtPlotMultiBarChart.ChartStyle') -> None: ...
    @typing.overload
    def setSamples(self, a0: typing.Any) -> None: ...
    @typing.overload
    def setSamples(self, a0: QwtSeriesDataQwtSetSample) -> None: ...
    def barTitles(self) -> typing.List[QwtText]: ...
    def setBarTitles(self, a0: typing.Iterable[QwtText]) -> None: ...
    def rtti(self) -> int: ...


class QwtNullPaintDevice(QtGui.QPaintDevice):

    class Mode(int): ...
    NormalMode = ... # type: 'QwtNullPaintDevice.Mode'
    PolygonPathMode = ... # type: 'QwtNullPaintDevice.Mode'
    PathMode = ... # type: 'QwtNullPaintDevice.Mode'

    def __init__(self) -> None: ...

    def sizeMetrics(self) -> QtCore.QSize: ...
    def updateState(self, state: QtGui.QPaintEngineState) -> None: ...
    def drawImage(self, a0: QtCore.QRectF, a1: QtGui.QImage, a2: QtCore.QRectF, a3: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag]) -> None: ...
    def drawTiledPixmap(self, a0: QtCore.QRectF, a1: QtGui.QPixmap, s: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def drawTextItem(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint], a1: QtGui.QTextItem) -> None: ...
    def drawPixmap(self, a0: QtCore.QRectF, a1: QtGui.QPixmap, a2: QtCore.QRectF) -> None: ...
    @typing.overload
    def drawPolygon(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint], a1: int, a2: QtGui.QPaintEngine.PolygonDrawMode) -> None: ...
    @typing.overload
    def drawPolygon(self, a0: QtCore.QPoint, a1: int, a2: QtGui.QPaintEngine.PolygonDrawMode) -> None: ...
    @typing.overload
    def drawPoints(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint], a1: int) -> None: ...
    @typing.overload
    def drawPoints(self, a0: QtCore.QPoint, a1: int) -> None: ...
    def drawPath(self, a0: QtGui.QPainterPath) -> None: ...
    @typing.overload
    def drawEllipse(self, a0: QtCore.QRectF) -> None: ...
    @typing.overload
    def drawEllipse(self, a0: QtCore.QRect) -> None: ...
    @typing.overload
    def drawLines(self, a0: QtCore.QLine, a1: int) -> None: ...
    @typing.overload
    def drawLines(self, a0: QtCore.QLineF, a1: int) -> None: ...
    @typing.overload
    def drawRects(self, a0: QtCore.QRect, a1: int) -> None: ...
    @typing.overload
    def drawRects(self, a0: QtCore.QRectF, a1: int) -> None: ...
    def metric(self, metric: QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> QtGui.QPaintEngine: ...
    def mode(self) -> 'QwtNullPaintDevice.Mode': ...
    def setMode(self, a0: 'QwtNullPaintDevice.Mode') -> None: ...


class QwtGraphic(QwtNullPaintDevice):

    class RenderHint(int): ...
    RenderPensUnscaled = ... # type: 'QwtGraphic.RenderHint'

    class RenderHints(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtGraphic.RenderHints', 'QwtGraphic.RenderHint']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtGraphic.RenderHints') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtGraphic.RenderHints': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtGraphic') -> None: ...

    def updateState(self, state: QtGui.QPaintEngineState) -> None: ...
    def drawImage(self, a0: QtCore.QRectF, a1: QtGui.QImage, a2: QtCore.QRectF, a3: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag]) -> None: ...
    def drawPixmap(self, a0: QtCore.QRectF, a1: QtGui.QPixmap, a2: QtCore.QRectF) -> None: ...
    def drawPath(self, a0: QtGui.QPainterPath) -> None: ...
    def sizeMetrics(self) -> QtCore.QSize: ...
    def testRenderHint(self, a0: 'QwtGraphic.RenderHint') -> bool: ...
    def setRenderHint(self, a0: 'QwtGraphic.RenderHint', on: bool = ...) -> None: ...
    def defaultSize(self) -> QtCore.QSizeF: ...
    def setDefaultSize(self, a0: QtCore.QSizeF) -> None: ...
    def controlPointRect(self) -> QtCore.QRectF: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def scaledBoundingRect(self, sx: float, sy: float) -> QtCore.QRectF: ...
    @typing.overload
    def toImage(self) -> QtGui.QImage: ...
    @typing.overload
    def toImage(self, a0: QtCore.QSize, a1: QtCore.Qt.AspectRatioMode = ...) -> QtGui.QImage: ...
    @typing.overload
    def toPixmap(self) -> QtGui.QPixmap: ...
    @typing.overload
    def toPixmap(self, a0: QtCore.QSize, a1: QtCore.Qt.AspectRatioMode = ...) -> QtGui.QPixmap: ...
    @typing.overload
    def render(self, a0: QtGui.QPainter) -> None: ...
    @typing.overload
    def render(self, a0: QtGui.QPainter, a1: QtCore.QSizeF, a2: QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def render(self, a0: QtGui.QPainter, a1: QtCore.QRectF, a2: QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def render(self, a0: QtGui.QPainter, a1: typing.Union[QtCore.QPointF, QtCore.QPoint], a2: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def reset(self) -> None: ...


class QwtAbstractScale(QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def scaleChange(self) -> None: ...
    def abstractScaleDraw(self) -> QwtAbstractScaleDraw: ...
    def setAbstractScaleDraw(self, a0: QwtAbstractScaleDraw) -> None: ...
    def rescale(self, lowerBound: float, upperBound: float, stepSize: float) -> None: ...
    def scaleMap(self) -> QwtScaleMap: ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def isInverted(self) -> bool: ...
    def invTransform(self, a0: int) -> float: ...
    def transform(self, a0: float) -> int: ...
    def scaleEngine(self) -> QwtScaleEngine: ...
    def setScaleEngine(self, a0: QwtScaleEngine) -> None: ...
    def scaleMaxMajor(self) -> int: ...
    def setScaleMaxMinor(self, ticks: int) -> None: ...
    def scaleMaxMinor(self) -> int: ...
    def setScaleMaxMajor(self, ticks: int) -> None: ...
    def scaleStepSize(self) -> float: ...
    def setScaleStepSize(self, stepSize: float) -> None: ...
    def upperBound(self) -> float: ...
    def setUpperBound(self, value: float) -> None: ...
    def lowerBound(self) -> float: ...
    def setLowerBound(self, value: float) -> None: ...
    def scaleDiv(self) -> QwtScaleDiv: ...
    @typing.overload
    def setScale(self, lowerBound: float, upperBound: float) -> None: ...
    @typing.overload
    def setScale(self, a0: QwtInterval) -> None: ...
    @typing.overload
    def setScale(self, a0: QwtScaleDiv) -> None: ...


class QwtAbstractSlider(QwtAbstractScale):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def incrementedValue(self, value: float, stepCount: int) -> float: ...
    def sliderChange(self) -> None: ...
    def scaleChange(self) -> None: ...
    def incrementValue(self, numSteps: int) -> None: ...
    def scrolledTo(self, pos: QtCore.QPoint) -> float: ...
    def isScrollPosition(self, pos: QtCore.QPoint) -> bool: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def sliderMoved(self, value: float) -> None: ...
    def sliderReleased(self) -> None: ...
    def sliderPressed(self) -> None: ...
    def valueChanged(self, value: float) -> None: ...
    def setValue(self, val: float) -> None: ...
    def invertedControls(self) -> bool: ...
    def setInvertedControls(self, a0: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, a0: bool) -> None: ...
    def isTracking(self) -> bool: ...
    def setTracking(self, a0: bool) -> None: ...
    def stepAlignment(self) -> bool: ...
    def setStepAlignment(self, a0: bool) -> None: ...
    def pageSteps(self) -> int: ...
    def setPageSteps(self, a0: int) -> None: ...
    def singleSteps(self) -> int: ...
    def setSingleSteps(self, a0: int) -> None: ...
    def totalSteps(self) -> int: ...
    def setTotalSteps(self, a0: int) -> None: ...
    def wrapping(self) -> bool: ...
    def setWrapping(self, a0: bool) -> None: ...
    def value(self) -> float: ...
    def isValid(self) -> bool: ...
    def setValid(self, a0: bool) -> None: ...


class QwtSlider(QwtAbstractSlider):

    class ScalePosition(int): ...
    NoScale = ... # type: 'QwtSlider.ScalePosition'
    LeadingScale = ... # type: 'QwtSlider.ScalePosition'
    TrailingScale = ... # type: 'QwtSlider.ScalePosition'

    @typing.overload
    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: QtCore.Qt.Orientation, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def handleRect(self) -> QtCore.QRect: ...
    def sliderRect(self) -> QtCore.QRect: ...
    def scaleChange(self) -> None: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def drawHandle(self, a0: QtGui.QPainter, a1: QtCore.QRect, pos: int) -> None: ...
    def drawSlider(self, a0: QtGui.QPainter, a1: QtCore.QRect) -> None: ...
    def isScrollPosition(self, a0: QtCore.QPoint) -> bool: ...
    def scrolledTo(self, a0: QtCore.QPoint) -> float: ...
    def updateInterval(self) -> int: ...
    def setUpdateInterval(self, a0: int) -> None: ...
    def scaleDraw(self) -> QwtScaleDraw: ...
    def setScaleDraw(self, a0: QwtScaleDraw) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def spacing(self) -> int: ...
    def setSpacing(self, a0: int) -> None: ...
    def borderWidth(self) -> int: ...
    def setBorderWidth(self, bw: int) -> None: ...
    def handleSize(self) -> QtCore.QSize: ...
    def setHandleSize(self, a0: QtCore.QSize) -> None: ...
    def hasGroove(self) -> bool: ...
    def setGroove(self, a0: bool) -> None: ...
    def hasTrough(self) -> bool: ...
    def setTrough(self, a0: bool) -> None: ...
    def scalePosition(self) -> 'QwtSlider.ScalePosition': ...
    def setScalePosition(self, a0: 'QwtSlider.ScalePosition') -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...


class QwtThermo(QwtAbstractScale):

    class OriginMode(int): ...
    OriginMinimum = ... # type: 'QwtThermo.OriginMode'
    OriginMaximum = ... # type: 'QwtThermo.OriginMode'
    OriginCustom = ... # type: 'QwtThermo.OriginMode'

    class ScalePosition(int): ...
    NoScale = ... # type: 'QwtThermo.ScalePosition'
    LeadingScale = ... # type: 'QwtThermo.ScalePosition'
    TrailingScale = ... # type: 'QwtThermo.ScalePosition'

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def alarmRect(self, a0: QtCore.QRect) -> QtCore.QRect: ...
    def fillRect(self, a0: QtCore.QRect) -> QtCore.QRect: ...
    def pipeRect(self) -> QtCore.QRect: ...
    def scaleDraw(self) -> QwtScaleDraw: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def scaleChange(self) -> None: ...
    def drawLiquid(self, a0: QtGui.QPainter, a1: QtCore.QRect) -> None: ...
    def setValue(self, val: float) -> None: ...
    def setScaleDraw(self, a0: QwtScaleDraw) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def value(self) -> float: ...
    def rangeFlags(self) -> QwtInterval.BorderFlags: ...
    def setRangeFlags(self, a0: typing.Union[QwtInterval.BorderFlags, QwtInterval.BorderFlag]) -> None: ...
    def pipeWidth(self) -> int: ...
    def setPipeWidth(self, w: int) -> None: ...
    def colorMap(self) -> QwtColorMap: ...
    def setColorMap(self, a0: QwtColorMap) -> None: ...
    def alarmEnabled(self) -> bool: ...
    def setAlarmEnabled(self, tf: bool) -> None: ...
    def alarmLevel(self) -> float: ...
    def setAlarmLevel(self, v: float) -> None: ...
    def alarmBrush(self) -> QtGui.QBrush: ...
    def setAlarmBrush(self, b: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def fillBrush(self) -> QtGui.QBrush: ...
    def setFillBrush(self, b: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def origin(self) -> float: ...
    def setOrigin(self, a0: float) -> None: ...
    def originMode(self) -> 'QwtThermo.OriginMode': ...
    def setOriginMode(self, a0: 'QwtThermo.OriginMode') -> None: ...
    def borderWidth(self) -> int: ...
    def setBorderWidth(self, w: int) -> None: ...
    def spacing(self) -> int: ...
    def setSpacing(self, a0: int) -> None: ...
    def scalePosition(self) -> 'QwtThermo.ScalePosition': ...
    def setScalePosition(self, a0: 'QwtThermo.ScalePosition') -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...


class QwtWheel(QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def valueAt(self, a0: QtCore.QPoint) -> float: ...
    def drawWheelBackground(self, a0: QtGui.QPainter, a1: QtCore.QRectF) -> None: ...
    def drawTicks(self, a0: QtGui.QPainter, a1: QtCore.QRectF) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def wheelRect(self) -> QtCore.QRect: ...
    def stopFlying(self) -> None: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def wheelMoved(self, value: float) -> None: ...
    def wheelReleased(self) -> None: ...
    def wheelPressed(self) -> None: ...
    def valueChanged(self, value: float) -> None: ...
    def setMass(self, a0: float) -> None: ...
    def setViewAngle(self, a0: float) -> None: ...
    def setTotalAngle(self, a0: float) -> None: ...
    def setValue(self, a0: float) -> None: ...
    def mass(self) -> float: ...
    def isTracking(self) -> bool: ...
    def setTracking(self, enable: bool) -> None: ...
    def updateInterval(self) -> int: ...
    def setUpdateInterval(self, a0: int) -> None: ...
    def maximum(self) -> float: ...
    def setMaximum(self, max: float) -> None: ...
    def minimum(self) -> float: ...
    def setMinimum(self, min: float) -> None: ...
    def setRange(self, vmin: float, vmax: float) -> None: ...
    def stepAlignment(self) -> bool: ...
    def setStepAlignment(self, on: bool) -> None: ...
    def pageStepCount(self) -> int: ...
    def setPageStepCount(self, a0: int) -> None: ...
    def singleStep(self) -> float: ...
    def setSingleStep(self, a0: float) -> None: ...
    def wrapping(self) -> bool: ...
    def setWrapping(self, tf: bool) -> None: ...
    def isInverted(self) -> bool: ...
    def setInverted(self, tf: bool) -> None: ...
    def borderWidth(self) -> int: ...
    def setBorderWidth(self, a0: int) -> None: ...
    def wheelBorderWidth(self) -> int: ...
    def setWheelBorderWidth(self, a0: int) -> None: ...
    def wheelWidth(self) -> int: ...
    def setWheelWidth(self, a0: int) -> None: ...
    def tickCount(self) -> int: ...
    def setTickCount(self, a0: int) -> None: ...
    def viewAngle(self) -> float: ...
    def totalAngle(self) -> float: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...
    def value(self) -> float: ...


class QwtRoundScaleDraw(QwtAbstractScaleDraw):

    def __init__(self) -> None: ...

    def drawLabel(self, a0: QtGui.QPainter, val: float) -> None: ...
    def drawBackbone(self, a0: QtGui.QPainter) -> None: ...
    def drawTick(self, a0: QtGui.QPainter, val: float, len: float) -> None: ...
    def extent(self, a0: QtGui.QFont) -> float: ...
    def setAngleRange(self, angle1: float, angle2: float) -> None: ...
    def center(self) -> QtCore.QPointF: ...
    @typing.overload
    def moveCenter(self, x: float, y: float) -> None: ...
    @typing.overload
    def moveCenter(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def radius(self) -> float: ...
    def setRadius(self, radius: float) -> None: ...


class QwtKnob(QwtAbstractSlider):

    class MarkerStyle(int): ...
    NoMarker = ... # type: 'QwtKnob.MarkerStyle'
    Tick = ... # type: 'QwtKnob.MarkerStyle'
    Triangle = ... # type: 'QwtKnob.MarkerStyle'
    Dot = ... # type: 'QwtKnob.MarkerStyle'
    Nub = ... # type: 'QwtKnob.MarkerStyle'
    Notch = ... # type: 'QwtKnob.MarkerStyle'

    class KnobStyle(int): ...
    Flat = ... # type: 'QwtKnob.KnobStyle'
    Raised = ... # type: 'QwtKnob.KnobStyle'
    Sunken = ... # type: 'QwtKnob.KnobStyle'
    Styled = ... # type: 'QwtKnob.KnobStyle'

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def isScrollPosition(self, a0: QtCore.QPoint) -> bool: ...
    def scrolledTo(self, a0: QtCore.QPoint) -> float: ...
    def drawMarker(self, a0: QtGui.QPainter, a1: QtCore.QRectF, arc: float) -> None: ...
    def drawFocusIndicator(self, a0: QtGui.QPainter) -> None: ...
    def drawKnob(self, a0: QtGui.QPainter, a1: QtCore.QRectF) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def knobRect(self) -> QtCore.QRect: ...
    def scaleDraw(self) -> QwtRoundScaleDraw: ...
    def setScaleDraw(self, a0: QwtRoundScaleDraw) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def markerSize(self) -> int: ...
    def setMarkerSize(self, a0: int) -> None: ...
    def markerStyle(self) -> 'QwtKnob.MarkerStyle': ...
    def setMarkerStyle(self, a0: 'QwtKnob.MarkerStyle') -> None: ...
    def borderWidth(self) -> int: ...
    def setBorderWidth(self, bw: int) -> None: ...
    def knobStyle(self) -> 'QwtKnob.KnobStyle': ...
    def setKnobStyle(self, a0: 'QwtKnob.KnobStyle') -> None: ...
    def totalAngle(self) -> float: ...
    def setTotalAngle(self, angle: float) -> None: ...
    def numTurns(self) -> int: ...
    def setNumTurns(self, a0: int) -> None: ...
    def knobWidth(self) -> int: ...
    def setKnobWidth(self, a0: int) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def setAlignment(self, a0: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...


class QwtPlotDirectPainter(QtCore.QObject):

    class Attribute(int): ...
    AtomicPainter = ... # type: 'QwtPlotDirectPainter.Attribute'
    FullRepaint = ... # type: 'QwtPlotDirectPainter.Attribute'
    CopyBackingStore = ... # type: 'QwtPlotDirectPainter.Attribute'

    class Attributes(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtPlotDirectPainter.Attributes', 'QwtPlotDirectPainter.Attribute']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtPlotDirectPainter.Attributes') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtPlotDirectPainter.Attributes': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def reset(self) -> None: ...
    def drawSeries(self, a0: QwtPlotSeriesItem, from_: int, to: int) -> None: ...
    def clipRegion(self) -> QtGui.QRegion: ...
    def setClipRegion(self, a0: QtGui.QRegion) -> None: ...
    def hasClipping(self) -> bool: ...
    def setClipping(self, a0: bool) -> None: ...
    def testAttribute(self, a0: 'QwtPlotDirectPainter.Attribute') -> bool: ...
    def setAttribute(self, a0: 'QwtPlotDirectPainter.Attribute', on: bool) -> None: ...


class QwtSamplingThread(QtCore.QThread):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def sample(self, elapsed: float) -> None: ...
    def run(self) -> None: ...
    def stop(self) -> None: ...
    def setInterval(self, interval: float) -> None: ...
    def elapsed(self) -> float: ...
    def interval(self) -> float: ...


class QwtPlotRasterItem(QwtPlotItem):

    class PaintAttribute(int): ...
    PaintInDeviceResolution = ... # type: 'QwtPlotRasterItem.PaintAttribute'

    class CachePolicy(int): ...
    NoCache = ... # type: 'QwtPlotRasterItem.CachePolicy'
    PaintCache = ... # type: 'QwtPlotRasterItem.CachePolicy'

    class PaintAttributes(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtPlotRasterItem.PaintAttributes', 'QwtPlotRasterItem.PaintAttribute']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtPlotRasterItem.PaintAttributes') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtPlotRasterItem.PaintAttributes': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, title: str = ...) -> None: ...
    @typing.overload
    def __init__(self, title: QwtText) -> None: ...

    def imageMap(self, a0: QtCore.Qt.Orientation, map: QwtScaleMap, area: QtCore.QRectF, imageSize: QtCore.QSize, pixelSize: float) -> QwtScaleMap: ...
    def renderImage(self, xMap: QwtScaleMap, yMap: QwtScaleMap, area: QtCore.QRectF, imageSize: QtCore.QSize) -> QtGui.QImage: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def interval(self, a0: QtCore.Qt.Axis) -> QwtInterval: ...
    def pixelHint(self, a0: QtCore.QRectF) -> QtCore.QRectF: ...
    def draw(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, rect: QtCore.QRectF) -> None: ...
    def invalidateCache(self) -> None: ...
    def cachePolicy(self) -> 'QwtPlotRasterItem.CachePolicy': ...
    def setCachePolicy(self, a0: 'QwtPlotRasterItem.CachePolicy') -> None: ...
    def alpha(self) -> int: ...
    def setAlpha(self, alpha: int) -> None: ...
    def testPaintAttribute(self, a0: 'QwtPlotRasterItem.PaintAttribute') -> bool: ...
    def setPaintAttribute(self, a0: 'QwtPlotRasterItem.PaintAttribute', on: bool = ...) -> None: ...


class QwtPlotSpectrogram(QwtPlotRasterItem):

    class DisplayMode(int): ...
    ImageMode = ... # type: 'QwtPlotSpectrogram.DisplayMode'
    ContourMode = ... # type: 'QwtPlotSpectrogram.DisplayMode'

    class DisplayModes(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtPlotSpectrogram.DisplayModes', 'QwtPlotSpectrogram.DisplayMode']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtPlotSpectrogram.DisplayModes') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtPlotSpectrogram.DisplayModes': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    def __init__(self, title: str = ...) -> None: ...

    def renderTile(self, xMap: QwtScaleMap, yMap: QwtScaleMap, imageRect: QtCore.QRect, image: QtGui.QImage) -> None: ...
    def contourRasterSize(self, a0: QtCore.QRectF, a1: QtCore.QRect) -> QtCore.QSize: ...
    def renderImage(self, xMap: QwtScaleMap, yMap: QwtScaleMap, area: QtCore.QRectF, imageSize: QtCore.QSize) -> QtGui.QImage: ...
    def draw(self, p: QtGui.QPainter, xMap: QwtScaleMap, yMap: QwtScaleMap, rect: QtCore.QRectF) -> None: ...
    def rtti(self) -> int: ...
    def contourLevels(self) -> typing.List[float]: ...
    def setContourLevels(self, a0: typing.Iterable[float]) -> None: ...
    def testConrecFlag(self, a0: 'QwtRasterData.ConrecFlag') -> bool: ...
    def setConrecFlag(self, a0: 'QwtRasterData.ConrecFlag', on: bool) -> None: ...
    def contourPen(self, level: float) -> QtGui.QPen: ...
    def defaultContourPen(self) -> QtGui.QPen: ...
    @typing.overload
    def setDefaultContourPen(self, a0: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], width: float = ..., a2: QtCore.Qt.PenStyle = ...) -> None: ...
    @typing.overload
    def setDefaultContourPen(self, a0: typing.Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def pixelHint(self, a0: QtCore.QRectF) -> QtCore.QRectF: ...
    def interval(self, a0: QtCore.Qt.Axis) -> QwtInterval: ...
    def setColorMap(self, a0: QwtColorMap) -> None: ...
    def data(self) -> 'QwtRasterData': ...
    def setData(self, data: 'QwtRasterData') -> None: ...
    def testDisplayMode(self, a0: 'QwtPlotSpectrogram.DisplayMode') -> bool: ...
    def setDisplayMode(self, a0: 'QwtPlotSpectrogram.DisplayMode', on: bool = ...) -> None: ...


class QwtRasterData(sip.wrapper):

    class ConrecFlag(int): ...
    IgnoreAllVerticesOnLevel = ... # type: 'QwtRasterData.ConrecFlag'
    IgnoreOutOfRange = ... # type: 'QwtRasterData.ConrecFlag'

    class ConrecFlags(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtRasterData.ConrecFlags', 'QwtRasterData.ConrecFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtRasterData.ConrecFlags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtRasterData.ConrecFlags': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    class Contour3DPoint(sip.wrapper): ...

    class ContourPlane(sip.wrapper): ...

    def __init__(self) -> None: ...

    def value(self, x: float, y: float) -> float: ...
    def discardRaster(self) -> None: ...
    def initRaster(self, a0: QtCore.QRectF, raster: QtCore.QSize) -> None: ...
    def pixelHint(self, a0: QtCore.QRectF) -> QtCore.QRectF: ...
    def interval(self, a0: QtCore.Qt.Axis) -> QwtInterval: ...
    def setInterval(self, a0: QtCore.Qt.Axis, a1: QwtInterval) -> None: ...


class QPrinter(sip.wrapper): ...


class QwtPlotRenderer(QtCore.QObject):

    class LayoutFlag(int): ...
    DefaultLayout = ... # type: 'QwtPlotRenderer.LayoutFlag'
    FrameWithScales = ... # type: 'QwtPlotRenderer.LayoutFlag'

    class DiscardFlag(int): ...
    DiscardNone = ... # type: 'QwtPlotRenderer.DiscardFlag'
    DiscardBackground = ... # type: 'QwtPlotRenderer.DiscardFlag'
    DiscardTitle = ... # type: 'QwtPlotRenderer.DiscardFlag'
    DiscardLegend = ... # type: 'QwtPlotRenderer.DiscardFlag'
    DiscardCanvasBackground = ... # type: 'QwtPlotRenderer.DiscardFlag'
    DiscardFooter = ... # type: 'QwtPlotRenderer.DiscardFlag'
    DiscardCanvasFrame = ... # type: 'QwtPlotRenderer.DiscardFlag'

    class DiscardFlags(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtPlotRenderer.DiscardFlags', 'QwtPlotRenderer.DiscardFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtPlotRenderer.DiscardFlags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtPlotRenderer.DiscardFlags': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    class LayoutFlags(sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QwtPlotRenderer.LayoutFlags', 'QwtPlotRenderer.LayoutFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QwtPlotRenderer.LayoutFlags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QwtPlotRenderer.LayoutFlags': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    def __init__(self, a0: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def exportTo(self, a0: QwtPlot, documentName: str, sizeMM: QtCore.QSizeF = ..., resolution: int = ...) -> bool: ...
    def renderLegend(self, a0: QwtPlot, a1: QtGui.QPainter, a2: QtCore.QRectF) -> None: ...
    def renderCanvas(self, a0: QwtPlot, a1: QtGui.QPainter, canvasRect: QtCore.QRectF, maps: QwtScaleMap) -> None: ...
    def renderScale(self, a0: QwtPlot, a1: QtGui.QPainter, axisId: int, startDist: int, endDist: int, baseDist: int, a6: QtCore.QRectF) -> None: ...
    def renderFooter(self, a0: QwtPlot, a1: QtGui.QPainter, a2: QtCore.QRectF) -> None: ...
    def renderTitle(self, a0: QwtPlot, a1: QtGui.QPainter, a2: QtCore.QRectF) -> None: ...
    def render(self, a0: QwtPlot, a1: QtGui.QPainter, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def renderTo(self, a0: QwtPlot, a1: QPrinter) -> None: ...
    @typing.overload
    def renderTo(self, a0: QwtPlot, p: QtGui.QPaintDevice) -> None: ...
    @typing.overload
    def renderDocument(self, a0: QwtPlot, fileName: str, sizeMM: QtCore.QSizeF, resolution: int = ...) -> None: ...
    @typing.overload
    def renderDocument(self, a0: QwtPlot, fileName: str, format: str, sizeMM: QtCore.QSizeF, resolution: int = ...) -> None: ...
    def layoutFlags(self) -> 'QwtPlotRenderer.LayoutFlags': ...
    def setLayoutFlags(self, flags: typing.Union['QwtPlotRenderer.LayoutFlags', 'QwtPlotRenderer.LayoutFlag']) -> None: ...
    def testLayoutFlag(self, flag: 'QwtPlotRenderer.LayoutFlag') -> bool: ...
    def setLayoutFlag(self, flag: 'QwtPlotRenderer.LayoutFlag', on: bool = ...) -> None: ...
    def discardFlags(self) -> 'QwtPlotRenderer.DiscardFlags': ...
    def setDiscardFlags(self, flags: typing.Union['QwtPlotRenderer.DiscardFlags', 'QwtPlotRenderer.DiscardFlag']) -> None: ...
    def testDiscardFlag(self, flag: 'QwtPlotRenderer.DiscardFlag') -> bool: ...
    def setDiscardFlag(self, flag: 'QwtPlotRenderer.DiscardFlag', on: bool = ...) -> None: ...


class QwtTransform(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtTransform') -> None: ...

    def copy(self) -> 'QwtTransform': ...
    def invTransform(self, value: float) -> float: ...
    def transform(self, value: float) -> float: ...
    def bounded(self, value: float) -> float: ...


class QwtNullTransform(QwtTransform):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtNullTransform') -> None: ...

    def copy(self) -> QwtTransform: ...
    def invTransform(self, value: float) -> float: ...
    def transform(self, value: float) -> float: ...


class QwtLogTransform(QwtTransform):

    LogMax = ... # type: float
    LogMin = ... # type: float

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtLogTransform') -> None: ...

    def copy(self) -> QwtTransform: ...
    def bounded(self, value: float) -> float: ...
    def invTransform(self, value: float) -> float: ...
    def transform(self, value: float) -> float: ...


class QwtPowerTransform(QwtTransform):

    @typing.overload
    def __init__(self, exponent: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPowerTransform') -> None: ...

    def copy(self) -> QwtTransform: ...
    def invTransform(self, value: float) -> float: ...
    def transform(self, value: float) -> float: ...


class QwtDialNeedle(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtDialNeedle') -> None: ...

    def drawKnob(self, a0: QtGui.QPainter, width: float, a2: typing.Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], sunken: bool) -> None: ...
    def drawNeedle(self, painter: QtGui.QPainter, length: float, colorGroup: QtGui.QPalette.ColorGroup) -> None: ...
    def draw(self, painter: QtGui.QPainter, center: typing.Union[QtCore.QPointF, QtCore.QPoint], length: float, direction: float, a4: QtGui.QPalette.ColorGroup = ...) -> None: ...
    def palette(self) -> QtGui.QPalette: ...
    def setPalette(self, a0: QtGui.QPalette) -> None: ...


class QwtDialSimpleNeedle(QwtDialNeedle):

    class Style(int): ...
    Arrow = ... # type: 'QwtDialSimpleNeedle.Style'
    Ray = ... # type: 'QwtDialSimpleNeedle.Style'

    @typing.overload
    def __init__(self, a0: 'QwtDialSimpleNeedle.Style', hasKnob: bool = ..., mid: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., base: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtDialSimpleNeedle') -> None: ...

    def drawNeedle(self, a0: QtGui.QPainter, length: float, a2: QtGui.QPalette.ColorGroup) -> None: ...
    def width(self) -> float: ...
    def setWidth(self, width: float) -> None: ...


class QwtCompassMagnetNeedle(QwtDialNeedle):

    class Style(int): ...
    TriangleStyle = ... # type: 'QwtCompassMagnetNeedle.Style'
    ThinStyle = ... # type: 'QwtCompassMagnetNeedle.Style'

    @typing.overload
    def __init__(self, a0: 'QwtCompassMagnetNeedle.Style' = ..., light: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., dark: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtCompassMagnetNeedle') -> None: ...

    def drawNeedle(self, a0: QtGui.QPainter, length: float, a2: QtGui.QPalette.ColorGroup) -> None: ...


class QwtCompassWindArrow(QwtDialNeedle):

    class Style(int): ...
    Style1 = ... # type: 'QwtCompassWindArrow.Style'
    Style2 = ... # type: 'QwtCompassWindArrow.Style'

    @typing.overload
    def __init__(self, a0: 'QwtCompassWindArrow.Style', light: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., dark: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtCompassWindArrow') -> None: ...

    def drawNeedle(self, a0: QtGui.QPainter, length: float, a2: QtGui.QPalette.ColorGroup) -> None: ...


class QwtDial(QwtAbstractSlider):

    class Mode(int): ...
    RotateNeedle = ... # type: 'QwtDial.Mode'
    RotateScale = ... # type: 'QwtDial.Mode'

    class Shadow(int): ...
    Plain = ... # type: 'QwtDial.Shadow'
    Raised = ... # type: 'QwtDial.Shadow'
    Sunken = ... # type: 'QwtDial.Shadow'

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def scaleChange(self) -> None: ...
    def sliderChange(self) -> None: ...
    def isScrollPosition(self, a0: QtCore.QPoint) -> bool: ...
    def scrolledTo(self, a0: QtCore.QPoint) -> float: ...
    def drawNeedle(self, a0: QtGui.QPainter, a1: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float, direction: float, a4: QtGui.QPalette.ColorGroup) -> None: ...
    def drawScaleContents(self, painter: QtGui.QPainter, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float) -> None: ...
    def drawScale(self, a0: QtGui.QPainter, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float) -> None: ...
    def invalidateCache(self) -> None: ...
    def drawFocusIndicator(self, a0: QtGui.QPainter) -> None: ...
    def drawContents(self, a0: QtGui.QPainter) -> None: ...
    def drawFrame(self, p: QtGui.QPainter) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, a0: QtGui.QPaintEvent) -> None: ...
    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None: ...
    def scaleDraw(self) -> QwtRoundScaleDraw: ...
    def setScaleDraw(self, a0: QwtRoundScaleDraw) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def scaleInnerRect(self) -> QtCore.QRect: ...
    def innerRect(self) -> QtCore.QRect: ...
    def boundingRect(self) -> QtCore.QRect: ...
    def needle(self) -> QwtDialNeedle: ...
    def setNeedle(self, a0: QwtDialNeedle) -> None: ...
    def origin(self) -> float: ...
    def setOrigin(self, a0: float) -> None: ...
    def maxScaleArc(self) -> float: ...
    def setMaxScaleArc(self, min: float) -> None: ...
    def minScaleArc(self) -> float: ...
    def setMinScaleArc(self, min: float) -> None: ...
    def setScaleArc(self, min: float, max: float) -> None: ...
    def mode(self) -> 'QwtDial.Mode': ...
    def setMode(self, a0: 'QwtDial.Mode') -> None: ...
    def lineWidth(self) -> int: ...
    def setLineWidth(self, a0: int) -> None: ...
    def frameShadow(self) -> 'QwtDial.Shadow': ...
    def setFrameShadow(self, a0: 'QwtDial.Shadow') -> None: ...


class QwtCompassRose(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtCompassRose') -> None: ...

    def draw(self, painter: QtGui.QPainter, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float, north: float, colorGroup: QtGui.QPalette.ColorGroup = ...) -> None: ...
    def palette(self) -> QtGui.QPalette: ...
    def setPalette(self, p: QtGui.QPalette) -> None: ...


class QwtSimpleCompassRose(QwtCompassRose):

    @typing.overload
    def __init__(self, numThorns: int = ..., numThornLevels: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtSimpleCompassRose') -> None: ...

    @staticmethod
    def drawRose(a0: QtGui.QPainter, a1: QtGui.QPalette, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float, origin: float, width: float, numThorns: int, numThornLevels: int, shrinkFactor: float) -> None: ...
    def draw(self, a0: QtGui.QPainter, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float, north: float, a4: QtGui.QPalette.ColorGroup = ...) -> None: ...
    def shrinkFactor(self) -> float: ...
    def setShrinkFactor(self, factor: float) -> None: ...
    def numThornLevels(self) -> int: ...
    def setNumThornLevels(self, count: int) -> None: ...
    def numThorns(self) -> int: ...
    def setNumThorns(self, count: int) -> None: ...
    def width(self) -> float: ...
    def setWidth(self, w: float) -> None: ...


class QwtCompassScaleDraw(QwtRoundScaleDraw):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, map: typing.Any) -> None: ...

    def label(self, value: float) -> QwtText: ...
    def labelMap(self) -> typing.Any: ...
    def setLabelMap(self, map: typing.Any) -> None: ...


class QwtCompass(QwtDial):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None: ...
    def drawScaleContents(self, a0: QtGui.QPainter, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float) -> None: ...
    def drawRose(self, a0: QtGui.QPainter, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float, north: float, a4: QtGui.QPalette.ColorGroup) -> None: ...
    def rose(self) -> QwtCompassRose: ...
    def setRose(self, rose: QwtCompassRose) -> None: ...


class QwtPointPolar(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, azimuth: float, radius: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QwtPointPolar') -> None: ...
    @typing.overload
    def __init__(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...

    def normalized(self) -> 'QwtPointPolar': ...
    def setAzimuth(self, a0: float) -> None: ...
    def setRadius(self, a0: float) -> None: ...
    def azimuth(self) -> float: ...
    def radius(self) -> float: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def toPoint(self) -> QtCore.QPointF: ...
    def setPoint(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...


class QwtAnalogClock(QwtDial):

    class Hand(int): ...
    SecondHand = ... # type: 'QwtAnalogClock.Hand'
    MinuteHand = ... # type: 'QwtAnalogClock.Hand'
    HourHand = ... # type: 'QwtAnalogClock.Hand'
    NHands = ... # type: 'QwtAnalogClock.Hand'

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def drawHand(self, a0: QtGui.QPainter, a1: 'QwtAnalogClock.Hand', a2: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float, direction: float, a5: QtGui.QPalette.ColorGroup) -> None: ...
    def drawNeedle(self, a0: QtGui.QPainter, a1: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float, direction: float, a4: QtGui.QPalette.ColorGroup) -> None: ...
    def setTime(self, a0: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def setCurrentTime(self) -> None: ...
    def hand(self, a0: 'QwtAnalogClock.Hand') -> QwtDialNeedle: ...
    def setHand(self, a0: 'QwtAnalogClock.Hand', a1: QwtDialNeedle) -> None: ...
