# QORE_FOUND - system has qore installed
# QORE_INCLUDE_DIR - includes
# QORE_INCLUDE_DIRS - cmake standard alias for QORE_INCLUDE_DIR
# QORE_LIBRARY - library location
# QORE_LIBRARIES - cmake standard alias for QORE_LIBRARY
#
# QORE_MODULES_DIR - location of qore modules
# QORE_API_VERSION - API version
#
# QORE_EXECUTABLE - qore interpret executable
# QORE_QPP_EXECUTABLE - qore qpp executable


if (CMAKE_VERSION VERSION_LESS 2.8.3)
    message(FATAL_ERROR "Qore requires at least CMake version 2.8.3")
endif()

set(QORE_FOUND 1)

set(QORE_INCLUDE_DIR /usr/pkg/include)
set(QORE_INCLUDE_DIRS ${QORE_INCLUDE_DIR})

find_library(QORE_LIBRARY NAMES qore libqore HINTS "/usr/pkg/lib/")
set(QORE_LIBRARIES ${QORE_LIBRARY})

# allow the module directory to be overridden (for example, when cross-compiling)
if(DEFINED QORE_MODULE_DIR)
    set(QORE_MODULES_DIR ${QORE_MODULE_DIR})
else()
    set(QORE_MODULES_DIR /usr/pkg/lib/qore-modules)
endif()
# allow the module directory to be overridden (for example, when cross-compiling)
if(DEFINED QORE_USER_MODULE_DIR)
    set(QORE_USER_MODULES_DIR ${QORE_USER_MODULE_DIR})
else()
    set(QORE_USER_MODULES_DIR /usr/pkg/share/qore-modules)
endif()
# allow the module directory to be overridden (for example, when cross-compiling)
if(DEFINED QORE_USER_MODULE_VER_DIR)
    set(QORE_USER_MODULES_VER_DIR ${QORE_USER_MODULE_VER_DIR})
else()
    set(QORE_USER_MODULES_VER_DIR /usr/pkg/share/qore-modules/1.2.0)
endif()

set(QORE_API_VERSION 1.2)
set(QORE_USERMODULE_DOXYGEN_TEMPLATE /usr/pkg/share/qore/Doxyfile.in)

# allow the qore executable to be overridden (for example, when cross-compiling)
if(NOT DEFINED QORE_EXECUTABLE)
    set(QORE_EXECUTABLE /usr/pkg/bin/qore${CMAKE_EXECUTABLE_SUFFIX})
endif()
# allow the qpp executable to be overridden (for example, when cross-compiling)
if(DEFINED QPP_EXECUTABLE)
    set(QORE_QPP_EXECUTABLE ${QPP_EXECUTABLE})
else()
    set(QORE_QPP_EXECUTABLE /usr/pkg/bin/qpp${CMAKE_EXECUTABLE_SUFFIX})
endif()
set(QORE_QDX_EXECUTABLE /usr/pkg/bin/qdx)
# allow the qjar executable to be overridden
if(DEFINED QJAR_EXECUTABLE)
    set(QORE_QJAR_EXECUTABLE ${QJAR_EXECUTABLE})
else()
    set(QORE_QJAR_EXECUTABLE /usr/pkg/bin/qjar)
endif()

# warning: the same prefix for current qore is used if there is no
# CMAKE_INSTALL_PREFIX given
if (CMAKE_INSTALL_PREFIX_INITIALIZED_TO_DEFAULT)
    set(CMAKE_INSTALL_PREFIX /usr/pkg)
    message(STATUS "Using detected CMAKE_INSTALL_PREFIX: /usr/pkg")
endif (CMAKE_INSTALL_PREFIX_INITIALIZED_TO_DEFAULT)


if (NOT CMAKE_BUILD_TYPE)
    set(CMAKE_BUILD_TYPE "release")
endif (NOT CMAKE_BUILD_TYPE)
string(TOLOWER ${CMAKE_BUILD_TYPE} QORE_BUILD_TYPE_LWR)
if (${QORE_BUILD_TYPE_LWR} MATCHES "debug")
    add_definitions(-DDEBUG)
else ()
    add_definitions(-DNDEBUG)
endif ()


include("${CMAKE_CURRENT_LIST_DIR}/QoreMacros.cmake")
