;;;"elk.init" Initialisation file for SLIB for ELK 2.1	-*- Scheme -*-
;;; Copyright (C) 1991, 1992, 1993 Aubrey Jaffer.
;
;Permission to copy this software, to redistribute it, and to use it
;for any purpose is granted, subject to the following restrictions and
;understandings.
;
;1.  Any copy made of this software must include this copyright notice
;in full.
;
;2.  I have made no warrantee or representation that the operation of
;this software will be error-free, and I am under no obligation to
;provide any services, by way of maintenance, update, or otherwise.
;
;3.  In conjunction with products arising from the use of this
;material, there shall be no use of my name in any advertising,
;promotional, or sales literature without prior written consent in
;each case.

; No guarantees are given about the correctness of any of the
; choices made below.  Only enough work was done to get the require
; mechanism to work correctly.
;
; Stephen J. Bevan <bevan@cs.man.ac.uk> 19920912 modified by Mike
; Sperber to work correctly with statically-linked Elk and slib1d.  Be
; sure to change the library vicinities according to your local
; configuration.  If you're running MS-DOS (which is possible since
; 2.1), you probably have to change this file to make everything work
; correctly.

;;; (software-type) should be set to the generic operating system type.
;;; UNIX, VMS, MACOS, AMIGA and MS-DOS are supported.

(define (software-type) 'UNIX)

;;; (scheme-implementation-type) should return the name of the scheme
;;; implementation loading this file.

(define (scheme-implementation-type) 'elk)

;;; (scheme-implementation-version) should return a string describing
;;; the version the scheme implementation loading this file.

(define (scheme-implementation-version) "3.99.8")

;;; (implementation-vicinity) should be defined to be the pathname of
;;; the directory where any auxillary files to your Scheme
;;; implementation reside.

(define (implementation-vicinity) "/usr/pkg/share/elk")

;;; (library-vicinity) should be defined to be the pathname of the
;;; directory where files of Scheme library functions reside.

;(define library-vicinity
;  (let ((library-path
;	 (or (getenv "SCHEME_LIBRARY_PATH")
;	     ;; Uses this path if SCHEME_LIBRARY_PATH is not defined.
;	     (case (software-type)
;	       ((UNIX) "/usr/local/lib/slib/")
;	       ((VMS) "lib$scheme:")
;	       ((MS-DOS) "C:\\SLIB\\")
;	       (else "")))))
;    (lambda () library-path)))
(define (library-vicinity) "/usr/pkg/lib/slib/")

;;; *features* should be set to a list of symbols describing features
;;; of this implementation.  Suggestions for features are:

(define *features*
      '(
;	source				;can load scheme source files
					;(slib:load-source "filename")
;	compiled			;can load compiled files
					;(slib:load-compiled "filename")
	rev4-report
	ieee-p1178
	sicp
	rev4-optional-procedures
	rev3-procedures
	rev2-procedures
	multiarg/and-
	multiarg-apply
	delay
	transcript
	full-continuation
;	sort
	format
	system
;	getenv <------- does elk 3.0 really have getenv? couldn't find it
	program-arguments
	string-port
	))

;------------

(define program-arguments
  (lambda ()
    (cons "undefined-program-name" (command-line-args))))

; EXACT? appears to always return #f which isn't very useful.
; Approximating it with INTEGER? at least means that some
; of the code in the library will work correctly

(define exact? integer?)  ; WARNING: redefining EXACT?

(define (inexact? arg)
  (not (exact? arg)))

;;; (TMPNAM) makes a temporary file name.
(define tmpnam
  (let ((cntr 100))
    (lambda () (set! cntr (+ 1 cntr))
	    (let ((tmp (string-append "slib_" (number->string cntr))))
	      (if (file-exists? tmp) (tmpnam) tmp)))))

(require 'unix)

; Pull in GENTENV and SYSTEM

;;; (FILE-EXISTS? <string>) already here.

;;; (DELETE-FILE <string>)
(define (delete-file f) (system (string-append "rm " f)))

;------------

;;; (OUTPUT-PORT-WIDTH <port>)
(define (output-port-width . arg) 79)

;;; (OUTPUT-PORT-HEIGHT <port>)
(define (output-port-height . arg) 24)

;;; (CURRENT-ERROR-PORT)
;;; is already defined in Elk 2.1

;;; FORCE-OUTPUT flushes any pending output on optional arg output port
;;; use this definition if your system doesn't have such a procedure.
(define force-output flush-output-port)

;;; CALL-WITH-INPUT-STRING and CALL-WITH-OUTPUT-STRING are the string
;;; port versions of CALL-WITH-*PUT-FILE.
(define (call-with-output-string f)
  (let ((outsp (open-output-string)))
    (f outsp)
    (let ((s (get-output-string outsp)))
      (close-output-port outsp)
      s)))

(define (call-with-input-string s f)
  (let* ((insp (open-input-string s))
	 (res (f insp)))
    (close-input-port insp)
    res))

;;; CHAR-CODE-LIMIT is one greater than the largest integer which can
;;; be returned by CHAR->INTEGER.
(define char-code-limit 256)

;;; MOST-POSITIVE-FIXNUM is used in modular.scm
(define most-positive-fixnum 8388608)  ; 23 bit integers ?

;;; Return argument
(define (identity x) x)

;;; If your implementation provides eval SLIB:EVAL is single argument
;;; eval using the top-level (user) environment.
(define slib:eval eval)

(define *macros* '())
(define (defmacro? m) (and (assq m *macros*) #t))

(define-macro (defmacro key pattern . body)
  `(begin
     (define-macro ,(cons key pattern) ,@body)
     (set! *macros* (cons (cons ',key (lambda ,pattern ,@body)) *macros*))))

(define (macroexpand-1 e)
  (if (pair? e) (let ((a (car e)))
		  (cond ((symbol? a) (set! a (assq a *macros*))
				     (if a (apply (cdr a) (cdr e)) e))
			(else e)))
      e))

(define (macroexpand e)
  (if (pair? e) (let ((a (car e)))
		  (cond ((symbol? a)
			 (set! a (assq a *macros*))
			 (if a (macroexpand (apply (cdr a) (cdr e))) e))
			(else e)))
      e))

(define gentemp
  (let ((*gensym-counter* -1))
    (lambda ()
      (set! *gensym-counter* (+ *gensym-counter* 1))
      (string->symbol
       (string-append "slib:G" (number->string *gensym-counter*))))))

(define defmacro:eval slib:eval)
(define defmacro:load load)
;;; If your implementation provides R4RS macros:
;(define macro:eval slib:eval)
;(define macro:load load)

(define (slib:eval-load <pathname> evl)
  (if (not (file-exists? <pathname>))
      (set! <pathname> (string-append <pathname> (scheme-file-suffix))))
  (call-with-input-file <pathname>
    (lambda (port)
      (let ((old-load-pathname *load-pathname*))
	(set! *load-pathname* <pathname>)
	(do ((o (read port) (read port)))
	    ((eof-object? o))
	  (evl o))
	(set! *load-pathname* old-load-pathname)))))

;;; define an error procedure for the library
(define slib:error error)

;;; define these as appropriate for your system.
(define slib:tab #\tab)
(define slib:form-feed #\formfeed)

;;; Define these if your implementation's syntax can support it and if
;;; they are not already defined.

;(define (1+ n) (+ n 1))
;(define (-1+ n) (+ n -1))
;(define 1- -1+)

(define in-vicinity string-append)

;;; Define SLIB:EXIT to be the implementation procedure to exit or
;;; return if exitting not supported.
(define slib:exit
  (lambda args
    (exit (cond ((null? args) 0)
		((eqv? #t (car args)) 0)
		((and (number? (car args)) (integer? (car args))) (car args))
		(else 1)))))

;;; Here for backward compatability
(define scheme-file-suffix
  (let ((suffix (case (software-type)
		  ((NOSVE) "_scm")
		  (else ".scm"))))
    (lambda () suffix)))

;;; (SLIB:LOAD-SOURCE "foo") should load "foo.scm" or with whatever
;;; suffix all the module files in SLIB have.  See feature 'SOURCE.

; Modify the already modified _load_ so that it copes with
; environments correctly.  The change involves using
; _(global-environment)_ if none is explicitly specified.
; If this is not done, definitions in files loaded by other files will
; not be loaded in the correct environment.

(define slib:load-source
  (let ((primitive-load load))
    (lambda (<pathname> . rest)
      (let ((env (if (null? rest) (list (global-environment)) rest)))
	(apply primitive-load (string-append <pathname> ".scm") env)))))

;;; (SLIB:LOAD-COMPILED "foo") should load the file that was produced
;;; by compiling "foo.scm" if this implementation can compile files.
;;; See feature 'COMPILED.

(define slib:load-compiled
  (let ((primitive-load load))
    (lambda (<pathname> . rest)
      (apply primitive-load (string->symbol (string-append name ".o")) rest))))

;;; At this point SLIB:LOAD must be able to load SLIB files.

(define slib:load slib:load-source)	;WARNING: redefining LOAD

(slib:load (in-vicinity (library-vicinity) "require"))
