# Copyright (c) 2017, Tomohiro Kusumi
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this
#    list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import re

from . import log
from . import nodep
from . import unix # not kernel to prevent circular import

def __execute_objdump(*args):
    assert not nodep.is_windows(), "Windows unsupported"
    cmd = ["objdump"]
    cmd.extend(*args)
    return unix.execute(*cmd)

def get_elf_section_info(f, section):
    args = "-h", "-j", section, f
    ret = __execute_objdump(args)
    if ret.retval:
        log.error("Failed to execute objdump {0}".format(args))
        return

    pattern = r"^\s+[0-9]+\s+{0}\s+(\S+)\s+(\S+)".format(section)
    start = False

    for l in ret.stdout.split("\n"):
        if l.startswith("Idx Name"):
            start = True
            continue
        if not start:
            continue
        m = re.match(pattern, l)
        if m:
            length = int(m.group(1), 16)
            offset = int(m.group(2), 16)
            return offset, length
