# Copyright (c) 2013, Tomohiro Kusumi
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this
#    list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# RELEASE is basically always 1.
# It was added only to sync with RPM versioning.
# Everytime a batch of new commits is pushed to GitHub, MINOR2 gets incremented.
# RPM patches within the same fileobj version may or may not increment RELEASE.

MAJOR = 0
MINOR1 = 7
MINOR2 = 108
RELEASE = 1

def get_version():
    return MAJOR, MINOR1, MINOR2

def get_release():
    return MAJOR, MINOR1, MINOR2, RELEASE

def get_version_string():
    return "{0}.{1}.{2}".format(*get_version())

def get_release_string():
    return "{0}.{1}.{2}-{3}".format(*get_release())

def get_tag_string():
    return "v" + get_version_string()

try:
    __version__ = get_version_string()
except Exception:
    __version__ = "???" # .format() unsupported
