/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2022 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
var Dashboard={grid:null,elem_id:"",element:null,elem_dom:null,rand:null,interval:null,current_name:null,markdown_editors:[],all_cards:[],all_widgets:[],edit_mode:false,embed:false,ajax_cards:false,context:"core",markdown_contents:[],dash_width:0,cell_margin:3,cols:26,cache_key:"",filters:"{}",display:function(a){var e=this;var t=typeof a!=="undefined"?a:{};var r={cols:24,rows:24,cell_length:40,cell_margin:5,rand:"",embed:false,ajax_cards:true,all_cards:[],context:"core"};t=Object.assign({},r,t);this.rand=t.rand;this.elem_id="#dashboard-"+t.rand;this.element=$(Dashboard.elem_id);this.elem_dom=Dashboard.element[0];this.current_name=$(this.elem_id+" .dashboard_select").val()||t.current;this.embed=t.embed;this.ajax_cards=t.ajax_cards;this.all_cards=t.all_cards;this.all_widgets=t.all_widgets;this.context=t.context;this.dash_width=this.element.width();this.cell_margin=t.cell_margin;this.cols=t.cols;this.cache_key=t.cache_key||"";var d=this.elem_dom.getBoundingClientRect();var i=d.left+(window.innerWidth-d.right)+.02;Dashboard.grid=GridStack.init({column:t.cols,maxRow:t.rows+1,margin:this.cell_margin,float:true,animate:false,draggable:{cancel:"textarea"},minWidth:768-i});Dashboard.grid.setStatic(true);Dashboard.generateCss();Dashboard.initFilters();Dashboard.refreshDashboard();if(Dashboard.ajax_cards){Dashboard.getCardsAjax()}if(!Dashboard.ajax_cards){Dashboard.fitNumbers();Dashboard.animateNumbers()}$("#dashboard-"+t.rand+" .toolbar .dashboard_select").change((function(){Dashboard.current_name=$(this).val();var a=$(this).find("option:selected").text();$(".dashboard-name").val(a);Dashboard.refreshDashboard();Dashboard.setLastDashboard();Dashboard.initFilters()}));$("#dashboard-"+t.rand+" .toolbar .add-dashboard").click((function(){Dashboard.addForm()}));$(document).on("submit",".display-add-dashboard-form",(function(a){a.preventDefault();glpi_close_all_dialogs();var e=$(this);var t={};$.each(e.closest(".display-add-dashboard-form").serializeArray(),(function(){t[this.name]=this.value}));Dashboard.addNew(t)}));$("#dashboard-"+t.rand+" .toolbar .delete-dashboard").click((function(){Dashboard.delete()}));$("#dashboard-"+t.rand+" .toolbar .clone-dashboard").click((function(){Dashboard.clone()}));$("#dashboard-"+t.rand+" .toolbar .open-embed").click((function(){glpi_ajax_dialog({title:__("Share or embed this dashboard"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"display_embed_form",dashboard:Dashboard.current_name}})}));$("#dashboard-"+t.rand+" .toolbar .edit-dashboard").click((function(){var a=!$(this).hasClass("active");Dashboard.setEditMode(a)}));var s="#dashboard-"+t.rand+" .toggle-fullscreen";$(s).click((function(){Dashboard.toggleFullscreenMode($(this))}));$(document).on("fullscreenchange webkitfullscreenchange mozfullscreenchange MSFullscreenChange",(function(){if(!document.webkitIsFullScreen&&!document.mozFullScreen&&!document.msFullscreenElement!==null){Dashboard.disableFullscreenMode()}}));$("#dashboard-"+t.rand+" .toolbar .night-mode").click((function(){$(this).toggleClass("active");Dashboard.element.toggleClass("theme-dark")}));$("#dashboard-"+t.rand+" .toolbar .auto-refresh").click((function(){$(this).toggleClass("active");var a=$(this).hasClass("active");if(a){var e=parseInt(CFG_GLPI.refresh_views);if(e==0||Number.isNaN(e)){e=30}var t=e*60;Dashboard.interval=setInterval((function(){Dashboard.refreshDashboard()}),t*1e3)}else{clearInterval(Dashboard.interval)}}));var o;$(window).on("resize",(function(a){if(a.target.constructor.name!=="Window"){return}window.clearTimeout(o);o=window.setTimeout((function(){Dashboard.generateCss();Dashboard.fitNumbers()}),200)}));$(document).on("click",".display-rights-form .save_rights",(function(){glpi_close_all_dialogs();var a=$(this);var e={};var t;$.each(a.closest(".display-rights-form").serializeArray(),(function(){var a=this.value.split("-");var t=a[0];var r=a[1];if(!(t in e)){e[t]=[]}e[t].push(r)}));t=a.closest(".display-rights-form").find('select[name="is_private"]').val();$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"save_rights",dashboard:Dashboard.current_name,rights:e,is_private:t}})}));Dashboard.grid.on("dragstop",(function(){Dashboard.saveDashboard()}));Dashboard.grid.on("resizestop",(function(a,t){Dashboard.saveDashboard();var r=$(t).find(".ct-chart");if(r.length>0){r[0].__chartist__.update()}e.resetComputedWidth($("body").find(".big-number").find(".formatted-number"));e.resetComputedWidth($("body").find(".big-number").find(".label"));Dashboard.fitNumbers($(t));Dashboard.animateNumbers($(t))}));$(document).on("click","#dashboard-"+t.rand+" .delete-item",(function(){var a=$(this);var e=a.closest(".grid-stack-item")[0];Dashboard.grid.removeWidget(e);Dashboard.saveDashboard()}));$(document).on("click","#dashboard-"+t.rand+" .refresh-item",(function(){var a=$(this);var e=a.closest(".grid-stack-item");var t=e.attr("gs-id");Dashboard.getCardsAjax("[gs-id="+t+"]")}));$(document).on("click","#dashboard-"+t.rand+" .edit-item",(function(){var a=$(this);var e=a.parent().parent(".grid-stack-item");var t=e.data("card-options");glpi_ajax_dialog({title:__("Edit this card"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"display_edit_widget",gridstack_id:e.attr("gs-id"),card_id:t.card_id,x:e.attr("gs-x"),y:e.attr("gs-y"),width:e.attr("gs-w"),height:e.attr("gs-h"),card_options:t}})}));$(document).on("click","#dashboard-"+t.rand+" .cell-add",(function(){var a=$(this);glpi_ajax_dialog({title:__("Add a card"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"display_add_widget",x:a.data("x"),y:a.data("y")}})}));$(document).on("submit",".display-widget-form ",(function(a){a.preventDefault();Dashboard.setWidgetFromForm($(this))}));$(document).on("click","#dashboard-"+t.rand+" .filters_toolbar .add-filter",(function(){glpi_close_all_dialogs();var a=Dashboard.getFiltersFromDB();var e=Object.keys(a);glpi_ajax_dialog({title:__("Add a filter"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"display_add_filter",used:e}})}));$(document).on("submit",".display-filter-form ",(function(a){a.preventDefault();var e=$(this);Dashboard.setFilterFromForm(e)}));$(document).on("click","#dashboard-"+t.rand+" .filters_toolbar .delete-filter",(function(){var a=$(this).closest(".filter");var e=a.data("filter-id");a.remove();var t=Dashboard.getFiltersFromDB();delete t[e];Dashboard.setFiltersInDB(t);Dashboard.refreshCardsImpactedByFilter(e)}));$(document).on("click",".save-dashboard-name ",(function(a){a.preventDefault();$(".dashboard_select option[value="+Dashboard.current_name+"]").text($(".dashboard-name").val());Dashboard.saveDashboard();$(".display-message").addClass("success").text(__("Saved")).show("fade").delay(2e3).hide("fade")}));$(document).on("select2:select",".display-widget-form select[name=card_id]",(function(a){var e=a.params.data;var t=e.id;var r=$(this).closest(".display-widget-form").find(".widgettype_field");var d=Dashboard.all_cards[t].widgettype;var i=d.length===1;r.show().find("input[type=radio]").next("label").css("display","none").end().filter("[value='"+d.join("'],[value='")+"']").prop("checked",i).trigger("change").next("label").css("display","inline-block")}));$(document).on("change",".display-widget-form [name=widgettype]",(function(){var a=$(this);var e=a.val();var t=Dashboard.all_widgets[e];var r=t.gradient||false;var d=t.pointlbl||false;var i=t.limit||false;var s=t.width||2;var o=t.height||2;var n=a.closest(".display-widget-form");n.find(".gradient_field").toggle(r);n.find(".pointlbl_field").toggle(d);n.find(".limit_field").toggle(i);var l=n.find('[name="width"]');var c=n.find('[name="height"]');if(l.val()==0){l.val(s)}if(c.val()==0){c.val(o)}}));$(document).on("input",".card.markdown textarea.markdown_content",(function(){Dashboard.saveMarkdown($(this))}));$(window).on("resize.fittext",(function(){e.computeWidth($("body").find(".big-number").find(".formatted-number"));e.computeWidth($("body").find(".big-number").find(".label"))}))},saveMarkdown:function(a){var e=a.closest(".grid-stack-item");var t=a.val();var r=e.attr("gs-id");e.addClass("dirty");Dashboard.markdown_contents[r]=t},setWidgetFromForm:function(a){glpi_close_all_dialogs();var e={};$.each(a.serializeArray(),(function(){e[this.name]=this.value}));if(e.card_id==="0"){return false}e.card_options=e.card_options||{};if(typeof e.card_options==="string"){e.card_options=JSON.parse(e.card_options)}var t="old_id"in e&&e.old_id.length>0;e.card_options.color=e.color||null;e.card_options.widgettype=e.widgettype||null;e.card_options.use_gradient=e.use_gradient||0;e.card_options.point_labels=e.point_labels||0;e.card_options.limit=e.limit||7;if(e.card_id==="markdown_editable"&&!("markdown_content"in e.card_options)){e.card_options.markdown_content=""}if(t===true){if(e.old_id==="0"){return false}var r=$(".grid-stack-item[gs-id="+e.old_id+"]")[0];Dashboard.grid.removeWidget(r)}var d=getUuidV4();e.gridstack_id=e.card_id+"_"+d;e.card_options.card_id=e.card_id;e.card_options.gridstack_id=e.gridstack_id;var i=e.card_options;i.force=true;var s=Dashboard.addWidget(e);$.get({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"get_card",dashboard:Dashboard.current_name,card_id:e.card_id,cache_key:Dashboard.cache_key,args:i}}).done((function(a){s.children(".grid-stack-item-content").append(a);Dashboard.fitNumbers(s);Dashboard.animateNumbers(s);Dashboard.saveDashboard()}))},addWidget:function(a){var e=a.gridstack_id;var t=parseInt(a.x||-1);var r=parseInt(a.y||-1);var d=parseInt(a.width||2);var i=parseInt(a.height||2);var s=a.card_options||{};var o='       <div class="grid-stack-item">          <span class="controls">             <i class="refresh-item ti ti-refresh" title="'+__("Refresh this card")+'"></i>             <i class="edit-item ti ti-edit" title="'+__("Edit this card")+'"></i>             <i class="delete-item ti ti-x" title="'+__("Delete this card")+'"></i>          </span>          <div class="grid-stack-item-content">          </div>       </div>';var n=Dashboard.grid.addWidget(o,{x:t,y:r,w:d,h:i,autoPosition:t<0||r<0,id:e});$(n).attr("data-card-options",JSON.stringify(s));return $(n)},setFilterFromForm:function(a){glpi_close_all_dialogs();var e={};$.each(a.serializeArray(),(function(){e[this.name]=this.value}));$.get({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"get_filter",filter_id:e.filter_id}}).done((function(a){$(".filters").append(a);Dashboard.saveFilter(e.filter_id,[])}))},refreshDashboard:function(){var a=$(Dashboard.elem_id+" .grid-stack");Dashboard.grid.removeAll();$.get({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{dashboard:Dashboard.current_name,action:"get_dashboard_items",embed:Dashboard.embed?1:0}}).done((function(e){a.prepend(e);a.find(".grid-stack-item").each((function(){Dashboard.grid.makeWidget($(this)[0])}));if(Dashboard.ajax_cards){Dashboard.getCardsAjax()}}))},setLastDashboard:function(){$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{dashboard:Dashboard.current_name,page:(location.origin+location.pathname).replace(CFG_GLPI.url_base,""),action:"set_last_dashboard"}})},saveFilter:function(a,e){var t=Dashboard.getFiltersFromDB();t[a]=e;Dashboard.setFiltersInDB(t);sortable(".filters","reload");Dashboard.refreshCardsImpactedByFilter(a)},refreshCardsImpactedByFilter:function(a){$(".dashboard .card.filter-"+a).each((function(){var a=$(this).closest(".grid-stack-item");var e=a.attr("gs-id");Dashboard.getCardsAjax("[gs-id="+e+"]")}))},saveDashboard:function(a){a=a|false;var e=$.makeArray(Dashboard.element.find(".grid-stack-item:visible:not(.grid-stack-placeholder)")).map((function(a){var e=$(a).attr("gs-id");var t=$(a).data("card-options");if(_.keys(Dashboard.markdown_contents).length>0&&e in Dashboard.markdown_contents){t.markdown_content=Dashboard.markdown_contents[e]}return e?{gridstack_id:$(a).attr("gs-id"),card_id:t.card_id,x:$(a).attr("gs-x"),y:$(a).attr("gs-y"),width:$(a).attr("gs-w"),height:$(a).attr("gs-h"),card_options:t}:null}));$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"save_items",dashboard:Dashboard.current_name,items:e,title:$(".dashboard-name").val()}}).done((function(){if(a){Dashboard.refreshDashboard()}}))},computeWidth:function(a){a.each((function(){var a=$(this).parent().parent().width();var e=$(this).parent().parent().height();if(a>e){var t=.35;var r=e/t;var d=r/a*100;var i=d/2;$(this).css("width",i+"%")}}))},resetComputedWidth:function(a){a.each((function(){$(this).css("width","100%")}))},fitNumbers:function(a){a=a||$("body");var e=1.16;if(this.dash_width<=700||$(this.grid.el).hasClass("grid-stack-one-column-mode")){e=1.8}this.computeWidth(a.find(".big-number").find(".formatted-number"));this.computeWidth(a.find(".big-number").find(".label"));a.find(".big-number").find(".formatted-number").fitText(e);a.find(".summary-numbers").find(".formatted-number").fitText(e-.65);a.find(".summary-numbers").find(".line .label").fitText(e-.2);a.find(".big-number").find(".label").fitText(e-.2,{minFontSize:"12px"});this.resetComputedWidth(a.find(".big-number").find(".formatted-number"));this.resetComputedWidth(a.find(".big-number").find(".label"))},animateNumbers:function(a){a=a||$("body");a.find(".multiple-numbers, .summary-numbers, .big-number").find(".formatted-number").each((function(){var a=$(this);var e=a.data("precision");var t=a.children(".number");var r=a.children(".suffix").text();var d=t.text();if(isNaN(t.text())){return true}jQuery({Counter:0}).animate({Counter:t.text()},{duration:800,easing:"swing",step:function(){t.text(this.Counter.toFixed(e))+r},complete:function(){t.text(d)+r}})}))},setEditMode:function(a){Dashboard.edit_mode=typeof a=="undefined"?true:a;var e=$(Dashboard.elem_id+" .toolbar .edit-dashboard");e.toggleClass("active",a);Dashboard.element.toggleClass("edit-mode",a);Dashboard.grid.setStatic(!a);sortable(".filters",a?"enable":"disable");if(!Dashboard.edit_mode){var t=$(".grid-stack-item.dirty");if(t.length>0){Dashboard.saveDashboard(true)}}},toggleFullscreenMode:function(a){var e=!a.hasClass("active");Dashboard.element.toggleClass("fullscreen").find(".night-mode").toggle(e);a.toggleClass("active");if(e){Dashboard.setEditMode(false)}if(e){GoInFullscreen(Dashboard.elem_dom)}else{GoOutFullscreen()}},disableFullscreenMode:function(){Dashboard.element.removeClass("fullscreen").find(".night-mode").hide().end().find(".toggle-fullscreen").removeClass("active");GoOutFullscreen()},clone:function(){$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{dashboard:Dashboard.current_name,action:"clone_dashboard"},dataType:"json"}).done((function(a){Dashboard.addNewDashbardInSelect(a.title,a.key)}))},delete:function(){var a=__("Are you sure you want to delete the dashboard %s ?").replace("%s",Dashboard.current_name);if(window.confirm(a,__("Delete this dashboard"))){$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"delete_dashboard",dashboard:Dashboard.current_name}}).done((function(){$("#dashboard-"+Dashboard.rand+" .toolbar .dashboard_select").find("option[value='"+Dashboard.current_name+"']").remove().end().prop("selectedIndex",0).trigger("change")}))}},addForm:function(){glpi_ajax_dialog({title:__("Add a new dashboard"),url:CFG_GLPI.root_doc+"/ajax/dashboard.php",params:{action:"add_new"}})},addNew:function(a){$.post({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"save_new_dashboard",title:a.title,context:Dashboard.context}}).done((function(e){Dashboard.addNewDashbardInSelect(a.title,e);Dashboard.setEditMode(true)}))},addNewDashbardInSelect:function(a,e){var t=new Option(a,e,false,true);$("#dashboard-"+Dashboard.rand+" .toolbar .dashboard_select").append(t).trigger("change")},getCardsAjax:function(a){a=a||"";var e=Dashboard.getFiltersFromDB();let t=[];let r=[];$(".grid-stack-item:not(.lock-bottom)"+a).each((function(){var d=$(this);var i=d.data("card-options");var s=d.attr("gs-id");var o=i.card_id||d.attr("gs-id");i.gridstack_id=s;if("markdown_content"in i){Dashboard.markdown_contents[s]=i.markdown_content}i.apply_filters=e;r.push({card_id:o,force:a.length>0?1:0,args:i,c_cache_key:i.cache_key||""});t.push({card_el:d,card_id:o})}));return $.ajax({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",method:"POST",data:{action:"get_cards",data:JSON.stringify({dashboard:Dashboard.current_name,force:a.length>0?1:0,embed:Dashboard.embed?1:0,d_cache_key:Dashboard.cache_key,cards:r})}}).then((function(a){$.each(t,((e,t)=>{let r=false;const d=t.card_el;$.each(a,((a,e)=>{if(t.card_id===a){const a=e;r=true;d.children(".grid-stack-item-content").html(a);Dashboard.fitNumbers(d);Dashboard.animateNumbers(d)}}));if(!r){d.html("<div class='empty-card card-error'><i class='fas fa-exclamation-triangle'></i></div>")}}))})).fail((function(){$.each(t,((a,e)=>{const t=e.card_el;t.html("<div class='empty-card card-error'><i class='fas fa-exclamation-triangle'></i></div>")}))}))},easter:function(){var a=$(Dashboard.elem_id+" .grid-stack .grid-stack-item .card");setInterval((function(){var e="#"+((1<<24)*Math.random()|0).toString(16);var t=Math.floor(Math.random()*a.length)+1;var r=a[t];$(r).css("background-color",e)}),10)},generateCss:function(){var a=Math.floor(this.element.width());var e=a/this.cols;var t=e;var r=a/this.cols;var d=100/this.cols;var i="       "+this.elem_id+" .cell-add {          width: "+e+"px;          height: "+r+"px;       }       "+this.elem_id+" .grid-guide {          background-size: "+e+"px "+r+"px;          bottom: "+r+"px;       }";for(var s=0;s<this.cols;s++){var o=s*d;var n=(s+1)*d;i+=this.elem_id+" .grid-stack > .grid-stack-item[gs-x='"+s+"'] {             left: "+o+"%;          }          "+this.elem_id+" .grid-stack > .grid-stack-item[gs-w='"+(s+1)+"'] {             min-width: "+d+"%;             width: "+n+"%;          }"}$("#gs_inline_css_"+this.rand).remove();if(a>700){$("<style id='gs_inline_css_"+this.rand+"'></style>").prop("type","text/css").html(i).appendTo("head")}else{t=60}this.grid.cellHeight(t)},initFilters:function(){if($(".filters").length===0){return}var a=Dashboard.getFiltersFromDB();$.each(a,(function(e,t){if(Array.isArray(t)&&t.length==0){a[e]=""}}));$.get({url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"get_dashboard_filters",filters:a}}).done((function(a){$(".filters").html(a);$(document).trigger("glpiDasbhoardInitFilter");sortable(".filters",{placeholderClass:"filter-placeholder",orientation:"horizontal"})[0].addEventListener("sortupdate",(function(a){var e=$(a.detail.destination.items).filter(".filter");var t=Dashboard.getFiltersFromDB();var r={};$.each(e,(function(){var a=$(this).data("filter-id");r[a]=t[a]}));Dashboard.setFiltersInDB(r)}));sortable(".filters","disable")}))},getFiltersFromDB:function(){var a;$.ajax({method:"GET",url:CFG_GLPI.root_doc+"/ajax/dashboard.php",async:false,data:{action:"get_filter_data",dashboard:Dashboard.current_name}}).done((function(e){try{a=JSON.parse(e)}catch(e){a=JSON.parse("{}")}}));return a},setFiltersInDB:function(a){var e=[];if(Dashboard.current_name.length>0){e[Dashboard.current_name]=a}$.ajax({method:"POST",url:CFG_GLPI.root_doc+"/ajax/dashboard.php",data:{action:"save_filter_data",dashboard:Dashboard.current_name,filters:JSON.stringify(e[Dashboard.current_name],(function(a,e){return e===undefined?null:e}))}})}};