############################################################################
# decafConfig.cmake
# Copyright (C) 2017  Belledonne Communications, Grenoble France
#
############################################################################
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
############################################################################
#
# Config file for the decaf package.
# It defines the following variables:
#
#  DECAF_FOUND - system has decaf
#  DECAF_INCLUDE_DIRS - the decaf include directory
#  DECAF_LIBRARIES - The libraries needed to use decaf
#  DECAF_CPPFLAGS - The compilation flags needed to use decaf


if(ON)
	set(DECAF_TARGETNAME decaf)
	set(DECAF_LIBRARIES ${DECAF_TARGETNAME})
else()
	set(DECAF_TARGETNAME decaf-static)
	if(TARGET ${DECAF_TARGETNAME})
		get_target_property(DECAF_LIBRARIES ${DECAF_TARGETNAME} LOCATION)
		get_target_property(DECAF_LINK_LIBRARIES ${DECAF_TARGETNAME} INTERFACE_LINK_LIBRARIES)
		if(DECAF_LINK_LIBRARIES)
			list(APPEND DECAF_LIBRARIES ${DECAF_LINK_LIBRARIES})
		endif()
	endif()
endif()
get_target_property(DECAF_INCLUDE_DIRS ${DECAF_TARGETNAME} INTERFACE_INCLUDE_DIRECTORIES)
list(INSERT DECAF_INCLUDE_DIRS 0 "/usr/pkg/include")
list(REMOVE_DUPLICATES DECAF_INCLUDE_DIRS)

set(DECAF_CPPFLAGS )
set(DECAF_FOUND 1)
