/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AnimManager;
import com.xerox.VTM.engine.CAnimation;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import java.util.Date;

class CTransZoom
extends CAnimation {
    float[] zsteps;
    LongPoint[] tsteps;

    CTransZoom(Camera c, AnimManager mgr, long d) {
        this.started = false;
        this.target = c;
        this.parent = mgr;
        this.duration = d;
        this.type = "both";
    }

    void start() {
        this.now = new Date();
        this.startTime = this.now.getTime();
        this.started = true;
    }

    void animate() {
        if (this.started) {
            this.now = new Date();
            this.progression = (double)(this.now.getTime() - this.startTime) / (double)this.duration;
            this.step = (int)Math.round((double)this.zsteps.length * this.progression);
            if (this.step < this.zsteps.length) {
                this.target.setAltitude(this.zsteps[this.step]);
                this.target.posx = this.tsteps[this.step].x;
                this.target.posy = this.tsteps[this.step].y;
                this.target.updatePrecisePosition();
                if (this.step > 0) {
                    this.target.propagateMove(this.tsteps[this.step].x - this.tsteps[this.step - 1].x, this.tsteps[this.step].y - this.tsteps[this.step - 1].y);
                }
            } else {
                this.target.setAltitude(this.zsteps[this.zsteps.length - 1]);
                this.target.posx = this.tsteps[this.tsteps.length - 1].x;
                this.target.posy = this.tsteps[this.tsteps.length - 1].y;
                this.target.updatePrecisePosition();
                if (this.step > 1) {
                    this.target.propagateMove(this.tsteps[this.tsteps.length - 1].x - this.tsteps[this.tsteps.length - 2].x, this.tsteps[this.tsteps.length - 1].y - this.tsteps[this.tsteps.length - 2].y);
                }
                this.parent.killCAnim(this, this.type);
            }
        }
    }

    protected void conclude() {
        this.target.setAltitude(this.zsteps[this.zsteps.length - 1]);
        this.target.posx = this.tsteps[this.tsteps.length - 1].x;
        this.target.posy = this.tsteps[this.tsteps.length - 1].y;
        this.target.updatePrecisePosition();
        if (this.tsteps.length > 1) {
            this.target.propagateMove(this.tsteps[this.tsteps.length - 1].x - this.tsteps[this.tsteps.length - 2].x, this.tsteps[this.tsteps.length - 1].y - this.tsteps[this.tsteps.length - 2].y);
        }
    }

    public void postAnimAction() {
        if (this.paa != null) {
            this.paa.animationEnded(this.target, (short)1, "both");
        }
    }
}

