#!/usr/pkg/bin/perl
#
# DO NOT ALTER THIS FILE
# IT IS WRITTEN BY Makefile.PL and inst/netsymbols.pl
# EDIT THOSE INSTEAD
#
package Net::Interface::NetSymbols;
use vars qw($VERSION @EXPORT_OK %EXPORT_TAGS);

$VERSION = 1.01;

my @afs = qw(
	AF_UNSPEC
	AF_LOCAL
	AF_UNIX
	AF_FILE
	AF_INET
	AF_AX25
	AF_IPX
	AF_APPLETALK
	AF_X25
	AF_INET6
	AF_ROSE
	AF_DECnet
	AF_PACKET
	AF_ROUTE
	AF_ASH
	AF_ECONET
	AF_MAX
);
my @pfs = qw(
	PF_UNSPEC
	PF_FILE
	PF_UNIX
	PF_LOCAL
	PF_INET
	PF_AX25
	PF_IPX
	PF_APPLETALK
	PF_X25
	PF_INET6
	PF_ROSE
	PF_DECnet
	PF_ROUTE
	PF_PACKET
	PF_ASH
	PF_ECONET
	PF_MAX
);
my @ifs = qw(
	IFF_POINTOPOINT
	IFF_UP
	IF_NAMESIZE
	IFF_MULTICAST
	IFF_AUTOMEDIA
	IFF_PORTSEL
	IFF_NOARP
	IFF_ALLMULTI
	IFF_MASTER
	IFF_DYNAMIC
	IFF_BROADCAST
	IFHWADDRLEN
	IFF_PROMISC
	IFF_SLAVE
	IFF_LOOPBACK
	IFF_DEBUG
	IFNAMSIZ
	IFF_NOTRAILERS
	IFF_RUNNING
);
my @iffs = qw(
	IFF_ALLMULTI
	IFF_AUTOMEDIA
	IFF_BROADCAST
	IFF_DEBUG
	IFF_DYNAMIC
	IFF_LOOPBACK
	IFF_MASTER
	IFF_MULTICAST
	IFF_NOARP
	IFF_NOTRAILERS
	IFF_POINTOPOINT
	IFF_PORTSEL
	IFF_PROMISC
	IFF_RUNNING
	IFF_SLAVE
	IFF_UP
);
my @iffIN6 = qw(
);
my %unique = (
	0	=> 'PF_UNSPEC',
	1	=> 'PF_LOCAL',
	2	=> 'PF_INET',
	3	=> 'PF_AX25',
	4	=> 'PF_IPX',
	5	=> 'PF_APPLETALK',
	9	=> 'PF_X25',
	10	=> 'PF_INET6',
	11	=> 'PF_ROSE',
	12	=> 'PF_DECnet',
	17	=> 'PF_PACKET',
	18	=> 'PF_ASH',
	19	=> 'PF_ECONET',
	46	=> 'PF_MAX',
);

my @iftype = qw(
    IPV6_ADDR_ANY
    IPV6_ADDR_UNICAST
    IPV6_ADDR_MULTICAST
    IPV6_ADDR_ANYCAST
    IPV6_ADDR_LOOPBACK
    IPV6_ADDR_LINKLOCAL
    IPV6_ADDR_SITELOCAL
    IPV6_ADDR_COMPATv4
    IPV6_ADDR_SCOPE_MASK
    IPV6_ADDR_MAPPED
    IPV6_ADDR_RESERVED
    IPV6_ADDR_ULUA
    IPV6_ADDR_6TO4
    IPV6_ADDR_6BONE
    IPV6_ADDR_AGU
    IPV6_ADDR_UNSPECIFIED
    IPV6_ADDR_SOLICITED_NODE
    IPV6_ADDR_ISATAP
    IPV6_ADDR_PRODUCTIVE
    IPV6_ADDR_6TO4_MICROSOFT
    IPV6_ADDR_TEREDO
    IPV6_ADDR_ORCHID
    IPV6_ADDR_NON_ROUTE_DOC
);

my @scope = qw(
    RFC2373_GLOBAL
    RFC2373_ORGLOCAL
    RFC2373_SITELOCAL
    RFC2373_LINKLOCAL
    RFC2373_NODELOCAL
    LINUX_COMPATv4
);

@EXPORT_OK = (@afs,@pfs,@ifs,@iftype,@scope);
%EXPORT_TAGS = (
	all	=> [@afs,@pfs,@ifs,@iftype,@scope],
	afs	=> [@afs],
	pfs	=> [@pfs],
	ifs	=> [@ifs],
	iffs	=> [@iffs],
	iffIN6	=> [@iffIN6],
	iftype	=> [@iftype],
	scope	=> [@scope],
);

sub NI_ENDVAL {return 2147483647};
sub NI_UNIQUE {return \%unique};
sub DESTROY {};

1;
__END__

=head1 NAME

Net::Interface::NetSymbols - AF_ PF_ IFxxx type symbols

=head1 SYNOPSIS

This module is built for this specific architecture during the F<make> 
process using F<inst/netsymbols.pl>. Do not edit this module, edit
F<inst/netsymbols.pl> instead.

This module contains symbols arrays only for use by Net::Interface, in all other
respects it is NOT functional. It contains documentation and data arrays 
for this specific architecture.

B<NOTE:>	WARNING !!

     usage is Net::Interface

B<NOT>  Net::Interface::NetSymbols

use Net::Interface qw(

	Net::Interface::NetSymbols::NI_ENDVAL();
	Net::Interface::NetSymbols::NI_UNIQUE();
AF_UNSPEC AF_LOCAL AF_UNIX AF_FILE AF_INET AF_AX25 AF_IPX AF_APPLETALK AF_X25 AF_INET6 AF_ROSE AF_DECnet AF_PACKET AF_ROUTE AF_ASH AF_ECONET AF_MAX

PF_UNSPEC PF_FILE PF_UNIX PF_LOCAL PF_INET PF_AX25 PF_IPX PF_APPLETALK PF_X25 PF_INET6 PF_ROSE PF_DECnet PF_ROUTE PF_PACKET PF_ASH PF_ECONET PF_MAX

IFF_POINTOPOINT IFF_UP IF_NAMESIZE IFF_MULTICAST IFF_AUTOMEDIA IFF_PORTSEL IFF_NOARP IFF_ALLMULTI IFF_MASTER IFF_DYNAMIC IFF_BROADCAST IFHWADDRLEN IFF_PROMISC IFF_SLAVE IFF_LOOPBACK IFF_DEBUG IFNAMSIZ IFF_NOTRAILERS IFF_RUNNING

IFF_ALLMULTI IFF_AUTOMEDIA IFF_BROADCAST IFF_DEBUG IFF_DYNAMIC IFF_LOOPBACK IFF_MASTER IFF_MULTICAST IFF_NOARP IFF_NOTRAILERS IFF_POINTOPOINT IFF_PORTSEL IFF_PROMISC IFF_RUNNING IFF_SLAVE IFF_UP

:all :afs :pfs :ifs :iffs :iftype :scope

);

=head1 DESCRIPTION

All of the AF_XXX and PF_XXX symbols available in local C<sys/socket.h> plus
usual aliases for AF_LOCAL i.e. (AF_FILE AF_UNIX PF_LOCAL PF_FILE PF_UNIX)

All of the IFxxxx and IN6_IF symbols in C<net/if.h, netinet/in.h, netinet/in_var.h> and
their includes.

Symbols may be accessed for their numeric value or their string name.

  i.e.	if ($family == AF_INET)
	    do something...

    or	print AF_INET
    will product the string "inet"

The same holds true for:

	printf("family is %s",AF_INET);
    or	sprint("family is %s",AF_INET);

To print the numeric value of the SYMBOL do:

	print (0 + SYMBOL), "\n";

On systems supporting IPV6, these additional symbols are available which
may be applied to the address I<type> to determine the address attributes.

    IPV6_ADDR_ANY		unknown
    IPV6_ADDR_UNICAST		unicast
    IPV6_ADDR_MULTICAST		multicast
    IPV6_ADDR_ANYCAST		anycast
    IPV6_ADDR_LOOPBACK		loopback
    IPV6_ADDR_LINKLOCAL		link-local
    IPV6_ADDR_SITELOCAL		site-local
    IPV6_ADDR_COMPATv4		compat-v4
    IPV6_ADDR_SCOPE_MASK	scope-mask
    IPV6_ADDR_MAPPED		mapped
    IPV6_ADDR_RESERVED		reserved
    IPV6_ADDR_ULUA		uniq-lcl-unicast
    IPV6_ADDR_6TO4		6to4
    IPV6_ADDR_6BONE		6bone
    IPV6_ADDR_AGU		global-unicast
    IPV6_ADDR_UNSPECIFIED	unspecified
    IPV6_ADDR_SOLICITED_NODE	solicited-node
    IPV6_ADDR_ISATAP		ISATAP
    IPV6_ADDR_PRODUCTIVE	productive
    IPV6_ADDR_6TO4_MICROSOFT	6to4-ms
    IPV6_ADDR_TEREDO		teredo
    IPV6_ADDR_ORCHID		orchid
    IPV6_ADDR_NON_ROUTE_DOC	non-routeable-doc

    if ($type & IPV6_ADDR_xxxx) {
	print IPV6_ADDR_xxxx,"\n";
    }

These symbols may be equated to the I<scope> of the address.

    RFC2373_GLOBAL		global-scope
    RFC2373_ORGLOCAL		org-local
    RFC2373_SITELOCAL		site-local
    RFC2373_LINKLOCAL		link-local
    RFC2373_NODELOCAL		loopback
    LINUX_COMPATv4		lx-compat-v4

    if ($scope eq RFC2373_xxxx) {
	print RFC2373_xxxx,"\n";
    }


=over 4

=item * :all	Import all symbols

=item * :afs	Import all AF_XXX symbols

=item * :pfs	Import all PF_XXX symbols

=item * :ifs	Import all IFxxxx symbols

=item * :iffs	Import all IFF symbols

=item * :iftype	Import all IPV6 type symbols

=item * :scope	Import all IPV6 scope symbols

=back

=head1 non EXPORT functions

=over 4

=item * Net::Interface::NetSymbols::NI_ENDVAL();

Reports the highest symbol value +1 of :all symbols above. Used for testing.

=item * Net::Interface::NetSymbols::NI_UNIQUE();

Returns a hash pointer to the AF_ or PF_ symbol values mapped to their
character strings as defined for this architecture.

  i.e.
	0	=> 'PF_UNSPEC',
	1	=> 'PF_LOCAL',
	2	=> 'PF_INET',
	3	=> 'PF_AX25',
	4	=> 'PF_IPX',
	5	=> 'PF_APPLETALK',
	9	=> 'PF_X25',
	10	=> 'PF_INET6',
	11	=> 'PF_ROSE',
	12	=> 'PF_DECnet',
	17	=> 'PF_PACKET',
	18	=> 'PF_ASH',
	19	=> 'PF_ECONET',
	46	=> 'PF_MAX',

=head1 AUTHOR	Michael Robinton <michael@bizsystems.com>

=head1 COPYRIGHT	2022

Michael Robinton, all rights reserved.

This library is free software. You can distribute it and/or modify it under
the same terms as Perl itself.

=cut

1;
