/* This is the header file of the Parma Polyhedra Library.
   Copyright (C) 2001-2010 Roberto Bagnara <bagnara@cs.unipr.it>
   Copyright (C) 2010-2016 BUGSENG srl (http://bugseng.com)

This file is part of the Parma Polyhedra Library (PPL).

The PPL is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

The PPL is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1307, USA.

For the most up-to-date information see the Parma Polyhedra Library
site: http://bugseng.com/products/ppl/ . */

#ifndef PPL_ppl_hh
#define PPL_ppl_hh 1

#ifdef NDEBUG
# define PPL_SAVE_NDEBUG NDEBUG
# undef NDEBUG
#endif

#ifdef __STDC_LIMIT_MACROS
# define PPL_SAVE_STDC_LIMIT_MACROS __STDC_LIMIT_MACROS
#endif

/* Automatically generated from PPL source file ../ppl-config.h line 1. */
/* config.h.  Generated from config.h.in by configure.  */
/* config.h.in.  Generated from configure.ac by autoheader.  */


/* BEGIN ppl-config.h */

#ifndef PPL_ppl_config_h
#define PPL_ppl_config_h 1

/* Unique (nonzero) code for the IEEE 754 Single Precision
   floating point format.  */
#define PPL_FLOAT_IEEE754_SINGLE 1

/* Unique (nonzero) code for the IEEE 754 Double Precision
   floating point format.  */
#define PPL_FLOAT_IEEE754_DOUBLE 2

/* Unique (nonzero) code for the IEEE 754 Quad Precision
   floating point format.  */
#define PPL_FLOAT_IEEE754_QUAD 3

/* Unique (nonzero) code for the Intel Double-Extended
   floating point format.  */
#define PPL_FLOAT_INTEL_DOUBLE_EXTENDED 4


/* Define if building universal (internal helper macro) */
/* #undef AC_APPLE_UNIVERSAL_BUILD */

/* Defined if the C++compiler supports C++11 features. */
/* #undef PPL_HAVE_CXX11 */

/* Define to 1 if you have the declaration of `ffs', and to 0 if you don't. */
#define PPL_HAVE_DECL_FFS 1

/* Define to 1 if you have the declaration of `fma', and to 0 if you don't. */
#define PPL_HAVE_DECL_FMA 1

/* Define to 1 if you have the declaration of `fmaf', and to 0 if you don't.
   */
#define PPL_HAVE_DECL_FMAF 1

/* Define to 1 if you have the declaration of `fmal', and to 0 if you don't.
   */
#define PPL_HAVE_DECL_FMAL 1

/* Define to 1 if you have the declaration of `getenv', and to 0 if you don't.
   */
#define PPL_HAVE_DECL_GETENV 1

/* Define to 1 if you have the declaration of `getrusage', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_GETRUSAGE 1

/* Define to 1 if you have the declaration of `rintf', and to 0 if you don't.
   */
#define PPL_HAVE_DECL_RINTF 1

/* Define to 1 if you have the declaration of `rintl', and to 0 if you don't.
   */
#define PPL_HAVE_DECL_RINTL 1

/* Define to 1 if you have the declaration of `RLIMIT_AS', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_RLIMIT_AS 1

/* Define to 1 if you have the declaration of `RLIMIT_DATA', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_RLIMIT_DATA 1

/* Define to 1 if you have the declaration of `RLIMIT_RSS', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_RLIMIT_RSS 1

/* Define to 1 if you have the declaration of `RLIMIT_VMEM', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_RLIMIT_VMEM 0

/* Define to 1 if you have the declaration of `setitimer', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_SETITIMER 1

/* Define to 1 if you have the declaration of `setrlimit', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_SETRLIMIT 1

/* Define to 1 if you have the declaration of `sigaction', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_SIGACTION 1

/* Define to 1 if you have the declaration of `strtod', and to 0 if you don't.
   */
#define PPL_HAVE_DECL_STRTOD 1

/* Define to 1 if you have the declaration of `strtof', and to 0 if you don't.
   */
#define PPL_HAVE_DECL_STRTOF 1

/* Define to 1 if you have the declaration of `strtold', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_STRTOLD 1

/* Define to 1 if you have the declaration of `strtoll', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_STRTOLL 1

/* Define to 1 if you have the declaration of `strtoull', and to 0 if you
   don't. */
#define PPL_HAVE_DECL_STRTOULL 1

/* Define to 1 if you have the <dlfcn.h> header file. */
#define PPL_HAVE_DLFCN_H 1

/* Define to 1 if you have the <fenv.h> header file. */
#define PPL_HAVE_FENV_H 1

/* Define to 1 if you have the <getopt.h> header file. */
#define PPL_HAVE_GETOPT_H 1

/* Define to 1 if you have the <glpk/glpk.h> header file. */
/* #undef PPL_HAVE_GLPK_GLPK_H */

/* Define to 1 if you have the <glpk.h> header file. */
/* #undef PPL_HAVE_GLPK_H */

/* Define to 1 if you have the <ieeefp.h> header file. */
/* #undef PPL_HAVE_IEEEFP_H */

/* Define to 1 if you have the <inttypes.h> header file. */
#define PPL_HAVE_INTTYPES_H 1

/* Define to 1 if the system has the type `int_fast16_t'. */
#define PPL_HAVE_INT_FAST16_T 1

/* Define to 1 if the system has the type `int_fast32_t'. */
#define PPL_HAVE_INT_FAST32_T 1

/* Define to 1 if the system has the type `int_fast64_t'. */
#define PPL_HAVE_INT_FAST64_T 1

/* Define to 1 if you have the <memory.h> header file. */
#define PPL_HAVE_MEMORY_H 1

/* Define to 1 if the system has the type `siginfo_t'. */
#define PPL_HAVE_SIGINFO_T 1

/* Define to 1 if you have the <signal.h> header file. */
#define PPL_HAVE_SIGNAL_H 1

/* Define to 1 if you have the <stdint.h> header file. */
#define PPL_HAVE_STDINT_H 1

/* Define to 1 if you have the <stdlib.h> header file. */
#define PPL_HAVE_STDLIB_H 1

/* Define to 1 if you have the <strings.h> header file. */
#define PPL_HAVE_STRINGS_H 1

/* Define to 1 if you have the <string.h> header file. */
#define PPL_HAVE_STRING_H 1

/* Define to 1 if you have the <sys/resource.h> header file. */
#define PPL_HAVE_SYS_RESOURCE_H 1

/* Define to 1 if you have the <sys/stat.h> header file. */
#define PPL_HAVE_SYS_STAT_H 1

/* Define to 1 if you have the <sys/time.h> header file. */
#define PPL_HAVE_SYS_TIME_H 1

/* Define to 1 if you have the <sys/types.h> header file. */
#define PPL_HAVE_SYS_TYPES_H 1

/* Define to 1 if the system has the type `timeval'. */
#define PPL_HAVE_TIMEVAL 1

/* Define to 1 if typeof works with your compiler. */
#define PPL_HAVE_TYPEOF 1

/* Define to 1 if the system has the type `uintptr_t'. */
#define PPL_HAVE_UINTPTR_T 1

/* Define to 1 if the system has the type `uint_fast16_t'. */
#define PPL_HAVE_UINT_FAST16_T 1

/* Define to 1 if the system has the type `uint_fast32_t'. */
#define PPL_HAVE_UINT_FAST32_T 1

/* Define to 1 if the system has the type `uint_fast64_t'. */
#define PPL_HAVE_UINT_FAST64_T 1

/* Define to 1 if you have the <unistd.h> header file. */
#define PPL_HAVE_UNISTD_H 1

/* Define to 1 if `_mp_alloc' is a member of `__mpz_struct'. */
#define PPL_HAVE___MPZ_STRUCT__MP_ALLOC 1

/* Define to 1 if `_mp_d' is a member of `__mpz_struct'. */
#define PPL_HAVE___MPZ_STRUCT__MP_D 1

/* Define to 1 if `_mp_size' is a member of `__mpz_struct'. */
#define PPL_HAVE___MPZ_STRUCT__MP_SIZE 1

/* Define to the sub-directory in which libtool stores uninstalled libraries.
   */
#define LT_OBJDIR ".libs/"

/* Define to the address where bug reports for this package should be sent. */
#define PPL_PACKAGE_BUGREPORT "ppl-devel@cs.unipr.it"

/* Define to the full name of this package. */
#define PPL_PACKAGE_NAME "the Parma Polyhedra Library"

/* Define to the full name and version of this package. */
#define PPL_PACKAGE_STRING "the Parma Polyhedra Library 1.2"

/* Define to the one symbol short name of this package. */
#define PPL_PACKAGE_TARNAME "ppl"

/* Define to the home page for this package. */
#define PACKAGE_URL ""

/* Define to the version of this package. */
#define PPL_PACKAGE_VERSION "1.2"

/* ABI-breaking extra assertions are enabled when this is defined. */
/* #undef PPL_ABI_BREAKING_EXTRA_DEBUG */

/* Not zero if the FPU can be controlled. */
#define PPL_CAN_CONTROL_FPU 1

/* Defined if the integral type to be used for coefficients is a checked one.
   */
/* #undef PPL_CHECKED_INTEGERS */

/* The number of bits of coefficients; 0 if unbounded. */
#define PPL_COEFFICIENT_BITS 0

/* The integral type used to represent coefficients. */
#define PPL_COEFFICIENT_TYPE mpz_class

/* This contains the options with which `configure' was invoked. */
#define PPL_CONFIGURE_OPTIONS " '--prefix=/usr/pkg' '--build=x86_64-unknown-linux' '--host=x86_64-unknown-linux' '--mandir=/usr/pkg/man' '--enable-option-checking=yes' 'build_alias=x86_64-unknown-linux' 'host_alias=x86_64-unknown-linux' 'CC=cc' 'CFLAGS=-O2 -D_FORTIFY_SOURCE=2 -I/usr/pkg/include' 'LDFLAGS=-Wl,-zrelro -L/usr/pkg/lib -Wl,-R/usr/pkg/lib' 'LIBS=' 'CPPFLAGS=-I/usr/pkg/include' 'CXX=c++' 'CXXFLAGS=-O2 -D_FORTIFY_SOURCE=2 -I/usr/pkg/include'"

/* The unique code of the binary format of C++ doubles, if supported;
   undefined otherwise. */
#define PPL_CXX_DOUBLE_BINARY_FORMAT PPL_FLOAT_IEEE754_DOUBLE

/* The binary format of C++ floats, if supported; undefined otherwise. */
#define PPL_CXX_FLOAT_BINARY_FORMAT PPL_FLOAT_IEEE754_SINGLE

/* The unique code of the binary format of C++ long doubles, if supported;
   undefined otherwise. */
#define PPL_CXX_LONG_DOUBLE_BINARY_FORMAT PPL_FLOAT_INTEL_DOUBLE_EXTENDED

/* Not zero if the the plain char type is signed. */
#define PPL_CXX_PLAIN_CHAR_IS_SIGNED 1

/* Not zero if the C++ compiler provides long double numbers that have bigger
   range or precision than double. */
#define PPL_CXX_PROVIDES_PROPER_LONG_DOUBLE 1

/* Not zero if the C++ compiler supports __attribute__ ((weak)). */
#define PPL_CXX_SUPPORTS_ATTRIBUTE_WEAK 1

/* Not zero if the the IEEE inexact flag is supported in C++. */
#define PPL_CXX_SUPPORTS_IEEE_INEXACT_FLAG 1

/* Not zero if it is possible to limit memory using setrlimit(). */
#define PPL_CXX_SUPPORTS_LIMITING_MEMORY 0

/* Not zero if the C++ compiler supports zero_length arrays. */
#define PPL_CXX_SUPPORTS_ZERO_LENGTH_ARRAYS 1

/* Defined if floating point arithmetic may use the 387 unit. */
#define PPL_FPMATH_MAY_USE_387 1

/* Defined if floating point arithmetic may use the SSE instruction set. */
#define PPL_FPMATH_MAY_USE_SSE 1

/* Defined if GLPK provides glp_term_hook(). */
/* #undef PPL_GLPK_HAS_GLP_TERM_HOOK */

/* Defined if GLPK provides glp_term_out(). */
/* #undef PPL_GLPK_HAS_GLP_TERM_OUT */

/* Defined if GLPK provides lib_set_print_hook(). */
/* #undef PPL_GLPK_HAS_LIB_SET_PRINT_HOOK */

/* Defined if GLPK provides _glp_lib_print_hook(). */
/* #undef PPL_GLPK_HAS__GLP_LIB_PRINT_HOOK */

/* Defined if the integral type to be used for coefficients is GMP's one. */
#define PPL_GMP_INTEGERS 1

/* Not zero if GMP has been compiled with support for exceptions. */
#define PPL_GMP_SUPPORTS_EXCEPTIONS 1

/* Defined if the integral type to be used for coefficients is a native one.
   */
/* #undef PPL_NATIVE_INTEGERS */

/* Assertions are disabled when this is defined. */
#define PPL_NDEBUG 1

/* Not zero if doubles are supported. */
#define PPL_SUPPORTED_DOUBLE 1

/* Not zero if floats are supported. */
#define PPL_SUPPORTED_FLOAT 1

/* Not zero if long doubles are supported. */
#define PPL_SUPPORTED_LONG_DOUBLE 1

/* The size of `char', as computed by sizeof. */
#define PPL_SIZEOF_CHAR 1

/* The size of `double', as computed by sizeof. */
#define PPL_SIZEOF_DOUBLE 8

/* The size of `float', as computed by sizeof. */
#define PPL_SIZEOF_FLOAT 4

/* The size of `fp', as computed by sizeof. */
#define PPL_SIZEOF_FP 8

/* The size of `int', as computed by sizeof. */
#define PPL_SIZEOF_INT 4

/* The size of `int*', as computed by sizeof. */
#define PPL_SIZEOF_INTP 8

/* The size of `long', as computed by sizeof. */
#define PPL_SIZEOF_LONG 8

/* The size of `long double', as computed by sizeof. */
#define PPL_SIZEOF_LONG_DOUBLE 16

/* The size of `long long', as computed by sizeof. */
#define PPL_SIZEOF_LONG_LONG 8

/* The size of `mp_limb_t', as computed by sizeof. */
#define PPL_SIZEOF_MP_LIMB_T 8

/* The size of `short', as computed by sizeof. */
#define PPL_SIZEOF_SHORT 2

/* The size of `size_t', as computed by sizeof. */
#define PPL_SIZEOF_SIZE_T 8

/* Define to 1 if you have the ANSI C header files. */
#define PPL_STDC_HEADERS 1

/* Define PPL_WORDS_BIGENDIAN to 1 if your processor stores words with the most
   significant byte first (like Motorola and SPARC, unlike Intel). */
#if defined AC_APPLE_UNIVERSAL_BUILD
# if defined __BIG_ENDIAN__
#  define PPL_WORDS_BIGENDIAN 1
# endif
#else
# ifndef PPL_WORDS_BIGENDIAN
/* #  undef PPL_WORDS_BIGENDIAN */
# endif
#endif

/* When defined and libstdc++ is used, it is used in debug mode. */
/* #undef _GLIBCXX_DEBUG */

/* When defined and libstdc++ is used, it is used in pedantic debug mode. */
/* #undef _GLIBCXX_DEBUG_PEDANTIC */

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef const */

/* Define to `__inline__' or `__inline' if that's what the C compiler
   calls it, or to nothing if 'inline' is not supported under any name.  */
#ifndef __cplusplus
/* #undef inline */
#endif

/* Define to __typeof__ if your compiler spells it that way. */
/* #undef typeof */

/* Define to the type of an unsigned integer type wide enough to hold a
   pointer, if such a type exists, and if the system does not define it. */
/* #undef uintptr_t */


#if defined(PPL_NDEBUG) && !defined(NDEBUG)
# define NDEBUG PPL_NDEBUG
#endif

/* In order for the definition of `int64_t' to be seen by Comeau C/C++,
   we must make sure <stdint.h> is included before <sys/types.hh> is
   (even indirectly) included.  Moreover we need to define
   __STDC_LIMIT_MACROS before the first inclusion of <stdint.h>
   in order to have the macros defined also in C++.  */

#ifdef PPL_HAVE_STDINT_H
# ifndef __STDC_LIMIT_MACROS
#  define __STDC_LIMIT_MACROS 1
# endif
# include <stdint.h>
#endif

#ifdef PPL_HAVE_INTTYPES_H
# include <inttypes.h>
#endif

#define PPL_U(x) x

#endif /* !defined(PPL_ppl_config_h) */

/* END ppl-config.h */

/* Automatically generated from PPL source file ../src/version.hh line 1. */
/* Declaration of macros and functions providing version  -*- C++ -*-
   and licensing information.
*/


//! The major number of the PPL version.
/*! \ingroup PPL_CXX_interface */
#define PPL_VERSION_MAJOR 1

//! The minor number of the PPL version.
/*! \ingroup PPL_CXX_interface */
#define PPL_VERSION_MINOR 2

//! The revision number of the PPL version.
/*! \ingroup PPL_CXX_interface */
#define PPL_VERSION_REVISION 0

/*! \brief
  The beta number of the PPL version.  This is zero for official
  releases and nonzero for development snapshots.
  \ingroup PPL_CXX_interface
*/
#define PPL_VERSION_BETA 0

//! A string containing the PPL version.
/*! \ingroup PPL_CXX_interface
  Let <CODE>M</CODE> and <CODE>m</CODE> denote the numbers associated
  to PPL_VERSION_MAJOR and PPL_VERSION_MINOR, respectively.  The
  format of PPL_VERSION is <CODE>M "." m</CODE> if both
  PPL_VERSION_REVISION (<CODE>r</CODE>) and PPL_VERSION_BETA
  (<CODE>b</CODE>)are zero, <CODE>M "." m "pre" b</CODE> if
  PPL_VERSION_REVISION is zero and PPL_VERSION_BETA is not zero,
  <CODE>M "." m "." r</CODE> if PPL_VERSION_REVISION is not zero and
  PPL_VERSION_BETA is zero, <CODE>M "." m "." r "pre" b</CODE> if
  neither PPL_VERSION_REVISION nor PPL_VERSION_BETA are zero.
*/
#define PPL_VERSION "1.2"

namespace Parma_Polyhedra_Library {

//! \name Library Version Control Functions
//@{

//! Returns the major number of the PPL version.
unsigned
version_major();

//! Returns the minor number of the PPL version.
unsigned
version_minor();

//! Returns the revision number of the PPL version.
unsigned
version_revision();

//! Returns the beta number of the PPL version.
unsigned
version_beta();

//! Returns a character string containing the PPL version.
const char* version();

//! Returns a character string containing the PPL banner.
/*!
  The banner provides information about the PPL version, the licensing,
  the lack of any warranty whatsoever, the C++ compiler used to build
  the library, where to report bugs and where to look for further
  information.
*/
const char* banner();

//@} // Library Version Control Functions

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/namespaces.hh line 1. */
/* Documentation for used namespaces.
*/


//! The entire library is confined to this namespace.
namespace Parma_Polyhedra_Library {

//! All input/output operators are confined to this namespace.
/*! \ingroup PPL_CXX_interface
  This is done so that the library's input/output operators
  do not interfere with those the user might want to define.
  In fact, it is highly unlikely that any predefined I/O
  operator will suit the needs of a client application.
  On the other hand, those applications for which the PPL
  I/O operator are enough can easily obtain access to them.
  For example, a directive like
  \code
    using namespace Parma_Polyhedra_Library::IO_Operators;
  \endcode
  would suffice for most uses.
  In more complex situations, such as
  \code
    const Constraint_System& cs = ...;
    copy(cs.begin(), cs.end(),
         ostream_iterator<Constraint>(cout, "\n"));
  \endcode
  the Parma_Polyhedra_Library namespace must be suitably extended.
  This can be done as follows:
  \code
    namespace Parma_Polyhedra_Library {
      // Import all the output operators into the main PPL namespace.
      using IO_Operators::operator<<;
    }
  \endcode
*/
namespace IO_Operators {
} // namespace IO_Operators

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Types and functions implementing checked numbers.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace Checked {
} // namespace Checked

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! %Implementation related data and functions.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace Implementation {
} // namespace Implementation

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to language interfaces.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace Interfaces {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the C language interface.
/*! \ingroup PPL_C_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace C {

} // namespace C

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the Java language interface.
/*! \ingroup PPL_Java_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace Java {

} // namespace Java

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the OCaml language interface.
/*! \ingroup PPL_OCaml_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace OCaml {

} // namespace OCaml

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the Prolog language interfaces.
/*! \ingroup PPL_Prolog_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace Prolog {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the Ciao Prolog language interface.
/*! \ingroup PPL_Prolog_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace Ciao {

} // namespace Ciao

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the GNU Prolog language interface.
/*! \ingroup PPL_Prolog_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace GNU {

} // namespace GNU

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the SICStus language interface.
/*! \ingroup PPL_Prolog_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace SICStus {

} // namespace SICStus

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the SWI-Prolog language interface.
/*! \ingroup PPL_Prolog_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace SWI {

} // namespace SWI

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the XSB language interface.
/*! \ingroup PPL_Prolog_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace XSB {

} // namespace XSB

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Data and functions related to the YAP language interface.
/*! \ingroup PPL_Prolog_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
namespace YAP {

} // namespace YAP

} // namespace Prolog

} // namespace Interfaces

} // namespace Parma_Polyhedra_Library


//! The standard C++ namespace.
/*! \ingroup PPL_CXX_interface
  The Parma Polyhedra Library conforms to the C++ standard and,
  in particular, as far as reserved names are concerned (17.4.3.1,
  [lib.reserved.names]).  The PPL, however, defines several
  template specializations for the standard library class template
  <CODE>numeric_limits</CODE> (18.2.1, [lib.limits]).

  \note
  The PPL provides the specializations of the class template
  <CODE>numeric_limits</CODE> not only for PPL-specific numeric types,
  but also for the GMP types <CODE>mpz_class</CODE> and
  <CODE>mpq_class</CODE>. These specializations will be removed
  as soon as they will be provided by the C++ interface of GMP.
*/
namespace std {
} // namespace std


/* Automatically generated from PPL source file ../src/Interval_Info_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename Policy>
class Interval_Info_Null;

template <typename T, typename Policy>
class Interval_Info_Bitset;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/checked_numeric_limits.hh line 1. */
/* Specializations of std::numeric_limits for "checked" types.
*/


/* Automatically generated from PPL source file ../src/Checked_Number_defs.hh line 1. */
/* Checked_Number class declaration.
*/


/* Automatically generated from PPL source file ../src/Checked_Number_types.hh line 1. */


/* Automatically generated from PPL source file ../src/Coefficient_traits_template.hh line 1. */
/* Coefficient_traits_template class declaration.
*/


namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Coefficient traits.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Coefficient>
struct Coefficient_traits_template {
};

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Checked_Number_types.hh line 17. */

namespace Parma_Polyhedra_Library {

struct Extended_Number_Policy;

template <typename T, typename Policy>
class Checked_Number;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/checked_defs.hh line 1. */
/* Abstract checked arithmetic function container.
*/


/* Automatically generated from PPL source file ../src/mp_std_bits_defs.hh line 1. */
/* Declarations of specializations of std:: objects for
   multi-precision types.
*/


#include <gmpxx.h>
#include <limits>

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Swaps \p x with \p y.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void swap(mpz_class& x, mpz_class& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Swaps \p x with \p y.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void swap(mpq_class& x, mpq_class& y);

#if __GNU_MP_VERSION < 5 \
  || (__GNU_MP_VERSION == 5 && __GNU_MP_VERSION_MINOR < 1)

namespace std {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Specialization of std::numeric_limits.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <>
class numeric_limits<mpz_class> {
private:
  typedef mpz_class Type;

public:
  static const bool is_specialized = true;
  static const int digits = 0;
  static const int digits10 = 0;
  static const bool is_signed = true;
  static const bool is_integer = true;
  static const bool is_exact = true;
  static const int radix = 2;
  static const int min_exponent = 0;
  static const int min_exponent10 = 0;
  static const int max_exponent = 0;
  static const int max_exponent10 = 0;
  static const bool has_infinity = false;
  static const bool has_quiet_NaN =  false;
  static const bool has_signaling_NaN = false;
  static const float_denorm_style has_denorm = denorm_absent;
  static const bool has_denorm_loss = false;
  static const bool is_iec559 = false;
  static const bool is_bounded = false;
  static const bool is_modulo = false;
  static const bool traps = false;
  static const bool tinyness_before = false;
  static const float_round_style round_style = round_toward_zero;

  static Type min() {
    return static_cast<Type>(0);
  }

  static Type max() {
    return static_cast<Type>(0);
  }

  static Type epsilon() {
    return static_cast<Type>(0);
  }

  static Type round_error() {
    return static_cast<Type>(0);
  }

  static Type infinity() {
    return static_cast<Type>(0);
  }

  static Type quiet_NaN() {
    return static_cast<Type>(0);
  }

  static Type denorm_min() {
    return static_cast<Type>(1);
  }
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Specialization of std::numeric_limits.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <>
class numeric_limits<mpq_class> {
private:
  typedef mpq_class Type;

public:
  static const bool is_specialized = true;
  static const int digits = 0;
  static const int digits10 = 0;
  static const bool is_signed = true;
  static const bool is_integer = false;
  static const bool is_exact = true;
  static const int radix = 2;
  static const int min_exponent = 0;
  static const int min_exponent10 = 0;
  static const int max_exponent = 0;
  static const int max_exponent10 = 0;
  static const bool has_infinity = false;
  static const bool has_quiet_NaN =  false;
  static const bool has_signaling_NaN = false;
  static const float_denorm_style has_denorm = denorm_absent;
  static const bool has_denorm_loss = false;
  static const bool is_iec559 = false;
  static const bool is_bounded = false;
  static const bool is_modulo = false;
  static const bool traps = false;
  static const bool tinyness_before = false;
  static const float_round_style round_style = round_toward_zero;

  static Type min() {
    return static_cast<Type>(0);
  }

  static Type max() {
    return static_cast<Type>(0);
  }

  static Type epsilon() {
    return static_cast<Type>(0);
  }

  static Type round_error() {
    return static_cast<Type>(0);
  }

  static Type infinity() {
    return static_cast<Type>(0);
  }

  static Type quiet_NaN() {
    return static_cast<Type>(0);
  }

  static Type denorm_min() {
    return static_cast<Type>(0);
  }
};

} // namespace std

#endif // __GNU_MP_VERSION < 5
       // || (__GNU_MP_VERSION == 5 && __GNU_MP_VERSION_MINOR < 1)

/* Automatically generated from PPL source file ../src/mp_std_bits_inlines.hh line 1. */
/* Definitions of specializations of std:: functions and methods for
   multi-precision types.
*/


inline void
swap(mpz_class& x, mpz_class& y) {
  mpz_swap(x.get_mpz_t(), y.get_mpz_t());
}

inline void
swap(mpq_class& x, mpq_class& y) {
  mpq_swap(x.get_mpq_t(), y.get_mpq_t());
}

/* Automatically generated from PPL source file ../src/mp_std_bits_defs.hh line 174. */

/* Automatically generated from PPL source file ../src/Temp_defs.hh line 1. */
/* Temp_* classes declarations.
*/


/* Automatically generated from PPL source file ../src/meta_programming.hh line 1. */
/* Metaprogramming utilities.
*/


#include <gmpxx.h>

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Declares a per-class constant of type <CODE>bool</CODE>, called \p name
  and with value \p value.

  \ingroup PPL_CXX_interface
  Differently from static constants, \p name needs not (and cannot) be
  defined (for static constants, the need for a further definition is
  mandated by Section 9.4.2/4 of the C++ standard).
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
#define const_bool_nodef(name, value)           \
  enum const_bool_value_ ## name { PPL_U(name) = (value) }

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Declares a per-class constant of type <CODE>int</CODE>, called \p name
  and with value \p value.

  \ingroup PPL_CXX_interface
  Differently from static constants, \p name needs not (and cannot) be
  defined (for static constants, the need for a further definition is
  mandated by Section 9.4.2/4 of the C++ standard).
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
#define const_int_nodef(name, value) \
  enum anonymous_enum_ ## name { PPL_U(name) = (value) }

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Declares a per-class constant of type \p type, called \p name
  and with value \p value.  The value of the constant is accessible
  by means of the syntax <CODE>name()</CODE>.

  \ingroup PPL_CXX_interface
  Differently from static constants, \p name needs not (and cannot) be
  defined (for static constants, the need for a further definition is
  mandated by Section 9.4.2/4 of the C++ standard).
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
#define const_value_nodef(type, name, value)    \
  static type PPL_U(name)() {                   \
    return (value);                             \
  }

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Declares a per-class constant of type \p type, called \p name
  and with value \p value.  A constant reference to the constant
  is accessible by means of the syntax <CODE>name()</CODE>.

  \ingroup PPL_CXX_interface
  Differently from static constants, \p name needs not (and cannot) be
  defined (for static constants, the need for a further definition is
  mandated by Section 9.4.2/4 of the C++ standard).
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
#define const_ref_nodef(type, name, value)                              \
  static const type& PPL_U(name)() {                                    \
    static type PPL_U(name) = (value);                                       \
    return (name);                                                      \
  }

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class that is only defined if \p b evaluates to <CODE>true</CODE>.

  \ingroup PPL_CXX_interface
  This is the non-specialized case, so the class is declared but not defined.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <bool b>
struct Compile_Time_Check;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class that is only defined if \p b evaluates to <CODE>true</CODE>.

  \ingroup PPL_CXX_interface
  This is the specialized case with \p b equal to <CODE>true</CODE>,
  so the class is declared and (trivially) defined.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <>
struct Compile_Time_Check<true> {
};

#define PPL_COMPILE_TIME_CHECK_NAME(suffix) compile_time_check_ ## suffix
#define PPL_COMPILE_TIME_CHECK_AUX(e, suffix)                           \
  enum anonymous_enum_compile_time_check_ ## suffix {                   \
    /* If e evaluates to false, then the sizeof cannot be compiled. */  \
    PPL_COMPILE_TIME_CHECK_NAME(suffix)                                 \
      = sizeof(Parma_Polyhedra_Library::Compile_Time_Check<(e)>)        \
  }

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Produces a compilation error if the compile-time constant \p e does
  not evaluate to <CODE>true</CODE>
  \ingroup PPL_CXX_interface
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
#define PPL_COMPILE_TIME_CHECK(e, msg) PPL_COMPILE_TIME_CHECK_AUX(e, __LINE__)

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class holding a constant called <CODE>value</CODE> that evaluates
  to \p b.
  \ingroup PPL_CXX_interface
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <bool b>
struct Bool {
  enum const_bool_value {
    value = b
  };
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class holding a constant called <CODE>value</CODE> that evaluates
  to <CODE>true</CODE>.
  \ingroup PPL_CXX_interface
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct True : public Bool<true> {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class holding a constant called <CODE>value</CODE> that evaluates
  to <CODE>false</CODE>.
  \ingroup PPL_CXX_interface
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct False : public Bool<false> {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class holding a constant called <CODE>value</CODE> that evaluates
  to <CODE>true</CODE> if and only if \p T1 is the same type as \p T2.

  \ingroup PPL_CXX_interface
  This is the non-specialized case, in which \p T1 and \p T2 can be different.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T1, typename T2>
struct Is_Same : public False {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class holding a constant called <CODE>value</CODE> that evaluates
  to <CODE>true</CODE> if and only if \p T1 is the same type as \p T2.

  \ingroup PPL_CXX_interface
  This is the specialization in which \p T1 and \p T2 are equal.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Is_Same<T, T> : public True {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class holding a constant called <CODE>value</CODE> that evaluates
  to <CODE>true</CODE> if and only if \p Base is the same type as \p Derived
  or \p Derived is a class derived from \p Base.

  \ingroup PPL_CXX_interface
  \note
  Care must be taken to use this predicate with template classes.
  Suppose we have
  \code
  template <typename T> struct B;
  template <typename T> struct D : public B<T>;
  \endcode
  Of course, we cannot test if, for some type variable <CODE>U</CODE>, we have
  <CODE>Is_Same_Or_Derived<B<U>, Type>:: const_bool_value:: value == true</CODE>.
  But we can do as follows:
  \code
  struct B_Base {
  };

  template <typename T> struct B : public B_Base;
  \endcode
  This enables us to inquire
  <CODE>Is_Same_Or_Derived<B_Base, Type>:: const_bool_value:: value</CODE>.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Base, typename Derived>
struct Is_Same_Or_Derived {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! A class that is constructible from just anything.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  struct Any {
    //! The universal constructor.
    template <typename T>
    Any(const T&);
  };

  //! Overloading with \p Base.
  static char func(const Base&);

  //! Overloading with \p Any.
  static double func(Any);

  //! A function obtaining a const reference to a \p Derived object.
  static const Derived& derived_object();

  PPL_COMPILE_TIME_CHECK(sizeof(char) != sizeof(double),
                         "architecture with sizeof(char) == sizeof(double)"
                         " (!?)");

  enum const_bool_value {
    /*!
      Assuming <CODE>sizeof(char) != sizeof(double)</CODE>, the C++
      overload resolution mechanism guarantees that <CODE>value</CODE>
      evaluates to <CODE>true</CODE> if and only if <CODE>Base</CODE>
      is the same type as <CODE>Derived</CODE> or <CODE>Derived</CODE>
      is a class derived from <CODE>Base</CODE>.
    */
    value = (sizeof(func(derived_object())) == sizeof(char))
  };
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class that provides a type member called <CODE>type</CODE> equivalent
  to \p T if and only if \p b is <CODE>true</CODE>.

  \ingroup PPL_CXX_interface
  This is the non-specialized case, in which the <CODE>type</CODE> member
  is not present.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <bool b, typename T = void>
struct Enable_If {
};

template <typename Type, Type, typename T = void>
struct Enable_If_Is {
  typedef T type;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  A class that provides a type member called <CODE>type</CODE> equivalent
  to \p T if and only if \p b is <CODE>true</CODE>.

  \ingroup PPL_CXX_interface
  This is the specialization in which the <CODE>type</CODE> member
  is present.

  \note
  Let <CODE>T</CODE>, <CODE>T1</CODE> and <CODE>T2</CODE> be any type
  expressions and suppose we have some template function
  <CODE>T f(T1, T2)</CODE>.  If we want to declare a specialization
  that is enabled only if some compile-time checkable condition holds,
  we simply declare the specialization by
  \code
  template ...
  typename Enable_If<condition, T>::type
  foo(T1 x, T2 y);
  \endcode
  For all the instantiations of the template parameters that cause
  <CODE>condition</CODE> to evaluate to <CODE>false</CODE>,
  the <CODE>Enable_If<condition, T>::type</CODE> member will not be defined.
  Hence, for that instantiations, the specialization will not be eligible.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Enable_If<true, T> {
  typedef T type;
};

template <typename T>
struct Is_Native : public False {
};

template <> struct Is_Native<char> : public True { };
template <> struct Is_Native<signed char> : public True { };
template <> struct Is_Native<signed short> : public True { };
template <> struct Is_Native<signed int> : public True { };
template <> struct Is_Native<signed long> : public True { };
template <> struct Is_Native<signed long long> : public True { };
template <> struct Is_Native<unsigned char> : public True { };
template <> struct Is_Native<unsigned short> : public True { };
template <> struct Is_Native<unsigned int> : public True { };
template <> struct Is_Native<unsigned long> : public True { };
template <> struct Is_Native<unsigned long long> : public True { };

#if PPL_SUPPORTED_FLOAT
template <> struct Is_Native<float> : public True { };
#endif
#if PPL_SUPPORTED_DOUBLE
template <> struct Is_Native<double> : public True { };
#endif
#if PPL_SUPPORTED_LONG_DOUBLE
template <> struct Is_Native<long double> : public True { };
#endif

template <> struct Is_Native<mpz_class> : public True { };

template <> struct Is_Native<mpq_class> : public True { };

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Slow_Copy.hh line 1. */
/* Basic Slow_Copy classes declarations.
*/


/* Automatically generated from PPL source file ../src/Slow_Copy.hh line 28. */
#include <gmpxx.h>

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface
  Copies are not slow by default.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Slow_Copy : public False {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface
  Copies are slow for mpz_class objects.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <>
struct Slow_Copy<mpz_class> : public True {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface
  Copies are slow for mpq_class objects.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <>
struct Slow_Copy<mpq_class> : public True {
};

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Temp_defs.hh line 29. */

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! A pool of temporary items of type \p T.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Temp_Item {
public:
  //! Obtains a reference to a temporary item.
  static Temp_Item& obtain();

  //! Releases the temporary item \p p.
  static void release(Temp_Item& p);

  //! Returns a reference to the encapsulated item.
  T& item();

private:
  //! The encapsulated item.
  T item_;

  //! Pointer to the next item in the free list.
  Temp_Item* next;

  class Free_List {
  public:
    Free_List();
    ~Free_List();
    Temp_Item* head_ptr;
  private:
    Free_List(const Free_List&); // Not implemented.
    Free_List& operator=(const Free_List&); // Not implemented.
  }; // class Free_List

  friend class Free_List;

  //! Head of the free list.
  static Temp_Item*& free_list_ref();

  //! Default constructor.
  Temp_Item();

  //! Copy constructor: private and intentionally not implemented.
  Temp_Item(const Temp_Item&);

  //! Assignment operator: private and intentionally not implemented.
  Temp_Item& operator=(const Temp_Item&);
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! An holder for a reference to a temporary object.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Temp_Reference_Holder {
public:
  //! Constructs an holder holding a dirty temp.
  Temp_Reference_Holder();

  //! Destructor.
  ~Temp_Reference_Holder();

  //! Returns a reference to the held item.
  T& item();

private:
  //! Copy constructor: private and intentionally not implemented.
  Temp_Reference_Holder(const Temp_Reference_Holder&);

  //! Assignment operator: private and intentionally not implemented.
  Temp_Reference_Holder& operator=(const Temp_Reference_Holder&);

  //! The held item, encapsulated.
  Temp_Item<T>& held;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! An (fake) holder for the value of a temporary object.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Temp_Value_Holder {
public:
  //! Constructs a fake holder.
  Temp_Value_Holder();

  //! Returns the value of the held item.
  T& item();

private:
  //! Copy constructor: private and intentionally not implemented.
  Temp_Value_Holder(const Temp_Value_Holder&);

  //! Assignment operator: private and intentionally not implemented.
  Temp_Value_Holder& operator=(const Temp_Value_Holder&);

  //! The held item.
  T item_;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! A structure for the efficient handling of temporaries.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T, typename Enable = void>
class Dirty_Temp;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Specialization for the handling of temporaries with a free list.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Dirty_Temp<T, typename Enable_If<Slow_Copy<T>::value>::type>
  : public Temp_Reference_Holder<T> {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Specialization for the handling of temporaries with local variables.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Dirty_Temp<T, typename Enable_If<!Slow_Copy<T>::value>::type>
  : public Temp_Value_Holder<T> {
};

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Temp_inlines.hh line 1. */
/* Temp_* classes implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Temp_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

template <typename T>
inline
Temp_Item<T>::Temp_Item()
  : item_() {
}

template <typename T>
inline T&
Temp_Item<T>::item() {
    return item_;
}

template <typename T>
inline
Temp_Item<T>::Free_List::Free_List()
  : head_ptr(0) {
}

template <typename T>
inline Temp_Item<T>*&
Temp_Item<T>::free_list_ref() {
  static Free_List free_list;
  return free_list.head_ptr;
}

template <typename T>
inline Temp_Item<T>&
Temp_Item<T>::obtain() {
  Temp_Item* const p = free_list_ref();
  if (p != 0) {
    free_list_ref() = p->next;
    return *p;
  }
  else {
    return *new Temp_Item();
  }
}

template <typename T>
inline void
Temp_Item<T>::release(Temp_Item& p) {
  p.next = free_list_ref();
  free_list_ref() = &p;
}

template <typename T>
inline
Temp_Reference_Holder<T>::Temp_Reference_Holder()
  : held(Temp_Item<T>::obtain()) {
}

template <typename T>
inline
Temp_Reference_Holder<T>::~Temp_Reference_Holder() {
  Temp_Item<T>::release(held);
}

template <typename T>
inline T&
Temp_Reference_Holder<T>::item() {
  return held.item();
}

template <typename T>
inline
Temp_Value_Holder<T>::Temp_Value_Holder() {
}

template <typename T>
inline T&
Temp_Value_Holder<T>::item() {
  return item_;
}

} // namespace Parma_Polyhedra_Library

#define PPL_DIRTY_TEMP(T, id)                                           \
  Parma_Polyhedra_Library::Dirty_Temp<PPL_U(T)> holder_ ## id;          \
  PPL_U(T)& PPL_U(id) = holder_ ## id.item()

/* Automatically generated from PPL source file ../src/Temp_templates.hh line 1. */
/* Temp_* classes implementation: non-inline template members.
*/


namespace Parma_Polyhedra_Library {

template <typename T>
Temp_Item<T>::Free_List::~Free_List() {
  while (head_ptr != 0) {
    Temp_Item* const p = head_ptr;
    head_ptr = head_ptr->next;
    delete p;
  }
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Temp_defs.hh line 154. */

/* Automatically generated from PPL source file ../src/Rounding_Dir_defs.hh line 1. */
/* Declaration of Rounding_Dir and related functions.
*/


/* Automatically generated from PPL source file ../src/Result_defs.hh line 1. */
/* Result enum and supporting function declarations.
*/


namespace Parma_Polyhedra_Library {

enum Result_Class {
  //! \hideinitializer Representable number result class.
  VC_NORMAL = 0U << 4,

  //! \hideinitializer Negative infinity result class.
  VC_MINUS_INFINITY = 1U << 4,

  //! \hideinitializer Positive infinity result class.
  VC_PLUS_INFINITY = 2U << 4,

  //! \hideinitializer Not a number result class.
  VC_NAN = 3U << 4,

  VC_MASK = VC_NAN
};

// This must be kept in sync with Relation_Symbol
enum Result_Relation {
  //! \hideinitializer No values satisfies the relation.
  VR_EMPTY = 0U,

  //! \hideinitializer Equal. This need to be accompanied by a value.
  VR_EQ = 1U,

  //! \hideinitializer Less than. This need to be accompanied by a value.
  VR_LT = 2U,

  //! \hideinitializer Greater than. This need to be accompanied by a value.
  VR_GT = 4U,

  //! \hideinitializer Not equal. This need to be accompanied by a value.
  VR_NE = VR_LT | VR_GT,

  //! \hideinitializer Less or equal. This need to be accompanied by a value.
  VR_LE = VR_EQ | VR_LT,

  //! \hideinitializer Greater or equal. This need to be accompanied by a value.
  VR_GE = VR_EQ | VR_GT,

  //! \hideinitializer All values satisfy the relation.
  VR_LGE = VR_LT | VR_EQ | VR_GT,

  VR_MASK = VR_LGE
};

//! Possible outcomes of a checked arithmetic computation.
/*! \ingroup PPL_CXX_interface */
enum Result {
  //! \hideinitializer The exact result is not comparable.
  V_EMPTY = VR_EMPTY,

  //! \hideinitializer The computed result is exact.
  V_EQ = static_cast<unsigned>(VR_EQ),

  //! \hideinitializer The computed result is inexact and rounded up.
  V_LT = static_cast<unsigned>(VR_LT),

  //! \hideinitializer The computed result is inexact and rounded down.
  V_GT = static_cast<unsigned>(VR_GT),

  //! \hideinitializer The computed result is inexact.
  V_NE = VR_NE,

  //! \hideinitializer The computed result may be inexact and rounded up.
  V_LE = VR_LE,

  //! \hideinitializer The computed result may be inexact and rounded down.
  V_GE = VR_GE,

  //! \hideinitializer The computed result may be inexact.
  V_LGE = VR_LGE,

  //! \hideinitializer The exact result is a number out of finite bounds.
  V_OVERFLOW = 1U << 6,

  //! \hideinitializer A negative integer overflow occurred (rounding up).
  V_LT_INF = V_LT | V_OVERFLOW,

  //! \hideinitializer A positive integer overflow occurred (rounding down).
  V_GT_SUP = V_GT | V_OVERFLOW,

  //! \hideinitializer A positive integer overflow occurred (rounding up).
  V_LT_PLUS_INFINITY = V_LT | static_cast<unsigned>(VC_PLUS_INFINITY),

  //! \hideinitializer A negative integer overflow occurred (rounding down).
  V_GT_MINUS_INFINITY = V_GT | static_cast<unsigned>(VC_MINUS_INFINITY),

  //! \hideinitializer Negative infinity result.
  V_EQ_MINUS_INFINITY = V_EQ | static_cast<unsigned>(VC_MINUS_INFINITY),

  //! \hideinitializer Positive infinity result.
  V_EQ_PLUS_INFINITY = V_EQ | static_cast<unsigned>(VC_PLUS_INFINITY),

  //! \hideinitializer Not a number result.
  V_NAN = static_cast<unsigned>(VC_NAN),

  //! \hideinitializer Converting from unknown string.
  V_CVT_STR_UNK = V_NAN | (1U << 8),

  //! \hideinitializer Dividing by zero.
  V_DIV_ZERO = V_NAN | (2U << 8),

  //! \hideinitializer Adding two infinities having opposite signs.
  V_INF_ADD_INF = V_NAN | (3U << 8),

  //! \hideinitializer Dividing two infinities.
  V_INF_DIV_INF = V_NAN | (4U << 8),

  //! \hideinitializer Taking the modulus of an infinity.
  V_INF_MOD = V_NAN | (5U << 8),

  //! \hideinitializer Multiplying an infinity by zero.
  V_INF_MUL_ZERO = V_NAN | (6U << 8),

  //! \hideinitializer Subtracting two infinities having the same sign.
  V_INF_SUB_INF = V_NAN | (7U << 8),

  //! \hideinitializer Computing a remainder modulo zero.
  V_MOD_ZERO = V_NAN | (8U << 8),

  //! \hideinitializer Taking the square root of a negative number.
  V_SQRT_NEG = V_NAN | (9U << 8),

  //! \hideinitializer Unknown result due to intermediate negative overflow.
  V_UNKNOWN_NEG_OVERFLOW = V_NAN | (10U << 8),

  //! \hideinitializer Unknown result due to intermediate positive overflow.
  V_UNKNOWN_POS_OVERFLOW = V_NAN | (11U << 8),

  //! \hideinitializer The computed result is not representable.
  V_UNREPRESENTABLE = 1U << 7

};

//! \name Functions Inspecting and/or Combining Result Values
//@{

/*! \ingroup PPL_CXX_interface */
Result operator&(Result x, Result y);

/*! \ingroup PPL_CXX_interface */
Result operator|(Result x, Result y);

/*! \ingroup PPL_CXX_interface */
Result operator-(Result x, Result y);

/*! \ingroup PPL_CXX_interface \brief
  Extracts the value class part of \p r (representable number,
  unrepresentable minus/plus infinity or nan).
*/
Result_Class result_class(Result r);

/*! \ingroup PPL_CXX_interface \brief
  Extracts the relation part of \p r.
*/
Result_Relation result_relation(Result r);

/*! \ingroup PPL_CXX_interface */
Result result_relation_class(Result r);

//@} // Functions Inspecting and/or Combining Result Values

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Result_inlines.hh line 1. */
/* Result supporting functions implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/assertions.hh line 1. */
/* Implementation of PPL assert-like macros.
*/


// The PPL_UNREACHABLE_MSG macro flags a program point as unreachable.
// Argument `msg__' is added to output when assertions are turned on.
#if defined(NDEBUG)
#define PPL_UNREACHABLE_MSG(msg__) Parma_Polyhedra_Library::ppl_unreachable()
#else
#define PPL_UNREACHABLE_MSG(msg__) Parma_Polyhedra_Library:: \
  ppl_unreachable_msg(msg__, __FILE__, __LINE__, __func__)
#endif

// The PPL_UNREACHABLE macro flags a program point as unreachable.
#define PPL_UNREACHABLE PPL_UNREACHABLE_MSG("unreachable")

// The PPL_ASSERTION_FAILED macro is used to output a message after
// an assertion failure and then cause program termination.
// (It is meant to be used only when assertions are turned on.)
#define PPL_ASSERTION_FAILED(msg__) Parma_Polyhedra_Library:: \
  ppl_assertion_failed(msg__, __FILE__, __LINE__, __func__)

// Helper macro PPL_ASSERT_IMPL_: do not use it directly.
#if defined(NDEBUG)
#define PPL_ASSERT_IMPL_(cond__) ((void) 0)
#else
#define PPL_STRING_(s) #s
#define PPL_ASSERT_IMPL_(cond__) \
  ((cond__) ? (void) 0 : PPL_ASSERTION_FAILED(PPL_STRING_(cond__)))
#endif


// Non zero to detect use of PPL_ASSERT instead of PPL_ASSERT_HEAVY
// Note: flag does not affect code built with NDEBUG defined.
#define PPL_DEBUG_PPL_ASSERT 1

// The PPL_ASSERT macro states that Boolean condition cond__ should hold.
// This is meant to replace uses of C assert().
#if defined(NDEBUG) || (!PPL_DEBUG_PPL_ASSERT)
#define PPL_ASSERT(cond__) PPL_ASSERT_IMPL_(cond__)
#else
// Note: here we have assertions enabled and PPL_DEBUG_PPL_ASSERT is 1.
// Check if the call to PPL_ASSERT should be replaced by PPL_ASSERT_HEAVY
// (i.e., if the former may interfere with computational weights).
#define PPL_ASSERT(cond__)                                        \
  do {                                                            \
    typedef Parma_Polyhedra_Library::Weightwatch_Traits W_Traits; \
    W_Traits::Threshold old_weight__ = W_Traits::weight;          \
    PPL_ASSERT_IMPL_(cond__);                                     \
    PPL_ASSERT_IMPL_(old_weight__ == W_Traits::weight             \
                     && ("PPL_ASSERT_HEAVY has to be used here" != 0)); \
  } while (false)
#endif // !defined(NDEBUG) && PPL_DEBUG_PPL_ASSERT


// Macro PPL_ASSERT_HEAVY is meant to be used when the evaluation of
// the assertion may change computational weights (via WEIGHT_ADD).
#if defined(NDEBUG)
#define PPL_ASSERT_HEAVY(cond__) PPL_ASSERT_IMPL_(cond__)
#else
#define PPL_ASSERT_HEAVY(cond__)                                \
  do {                                                          \
    Parma_Polyhedra_Library::In_Assert guard;                   \
    PPL_ASSERT_IMPL_(cond__);                                   \
  } while (false)
#endif // !defined(NDEBUG)


// Macro PPL_EXPECT (resp., PPL_EXPECT_HEAVY) should be used rather than
// PPL_ASSERT (resp., PPL_ASSERT_HEAVY) when the condition is assumed to
// hold but it is not under library control (typically, it depends on
// user provided input).
#define PPL_EXPECT(cond__) PPL_ASSERT(cond__)
#define PPL_EXPECT_HEAVY(cond__) PPL_ASSERT_HEAVY(cond__)


namespace Parma_Polyhedra_Library {

#if PPL_CXX_SUPPORTS_ATTRIBUTE_WEAK
#define PPL_WEAK_NORETURN __attribute__((weak, noreturn))
#else
#define PPL_WEAK_NORETURN __attribute__((noreturn))
#endif

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Helper function causing program termination by calling \c abort.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void ppl_unreachable() PPL_WEAK_NORETURN;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Helper function printing message on \c std::cerr and causing program
  termination by calling \c abort.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void ppl_unreachable_msg(const char* msg,
                         const char* file, unsigned int line,
                         const char* function) PPL_WEAK_NORETURN;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Helper function printing an assertion failure message on \c std::cerr
  and causing program termination by calling \c abort.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void ppl_assertion_failed(const char* assertion_text,
                          const char* file, unsigned int line,
                          const char* function) PPL_WEAK_NORETURN;


#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Returns \c true if and only if \p x_copy contains \p y_copy.

  \note
  This is a helper function for debugging purposes, to be used in assertions.
  The two arguments are meant to be passed by value, i.e., <em>copied</em>,
  so that their representations will not be affected by the containment check.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
bool copy_contains(T x_copy, T y_copy) {
  return x_copy.contains(y_copy);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Result_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

/*! \ingroup PPL_CXX_interface */
inline Result
operator&(Result x, Result y) {
  const unsigned res = static_cast<unsigned>(x) & static_cast<unsigned>(y);
  return static_cast<Result>(res);
}

/*! \ingroup PPL_CXX_interface */
inline Result
operator|(Result x, Result y) {
  const unsigned res = static_cast<unsigned>(x) | static_cast<unsigned>(y);
  return static_cast<Result>(res);
}

/*! \ingroup PPL_CXX_interface */
inline Result
operator-(Result x, Result y) {
  const Result y_neg = static_cast<Result>(~static_cast<unsigned>(y));
  return x & y_neg;
}

/*! \ingroup PPL_CXX_interface */
inline Result_Class
result_class(Result r) {
  const Result rc = r & static_cast<Result>(VC_MASK);
  return static_cast<Result_Class>(rc);
}

/*! \ingroup PPL_CXX_interface */
inline Result_Relation
result_relation(Result r) {
  const Result rc = r & static_cast<Result>(VR_MASK);
  return static_cast<Result_Relation>(rc);
}

/*! \ingroup PPL_CXX_interface */
inline Result
result_relation_class(Result r) {
  return r & (static_cast<Result>(VR_MASK) | static_cast<Result>(VC_MASK));
}

inline int
result_overflow(Result r) {
  switch (result_class(r)) {
  case VC_NORMAL:
    switch (r) {
    case V_LT_INF:
      return -1;
    case V_GT_SUP:
      return 1;
    default:
      break;
    }
    break;
  case VC_MINUS_INFINITY:
    return -1;
  case VC_PLUS_INFINITY:
    return 1;
  default:
    break;
  }
  return 0;
}

inline bool
result_representable(Result r) {
  return (r & V_UNREPRESENTABLE) != V_UNREPRESENTABLE;
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Result_defs.hh line 194. */

/* Automatically generated from PPL source file ../src/fpu_defs.hh line 1. */
/* Floating point unit related functions.
*/


/* Automatically generated from PPL source file ../src/fpu_types.hh line 1. */


#ifdef PPL_HAVE_IEEEFP_H
#include <ieeefp.h>
#endif

namespace Parma_Polyhedra_Library {

enum fpu_rounding_direction_type {};
enum fpu_rounding_control_word_type {};

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/compiler.hh line 1. */
/* C++ compiler related stuff.
*/


#include <cstddef>
#include <climits>
#include <cassert>

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  No-op macro that allows to avoid unused variable warnings from
  the compiler.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
#define PPL_USED(v) (void)(v)

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  No-op function that force the compiler to store the argument and
  to reread it from memory if needed (thus preventing CSE).
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
inline void
PPL_CC_FLUSH(const T& x) {
#if defined(__GNUC__) || defined(__INTEL_COMPILER)
  __asm__ __volatile__ ("" : "+m" (const_cast<T&>(x)));
#else
  // FIXME: is it possible to achieve the same effect in a portable way?
  PPL_USED(x);
#endif
}

#ifndef PPL_SUPPRESS_UNINIT_WARNINGS
#define PPL_SUPPRESS_UNINIT_WARNINGS 1
#endif

#ifndef PPL_SUPPRESS_UNINITIALIZED_WARNINGS
#define PPL_SUPPRESS_UNINITIALIZED_WARNINGS 1
#endif

#if PPL_SUPPRESS_UNINITIALIZED_WARNINGS
template <typename T>
struct Suppress_Uninitialized_Warnings_Type {
  typedef T synonym;
};

#define PPL_UNINITIALIZED(type, name)                                   \
  PPL_U(type) PPL_U(name)                                               \
  = Suppress_Uninitialized_Warnings_Type<PPL_U(type)>::synonym()
#else
#define PPL_UNINITIALIZED(type, name)           \
  PPL_U(type) name
#endif

#define sizeof_to_bits(size)                    \
  ((size) * static_cast<std::size_t>(CHAR_BIT))

#if !defined(__GNUC__)

inline unsigned int
clz32(uint32_t w) {
  unsigned int r = 31;
  if ((w & 0xffff0000U) != 0) {
    w >>= 16;
    r -= 16;
  }
  if ((w & 0xff00U) != 0) {
    w >>= 8;
    r -= 8;
  }
  if ((w & 0xf0U) != 0) {
    w >>= 4;
    r -= 4;
  }
  if ((w & 0xcU) != 0) {
    w >>= 2;
    r -= 2;
  }
  if ((w & 0x2U) != 0) {
    r -= 1;
  }
  return r;
}

inline unsigned int
clz64(uint64_t w) {
  if ((w & 0xffffffff00000000ULL) == 0) {
    return clz32(static_cast<uint32_t>(w)) + 32;
  }
  else {
    return clz32(static_cast<uint32_t>(w >> 32));
  }
}

inline unsigned int
ctz32(uint32_t w) {
  static const unsigned int mod37_table[] = {
    32, 0, 1, 26, 2, 23, 27, 0, 3, 16, 24, 30, 28, 11, 0, 13,
    4, 7, 17, 0, 25, 22, 31, 15, 29, 10, 12, 6, 0, 21, 14, 9,
    5, 20, 8, 19, 18
  };
  return mod37_table[(w & -w) % 37];
}

inline unsigned int
ctz64(uint64_t w) {
  if ((w & 0x00000000ffffffffULL) == 0) {
    return ctz32(static_cast<uint32_t>(w >> 32)) + 32;
  }
  else {
    return ctz32(static_cast<uint32_t>(w));
  }
}

#endif

inline unsigned int
clz(unsigned int u) {
  assert(u != 0);
#if defined(__GNUC__)
  return static_cast<unsigned int>(__builtin_clz(u));
#elif PPL_SIZEOF_INT == 4
  return clz32(u);
#elif PPL_SIZEOF_INT == 8
  return clz64(u);
#else
  #error "Unsupported unsigned int size"
#endif
}

inline unsigned int
clz(unsigned long ul) {
  assert(ul != 0);
#if defined(__GNUC__)
  return static_cast<unsigned int>(__builtin_clzl(ul));
#elif PPL_SIZEOF_LONG == 4
  return clz32(ul);
#elif PPL_SIZEOF_LONG == 8
  return clz64(ul);
#else
  #error "Unsupported unsigned long size"
#endif
}

inline unsigned int
clz(unsigned long long ull) {
  assert(ull != 0);
#if defined(__GNUC__)
  return static_cast<unsigned int>(__builtin_clzll(ull));
#elif PPL_SIZEOF_LONG_LONG == 4
  return clz32(ull);
#elif PPL_SIZEOF_LONG_LONG == 8
  return clz64(ull);
#else
  #error "Unsupported unsigned long long size"
#endif
}


inline unsigned int
ctz(unsigned int u) {
  assert(u != 0);
#if defined(__GNUC__)
  return static_cast<unsigned int>(__builtin_ctz(u));
#elif PPL_SIZEOF_INT == 4
  return ctz32(u);
#elif PPL_SIZEOF_INT == 8
  return ctz64(u);
#else
  #error "Unsupported unsigned int size"
#endif
}

inline unsigned int
ctz(unsigned long ul) {
  assert(ul != 0);
#if defined(__GNUC__)
  return static_cast<unsigned int>(__builtin_ctzl(ul));
#elif PPL_SIZEOF_LONG == 4
  return ctz32(ul);
#elif PPL_SIZEOF_LONG == 8
  return ctz64(ul);
#else
  #error "Unsupported unsigned long size"
#endif
}

inline unsigned int
ctz(unsigned long long ull) {
  assert(ull != 0);
#if defined(__GNUC__)
  return static_cast<unsigned int>(__builtin_ctzll(ull));
#elif PPL_SIZEOF_LONG_LONG == 4
  return ctz32(ull);
#elif PPL_SIZEOF_LONG_LONG == 8
  return ctz64(ull);
#else
  #error "Unsupported unsigned long long size"
#endif
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/fpu_defs.hh line 29. */

namespace Parma_Polyhedra_Library {

//! \name Functions Controlling Floating Point Unit
//@{

//! Initializes the FPU control functions.
void
fpu_initialize_control_functions();

//! Returns the current FPU rounding direction.
fpu_rounding_direction_type
fpu_get_rounding_direction();

//! Sets the FPU rounding direction to \p dir.
void
fpu_set_rounding_direction(fpu_rounding_direction_type dir);

/*! \brief
  Sets the FPU rounding direction to \p dir and returns the rounding
  control word previously in use.
*/
fpu_rounding_control_word_type
fpu_save_rounding_direction(fpu_rounding_direction_type dir);

/*! \brief
  Sets the FPU rounding direction to \p dir, clears the <EM>inexact
  computation</EM> status, and returns the rounding control word
  previously in use.
*/
fpu_rounding_control_word_type
fpu_save_rounding_direction_reset_inexact(fpu_rounding_direction_type dir);

//! Restores the FPU rounding rounding control word to \p cw.
void
fpu_restore_rounding_direction(fpu_rounding_control_word_type w);

//! Clears the <EM>inexact computation</EM> status.
void
fpu_reset_inexact();

/*! \brief
  Queries the <EM>inexact computation</EM> status.

  Returns 0 if the computation was definitely exact, 1 if it was
  definitely inexact, -1 if definite exactness information is unavailable.
*/
int
fpu_check_inexact();

//@} // Functions Controlling Floating Point Unit

} // namespace Parma_Polyhedra_Library

#if PPL_CAN_CONTROL_FPU

#if defined(__i386__) && (defined(__GNUC__) || defined(__INTEL_COMPILER))
/* Automatically generated from PPL source file ../src/fpu-ia32_inlines.hh line 1. */
/* IA-32 floating point unit inline related functions.
*/


#include <csetjmp>
#include <csignal>

#define FPU_INVALID       0x01
#define FPU_DIVBYZERO     0x04
#define FPU_OVERFLOW      0x08
#define FPU_UNDERFLOW     0x10
#define FPU_INEXACT       0x20

#define FPU_ALL_EXCEPT \
  (FPU_INEXACT | FPU_DIVBYZERO | FPU_UNDERFLOW | FPU_OVERFLOW | FPU_INVALID)

#define PPL_FPU_TONEAREST     0
#define PPL_FPU_DOWNWARD      0x400
#define PPL_FPU_UPWARD        0x800
#define PPL_FPU_TOWARDZERO    0xc00

#define FPU_ROUNDING_MASK 0xc00

#define SSE_INEXACT       0x20

#define PPL_FPU_CONTROL_DEFAULT_BASE 0x37f
#define PPL_SSE_CONTROL_DEFAULT_BASE 0x1f80

// This MUST be congruent with the definition of ROUND_DIRECT
#define PPL_FPU_CONTROL_DEFAULT \
  (PPL_FPU_CONTROL_DEFAULT_BASE | PPL_FPU_UPWARD)
#define PPL_SSE_CONTROL_DEFAULT \
  (PPL_SSE_CONTROL_DEFAULT_BASE | (PPL_FPU_UPWARD << 3))

namespace Parma_Polyhedra_Library {

typedef struct {
  unsigned short control_word;
  unsigned short unused1;
  unsigned short status_word;
  unsigned short unused2;
  unsigned short tags;
  unsigned short unused3;
  unsigned int eip;
  unsigned short cs_selector;
  unsigned int opcode:11;
  unsigned int unused4:5;
  unsigned int data_offset;
  unsigned short data_selector;
  unsigned short unused5;
} ia32_fenv_t;

inline int
fpu_get_control() {
  unsigned short cw;
  __asm__ __volatile__ ("fnstcw %0" : "=m" (*&cw) : : "memory");
  return cw;
}

inline void
fpu_set_control(int c) {
  unsigned short cw = static_cast<unsigned short>(c);
  __asm__ __volatile__ ("fldcw %0" : : "m" (*&cw) : "memory");
}

inline int
fpu_get_status() {
  unsigned short sw;
  __asm__ __volatile__ ("fnstsw %0" : "=a" (sw) : : "memory");
  return sw;
}

inline void
fpu_clear_status(unsigned short bits) {
  /* There is no fldsw instruction */
  ia32_fenv_t env;
  __asm__ __volatile__ ("fnstenv %0" : "=m" (env));
  env.status_word = static_cast<unsigned short>(env.status_word & ~bits);
  __asm__ __volatile__ ("fldenv %0" : : "m" (env) : "memory");
}

inline void
fpu_clear_exceptions() {
  __asm__ __volatile__ ("fnclex" : /* No outputs.  */ : : "memory");
}

#ifdef PPL_FPMATH_MAY_USE_SSE
inline void
sse_set_control(unsigned int cw) {
  __asm__ __volatile__ ("ldmxcsr %0" : : "m" (*&cw) : "memory");
}

inline unsigned int
sse_get_control() {
  unsigned int cw;
  __asm__ __volatile__ ("stmxcsr %0" : "=m" (*&cw) : : "memory");
  return cw;
}
#endif

inline void
fpu_initialize_control_functions() {
#ifdef PPL_FPMATH_MAY_USE_SSE
  extern void detect_sse_unit();
  detect_sse_unit();
#endif
}

inline fpu_rounding_direction_type
fpu_get_rounding_direction() {
  return static_cast<fpu_rounding_direction_type>(fpu_get_control() & FPU_ROUNDING_MASK);
}

inline void
fpu_set_rounding_direction(fpu_rounding_direction_type dir) {
#ifdef PPL_FPMATH_MAY_USE_387
  fpu_set_control(PPL_FPU_CONTROL_DEFAULT_BASE | dir);
#endif
#ifdef PPL_FPMATH_MAY_USE_SSE
  extern bool have_sse_unit;
  if (have_sse_unit)
    sse_set_control(PPL_SSE_CONTROL_DEFAULT_BASE | (dir << 3));
#endif
}

inline fpu_rounding_control_word_type
fpu_save_rounding_direction(fpu_rounding_direction_type dir) {
#ifdef PPL_FPMATH_MAY_USE_387
  fpu_set_control(PPL_FPU_CONTROL_DEFAULT_BASE | dir);
#endif
#ifdef PPL_FPMATH_MAY_USE_SSE
  extern bool have_sse_unit;
  if (have_sse_unit)
    sse_set_control(PPL_SSE_CONTROL_DEFAULT_BASE | (dir << 3));
#endif
  return static_cast<fpu_rounding_control_word_type>(0);
}

inline void
fpu_reset_inexact() {
#ifdef PPL_FPMATH_MAY_USE_387
  fpu_clear_exceptions();
#endif
#ifdef PPL_FPMATH_MAY_USE_SSE
  // NOTE: on entry to this function the current rounding mode
  // has to be the default one.
  extern bool have_sse_unit;
  if (have_sse_unit) {
    sse_set_control(PPL_SSE_CONTROL_DEFAULT);
  }
#endif
}

inline void
fpu_restore_rounding_direction(fpu_rounding_control_word_type) {
#ifdef PPL_FPMATH_MAY_USE_387
  fpu_set_control(PPL_FPU_CONTROL_DEFAULT);
#endif
#ifdef PPL_FPMATH_MAY_USE_SSE
  extern bool have_sse_unit;
  if (have_sse_unit) {
    sse_set_control(PPL_SSE_CONTROL_DEFAULT);
  }
#endif
}

inline int
fpu_check_inexact() {
#ifdef PPL_FPMATH_MAY_USE_387
  if (fpu_get_status() & FPU_INEXACT) {
    return 1;
  }
#endif
#ifdef PPL_FPMATH_MAY_USE_SSE
  extern bool have_sse_unit;
  if (have_sse_unit && (sse_get_control() & SSE_INEXACT)) {
    return 1;
  }
#endif
  return 0;
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/fpu_defs.hh line 87. */
#elif defined(PPL_HAVE_IEEEFP_H)                                        \
  && (defined(__sparc)                                                  \
      || defined(sparc)                                                 \
      || defined(__sparc__))
/* Automatically generated from PPL source file ../src/fpu-sparc_inlines.hh line 1. */
/* SPARC floating point unit related functions.
*/


#ifdef PPL_HAVE_IEEEFP_H
#include <ieeefp.h>

#define PPL_FPU_TONEAREST  ((int) FP_RN)
#define PPL_FPU_UPWARD     ((int) FP_RP)
#define PPL_FPU_DOWNWARD   ((int) FP_RM)
#define PPL_FPU_TOWARDZERO ((int) FP_RZ)

namespace Parma_Polyhedra_Library {

inline void
fpu_initialize_control_functions() {
}

inline fpu_rounding_direction_type
fpu_get_rounding_direction() {
  return static_cast<fpu_rounding_direction_type>(fpgetround());
}

inline void
fpu_set_rounding_direction(fpu_rounding_direction_type dir) {
  fpsetround((fp_rnd) dir);
}

inline fpu_rounding_control_word_type
fpu_save_rounding_direction(fpu_rounding_direction_type dir) {
  return static_cast<fpu_rounding_control_word_type>(fpsetround((fp_rnd) dir));
}

inline void
fpu_reset_inexact() {
  fp_except except = fpgetmask();
  except &= ~FP_X_IMP;
  fpsetmask(except);
}

inline void
fpu_restore_rounding_direction(fpu_rounding_control_word_type w) {
  fpsetround((fp_rnd) w);
}

inline int
fpu_check_inexact() {
  return (fpgetmask() & FP_X_IMP) ? 1 : 0;
}

} // namespace Parma_Polyhedra_Library

#endif // !defined(PPL_HAVE_IEEEFP_H)

/* Automatically generated from PPL source file ../src/fpu_defs.hh line 92. */
#elif defined(PPL_HAVE_FENV_H)
/* Automatically generated from PPL source file ../src/fpu-c99_inlines.hh line 1. */
/* C99 Floating point unit related functions.
*/


#ifdef PPL_HAVE_FENV_H
#include <fenv.h>
#include <stdexcept>

#ifdef FE_TONEAREST
#define PPL_FPU_TONEAREST FE_TONEAREST
#endif
#ifdef FE_UPWARD
#define PPL_FPU_UPWARD FE_UPWARD
#endif
#ifdef FE_DOWNWARD
#define PPL_FPU_DOWNWARD FE_DOWNWARD
#endif
#ifdef FE_TOWARDZERO
#define PPL_FPU_TOWARDZERO FE_TOWARDZERO
#endif

namespace Parma_Polyhedra_Library {

inline void
fpu_initialize_control_functions() {
  const int old = fegetround();
  if (fesetround(PPL_FPU_DOWNWARD) != 0
      || fesetround(PPL_FPU_UPWARD) != 0
      || fesetround(old) != 0) {
    throw std::logic_error("PPL configuration error:"
                           " PPL_CAN_CONTROL_FPU evaluates to true,"
                           " but fesetround() returns nonzero.");
  }
}

inline fpu_rounding_direction_type
fpu_get_rounding_direction() {
  return static_cast<fpu_rounding_direction_type>(fegetround());
}

inline void
fpu_set_rounding_direction(fpu_rounding_direction_type dir) {
  fesetround(dir);
}

inline fpu_rounding_control_word_type
fpu_save_rounding_direction(fpu_rounding_direction_type dir) {
  const fpu_rounding_control_word_type old
    = static_cast<fpu_rounding_control_word_type>(fegetround());
  fesetround(dir);
  return old;
}

inline void
fpu_reset_inexact() {
#if PPL_CXX_SUPPORTS_IEEE_INEXACT_FLAG
  feclearexcept(FE_INEXACT);
#endif
}

inline void
fpu_restore_rounding_direction(fpu_rounding_control_word_type w) {
  fesetround(w);
}

inline int
fpu_check_inexact() {
#if PPL_CXX_SUPPORTS_IEEE_INEXACT_FLAG
  return fetestexcept(FE_INEXACT) != 0 ? 1 : 0;
#else
  return -1;
#endif
}

} // namespace Parma_Polyhedra_Library

#endif // !defined(PPL_HAVE_FENV_H)

/* Automatically generated from PPL source file ../src/fpu_defs.hh line 94. */
#else
#error "PPL_CAN_CONTROL_FPU evaluates to true: why?"
#endif

#else // !PPL_CAN_CONTROL_FPU

/* Automatically generated from PPL source file ../src/fpu-none_inlines.hh line 1. */
/* Null floating point unit related functions.
*/


#include <stdexcept>

namespace Parma_Polyhedra_Library {

inline void
fpu_initialize_control_functions() {
  throw std::logic_error("PPL::fpu_initialize_control_functions():"
                         " cannot control the FPU");
}

inline fpu_rounding_direction_type
fpu_get_rounding_direction() {
  throw std::logic_error("PPL::fpu_get_rounding_direction():"
                         " cannot control the FPU");
}

inline void
fpu_set_rounding_direction(int) {
  throw std::logic_error("PPL::fpu_set_rounding_direction():"
                         " cannot control the FPU");
}

inline int
fpu_save_rounding_direction(int) {
  throw std::logic_error("PPL::fpu_save_rounding_direction():"
                         " cannot control the FPU");
}

inline void
fpu_reset_inexact() {
  throw std::logic_error("PPL::fpu_reset_inexact():"
                         " cannot control the FPU");
}

inline void
fpu_restore_rounding_direction(int) {
  throw std::logic_error("PPL::fpu_restore_rounding_direction():"
                         " cannot control the FPU");
}

inline int
fpu_check_inexact() {
  throw std::logic_error("PPL::fpu_check_inexact():"
                         " cannot control the FPU");
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/fpu_defs.hh line 101. */

#endif // !PPL_CAN_CONTROL_FPU

/* Automatically generated from PPL source file ../src/Rounding_Dir_defs.hh line 29. */

namespace Parma_Polyhedra_Library {

//! Rounding directions for arithmetic computations.
/*! \ingroup PPL_CXX_interface */
enum Rounding_Dir {
  /*! \hideinitializer
    Round toward \f$-\infty\f$.
  */
  ROUND_DOWN = 0U,

  /*! \hideinitializer
    Round toward \f$+\infty\f$.
  */
  ROUND_UP = 1U,

  /*! \hideinitializer
    Rounding is delegated to lower level. Result info is evaluated lazily.
  */
  ROUND_IGNORE = 6U,
  ROUND_NATIVE = ROUND_IGNORE,

  /*! \hideinitializer
    Rounding is not needed: client code must ensure that the operation
    result is exact and representable in the destination type.
    Result info is evaluated lazily.
  */
  ROUND_NOT_NEEDED = 7U,

  ROUND_DIRECT = ROUND_UP,
  ROUND_INVERSE = ROUND_DOWN,

  ROUND_DIR_MASK = 7U,

  /*! \hideinitializer
    The client code is willing to pay an extra price to know the exact
    relation between the exact result and the computed one.
   */
  ROUND_STRICT_RELATION = 8U,

  ROUND_CHECK = ROUND_DIRECT | ROUND_STRICT_RELATION
};

//! \name Functions Inspecting and/or Combining Rounding_Dir Values
//@{

/*! \ingroup PPL_CXX_interface */
Rounding_Dir operator&(Rounding_Dir x, Rounding_Dir y);

/*! \ingroup PPL_CXX_interface */
Rounding_Dir operator|(Rounding_Dir x, Rounding_Dir y);

/*! \ingroup PPL_CXX_interface \brief
  Returns the inverse rounding mode of \p dir,
  <CODE>ROUND_IGNORE</CODE> being the inverse of itself.
*/
Rounding_Dir inverse(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
Rounding_Dir round_dir(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
bool round_down(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
bool round_up(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
bool round_ignore(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
bool round_not_needed(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
bool round_not_requested(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
bool round_direct(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
bool round_inverse(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
bool round_strict_relation(Rounding_Dir dir);

/*! \ingroup PPL_CXX_interface */
fpu_rounding_direction_type round_fpu_dir(Rounding_Dir dir);

//@} // Functions Inspecting and/or Combining Rounding_Dir Values

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Rounding_Dir_inlines.hh line 1. */
/* Inline functions operating on enum Rounding_Dir values.
*/


/* Automatically generated from PPL source file ../src/Rounding_Dir_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

/*! \ingroup PPL_CXX_interface */
inline Rounding_Dir
operator&(Rounding_Dir x, Rounding_Dir y) {
  const unsigned res = static_cast<unsigned>(x) & static_cast<unsigned>(y);
  return static_cast<Rounding_Dir>(res);
}

/*! \ingroup PPL_CXX_interface */
inline Rounding_Dir
operator|(Rounding_Dir x, Rounding_Dir y) {
  const unsigned res = static_cast<unsigned>(x) | static_cast<unsigned>(y);
  return static_cast<Rounding_Dir>(res);
}

/*! \ingroup PPL_CXX_interface */
inline Rounding_Dir
round_dir(Rounding_Dir dir) {
  return dir & ROUND_DIR_MASK;
}

/*! \ingroup PPL_CXX_interface */
inline bool
round_down(Rounding_Dir dir) {
  return round_dir(dir) == ROUND_DOWN;
}

/*! \ingroup PPL_CXX_interface */
inline bool
round_up(Rounding_Dir dir) {
  return round_dir(dir) == ROUND_UP;
}

/*! \ingroup PPL_CXX_interface */
inline bool
round_ignore(Rounding_Dir dir) {
  return round_dir(dir) == ROUND_IGNORE;
}

/*! \ingroup PPL_CXX_interface */
inline bool
round_not_needed(Rounding_Dir dir) {
  return round_dir(dir) == ROUND_NOT_NEEDED;
}

/*! \ingroup PPL_CXX_interface */
inline bool
round_not_requested(Rounding_Dir dir) {
  return round_dir(dir) == ROUND_IGNORE || round_dir(dir) == ROUND_NOT_NEEDED;
}

/*! \ingroup PPL_CXX_interface */
inline bool
round_direct(Rounding_Dir dir) {
  return round_dir(dir) == ROUND_DIRECT;
}

/*! \ingroup PPL_CXX_interface */
inline bool
round_inverse(Rounding_Dir dir) {
  return round_dir(dir) == ROUND_INVERSE;
}

/*! \ingroup PPL_CXX_interface */
inline bool
round_strict_relation(Rounding_Dir dir) {
  return (dir & ROUND_STRICT_RELATION) == ROUND_STRICT_RELATION;
}

#if PPL_CAN_CONTROL_FPU

/*! \ingroup PPL_CXX_interface */
inline fpu_rounding_direction_type
round_fpu_dir(Rounding_Dir dir) {
  switch (round_dir(dir)) {
  case ROUND_UP:
    return static_cast<fpu_rounding_direction_type>(PPL_FPU_UPWARD);
  case ROUND_DOWN:
    return static_cast<fpu_rounding_direction_type>(PPL_FPU_DOWNWARD);
  case ROUND_IGNORE: // Fall through.
  default:
    PPL_UNREACHABLE;
    return static_cast<fpu_rounding_direction_type>(PPL_FPU_UPWARD);
  }
}

#undef PPL_FPU_DOWNWARD
#undef PPL_FPU_TONEAREST
#undef PPL_FPU_TOWARDZERO
#undef PPL_FPU_UPWARD

#endif

/*! \ingroup PPL_CXX_interface */
inline Rounding_Dir
inverse(Rounding_Dir dir) {
  switch (round_dir(dir)) {
  case ROUND_UP:
    return ROUND_DOWN | (dir & ROUND_STRICT_RELATION);
  case ROUND_DOWN:
    return ROUND_UP | (dir & ROUND_STRICT_RELATION);
  case ROUND_IGNORE:
    return dir;
  default:
    PPL_UNREACHABLE;
    return dir;
  }
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Rounding_Dir_defs.hh line 122. */


/* Automatically generated from PPL source file ../src/Numeric_Format_defs.hh line 1. */
/* Numeric format.
*/


/* Automatically generated from PPL source file ../src/Numeric_Format_defs.hh line 29. */

namespace Parma_Polyhedra_Library {

class Numeric_Format {
};

} // namespace Parma_Polyhedra_Library


/* Automatically generated from PPL source file ../src/Float_defs.hh line 1. */
/* IEC 559 floating point format related functions.
*/


/* Automatically generated from PPL source file ../src/globals_types.hh line 1. */


#include <cstddef>

namespace Parma_Polyhedra_Library {

//! An unsigned integral type for representing space dimensions.
/*! \ingroup PPL_CXX_interface */
typedef size_t dimension_type;

//! An unsigned integral type for representing memory size in bytes.
/*! \ingroup PPL_CXX_interface */
typedef size_t memory_size_type;

//! Kinds of degenerate abstract elements.
/*! \ingroup PPL_CXX_interface */
enum Degenerate_Element {
  //! The universe element, i.e., the whole vector space.
  UNIVERSE,
  //! The empty element, i.e., the empty set.
  EMPTY
};

//! Relation symbols.
/*! \ingroup PPL_CXX_interface */
// This must be kept in sync with Result
enum Relation_Symbol {
  //! \hideinitializer Equal to.
  EQUAL = 1U,
  //! \hideinitializer Less than.
  LESS_THAN = 2U,
  //! \hideinitializer Less than or equal to.
  LESS_OR_EQUAL = LESS_THAN | EQUAL,
  //! \hideinitializer Greater than.
  GREATER_THAN = 4U,
  //! \hideinitializer Greater than or equal to.
  GREATER_OR_EQUAL = GREATER_THAN | EQUAL,
  //! \hideinitializer Not equal to.
  NOT_EQUAL = LESS_THAN | GREATER_THAN
};

//! Complexity pseudo-classes.
/*! \ingroup PPL_CXX_interface */
enum Complexity_Class {
  //! Worst-case polynomial complexity.
  POLYNOMIAL_COMPLEXITY,
  //! Worst-case exponential complexity but typically polynomial behavior.
  SIMPLEX_COMPLEXITY,
  //! Any complexity.
  ANY_COMPLEXITY
};

//! Possible optimization modes.
/*! \ingroup PPL_CXX_interface */
enum Optimization_Mode {
  //! Minimization is requested.
  MINIMIZATION,
  //! Maximization is requested.
  MAXIMIZATION
};

/*! \ingroup PPL_CXX_interface \brief
  Widths of bounded integer types.

  See the section on
  \ref Approximating_Bounded_Integers "approximating bounded integers".
*/
enum Bounded_Integer_Type_Width {
  //! \hideinitializer 8 bits.
  BITS_8 = 8,

  //! \hideinitializer 16 bits.
  BITS_16 = 16,

  //! \hideinitializer 32 bits.
  BITS_32 = 32,

  //! \hideinitializer 64 bits.
  BITS_64 = 64,

  //! \hideinitializer 128 bits.
  BITS_128 = 128
};

/*! \ingroup PPL_CXX_interface \brief
  Representation of bounded integer types.

  See the section on
  \ref Approximating_Bounded_Integers "approximating bounded integers".
*/
enum Bounded_Integer_Type_Representation {
  //! Unsigned binary.
  UNSIGNED,

  /*! \brief
    Signed binary where negative values are represented by the two's
    complement of the absolute value.
  */
  SIGNED_2_COMPLEMENT
};

/*! \ingroup PPL_CXX_interface \brief
  Overflow behavior of bounded integer types.

  See the section on
  \ref Approximating_Bounded_Integers "approximating bounded integers".
*/
enum Bounded_Integer_Type_Overflow {
  /*! \brief
    On overflow, wrapping takes place.

    This means that, for a \f$w\f$-bit bounded integer, the computation
    happens modulo \f$2^w\f$.
  */
  OVERFLOW_WRAPS,

  /*! \brief
    On overflow, the result is undefined.

    This simply means that the result of the operation resulting in an
    overflow can take any value.

    \note
    Even though something more serious can happen in the system
    being analyzed ---due to, e.g., C's undefined behavior---, here we
    are only concerned with the results of arithmetic operations.
    It is the responsibility of the analyzer to ensure that other
    manifestations of undefined behavior are conservatively approximated.
  */
  OVERFLOW_UNDEFINED,

  /*! \brief
    Overflow is impossible.

    This is for the analysis of languages where overflow is trapped
    before it affects the state, for which, thus, any indication that
    an overflow may have affected the state is necessarily due to
    the imprecision of the analysis.
  */
  OVERFLOW_IMPOSSIBLE
};

/*! \ingroup PPL_CXX_interface \brief
  Possible representations of coefficient sequences (i.e. linear expressions
  and more complex objects containing linear expressions, e.g. Constraints,
  Generators, etc.).
*/
enum Representation {
  /*! \brief
    Dense representation: the coefficient sequence is represented as a vector
    of coefficients, including the zero coefficients.
    If there are only a few nonzero coefficients, this representation is
    faster and also uses a bit less memory.
  */
  DENSE,

  /*! \brief
    Sparse representation: only the nonzero coefficient are stored.
    If there are many nonzero coefficients, this improves memory consumption
    and run time (both because there is less data to process in O(n)
    operations and because finding zeroes/nonzeroes is much faster since
    zeroes are not stored at all, so any stored coefficient is nonzero).
  */
  SPARSE
};

/*! \ingroup PPL_CXX_interface \brief
  Floating point formats known to the library.

  The parameters of each format are defined by a specific struct
  in file Float_defs.hh.  See the section on \ref floating_point
  "Analysis of floating point computations" for more information.
*/
enum Floating_Point_Format {
  //! IEEE 754 half precision, 16 bits (5 exponent, 10 mantissa).
  IEEE754_HALF,

  //! IEEE 754 single precision, 32 bits (8 exponent, 23 mantissa).
  IEEE754_SINGLE,

  //! IEEE 754 double precision, 64 bits (11 exponent, 52 mantissa).
  IEEE754_DOUBLE,

  //! IEEE 754 quad precision, 128 bits (15 exponent, 112 mantissa).
  IEEE754_QUAD,

  //! Intel double extended precision, 80 bits (15 exponent, 64 mantissa)
  INTEL_DOUBLE_EXTENDED,

  //! IBM single precision, 32 bits (7 exponent, 24 mantissa).
  IBM_SINGLE,

  //! IBM double precision, 64 bits (7 exponent, 56 mantissa).
  IBM_DOUBLE
};

struct Weightwatch_Traits;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Concrete_Expression_types.hh line 1. */


namespace Parma_Polyhedra_Library {

/*
  NOTE: Doxygen seems to ignore documentation blocks attached to
  template class declarations that are not provided with a definition.
  This justifies (here below) the explicit use of Doxygen command \class.
*/

/*! \brief The base class of all concrete expressions.
  \class Parma_Polyhedra_Library::Concrete_Expression
*/
template <typename Target>
class Concrete_Expression;

/*! \brief A binary operator applied to two concrete expressions.
  \class Parma_Polyhedra_Library::Binary_Operator
*/
template <typename Target>
class Binary_Operator;

/*! \brief A unary operator applied to one concrete expression.
  \class Parma_Polyhedra_Library::Unary_Operator
*/
template <typename Target>
class Unary_Operator;

/*! \brief A cast operator converting one concrete expression to some type.
  \class Parma_Polyhedra_Library::Cast_Operator
*/
template <typename Target>
class Cast_Operator;

/*! \brief An integer constant concrete expression.
  \class Parma_Polyhedra_Library::Integer_Constant
*/
template <typename Target>
class Integer_Constant;

/*! \brief A floating-point constant concrete expression.
  \class Parma_Polyhedra_Library::Floating_Point_Constant
*/
template <typename Target>
class Floating_Point_Constant;

/*! \brief A concrete expression representing a reference to some approximable.
  \class Parma_Polyhedra_Library::Approximable_Reference
*/
template <typename Target>
class Approximable_Reference;

class Concrete_Expression_Type;

/*! \brief
  Encodes the kind of concrete expression.

  The values should be defined by the particular instance
  and uniquely identify one of: Binary_Operator, Unary_Operator,
  Cast_Operator, Integer_Constant, Floating_Point_Constant, or
  Approximable_Reference.  For example, the Binary_Operator kind
  integer constant should be defined by an instance as the member
  <CODE>Binary_Operator\<T\>::%KIND</CODE>.
*/
typedef int Concrete_Expression_Kind;

/*! \brief
  Encodes a binary operator of concrete expressions.

  The values should be uniquely defined by the particular instance and
  named: ADD, SUB, MUL, DIV, REM, BAND, BOR, BXOR, LSHIFT, RSHIFT.
*/
typedef int Concrete_Expression_BOP;

/*! \brief
  Encodes a unary operator of concrete expressions.

  The values should be uniquely defined by the particular instance and
  named: PLUS, MINUS, BNOT.
*/
typedef int Concrete_Expression_UOP;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Variable_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Variable;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Form_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename C>
class Linear_Form;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Float_defs.hh line 33. */
#include <set>
#include <cmath>
#include <map>
#include <gmp.h>

#ifdef NAN
#define PPL_NAN NAN
#else
#define PPL_NAN (HUGE_VAL - HUGE_VAL)
#endif

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct float_ieee754_half {
  uint16_t word;
  static const uint16_t SGN_MASK = 0x8000U;
  static const uint16_t EXP_MASK = 0xfc00U;
  static const uint16_t WRD_MAX = 0x7bffU;
  static const uint16_t POS_INF = 0x7c00U;
  static const uint16_t NEG_INF = 0xfc00U;
  static const uint16_t POS_ZERO = 0x0000U;
  static const uint16_t NEG_ZERO = 0x8000U;
  static const unsigned int BASE = 2;
  static const unsigned int EXPONENT_BITS = 5;
  static const unsigned int MANTISSA_BITS = 10;
  static const int EXPONENT_MAX = (1 << (EXPONENT_BITS - 1)) - 1;
  static const int EXPONENT_BIAS = EXPONENT_MAX;
  static const int EXPONENT_MIN = -EXPONENT_MAX + 1;
  static const int EXPONENT_MIN_DENORM = EXPONENT_MIN
                                        - static_cast<int>(MANTISSA_BITS);
  static const Floating_Point_Format floating_point_format = IEEE754_HALF;
  int inf_sign() const;
  bool is_nan() const;
  int zero_sign() const;
  bool sign_bit() const;
  void negate();
  void dec();
  void inc();
  void set_max(bool negative);
  void build(bool negative, mpz_t mantissa, int exponent);

};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct float_ieee754_single {
  uint32_t word;
  static const uint32_t SGN_MASK = 0x80000000U;
  static const uint32_t EXP_MASK = 0x7f800000U;
  static const uint32_t WRD_MAX = 0x7f7fffffU;
  static const uint32_t POS_INF = 0x7f800000U;
  static const uint32_t NEG_INF = 0xff800000U;
  static const uint32_t POS_ZERO = 0x00000000U;
  static const uint32_t NEG_ZERO = 0x80000000U;
  static const unsigned int BASE = 2;
  static const unsigned int EXPONENT_BITS = 8;
  static const unsigned int MANTISSA_BITS = 23;
  static const int EXPONENT_MAX = (1 << (EXPONENT_BITS - 1)) - 1;
  static const int EXPONENT_BIAS = EXPONENT_MAX;
  static const int EXPONENT_MIN = -EXPONENT_MAX + 1;
  static const int EXPONENT_MIN_DENORM = EXPONENT_MIN
                                        - static_cast<int>(MANTISSA_BITS);
  static const Floating_Point_Format floating_point_format = IEEE754_SINGLE;
  int inf_sign() const;
  bool is_nan() const;
  int zero_sign() const;
  bool sign_bit() const;
  void negate();
  void dec();
  void inc();
  void set_max(bool negative);
  void build(bool negative, mpz_t mantissa, int exponent);
};

#ifdef WORDS_BIGENDIAN
#ifndef PPL_WORDS_BIGENDIAN
#define PPL_WORDS_BIGENDIAN
#endif
#endif

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct float_ieee754_double {
#ifdef PPL_WORDS_BIGENDIAN
  uint32_t msp;
  uint32_t lsp;
#else
  uint32_t lsp;
  uint32_t msp;
#endif
  static const uint32_t MSP_SGN_MASK = 0x80000000U;
  static const uint32_t MSP_POS_INF = 0x7ff00000U;
  static const uint32_t MSP_NEG_INF = 0xfff00000U;
  static const uint32_t MSP_POS_ZERO = 0x00000000U;
  static const uint32_t MSP_NEG_ZERO = 0x80000000U;
  static const uint32_t LSP_INF = 0;
  static const uint32_t LSP_ZERO = 0;
  static const uint32_t MSP_MAX = 0x7fefffffU;
  static const uint32_t LSP_MAX = 0xffffffffU;
  static const unsigned int BASE = 2;
  static const unsigned int EXPONENT_BITS = 11;
  static const unsigned int MANTISSA_BITS = 52;
  static const int EXPONENT_MAX = (1 << (EXPONENT_BITS - 1)) - 1;
  static const int EXPONENT_BIAS = EXPONENT_MAX;
  static const int EXPONENT_MIN = -EXPONENT_MAX + 1;
  static const int EXPONENT_MIN_DENORM = EXPONENT_MIN
                                        - static_cast<int>(MANTISSA_BITS);
  static const Floating_Point_Format floating_point_format = IEEE754_DOUBLE;
  int inf_sign() const;
  bool is_nan() const;
  int zero_sign() const;
  bool sign_bit() const;
  void negate();
  void dec();
  void inc();
  void set_max(bool negative);
  void build(bool negative, mpz_t mantissa, int exponent);
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct float_ibm_single {
  uint32_t word;
  static const uint32_t SGN_MASK = 0x80000000U;
  static const uint32_t EXP_MASK = 0x7f000000U;
  static const uint32_t WRD_MAX = 0x7fffffffU;
  static const uint32_t POS_INF = 0x7f000000U;
  static const uint32_t NEG_INF = 0xff000000U;
  static const uint32_t POS_ZERO = 0x00000000U;
  static const uint32_t NEG_ZERO = 0x80000000U;
  static const unsigned int BASE = 16;
  static const unsigned int EXPONENT_BITS = 7;
  static const unsigned int MANTISSA_BITS = 24;
  static const int EXPONENT_BIAS = 64;
  static const int EXPONENT_MAX = (1 << (EXPONENT_BITS - 1)) - 1;
  static const int EXPONENT_MIN = -EXPONENT_MAX + 1;
  static const int EXPONENT_MIN_DENORM = EXPONENT_MIN
                                        - static_cast<int>(MANTISSA_BITS);
  static const Floating_Point_Format floating_point_format = IBM_SINGLE;
  int inf_sign() const;
  bool is_nan() const;
  int zero_sign() const;
  bool sign_bit() const;
  void negate();
  void dec();
  void inc();
  void set_max(bool negative);
  void build(bool negative, mpz_t mantissa, int exponent);
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct float_ibm_double {
  static const unsigned int BASE = 16;
  static const unsigned int EXPONENT_BITS = 7;
  static const unsigned int MANTISSA_BITS = 56;
  static const int EXPONENT_BIAS = 64;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct float_intel_double_extended {
#ifdef PPL_WORDS_BIGENDIAN
  uint32_t msp;
  uint64_t lsp;
#else
  uint64_t lsp;
  uint32_t msp;
#endif
  static const uint32_t MSP_SGN_MASK = 0x00008000U;
  static const uint32_t MSP_POS_INF = 0x00007fffU;
  static const uint32_t MSP_NEG_INF = 0x0000ffffU;
  static const uint32_t MSP_POS_ZERO = 0x00000000U;
  static const uint32_t MSP_NEG_ZERO = 0x00008000U;
  static const uint64_t LSP_INF = static_cast<uint64_t>(0x8000000000000000ULL);
  static const uint64_t LSP_ZERO = 0;
  static const uint32_t MSP_MAX = 0x00007ffeU;
  static const uint64_t LSP_DMAX = static_cast<uint64_t>(0x7fffffffffffffffULL);
  static const uint64_t LSP_NMAX = static_cast<uint64_t>(0xffffffffffffffffULL);
  static const unsigned int BASE = 2;
  static const unsigned int EXPONENT_BITS = 15;
  static const unsigned int MANTISSA_BITS = 63;
  static const int EXPONENT_MAX = (1 << (EXPONENT_BITS - 1)) - 1;
  static const int EXPONENT_BIAS = EXPONENT_MAX;
  static const int EXPONENT_MIN = -EXPONENT_MAX + 1;
  static const int EXPONENT_MIN_DENORM = EXPONENT_MIN
                                        - static_cast<int>(MANTISSA_BITS);
  static const Floating_Point_Format floating_point_format =
                                     INTEL_DOUBLE_EXTENDED;
  int inf_sign() const;
  bool is_nan() const;
  int zero_sign() const;
  bool sign_bit() const;
  void negate();
  void dec();
  void inc();
  void set_max(bool negative);
  void build(bool negative, mpz_t mantissa, int exponent);
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct float_ieee754_quad {
#ifdef PPL_WORDS_BIGENDIAN
  uint64_t msp;
  uint64_t lsp;
#else
  uint64_t lsp;
  uint64_t msp;
#endif
  static const uint64_t MSP_SGN_MASK = static_cast<uint64_t>(0x8000000000000000ULL);
  static const uint64_t MSP_POS_INF = static_cast<uint64_t>(0x7fff000000000000ULL);
  static const uint64_t MSP_NEG_INF = static_cast<uint64_t>(0xffff000000000000ULL);
  static const uint64_t MSP_POS_ZERO = static_cast<uint64_t>(0x0000000000000000ULL);
  static const uint64_t MSP_NEG_ZERO = static_cast<uint64_t>(0x8000000000000000ULL);
  static const uint64_t LSP_INF = 0;
  static const uint64_t LSP_ZERO = 0;
  static const uint64_t MSP_MAX = static_cast<uint64_t>(0x7ffeffffffffffffULL);
  static const uint64_t LSP_MAX = static_cast<uint64_t>(0xffffffffffffffffULL);
  static const unsigned int BASE = 2;
  static const unsigned int EXPONENT_BITS = 15;
  static const unsigned int MANTISSA_BITS = 112;
  static const int EXPONENT_MAX = (1 << (EXPONENT_BITS - 1)) - 1;
  static const int EXPONENT_BIAS = EXPONENT_MAX;
  static const int EXPONENT_MIN = -EXPONENT_MAX + 1;
  static const int EXPONENT_MIN_DENORM = EXPONENT_MIN
                                        - static_cast<int>(MANTISSA_BITS);
  static const Floating_Point_Format floating_point_format = IEEE754_QUAD;
  int inf_sign() const;
  bool is_nan() const;
  int zero_sign() const;
  bool sign_bit() const;
  void negate();
  void dec();
  void inc();
  void set_max(bool negative);
  void build(bool negative, mpz_t mantissa, int exponent);
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Float : public False { };

#if PPL_SUPPORTED_FLOAT
template <>
class Float<float> : public True {
public:
#if PPL_CXX_FLOAT_BINARY_FORMAT == PPL_FLOAT_IEEE754_HALF
  typedef float_ieee754_half Binary;
#elif PPL_CXX_FLOAT_BINARY_FORMAT == PPL_FLOAT_IEEE754_SINGLE
  typedef float_ieee754_single Binary;
#elif PPL_CXX_FLOAT_BINARY_FORMAT == PPL_FLOAT_IEEE754_DOUBLE
  typedef float_ieee754_double Binary;
#elif PPL_CXX_FLOAT_BINARY_FORMAT == PPL_FLOAT_IBM_SINGLE
  typedef float_ibm_single Binary;
#elif PPL_CXX_FLOAT_BINARY_FORMAT == PPL_FLOAT_IEEE754_QUAD
  typedef float_ieee754_quad Binary;
#elif PPL_CXX_FLOAT_BINARY_FORMAT == PPL_FLOAT_INTEL_DOUBLE_EXTENDED
  typedef float_intel_double_extended Binary;
#else
#error "Invalid value for PPL_CXX_FLOAT_BINARY_FORMAT"
#endif
  union {
    float number;
    Binary binary;
  } u;
  Float();
  Float(float v);
  float value();
};
#endif

#if PPL_SUPPORTED_DOUBLE
template <>
class Float<double> : public True {
public:
#if PPL_CXX_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IEEE754_HALF
  typedef float_ieee754_half Binary;
#elif PPL_CXX_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IEEE754_SINGLE
  typedef float_ieee754_single Binary;
#elif PPL_CXX_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IEEE754_DOUBLE
  typedef float_ieee754_double Binary;
#elif PPL_CXX_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IBM_SINGLE
  typedef float_ibm_single Binary;
#elif PPL_CXX_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IEEE754_QUAD
  typedef float_ieee754_quad Binary;
#elif PPL_CXX_DOUBLE_BINARY_FORMAT == PPL_FLOAT_INTEL_DOUBLE_EXTENDED
  typedef float_intel_double_extended Binary;
#else
#error "Invalid value for PPL_CXX_DOUBLE_BINARY_FORMAT"
#endif
  union {
    double number;
    Binary binary;
  } u;
  Float();
  Float(double v);
  double value();
};
#endif

#if PPL_SUPPORTED_LONG_DOUBLE
template <>
class Float<long double> : public True {
public:
#if PPL_CXX_LONG_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IEEE754_HALF
  typedef float_ieee754_half Binary;
#elif PPL_CXX_LONG_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IEEE754_SINGLE
  typedef float_ieee754_single Binary;
#elif PPL_CXX_LONG_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IEEE754_DOUBLE
  typedef float_ieee754_double Binary;
#elif PPL_CXX_LONG_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IBM_SINGLE
  typedef float_ibm_single Binary;
#elif PPL_CXX_LONG_DOUBLE_BINARY_FORMAT == PPL_FLOAT_IEEE754_QUAD
  typedef float_ieee754_quad Binary;
#elif PPL_CXX_LONG_DOUBLE_BINARY_FORMAT == PPL_FLOAT_INTEL_DOUBLE_EXTENDED
  typedef float_intel_double_extended Binary;
#else
#error "Invalid value for PPL_CXX_LONG_DOUBLE_BINARY_FORMAT"
#endif
  union {
    long double number;
    Binary binary;
  } u;
  Float();
  Float(long double v);
  long double value();
};
#endif

// FIXME: is this the right place for this function?
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  If \p v is nonzero, returns the position of the most significant bit
  in \p a.

  The behavior is undefined if \p v is zero.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
unsigned int msb_position(unsigned long long v);

/*! \brief
  An abstract class to be implemented by an external analyzer such
  as ECLAIR in order to provide to the PPL the necessary information
  for performing the analysis of floating point computations.

  \par Template type parameters

  - The class template parameter \p Target specifies the implementation
  of Concrete_Expression to be used.
  - The class template parameter \p FP_Interval_Type represents the type
  of the intervals used in the abstract domain. The interval bounds
  should have a floating point type.
*/
template <typename Target, typename FP_Interval_Type>
class FP_Oracle {
public:
  /*
    FIXME: the const qualifiers on expressions may raise CLANG
    compatibility issues. It may be necessary to omit them.
  */

  /*! \brief
    Asks the external analyzer for an interval that correctly
    approximates the floating point entity referenced by \p dim.
    Result is stored into \p result.

    \return <CODE>true</CODE> if the analyzer was able to find a correct
    approximation, <CODE>false</CODE> otherwise.
  */
  virtual bool get_interval(dimension_type dim, FP_Interval_Type& result) const
    = 0;

  /*! \brief
    Asks the external analyzer for an interval that correctly
    approximates the value of floating point constant \p expr.
    Result is stored into \p result.

    \return <CODE>true</CODE> if the analyzer was able to find a correct
    approximation, <CODE>false</CODE> otherwise.
  */
  virtual bool get_fp_constant_value(
               const Floating_Point_Constant<Target>& expr,
                     FP_Interval_Type& result) const = 0;

  /*! \brief
    Asks the external analyzer for an interval that correctly approximates
    the value of \p expr, which must be of integer type.
    Result is stored into \p result.

    \return <CODE>true</CODE> if the analyzer was able to find a correct
    approximation, <CODE>false</CODE> otherwise.
  */
  virtual bool get_integer_expr_value(const Concrete_Expression<Target>& expr,
                                      FP_Interval_Type& result) const = 0;

  /*! \brief
    Asks the external analyzer for the possible space dimensions that
    are associated to the approximable reference \p expr.
    Result is stored into \p result.

    \return <CODE>true</CODE> if the analyzer was able to return
    the (possibly empty!) set, <CODE>false</CODE> otherwise.

    The resulting set MUST NOT contain <CODE>not_a_dimension()</CODE>.
  */
  virtual bool get_associated_dimensions(
          const Approximable_Reference<Target>& expr,
          std::set<dimension_type>& result) const = 0;

};

/* FIXME: some of the following  documentation should probably be
   under PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS */

/*! \brief \relates Float
  Returns <CODE>true</CODE> if and only if there is some floating point
  number that is representable by \p f2 but not by \p f1.
*/
bool is_less_precise_than(Floating_Point_Format f1, Floating_Point_Format f2);

/*! \brief \relates Float
  Computes the absolute error of floating point computations.

  \par Template type parameters

  - The class template parameter \p FP_Interval_Type represents the type
  of the intervals used in the abstract domain. The interval bounds
  should have a floating point type.

  \param analyzed_format The floating point format used by the analyzed
  program.

  \return The interval \f$[-\omega, \omega]\f$ where \f$\omega\f$ is the
  smallest non-zero positive number in the less precise floating point
  format between the analyzer format and the analyzed format.
*/
template <typename FP_Interval_Type>
const FP_Interval_Type&
compute_absolute_error(Floating_Point_Format analyzed_format);

/*! \brief \relates Linear_Form
  Discards all linear forms containing variable \p var from the
  linear form abstract store \p lf_store.
*/
template <typename FP_Interval_Type>
void
discard_occurrences(std::map<dimension_type,
                             Linear_Form<FP_Interval_Type> >& lf_store,
                    Variable var);

/*! \brief \relates Linear_Form
  Assigns the linear form \p lf to \p var in the linear form abstract
  store \p lf_store, then discards all occurrences of \p var from it.
*/
template <typename FP_Interval_Type>
void
affine_form_image(std::map<dimension_type,
                           Linear_Form<FP_Interval_Type> >& lf_store,
                  Variable var,
                  const Linear_Form<FP_Interval_Type>& lf);

/*! \brief \relates Linear_Form
  Discards from \p ls1 all linear forms but those that are associated
  to the same variable in \p ls2.
*/
template <typename FP_Interval_Type>
void
upper_bound_assign(std::map<dimension_type,
                            Linear_Form<FP_Interval_Type> >& ls1,
                   const std::map<dimension_type,
                                  Linear_Form<FP_Interval_Type> >& ls2);

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Float_inlines.hh line 1. */
/* IEC 559 floating point format related functions.
*/


/* Automatically generated from PPL source file ../src/Variable_defs.hh line 1. */
/* Variable class declaration.
*/


/* Automatically generated from PPL source file ../src/Init_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Init;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Variable_defs.hh line 30. */
#include <iosfwd>
#include <set>

namespace Parma_Polyhedra_Library {

namespace IO_Operators {

//! Output operator.
/*! \relates Parma_Polyhedra_Library::Variable */
std::ostream&
operator<<(std::ostream& s, const Variable v);

} // namespace IO_Operators

//! Defines a total ordering on variables.
/*! \relates Variable */
bool less(Variable v, Variable w);

/*! \relates Variable */
void
swap(Variable& x, Variable& y);

} // namespace Parma_Polyhedra_Library

//! A dimension of the vector space.
/*! \ingroup PPL_CXX_interface
  An object of the class Variable represents a dimension of the space,
  that is one of the Cartesian axes.
  Variables are used as basic blocks in order to build
  more complex linear expressions.
  Each variable is identified by a non-negative integer,
  representing the index of the corresponding Cartesian axis
  (the first axis has index 0).
  The space dimension of a variable is the dimension of the vector space
  made by all the Cartesian axes having an index less than or equal to
  that of the considered variable; thus, if a variable has index \f$i\f$,
  its space dimension is \f$i+1\f$.

  Note that the ``meaning'' of an object of the class Variable
  is completely specified by the integer index provided to its
  constructor:
  be careful not to be mislead by C++ language variable names.
  For instance, in the following example the linear expressions
  <CODE>e1</CODE> and <CODE>e2</CODE> are equivalent,
  since the two variables <CODE>x</CODE> and <CODE>z</CODE> denote
  the same Cartesian axis.
  \code
  Variable x(0);
  Variable y(1);
  Variable z(0);
  Linear_Expression e1 = x + y;
  Linear_Expression e2 = y + z;
  \endcode

*/
class Parma_Polyhedra_Library::Variable {

public:
  //! Builds the variable corresponding to the Cartesian axis of index \p i.
  /*!
    \exception std::length_error
    Thrown if <CODE>i+1</CODE> exceeds
    <CODE>Variable::max_space_dimension()</CODE>.
  */
  explicit Variable(dimension_type i);

  //! Returns the index of the Cartesian axis associated to the variable.
  dimension_type id() const;

  //! Returns the maximum space dimension a Variable can handle.
  static dimension_type max_space_dimension();

  //! Returns the dimension of the vector space enclosing \p *this.
  /*!
    The returned value is <CODE>id()+1</CODE>.
  */
  dimension_type space_dimension() const;

  //! Returns the total size in bytes of the memory occupied by \p *this.
  memory_size_type total_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  memory_size_type external_memory_in_bytes() const;

  //! Checks if all the invariants are satisfied.
  bool OK() const;

  //! Type of output functions.
  typedef void output_function_type(std::ostream& s, const Variable v);

  //! The default output function.
  static void default_output_function(std::ostream& s, const Variable v);

  //! Sets the output function to be used for printing Variable objects.
  static void set_output_function(output_function_type* p);

  //! Returns the pointer to the current output function.
  static output_function_type* get_output_function();

  //! Binary predicate defining the total ordering on variables.
  /*! \ingroup PPL_CXX_interface */
  struct Compare {
    //! Returns <CODE>true</CODE> if and only if \p x comes before \p y.
    bool operator()(Variable x, Variable y) const;
  };

  //! Swaps *this and v.
  void m_swap(Variable& v);

private:
  //! The index of the Cartesian axis.
  dimension_type varid;

  // The initialization class needs to set the default output function.
  friend class Init;

  friend std::ostream&
  Parma_Polyhedra_Library::IO_Operators::operator<<(std::ostream& s,
                                                    const Variable v);

  //! Pointer to the current output function.
  static output_function_type* current_output_function;

};

/* Automatically generated from PPL source file ../src/Variable_inlines.hh line 1. */
/* Variable class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/globals_defs.hh line 1. */
/* Declarations of global objects.
*/


/* Automatically generated from PPL source file ../src/C_Integer.hh line 1. */
/* C integers info.
*/


/* Automatically generated from PPL source file ../src/C_Integer.hh line 28. */
#include <climits>

// C99 defines LLONG_MIN, LLONG_MAX and ULLONG_MAX, but this part of
// C99 is not yet included into the C++ standard.
// GCC defines LONG_LONG_MIN, LONG_LONG_MAX and ULONG_LONG_MAX.
// Some compilers (such as Comeau C++ up to and including version 4.3.3)
// define nothing.  In this last case we make a reasonable guess.
#ifndef LLONG_MIN
#if defined(LONG_LONG_MIN)
#define LLONG_MIN LONG_LONG_MIN
#elif PPL_SIZEOF_LONG_LONG == 8
#define LLONG_MIN 0x8000000000000000LL
#endif
#endif

#ifndef LLONG_MAX
#if defined(LONG_LONG_MAX)
#define LLONG_MAX LONG_LONG_MAX
#elif PPL_SIZEOF_LONG_LONG == 8
#define LLONG_MAX 0x7fffffffffffffffLL
#endif
#endif

#ifndef ULLONG_MAX
#if defined(ULONG_LONG_MAX)
#define ULLONG_MAX ULONG_LONG_MAX
#elif PPL_SIZEOF_LONG_LONG == 8
#define ULLONG_MAX 0xffffffffffffffffULL
#endif
#endif

namespace Parma_Polyhedra_Library {

template <typename T>
struct C_Integer : public False { };

template <>
struct C_Integer<char> : public True {
  enum const_bool_value {
#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
    is_signed = true
#else
    is_signed = false
#endif
  };
  typedef void smaller_type;
  typedef void smaller_signed_type;
  typedef void smaller_unsigned_type;
#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
  typedef unsigned char other_type;
#else
  typedef signed char other_type;
#endif
  static const char min = static_cast<char>(CHAR_MIN);
  static const char max = static_cast<char>(CHAR_MAX);
};

template <>
struct C_Integer<signed char> : public True {
  enum const_bool_value {
    is_signed = true
  };
  typedef void smaller_type;
  typedef void smaller_signed_type;
  typedef void smaller_unsigned_type;
  typedef unsigned char other_type;
  static const signed char min = static_cast<signed char>(SCHAR_MIN);
  static const signed char max = static_cast<signed char>(SCHAR_MAX);
};

template <>
struct C_Integer<signed short> : public True {
  enum const_bool_value {
    is_signed = true
  };
  typedef signed char smaller_type;
  typedef signed char smaller_signed_type;
  typedef unsigned char smaller_unsigned_type;
  typedef unsigned short other_type;
  static const signed short min = static_cast<signed short>(SHRT_MIN);
  static const signed short max = static_cast<signed short>(SHRT_MAX);
};

template <>
struct C_Integer<signed int> : public True {
  enum const_bool_value {
    is_signed = true
  };
  typedef signed short smaller_type;
  typedef signed short smaller_signed_type;
  typedef unsigned short smaller_unsigned_type;
  typedef unsigned int other_type;
  static const signed int min = INT_MIN;
  static const signed int max = INT_MAX;
};

template <>
struct C_Integer<signed long> : public True {
  enum const_bool_value {
    is_signed = true
  };
  typedef signed int smaller_type;
  typedef signed int smaller_signed_type;
  typedef unsigned int smaller_unsigned_type;
  typedef unsigned long other_type;
  static const signed long min = LONG_MIN;
  static const signed long max = LONG_MAX;
};

template <>
struct C_Integer<signed long long> : public True {
  enum const_bool_value {
    is_signed = true
  };
  typedef signed long smaller_type;
  typedef signed long smaller_signed_type;
  typedef unsigned long smaller_unsigned_type;
  typedef unsigned long long other_type;
  static const signed long long min = LLONG_MIN;
  static const signed long long max = LLONG_MAX;
};

template <>
struct C_Integer<unsigned char> : public True {
  enum const_bool_value {
    is_signed = false
  };
  typedef void smaller_type;
  typedef void smaller_signed_type;
  typedef void smaller_unsigned_type;
  typedef signed char other_type;
  static const unsigned char min = static_cast<unsigned char>(0U);
  static const unsigned char max = static_cast<unsigned char>(UCHAR_MAX);
};

template <>
struct C_Integer<unsigned short> : public True {
  enum const_bool_value {
    is_signed = false
  };
  typedef unsigned char smaller_type;
  typedef signed char smaller_signed_type;
  typedef unsigned char smaller_unsigned_type;
  typedef signed short other_type;
  static const unsigned short min = static_cast<unsigned short>(0U);
  static const unsigned short max = static_cast<unsigned short>(USHRT_MAX);
};

template <>
struct C_Integer<unsigned int> : public True {
  enum const_bool_value {
    is_signed = false
  };
  typedef unsigned short smaller_type;
  typedef signed short smaller_signed_type;
  typedef unsigned short smaller_unsigned_type;
  typedef signed int other_type;
  static const unsigned int min = 0U;
  static const unsigned int max = UINT_MAX;
};

template <>
struct C_Integer<unsigned long> : public True {
  enum const_bool_value {
    is_signed = false
  };
  typedef unsigned int smaller_type;
  typedef signed int smaller_signed_type;
  typedef unsigned int smaller_unsigned_type;
  typedef signed long other_type;
  static const unsigned long min = 0UL;
  static const unsigned long max = ULONG_MAX;
};

template <>
struct C_Integer<unsigned long long> : public True {
  enum const_bool_value {
    is_signed = false
  };
  typedef unsigned long smaller_type;
  typedef signed long smaller_signed_type;
  typedef unsigned long smaller_unsigned_type;
  typedef signed long long other_type;
  static const unsigned long long min = 0ULL;
  static const unsigned long long max = ULLONG_MAX;
};

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/globals_defs.hh line 32. */
#include <exception>
#include <gmpxx.h>

#ifndef PPL_PROFILE_ADD_WEIGHT
#define PPL_PROFILE_ADD_WEIGHT 0
#endif

#if defined(NDEBUG) && PPL_PROFILE_ADD_WEIGHT
/* Automatically generated from PPL source file ../src/Weight_Profiler_defs.hh line 1. */
/* Weight_Profiler class declaration.
*/

#ifndef Weight_Profiler_defs_hh
#define Weight_Profiler_defs_hh 1

#include <cassert>

namespace Parma_Polyhedra_Library {

class Weight_Profiler {
private:
  enum { DISCARDED = 0, VALID = 1 };

public:
  Weight_Profiler(const char* file, int line,
                  Weightwatch_Traits::Delta delta,
                  double min_threshold = 0, double max_threshold = 0)
    : file(file), line(line), delta(delta),
      min_threshold(min_threshold), max_threshold(max_threshold) {
    for (int i = 0; i < 2; ++i) {
      stat[i].samples = 0;
      stat[i].count = 0;
      stat[i].sum = 0;
      stat[i].squares_sum = 0;
      stat[i].min = 0;
      stat[i].max = 0;
    }
  }

  ~Weight_Profiler() {
    output_stats();
  }

  void output_stats();

  static void begin() {
#ifndef NDEBUG
    int r = clock_gettime(CLOCK_THREAD_CPUTIME_ID, &stamp);
    assert(r >= 0);
#else
    clock_gettime(CLOCK_THREAD_CPUTIME_ID, &stamp);
#endif
  }

  void end(unsigned int factor = 1) {
    Weightwatch_Traits::weight
      += (Weightwatch_Traits::Threshold) delta * factor;
    struct timespec start = stamp;
    begin();
    double elapsed;
    if (stamp.tv_nsec >= start.tv_nsec) {
      elapsed = (stamp.tv_nsec - start.tv_nsec)
        + (stamp.tv_sec - start.tv_sec) * 1e9;
    }
    else {
      elapsed = (1000000000 - start.tv_nsec + stamp.tv_nsec )
        + (stamp.tv_sec - start.tv_sec - 1) * 1e9;
    }
    elapsed -= adjustment;
    double elapsed1 = elapsed / factor;
    int i = (elapsed1 < min_threshold
             || (max_threshold > 0 && elapsed1 > max_threshold))
      ? DISCARDED
      : VALID;
    ++stat[i].samples;
    if (stat[i].count == 0) {
      stat[i].min = stat[i].max = elapsed1;
    }
    else if (stat[i].min > elapsed1) {
      stat[i].min = elapsed1;
    }
    else if (stat[i].max < elapsed1) {
      stat[i].max = elapsed1;
    }
    stat[i].sum += elapsed;
    stat[i].squares_sum += elapsed * elapsed1;
    stat[i].count += factor;
  }

  static double tune_adjustment();

 private:
  //! File of this profiling point.
  const char *file;

  //! Line of this profiling point.
  int line;

  //! Computational weight to be added at each iteration.
  Weightwatch_Traits::Delta delta;

  //! Times less than this value are discarded.
  double min_threshold;

  //! Times greater than this value are discarded.
  double max_threshold;

  //! Statistical data for samples (both DISCARDED and VALID)
  struct {
    //! Number of collected samples.
    unsigned int samples;

    /*! \brief
      Number of collected iterations.

      \note
      Multiple iterations are possibly collected for each sample.
    */
    unsigned int count;

    //! Sum of the measured times.
    double sum;

    //! Sum of the squares of the measured times (to compute variance).
    double squares_sum;

    //! Minimum measured time.
    double min;

    //! Maximum measured time.
    double max;
  } stat[2];

  //! Holds the time corresponding to last time begin() was called.
  static struct timespec stamp;

  /*! \brief
    Time quantity used to adjust the elapsed times so as not to take
    into account the time spent by the measurement infrastructure.
  */
  static double adjustment;
};

}

#endif // Weight_Profiler_defs_hh
/* Automatically generated from PPL source file ../src/globals_defs.hh line 41. */
#endif

#if defined(NDEBUG)

#if PPL_PROFILE_ADD_WEIGHT

#define WEIGHT_BEGIN() Weight_Profiler::begin()

#define WEIGHT_ADD(delta)                                     \
  do {                                                        \
    static Weight_Profiler wp__(__FILE__, __LINE__, delta);   \
    wp__.end();                                               \
  } while (false)

#define WEIGHT_ADD_MUL(delta, factor)                                   \
  do {                                                                  \
    static Weight_Profiler wp__(__FILE__, __LINE__, delta);             \
    wp__.end(factor);                                                   \
  } while (false)

#else // !PPL_PROFILE_ADD_WEIGHT

#define WEIGHT_BEGIN()                          \
  do {                                          \
  } while (false)

#define WEIGHT_ADD(delta)                       \
  do {                                          \
    Weightwatch_Traits::weight += (delta);      \
  } while (false)

#define WEIGHT_ADD_MUL(delta, factor)                   \
  do {                                                  \
    Weightwatch_Traits::weight += (delta)*(factor);     \
  } while (false)

#endif // !PPL_PROFILE_ADD_WEIGHT

#else // !defined(NDEBUG)

#define WEIGHT_BEGIN()

#define WEIGHT_ADD(delta)                       \
  do {                                          \
    if (!In_Assert::asserting()) {              \
      Weightwatch_Traits::weight += delta;      \
    }                                           \
  } while (false)

#define WEIGHT_ADD_MUL(delta, factor)                   \
  do {                                                  \
    if (!In_Assert::asserting()) {                      \
      Weightwatch_Traits::weight += delta * factor;     \
    }                                                   \
  } while (false)

#endif // !defined(NDEBUG)


namespace Parma_Polyhedra_Library {

//! Returns a value that does not designate a valid dimension.
dimension_type
not_a_dimension();

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns the hash code for space dimension \p dim.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
int32_t
hash_code_from_dimension(dimension_type dim);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Make sure swap() is specialized when needed.

  This will cause a compile-time error whenever a specialization for \p T
  is beneficial but missing.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
inline typename Enable_If<Slow_Copy<T>::value, void>::type
swap(T&, T&) {
  PPL_COMPILE_TIME_CHECK(!Slow_Copy<T>::value, "missing swap specialization");
}

/*! \brief
  Declare a local variable named \p id, of type Coefficient, and containing
  an unknown initial value.

  Use of this macro to declare temporaries of type Coefficient results
  in decreased memory allocation overhead and in better locality.
*/
#define PPL_DIRTY_TEMP_COEFFICIENT(id) \
PPL_DIRTY_TEMP(Parma_Polyhedra_Library::Coefficient, id)

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Speculative allocation function.
/*!
  \return
  The actual capacity to be allocated.

  \param requested_size
  The number of elements we need.

  \param maximum_size
  The maximum number of elements to be allocated. It is assumed
  to be no less than \p requested_size.

  Computes a capacity given a requested size.
  Allows for speculative allocation aimed at reducing the number of
  reallocations enough to guarantee amortized constant insertion time
  for our vector-like data structures. In all cases, the speculative
  allocation will not exceed \p maximum_size.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
dimension_type
compute_capacity(dimension_type requested_size,
                 dimension_type maximum_size);


#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Traits class for the deterministic timeout mechanism.
/*! \ingroup PPL_CXX_interface
  This abstract base class should be instantiated by those users
  willing to provide a polynomial upper bound to the time spent
  by any invocation of a library operator.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct Weightwatch_Traits {
  //! The type used to specify thresholds for computational weight.
  typedef unsigned long long Threshold;

  //! The type used to specify increments of computational weight.
  typedef unsigned long long Delta;

  //! Returns the current computational weight.
  static const Threshold& get();

  //! Compares the two weights \p a and \p b.
  static bool less_than(const Threshold& a, const Threshold& b);

  //! Computes a \c Delta value from \p unscaled and \p scale.
  /*!
    \return
    \f$u \cdot 2^s\f$, where \f$u\f$ is the value of \p unscaled and
    \f$s\f$ is the value of \p scale.

    \param unscaled
    The value of delta before scaling.

    \param scale
    The scaling to be applied to \p unscaled.
  */
  static Delta compute_delta(unsigned long unscaled, unsigned scale);

  //! Sets \p threshold to be \p delta units bigger than the current weight.
  static void from_delta(Threshold& threshold, const Delta& delta);

  //! The current computational weight.
  static Threshold weight;

  /*! \brief
    A pointer to the function that has to be called when checking
    the reaching of thresholds.

    The pointer can be null if no thresholds are set.
  */
  static void (*check_function)(void);
};


#ifndef NDEBUG

class In_Assert {
private:
  //! Non zero during evaluation of PPL_ASSERT expression.
  static unsigned int count;
public:
  In_Assert() {
    ++count;
  }
  ~In_Assert() {
    --count;
  }
  static bool asserting() {
    return count != 0;
  }
};

#endif


//! User objects the PPL can throw.
/*! \ingroup PPL_CXX_interface
  This abstract base class should be instantiated by those users
  willing to provide a polynomial upper bound to the time spent
  by any invocation of a library operator.
*/
class Throwable {
public:
  //! Throws the user defined exception object.
  virtual void throw_me() const = 0;

  //! Virtual destructor.
  virtual ~Throwable();
};

/*! \brief
  A pointer to an exception object.

  \ingroup PPL_CXX_interface
  This pointer, which is initialized to zero, is repeatedly checked
  along any super-linear (i.e., computationally expensive) computation
  path in the library.
  When it is found nonzero the exception it points to is thrown.
  In other words, making this pointer point to an exception (and
  leaving it in this state) ensures that the library will return
  control to the client application, possibly by throwing the given
  exception, within a time that is a linear function of the size
  of the representation of the biggest object (powerset of polyhedra,
  polyhedron, system of constraints or generators) on which the library
  is operating upon.

  \note
  The only sensible way to assign to this pointer is from within a
  signal handler or from a parallel thread.  For this reason, the
  library, apart from ensuring that the pointer is initially set to zero,
  never assigns to it.  In particular, it does not zero it again when
  the exception is thrown: it is the client's responsibility to do so.
*/
extern const Throwable* volatile abandon_expensive_computations;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  If the pointer abandon_expensive_computations is found
  to be nonzero, the exception it points to is thrown.

  \relates Throwable
*/
#endif
void
maybe_abandon();

//! A tag class.
/*! \ingroup PPL_CXX_interface
  Tag class to distinguish those constructors that recycle the data
  structures of their arguments, instead of taking a copy.
*/
struct Recycle_Input {
};

// Turn s into a string: PPL_STR(x + y) => "x + y".
#define PPL_STR(s) #s
// Turn the expansion of s into a string: PPL_XSTR(x) => "x expanded".
#define PPL_XSTR(s) PPL_STR(s)

#define PPL_OUTPUT_DECLARATIONS                                         \
  /*! \brief Writes to \c std::cerr an ASCII representation of \p *this. */ \
  void ascii_dump() const;                                              \
  /*! \brief Writes to \p s an ASCII representation of \p *this. */     \
  void ascii_dump(std::ostream& s) const;                               \
  /*! \brief Prints \p *this to \c std::cerr using \c operator<<. */    \
  void print() const;

#define PPL_OUTPUT_DEFINITIONS(class_name)                      \
  void                                                          \
  Parma_Polyhedra_Library::class_name::ascii_dump() const {     \
    ascii_dump(std::cerr);                                      \
  }                                                             \
                                                                \
  void                                                          \
  Parma_Polyhedra_Library::class_name::print() const {          \
    using IO_Operators::operator<<;                             \
    std::cerr << *this;                                         \
  }

#define PPL_OUTPUT_DEFINITIONS_ASCII_ONLY(class_name)                   \
  void                                                                  \
  Parma_Polyhedra_Library::class_name::ascii_dump() const {             \
    ascii_dump(std::cerr);                                              \
  }                                                                     \
                                                                        \
  void                                                                  \
  Parma_Polyhedra_Library::class_name::print() const {                  \
    std::cerr << "No user level output operator defined "               \
              << "for class " PPL_XSTR(class_name) << "." << std::endl; \
  }

#define PPL_OUTPUT_TEMPLATE_DEFINITIONS(type_symbol, class_prefix)      \
  template <typename type_symbol>                                       \
  void                                                                  \
  class_prefix::ascii_dump() const {                             \
    ascii_dump(std::cerr);                                              \
  }                                                                     \
                                                                        \
  template <typename type_symbol>                                       \
  void                                                                  \
  class_prefix::print() const {                                  \
    using IO_Operators::operator<<;                                     \
    std::cerr << *this;                                                 \
  }

#define PPL_OUTPUT_2_PARAM_TEMPLATE_DEFINITIONS(type_symbol1,           \
                                                type_symbol2,           \
                                                class_prefix)           \
  template <typename type_symbol1, typename type_symbol2>               \
  void                                                                  \
  PPL_U(class_prefix)<PPL_U(type_symbol1), PPL_U(type_symbol2)>         \
  ::ascii_dump() const {                                                \
    ascii_dump(std::cerr);                                              \
  }                                                                     \
                                                                        \
  template <typename type_symbol1, typename type_symbol2>               \
  void                                                                  \
  PPL_U(class_prefix)<PPL_U(type_symbol1), PPL_U(type_symbol2)>         \
  ::print() const {                                                     \
    using IO_Operators::operator<<;                                     \
    std::cerr << *this;                                                 \
  }

#define PPL_OUTPUT_3_PARAM_TEMPLATE_DEFINITIONS(type_symbol1,           \
                                                type_symbol2,           \
                                                type_symbol3,           \
                                                class_prefix)           \
  template <typename type_symbol1, typename type_symbol2,               \
            typename type_symbol3>                                      \
  void                                                                  \
  PPL_U(class_prefix)<PPL_U(type_symbol1), type_symbol2,                \
                      PPL_U(type_symbol3)>::ascii_dump()                \
    const {                                                             \
    ascii_dump(std::cerr);                                              \
  }                                                                     \
                                                                        \
    template <typename type_symbol1, typename type_symbol2,             \
              typename type_symbol3>                                    \
    void                                                                \
    PPL_U(class_prefix)<PPL_U(type_symbol1), type_symbol2,              \
                        PPL_U(type_symbol3)>::print()                   \
      const {                                                           \
      using IO_Operators::operator<<;                                   \
      std::cerr << *this;                                               \
    }

#define PPL_OUTPUT_TEMPLATE_DEFINITIONS_ASCII_ONLY(type_symbol, class_prefix) \
  template <typename type_symbol>                                       \
  void                                                                  \
  class_prefix::ascii_dump() const {                                    \
    ascii_dump(std::cerr);                                              \
  }                                                                     \
                                                                        \
  template <typename type_symbol>                                       \
  void                                                                  \
  class_prefix::print() const {                                         \
    std::cerr << "No user level output operator defined "               \
              << "for " PPL_XSTR(class_prefix) << "." << std::endl;     \
  }

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns <CODE>true</CODE> if \p c is any kind of space character.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
bool is_space(char c);

template <typename T, long long v, typename Enable = void>
struct Fit : public False {
};

template <typename T, long long v>
struct Fit<T, v, typename Enable_If<C_Integer<T>::value>::type>  {
  enum {
    value = (v >= static_cast<long long>(C_Integer<T>::min)
             && v <= static_cast<long long>(C_Integer<T>::max))
  };
};

template <typename T, T v>
struct TConstant {
  static const T value = v;
};


template <typename T, T v>
const T TConstant<T, v>::value;

template <typename T, long long v, bool prefer_signed = true,
          typename Enable = void>
struct Constant_ : public TConstant<T, v> {
};

//! \cond
// Keep Doxygen off until it learns how to deal properly with `||'.

template <typename T, long long v, bool prefer_signed>
struct Constant_<T, v, prefer_signed,
                 typename Enable_If<(Fit<typename C_Integer<T>::smaller_signed_type, v>::value
                                     && (prefer_signed
                                         || !Fit<typename C_Integer<T>::smaller_unsigned_type, v>::value))>::type>
  : public Constant_<typename C_Integer<T>::smaller_signed_type, v, prefer_signed> {
};

template <typename T, long long v, bool prefer_signed>
struct Constant_<T, v, prefer_signed,
                 typename Enable_If<(Fit<typename C_Integer<T>::smaller_unsigned_type, v>::value
                                     && (!prefer_signed
                                         || !Fit<typename C_Integer<T>::smaller_signed_type, v>::value))>::type>
  : public Constant_<typename C_Integer<T>::smaller_unsigned_type, v, prefer_signed> {
};

//! \endcond

template <long long v, bool prefer_signed = true>
struct Constant : public Constant_<long long, v, prefer_signed> {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! \name Memory Size Inspection Functions
//@{
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  For native types, returns the total size in bytes of the memory
  occupied by the type of the (unused) parameter, i.e., 0.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
typename Enable_If<Is_Native<T>::value, memory_size_type>::type
total_memory_in_bytes(const T&);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  For native types, returns the size in bytes of the memory managed
  by the type of the (unused) parameter, i.e., 0.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
typename Enable_If<Is_Native<T>::value, memory_size_type>::type
external_memory_in_bytes(const T&);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns the total size in bytes of the memory occupied by \p x.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
memory_size_type
total_memory_in_bytes(const mpz_class& x);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns the size in bytes of the memory managed by \p x.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
memory_size_type
external_memory_in_bytes(const mpz_class& x);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns the total size in bytes of the memory occupied by \p x.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
memory_size_type
total_memory_in_bytes(const mpq_class& x);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns the size in bytes of the memory managed by \p x.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
memory_size_type
external_memory_in_bytes(const mpq_class& x);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//@} // Memory Size Inspection Functions
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)


template <typename T, typename Enable = void>
struct Has_OK : public False { };

template <typename T>
struct Has_OK<T, typename Enable_If_Is<bool (T::*)() const, &T::OK>::type>
  : public True {
};

template <typename T>
inline typename Enable_If<Has_OK<T>::value, bool>::type
f_OK(const T& to) {
  return to.OK();
}

#define FOK(T) inline bool f_OK(const T&) { return true; }

FOK(char)
FOK(signed char)
FOK(unsigned char)
FOK(signed short)
FOK(unsigned short)
FOK(signed int)
FOK(unsigned int)
FOK(signed long)
FOK(unsigned long)
FOK(signed long long)
FOK(unsigned long long)
FOK(float)
FOK(double)
FOK(long double)
FOK(mpz_class)
FOK(mpq_class)

void ascii_dump(std::ostream& s, Representation r);
bool ascii_load(std::istream& s, Representation& r);

dimension_type
check_space_dimension_overflow(dimension_type dim,
                               dimension_type max,
                               const char* domain,
                               const char* method,
                               const char* reason);

template <typename RA_Container>
typename RA_Container::iterator
nth_iter(RA_Container& cont, dimension_type n);

template <typename RA_Container>
typename RA_Container::const_iterator
nth_iter(const RA_Container& cont, dimension_type n);

dimension_type
least_significant_one_mask(dimension_type i);

} // namespace Parma_Polyhedra_Library

// By default, use sparse matrices both for MIP_Problem and PIP_Problem.
#ifndef PPL_USE_SPARSE_MATRIX
#define PPL_USE_SPARSE_MATRIX 1
#endif

/* Automatically generated from PPL source file ../src/globals_inlines.hh line 1. */
/* Implementation of global objects: inline functions.
*/


/* Automatically generated from PPL source file ../src/globals_inlines.hh line 28. */
#include <limits>
#include <cassert>
#include <istream>
#include <ostream>
#include <cctype>
#include <stdexcept>

namespace Parma_Polyhedra_Library {

inline dimension_type
not_a_dimension() {
  return std::numeric_limits<dimension_type>::max();
}

inline int32_t
hash_code_from_dimension(dimension_type dim) {
  const dimension_type divisor = 1U << (32 - 1);
  dim = dim % divisor;
  return static_cast<int32_t>(dim);
}

inline const Weightwatch_Traits::Threshold&
Weightwatch_Traits::get() {
  return weight;
}

inline bool
Weightwatch_Traits::less_than(const Threshold& a, const Threshold& b) {
  return b - a < (1ULL << (sizeof_to_bits(sizeof(Threshold)) - 1));
}

inline Weightwatch_Traits::Delta
Weightwatch_Traits::compute_delta(unsigned long unscaled, unsigned scale) {
  if ((std::numeric_limits<Delta>::max() >> scale) < unscaled) {
    throw std::invalid_argument("PPL::Weightwatch_Traits::"
                                "compute_delta(u, s):\n"
                                "values of u and s cause wrap around.");
  }
  return static_cast<Delta>(unscaled) << scale;
}

inline void
Weightwatch_Traits::from_delta(Threshold& threshold, const Delta& delta) {
  threshold = weight + delta;
}

inline void
maybe_abandon() {
#ifndef NDEBUG
  if (In_Assert::asserting()) {
    return;
  }
#endif
  if (Weightwatch_Traits::check_function != 0) {
    Weightwatch_Traits::check_function();
  }
  if (const Throwable* const p = abandon_expensive_computations) {
    p->throw_me();
  }
}

inline dimension_type
compute_capacity(const dimension_type requested_size,
                 const dimension_type maximum_size) {
  assert(requested_size <= maximum_size);
  // Speculation factor 2.
  return (requested_size < maximum_size/2)
    ? (2*(requested_size + 1))
    : maximum_size;
  // Speculation factor 1.5.
  // return (maximum_size - requested_size > requested_size/2)
  //   ? requested_size + requested_size/2 + 1
  //   : maximum_size;
}

template <typename T>
inline typename
Enable_If<Is_Native<T>::value, memory_size_type>::type
external_memory_in_bytes(const T&) {
  return 0;
}

template <typename T>
inline typename
Enable_If<Is_Native<T>::value, memory_size_type>::type
total_memory_in_bytes(const T&) {
  return sizeof(T);
}

inline memory_size_type
external_memory_in_bytes(const mpz_class& x) {
  return static_cast<memory_size_type>(x.get_mpz_t()[0]._mp_alloc)
    * PPL_SIZEOF_MP_LIMB_T;
}

inline memory_size_type
total_memory_in_bytes(const mpz_class& x) {
  return sizeof(x) + external_memory_in_bytes(x);
}

inline memory_size_type
external_memory_in_bytes(const mpq_class& x) {
  return external_memory_in_bytes(x.get_num())
    + external_memory_in_bytes(x.get_den());
}

inline memory_size_type
total_memory_in_bytes(const mpq_class& x) {
  return sizeof(x) + external_memory_in_bytes(x);
}

inline void
ascii_dump(std::ostream& s, Representation r) {
  if (r == DENSE) {
    s << "DENSE";
  }
  else {
    s << "SPARSE";
  }
}

inline bool
ascii_load(std::istream& is, Representation& r) {
  std::string s;
  if (!(is >> s)) {
    return false;
  }

  if (s == "DENSE")  {
    r = DENSE;
    return true;
  }
  if (s == "SPARSE")  {
    r = SPARSE;
    return true;
  }
  return false;
}

inline bool
is_space(char c) {
  return isspace(c) != 0;
}

template <typename RA_Container>
inline typename RA_Container::iterator
nth_iter(RA_Container& cont, dimension_type n) {
  typedef typename RA_Container::difference_type diff_t;
  return cont.begin() + static_cast<diff_t>(n);
}

template <typename RA_Container>
inline typename RA_Container::const_iterator
nth_iter(const RA_Container& cont, dimension_type n) {
  typedef typename RA_Container::difference_type diff_t;
  return cont.begin() + static_cast<diff_t>(n);
}

inline dimension_type
least_significant_one_mask(const dimension_type i) {
  return i & (~i + 1U);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/globals_defs.hh line 570. */

/* Automatically generated from PPL source file ../src/Variable_inlines.hh line 28. */
#include <stdexcept>

namespace Parma_Polyhedra_Library {

inline dimension_type
Variable::max_space_dimension() {
  return not_a_dimension() - 1;
}

inline
Variable::Variable(dimension_type i)
  : varid((i < max_space_dimension())
          ? i
          : (throw std::length_error("PPL::Variable::Variable(i):\n"
                                     "i exceeds the maximum allowed "
                                     "variable identifier."), i)) {
}

inline dimension_type
Variable::id() const {
  return varid;
}

inline dimension_type
Variable::space_dimension() const {
  return varid + 1;
}

inline memory_size_type
Variable::external_memory_in_bytes() const {
  return 0;
}

inline memory_size_type
Variable::total_memory_in_bytes() const {
  return sizeof(*this) + external_memory_in_bytes();
}

inline void
Variable::set_output_function(output_function_type* p) {
  current_output_function = p;
}

inline Variable::output_function_type*
Variable::get_output_function() {
  return current_output_function;
}

/*! \relates Variable */
inline bool
less(const Variable v, const Variable w) {
  return v.id() < w.id();
}

inline bool
Variable::Compare::operator()(const Variable x, const Variable y) const {
  return less(x, y);
}

inline void
Variable::m_swap(Variable& v) {
  using std::swap;
  swap(varid, v.varid);
}

inline void
swap(Variable& x, Variable& y) {
  x.m_swap(y);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Variable_defs.hh line 156. */

/* Automatically generated from PPL source file ../src/Linear_Form_defs.hh line 1. */
/* Linear_Form class declaration.
*/


/* Automatically generated from PPL source file ../src/Linear_Expression_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Linear_Expression;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Box_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename Interval>
class Box;

class Box_Helpers;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Form_defs.hh line 32. */
#include <vector>

namespace Parma_Polyhedra_Library {

//! Swaps \p x with \p y.
/*! \relates Linear_Form */
template <typename C>
void swap(Linear_Form<C>& x, Linear_Form<C>& y);

// Put them in the namespace here to declare them friend later.

//! Returns the linear form \p f1 + \p f2.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator+(const Linear_Form<C>& f1, const Linear_Form<C>& f2);

//! Returns the linear form \p v + \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator+(Variable v, const Linear_Form<C>& f);

//! Returns the linear form \p f + \p v.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator+(const Linear_Form<C>& f, Variable v);

//! Returns the linear form \p n + \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator+(const C& n, const Linear_Form<C>& f);

//! Returns the linear form \p f + \p n.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator+(const Linear_Form<C>& f, const C& n);

//! Returns the linear form \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator+(const Linear_Form<C>& f);

//! Returns the linear form - \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator-(const Linear_Form<C>& f);

//! Returns the linear form \p f1 - \p f2.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator-(const Linear_Form<C>& f1, const Linear_Form<C>& f2);

//! Returns the linear form \p v - \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator-(Variable v, const Linear_Form<C>& f);

//! Returns the linear form \p f - \p v.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator-(const Linear_Form<C>& f, Variable v);

//! Returns the linear form \p n - \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator-(const C& n, const Linear_Form<C>& f);

//! Returns the linear form \p f - \p n.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator-(const Linear_Form<C>& f, const C& n);

//! Returns the linear form \p n * \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator*(const C& n, const Linear_Form<C>& f);

//! Returns the linear form \p f * \p n.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>
operator*(const Linear_Form<C>& f, const C& n);

//! Returns the linear form \p f1 + \p f2 and assigns it to \p e1.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>&
operator+=(Linear_Form<C>& f1, const Linear_Form<C>& f2);

//! Returns the linear form \p f + \p v and assigns it to \p f.
/*! \relates Linear_Form
  \exception std::length_error
  Thrown if the space dimension of \p v exceeds
  <CODE>Linear_Form::max_space_dimension()</CODE>.
 */
template <typename C>
Linear_Form<C>&
operator+=(Linear_Form<C>& f, Variable v);

//! Returns the linear form \p f + \p n and assigns it to \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>&
operator+=(Linear_Form<C>& f, const C& n);

//! Returns the linear form \p f1 - \p f2 and assigns it to \p f1.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>&
operator-=(Linear_Form<C>& f1, const Linear_Form<C>& f2);

//! Returns the linear form \p f - \p v and assigns it to \p f.
/*! \relates Linear_Form
  \exception std::length_error
  Thrown if the space dimension of \p v exceeds
  <CODE>Linear_Form::max_space_dimension()</CODE>.
 */
template <typename C>
Linear_Form<C>&
operator-=(Linear_Form<C>& f, Variable v);

//! Returns the linear form \p f - \p n and assigns it to \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>&
operator-=(Linear_Form<C>& f, const C& n);

//! Returns the linear form \p n * \p f and assigns it to \p f.
/*! \relates Linear_Form */
template <typename C>
Linear_Form<C>&
operator*=(Linear_Form<C>& f, const C& n);

//! Returns the linear form \p f / \p n and assigns it to \p f.
/*!
   \relates Linear_Form
   Performs the division of a linear form by a scalar. It is up to the user to
   ensure that division by 0 is not performed.
*/
template <typename C>
Linear_Form<C>&
operator/=(Linear_Form<C>& f, const C& n);

//! Returns <CODE>true</CODE> if and only if \p x and \p y are equal.
/*! \relates Linear_Form */
template <typename C>
bool
operator==(const Linear_Form<C>& x, const Linear_Form<C>& y);

//! Returns <CODE>true</CODE> if and only if \p x and \p y are different.
/*! \relates Linear_Form */
template <typename C>
bool
operator!=(const Linear_Form<C>& x, const Linear_Form<C>& y);

namespace IO_Operators {

//! Output operator.
/*! \relates Parma_Polyhedra_Library::Linear_Form */
template <typename C>
std::ostream& operator<<(std::ostream& s, const Linear_Form<C>& f);

} // namespace IO_Operators

} // namespace Parma_Polyhedra_Library

//! A linear form with interval coefficients.
/*! \ingroup PPL_CXX_interface
  An object of the class Linear_Form represents the interval linear form
  \f[
    \sum_{i=0}^{n-1} a_i x_i + b
  \f]
  where \f$n\f$ is the dimension of the vector space,
  each \f$a_i\f$ is the coefficient
  of the \f$i\f$-th variable \f$x_i\f$
  and \f$b\f$ is the inhomogeneous term.
  The coefficients and the inhomogeneous term of the linear form
  have the template parameter \p C as their type. \p C must be the
  type of an Interval.

  \par How to build a linear form.
  A full set of functions is defined in order to provide a convenient
  interface for building complex linear forms starting from simpler ones
  and from objects of the classes Variable and \p C. Available operators
  include binary addition and subtraction, as well as multiplication and
  division by a coefficient.
  The space dimension of a linear form is defined as
  the highest variable dimension among variables that have a nonzero
  coefficient in the linear form, or zero if no such variable exists.
  The space dimension for each variable \f$x_i\f$ is given by \f$i + 1\f$.

  \par Example
  Given the type \p T of an Interval with floating point coefficients (though
  any integral type may also be used), the following code builds the interval
  linear form \f$lf = x_5 - x_2 + 1\f$ with space dimension 6:
  \code
  Variable x5(5);
  Variable x2(2);
  T x5_coefficient;
  x5_coefficient.lower() = 2.0;
  x5_coefficient.upper() = 3.0;
  T inhomogeneous_term;
  inhomogeneous_term.lower() = 4.0;
  inhomogeneous_term.upper() = 8.0;
  Linear_Form<T> lf(x2);
  lf = -lf;
  lf += Linear_Form<T>(x2);
  Linear_Form<T> lf_x5(x5);
  lf_x5 *= x5_coefficient;
  lf += lf_x5;
  \endcode
  Note that \c lf_x5 is created with space dimension 6, while \c lf is
  created with space dimension 0 and then extended first to space
  dimension 2 when \c x2 is subtracted and finally to space dimension
  6 when \c lf_x5 is added.
*/
template <typename C>
class Parma_Polyhedra_Library::Linear_Form {
public:
  //! Default constructor: returns a copy of Linear_Form::zero().
  Linear_Form();

  //! Ordinary copy constructor.
  Linear_Form(const Linear_Form& f);

  //! Destructor.
  ~Linear_Form();

  //! Builds the linear form corresponding to the inhomogeneous term \p n.
  explicit Linear_Form(const C& n);

  //! Builds the linear form corresponding to the variable \p v.
  /*!
    \exception std::length_error
    Thrown if the space dimension of \p v exceeds
    <CODE>Linear_Form::max_space_dimension()</CODE>.
  */
  Linear_Form(Variable v);

  //! Builds a linear form approximating the linear expression \p e.
  Linear_Form(const Linear_Expression& e);

  //! Returns the maximum space dimension a Linear_Form can handle.
  static dimension_type max_space_dimension();

  //! Returns the dimension of the vector space enclosing \p *this.
  dimension_type space_dimension() const;

  //! Returns the coefficient of \p v in \p *this.
  const C& coefficient(Variable v) const;

  //! Returns the inhomogeneous term of \p *this.
  const C& inhomogeneous_term() const;

  //! Negates all the coefficients of \p *this.
  void negate();

  /*! \brief
    Returns a lower bound to the total size in bytes of the memory
    occupied by \p *this.
  */
  memory_size_type total_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  memory_size_type external_memory_in_bytes() const;

  PPL_OUTPUT_DECLARATIONS

  /*! \brief
    Loads from \p s an ASCII representation (as produced by
    ascii_dump(std::ostream&) const) and sets \p *this accordingly.
    Returns <CODE>true</CODE> if successful, <CODE>false</CODE> otherwise.
  */
  bool ascii_load(std::istream& s);

  //! Checks if all the invariants are satisfied.
  bool OK() const;

  //! Swaps \p *this with \p y.
  void m_swap(Linear_Form& y);

  // Floating point analysis related methods.

  /*! \brief
    Verifies if the linear form overflows.

    \return
    Returns <CODE>false</CODE> if all coefficients in \p lf are bounded,
    <CODE>true</CODE> otherwise.

    \p T must be the type of possibly unbounded quantities.
  */
  bool overflows() const;

  /*! \brief
    Computes the relative error associated to floating point computations
    that operate on a quantity that is overapproximated by \p *this.

    \param analyzed_format The floating point format used by the analyzed
    program.
    \param result Becomes the linear form corresponding to the relative
    error committed.

    This method makes <CODE>result</CODE> become a linear form
    obtained by evaluating the function \f$\varepsilon_{\mathbf{f}}(l)\f$
    on the linear form. This function is defined as:
    \f[
    \varepsilon_{\mathbf{f}}\left([a, b]+\sum_{v \in \cV}[a_{v}, b_{v}]v\right)
    \defeq
    (\textrm{max}(|a|, |b|) \amifp [-\beta^{-\textrm{p}}, \beta^{-\textrm{p}}])
    +
    \sum_{v \in \cV}(\textrm{max}(|a_{v}|,|b_{v}|)
    \amifp
    [-\beta^{-\textrm{p}}, \beta^{-\textrm{p}}])v
    \f]
    where p is the fraction size in bits for the format \f$\mathbf{f}\f$ and
    \f$\beta\f$ the base.

    The result is undefined if \p T is not the type of an interval with
    floating point boundaries.
  */
  void relative_error(Floating_Point_Format analyzed_format,
                      Linear_Form& result) const;

  /*! \brief
    Makes \p result become an interval that overapproximates all the
    possible values of \p *this.

    \param oracle The FP_Oracle to be queried.
    \param result The linear form that will store the result.

    \return <CODE>true</CODE> if the operation was successful,
    <CODE>false</CODE> otherwise (the possibility of failure
    depends on the oracle's implementation).

    \par Template type parameters

    - The class template parameter \p Target specifies the implementation
    of Concrete_Expression to be used.

    This method makes <CODE>result</CODE> become
    \f$\iota(lf)\rho^{\#}\f$, that is an interval defined as:
    \f[
    \iota\left(i + \sum_{v \in \cV}i_{v}v\right)\rho^{\#}
    \defeq
    i \asifp \left(\bigoplus_{v \in \cV}{}^{\#}i_{v} \amifp
    \rho^{\#}(v)\right)
    \f]
    where \f$\rho^{\#}(v)\f$ is an interval (provided by the oracle)
    that correctly approximates the value of \f$v\f$.

    The result is undefined if \p C is not the type of an interval with
    floating point boundaries.
  */
  template <typename Target>
  bool intervalize(const FP_Oracle<Target,C>& oracle, C& result) const;

private:
  //! The generic coefficient equal to the singleton zero.
  static C zero;

  //! Type of the container vector.
  typedef std::vector<C> vec_type;

  //! The container vector.
  vec_type vec;

  //! Implementation sizing constructor.
  /*!
    The bool parameter is just to avoid problems with
    the constructor Linear_Form(const C& n).
  */
  Linear_Form(dimension_type sz, bool);

  /*! \brief
    Builds the linear form corresponding to the difference of
    \p v and \p w.

    \exception std::length_error
    Thrown if the space dimension of \p v or the one of \p w exceed
    <CODE>Linear_Form::max_space_dimension()</CODE>.
  */
  Linear_Form(Variable v, Variable w);

  //! Gives the number of generic coefficients currently in use.
  dimension_type size() const;

  //! Extends the vector of \p *this to size \p sz.
  void extend(dimension_type sz);

  //! Returns a reference to \p vec[i].
  C& operator[](dimension_type i);

  //! Returns a const reference to \p vec[i].
  const C& operator[](dimension_type i) const;

  friend Linear_Form<C>
  operator+<C>(const Linear_Form<C>& f1, const Linear_Form<C>& f2);
  friend Linear_Form<C>
  operator+<C>(const C& n, const Linear_Form<C>& f);
  friend Linear_Form<C>
  operator+<C>(const Linear_Form<C>& f, const C& n);
  friend Linear_Form<C>
  operator+<C>(Variable v, const Linear_Form<C>& f);

  friend Linear_Form<C>
  operator-<C>(const Linear_Form<C>& f);

  friend Linear_Form<C>
  operator-<C>(const Linear_Form<C>& f1, const Linear_Form<C>& f2);
  friend Linear_Form<C>
  operator-<C>(const C& n, const Linear_Form<C>& f);
  friend Linear_Form<C>
  operator-<C>(const Linear_Form<C>& f, const C& n);
  friend Linear_Form<C>
  operator-<C>(Variable v, const Linear_Form<C>& f);
  friend Linear_Form<C>
  operator-<C>(const Linear_Form<C>& f, Variable v);

  friend Linear_Form<C>
  operator*<C>(const C& n, const Linear_Form<C>& f);
  friend Linear_Form<C>
  operator*<C>(const Linear_Form<C>& f, const C& n);

  friend Linear_Form<C>&
  operator+=<C>(Linear_Form<C>& f1, const Linear_Form<C>& f2);
  friend Linear_Form<C>&
  operator+=<C>(Linear_Form<C>& f, Variable v);
  friend Linear_Form<C>&
  operator+=<C>(Linear_Form<C>& f, const C& n);

  friend Linear_Form<C>&
  operator-=<C>(Linear_Form<C>& f1, const Linear_Form<C>& f2);
  friend Linear_Form<C>&
  operator-=<C>(Linear_Form<C>& f, Variable v);
  friend Linear_Form<C>&
  operator-=<C>(Linear_Form<C>& f, const C& n);

  friend Linear_Form<C>&
  operator*=<C>(Linear_Form<C>& f, const C& n);

  friend Linear_Form<C>&
  operator/=<C>(Linear_Form<C>& f, const C& n);

  friend bool
  operator==<C>(const Linear_Form<C>& x, const Linear_Form<C>& y);

  friend std::ostream&
  Parma_Polyhedra_Library::IO_Operators
  ::operator<<<C>(std::ostream& s, const Linear_Form<C>& f);
};

/* Automatically generated from PPL source file ../src/Linear_Form_inlines.hh line 1. */
/* Linear_Form class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Linear_Form_inlines.hh line 28. */
#include <iostream>
#include <stdexcept>

namespace Parma_Polyhedra_Library {

template <typename C>
inline dimension_type
Linear_Form<C>::max_space_dimension() {
  return vec_type().max_size() - 1;
}

template <typename C>
inline
Linear_Form<C>::Linear_Form()
  : vec(1, zero) {
  vec.reserve(compute_capacity(1, vec_type().max_size()));
}

template <typename C>
inline
Linear_Form<C>::Linear_Form(dimension_type sz, bool)
  : vec(sz, zero) {
  vec.reserve(compute_capacity(sz, vec_type().max_size()));
}

template <typename C>
inline
Linear_Form<C>::Linear_Form(const Linear_Form& f)
  : vec(f.vec) {
}

template <typename C>
inline
Linear_Form<C>::~Linear_Form() {
}

template <typename C>
inline dimension_type
Linear_Form<C>::size() const {
  return vec.size();
}

template <typename C>
inline void
Linear_Form<C>::extend(dimension_type sz) {
  assert(sz > size());
  vec.reserve(compute_capacity(sz, vec_type().max_size()));
  vec.resize(sz, zero);
}

template <typename C>
inline
Linear_Form<C>::Linear_Form(const C& n)
  : vec(1, n) {
  vec.reserve(compute_capacity(1, vec_type().max_size()));
}

template <typename C>
inline dimension_type
Linear_Form<C>::space_dimension() const {
  return size() - 1;
}

template <typename C>
inline const C&
Linear_Form<C>::coefficient(Variable v) const {
  if (v.space_dimension() > space_dimension()) {
    return zero;
  }
  return vec[v.id()+1];
}

template <typename C>
inline C&
Linear_Form<C>::operator[](dimension_type i) {
  assert(i < size());
  return vec[i];
}

template <typename C>
inline const C&
Linear_Form<C>::operator[](dimension_type i) const {
  assert(i < size());
  return vec[i];
}

template <typename C>
inline const C&
Linear_Form<C>::inhomogeneous_term() const {
  return vec[0];
}

template <typename C>
inline memory_size_type
Linear_Form<C>::total_memory_in_bytes() const {
  return sizeof(*this) + external_memory_in_bytes();
}

/*! \relates Linear_Form */
template <typename C>
inline Linear_Form<C>
operator+(const Linear_Form<C>& f) {
  return f;
}

/*! \relates Linear_Form */
template <typename C>
inline Linear_Form<C>
operator+(const Linear_Form<C>& f, const C& n) {
  return n + f;
}

/*! \relates Linear_Form */
template <typename C>
inline Linear_Form<C>
operator+(const Linear_Form<C>& f, const Variable v) {
  return v + f;
}

/*! \relates Linear_Form */
template <typename C>
inline Linear_Form<C>
operator-(const Linear_Form<C>& f, const C& n) {
  return -n + f;
}

/*! \relates Linear_Form */
template <typename C>
inline Linear_Form<C>
operator-(const Variable v, const Variable w) {
  return Linear_Form<C>(v, w);
}

/*! \relates Linear_Form */
template <typename C>
inline Linear_Form<C>
operator*(const Linear_Form<C>& f, const C& n) {
  return n * f;
}

/*! \relates Linear_Form */
template <typename C>
inline Linear_Form<C>&
operator+=(Linear_Form<C>& f, const C& n) {
  f[0] += n;
  return f;
}

/*! \relates Linear_Form */
template <typename C>
inline Linear_Form<C>&
operator-=(Linear_Form<C>& f, const C& n) {
  f[0] -= n;
  return f;
}

/*! \relates Linear_Form */
template <typename C>
inline bool
operator!=(const Linear_Form<C>& x, const Linear_Form<C>& y) {
  return !(x == y);
}

template <typename C>
inline void
Linear_Form<C>::m_swap(Linear_Form& y) {
  using std::swap;
  swap(vec, y.vec);
}

template <typename C>
inline void
Linear_Form<C>::ascii_dump(std::ostream& s) const {
  using namespace IO_Operators;
  dimension_type space_dim = space_dimension();
  s << space_dim << "\n";
  for (dimension_type i = 0; i <= space_dim; ++i) {
    const char separator = ' ';
    s << vec[i] << separator;
  }
  s << "\n";
}

template <typename C>
inline bool
Linear_Form<C>::ascii_load(std::istream& s) {
  using namespace IO_Operators;
  dimension_type new_dim;
  if (!(s >> new_dim)) {
    return false;
  }

  vec.resize(new_dim + 1, zero);
  for (dimension_type i = 0; i <= new_dim; ++i) {
    if (!(s >> vec[i])) {
      return false;
    }
  }

  PPL_ASSERT(OK());
  return true;
}

// Floating point analysis related methods.
template <typename C>
inline bool
Linear_Form<C>::overflows() const {
  if (!inhomogeneous_term().is_bounded()) {
    return true;
  }
  for (dimension_type i = space_dimension(); i-- > 0; ) {
    if (!coefficient(Variable(i)).is_bounded()) {
      return true;
    }
  }

  return false;
}

/*! \relates Linear_Form */
template <typename C>
inline void
swap(Linear_Form<C>& x, Linear_Form<C>& y) {
  x.m_swap(y);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Form_defs.hh line 497. */
// Linear_Form_templates.hh is not included here on purpose.

/* Automatically generated from PPL source file ../src/Float_inlines.hh line 30. */
#include <climits>

namespace Parma_Polyhedra_Library {

inline int
float_ieee754_half::inf_sign() const {
  if (word == NEG_INF) {
    return -1;
  }
  if (word == POS_INF) {
    return 1;
  }
  return 0;
}

inline bool
float_ieee754_half::is_nan() const {
  return (word & ~SGN_MASK) > POS_INF;
}

inline int
float_ieee754_half::zero_sign() const {
  if (word == NEG_ZERO) {
    return -1;
  }
  if (word == POS_ZERO) {
    return 1;
  }
  return 0;
}

inline void
float_ieee754_half::negate() {
  word ^= SGN_MASK;
}

inline bool
float_ieee754_half::sign_bit() const {
  return (word & SGN_MASK) != 0;
}

inline void
float_ieee754_half::dec() {
  --word;
}

inline void
float_ieee754_half::inc() {
  ++word;
}

inline void
float_ieee754_half::set_max(bool negative) {
  word = WRD_MAX;
  if (negative) {
    word |= SGN_MASK;
  }
}

inline void
float_ieee754_half::build(bool negative, mpz_t mantissa, int exponent) {
  word = static_cast<uint16_t>(mpz_get_ui(mantissa)
                               & ((1UL << MANTISSA_BITS) - 1));
  if (negative) {
    word |= SGN_MASK;
  }
  const int exponent_repr = exponent + EXPONENT_BIAS;
  PPL_ASSERT(exponent_repr >= 0 && exponent_repr < (1 << EXPONENT_BITS));
  word |= static_cast<uint16_t>(exponent_repr) << MANTISSA_BITS;
}

inline int
float_ieee754_single::inf_sign() const {
  if (word == NEG_INF) {
    return -1;
  }
  if (word == POS_INF) {
    return 1;
  }
  return 0;
}

inline bool
float_ieee754_single::is_nan() const {
  return (word & ~SGN_MASK) > POS_INF;
}

inline int
float_ieee754_single::zero_sign() const {
  if (word == NEG_ZERO) {
    return -1;
  }
  if (word == POS_ZERO) {
    return 1;
  }
  return 0;
}

inline void
float_ieee754_single::negate() {
  word ^= SGN_MASK;
}

inline bool
float_ieee754_single::sign_bit() const {
  return (word & SGN_MASK) != 0;
}

inline void
float_ieee754_single::dec() {
  --word;
}

inline void
float_ieee754_single::inc() {
  ++word;
}

inline void
float_ieee754_single::set_max(bool negative) {
  word = WRD_MAX;
  if (negative) {
    word |= SGN_MASK;
  }
}

inline void
float_ieee754_single::build(bool negative, mpz_t mantissa, int exponent) {
  word = static_cast<uint32_t>(mpz_get_ui(mantissa)
                               & ((1UL << MANTISSA_BITS) - 1));
  if (negative) {
    word |= SGN_MASK;
  }
  const int exponent_repr = exponent + EXPONENT_BIAS;
  PPL_ASSERT(exponent_repr >= 0 && exponent_repr < (1 << EXPONENT_BITS));
  word |= static_cast<uint32_t>(exponent_repr) << MANTISSA_BITS;
}

inline int
float_ieee754_double::inf_sign() const {
  if (lsp != LSP_INF) {
    return 0;
  }
  if (msp == MSP_NEG_INF) {
    return -1;
  }
  if (msp == MSP_POS_INF) {
    return 1;
  }
  return 0;
}

inline bool
float_ieee754_double::is_nan() const {
  const uint32_t a = msp & ~MSP_SGN_MASK;
  return a > MSP_POS_INF || (a == MSP_POS_INF && lsp != LSP_INF);
}

inline int
float_ieee754_double::zero_sign() const {
  if (lsp != LSP_ZERO) {
    return 0;
  }
  if (msp == MSP_NEG_ZERO) {
    return -1;
  }
  if (msp == MSP_POS_ZERO) {
    return 1;
  }
  return 0;
}

inline void
float_ieee754_double::negate() {
  msp ^= MSP_SGN_MASK;
}

inline bool
float_ieee754_double::sign_bit() const {
  return (msp & MSP_SGN_MASK) != 0;
}

inline void
float_ieee754_double::dec() {
  if (lsp == 0) {
    --msp;
    lsp = LSP_MAX;
  }
  else {
    --lsp;
  }
}

inline void
float_ieee754_double::inc() {
  if (lsp == LSP_MAX) {
    ++msp;
    lsp = 0;
  }
  else {
    ++lsp;
  }
}

inline void
float_ieee754_double::set_max(bool negative) {
  msp = MSP_MAX;
  lsp = LSP_MAX;
  if (negative) {
    msp |= MSP_SGN_MASK;
  }
}

inline void
float_ieee754_double::build(bool negative, mpz_t mantissa, int exponent) {
  unsigned long m;
#if ULONG_MAX == 0xffffffffUL
  lsp = mpz_get_ui(mantissa);
  mpz_tdiv_q_2exp(mantissa, mantissa, 32);
  m = mpz_get_ui(mantissa);
#else
  m = mpz_get_ui(mantissa);
  lsp = static_cast<uint32_t>(m & LSP_MAX);
  m >>= 32;
#endif
  msp = static_cast<uint32_t>(m & ((1UL << (MANTISSA_BITS - 32)) - 1));
  if (negative) {
    msp |= MSP_SGN_MASK;
  }
  const int exponent_repr = exponent + EXPONENT_BIAS;
  PPL_ASSERT(exponent_repr >= 0 && exponent_repr < (1 << EXPONENT_BITS));
  msp |= static_cast<uint32_t>(exponent_repr) << (MANTISSA_BITS - 32);
}

inline int
float_ibm_single::inf_sign() const {
  if (word == NEG_INF) {
    return -1;
  }
  if (word == POS_INF) {
    return 1;
  }
  return 0;
}

inline bool
float_ibm_single::is_nan() const {
  return (word & ~SGN_MASK) > POS_INF;
}

inline int
float_ibm_single::zero_sign() const {
  if (word == NEG_ZERO) {
    return -1;
  }
  if (word == POS_ZERO) {
    return 1;
  }
  return 0;
}

inline void
float_ibm_single::negate() {
  word ^= SGN_MASK;
}

inline bool
float_ibm_single::sign_bit() const {
  return (word & SGN_MASK) != 0;
}

inline void
float_ibm_single::dec() {
  --word;
}

inline void
float_ibm_single::inc() {
  ++word;
}

inline void
float_ibm_single::set_max(bool negative) {
  word = WRD_MAX;
  if (negative) {
    word |= SGN_MASK;
  }
}

inline void
float_ibm_single::build(bool negative, mpz_t mantissa, int exponent) {
  word = static_cast<uint32_t>(mpz_get_ui(mantissa)
                               & ((1UL << MANTISSA_BITS) - 1));
  if (negative) {
    word |= SGN_MASK;
  }
  const int exponent_repr = exponent + EXPONENT_BIAS;
  PPL_ASSERT(exponent_repr >= 0 && exponent_repr < (1 << EXPONENT_BITS));
  word |= static_cast<uint32_t>(exponent_repr) << MANTISSA_BITS;
}

inline int
float_intel_double_extended::inf_sign() const {
  if (lsp != LSP_INF) {
    return 0;
  }
  const uint32_t a = msp & MSP_NEG_INF;
  if (a == MSP_NEG_INF) {
    return -1;
  }
  if (a == MSP_POS_INF) {
    return 1;
  }
  return 0;
}

inline bool
float_intel_double_extended::is_nan() const {
  return (msp & MSP_POS_INF) == MSP_POS_INF
    && lsp != LSP_INF;
}

inline int
float_intel_double_extended::zero_sign() const {
  if (lsp != LSP_ZERO) {
    return 0;
  }
  const uint32_t a = msp & MSP_NEG_INF;
  if (a == MSP_NEG_ZERO) {
    return -1;
  }
  if (a == MSP_POS_ZERO) {
    return 1;
  }
  return 0;
}

inline void
float_intel_double_extended::negate() {
  msp ^= MSP_SGN_MASK;
}

inline bool
float_intel_double_extended::sign_bit() const {
  return (msp & MSP_SGN_MASK) != 0;
}

inline void
float_intel_double_extended::dec() {
  if ((lsp & LSP_DMAX) == 0) {
    --msp;
    lsp = ((msp & MSP_NEG_INF) == 0) ? LSP_DMAX : LSP_NMAX;
  }
  else {
    --lsp;
  }
}

inline void
float_intel_double_extended::inc() {
  if ((lsp & LSP_DMAX) == LSP_DMAX) {
    ++msp;
    lsp = LSP_DMAX + 1;
  }
  else {
    ++lsp;
  }
}

inline void
float_intel_double_extended::set_max(bool negative) {
  msp = MSP_MAX;
  lsp = LSP_NMAX;
  if (negative) {
    msp |= MSP_SGN_MASK;
  }
}

inline void
float_intel_double_extended::build(bool negative,
                                   mpz_t mantissa, int exponent) {
#if ULONG_MAX == 0xffffffffUL
  mpz_export(&lsp, 0, -1, sizeof(lsp), 0, 0, mantissa);
#else
  lsp = mpz_get_ui(mantissa);
#endif
  msp = (negative ? MSP_SGN_MASK : 0);
  const int exponent_repr = exponent + EXPONENT_BIAS;
  PPL_ASSERT(exponent_repr >= 0 && exponent_repr < (1 << EXPONENT_BITS));
  msp |= static_cast<uint32_t>(exponent_repr);
}

inline int
float_ieee754_quad::inf_sign() const {
  if (lsp != LSP_INF) {
    return 0;
  }
  if (msp == MSP_NEG_INF) {
    return -1;
  }
  if (msp == MSP_POS_INF) {
    return 1;
  }
  return 0;
}

inline bool
float_ieee754_quad::is_nan() const {
  return (msp & ~MSP_SGN_MASK) == MSP_POS_INF
    && lsp != LSP_INF;
}

inline int
float_ieee754_quad::zero_sign() const {
  if (lsp != LSP_ZERO) {
    return 0;
  }
  if (msp == MSP_NEG_ZERO) {
    return -1;
  }
  if (msp == MSP_POS_ZERO) {
    return 1;
  }
  return 0;
}

inline void
float_ieee754_quad::negate() {
  msp ^= MSP_SGN_MASK;
}

inline bool
float_ieee754_quad::sign_bit() const {
  return (msp & MSP_SGN_MASK) != 0;
}

inline void
float_ieee754_quad::dec() {
  if (lsp == 0) {
    --msp;
    lsp = LSP_MAX;
  }
  else {
    --lsp;
  }
}

inline void
float_ieee754_quad::inc() {
  if (lsp == LSP_MAX) {
    ++msp;
    lsp = 0;
  }
  else {
    ++lsp;
  }
}

inline void
float_ieee754_quad::set_max(bool negative) {
  msp = MSP_MAX;
  lsp = LSP_MAX;
  if (negative) {
    msp |= MSP_SGN_MASK;
  }
}

inline void
float_ieee754_quad::build(bool negative, mpz_t mantissa, int exponent) {
  uint64_t parts[2];
  mpz_export(parts, 0, -1, sizeof(parts[0]), 0, 0, mantissa);
  lsp = parts[0];
  msp = parts[1];
  msp &= ((static_cast<uint64_t>(1) << (MANTISSA_BITS - 64)) - 1);
  if (negative) {
    msp |= MSP_SGN_MASK;
  }
  const int exponent_repr = exponent + EXPONENT_BIAS;
  PPL_ASSERT(exponent_repr >= 0 && exponent_repr < (1 << EXPONENT_BITS));
  msp |= static_cast<uint64_t>(exponent_repr) << (MANTISSA_BITS - 64);
}

inline bool
is_less_precise_than(Floating_Point_Format f1, Floating_Point_Format f2) {
  return f1 < f2;
}

inline unsigned int
msb_position(unsigned long long v) {
  return static_cast<unsigned int>(sizeof_to_bits(sizeof(v))) - 1U - clz(v);
}

template <typename FP_Interval_Type>
inline void
affine_form_image(std::map<dimension_type,
                           Linear_Form<FP_Interval_Type> >& lf_store,
                  const Variable var,
                  const Linear_Form<FP_Interval_Type>& lf) {
  // Assign the new linear form for var.
  lf_store[var.id()] = lf;
  // Now invalidate all linear forms in which var occurs.
  discard_occurrences(lf_store, var);
}

#if PPL_SUPPORTED_FLOAT
inline
Float<float>::Float() {
}

inline
Float<float>::Float(float v) {
  u.number = v;
}

inline float
Float<float>::value() {
  return u.number;
}
#endif

#if PPL_SUPPORTED_DOUBLE
inline
Float<double>::Float() {
}

inline
Float<double>::Float(double v) {
  u.number = v;
}

inline double
Float<double>::value() {
  return u.number;
}
#endif

#if PPL_SUPPORTED_LONG_DOUBLE
inline
Float<long double>::Float() {
}

inline
Float<long double>::Float(long double v) {
  u.number = v;
}

inline long double
Float<long double>::value() {
  return u.number;
}
#endif

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Float_templates.hh line 1. */
/* IEC 559 floating point format related functions:
   non-inline template functions.
*/


/* Automatically generated from PPL source file ../src/Float_templates.hh line 30. */
#include <cmath>

namespace Parma_Polyhedra_Library {

template <typename FP_Interval_Type>
const FP_Interval_Type& compute_absolute_error(
                        const Floating_Point_Format analyzed_format) {
  typedef typename FP_Interval_Type::boundary_type analyzer_format;

  // FIXME: check if initializing caches with EMPTY is better.
  static const FP_Interval_Type ZERO_INTERVAL = FP_Interval_Type(0);
  // Cached results for each different analyzed format.
  static FP_Interval_Type ieee754_half_result = ZERO_INTERVAL;
  static FP_Interval_Type ieee754_single_result = ZERO_INTERVAL;
  static FP_Interval_Type ieee754_double_result = ZERO_INTERVAL;
  static FP_Interval_Type ibm_single_result = ZERO_INTERVAL;
  static FP_Interval_Type ieee754_quad_result = ZERO_INTERVAL;
  static FP_Interval_Type intel_double_extended_result = ZERO_INTERVAL;

  FP_Interval_Type* to_compute = NULL;
  // Get the necessary information on the analyzed's format.
  unsigned int f_base;
  int f_exponent_bias;
  unsigned int f_mantissa_bits;
  switch (analyzed_format) {
    case IEEE754_HALF:
      if (ieee754_half_result != ZERO_INTERVAL) {
        return ieee754_half_result;
      }
      to_compute = &ieee754_half_result;
      f_base = float_ieee754_half::BASE;
      f_exponent_bias = float_ieee754_half::EXPONENT_BIAS;
      f_mantissa_bits = float_ieee754_half::MANTISSA_BITS;
      break;
    case IEEE754_SINGLE:
      if (ieee754_single_result != ZERO_INTERVAL) {
        return ieee754_single_result;
      }

      to_compute = &ieee754_single_result;
      f_base = float_ieee754_single::BASE;
      f_exponent_bias = float_ieee754_single::EXPONENT_BIAS;
      f_mantissa_bits = float_ieee754_single::MANTISSA_BITS;
      break;
    case IEEE754_DOUBLE:
      if (ieee754_double_result != ZERO_INTERVAL) {
        return ieee754_double_result;
      }

      to_compute = &ieee754_double_result;
      f_base = float_ieee754_double::BASE;
      f_exponent_bias = float_ieee754_double::EXPONENT_BIAS;
      f_mantissa_bits = float_ieee754_double::MANTISSA_BITS;
      break;
    case IBM_SINGLE:
      if (ibm_single_result != ZERO_INTERVAL) {
        return ibm_single_result;
      }

      to_compute = &ibm_single_result;
      f_base = float_ibm_single::BASE;
      f_exponent_bias = float_ibm_single::EXPONENT_BIAS;
      f_mantissa_bits = float_ibm_single::MANTISSA_BITS;
      break;
    case IEEE754_QUAD:
      if (ieee754_quad_result != ZERO_INTERVAL) {
        return ieee754_quad_result;
      }

      to_compute = &ieee754_quad_result;
      f_base = float_ieee754_quad::BASE;
      f_exponent_bias = float_ieee754_quad::EXPONENT_BIAS;
      f_mantissa_bits = float_ieee754_quad::MANTISSA_BITS;
      break;
    case INTEL_DOUBLE_EXTENDED:
      if (intel_double_extended_result != ZERO_INTERVAL) {
        return intel_double_extended_result;
      }

      to_compute = &intel_double_extended_result;
      f_base = float_intel_double_extended::BASE;
      f_exponent_bias = float_intel_double_extended::EXPONENT_BIAS;
      f_mantissa_bits = float_intel_double_extended::MANTISSA_BITS;
      break;
    default:
      PPL_UNREACHABLE;
      break;
  }

  PPL_ASSERT(to_compute != NULL);

  // We assume that f_base is a power of 2.
  analyzer_format omega;
  int power = static_cast<int>(msb_position(f_base))
    * ((1 - f_exponent_bias) - static_cast<int>(f_mantissa_bits));
  omega = std::max(static_cast<analyzer_format>(ldexp(1.0, power)),
                   std::numeric_limits<analyzer_format>::denorm_min());

  to_compute->build(i_constraint(GREATER_OR_EQUAL, -omega),
                    i_constraint(LESS_OR_EQUAL, omega));
  return *to_compute;
}

template <typename FP_Interval_Type>
void
discard_occurrences(std::map<dimension_type,
                             Linear_Form<FP_Interval_Type> >& lf_store,
                    Variable var) {
  typedef Linear_Form<FP_Interval_Type> FP_Linear_Form;
  typedef typename std::map<dimension_type, FP_Linear_Form>::iterator Iter;
  for (Iter i = lf_store.begin(); i != lf_store.end(); ) {
    if ((i->second).coefficient(var) != 0) {
      i = lf_store.erase(i);
    }
    else {
      ++i;
    }
  }
}

/* FIXME: improve efficiency by adding the list of potentially conflicting
   variables as an argument. */
template <typename FP_Interval_Type>
void upper_bound_assign(std::map<dimension_type,
                                 Linear_Form<FP_Interval_Type> >& ls1,
                        const std::map<dimension_type,
                                       Linear_Form<FP_Interval_Type> >& ls2) {
  typedef Linear_Form<FP_Interval_Type> FP_Linear_Form;
  typedef typename std::map<dimension_type, FP_Linear_Form>::iterator Iter;
  typedef typename std::map<dimension_type,
                            FP_Linear_Form>::const_iterator Const_Iter;

  Const_Iter i2_end = ls2.end();
  for (Iter i1 = ls1.begin(), i1_end = ls1.end(); i1 != i1_end; ) {
    Const_Iter i2 = ls2.find(i1->first);
    if ((i2 == i2_end) || (i1->second != i2->second)) {
      i1 = ls1.erase(i1);
    }
    else {
      ++i1;
    }
  }
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Float_defs.hh line 521. */

/* Automatically generated from PPL source file ../src/checked_defs.hh line 32. */
#include <cassert>
#include <iostream>
#include <gmpxx.h>

namespace Parma_Polyhedra_Library {

namespace Checked {


// It is a pity that function partial specialization is not permitted
// by C++.  To (partly) overcome this limitation, we use class
// encapsulated functions and partial specialization of containing
// classes.

#define PPL_FUNCTION_CLASS(name) name ## _function_struct

#define PPL_DECLARE_FUN1_0_0(name, ret_type, qual, type)                \
  template <typename Policy, typename type>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy, typename type>                             \
  inline ret_type PPL_U(name)(PPL_U(qual) PPL_U(type)& arg) {           \
    return PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)>::function(arg); \
  }

#define PPL_DECLARE_FUN1_0_1(name, ret_type, qual, type, after1)        \
  template <typename Policy, typename type>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy, typename type>                             \
  inline ret_type PPL_U(name)(PPL_U(qual) PPL_U(type)& arg, PPL_U(after1) a1) { \
    return                                                              \
      PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)>::function(arg, a1); \
  }

#define PPL_DECLARE_FUN1_0_2(name, ret_type, qual, type, after1, after2) \
  template <typename Policy, typename type>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy, typename type>                             \
  inline ret_type PPL_U(name)(PPL_U(qual) PPL_U(type)& arg, PPL_U(after1) a1, \
                       PPL_U(after2) a2) {                              \
    return                                                              \
      PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)>::function(arg,      \
                                                              a1, a2);  \
  }

#define PPL_DECLARE_FUN1_0_3(name, ret_type, qual, type,                \
                             after1, after2, after3)                    \
  template <typename Policy, typename type>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy, typename type>                             \
  inline ret_type PPL_U(name)(PPL_U(qual) PPL_U(type)& arg,             \
                       PPL_U(after1) a1, PPL_U(after2) a2,              \
                       PPL_U(after3) a3) {                              \
    return                                                              \
      PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)>::function(arg,      \
                                                              a1, a2,   \
                                                              a3);      \
  }

#define PPL_DECLARE_FUN1_1_1(name, ret_type, before1, qual, type, after1) \
  template <typename Policy, typename type>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy, typename type>                             \
  inline ret_type PPL_U(name)(PPL_U(before1) b1, PPL_U(qual) PPL_U(type)& arg, \
                       PPL_U(after1) a1) {                              \
    return                                                              \
      PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)>::function(b1, arg,  \
                                                              a1);      \
  }

#define PPL_DECLARE_FUN1_1_2(name, ret_type, before1, qual, type,       \
                             after1, after2)                            \
  template <typename Policy, typename type>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy, typename type>                             \
  inline ret_type PPL_U(name)(PPL_U(before1) b1, PPL_U(qual) PPL_U(type)& arg, \
                       PPL_U(after1) a1, PPL_U(after2) a2) {            \
    return                                                              \
      PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)>::function(b1, arg,  \
                                                              a1, a2);  \
  }

#define PPL_DECLARE_FUN1_2_2(name, ret_type, before1, before2, qual, type, \
                             after1, after2)                            \
  template <typename Policy, typename type>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy, typename type>                             \
  inline ret_type PPL_U(name)(PPL_U(before1) b1, PPL_U(before2) b2,     \
                       PPL_U(qual) PPL_U(type)& arg,                    \
                       PPL_U(after1) a1, PPL_U(after2) a2) {            \
    return                                                              \
      PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)>::function(b1, b2,   \
                                                              arg,      \
                                                              a1, a2);  \
  }

#define PPL_DECLARE_FUN2_0_0(name, ret_type, qual1, type1, qual2, type2) \
  template <typename Policy1, typename Policy2,                         \
            typename type1, typename type2>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy1, typename Policy2,                         \
            typename type1, typename type2>                             \
  inline ret_type PPL_U(name)(PPL_U(qual1) PPL_U(type1)& arg1,          \
                       PPL_U(qual2) PPL_U(type2)& arg2) {               \
    return PPL_FUNCTION_CLASS(name)<Policy1, Policy2,                   \
      type1, PPL_U(type2)>::function(arg1, arg2);                       \
  }

#define PPL_DECLARE_FUN2_0_1(name, ret_type, qual1, type1,      \
                             qual2, type2, after1)              \
  template <typename Policy1, typename Policy2,                 \
            typename type1, typename type2>                     \
  struct PPL_FUNCTION_CLASS(name);                              \
  template <typename Policy1, typename Policy2,                 \
            typename type1, typename type2>                     \
  inline ret_type PPL_U(name)(PPL_U(qual1) PPL_U(type1)& arg1,  \
                       PPL_U(qual2) PPL_U(type2)& arg2,         \
                       PPL_U(after1) a1) {                      \
    return PPL_FUNCTION_CLASS(name)<Policy1, Policy2,           \
      type1, PPL_U(type2)>::function(arg1, arg2, a1);           \
  }

#define PPL_DECLARE_FUN2_0_2(name, ret_type, qual1, type1, qual2, type2, \
                             after1, after2)                            \
  template <typename Policy1, typename Policy2,                         \
            typename type1, typename type2>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy1, typename Policy2,                         \
            typename type1, typename type2>                             \
  inline ret_type PPL_U(name)(PPL_U(qual1) PPL_U(type1)& arg1,          \
                       PPL_U(qual2) PPL_U(type2)& arg2,                 \
                       PPL_U(after1) a1, PPL_U(after2) a2) {            \
    return PPL_FUNCTION_CLASS(name)<Policy1, Policy2,                   \
      type1, PPL_U(type2)>::function(arg1, arg2, a1, a2);               \
  }

#define PPL_DECLARE_FUN3_0_1(name, ret_type, qual1, type1,              \
                             qual2, type2, qual3, type3, after1)        \
  template <typename Policy1, typename Policy2, typename Policy3,       \
            typename type1, typename type2, typename type3>             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy1, typename Policy2, typename Policy3,       \
            typename type1, typename type2, typename type3>             \
  inline ret_type PPL_U(name)(PPL_U(qual1) PPL_U(type1)& arg1,          \
                       PPL_U(qual2) PPL_U(type2)& arg2,                 \
                       PPL_U(qual3) PPL_U(type3)& arg3,                 \
                       PPL_U(after1) a1) {                              \
    return PPL_FUNCTION_CLASS(name)<Policy1, Policy2, Policy3,          \
      type1, type2, PPL_U(type3)>                                       \
      ::function(arg1, arg2, arg3, a1);                                 \
  }

#define PPL_DECLARE_FUN5_0_1(name, ret_type,                            \
                             qual1, type1, qual2, type2, qual3, type3,  \
                             qual4, type4, qual5, type5,                \
                             after1)                                    \
  template <typename Policy1, typename Policy2, typename Policy3,       \
            typename Policy4,typename Policy5,                          \
            typename type1, typename type2, typename type3,             \
            typename type4, typename type5>                             \
  struct PPL_FUNCTION_CLASS(name);                                      \
  template <typename Policy1, typename Policy2, typename Policy3,       \
            typename Policy4,typename Policy5,                          \
            typename type1, typename type2, typename type3,             \
            typename type4, typename type5>                             \
  inline ret_type PPL_U(name)(PPL_U(qual1) PPL_U(type1)& arg1, PPL_U(qual2) \
                       PPL_U(type2)& arg2,                              \
                       PPL_U(qual3) PPL_U(type3)& arg3, PPL_U(qual4)    \
                       PPL_U(type4)& arg4,                              \
                       PPL_U(qual5) PPL_U(type5)& arg5,                 \
                       PPL_U(after1) a1) {                              \
    return PPL_FUNCTION_CLASS(name)<Policy1, Policy2, Policy3,          \
      Policy4, Policy5,                                                 \
      type1, type2,                                                     \
      type3, type4,                                                     \
      PPL_U(type5)>                                                     \
      ::function(arg1, arg2, arg3, arg4, arg5, a1);                     \
  }

#define PPL_SPECIALIZE_FUN1_0_0(name, func, ret_type, qual, type)       \
  template <typename Policy>                                            \
  struct PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)> {                \
    static inline ret_type function(PPL_U(qual) PPL_U(type)& arg) {     \
      return PPL_U(func)<Policy>(arg);                                  \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN1_0_1(name, func, ret_type, qual, type, after1) \
  template <typename Policy>                                            \
  struct PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)> {                \
    static inline ret_type function(PPL_U(qual) PPL_U(type)& arg,       \
                                    PPL_U(after1) a1) {                 \
      return PPL_U(func)<Policy>(arg, a1);                              \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN1_0_2(name, func, ret_type, qual, type,       \
                                after1, after2)                         \
  template <typename Policy>                                            \
  struct PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)> {                \
    static inline ret_type function(PPL_U(qual) PPL_U(type)& arg,       \
                                    PPL_U(after1) a1, PPL_U(after2) a2) \
    {                                                                   \
      return PPL_U(func)<Policy>(arg, a1, a2);                          \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN1_0_3(name, func, ret_type, qual, type,       \
                                after1, after2, after3)                 \
  template <typename Policy>                                            \
  struct PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)> {                \
    static inline ret_type function(PPL_U(qual) PPL_U(type)& arg,       \
                                    PPL_U(after1) a1, PPL_U(after2) a2, \
                                    PPL_U(after3) a3) {                 \
      return PPL_U(func)<Policy>(arg, a1, a2, a3);                      \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN1_1_1(name, func, ret_type, before1,          \
                                qual, type, after1)                     \
  template <typename Policy>                                            \
  struct PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)> {                \
    static inline ret_type function(PPL_U(before1) b1, PPL_U(qual)      \
                                    PPL_U(type)& arg,                   \
                                    PPL_U(after1) a1) {                 \
      return PPL_U(func)<Policy>(b1, arg, a1);                          \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN1_1_2(name, func, ret_type, before1,          \
                                qual, type, after1, after2)             \
  template <typename Policy>                                            \
  struct PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)> {                \
    static inline ret_type function(PPL_U(before1) b1, PPL_U(qual)      \
                                    PPL_U(type)& arg,                   \
                                    PPL_U(after1) a1, PPL_U(after2) a2) \
    {                                                                   \
      return PPL_U(func)<Policy>(b1, arg, a1, a2);                      \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN1_2_2(name, func, ret_type, before1, before2, \
                                qual, type, after1, after2)             \
  template <typename Policy>                                            \
  struct PPL_FUNCTION_CLASS(name)<Policy, PPL_U(type)> {                \
    static inline ret_type function(PPL_U(before1) b1, PPL_U(before2) b2, \
                                    PPL_U(qual) PPL_U(type)& arg,       \
                                    PPL_U(after1) a1, PPL_U(after2) a2) \
    {                                                                   \
      return PPL_U(func)<Policy>(b1, b2, arg, a1, a2);                  \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN2_0_0(name, func, ret_type, qual1, type1,     \
                                qual2, type2)                           \
  template <typename Policy1, typename Policy2>                         \
  struct PPL_FUNCTION_CLASS(name)<Policy1, Policy2, type1,              \
                                  PPL_U(type2)> {                       \
    static inline ret_type function(PPL_U(qual1) PPL_U(type1)& arg1,    \
                                    PPL_U(qual2) PPL_U(type2) &arg2) {  \
      return PPL_U(func)<Policy1, Policy2>(arg1, arg2);                 \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN2_0_1(name, func, ret_type, qual1, type1,     \
                                qual2, type2, after1)                   \
  template <typename Policy1, typename Policy2>                         \
  struct PPL_FUNCTION_CLASS(name)<Policy1, Policy2, type1,              \
                                  PPL_U(type2)> {                       \
    static inline ret_type function(PPL_U(qual1) PPL_U(type1)& arg1,    \
                                    PPL_U(qual2) PPL_U(type2) &arg2,    \
                                    PPL_U(after1) a1) {                 \
      return PPL_U(func)<Policy1, Policy2>(arg1, arg2, a1);             \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN2_0_2(name, func, ret_type, qual1, type1,     \
                                qual2, type2, after1, after2)           \
  template <typename Policy1, typename Policy2>                         \
  struct PPL_FUNCTION_CLASS(name)<Policy1, Policy2, type1,              \
                                  PPL_U(type2)> {                       \
    static inline ret_type function(PPL_U(qual1) PPL_U(type1)& arg1,    \
                                    PPL_U(qual2) PPL_U(type2) &arg2,    \
                                    PPL_U(after1) a1, PPL_U(after2) a2) \
    {                                                                   \
      return PPL_U(func)<Policy1, Policy2>(arg1, arg2, a1, a2);         \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN3_0_1(name, func, ret_type, qual1, type1,     \
                                qual2, type2, qual3, type3, after1)     \
  template <typename Policy1, typename Policy2, typename Policy3>       \
  struct PPL_FUNCTION_CLASS(name) <Policy1, Policy2, Policy3,           \
                                   type1, type2,                        \
                                   PPL_U(type3)> {                      \
    static inline Result function(PPL_U(qual1) PPL_U(type1)& arg1,      \
                                  PPL_U(qual2) PPL_U(type2) &arg2,      \
                                  PPL_U(qual3) PPL_U(type3) &arg3,      \
                                  PPL_U(after1) a1) {                   \
      return PPL_U(func)<Policy1, Policy2, Policy3>(arg1, arg2, arg3,   \
                                                    a1);                \
    }                                                                   \
  };

#define PPL_SPECIALIZE_FUN5_0_1(name, func, ret_type,                   \
                                qual1, type1, qual2, type2,             \
                                qual3, type3,                           \
                                qual4, type4, qual5, type5, after1)     \
  template <typename Policy1, typename Policy2, typename Policy3,       \
            typename Policy4, typename Policy5>                         \
  struct PPL_FUNCTION_CLASS(name) <Policy1, Policy2, Policy3, Policy4,  \
                                   Policy5,                             \
                                   type1, type2,                        \
                                   type3, type4,                        \
                                   PPL_U(type5)> {                      \
    static inline Result                                                \
      function(PPL_U(qual1) PPL_U(type1)& arg1, PPL_U(qual2)            \
               PPL_U(type2) &arg2,                                      \
               PPL_U(qual3) PPL_U(type3) &arg3, PPL_U(qual4)            \
               PPL_U(type4) &arg4,                                      \
               PPL_U(qual5) PPL_U(type5) &arg5, PPL_U(after1) a1) {     \
      return PPL_U(func)<Policy1, Policy2, Policy3, Policy4,            \
        Policy5>(arg1, arg2, arg3, arg4, arg5, a1);                     \
    }                                                                   \
  };

// The `nonconst' macro helps readability of the sequel.
#ifdef nonconst
#define PPL_SAVED_nonconst nonconst
#undef nonconst
#endif
#define nonconst

#define PPL_SPECIALIZE_COPY(func, Type)                                 \
  PPL_SPECIALIZE_FUN2_0_0(copy, func, void, nonconst, Type, const, Type)
#define PPL_SPECIALIZE_SGN(func, From)                                  \
  PPL_SPECIALIZE_FUN1_0_0(sgn, func, Result_Relation, const, From)
#define PPL_SPECIALIZE_CMP(func, Type1, Type2)                          \
  PPL_SPECIALIZE_FUN2_0_0(cmp, func, Result_Relation, const, Type1, const, Type2)
#define PPL_SPECIALIZE_CLASSIFY(func, Type)                             \
  PPL_SPECIALIZE_FUN1_0_3(classify, func, Result, const, Type, bool, bool, bool)
#define PPL_SPECIALIZE_IS_NAN(func, Type)                       \
  PPL_SPECIALIZE_FUN1_0_0(is_nan, func, bool, const, Type)
#define PPL_SPECIALIZE_IS_MINF(func, Type)                      \
  PPL_SPECIALIZE_FUN1_0_0(is_minf, func, bool, const, Type)
#define PPL_SPECIALIZE_IS_PINF(func, Type)                      \
  PPL_SPECIALIZE_FUN1_0_0(is_pinf, func, bool, const, Type)
#define PPL_SPECIALIZE_IS_INT(func, Type)                       \
  PPL_SPECIALIZE_FUN1_0_0(is_int, func, bool, const, Type)
#define PPL_SPECIALIZE_ASSIGN_SPECIAL(func, Type)                       \
  PPL_SPECIALIZE_FUN1_0_2(assign_special, func, Result,                 \
                          nonconst, Type, Result_Class, Rounding_Dir)
#define PPL_SPECIALIZE_CONSTRUCT_SPECIAL(func, Type)                    \
  PPL_SPECIALIZE_FUN1_0_2(construct_special, func, Result, nonconst,    \
                          Type, Result_Class, Rounding_Dir)
#define PPL_SPECIALIZE_CONSTRUCT(func, To, From)                        \
  PPL_SPECIALIZE_FUN2_0_1(construct, func, Result, nonconst, To,        \
                          const, From, Rounding_Dir)
#define PPL_SPECIALIZE_ASSIGN(func, To, From)                   \
  PPL_SPECIALIZE_FUN2_0_1(assign, func, Result, nonconst, To,   \
                          const, From, Rounding_Dir)
#define PPL_SPECIALIZE_FLOOR(func, To, From)                    \
  PPL_SPECIALIZE_FUN2_0_1(floor, func, Result, nonconst, To,    \
                          const, From, Rounding_Dir)
#define PPL_SPECIALIZE_CEIL(func, To, From)                     \
  PPL_SPECIALIZE_FUN2_0_1(ceil, func, Result, nonconst, To,     \
                          const, From, Rounding_Dir)
#define PPL_SPECIALIZE_TRUNC(func, To, From)                    \
  PPL_SPECIALIZE_FUN2_0_1(trunc, func, Result, nonconst, To,    \
                          const, From, Rounding_Dir)
#define PPL_SPECIALIZE_NEG(func, To, From)                      \
  PPL_SPECIALIZE_FUN2_0_1(neg, func, Result, nonconst, To,      \
                          const, From, Rounding_Dir)
#define PPL_SPECIALIZE_ABS(func, To, From)                      \
  PPL_SPECIALIZE_FUN2_0_1(abs, func, Result, nonconst, To,      \
                          const, From, Rounding_Dir)
#define PPL_SPECIALIZE_SQRT(func, To, From)                     \
  PPL_SPECIALIZE_FUN2_0_1(sqrt, func, Result, nonconst, To,     \
                          const, From, Rounding_Dir)
#define PPL_SPECIALIZE_ADD(func, To, From1, From2)                      \
  PPL_SPECIALIZE_FUN3_0_1(add, func, Result, nonconst, To,              \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_SUB(func, To, From1, From2)                      \
  PPL_SPECIALIZE_FUN3_0_1(sub, func, Result, nonconst, To,              \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_MUL(func, To, From1, From2)                      \
  PPL_SPECIALIZE_FUN3_0_1(mul, func, Result, nonconst, To,              \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_DIV(func, To, From1, From2)                      \
  PPL_SPECIALIZE_FUN3_0_1(div, func, Result, nonconst, To,              \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_REM(func, To, From1, From2)                      \
  PPL_SPECIALIZE_FUN3_0_1(rem, func, Result, nonconst, To,              \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_IDIV(func, To, From1, From2)                     \
  PPL_SPECIALIZE_FUN3_0_1(idiv, func, Result, nonconst, To,             \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_ADD_2EXP(func, To, From)                         \
  PPL_SPECIALIZE_FUN2_0_2(add_2exp, func, Result, nonconst, To,         \
                          const, From, unsigned int, Rounding_Dir)
#define PPL_SPECIALIZE_SUB_2EXP(func, To, From)                         \
  PPL_SPECIALIZE_FUN2_0_2(sub_2exp, func, Result, nonconst, To,         \
                          const, From, unsigned int, Rounding_Dir)
#define PPL_SPECIALIZE_MUL_2EXP(func, To, From)                         \
  PPL_SPECIALIZE_FUN2_0_2(mul_2exp, func, Result, nonconst, To,         \
                          const, From, unsigned int, Rounding_Dir)
#define PPL_SPECIALIZE_DIV_2EXP(func, To, From)                         \
  PPL_SPECIALIZE_FUN2_0_2(div_2exp, func, Result, nonconst, To,         \
                          const, From, unsigned int, Rounding_Dir)
#define PPL_SPECIALIZE_SMOD_2EXP(func, To, From)                        \
  PPL_SPECIALIZE_FUN2_0_2(smod_2exp, func, Result, nonconst, To,        \
                          const, From, unsigned int, Rounding_Dir)
#define PPL_SPECIALIZE_UMOD_2EXP(func, To, From)                        \
  PPL_SPECIALIZE_FUN2_0_2(umod_2exp, func, Result, nonconst, To,        \
                          const, From, unsigned int, Rounding_Dir)
#define PPL_SPECIALIZE_ADD_MUL(func, To, From1, From2)                  \
  PPL_SPECIALIZE_FUN3_0_1(add_mul, func, Result, nonconst, To,          \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_SUB_MUL(func, To, From1, From2)                  \
  PPL_SPECIALIZE_FUN3_0_1(sub_mul, func, Result, nonconst, To,          \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_GCD(func, To, From1, From2)                      \
  PPL_SPECIALIZE_FUN3_0_1(gcd, func, Result, nonconst, To,              \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_GCDEXT(func, To1, From1, From2, To2, To3)        \
  PPL_SPECIALIZE_FUN5_0_1(gcdext, func, Result, nonconst, To1,          \
                          nonconst, To2, nonconst, To3,                 \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_LCM(func, To, From1, From2)                      \
  PPL_SPECIALIZE_FUN3_0_1(lcm, func, Result, nonconst, To,              \
                          const, From1, const, From2, Rounding_Dir)
#define PPL_SPECIALIZE_INPUT(func, Type)                        \
  PPL_SPECIALIZE_FUN1_0_2(input, func, Result, nonconst, Type,  \
                          std::istream&, Rounding_Dir)
#define PPL_SPECIALIZE_OUTPUT(func, Type)                       \
  PPL_SPECIALIZE_FUN1_1_2(output, func, Result, std::ostream&,  \
                          const, Type,                          \
                          const Numeric_Format&, Rounding_Dir)


PPL_DECLARE_FUN2_0_0(copy,
                     void, nonconst, Type1, const, Type2)
PPL_DECLARE_FUN1_0_0(sgn,
                     Result_Relation, const, From)
PPL_DECLARE_FUN2_0_0(cmp,
                     Result_Relation, const, Type1, const, Type2)
PPL_DECLARE_FUN1_0_3(classify,
                     Result, const, Type, bool, bool, bool)
PPL_DECLARE_FUN1_0_0(is_nan,
                     bool, const, Type)
PPL_DECLARE_FUN1_0_0(is_minf,
                     bool, const, Type)
PPL_DECLARE_FUN1_0_0(is_pinf,
                     bool, const, Type)
PPL_DECLARE_FUN1_0_0(is_int,
                     bool, const, Type)
PPL_DECLARE_FUN1_0_2(assign_special,
                     Result, nonconst, Type, Result_Class, Rounding_Dir)
PPL_DECLARE_FUN1_0_2(construct_special,
                     Result, nonconst, Type, Result_Class, Rounding_Dir)
PPL_DECLARE_FUN2_0_1(construct,
                     Result, nonconst, To, const, From, Rounding_Dir)
PPL_DECLARE_FUN2_0_1(assign,
                     Result, nonconst, To, const, From, Rounding_Dir)
PPL_DECLARE_FUN2_0_1(floor,
                     Result, nonconst, To, const, From, Rounding_Dir)
PPL_DECLARE_FUN2_0_1(ceil,
                     Result, nonconst, To, const, From, Rounding_Dir)
PPL_DECLARE_FUN2_0_1(trunc,
                     Result, nonconst, To, const, From, Rounding_Dir)
PPL_DECLARE_FUN2_0_1(neg,
                     Result, nonconst, To, const, From, Rounding_Dir)
PPL_DECLARE_FUN2_0_1(abs,
                     Result, nonconst, To, const, From, Rounding_Dir)
PPL_DECLARE_FUN2_0_1(sqrt,
                     Result, nonconst, To, const, From, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(add,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(sub,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(mul,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(div,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(rem,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(idiv,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN2_0_2(add_2exp,
                     Result, nonconst, To,
                     const, From, unsigned int, Rounding_Dir)
PPL_DECLARE_FUN2_0_2(sub_2exp,
                     Result, nonconst, To,
                     const, From, unsigned int, Rounding_Dir)
PPL_DECLARE_FUN2_0_2(mul_2exp,
                     Result, nonconst, To,
                     const, From, unsigned int, Rounding_Dir)
PPL_DECLARE_FUN2_0_2(div_2exp,
                     Result, nonconst, To,
                     const, From, unsigned int, Rounding_Dir)
PPL_DECLARE_FUN2_0_2(smod_2exp,
                     Result, nonconst, To,
                     const, From, unsigned int, Rounding_Dir)
PPL_DECLARE_FUN2_0_2(umod_2exp,
                     Result, nonconst, To,
                     const, From, unsigned int, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(add_mul,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(sub_mul,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(gcd,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN5_0_1(gcdext,
                     Result, nonconst, To1, nonconst, To2, nonconst, To3,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN3_0_1(lcm,
                     Result, nonconst, To,
                     const, From1, const, From2, Rounding_Dir)
PPL_DECLARE_FUN1_0_2(input,
                     Result, nonconst, Type, std::istream&, Rounding_Dir)
PPL_DECLARE_FUN1_1_2(output,
                     Result, std::ostream&, const, Type,
                     const Numeric_Format&, Rounding_Dir)

#undef PPL_DECLARE_FUN1_0_0
#undef PPL_DECLARE_FUN1_0_1
#undef PPL_DECLARE_FUN1_0_2
#undef PPL_DECLARE_FUN1_0_3
#undef PPL_DECLARE_FUN1_1_1
#undef PPL_DECLARE_FUN1_1_2
#undef PPL_DECLARE_FUN1_2_2
#undef PPL_DECLARE_FUN2_0_0
#undef PPL_DECLARE_FUN2_0_1
#undef PPL_DECLARE_FUN2_0_2
#undef PPL_DECLARE_FUN3_0_1
#undef PPL_DECLARE_FUN5_0_1

template <typename Policy, typename To>
Result round(To& to, Result r, Rounding_Dir dir);

Result input_mpq(mpq_class& to, std::istream& is);

std::string float_mpq_to_string(mpq_class& q);

} // namespace Checked

struct Minus_Infinity {
  static const Result_Class vclass = VC_MINUS_INFINITY;
};
struct Plus_Infinity {
  static const Result_Class vclass = VC_PLUS_INFINITY;
};
struct Not_A_Number {
  static const Result_Class vclass = VC_NAN;
};

template <typename T>
struct Is_Special : public False { };

template <>
struct Is_Special<Minus_Infinity> : public True {};

template <>
struct Is_Special<Plus_Infinity> : public True {};

template <>
struct Is_Special<Not_A_Number> : public True {};

extern Minus_Infinity MINUS_INFINITY;
extern Plus_Infinity PLUS_INFINITY;
extern Not_A_Number NOT_A_NUMBER;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Checked_Number_Transparent_Policy {
  //! Do not check for overflowed result.
  const_bool_nodef(check_overflow, false);

  //! Do not check for attempts to add infinities with different sign.
  const_bool_nodef(check_inf_add_inf, false);

  //! Do not check for attempts to subtract infinities with same sign.
  const_bool_nodef(check_inf_sub_inf, false);

  //! Do not check for attempts to multiply infinities by zero.
  const_bool_nodef(check_inf_mul_zero, false);

  //! Do not check for attempts to divide by zero.
  const_bool_nodef(check_div_zero, false);

  //! Do not check for attempts to divide infinities.
  const_bool_nodef(check_inf_div_inf, false);

  //! Do not check for attempts to compute remainder of infinities.
  const_bool_nodef(check_inf_mod, false);

  //! Do not check for attempts to take the square root of a negative number.
  const_bool_nodef(check_sqrt_neg, false);

  //! Handle not-a-number special value if \p T has it.
  const_bool_nodef(has_nan, std::numeric_limits<T>::has_quiet_NaN);

  //! Handle infinity special values if \p T have them.
  const_bool_nodef(has_infinity, std::numeric_limits<T>::has_infinity);

  /*! \brief
    The checked number can always be safely converted to the
    underlying type \p T and vice-versa.
  */
  const_bool_nodef(convertible, true);

  //! Do not honor requests to check for FPU inexact results.
  const_bool_nodef(fpu_check_inexact, false);

  //! Do not make extra checks to detect FPU NaN results.
  const_bool_nodef(fpu_check_nan_result, false);

  /*! \brief
    For constructors, by default use the same rounding used by
    underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_CONSTRUCTOR = ROUND_NATIVE;

  /*! \brief
    For overloaded operators (operator+(), operator-(), ...), by
    default use the same rounding used by the underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_OPERATOR = ROUND_NATIVE;

  /*! \brief
    For input functions, by default use the same rounding used by
    the underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_INPUT = ROUND_NATIVE;

  /*! \brief
    For output functions, by default use the same rounding used by
    the underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_OUTPUT = ROUND_NATIVE;

  /*! \brief
    For all other functions, by default use the same rounding used by
    the underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_FUNCTION = ROUND_NATIVE;

  /*! \brief
    Handles \p r: called by all constructors, operators and functions that
    do not return a Result value.
  */
  static void handle_result(Result r);
};

} // namespace Parma_Polyhedra_Library

#define CHECK_P(cond, check) ((cond) ? (check) : (assert(!(check)), false))

/* Automatically generated from PPL source file ../src/checked_inlines.hh line 1. */
/* Abstract checked arithmetic functions: fall-backs.
*/


/* Automatically generated from PPL source file ../src/checked_inlines.hh line 31. */

/*! \brief
  Performs the test <CODE>a < b</CODE> avoiding the warning about the
  comparison being always false due to limited range of data type.
  FIXME: we have not found a working solution. The GCC option
  -Wno-type-limits suppresses the warning
*/
#define PPL_LT_SILENT(a, b) ((a) < (b))
#define PPL_GT_SILENT(a, b) ((a) > (b))

namespace Parma_Polyhedra_Library {

namespace Checked {

template <typename T1, typename T2>
struct Safe_Conversion : public False {
};
template <typename T>
struct Safe_Conversion<T, T> : public True {
};

#define PPL_SAFE_CONVERSION(To, From)                        \
  template <> struct Safe_Conversion<PPL_U(To), PPL_U(From)> \
    : public True { }

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(signed short, char);
#endif
PPL_SAFE_CONVERSION(signed short, signed char);
#if PPL_SIZEOF_CHAR < PPL_SIZEOF_SHORT
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(signed short, char);
#endif
PPL_SAFE_CONVERSION(signed short, unsigned char);
#endif

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(signed int, char);
#endif
PPL_SAFE_CONVERSION(signed int, signed char);
PPL_SAFE_CONVERSION(signed int, signed short);
#if PPL_SIZEOF_CHAR < PPL_SIZEOF_INT
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(signed int, char);
#endif
PPL_SAFE_CONVERSION(signed int, unsigned char);
#endif
#if PPL_SIZEOF_SHORT < PPL_SIZEOF_INT
PPL_SAFE_CONVERSION(signed int, unsigned short);
#endif

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(signed long, char);
#endif
PPL_SAFE_CONVERSION(signed long, signed char);
PPL_SAFE_CONVERSION(signed long, signed short);
PPL_SAFE_CONVERSION(signed long, signed int);
#if PPL_SIZEOF_CHAR < PPL_SIZEOF_LONG
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(signed long, char);
#endif
PPL_SAFE_CONVERSION(signed long, unsigned char);
#endif
#if PPL_SIZEOF_SHORT < PPL_SIZEOF_LONG
PPL_SAFE_CONVERSION(signed long, unsigned short);
#endif
#if PPL_SIZEOF_INT < PPL_SIZEOF_LONG
PPL_SAFE_CONVERSION(signed long, unsigned int);
#endif

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(signed long long, char);
#endif
PPL_SAFE_CONVERSION(signed long long, signed char);
PPL_SAFE_CONVERSION(signed long long, signed short);
PPL_SAFE_CONVERSION(signed long long, signed int);
PPL_SAFE_CONVERSION(signed long long, signed long);
#if PPL_SIZEOF_CHAR < PPL_SIZEOF_LONG_LONG
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(signed long long, char);
#endif
PPL_SAFE_CONVERSION(signed long long, unsigned char);
#endif
#if PPL_SIZEOF_SHORT < PPL_SIZEOF_LONG_LONG
PPL_SAFE_CONVERSION(signed long long, unsigned short);
#endif
#if PPL_SIZEOF_INT < PPL_SIZEOF_LONG_LONG
PPL_SAFE_CONVERSION(signed long long, unsigned int);
#endif
#if PPL_SIZEOF_LONG < PPL_SIZEOF_LONG_LONG
PPL_SAFE_CONVERSION(signed long long, unsigned long);
#endif

#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(unsigned short, char);
#endif
PPL_SAFE_CONVERSION(unsigned short, unsigned char);

#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(unsigned int, char);
#endif
PPL_SAFE_CONVERSION(unsigned int, unsigned char);
PPL_SAFE_CONVERSION(unsigned int, unsigned short);

#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(unsigned long, char);
#endif
PPL_SAFE_CONVERSION(unsigned long, unsigned char);
PPL_SAFE_CONVERSION(unsigned long, unsigned short);
PPL_SAFE_CONVERSION(unsigned long, unsigned int);

#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SAFE_CONVERSION(unsigned long long, char);
#endif
PPL_SAFE_CONVERSION(unsigned long long, unsigned char);
PPL_SAFE_CONVERSION(unsigned long long, unsigned short);
PPL_SAFE_CONVERSION(unsigned long long, unsigned int);
PPL_SAFE_CONVERSION(unsigned long long, unsigned long);


#if PPL_SIZEOF_CHAR <= PPL_SIZEOF_FLOAT - 2
PPL_SAFE_CONVERSION(float, char);
PPL_SAFE_CONVERSION(float, signed char);
PPL_SAFE_CONVERSION(float, unsigned char);
#endif
#if PPL_SIZEOF_SHORT <= PPL_SIZEOF_FLOAT - 2
PPL_SAFE_CONVERSION(float, signed short);
PPL_SAFE_CONVERSION(float, unsigned short);
#endif
#if PPL_SIZEOF_INT <= PPL_SIZEOF_FLOAT - 2
PPL_SAFE_CONVERSION(float, signed int);
PPL_SAFE_CONVERSION(float, unsigned int);
#endif
#if PPL_SIZEOF_LONG <= PPL_SIZEOF_FLOAT - 2
PPL_SAFE_CONVERSION(float, signed long);
PPL_SAFE_CONVERSION(float, unsigned long);
#endif
#if PPL_SIZEOF_LONG_LONG <= PPL_SIZEOF_FLOAT - 2
PPL_SAFE_CONVERSION(float, signed long long);
PPL_SAFE_CONVERSION(float, unsigned long long);
#endif

#if PPL_SIZEOF_CHAR <= PPL_SIZEOF_DOUBLE - 4
PPL_SAFE_CONVERSION(double, char);
PPL_SAFE_CONVERSION(double, signed char);
PPL_SAFE_CONVERSION(double, unsigned char);
#endif
#if PPL_SIZEOF_SHORT <= PPL_SIZEOF_DOUBLE - 4
PPL_SAFE_CONVERSION(double, signed short);
PPL_SAFE_CONVERSION(double, unsigned short);
#endif
#if PPL_SIZEOF_INT <= PPL_SIZEOF_DOUBLE - 4
PPL_SAFE_CONVERSION(double, signed int);
PPL_SAFE_CONVERSION(double, unsigned int);
#endif
#if PPL_SIZEOF_LONG <= PPL_SIZEOF_DOUBLE - 4
PPL_SAFE_CONVERSION(double, signed long);
PPL_SAFE_CONVERSION(double, unsigned long);
#endif
#if PPL_SIZEOF_LONG_LONG <= PPL_SIZEOF_DOUBLE - 4
PPL_SAFE_CONVERSION(double, signed long long);
PPL_SAFE_CONVERSION(double, unsigned long long);
#endif
PPL_SAFE_CONVERSION(double, float);

#if PPL_SIZEOF_CHAR <= PPL_SIZEOF_LONG_DOUBLE - 4
PPL_SAFE_CONVERSION(long double, char);
PPL_SAFE_CONVERSION(long double, signed char);
PPL_SAFE_CONVERSION(long double, unsigned char);
#endif
#if PPL_SIZEOF_SHORT <= PPL_SIZEOF_LONG_DOUBLE - 4
PPL_SAFE_CONVERSION(long double, signed short);
PPL_SAFE_CONVERSION(long double, unsigned short);
#endif
#if PPL_SIZEOF_INT <= PPL_SIZEOF_LONG_DOUBLE - 4
PPL_SAFE_CONVERSION(long double, signed int);
PPL_SAFE_CONVERSION(long double, unsigned int);
#endif
#if PPL_SIZEOF_LONG <= PPL_SIZEOF_LONG_DOUBLE - 4
PPL_SAFE_CONVERSION(long double, signed long);
PPL_SAFE_CONVERSION(long double, unsigned long);
#endif
#if PPL_SIZEOF_LONG_LONG <= PPL_SIZEOF_LONG_DOUBLE - 4
PPL_SAFE_CONVERSION(long double, signed long long);
PPL_SAFE_CONVERSION(long double, unsigned long long);
#endif
PPL_SAFE_CONVERSION(long double, float);
PPL_SAFE_CONVERSION(long double, double);

PPL_SAFE_CONVERSION(mpz_class, char);
PPL_SAFE_CONVERSION(mpz_class, signed char);
PPL_SAFE_CONVERSION(mpz_class, signed short);
PPL_SAFE_CONVERSION(mpz_class, signed int);
PPL_SAFE_CONVERSION(mpz_class, signed long);
// GMP's API does not support signed long long.
PPL_SAFE_CONVERSION(mpz_class, unsigned char);
PPL_SAFE_CONVERSION(mpz_class, unsigned short);
PPL_SAFE_CONVERSION(mpz_class, unsigned int);
PPL_SAFE_CONVERSION(mpz_class, unsigned long);
// GMP's API does not support unsigned long long.

PPL_SAFE_CONVERSION(mpq_class, char);
PPL_SAFE_CONVERSION(mpq_class, signed char);
PPL_SAFE_CONVERSION(mpq_class, signed short);
PPL_SAFE_CONVERSION(mpq_class, signed int);
PPL_SAFE_CONVERSION(mpq_class, signed long);
// GMP's API does not support signed long long.
PPL_SAFE_CONVERSION(mpq_class, unsigned char);
PPL_SAFE_CONVERSION(mpq_class, unsigned short);
PPL_SAFE_CONVERSION(mpq_class, unsigned int);
PPL_SAFE_CONVERSION(mpq_class, unsigned long);
// GMP's API does not support unsigned long long.
PPL_SAFE_CONVERSION(mpq_class, float);
PPL_SAFE_CONVERSION(mpq_class, double);
// GMP's API does not support long double.

#undef PPL_SAFE_CONVERSION

template <typename Policy, typename Type>
struct PPL_FUNCTION_CLASS(construct)<Policy, Policy, Type, Type> {
  static inline Result function(Type& to, const Type& from, Rounding_Dir) {
    new(&to) Type(from);
    return V_EQ;
  }
};

template <typename To_Policy, typename From_Policy, typename To, typename From>
struct PPL_FUNCTION_CLASS(construct) {
  static inline Result function(To& to, const From& from, Rounding_Dir dir) {
    new(&to) To();
    return assign<To_Policy, From_Policy>(to, from, dir);
  }
};

template <typename To_Policy, typename To>
struct PPL_FUNCTION_CLASS(construct_special) {
  static inline Result function(To& to, Result_Class r, Rounding_Dir dir) {
    new(&to) To();
    return assign_special<To_Policy>(to, r, dir);
  }
};

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_exact(To& to, const From& from, Rounding_Dir) {
  to = from;
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline typename Enable_If<Is_Same<To_Policy, From_Policy>::value, void>::type
copy_generic(Type& to, const Type& from) {
  to = from;
}

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
abs_generic(To& to, const From& from, Rounding_Dir dir) {
  if (from < 0) {
    return neg<To_Policy, From_Policy>(to, from, dir);
  }
  else {
    return assign<To_Policy, From_Policy>(to, from, dir);
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From>
inline void
gcd_exact_no_abs(To& to, const From& x, const From& y) {
  To w_x = x;
  To w_y = y;
  To remainder;
  while (w_y != 0) {
    // The following is derived from the assumption that w_x % w_y
    // is always representable. This is true for both native integers
    // and IEC 559 floating point numbers.
    rem<To_Policy, From1_Policy, From2_Policy>(remainder, w_x, w_y,
                                               ROUND_NOT_NEEDED);
    w_x = w_y;
    w_y = remainder;
  }
  to = w_x;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
gcd_exact(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  gcd_exact_no_abs<To_Policy, From1_Policy, From2_Policy>(to, x, y);
  return abs<To_Policy, To_Policy>(to, to, dir);
}

template <typename To1_Policy, typename To2_Policy, typename To3_Policy,
          typename From1_Policy, typename From2_Policy,
          typename To1, typename To2, typename To3,
          typename From1, typename From2>
inline Result
gcdext_exact(To1& to, To2& s, To3& t, const From1& x, const From2& y,
             Rounding_Dir dir) {
  // In case this becomes a bottleneck, we may consider using the
  // Stehle'-Zimmermann algorithm (see R. Crandall and C. Pomerance,
  // Prime Numbers - A Computational Perspective, Second Edition,
  // Springer, 2005).
  if (y == 0) {
    if (x == 0) {
      s = 0;
      t = 1;
      return V_EQ;
    }
    else {
      if (x < 0) {
        s = -1;
      }
      else {
        s = 1;
      }
      t = 0;
      return abs<To1_Policy, From1_Policy>(to, x, dir);
    }
  }

  s = 1;
  t = 0;
  bool negative_x = x < 0;
  bool negative_y = y < 0;

  Result r;
  r = abs<To1_Policy, From1_Policy>(to, x, dir);
  if (r != V_EQ) {
    return r;
  }

  From2 a_y;
  r = abs<To1_Policy, From2_Policy>(a_y, y, dir);
  if (r != V_EQ) {
    return r;
  }

  // If PPL_MATCH_GMP_GCDEXT is defined then s is favored when the absolute
  // values of the given numbers are equal.  For instance if x and y
  // are both 5 then s will be 1 and t will be 0, instead of the other
  // way round.  This is to match the behavior of GMP.
#define PPL_MATCH_GMP_GCDEXT 1
#ifdef PPL_MATCH_GMP_GCDEXT
  if (to == a_y) {
    goto sign_check;
  }
#endif

  {
    To2 v1 = 0;
    To3 v2 = 1;
    To1 v3 = static_cast<To1>(a_y);
    while (true) {
      To1 q = to / v3;
      // Remainder, next candidate GCD.
      To1 t3 = to - q*v3;
      To2 t1 = s - static_cast<To2>(q)*v1;
      To3 t2 = t - static_cast<To3>(q)*v2;
      s = v1;
      t = v2;
      to = v3;
      if (t3 == 0) {
        break;
      }
      v1 = t1;
      v2 = t2;
      v3 = t3;
    }
  }

#ifdef PPL_MATCH_GMP_GCDEXT
 sign_check:
#endif
  if (negative_x) {
    r = neg<To2_Policy, To2_Policy>(s, s, dir);
    if (r != V_EQ) {
      return r;
    }
  }
  if (negative_y) {
    return neg<To3_Policy, To3_Policy>(t, t, dir);
  }
  return V_EQ;
#undef PPL_MATCH_GMP_GCDEXT
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
lcm_gcd_exact(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (x == 0 || y == 0) {
    to = 0;
    return V_EQ;
  }
  To a_x;
  To a_y;
  Result r;
  r = abs<From1_Policy, From1_Policy>(a_x, x, dir);
  if (r != V_EQ) {
    return r;
  }
  r = abs<From2_Policy, From2_Policy>(a_y, y, dir);
  if (r != V_EQ) {
    return r;
  }
  To gcd;
  gcd_exact_no_abs<To_Policy, From1_Policy, From2_Policy>(gcd, a_x, a_y);
  // The following is derived from the assumption that a_x / gcd(a_x, a_y)
  // is always representable. This is true for both native integers
  // and IEC 559 floating point numbers.
  div<To_Policy, From1_Policy, To_Policy>(to, a_x, gcd, ROUND_NOT_NEEDED);
  return mul<To_Policy, To_Policy, From2_Policy>(to, to, a_y, dir);
}

template <typename Policy, typename Type>
inline Result_Relation
sgn_generic(const Type& x) {
  if (x > 0) {
    return VR_GT;
  }
  if (x == 0) {
    return VR_EQ;
  }
  return VR_LT;
}

template <typename T1, typename T2, typename Enable = void>
struct Safe_Int_Comparison : public False {
};

template <typename T1, typename T2>
struct Safe_Int_Comparison<T1, T2, typename Enable_If<(C_Integer<T1>::value && C_Integer<T2>::value)>::type>
  : public Bool<(C_Integer<T1>::is_signed
                 ? (C_Integer<T2>::is_signed
                    || sizeof(T2) < sizeof(T1)
                    || sizeof(T2) < sizeof(int))
                 : (!C_Integer<T2>::is_signed
                    || sizeof(T1) < sizeof(T2)
                    || sizeof(T1) < sizeof(int)))> {
};


template <typename T1, typename T2>
inline typename Enable_If<(Safe_Int_Comparison<T1, T2>::value
                           || Safe_Conversion<T1, T2>::value
                           || Safe_Conversion<T2, T1>::value), bool>::type
lt(const T1& x, const T2& y) {
  return x < y;
}
template <typename T1, typename T2>
inline typename Enable_If<(Safe_Int_Comparison<T1, T2>::value
                           || Safe_Conversion<T1, T2>::value
                           || Safe_Conversion<T2, T1>::value), bool>::type
le(const T1& x, const T2& y) {
  return x <= y;
}
template <typename T1, typename T2>
inline typename Enable_If<(Safe_Int_Comparison<T1, T2>::value
                           || Safe_Conversion<T1, T2>::value
                           || Safe_Conversion<T2, T1>::value), bool>::type
eq(const T1& x, const T2& y) {
  return x == y;
}

template <typename S, typename U>
inline typename Enable_If<(!Safe_Int_Comparison<S, U>::value
                           && C_Integer<U>::value
                           && C_Integer<S>::is_signed), bool>::type
lt(const S& x, const U& y) {
  return x < 0 || static_cast<typename C_Integer<S>::other_type>(x) < y;
}

template <typename U, typename S>
inline typename Enable_If<(!Safe_Int_Comparison<S, U>::value
                           && C_Integer<U>::value
                           && C_Integer<S>::is_signed), bool>::type
lt(const U& x, const S& y) {
  return y >= 0 && x < static_cast<typename C_Integer<S>::other_type>(y);
}

template <typename S, typename U>
inline typename Enable_If<(!Safe_Int_Comparison<S, U>::value
                           && C_Integer<U>::value
                           && C_Integer<S>::is_signed), bool>::type
le(const S& x, const U& y) {
  return x < 0 || static_cast<typename C_Integer<S>::other_type>(x) <= y;
}

template <typename U, typename S>
inline typename Enable_If<(!Safe_Int_Comparison<S, U>::value
                           && C_Integer<U>::value
                           && C_Integer<S>::is_signed), bool>::type
le(const U& x, const S& y) {
  return y >= 0 && x <= static_cast<typename C_Integer<S>::other_type>(y);
}

template <typename S, typename U>
inline typename Enable_If<(!Safe_Int_Comparison<S, U>::value
                           && C_Integer<U>::value
                           && C_Integer<S>::is_signed), bool>::type
eq(const S& x, const U& y) {
  return x >= 0 && static_cast<typename C_Integer<S>::other_type>(x) == y;
}

template <typename U, typename S>
inline typename Enable_If<(!Safe_Int_Comparison<S, U>::value
                           && C_Integer<U>::value
                           && C_Integer<S>::is_signed), bool>::type
eq(const U& x, const S& y) {
  return y >= 0 && x == static_cast<typename C_Integer<S>::other_type>(y);
}

template <typename T1, typename T2>
inline typename Enable_If<(!Safe_Conversion<T1, T2>::value
                           && !Safe_Conversion<T2, T1>::value
                           && (!C_Integer<T1>::value || !C_Integer<T2>::value)), bool>::type
eq(const T1& x, const T2& y) {
  PPL_DIRTY_TEMP(T1, tmp);
  Result r = assign_r(tmp, y, ROUND_CHECK);
  // FIXME: We can do this also without fpu inexact check using a
  // conversion back and forth and then testing equality.  We should
  // code this in checked_float_inlines.hh, probably it's faster also
  // if fpu supports inexact check.
  PPL_ASSERT(r != V_LE && r != V_GE && r != V_LGE);
  return r == V_EQ && x == tmp;
}

template <typename T1, typename T2>
inline typename Enable_If<(!Safe_Conversion<T1, T2>::value
                           && !Safe_Conversion<T2, T1>::value
                           && (!C_Integer<T1>::value || !C_Integer<T2>::value)), bool>::type
lt(const T1& x, const T2& y) {
  PPL_DIRTY_TEMP(T1, tmp);
  Result r = assign_r(tmp, y, ROUND_UP);
  if (!result_representable(r)) {
    return true;
  }
  switch (result_relation(r)) {
  case VR_EQ:
  case VR_LT:
  case VR_LE:
    return x < tmp;
  default:
    return false;
  }
}

template <typename T1, typename T2>
inline typename
Enable_If<(!Safe_Conversion<T1, T2>::value
           && !Safe_Conversion<T2, T1>::value
           && (!C_Integer<T1>::value || !C_Integer<T2>::value)), bool>::type
le(const T1& x, const T2& y) {
  PPL_DIRTY_TEMP(T1, tmp);
  Result r = assign_r(tmp, y, (ROUND_UP | ROUND_STRICT_RELATION));
  // FIXME: We can do this also without fpu inexact check using a
  // conversion back and forth and then testing equality.  We should
  // code this in checked_float_inlines.hh, probably it's faster also
  // if fpu supports inexact check.
  PPL_ASSERT(r != V_LE && r != V_GE && r != V_LGE);
  if (!result_representable(r)) {
    return true;
  }
  switch (result_relation(r)) {
  case VR_EQ:
    return x <= tmp;
  case VR_LT:
    return x < tmp;
  case VR_LE:
  case VR_GE:
  case VR_LGE:
    // See comment above.
    PPL_UNREACHABLE;
    return false;
  default:
    return false;
  }
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline bool
lt_p(const Type1& x, const Type2& y) {
  return lt(x, y);
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline bool
le_p(const Type1& x, const Type2& y) {
  return le(x, y);
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline bool
eq_p(const Type1& x, const Type2& y) {
  return eq(x, y);
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline Result_Relation
cmp_generic(const Type1& x, const Type2& y) {
  if (lt(y, x)) {
    return VR_GT;
  }
  if (lt(x, y)) {
    return VR_LT;
  }
  return VR_EQ;
}

template <typename Policy, typename Type>
inline Result
assign_nan(Type& to, Result r) {
  assign_special<Policy>(to, VC_NAN, ROUND_IGNORE);
  return r;
}

template <typename Policy, typename Type>
inline Result
input_generic(Type& to, std::istream& is, Rounding_Dir dir) {
  PPL_DIRTY_TEMP(mpq_class, q);
  Result r = input_mpq(q, is);
  Result_Class c = result_class(r);
  switch (c) {
  case VC_MINUS_INFINITY:
  case VC_PLUS_INFINITY:
    return assign_special<Policy>(to, c, dir);
  case VC_NAN:
    return assign_nan<Policy>(to, r);
  default:
    break;
  }
  PPL_ASSERT(r == V_EQ);
  return assign<Policy, void>(to, q, dir);
}

} // namespace Checked

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/checked_int_inlines.hh line 1. */
/* Specialized "checked" functions for native integer numbers.
*/


/* Automatically generated from PPL source file ../src/checked_int_inlines.hh line 28. */
#include <cerrno>
#include <cstdlib>
#include <climits>
#include <string>

#if !PPL_HAVE_DECL_STRTOLL
signed long long
strtoll(const char* nptr, char** endptr, int base);
#endif

#if !PPL_HAVE_DECL_STRTOULL
unsigned long long
strtoull(const char* nptr, char** endptr, int base);
#endif

namespace Parma_Polyhedra_Library {

namespace Checked {

#ifndef PPL_HAVE_INT_FAST16_T
typedef int16_t int_fast16_t;
#endif

#ifndef PPL_HAVE_INT_FAST32_T
typedef int32_t int_fast32_t;
#endif

#ifndef PPL_HAVE_INT_FAST64_T
typedef int64_t int_fast64_t;
#endif

#ifndef PPL_HAVE_UINT_FAST16_T
typedef uint16_t uint_fast16_t;
#endif

#ifndef PPL_HAVE_UINT_FAST32_T
typedef uint32_t uint_fast32_t;
#endif

#ifndef PPL_HAVE_UINT_FAST64_T
typedef uint64_t uint_fast64_t;
#endif

template <typename Policy, typename Type>
struct Extended_Int {
  static const Type plus_infinity = C_Integer<Type>::max;
  static const Type minus_infinity = ((C_Integer<Type>::min >= 0)
                                      ? (C_Integer<Type>::max - 1)
                                      : C_Integer<Type>::min);
  static const Type not_a_number
  = ((C_Integer<Type>::min >= 0)
     ? (C_Integer<Type>::max - 2 * (Policy::has_infinity ? 1 : 0))
     : (C_Integer<Type>::min + (Policy::has_infinity ? 1 : 0)));
  static const Type min
  = (C_Integer<Type>::min
     + ((C_Integer<Type>::min >= 0)
        ? 0
        : ((Policy::has_infinity ? 1 : 0) + (Policy::has_nan ? 1 : 0))));
  static const Type max
  = (C_Integer<Type>::max
     - ((C_Integer<Type>::min >= 0)
        ? (2 * (Policy::has_infinity ? 1 : 0) + (Policy::has_nan ? 1 : 0))
        : (Policy::has_infinity ? 1 : 0)));
};

template <typename Policy, typename To>
inline Result
set_neg_overflow_int(To& to, Rounding_Dir dir) {
  if (round_up(dir)) {
    to = Extended_Int<Policy, To>::min;
    return V_LT_INF;
  }
  else {
    if (Policy::has_infinity) {
      to = Extended_Int<Policy, To>::minus_infinity;
      return V_GT_MINUS_INFINITY;
    }
    return V_GT_MINUS_INFINITY | V_UNREPRESENTABLE;
  }
}

template <typename Policy, typename To>
inline Result
set_pos_overflow_int(To& to, Rounding_Dir dir) {
  if (round_down(dir)) {
    to = Extended_Int<Policy, To>::max;
    return V_GT_SUP;
  }
  else {
    if (Policy::has_infinity) {
      to = Extended_Int<Policy, To>::plus_infinity;
      return V_LT_PLUS_INFINITY;
    }
    return V_LT_PLUS_INFINITY | V_UNREPRESENTABLE;
  }
}

template <typename Policy, typename To>
inline Result
round_lt_int_no_overflow(To& to, Rounding_Dir dir) {
  if (round_down(dir)) {
    --to;
    return V_GT;
  }
  return V_LT;
}

template <typename Policy, typename To>
inline Result
round_gt_int_no_overflow(To& to, Rounding_Dir dir) {
  if (round_up(dir)) {
    ++to;
    return V_LT;
  }
  return V_GT;
}

template <typename Policy, typename To>
inline Result
round_lt_int(To& to, Rounding_Dir dir) {
  if (round_down(dir)) {
    if (to == Extended_Int<Policy, To>::min) {
      if (Policy::has_infinity) {
        to = Extended_Int<Policy, To>::minus_infinity;
        return V_GT_MINUS_INFINITY;
      }
      return V_GT_MINUS_INFINITY | V_UNREPRESENTABLE;
    }
    else {
      --to;
      return V_GT;
    }
  }
  return V_LT;
}

template <typename Policy, typename To>
inline Result
round_gt_int(To& to, Rounding_Dir dir) {
  if (round_up(dir)) {
    if (to == Extended_Int<Policy, To>::max) {
      if (Policy::has_infinity) {
        to = Extended_Int<Policy, To>::plus_infinity;
        return V_LT_PLUS_INFINITY;
      }
      return V_LT_PLUS_INFINITY | V_UNREPRESENTABLE;
    }
    else {
      ++to;
      return V_LT;
    }
  }
  return V_GT;
}

PPL_SPECIALIZE_COPY(copy_generic, char)
PPL_SPECIALIZE_COPY(copy_generic, signed char)
PPL_SPECIALIZE_COPY(copy_generic, signed short)
PPL_SPECIALIZE_COPY(copy_generic, signed int)
PPL_SPECIALIZE_COPY(copy_generic, signed long)
PPL_SPECIALIZE_COPY(copy_generic, signed long long)
PPL_SPECIALIZE_COPY(copy_generic, unsigned char)
PPL_SPECIALIZE_COPY(copy_generic, unsigned short)
PPL_SPECIALIZE_COPY(copy_generic, unsigned int)
PPL_SPECIALIZE_COPY(copy_generic, unsigned long)
PPL_SPECIALIZE_COPY(copy_generic, unsigned long long)

template <typename Policy, typename Type>
inline Result
classify_int(const Type v, bool nan, bool inf, bool sign) {
  if (Policy::has_nan
      && (nan || sign)
      && v == Extended_Int<Policy, Type>::not_a_number) {
    return V_NAN;
  }
  if (!inf && !sign) {
    return V_LGE;
  }
  if (Policy::has_infinity) {
    if (v == Extended_Int<Policy, Type>::minus_infinity) {
      return inf ? V_EQ_MINUS_INFINITY : V_LT;
    }
    if (v == Extended_Int<Policy, Type>::plus_infinity) {
      return inf ? V_EQ_PLUS_INFINITY : V_GT;
    }
  }
  if (sign) {
    if (v < 0) {
      return V_LT;
    }
    if (v > 0) {
      return V_GT;
    }
    return V_EQ;
  }
  return V_LGE;
}

PPL_SPECIALIZE_CLASSIFY(classify_int, char)
PPL_SPECIALIZE_CLASSIFY(classify_int, signed char)
PPL_SPECIALIZE_CLASSIFY(classify_int, signed short)
PPL_SPECIALIZE_CLASSIFY(classify_int, signed int)
PPL_SPECIALIZE_CLASSIFY(classify_int, signed long)
PPL_SPECIALIZE_CLASSIFY(classify_int, signed long long)
PPL_SPECIALIZE_CLASSIFY(classify_int, unsigned char)
PPL_SPECIALIZE_CLASSIFY(classify_int, unsigned short)
PPL_SPECIALIZE_CLASSIFY(classify_int, unsigned int)
PPL_SPECIALIZE_CLASSIFY(classify_int, unsigned long)
PPL_SPECIALIZE_CLASSIFY(classify_int, unsigned long long)

template <typename Policy, typename Type>
inline bool
is_nan_int(const Type v) {
  return Policy::has_nan && v == Extended_Int<Policy, Type>::not_a_number;
}

PPL_SPECIALIZE_IS_NAN(is_nan_int, char)
PPL_SPECIALIZE_IS_NAN(is_nan_int, signed char)
PPL_SPECIALIZE_IS_NAN(is_nan_int, signed short)
PPL_SPECIALIZE_IS_NAN(is_nan_int, signed int)
PPL_SPECIALIZE_IS_NAN(is_nan_int, signed long)
PPL_SPECIALIZE_IS_NAN(is_nan_int, signed long long)
PPL_SPECIALIZE_IS_NAN(is_nan_int, unsigned char)
PPL_SPECIALIZE_IS_NAN(is_nan_int, unsigned short)
PPL_SPECIALIZE_IS_NAN(is_nan_int, unsigned int)
PPL_SPECIALIZE_IS_NAN(is_nan_int, unsigned long)
PPL_SPECIALIZE_IS_NAN(is_nan_int, unsigned long long)

template <typename Policy, typename Type>
inline bool
is_minf_int(const Type v) {
  return Policy::has_infinity
    && v == Extended_Int<Policy, Type>::minus_infinity;
}

PPL_SPECIALIZE_IS_MINF(is_minf_int, char)
PPL_SPECIALIZE_IS_MINF(is_minf_int, signed char)
PPL_SPECIALIZE_IS_MINF(is_minf_int, signed short)
PPL_SPECIALIZE_IS_MINF(is_minf_int, signed int)
PPL_SPECIALIZE_IS_MINF(is_minf_int, signed long)
PPL_SPECIALIZE_IS_MINF(is_minf_int, signed long long)
PPL_SPECIALIZE_IS_MINF(is_minf_int, unsigned char)
PPL_SPECIALIZE_IS_MINF(is_minf_int, unsigned short)
PPL_SPECIALIZE_IS_MINF(is_minf_int, unsigned int)
PPL_SPECIALIZE_IS_MINF(is_minf_int, unsigned long)
PPL_SPECIALIZE_IS_MINF(is_minf_int, unsigned long long)

template <typename Policy, typename Type>
inline bool
is_pinf_int(const Type v) {
  return Policy::has_infinity
    && v == Extended_Int<Policy, Type>::plus_infinity;
}

PPL_SPECIALIZE_IS_PINF(is_pinf_int, char)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, signed char)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, signed short)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, signed int)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, signed long)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, signed long long)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, unsigned char)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, unsigned short)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, unsigned int)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, unsigned long)
PPL_SPECIALIZE_IS_PINF(is_pinf_int, unsigned long long)

template <typename Policy, typename Type>
inline bool
is_int_int(const Type v) {
  return !is_nan<Policy>(v);
}

PPL_SPECIALIZE_IS_INT(is_int_int, char)
PPL_SPECIALIZE_IS_INT(is_int_int, signed char)
PPL_SPECIALIZE_IS_INT(is_int_int, signed short)
PPL_SPECIALIZE_IS_INT(is_int_int, signed int)
PPL_SPECIALIZE_IS_INT(is_int_int, signed long)
PPL_SPECIALIZE_IS_INT(is_int_int, signed long long)
PPL_SPECIALIZE_IS_INT(is_int_int, unsigned char)
PPL_SPECIALIZE_IS_INT(is_int_int, unsigned short)
PPL_SPECIALIZE_IS_INT(is_int_int, unsigned int)
PPL_SPECIALIZE_IS_INT(is_int_int, unsigned long)
PPL_SPECIALIZE_IS_INT(is_int_int, unsigned long long)

template <typename Policy, typename Type>
inline Result
assign_special_int(Type& v, Result_Class c, Rounding_Dir dir) {
  PPL_ASSERT(c == VC_MINUS_INFINITY || c == VC_PLUS_INFINITY || c == VC_NAN);
  switch (c) {
  case VC_NAN:
    if (Policy::has_nan) {
      v = Extended_Int<Policy, Type>::not_a_number;
      return V_NAN;
    }
    return V_NAN | V_UNREPRESENTABLE;
  case VC_MINUS_INFINITY:
    if (Policy::has_infinity) {
      v = Extended_Int<Policy, Type>::minus_infinity;
      return V_EQ_MINUS_INFINITY;
    }
    if (round_up(dir)) {
      v = Extended_Int<Policy, Type>::min;
      return V_LT_INF;
    }
    return V_EQ_MINUS_INFINITY | V_UNREPRESENTABLE;
  case VC_PLUS_INFINITY:
    if (Policy::has_infinity) {
      v = Extended_Int<Policy, Type>::plus_infinity;
      return V_EQ_PLUS_INFINITY;
    }
    if (round_down(dir)) {
      v = Extended_Int<Policy, Type>::max;
      return V_GT_SUP;
    }
    return V_EQ_PLUS_INFINITY | V_UNREPRESENTABLE;
  default:
    PPL_UNREACHABLE;
    return V_NAN | V_UNREPRESENTABLE;
  }
}

PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, char)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, signed char)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, signed short)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, signed int)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, signed long)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, signed long long)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, unsigned char)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, unsigned short)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, unsigned int)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, unsigned long)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_int, unsigned long long)

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_signed_int_signed_int(To& to, const From from, Rounding_Dir dir) {
  if (sizeof(To) < sizeof(From)
      || (sizeof(To) == sizeof(From)
      && (Extended_Int<To_Policy, To>::min > Extended_Int<From_Policy, From>::min
      || Extended_Int<To_Policy, To>::max < Extended_Int<From_Policy, From>::max))) {
    if (CHECK_P(To_Policy::check_overflow,
                PPL_LT_SILENT(from,
                              static_cast<From>(Extended_Int<To_Policy, To>::min)))) {
      return set_neg_overflow_int<To_Policy>(to, dir);
    }
    if (CHECK_P(To_Policy::check_overflow,
                PPL_GT_SILENT(from,
                              static_cast<From>(Extended_Int<To_Policy, To>::max)))) {
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
  }
  to = static_cast<To>(from);
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_signed_int_unsigned_int(To& to, const From from, Rounding_Dir dir) {
  if (sizeof(To) <= sizeof(From)) {
    if (CHECK_P(To_Policy::check_overflow,
                from > static_cast<From>(Extended_Int<To_Policy, To>::max))) {
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
  }
  to = static_cast<To>(from);
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_unsigned_int_signed_int(To& to, const From from, Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_overflow, from < 0)) {
    return set_neg_overflow_int<To_Policy>(to, dir);
  }
  if (sizeof(To) < sizeof(From)) {
    if (CHECK_P(To_Policy::check_overflow,
                from > static_cast<From>(Extended_Int<To_Policy, To>::max))) {
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
  }
  to = static_cast<To>(from);
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_unsigned_int_unsigned_int(To& to, const From from, Rounding_Dir dir) {
  if (sizeof(To) < sizeof(From)
      || (sizeof(To) == sizeof(From)
      && Extended_Int<To_Policy, To>::max < Extended_Int<From_Policy, From>::max)) {
    if (CHECK_P(To_Policy::check_overflow,
                PPL_GT_SILENT(from,
                              static_cast<From>(Extended_Int<To_Policy, To>::max)))) {
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
  }
  to = static_cast<To>(from);
  return V_EQ;
}


#define PPL_ASSIGN2_SIGNED_SIGNED(Smaller, Larger) \
PPL_SPECIALIZE_ASSIGN(assign_signed_int_signed_int, Smaller, Larger) \
PPL_SPECIALIZE_ASSIGN(assign_signed_int_signed_int, Larger, Smaller)

#define PPL_ASSIGN2_UNSIGNED_UNSIGNED(Smaller, Larger) \
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_unsigned_int, Smaller, Larger) \
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_unsigned_int, Larger, Smaller)

#define PPL_ASSIGN2_UNSIGNED_SIGNED(Smaller, Larger) \
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_signed_int, Smaller, Larger) \
PPL_SPECIALIZE_ASSIGN(assign_signed_int_unsigned_int, Larger, Smaller)

#define PPL_ASSIGN2_SIGNED_UNSIGNED(Smaller, Larger) \
PPL_SPECIALIZE_ASSIGN(assign_signed_int_unsigned_int, Smaller, Larger) \
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_signed_int, Larger, Smaller)

#define PPL_ASSIGN_SIGNED(Type) \
PPL_SPECIALIZE_ASSIGN(assign_signed_int_signed_int, Type, Type)
#define PPL_ASSIGN_UNSIGNED(Type) \
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_unsigned_int, Type, Type)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_ASSIGN_SIGNED(char)
#endif
PPL_ASSIGN_SIGNED(signed char)
PPL_ASSIGN_SIGNED(signed short)
PPL_ASSIGN_SIGNED(signed int)
PPL_ASSIGN_SIGNED(signed long)
PPL_ASSIGN_SIGNED(signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_ASSIGN_UNSIGNED(char)
#endif
PPL_ASSIGN_UNSIGNED(unsigned char)
PPL_ASSIGN_UNSIGNED(unsigned short)
PPL_ASSIGN_UNSIGNED(unsigned int)
PPL_ASSIGN_UNSIGNED(unsigned long)
PPL_ASSIGN_UNSIGNED(unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_ASSIGN2_SIGNED_SIGNED(char, signed short)
PPL_ASSIGN2_SIGNED_SIGNED(char, signed int)
PPL_ASSIGN2_SIGNED_SIGNED(char, signed long)
PPL_ASSIGN2_SIGNED_SIGNED(char, signed long long)
#endif
PPL_ASSIGN2_SIGNED_SIGNED(signed char, signed short)
PPL_ASSIGN2_SIGNED_SIGNED(signed char, signed int)
PPL_ASSIGN2_SIGNED_SIGNED(signed char, signed long)
PPL_ASSIGN2_SIGNED_SIGNED(signed char, signed long long)
PPL_ASSIGN2_SIGNED_SIGNED(signed short, signed int)
PPL_ASSIGN2_SIGNED_SIGNED(signed short, signed long)
PPL_ASSIGN2_SIGNED_SIGNED(signed short, signed long long)
PPL_ASSIGN2_SIGNED_SIGNED(signed int, signed long)
PPL_ASSIGN2_SIGNED_SIGNED(signed int, signed long long)
PPL_ASSIGN2_SIGNED_SIGNED(signed long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_ASSIGN2_UNSIGNED_UNSIGNED(char, unsigned short)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(char, unsigned int)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(char, unsigned long)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(char, unsigned long long)
#endif
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned char, unsigned short)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned char, unsigned int)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned char, unsigned long)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned char, unsigned long long)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned short, unsigned int)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned short, unsigned long)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned short, unsigned long long)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned int, unsigned long)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned int, unsigned long long)
PPL_ASSIGN2_UNSIGNED_UNSIGNED(unsigned long, unsigned long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_ASSIGN2_UNSIGNED_SIGNED(char, signed short)
PPL_ASSIGN2_UNSIGNED_SIGNED(char, signed int)
PPL_ASSIGN2_UNSIGNED_SIGNED(char, signed long)
PPL_ASSIGN2_UNSIGNED_SIGNED(char, signed long long)
#endif
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned char, signed short)
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned char, signed int)
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned char, signed long)
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned char, signed long long)
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned short, signed int)
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned short, signed long)
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned short, signed long long)
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned int, signed long)
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned int, signed long long)
PPL_ASSIGN2_UNSIGNED_SIGNED(unsigned long, signed long long)
#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_ASSIGN2_SIGNED_UNSIGNED(char, unsigned char)
PPL_ASSIGN2_SIGNED_UNSIGNED(char, unsigned short)
PPL_ASSIGN2_SIGNED_UNSIGNED(char, unsigned int)
PPL_ASSIGN2_SIGNED_UNSIGNED(char, unsigned long)
PPL_ASSIGN2_SIGNED_UNSIGNED(char, unsigned long long)
#else
PPL_ASSIGN2_SIGNED_UNSIGNED(signed char, char)
#endif
PPL_ASSIGN2_SIGNED_UNSIGNED(signed char, unsigned char)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed char, unsigned short)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed char, unsigned int)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed char, unsigned long)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed char, unsigned long long)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed short, unsigned short)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed short, unsigned int)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed short, unsigned long)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed short, unsigned long long)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed int, unsigned int)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed int, unsigned long)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed int, unsigned long long)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed long, unsigned long)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed long, unsigned long long)
PPL_ASSIGN2_SIGNED_UNSIGNED(signed long long, unsigned long long)

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_int_float(To& to, const From from, Rounding_Dir dir) {
  if (is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
#if 0
  // FIXME: this is correct but it is inefficient and breaks the build
  // for the missing definition of static const members (a problem present
  // also in other areas of the PPL).
  if (CHECK_P(To_Policy::check_overflow,
              lt(from, Extended_Int<To_Policy, To>::min))) {
    return set_neg_overflow_int<To_Policy>(to, dir);
  }
  if (CHECK_P(To_Policy::check_overflow,
              !le(from, Extended_Int<To_Policy, To>::max))) {
    return set_pos_overflow_int<To_Policy>(to, dir);
  }
#else
  if (CHECK_P(To_Policy::check_overflow,
             (from < Extended_Int<To_Policy, To>::min))) {
    return set_neg_overflow_int<To_Policy>(to, dir);
  }
  if (CHECK_P(To_Policy::check_overflow,
             (from > Extended_Int<To_Policy, To>::max))) {
    return set_pos_overflow_int<To_Policy>(to, dir);
  }
#endif
  if (round_not_requested(dir)) {
    to = from;
    return V_LGE;
  }
  From i_from = rint(from);
  to = i_from;
  if (from == i_from) {
    return V_EQ;
  }
  if (round_direct(ROUND_UP)) {
    return round_lt_int<To_Policy>(to, dir);
  }
  if (round_direct(ROUND_DOWN)) {
    return round_gt_int<To_Policy>(to, dir);
  }
  if (from < i_from) {
    return round_lt_int<To_Policy>(to, dir);
  }
  PPL_ASSERT(from > i_from);
  return round_gt_int<To_Policy>(to, dir);
}

PPL_SPECIALIZE_ASSIGN(assign_int_float, char, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed char, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed short, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed int, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed long, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed long long, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned char, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned short, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned int, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned long, float)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned long long, float)

PPL_SPECIALIZE_ASSIGN(assign_int_float, char, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed char, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed short, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed int, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed long, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed long long, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned char, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned short, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned int, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned long, double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned long long, double)

PPL_SPECIALIZE_ASSIGN(assign_int_float, char, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed char, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed short, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed int, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed long, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, signed long long, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned char, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned short, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned int, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned long, long double)
PPL_SPECIALIZE_ASSIGN(assign_int_float, unsigned long long, long double)

#undef PPL_ASSIGN_SIGNED
#undef PPL_ASSIGN_UNSIGNED
#undef PPL_ASSIGN2_SIGNED_SIGNED
#undef PPL_ASSIGN2_UNSIGNED_UNSIGNED
#undef PPL_ASSIGN2_UNSIGNED_SIGNED
#undef PPL_ASSIGN2_SIGNED_UNSIGNED

template <typename To_Policy, typename From_Policy, typename To>
inline Result
assign_signed_int_mpz(To& to, const mpz_class& from, Rounding_Dir dir) {
  if (sizeof(To) <= sizeof(signed long)) {
    if (!To_Policy::check_overflow) {
      to = from.get_si();
      return V_EQ;
    }
    if (from.fits_slong_p()) {
      signed long v = from.get_si();
      if (PPL_LT_SILENT(v, (Extended_Int<To_Policy, To>::min))) {
        return set_neg_overflow_int<To_Policy>(to, dir);
      }
      if (PPL_GT_SILENT(v, (Extended_Int<To_Policy, To>::max))) {
        return set_pos_overflow_int<To_Policy>(to, dir);
      }
      to = v;
      return V_EQ;
    }
  }
  else {
    mpz_srcptr m = from.get_mpz_t();
    size_t sz = mpz_size(m);
    if (sz <= sizeof(To) / sizeof(mp_limb_t)) {
      if (sz == 0) {
        to = 0;
        return V_EQ;
      }
      To v;
      mpz_export(&v, 0, -1, sizeof(To), 0, 0, m);
      if (v >= 0) {
        if (::sgn(from) < 0) {
          return neg<To_Policy, To_Policy>(to, v, dir);
        }
        to = v;
        return V_EQ;
      }
    }
  }
  return (::sgn(from) < 0)
    ? set_neg_overflow_int<To_Policy>(to, dir)
    : set_pos_overflow_int<To_Policy>(to, dir);
}

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_ASSIGN(assign_signed_int_mpz, char, mpz_class)
#endif
PPL_SPECIALIZE_ASSIGN(assign_signed_int_mpz, signed char, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_signed_int_mpz, signed short, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_signed_int_mpz, signed int, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_signed_int_mpz, signed long, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_signed_int_mpz, signed long long, mpz_class)

template <typename To_Policy, typename From_Policy, typename To>
inline Result
assign_unsigned_int_mpz(To& to, const mpz_class& from, Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_overflow, ::sgn(from) < 0)) {
    return set_neg_overflow_int<To_Policy>(to, dir);
  }
  if (sizeof(To) <= sizeof(unsigned long)) {
    if (!To_Policy::check_overflow) {
      to = static_cast<To>(from.get_ui());
      return V_EQ;
    }
    if (from.fits_ulong_p()) {
      const unsigned long v = from.get_ui();
      if (PPL_GT_SILENT(v, (Extended_Int<To_Policy, To>::max))) {
        return set_pos_overflow_int<To_Policy>(to, dir);
      }
      to = static_cast<To>(v);
      return V_EQ;
    }
  }
  else {
    const mpz_srcptr m = from.get_mpz_t();
    const size_t sz = mpz_size(m);
    if (sz <= sizeof(To) / sizeof(mp_limb_t)) {
      if (sz == 0) {
        to = 0;
      }
      else {
        mpz_export(&to, 0, -1, sizeof(To), 0, 0, m);
      }
      return V_EQ;
    }
  }
  return set_pos_overflow_int<To_Policy>(to, dir);
}

#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_mpz, char, mpz_class)
#endif
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_mpz, unsigned char, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_mpz, unsigned short, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_mpz, unsigned int, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_mpz, unsigned long, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_unsigned_int_mpz, unsigned long long, mpz_class)

template <typename To_Policy, typename From_Policy, typename To>
inline Result
assign_int_mpq(To& to, const mpq_class& from, Rounding_Dir dir) {
  mpz_srcptr n = from.get_num().get_mpz_t();
  mpz_srcptr d = from.get_den().get_mpz_t();
  PPL_DIRTY_TEMP(mpz_class, q);
  mpz_ptr q_z = q.get_mpz_t();
  if (round_not_requested(dir)) {
    mpz_tdiv_q(q_z, n, d);
    Result r = assign<To_Policy, void>(to, q, dir);
    if (r != V_EQ) {
      return r;
    }
    return V_LGE;
  }
  mpz_t rem;
  int sign;
  mpz_init(rem);
  mpz_tdiv_qr(q_z, rem, n, d);
  sign = mpz_sgn(rem);
  mpz_clear(rem);
  Result r = assign<To_Policy, void>(to, q, dir);
  if (r != V_EQ) {
    return r;
  }
  switch (sign) {
  case -1:
    return round_lt_int<To_Policy>(to, dir);
  case 1:
    return round_gt_int<To_Policy>(to, dir);
  default:
    return V_EQ;
  }
}

PPL_SPECIALIZE_ASSIGN(assign_int_mpq, char, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, signed char, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, signed short, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, signed int, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, signed long, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, signed long long, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, unsigned char, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, unsigned short, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, unsigned int, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, unsigned long, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_int_mpq, unsigned long long, mpq_class)

#if ~0 != -1
#error "Only two's complement is supported"
#endif

#if UCHAR_MAX == 0xff
#define CHAR_BITS 8
#else
#error "Unexpected max for unsigned char"
#endif

#if USHRT_MAX == 0xffff
#define SHRT_BITS 16
#else
#error "Unexpected max for unsigned short"
#endif

#if UINT_MAX == 0xffffffff
#define INT_BITS 32
#else
#error "Unexpected max for unsigned int"
#endif

#if ULONG_MAX == 0xffffffffUL
#define LONG_BITS 32
#elif ULONG_MAX == 0xffffffffffffffffULL
#define LONG_BITS 64
#else
#error "Unexpected max for unsigned long"
#endif

#if ULLONG_MAX == 0xffffffffffffffffULL
#define LONG_LONG_BITS 64
#else
#error "Unexpected max for unsigned long long"
#endif


template <typename T>
struct Larger;

// The following may be tuned for performance on specific architectures.
//
// Current guidelines:
//   - avoid division where possible (larger type variant for mul)
//   - use larger type variant for types smaller than architecture bit size

template <>
struct Larger<char> {
  const_bool_nodef(use_for_neg, true);
  const_bool_nodef(use_for_add, true);
  const_bool_nodef(use_for_sub, true);
  const_bool_nodef(use_for_mul, true);
  typedef int_fast16_t type_for_neg;
  typedef int_fast16_t type_for_add;
  typedef int_fast16_t type_for_sub;
  typedef int_fast16_t type_for_mul;
};

template <>
struct Larger<signed char> {
  const_bool_nodef(use_for_neg, true);
  const_bool_nodef(use_for_add, true);
  const_bool_nodef(use_for_sub, true);
  const_bool_nodef(use_for_mul, true);
  typedef int_fast16_t type_for_neg;
  typedef int_fast16_t type_for_add;
  typedef int_fast16_t type_for_sub;
  typedef int_fast16_t type_for_mul;
};

template <>
struct Larger<unsigned char> {
  const_bool_nodef(use_for_neg, true);
  const_bool_nodef(use_for_add, true);
  const_bool_nodef(use_for_sub, true);
  const_bool_nodef(use_for_mul, true);
  typedef int_fast16_t type_for_neg;
  typedef uint_fast16_t type_for_add;
  typedef int_fast16_t type_for_sub;
  typedef uint_fast16_t type_for_mul;
};

template <>
struct Larger<signed short> {
  const_bool_nodef(use_for_neg, true);
  const_bool_nodef(use_for_add, true);
  const_bool_nodef(use_for_sub, true);
  const_bool_nodef(use_for_mul, true);
  typedef int_fast32_t type_for_neg;
  typedef int_fast32_t type_for_add;
  typedef int_fast32_t type_for_sub;
  typedef int_fast32_t type_for_mul;
};

template <>
struct Larger<unsigned short> {
  const_bool_nodef(use_for_neg, true);
  const_bool_nodef(use_for_add, true);
  const_bool_nodef(use_for_sub, true);
  const_bool_nodef(use_for_mul, true);
  typedef int_fast32_t type_for_neg;
  typedef uint_fast32_t type_for_add;
  typedef int_fast32_t type_for_sub;
  typedef uint_fast32_t type_for_mul;
};

template <>
struct Larger<signed int> {
  const_bool_nodef(use_for_neg, (LONG_BITS == 64));
  const_bool_nodef(use_for_add, (LONG_BITS == 64));
  const_bool_nodef(use_for_sub, (LONG_BITS == 64));
  const_bool_nodef(use_for_mul, true);
  typedef int_fast64_t type_for_neg;
  typedef int_fast64_t type_for_add;
  typedef int_fast64_t type_for_sub;
  typedef int_fast64_t type_for_mul;
};

template <>
struct Larger<unsigned int> {
  const_bool_nodef(use_for_neg, (LONG_BITS == 64));
  const_bool_nodef(use_for_add, (LONG_BITS == 64));
  const_bool_nodef(use_for_sub, (LONG_BITS == 64));
  const_bool_nodef(use_for_mul, true);
  typedef int_fast64_t type_for_neg;
  typedef uint_fast64_t type_for_add;
  typedef int_fast64_t type_for_sub;
  typedef uint_fast64_t type_for_mul;
};

template <>
struct Larger<signed long> {
  const_bool_nodef(use_for_neg, false);
  const_bool_nodef(use_for_add, false);
  const_bool_nodef(use_for_sub, false);
  const_bool_nodef(use_for_mul, (LONG_BITS == 32));
  typedef int_fast64_t type_for_neg;
  typedef int_fast64_t type_for_add;
  typedef int_fast64_t type_for_sub;
  typedef int_fast64_t type_for_mul;
};

template <>
struct Larger<unsigned long> {
  const_bool_nodef(use_for_neg, false);
  const_bool_nodef(use_for_add, false);
  const_bool_nodef(use_for_sub, false);
  const_bool_nodef(use_for_mul, (LONG_BITS == 32));
  typedef int_fast64_t type_for_neg;
  typedef uint_fast64_t type_for_add;
  typedef int_fast64_t type_for_sub;
  typedef uint_fast64_t type_for_mul;
};

template <>
struct Larger<signed long long> {
  const_bool_nodef(use_for_neg, false);
  const_bool_nodef(use_for_add, false);
  const_bool_nodef(use_for_sub, false);
  const_bool_nodef(use_for_mul, false);
  typedef int_fast64_t type_for_neg;
  typedef int_fast64_t type_for_add;
  typedef int_fast64_t type_for_sub;
  typedef int_fast64_t type_for_mul;
};

template <>
struct Larger<unsigned long long> {
  const_bool_nodef(use_for_neg, false);
  const_bool_nodef(use_for_add, false);
  const_bool_nodef(use_for_sub, false);
  const_bool_nodef(use_for_mul, false);
  typedef int_fast64_t type_for_neg;
  typedef uint_fast64_t type_for_add;
  typedef int_fast64_t type_for_sub;
  typedef uint_fast64_t type_for_mul;
};

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
neg_int_larger(Type& to, const Type x, Rounding_Dir dir) {
  typename Larger<Type>::type_for_neg l = x;
  l = -l;
  return assign<To_Policy, To_Policy>(to, l, dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
add_int_larger(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  typename Larger<Type>::type_for_add l = x;
  l += y;
  return assign<To_Policy, To_Policy>(to, l, dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
sub_int_larger(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  typename Larger<Type>::type_for_sub l = x;
  l -= y;
  return assign<To_Policy, To_Policy>(to, l, dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
mul_int_larger(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  typename Larger<Type>::type_for_mul l = x;
  l *= y;
  return assign<To_Policy, To_Policy>(to, l, dir);
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
neg_signed_int(Type& to, const Type from, Rounding_Dir dir) {
  if (To_Policy::check_overflow && Larger<Type>::use_for_neg) {
    return neg_int_larger<To_Policy, From_Policy>(to, from, dir);
  }
  if (CHECK_P(To_Policy::check_overflow,
              (from < -Extended_Int<To_Policy, Type>::max))) {
    return set_pos_overflow_int<To_Policy>(to, dir);
  }
  to = -from;
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
neg_unsigned_int(Type& to, const Type from, Rounding_Dir dir) {
  if (To_Policy::check_overflow && Larger<Type>::use_for_neg) {
    return neg_int_larger<To_Policy, From_Policy>(to, from, dir);
  }
  if (CHECK_P(To_Policy::check_overflow, from != 0)) {
    return set_neg_overflow_int<To_Policy>(to, dir);
  }
  to = from;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
add_signed_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_overflow && Larger<Type>::use_for_add) {
    return add_int_larger<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
  }
  if (To_Policy::check_overflow) {
    if (y >= 0) {
      if (x > Extended_Int<To_Policy, Type>::max - y) {
        return set_pos_overflow_int<To_Policy>(to, dir);
      }
    }
    else if (x < Extended_Int<To_Policy, Type>::min - y) {
      return set_neg_overflow_int<To_Policy>(to, dir);
    }
  }
  to = x + y;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
add_unsigned_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_overflow && Larger<Type>::use_for_add) {
    return add_int_larger<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
  }
  if (CHECK_P(To_Policy::check_overflow,
              (x > Extended_Int<To_Policy, Type>::max - y))) {
    return set_pos_overflow_int<To_Policy>(to, dir);
  }
  to = x + y;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
sub_signed_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_overflow && Larger<Type>::use_for_sub) {
    return sub_int_larger<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
  }
  if (To_Policy::check_overflow) {
    if (y >= 0) {
      if (x < Extended_Int<To_Policy, Type>::min + y) {
        return set_neg_overflow_int<To_Policy>(to, dir);
      }
    }
    else if (x > Extended_Int<To_Policy, Type>::max + y) {
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
  }
  to = x - y;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
sub_unsigned_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_overflow && Larger<Type>::use_for_sub) {
    return sub_int_larger<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
  }
  if (CHECK_P(To_Policy::check_overflow,
              (x < Extended_Int<To_Policy, Type>::min + y))) {
    return set_neg_overflow_int<To_Policy>(to, dir);
  }
  to = x - y;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
mul_signed_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_overflow && Larger<Type>::use_for_mul) {
    return mul_int_larger<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
  }
  if (!To_Policy::check_overflow) {
    to = x * y;
    return V_EQ;
  }
  if (y == 0) {
    to = 0;
    return V_EQ;
  }
  if (y == -1) {
    return neg_signed_int<To_Policy, From1_Policy>(to, x, dir);
  }
  if (x >= 0) {
    if (y > 0) {
      if (x > Extended_Int<To_Policy, Type>::max / y) {
        return set_pos_overflow_int<To_Policy>(to, dir);
      }
    }
    else {
      if (x > Extended_Int<To_Policy, Type>::min / y) {
        return set_neg_overflow_int<To_Policy>(to, dir);
      }
    }
  }
  else {
    if (y < 0) {
      if (x < Extended_Int<To_Policy, Type>::max / y) {
        return set_pos_overflow_int<To_Policy>(to, dir);
      }
    }
    else {
      if (x < Extended_Int<To_Policy, Type>::min / y) {
        return set_neg_overflow_int<To_Policy>(to, dir);
      }
    }
  }
  to = x * y;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
mul_unsigned_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_overflow && Larger<Type>::use_for_mul) {
    return mul_int_larger<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
  }
  if (!To_Policy::check_overflow) {
    to = x * y;
    return V_EQ;
  }
  if (y == 0) {
    to = 0;
    return V_EQ;
  }
  if (x > Extended_Int<To_Policy, Type>::max / y) {
    return set_pos_overflow_int<To_Policy>(to, dir);
  }
  to = x * y;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
div_signed_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_div_zero, y == 0)) {
    return assign_nan<To_Policy>(to, V_DIV_ZERO);
  }
  if (To_Policy::check_overflow && y == -1) {
    return neg_signed_int<To_Policy, From1_Policy>(to, x, dir);
  }
  to = x / y;
  if (round_not_requested(dir)) {
    return V_LGE;
  }
  if (y == -1) {
    return V_EQ;
  }
  Type m = x % y;
  if (m < 0) {
    return round_lt_int_no_overflow<To_Policy>(to, dir);
  }
  else if (m > 0) {
    return round_gt_int_no_overflow<To_Policy>(to, dir);
  }
  else {
    return V_EQ;
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
div_unsigned_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_div_zero, y == 0)) {
    return assign_nan<To_Policy>(to, V_DIV_ZERO);
  }
  to = x / y;
  if (round_not_requested(dir)) {
    return V_GE;
  }
  Type m = x % y;
  if (m == 0) {
    return V_EQ;
  }
  return round_gt_int<To_Policy>(to, dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
idiv_signed_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_div_zero, y == 0)) {
    return assign_nan<To_Policy>(to, V_DIV_ZERO);
  }
  if (To_Policy::check_overflow && y == -1) {
    return neg_signed_int<To_Policy, From1_Policy>(to, x, dir);
  }
  to = x / y;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
idiv_unsigned_int(Type& to, const Type x, const Type y, Rounding_Dir) {
  if (CHECK_P(To_Policy::check_div_zero, y == 0)) {
    return assign_nan<To_Policy>(to, V_DIV_ZERO);
  }
  to = x / y;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
rem_signed_int(Type& to, const Type x, const Type y, Rounding_Dir) {
  if (CHECK_P(To_Policy::check_div_zero, y == 0)) {
    return assign_nan<To_Policy>(to, V_MOD_ZERO);
  }
  to = (y == -1) ? 0 : (x % y);
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
rem_unsigned_int(Type& to, const Type x, const Type y, Rounding_Dir) {
  if (CHECK_P(To_Policy::check_div_zero, y == 0)) {
    return assign_nan<To_Policy>(to, V_MOD_ZERO);
  }
  to = x % y;
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
div_2exp_unsigned_int(Type& to, const Type x, unsigned int exp,
                      Rounding_Dir dir) {
  if (exp >= sizeof_to_bits(sizeof(Type))) {
    to = 0;
    if (round_not_requested(dir)) {
      return V_GE;
    }
    if (x == 0) {
      return V_EQ;
    }
    return round_gt_int_no_overflow<To_Policy>(to, dir);
  }
  to = x >> exp;
  if (round_not_requested(dir)) {
    return V_GE;
  }
  if (x & ((Type(1) << exp) - 1)) {
    return round_gt_int_no_overflow<To_Policy>(to, dir);
  }
  else {
    return V_EQ;
  }
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
div_2exp_signed_int(Type& to, const Type x, unsigned int exp,
                    Rounding_Dir dir) {
  if (x < 0) {
    if (exp >= sizeof_to_bits(sizeof(Type))) {
      to = 0;
      if (round_not_requested(dir)) {
        return V_LE;
      }
      return round_lt_int_no_overflow<To_Policy>(to, dir);
    }
    typedef typename C_Integer<Type>::other_type UType;
    UType ux = x;
    ux = -ux;
    to = ~Type(~-(ux >> exp));
    if (round_not_requested(dir)) {
      return V_LE;
    }
    if (ux & ((UType(1) << exp) -1)) {
      return round_lt_int_no_overflow<To_Policy>(to, dir);
    }
    return V_EQ;
  }
  else {
    if (exp >= sizeof_to_bits(sizeof(Type)) - 1) {
      to = 0;
      if (round_not_requested(dir)) {
        return V_GE;
      }
      if (x == 0) {
        return V_EQ;
      }
      return round_gt_int_no_overflow<To_Policy>(to, dir);
    }
    to = x >> exp;
    if (round_not_requested(dir)) {
      return V_GE;
    }
    if (x & ((Type(1) << exp) - 1)) {
      return round_gt_int_no_overflow<To_Policy>(to, dir);
    }
    else {
      return V_EQ;
    }
  }
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
add_2exp_unsigned_int(Type& to, const Type x, unsigned int exp,
                      Rounding_Dir dir) {
  if (!To_Policy::check_overflow) {
    to = x + (Type(1) << exp);
    return V_EQ;
  }
  if (exp >= sizeof_to_bits(sizeof(Type))) {
    return set_pos_overflow_int<To_Policy>(to, dir);
  }
  Type n = Type(1) << exp;
  return add_unsigned_int<To_Policy, From_Policy, void>(to, x, n, dir);
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
add_2exp_signed_int(Type& to, const Type x, unsigned int exp,
                    Rounding_Dir dir) {
  if (!To_Policy::check_overflow) {
    to = x + (Type(1) << exp);
    return V_EQ;
  }
  if (exp >= sizeof_to_bits(sizeof(Type))) {
    return set_pos_overflow_int<To_Policy>(to, dir);
  }
  if (exp == sizeof_to_bits(sizeof(Type)) - 1) {
    Type n = -2 * (Type(1) << (exp - 1));
    return sub_signed_int<To_Policy, From_Policy, void>(to, x, n, dir);
  }
  else {
    Type n = Type(1) << exp;
    return add_signed_int<To_Policy, From_Policy, void>(to, x, n, dir);
  }
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
sub_2exp_unsigned_int(Type& to, const Type x, unsigned int exp,
                      Rounding_Dir dir) {
  if (!To_Policy::check_overflow) {
    to = x - (Type(1) << exp);
    return V_EQ;
  }
  if (exp >= sizeof_to_bits(sizeof(Type))) {
    return set_neg_overflow_int<To_Policy>(to, dir);
  }
  Type n = Type(1) << exp;
  return sub_unsigned_int<To_Policy, From_Policy, void>(to, x, n, dir);
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
sub_2exp_signed_int(Type& to, const Type x, unsigned int exp,
                    Rounding_Dir dir) {
  if (!To_Policy::check_overflow) {
    to = x - (Type(1) << exp);
    return V_EQ;
  }
  if (exp >= sizeof_to_bits(sizeof(Type))) {
    return set_neg_overflow_int<To_Policy>(to, dir);
  }
  if (exp == sizeof_to_bits(sizeof(Type)) - 1) {
    Type n = -2 * (Type(1) << (exp - 1));
    return add_signed_int<To_Policy, From_Policy, void>(to, x, n, dir);
  }
  else {
    Type n = Type(1) << exp;
    return sub_signed_int<To_Policy, From_Policy, void>(to, x, n, dir);
  }
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
mul_2exp_unsigned_int(Type& to, const Type x, unsigned int exp,
                      Rounding_Dir dir) {
  if (!To_Policy::check_overflow) {
    to = x << exp;
    return V_EQ;
  }
  if (exp >= sizeof_to_bits(sizeof(Type))) {
    if (x == 0) {
      to = 0;
      return V_EQ;
    }
    return set_pos_overflow_int<To_Policy>(to, dir);
  }
  if (x > Extended_Int<To_Policy, Type>::max >> exp) {
    return set_pos_overflow_int<To_Policy>(to, dir);
  }
  to = x << exp;
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
mul_2exp_signed_int(Type& to, const Type x, unsigned int exp,
                    Rounding_Dir dir) {
  if (x < 0) {
    if (!To_Policy::check_overflow) {
      to = x * (Type(1) << exp);
      return V_EQ;
    }
    if (exp >= sizeof_to_bits(sizeof(Type))) {
      return set_neg_overflow_int<To_Policy>(to, dir);
    }
    typedef typename C_Integer<Type>::other_type UType;
    UType mask = UType(-1) << (sizeof_to_bits(sizeof(Type)) - exp - 1);
    UType ux = x;
    if ((ux & mask) != mask) {
      return set_neg_overflow_int<To_Policy>(to, dir);
    }
    ux <<= exp;
    Type n = ~(Type(~ux));
    if (PPL_LT_SILENT(n, (Extended_Int<To_Policy, Type>::min))) {
      return set_neg_overflow_int<To_Policy>(to, dir);
    }
    to = n;
  }
  else {
    if (!To_Policy::check_overflow) {
      to = x << exp;
      return V_EQ;
    }
    if (exp >= sizeof_to_bits(sizeof(Type)) - 1) {
      if (x == 0) {
        to = 0;
        return V_EQ;
      }
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
    if (x > Extended_Int<To_Policy, Type>::max >> exp) {
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
    to = x << exp;
  }
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
smod_2exp_unsigned_int(Type& to, const Type x, unsigned int exp,
                       Rounding_Dir dir) {
  if (exp > sizeof_to_bits(sizeof(Type))) {
    to = x;
  }
  else {
    Type v = (exp == sizeof_to_bits(sizeof(Type)) ? x : (x & ((Type(1) << exp) - 1)));
    if (v >= (Type(1) << (exp - 1))) {
      return set_neg_overflow_int<To_Policy>(to, dir);
    }
    else {
      to = v;
    }
  }
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
smod_2exp_signed_int(Type& to, const Type x, unsigned int exp,
                     Rounding_Dir) {
  if (exp >= sizeof_to_bits(sizeof(Type))) {
    to = x;
  }
  else {
    Type m = Type(1) << (exp - 1);
    to = (x & (m - 1)) - (x & m);
  }
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
umod_2exp_unsigned_int(Type& to, const Type x, unsigned int exp,
                       Rounding_Dir) {
  if (exp >= sizeof_to_bits(sizeof(Type))) {
    to = x;
  }
  else {
    to = x & ((Type(1) << exp) - 1);
  }
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
umod_2exp_signed_int(Type& to, const Type x, unsigned int exp,
                     Rounding_Dir dir) {
  if (exp >= sizeof_to_bits(sizeof(Type))) {
    if (x < 0) {
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
    to = x;
  }
  else {
    to = x & ((Type(1) << exp) - 1);
  }
  return V_EQ;
}

template <typename Type>
inline void
isqrt_rem(Type& q, Type& r, const Type from) {
  q = 0;
  r = from;
  Type t(1);
  for (t <<= sizeof_to_bits(sizeof(Type)) - 2; t != 0; t >>= 2) {
    Type s = q + t;
    if (s <= r) {
      r -= s;
      q = s + t;
    }
    q >>= 1;
  }
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
sqrt_unsigned_int(Type& to, const Type from, Rounding_Dir dir) {
  Type rem;
  isqrt_rem(to, rem, from);
  if (round_not_requested(dir)) {
    return V_GE;
  }
  if (rem == 0) {
    return V_EQ;
  }
  return round_gt_int<To_Policy>(to, dir);
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
sqrt_signed_int(Type& to, const Type from, Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_sqrt_neg, from < 0)) {
    return assign_nan<To_Policy>(to, V_SQRT_NEG);
  }
  return sqrt_unsigned_int<To_Policy, From_Policy>(to, from, dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
add_mul_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  Type z;
  Result r = mul<To_Policy, From1_Policy, From2_Policy>(z, x, y, dir);
  switch (result_overflow(r)) {
  case 0:
    return add<To_Policy, To_Policy, To_Policy>(to, to, z, dir);
  case -1:
    if (to <= 0) {
      return set_neg_overflow_int<To_Policy>(to, dir);
    }
    return assign_nan<To_Policy>(to, V_UNKNOWN_NEG_OVERFLOW);
  case 1:
    if (to >= 0) {
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
    return assign_nan<To_Policy>(to, V_UNKNOWN_POS_OVERFLOW);
  default:
    PPL_UNREACHABLE;
    return V_NAN;
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
sub_mul_int(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  Type z;
  Result r = mul<To_Policy, From1_Policy, From2_Policy>(z, x, y, dir);
  switch (result_overflow(r)) {
  case 0:
    return sub<To_Policy, To_Policy, To_Policy>(to, to, z, dir);
  case -1:
    if (to >= 0) {
      return set_pos_overflow_int<To_Policy>(to, dir);
    }
    return assign_nan<To_Policy>(to, V_UNKNOWN_NEG_OVERFLOW);
  case 1:
    if (to <= 0) {
      return set_neg_overflow_int<To_Policy>(to, dir);
    }
    return assign_nan<To_Policy>(to, V_UNKNOWN_POS_OVERFLOW);
  default:
    PPL_UNREACHABLE;
    return V_NAN;
  }
}

template <typename Policy, typename Type>
inline Result
output_char(std::ostream& os, Type& from,
            const Numeric_Format&, Rounding_Dir) {
  os << int(from);
  return V_EQ;
}

template <typename Policy, typename Type>
inline Result
output_int(std::ostream& os, Type& from, const Numeric_Format&, Rounding_Dir) {
  os << from;
  return V_EQ;
}

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_FLOOR(assign_signed_int_signed_int, char, char)
#endif
PPL_SPECIALIZE_FLOOR(assign_signed_int_signed_int, signed char, signed char)
PPL_SPECIALIZE_FLOOR(assign_signed_int_signed_int, signed short, signed short)
PPL_SPECIALIZE_FLOOR(assign_signed_int_signed_int, signed int, signed int)
PPL_SPECIALIZE_FLOOR(assign_signed_int_signed_int, signed long, signed long)
PPL_SPECIALIZE_FLOOR(assign_signed_int_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_FLOOR(assign_unsigned_int_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_FLOOR(assign_unsigned_int_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_FLOOR(assign_unsigned_int_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_FLOOR(assign_unsigned_int_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_FLOOR(assign_unsigned_int_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_FLOOR(assign_unsigned_int_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_CEIL(assign_signed_int_signed_int, char, char)
#endif
PPL_SPECIALIZE_CEIL(assign_signed_int_signed_int, signed char, signed char)
PPL_SPECIALIZE_CEIL(assign_signed_int_signed_int, signed short, signed short)
PPL_SPECIALIZE_CEIL(assign_signed_int_signed_int, signed int, signed int)
PPL_SPECIALIZE_CEIL(assign_signed_int_signed_int, signed long, signed long)
PPL_SPECIALIZE_CEIL(assign_signed_int_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_CEIL(assign_unsigned_int_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_CEIL(assign_unsigned_int_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_CEIL(assign_unsigned_int_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_CEIL(assign_unsigned_int_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_CEIL(assign_unsigned_int_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_CEIL(assign_unsigned_int_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_TRUNC(assign_signed_int_signed_int, char, char)
#endif
PPL_SPECIALIZE_TRUNC(assign_signed_int_signed_int, signed char, signed char)
PPL_SPECIALIZE_TRUNC(assign_signed_int_signed_int, signed short, signed short)
PPL_SPECIALIZE_TRUNC(assign_signed_int_signed_int, signed int, signed int)
PPL_SPECIALIZE_TRUNC(assign_signed_int_signed_int, signed long, signed long)
PPL_SPECIALIZE_TRUNC(assign_signed_int_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_TRUNC(assign_unsigned_int_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_TRUNC(assign_unsigned_int_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_TRUNC(assign_unsigned_int_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_TRUNC(assign_unsigned_int_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_TRUNC(assign_unsigned_int_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_TRUNC(assign_unsigned_int_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_NEG(neg_signed_int, char, char)
#endif
PPL_SPECIALIZE_NEG(neg_signed_int, signed char, signed char)
PPL_SPECIALIZE_NEG(neg_signed_int, signed short, signed short)
PPL_SPECIALIZE_NEG(neg_signed_int, signed int, signed int)
PPL_SPECIALIZE_NEG(neg_signed_int, signed long, signed long)
PPL_SPECIALIZE_NEG(neg_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_NEG(neg_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_NEG(neg_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_NEG(neg_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_NEG(neg_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_NEG(neg_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_NEG(neg_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_ADD(add_signed_int, char, char, char)
#endif
PPL_SPECIALIZE_ADD(add_signed_int, signed char, signed char, signed char)
PPL_SPECIALIZE_ADD(add_signed_int, signed short, signed short, signed short)
PPL_SPECIALIZE_ADD(add_signed_int, signed int, signed int, signed int)
PPL_SPECIALIZE_ADD(add_signed_int, signed long, signed long, signed long)
PPL_SPECIALIZE_ADD(add_signed_int, signed long long, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_ADD(add_unsigned_int, char, char, char)
#endif
PPL_SPECIALIZE_ADD(add_unsigned_int, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_ADD(add_unsigned_int, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_ADD(add_unsigned_int, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_ADD(add_unsigned_int, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_ADD(add_unsigned_int, unsigned long long, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_SUB(sub_signed_int, char, char, char)
#endif
PPL_SPECIALIZE_SUB(sub_signed_int, signed char, signed char, signed char)
PPL_SPECIALIZE_SUB(sub_signed_int, signed short, signed short, signed short)
PPL_SPECIALIZE_SUB(sub_signed_int, signed int, signed int, signed int)
PPL_SPECIALIZE_SUB(sub_signed_int, signed long, signed long, signed long)
PPL_SPECIALIZE_SUB(sub_signed_int, signed long long, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_SUB(sub_unsigned_int, char, char, char)
#endif
PPL_SPECIALIZE_SUB(sub_unsigned_int, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_SUB(sub_unsigned_int, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_SUB(sub_unsigned_int, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_SUB(sub_unsigned_int, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_SUB(sub_unsigned_int, unsigned long long, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_MUL(mul_signed_int, char, char, char)
#endif
PPL_SPECIALIZE_MUL(mul_signed_int, signed char, signed char, signed char)
PPL_SPECIALIZE_MUL(mul_signed_int, signed short, signed short, signed short)
PPL_SPECIALIZE_MUL(mul_signed_int, signed int, signed int, signed int)
PPL_SPECIALIZE_MUL(mul_signed_int, signed long, signed long, signed long)
PPL_SPECIALIZE_MUL(mul_signed_int, signed long long, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_MUL(mul_unsigned_int, char, char, char)
#endif
PPL_SPECIALIZE_MUL(mul_unsigned_int, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_MUL(mul_unsigned_int, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_MUL(mul_unsigned_int, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_MUL(mul_unsigned_int, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_MUL(mul_unsigned_int, unsigned long long, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_DIV(div_signed_int, char, char, char)
#endif
PPL_SPECIALIZE_DIV(div_signed_int, signed char, signed char, signed char)
PPL_SPECIALIZE_DIV(div_signed_int, signed short, signed short, signed short)
PPL_SPECIALIZE_DIV(div_signed_int, signed int, signed int, signed int)
PPL_SPECIALIZE_DIV(div_signed_int, signed long, signed long, signed long)
PPL_SPECIALIZE_DIV(div_signed_int, signed long long, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_DIV(div_unsigned_int, char, char, char)
#endif
PPL_SPECIALIZE_DIV(div_unsigned_int, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_DIV(div_unsigned_int, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_DIV(div_unsigned_int, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_DIV(div_unsigned_int, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_DIV(div_unsigned_int, unsigned long long, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_IDIV(idiv_signed_int, char, char, char)
#endif
PPL_SPECIALIZE_IDIV(idiv_signed_int, signed char, signed char, signed char)
PPL_SPECIALIZE_IDIV(idiv_signed_int, signed short, signed short, signed short)
PPL_SPECIALIZE_IDIV(idiv_signed_int, signed int, signed int, signed int)
PPL_SPECIALIZE_IDIV(idiv_signed_int, signed long, signed long, signed long)
PPL_SPECIALIZE_IDIV(idiv_signed_int, signed long long, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_IDIV(idiv_unsigned_int, char, char, char)
#endif
PPL_SPECIALIZE_IDIV(idiv_unsigned_int, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_IDIV(idiv_unsigned_int, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_IDIV(idiv_unsigned_int, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_IDIV(idiv_unsigned_int, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_IDIV(idiv_unsigned_int, unsigned long long, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_REM(rem_signed_int, char, char, char)
#endif
PPL_SPECIALIZE_REM(rem_signed_int, signed char, signed char, signed char)
PPL_SPECIALIZE_REM(rem_signed_int, signed short, signed short, signed short)
PPL_SPECIALIZE_REM(rem_signed_int, signed int, signed int, signed int)
PPL_SPECIALIZE_REM(rem_signed_int, signed long, signed long, signed long)
PPL_SPECIALIZE_REM(rem_signed_int, signed long long, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_REM(rem_unsigned_int, char, char, char)
#endif
PPL_SPECIALIZE_REM(rem_unsigned_int, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_REM(rem_unsigned_int, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_REM(rem_unsigned_int, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_REM(rem_unsigned_int, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_REM(rem_unsigned_int, unsigned long long, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_ADD_2EXP(add_2exp_signed_int, char, char)
#endif
PPL_SPECIALIZE_ADD_2EXP(add_2exp_signed_int, signed char, signed char)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_signed_int, signed short, signed short)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_signed_int, signed int, signed int)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_signed_int, signed long, signed long)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_ADD_2EXP(add_2exp_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_ADD_2EXP(add_2exp_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_signed_int, char, char)
#endif
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_signed_int, signed char, signed char)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_signed_int, signed short, signed short)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_signed_int, signed int, signed int)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_signed_int, signed long, signed long)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_signed_int, char, char)
#endif
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_signed_int, signed char, signed char)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_signed_int, signed short, signed short)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_signed_int, signed int, signed int)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_signed_int, signed long, signed long)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_DIV_2EXP(div_2exp_signed_int, char, char)
#endif
PPL_SPECIALIZE_DIV_2EXP(div_2exp_signed_int, signed char, signed char)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_signed_int, signed short, signed short)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_signed_int, signed int, signed int)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_signed_int, signed long, signed long)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_DIV_2EXP(div_2exp_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_DIV_2EXP(div_2exp_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_signed_int, char, char)
#endif
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_signed_int, signed char, signed char)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_signed_int, signed short, signed short)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_signed_int, signed int, signed int)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_signed_int, signed long, signed long)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_signed_int, char, char)
#endif
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_signed_int, signed char, signed char)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_signed_int, signed short, signed short)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_signed_int, signed int, signed int)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_signed_int, signed long, signed long)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_SQRT(sqrt_signed_int, char, char)
#endif
PPL_SPECIALIZE_SQRT(sqrt_signed_int, signed char, signed char)
PPL_SPECIALIZE_SQRT(sqrt_signed_int, signed short, signed short)
PPL_SPECIALIZE_SQRT(sqrt_signed_int, signed int, signed int)
PPL_SPECIALIZE_SQRT(sqrt_signed_int, signed long, signed long)
PPL_SPECIALIZE_SQRT(sqrt_signed_int, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_SQRT(sqrt_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_SQRT(sqrt_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_SQRT(sqrt_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_SQRT(sqrt_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_SQRT(sqrt_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_SQRT(sqrt_unsigned_int, unsigned long long, unsigned long long)

#if PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_ABS(abs_generic, char, char)
#endif
PPL_SPECIALIZE_ABS(abs_generic, signed char, signed char)
PPL_SPECIALIZE_ABS(abs_generic, signed short, signed short)
PPL_SPECIALIZE_ABS(abs_generic, signed int, signed int)
PPL_SPECIALIZE_ABS(abs_generic, signed long, signed long)
PPL_SPECIALIZE_ABS(abs_generic, signed long long, signed long long)
#if !PPL_CXX_PLAIN_CHAR_IS_SIGNED
PPL_SPECIALIZE_ABS(assign_unsigned_int_unsigned_int, char, char)
#endif
PPL_SPECIALIZE_ABS(assign_unsigned_int_unsigned_int, unsigned char, unsigned char)
PPL_SPECIALIZE_ABS(assign_unsigned_int_unsigned_int, unsigned short, unsigned short)
PPL_SPECIALIZE_ABS(assign_unsigned_int_unsigned_int, unsigned int, unsigned int)
PPL_SPECIALIZE_ABS(assign_unsigned_int_unsigned_int, unsigned long, unsigned long)
PPL_SPECIALIZE_ABS(assign_unsigned_int_unsigned_int, unsigned long long, unsigned long long)

PPL_SPECIALIZE_GCD(gcd_exact, char, char, char)
PPL_SPECIALIZE_GCD(gcd_exact, signed char, signed char, signed char)
PPL_SPECIALIZE_GCD(gcd_exact, signed short, signed short, signed short)
PPL_SPECIALIZE_GCD(gcd_exact, signed int, signed int, signed int)
PPL_SPECIALIZE_GCD(gcd_exact, signed long, signed long, signed long)
PPL_SPECIALIZE_GCD(gcd_exact, signed long long, signed long long, signed long long)
PPL_SPECIALIZE_GCD(gcd_exact, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_GCD(gcd_exact, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_GCD(gcd_exact, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_GCD(gcd_exact, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_GCD(gcd_exact, unsigned long long, unsigned long long, unsigned long long)

PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      char, char, char, char, char)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      signed char, signed char, signed char,
                      signed char, signed char)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      signed short, signed short, signed short,
                      signed short, signed short)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      signed int, signed int, signed int,
                      signed int, signed int)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      signed long, signed long, signed long,
                      signed long, signed long)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      signed long long, signed long long, signed long long,
                      signed long long, signed long long)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      unsigned char, unsigned char, unsigned char,
                      unsigned char, unsigned char)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      unsigned short, unsigned short, unsigned short,
                      unsigned short, unsigned short)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      unsigned int, unsigned int, unsigned int,
                      unsigned int, unsigned int)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      unsigned long, unsigned long, unsigned long,
                      unsigned long, unsigned long)
PPL_SPECIALIZE_GCDEXT(gcdext_exact,
                      unsigned long long, unsigned long long,
                      unsigned long long, unsigned long long,
                      unsigned long long)

PPL_SPECIALIZE_LCM(lcm_gcd_exact, char, char, char)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, signed char, signed char, signed char)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, signed short, signed short, signed short)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, signed int, signed int, signed int)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, signed long, signed long, signed long)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, signed long long, signed long long, signed long long)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, unsigned long long, unsigned long long, unsigned long long)

PPL_SPECIALIZE_SGN(sgn_generic, char)
PPL_SPECIALIZE_SGN(sgn_generic, signed char)
PPL_SPECIALIZE_SGN(sgn_generic, signed short)
PPL_SPECIALIZE_SGN(sgn_generic, signed int)
PPL_SPECIALIZE_SGN(sgn_generic, signed long)
PPL_SPECIALIZE_SGN(sgn_generic, signed long long)
PPL_SPECIALIZE_SGN(sgn_generic, unsigned char)
PPL_SPECIALIZE_SGN(sgn_generic, unsigned short)
PPL_SPECIALIZE_SGN(sgn_generic, unsigned int)
PPL_SPECIALIZE_SGN(sgn_generic, unsigned long)
PPL_SPECIALIZE_SGN(sgn_generic, unsigned long long)

PPL_SPECIALIZE_CMP(cmp_generic, char, char)
PPL_SPECIALIZE_CMP(cmp_generic, signed char, signed char)
PPL_SPECIALIZE_CMP(cmp_generic, signed short, signed short)
PPL_SPECIALIZE_CMP(cmp_generic, signed int, signed int)
PPL_SPECIALIZE_CMP(cmp_generic, signed long, signed long)
PPL_SPECIALIZE_CMP(cmp_generic, signed long long, signed long long)
PPL_SPECIALIZE_CMP(cmp_generic, unsigned char, unsigned char)
PPL_SPECIALIZE_CMP(cmp_generic, unsigned short, unsigned short)
PPL_SPECIALIZE_CMP(cmp_generic, unsigned int, unsigned int)
PPL_SPECIALIZE_CMP(cmp_generic, unsigned long, unsigned long)
PPL_SPECIALIZE_CMP(cmp_generic, unsigned long long, unsigned long long)

PPL_SPECIALIZE_ADD_MUL(add_mul_int, char, char, char)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, signed char, signed char, signed char)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, signed short, signed short, signed short)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, signed int, signed int, signed int)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, signed long, signed long, signed long)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, signed long long, signed long long, signed long long)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_ADD_MUL(add_mul_int, unsigned long long, unsigned long long, unsigned long long)

PPL_SPECIALIZE_SUB_MUL(sub_mul_int, char, char, char)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, signed char, signed char, signed char)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, signed short, signed short, signed short)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, signed int, signed int, signed int)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, signed long, signed long, signed long)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, signed long long, signed long long, signed long long)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, unsigned char, unsigned char, unsigned char)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, unsigned short, unsigned short, unsigned short)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, unsigned int, unsigned int, unsigned int)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, unsigned long, unsigned long, unsigned long)
PPL_SPECIALIZE_SUB_MUL(sub_mul_int, unsigned long long, unsigned long long, unsigned long long)

PPL_SPECIALIZE_INPUT(input_generic, char)
PPL_SPECIALIZE_INPUT(input_generic, signed char)
PPL_SPECIALIZE_INPUT(input_generic, signed short)
PPL_SPECIALIZE_INPUT(input_generic, signed int)
PPL_SPECIALIZE_INPUT(input_generic, signed long)
PPL_SPECIALIZE_INPUT(input_generic, signed long long)
PPL_SPECIALIZE_INPUT(input_generic, unsigned char)
PPL_SPECIALIZE_INPUT(input_generic, unsigned short)
PPL_SPECIALIZE_INPUT(input_generic, unsigned int)
PPL_SPECIALIZE_INPUT(input_generic, unsigned long)
PPL_SPECIALIZE_INPUT(input_generic, unsigned long long)

PPL_SPECIALIZE_OUTPUT(output_char, char)
PPL_SPECIALIZE_OUTPUT(output_char, signed char)
PPL_SPECIALIZE_OUTPUT(output_int, signed short)
PPL_SPECIALIZE_OUTPUT(output_int, signed int)
PPL_SPECIALIZE_OUTPUT(output_int, signed long)
PPL_SPECIALIZE_OUTPUT(output_int, signed long long)
PPL_SPECIALIZE_OUTPUT(output_char, unsigned char)
PPL_SPECIALIZE_OUTPUT(output_int, unsigned short)
PPL_SPECIALIZE_OUTPUT(output_int, unsigned int)
PPL_SPECIALIZE_OUTPUT(output_int, unsigned long)
PPL_SPECIALIZE_OUTPUT(output_int, unsigned long long)

} // namespace Checked

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/checked_float_inlines.hh line 1. */
/* Specialized "checked" functions for native floating-point numbers.
*/


/* Automatically generated from PPL source file ../src/checked_float_inlines.hh line 28. */
#include <cmath>

namespace Parma_Polyhedra_Library {

namespace Checked {

inline float
multiply_add(float x, float y, float z) {
#if PPL_HAVE_DECL_FMAF && defined(FP_FAST_FMAF) \
  && !defined(__alpha) && !defined(__FreeBSD__)
  return fmaf(x, y, z);
#else
  return x*y + z;
#endif
}

inline double
multiply_add(double x, double y, double z) {
#if PPL_HAVE_DECL_FMA && defined(FP_FAST_FMA) \
  && !defined(__alpha) && !defined(__FreeBSD__)
  return fma(x, y, z);
#else
  return x*y + z;
#endif
}

inline long double
multiply_add(long double x, long double y, long double z) {
#if PPL_HAVE_DECL_FMAL && defined(FP_FAST_FMAL) \
  && !defined(__alpha) && !defined(__FreeBSD__)
  return fmal(x, y, z);
#else
  return x*y + z;
#endif
}

#if PPL_HAVE_DECL_RINTF
inline float
round_to_integer(float x) {
  return rintf(x);
}
#endif

inline double
round_to_integer(double x) {
  return rint(x);
}

#if PPL_HAVE_DECL_RINTL
inline long double
round_to_integer(long double x) {
  return rintl(x);
}
#elif !PPL_CXX_PROVIDES_PROPER_LONG_DOUBLE
// If proper long doubles are not provided, this is most likely
// because long double and double are the same type: use rint().
inline long double
round_to_integer(long double x) {
  return rint(x);
}
#elif defined(__i386__) && (defined(__GNUC__) || defined(__INTEL_COMPILER))
// On Cygwin, we have proper long doubles but rintl() is not defined:
// luckily, one machine instruction is enough to save the day.
inline long double
round_to_integer(long double x) {
  long double i;
  __asm__ ("frndint" : "=t" (i) : "0" (x));
  return i;
}
#endif

inline bool
fpu_direct_rounding(Rounding_Dir dir) {
  return round_direct(dir) || round_not_requested(dir);
}

inline bool
fpu_inverse_rounding(Rounding_Dir dir) {
  return round_inverse(dir);
}

// The FPU mode is "round down".
//
// The result of the rounded down multiplication is thus computed directly.
//
//   a = 0.3
//   b = 0.1
//   c_i = a * b = 0.03
//   c = c_i = 0.0
//
// To obtain the result of the rounded up multiplication
// we do -(-a * b).
//
//   a = 0.3
//   b = 0.1
//   c_i = -a * b = -0.03
//
// Here c_i should be forced to lose excess precision, otherwise the
// FPU will truncate using the rounding mode in force, which is "round down".
//
//   c_i = -c_i = 0.03
//   c = c_i = 0.0
//
// Wrong result: we should have obtained c = 0.1.

inline void
limit_precision(const float& v) {
  PPL_CC_FLUSH(v);
}

inline void
limit_precision(const double& v) {
  PPL_CC_FLUSH(v);
}

inline void
limit_precision(const long double&) {
}

template <typename Policy, typename T>
inline Result
classify_float(const T v, bool nan, bool inf, bool sign) {
  Float<T> f(v);
  if ((nan || sign) && CHECK_P(Policy::has_nan, f.u.binary.is_nan())) {
    return V_NAN;
  }
  if (inf) {
    if (Policy::has_infinity) {
      int sign_inf = f.u.binary.inf_sign();
      if (sign_inf < 0) {
        return V_EQ_MINUS_INFINITY;
      }
      if (sign_inf > 0) {
        return V_EQ_PLUS_INFINITY;
      }
    }
    else {
      PPL_ASSERT(f.u.binary.inf_sign() == 0);
    }
  }
  if (sign) {
    if (v < 0) {
      return V_LT;
    }
    if (v > 0) {
      return V_GT;
    }
    return V_EQ;
  }
  return V_LGE;
}

template <typename Policy, typename T>
inline bool
is_nan_float(const T v) {
  Float<T> f(v);
  return CHECK_P(Policy::has_nan, f.u.binary.is_nan());
}

template <typename Policy, typename T>
inline bool
is_inf_float(const T v) {
  Float<T> f(v);
  return CHECK_P(Policy::has_infinity, (f.u.binary.inf_sign() != 0));
}
template <typename Policy, typename T>
inline bool
is_minf_float(const T v) {
  Float<T> f(v);
  return CHECK_P(Policy::has_infinity, (f.u.binary.inf_sign() < 0));
}

template <typename Policy, typename T>
inline bool
is_pinf_float(const T v) {
  Float<T> f(v);
  return CHECK_P(Policy::has_infinity, (f.u.binary.inf_sign() > 0));
}


template <typename Policy, typename T>
inline bool
is_int_float(const T v) {
  return round_to_integer(v) == v;
}

template <typename Policy, typename T>
inline Result
assign_special_float(T& v, Result_Class c, Rounding_Dir) {
  PPL_ASSERT(c == VC_MINUS_INFINITY || c == VC_PLUS_INFINITY || c == VC_NAN);
  switch (c) {
  case VC_MINUS_INFINITY:
    v = -HUGE_VAL;
    return V_EQ_MINUS_INFINITY;
  case VC_PLUS_INFINITY:
    v = HUGE_VAL;
    return V_EQ_PLUS_INFINITY;
  case VC_NAN:
    v = PPL_NAN;
    return V_NAN;
  default:
    PPL_UNREACHABLE;
    return V_NAN | V_UNREPRESENTABLE;
  }
}

template <typename T>
inline void
pred_float(T& v) {
  Float<T> f(v);
  PPL_ASSERT(!f.u.binary.is_nan());
  PPL_ASSERT(f.u.binary.inf_sign() >= 0);
  if (f.u.binary.zero_sign() > 0) {
    f.u.binary.negate();
    f.u.binary.inc();
  }
  else if (f.u.binary.sign_bit()) {
    f.u.binary.inc();
  }
  else {
    f.u.binary.dec();
  }
  v = f.value();
}

template <typename T>
inline void
succ_float(T& v) {
  Float<T> f(v);
  PPL_ASSERT(!f.u.binary.is_nan());
  PPL_ASSERT(f.u.binary.inf_sign() <= 0);
  if (f.u.binary.zero_sign() < 0) {
    f.u.binary.negate();
    f.u.binary.inc();
  }
  else if (!f.u.binary.sign_bit()) {
    f.u.binary.inc();
  }
  else {
    f.u.binary.dec();
  }
  v = f.value();
}

template <typename Policy, typename To>
inline Result
round_lt_float(To& to, Rounding_Dir dir) {
  if (round_down(dir)) {
    pred_float(to);
    return V_GT;
  }
  return V_LT;
}

template <typename Policy, typename To>
inline Result
round_gt_float(To& to, Rounding_Dir dir) {
  if (round_up(dir)) {
    succ_float(to);
    return V_LT;
  }
  return V_GT;
}


template <typename Policy>
inline void
prepare_inexact(Rounding_Dir dir) {
  if (Policy::fpu_check_inexact
      && !round_not_needed(dir) && round_strict_relation(dir)) {
    fpu_reset_inexact();
  }
}

template <typename Policy>
inline Result
result_relation(Rounding_Dir dir) {
  if (Policy::fpu_check_inexact
      && !round_not_needed(dir) && round_strict_relation(dir)) {
    switch (fpu_check_inexact()) {
    case 0:
      return V_EQ;
    case -1:
      goto unknown;
    case 1:
      break;
    }
    switch (round_dir(dir)) {
    case ROUND_DOWN:
      return V_GT;
    case ROUND_UP:
      return V_LT;
    default:
      return V_NE;
    }
  }
  else {
  unknown:
    switch (round_dir(dir)) {
    case ROUND_DOWN:
      return V_GE;
    case ROUND_UP:
      return V_LE;
    default:
      return V_LGE;
    }
  }
}

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_float_float_exact(To& to, const From from, Rounding_Dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  to = from;
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_float_float_inexact(To& to, const From from, Rounding_Dir dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  prepare_inexact<To_Policy>(dir);
  if (fpu_direct_rounding(dir)) {
    to = from;
  }
  else if (fpu_inverse_rounding(dir)) {
    From tmp = -from;
    to = tmp;
    limit_precision(to);
    to = -to;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(dir));
    limit_precision(from);
    to = from;
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  return result_relation<To_Policy>(dir);
}

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_float_float(To& to, const From from, Rounding_Dir dir) {
  if (sizeof(From) > sizeof(To)) {
    return assign_float_float_inexact<To_Policy, From_Policy>(to, from, dir);
  }
  else {
    return assign_float_float_exact<To_Policy, From_Policy>(to, from, dir);
  }
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
floor_float(Type& to, const Type from, Rounding_Dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (fpu_direct_rounding(ROUND_DOWN)) {
    to = round_to_integer(from);
  }
  else if (fpu_inverse_rounding(ROUND_DOWN)) {
    to = round_to_integer(-from);
    limit_precision(to);
    to = -to;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(ROUND_DOWN));
    limit_precision(from);
    to = round_to_integer(from);
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
ceil_float(Type& to, const Type from, Rounding_Dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (fpu_direct_rounding(ROUND_UP)) {
    to = round_to_integer(from);
  }
  else if (fpu_inverse_rounding(ROUND_UP)) {
    to = round_to_integer(-from);
    limit_precision(to);
    to = -to;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(ROUND_UP));
    limit_precision(from);
    to = round_to_integer(from);
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
trunc_float(Type& to, const Type from, Rounding_Dir dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (from >= 0) {
    return floor<To_Policy, From_Policy>(to, from, dir);
  }
  else {
    return ceil<To_Policy, From_Policy>(to, from, dir);
  }
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
neg_float(Type& to, const Type from, Rounding_Dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  to = -from;
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
add_float(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_inf_add_inf
      && is_inf_float<From1_Policy>(x) && x == -y) {
    return assign_nan<To_Policy>(to, V_INF_ADD_INF);
  }
  prepare_inexact<To_Policy>(dir);
  if (fpu_direct_rounding(dir)) {
    to = x + y;
  }
  else if (fpu_inverse_rounding(dir)) {
    to = -x - y;
    limit_precision(to);
    to = -to;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(dir));
    limit_precision(x);
    limit_precision(y);
    to = x + y;
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  if (To_Policy::fpu_check_nan_result && is_nan<To_Policy>(to)) {
    return V_NAN;
  }
  return result_relation<To_Policy>(dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
sub_float(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_inf_sub_inf
      && is_inf_float<From1_Policy>(x) && x == y) {
    return assign_nan<To_Policy>(to, V_INF_SUB_INF);
  }
  prepare_inexact<To_Policy>(dir);
  if (fpu_direct_rounding(dir)) {
    to = x - y;
  }
  else if (fpu_inverse_rounding(dir)) {
    to = y - x;
    limit_precision(to);
    to = -to;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(dir));
    limit_precision(x);
    limit_precision(y);
    to = x - y;
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  if (To_Policy::fpu_check_nan_result && is_nan<To_Policy>(to)) {
    return V_NAN;
  }
  return result_relation<To_Policy>(dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
mul_float(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_inf_mul_zero
      && ((x == 0 && is_inf_float<From2_Policy>(y))
          ||
          (y == 0 && is_inf_float<From1_Policy>(x)))) {
    return assign_nan<To_Policy>(to, V_INF_MUL_ZERO);
  }
  prepare_inexact<To_Policy>(dir);
  if (fpu_direct_rounding(dir)) {
    to = x * y;
  }
  else if (fpu_inverse_rounding(dir)) {
    to = x * -y;
    limit_precision(to);
    to = -to;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(dir));
    limit_precision(x);
    limit_precision(y);
    to = x * y;
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  if (To_Policy::fpu_check_nan_result && is_nan<To_Policy>(to)) {
    return V_NAN;
  }
  return result_relation<To_Policy>(dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
div_float(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_inf_div_inf
      && is_inf_float<From1_Policy>(x) && is_inf_float<From2_Policy>(y)) {
    return assign_nan<To_Policy>(to, V_INF_DIV_INF);
  }
  if (To_Policy::check_div_zero && y == 0) {
    return assign_nan<To_Policy>(to, V_DIV_ZERO);
  }
  prepare_inexact<To_Policy>(dir);
  if (fpu_direct_rounding(dir)) {
    to = x / y;
  }
  else if (fpu_inverse_rounding(dir)) {
    to = x / -y;
    limit_precision(to);
    to = -to;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(dir));
    limit_precision(x);
    limit_precision(y);
    to = x / y;
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  if (To_Policy::fpu_check_nan_result && is_nan<To_Policy>(to)) {
    return V_NAN;
  }
  return result_relation<To_Policy>(dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
idiv_float(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  Type temp;
  // The inexact check is useless
  dir = round_dir(dir);
  Result r = div<To_Policy, From1_Policy, From2_Policy>(temp, x, y, dir);
  if (result_class(r) != VC_NORMAL) {
    to = temp;
    return r;
  }
  Result r1 = trunc<To_Policy, To_Policy>(to, temp, ROUND_NOT_NEEDED);
  PPL_ASSERT(r1 == V_EQ);
  if (r == V_EQ || to != temp) {
    return r1;
  }
  // FIXME: Prove that it is impossible to return a strict relation
  return (dir == ROUND_UP) ? V_LE : V_GE;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
rem_float(Type& to, const Type x, const Type y, Rounding_Dir) {
  if (To_Policy::check_inf_mod && is_inf_float<From1_Policy>(x)) {
    return assign_nan<To_Policy>(to, V_INF_MOD);
  }
  if (To_Policy::check_div_zero && y == 0) {
    return assign_nan<To_Policy>(to, V_MOD_ZERO);
  }
  to = std::fmod(x, y);
  if (To_Policy::fpu_check_nan_result && is_nan<To_Policy>(to)) {
    return V_NAN;
  }
  return V_EQ;
}

struct Float_2exp {
  const_bool_nodef(has_nan, false);
  const_bool_nodef(has_infinity, false);
};

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
add_2exp_float(Type& to, const Type x, unsigned int exp, Rounding_Dir dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  PPL_ASSERT(exp < sizeof_to_bits(sizeof(unsigned long long)));
  return
    add<To_Policy, From_Policy, Float_2exp>(to,
                                            x,
                                            Type(1ULL << exp),
                                            dir);
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
sub_2exp_float(Type& to, const Type x, unsigned int exp, Rounding_Dir dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  PPL_ASSERT(exp < sizeof_to_bits(sizeof(unsigned long long)));
  return
    sub<To_Policy, From_Policy, Float_2exp>(to,
                                            x,
                                            Type(1ULL << exp),
                                            dir);
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
mul_2exp_float(Type& to, const Type x, unsigned int exp, Rounding_Dir dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  PPL_ASSERT(exp < sizeof_to_bits(sizeof(unsigned long long)));
  return
    mul<To_Policy, From_Policy, Float_2exp>(to,
                                            x,
                                            Type(1ULL << exp),
                                            dir);
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
div_2exp_float(Type& to, const Type x, unsigned int exp, Rounding_Dir dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  PPL_ASSERT(exp < sizeof_to_bits(sizeof(unsigned long long)));
  return
    div<To_Policy, From_Policy, Float_2exp>(to,
                                            x,
                                            Type(1ULL << exp),
                                            dir);
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
smod_2exp_float(Type& to, const Type x, unsigned int exp, Rounding_Dir dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (To_Policy::check_inf_mod && is_inf_float<From_Policy>(x)) {
    return assign_nan<To_Policy>(to, V_INF_MOD);
  }
  PPL_ASSERT(exp < sizeof_to_bits(sizeof(unsigned long long)));
  Type m = 1ULL << exp;
  rem_float<To_Policy, From_Policy, Float_2exp>(to, x, m, ROUND_IGNORE);
  Type m2 = m / 2;
  if (to < -m2) {
    return add_float<To_Policy, From_Policy, Float_2exp>(to, to, m, dir);
  }
  else if (to >= m2) {
    return sub_float<To_Policy, From_Policy, Float_2exp>(to, to, m, dir);
  }
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
umod_2exp_float(Type& to, const Type x, unsigned int exp, Rounding_Dir dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (To_Policy::check_inf_mod && is_inf_float<From_Policy>(x)) {
    return assign_nan<To_Policy>(to, V_INF_MOD);
  }
  PPL_ASSERT(exp < sizeof_to_bits(sizeof(unsigned long long)));
  Type m = 1ULL << exp;
  rem_float<To_Policy, From_Policy, Float_2exp>(to, x, m, ROUND_IGNORE);
  if (to < 0) {
    return add_float<To_Policy, From_Policy, Float_2exp>(to, to, m, dir);
  }
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
abs_float(Type& to, const Type from, Rounding_Dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  to = std::abs(from);
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename Type>
inline Result
sqrt_float(Type& to, const Type from, Rounding_Dir dir) {
  if (To_Policy::fpu_check_nan_result && is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (To_Policy::check_sqrt_neg && from < 0) {
    return assign_nan<To_Policy>(to, V_SQRT_NEG);
  }
  prepare_inexact<To_Policy>(dir);
  if (fpu_direct_rounding(dir)) {
    to = std::sqrt(from);
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(dir));
    limit_precision(from);
    to = std::sqrt(from);
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  return result_relation<To_Policy>(dir);
}

template <typename Policy, typename Type>
inline Result_Relation
sgn_float(const Type x) {
  if (x > 0) {
    return VR_GT;
  }
  if (x < 0) {
    return VR_LT;
  }
  if (x == 0) {
    return VR_EQ;
  }
  return VR_EMPTY;
}

template <typename Policy1, typename Policy2, typename Type>
inline Result_Relation
cmp_float(const Type x, const Type y) {
  if (x > y) {
    return VR_GT;
  }
  if (x < y) {
    return VR_LT;
  }
  if (x == y) {
    return VR_EQ;
  }
  return VR_EMPTY;
}

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_float_int_inexact(To& to, const From from, Rounding_Dir dir) {
  prepare_inexact<To_Policy>(dir);
  if (fpu_direct_rounding(dir)) {
    to = from;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(dir));
    to = from;
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  return result_relation<To_Policy>(dir);
}

template <typename To_Policy, typename From_Policy, typename To, typename From>
inline Result
assign_float_int(To& to, const From from, Rounding_Dir dir) {
  if (sizeof_to_bits(sizeof(From)) > Float<To>::Binary::MANTISSA_BITS) {
    return assign_float_int_inexact<To_Policy, From_Policy>(to, from, dir);
  }
  else {
    return assign_exact<To_Policy, From_Policy>(to, from, dir);
  }
}

template <typename Policy, typename T>
inline Result
set_neg_overflow_float(T& to, Rounding_Dir dir) {
  switch (round_dir(dir)) {
  case ROUND_UP:
    {
      Float<T> f;
      f.u.binary.set_max(true);
      to = f.value();
      return V_LT_INF;
    }
  case ROUND_DOWN: // Fall through.
  case ROUND_IGNORE:
    to = -HUGE_VAL;
    return V_GT_MINUS_INFINITY;
  default:
    PPL_UNREACHABLE;
    return V_GT_MINUS_INFINITY;
  }
}

template <typename Policy, typename T>
inline Result
set_pos_overflow_float(T& to, Rounding_Dir dir) {
  switch (round_dir(dir)) {
  case ROUND_DOWN:
    {
      Float<T> f;
      f.u.binary.set_max(false);
      to = f.value();
      return V_GT_SUP;
    }
  case ROUND_UP: // Fall through.
  case ROUND_IGNORE:
    to = HUGE_VAL;
    return V_LT_PLUS_INFINITY;
  default:
    PPL_UNREACHABLE;
    return V_LT_PLUS_INFINITY;
  }
}

template <typename To_Policy, typename From_Policy, typename T>
inline Result
assign_float_mpz(T& to, const mpz_class& from, Rounding_Dir dir) {
  int sign = sgn(from);
  if (sign == 0) {
    to = 0;
    return V_EQ;
  }
  mpz_srcptr from_z = from.get_mpz_t();
  size_t exponent = mpz_sizeinbase(from_z, 2) - 1;
  if (exponent > size_t(Float<T>::Binary::EXPONENT_MAX)) {
    if (sign < 0) {
      return set_neg_overflow_float<To_Policy>(to, dir);
    }
    else {
      return set_pos_overflow_float<To_Policy>(to, dir);
    }
  }
  unsigned long zeroes = mpn_scan1(from_z->_mp_d, 0);
  size_t meaningful_bits = exponent - zeroes;
  mpz_t mantissa;
  mpz_init(mantissa);
  if (exponent > Float<T>::Binary::MANTISSA_BITS) {
    mpz_tdiv_q_2exp(mantissa,
                    from_z,
                    exponent - Float<T>::Binary::MANTISSA_BITS);
  }
  else {
    mpz_mul_2exp(mantissa, from_z, Float<T>::Binary::MANTISSA_BITS - exponent);
  }
  Float<T> f;
  f.u.binary.build(sign < 0, mantissa, static_cast<long>(exponent));
  mpz_clear(mantissa);
  to = f.value();
  if (meaningful_bits > Float<T>::Binary::MANTISSA_BITS) {
    if (sign < 0) {
      return round_lt_float<To_Policy>(to, dir);
    }
    else {
      return round_gt_float<To_Policy>(to, dir);
    }
  }
  return V_EQ;
}

template <typename To_Policy, typename From_Policy, typename T>
inline Result
assign_float_mpq(T& to, const mpq_class& from, Rounding_Dir dir) {
  const mpz_class& numer = from.get_num();
  const mpz_class& denom = from.get_den();
  if (denom == 1) {
    return assign_float_mpz<To_Policy, From_Policy>(to, numer, dir);
  }
  mpz_srcptr numer_z = numer.get_mpz_t();
  mpz_srcptr denom_z = denom.get_mpz_t();
  int sign = sgn(numer);
  long exponent = static_cast<long>(mpz_sizeinbase(numer_z, 2))
    - static_cast<long>(mpz_sizeinbase(denom_z, 2));
  if (exponent < Float<T>::Binary::EXPONENT_MIN_DENORM) {
    to = 0;
  inexact:
    if (sign < 0) {
      return round_lt_float<To_Policy>(to, dir);
    }
    else {
      return round_gt_float<To_Policy>(to, dir);
    }
  }
  if (exponent > Float<T>::Binary::EXPONENT_MAX + 1) {
  overflow:
    if (sign < 0) {
      return set_neg_overflow_float<To_Policy>(to, dir);
    }
    else {
      return set_pos_overflow_float<To_Policy>(to, dir);
    }
  }
  unsigned int needed_bits = Float<T>::Binary::MANTISSA_BITS + 1;
  if (exponent < Float<T>::Binary::EXPONENT_MIN) {
    long diff = Float<T>::Binary::EXPONENT_MIN - exponent;
    needed_bits -= static_cast<unsigned int>(diff);
  }
  mpz_t mantissa;
  mpz_init(mantissa);
  {
    long shift = static_cast<long>(needed_bits) - exponent;
    if (shift > 0) {
      mpz_mul_2exp(mantissa, numer_z, static_cast<unsigned long>(shift));
      numer_z = mantissa;
    }
    else if (shift < 0) {
      shift = -shift;
      mpz_mul_2exp(mantissa, denom_z, static_cast<unsigned long>(shift));
      denom_z = mantissa;
    }
  }
  mpz_t r;
  mpz_init(r);
  mpz_tdiv_qr(mantissa, r, numer_z, denom_z);
  size_t bits = mpz_sizeinbase(mantissa, 2);
  bool inexact = (mpz_sgn(r) != 0);
  mpz_clear(r);
  if (bits == needed_bits + 1) {
    inexact = (inexact || mpz_odd_p(mantissa));
    mpz_tdiv_q_2exp(mantissa, mantissa, 1);
  }
  else {
    --exponent;
  }
  if (exponent > Float<T>::Binary::EXPONENT_MAX) {
    mpz_clear(mantissa);
    goto overflow;
  }
  else if (exponent < Float<T>::Binary::EXPONENT_MIN - 1) {
    // Denormalized.
    exponent = Float<T>::Binary::EXPONENT_MIN - 1;
  }
  Float<T> f;
  f.u.binary.build(sign < 0, mantissa, exponent);
  mpz_clear(mantissa);
  to = f.value();
  if (inexact) {
    goto inexact;
  }
  return V_EQ;
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename Type>
inline Result
add_mul_float(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_inf_mul_zero
      && ((x == 0 && is_inf_float<From2_Policy>(y))
          ||
          (y == 0 && is_inf_float<From1_Policy>(x)))) {
    return assign_nan<To_Policy>(to, V_INF_MUL_ZERO);
  }
  // FIXME: missing check_inf_add_inf
  prepare_inexact<To_Policy>(dir);
  if (fpu_direct_rounding(dir)) {
    to = multiply_add(x, y, to);
  }
  else if (fpu_inverse_rounding(dir)) {
    to = multiply_add(-x, y, -to);
    limit_precision(to);
    to = -to;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(dir));
    limit_precision(x);
    limit_precision(y);
    limit_precision(to);
    to = multiply_add(x, y, to);
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  if (To_Policy::fpu_check_nan_result && is_nan<To_Policy>(to)) {
    return V_NAN;
  }
  return result_relation<To_Policy>(dir);
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy, typename Type>
inline Result
sub_mul_float(Type& to, const Type x, const Type y, Rounding_Dir dir) {
  if (To_Policy::check_inf_mul_zero
      && ((x == 0 && is_inf_float<From2_Policy>(y))
          ||
          (y == 0 && is_inf_float<From1_Policy>(x)))) {
    return assign_nan<To_Policy>(to, V_INF_MUL_ZERO);
  }
  // FIXME: missing check_inf_add_inf
  prepare_inexact<To_Policy>(dir);
  if (fpu_direct_rounding(dir)) {
    to = multiply_add(x, -y, to);
  }
  else if (fpu_inverse_rounding(dir)) {
    to = multiply_add(x, y, -to);
    limit_precision(to);
    to = -to;
  }
  else {
    fpu_rounding_control_word_type old
      = fpu_save_rounding_direction(round_fpu_dir(dir));
    limit_precision(x);
    limit_precision(y);
    limit_precision(to);
    to = multiply_add(x, -y, to);
    limit_precision(to);
    fpu_restore_rounding_direction(old);
  }
  if (To_Policy::fpu_check_nan_result && is_nan<To_Policy>(to)) {
    return V_NAN;
  }
  return result_relation<To_Policy>(dir);
}

template <typename From>
inline void
assign_mpq_numeric_float(mpq_class& to, const From from) {
  to = from;
}

template <>
inline void
assign_mpq_numeric_float(mpq_class& to, const long double from) {
  to = 0;
  if (from == 0.0L) {
    return;
  }
  mpz_class& num = to.get_num();
  mpz_class& den = to.get_den();
  int exp;
  long double n = std::frexp(from, &exp);
  bool neg = false;
  if (n < 0.0L) {
    neg = true;
    n = -n;
  }
  const long double mult = static_cast<long double>(ULONG_MAX) + 1.0L;
  const unsigned int bits = sizeof(unsigned long) * CHAR_BIT;
  while (true) {
    n *= mult;
    exp -= bits;
    const long double intpart = std::floor(n);
    num += static_cast<unsigned long>(intpart);
    n -= intpart;
    if (n == 0.0L) {
      break;
    }
    num <<= bits;
  }
  if (exp < 0) {
    den <<= -exp;
  }
  else {
    num <<= exp;
  }
  if (neg) {
    to = -to;
  }
  to.canonicalize();
}

template <typename Policy, typename Type>
inline Result
output_float(std::ostream& os, const Type from, const Numeric_Format&,
             Rounding_Dir) {
  if (from == 0) {
    os << "0";
  }
  else if (is_minf<Policy>(from)) {
    os << "-inf";
  }
  else if (is_pinf<Policy>(from)) {
    os << "+inf";
  }
  else if (is_nan<Policy>(from)) {
    os << "nan";
  }
  else {
    mpq_class q;
    assign_mpq_numeric_float(q, from);
    std::string s = float_mpq_to_string(q);
    os << s;
  }
  return V_EQ;
}

#if PPL_SUPPORTED_FLOAT
PPL_SPECIALIZE_ASSIGN(assign_float_float_exact, float, float)
#if PPL_SUPPORTED_DOUBLE
PPL_SPECIALIZE_ASSIGN(assign_float_float, float, double)
PPL_SPECIALIZE_ASSIGN(assign_float_float_exact, double, float)
#endif
#if PPL_SUPPORTED_LONG_DOUBLE
PPL_SPECIALIZE_ASSIGN(assign_float_float, float, long double)
PPL_SPECIALIZE_ASSIGN(assign_float_float_exact, long double, float)
#endif
#endif

#if PPL_SUPPORTED_DOUBLE
PPL_SPECIALIZE_ASSIGN(assign_float_float_exact, double, double)
#if PPL_SUPPORTED_LONG_DOUBLE
PPL_SPECIALIZE_ASSIGN(assign_float_float, double, long double)
PPL_SPECIALIZE_ASSIGN(assign_float_float_exact, long double, double)
#endif
#endif

#if PPL_SUPPORTED_LONG_DOUBLE
PPL_SPECIALIZE_ASSIGN(assign_float_float_exact, long double, long double)
#endif

#if PPL_SUPPORTED_FLOAT
PPL_SPECIALIZE_CLASSIFY(classify_float, float)
PPL_SPECIALIZE_IS_NAN(is_nan_float, float)
PPL_SPECIALIZE_IS_MINF(is_minf_float, float)
PPL_SPECIALIZE_IS_PINF(is_pinf_float, float)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_float, float)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, char)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, signed char)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, signed short)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, signed int)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, signed long)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, signed long long)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, unsigned char)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, unsigned short)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, unsigned int)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, unsigned long)
PPL_SPECIALIZE_ASSIGN(assign_float_int, float, unsigned long long)
PPL_SPECIALIZE_ASSIGN(assign_float_mpz, float, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_float_mpq, float, mpq_class)
PPL_SPECIALIZE_COPY(copy_generic, float)
PPL_SPECIALIZE_IS_INT(is_int_float, float)
PPL_SPECIALIZE_FLOOR(floor_float, float, float)
PPL_SPECIALIZE_CEIL(ceil_float, float, float)
PPL_SPECIALIZE_TRUNC(trunc_float, float, float)
PPL_SPECIALIZE_NEG(neg_float, float, float)
PPL_SPECIALIZE_ABS(abs_float, float, float)
PPL_SPECIALIZE_ADD(add_float, float, float, float)
PPL_SPECIALIZE_SUB(sub_float, float, float, float)
PPL_SPECIALIZE_MUL(mul_float, float, float, float)
PPL_SPECIALIZE_DIV(div_float, float, float, float)
PPL_SPECIALIZE_REM(rem_float, float, float, float)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_float, float, float)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_float, float, float)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_float, float, float)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_float, float, float)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_float, float, float)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_float, float, float)
PPL_SPECIALIZE_SQRT(sqrt_float, float, float)
PPL_SPECIALIZE_GCD(gcd_exact, float, float, float)
PPL_SPECIALIZE_GCDEXT(gcdext_exact, float, float, float, float, float)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, float, float, float)
PPL_SPECIALIZE_SGN(sgn_float, float)
PPL_SPECIALIZE_CMP(cmp_float, float, float)
PPL_SPECIALIZE_ADD_MUL(add_mul_float, float, float, float)
PPL_SPECIALIZE_SUB_MUL(sub_mul_float, float, float, float)
PPL_SPECIALIZE_INPUT(input_generic, float)
PPL_SPECIALIZE_OUTPUT(output_float, float)
#endif

#if PPL_SUPPORTED_DOUBLE
PPL_SPECIALIZE_CLASSIFY(classify_float, double)
PPL_SPECIALIZE_IS_NAN(is_nan_float, double)
PPL_SPECIALIZE_IS_MINF(is_minf_float, double)
PPL_SPECIALIZE_IS_PINF(is_pinf_float, double)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_float, double)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, char)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, signed char)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, signed short)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, signed int)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, signed long)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, signed long long)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, unsigned char)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, unsigned short)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, unsigned int)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, unsigned long)
PPL_SPECIALIZE_ASSIGN(assign_float_int, double, unsigned long long)
PPL_SPECIALIZE_ASSIGN(assign_float_mpz, double, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_float_mpq, double, mpq_class)
PPL_SPECIALIZE_COPY(copy_generic, double)
PPL_SPECIALIZE_IS_INT(is_int_float, double)
PPL_SPECIALIZE_FLOOR(floor_float, double, double)
PPL_SPECIALIZE_CEIL(ceil_float, double, double)
PPL_SPECIALIZE_TRUNC(trunc_float, double, double)
PPL_SPECIALIZE_NEG(neg_float, double, double)
PPL_SPECIALIZE_ABS(abs_float, double, double)
PPL_SPECIALIZE_ADD(add_float, double, double, double)
PPL_SPECIALIZE_SUB(sub_float, double, double, double)
PPL_SPECIALIZE_MUL(mul_float, double, double, double)
PPL_SPECIALIZE_DIV(div_float, double, double, double)
PPL_SPECIALIZE_REM(rem_float, double, double, double)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_float, double, double)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_float, double, double)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_float, double, double)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_float, double, double)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_float, double, double)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_float, double, double)
PPL_SPECIALIZE_SQRT(sqrt_float, double, double)
PPL_SPECIALIZE_GCD(gcd_exact, double, double, double)
PPL_SPECIALIZE_GCDEXT(gcdext_exact, double, double, double, double, double)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, double, double, double)
PPL_SPECIALIZE_SGN(sgn_float, double)
PPL_SPECIALIZE_CMP(cmp_float, double, double)
PPL_SPECIALIZE_ADD_MUL(add_mul_float, double, double, double)
PPL_SPECIALIZE_SUB_MUL(sub_mul_float, double, double, double)
PPL_SPECIALIZE_INPUT(input_generic, double)
PPL_SPECIALIZE_OUTPUT(output_float, double)
#endif

#if PPL_SUPPORTED_LONG_DOUBLE
PPL_SPECIALIZE_CLASSIFY(classify_float, long double)
PPL_SPECIALIZE_IS_NAN(is_nan_float, long double)
PPL_SPECIALIZE_IS_MINF(is_minf_float, long double)
PPL_SPECIALIZE_IS_PINF(is_pinf_float, long double)
PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_float, long double)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, char)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, signed char)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, signed short)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, signed int)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, signed long)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, signed long long)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, unsigned char)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, unsigned short)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, unsigned int)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, unsigned long)
PPL_SPECIALIZE_ASSIGN(assign_float_int, long double, unsigned long long)
PPL_SPECIALIZE_ASSIGN(assign_float_mpz, long double, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_float_mpq, long double, mpq_class)
PPL_SPECIALIZE_COPY(copy_generic, long double)
PPL_SPECIALIZE_IS_INT(is_int_float, long double)
PPL_SPECIALIZE_FLOOR(floor_float, long double, long double)
PPL_SPECIALIZE_CEIL(ceil_float, long double, long double)
PPL_SPECIALIZE_TRUNC(trunc_float, long double, long double)
PPL_SPECIALIZE_NEG(neg_float, long double, long double)
PPL_SPECIALIZE_ABS(abs_float, long double, long double)
PPL_SPECIALIZE_ADD(add_float, long double, long double, long double)
PPL_SPECIALIZE_SUB(sub_float, long double, long double, long double)
PPL_SPECIALIZE_MUL(mul_float, long double, long double, long double)
PPL_SPECIALIZE_DIV(div_float, long double, long double, long double)
PPL_SPECIALIZE_REM(rem_float, long double, long double, long double)
PPL_SPECIALIZE_ADD_2EXP(add_2exp_float, long double, long double)
PPL_SPECIALIZE_SUB_2EXP(sub_2exp_float, long double, long double)
PPL_SPECIALIZE_MUL_2EXP(mul_2exp_float, long double, long double)
PPL_SPECIALIZE_DIV_2EXP(div_2exp_float, long double, long double)
PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_float, long double, long double)
PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_float, long double, long double)
PPL_SPECIALIZE_SQRT(sqrt_float, long double, long double)
PPL_SPECIALIZE_GCD(gcd_exact, long double, long double, long double)
PPL_SPECIALIZE_GCDEXT(gcdext_exact, long double, long double, long double,
                  long double, long double)
PPL_SPECIALIZE_LCM(lcm_gcd_exact, long double, long double, long double)
PPL_SPECIALIZE_SGN(sgn_float, long double)
PPL_SPECIALIZE_CMP(cmp_float, long double, long double)
PPL_SPECIALIZE_ADD_MUL(add_mul_float, long double, long double, long double)
PPL_SPECIALIZE_SUB_MUL(sub_mul_float, long double, long double, long double)
PPL_SPECIALIZE_INPUT(input_generic, long double)
PPL_SPECIALIZE_OUTPUT(output_float, long double)
#endif

} // namespace Checked

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/checked_mpz_inlines.hh line 1. */
/* Specialized "checked" functions for GMP's mpz_class numbers.
*/


#include <sstream>

namespace Parma_Polyhedra_Library {

namespace Checked {

template <typename Policy>
inline Result
round_lt_mpz(mpz_class& to, Rounding_Dir dir) {
  if (round_down(dir)) {
    --to;
    return V_GT;
  }
  return V_LT;
}

template <typename Policy>
inline Result
round_gt_mpz(mpz_class& to, Rounding_Dir dir) {
  if (round_up(dir)) {
    ++to;
    return V_LT;
  }
  return V_GT;
}

#if __cplusplus >= 201103L
//! Type of the _mp_size field of GMP's __mpz_struct.
typedef decltype(__mpz_struct()._mp_size) mp_size_field_t;
#elif PPL_HAVE_TYPEOF
//! Type of the _mp_size field of GMP's __mpz_struct.
typedef typeof(__mpz_struct()._mp_size) mp_size_field_t;
#else
//! This is assumed to be the type of the _mp_size field of GMP's __mpz_struct.
typedef int mp_size_field_t;
#endif

inline mp_size_field_t
get_mp_size(const mpz_class &v) {
  return v.get_mpz_t()->_mp_size;
}

inline void
set_mp_size(mpz_class &v, mp_size_field_t size) {
  v.get_mpz_t()->_mp_size = size;
}

template <typename Policy>
inline Result
classify_mpz(const mpz_class& v, bool nan, bool inf, bool sign) {
  if (Policy::has_nan || Policy::has_infinity) {
    mp_size_field_t s = get_mp_size(v);
    if (Policy::has_nan
        && (nan || sign)
        && s == C_Integer<mp_size_field_t>::min + 1) {
      return V_NAN;
    }
    if (!inf && !sign) {
      return V_LGE;
    }
    if (Policy::has_infinity) {
      if (s == C_Integer<mp_size_field_t>::min) {
        return inf ? V_EQ_MINUS_INFINITY : V_LT;
      }
      if (s == C_Integer<mp_size_field_t>::max) {
        return inf ? V_EQ_PLUS_INFINITY : V_GT;
      }
    }
  }
  if (sign) {
    return static_cast<Result>(sgn<Policy>(v));
  }
  return V_LGE;
}

PPL_SPECIALIZE_CLASSIFY(classify_mpz, mpz_class)

template <typename Policy>
inline bool
is_nan_mpz(const mpz_class& v) {
  return Policy::has_nan
    && get_mp_size(v) == C_Integer<mp_size_field_t>::min + 1;
}

PPL_SPECIALIZE_IS_NAN(is_nan_mpz, mpz_class)

template <typename Policy>
inline bool
is_minf_mpz(const mpz_class& v) {
  return Policy::has_infinity
    && get_mp_size(v) == C_Integer<mp_size_field_t>::min;
}

PPL_SPECIALIZE_IS_MINF(is_minf_mpz, mpz_class)

template <typename Policy>
inline bool
is_pinf_mpz(const mpz_class& v) {
  return Policy::has_infinity
    && get_mp_size(v) == C_Integer<mp_size_field_t>::max;
}

PPL_SPECIALIZE_IS_PINF(is_pinf_mpz, mpz_class)

template <typename Policy>
inline bool
is_int_mpz(const mpz_class& v) {
  return !is_nan<Policy>(v);
}

PPL_SPECIALIZE_IS_INT(is_int_mpz, mpz_class)

template <typename Policy>
inline Result
assign_special_mpz(mpz_class& v, Result_Class c, Rounding_Dir) {
  switch (c) {
  case VC_NAN:
    if (Policy::has_nan) {
      set_mp_size(v, C_Integer<mp_size_field_t>::min + 1);
    }
    return V_NAN;
  case VC_MINUS_INFINITY:
    if (Policy::has_infinity) {
      set_mp_size(v, C_Integer<mp_size_field_t>::min);
      return V_EQ_MINUS_INFINITY;
    }
    return V_EQ_MINUS_INFINITY | V_UNREPRESENTABLE;
  case VC_PLUS_INFINITY:
    if (Policy::has_infinity) {
      set_mp_size(v, C_Integer<mp_size_field_t>::max);
      return V_EQ_PLUS_INFINITY;
    }
    return V_EQ_PLUS_INFINITY | V_UNREPRESENTABLE;
  default:
    PPL_UNREACHABLE;
    return V_NAN;
  }
}

PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_mpz, mpz_class)

template <typename To_Policy, typename From_Policy>
inline void
copy_mpz(mpz_class& to, const mpz_class& from) {
  if (is_nan_mpz<From_Policy>(from)) {
    PPL_ASSERT(To_Policy::has_nan);
  }
  else if (is_minf_mpz<From_Policy>(from) || is_pinf_mpz<From_Policy>(from)) {
    PPL_ASSERT(To_Policy::has_infinity);
  }
  else {
    to = from;
    return;
  }
  set_mp_size(to, get_mp_size(from));
}

PPL_SPECIALIZE_COPY(copy_mpz, mpz_class)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
construct_mpz_base(mpz_class& to, const From from, Rounding_Dir) {
    new(&to) mpz_class(from);
    return V_EQ;
}

PPL_SPECIALIZE_CONSTRUCT(construct_mpz_base, mpz_class, char)
PPL_SPECIALIZE_CONSTRUCT(construct_mpz_base, mpz_class, signed char)
PPL_SPECIALIZE_CONSTRUCT(construct_mpz_base, mpz_class, signed short)
PPL_SPECIALIZE_CONSTRUCT(construct_mpz_base, mpz_class, signed int)
PPL_SPECIALIZE_CONSTRUCT(construct_mpz_base, mpz_class, signed long)
PPL_SPECIALIZE_CONSTRUCT(construct_mpz_base, mpz_class, unsigned char)
PPL_SPECIALIZE_CONSTRUCT(construct_mpz_base, mpz_class, unsigned short)
PPL_SPECIALIZE_CONSTRUCT(construct_mpz_base, mpz_class, unsigned int)
PPL_SPECIALIZE_CONSTRUCT(construct_mpz_base, mpz_class, unsigned long)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
construct_mpz_float(mpz_class& to, const From& from, Rounding_Dir dir) {
  if (is_nan<From_Policy>(from)) {
    return construct_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(from)) {
    return construct_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(from)) {
    return construct_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  if (round_not_requested(dir)) {
    new(&to) mpz_class(from);
    return V_LGE;
  }
  From n = rint(from);
  new(&to) mpz_class(n);
  if (from == n) {
    return V_EQ;
  }
  if (from < 0) {
    return round_lt_mpz<To_Policy>(to, dir);
  }
  else {
    return round_gt_mpz<To_Policy>(to, dir);
  }
}

PPL_SPECIALIZE_CONSTRUCT(construct_mpz_float, mpz_class, float)
PPL_SPECIALIZE_CONSTRUCT(construct_mpz_float, mpz_class, double)

PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, char)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, signed char)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, signed short)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, signed int)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, signed long)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, unsigned char)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, unsigned short)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, unsigned int)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpz_class, unsigned long)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
assign_mpz_signed_int(mpz_class& to, const From from, Rounding_Dir) {
  if (sizeof(From) <= sizeof(signed long)) {
    to = static_cast<signed long>(from);
  }
  else {
    mpz_ptr m = to.get_mpz_t();
    if (from >= 0) {
      mpz_import(m, 1, 1, sizeof(From), 0, 0, &from);
    }
    else {
      From n = -from;
      mpz_import(m, 1, 1, sizeof(From), 0, 0, &n);
      mpz_neg(m, m);
    }
  }
  return V_EQ;
}

PPL_SPECIALIZE_ASSIGN(assign_mpz_signed_int, mpz_class, signed long long)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
assign_mpz_unsigned_int(mpz_class& to, const From from, Rounding_Dir) {
  if (sizeof(From) <= sizeof(unsigned long)) {
    to = static_cast<unsigned long>(from);
  }
  else {
    mpz_import(to.get_mpz_t(), 1, 1, sizeof(From), 0, 0, &from);
  }
  return V_EQ;
}

PPL_SPECIALIZE_ASSIGN(assign_mpz_unsigned_int, mpz_class, unsigned long long)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
assign_mpz_float(mpz_class& to, const From from, Rounding_Dir dir) {
  if (is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  if (round_not_requested(dir)) {
    to = from;
    return V_LGE;
  }
  From i_from = rint(from);
  to = i_from;
  if (from == i_from) {
    return V_EQ;
  }
  if (round_direct(ROUND_UP)) {
    return round_lt_mpz<To_Policy>(to, dir);
  }
  if (round_direct(ROUND_DOWN)) {
    return round_gt_mpz<To_Policy>(to, dir);
  }
  if (from < i_from) {
    return round_lt_mpz<To_Policy>(to, dir);
  }
  if (from > i_from) {
    return round_gt_mpz<To_Policy>(to, dir);
  }
  PPL_UNREACHABLE;
  return V_NAN;
}

PPL_SPECIALIZE_ASSIGN(assign_mpz_float, mpz_class, float)
PPL_SPECIALIZE_ASSIGN(assign_mpz_float, mpz_class, double)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
assign_mpz_long_double(mpz_class& to, const From& from, Rounding_Dir dir) {
  if (is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  // FIXME: this is an incredibly inefficient implementation!
  std::stringstream ss;
  output<From_Policy>(ss, from, Numeric_Format(), dir);
  PPL_DIRTY_TEMP(mpq_class, tmp);
#ifndef NDEBUG
  Result r =
#endif
    input_mpq(tmp, ss);
  PPL_ASSERT(r == V_EQ);
  return assign<To_Policy, From_Policy>(to, tmp, dir);
}

PPL_SPECIALIZE_ASSIGN(assign_mpz_long_double, mpz_class, long double)

template <typename To_Policy, typename From_Policy>
inline Result
assign_mpz_mpq(mpz_class& to, const mpq_class& from, Rounding_Dir dir) {
  if (round_not_needed(dir)) {
    to = from.get_num();
    return V_LGE;
  }
  if (round_ignore(dir)) {
    to = from;
    return V_LGE;
  }
  const mpz_srcptr n = from.get_num().get_mpz_t();
  const mpz_srcptr d = from.get_den().get_mpz_t();
  if (round_down(dir)) {
    mpz_fdiv_q(to.get_mpz_t(), n, d);
    if (round_strict_relation(dir)) {
      return (mpz_divisible_p(n, d) != 0) ? V_EQ : V_GT;
    }
    return V_GE;
  }
  else {
    PPL_ASSERT(round_up(dir));
    mpz_cdiv_q(to.get_mpz_t(), n, d);
    if (round_strict_relation(dir)) {
      return (mpz_divisible_p(n, d) != 0) ? V_EQ : V_LT;
    }
    return V_LE;
  }
}

PPL_SPECIALIZE_ASSIGN(assign_mpz_mpq, mpz_class, mpq_class)

PPL_SPECIALIZE_FLOOR(assign_exact, mpz_class, mpz_class)
PPL_SPECIALIZE_CEIL(assign_exact, mpz_class, mpz_class)
PPL_SPECIALIZE_TRUNC(assign_exact, mpz_class, mpz_class)

template <typename To_Policy, typename From_Policy>
inline Result
neg_mpz(mpz_class& to, const mpz_class& from, Rounding_Dir) {
  mpz_neg(to.get_mpz_t(), from.get_mpz_t());
  return V_EQ;
}

PPL_SPECIALIZE_NEG(neg_mpz, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
add_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y, Rounding_Dir) {
  to = x + y;
  return V_EQ;
}

PPL_SPECIALIZE_ADD(add_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
sub_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y, Rounding_Dir) {
  to = x - y;
  return V_EQ;
}

PPL_SPECIALIZE_SUB(sub_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
mul_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y, Rounding_Dir) {
  to = x * y;
  return V_EQ;
}

PPL_SPECIALIZE_MUL(mul_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
div_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y,
        Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_div_zero, ::sgn(y) == 0)) {
    return assign_nan<To_Policy>(to, V_DIV_ZERO);
  }
  const mpz_srcptr n = x.get_mpz_t();
  const mpz_srcptr d = y.get_mpz_t();
  if (round_not_needed(dir)) {
    mpz_divexact(to.get_mpz_t(), n, d);
    return V_LGE;
  }
  if (round_ignore(dir)) {
    mpz_cdiv_q(to.get_mpz_t(), n, d);
    return V_LE;
  }
  if (round_down(dir)) {
    mpz_fdiv_q(to.get_mpz_t(), n, d);
    if (round_strict_relation(dir)) {
      return (mpz_divisible_p(n, d) != 0) ? V_EQ : V_GT;
    }
    return V_GE;
  }
  else {
    PPL_ASSERT(round_up(dir));
    mpz_cdiv_q(to.get_mpz_t(), n, d);
    if (round_strict_relation(dir)) {
      return (mpz_divisible_p(n, d) != 0) ? V_EQ : V_LT;
    }
    return V_LE;
  }
}

PPL_SPECIALIZE_DIV(div_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
idiv_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y,
        Rounding_Dir) {
  if (CHECK_P(To_Policy::check_div_zero, ::sgn(y) == 0)) {
    return assign_nan<To_Policy>(to, V_DIV_ZERO);
  }
  mpz_srcptr n = x.get_mpz_t();
  mpz_srcptr d = y.get_mpz_t();
  mpz_tdiv_q(to.get_mpz_t(), n, d);
  return V_EQ;
}

PPL_SPECIALIZE_IDIV(idiv_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
rem_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y, Rounding_Dir) {
  if (CHECK_P(To_Policy::check_div_zero, ::sgn(y) == 0)) {
    return assign_nan<To_Policy>(to, V_MOD_ZERO);
  }
  to = x % y;
  return V_EQ;
}

PPL_SPECIALIZE_REM(rem_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From_Policy>
inline Result
add_2exp_mpz(mpz_class& to, const mpz_class& x, unsigned int exp,
             Rounding_Dir) {
  PPL_DIRTY_TEMP(mpz_class, v);
  v = 1;
  mpz_mul_2exp(v.get_mpz_t(), v.get_mpz_t(), exp);
  to = x + v;
  return V_EQ;
}

PPL_SPECIALIZE_ADD_2EXP(add_2exp_mpz, mpz_class, mpz_class)

template <typename To_Policy, typename From_Policy>
inline Result
sub_2exp_mpz(mpz_class& to, const mpz_class& x, unsigned int exp,
             Rounding_Dir) {
  PPL_DIRTY_TEMP(mpz_class, v);
  v = 1;
  mpz_mul_2exp(v.get_mpz_t(), v.get_mpz_t(), exp);
  to = x - v;
  return V_EQ;
}

PPL_SPECIALIZE_SUB_2EXP(sub_2exp_mpz, mpz_class, mpz_class)

template <typename To_Policy, typename From_Policy>
inline Result
mul_2exp_mpz(mpz_class& to, const mpz_class& x, unsigned int exp,
             Rounding_Dir) {
  mpz_mul_2exp(to.get_mpz_t(), x.get_mpz_t(), exp);
  return V_EQ;
}

PPL_SPECIALIZE_MUL_2EXP(mul_2exp_mpz, mpz_class, mpz_class)

template <typename To_Policy, typename From_Policy>
inline Result
div_2exp_mpz(mpz_class& to, const mpz_class& x, unsigned int exp,
             Rounding_Dir dir) {
  const mpz_srcptr n = x.get_mpz_t();
  if (round_not_requested(dir)) {
    mpz_tdiv_q_2exp(to.get_mpz_t(), x.get_mpz_t(), exp);
    return V_LGE;
  }
  if (round_down(dir)) {
    mpz_fdiv_q_2exp(to.get_mpz_t(), n, exp);
    if (round_strict_relation(dir)) {
      return (mpz_divisible_2exp_p(n, exp) != 0) ? V_EQ : V_GT;
    }
    return V_GE;
  }
  else {
    PPL_ASSERT(round_up(dir));
    mpz_cdiv_q_2exp(to.get_mpz_t(), n, exp);
    if (round_strict_relation(dir)) {
      return (mpz_divisible_2exp_p(n, exp) != 0) ? V_EQ : V_LT;
    }
    return V_LE;
  }
}

PPL_SPECIALIZE_DIV_2EXP(div_2exp_mpz, mpz_class, mpz_class)

template <typename To_Policy, typename From_Policy>
inline Result
smod_2exp_mpz(mpz_class& to, const mpz_class& x, unsigned int exp,
              Rounding_Dir) {
  if (mpz_tstbit(x.get_mpz_t(), exp - 1) != 0) {
    mpz_cdiv_r_2exp(to.get_mpz_t(), x.get_mpz_t(), exp);
  }
  else {
    mpz_fdiv_r_2exp(to.get_mpz_t(), x.get_mpz_t(), exp);
  }
  return V_EQ;
}

PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_mpz, mpz_class, mpz_class)

template <typename To_Policy, typename From_Policy>
inline Result
umod_2exp_mpz(mpz_class& to, const mpz_class& x, unsigned int exp,
              Rounding_Dir) {
  mpz_fdiv_r_2exp(to.get_mpz_t(), x.get_mpz_t(), exp);
  return V_EQ;
}

PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_mpz, mpz_class, mpz_class)

template <typename To_Policy, typename From_Policy>
inline Result
abs_mpz(mpz_class& to, const mpz_class& from, Rounding_Dir) {
  to = abs(from);
  return V_EQ;
}

PPL_SPECIALIZE_ABS(abs_mpz, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
add_mul_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y,
            Rounding_Dir) {
  mpz_addmul(to.get_mpz_t(), x.get_mpz_t(), y.get_mpz_t());
  return V_EQ;
}

PPL_SPECIALIZE_ADD_MUL(add_mul_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
sub_mul_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y,
            Rounding_Dir) {
  mpz_submul(to.get_mpz_t(), x.get_mpz_t(), y.get_mpz_t());
  return V_EQ;
}

PPL_SPECIALIZE_SUB_MUL(sub_mul_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
gcd_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y, Rounding_Dir) {
  mpz_gcd(to.get_mpz_t(), x.get_mpz_t(), y.get_mpz_t());
  return V_EQ;
}

PPL_SPECIALIZE_GCD(gcd_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
gcdext_mpz(mpz_class& to, mpz_class& s, mpz_class& t,
           const mpz_class& x, const mpz_class& y,
           Rounding_Dir) {
  mpz_gcdext(to.get_mpz_t(), s.get_mpz_t(), t.get_mpz_t(),
             x.get_mpz_t(), y.get_mpz_t());
  return V_EQ;
}

PPL_SPECIALIZE_GCDEXT(gcdext_mpz, mpz_class, mpz_class, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
lcm_mpz(mpz_class& to, const mpz_class& x, const mpz_class& y, Rounding_Dir) {
  mpz_lcm(to.get_mpz_t(), x.get_mpz_t(), y.get_mpz_t());
  return V_EQ;
}

PPL_SPECIALIZE_LCM(lcm_mpz, mpz_class, mpz_class, mpz_class)

template <typename To_Policy, typename From_Policy>
inline Result
sqrt_mpz(mpz_class& to, const mpz_class& from, Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_sqrt_neg, from < 0)) {
    return assign_nan<To_Policy>(to, V_SQRT_NEG);
  }
  if (round_not_requested(dir)) {
    to = sqrt(from);
    return V_GE;
  }
  PPL_DIRTY_TEMP(mpz_class, r);
  mpz_sqrtrem(to.get_mpz_t(), r.get_mpz_t(), from.get_mpz_t());
  if (r == 0) {
    return V_EQ;
  }
  return round_gt_mpz<To_Policy>(to, dir);
}

PPL_SPECIALIZE_SQRT(sqrt_mpz, mpz_class, mpz_class)

template <typename Policy, typename Type>
inline Result_Relation
sgn_mp(const Type& x) {
  const int sign = ::sgn(x);
  return (sign > 0) ? VR_GT : ((sign < 0) ? VR_LT : VR_EQ);
}

PPL_SPECIALIZE_SGN(sgn_mp, mpz_class)
PPL_SPECIALIZE_SGN(sgn_mp, mpq_class)

template <typename Policy1, typename Policy2, typename Type>
inline Result_Relation
cmp_mp(const Type& x, const Type& y) {
  int i = ::cmp(x, y);
  return (i > 0) ? VR_GT : ((i < 0) ? VR_LT : VR_EQ);
}

PPL_SPECIALIZE_CMP(cmp_mp, mpz_class, mpz_class)
PPL_SPECIALIZE_CMP(cmp_mp, mpq_class, mpq_class)

template <typename Policy>
inline Result
output_mpz(std::ostream& os, const mpz_class& from, const Numeric_Format&,
           Rounding_Dir) {
  os << from;
  return V_EQ;
}

PPL_SPECIALIZE_INPUT(input_generic, mpz_class)
PPL_SPECIALIZE_OUTPUT(output_mpz, mpz_class)

} // namespace Checked

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/checked_mpq_inlines.hh line 1. */
/* Specialized "checked" functions for GMP's mpq_class numbers.
*/


#include <sstream>
#include <climits>
#include <stdexcept>

namespace Parma_Polyhedra_Library {

namespace Checked {

template <typename Policy>
inline Result
classify_mpq(const mpq_class& v, bool nan, bool inf, bool sign) {
  if ((Policy::has_nan || Policy::has_infinity)
      && ::sgn(v.get_den()) == 0) {
    int s = ::sgn(v.get_num());
    if (Policy::has_nan && (nan || sign) && s == 0) {
      return V_NAN;
    }
    if (!inf && !sign) {
      return V_LGE;
    }
    if (Policy::has_infinity) {
      if (s < 0) {
        return inf ? V_EQ_MINUS_INFINITY : V_LT;
      }
      if (s > 0) {
        return inf ? V_EQ_PLUS_INFINITY : V_GT;
      }
    }
  }
  if (sign) {
    return static_cast<Result>(sgn<Policy>(v));
  }
  return V_LGE;
}

PPL_SPECIALIZE_CLASSIFY(classify_mpq, mpq_class)

template <typename Policy>
inline bool
is_nan_mpq(const mpq_class& v) {
  return Policy::has_nan
    && ::sgn(v.get_den()) == 0
    && ::sgn(v.get_num()) == 0;
}

PPL_SPECIALIZE_IS_NAN(is_nan_mpq, mpq_class)

template <typename Policy>
inline bool
is_minf_mpq(const mpq_class& v) {
  return Policy::has_infinity
    && ::sgn(v.get_den()) == 0
    && ::sgn(v.get_num()) < 0;
}

PPL_SPECIALIZE_IS_MINF(is_minf_mpq, mpq_class)

template <typename Policy>
inline bool
is_pinf_mpq(const mpq_class& v) {
  return Policy::has_infinity
    && ::sgn(v.get_den()) == 0
    && ::sgn(v.get_num()) > 0;
}

PPL_SPECIALIZE_IS_PINF(is_pinf_mpq, mpq_class)

template <typename Policy>
inline bool
is_int_mpq(const mpq_class& v) {
  if ((Policy::has_infinity || Policy::has_nan)
      && ::sgn(v.get_den()) == 0) {
    return !(Policy::has_nan && ::sgn(v.get_num()) == 0);
  }
  else {
    return v.get_den() == 1;
  }
}

PPL_SPECIALIZE_IS_INT(is_int_mpq, mpq_class)

template <typename Policy>
inline Result
assign_special_mpq(mpq_class& v, Result_Class c, Rounding_Dir) {
  switch (c) {
  case VC_NAN:
    if (Policy::has_nan) {
      v.get_num() = 0;
      v.get_den() = 0;
      return V_NAN | V_UNREPRESENTABLE;
    }
    return V_NAN;
  case VC_MINUS_INFINITY:
    if (Policy::has_infinity) {
      v.get_num() = -1;
      v.get_den() = 0;
      return V_EQ_MINUS_INFINITY;
    }
    return V_EQ_MINUS_INFINITY | V_UNREPRESENTABLE;
  case VC_PLUS_INFINITY:
    if (Policy::has_infinity) {
      v.get_num() = 1;
      v.get_den() = 0;
      return V_EQ_PLUS_INFINITY;
    }
    return V_EQ_PLUS_INFINITY | V_UNREPRESENTABLE;
  default:
    PPL_UNREACHABLE;
    return V_NAN | V_UNREPRESENTABLE;
  }
}

PPL_SPECIALIZE_ASSIGN_SPECIAL(assign_special_mpq, mpq_class)

PPL_SPECIALIZE_COPY(copy_generic, mpq_class)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
construct_mpq_base(mpq_class& to, const From& from, Rounding_Dir) {
  new(&to) mpq_class(from);
  return V_EQ;
}

PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, mpz_class)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, char)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, signed char)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, signed short)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, signed int)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, signed long)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, unsigned char)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, unsigned short)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, unsigned int)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_base, mpq_class, unsigned long)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
construct_mpq_float(mpq_class& to, const From& from, Rounding_Dir dir) {
  if (is_nan<From_Policy>(from)) {
    return construct_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(from)) {
    return construct_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(from)) {
    return construct_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  new(&to) mpq_class(from);
  return V_EQ;
}

PPL_SPECIALIZE_CONSTRUCT(construct_mpq_float, mpq_class, float)
PPL_SPECIALIZE_CONSTRUCT(construct_mpq_float, mpq_class, double)

PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, mpq_class)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, mpz_class)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, char)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, signed char)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, signed short)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, signed int)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, signed long)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, unsigned char)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, unsigned short)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, unsigned int)
PPL_SPECIALIZE_ASSIGN(assign_exact, mpq_class, unsigned long)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
assign_mpq_float(mpq_class& to, const From& from, Rounding_Dir dir) {
  if (is_nan<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(from)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  assign_mpq_numeric_float(to, from);
  return V_EQ;
}

PPL_SPECIALIZE_ASSIGN(assign_mpq_float, mpq_class, float)
PPL_SPECIALIZE_ASSIGN(assign_mpq_float, mpq_class, double)
PPL_SPECIALIZE_ASSIGN(assign_mpq_float, mpq_class, long double)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
assign_mpq_signed_int(mpq_class& to, const From from, Rounding_Dir) {
  if (sizeof(From) <= sizeof(signed long)) {
    to = static_cast<signed long>(from);
  }
  else {
    mpz_ptr m = to.get_num().get_mpz_t();
    if (from >= 0) {
      mpz_import(m, 1, 1, sizeof(From), 0, 0, &from);
    }
    else {
      From n = -from;
      mpz_import(m, 1, 1, sizeof(From), 0, 0, &n);
      mpz_neg(m, m);
    }
    to.get_den() = 1;
  }
  return V_EQ;
}

PPL_SPECIALIZE_ASSIGN(assign_mpq_signed_int, mpq_class, signed long long)

template <typename To_Policy, typename From_Policy, typename From>
inline Result
assign_mpq_unsigned_int(mpq_class& to, const From from, Rounding_Dir) {
  if (sizeof(From) <= sizeof(unsigned long)) {
    to = static_cast<unsigned long>(from);
  }
  else {
    mpz_import(to.get_num().get_mpz_t(), 1, 1, sizeof(From), 0, 0, &from);
    to.get_den() = 1;
  }
  return V_EQ;
}

PPL_SPECIALIZE_ASSIGN(assign_mpq_unsigned_int, mpq_class, unsigned long long)

template <typename To_Policy, typename From_Policy>
inline Result
floor_mpq(mpq_class& to, const mpq_class& from, Rounding_Dir) {
  mpz_fdiv_q(to.get_num().get_mpz_t(),
             from.get_num().get_mpz_t(), from.get_den().get_mpz_t());
  to.get_den() = 1;
  return V_EQ;
}

PPL_SPECIALIZE_FLOOR(floor_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
ceil_mpq(mpq_class& to, const mpq_class& from, Rounding_Dir) {
  mpz_cdiv_q(to.get_num().get_mpz_t(),
             from.get_num().get_mpz_t(), from.get_den().get_mpz_t());
  to.get_den() = 1;
  return V_EQ;
}

PPL_SPECIALIZE_CEIL(ceil_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
trunc_mpq(mpq_class& to, const mpq_class& from, Rounding_Dir) {
  mpz_tdiv_q(to.get_num().get_mpz_t(),
             from.get_num().get_mpz_t(), from.get_den().get_mpz_t());
  to.get_den() = 1;
  return V_EQ;
}

PPL_SPECIALIZE_TRUNC(trunc_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
neg_mpq(mpq_class& to, const mpq_class& from, Rounding_Dir) {
  mpq_neg(to.get_mpq_t(), from.get_mpq_t());
  return V_EQ;
}

PPL_SPECIALIZE_NEG(neg_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
add_mpq(mpq_class& to, const mpq_class& x, const mpq_class& y, Rounding_Dir) {
  to = x + y;
  return V_EQ;
}

PPL_SPECIALIZE_ADD(add_mpq, mpq_class, mpq_class, mpq_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
sub_mpq(mpq_class& to, const mpq_class& x, const mpq_class& y, Rounding_Dir) {
  to = x - y;
  return V_EQ;
}

PPL_SPECIALIZE_SUB(sub_mpq, mpq_class, mpq_class, mpq_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
mul_mpq(mpq_class& to, const mpq_class& x, const mpq_class& y, Rounding_Dir) {
  to = x * y;
  return V_EQ;
}

PPL_SPECIALIZE_MUL(mul_mpq, mpq_class, mpq_class, mpq_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
div_mpq(mpq_class& to, const mpq_class& x, const mpq_class& y, Rounding_Dir) {
  if (CHECK_P(To_Policy::check_div_zero, sgn(y) == 0)) {
    return assign_nan<To_Policy>(to, V_DIV_ZERO);
  }
  to = x / y;
  return V_EQ;
}

PPL_SPECIALIZE_DIV(div_mpq, mpq_class, mpq_class, mpq_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
idiv_mpq(mpq_class& to, const mpq_class& x, const mpq_class& y, Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_div_zero, sgn(y) == 0)) {
    return assign_nan<To_Policy>(to, V_DIV_ZERO);
  }
  to = x / y;
  return trunc<To_Policy, To_Policy>(to, to, dir);
}

PPL_SPECIALIZE_IDIV(idiv_mpq, mpq_class, mpq_class, mpq_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
rem_mpq(mpq_class& to, const mpq_class& x, const mpq_class& y, Rounding_Dir) {
  if (CHECK_P(To_Policy::check_div_zero, sgn(y) == 0)) {
    return assign_nan<To_Policy>(to, V_MOD_ZERO);
  }
  PPL_DIRTY_TEMP(mpq_class, tmp);
  tmp = x / y;
  tmp.get_num() %= tmp.get_den();
  to = tmp * y;
  return V_EQ;
}

PPL_SPECIALIZE_REM(rem_mpq, mpq_class, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
add_2exp_mpq(mpq_class& to, const mpq_class& x, unsigned int exp,
             Rounding_Dir) {
  PPL_DIRTY_TEMP(mpz_class, v);
  v = 1;
  mpz_mul_2exp(v.get_mpz_t(), v.get_mpz_t(), exp);
  to = x + v;
  return V_EQ;
}

PPL_SPECIALIZE_ADD_2EXP(add_2exp_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
sub_2exp_mpq(mpq_class& to, const mpq_class& x, unsigned int exp,
             Rounding_Dir) {
  PPL_DIRTY_TEMP(mpz_class, v);
  v = 1;
  mpz_mul_2exp(v.get_mpz_t(), v.get_mpz_t(), exp);
  to = x - v;
  return V_EQ;
}

PPL_SPECIALIZE_SUB_2EXP(sub_2exp_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
mul_2exp_mpq(mpq_class& to, const mpq_class& x, unsigned int exp,
             Rounding_Dir) {
  mpz_mul_2exp(to.get_num().get_mpz_t(), x.get_num().get_mpz_t(), exp);
  to.get_den() = x.get_den();
  to.canonicalize();
  return V_EQ;
}

PPL_SPECIALIZE_MUL_2EXP(mul_2exp_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
div_2exp_mpq(mpq_class& to, const mpq_class& x, unsigned int exp,
             Rounding_Dir) {
  to.get_num() = x.get_num();
  mpz_mul_2exp(to.get_den().get_mpz_t(), x.get_den().get_mpz_t(), exp);
  to.canonicalize();
  return V_EQ;
}

PPL_SPECIALIZE_DIV_2EXP(div_2exp_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
smod_2exp_mpq(mpq_class& to, const mpq_class& x, unsigned int exp,
              Rounding_Dir) {
  mpz_mul_2exp(to.get_den().get_mpz_t(), x.get_den().get_mpz_t(), exp);
  mpz_fdiv_r(to.get_num().get_mpz_t(), x.get_num().get_mpz_t(), to.get_den().get_mpz_t());
  mpz_fdiv_q_2exp(to.get_den().get_mpz_t(), to.get_den().get_mpz_t(), 1);
  bool neg = to.get_num() >= to.get_den();
  mpz_mul_2exp(to.get_den().get_mpz_t(), to.get_den().get_mpz_t(), 1);
  if (neg) {
    to.get_num() -= to.get_den();
  }
  mpz_mul_2exp(to.get_num().get_mpz_t(), to.get_num().get_mpz_t(), exp);
  to.canonicalize();
  return V_EQ;
}

PPL_SPECIALIZE_SMOD_2EXP(smod_2exp_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
umod_2exp_mpq(mpq_class& to, const mpq_class& x, unsigned int exp,
              Rounding_Dir) {
  mpz_mul_2exp(to.get_den().get_mpz_t(), x.get_den().get_mpz_t(), exp);
  mpz_fdiv_r(to.get_num().get_mpz_t(), x.get_num().get_mpz_t(), to.get_den().get_mpz_t());
  mpz_mul_2exp(to.get_num().get_mpz_t(), to.get_num().get_mpz_t(), exp);
  to.canonicalize();
  return V_EQ;
}

PPL_SPECIALIZE_UMOD_2EXP(umod_2exp_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From_Policy>
inline Result
abs_mpq(mpq_class& to, const mpq_class& from, Rounding_Dir) {
  to = abs(from);
  return V_EQ;
}

PPL_SPECIALIZE_ABS(abs_mpq, mpq_class, mpq_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
add_mul_mpq(mpq_class& to, const mpq_class& x, const mpq_class& y,
            Rounding_Dir) {
  to += x * y;
  return V_EQ;
}

PPL_SPECIALIZE_ADD_MUL(add_mul_mpq, mpq_class, mpq_class, mpq_class)

template <typename To_Policy, typename From1_Policy, typename From2_Policy>
inline Result
sub_mul_mpq(mpq_class& to, const mpq_class& x, const mpq_class& y,
            Rounding_Dir) {
  to -= x * y;
  return V_EQ;
}

PPL_SPECIALIZE_SUB_MUL(sub_mul_mpq, mpq_class, mpq_class, mpq_class)

extern unsigned irrational_precision;

template <typename To_Policy, typename From_Policy>
inline Result
sqrt_mpq(mpq_class& to, const mpq_class& from, Rounding_Dir dir) {
  if (CHECK_P(To_Policy::check_sqrt_neg, from < 0)) {
    return assign_nan<To_Policy>(to, V_SQRT_NEG);
  }
  if (from == 0) {
    to = 0;
    return V_EQ;
  }
  bool gt1 = from.get_num() > from.get_den();
  const mpz_class& from_a = gt1 ? from.get_num() : from.get_den();
  const mpz_class& from_b = gt1 ? from.get_den() : from.get_num();
  mpz_class& to_a = gt1 ? to.get_num() : to.get_den();
  mpz_class& to_b = gt1 ? to.get_den() : to.get_num();
  Rounding_Dir rdir = gt1 ? dir : inverse(dir);
  mul_2exp<To_Policy, From_Policy>(to_a, from_a,
                                   2*irrational_precision, ROUND_IGNORE);
  Result r_div
    = div<To_Policy, To_Policy, To_Policy>(to_a, to_a, from_b, rdir);
  Result r_sqrt = sqrt<To_Policy, To_Policy>(to_a, to_a, rdir);
  to_b = 1;
  mul_2exp<To_Policy, To_Policy>(to_b, to_b,
                                 irrational_precision, ROUND_IGNORE);
  to.canonicalize();
  return (r_div != V_EQ) ? r_div : r_sqrt;
}

PPL_SPECIALIZE_SQRT(sqrt_mpq, mpq_class, mpq_class)

template <typename Policy>
inline Result
input_mpq(mpq_class& to, std::istream& is, Rounding_Dir dir) {
  Result r = input_mpq(to, is);
  Result_Class c = result_class(r);
  switch (c) {
  case VC_MINUS_INFINITY:
  case VC_PLUS_INFINITY:
    return assign_special<Policy>(to, c, dir);
  case VC_NAN:
    return assign_nan<Policy>(to, r);
  default:
    return r;
  }
}

PPL_SPECIALIZE_INPUT(input_mpq, mpq_class)

template <typename Policy>
inline Result
output_mpq(std::ostream& os,
           const mpq_class& from,
           const Numeric_Format&,
           Rounding_Dir) {
  os << from;
  return V_EQ;
}

PPL_SPECIALIZE_OUTPUT(output_mpq, mpq_class)

} // namespace Checked

//! Returns the precision parameter used for irrational calculations.
inline unsigned
irrational_precision() {
  return Checked::irrational_precision;
}

//! Sets the precision parameter used for irrational calculations.
/*! The lesser between numerator and denominator is limited to 2**\p p.

  If \p p is less than or equal to <CODE>INT_MAX</CODE>, sets the
  precision parameter used for irrational calculations to \p p.

  \exception std::invalid_argument
  Thrown if \p p is greater than <CODE>INT_MAX</CODE>.
*/
inline void
set_irrational_precision(const unsigned p) {
  if (p <= INT_MAX) {
    Checked::irrational_precision = p;
  }
  else {
    throw std::invalid_argument("PPL::set_irrational_precision(p)"
                                " with p > INT_MAX");
  }
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/checked_ext_inlines.hh line 1. */
/* Checked extended arithmetic functions.
*/


namespace Parma_Polyhedra_Library {

template <typename T> struct FPU_Related : public False {};
template <> struct FPU_Related<float> : public True {};
template <> struct FPU_Related<double> : public True {};
template <> struct FPU_Related<long double> : public True {};

namespace Checked {

template <typename T>
inline bool
handle_ext_natively(const T&) {
  return FPU_Related<T>::value;
}

template <typename Policy, typename Type>
inline bool
ext_to_handle(const Type& x) {
  return !handle_ext_natively(x)
    && (Policy::has_infinity || Policy::has_nan);
}

template <typename Policy, typename Type>
inline Result_Relation
sgn_ext(const Type& x) {
  if (!ext_to_handle<Policy>(x)) {
    goto native;
  }
  if (is_nan<Policy>(x)) {
    return VR_EMPTY;
  }
  else if (is_minf<Policy>(x)) {
    return VR_LT;
  }
  else if (is_pinf<Policy>(x)) {
    return VR_GT;
  }
  else {
  native:
    return sgn<Policy>(x);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
construct_ext(To& to, const From& x, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return construct_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return construct_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return construct_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return construct<To_Policy, From_Policy>(to, x, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
assign_ext(To& to, const From& x, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return assign<To_Policy, From_Policy>(to, x, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
neg_ext(To& to, const From& x, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else {
  native:
    return neg<To_Policy, From_Policy>(to, x, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
floor_ext(To& to, const From& x, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return floor<To_Policy, From_Policy>(to, x, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
ceil_ext(To& to, const From& x, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return ceil<To_Policy, From_Policy>(to, x, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
trunc_ext(To& to, const From& x, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return trunc<To_Policy, From_Policy>(to, x, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
abs_ext(To& to, const From& x, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x) || is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return abs<To_Policy, From_Policy>(to, x, dir);
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
add_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (!ext_to_handle<From1_Policy>(x) && !ext_to_handle<From2_Policy>(y)) {
    goto native;
  }
  if (is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From1_Policy>(x)) {
    if (CHECK_P(To_Policy::check_inf_add_inf, is_pinf<From2_Policy>(y))) {
      goto inf_add_inf;
    }
    else {
      goto minf;
    }
  }
  else if (is_pinf<From1_Policy>(x)) {
    if (CHECK_P(To_Policy::check_inf_add_inf, is_minf<From2_Policy>(y))) {
    inf_add_inf:
      return assign_nan<To_Policy>(to, V_INF_ADD_INF);
    }
    else {
      goto pinf;
    }
  }
  else {
    if (is_minf<From2_Policy>(y)) {
    minf:
      return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
    }
    else if (is_pinf<From2_Policy>(y)) {
    pinf:
      return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
    }
    else {
    native:
      return add<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
    }
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
sub_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (!ext_to_handle<From1_Policy>(x) && !ext_to_handle<From2_Policy>(y)) {
    goto native;
  }
  if (is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From1_Policy>(x)) {
    if (CHECK_P(To_Policy::check_inf_sub_inf, is_minf<From2_Policy>(y))) {
      goto inf_sub_inf;
    }
    else {
      goto minf;
    }
  }
  else if (is_pinf<From1_Policy>(x)) {
    if (CHECK_P(To_Policy::check_inf_sub_inf, is_pinf<From2_Policy>(y))) {
    inf_sub_inf:
      return assign_nan<To_Policy>(to, V_INF_SUB_INF);
    }
    else {
      goto pinf;
    }
  }
  else {
    if (is_pinf<From2_Policy>(y)) {
    minf:
      return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
    }
    else if (is_minf<From2_Policy>(y)) {
    pinf:
      return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
    }
    else {
    native:
      return sub<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
    }
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
mul_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (!ext_to_handle<From1_Policy>(x) && !ext_to_handle<From2_Policy>(y)) {
    goto native;
  }
  if (is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (is_minf<From1_Policy>(x)) {
    switch (sgn_ext<From2_Policy>(y)) {
    case VR_LT:
      goto pinf;
    case VR_GT:
      goto minf;
    default:
      goto inf_mul_zero;
    }
  }
  else if (is_pinf<From1_Policy>(x)) {
    switch (sgn_ext<From2_Policy>(y)) {
    case VR_LT:
      goto minf;
    case VR_GT:
      goto pinf;
    default:
      goto inf_mul_zero;
    }
  }
  else {
    if (is_minf<From2_Policy>(y)) {
      switch (sgn<From1_Policy>(x)) {
      case VR_LT:
        goto pinf;
      case VR_GT:
        goto minf;
      default:
        goto inf_mul_zero;
      }
    }
    else if (is_pinf<From2_Policy>(y)) {
      switch (sgn<From1_Policy>(x)) {
      case VR_LT:
      minf:
        return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
      case VR_GT:
      pinf:
        return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
      default:
      inf_mul_zero:
        PPL_ASSERT(To_Policy::check_inf_mul_zero);
        return assign_nan<To_Policy>(to, V_INF_MUL_ZERO);
      }
    }
    else {
    native:
      return mul<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
    }
  }
}


template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
add_mul_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (!ext_to_handle<To_Policy>(to)
      && !ext_to_handle<From1_Policy>(x) && !ext_to_handle<From2_Policy>(y)) {
    goto native;
  }
  if (is_nan<To_Policy>(to)
      || is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (is_minf<From1_Policy>(x)) {
    switch (sgn_ext<From2_Policy>(y)) {
    case VR_LT:
      goto a_pinf;
    case VR_GT:
      goto a_minf;
    default:
      goto inf_mul_zero;
    }
  }
  else if (is_pinf<From1_Policy>(x)) {
    switch (sgn_ext<From2_Policy>(y)) {
    case VR_LT:
      goto a_minf;
    case VR_GT:
      goto a_pinf;
    default:
      goto inf_mul_zero;
    }
  }
  else {
    if (is_minf<From2_Policy>(y)) {
      switch (sgn<From1_Policy>(x)) {
      case VR_LT:
        goto a_pinf;
      case VR_GT:
        goto a_minf;
      default:
        goto inf_mul_zero;
      }
    }
    else if (is_pinf<From2_Policy>(y)) {
      switch (sgn<From1_Policy>(x)) {
      case VR_LT:
      a_minf:
        if (CHECK_P(To_Policy::check_inf_add_inf, is_pinf<To_Policy>(to))) {
          goto inf_add_inf;
        }
        else {
          goto minf;
        }
      case VR_GT:
      a_pinf:
        if (CHECK_P(To_Policy::check_inf_add_inf, is_minf<To_Policy>(to))) {
        inf_add_inf:
          return assign_nan<To_Policy>(to, V_INF_ADD_INF);
        }
        else {
          goto pinf;
        }
      default:
      inf_mul_zero:
        PPL_ASSERT(To_Policy::check_inf_mul_zero);
        return assign_nan<To_Policy>(to, V_INF_MUL_ZERO);
      }
    }
    else {
      if (is_minf<To_Policy>(to)) {
      minf:
        return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
      }
      if (is_pinf<To_Policy>(to)) {
      pinf:
        return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
      }
    native:
      return add_mul<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
    }
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
sub_mul_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (!ext_to_handle<To_Policy>(to)
      && !ext_to_handle<From1_Policy>(x) && !ext_to_handle<From2_Policy>(y)) {
    goto native;
  }
  if (is_nan<To_Policy>(to)
      || is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (is_minf<From1_Policy>(x)) {
    switch (sgn_ext<From2_Policy>(y)) {
    case VR_LT:
      goto a_pinf;
    case VR_GT:
      goto a_minf;
    default:
      goto inf_mul_zero;
    }
  }
  else if (is_pinf<From1_Policy>(x)) {
    switch (sgn_ext<From2_Policy>(y)) {
    case VR_LT:
      goto a_minf;
    case VR_GT:
      goto a_pinf;
    default:
      goto inf_mul_zero;
    }
  }
  else {
    if (is_minf<From2_Policy>(y)) {
      switch (sgn<From1_Policy>(x)) {
      case VR_LT:
        goto a_pinf;
      case VR_GT:
        goto a_minf;
      default:
        goto inf_mul_zero;
      }
    }
    else if (is_pinf<From2_Policy>(y)) {
      switch (sgn<From1_Policy>(x)) {
      case VR_LT:
      a_minf:
        if (CHECK_P(To_Policy::check_inf_sub_inf, is_minf<To_Policy>(to))) {
          goto inf_sub_inf;
        }
        else {
          goto pinf;
        }
      case VR_GT:
      a_pinf:
        if (CHECK_P(To_Policy::check_inf_sub_inf, is_pinf<To_Policy>(to))) {
        inf_sub_inf:
          return assign_nan<To_Policy>(to, V_INF_SUB_INF);
        }
        else {
          goto minf;
        }
      default:
      inf_mul_zero:
        PPL_ASSERT(To_Policy::check_inf_mul_zero);
        return assign_nan<To_Policy>(to, V_INF_MUL_ZERO);
      }
    }
    else {
      if (is_minf<To_Policy>(to)) {
      minf:
        return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
      }
      if (is_pinf<To_Policy>(to)) {
      pinf:
        return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
      }
    native:
      return sub_mul<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
    }
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
div_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (!ext_to_handle<From1_Policy>(x) && !ext_to_handle<From2_Policy>(y)) {
    goto native;
  }
  if (is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (is_minf<From1_Policy>(x)) {
    if (CHECK_P(To_Policy::check_inf_div_inf, is_minf<From2_Policy>(y)
                || is_pinf<From2_Policy>(y))) {
      goto inf_div_inf;
    }
    else {
      switch (sgn<From2_Policy>(y)) {
      case VR_LT:
        goto pinf;
      case VR_GT:
        goto minf;
      default:
        goto div_zero;
      }
    }
  }
  else if (is_pinf<From1_Policy>(x)) {
    if (CHECK_P(To_Policy::check_inf_div_inf, is_minf<From2_Policy>(y)
                || is_pinf<From2_Policy>(y))) {
    inf_div_inf:
      return assign_nan<To_Policy>(to, V_INF_DIV_INF);
    }
    else {
      switch (sgn<From2_Policy>(y)) {
      case VR_LT:
      minf:
        return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
      case VR_GT:
      pinf:
        return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
      default:
      div_zero:
        PPL_ASSERT(To_Policy::check_div_zero);
        return assign_nan<To_Policy>(to, V_DIV_ZERO);
      }
    }
  }
  else {
    if (is_minf<From2_Policy>(y) || is_pinf<From2_Policy>(y)) {
      to = 0;
      return V_EQ;
    }
    else {
    native:
      return div<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
    }
  }
}


template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
idiv_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (!ext_to_handle<From1_Policy>(x) && !ext_to_handle<From2_Policy>(y)) {
    goto native;
  }
  if (is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  if (is_minf<From1_Policy>(x)) {
    if (CHECK_P(To_Policy::check_inf_div_inf, is_minf<From2_Policy>(y)
                || is_pinf<From2_Policy>(y))) {
      goto inf_div_inf;
    }
    else {
      switch (sgn<From2_Policy>(y)) {
      case VR_LT:
        goto pinf;
      case VR_GT:
        goto minf;
      default:
        goto div_zero;
      }
    }
  }
  else if (is_pinf<From1_Policy>(x)) {
    if (CHECK_P(To_Policy::check_inf_div_inf, is_minf<From2_Policy>(y)
                || is_pinf<From2_Policy>(y))) {
    inf_div_inf:
      return assign_nan<To_Policy>(to, V_INF_DIV_INF);
    }
    else {
      switch (sgn<From2_Policy>(y)) {
      case VR_LT:
      minf:
        return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
      case VR_GT:
      pinf:
        return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
      default:
      div_zero:
        PPL_ASSERT(To_Policy::check_div_zero);
        return assign_nan<To_Policy>(to, V_DIV_ZERO);
      }
    }
  }
  else {
    if (is_minf<From2_Policy>(y) || is_pinf<From2_Policy>(y)) {
      to = 0;
      return V_EQ;
    }
    else {
    native:
      return idiv<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
    }
  }
}


template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
rem_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (!ext_to_handle<From1_Policy>(x) && !ext_to_handle<From2_Policy>(y)) {
    goto native;
  }
  if (is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (CHECK_P(To_Policy::check_inf_mod, is_minf<From1_Policy>(x)
                   || is_pinf<From1_Policy>(x))) {
    return assign_nan<To_Policy>(to, V_INF_MOD);
  }
  else {
    if (is_minf<From1_Policy>(y) || is_pinf<From2_Policy>(y)) {
      to = x;
      return V_EQ;
    }
    else {
    native:
      return rem<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
    }
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
add_2exp_ext(To& to, const From& x, unsigned int exp, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return add_2exp<To_Policy, From_Policy>(to, x, exp, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
sub_2exp_ext(To& to, const From& x, unsigned int exp, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return sub_2exp<To_Policy, From_Policy>(to, x, exp, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
mul_2exp_ext(To& to, const From& x, unsigned int exp, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return mul_2exp<To_Policy, From_Policy>(to, x, exp, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
div_2exp_ext(To& to, const From& x, unsigned int exp, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_MINUS_INFINITY, dir);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return div_2exp<To_Policy, From_Policy>(to, x, exp, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
smod_2exp_ext(To& to, const From& x, unsigned int exp, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (CHECK_P(To_Policy::check_inf_mod, is_minf<From_Policy>(x)
                   || is_pinf<From_Policy>(x))) {
    return assign_nan<To_Policy>(to, V_INF_MOD);
  }
  else {
  native:
    return smod_2exp<To_Policy, From_Policy>(to, x, exp, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
umod_2exp_ext(To& to, const From& x, unsigned int exp, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (CHECK_P(To_Policy::check_inf_mod, is_minf<From_Policy>(x)
                   || is_pinf<From_Policy>(x))) {
    return assign_nan<To_Policy>(to, V_INF_MOD);
  }
  else {
  native:
    return umod_2exp<To_Policy, From_Policy>(to, x, exp, dir);
  }
}

template <typename To_Policy, typename From_Policy,
          typename To, typename From>
inline Result
sqrt_ext(To& to, const From& x, Rounding_Dir dir) {
  if (!ext_to_handle<From_Policy>(x)) {
    goto native;
  }
  if (is_nan<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From_Policy>(x)) {
    return assign_nan<To_Policy>(to, V_SQRT_NEG);
  }
  else if (is_pinf<From_Policy>(x)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
  native:
    return sqrt<To_Policy, From_Policy>(to, x, dir);
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
gcd_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From1_Policy>(x) || is_pinf<From1_Policy>(x)) {
    return abs_ext<To_Policy, From2_Policy>(to, y, dir);
  }
  else if (is_minf<From2_Policy>(y) || is_pinf<From2_Policy>(y)) {
    return abs_ext<To_Policy, From1_Policy>(to, x, dir);
  }
  else {
    return gcd<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
  }
}

template <typename To1_Policy, typename To2_Policy, typename To3_Policy,
          typename From1_Policy, typename From2_Policy,
          typename To1, typename To2, typename To3,
          typename From1, typename From2>
inline Result
gcdext_ext(To1& to, To2& s, To3& t, const From1& x, const From2& y,
           Rounding_Dir dir) {
  if (is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To1_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From1_Policy>(x) || is_pinf<From1_Policy>(x)) {
    s = 0;
    t = y > 0 ? -1 : 1;
    return abs_ext<To1_Policy, From2_Policy>(to, y, dir);
  }
  else if (is_minf<From2_Policy>(y) || is_pinf<From2_Policy>(y)) {
    s = x > 0 ? -1 : 1;
    t = 0;
    return abs_ext<To1_Policy, From1_Policy>(to, x, dir);
  }
  else {
    return gcdext<To1_Policy, To2_Policy, To3_Policy, From1_Policy, From2_Policy>(to, s, t, x, y, dir);
  }
}

template <typename To_Policy, typename From1_Policy, typename From2_Policy,
          typename To, typename From1, typename From2>
inline Result
lcm_ext(To& to, const From1& x, const From2& y, Rounding_Dir dir) {
  if (is_nan<From1_Policy>(x) || is_nan<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_NAN, ROUND_IGNORE);
  }
  else if (is_minf<From1_Policy>(x) || is_pinf<From1_Policy>(x)
           || is_minf<From2_Policy>(y) || is_pinf<From2_Policy>(y)) {
    return assign_special<To_Policy>(to, VC_PLUS_INFINITY, dir);
  }
  else {
    return lcm<To_Policy, From1_Policy, From2_Policy>(to, x, y, dir);
  }
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline Result_Relation
cmp_ext(const Type1& x, const Type2& y) {
  if (!ext_to_handle<Policy1>(x) && !ext_to_handle<Policy2>(y)) {
    goto native;
  }
  if (is_nan<Policy1>(x) || is_nan<Policy2>(y)) {
    return VR_EMPTY;
  }
  else if (is_minf<Policy1>(x)) {
    return is_minf<Policy2>(y) ? VR_EQ : VR_LT;
  }
  else if (is_pinf<Policy1>(x)) {
    return is_pinf<Policy2>(y) ? VR_EQ : VR_GT;
  }
  else {
    if (is_minf<Policy2>(y)) {
      return VR_GT;
    }
    if (is_pinf<Policy2>(y)) {
      return VR_LT;
    }
  native:
    return cmp<Policy1, Policy2>(x, y);
  }
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline bool
lt_ext(const Type1& x, const Type2& y) {
  if (!ext_to_handle<Policy1>(x) && !ext_to_handle<Policy2>(y)) {
    goto native;
  }
  if (is_nan<Policy1>(x) || is_nan<Policy2>(y)) {
    return false;
  }
  if (is_pinf<Policy1>(x) || is_minf<Policy2>(y)) {
    return false;
  }
  if (is_minf<Policy1>(x) || is_pinf<Policy2>(y)) {
    return true;
  }
 native:
  return lt_p<Policy1, Policy2>(x, y);
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline bool
gt_ext(const Type1& x, const Type2& y) {
  return lt_ext<Policy1, Policy2>(y, x);
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline bool
le_ext(const Type1& x, const Type2& y) {
  if (!ext_to_handle<Policy1>(x) && !ext_to_handle<Policy2>(y)) {
    goto native;
  }
  if (is_nan<Policy1>(x) || is_nan<Policy2>(y)) {
    return false;
  }
  if (is_minf<Policy1>(x) || is_pinf<Policy2>(y)) {
    return true;
  }
  if (is_pinf<Policy1>(x) || is_minf<Policy2>(y)) {
    return false;
  }
 native:
  return le_p<Policy1, Policy2>(x, y);
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline bool
ge_ext(const Type1& x, const Type2& y) {
  return le_ext<Policy1, Policy2>(y, x);
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline bool
eq_ext(const Type1& x, const Type2& y) {
  if (!ext_to_handle<Policy1>(x) && !ext_to_handle<Policy2>(y)) {
    goto native;
  }
  if (is_nan<Policy1>(x) || is_nan<Policy2>(y)) {
    return false;
  }
  if (is_minf<Policy1>(x)) {
    return is_minf<Policy2>(y);
  }
  if (is_pinf<Policy1>(x)) {
    return is_pinf<Policy2>(y);
  }
  else if (is_minf<Policy2>(y) || is_pinf<Policy2>(y)) {
    return false;
  }
 native:
  return eq_p<Policy1, Policy2>(x, y);
}

template <typename Policy1, typename Policy2,
          typename Type1, typename Type2>
inline bool
ne_ext(const Type1& x, const Type2& y) {
  return !eq_ext<Policy1, Policy2>(x, y);
}

template <typename Policy, typename Type>
inline Result
output_ext(std::ostream& os, const Type& x,
           const Numeric_Format& format, Rounding_Dir dir) {
  if (!ext_to_handle<Policy>(x)) {
    goto native;
  }
  if (is_nan<Policy>(x)) {
    os << "nan";
    return V_NAN;
  }
  if (is_minf<Policy>(x)) {
    os << "-inf";
    return V_EQ;
  }
  if (is_pinf<Policy>(x)) {
    os << "+inf";
    return V_EQ;
  }
 native:
  return output<Policy>(os, x, format, dir);
}

template <typename To_Policy, typename To>
inline Result
input_ext(To& to, std::istream& is, Rounding_Dir dir) {
  return input<To_Policy>(to, is, dir);
}

} // namespace Checked

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/checked_defs.hh line 706. */

#undef nonconst
#ifdef PPL_SAVED_nonconst
#define nonconst PPL_SAVED_nonconst
#undef PPL_SAVED_nonconst
#endif

#undef PPL_FUNCTION_CLASS
#undef PPL_NAN

/* Automatically generated from PPL source file ../src/Checked_Number_defs.hh line 31. */
#include <iosfwd>

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
struct Extended_Number_Policy {
  const_bool_nodef(check_overflow, true);
  const_bool_nodef(check_inf_add_inf, false);
  const_bool_nodef(check_inf_sub_inf, false);
  const_bool_nodef(check_inf_mul_zero, false);
  const_bool_nodef(check_div_zero, false);
  const_bool_nodef(check_inf_div_inf, false);
  const_bool_nodef(check_inf_mod, false);
  const_bool_nodef(check_sqrt_neg, false);
  const_bool_nodef(has_nan, true);
  const_bool_nodef(has_infinity, true);

  // `convertible' is intentionally not defined: the compile time
  // error on conversions is the expected behavior.

  const_bool_nodef(fpu_check_inexact, true);
  const_bool_nodef(fpu_check_nan_result, true);

  // ROUND_DEFAULT_CONSTRUCTOR is intentionally not defined.
  // ROUND_DEFAULT_OPERATOR is intentionally not defined.
  // ROUND_DEFAULT_FUNCTION is intentionally not defined.
  // ROUND_DEFAULT_INPUT is intentionally not defined.
  // ROUND_DEFAULT_OUTPUT is intentionally not defined.

  static void handle_result(Result r);
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! A policy checking for overflows.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Check_Overflow_Policy {
  const_bool_nodef(check_overflow, true);
  const_bool_nodef(check_inf_add_inf, false);
  const_bool_nodef(check_inf_sub_inf, false);
  const_bool_nodef(check_inf_mul_zero, false);
  const_bool_nodef(check_div_zero, false);
  const_bool_nodef(check_inf_div_inf, false);
  const_bool_nodef(check_inf_mod, false);
  const_bool_nodef(check_sqrt_neg, false);
  const_bool_nodef(has_nan, std::numeric_limits<T>::has_quiet_NaN);
  const_bool_nodef(has_infinity, std::numeric_limits<T>::has_infinity);
  const_bool_nodef(convertible, true);
  const_bool_nodef(fpu_check_inexact, true);
  const_bool_nodef(fpu_check_nan_result, true);
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T, typename Enable = void>
struct Native_Checked_From_Wrapper;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Native_Checked_From_Wrapper<T, typename Enable_If<Is_Native<T>::value>::type> {
  typedef Checked_Number_Transparent_Policy<T> Policy;
  static const T& raw_value(const T& v) {
    return v;
  }
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T, typename P>
struct Native_Checked_From_Wrapper<Checked_Number<T, P> > {
  typedef P Policy;
  static const T& raw_value(const Checked_Number<T, P>& v) {
    return v.raw_value();
  }
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T, typename Enable = void>
struct Native_Checked_To_Wrapper;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Native_Checked_To_Wrapper<T, typename Enable_If<Is_Native<T>::value>::type> {
  typedef Check_Overflow_Policy<T> Policy;
  static T& raw_value(T& v) {
    return v;
  }
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T, typename P>
struct Native_Checked_To_Wrapper<Checked_Number<T, P> > {
  typedef P Policy;
  static T& raw_value(Checked_Number<T, P>& v) {
    return v.raw_value();
  }
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Is_Checked : public False { };

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T, typename P>
struct Is_Checked<Checked_Number<T, P> > : public True { };

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Is_Native_Or_Checked
  : public Bool<Is_Native<T>::value || Is_Checked<T>::value> { };

//! A wrapper for numeric types implementing a given policy.
/*! \ingroup PPL_CXX_interface
  The wrapper and related functions implement an interface which is common
  to all kinds of coefficient types, therefore allowing for a uniform
  coding style. This class also implements the policy encoded by the
  second template parameter. The default policy is to perform the detection
  of overflow errors.
*/
template <typename T, typename Policy>
class Checked_Number {
public:

  //! \name Constructors
  //@{

  //! Default constructor.
  Checked_Number();

  //! Copy constructor.
  Checked_Number(const Checked_Number& y);

  //! Direct initialization from a Checked_Number and rounding mode.
  template <typename From, typename From_Policy>
  Checked_Number(const Checked_Number<From, From_Policy>& y, Rounding_Dir dir);

  //! Direct initialization from a plain char and rounding mode.
  Checked_Number(char y, Rounding_Dir dir);

  //! Direct initialization from a signed char and rounding mode.
  Checked_Number(signed char y, Rounding_Dir dir);

  //! Direct initialization from a signed short and rounding mode.
  Checked_Number(signed short y, Rounding_Dir dir);

  //! Direct initialization from a signed int and rounding mode.
  Checked_Number(signed int y, Rounding_Dir dir);

  //! Direct initialization from a signed long and rounding mode.
  Checked_Number(signed long y, Rounding_Dir dir);

  //! Direct initialization from a signed long long and rounding mode.
  Checked_Number(signed long long y, Rounding_Dir dir);

  //! Direct initialization from an unsigned char and rounding mode.
  Checked_Number(unsigned char y, Rounding_Dir dir);

  //! Direct initialization from an unsigned short and rounding mode.
  Checked_Number(unsigned short y, Rounding_Dir dir);

  //! Direct initialization from an unsigned int and rounding mode.
  Checked_Number(unsigned int y, Rounding_Dir dir);

  //! Direct initialization from an unsigned long and rounding mode.
  Checked_Number(unsigned long y, Rounding_Dir dir);

  //! Direct initialization from an unsigned long long and rounding mode.
  Checked_Number(unsigned long long y, Rounding_Dir dir);

#if PPL_SUPPORTED_FLOAT
  //! Direct initialization from a float and rounding mode.
  Checked_Number(float y, Rounding_Dir dir);
#endif

#if PPL_SUPPORTED_DOUBLE
  //! Direct initialization from a double and rounding mode.
  Checked_Number(double y, Rounding_Dir dir);
#endif

#if PPL_SUPPORTED_LONG_DOUBLE
  //! Direct initialization from a long double and rounding mode.
  Checked_Number(long double y, Rounding_Dir dir);
#endif

  //! Direct initialization from a rational and rounding mode.
  Checked_Number(const mpq_class& y, Rounding_Dir dir);

  //! Direct initialization from an unbounded integer and rounding mode.
  Checked_Number(const mpz_class& y, Rounding_Dir dir);

  //! Direct initialization from a C string and rounding mode.
  Checked_Number(const char* y, Rounding_Dir dir);

  //! Direct initialization from special and rounding mode.
  template <typename From>
  Checked_Number(const From&, Rounding_Dir dir,
                 typename Enable_If<Is_Special<From>::value, bool>::type
                 ignored = false);

  //! Direct initialization from a Checked_Number, default rounding mode.
  template <typename From, typename From_Policy>
  explicit Checked_Number(const Checked_Number<From, From_Policy>& y);

  //! Direct initialization from a plain char, default rounding mode.
  Checked_Number(char y);

  //! Direct initialization from a signed char, default rounding mode.
  Checked_Number(signed char y);

  //! Direct initialization from a signed short, default rounding mode.
  Checked_Number(signed short y);

  //! Direct initialization from a signed int, default rounding mode.
  Checked_Number(signed int y);

  //! Direct initialization from a signed long, default rounding mode.
  Checked_Number(signed long y);

  //! Direct initialization from a signed long long, default rounding mode.
  Checked_Number(signed long long y);

  //! Direct initialization from an unsigned char, default rounding mode.
  Checked_Number(unsigned char y);

  //! Direct initialization from an unsigned short, default rounding mode.
  Checked_Number(unsigned short y);

  //! Direct initialization from an unsigned int, default rounding mode.
  Checked_Number(unsigned int y);

  //! Direct initialization from an unsigned long, default rounding mode.
  Checked_Number(unsigned long y);

  //! Direct initialization from an unsigned long long, default rounding mode.
  Checked_Number(unsigned long long y);

  //! Direct initialization from a float, default rounding mode.
  Checked_Number(float y);

  //! Direct initialization from a double, default rounding mode.
  Checked_Number(double y);

  //! Direct initialization from a long double, default rounding mode.
  Checked_Number(long double y);

  //! Direct initialization from a rational, default rounding mode.
  Checked_Number(const mpq_class& y);

  //! Direct initialization from an unbounded integer, default rounding mode.
  Checked_Number(const mpz_class& y);

  //! Direct initialization from a C string, default rounding mode.
  Checked_Number(const char* y);

  //! Direct initialization from special, default rounding mode
  template <typename From>
  Checked_Number(const From&, typename Enable_If<Is_Special<From>::value, bool>::type ignored = false);


  //@} // Constructors

  //! \name Accessors and Conversions
  //@{

  //! Conversion operator: returns a copy of the underlying numeric value.
  operator T() const;

  //! Returns a reference to the underlying numeric value.
  T& raw_value();

  //! Returns a const reference to the underlying numeric value.
  const T& raw_value() const;

  //@} // Accessors and Conversions

  //! Checks if all the invariants are satisfied.
  bool OK() const;

  //! Classifies *this.
  /*!
    Returns the appropriate Result characterizing:
    - whether \p *this is NaN,
      if \p nan is <CODE>true</CODE>;
    - whether \p *this is a (positive or negative) infinity,
      if \p inf is <CODE>true</CODE>;
    - the sign of \p *this,
      if \p sign is <CODE>true</CODE>.
  */
  Result classify(bool nan = true, bool inf = true, bool sign = true) const;

  //! \name Assignment Operators
  //@{

  //! Assignment operator.
  Checked_Number& operator=(const Checked_Number& y);

  //! Assignment operator.
  template <typename From>
  Checked_Number& operator=(const From& y);

  //! Add and assign operator.
  template <typename From_Policy>
  Checked_Number& operator+=(const Checked_Number<T, From_Policy>& y);

  //! Add and assign operator.
  Checked_Number& operator+=(const T& y);

  //! Add and assign operator.
  template <typename From>
  typename Enable_If<Is_Native_Or_Checked<From>::value,
                     Checked_Number<T, Policy>&>::type
  operator+=(const From& y);

  //! Subtract and assign operator.
  template <typename From_Policy>
  Checked_Number& operator-=(const Checked_Number<T, From_Policy>& y);

  //! Subtract and assign operator.
  Checked_Number& operator-=(const T& y);

  //! Subtract and assign operator.
  template <typename From>
  typename Enable_If<Is_Native_Or_Checked<From>::value,
                     Checked_Number<T, Policy>&>::type
  operator-=(const From& y);

  //! Multiply and assign operator.
  template <typename From_Policy>
  Checked_Number& operator*=(const Checked_Number<T, From_Policy>& y);

  //! Multiply and assign operator.
  Checked_Number& operator*=(const T& y);

  //! Multiply and assign operator.
  template <typename From>
  typename Enable_If<Is_Native_Or_Checked<From>::value,
                     Checked_Number<T, Policy>&>::type
  operator*=(const From& y);

  //! Divide and assign operator.
  template <typename From_Policy>
  Checked_Number& operator/=(const Checked_Number<T, From_Policy>& y);

  //! Divide and assign operator.
  Checked_Number& operator/=(const T& y);

  //! Divide and assign operator.
  template <typename From>
  typename Enable_If<Is_Native_Or_Checked<From>::value,
                     Checked_Number<T, Policy>&>::type
  operator/=(const From& y);

  //! Compute remainder and assign operator.
  template <typename From_Policy>
  Checked_Number& operator%=(const Checked_Number<T, From_Policy>& y);

  //! Compute remainder and assign operator.
  Checked_Number& operator%=(const T& y);

  //! Compute remainder and assign operator.
  template <typename From>
  typename Enable_If<Is_Native_Or_Checked<From>::value,
                     Checked_Number<T, Policy>& >::type
  operator%=(const From& y);

  //@} // Assignment Operators


  //! \name Increment and Decrement Operators
  //@{

  //! Pre-increment operator.
  Checked_Number& operator++();

  //! Post-increment operator.
  Checked_Number  operator++(int);

  //! Pre-decrement operator.
  Checked_Number& operator--();

  //! Post-decrement operator.
  Checked_Number  operator--(int);

  //@} // Increment and Decrement Operators

private:
  //! The underlying numeric value.
  T v;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T, typename P>
struct Slow_Copy<Checked_Number<T, P> > : public Bool<Slow_Copy<T>::value> {};

/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_not_a_number(const T& x);

/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_minus_infinity(const T& x);

/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_plus_infinity(const T& x);

/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, int>::type
infinity_sign(const T& x);

/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_integer(const T& x);

/*! \relates Checked_Number */
template <typename To, typename From>
typename Enable_If<Is_Native_Or_Checked<To>::value && Is_Special<From>::value, Result>::type
construct(To& to, const From& x, Rounding_Dir dir);

/*! \relates Checked_Number */
template <typename To, typename From>
typename Enable_If<Is_Native_Or_Checked<To>::value && Is_Special<From>::value, Result>::type
assign_r(To& to, const From& x, Rounding_Dir dir);

/*! \relates Checked_Number */
template <typename To>
typename Enable_If<Is_Native_Or_Checked<To>::value, Result>::type
assign_r(To& to, const char* x, Rounding_Dir dir);

/*! \relates Checked_Number */
template <typename To, typename To_Policy>
typename Enable_If<Is_Native_Or_Checked<To>::value, Result>::type
assign_r(To& to, char* x, Rounding_Dir dir);

#define PPL_DECLARE_FUNC1_A(name) \
template <typename To, typename From> \
typename Enable_If<Is_Native_Or_Checked<To>::value \
                   && Is_Native_Or_Checked<From>::value, \
                   Result>::type \
 PPL_U(name)(To& to, const From& x, Rounding_Dir dir);

PPL_DECLARE_FUNC1_A(assign_r)
PPL_DECLARE_FUNC1_A(floor_assign_r)
PPL_DECLARE_FUNC1_A(ceil_assign_r)
PPL_DECLARE_FUNC1_A(trunc_assign_r)
PPL_DECLARE_FUNC1_A(neg_assign_r)
PPL_DECLARE_FUNC1_A(abs_assign_r)
PPL_DECLARE_FUNC1_A(sqrt_assign_r)

#undef PPL_DECLARE_FUNC1_A

#define PPL_DECLARE_FUNC1_B(name) \
template <typename To, typename From> \
typename Enable_If<Is_Native_Or_Checked<To>::value \
                   && Is_Native_Or_Checked<From>::value, \
                   Result>::type \
 PPL_U(name)(To& to, const From& x, unsigned int exp, Rounding_Dir dir);

PPL_DECLARE_FUNC1_B(add_2exp_assign_r)
PPL_DECLARE_FUNC1_B(sub_2exp_assign_r)
PPL_DECLARE_FUNC1_B(mul_2exp_assign_r)
PPL_DECLARE_FUNC1_B(div_2exp_assign_r)
PPL_DECLARE_FUNC1_B(smod_2exp_assign_r)
PPL_DECLARE_FUNC1_B(umod_2exp_assign_r)

#undef PPL_DECLARE_FUNC1_B

#define PPL_DECLARE_FUNC2(name) \
template <typename To, typename From1, typename From2> \
typename Enable_If<Is_Native_Or_Checked<To>::value \
                   && Is_Native_Or_Checked<From1>::value \
                   && Is_Native_Or_Checked<From2>::value, \
                   Result>::type \
 PPL_U(name)(To& to, const From1& x, const From2& y, Rounding_Dir dir);

PPL_DECLARE_FUNC2(add_assign_r)
PPL_DECLARE_FUNC2(sub_assign_r)
PPL_DECLARE_FUNC2(mul_assign_r)
PPL_DECLARE_FUNC2(div_assign_r)
PPL_DECLARE_FUNC2(idiv_assign_r)
PPL_DECLARE_FUNC2(rem_assign_r)
PPL_DECLARE_FUNC2(gcd_assign_r)
PPL_DECLARE_FUNC2(lcm_assign_r)
PPL_DECLARE_FUNC2(add_mul_assign_r)
PPL_DECLARE_FUNC2(sub_mul_assign_r)

#undef PPL_DECLARE_FUNC2

#define PPL_DECLARE_FUNC4(name) \
template <typename To1, typename To2, typename To3, \
          typename From1, typename From2> \
typename Enable_If<Is_Native_Or_Checked<To1>::value \
                   && Is_Native_Or_Checked<To2>::value \
                   && Is_Native_Or_Checked<To3>::value \
                   && Is_Native_Or_Checked<From1>::value \
                   && Is_Native_Or_Checked<From2>::value, \
                   Result>::type \
 PPL_U(name)(To1& to, To2& s, To3& t,     \
     const From1& x, const From2& y, \
     Rounding_Dir dir);

PPL_DECLARE_FUNC4(gcdext_assign_r)

#undef PPL_DECLARE_FUNC4

//! \name Accessor Functions
//@{

//@} // Accessor Functions

//! \name Memory Size Inspection Functions
//@{

//! Returns the total size in bytes of the memory occupied by \p x.
/*! \relates Checked_Number */
template <typename T, typename Policy>
memory_size_type
total_memory_in_bytes(const Checked_Number<T, Policy>& x);

//! Returns the size in bytes of the memory managed by \p x.
/*! \relates Checked_Number */
template <typename T, typename Policy>
memory_size_type
external_memory_in_bytes(const Checked_Number<T, Policy>& x);

//@} // Memory Size Inspection Functions

//! \name Arithmetic Operators
//@{

//! Unary plus operator.
/*! \relates Checked_Number */
template <typename T, typename Policy>
Checked_Number<T, Policy>
operator+(const Checked_Number<T, Policy>& x);

//! Unary minus operator.
/*! \relates Checked_Number */
template <typename T, typename Policy>
Checked_Number<T, Policy>
operator-(const Checked_Number<T, Policy>& x);

//! Assigns to \p x largest integral value not greater than \p x.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
floor_assign(Checked_Number<T, Policy>& x);

//! Assigns to \p x largest integral value not greater than \p y.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
floor_assign(Checked_Number<T, Policy>& x, const Checked_Number<T, Policy>& y);

//! Assigns to \p x smallest integral value not less than \p x.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
ceil_assign(Checked_Number<T, Policy>& x);

//! Assigns to \p x smallest integral value not less than \p y.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
ceil_assign(Checked_Number<T, Policy>& x, const Checked_Number<T, Policy>& y);

//! Round \p x to the nearest integer not larger in absolute value.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
trunc_assign(Checked_Number<T, Policy>& x);

//! Assigns to \p x the value of \p y rounded to the nearest integer not larger in absolute value.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
trunc_assign(Checked_Number<T, Policy>& x, const Checked_Number<T, Policy>& y);

//! Assigns to \p x its negation.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
neg_assign(Checked_Number<T, Policy>& x);

//! Assigns to \p x the negation of \p y.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
neg_assign(Checked_Number<T, Policy>& x, const Checked_Number<T, Policy>& y);

//! Assigns to \p x its absolute value.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
abs_assign(Checked_Number<T, Policy>& x);

//! Assigns to \p x the absolute value of \p y.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
abs_assign(Checked_Number<T, Policy>& x, const Checked_Number<T, Policy>& y);

//! Assigns to \p x the value <CODE>x + y * z</CODE>.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
add_mul_assign(Checked_Number<T, Policy>& x,
               const Checked_Number<T, Policy>& y,
               const Checked_Number<T, Policy>& z);

//! Assigns to \p x the value <CODE>x - y * z</CODE>.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
sub_mul_assign(Checked_Number<T, Policy>& x,
               const Checked_Number<T, Policy>& y,
               const Checked_Number<T, Policy>& z);

//! Assigns to \p x the greatest common divisor of \p y and \p z.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
gcd_assign(Checked_Number<T, Policy>& x,
           const Checked_Number<T, Policy>& y,
           const Checked_Number<T, Policy>& z);

/*! \brief
  Assigns to \p x the greatest common divisor of \p y and \p z,
  setting \p s and \p t such that s*y + t*z = x = gcd(y, z).
*/
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
gcdext_assign(Checked_Number<T, Policy>& x,
              Checked_Number<T, Policy>& s,
              Checked_Number<T, Policy>& t,
              const Checked_Number<T, Policy>& y,
              const Checked_Number<T, Policy>& z);

//! Assigns to \p x the least common multiple of \p y and \p z.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
lcm_assign(Checked_Number<T, Policy>& x,
           const Checked_Number<T, Policy>& y,
           const Checked_Number<T, Policy>& z);

//! Assigns to \p x the value \f$ y \cdot 2^\mathtt{exp} \f$.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
mul_2exp_assign(Checked_Number<T, Policy>& x,
                const Checked_Number<T, Policy>& y,
                unsigned int exp);

//! Assigns to \p x the value \f$ y / 2^\mathtt{exp} \f$.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void
div_2exp_assign(Checked_Number<T, Policy>& x,
                const Checked_Number<T, Policy>& y,
                unsigned int exp);

/*! \brief
  If \p z divides \p y, assigns to \p x the quotient of the integer
  division of \p y and \p z.

  \relates Checked_Number
  The behavior is undefined if \p z does not divide \p y.
*/
template <typename T, typename Policy>
void
exact_div_assign(Checked_Number<T, Policy>& x,
                 const Checked_Number<T, Policy>& y,
                 const Checked_Number<T, Policy>& z);

//! Assigns to \p x the integer square root of \p y.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void sqrt_assign(Checked_Number<T, Policy>& x,
                 const Checked_Number<T, Policy>& y);

//@} // Arithmetic Operators


//! \name Relational Operators and Comparison Functions
//@{

//! Equality operator.
/*! \relates Checked_Number */
template <typename T1, typename T2>
inline
typename Enable_If<Is_Native_Or_Checked<T1>::value
                   && Is_Native_Or_Checked<T2>::value
                   && (Is_Checked<T1>::value || Is_Checked<T2>::value),
                   bool>::type
operator==(const T1& x, const T2& y);

/*! \relates Checked_Number */
template <typename T1, typename T2>
inline typename Enable_If<Is_Native_Or_Checked<T1>::value
                          && Is_Native_Or_Checked<T2>::value,
                          bool>::type
equal(const T1& x, const T2& y);

//! Disequality operator.
/*! \relates Checked_Number */
template <typename T1, typename T2>
inline
typename Enable_If<Is_Native_Or_Checked<T1>::value
                   && Is_Native_Or_Checked<T2>::value
                   && (Is_Checked<T1>::value || Is_Checked<T2>::value),
                   bool>::type
operator!=(const T1& x, const T2& y);

/*! \relates Checked_Number */
template <typename T1, typename T2>
inline typename Enable_If<Is_Native_Or_Checked<T1>::value
                          && Is_Native_Or_Checked<T2>::value,
                          bool>::type
not_equal(const T1& x, const T2& y);

//! Greater than or equal to operator.
/*! \relates Checked_Number */
template <typename T1, typename T2>
inline
typename Enable_If<Is_Native_Or_Checked<T1>::value
                   && Is_Native_Or_Checked<T2>::value
                   && (Is_Checked<T1>::value || Is_Checked<T2>::value),
                   bool>::type
operator>=(const T1& x, const T2& y);

/*! \relates Checked_Number */
template <typename T1, typename T2>
inline typename Enable_If<Is_Native_Or_Checked<T1>::value
                          && Is_Native_Or_Checked<T2>::value,
                          bool>::type
greater_or_equal(const T1& x, const T2& y);

//! Greater than operator.
/*! \relates Checked_Number */
template <typename T1, typename T2>
inline
typename Enable_If<Is_Native_Or_Checked<T1>::value
                   && Is_Native_Or_Checked<T2>::value
                   && (Is_Checked<T1>::value || Is_Checked<T2>::value),
                   bool>::type
operator>(const T1& x, const T2& y);

/*! \relates Checked_Number */
template <typename T1, typename T2>
inline typename Enable_If<Is_Native_Or_Checked<T1>::value
                          && Is_Native_Or_Checked<T2>::value,
                          bool>::type
greater_than(const T1& x, const T2& y);

//! Less than or equal to operator.
/*! \relates Checked_Number */
template <typename T1, typename T2>
inline
typename Enable_If<Is_Native_Or_Checked<T1>::value
                   && Is_Native_Or_Checked<T2>::value
                   && (Is_Checked<T1>::value || Is_Checked<T2>::value),
                   bool>::type
operator<=(const T1& x, const T2& y);

/*! \relates Checked_Number */
template <typename T1, typename T2>
inline typename Enable_If<Is_Native_Or_Checked<T1>::value
                          && Is_Native_Or_Checked<T2>::value,
                          bool>::type
less_or_equal(const T1& x, const T2& y);

//! Less than operator.
/*! \relates Checked_Number */
template <typename T1, typename T2>
inline
typename Enable_If<Is_Native_Or_Checked<T1>::value
                   && Is_Native_Or_Checked<T2>::value
                   && (Is_Checked<T1>::value || Is_Checked<T2>::value),
                   bool>::type
operator<(const T1& x, const T2& y);

/*! \relates Checked_Number */
template <typename T1, typename T2>
inline typename Enable_If<Is_Native_Or_Checked<T1>::value
                          && Is_Native_Or_Checked<T2>::value,
                          bool>::type
less_than(const T1& x, const T2& y);

/*! \brief
  Returns \f$-1\f$, \f$0\f$ or \f$1\f$ depending on whether the value
  of \p x is negative, zero or positive, respectively.

  \relates Checked_Number
*/
template <typename From>
inline typename Enable_If<Is_Native_Or_Checked<From>::value, int>::type \
sgn(const From& x);

/*! \brief
  Returns a negative, zero or positive value depending on whether
  \p x is lower than, equal to or greater than \p y, respectively.

  \relates Checked_Number
*/
template <typename From1, typename From2>
inline typename Enable_If<Is_Native_Or_Checked<From1>::value
                          && Is_Native_Or_Checked<From2>::value,
                          int>::type
cmp(const From1& x, const From2& y);

//@} // Relational Operators and Comparison Functions

//! \name Input-Output Operators
//@{

/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, Result>::type
output(std::ostream& os,
       const T& x,
       const Numeric_Format& format,
       Rounding_Dir dir);

//! Output operator.
/*! \relates Checked_Number */
template <typename T, typename Policy>
std::ostream&
operator<<(std::ostream& os, const Checked_Number<T, Policy>& x);

//! Ascii dump for native or checked.
/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, void>::type
ascii_dump(std::ostream& s, const T& t);

//! Input function.
/*!
  \relates Checked_Number

  \param is
  Input stream to read from;

  \param x
  Number (possibly extended) to assign to in case of successful reading;

  \param dir
  Rounding mode to be applied.

  \return
  Result of the input operation.  Success, success with imprecision,
  overflow, parsing error: all possibilities are taken into account,
  checked for, and properly reported.

  This function attempts reading a (possibly extended) number from the given
  stream \p is, possibly rounding as specified by \p dir, assigning the result
  to \p x upon success, and returning the appropriate Result.

  The input syntax allows the specification of:
  - plain base-10 integer numbers as <CODE>34976098</CODE>,
    <CODE>-77</CODE> and <CODE>+13</CODE>;
  - base-10 integer numbers in scientific notation as <CODE>15e2</CODE>
    and <CODE>15*^2</CODE> (both meaning \f$15 \cdot 10^2 = 1500\f$),
    <CODE>9200e-2</CODE> and <CODE>-18*^+11111111111111111</CODE>;
  - base-10 rational numbers in fraction notation as
    <CODE>15/3</CODE> and <CODE>15/-3</CODE>;
  - base-10 rational numbers in fraction/scientific notation as
    <CODE>15/30e-1</CODE> (meaning \f$5\f$) and <CODE>15*^-3/29e2</CODE>
    (meaning \f$3/580000\f$);
  - base-10 rational numbers in floating point notation as
    <CODE>71.3</CODE> (meaning \f$713/10\f$) and
    <CODE>-0.123456</CODE> (meaning \f$-1929/15625\f$);
  - base-10 rational numbers in floating point scientific notation as
    <CODE>2.2e-1</CODE> (meaning \f$11/50\f$) and <CODE>-2.20001*^+3</CODE>
    (meaning \f$-220001/100\f$);
  - integers and rationals (in fractional, floating point and scientific
    notations) specified by using Mathematica-style bases, in the range
    from 2 to 36, as
    <CODE>2^^11</CODE> (meaning \f$3\f$),
    <CODE>36^^z</CODE> (meaning \f$35\f$),
    <CODE>36^^xyz</CODE> (meaning \f$44027\f$),
    <CODE>2^^11.1</CODE> (meaning \f$7/2\f$),
    <CODE>10^^2e3</CODE> (meaning \f$2000\f$),
    <CODE>8^^2e3</CODE> (meaning \f$1024\f$),
    <CODE>8^^2.1e3</CODE> (meaning \f$1088\f$),
    <CODE>8^^20402543.120347e7</CODE> (meaning \f$9073863231288\f$),
    <CODE>8^^2.1</CODE> (meaning \f$17/8\f$);
    note that the base and the exponent are always written as plain
    base-10 integer numbers; also, when an ambiguity may arise, the
    character <CODE>e</CODE> is interpreted as a digit, so that
    <CODE>16^^1e2</CODE> (meaning \f$482\f$) is different from
    <CODE>16^^1*^2</CODE> (meaning \f$256\f$);
  - the C-style hexadecimal prefix <CODE>0x</CODE> is interpreted as
    the Mathematica-style prefix <CODE>16^^</CODE>;
  - the C-style binary exponent indicator <CODE>p</CODE> can only be used
    when base 16 has been specified; if used, the exponent will be
    applied to base 2 (instead of base 16, as is the case when the
    indicator <CODE>e</CODE> is used);
  - special values like <CODE>inf</CODE> and <CODE>+inf</CODE>
    (meaning \f$+\infty\f$), <CODE>-inf</CODE> (meaning \f$-\infty\f$),
    and <CODE>nan</CODE> (meaning "not a number").

  The rationale behind the accepted syntax can be summarized as follows:
  - if the syntax is accepted by Mathematica, then this function
    accepts it with the same semantics;
  - if the syntax is acceptable as standard C++ integer or floating point
    literal (except for octal notation and type suffixes, which are not
    supported), then this function accepts it with the same semantics;
  - natural extensions of the above are accepted with the natural
    extensions of the semantics;
  - special values are accepted.

  Valid syntax is more formally and completely specified by the
  following grammar, with the additional provisos that everything is
  <EM>case insensitive</EM>, that the syntactic category
  <CODE>BDIGIT</CODE> is further restricted by the current base
  and that for all bases above 14, any <CODE>e</CODE> is always
  interpreted as a digit and never as a delimiter for the exponent part
  (if such a delimiter is desired, it has to be written as <CODE>*^</CODE>).

\code
number  : NAN                                   INF     : 'inf'
        | SIGN INF                                      ;
        | INF
        | num                                   NAN     : 'nan'
        | num DIV num                                   ;
        ;
                                                SIGN    : '-'
num     : u_num                                         | '+'
        | SIGN u_num                                    ;

u_num   : u_num1                                EXP     : 'e'
        | HEX u_num1                                    | 'p'
        | base BASE u_num1                              | '*^'
        ;                                               ;
                                                POINT   : '.'
u_num1  : mantissa                                      ;
        | mantissa EXP exponent
        ;                                       DIV     : '/'
                                                        ;
mantissa: bdigits
        | POINT bdigits                         MINUS   : '-'
        | bdigits POINT                                 ;
        | bdigits POINT bdigits
        ;                                       PLUS    : '+'
                                                ;
exponent: SIGN digits
        | digits                                HEX     : '0x'
        ;                                       ;

bdigits : BDIGIT                                BASE    : '^^'
        | bdigits BDIGIT                                ;
        ;
                                                DIGIT   : '0' .. '9'
digits  : DIGIT                                         ;
        | digits DIGIT
        ;                                       BDIGIT  : '0' .. '9'
                                                        | 'a' .. 'z'
                                                        ;
\endcode
*/
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, Result>::type
input(T& x, std::istream& is, Rounding_Dir dir);

//! Input operator.
/*! \relates Checked_Number */
template <typename T, typename Policy>
std::istream&
operator>>(std::istream& is, Checked_Number<T, Policy>& x);

//! Ascii load for native or checked.
/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
ascii_load(std::ostream& s, T& t);

//@} // Input-Output Operators

void throw_result_exception(Result r);

template <typename T>
T
plus_infinity();

template <typename T>
T
minus_infinity();

template <typename T>
T
not_a_number();

//! Swaps \p x with \p y.
/*! \relates Checked_Number */
template <typename T, typename Policy>
void swap(Checked_Number<T, Policy>& x, Checked_Number<T, Policy>& y);

template <typename T, typename Policy>
struct FPU_Related<Checked_Number<T, Policy> > : public FPU_Related<T> {};

template <typename T>
void maybe_reset_fpu_inexact();

template <typename T>
int maybe_check_fpu_inexact();

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Checked_Number_inlines.hh line 1. */
/* Checked_Number class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Checked_Number_inlines.hh line 28. */
#include <stdexcept>
#include <sstream>

namespace Parma_Polyhedra_Library {

#ifndef NDEBUG
#define DEBUG_ROUND_NOT_NEEDED
#endif

inline Rounding_Dir
rounding_dir(Rounding_Dir dir) {
  if (dir == ROUND_NOT_NEEDED) {
#ifdef DEBUG_ROUND_NOT_NEEDED
    return ROUND_CHECK;
#endif
  }
  return dir;
}

inline Result
check_result(Result r, Rounding_Dir dir) {
  if (dir == ROUND_NOT_NEEDED) {
#ifdef DEBUG_ROUND_NOT_NEEDED
    PPL_ASSERT(result_relation(r) == VR_EQ);
#endif
    return r;
  }
  return r;
}


template <typename T>
inline void
Checked_Number_Transparent_Policy<T>::handle_result(Result) {
}

inline void
Extended_Number_Policy::handle_result(Result r) {
  if (result_class(r) == VC_NAN) {
    throw_result_exception(r);
  }
}

template <typename T, typename Policy>
inline
Checked_Number<T, Policy>::Checked_Number()
 : v(0) {
}

template <typename T, typename Policy>
inline
Checked_Number<T, Policy>::Checked_Number(const Checked_Number& y) {
  // TODO: avoid default construction of value member.
  Checked::copy<Policy, Policy>(v, y.raw_value());
}

template <typename T, typename Policy>
template <typename From, typename From_Policy>
inline
Checked_Number<T, Policy>
::Checked_Number(const Checked_Number<From, From_Policy>& y,
                 Rounding_Dir dir) {
  // TODO: avoid default construction of value member.
  Policy::handle_result(check_result(Checked::assign_ext<Policy, From_Policy>
                                     (v,
                                      y.raw_value(),
                                      rounding_dir(dir)),
                                     dir)
                        );
}

template <typename T, typename Policy>
template <typename From, typename From_Policy>
inline
Checked_Number<T, Policy>
::Checked_Number(const Checked_Number<From, From_Policy>& y) {
  // TODO: avoid default construction of value member.
  Rounding_Dir dir = Policy::ROUND_DEFAULT_CONSTRUCTOR;
  Policy::handle_result(check_result(Checked::assign_ext<Policy, From_Policy>
                                     (v,
                                      y.raw_value(),
                                      rounding_dir(dir)),
                                     dir));
}

// TODO: avoid default construction of value member.
#define PPL_DEFINE_CTOR(type) \
template <typename T, typename Policy> \
inline \
Checked_Number<T, Policy>::Checked_Number(const type y, Rounding_Dir dir) { \
  Policy::handle_result(check_result(Checked::assign_ext<Policy,        \
                                     Checked_Number_Transparent_Policy<PPL_U(type)> > \
                                     (v, y, rounding_dir(dir)),         \
                                     dir));                             \
}                                                                       \
template <typename T, typename Policy>                                  \
inline                                                                  \
Checked_Number<T, Policy>::Checked_Number(const type y) {               \
  Rounding_Dir dir = Policy::ROUND_DEFAULT_CONSTRUCTOR;                 \
  Policy::handle_result(check_result(Checked::assign_ext<Policy,        \
                                     Checked_Number_Transparent_Policy<PPL_U(type)> > \
                                     (v, y, rounding_dir(dir)),         \
                                     dir));                             \
}

PPL_DEFINE_CTOR(char)
PPL_DEFINE_CTOR(signed char)
PPL_DEFINE_CTOR(signed short)
PPL_DEFINE_CTOR(signed int)
PPL_DEFINE_CTOR(signed long)
PPL_DEFINE_CTOR(signed long long)
PPL_DEFINE_CTOR(unsigned char)
PPL_DEFINE_CTOR(unsigned short)
PPL_DEFINE_CTOR(unsigned int)
PPL_DEFINE_CTOR(unsigned long)
PPL_DEFINE_CTOR(unsigned long long)
#if PPL_SUPPORTED_FLOAT
PPL_DEFINE_CTOR(float)
#endif
#if PPL_SUPPORTED_DOUBLE
PPL_DEFINE_CTOR(double)
#endif
#if PPL_SUPPORTED_LONG_DOUBLE
PPL_DEFINE_CTOR(long double)
#endif
PPL_DEFINE_CTOR(mpq_class&)
PPL_DEFINE_CTOR(mpz_class&)

#undef PPL_DEFINE_CTOR


template <typename T, typename Policy>
inline
Checked_Number<T, Policy>::Checked_Number(const char* y, Rounding_Dir dir) {
  std::istringstream s(y);
  Policy::handle_result(check_result(Checked::input<Policy>(v,
                                                            s,
                                                            rounding_dir(dir)),
                                     dir));
}

template <typename T, typename Policy>
inline
Checked_Number<T, Policy>::Checked_Number(const char* y) {
  std::istringstream s(y);
  Rounding_Dir dir = Policy::ROUND_DEFAULT_CONSTRUCTOR;
  Policy::handle_result(check_result(Checked::input<Policy>(v,
                                                            s,
                                                            rounding_dir(dir)),
                                     dir));
}

template <typename T, typename Policy>
template <typename From>
inline
Checked_Number<T, Policy>
::Checked_Number(const From&,
                 Rounding_Dir dir,
                 typename Enable_If<Is_Special<From>::value, bool>::type) {
  Policy::handle_result(check_result(Checked::assign_special<Policy>(v,
                                                                     From::vclass,
                                                                     rounding_dir(dir)),
                                     dir));
}

template <typename T, typename Policy>
template <typename From>
inline
Checked_Number<T, Policy>::Checked_Number(const From&, typename Enable_If<Is_Special<From>::value, bool>::type) {
  Rounding_Dir dir = Policy::ROUND_DEFAULT_CONSTRUCTOR;
  Policy::handle_result(check_result(Checked::assign_special<Policy>(v,
                                                            From::vclass,
                                                            rounding_dir(dir)),
                                     dir));
}

template <typename To, typename From>
inline typename Enable_If<Is_Native_Or_Checked<To>::value
                          && Is_Special<From>::value, Result>::type
assign_r(To& to, const From&, Rounding_Dir dir) {
  return check_result(Checked::assign_special<typename Native_Checked_To_Wrapper<To>
                      ::Policy>(Native_Checked_To_Wrapper<To>::raw_value(to),
                                From::vclass,
                                rounding_dir(dir)),
                      dir);
}

template <typename To, typename From>
inline typename Enable_If<Is_Native_Or_Checked<To>::value && Is_Special<From>::value, Result>::type
construct(To& to, const From&, Rounding_Dir dir) {
  return check_result(Checked::construct_special<typename Native_Checked_To_Wrapper<To>
                      ::Policy>(Native_Checked_To_Wrapper<To>::raw_value(to),
                                From::vclass,
                                rounding_dir(dir)),
                      dir);
}

template <typename T>
inline typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_minus_infinity(const T& x) {
  return Checked::is_minf<typename Native_Checked_From_Wrapper<T>
    ::Policy>(Native_Checked_From_Wrapper<T>::raw_value(x));
}

template <typename T>
inline typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_plus_infinity(const T& x) {
  return Checked::is_pinf<typename Native_Checked_From_Wrapper<T>
    ::Policy>(Native_Checked_From_Wrapper<T>::raw_value(x));
}

template <typename T>
inline typename Enable_If<Is_Native_Or_Checked<T>::value, int>::type
infinity_sign(const T& x) {
  return is_minus_infinity(x) ? -1 : (is_plus_infinity(x) ? 1 : 0);
}

template <typename T>
inline typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_not_a_number(const T& x) {
  return Checked::is_nan<typename Native_Checked_From_Wrapper<T>
    ::Policy>(Native_Checked_From_Wrapper<T>::raw_value(x));
}

template <typename T>
inline typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_integer(const T& x) {
  return Checked::is_int<typename Native_Checked_From_Wrapper<T>
    ::Policy>(Native_Checked_From_Wrapper<T>::raw_value(x));
}

template <typename T, typename Policy>
inline
Checked_Number<T, Policy>::operator T() const {
  if (Policy::convertible) {
    return v;
  }
}

template <typename T, typename Policy>
inline T&
Checked_Number<T, Policy>::raw_value() {
  return v;
}

template <typename T, typename Policy>
inline const T&
Checked_Number<T, Policy>::raw_value() const {
  return v;
}

/*! \relates Checked_Number */
template <typename T, typename Policy>
inline const T&
raw_value(const Checked_Number<T, Policy>& x) {
  return x.raw_value();
}

/*! \relates Checked_Number */
template <typename T, typename Policy>
inline T&
raw_value(Checked_Number<T, Policy>& x) {
  return x.raw_value();
}

template <typename T, typename Policy>
inline bool
Checked_Number<T, Policy>::OK() const {
  return true;
}

template <typename T, typename Policy>
inline Result
Checked_Number<T, Policy>::classify(bool nan, bool inf, bool sign) const {
  return Checked::classify<Policy>(v, nan, inf, sign);
}

template <typename T, typename Policy>
inline bool
is_not_a_number(const Checked_Number<T, Policy>& x) {
  return Checked::is_nan<Policy>(x.raw_value());
}

template <typename T, typename Policy>
inline bool
is_minus_infinity(const Checked_Number<T, Policy>& x) {
  return Checked::is_minf<Policy>(x.raw_value());
}

template <typename T, typename Policy>
inline bool
is_plus_infinity(const Checked_Number<T, Policy>& x) {
  return Checked::is_pinf<Policy>(x.raw_value());
}

/*! \relates Checked_Number */
template <typename T, typename Policy>
inline memory_size_type
total_memory_in_bytes(const Checked_Number<T, Policy>& x) {
  return total_memory_in_bytes(x.raw_value());
}

/*! \relates Checked_Number */
template <typename T, typename Policy>
inline memory_size_type
external_memory_in_bytes(const Checked_Number<T, Policy>& x) {
  return external_memory_in_bytes(x.raw_value());
}


/*! \relates Checked_Number */
template <typename To>
inline typename Enable_If<Is_Native_Or_Checked<To>::value, Result>::type
assign_r(To& to, const char* x, Rounding_Dir dir) {
  std::istringstream s(x);
  return check_result(Checked::input<typename Native_Checked_To_Wrapper<To>
                      ::Policy>(Native_Checked_To_Wrapper<To>::raw_value(to),
                                s,
                                rounding_dir(dir)),
                      dir);
}

#define PPL_DEFINE_FUNC1_A(name, func) \
template <typename To, typename From>                                   \
inline typename Enable_If<Is_Native_Or_Checked<To>::value               \
                          && Is_Native_Or_Checked<From>::value,         \
                          Result>::type                                 \
 PPL_U(name)(To& to, const From& x, Rounding_Dir dir) {                 \
  return                                                                \
    check_result(Checked::func<typename Native_Checked_To_Wrapper<To>   \
                 ::Policy,                                              \
                 typename Native_Checked_From_Wrapper<From>             \
                 ::Policy>(Native_Checked_To_Wrapper<To>::raw_value(to), \
                           Native_Checked_From_Wrapper<From>::raw_value(x), \
                           rounding_dir(dir)), dir);                    \
}

PPL_DEFINE_FUNC1_A(construct, construct_ext)
PPL_DEFINE_FUNC1_A(assign_r, assign_ext)
PPL_DEFINE_FUNC1_A(floor_assign_r, floor_ext)
PPL_DEFINE_FUNC1_A(ceil_assign_r, ceil_ext)
PPL_DEFINE_FUNC1_A(trunc_assign_r, trunc_ext)
PPL_DEFINE_FUNC1_A(neg_assign_r, neg_ext)
PPL_DEFINE_FUNC1_A(abs_assign_r, abs_ext)
PPL_DEFINE_FUNC1_A(sqrt_assign_r, sqrt_ext)

#undef PPL_DEFINE_FUNC1_A

#define PPL_DEFINE_FUNC1_B(name, func) \
template <typename To, typename From>                                   \
inline typename Enable_If<Is_Native_Or_Checked<To>::value               \
                          && Is_Native_Or_Checked<From>::value,         \
                          Result>::type                                 \
 PPL_U(name)(To& to, const From& x, unsigned int exp, Rounding_Dir dir) { \
  return                                                                \
    check_result(Checked::func<typename Native_Checked_To_Wrapper<To>   \
                 ::Policy,                                              \
                 typename Native_Checked_From_Wrapper<From>             \
                 ::Policy>(Native_Checked_To_Wrapper<To>::raw_value(to), \
                           Native_Checked_From_Wrapper<From>::raw_value(x), \
                           exp,                                         \
                           rounding_dir(dir)),                          \
                 dir);                                                  \
}

PPL_DEFINE_FUNC1_B(add_2exp_assign_r, add_2exp_ext)
PPL_DEFINE_FUNC1_B(sub_2exp_assign_r, sub_2exp_ext)
PPL_DEFINE_FUNC1_B(mul_2exp_assign_r, mul_2exp_ext)
PPL_DEFINE_FUNC1_B(div_2exp_assign_r, div_2exp_ext)
PPL_DEFINE_FUNC1_B(smod_2exp_assign_r, smod_2exp_ext)
PPL_DEFINE_FUNC1_B(umod_2exp_assign_r, umod_2exp_ext)

#undef PPL_DEFINE_FUNC1_B

#define PPL_DEFINE_FUNC2(name, func) \
template <typename To, typename From1, typename From2>                  \
inline typename Enable_If<Is_Native_Or_Checked<To>::value               \
                          && Is_Native_Or_Checked<From1>::value         \
                          && Is_Native_Or_Checked<From2>::value,        \
                          Result>::type                                 \
 PPL_U(name)(To& to, const From1& x, const From2& y, Rounding_Dir dir) { \
  return                                                                \
    check_result(Checked::func<typename Native_Checked_To_Wrapper<To>   \
                 ::Policy,                                              \
                 typename Native_Checked_From_Wrapper<From1>            \
                 ::Policy,                                              \
                 typename Native_Checked_From_Wrapper<From2>            \
                 ::Policy>(Native_Checked_To_Wrapper<To>::raw_value(to), \
                           Native_Checked_From_Wrapper<From1>::raw_value(x), \
                           Native_Checked_From_Wrapper<From2>::raw_value(y), \
                           rounding_dir(dir)),                          \
                 dir);                                                  \
}

PPL_DEFINE_FUNC2(add_assign_r, add_ext)
PPL_DEFINE_FUNC2(sub_assign_r, sub_ext)
PPL_DEFINE_FUNC2(mul_assign_r, mul_ext)
PPL_DEFINE_FUNC2(div_assign_r, div_ext)
PPL_DEFINE_FUNC2(idiv_assign_r, idiv_ext)
PPL_DEFINE_FUNC2(rem_assign_r, rem_ext)
PPL_DEFINE_FUNC2(gcd_assign_r, gcd_ext)
PPL_DEFINE_FUNC2(lcm_assign_r, lcm_ext)
PPL_DEFINE_FUNC2(add_mul_assign_r, add_mul_ext)
PPL_DEFINE_FUNC2(sub_mul_assign_r, sub_mul_ext)

#undef PPL_DEFINE_FUNC2

#define PPL_DEFINE_FUNC4(name, func)                                    \
template <typename To1,                                                 \
          typename To2,                                                 \
          typename To3,                                                 \
          typename From1,                                               \
          typename From2>                                               \
inline typename Enable_If<Is_Native_Or_Checked<To1>::value              \
                          && Is_Native_Or_Checked<To2>::value           \
                          && Is_Native_Or_Checked<To3>::value           \
                          && Is_Native_Or_Checked<From1>::value         \
                          && Is_Native_Or_Checked<From2>::value,        \
                          Result>::type                                 \
 PPL_U(name)(To1& to, To2& s, To3& t, const From1& x, const From2& y,   \
     Rounding_Dir dir) {                                                \
  return                                                                \
    check_result(Checked::func<typename Native_Checked_To_Wrapper<To1>::Policy, \
                 typename Native_Checked_To_Wrapper<To2>::Policy,       \
                 typename Native_Checked_To_Wrapper<To3>::Policy,       \
                 typename Native_Checked_From_Wrapper<From1>::Policy,   \
                 typename Native_Checked_From_Wrapper<From2>::Policy>   \
                 (Native_Checked_To_Wrapper<To1>::raw_value(to),        \
                  Native_Checked_To_Wrapper<To2>::raw_value(s),         \
                  Native_Checked_To_Wrapper<To3>::raw_value(t),         \
                  Native_Checked_From_Wrapper<From1>::raw_value(x),     \
                  Native_Checked_From_Wrapper<From2>::raw_value(y),     \
                  rounding_dir(dir)),                                   \
                 dir);                                                  \
}

PPL_DEFINE_FUNC4(gcdext_assign_r, gcdext_ext)

#undef PPL_DEFINE_PPL_DEFINE_FUNC4

#define PPL_DEFINE_INCREMENT(f, fun) \
template <typename T, typename Policy> \
inline Checked_Number<T, Policy>& \
Checked_Number<T, Policy>::f() { \
  Policy::handle_result((fun)(*this, *this, T(1),             \
                            Policy::ROUND_DEFAULT_OPERATOR)); \
  return *this; \
} \
template <typename T, typename Policy> \
inline Checked_Number<T, Policy> \
Checked_Number<T, Policy>::f(int) {\
  T r = v;\
  Policy::handle_result((fun)(*this, *this, T(1),             \
                            Policy::ROUND_DEFAULT_OPERATOR)); \
  return r;\
}

PPL_DEFINE_INCREMENT(operator ++, add_assign_r)
PPL_DEFINE_INCREMENT(operator --, sub_assign_r)

#undef PPL_DEFINE_INCREMENT

template <typename T, typename Policy>
inline Checked_Number<T, Policy>&
Checked_Number<T, Policy>::operator=(const Checked_Number<T, Policy>& y) {
  Checked::copy<Policy, Policy>(v, y.raw_value());
  return *this;
}
template <typename T, typename Policy>
template <typename From>
inline Checked_Number<T, Policy>&
Checked_Number<T, Policy>::operator=(const From& y) {
  Policy::handle_result(assign_r(*this, y, Policy::ROUND_DEFAULT_OPERATOR));
  return *this;
}

#define PPL_DEFINE_BINARY_OP_ASSIGN(f, fun) \
template <typename T, typename Policy> \
template <typename From_Policy> \
inline Checked_Number<T, Policy>& \
Checked_Number<T, Policy>::f(const Checked_Number<T, From_Policy>& y) { \
  Policy::handle_result((fun)(*this, *this, y,                          \
                            Policy::ROUND_DEFAULT_OPERATOR)); \
  return *this; \
} \
template <typename T, typename Policy> \
inline Checked_Number<T, Policy>& \
Checked_Number<T, Policy>::f(const T& y) { \
  Policy::handle_result((fun)(*this, *this, y,                \
                            Policy::ROUND_DEFAULT_OPERATOR)); \
  return *this; \
} \
template <typename T, typename Policy> \
template <typename From> \
inline typename Enable_If<Is_Native_Or_Checked<From>::value, \
                          Checked_Number<T, Policy>& >::type \
Checked_Number<T, Policy>::f(const From& y) { \
  Checked_Number<T, Policy> cy(y); \
  Policy::handle_result((fun)(*this, *this, cy,               \
                            Policy::ROUND_DEFAULT_OPERATOR)); \
  return *this; \
}

PPL_DEFINE_BINARY_OP_ASSIGN(operator +=, add_assign_r)
PPL_DEFINE_BINARY_OP_ASSIGN(operator -=, sub_assign_r)
PPL_DEFINE_BINARY_OP_ASSIGN(operator *=, mul_assign_r)
PPL_DEFINE_BINARY_OP_ASSIGN(operator /=, div_assign_r)
PPL_DEFINE_BINARY_OP_ASSIGN(operator %=, rem_assign_r)

#undef PPL_DEFINE_BINARY_OP_ASSIGN

#define PPL_DEFINE_BINARY_OP(f, fun) \
template <typename T, typename Policy> \
inline Checked_Number<T, Policy> \
 PPL_U(f)(const Checked_Number<T, Policy>& x,   \
         const Checked_Number<T, Policy>& y) {  \
  Checked_Number<T, Policy> r; \
  Policy::handle_result((fun)(r, x, y, Policy::ROUND_DEFAULT_OPERATOR)); \
  return r; \
} \
template <typename Type, typename T, typename Policy>   \
inline \
typename Enable_If<Is_Native<Type>::value, Checked_Number<T, Policy> >::type \
 PPL_U(f)(const Type& x, const Checked_Number<T, Policy>& y) {          \
  Checked_Number<T, Policy> r(x); \
  Policy::handle_result((fun)(r, r, y, Policy::ROUND_DEFAULT_OPERATOR)); \
  return r; \
} \
template <typename T, typename Policy, typename Type>   \
inline \
typename Enable_If<Is_Native<Type>::value, Checked_Number<T, Policy> >::type \
 PPL_U(f)(const Checked_Number<T, Policy>& x, const Type& y) {          \
  Checked_Number<T, Policy> r(y); \
  Policy::handle_result((fun)(r, x, r, Policy::ROUND_DEFAULT_OPERATOR)); \
  return r; \
}

PPL_DEFINE_BINARY_OP(operator +, add_assign_r)
PPL_DEFINE_BINARY_OP(operator -, sub_assign_r)
PPL_DEFINE_BINARY_OP(operator *, mul_assign_r)
PPL_DEFINE_BINARY_OP(operator /, div_assign_r)
PPL_DEFINE_BINARY_OP(operator %, rem_assign_r)

#undef PPL_DEFINE_BINARY_OP

#define PPL_DEFINE_COMPARE_OP(f, fun)                                   \
template <typename T1, typename T2>                                     \
inline                                                                  \
typename Enable_If<Is_Native_Or_Checked<T1>::value                      \
                   && Is_Native_Or_Checked<T2>::value                   \
                   && (Is_Checked<T1>::value || Is_Checked<T2>::value), \
                   bool>::type                                          \
 PPL_U(f)(const T1& x, const T2& y) {                                   \
  return Checked::fun<typename Native_Checked_From_Wrapper<T1>::Policy, \
                      typename Native_Checked_From_Wrapper<T2>::Policy> \
    (Native_Checked_From_Wrapper<T1>::raw_value(x),                     \
     Native_Checked_From_Wrapper<T2>::raw_value(y));                    \
}

PPL_DEFINE_COMPARE_OP(operator ==, eq_ext)
PPL_DEFINE_COMPARE_OP(operator !=, ne_ext)
PPL_DEFINE_COMPARE_OP(operator >=, ge_ext)
PPL_DEFINE_COMPARE_OP(operator >, gt_ext)
PPL_DEFINE_COMPARE_OP(operator <=, le_ext)
PPL_DEFINE_COMPARE_OP(operator <, lt_ext)

#undef PPL_DEFINE_COMPARE_OP

#define PPL_DEFINE_COMPARE(f, fun)                                      \
template <typename T1, typename T2>                                     \
inline typename Enable_If<Is_Native_Or_Checked<T1>::value               \
                          && Is_Native_Or_Checked<T2>::value,           \
                          bool>::type                                   \
 PPL_U(f)(const T1& x, const T2& y) {                                   \
  return Checked::fun<typename Native_Checked_From_Wrapper<T1>::Policy, \
                      typename Native_Checked_From_Wrapper<T2>::Policy> \
    (Native_Checked_From_Wrapper<T1>::raw_value(x),                     \
     Native_Checked_From_Wrapper<T2>::raw_value(y));                    \
}

PPL_DEFINE_COMPARE(equal, eq_ext)
PPL_DEFINE_COMPARE(not_equal, ne_ext)
PPL_DEFINE_COMPARE(greater_or_equal, ge_ext)
PPL_DEFINE_COMPARE(greater_than, gt_ext)
PPL_DEFINE_COMPARE(less_or_equal, le_ext)
PPL_DEFINE_COMPARE(less_than, lt_ext)

#undef PPL_DEFINE_COMPARE

/*! \relates Checked_Number */
template <typename T, typename Policy>
inline Checked_Number<T, Policy>
operator+(const Checked_Number<T, Policy>& x) {
  return x;
}

/*! \relates Checked_Number */
template <typename T, typename Policy>
inline Checked_Number<T, Policy>
operator-(const Checked_Number<T, Policy>& x) {
  Checked_Number<T, Policy> r;
  Policy::handle_result(neg_assign_r(r, x, Policy::ROUND_DEFAULT_OPERATOR));
  return r;
}

#define PPL_DEFINE_ASSIGN_FUN2_1(f, fun) \
template <typename T, typename Policy> \
inline void \
 PPL_U(f)(Checked_Number<T, Policy>& x) {                               \
  Policy::handle_result((fun)(x, x, Policy::ROUND_DEFAULT_FUNCTION));   \
}

#define PPL_DEFINE_ASSIGN_FUN2_2(f, fun) \
template <typename T, typename Policy> \
inline void \
 PPL_U(f)(Checked_Number<T, Policy>& x, const Checked_Number<T, Policy>& y) { \
  Policy::handle_result((fun)(x, y, Policy::ROUND_DEFAULT_FUNCTION)); \
}

#define PPL_DEFINE_ASSIGN_FUN3_3(f, fun) \
template <typename T, typename Policy> \
inline void \
 PPL_U(f)(Checked_Number<T, Policy>& x, const Checked_Number<T, Policy>& y, \
  const Checked_Number<T, Policy>& z) { \
  Policy::handle_result((fun)(x, y, z, Policy::ROUND_DEFAULT_FUNCTION)); \
}

#define PPL_DEFINE_ASSIGN_FUN5_5(f, fun)                                        \
template <typename T, typename Policy>                                  \
inline void                                                             \
 PPL_U(f)(Checked_Number<T, Policy>& x,                                 \
  Checked_Number<T, Policy>& s, Checked_Number<T, Policy>& t,           \
  const Checked_Number<T, Policy>& y,                                   \
  const Checked_Number<T, Policy>& z) {                                 \
  Policy::handle_result((fun)(x, s, t, y, z, Policy::ROUND_DEFAULT_FUNCTION)); \
}

PPL_DEFINE_ASSIGN_FUN2_2(sqrt_assign, sqrt_assign_r)

PPL_DEFINE_ASSIGN_FUN2_1(floor_assign, floor_assign_r)
PPL_DEFINE_ASSIGN_FUN2_2(floor_assign, floor_assign_r)

PPL_DEFINE_ASSIGN_FUN2_1(ceil_assign, ceil_assign_r)
PPL_DEFINE_ASSIGN_FUN2_2(ceil_assign, ceil_assign_r)

PPL_DEFINE_ASSIGN_FUN2_1(trunc_assign, trunc_assign_r)
PPL_DEFINE_ASSIGN_FUN2_2(trunc_assign, trunc_assign_r)

PPL_DEFINE_ASSIGN_FUN2_1(neg_assign, neg_assign_r)
PPL_DEFINE_ASSIGN_FUN2_2(neg_assign, neg_assign_r)

PPL_DEFINE_ASSIGN_FUN2_1(abs_assign, abs_assign_r)
PPL_DEFINE_ASSIGN_FUN2_2(abs_assign, abs_assign_r)

PPL_DEFINE_ASSIGN_FUN3_3(add_mul_assign, add_mul_assign_r)

PPL_DEFINE_ASSIGN_FUN3_3(sub_mul_assign, sub_mul_assign_r)

PPL_DEFINE_ASSIGN_FUN3_3(rem_assign, rem_assign_r)

PPL_DEFINE_ASSIGN_FUN3_3(gcd_assign, gcd_assign_r)

PPL_DEFINE_ASSIGN_FUN5_5(gcdext_assign, gcdext_assign_r)

PPL_DEFINE_ASSIGN_FUN3_3(lcm_assign, lcm_assign_r)

#undef PPL_DEFINE_ASSIGN_FUN2_1
#undef PPL_DEFINE_ASSIGN_FUN2_2
#undef PPL_DEFINE_ASSIGN_FUN3_2
#undef PPL_DEFINE_ASSIGN_FUN3_3
#undef PPL_DEFINE_ASSIGN_FUN5_5

#define PPL_DEFINE_ASSIGN_2EXP(f, fun)                                  \
template <typename T, typename Policy>                                  \
inline void                                                             \
 PPL_U(f)(Checked_Number<T, Policy>& x,                                 \
          const Checked_Number<T, Policy>& y, unsigned int exp) {       \
  Policy::handle_result((fun)(x, y, exp, Policy::ROUND_DEFAULT_FUNCTION)); \
}

PPL_DEFINE_ASSIGN_2EXP(mul_2exp_assign, mul_2exp_assign_r)
PPL_DEFINE_ASSIGN_2EXP(div_2exp_assign, div_2exp_assign_r)

template <typename T, typename Policy>
inline void
exact_div_assign(Checked_Number<T, Policy>& x,
                 const Checked_Number<T, Policy>& y,
                 const Checked_Number<T, Policy>& z) {
  Policy::handle_result(div_assign_r(x, y, z, ROUND_NOT_NEEDED));
}

/*! \relates Checked_Number */
template <typename From>
inline typename Enable_If<Is_Native_Or_Checked<From>::value, int>::type
sgn(const From& x) {
  Result_Relation r
    = Checked::sgn_ext<typename Native_Checked_From_Wrapper<From>::Policy>
        (Native_Checked_From_Wrapper<From>::raw_value(x));
  switch (r) {
  case VR_LT:
    return -1;
  case VR_EQ:
    return 0;
  case VR_GT:
    return 1;
  default:
    throw(0);
  }
}

/*! \relates Checked_Number */
template <typename From1, typename From2>
inline typename Enable_If<Is_Native_Or_Checked<From1>::value
                          && Is_Native_Or_Checked<From2>::value,
                          int>::type
cmp(const From1& x, const From2& y) {
  Result_Relation r
    = Checked::cmp_ext<typename Native_Checked_From_Wrapper<From1>::Policy,
                       typename Native_Checked_From_Wrapper<From2>::Policy>
                 (Native_Checked_From_Wrapper<From1>::raw_value(x),
                  Native_Checked_From_Wrapper<From2>::raw_value(y));
  switch (r) {
  case VR_LT:
    return -1;
  case VR_EQ:
    return 0;
  case VR_GT:
    return 1;
  default:
    throw(0);
  }
}

/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, Result>::type
output(std::ostream& os, const T& x,
       const Numeric_Format& format, Rounding_Dir dir) {
  return check_result(Checked::output_ext<typename Native_Checked_From_Wrapper<T>::Policy>
                      (os,
                       Native_Checked_From_Wrapper<T>::raw_value(x),
                       format,
                       rounding_dir(dir)),
                      dir);
}

/*! \relates Checked_Number */
template <typename T, typename Policy>
inline std::ostream&
operator<<(std::ostream& os, const Checked_Number<T, Policy>& x) {
  Policy::handle_result(output(os, x, Numeric_Format(), ROUND_IGNORE));
  return os;
}

/*! \relates Checked_Number */
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, Result>::type
input(T& x, std::istream& is, Rounding_Dir dir) {
  return check_result(Checked::input_ext<typename Native_Checked_To_Wrapper<T>::Policy>
                      (Native_Checked_To_Wrapper<T>::raw_value(x),
                       is,
                       rounding_dir(dir)),
                      dir);
}

/*! \relates Checked_Number */
template <typename T, typename Policy>
inline std::istream& operator>>(std::istream& is,
                                Checked_Number<T, Policy>& x) {
  Result r = input(x, is, Policy::ROUND_DEFAULT_INPUT);
  if (r == V_CVT_STR_UNK) {
    is.setstate(std::ios::failbit);
  }
  else {
    Policy::handle_result(r);
  }
  return is;
}

template <typename T>
inline T
plus_infinity() {
  return PLUS_INFINITY;
}

template <typename T>
inline T
minus_infinity() {
  return MINUS_INFINITY;
}

template <typename T>
inline T
not_a_number() {
  return NOT_A_NUMBER;
}

/*! \relates Checked_Number */
template <typename T, typename Policy>
inline void
swap(Checked_Number<T, Policy>& x, Checked_Number<T, Policy>& y) {
  using std::swap;
  swap(x.raw_value(), y.raw_value());
}

template <typename T>
inline void
maybe_reset_fpu_inexact() {
  if (FPU_Related<T>::value) {
    return fpu_reset_inexact();
  }
}

template <typename T>
inline int
maybe_check_fpu_inexact() {
  if (FPU_Related<T>::value) {
    return fpu_check_inexact();
  }
  else {
    return 0;
  }
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Checked_Number_templates.hh line 1. */
/* Checked_Number class implementation: non-inline template functions.
*/


/* Automatically generated from PPL source file ../src/Checked_Number_templates.hh line 28. */
#include <iomanip>
#include <limits>

namespace Parma_Polyhedra_Library {

template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, void>::type
ascii_dump(std::ostream& s, const T& t) {
  if (std::numeric_limits<T>::is_exact) {
    // An exact data type: pretty printer is accurate.
    s << t;
  }
  else {
    // An inexact data type (probably floating point):
    // first dump its hexadecimal representation ...
    const std::ios::fmtflags old_flags = s.setf(std::ios::hex,
                                                std::ios::basefield);
    const unsigned char* p = reinterpret_cast<const unsigned char*>(&t);
    for (unsigned i = 0; i < sizeof(T); ++i) {
      s << std::setw(2) << std::setfill('0') << static_cast<unsigned>(p[i]);
    }
    s.flags(old_flags);
    // ... and then pretty print it for readability.
    s << " (" << t << ")";
  }
}

template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
ascii_load(std::istream& s, T& t) {
  if (std::numeric_limits<T>::is_exact) {
    // An exact data type: input from pretty printed version is accurate.
    s >> t;
    return !s.fail();
  }
  else {
    // An inexact data type (probably floating point):
    // first load its hexadecimal representation ...
    std::string str;
    if (!(s >> str) || str.size() != 2*sizeof(T)) {
      return false;
    }
    unsigned char* p = reinterpret_cast<unsigned char*>(&t);
    // CHECKME: any (portable) simpler way?
    for (unsigned i = 0; i < sizeof(T); ++i) {
      unsigned byte_value = 0;
      for (unsigned j = 0; j < 2; ++j) {
        byte_value <<= 4;
        unsigned half_byte_value;
        // Interpret single hex character.
        switch (str[2*i + j]) {
        case '0':
          half_byte_value = 0;
          break;
        case '1':
          half_byte_value = 1;
          break;
        case '2':
          half_byte_value = 2;
          break;
        case '3':
          half_byte_value = 3;
          break;
        case '4':
          half_byte_value = 4;
          break;
        case '5':
          half_byte_value = 5;
          break;
        case '6':
          half_byte_value = 6;
          break;
        case '7':
          half_byte_value = 7;
          break;
        case '8':
          half_byte_value = 8;
          break;
        case '9':
          half_byte_value = 9;
          break;
        case 'A':
        case 'a':
          half_byte_value = 10;
          break;
        case 'B':
        case 'b':
          half_byte_value = 11;
          break;
        case 'C':
        case 'c':
          half_byte_value = 12;
          break;
        case 'D':
        case 'd':
          half_byte_value = 13;
          break;
        case 'E':
        case 'e':
          half_byte_value = 14;
          break;
        case 'F':
        case 'f':
          half_byte_value = 15;
          break;
        default:
          return false;
        }
        byte_value += half_byte_value;
      }
      PPL_ASSERT(byte_value <= 255);
      p[i] = static_cast<unsigned char>(byte_value);
    }
    // ... then read and discard pretty printed value.
    if (!(s >> str)) {
      return false;
    }
    const std::string::size_type sz = str.size();
    return sz > 2 && str[0] == '(' && str[sz-1] == ')';
  }
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Checked_Number_defs.hh line 1069. */

/* Automatically generated from PPL source file ../src/checked_numeric_limits.hh line 29. */
#include <limits>

namespace std {

using namespace Parma_Polyhedra_Library;

#define PPL_SPECIALIZE_LIMITS_INT(T)                                    \
  /*! \brief Partial specialization of std::numeric_limits. */          \
  template <typename Policy>                                            \
  class numeric_limits<Checked_Number<PPL_U(T), Policy> >              \
    : public numeric_limits<PPL_U(T)> {                                 \
  private:                                                              \
    typedef Checked_Number<PPL_U(T), Policy> Type;                      \
                                                                        \
  public:                                                               \
    static const bool has_infinity = Policy::has_infinity;              \
    static const bool has_quiet_NaN =  Policy::has_nan;                 \
                                                                        \
    static Type min() {                                                 \
      Type v;                                                           \
      v.raw_value() = Checked::Extended_Int<Policy, PPL_U(T)>::min;     \
      return v;                                                         \
    }                                                                   \
                                                                        \
    static Type max() {                                                 \
      Type v;                                                           \
      v.raw_value() = Checked::Extended_Int<Policy, PPL_U(T)>::max;     \
      return v;                                                         \
    }                                                                   \
                                                                        \
    static Type infinity() {                                            \
      Type v;                                                           \
      Checked::assign_special<Policy>(v.raw_value(), VC_PLUS_INFINITY,  \
                                      ROUND_IGNORE);                    \
      return v;                                                         \
    }                                                                   \
                                                                        \
    static Type quiet_NaN() {                                           \
      Type v;                                                           \
      Checked::assign_special<Policy>(v.raw_value(), VC_NAN,            \
                                      ROUND_IGNORE);                    \
      return v;                                                         \
    }                                                                   \
  };

PPL_SPECIALIZE_LIMITS_INT(char)

PPL_SPECIALIZE_LIMITS_INT(signed char)
PPL_SPECIALIZE_LIMITS_INT(signed short)
PPL_SPECIALIZE_LIMITS_INT(signed int)
PPL_SPECIALIZE_LIMITS_INT(signed long)
PPL_SPECIALIZE_LIMITS_INT(signed long long)

PPL_SPECIALIZE_LIMITS_INT(unsigned char)
PPL_SPECIALIZE_LIMITS_INT(unsigned short)
PPL_SPECIALIZE_LIMITS_INT(unsigned int)
PPL_SPECIALIZE_LIMITS_INT(unsigned long)
PPL_SPECIALIZE_LIMITS_INT(unsigned long long)

#undef PPL_SPECIALIZE_LIMITS_INT

#define PPL_SPECIALIZE_LIMITS_FLOAT(T)                                  \
  /*! \brief Partial specialization of std::numeric_limits. */          \
  template <typename Policy>                                            \
  struct numeric_limits<Checked_Number<PPL_U(T), Policy> >              \
    : public numeric_limits<PPL_U(T)> {                                 \
};

#if PPL_SUPPORTED_FLOAT
PPL_SPECIALIZE_LIMITS_FLOAT(float)
#endif
#if PPL_SUPPORTED_DOUBLE
PPL_SPECIALIZE_LIMITS_FLOAT(double)
#endif
#if PPL_SUPPORTED_LONG_DOUBLE
PPL_SPECIALIZE_LIMITS_FLOAT(long double)
#endif

#undef PPL_SPECIALIZE_LIMITS_FLOAT

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Partial specialization of std::numeric_limits.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Policy>
class
numeric_limits<Checked_Number<mpz_class, Policy> >
  : public numeric_limits<mpz_class> {
private:
  typedef Checked_Number<mpz_class, Policy> Type;

public:
  static const bool has_infinity = Policy::has_infinity;
  static const bool has_quiet_NaN =  Policy::has_nan;

  static Type infinity() {
    Type v;
    Checked::assign_special<Policy>(v.raw_value(), VC_PLUS_INFINITY,
                                    ROUND_IGNORE);
    return v;
  }

  static Type quiet_NaN() {
    Type v;
    Checked::assign_special<Policy>(v.raw_value(), VC_NAN, ROUND_IGNORE);
    return v;
  }
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Partial specialization of std::numeric_limits.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Policy>
class
numeric_limits<Checked_Number<mpq_class, Policy> >
: public numeric_limits<mpq_class> {
private:
  typedef Checked_Number<mpq_class, Policy> Type;

public:
  static const bool has_infinity = Policy::has_infinity;
  static const bool has_quiet_NaN =  Policy::has_nan;

  static Type infinity() {
    Type v;
    Checked::assign_special<Policy>(v.raw_value(), VC_PLUS_INFINITY,
                                    ROUND_IGNORE);
    return v;
  }

  static Type quiet_NaN() {
    Type v;
    Checked::assign_special<Policy>(v.raw_value(), VC_NAN, ROUND_IGNORE);
    return v;
  }
};

} // namespace std

/* Automatically generated from PPL source file ../src/stdiobuf_defs.hh line 1. */
/* stdiobuf class declaration.
*/


/* Automatically generated from PPL source file ../src/stdiobuf_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class stdiobuf;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/stdiobuf_defs.hh line 28. */
#include <cstdio>
#include <streambuf>

class Parma_Polyhedra_Library::stdiobuf
  : public std::basic_streambuf<char, std::char_traits<char> > {
public:
  //! Constructor.
  stdiobuf(FILE* file);

protected:
  /*! \brief
    Gets a character in case of underflow.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.3.
  */
  virtual int_type underflow();

  /*! \brief
    In case of underflow, gets a character and advances the next pointer.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.3.
  */
  virtual int_type uflow();

  /*! \brief
    Gets a sequence of characters.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.3.
  */
  virtual std::streamsize xsgetn(char_type* s, std::streamsize n);

  /*! \brief
    Puts character back in case of backup underflow.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.4.
  */
  virtual int_type pbackfail(int_type c = traits_type::eof());

  /*! \brief
    Writes a sequence of characters.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.5.
  */
  virtual std::streamsize xsputn(const char_type* s, std::streamsize n);

  /*! \brief
    Writes a character in case of overflow.

    Specified by ISO/IEC 14882:1998: 27.5.2.4.5.
  */
  virtual int_type overflow(int_type c);

  /*! \brief
    Synchronizes the stream buffer.

    Specified by ISO/IEC 14882:1998: 27.5.2.4.2.
  */
  virtual int sync();

private:
  //! Character type of the streambuf.
  typedef char char_type;

  //! Traits type of the streambuf.
  typedef std::char_traits<char_type> traits_type;

  //! Integer type of the streambuf.
  typedef traits_type::int_type int_type;

  //! The encapsulated stdio file.
  FILE* fp;

  //! Buffer for the last character read.
  int_type unget_char_buf;
};

/* Automatically generated from PPL source file ../src/stdiobuf_inlines.hh line 1. */
/* stdiobuf class implementation: inline functions.
*/


namespace Parma_Polyhedra_Library {

inline
stdiobuf::stdiobuf(FILE* file)
  : fp(file), unget_char_buf(traits_type::eof()) {
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/stdiobuf_defs.hh line 110. */

/* Automatically generated from PPL source file ../src/c_streambuf_defs.hh line 1. */
/* c_streambuf class declaration.
*/


/* Automatically generated from PPL source file ../src/c_streambuf_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class c_streambuf;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/c_streambuf_defs.hh line 28. */
#include <streambuf>
#include <cstddef>

class Parma_Polyhedra_Library::c_streambuf
  : public std::basic_streambuf<char, std::char_traits<char> > {
public:
  //! Constructor.
  c_streambuf();

  //! Destructor.
  virtual ~c_streambuf();

protected:
  /*! \brief
    Gets a character in case of underflow.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.3.
  */
  virtual int_type underflow();

  /*! \brief
    In case of underflow, gets a character and advances the next pointer.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.3.
  */
  virtual int_type uflow();

  /*! \brief
    Gets a sequence of characters.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.3.
  */
  virtual std::streamsize xsgetn(char_type* s, std::streamsize n);

  /*! \brief
    Puts character back in case of backup underflow.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.4.
  */
  virtual int_type pbackfail(int_type c = traits_type::eof());

  /*! \brief
    Writes a sequence of characters.

    \remarks
    Specified by ISO/IEC 14882:1998: 27.5.2.4.5.
  */
  virtual std::streamsize xsputn(const char_type* s, std::streamsize n);

  /*! \brief
    Writes a character in case of overflow.

    Specified by ISO/IEC 14882:1998: 27.5.2.4.5.
  */
  virtual int_type overflow(int_type c);

  /*! \brief
    Synchronizes the stream buffer.

    Specified by ISO/IEC 14882:1998: 27.5.2.4.2.
  */
  virtual int sync();

private:
  //! Character type of the streambuf.
  typedef char char_type;

  //! Traits type of the streambuf.
  typedef std::char_traits<char_type> traits_type;

  //! Integer type of the streambuf.
  typedef traits_type::int_type int_type;

  //! Buffer for the last character read.
  int_type unget_char_buf;

  //! Buffer for next character
  int_type next_char_buf;

  virtual size_t cb_read(char *, size_t) {
    return 0;
  }
  virtual size_t cb_write(const char *, size_t) {
    return 0;
  }
  virtual int cb_sync() {
    return 0;
  }
  virtual int cb_flush() {
    return 0;
  }
};

/* Automatically generated from PPL source file ../src/c_streambuf_inlines.hh line 1. */
/* c_streambuf class implementation: inline functions.
*/


namespace Parma_Polyhedra_Library {

inline
c_streambuf::c_streambuf()
  : unget_char_buf(traits_type::eof()), next_char_buf(traits_type::eof()) {
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/c_streambuf_defs.hh line 126. */

/* Automatically generated from PPL source file ../src/Integer_Interval.hh line 1. */
/* Integer_Interval class declaration and implementation.
*/


/* Automatically generated from PPL source file ../src/Interval_defs.hh line 1. */
/* Declarations for the Interval class and its constituents.
*/


/* Automatically generated from PPL source file ../src/Interval_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename Boundary, typename Info>
class Interval;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/assign_or_swap.hh line 1. */
/* The assign_or_swap() utility functions.
*/


/* Automatically generated from PPL source file ../src/Has_Assign_Or_Swap.hh line 1. */
/* Has_Assign_Or_Swap classes declarations.
*/


/* Automatically generated from PPL source file ../src/Has_Assign_Or_Swap.hh line 28. */

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface
  The assign_or_swap() method is not present by default.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T, typename Enable = void>
struct Has_Assign_Or_Swap : public False {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface
  The assign_or_swap() method is present if it is present (!).
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
struct Has_Assign_Or_Swap<T,
                          typename Enable_If_Is<void (T::*)(T& x),
                                                &T::assign_or_swap>::type>
  : public True {
};

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/assign_or_swap.hh line 30. */

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface
  If there is an assign_or_swap() method, use it.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
inline typename Enable_If<Has_Assign_Or_Swap<T>::value, void>::type
assign_or_swap(T& to, T& from) {
  to.assign_or_swap(from);
}

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface
  If there is no assign_or_swap() method but copies are not slow, copy.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
inline typename Enable_If<!Has_Assign_Or_Swap<T>::value
                          && !Slow_Copy<T>::value, void>::type
assign_or_swap(T& to, T& from) {
  to = from;
}

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \ingroup PPL_CXX_interface
  If there is no assign_or_swap() and copies are slow, delegate to swap().
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
inline typename Enable_If<!Has_Assign_Or_Swap<T>::value
                          && Slow_Copy<T>::value, void>::type
assign_or_swap(T& to, T& from) {
  using std::swap;
  swap(to, from);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/intervals_defs.hh line 1. */
/* Helper classes for intervals.
*/


/* Automatically generated from PPL source file ../src/intervals_defs.hh line 29. */
#include <cstdlib>

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! The result of an operation on intervals.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
enum I_Result {
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Result may be empty.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_EMPTY = 1U,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Result may have only one value.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_SINGLETON = 2U,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  /*! \brief \hideinitializer
    Result may have more than one value, but it is not the domain universe.
  */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_SOME = 4U,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Result may be the domain universe.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_UNIVERSE = 8U,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Result is not empty.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_NOT_EMPTY = I_SINGLETON | I_SOME | I_UNIVERSE,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Result may be empty or not empty.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_ANY = I_EMPTY | I_NOT_EMPTY,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Result may be empty or not empty.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_NOT_UNIVERSE = I_EMPTY | I_SINGLETON | I_SOME,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Result is neither empty nor the domain universe.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_NOT_DEGENERATE = I_SINGLETON | I_SOME,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Result is definitely exact.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_EXACT = 16,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Result is definitely inexact.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_INEXACT = 32,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Operation has definitely changed the set.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_CHANGED = 64,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Operation has left the set definitely unchanged.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_UNCHANGED = 128,
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! \hideinitializer Operation is undefined for some combination of values.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  I_SINGULARITIES = 256
};

inline I_Result
operator|(I_Result a, I_Result b) {
  return static_cast<I_Result>(static_cast<unsigned>(a)
                               | static_cast<unsigned>(b));
}

inline I_Result
operator&(I_Result a, I_Result b) {
  return static_cast<I_Result>(static_cast<unsigned>(a)
                               & static_cast<unsigned>(b));
}

inline I_Result
operator-(I_Result a, I_Result b) {
    return static_cast<I_Result>(static_cast<unsigned>(a)
                                 & ~static_cast<unsigned>(b));
}

template <typename Criteria, typename T>
struct Use_By_Ref;

struct Use_Slow_Copy;
template <typename T>
struct Use_By_Ref<Use_Slow_Copy, T>
  : public Bool<Slow_Copy<T>::value> {
};

struct By_Value;
template <typename T>
struct Use_By_Ref<By_Value, T>
  : public False {
};

struct By_Ref;
template <typename T>
struct Use_By_Ref<By_Ref, T>
  : public True {
};

template <typename T, typename Criteria = Use_Slow_Copy, typename Enable = void>
class Val_Or_Ref;

template <typename T, typename Criteria>
class Val_Or_Ref<T, Criteria,
                 typename Enable_If<!Use_By_Ref<Criteria, T>::value>::type> {
  T value;
public:
  typedef T Arg_Type;
  typedef T Return_Type;
  Val_Or_Ref()
    : value() {
  }
  explicit Val_Or_Ref(Arg_Type v, bool = false)
    : value(v) {
  }
  Val_Or_Ref& operator=(Arg_Type v) {
    value = v;
    return *this;
  }
  void set(Arg_Type v, bool = false) {
    value = v;
  }
  Return_Type get() const {
    return value;
  }
  operator Return_Type() const {
    return get();
  }
};

template <typename T, typename Criteria>
class Val_Or_Ref<T, Criteria,
                 typename Enable_If<Use_By_Ref<Criteria, T>::value>::type> {
  const T* ptr;
public:
  typedef T& Arg_Type;
  typedef const T& Return_Type;
  Val_Or_Ref()
    : ptr(0) {
  }
  explicit Val_Or_Ref(Arg_Type v)
    : ptr(&v) {
  }
  Val_Or_Ref(const T& v, bool)
    : ptr(&v) {
  }
  Val_Or_Ref& operator=(Arg_Type v) {
    ptr = &v;
    return *this;
  }
  void set(Arg_Type v) {
    ptr = &v;
  }
  void set(const T& v, bool) {
    ptr = &v;
  }
  Return_Type get() const {
    return *ptr;
  }
  operator Return_Type() const {
    return get();
  }
};

class I_Constraint_Base {
};

template <typename Derived>
class I_Constraint_Common : public I_Constraint_Base {
public:
  template <typename T>
  Result convert_real(T& to) const {
    const Derived& c = static_cast<const Derived&>(*this);
    Result r = c.rel();
    switch (r) {
    case V_EMPTY:
    case V_LGE:
      return r;
    case V_LE:
      r = assign_r(to, c.value(), (ROUND_UP | ROUND_STRICT_RELATION));
      r = result_relation_class(r);
      if (r == V_EQ) {
        return V_LE;
      }
      goto lt;
    case V_LT:
      r = assign_r(to, c.value(), ROUND_UP);
      r = result_relation_class(r);
    lt:
      switch (r) {
      case V_EMPTY:
      case V_LT_PLUS_INFINITY:
      case V_EQ_MINUS_INFINITY:
        return r;
      case V_LT:
      case V_LE:
      case V_EQ:
        return V_LT;
      default:
        break;
      }
      break;
    case V_GE:
      r = assign_r(to, c.value(), (ROUND_DOWN | ROUND_STRICT_RELATION));
      r = result_relation_class(r);
      if (r == V_EQ) {
        return V_GE;
      }
      goto gt;
    case V_GT:
      r = assign_r(to, c.value(), ROUND_DOWN);
      r = result_relation_class(r);
    gt:
      switch (r) {
      case V_EMPTY:
      case V_GT_MINUS_INFINITY:
      case V_EQ_PLUS_INFINITY:
        return r;
      case V_LT:
      case V_LE:
      case V_EQ:
        return V_GT;
      default:
        break;
      }
      break;
    case V_EQ:
      r = assign_r(to, c.value(), ROUND_CHECK);
      r = result_relation_class(r);
      PPL_ASSERT(r != V_LT && r != V_GT);
      if (r == V_EQ) {
        return V_EQ;
      }
      else {
        return V_EMPTY;
      }
    case V_NE:
      r = assign_r(to, c.value(), ROUND_CHECK);
      r = result_relation_class(r);
      if (r == V_EQ) {
        return V_NE;
      }
      else {
        return V_LGE;
      }
    default:
      break;
    }
    PPL_UNREACHABLE;
    return V_EMPTY;
  }
  template <typename T>
  Result convert_real(T& to1, Result& rel2, T& to2) const {
    const Derived& c = static_cast<const Derived&>(*this);
    Result rel1;
    if (c.rel() != V_EQ) {
      rel2 = convert(to2);
      return V_LGE;
    }
    rel2 = assign_r(to2, c.value(), ROUND_UP);
    rel2 = result_relation_class(rel2);
    switch (rel2) {
    case V_EMPTY:
    case V_EQ_MINUS_INFINITY:
    case V_EQ:
      return V_LGE;
    default:
      break;
    }
    rel1 = assign_r(to1, c.value(), ROUND_DOWN);
    rel1 = result_relation_class(rel1);
    switch (rel1) {
    case V_EQ:
      PPL_ASSERT(rel2 == V_LE);
      goto eq;
    case V_EQ_PLUS_INFINITY:
    case V_EMPTY:
      rel2 = rel1;
      return V_LGE;
    case V_GE:
      if (rel2 == V_LE && to1 == to2) {
      eq:
        rel2 = V_EQ;
        return V_LGE;
      }
      /* Fall through*/
    case V_GT:
    case V_GT_MINUS_INFINITY:
      return rel1;
    default:
      PPL_UNREACHABLE;
      return V_EMPTY;
    }
    switch (rel2) {
    case V_LE:
    case V_LT:
    case V_LT_PLUS_INFINITY:
      return rel1;
    default:
      PPL_UNREACHABLE;
      return V_EMPTY;
    }
  }
  template <typename T>
  Result convert_integer(T& to) const {
    Result rel = convert_real(to);
    switch (rel) {
    case V_LT:
      if (is_integer(to)) {
        rel = sub_assign_r(to, to, T(1), (ROUND_UP | ROUND_STRICT_RELATION));
        rel = result_relation_class(rel);
        return (rel == V_EQ) ? V_LE : rel;
      }
      /* Fall through */
    case V_LE:
      rel = floor_assign_r(to, to, ROUND_UP);
      rel = result_relation_class(rel);
      PPL_ASSERT(rel == V_EQ);
      return V_LE;
    case V_GT:
      if (is_integer(to)) {
        rel = add_assign_r(to, to, T(1), (ROUND_DOWN | ROUND_STRICT_RELATION));
        rel = result_relation_class(rel);
        return (rel == V_EQ) ? V_GE : rel;
      }
      /* Fall through */
    case V_GE:
      rel = ceil_assign_r(to, to, ROUND_DOWN);
      rel = result_relation_class(rel);
      PPL_ASSERT(rel == V_EQ);
      return V_GE;
    case V_EQ:
      if (is_integer(to)) {
        return V_EQ;
      }
      return V_EMPTY;
    case V_NE:
      if (is_integer(to)) {
        return V_NE;
      }
      return V_LGE;
    default:
      return rel;
    }
  }
};

struct I_Constraint_Rel {
  Result rel;
  I_Constraint_Rel(Result r)
    : rel(r) {
    PPL_ASSERT(result_relation_class(r) == r);
  }
  I_Constraint_Rel(Relation_Symbol r)
    : rel(static_cast<Result>(r)) {
  }
  operator Result() const {
    return rel;
  }
};

template <typename T, typename Val_Or_Ref_Criteria = Use_Slow_Copy,
          bool extended = false>
class I_Constraint
  : public I_Constraint_Common<I_Constraint<T, Val_Or_Ref_Criteria,
                                            extended> > {
  typedef Val_Or_Ref<T, Val_Or_Ref_Criteria> Val_Ref;
  typedef typename Val_Ref::Arg_Type Arg_Type;
  typedef typename Val_Ref::Return_Type Return_Type;
  Result rel_;
  Val_Ref value_;
public:
  typedef T value_type;
  explicit I_Constraint()
    : rel_(V_LGE) {
  }
  I_Constraint(I_Constraint_Rel r, Arg_Type v)
    : rel_(r), value_(v) {
  }
  I_Constraint(I_Constraint_Rel r, const T& v, bool force)
    : rel_(r), value_(v, force) {
  }
  template <typename U>
  I_Constraint(I_Constraint_Rel r, const U& v)
    : rel_(r), value_(v) {
  }
  void set(I_Constraint_Rel r, Arg_Type v) {
    rel_ =  r;
    value_.set(v);
  }
  void set(I_Constraint_Rel r, const T& v, bool force) {
    rel_ =  r;
    value_.set(v, force);
  }
  template <typename U>
  void set(I_Constraint_Rel r, const U& v) {
    rel_ = r;
    value_.set(v);
  }
  Return_Type value() const {
    return value_;
  }
  Result rel() const {
    return rel_;
  }
};

template <typename T>
inline I_Constraint<T>
i_constraint(I_Constraint_Rel rel, const T& v) {
  return I_Constraint<T>(rel, v);
}

template <typename T>
inline I_Constraint<T>
i_constraint(I_Constraint_Rel rel, const T& v, bool force) {
  return I_Constraint<T>(rel, v, force);
}

template <typename T>
inline I_Constraint<T>
i_constraint(I_Constraint_Rel rel, T& v) {
  return I_Constraint<T>(rel, v);
}

template <typename T, typename Val_Or_Ref_Criteria>
inline I_Constraint<T, Val_Or_Ref_Criteria>
i_constraint(I_Constraint_Rel rel, const T& v, const Val_Or_Ref_Criteria&) {
  return I_Constraint<T, Val_Or_Ref_Criteria>(rel, v);
}

template <typename T, typename Val_Or_Ref_Criteria>
inline I_Constraint<T, Val_Or_Ref_Criteria>
i_constraint(I_Constraint_Rel rel, const T& v, bool force,
             const Val_Or_Ref_Criteria&) {
  return I_Constraint<T, Val_Or_Ref_Criteria>(rel, v, force);
}

template <typename T, typename Val_Or_Ref_Criteria>
inline I_Constraint<T, Val_Or_Ref_Criteria>
i_constraint(I_Constraint_Rel rel, T& v, const Val_Or_Ref_Criteria&) {
  return I_Constraint<T, Val_Or_Ref_Criteria>(rel, v);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Interval_Info_defs.hh line 1. */
/* Interval_Info class declaration and implementation.
*/


/* Automatically generated from PPL source file ../src/Boundary_defs.hh line 1. */
/* Interval boundary functions.
*/


/* Automatically generated from PPL source file ../src/Boundary_defs.hh line 28. */

namespace Parma_Polyhedra_Library {

namespace Boundary_NS {

struct Property {
  enum Type {
    SPECIAL_,
    OPEN_
  };
  typedef bool Value;
  static const Value default_value = true;
  static const Value unsupported_value = false;
  Property(Type t)
    : type(t) {
  }
  Type type;
};

static const Property SPECIAL(Property::SPECIAL_);
static const Property OPEN(Property::OPEN_);

enum Boundary_Type {
  LOWER = ROUND_DOWN,
  UPPER = ROUND_UP
};

inline Rounding_Dir
round_dir_check(Boundary_Type t, bool check = false) {
  if (check) {
    return static_cast<Rounding_Dir>(t) | ROUND_STRICT_RELATION;
  }
  else {
    return static_cast<Rounding_Dir>(t);
  }
}

template <typename T, typename Info>
inline Result
special_set_boundary_infinity(Boundary_Type type, T&, Info& info) {
  PPL_ASSERT(Info::store_special);
  info.set_boundary_property(type, SPECIAL);
  return V_EQ;
}

template <typename T, typename Info>
inline bool
special_is_open(Boundary_Type, const T&, const Info&) {
  return !Info::may_contain_infinity;
}

template <typename T, typename Info>
inline bool
normal_is_open(Boundary_Type type, const T& x, const Info& info) {
  if (Info::store_open) {
    return info.get_boundary_property(type, OPEN);
  }
  else {
    return !Info::store_special && !Info::may_contain_infinity
      && normal_is_boundary_infinity(type, x, info);
  }
}

template <typename T, typename Info>
inline bool
is_open(Boundary_Type type, const T& x, const Info& info) {
  if (Info::store_open) {
    return info.get_boundary_property(type, OPEN);
  }
  else {
    return !Info::may_contain_infinity
      && is_boundary_infinity(type, x, info);
  }
}

template <typename T, typename Info>
inline Result
set_unbounded(Boundary_Type type, T& x, Info& info) {
  PPL_COMPILE_TIME_CHECK(Info::store_special
                         || std::numeric_limits<T>::is_bounded
                         || std::numeric_limits<T>::has_infinity,
                         "unbounded is not representable");
  Result r;
  if (Info::store_special) {
    r = special_set_boundary_infinity(type, x, info);
  }
  else if (type == LOWER) {
    r = assign_r(x, MINUS_INFINITY, ROUND_UP);
  }
  else {
    r = assign_r(x, PLUS_INFINITY, ROUND_DOWN);
  }
  if (result_relation(r) == VR_EQ && !Info::may_contain_infinity) {
    info.set_boundary_property(type, OPEN);
  }
  return r;
}

template <typename T, typename Info>
inline Result
set_minus_infinity(Boundary_Type type, T& x, Info& info, bool open = false) {
  if (open) {
    PPL_ASSERT(type == LOWER);
  }
  else {
    PPL_ASSERT(Info::may_contain_infinity);
  }
  Result r;
  if (Info::store_special) {
    PPL_ASSERT(type == LOWER);
    r = special_set_boundary_infinity(type, x, info);
  }
  else {
    r = assign_r(x, MINUS_INFINITY, round_dir_check(type));
    PPL_ASSERT(result_representable(r));
  }
  if (open || result_relation(r) != VR_EQ) {
    info.set_boundary_property(type, OPEN);
  }
  return r;
}

template <typename T, typename Info>
inline Result
set_plus_infinity(Boundary_Type type, T& x, Info& info, bool open = false) {
  if (open) {
    PPL_ASSERT(type == UPPER);
  }
  else {
    PPL_ASSERT(Info::may_contain_infinity);
  }
  Result r;
  if (Info::store_special) {
    PPL_ASSERT(type == UPPER);
    r = special_set_boundary_infinity(type, x, info);
  }
  else {
    r = assign_r(x, PLUS_INFINITY, round_dir_check(type));
    PPL_ASSERT(result_representable(r));
  }
  if (open || result_relation(r) != VR_EQ) {
    info.set_boundary_property(type, OPEN);
  }
  return r;
}

template <typename T, typename Info>
inline Result
set_boundary_infinity(Boundary_Type type, T& x, Info& info, bool open = false) {
  PPL_ASSERT(open || Info::may_contain_infinity);
  Result r;
  if (Info::store_special) {
    r = special_set_boundary_infinity(type, x, info);
  }
  else if (type == LOWER) {
    r = assign_r(x, MINUS_INFINITY, round_dir_check(type));
  }
  else {
    r = assign_r(x, PLUS_INFINITY, round_dir_check(type));
  }
  PPL_ASSERT(result_representable(r));
  if (open) {
    info.set_boundary_property(type, OPEN);
  }
  return r;
}

template <typename T, typename Info>
inline bool
is_domain_inf(Boundary_Type type, const T& x, const Info& info) {
  if (Info::store_special && type == LOWER) {
    return info.get_boundary_property(type, SPECIAL);
  }
  else if (std::numeric_limits<T>::has_infinity) {
    return Parma_Polyhedra_Library::is_minus_infinity(x);
  }
  else if (std::numeric_limits<T>::is_bounded) {
    return x == std::numeric_limits<T>::min();
  }
  else {
    return false;
  }
}

template <typename T, typename Info>
inline bool
is_domain_sup(Boundary_Type type, const T& x, const Info& info) {
  if (Info::store_special && type == UPPER) {
    return info.get_boundary_property(type, SPECIAL);
  }
  else if (std::numeric_limits<T>::has_infinity) {
    return Parma_Polyhedra_Library::is_plus_infinity(x);
  }
  else if (std::numeric_limits<T>::is_bounded) {
      return x == std::numeric_limits<T>::max();
  }
  else {
    return false;
  }
}

template <typename T, typename Info>
inline bool
normal_is_boundary_infinity(Boundary_Type type, const T& x, const Info&) {
  if (!std::numeric_limits<T>::has_infinity) {
    return false;
  }
  if (type == LOWER) {
    return Parma_Polyhedra_Library::is_minus_infinity(x);
  }
  else {
    return Parma_Polyhedra_Library::is_plus_infinity(x);
  }
}

template <typename T, typename Info>
inline bool
is_boundary_infinity(Boundary_Type type, const T& x, const Info& info) {
  if (Info::store_special) {
    return info.get_boundary_property(type, SPECIAL);
  }
  else {
    return normal_is_boundary_infinity(type, x, info);
  }
}

template <typename T, typename Info>
inline bool
normal_is_reverse_infinity(Boundary_Type type, const T& x, const Info&) {
  if (!Info::may_contain_infinity) {
    return false;
  }
  else if (type == LOWER) {
    return Parma_Polyhedra_Library::is_plus_infinity(x);
  }
  else {
    return Parma_Polyhedra_Library::is_minus_infinity(x);
  }
}

template <typename T, typename Info>
inline bool
is_minus_infinity(Boundary_Type type, const T& x, const Info& info) {
  if (type == LOWER) {
    if (Info::store_special) {
      return info.get_boundary_property(type, SPECIAL);
    }
    else {
      return normal_is_boundary_infinity(type, x, info);
    }
  }
  else {
    return !Info::store_special && normal_is_reverse_infinity(type, x, info);
  }
}

template <typename T, typename Info>
inline bool
is_plus_infinity(Boundary_Type type, const T& x, const Info& info) {
  if (type == UPPER) {
    if (Info::store_special) {
      return info.get_boundary_property(type, SPECIAL);
    }
    else {
      return normal_is_boundary_infinity(type, x, info);
    }
  }
  else {
    return !Info::store_special && normal_is_reverse_infinity(type, x, info);
  }
}

template <typename T, typename Info>
inline bool
is_reverse_infinity(Boundary_Type type, const T& x, const Info& info) {
  return normal_is_reverse_infinity(type, x, info);
}

template <typename T, typename Info>
inline int
infinity_sign(Boundary_Type type, const T& x, const Info& info) {
  if (is_boundary_infinity(type, x, info)) {
    return (type == LOWER) ? -1 : 1;
  }
  else if (is_reverse_infinity(type, x, info)) {
    return (type == UPPER) ? -1 : 1;
  }
  else {
    return 0;
  }
}

template <typename T, typename Info>
inline bool
is_boundary_infinity_closed(Boundary_Type type, const T& x, const Info& info) {
  return Info::may_contain_infinity
    && !info.get_boundary_property(type, OPEN)
    && is_boundary_infinity(type, x, info);
}

template <typename Info>
inline bool
boundary_infinity_is_open(Boundary_Type type, const Info& info) {
  return !Info::may_contain_infinity
    || info.get_boundary_property(type, OPEN);
}

template <typename T, typename Info>
inline int
sgn_b(Boundary_Type type, const T& x, const Info& info) {
  if (info.get_boundary_property(type, SPECIAL)) {
    return (type == LOWER) ? -1 : 1;
  }
  else {
    // The following Parma_Polyhedra_Library:: qualification is to work
    // around a bug of GCC 4.0.x.
    return Parma_Polyhedra_Library::sgn(x);
  }
}

template <typename T, typename Info>
inline int
sgn(Boundary_Type type, const T& x, const Info& info) {
  int sign = sgn_b(type, x, info);
  if (x == 0 && info.get_boundary_property(type, OPEN)) {
    return (type == LOWER) ? -1 : 1;
  }
  else {
    return sign;
  }
}

template <typename T1, typename Info1, typename T2, typename Info2>
inline bool
eq(Boundary_Type type1, const T1& x1, const Info1& info1,
   Boundary_Type type2, const T2& x2, const Info2& info2) {
  if (type1 == type2) {
    if (is_open(type1, x1, info1)
        != is_open(type2, x2, info2)) {
      return false;
    }
  }
  else if (is_open(type1, x1, info1)
           || is_open(type2, x2, info2)) {
    return false;
  }
  if (is_minus_infinity(type1, x1, info1)) {
    return is_minus_infinity(type2, x2, info2);
  }
  else if (is_plus_infinity(type1, x1, info1)) {
    return is_plus_infinity(type2, x2, info2);
  }
  else if (is_minus_infinity(type2, x2, info2)
           || is_plus_infinity(type2, x2, info2)) {
    return false;
  }
  else {
    return equal(x1, x2);
  }
}

template <typename T1, typename Info1, typename T2, typename Info2>
inline bool
lt(Boundary_Type type1, const T1& x1, const Info1& info1,
   Boundary_Type type2, const T2& x2, const Info2& info2) {
  if (is_open(type1, x1, info1)) {
    if (type1 == UPPER
        && (type2 == LOWER
            || !is_open(type2, x2, info2))) {
      goto le;
    }
  }
  else if (type2 == LOWER
           && is_open(type2, x2, info2)) {
  le:
    if (is_minus_infinity(type1, x1, info1)
        || is_plus_infinity(type2, x2, info2)) {
      return true;
    }
    if (is_plus_infinity(type1, x1, info1)
        || is_minus_infinity(type2, x2, info2)) {
      return false;
    }
    else {
      return less_or_equal(x1, x2);
    }
  }
  if (is_plus_infinity(type1, x1, info1)
      || is_minus_infinity(type2, x2, info2)) {
    return false;
  }
  if (is_minus_infinity(type1, x1, info1)
      || is_plus_infinity(type2, x2, info2)) {
    return true;
  }
  else {
    return less_than(x1, x2);
  }
}

template <typename T1, typename Info1, typename T2, typename Info2>
inline bool
gt(Boundary_Type type1, const T1& x1, const Info1& info1,
   Boundary_Type type2, const T2& x2, const Info2& info2) {
  return lt(type2, x2, info2, type1, x1, info1);
}

template <typename T1, typename Info1, typename T2, typename Info2>
inline bool
le(Boundary_Type type1, const T1& x1, const Info1& info1,
   Boundary_Type type2, const T2& x2, const Info2& info2) {
  return !gt(type1, x1, info1, type2, x2, info2);
}

template <typename T1, typename Info1, typename T2, typename Info2>
inline bool
ge(Boundary_Type type1, const T1& x1, const Info1& info1,
   Boundary_Type type2, const T2& x2, const Info2& info2) {
  return !lt(type1, x1, info1, type2, x2, info2);
}

template <typename T, typename Info>
inline Result
adjust_boundary(Boundary_Type type, T& x, Info& info,
                bool open, Result r) {
  r = result_relation_class(r);
  if (type == LOWER) {
    switch (r) {
    case V_GT_MINUS_INFINITY:
      open = true;
      /* Fall through */
    case V_EQ_MINUS_INFINITY:
      if (!Info::store_special) {
        return r;
      }
      if (open) {
        info.set_boundary_property(type, OPEN);
      }
      return special_set_boundary_infinity(type, x, info);
    case V_GT:
      open = true;
      /* Fall through */
    case V_GE:
    case V_EQ:
      if (open) {
        info.set_boundary_property(type, OPEN);
      }
      return r;
    default:
      PPL_UNREACHABLE;
      return V_NAN;
    }
  }
  else {
    switch (r) {
    case V_LT_PLUS_INFINITY:
      open = true;
      /* Fall through */
    case V_EQ_PLUS_INFINITY:
      if (!Info::store_special) {
        return r;
      }
      if (open) {
        info.set_boundary_property(type, OPEN);
      }
      return special_set_boundary_infinity(type, x, info);
    case V_LT:
      open = true;
      /* Fall through */
    case V_LE:
    case V_EQ:
      if (open) {
        info.set_boundary_property(type, OPEN);
      }
      return r;
    default:
      PPL_UNREACHABLE;
      return V_NAN;
    }
  }
}

template <typename To, typename To_Info, typename T, typename Info>
inline Result
complement(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type, const T& x, const Info& info) {
  PPL_ASSERT(to_type != type);
  bool should_shrink;
  if (info.get_boundary_property(type, SPECIAL)) {
    should_shrink = !special_is_open(type, x, info);
    if (type == LOWER) {
      return set_minus_infinity(to_type, to, to_info, should_shrink);
    }
    else {
      return set_plus_infinity(to_type, to, to_info, should_shrink);
    }
  }
  should_shrink = !normal_is_open(type, x, info);
  bool check = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  Result r = assign_r(to, x, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}

template <typename To, typename To_Info, typename T, typename Info>
inline Result
assign(Boundary_Type to_type, To& to, To_Info& to_info,
       Boundary_Type type, const T& x, const Info& info,
       bool should_shrink = false) {
  PPL_ASSERT(to_type == type);
  if (info.get_boundary_property(type, SPECIAL)) {
    should_shrink = (should_shrink || special_is_open(type, x, info));
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  should_shrink = (should_shrink || normal_is_open(type, x, info));
  const bool check
    = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  const Result r = assign_r(to, x, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}

template <typename To, typename To_Info, typename T, typename Info>
inline Result
min_assign(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type, const T& x, const Info& info) {
  if (lt(type, x, info, to_type, to, to_info)) {
    to_info.clear_boundary_properties(to_type);
    return assign(to_type, to, to_info, type, x, info);
  }
  return V_EQ;
}

template <typename To, typename To_Info, typename T1, typename Info1, typename T2, typename Info2>
inline Result
min_assign(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type1, const T1& x1, const Info1& info1,
           Boundary_Type type2, const T2& x2, const Info2& info2) {
  if (lt(type1, x1, info1, type2, x2, info2)) {
    return assign(to_type, to, to_info, type1, x1, info1);
  }
  else {
    return assign(to_type, to, to_info, type2, x2, info2);
  }
}

template <typename To, typename To_Info, typename T, typename Info>
inline Result
max_assign(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type, const T& x, const Info& info) {
  if (gt(type, x, info, to_type, to, to_info)) {
    to_info.clear_boundary_properties(to_type);
    return assign(to_type, to, to_info, type, x, info);
  }
  return V_EQ;
}

template <typename To, typename To_Info, typename T1, typename Info1, typename T2, typename Info2>
inline Result
max_assign(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type1, const T1& x1, const Info1& info1,
           Boundary_Type type2, const T2& x2, const Info2& info2) {
  if (gt(type1, x1, info1, type2, x2, info2)) {
    return assign(to_type, to, to_info, type1, x1, info1);
  }
  else {
    return assign(to_type, to, to_info, type2, x2, info2);
  }
}

template <typename To, typename To_Info, typename T, typename Info>
inline Result
neg_assign(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type, const T& x, const Info& info) {
  PPL_ASSERT(to_type != type);
  bool should_shrink;
  if (info.get_boundary_property(type, SPECIAL)) {
    should_shrink = special_is_open(type, x, info);
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  should_shrink = normal_is_open(type, x, info);
  bool check = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  Result r = neg_assign_r(to, x, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}

template <typename To, typename To_Info, typename T1, typename Info1, typename T2, typename Info2>
inline Result
add_assign(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type1, const T1& x1, const Info1& info1,
           Boundary_Type type2, const T2& x2, const Info2& info2) {
  PPL_ASSERT(type1 == type2);
  bool should_shrink;
  if (is_boundary_infinity(type1, x1, info1)) {
    should_shrink = (boundary_infinity_is_open(type1, info1)
                     && !is_boundary_infinity_closed(type2, x2, info2));
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  else if (is_boundary_infinity(type2, x2, info2)) {
    should_shrink = (boundary_infinity_is_open(type2, info2)
                     && !is_boundary_infinity_closed(type1, x1, info1));
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  should_shrink = (normal_is_open(type1, x1, info1)
                   || normal_is_open(type2, x2, info2));
  bool check = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  // FIXME: extended handling is not needed
  Result r = add_assign_r(to, x1, x2, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}

template <typename To, typename To_Info, typename T1, typename Info1, typename T2, typename Info2>
inline Result
sub_assign(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type1, const T1& x1, const Info1& info1,
           Boundary_Type type2, const T2& x2, const Info2& info2) {
  PPL_ASSERT(type1 != type2);
  bool should_shrink;
  if (is_boundary_infinity(type1, x1, info1)) {
    should_shrink = (boundary_infinity_is_open(type1, info1)
                     && !is_boundary_infinity_closed(type2, x2, info2));
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  else if (is_boundary_infinity(type2, x2, info2)) {
    should_shrink = (boundary_infinity_is_open(type2, info2)
                     && !is_boundary_infinity_closed(type1, x1, info1));
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  should_shrink = (normal_is_open(type1, x1, info1)
                   || normal_is_open(type2, x2, info2));
  bool check = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  // FIXME: extended handling is not needed
  Result r = sub_assign_r(to, x1, x2, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}

template <typename To, typename To_Info, typename T1, typename Info1, typename T2, typename Info2>
inline Result
mul_assign(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type1, const T1& x1, const Info1& info1,
           Boundary_Type type2, const T2& x2, const Info2& info2) {
  bool should_shrink;
  if (is_boundary_infinity(type1, x1, info1)) {
    should_shrink = (boundary_infinity_is_open(type1, info1)
                     && !is_boundary_infinity_closed(type2, x2, info2));
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  else if (is_boundary_infinity(type2, x2, info2)) {
    should_shrink = (boundary_infinity_is_open(type2, info2)
                     && !is_boundary_infinity_closed(type1, x1, info1));
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  should_shrink = (normal_is_open(type1, x1, info1)
                   || normal_is_open(type2, x2, info2));
  bool check = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  PPL_ASSERT(x1 != Constant<0>::value && x2 != Constant<0>::value);
  // FIXME: extended handling is not needed
  Result r = mul_assign_r(to, x1, x2, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}

template <typename To, typename To_Info>
inline Result
set_zero(Boundary_Type to_type, To& to, To_Info& to_info, bool should_shrink) {
  bool check = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  Result r = assign_r(to, Constant<0>::value, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}

template <typename To, typename To_Info, typename T1, typename Info1, typename T2, typename Info2>
inline Result
mul_assign_z(Boundary_Type to_type, To& to, To_Info& to_info,
             Boundary_Type type1, const T1& x1, const Info1& info1, int x1s,
             Boundary_Type type2, const T2& x2, const Info2& info2, int x2s) {
  bool should_shrink;
  if (x1s != 0) {
    if (x2s != 0) {
      return mul_assign(to_type, to, to_info,
                        type1, x1, info1,
                        type2, x2, info2);
    }
    else {
      should_shrink = info2.get_boundary_property(type2, OPEN);
    }
  }
  else {
    should_shrink = (info1.get_boundary_property(type1, OPEN)
                     && (x2s != 0 || info2.get_boundary_property(type2, OPEN)));
  }
  return set_zero(to_type, to, to_info, should_shrink);
}

template <typename To, typename To_Info, typename T1, typename Info1, typename T2, typename Info2>
inline Result
div_assign(Boundary_Type to_type, To& to, To_Info& to_info,
           Boundary_Type type1, const T1& x1, const Info1& info1,
           Boundary_Type type2, const T2& x2, const Info2& info2) {
  bool should_shrink;
  if (is_boundary_infinity(type1, x1, info1)) {
    should_shrink = boundary_infinity_is_open(type1, info1);
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  else if (is_boundary_infinity(type2, x2, info2)) {
    should_shrink = boundary_infinity_is_open(type2, info2);
    return set_zero(to_type, to, to_info, should_shrink);
  }
  should_shrink = (normal_is_open(type1, x1, info1)
                   || normal_is_open(type2, x2, info2));
  bool check = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  PPL_ASSERT(x1 != Constant<0>::value && x2 != Constant<0>::value);
  // FIXME: extended handling is not needed
  Result r = div_assign_r(to, x1, x2, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}


template <typename To, typename To_Info, typename T1, typename Info1, typename T2, typename Info2>
inline Result
div_assign_z(Boundary_Type to_type, To& to, To_Info& to_info,
             Boundary_Type type1, const T1& x1, const Info1& info1, int x1s,
             Boundary_Type type2, const T2& x2, const Info2& info2, int x2s) {
  if (x1s != 0) {
    if (x2s != 0) {
      return div_assign(to_type, to, to_info,
                        type1, x1, info1,
                        type2, x2, info2);
    }
    else {
      return set_boundary_infinity(to_type, to, to_info, true);
    }
  }
  else {
    bool should_shrink = info1.get_boundary_property(type1, OPEN)
      && !is_boundary_infinity_closed(type2, x2, info2);
    return set_zero(to_type, to, to_info, should_shrink);
  }
}

template <typename To, typename To_Info, typename T, typename Info>
inline Result
umod_2exp_assign(Boundary_Type to_type, To& to, To_Info& to_info,
                 Boundary_Type type, const T& x, const Info& info,
                 unsigned int exp) {
  PPL_ASSERT(to_type == type);
  bool should_shrink;
  if (is_boundary_infinity(type, x, info)) {
    should_shrink = boundary_infinity_is_open(type, info);
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  should_shrink = normal_is_open(type, x, info);
  bool check = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  Result r = umod_2exp_assign_r(to, x, exp, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}

template <typename To, typename To_Info, typename T, typename Info>
inline Result
smod_2exp_assign(Boundary_Type to_type, To& to, To_Info& to_info,
                 Boundary_Type type, const T& x, const Info& info,
                 unsigned int exp) {
  PPL_ASSERT(to_type == type);
  bool should_shrink;
  if (is_boundary_infinity(type, x, info)) {
    should_shrink = boundary_infinity_is_open(type, info);
    return set_boundary_infinity(to_type, to, to_info, should_shrink);
  }
  should_shrink = normal_is_open(type, x, info);
  bool check = (To_Info::check_inexact || (!should_shrink && To_Info::store_open));
  Result r = smod_2exp_assign_r(to, x, exp, round_dir_check(to_type, check));
  return adjust_boundary(to_type, to, to_info, should_shrink, r);
}

} // namespace Boundary_NS

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Interval_Info_defs.hh line 28. */
#include <iostream>

namespace Parma_Polyhedra_Library {

namespace Interval_NS {

struct Property {
  enum Type {
    CARDINALITY_0_,
    CARDINALITY_1_,
    CARDINALITY_IS_
  };
  typedef bool Value;
  static const Value default_value = true;
  static const Value unsupported_value = false;
  Property(Type t)
    : type(t) {
  }
  Type type;
};

const Property CARDINALITY_0(Property::CARDINALITY_0_);
const Property CARDINALITY_1(Property::CARDINALITY_1_);
const Property CARDINALITY_IS(Property::CARDINALITY_IS_);

template <typename T>
inline void
reset_bits(T& bits) {
  bits = 0;
}

template <typename T>
inline void
reset_bit(T& bits, unsigned int bit) {
  bits &= ~(static_cast<T>(1) << bit);
}

template <typename T>
inline void
set_bit(T& bits, unsigned int bit, bool value) {
  if (value) {
    bits |= static_cast<T>(1) << bit;
  }
  else {
    reset_bit(bits, bit);
  }
}

template <typename T>
inline bool
get_bit(const T& bits, unsigned int bit) {
  return (bits & (static_cast<T>(1) << bit)) != 0;
}

template <typename T>
inline void
set_bits(T& bits, unsigned int start, unsigned int len, T value) {
  bits &= ~(((static_cast<T>(1) << len) - 1) << start);
  bits |= value << start;
}

template <typename T>
inline T
get_bits(T& bits, unsigned int start, unsigned int len) {
  return (bits >> start) & ((static_cast<T>(1) << len) - 1);
}

} // namespace Interval_NS

using namespace Interval_NS;
using namespace Boundary_NS;


template <typename Policy>
class Interval_Info_Null {
public:
  const_bool_nodef(may_be_empty, Policy::may_be_empty);
  const_bool_nodef(may_contain_infinity, Policy::may_contain_infinity);
  const_bool_nodef(check_inexact, Policy::check_inexact);
  const_bool_nodef(store_special, false);
  const_bool_nodef(store_open, false);
  const_bool_nodef(cache_empty, false);
  const_bool_nodef(cache_singleton, false);
  Interval_Info_Null() {
  }
  void clear() {
  }
  void clear_boundary_properties(Boundary_Type) {
  }

  template <typename Property>
  void set_boundary_property(Boundary_Type, const Property&, typename Property::Value = Property::default_value) {
  }
  template <typename Property>
  typename Property::Value get_boundary_property(Boundary_Type, const Property&) const {
    return Property::unsupported_value;
  }
  template <typename Property>
  void set_interval_property(const Property&, typename Property::Value = Property::default_value) {
  }
  template <typename Property>
  typename Property::Value get_interval_property(const Property&) const {
    return Property::unsupported_value;
  }

  //! Swaps \p *this with \p y.
  void m_swap(Interval_Info_Null& y);

  void ascii_dump(std::ostream& s) const;
  bool ascii_load(std::istream& s);
};

template <typename Policy>
class Interval_Info_Null_Open : public Interval_Info_Null<Policy> {
public:
  const_bool_nodef(store_open, true);
  Interval_Info_Null_Open(bool o)
    : open(o) {
  }
  bool get_boundary_property(Boundary_Type,
                             const Boundary_NS::Property& p) const {
    if (p.type == Boundary_NS::Property::OPEN_) {
      return open;
    }
    else {
      return Boundary_NS::Property::unsupported_value;
    }
  }

  void ascii_dump(std::ostream& s) const;
  bool ascii_load(std::istream& s);

private:
  bool open;
};


template <typename T, typename Policy>
class Interval_Info_Bitset {
public:
  const_bool_nodef(may_be_empty, Policy::may_be_empty);
  const_bool_nodef(may_contain_infinity, Policy::may_contain_infinity);
  const_bool_nodef(check_inexact, Policy::check_inexact);
  const_bool_nodef(store_special, Policy::store_special);
  const_bool_nodef(store_open, Policy::store_open);
  const_bool_nodef(cache_empty, Policy::cache_empty);
  const_bool_nodef(cache_singleton, Policy::cache_singleton);
  const_int_nodef(lower_special_bit, Policy::next_bit);
  const_int_nodef(lower_open_bit, lower_special_bit + (store_special ? 1 : 0));
  const_int_nodef(upper_special_bit, lower_open_bit + (store_open ? 1 : 0));
  const_int_nodef(upper_open_bit, upper_special_bit + (store_special ? 1 : 0));
  const_int_nodef(cardinality_is_bit, upper_open_bit + (store_open ? 1 : 0));
  const_int_nodef(cardinality_0_bit, cardinality_is_bit
                  + ((cache_empty || cache_singleton) ? 1 : 0));
  const_int_nodef(cardinality_1_bit, cardinality_0_bit + (cache_empty ? 1 : 0));
  const_int_nodef(next_bit, cardinality_1_bit + (cache_singleton ? 1 : 0));

  Interval_Info_Bitset() {
    // FIXME: would we have speed benefits with uninitialized info?
    // (Dirty_Temp)
    clear();
  }

  void clear() {
    reset_bits(bitset);
  }
  void clear_boundary_properties(Boundary_Type t) {
    set_boundary_property(t, SPECIAL, false);
    set_boundary_property(t, OPEN, false);
  }
  void set_boundary_property(Boundary_Type t,
                             const Boundary_NS::Property& p,
                             bool value = true) {
    switch (p.type) {
    case Boundary_NS::Property::SPECIAL_:
      if (store_special) {
        if (t == LOWER) {
          set_bit(bitset, lower_special_bit, value);
        }
        else {
          set_bit(bitset, upper_special_bit, value);
        }
      }
      break;
    case Boundary_NS::Property::OPEN_:
      if (store_open) {
        if (t == LOWER) {
          set_bit(bitset, lower_open_bit, value);
        }
        else {
          set_bit(bitset, upper_open_bit, value);
        }
      }
      break;
    default:
      break;
    }
  }
  bool get_boundary_property(Boundary_Type t, const Boundary_NS::Property& p) const {
    switch (p.type) {
    case Boundary_NS::Property::SPECIAL_:
      if (!store_special) {
        return false;
      }
      if (t == LOWER) {
        return get_bit(bitset, lower_special_bit);
      }
      else {
        return get_bit(bitset, upper_special_bit);
      }
    case Boundary_NS::Property::OPEN_:
      if (!store_open) {
        return false;
      }
      else if (t == LOWER) {
        return get_bit(bitset, lower_open_bit);
      }
      else {
        return get_bit(bitset, upper_open_bit);
      }
    default:
      return false;
    }
  }
  void set_interval_property(const Interval_NS::Property& p, bool value = true) {
    switch (p.type) {
    case Interval_NS::Property::CARDINALITY_0_:
      if (cache_empty) {
        set_bit(bitset, cardinality_0_bit, value);
      }
      break;
    case Interval_NS::Property::CARDINALITY_1_:
      if (cache_singleton) {
        set_bit(bitset, cardinality_1_bit, value);
      }
      break;
    case Interval_NS::Property::CARDINALITY_IS_:
      if (cache_empty || cache_singleton) {
        set_bit(bitset, cardinality_is_bit, value);
      }
      break;
    default:
      break;
    }
  }
  bool get_interval_property(Interval_NS::Property p) const {
    switch (p.type) {
    case Interval_NS::Property::CARDINALITY_0_:
      return cache_empty && get_bit(bitset, cardinality_0_bit);
    case Interval_NS::Property::CARDINALITY_1_:
      return cache_singleton && get_bit(bitset, cardinality_1_bit);
    case Interval_NS::Property::CARDINALITY_IS_:
      return (cache_empty || cache_singleton)
        && get_bit(bitset, cardinality_is_bit);
    default:
      return false;
    }
  }

  //! Swaps \p *this with \p y.
  void m_swap(Interval_Info_Bitset& y);

  void ascii_dump(std::ostream& s) const;
  bool ascii_load(std::istream& s);

protected:
  T bitset;
};

}

/* Automatically generated from PPL source file ../src/Interval_Info_inlines.hh line 1. */
/* Interval_Info class implementation: inline functions.
*/


#include <iomanip>

namespace Parma_Polyhedra_Library {

template <typename Policy>
inline void
Interval_Info_Null<Policy>::m_swap(Interval_Info_Null<Policy>&) {
}

template <typename Policy>
inline void
Interval_Info_Null<Policy>::ascii_dump(std::ostream&) const {
}

template <typename Policy>
inline bool
Interval_Info_Null<Policy>::ascii_load(std::istream&) {
  return true;
}

template <typename Policy>
inline void
Interval_Info_Null_Open<Policy>::ascii_dump(std::ostream& s) const {
  s << (open ? "open" : "closed");
}

template <typename Policy>
inline bool
Interval_Info_Null_Open<Policy>::ascii_load(std::istream& s) {
  std::string str;
  if (!(s >> str)) {
    return false;
  }
  if (str == "open") {
    open = true;
    return true;
  }
  if (str == "closed") {
    open = false;
    return true;
  }
  return false;
}

template <typename T, typename Policy>
inline void
Interval_Info_Bitset<T, Policy>::m_swap(Interval_Info_Bitset<T, Policy>& y) {
  using std::swap;
  swap(bitset, y.bitset);
}

template <typename T, typename Policy>
inline void
Interval_Info_Bitset<T, Policy>::ascii_dump(std::ostream& s) const {
  const std::ios::fmtflags old_flags = s.setf(std::ios::hex,
                                              std::ios::basefield);
  s << bitset;
  s.flags(old_flags);
}

template <typename T, typename Policy>
inline bool
Interval_Info_Bitset<T, Policy>::ascii_load(std::istream& s) {
  const std::ios::fmtflags old_flags = s.setf(std::ios::hex,
                                              std::ios::basefield);
  s >> bitset;
  s.flags(old_flags);
  return !s.fail();
}

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \relates Interval_Info_Null */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Policy>
inline void
swap(Interval_Info_Null<Policy>& x, Interval_Info_Null<Policy>& y) {
  x.m_swap(y);
}

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \relates Interval_Info_Bitset */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T, typename Policy>
inline void
swap(Interval_Info_Bitset<T, Policy>& x, Interval_Info_Bitset<T, Policy>& y) {
  x.m_swap(y);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Interval_Info_defs.hh line 300. */

/* Automatically generated from PPL source file ../src/Interval_defs.hh line 33. */
#include <iosfwd>

namespace Parma_Polyhedra_Library {

enum Ternary { T_YES, T_NO, T_MAYBE };

inline I_Result
combine(Result l, Result u) {
  const unsigned res
    = static_cast<unsigned>(l) | (static_cast<unsigned>(u) << 6);
  return static_cast<I_Result>(res);
}

struct Interval_Base {
};

using namespace Boundary_NS;
using namespace Interval_NS;

template <typename T, typename Enable = void>
struct Is_Singleton : public Is_Native_Or_Checked<T> {};

template <typename T>
struct Is_Interval : public Is_Same_Or_Derived<Interval_Base, T> {};

//! A generic, not necessarily closed, possibly restricted interval.
/*! \ingroup PPL_CXX_interface
  The class template type parameter \p Boundary represents the type
  of the interval boundaries, and can be chosen, among other possibilities,
  within one of the following number families:

  - a bounded precision native integer type (that is,
    from <CODE>signed char</CODE> to <CODE>long long</CODE>
    and from <CODE>int8_t</CODE> to <CODE>int64_t</CODE>);
  - a bounded precision floating point type (<CODE>float</CODE>,
    <CODE>double</CODE> or <CODE>long double</CODE>);
  - an unbounded integer or rational type, as provided by the C++ interface
    of GMP (<CODE>mpz_class</CODE> or <CODE>mpq_class</CODE>).

  The class template type parameter \p Info allows to control a number
  of features of the class, among which:

  - the ability to support open as well as closed boundaries;
  - the ability to represent empty intervals in addition to nonempty ones;
  - the ability to represent intervals of extended number families
    that contain positive and negative infinities;
*/
template <typename Boundary, typename Info>
class Interval : public Interval_Base, private Info {
private:
  PPL_COMPILE_TIME_CHECK(!Info::store_special
                         || !std::numeric_limits<Boundary>::has_infinity,
                         "store_special is meaningless"
                         " when boundary type may contains infinity");
  Info& w_info() const {
    return const_cast<Interval&>(*this);
  }

public:
  typedef Boundary boundary_type;
  typedef Info info_type;

  typedef Interval_NS::Property Property;

  template <typename T>
  typename Enable_If<Is_Singleton<T>::value || Is_Interval<T>::value, Interval&>::type
  operator=(const T& x) {
    assign(x);
    return *this;
  }

  template <typename T>
  typename Enable_If<Is_Singleton<T>::value || Is_Interval<T>::value, Interval&>::type
  operator+=(const T& x) {
    add_assign(*this, x);
    return *this;
  }
  template <typename T>
  typename Enable_If<Is_Singleton<T>::value || Is_Interval<T>::value, Interval&>::type
  operator-=(const T& x) {
    sub_assign(*this, x);
    return *this;
  }
  template <typename T>
  typename Enable_If<Is_Singleton<T>::value || Is_Interval<T>::value, Interval&>::type
  operator*=(const T& x) {
    mul_assign(*this, x);
    return *this;
  }
  template <typename T>
  typename Enable_If<Is_Singleton<T>::value || Is_Interval<T>::value, Interval&>::type
  operator/=(const T& x) {
    div_assign(*this, x);
    return *this;
  }

  //! Swaps \p *this with \p y.
  void m_swap(Interval& y);

  Info& info() {
    return *this;
  }

  const Info& info() const {
    return *this;
  }

  Boundary& lower() {
    return lower_;
  }

  const Boundary& lower() const {
    return lower_;
  }

  Boundary& upper() {
    return upper_;
  }

  const Boundary& upper() const {
    return upper_;
  }

  I_Constraint<boundary_type> lower_constraint() const {
    PPL_ASSERT(!is_empty());
    if (info().get_boundary_property(LOWER, SPECIAL)) {
      return I_Constraint<boundary_type>();
    }
    return i_constraint(lower_is_open() ? GREATER_THAN : GREATER_OR_EQUAL,
                        lower(), true);
  }
  I_Constraint<boundary_type> upper_constraint() const {
    PPL_ASSERT(!is_empty());
    if (info().get_boundary_property(UPPER, SPECIAL)) {
      return I_Constraint<boundary_type>();
    }
    return i_constraint(upper_is_open() ? LESS_THAN : LESS_OR_EQUAL,
                        upper(), true);
  }

  bool is_empty() const {
    return lt(UPPER, upper(), info(), LOWER, lower(), info());
  }

  bool check_empty(I_Result r) const {
    return (r & I_ANY) == I_EMPTY
      || ((r & I_ANY) != I_NOT_EMPTY && is_empty());
  }

  bool is_singleton() const {
    return eq(LOWER, lower(), info(), UPPER, upper(), info());
  }

  bool lower_is_open() const {
    PPL_ASSERT(OK());
    return is_open(LOWER, lower(), info());
  }

  bool upper_is_open() const {
    PPL_ASSERT(OK());
    return is_open(UPPER, upper(), info());
  }

  bool lower_is_boundary_infinity() const {
    PPL_ASSERT(OK());
    return Boundary_NS::is_boundary_infinity(LOWER, lower(), info());
  }

  bool upper_is_boundary_infinity() const {
    PPL_ASSERT(OK());
    return Boundary_NS::is_boundary_infinity(UPPER, upper(), info());
  }

  bool lower_is_domain_inf() const {
    PPL_ASSERT(OK());
    return Boundary_NS::is_domain_inf(LOWER, lower(), info());
  }

  bool upper_is_domain_sup() const {
    PPL_ASSERT(OK());
    return Boundary_NS::is_domain_sup(UPPER, upper(), info());
  }

  bool is_bounded() const {
    PPL_ASSERT(OK());
    return !lower_is_boundary_infinity() && !upper_is_boundary_infinity();
  }

  bool is_universe() const {
    PPL_ASSERT(OK());
    return lower_is_domain_inf() && upper_is_domain_sup();
  }

  I_Result lower_extend() {
    info().clear_boundary_properties(LOWER);
    set_unbounded(LOWER, lower(), info());
    return I_ANY;
  }

  template <typename C>
  typename Enable_If<Is_Same_Or_Derived<I_Constraint_Base, C>::value, I_Result>::type
  lower_extend(const C& c);

  I_Result upper_extend() {
    info().clear_boundary_properties(UPPER);
    set_unbounded(UPPER, upper(), info());
    return I_ANY;
  }

  template <typename C>
  typename Enable_If<Is_Same_Or_Derived<I_Constraint_Base, C>::value, I_Result>::type
  upper_extend(const C& c);

  I_Result build() {
    return assign(UNIVERSE);
  }

  template <typename C>
  typename Enable_If<Is_Same_Or_Derived<I_Constraint_Base, C>::value, I_Result>::type
  build(const C& c) {
    Relation_Symbol rs;
    switch (c.rel()) {
    case V_LGE:
    case V_GT_MINUS_INFINITY:
    case V_LT_PLUS_INFINITY:
      return assign(UNIVERSE);
    default:
      return assign(EMPTY);
    case V_LT:
    case V_LE:
    case V_GT:
    case V_GE:
    case V_EQ:
    case V_NE:
      assign(UNIVERSE);
      rs = static_cast<Relation_Symbol>(c.rel());
      return refine_existential(rs, c.value());
    }
  }

  template <typename C1, typename C2>
  typename Enable_If<Is_Same_Or_Derived<I_Constraint_Base, C1>::value
                     &&
                     Is_Same_Or_Derived<I_Constraint_Base, C2>::value,
                     I_Result>::type
  build(const C1& c1, const C2& c2) {
    switch (c1.rel()) {
    case V_LGE:
      return build(c2);
    case V_NAN:
      return assign(EMPTY);
    default:
      break;
    }
    switch (c2.rel()) {
    case V_LGE:
      return build(c1);
    case V_NAN:
      return assign(EMPTY);
    default:
      break;
    }
    build(c1);
    const I_Result r = add_constraint(c2);
    return r - (I_CHANGED | I_UNCHANGED);
  }

  template <typename C>
  typename Enable_If<Is_Same_Or_Derived<I_Constraint_Base, C>::value, I_Result>::type
  add_constraint(const C& c) {
    Interval x;
    x.build(c);
    return intersect_assign(x);
  }

  I_Result assign(Degenerate_Element e) {
    I_Result r;
    info().clear();
    switch (e) {
    case EMPTY:
      lower_ = 1;
      upper_ = 0;
      r = I_EMPTY | I_EXACT;
      break;
    case UNIVERSE:
      set_unbounded(LOWER, lower(), info());
      set_unbounded(UPPER, upper(), info());
      r = I_UNIVERSE | I_EXACT;
      break;
    default:
      PPL_UNREACHABLE;
      r = I_EMPTY;
      break;
    }
    PPL_ASSERT(OK());
    return r;
  }

  template <typename From>
  typename Enable_If<Is_Special<From>::value, I_Result>::type
  assign(const From&) {
    info().clear();
    Result rl;
    Result ru;
    switch (From::vclass) {
    case VC_MINUS_INFINITY:
      rl = Boundary_NS::set_minus_infinity(LOWER, lower(), info());
      ru = Boundary_NS::set_minus_infinity(UPPER, upper(), info());
      break;
    case VC_PLUS_INFINITY:
      rl = Boundary_NS::set_plus_infinity(LOWER, lower(), info());
      ru = Boundary_NS::set_plus_infinity(UPPER, upper(), info());
      break;
    default:
      PPL_UNREACHABLE;
      rl = V_NAN;
      ru = V_NAN;
      break;
    }
    PPL_ASSERT(OK());
    return combine(rl, ru);
  }

  I_Result set_infinities() {
    info().clear();
    Result rl = Boundary_NS::set_minus_infinity(LOWER, lower(), info());
    Result ru = Boundary_NS::set_plus_infinity(UPPER, upper(), info());
    PPL_ASSERT(OK());
    return combine(rl, ru);
  }

  static bool is_always_topologically_closed() {
    return !Info::store_open;
  }

  bool is_topologically_closed() const {
    PPL_ASSERT(OK());
    return is_always_topologically_closed()
      || is_empty()
      || ((lower_is_boundary_infinity() || !lower_is_open())
          && (upper_is_boundary_infinity() || !upper_is_open()));
  }

  //! Assigns to \p *this its topological closure.
  void topological_closure_assign() {
    if (!Info::store_open || is_empty()) {
      return;
    }
    if (lower_is_open() && !lower_is_boundary_infinity()) {
      info().set_boundary_property(LOWER, OPEN, false);
    }
    if (upper_is_open() && !upper_is_boundary_infinity()) {
      info().set_boundary_property(UPPER, OPEN, false);
    }
  }

  void remove_inf() {
    PPL_ASSERT(!is_empty());
    if (!Info::store_open) {
      return;
    }
    info().set_boundary_property(LOWER, OPEN, true);
  }

  void remove_sup() {
    PPL_ASSERT(!is_empty());
    if (!Info::store_open) {
      return;
    }
    info().set_boundary_property(UPPER, OPEN, true);
  }

  int infinity_sign() const {
    PPL_ASSERT(OK());
    if (is_reverse_infinity(LOWER, lower(), info())) {
      return 1;
    }
    else if (is_reverse_infinity(UPPER, upper(), info())) {
      return -1;
    }
    else {
      return 0;
    }
  }

  bool contains_integer_point() const {
    PPL_ASSERT(OK());
    if (is_empty()) {
      return false;
    }
    if (!is_bounded()) {
      return true;
    }
    Boundary l;
    if (lower_is_open()) {
      add_assign_r(l, lower(), Boundary(1), ROUND_DOWN);
      floor_assign_r(l, l, ROUND_DOWN);
    }
    else {
      ceil_assign_r(l, lower(), ROUND_DOWN);
    }
    Boundary u;
    if (upper_is_open()) {
      sub_assign_r(u, upper(), Boundary(1), ROUND_UP);
      ceil_assign_r(u, u, ROUND_UP);
    }
    else {
      floor_assign_r(u, upper(), ROUND_UP);
    }
    return u >= l;
  }

  void drop_some_non_integer_points() {
    if (is_empty()) {
      return;
    }
    if (lower_is_open() && !lower_is_boundary_infinity()) {
      add_assign_r(lower(), lower(), Boundary(1), ROUND_DOWN);
      floor_assign_r(lower(), lower(), ROUND_DOWN);
      info().set_boundary_property(LOWER, OPEN, false);
    }
    else {
      ceil_assign_r(lower(), lower(), ROUND_DOWN);
    }
    if (upper_is_open() && !upper_is_boundary_infinity()) {
      sub_assign_r(upper(), upper(), Boundary(1), ROUND_UP);
      ceil_assign_r(upper(), upper(), ROUND_UP);
      info().set_boundary_property(UPPER, OPEN, false);
    }
    else {
      floor_assign_r(upper(), upper(), ROUND_UP);
    }
  }

  template <typename From>
  typename Enable_If<Is_Singleton<From>::value || Is_Interval<From>::value, I_Result>::type
  wrap_assign(Bounded_Integer_Type_Width w,
              Bounded_Integer_Type_Representation r,
              const From& refinement) {
    if (is_empty()) {
      return I_EMPTY;
    }
    if (lower_is_boundary_infinity() || upper_is_boundary_infinity()) {
      return assign(refinement);
    }
    PPL_DIRTY_TEMP(Boundary, u);
    Result result = sub_2exp_assign_r(u, upper(), w, ROUND_UP);
    if (result_overflow(result) == 0 && u > lower()) {
      return assign(refinement);
    }
    info().clear();
    switch (r) {
    case UNSIGNED:
      umod_2exp_assign(LOWER, lower(), info(),
                       LOWER, lower(), info(), w);
      umod_2exp_assign(UPPER, upper(), info(),
                       UPPER, upper(), info(), w);
      break;
    case SIGNED_2_COMPLEMENT:
      smod_2exp_assign(LOWER, lower(), info(),
                       LOWER, lower(), info(), w);
      smod_2exp_assign(UPPER, upper(), info(),
                       UPPER, upper(), info(), w);
      break;
    default:
      PPL_UNREACHABLE;
      break;
    }
    if (le(LOWER, lower(), info(), UPPER, upper(), info())) {
      return intersect_assign(refinement);
    }
    PPL_DIRTY_TEMP(Interval, tmp);
    tmp.info().clear();
    Boundary_NS::assign(LOWER, tmp.lower(), tmp.info(),
                        LOWER, lower(), info());
    set_unbounded(UPPER, tmp.upper(), tmp.info());
    tmp.intersect_assign(refinement);
    lower_extend();
    intersect_assign(refinement);
    return join_assign(tmp);
  }

  //! Returns the total size in bytes of the memory occupied by \p *this.
  memory_size_type total_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  memory_size_type external_memory_in_bytes() const;

  void ascii_dump(std::ostream& s) const;
  bool ascii_load(std::istream& s);

  bool OK() const {
    if (!Info::may_be_empty && is_empty()) {
#ifndef NDEBUG
      std::cerr << "The interval is unexpectedly empty.\n";
#endif
      return false;
    }

    if (is_open(LOWER, lower(), info())) {
      if (is_plus_infinity(LOWER, lower(), info())) {
#ifndef NDEBUG
        std::cerr << "The lower boundary is +inf open.\n";
#endif
      }
    }
    else if (!Info::may_contain_infinity
             && (is_minus_infinity(LOWER, lower(), info())
                 || is_plus_infinity(LOWER, lower(), info()))) {
#ifndef NDEBUG
      std::cerr << "The lower boundary is unexpectedly infinity.\n";
#endif
      return false;
    }
    if (!info().get_boundary_property(LOWER, SPECIAL)) {
      if (is_not_a_number(lower())) {
#ifndef NDEBUG
        std::cerr << "The lower boundary is not a number.\n";
#endif
        return false;
      }
    }

    if (is_open(UPPER, upper(), info())) {
      if (is_minus_infinity(UPPER, upper(), info())) {
#ifndef NDEBUG
        std::cerr << "The upper boundary is -inf open.\n";
#endif
      }
    }
    else if (!Info::may_contain_infinity
             && (is_minus_infinity(UPPER, upper(), info())
                 || is_plus_infinity(UPPER, upper(), info()))) {
#ifndef NDEBUG
      std::cerr << "The upper boundary is unexpectedly infinity."
                << std::endl;
#endif
      return false;
    }
    if (!info().get_boundary_property(UPPER, SPECIAL)) {
      if (is_not_a_number(upper())) {
#ifndef NDEBUG
        std::cerr << "The upper boundary is not a number.\n";
#endif
        return false;
      }
    }

    // Everything OK.
    return true;
  }

  Interval() {
  }

  template <typename T>
  explicit Interval(const T& x) {
    assign(x);
  }

  /*! \brief
    Builds the smallest interval containing the number whose textual
    representation is contained in \p s.
  */
  explicit Interval(const char* s);

  template <typename T>
  typename Enable_If<Is_Singleton<T>::value
                     || Is_Interval<T>::value, bool>::type
  contains(const T& y) const;

  template <typename T>
  typename Enable_If<Is_Singleton<T>::value
                     || Is_Interval<T>::value, bool>::type
  strictly_contains(const T& y) const;

  template <typename T>
  typename Enable_If<Is_Singleton<T>::value
                     || Is_Interval<T>::value, bool>::type
  is_disjoint_from(const T& y) const;


  template <typename From>
  typename Enable_If<Is_Singleton<From>::value
                     || Is_Interval<From>::value, I_Result>::type
  assign(const From& x);

  template <typename Type>
  typename Enable_If<Is_Singleton<Type>::value
                     || Is_Interval<Type>::value, bool>::type
  can_be_exactly_joined_to(const Type& x) const;

  template <typename From>
  typename Enable_If<Is_Singleton<From>::value
                     || Is_Interval<From>::value, I_Result>::type
  join_assign(const From& x);

  template <typename From1, typename From2>
  typename Enable_If<((Is_Singleton<From1>::value
                       || Is_Interval<From1>::value)
                      && (Is_Singleton<From2>::value
                          || Is_Interval<From2>::value)), I_Result>::type
  join_assign(const From1& x, const From2& y);

  template <typename From>
  typename Enable_If<Is_Singleton<From>::value
                     || Is_Interval<From>::value, I_Result>::type
  intersect_assign(const From& x);

  template <typename From1, typename From2>
  typename Enable_If<((Is_Singleton<From1>::value
                       || Is_Interval<From1>::value)
                      && (Is_Singleton<From2>::value
                          || Is_Interval<From2>::value)), I_Result>::type
  intersect_assign(const From1& x, const From2& y);

  /*! \brief
    Assigns to \p *this the smallest interval containing the set-theoretic
    difference of \p *this and \p x.
  */
  template <typename From>
  typename Enable_If<Is_Singleton<From>::value
                     || Is_Interval<From>::value, I_Result>::type
  difference_assign(const From& x);

  /*! \brief
    Assigns to \p *this the smallest interval containing the set-theoretic
    difference of \p x and \p y.
  */
  template <typename From1, typename From2>
  typename Enable_If<((Is_Singleton<From1>::value
                       || Is_Interval<From1>::value)
                      && (Is_Singleton<From2>::value
                          || Is_Interval<From2>::value)), I_Result>::type
  difference_assign(const From1& x, const From2& y);

  /*! \brief
    Assigns to \p *this the largest interval contained in the set-theoretic
    difference of \p *this and \p x.
  */
  template <typename From>
  typename Enable_If<Is_Singleton<From>::value
                     || Is_Interval<From>::value, I_Result>::type
  lower_approximation_difference_assign(const From& x);

  /*! \brief
    Assigns to \p *this a \ref Meet_Preserving_Simplification
    "meet-preserving simplification" of \p *this with respect to \p y.

    \return
    \c false if and only if the meet of \p *this and \p y is empty.
  */
  template <typename From>
  typename Enable_If<Is_Interval<From>::value, bool>::type
  simplify_using_context_assign(const From& y);

  /*! \brief
    Assigns to \p *this an interval having empty intersection with \p y.
    The assigned interval should be as large as possible.
  */
  template <typename From>
  typename Enable_If<Is_Interval<From>::value, void>::type
  empty_intersection_assign(const From& y);

  /*! \brief
    Refines \p to according to the existential relation \p rel with \p x.

    The \p to interval is restricted to become, upon successful exit,
    the smallest interval of its type that contains the set
    \f[
      \{\,
        a \in \mathtt{to}
      \mid
        \exists b \in \mathtt{x} \st a \mathrel{\mathtt{rel}} b
      \,\}.
    \f]
    \return
    ???
  */
  template <typename From>
  typename Enable_If<Is_Singleton<From>::value
                     || Is_Interval<From>::value, I_Result>::type
  refine_existential(Relation_Symbol rel, const From& x);

  /*! \brief
    Refines \p to so that it satisfies the universal relation \p rel with \p x.

    The \p to interval is restricted to become, upon successful exit,
    the smallest interval of its type that contains the set
    \f[
      \{\,
        a \in \mathtt{to}
      \mid
        \forall b \in \mathtt{x} \itc a \mathrel{\mathtt{rel}} b
      \,\}.
    \f]
    \return
    ???
  */
  template <typename From>
  typename Enable_If<Is_Singleton<From>::value
                     || Is_Interval<From>::value, I_Result>::type
  refine_universal(Relation_Symbol rel, const From& x);

  template <typename From>
  typename Enable_If<Is_Singleton<From>::value
                     || Is_Interval<From>::value, I_Result>::type
  neg_assign(const From& x);

  template <typename From1, typename From2>
  typename Enable_If<((Is_Singleton<From1>::value || Is_Interval<From1>::value)
                      && (Is_Singleton<From2>::value || Is_Interval<From2>::value)), I_Result>::type
  add_assign(const From1& x, const From2& y);

  template <typename From1, typename From2>
  typename Enable_If<((Is_Singleton<From1>::value || Is_Interval<From1>::value)
                      && (Is_Singleton<From2>::value || Is_Interval<From2>::value)), I_Result>::type
  sub_assign(const From1& x, const From2& y);

  template <typename From1, typename From2>
  typename Enable_If<((Is_Singleton<From1>::value || Is_Interval<From1>::value)
                      && (Is_Singleton<From2>::value || Is_Interval<From2>::value)), I_Result>::type
  mul_assign(const From1& x, const From2& y);

  template <typename From1, typename From2>
  typename Enable_If<((Is_Singleton<From1>::value || Is_Interval<From1>::value)
                      && (Is_Singleton<From2>::value || Is_Interval<From2>::value)), I_Result>::type
  div_assign(const From1& x, const From2& y);

  template <typename From, typename Iterator>
  typename Enable_If<Is_Interval<From>::value, void>::type
  CC76_widening_assign(const From& y, Iterator first, Iterator last);

private:
  Boundary lower_;
  Boundary upper_;
};

//! Swaps \p x with \p y.
/*! \relates Interval */
template <typename Boundary, typename Info>
void swap(Interval<Boundary, Info>& x, Interval<Boundary, Info>& y);

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Interval_inlines.hh line 1. */
/* Inline functions for the Interval class and its constituents.
*/


namespace Parma_Polyhedra_Library {

template <typename Boundary, typename Info>
inline memory_size_type
Interval<Boundary, Info>::external_memory_in_bytes() const {
  return Parma_Polyhedra_Library::external_memory_in_bytes(lower())
    + Parma_Polyhedra_Library::external_memory_in_bytes(upper());
}

template <typename Boundary, typename Info>
inline memory_size_type
Interval<Boundary, Info>::total_memory_in_bytes() const {
  return sizeof(*this) + external_memory_in_bytes();
}

template <typename Boundary, typename Info>
inline void
Interval<Boundary, Info>::m_swap(Interval<Boundary, Info>& y) {
  using std::swap;
  swap(lower(), y.lower());
  swap(upper(), y.upper());
  swap(info(), y.info());
}

template <typename Boundary, typename Info>
inline bool
f_is_empty(const Interval<Boundary, Info>& x) {
  return x.is_empty();
}
template <typename Boundary, typename Info>
inline bool
f_is_singleton(const Interval<Boundary, Info>& x) {
  return x.is_singleton();
}
template <typename Boundary, typename Info>
inline int
infinity_sign(const Interval<Boundary, Info>& x) {
  return x.infinity_sign();
}

namespace Interval_NS {

template <typename Boundary, typename Info>
inline const Boundary&
f_lower(const Interval<Boundary, Info>& x) {
  return x.lower();
}
template <typename Boundary, typename Info>
inline const Boundary&
f_upper(const Interval<Boundary, Info>& x) {
  return x.upper();
}
template <typename Boundary, typename Info>
inline const Info&
f_info(const Interval<Boundary, Info>& x) {
  return x.info();
}

struct Scalar_As_Interval_Policy {
  const_bool_nodef(may_be_empty, true);
  const_bool_nodef(may_contain_infinity, true);
  const_bool_nodef(check_inexact, false);
};

typedef Interval_Info_Null<Scalar_As_Interval_Policy>
Scalar_As_Interval_Info;

const Scalar_As_Interval_Info SCALAR_INFO;

typedef Interval_Info_Null_Open<Scalar_As_Interval_Policy>
Scalar_As_Interval_Info_Open;

template <typename T>
inline typename Enable_If<Is_Singleton<T>::value, const T&>::type
f_lower(const T& x) {
  return x;
}
template <typename T>
inline typename Enable_If<Is_Singleton<T>::value, const T&>::type
f_upper(const T& x) {
  return x;
}
template <typename T>
inline typename Enable_If<Is_Singleton<T>::value,
                          const Scalar_As_Interval_Info&>::type
f_info(const T&) {
  return SCALAR_INFO;
}
template <typename T>
inline typename Enable_If<Is_Singleton<T>::value,
                          Scalar_As_Interval_Info_Open>::type
f_info(const T&, bool open) {
  return Scalar_As_Interval_Info_Open(open);
}

template <typename T>
inline typename Enable_If<Is_Singleton<T>::value, bool>::type
f_is_empty(const T& x) {
  return is_not_a_number(x);
}

template <typename T>
inline typename Enable_If<Is_Singleton<T>::value, bool>::type
f_is_singleton(const T& x) {
  return !f_is_empty(x);
}

} // namespace Interval_NS

template <typename T>
inline typename Enable_If<Is_Singleton<T>::value
                          || Is_Interval<T>::value, bool>::type
is_singleton_integer(const T& x) {
  return is_singleton(x) && is_integer(f_lower(x));
}

template <typename T>
inline typename Enable_If<Is_Singleton<T>::value
                          || Is_Interval<T>::value, bool>::type
check_empty_arg(const T& x) {
  if (f_info(x).may_be_empty) {
    return f_is_empty(x);
  }
  else {
    PPL_ASSERT(!f_is_empty(x));
    return false;
  }
}

template <typename T1, typename T2>
inline typename Enable_If<((Is_Singleton<T1>::value
                            || Is_Interval<T1>::value)
                           && (Is_Singleton<T2>::value
                               || Is_Interval<T2>::value)
                           && (Is_Interval<T1>::value
                               || Is_Interval<T2>::value)),
                          bool>::type
operator==(const T1& x, const T2& y) {
  PPL_ASSERT(f_OK(x));
  PPL_ASSERT(f_OK(y));
  if (check_empty_arg(x)) {
    return check_empty_arg(y);
  }
  else if (check_empty_arg(y)) {
    return false;
  }
  return eq(LOWER, f_lower(x), f_info(x), LOWER, f_lower(y), f_info(y))
    && eq(UPPER, f_upper(x), f_info(x), UPPER, f_upper(y), f_info(y));
}

template <typename T1, typename T2>
inline typename Enable_If<((Is_Singleton<T1>::value
                            || Is_Interval<T1>::value)
                           && (Is_Singleton<T2>::value
                               || Is_Interval<T2>::value)
                           && (Is_Interval<T1>::value
                               || Is_Interval<T2>::value)),
                          bool>::type
operator!=(const T1& x, const T2& y) {
  return !(x == y);
}

template <typename Boundary, typename Info>
template <typename T>
inline typename Enable_If<Is_Singleton<T>::value
                          || Is_Interval<T>::value, bool>::type
Interval<Boundary, Info>::contains(const T& y) const {
  PPL_ASSERT(OK());
  PPL_ASSERT(f_OK(y));
  if (check_empty_arg(y)) {
    return true;
  }
  if (check_empty_arg(*this)) {
    return false;
  }
  return le(LOWER, lower(), info(), LOWER, f_lower(y), f_info(y))
    && ge(UPPER, upper(), info(), UPPER, f_upper(y), f_info(y));
}

template <typename Boundary, typename Info>
template <typename T>
inline typename Enable_If<Is_Singleton<T>::value
                          || Is_Interval<T>::value, bool>::type
Interval<Boundary, Info>::strictly_contains(const T& y) const {
  PPL_ASSERT(OK());
  PPL_ASSERT(f_OK(y));
  if (check_empty_arg(y)) {
    return !check_empty_arg(*this);
  }
  if (check_empty_arg(*this)) {
    return false;
  }
  return (lt(LOWER, lower(), info(), LOWER, f_lower(y), f_info(y))
          && ge(UPPER, upper(), info(), UPPER, f_upper(y), f_info(y)))
    || (le(LOWER, lower(), info(), LOWER, f_lower(y), f_info(y))
        && gt(UPPER, upper(), info(), UPPER, f_upper(y), f_info(y)));
}

template <typename Boundary, typename Info>
template <typename T>
inline typename Enable_If<Is_Singleton<T>::value
                          || Is_Interval<T>::value, bool>::type
Interval<Boundary, Info>::is_disjoint_from(const T& y) const {
  PPL_ASSERT(OK());
  PPL_ASSERT(f_OK(y));
  if (check_empty_arg(*this) || check_empty_arg(y)) {
    return true;
  }
  return gt(LOWER, lower(), info(), UPPER, f_upper(y), f_info(y))
    || lt(UPPER, upper(), info(), LOWER, f_lower(y), f_info(y));
}

template <typename To_Boundary, typename To_Info>
template <typename From>
inline typename Enable_If<Is_Singleton<From>::value
                          || Is_Interval<From>::value, I_Result>::type
Interval<To_Boundary, To_Info>::assign(const From& x) {
  PPL_ASSERT(f_OK(x));
  if (check_empty_arg(x)) {
    return assign(EMPTY);
  }
  PPL_DIRTY_TEMP(To_Info, to_info);
  to_info.clear();
  const Result rl = Boundary_NS::assign(LOWER, lower(), to_info,
                                        LOWER, f_lower(x), f_info(x));
  const Result ru = Boundary_NS::assign(UPPER, upper(), to_info,
                                        UPPER, f_upper(x), f_info(x));
  assign_or_swap(info(), to_info);
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

template <typename To_Boundary, typename To_Info>
template <typename From>
inline typename Enable_If<Is_Singleton<From>::value
                          || Is_Interval<From>::value, I_Result>::type
Interval<To_Boundary, To_Info>::join_assign(const From& x) {
  PPL_ASSERT(f_OK(x));
  if (check_empty_arg(*this)) {
    return assign(x);
  }
  if (check_empty_arg(x)) {
    return combine(V_EQ, V_EQ);
  }
  Result rl;
  Result ru;
  rl = min_assign(LOWER, lower(), info(), LOWER, f_lower(x), f_info(x));
  ru = max_assign(UPPER, upper(), info(), UPPER, f_upper(x), f_info(x));
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

template <typename To_Boundary, typename To_Info>
template <typename From1, typename From2>
inline typename Enable_If<((Is_Singleton<From1>::value
                            || Is_Interval<From1>::value)
                           && (Is_Singleton<From2>::value
                               || Is_Interval<From2>::value)), I_Result>::type
Interval<To_Boundary, To_Info>::join_assign(const From1& x, const From2& y) {
  PPL_ASSERT(f_OK(x));
  PPL_ASSERT(f_OK(y));
  if (check_empty_arg(x)) {
    return assign(y);
  }
  if (check_empty_arg(y)) {
    return assign(x);
  }
  PPL_DIRTY_TEMP(To_Info, to_info);
  to_info.clear();
  Result rl;
  Result ru;
  rl = min_assign(LOWER, lower(), to_info,
                  LOWER, f_lower(x), f_info(x),
                  LOWER, f_lower(y), f_info(y));
  ru = max_assign(UPPER, upper(), to_info,
                  UPPER, f_upper(x), f_info(x),
                  UPPER, f_upper(y), f_info(y));
  assign_or_swap(info(), to_info);
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

template <typename Boundary, typename Info>
template <typename Type>
inline typename Enable_If<Is_Singleton<Type>::value
                          || Is_Interval<Type>::value, bool>::type
Interval<Boundary, Info>::can_be_exactly_joined_to(const Type& x) const {
  PPL_DIRTY_TEMP(Boundary, b);
  if (gt(LOWER, lower(), info(), UPPER, f_upper(x), f_info(x))) {
    b = lower();
    return eq(LOWER, b, info(), UPPER, f_upper(x), f_info(x));
  }
  else if (lt(UPPER, upper(), info(), LOWER, f_lower(x), f_info(x))) {
    b = upper();
    return eq(UPPER, b, info(), LOWER, f_lower(x), f_info(x));
  }
  return true;
}


template <typename To_Boundary, typename To_Info>
template <typename From>
inline typename Enable_If<Is_Singleton<From>::value
                          || Is_Interval<From>::value, I_Result>::type
Interval<To_Boundary, To_Info>::intersect_assign(const From& x) {
  PPL_ASSERT(f_OK(x));
  max_assign(LOWER, lower(), info(), LOWER, f_lower(x), f_info(x));
  min_assign(UPPER, upper(), info(), UPPER, f_upper(x), f_info(x));
  PPL_ASSERT(OK());
  return I_ANY;
}

template <typename To_Boundary, typename To_Info>
template <typename From1, typename From2>
inline typename Enable_If<((Is_Singleton<From1>::value
                            || Is_Interval<From1>::value)
                           && (Is_Singleton<From2>::value
                               || Is_Interval<From2>::value)), I_Result>::type
Interval<To_Boundary, To_Info>::intersect_assign(const From1& x,
                                                 const From2& y) {
  PPL_ASSERT(f_OK(x));
  PPL_ASSERT(f_OK(y));
  PPL_DIRTY_TEMP(To_Info, to_info);
  to_info.clear();
  max_assign(LOWER, lower(), to_info,
             LOWER, f_lower(x), f_info(x),
             LOWER, f_lower(y), f_info(y));
  min_assign(UPPER, upper(), to_info,
             UPPER, f_upper(x), f_info(x),
             UPPER, f_upper(y), f_info(y));
  assign_or_swap(info(), to_info);
  PPL_ASSERT(OK());
  return I_NOT_EMPTY;
}

template <typename To_Boundary, typename To_Info>
template <typename From>
inline typename Enable_If<Is_Singleton<From>::value
                          || Is_Interval<From>::value, I_Result>::type
Interval<To_Boundary, To_Info>::difference_assign(const From& x) {
  PPL_ASSERT(f_OK(x));
  if (lt(UPPER, upper(), info(), LOWER, f_lower(x), f_info(x))
      || gt(LOWER, lower(), info(), UPPER, f_upper(x), f_info(x))) {
    return combine(V_EQ, V_EQ);
  }
  bool nl = ge(LOWER, lower(), info(), LOWER, f_lower(x), f_info(x));
  bool nu = le(UPPER, upper(), info(), UPPER, f_upper(x), f_info(x));
  Result rl = V_EQ;
  Result ru = V_EQ;
  if (nl) {
    if (nu) {
      return assign(EMPTY);
    }
    else {
      info().clear_boundary_properties(LOWER);
      rl = complement(LOWER, lower(), info(), UPPER, f_upper(x), f_info(x));
    }
  }
  else if (nu) {
    info().clear_boundary_properties(UPPER);
    ru = complement(UPPER, upper(), info(), LOWER, f_lower(x), f_info(x));
  }
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

template <typename To_Boundary, typename To_Info>
template <typename From1, typename From2>
inline typename Enable_If<((Is_Singleton<From1>::value
                            || Is_Interval<From1>::value)
                           && (Is_Singleton<From2>::value
                               || Is_Interval<From2>::value)), I_Result>::type
Interval<To_Boundary, To_Info>::difference_assign(const From1& x,
                                                  const From2& y) {
  PPL_ASSERT(f_OK(x));
  PPL_ASSERT(f_OK(y));
  PPL_DIRTY_TEMP(To_Info, to_info);
  to_info.clear();
  if (lt(UPPER, f_upper(x), f_info(x), LOWER, f_lower(y), f_info(y))
      || gt(LOWER, f_lower(x), f_info(x), UPPER, f_upper(y), f_info(y))) {
    return assign(x);
  }
  bool nl = ge(LOWER, f_lower(x), f_info(x), LOWER, f_lower(y), f_info(y));
  bool nu = le(UPPER, f_upper(x), f_info(x), UPPER, f_upper(y), f_info(y));
  Result rl = V_EQ;
  Result ru = V_EQ;
  if (nl) {
    if (nu) {
      return assign(EMPTY);
    }
    else {
      rl = complement(LOWER, lower(), info(), UPPER, f_upper(y), f_info(y));
      ru = Boundary_NS::assign(UPPER, upper(), info(), UPPER, f_upper(x), f_info(x));
    }
  }
  else if (nu) {
    ru = complement(UPPER, upper(), info(), LOWER, f_lower(y), f_info(y));
    rl = Boundary_NS::assign(LOWER, lower(), info(),
                             LOWER, f_lower(x), f_info(x));
  }
  assign_or_swap(info(), to_info);
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

template <typename To_Boundary, typename To_Info>
template <typename From>
inline typename Enable_If<Is_Singleton<From>::value
                          || Is_Interval<From>::value, I_Result>::type
Interval<To_Boundary, To_Info>
::refine_existential(Relation_Symbol rel, const From& x) {
  PPL_ASSERT(OK());
  PPL_ASSERT(f_OK(x));
  if (check_empty_arg(x)) {
    return assign(EMPTY);
  }
  switch (rel) {
  case LESS_THAN:
    {
      if (lt(UPPER, upper(), info(), UPPER, f_upper(x), f_info(x))) {
        return combine(V_EQ, V_EQ);
      }
      info().clear_boundary_properties(UPPER);
      Boundary_NS::assign(UPPER, upper(), info(),
                          UPPER, f_upper(x), f_info(x), true);
      return I_ANY;
    }
  case LESS_OR_EQUAL:
    {
      if (le(UPPER, upper(), info(), UPPER, f_upper(x), f_info(x))) {
        return combine(V_EQ, V_EQ);
      }
      info().clear_boundary_properties(UPPER);
      Boundary_NS::assign(UPPER, upper(), info(),
                          UPPER, f_upper(x), f_info(x));
      return I_ANY;
    }
  case GREATER_THAN:
    {
      if (gt(LOWER, lower(), info(), LOWER, f_lower(x), f_info(x))) {
        return combine(V_EQ, V_EQ);
      }
      info().clear_boundary_properties(LOWER);
      Boundary_NS::assign(LOWER, lower(), info(),
                          LOWER, f_lower(x), f_info(x), true);
      return I_ANY;
    }
  case GREATER_OR_EQUAL:
    {
      if (ge(LOWER, lower(), info(), LOWER, f_lower(x), f_info(x))) {
        return combine(V_EQ, V_EQ);
      }
      info().clear_boundary_properties(LOWER);
      Boundary_NS::assign(LOWER, lower(), info(),
                          LOWER, f_lower(x), f_info(x));
      return I_ANY;
    }
  case EQUAL:
    return intersect_assign(x);
  case NOT_EQUAL:
    {
      if (!f_is_singleton(x)) {
        return combine(V_EQ, V_EQ);
      }
      if (check_empty_arg(*this)) {
        return I_EMPTY;
      }
      if (eq(LOWER, lower(), info(), LOWER, f_lower(x), f_info(x))) {
        remove_inf();
      }
      if (eq(UPPER, upper(), info(), UPPER, f_upper(x), f_info(x))) {
        remove_sup();
      }
      return I_ANY;
    }
  default:
    PPL_UNREACHABLE;
    return I_EMPTY;
  }
}

template <typename To_Boundary, typename To_Info>
template <typename From>
inline typename Enable_If<Is_Singleton<From>::value
                          || Is_Interval<From>::value, I_Result>::type
Interval<To_Boundary, To_Info>::refine_universal(Relation_Symbol rel,
                                                 const From& x) {
  PPL_ASSERT(OK());
  PPL_ASSERT(f_OK(x));
  if (check_empty_arg(x)) {
    return combine(V_EQ, V_EQ);
  }
  switch (rel) {
  case LESS_THAN:
    {
      if (lt(UPPER, upper(), info(), LOWER, f_lower(x), f_info(x))) {
        return combine(V_EQ, V_EQ);
      }
      info().clear_boundary_properties(UPPER);
      Result ru = Boundary_NS::assign(UPPER, upper(), info(),
                                      LOWER, f_lower(x), SCALAR_INFO,
                                      !is_open(LOWER, f_lower(x), f_info(x)));
      PPL_USED(ru);
      return I_ANY;
    }
  case LESS_OR_EQUAL:
    {
      if (le(UPPER, upper(), info(), LOWER, f_lower(x), f_info(x))) {
        return combine(V_EQ, V_EQ);
      }
      info().clear_boundary_properties(UPPER);
      Result ru = Boundary_NS::assign(UPPER, upper(), info(),
                                      LOWER, f_lower(x), SCALAR_INFO);
      PPL_USED(ru);
      return I_ANY;
    }
  case GREATER_THAN:
    {
      if (gt(LOWER, lower(), info(), UPPER, f_upper(x), f_info(x))) {
        return combine(V_EQ, V_EQ);
      }
      info().clear_boundary_properties(LOWER);
      Result rl = Boundary_NS::assign(LOWER, lower(), info(),
                                      UPPER, f_upper(x), SCALAR_INFO,
                                      !is_open(UPPER, f_upper(x), f_info(x)));
      PPL_USED(rl);
      return I_ANY;
    }
  case GREATER_OR_EQUAL:
    {
      if (ge(LOWER, lower(), info(), UPPER, f_upper(x), f_info(x))) {
        return combine(V_EQ, V_EQ);
      }
      info().clear_boundary_properties(LOWER);
      Result rl = Boundary_NS::assign(LOWER, lower(), info(),
                                      UPPER, f_upper(x), SCALAR_INFO);
      PPL_USED(rl);
      return I_ANY;
    }
  case EQUAL:
    if (!f_is_singleton(x)) {
      return assign(EMPTY);
    }
    return intersect_assign(x);
  case NOT_EQUAL:
    {
      if (check_empty_arg(*this)) {
        return I_EMPTY;
      }
      if (eq(LOWER, lower(), info(), LOWER, f_lower(x), f_info(x))) {
        remove_inf();
      }
      if (eq(UPPER, upper(), info(), UPPER, f_upper(x), f_info(x))) {
        remove_sup();
      }
      return I_ANY;
    }
  default:
    PPL_UNREACHABLE;
    return I_EMPTY;
  }
}

template <typename To_Boundary, typename To_Info>
template <typename From>
inline typename Enable_If<Is_Singleton<From>::value
                          || Is_Interval<From>::value, I_Result>::type
Interval<To_Boundary, To_Info>::neg_assign(const From& x) {
  PPL_ASSERT(f_OK(x));
  if (check_empty_arg(x)) {
    return assign(EMPTY);
  }
  PPL_DIRTY_TEMP(To_Info, to_info);
  to_info.clear();
  Result rl;
  Result ru;
  PPL_DIRTY_TEMP(To_Boundary, to_lower);
  rl = Boundary_NS::neg_assign(LOWER, to_lower, to_info, UPPER, f_upper(x), f_info(x));
  ru = Boundary_NS::neg_assign(UPPER, upper(), to_info, LOWER, f_lower(x), f_info(x));
  assign_or_swap(lower(), to_lower);
  assign_or_swap(info(), to_info);
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

template <typename To_Boundary, typename To_Info>
template <typename From1, typename From2>
inline typename Enable_If<((Is_Singleton<From1>::value
                            || Is_Interval<From1>::value)
                           && (Is_Singleton<From2>::value
                               || Is_Interval<From2>::value)), I_Result>::type
Interval<To_Boundary, To_Info>::add_assign(const From1& x, const From2& y) {
  PPL_ASSERT(f_OK(x));
  PPL_ASSERT(f_OK(y));
  if (check_empty_arg(x) || check_empty_arg(y)) {
    return assign(EMPTY);
  }
  int inf_sign = Parma_Polyhedra_Library::infinity_sign(x);
  if (inf_sign != 0) {
    if (Parma_Polyhedra_Library::infinity_sign(y) == -inf_sign) {
      return assign(EMPTY);
    }
  }
  else {
    inf_sign = Parma_Polyhedra_Library::infinity_sign(y);
  }
  if (inf_sign < 0) {
    return assign(MINUS_INFINITY);
  }
  else if (inf_sign > 0) {
    return assign(PLUS_INFINITY);
  }
  PPL_DIRTY_TEMP(To_Info, to_info);
  to_info.clear();
  Result rl = Boundary_NS::add_assign(LOWER, lower(), to_info,
                                      LOWER, f_lower(x), f_info(x),
                                      LOWER, f_lower(y), f_info(y));
  Result ru = Boundary_NS::add_assign(UPPER, upper(), to_info,
                                      UPPER, f_upper(x), f_info(x),
                                      UPPER, f_upper(y), f_info(y));
  assign_or_swap(info(), to_info);
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

template <typename To_Boundary, typename To_Info>
template <typename From1, typename From2>
inline typename Enable_If<((Is_Singleton<From1>::value
                            || Is_Interval<From1>::value)
                           && (Is_Singleton<From2>::value
                               || Is_Interval<From2>::value)), I_Result>::type
Interval<To_Boundary, To_Info>::sub_assign(const From1& x, const From2& y) {
  PPL_ASSERT(f_OK(x));
  PPL_ASSERT(f_OK(y));
  if (check_empty_arg(x) || check_empty_arg(y)) {
    return assign(EMPTY);
  }
  int inf_sign = Parma_Polyhedra_Library::infinity_sign(x);
  if (inf_sign != 0) {
    if (Parma_Polyhedra_Library::infinity_sign(y) == inf_sign) {
      return assign(EMPTY);
    }
  }
  else {
    inf_sign = -Parma_Polyhedra_Library::infinity_sign(y);
  }
  if (inf_sign < 0) {
    return assign(MINUS_INFINITY);
  }
  else if (inf_sign > 0) {
    return assign(PLUS_INFINITY);
  }
  PPL_DIRTY_TEMP(To_Info, to_info);
  to_info.clear();
  Result rl;
  Result ru;
  PPL_DIRTY_TEMP(To_Boundary, to_lower);
  rl = Boundary_NS::sub_assign(LOWER, to_lower, to_info,
                               LOWER, f_lower(x), f_info(x),
                               UPPER, f_upper(y), f_info(y));
  ru = Boundary_NS::sub_assign(UPPER, upper(), to_info,
                               UPPER, f_upper(x), f_info(x),
                               LOWER, f_lower(y), f_info(y));
  assign_or_swap(lower(), to_lower);
  assign_or_swap(info(), to_info);
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

/**
+---------+-----------+-----------+-----------------+
|    *    |  yl > 0   |  yu < 0   |  yl < 0, yu > 0 |
+---------+-----------+-----------+-----------------+
| xl > 0  |xl*yl,xu*yu|xu*yl,xl*yu|   xu*yl,xu*yu   |
+---------+-----------+-----------+-----------------+
| xu < 0  |xl*yu,xu*yl|xu*yu,xl*yl|   xl*yu,xl*yl   |
+---------+-----------+-----------+-----------------+
|xl<0 xu>0|xl*yu,xu*yu|xu*yl,xl*yl|min(xl*yu,xu*yl),|
|         |           |           |max(xl*yl,xu*yu) |
+---------+-----------+-----------+-----------------+
**/
template <typename To_Boundary, typename To_Info>
template <typename From1, typename From2>
inline typename Enable_If<((Is_Singleton<From1>::value
                            || Is_Interval<From1>::value)
                           && (Is_Singleton<From2>::value
                               || Is_Interval<From2>::value)), I_Result>::type
Interval<To_Boundary, To_Info>::mul_assign(const From1& x, const From2& y) {
  PPL_ASSERT(f_OK(x));
  PPL_ASSERT(f_OK(y));
  if (check_empty_arg(x) || check_empty_arg(y)) {
    return assign(EMPTY);
  }
  int xls = sgn_b(LOWER, f_lower(x), f_info(x));
  int xus = (xls > 0) ? 1 : sgn_b(UPPER, f_upper(x), f_info(x));
  int yls = sgn_b(LOWER, f_lower(y), f_info(y));
  int yus = (yls > 0) ? 1 : sgn_b(UPPER, f_upper(y), f_info(y));
  int inf_sign = Parma_Polyhedra_Library::infinity_sign(x);
  int ls;
  int us;
  if (inf_sign != 0) {
    ls = yls;
    us = yus;
    goto inf;
  }
  else {
    inf_sign = Parma_Polyhedra_Library::infinity_sign(y);
    if (inf_sign != 0) {
      ls = xls;
      us = xus;
    inf:
      if (ls == 0 && us == 0) {
        return assign(EMPTY);
      }
      if (ls == -us) {
        return set_infinities();
      }
      if (ls < 0 || us < 0) {
        inf_sign = -inf_sign;
      }
      if (inf_sign < 0) {
        return assign(MINUS_INFINITY);
      }
      else {
        return assign(PLUS_INFINITY);
      }
    }
  }

  PPL_DIRTY_TEMP(To_Info, to_info);
  to_info.clear();
  Result rl;
  Result ru;
  PPL_DIRTY_TEMP(To_Boundary, to_lower);

  if (xls >= 0) {
    if (yls >= 0) {
      // 0 <= xl <= xu, 0 <= yl <= yu
      rl = mul_assign_z(LOWER, to_lower, to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        LOWER, f_lower(y), f_info(y), yls);
      ru = mul_assign_z(UPPER, upper(), to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        UPPER, f_upper(y), f_info(y), yus);
    }
    else if (yus <= 0) {
      // 0 <= xl <= xu, yl <= yu <= 0
      rl = mul_assign_z(LOWER, to_lower, to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        LOWER, f_lower(y), f_info(y), yls);
      ru = mul_assign_z(UPPER, upper(), to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        UPPER, f_upper(y), f_info(y), yus);
    }
    else {
      // 0 <= xl <= xu, yl < 0 < yu
      rl = mul_assign_z(LOWER, to_lower, to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        LOWER, f_lower(y), f_info(y), yls);
      ru = mul_assign_z(UPPER, upper(), to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        UPPER, f_upper(y), f_info(y), yus);
    }
  }
  else if (xus <= 0) {
    if (yls >= 0) {
      // xl <= xu <= 0, 0 <= yl <= yu
      rl = mul_assign_z(LOWER, to_lower, to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        UPPER, f_upper(y), f_info(y), yus);
      ru = mul_assign_z(UPPER, upper(), to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        LOWER, f_lower(y), f_info(y), yls);
    }
    else if (yus <= 0) {
      // xl <= xu <= 0, yl <= yu <= 0
      rl = mul_assign_z(LOWER, to_lower, to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        UPPER, f_upper(y), f_info(y), yus);
      ru = mul_assign_z(UPPER, upper(), to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        LOWER, f_lower(y), f_info(y), yls);
    }
    else {
      // xl <= xu <= 0, yl < 0 < yu
      rl = mul_assign_z(LOWER, to_lower, to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        UPPER, f_upper(y), f_info(y), yus);
      ru = mul_assign_z(UPPER, upper(), to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        LOWER, f_lower(y), f_info(y), yls);
    }
  }
  else if (yls >= 0) {
    // xl < 0 < xu, 0 <= yl <= yu
    rl = mul_assign_z(LOWER, to_lower, to_info,
                      LOWER, f_lower(x), f_info(x), xls,
                      UPPER, f_upper(y), f_info(y), yus);
    ru = mul_assign_z(UPPER, upper(), to_info,
                      UPPER, f_upper(x), f_info(x), xus,
                      UPPER, f_upper(y), f_info(y), yus);
  }
  else if (yus <= 0) {
    // xl < 0 < xu, yl <= yu <= 0
    rl = mul_assign_z(LOWER, to_lower, to_info,
                      UPPER, f_upper(x), f_info(x), xus,
                      LOWER, f_lower(y), f_info(y), yls);
    ru = mul_assign_z(UPPER, upper(), to_info,
                      LOWER, f_lower(x), f_info(x), xls,
                      LOWER, f_lower(y), f_info(y), yls);
  }
  else {
    // xl < 0 < xu, yl < 0 < yu
    PPL_DIRTY_TEMP(To_Boundary, tmp);
    PPL_DIRTY_TEMP(To_Info, tmp_info);
    tmp_info.clear();
    Result tmp_r;
    tmp_r = Boundary_NS::mul_assign(LOWER, tmp, tmp_info,
                                    UPPER, f_upper(x), f_info(x),
                                    LOWER, f_lower(y), f_info(y));
    rl = Boundary_NS::mul_assign(LOWER, to_lower, to_info,
                                 LOWER, f_lower(x), f_info(x),
                                 UPPER, f_upper(y), f_info(y));
    if (gt(LOWER, to_lower, to_info, LOWER, tmp, tmp_info)) {
      to_lower = tmp;
      rl = tmp_r;
    }
    tmp_info.clear();
    tmp_r = Boundary_NS::mul_assign(UPPER, tmp, tmp_info,
                                    UPPER, f_upper(x), f_info(x),
                                    UPPER, f_upper(y), f_info(y));
    ru = Boundary_NS::mul_assign(UPPER, upper(), to_info,
                                 LOWER, f_lower(x), f_info(x),
                                 LOWER, f_lower(y), f_info(y));
    if (lt(UPPER, upper(), to_info, UPPER, tmp, tmp_info)) {
      upper() = tmp;
      ru = tmp_r;
    }
  }
  assign_or_swap(lower(), to_lower);
  assign_or_swap(info(), to_info);
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

/**
+-----------+-----------+-----------+
|     /     |  yu < 0   |  yl > 0   |
+-----------+-----------+-----------+
|   xu<=0   |xu/yl,xl/yu|xl/yl,xu/yu|
+-----------+-----------+-----------+
|xl<=0 xu>=0|xu/yu,xl/yu|xl/yl,xu/yl|
+-----------+-----------+-----------+
|   xl>=0   |xu/yu,xl/yl|xl/yu,xu/yl|
+-----------+-----------+-----------+
**/
template <typename To_Boundary, typename To_Info>
template <typename From1, typename From2>
inline typename Enable_If<((Is_Singleton<From1>::value
                            || Is_Interval<From1>::value)
                           && (Is_Singleton<From2>::value
                               || Is_Interval<From2>::value)), I_Result>::type
Interval<To_Boundary, To_Info>::div_assign(const From1& x, const From2& y) {
  PPL_ASSERT(f_OK(x));
  PPL_ASSERT(f_OK(y));
  if (check_empty_arg(x) || check_empty_arg(y)) {
    return assign(EMPTY);
  }
  int yls = sgn_b(LOWER, f_lower(y), f_info(y));
  int yus = (yls > 0) ? 1 : sgn_b(UPPER, f_upper(y), f_info(y));
  if (yls == 0 && yus == 0) {
    return assign(EMPTY);
  }
  int inf_sign = Parma_Polyhedra_Library::infinity_sign(x);
  if (inf_sign != 0) {
    if (Parma_Polyhedra_Library::infinity_sign(y) != 0) {
      return assign(EMPTY);
    }
    if (yls == -yus) {
      return set_infinities();
    }
    if (yls < 0 || yus < 0) {
      inf_sign = -inf_sign;
    }
    if (inf_sign < 0) {
      return assign(MINUS_INFINITY);
    }
    else {
      return assign(PLUS_INFINITY);
    }
  }
  int xls = sgn_b(LOWER, f_lower(x), f_info(x));
  int xus = (xls > 0) ? 1 : sgn_b(UPPER, f_upper(x), f_info(x));

  PPL_DIRTY_TEMP(To_Info, to_info);
  to_info.clear();
  Result rl;
  Result ru;
  PPL_DIRTY_TEMP(To_Boundary, to_lower);
  if (yls >= 0) {
    if (xls >= 0) {
      rl = div_assign_z(LOWER, to_lower, to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        UPPER, f_upper(y), f_info(y), yus);
      ru = div_assign_z(UPPER, upper(), to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        LOWER, f_lower(y), f_info(y), yls);
    }
    else if (xus <= 0) {
      rl = div_assign_z(LOWER, to_lower, to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        LOWER, f_lower(y), f_info(y), yls);
      ru = div_assign_z(UPPER, upper(), to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        UPPER, f_upper(y), f_info(y), yus);
    }
    else {
      rl = div_assign_z(LOWER, to_lower, to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        LOWER, f_lower(y), f_info(y), yls);
      ru = div_assign_z(UPPER, upper(), to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        LOWER, f_lower(y), f_info(y), yls);
    }
  }
  else if (yus <= 0) {
    if (xls >= 0) {
      rl = div_assign_z(LOWER, to_lower, to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        UPPER, f_upper(y), f_info(y), yus);
      ru = div_assign_z(UPPER, upper(), to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        LOWER, f_lower(y), f_info(y), yls);
    }
    else if (xus <= 0) {
      rl = div_assign_z(LOWER, to_lower, to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        LOWER, f_lower(y), f_info(y), yls);
      ru = div_assign_z(UPPER, upper(), to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        UPPER, f_upper(y), f_info(y), yus);
    }
    else {
      rl = div_assign_z(LOWER, to_lower, to_info,
                        UPPER, f_upper(x), f_info(x), xus,
                        UPPER, f_upper(y), f_info(y), yus);
      ru = div_assign_z(UPPER, upper(), to_info,
                        LOWER, f_lower(x), f_info(x), xls,
                        UPPER, f_upper(y), f_info(y), yus);
    }
  }
  else {
    return static_cast<I_Result>(assign(UNIVERSE) | I_SINGULARITIES);
  }
  assign_or_swap(lower(), to_lower);
  assign_or_swap(info(), to_info);
  PPL_ASSERT(OK());
  return combine(rl, ru);
}

template <typename B, typename Info, typename T>
inline typename Enable_If<Is_Singleton<T>::value, Interval<B, Info> >::type
operator+(const Interval<B, Info>& x, const T& y) {
  Interval<B, Info> z;
  z.add_assign(x, y);
  return z;
}

template <typename B, typename Info, typename T>
inline typename Enable_If<Is_Singleton<T>::value, Interval<B, Info> >::type
operator+(const T& x, const Interval<B, Info>& y) {
  Interval<B, Info> z;
  z.add_assign(x, y);
  return z;
}

template <typename B, typename Info>
inline Interval<B, Info>
operator+(const Interval<B, Info>& x, const Interval<B, Info>& y) {
  Interval<B, Info> z;
  z.add_assign(x, y);
  return z;
}

template <typename B, typename Info, typename T>
inline typename Enable_If<Is_Singleton<T>::value, Interval<B, Info> >::type
operator-(const Interval<B, Info>& x, const T& y) {
  Interval<B, Info> z;
  z.sub_assign(x, y);
  return z;
}

template <typename B, typename Info, typename T>
inline typename Enable_If<Is_Singleton<T>::value, Interval<B, Info> >::type
operator-(const T& x, const Interval<B, Info>& y) {
  Interval<B, Info> z;
  z.sub_assign(x, y);
  return z;
}

template <typename B, typename Info>
inline Interval<B, Info>
operator-(const Interval<B, Info>& x, const Interval<B, Info>& y) {
  Interval<B, Info> z;
  z.sub_assign(x, y);
  return z;
}

template <typename B, typename Info, typename T>
inline typename Enable_If<Is_Singleton<T>::value, Interval<B, Info> >::type
operator*(const Interval<B, Info>& x, const T& y) {
  Interval<B, Info> z;
  z.mul_assign(x, y);
  return z;
}

template <typename B, typename Info, typename T>
inline typename Enable_If<Is_Singleton<T>::value, Interval<B, Info> >::type
operator*(const T& x, const Interval<B, Info>& y) {
  Interval<B, Info> z;
  z.mul_assign(x, y);
  return z;
}

template <typename B, typename Info>
inline Interval<B, Info>
operator*(const Interval<B, Info>& x, const Interval<B, Info>& y) {
  Interval<B, Info> z;
  z.mul_assign(x, y);
  return z;
}

template <typename B, typename Info, typename T>
inline typename Enable_If<Is_Singleton<T>::value, Interval<B, Info> >::type
operator/(const Interval<B, Info>& x, const T& y) {
  Interval<B, Info> z;
  z.div_assign(x, y);
  return z;
}

template <typename B, typename Info, typename T>
inline typename Enable_If<Is_Singleton<T>::value, Interval<B, Info> >::type
operator/(const T& x, const Interval<B, Info>& y) {
  Interval<B, Info> z;
  z.div_assign(x, y);
  return z;
}

template <typename B, typename Info>
inline Interval<B, Info>
operator/(const Interval<B, Info>& x, const Interval<B, Info>& y) {
  Interval<B, Info> z;
  z.div_assign(x, y);
  return z;
}

template <typename Boundary, typename Info>
inline std::ostream&
operator<<(std::ostream& os, const Interval<Boundary, Info>& x) {
  if (check_empty_arg(x)) {
    return os << "[]";
  }
  if (x.is_singleton()) {
    output(os, x.lower(), Numeric_Format(), ROUND_NOT_NEEDED);
    return os;
  }
  os << (x.lower_is_open() ? "(" : "[");
  if (x.info().get_boundary_property(LOWER, SPECIAL)) {
    os << "-inf";
  }
  else {
    output(os, x.lower(), Numeric_Format(), ROUND_NOT_NEEDED);
  }
  os << ", ";
  if (x.info().get_boundary_property(UPPER, SPECIAL)) {
    os << "+inf";
  }
  else {
    output(os, x.upper(), Numeric_Format(), ROUND_NOT_NEEDED);
  }
  os << (x.upper_is_open() ? ")" : "]");
  return os;
}

template <typename Boundary, typename Info>
inline void
Interval<Boundary, Info>::ascii_dump(std::ostream& s) const {
  using Parma_Polyhedra_Library::ascii_dump;
  s << "info ";
  info().ascii_dump(s);
  s << " lower ";
  ascii_dump(s, lower());
  s << " upper ";
  ascii_dump(s, upper());
  s << '\n';
}

template <typename Boundary, typename Info>
inline bool
Interval<Boundary, Info>::ascii_load(std::istream& s) {
  using Parma_Polyhedra_Library::ascii_load;
  std::string str;
  if (!(s >> str) || str != "info") {
    return false;
  }
  if (!info().ascii_load(s)) {
    return false;
  }
  if (!(s >> str) || str != "lower") {
    return false;
  }
  if (!ascii_load(s, lower())) {
    return false;
  }
  if (!(s >> str) || str != "upper") {
    return false;
  }
  if (!ascii_load(s, upper())) {
    return false;
  }
  PPL_ASSERT(OK());
  return true;
}

/*! \brief
  Helper class to select the appropriate numerical type to perform
  boundary computations so as to reduce the chances of overflow without
  incurring too much overhead.
*/
template <typename Interval_Boundary_Type> struct Select_Temp_Boundary_Type;

template <typename Interval_Boundary_Type>
struct Select_Temp_Boundary_Type {
  typedef Interval_Boundary_Type type;
};

#if PPL_SUPPORTED_DOUBLE
template <>
struct Select_Temp_Boundary_Type<float> {
  typedef double type;
};
#endif

template <>
struct Select_Temp_Boundary_Type<char> {
  typedef signed long long type;
};

template <>
struct Select_Temp_Boundary_Type<signed char> {
  typedef signed long long type;
};

template <>
struct Select_Temp_Boundary_Type<unsigned char> {
  typedef signed long long type;
};

template <>
struct Select_Temp_Boundary_Type<signed short> {
  typedef signed long long type;
};

template <>
struct Select_Temp_Boundary_Type<unsigned short> {
  typedef signed long long type;
};

template <>
struct Select_Temp_Boundary_Type<signed int> {
  typedef signed long long type;
};

template <>
struct Select_Temp_Boundary_Type<unsigned int> {
  typedef signed long long type;
};

template <>
struct Select_Temp_Boundary_Type<signed long> {
  typedef signed long long type;
};

template <>
struct Select_Temp_Boundary_Type<unsigned long> {
  typedef signed long long type;
};

template <>
struct Select_Temp_Boundary_Type<unsigned long long> {
  typedef signed long long type;
};

/*! \relates Interval */
template <typename Boundary, typename Info>
inline void
swap(Interval<Boundary, Info>& x, Interval<Boundary, Info>& y) {
  x.m_swap(y);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Interval_templates.hh line 1. */
/* Interval class implementation: non-inline template functions.
*/


#include <algorithm>

namespace Parma_Polyhedra_Library {

template <typename Boundary, typename Info>
template <typename C>
typename Enable_If<Is_Same_Or_Derived<I_Constraint_Base, C>::value, I_Result>::type
Interval<Boundary, Info>::lower_extend(const C& c) {
  PPL_ASSERT(OK());
  bool open;
  switch (c.rel()) {
  case V_LGE:
    return lower_extend();
  case V_NAN:
    return I_NOT_EMPTY | I_EXACT | I_UNCHANGED;
  case V_GT:
    open = true;
    break;
  case V_GE: // Fall through.
  case V_EQ:
    open = false;
    break;
  default:
    PPL_UNREACHABLE;
    return I_NOT_EMPTY | I_EXACT | I_UNCHANGED;
  }
  min_assign(LOWER, lower(), info(), LOWER, c.value(), f_info(c.value(), open));
  PPL_ASSERT(OK());
  return I_ANY;
}

template <typename Boundary, typename Info>
template <typename C>
typename Enable_If<Is_Same_Or_Derived<I_Constraint_Base, C>::value, I_Result>::type
Interval<Boundary, Info>::upper_extend(const C& c) {
  PPL_ASSERT(OK());
  bool open;
  switch (c.rel()) {
  case V_LGE:
    return lower_extend();
  case V_NAN:
    return I_NOT_EMPTY | I_EXACT | I_UNCHANGED;
  case V_LT:
    open = true;
    break;
  case V_LE: // Fall through.
  case V_EQ:
    open = false;
    break;
  default:
    PPL_UNREACHABLE;
    return I_NOT_EMPTY | I_EXACT | I_UNCHANGED;
  }
  max_assign(UPPER, upper(), info(), UPPER, c.value(), f_info(c.value(), open));
  PPL_ASSERT(OK());
  return I_ANY;
}

template <typename Boundary, typename Info>
template <typename From, typename Iterator>
typename Enable_If<Is_Interval<From>::value, void>::type
Interval<Boundary, Info>::CC76_widening_assign(const From& y,
                                               Iterator first,
                                               Iterator last) {
  // We assume that `y' is contained in or equal to `*this'.
  PPL_ASSERT(contains(y));
  Interval<Boundary, Info>& x = *this;

  // Upper bound.
  if (!x.upper_is_boundary_infinity()) {
    Boundary& x_ub = x.upper();
    const Boundary& y_ub = y.upper();
    PPL_ASSERT(!y.upper_is_boundary_infinity() && y_ub <= x_ub);
    if (y_ub < x_ub) {
      Iterator k = std::lower_bound(first, last, x_ub);
      if (k != last) {
        if (x_ub < *k) {
          x_ub = *k;
        }
      }
      else {
        x.upper_extend();
      }
    }
  }

  // Lower bound.
  if (!x.lower_is_boundary_infinity()) {
    Boundary& x_lb = x.lower();
    const Boundary& y_lb = y.lower();
    PPL_ASSERT(!y.lower_is_boundary_infinity() && y_lb >= x_lb);
    if (y_lb > x_lb) {
      Iterator k = std::lower_bound(first, last, x_lb);
      if (k != last) {
        if (x_lb < *k) {
          if (k != first) {
            x_lb = *--k;
          }
          else {
            x.lower_extend();
          }
        }
      }
      else {
        if (k != first) {
          x_lb = *--k;
        }
        else {
          x.lower_extend();
        }
      }
    }
  }
}

template <typename Boundary, typename Info>
Interval<Boundary, Info>::Interval(const char* s) {
  // Get the lower bound.
  Boundary lower_bound;
  Result lower_r = assign_r(lower_bound, s, ROUND_DOWN);
  if (lower_r == V_CVT_STR_UNK || lower_r == V_NAN) {
    throw std::invalid_argument("PPL::Interval(const char* s)"
                                " with s invalid");
  }
  lower_r = result_relation_class(lower_r);

  // Get the upper bound.
  Boundary upper_bound;
  Result upper_r = assign_r(upper_bound, s, ROUND_UP);
  PPL_ASSERT(upper_r != V_CVT_STR_UNK && upper_r != V_NAN);
  upper_r = result_relation_class(upper_r);

  // Build the interval.
  bool lower_open = false;
  bool upper_open = false;
  bool lower_boundary_infinity = false;
  bool upper_boundary_infinity = false;
  switch (lower_r) {
  case V_EQ: // Fall through.
  case V_GE:
    break;
  case V_GT:
    lower_open = true;
    break;
  case V_GT_MINUS_INFINITY:
    lower_open = true;
    // Fall through.
  case V_EQ_MINUS_INFINITY:
    lower_boundary_infinity = true;
    break;
  case V_EQ_PLUS_INFINITY: // Fall through.
  case V_LT_PLUS_INFINITY:
    if (upper_r == V_EQ_PLUS_INFINITY || upper_r == V_LT_PLUS_INFINITY) {
      assign(UNIVERSE);
    }
    else {
      assign(EMPTY);
    }
    break;
  default:
    PPL_UNREACHABLE;
    break;
  }
  switch (upper_r) {
  case V_EQ: // Fall through.
  case V_LE:
    break;
  case V_LT:
    upper_open = true;
    break;
  case V_EQ_MINUS_INFINITY: // Fall through.
  case V_GT_MINUS_INFINITY:
    if (lower_r == V_EQ_MINUS_INFINITY || lower_r == V_GT_MINUS_INFINITY) {
      assign(UNIVERSE);
    }
    else {
      assign(EMPTY);
    }
    break;
  case V_LT_PLUS_INFINITY:
    upper_open = true;
    // Fall through.
  case V_EQ_PLUS_INFINITY:
    upper_boundary_infinity = true;
    break;
  default:
    PPL_UNREACHABLE;
    break;
  }

  if (!lower_boundary_infinity
      && !upper_boundary_infinity
      && (lower_bound > upper_bound
          || (lower_open && lower_bound == upper_bound))) {
    assign(EMPTY);
  }
  else {
    if (lower_boundary_infinity) {
      set_minus_infinity(LOWER, lower(), info(), lower_open);
    }
    else {
      Boundary_NS::assign(LOWER, lower(), info(),
                          LOWER, lower_bound, SCALAR_INFO, lower_open);
    }
    if (upper_boundary_infinity) {
      set_plus_infinity(UPPER, upper(), info(), upper_open);
    }
    else {
      Boundary_NS::assign(UPPER, upper(), info(),
                          UPPER, upper_bound, SCALAR_INFO, upper_open);
    }
  }
}


template <typename Boundary, typename Info>
inline std::istream&
operator>>(std::istream& is, Interval<Boundary, Info>& x) {
  Boundary lower_bound;
  Boundary upper_bound;
  bool lower_boundary_infinity = false;
  bool upper_boundary_infinity = false;
  bool lower_open = false;
  bool upper_open = false;
  Result lower_r;
  Result upper_r;

  // Eat leading white space.
  char c;
  do {
    if (!is.get(c)) {
      goto fail;
    }
  } while (is_space(c));

  // Get the opening parenthesis and handle the empty interval case.
  if (c == '(') {
    lower_open = true;
  }
  else if (c == '[') {
    if (!is.get(c)) {
      goto fail;
    }
    if (c == ']') {
      // Empty interval.
      x.assign(EMPTY);
      return is;
    }
    else {
      is.unget();
    }
  }
  else {
    goto unexpected_char;
  }

  // Get the lower bound.
  lower_r = input(lower_bound, is, ROUND_DOWN);
  if (lower_r == V_CVT_STR_UNK || lower_r == V_NAN) {
    goto fail;
  }
  lower_r = result_relation_class(lower_r);

  // Match the comma separating the lower and upper bounds.
  do {
    if (!is.get(c)) {
      goto fail;
    }
  } while (is_space(c));
  if (c != ',') {
    goto unexpected_char;
  }

  // Get the upper bound.
  upper_r = input(upper_bound, is, ROUND_UP);
  if (upper_r == V_CVT_STR_UNK || upper_r == V_NAN) {
    goto fail;
  }
  upper_r = result_relation_class(upper_r);

  // Get the closing parenthesis.
  do {
    if (!is.get(c)) {
      goto fail;
    }
  } while (is_space(c));
  if (c == ')') {
    upper_open = true;
  }
  else if (c != ']') {
  unexpected_char:
    is.unget();
  fail:
    is.setstate(std::ios::failbit);
    return is;
  }

  // Build interval.
  switch (lower_r) {
  case V_EQ: // Fall through.
  case V_GE:
    break;
  case V_GT:
    lower_open = true;
    break;
  case V_GT_MINUS_INFINITY:
    lower_open = true;
    // Fall through.
  case V_EQ_MINUS_INFINITY:
    lower_boundary_infinity = true;
    break;
  case V_EQ_PLUS_INFINITY: // Fall through.
  case V_LT_PLUS_INFINITY:
    if (upper_r == V_EQ_PLUS_INFINITY || upper_r == V_LT_PLUS_INFINITY) {
      x.assign(UNIVERSE);
    }
    else {
      x.assign(EMPTY);
    }
    return is;
  default:
    PPL_UNREACHABLE;
    break;
  }
  switch (upper_r) {
  case V_EQ: // Fall through.
  case V_LE:
    break;
  case V_LT:
    upper_open = true;
    break;
  case V_GT_MINUS_INFINITY:
    upper_open = true;
    // Fall through.
  case V_EQ_MINUS_INFINITY:
    if (lower_r == V_EQ_MINUS_INFINITY || lower_r == V_GT_MINUS_INFINITY) {
      x.assign(UNIVERSE);
    }
    else {
      x.assign(EMPTY);
    }
    return is;
  case V_EQ_PLUS_INFINITY: // Fall through.
  case V_LT_PLUS_INFINITY:
    upper_boundary_infinity = true;
    break;
  default:
    PPL_UNREACHABLE;
    break;
  }

  if (!lower_boundary_infinity
      && !upper_boundary_infinity
      && (lower_bound > upper_bound
          || (lower_open && lower_bound == upper_bound))) {
    x.assign(EMPTY);
  }
  else {
    if (lower_boundary_infinity) {
      set_minus_infinity(LOWER, x.lower(), x.info(), lower_open);
    }
    else {
      assign(LOWER, x.lower(), x.info(),
             LOWER, lower_bound, SCALAR_INFO, lower_open);
    }
    if (upper_boundary_infinity) {
      set_plus_infinity(UPPER, x.upper(), x.info(), upper_open);
    }
    else {
      assign(UPPER, x.upper(), x.info(),
             UPPER, upper_bound, SCALAR_INFO, upper_open);
    }
  }
  return is;
}

template <typename Boundary, typename Info>
template <typename From>
typename Enable_If<Is_Interval<From>::value, bool>::type
Interval<Boundary, Info>::simplify_using_context_assign(const From& y) {
  // FIXME: the following code wrongly assumes that intervals are closed
  if (lt(UPPER, upper(), info(), LOWER, f_lower(y), f_info(y))) {
    lower_extend();
    return false;
  }
  if (gt(LOWER, lower(), info(), UPPER, f_upper(y), f_info(y))) {
    upper_extend();
    return false;
  }
  // Weakening the upper bound.
  if (!upper_is_boundary_infinity() && !y.upper_is_boundary_infinity()
      && y.upper() <= upper()) {
    upper_extend();
  }
  // Weakening the lower bound.
  if (!lower_is_boundary_infinity() && !y.lower_is_boundary_infinity()
      && y.lower() >= lower()) {
    lower_extend();
  }
  return true;
}

template <typename Boundary, typename Info>
template <typename From>
typename Enable_If<Is_Interval<From>::value, void>::type
Interval<Boundary, Info>::empty_intersection_assign(const From&) {
  // FIXME: write me.
  assign(EMPTY);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Interval_defs.hh line 780. */

/* Automatically generated from PPL source file ../src/Integer_Interval.hh line 28. */
#include <gmpxx.h>

namespace Parma_Polyhedra_Library {

struct Integer_Interval_Info_Policy {
  const_bool_nodef(store_special, true);
  const_bool_nodef(store_open, false);
  const_bool_nodef(cache_empty, true);
  const_bool_nodef(cache_singleton, true);
  const_int_nodef(next_bit, 0);
  const_bool_nodef(may_be_empty, true);
  const_bool_nodef(may_contain_infinity, false);
  const_bool_nodef(check_empty_result, false);
  const_bool_nodef(check_inexact, false);
};

typedef Interval_Info_Bitset<unsigned int, Integer_Interval_Info_Policy> Integer_Interval_Info;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! An interval with integral, necessarily closed boundaries.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
typedef Interval<mpz_class, Integer_Interval_Info> Integer_Interval;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/initializer.hh line 1. */
/* Nifty counter object for the initialization of the library.
*/


/* Automatically generated from PPL source file ../src/Init_defs.hh line 1. */
/* Init class declaration.
*/


/* Automatically generated from PPL source file ../src/Init_defs.hh line 29. */

namespace Parma_Polyhedra_Library {

/*! \brief
  Sets the FPU rounding mode so that the PPL abstractions based on
  floating point numbers work correctly.

  This is performed automatically at initialization-time.  Calling
  this function is needed only if restore_pre_PPL_rounding() has been
  previously called.
*/
void set_rounding_for_PPL();

/*! \brief
  Sets the FPU rounding mode as it was before initialization of the PPL.

  This is important if the application uses floating-point computations
  outside the PPL.  It is crucial when the application uses functions
  from a mathematical library that are not guaranteed to work correctly
  under all rounding modes.

  After calling this function it is absolutely necessary to call
  set_rounding_for_PPL() before using any PPL abstractions based on
  floating point numbers.
  This is performed automatically at finalization-time.
*/
void restore_pre_PPL_rounding();

} // namespace Parma_Polyhedra_Library

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Class for initialization and finalization.
/*! \ingroup PPL_CXX_interface
  <EM>Nifty Counter</EM> initialization class,
  ensuring that the library is initialized only once
  and before its first use.
  A count of the number of translation units using the library
  is maintained. A static object of Init type will be declared
  by each translation unit using the library.  As a result,
  only one of them will initialize and properly finalize
  the library.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
class Parma_Polyhedra_Library::Init {
public:
  //! Initializes the PPL.
  Init();

  //! Finalizes the PPL.
  ~Init();

private:
  /*! \brief
    Default precision parameter used for irrational calculations.

    The default is chosen to have a precision greater than most
    precise IEC 559 floating point (112 bits of mantissa).
  */
  static const unsigned DEFAULT_IRRATIONAL_PRECISION = 128U;

  //! Count the number of objects created.
  static unsigned int count;
  static fpu_rounding_direction_type old_rounding_direction;

  friend void set_rounding_for_PPL();
  friend void restore_pre_PPL_rounding();
};

/* Automatically generated from PPL source file ../src/Init_inlines.hh line 1. */
/* Init class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Init_inlines.hh line 29. */

namespace Parma_Polyhedra_Library {

inline void
set_rounding_for_PPL() {
#if PPL_CAN_CONTROL_FPU
    fpu_set_rounding_direction(round_fpu_dir(ROUND_DIRECT));
#endif
}

inline void
restore_pre_PPL_rounding() {
#if PPL_CAN_CONTROL_FPU
  fpu_set_rounding_direction(Init::old_rounding_direction);
#endif
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Init_defs.hh line 98. */


/* Automatically generated from PPL source file ../src/initializer.hh line 28. */

#ifndef PPL_NO_AUTOMATIC_INITIALIZATION

static Parma_Polyhedra_Library::Init Parma_Polyhedra_Library_initializer;

#else

namespace Parma_Polyhedra_Library {

namespace Implementation {

void initialize_aux();
void finalize_aux();

} // namespace Implementation

} // namespace Parma_Polyhedra_Library

#endif

namespace Parma_Polyhedra_Library {

//! Initializes the library.
inline void
initialize() {
#ifdef PPL_NO_AUTOMATIC_INITIALIZATION
  Implementation::initialize_aux();
#endif
}

//! Finalizes the library.
inline void
finalize() {
#ifdef PPL_NO_AUTOMATIC_INITIALIZATION
  Implementation::finalize_aux();
#endif
}

} //namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Expression_Impl_defs.hh line 1. */
/* Linear_Expression_Impl class declaration.
*/


/* Automatically generated from PPL source file ../src/Linear_Expression_Impl_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename Row>
class Linear_Expression_Impl;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Expression_Interface_defs.hh line 1. */
/* Linear_Expression_Interface class declaration.
*/


/* Automatically generated from PPL source file ../src/Linear_Expression_Interface_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Linear_Expression_Interface;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Coefficient_defs.hh line 1. */
/* Coefficient class declaration.
*/


/* Automatically generated from PPL source file ../src/Coefficient_types.hh line 1. */


/* Automatically generated from PPL source file ../src/Coefficient_types.hh line 17. */

#ifdef PPL_GMP_INTEGERS
/* Automatically generated from PPL source file ../src/GMP_Integer_types.hh line 1. */


/* Automatically generated from PPL source file ../src/GMP_Integer_types.hh line 18. */
#include <gmpxx.h>

namespace Parma_Polyhedra_Library {

/*! \class Parma_Polyhedra_Library::GMP_Integer
  \brief
  Unbounded integers as provided by the GMP library.

  \ingroup PPL_CXX_interface
  GMP_Integer is an alias for the <CODE>mpz_class</CODE> type
  defined in the C++ interface of the GMP library.
  For more information, see <CODE>http://gmplib.org/</CODE>
*/
typedef mpz_class GMP_Integer;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Coefficient traits specialization for unbounded integers.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <>
struct Coefficient_traits_template<GMP_Integer> {
  //! The type used for references to const unbounded integers.
  typedef const GMP_Integer& const_reference;
};

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Coefficient_types.hh line 20. */
#endif

#if defined(PPL_CHECKED_INTEGERS) || defined(PPL_NATIVE_INTEGERS)

namespace Parma_Polyhedra_Library {

//! A policy for checked bounded integer coefficients.
/*! \ingroup PPL_CXX_interface */
struct Bounded_Integer_Coefficient_Policy {
  //! Check for overflowed result.
  const_bool_nodef(check_overflow, true);

  //! Do not check for attempts to add infinities with different sign.
  const_bool_nodef(check_inf_add_inf, false);

  //! Do not check for attempts to subtract infinities with same sign.
  const_bool_nodef(check_inf_sub_inf, false);

  //! Do not check for attempts to multiply infinities by zero.
  const_bool_nodef(check_inf_mul_zero, false);

  //! Do not check for attempts to divide by zero.
  const_bool_nodef(check_div_zero, false);

  //! Do not check for attempts to divide infinities.
  const_bool_nodef(check_inf_div_inf, false);

  //! Do not check for attempts to compute remainder of infinities.
  const_bool_nodef(check_inf_mod, false);

  //! Do not checks for attempts to take the square root of a negative number.
  const_bool_nodef(check_sqrt_neg, false);

  //! Do not handle not-a-number special value.
  const_bool_nodef(has_nan, false);

  //! Do not handle infinity special values.
  const_bool_nodef(has_infinity, false);

  /*! \brief
    The checked number can always be safely converted to the
    underlying type \p T and vice-versa.
  */
  const_bool_nodef(convertible, true);

  //! Do not honor requests to check for FPU inexact results.
  const_bool_nodef(fpu_check_inexact, false);

  //! Do not make extra checks to detect FPU NaN results.
  const_bool_nodef(fpu_check_nan_result, true);

  /*! \brief
    For constructors, by default use the same rounding used by
    underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_CONSTRUCTOR = ROUND_NATIVE;

  /*! \brief
    For overloaded operators (operator+(), operator-(), ...), by
    default use the same rounding used by the underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_OPERATOR = ROUND_NATIVE;

  /*! \brief
    For input functions, by default use the same rounding used by
    the underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_INPUT = ROUND_NATIVE;

  /*! \brief
    For output functions, by default use the same rounding used by
    the underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_OUTPUT = ROUND_NATIVE;

  /*! \brief
    For all other functions, by default use the same rounding used by
    the underlying type.
  */
  static const Rounding_Dir ROUND_DEFAULT_FUNCTION = ROUND_NATIVE;

  /*! \brief
    Handles \p r: called by all constructors, operators and functions that
    do not return a Result value.
  */
  static void handle_result(Result r);
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Coefficient traits specialization for 8 bits checked integers.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Policy>
struct Coefficient_traits_template<Checked_Number<int8_t, Policy> > {
  //! The type used for references to const 8 bit checked integers.
  typedef Checked_Number<int8_t, Policy> const_reference;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Coefficient traits specialization for 16 bits checked integers.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Policy>
struct Coefficient_traits_template<Checked_Number<int16_t, Policy> > {
  //! The type used for references to const 16 bit checked integers.
  typedef Checked_Number<int16_t, Policy> const_reference;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Coefficient traits specialization for 32 bits checked integers.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Policy>
struct Coefficient_traits_template<Checked_Number<int32_t, Policy> > {
  //! The type used for references to const 32 bit checked integers.
  typedef Checked_Number<int32_t, Policy> const_reference;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Coefficient traits specialization for 64 bits checked integers.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Policy>
struct Coefficient_traits_template<Checked_Number<int64_t, Policy> > {
  //! The type used for references to const 64 bit checked integers.
  typedef const Checked_Number<int64_t, Policy>& const_reference;
};

} // namespace Parma_Polyhedra_Library

#endif // defined(PPL_CHECKED_INTEGERS) || defined(PPL_NATIVE_INTEGERS)

namespace Parma_Polyhedra_Library {

//! An alias for easily naming the type of PPL coefficients.
/*! \ingroup PPL_CXX_interface
  Objects of type Coefficient are used to implement the integral valued
  coefficients occurring in linear expressions, constraints, generators,
  intervals, bounding boxes and so on.  Depending on the chosen
  configuration options (see file <CODE>README.configure</CODE>),
  a Coefficient may actually be:
    - The GMP_Integer type, which in turn is an alias for the
      <CODE>mpz_class</CODE> type implemented by the C++ interface
      of the GMP library (this is the default configuration).
    - An instance of the Checked_Number class template: with the policy
      Bounded_Integer_Coefficient_Policy, this implements overflow
      detection on top of a native integral type (available template
      instances include checked integers having 8, 16, 32 or 64 bits);
      with the Checked_Number_Transparent_Policy, this is a wrapper
      for native integral types with no overflow detection
      (available template instances are as above).
*/
typedef PPL_COEFFICIENT_TYPE Coefficient;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! An alias for easily naming the coefficient traits.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
typedef Coefficient_traits_template<Coefficient> Coefficient_traits;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Coefficient_defs.hh line 28. */

#if defined(PPL_CHECKED_INTEGERS) || defined(PPL_NATIVE_INTEGERS)
/* Automatically generated from PPL source file ../src/Coefficient_defs.hh line 32. */
#endif

#ifdef PPL_GMP_INTEGERS
/* Automatically generated from PPL source file ../src/GMP_Integer_defs.hh line 1. */
/* GMP_Integer class declaration.
*/


/* Automatically generated from PPL source file ../src/GMP_Integer_defs.hh line 29. */
#include <cstddef>

namespace Parma_Polyhedra_Library {

//! \name Accessor Functions
//@{

//! Returns a const reference to the underlying integer value.
/*! \relates GMP_Integer */
const mpz_class& raw_value(const GMP_Integer& x);

//! Returns a reference to the underlying integer value.
/*! \relates GMP_Integer */
mpz_class& raw_value(GMP_Integer& x);

//@} // Accessor Functions

//! \name Arithmetic Operators
//@{

//! Assigns to \p x its negation.
/*! \relates GMP_Integer */
void neg_assign(GMP_Integer& x);

//! Assigns to \p x the negation of \p y.
/*! \relates GMP_Integer */
void neg_assign(GMP_Integer& x, const GMP_Integer& y);

//! Assigns to \p x its absolute value.
/*! \relates GMP_Integer */
void abs_assign(GMP_Integer& x);

//! Assigns to \p x the absolute value of \p y.
/*! \relates GMP_Integer */
void abs_assign(GMP_Integer& x, const GMP_Integer& y);

//! Assigns to \p x the remainder of the division of \p y by \p z.
/*! \relates GMP_Integer */
void rem_assign(GMP_Integer& x,
                const GMP_Integer& y, const GMP_Integer& z);

//! Assigns to \p x the greatest common divisor of \p y and \p z.
/*! \relates GMP_Integer */
void gcd_assign(GMP_Integer& x,
                const GMP_Integer& y, const GMP_Integer& z);

//! Extended GCD.
/*! \relates GMP_Integer
  Assigns to \p x the greatest common divisor of \p y and \p z, and to
  \p s and \p t the values such that \p y * \p s + \p z * \p t = \p x.
*/
void gcdext_assign(GMP_Integer& x, GMP_Integer& s, GMP_Integer& t,
                   const GMP_Integer& y, const GMP_Integer& z);

//! Assigns to \p x the least common multiple of \p y and \p z.
/*! \relates GMP_Integer */
void lcm_assign(GMP_Integer& x,
                const GMP_Integer& y, const GMP_Integer& z);

//! Assigns to \p x the value <CODE>x + y * z</CODE>.
/*! \relates GMP_Integer */
void add_mul_assign(GMP_Integer& x,
                    const GMP_Integer& y, const GMP_Integer& z);

//! Assigns to \p x the value <CODE>x - y * z</CODE>.
/*! \relates GMP_Integer */
void sub_mul_assign(GMP_Integer& x,
                    const GMP_Integer& y, const GMP_Integer& z);

//! Assigns to \p x the value \f$ y \cdot 2^\mathtt{exp} \f$.
/*! \relates GMP_Integer */
void mul_2exp_assign(GMP_Integer& x, const GMP_Integer& y, unsigned int exp);

//! Assigns to \p x the value \f$ y / 2^\mathtt{exp} \f$.
/*! \relates GMP_Integer */
void div_2exp_assign(GMP_Integer& x, const GMP_Integer& y, unsigned int exp);

/*! \brief
  If \p z divides \p y, assigns to \p x the quotient of the integer
  division of \p y and \p z.

  \relates GMP_Integer
  The behavior is undefined if \p z does not divide \p y.
*/
void exact_div_assign(GMP_Integer& x,
                      const GMP_Integer& y, const GMP_Integer& z);

//! Assigns to \p x the integer square root of \p y.
/*! \relates GMP_Integer */
void sqrt_assign(GMP_Integer& x, const GMP_Integer& y);

/*! \brief
  Returns a negative, zero or positive value depending on whether
  \p x is lower than, equal to or greater than \p y, respectively.

  \relates GMP_Integer
*/
int cmp(const GMP_Integer& x, const GMP_Integer& y);

//@} // Arithmetic Operators

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/GMP_Integer_inlines.hh line 1. */
/* GMP_Integer class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/GMP_Integer_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

inline void
neg_assign(GMP_Integer& x) {
  mpz_neg(x.get_mpz_t(), x.get_mpz_t());
}

inline void
neg_assign(GMP_Integer& x, const GMP_Integer& y) {
  mpz_neg(x.get_mpz_t(), y.get_mpz_t());
}

inline void
abs_assign(GMP_Integer& x) {
  mpz_abs(x.get_mpz_t(), x.get_mpz_t());
}

inline void
abs_assign(GMP_Integer& x, const GMP_Integer& y) {
  mpz_abs(x.get_mpz_t(), y.get_mpz_t());
}

inline void
gcd_assign(GMP_Integer& x, const GMP_Integer& y, const GMP_Integer& z) {
  mpz_gcd(x.get_mpz_t(), y.get_mpz_t(), z.get_mpz_t());
}

inline void
rem_assign(GMP_Integer& x, const GMP_Integer& y, const GMP_Integer& z) {
  mpz_tdiv_r(x.get_mpz_t(), y.get_mpz_t(), z.get_mpz_t());
}

inline void
gcdext_assign(GMP_Integer& x, GMP_Integer& s, GMP_Integer& t,
              const GMP_Integer& y, const GMP_Integer& z) {
  mpz_gcdext(x.get_mpz_t(),
             s.get_mpz_t(), t.get_mpz_t(),
             y.get_mpz_t(), z.get_mpz_t());
}

inline void
lcm_assign(GMP_Integer& x, const GMP_Integer& y, const GMP_Integer& z) {
  mpz_lcm(x.get_mpz_t(), y.get_mpz_t(), z.get_mpz_t());
}

inline void
add_mul_assign(GMP_Integer& x, const GMP_Integer& y, const GMP_Integer& z) {
  mpz_addmul(x.get_mpz_t(), y.get_mpz_t(), z.get_mpz_t());
}

inline void
sub_mul_assign(GMP_Integer& x, const GMP_Integer& y, const GMP_Integer& z) {
  mpz_submul(x.get_mpz_t(), y.get_mpz_t(), z.get_mpz_t());
}

inline void
mul_2exp_assign(GMP_Integer& x, const GMP_Integer& y, unsigned int exp) {
  mpz_mul_2exp(x.get_mpz_t(), y.get_mpz_t(), exp);
}

inline void
div_2exp_assign(GMP_Integer& x, const GMP_Integer& y, unsigned int exp) {
  mpz_tdiv_q_2exp(x.get_mpz_t(), y.get_mpz_t(), exp);
}

inline void
exact_div_assign(GMP_Integer& x, const GMP_Integer& y, const GMP_Integer& z) {
  PPL_ASSERT(y % z == 0);
  mpz_divexact(x.get_mpz_t(), y.get_mpz_t(), z.get_mpz_t());
}

inline void
sqrt_assign(GMP_Integer& x, const GMP_Integer& y) {
  mpz_sqrt(x.get_mpz_t(), y.get_mpz_t());
}

inline int
cmp(const GMP_Integer& x, const GMP_Integer& y) {
  return mpz_cmp(x.get_mpz_t(), y.get_mpz_t());
}

inline const mpz_class&
raw_value(const GMP_Integer& x) {
  return x;
}

inline mpz_class&
raw_value(GMP_Integer& x) {
  return x;
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/GMP_Integer_defs.hh line 133. */

/* Automatically generated from PPL source file ../src/Coefficient_defs.hh line 36. */
#endif

#include <iosfwd>

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Initializes the Coefficient constants.
#endif
void Coefficient_constants_initialize();

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Finalizes the Coefficient constants.
#endif
void Coefficient_constants_finalize();

//! Returns a const reference to a Coefficient with value 0.
Coefficient_traits::const_reference Coefficient_zero();

//! Returns a const reference to a Coefficient with value 1.
Coefficient_traits::const_reference Coefficient_one();

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Coefficient_inlines.hh line 1. */
/* Coefficient class implementation: inline functions.
*/


namespace Parma_Polyhedra_Library {

#ifdef PPL_CHECKED_INTEGERS
inline void
Bounded_Integer_Coefficient_Policy::handle_result(Result r) {
  // Note that the input functions can return VC_NAN.
  if (result_overflow(r) || result_class(r) == VC_NAN) {
    throw_result_exception(r);
  }
}
#endif // PPL_CHECKED_INTEGERS


#if defined(PPL_CHECKED_INTEGERS) || defined(PPL_NATIVE_INTEGERS)
inline Coefficient_traits::const_reference
Coefficient_zero() {
  // FIXME: is there a way to avoid this static variable?
  static Coefficient zero(0);
  return zero;
}

inline Coefficient_traits::const_reference
Coefficient_one() {
  // FIXME: is there a way to avoid this static variable?
  static Coefficient one(1);
  return one;
}
#endif // defined(PPL_CHECKED_INTEGERS) || defined(PPL_NATIVE_INTEGERS)

#ifdef PPL_GMP_INTEGERS
inline Coefficient_traits::const_reference
Coefficient_zero() {
  extern const Coefficient* Coefficient_zero_p;
  return *Coefficient_zero_p;
}

inline Coefficient_traits::const_reference
Coefficient_one() {
  extern const Coefficient* Coefficient_one_p;
  PPL_ASSERT(*Coefficient_one_p != 0);
  return *Coefficient_one_p;
}
#endif // PPL_GMP_INTEGERS

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Coefficient_defs.hh line 61. */

/* Automatically generated from PPL source file ../src/Variables_Set_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Variables_Set;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Dense_Row_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Dense_Row;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Sparse_Row_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Sparse_Row;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Expression_Interface_defs.hh line 33. */
#include <vector>
#include <set>
#include <cstddef>

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! A linear expression.
/*! \ingroup PPL_CXX_interface
  An object of a class implementing Linear_Expression_Interface
  represents a linear expression
  \f[
    \sum_{i=0}^{n-1} a_i x_i + b
  \f]
  where \f$n\f$ is the dimension of the vector space,
  each \f$a_i\f$ is the integer coefficient
  of the \f$i\f$-th variable \f$x_i\f$
  and \f$b\f$ is the integer for the inhomogeneous term.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
class Parma_Polyhedra_Library::Linear_Expression_Interface {
public:
  virtual ~Linear_Expression_Interface();

  virtual bool OK() const = 0;

  //! Returns the current representation of this linear expression.
  virtual Representation representation() const = 0;

  //! An interface for const iterators on the expression (homogeneous)
  //! coefficients that are nonzero.
  /*!
    These iterators are invalidated by operations that modify the expression.
  */
  class const_iterator_interface {
  public:
    typedef std::bidirectional_iterator_tag iterator_category;
    typedef const Coefficient value_type;
    typedef std::ptrdiff_t difference_type;
    typedef value_type* pointer;
    typedef Coefficient_traits::const_reference reference;

    //! Returns a copy of *this.
    //! This returns a pointer to dynamic-allocated memory. The caller has the
    //! duty to free the memory when it's not needed anymore.
    virtual const_iterator_interface* clone() const = 0;

    virtual ~const_iterator_interface();

    //! Navigates to the next nonzero coefficient.
    //! Note that this method does *not* return a reference, to increase
    //! efficiency since it's virtual.
    virtual void operator++() = 0;

    //! Navigates to the previous nonzero coefficient.
    //! Note that this method does *not* return a reference, to increase
    //! efficiency since it's virtual.
    virtual void operator--() = 0;

    //! Returns the current element.
    virtual reference operator*() const = 0;

    //! Returns the variable of the coefficient pointed to by \c *this.
    /*!
      \returns the variable of the coefficient pointed to by \c *this.
    */
    virtual Variable variable() const = 0;

    //! Compares \p *this with x .
    /*!
      \param x
      The %iterator that will be compared with *this.
    */
    virtual bool operator==(const const_iterator_interface& x) const = 0;
  };

  //! This returns a pointer to dynamic-allocated memory. The caller has the
  //! duty to free the memory when it's not needed anymore.
  virtual const_iterator_interface* begin() const = 0;

  //! This returns a pointer to dynamic-allocated memory. The caller has the
  //! duty to free the memory when it's not needed anymore.
  virtual const_iterator_interface* end() const = 0;

  //! This returns a pointer to dynamic-allocated memory. The caller has the
  //! duty to free the memory when it's not needed anymore.
  //! Returns (a pointer to) an iterator that points to the first nonzero
  //! coefficient of a variable greater than or equal to v, or at end if no
  //! such coefficient exists.
  virtual const_iterator_interface* lower_bound(Variable v) const = 0;

  //! Returns the dimension of the vector space enclosing \p *this.
  virtual dimension_type space_dimension() const = 0;

  //! Sets the dimension of the vector space enclosing \p *this to \p n .
  virtual void set_space_dimension(dimension_type n) = 0;

  //! Returns the coefficient of \p v in \p *this.
  virtual Coefficient_traits::const_reference
  coefficient(Variable v) const = 0;

  //! Sets the coefficient of \p v in \p *this to \p n.
  virtual void
  set_coefficient(Variable v, Coefficient_traits::const_reference n) = 0;

  //! Returns the inhomogeneous term of \p *this.
  virtual Coefficient_traits::const_reference inhomogeneous_term() const = 0;

  //! Sets the inhomogeneous term of \p *this to \p n.
  virtual void
  set_inhomogeneous_term(Coefficient_traits::const_reference n) = 0;

  //! Linearly combines \p *this with \p y so that the coefficient of \p v
  //! is 0.
  /*!
    \param y
    The expression that will be combined with \p *this object;

    \param v
    The variable whose coefficient has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the coefficient of variable \p v equal to \f$0\f$. Then it assigns
    the resulting expression to \p *this.

    \p *this and \p y must have the same space dimension.
  */
  virtual void
  linear_combine(const Linear_Expression_Interface& y, Variable v) = 0;

  //! Equivalent to <CODE>*this = *this * c1 + y * c2</CODE>, but assumes that
  //! \p *this and \p y have the same space dimension.
  virtual void linear_combine(const Linear_Expression_Interface& y,
                              Coefficient_traits::const_reference c1,
                              Coefficient_traits::const_reference c2) = 0;

  //! Equivalent to <CODE>*this = *this * c1 + y * c2</CODE>.
  //! c1 and c2 may be 0.
  virtual void linear_combine_lax(const Linear_Expression_Interface& y,
                                  Coefficient_traits::const_reference c1,
                                  Coefficient_traits::const_reference c2) = 0;

  //! Swaps the coefficients of the variables \p v1 and \p v2 .
  virtual void swap_space_dimensions(Variable v1, Variable v2) = 0;

  //! Removes all the specified dimensions from the expression.
  /*!
    The space dimension of the variable with the highest space
    dimension in \p vars must be at most the space dimension
    of \p this.
  */
  virtual void remove_space_dimensions(const Variables_Set& vars) = 0;

  //! Shift by \p n positions the coefficients of variables, starting from
  //! the coefficient of \p v. This increases the space dimension by \p n.
  virtual void shift_space_dimensions(Variable v, dimension_type n) = 0;

  //! Permutes the space dimensions of the expression.
  /*!
    \param cycle
    A vector representing a cycle of the permutation according to which the
    space dimensions must be rearranged.

    The \p cycle vector represents a cycle of a permutation of space
    dimensions.
    For example, the permutation
    \f$ \{ x_1 \mapsto x_2, x_2 \mapsto x_3, x_3 \mapsto x_1 \}\f$ can be
    represented by the vector containing \f$ x_1, x_2, x_3 \f$.
  */
  virtual void
  permute_space_dimensions(const std::vector<Variable>& cycle) = 0;

  //! Returns <CODE>true</CODE> if and only if \p *this is \f$0\f$.
  virtual bool is_zero() const = 0;

  /*! \brief
    Returns <CODE>true</CODE> if and only if all the homogeneous
    terms of \p *this are \f$0\f$.
  */
  virtual bool all_homogeneous_terms_are_zero() const = 0;

  /*! \brief
    Returns a lower bound to the total size in bytes of the memory
    occupied by \p *this.
  */
  virtual memory_size_type total_memory_in_bytes() const = 0;

  //! Returns the size in bytes of the memory managed by \p *this.
  virtual memory_size_type external_memory_in_bytes() const = 0;

  //! Writes to \p s an ASCII representation of \p *this.
  virtual void ascii_dump(std::ostream& s) const = 0;

  /*! \brief
    Loads from \p s an ASCII representation (as produced by
    ascii_dump(std::ostream&) const) and sets \p *this accordingly.
    Returns <CODE>true</CODE> if successful, <CODE>false</CODE> otherwise.
  */
  virtual bool ascii_load(std::istream& s) = 0;

  //! Returns \p true if *this is equal to \p x.
  //! Note that (*this == x) has a completely different meaning.
  virtual bool is_equal_to(const Linear_Expression_Interface& x) const = 0;

  //! Normalizes the modulo of the coefficients and of the inhomogeneous term
  //! so that they are mutually prime.
  /*!
    Computes the Greatest Common Divisor (GCD) among the coefficients
    and the inhomogeneous term and normalizes them by the GCD itself.
  */
  virtual void normalize() = 0;

  //! Ensures that the first nonzero homogeneous coefficient is positive,
  //! by negating the row if necessary.
  virtual void sign_normalize() = 0;

  /*! \brief
    Negates the elements from index \p first (included)
    to index \p last (excluded).
  */
  virtual void negate(dimension_type first, dimension_type last) = 0;

  virtual Linear_Expression_Interface&
  operator+=(Coefficient_traits::const_reference n) = 0;
  virtual Linear_Expression_Interface&
  operator-=(Coefficient_traits::const_reference n) = 0;

  //! The basic comparison function.
  /*! \relates Linear_Expression_Interface

    \returns -1 or -2 if x is less than y, 0 if they are equal and 1 or 2 is y
            is greater. The absolute value of the result is 1 if the difference
            is only in the inhomogeneous terms, 2 otherwise

    The order is a lexicographic. It starts comparing the variables'
    coefficient, starting from Variable(0), and at the end it compares
    the inhomogeneous terms.
  */
  virtual int compare(const Linear_Expression_Interface& y) const = 0;

  virtual Linear_Expression_Interface&
  operator+=(const Linear_Expression_Interface& e2) = 0;
  virtual Linear_Expression_Interface&
  operator+=(const Variable v) = 0;
  virtual Linear_Expression_Interface&
  operator-=(const Linear_Expression_Interface& e2) = 0;
  virtual Linear_Expression_Interface&
  operator-=(const Variable v) = 0;
  virtual Linear_Expression_Interface&
  operator*=(Coefficient_traits::const_reference n) = 0;
  virtual Linear_Expression_Interface&
  operator/=(Coefficient_traits::const_reference n) = 0;

  virtual void negate() = 0;

  virtual Linear_Expression_Interface&
  add_mul_assign(Coefficient_traits::const_reference n, const Variable v) = 0;

  virtual Linear_Expression_Interface&
  sub_mul_assign(Coefficient_traits::const_reference n, const Variable v) = 0;

  virtual void add_mul_assign(Coefficient_traits::const_reference factor,
                              const Linear_Expression_Interface& e2) = 0;

  virtual void sub_mul_assign(Coefficient_traits::const_reference factor,
                              const Linear_Expression_Interface& e2) = 0;

  virtual void print(std::ostream& s) const = 0;

  /*! \brief
    Returns <CODE>true</CODE> if the coefficient of each variable in
    \p vars[i] is \f$0\f$.
  */
  virtual bool all_zeroes(const Variables_Set& vars) const = 0;

  //! Returns true if there is a variable in [first,last) whose coefficient
  //! is nonzero in both *this and x.
  virtual bool have_a_common_variable(const Linear_Expression_Interface& x,
                                      Variable first, Variable last) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns the i-th coefficient.
  virtual Coefficient_traits::const_reference get(dimension_type i) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Sets the i-th coefficient to n.
  virtual void set(dimension_type i, Coefficient_traits::const_reference n) = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  /*! \brief
    Returns <CODE>true</CODE> if (*this)[i] is \f$0\f$, for each i in
    [start, end).
  */
  virtual bool all_zeroes(dimension_type start, dimension_type end) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  /*! \brief
    Returns the number of zero coefficient in [start, end).
  */
  virtual dimension_type
  num_zeroes(dimension_type start, dimension_type end) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  /*! \brief
    Returns the gcd of the nonzero coefficients in [start,end). If all the
    coefficients in this range are 0 returns 0.
  */
  virtual Coefficient gcd(dimension_type start, dimension_type end) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  virtual void exact_div_assign(Coefficient_traits::const_reference c,
                                dimension_type start, dimension_type end) = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Equivalent to <CODE>(*this)[i] *= n</CODE>, for each i in [start, end).
  virtual void mul_assign(Coefficient_traits::const_reference n,
                          dimension_type start, dimension_type end) = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Linearly combines \p *this with \p y so that the coefficient of \p v
  //! is 0.
  /*!
    \param y
    The expression that will be combined with \p *this object;

    \param i
    The index of the coefficient that has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the i-th coefficient equal to \f$0\f$. Then it assigns
    the resulting expression to \p *this.

    \p *this and \p y must have the same space dimension.
  */
  virtual void
  linear_combine(const Linear_Expression_Interface& y, dimension_type i) = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end).
  virtual void linear_combine(const Linear_Expression_Interface& y,
                              Coefficient_traits::const_reference c1,
                              Coefficient_traits::const_reference c2,
                              dimension_type start, dimension_type end) = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end). c1 and c2 may be zero.
  virtual void linear_combine_lax(const Linear_Expression_Interface& y,
                                  Coefficient_traits::const_reference c1,
                                  Coefficient_traits::const_reference c2,
                                  dimension_type start, dimension_type end) = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns the index of the last nonzero element, or 0 if there are no
  //! nonzero elements.
  virtual dimension_type last_nonzero() const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns the index of the last nonzero element in [first,last), or last
  //! if there are no nonzero elements.
  virtual dimension_type
  last_nonzero(dimension_type first, dimension_type last) const = 0;

  //! Returns the index of the first nonzero element, or \p last if there are no
  //! nonzero elements, considering only elements in [first,last).
  virtual dimension_type
  first_nonzero(dimension_type first, dimension_type last) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  /*! \brief
    Returns <CODE>true</CODE> if each coefficient in [start,end) is *not* in
    \f$0\f$, disregarding coefficients of variables in \p vars.
  */
  virtual bool
  all_zeroes_except(const Variables_Set& vars,
                    dimension_type start, dimension_type end) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Sets results to the sum of (*this)[i]*y[i], for each i in [start,end).
  virtual void
  scalar_product_assign(Coefficient& result,
                        const Linear_Expression_Interface& y,
                        dimension_type start, dimension_type end) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Computes the sign of the sum of (*this)[i]*y[i],
  //! for each i in [start,end).
  virtual int
  scalar_product_sign(const Linear_Expression_Interface& y,
                      dimension_type start, dimension_type end) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Removes from the set x all the indexes of nonzero elements of *this.
  virtual void
  has_a_free_dimension_helper(std::set<dimension_type>& x) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns \p true if (*this)[i] is equal to x[i], for each i in [start,end).
  virtual bool is_equal_to(const Linear_Expression_Interface& x,
                           dimension_type start, dimension_type end) const = 0;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns \p true if (*this)[i]*c1 is equal to x[i]*c2, for each i in
  //! [start,end).
  virtual bool is_equal_to(const Linear_Expression_Interface& x,
                           Coefficient_traits::const_reference c1,
                           Coefficient_traits::const_reference c2,
                           dimension_type start, dimension_type end) const = 0;

  // NOTE: This method is public, but it is not exposed in
  // Linear_Expression, so that it can be used internally in the PPL,
  // by friends of Linear_Expression.
  //! Sets \p r to a copy of the row that implements \p *this.
  virtual void get_row(Dense_Row& r) const = 0;

  // NOTE: This method is public, but it is not exposed in
  // Linear_Expression, so that it can be used internally in the PPL,
  // by friends of Linear_Expression.
  //! Sets \p r to a copy of the row that implements \p *this.
  virtual void get_row(Sparse_Row& r) const = 0;
};

/* Automatically generated from PPL source file ../src/Variables_Set_defs.hh line 1. */
/* Variables_Set class declaration.
*/


/* Automatically generated from PPL source file ../src/Variables_Set_defs.hh line 30. */
#include <iosfwd>
#include <set>

namespace Parma_Polyhedra_Library {

namespace IO_Operators {

//! Output operator.
/*! \relates Parma_Polyhedra_Library::Variables_Set */
std::ostream&
operator<<(std::ostream& s, const Variables_Set& vs);

} // namespace IO_Operators

} // namespace Parma_Polyhedra_Library

//! An std::set of variables' indexes.
class Parma_Polyhedra_Library::Variables_Set
  : public std::set<dimension_type> {
private:
  typedef std::set<dimension_type> Base;

public:
  //! Builds the empty set of variable indexes.
  Variables_Set();

  //! Builds the singleton set of indexes containing <CODE>v.id()</CODE>;
  explicit Variables_Set(const Variable v);

  /*! \brief
    Builds the set of variables's indexes in the range from
    <CODE>v.id()</CODE> to <CODE>w.id()</CODE>.

    If <CODE>v.id() <= w.id()</CODE>, this constructor builds the
    set of variables' indexes
    <CODE>v.id()</CODE>, <CODE>v.id()+1</CODE>, ..., <CODE>w.id()</CODE>.
    The empty set is built otherwise.
  */
  Variables_Set(const Variable v, const Variable w);

  //! Returns the maximum space dimension a Variables_Set can handle.
  static dimension_type max_space_dimension();

  /*! \brief
    Returns the dimension of the smallest vector space enclosing all
    the variables whose indexes are in the set.
  */
  dimension_type space_dimension() const;

  //! Inserts the index of variable \p v into the set.
  void insert(Variable v);

  // The `insert' method above overloads (instead of hiding) the
  // other `insert' method of std::set.
  using Base::insert;

  /*! \brief
    Loads from \p s an ASCII representation (as produced by
    ascii_dump(std::ostream&) const) and sets \p *this accordingly.
    Returns <CODE>true</CODE> if successful, <CODE>false</CODE> otherwise.
  */
  bool ascii_load(std::istream& s);

  //! Returns the total size in bytes of the memory occupied by \p *this.
  memory_size_type total_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  memory_size_type external_memory_in_bytes() const;

  //! Checks if all the invariants are satisfied.
  bool OK() const;

  PPL_OUTPUT_DECLARATIONS
};

/* Automatically generated from PPL source file ../src/Variables_Set_inlines.hh line 1. */
/* Variables_Set class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Variables_Set_inlines.hh line 28. */
#include <stdexcept>

namespace Parma_Polyhedra_Library {

inline
Variables_Set::Variables_Set()
  : Base() {
}

inline void
Variables_Set::insert(const Variable v) {
  insert(v.id());
}

inline
Variables_Set::Variables_Set(const Variable v)
  : Base() {
  insert(v);
}

inline dimension_type
Variables_Set::max_space_dimension() {
  return Variable::max_space_dimension();
}

inline dimension_type
Variables_Set::space_dimension() const {
  reverse_iterator i = rbegin();
  return (i == rend()) ? 0 : (*i + 1);
}

inline memory_size_type
Variables_Set::external_memory_in_bytes() const {
  // We assume sets are implemented by means of red-black trees that
  // require to store the color (we assume an enum) and three pointers
  // to the parent, left and right child, respectively.
  enum color { red, black };
  return size() * (sizeof(color) + 3*sizeof(void*) + sizeof(dimension_type));
}

inline memory_size_type
Variables_Set::total_memory_in_bytes() const {
  return sizeof(*this) + external_memory_in_bytes();
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Variables_Set_defs.hh line 106. */

/* Automatically generated from PPL source file ../src/Dense_Row_defs.hh line 1. */
/* Dense_Row class declaration.
*/


/* Automatically generated from PPL source file ../src/Dense_Row_defs.hh line 28. */

/* Automatically generated from PPL source file ../src/Dense_Row_defs.hh line 30. */

/* Automatically generated from PPL source file ../src/Dense_Row_defs.hh line 33. */
#include <memory>
#include <vector>
#include <limits>
#include <cstddef>

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! A finite sequence of coefficients.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
class Parma_Polyhedra_Library::Dense_Row {
public:
  class iterator;
  class const_iterator;

  //! Constructs an empty row.
  Dense_Row();

  explicit Dense_Row(const Sparse_Row& row);

  //! Tight constructor: resizing may require reallocation.
  /*!
    Constructs a row with size and capacity \p sz.
  */
  Dense_Row(dimension_type sz);

  //! Sizing constructor with capacity.
  /*!
    \param sz
    The size of the row that will be constructed;

    \param capacity
    The capacity of the row that will be constructed;

    The row that is constructed has storage for \p capacity elements,
    \p sz of which are default-constructed now.
  */
  Dense_Row(dimension_type sz, dimension_type capacity);

  //! Ordinary copy constructor.
  Dense_Row(const Dense_Row& y);

  //! Copy constructor with specified capacity.
  /*!
    It is assumed that \p capacity is greater than or equal to
    the size of \p y.
  */
  Dense_Row(const Dense_Row& y, dimension_type capacity);

  //! Copy constructor with specified size and capacity.
  /*!
    It is assumed that \p sz is less than or equal to \p capacity.
  */
  Dense_Row(const Dense_Row& y, dimension_type sz, dimension_type capacity);

  //! Copy constructor with specified size and capacity from a Sparse_Row.
  /*!
    It is assumed that \p sz is less than or equal to \p capacity.
  */
  Dense_Row(const Sparse_Row& y, dimension_type sz, dimension_type capacity);

  //! Destructor.
  ~Dense_Row();

  //! Assignment operator.
  Dense_Row& operator=(const Dense_Row& y);

  //! Assignment operator.
  Dense_Row& operator=(const Sparse_Row& y);

  //! Swaps \p *this with \p y.
  void m_swap(Dense_Row& y);

  //! Resizes the row to \p sz.
  void resize(dimension_type sz);

  //! Resizes the row to \p sz, with capacity \p capacity.
  void resize(dimension_type sz, dimension_type capacity);

  //! Resets all the elements of this row.
  void clear();

  //! Adds \p n zeroes before index \p i.
  /*!
    \param n
    The number of zeroes that will be added to the row.

    \param i
    The index of the element before which the zeroes will be added.

    Existing elements with index greater than or equal to \p i are shifted
    to the right by \p n positions. The size is increased by \p n.

    Existing iterators are invalidated.
  */
  void add_zeroes_and_shift(dimension_type n, dimension_type i);

  //! Expands the row to size \p new_size.
  /*!
    Adds new positions to the implementation of the row
    obtaining a new row with size \p new_size.
    It is assumed that \p new_size is between the current size
    and capacity of the row.
  */
  void expand_within_capacity(dimension_type new_size);

  //! Shrinks the row by erasing elements at the end.
  /*!
    Destroys elements of the row implementation
    from position \p new_size to the end.
    It is assumed that \p new_size is not greater than the current size.
  */
  void shrink(dimension_type new_size);

  //! Returns the size() of the largest possible Dense_Row.
  static dimension_type max_size();

  //! Gives the number of coefficients currently in use.
  dimension_type size() const;

  //! \name Subscript operators
  //@{
  //! Returns a reference to the element of the row indexed by \p k.
  Coefficient& operator[](dimension_type k);

  //! Returns a constant reference to the element of the row indexed by \p k.
  Coefficient_traits::const_reference operator[](dimension_type k) const;
  //@} // Subscript operators

  //! Normalizes the modulo of coefficients so that they are mutually prime.
  /*!
    Computes the Greatest Common Divisor (GCD) among the elements of
    the row and normalizes them by the GCD itself.
  */
  void normalize();

  //! Swaps the i-th element with the j-th element.
  //! Provided for compatibility with Sparse_Row
  void swap_coefficients(dimension_type i, dimension_type j);

  //! Swaps the element pointed to by i with the element pointed to by j.
  //! Provided for compatibility with Sparse_Row
  void swap_coefficients(iterator i, iterator j);

  iterator begin();
  const_iterator begin() const;

  iterator end();
  const_iterator end() const;

  //! Resets the i-th element to 0.
  //! Provided for compatibility with Sparse_Row
  void reset(dimension_type i);

  //! Resets the elements [first,last) to 0.
  //! Provided for compatibility with Sparse_Row
  void reset(dimension_type first, dimension_type last);

  //! Resets the element pointed to by itr to 0.
  //! Provided for compatibility with Sparse_Row.
  iterator reset(iterator itr);

  //! Gets the i-th element.
  //! Provided for compatibility with Sparse_Row.
  Coefficient_traits::const_reference get(dimension_type i) const;

  //! Provided for compatibility with Sparse_Row.
  iterator find(dimension_type i);

  //! Provided for compatibility with Sparse_Row.
  const_iterator find(dimension_type i) const;

  //! Provided for compatibility with Sparse_Row.
  iterator find(iterator itr, dimension_type i);

  //! Provided for compatibility with Sparse_Row.
  const_iterator find(const_iterator itr, dimension_type i) const;

  //! Provided for compatibility with Sparse_Row.
  iterator lower_bound(dimension_type i);

  //! Provided for compatibility with Sparse_Row.
  const_iterator lower_bound(dimension_type i) const;

  //! Provided for compatibility with Sparse_Row.
  iterator lower_bound(iterator itr, dimension_type i);

  //! Provided for compatibility with Sparse_Row.
  const_iterator lower_bound(const_iterator itr, dimension_type i) const;

  //! Provided for compatibility with Sparse_Row.
  iterator insert(dimension_type i, Coefficient_traits::const_reference x);

  //! Provided for compatibility with Sparse_Row.
  iterator insert(dimension_type i);

  //! Provided for compatibility with Sparse_Row.
  iterator insert(iterator itr, dimension_type i,
                       Coefficient_traits::const_reference x);

  //! Provided for compatibility with Sparse_Row.
  iterator insert(iterator itr, dimension_type i);

  //! Calls g(x[i],y[i]), for each i.
  /*!
    \param y
    The row that will be combined with *this.

    \param f
    A functor that should take a Coefficient&.
    f(c1) must be equivalent to g(c1, 0).

    \param g
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    g(c1, c2) must do nothing when c1 is zero.

    This method takes \f$O(n)\f$ time.

    \note
    The functors will only be called when necessary, assuming the requested
    properties hold.

    \see combine_needs_second
    \see combine
  */
  template <typename Func1, typename Func2>
  void combine_needs_first(const Dense_Row& y,
                           const Func1& f, const Func2& g);

  //! Calls g(x[i],y[i]), for each i.
  /*!
    \param y
    The row that will be combined with *this.

    \param g
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    g(c1, 0) must do nothing, for every c1.

    \param h
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    h(c1, c2) must be equivalent to g(c1, c2) when c1 is zero.

    This method takes \f$O(n)\f$ time.

    \note
    The functors will only be called when necessary, assuming the requested
    properties hold.

    \see combine_needs_first
    \see combine
  */
  template <typename Func1, typename Func2>
  void combine_needs_second(const Dense_Row& y,
                            const Func1& g, const Func2& h);

  //! Calls g(x[i],y[i]), for each i.
  /*!
    \param y
    The row that will be combined with *this.

    \param f
    A functor that should take a Coefficient&.
    f(c1) must be equivalent to g(c1, 0).

    \param g
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    g(c1, c2) must do nothing when both c1 and c2 are zero.

    \param h
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    h(c1, c2) must be equivalent to g(c1, c2) when c1 is zero.

    This method takes \f$O(n)\f$ time.

    \note
    The functors will only be called when necessary, assuming the requested
    properties hold.

    \see combine_needs_first
    \see combine_needs_second
  */
  template <typename Func1, typename Func2, typename Func3>
  void combine(const Dense_Row& y,
               const Func1& f, const Func2& g, const Func3& h);

  //! Executes <CODE>(*this)[i] = (*this)[i]*coeff1 + y[i]*coeff2</CODE>, for
  //! each i.
  /*!
    \param y
    The row that will be combined with *this.

    \param coeff1
    The coefficient used for elements of *this.
    It must not be 0.

    \param coeff2
    The coefficient used for elements of y.
    It must not be 0.

    This method takes \f$O(n)\f$ time.

    \see combine_needs_first
    \see combine_needs_second
    \see combine
  */
  void linear_combine(const Dense_Row& y,
                      Coefficient_traits::const_reference coeff1,
                      Coefficient_traits::const_reference coeff2);

  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end).
  /*!
    This method detects when coeff1==1 and/or coeff2==1 or coeff2==-1 in
    order to save some work.

    coeff1 and coeff2 must not be 0.
  */
  void linear_combine(const Dense_Row& y,
                      Coefficient_traits::const_reference c1,
                      Coefficient_traits::const_reference c2,
                      dimension_type start, dimension_type end);

  PPL_OUTPUT_DECLARATIONS

  /*! \brief
    Loads from \p s an ASCII representation (as produced by
    ascii_dump(std::ostream&) const) and sets \p *this accordingly.
    Returns <CODE>true</CODE> if successful, <CODE>false</CODE> otherwise.
  */
  bool ascii_load(std::istream& s);

  /*! \brief
    Returns a lower bound to the total size in bytes of the memory
    occupied by \p *this.
  */
  memory_size_type total_memory_in_bytes() const;

  /*! \brief
    Returns a lower bound to the size in bytes of the memory
    managed by \p *this.
  */
  memory_size_type external_memory_in_bytes() const;

  /*! \brief
    Returns the total size in bytes of the memory occupied by \p *this,
    provided the capacity of \p *this is given by \p capacity.
  */
  memory_size_type total_memory_in_bytes(dimension_type capacity) const;

  /*! \brief
    Returns the size in bytes of the memory managed by \p *this,
    provided the capacity of \p *this is given by \p capacity.
  */
  memory_size_type external_memory_in_bytes(dimension_type capacity) const;

  //! Checks if all the invariants are satisfied.
  bool OK() const;

  /*! \brief
    Checks if all the invariants are satisfied and that the actual
    size matches the value provided as argument.
  */
  bool OK(dimension_type row_size) const;

private:
  void init(const Sparse_Row& row);

  void destroy();

  struct Impl {

    Impl();

    ~Impl();

    //! The number of coefficients in the row.
    dimension_type size;

    //! The capacity of the row.
    dimension_type capacity;

    //! The allocator used to allocate/deallocate vec.
    std::allocator<Coefficient> coeff_allocator;

    //! The vector of coefficients.
    //! An empty vector may be stored as NULL instead of using a valid pointer.
    Coefficient* vec;
  };

  Impl impl;

  //! Returns the capacity of the row.
  dimension_type capacity() const;
};

class Parma_Polyhedra_Library::Dense_Row::iterator {
public:

  typedef std::bidirectional_iterator_tag iterator_category;
  typedef Coefficient value_type;
  typedef std::ptrdiff_t difference_type;
  typedef value_type* pointer;
  typedef value_type& reference;

  iterator();
  iterator(Dense_Row& r, dimension_type i);

  Coefficient& operator*();
  Coefficient_traits::const_reference operator*() const;

  //! Returns the index of the element pointed to by \c *this.
  /*!
    If itr is a valid iterator for row, <CODE>row[itr.index()]</CODE> is
    equivalent to *itr.

    \returns the index of the element pointed to by \c *this.
  */
  dimension_type index() const;

  iterator& operator++();
  iterator operator++(int);

  iterator& operator--();
  iterator operator--(int);

  bool operator==(const iterator& x) const;
  bool operator!=(const iterator& x) const;

  operator const_iterator() const;

  bool OK() const;

private:
  Dense_Row* row;
  dimension_type idx;
};

class Parma_Polyhedra_Library::Dense_Row::const_iterator {
public:

  typedef const Coefficient value_type;
  typedef std::ptrdiff_t difference_type;
  typedef value_type* pointer;
  typedef Coefficient_traits::const_reference reference;

  const_iterator();
  const_iterator(const Dense_Row& r, dimension_type i);

  Coefficient_traits::const_reference operator*() const;

  //! Returns the index of the element pointed to by \c *this.
  /*!
    If itr is a valid iterator for row, <CODE>row[itr.index()]</CODE> is
    equivalent to *itr.

    \returns the index of the element pointed to by \c *this.
  */
  dimension_type index() const;

  const_iterator& operator++();
  const_iterator operator++(int);

  const_iterator& operator--();
  const_iterator operator--(int);

  bool operator==(const const_iterator& x) const;
  bool operator!=(const const_iterator& x) const;

  bool OK() const;

private:
  const Dense_Row* row;
  dimension_type idx;
};


namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Swaps \p x with \p y.
/*! \relates Dense_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void swap(Dense_Row& x, Dense_Row& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Swaps objects referred by \p x and \p y.
/*! \relates Dense_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void iter_swap(std::vector<Dense_Row>::iterator x,
               std::vector<Dense_Row>::iterator y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns <CODE>true</CODE> if and only if \p x and \p y are equal.
/*! \relates Dense_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
bool operator==(const Dense_Row& x, const Dense_Row& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns <CODE>true</CODE> if and only if \p x and \p y are different.
/*! \relates Dense_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
bool operator!=(const Dense_Row& x, const Dense_Row& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \relates Dense_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void linear_combine(Dense_Row& x, const Dense_Row& y,
                    Coefficient_traits::const_reference coeff1,
                    Coefficient_traits::const_reference coeff2);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Equivalent to <CODE>x[i] = x[i] * c1 + y[i] * c2</CODE>,
//! for each i in [start, end).
/*! \relates Dense_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void linear_combine(Dense_Row& x, const Dense_Row& y,
                    Coefficient_traits::const_reference c1,
                    Coefficient_traits::const_reference c2,
                    dimension_type start, dimension_type end);

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Dense_Row_inlines.hh line 1. */
/* Dense_Row class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Dense_Row_inlines.hh line 28. */
#include <cstddef>
#include <limits>
#include <algorithm>

namespace Parma_Polyhedra_Library {

inline
Dense_Row::Impl::Impl()
  : size(0), capacity(0), coeff_allocator(), vec(0) {
}

inline
Dense_Row::Impl::~Impl() {
  while (size != 0) {
    --size;
    vec[size].~Coefficient();
  }
  coeff_allocator.deallocate(vec, capacity);
}

inline dimension_type
Dense_Row::max_size() {
  return std::numeric_limits<size_t>::max() / sizeof(Coefficient);
}

inline dimension_type
Dense_Row::size() const {
  return impl.size;
}

inline dimension_type
Dense_Row::capacity() const {
  return impl.capacity;
}

inline
Dense_Row::Dense_Row()
  : impl() {

  PPL_ASSERT(OK());
}

inline
Dense_Row::Dense_Row(const dimension_type sz,
                     const dimension_type capacity)
  : impl() {

  resize(sz, capacity);

  PPL_ASSERT(size() == sz);
  PPL_ASSERT(impl.capacity == capacity);
  PPL_ASSERT(OK());
}

inline
Dense_Row::Dense_Row(const dimension_type sz)
  : impl() {

  resize(sz);

  PPL_ASSERT(size() == sz);
  PPL_ASSERT(OK());
}

inline
Dense_Row::Dense_Row(const Dense_Row& y)
  : impl() {
  impl.coeff_allocator = y.impl.coeff_allocator;
  if (y.impl.vec != 0) {
    impl.capacity = y.capacity();
    impl.vec = impl.coeff_allocator.allocate(impl.capacity);
    while (impl.size != y.size()) {
      new(&impl.vec[impl.size]) Coefficient(y[impl.size]);
      ++impl.size;
    }
  }
  PPL_ASSERT(size() == y.size());
  PPL_ASSERT(capacity() == y.capacity());
  PPL_ASSERT(OK());
}

inline
Dense_Row::Dense_Row(const Dense_Row& y,
                     const dimension_type capacity)
  : impl() {
  PPL_ASSERT(y.size() <= capacity);
  PPL_ASSERT(capacity <= max_size());

  impl.capacity = capacity;
  impl.coeff_allocator = y.impl.coeff_allocator;
  impl.vec = impl.coeff_allocator.allocate(impl.capacity);

  if (y.impl.vec != 0) {
    while (impl.size != y.size()) {
      new(&impl.vec[impl.size]) Coefficient(y[impl.size]);
      ++impl.size;
    }
  }

  PPL_ASSERT(size() == y.size());
  PPL_ASSERT(impl.capacity == capacity);
  PPL_ASSERT(OK());
}

inline
Dense_Row::Dense_Row(const Dense_Row& y,
                     const dimension_type sz,
                     const dimension_type capacity)
  : impl() {
  PPL_ASSERT(sz <= capacity);
  PPL_ASSERT(capacity <= max_size());
  PPL_ASSERT(capacity != 0);

  impl.capacity = capacity;
  impl.coeff_allocator = y.impl.coeff_allocator;
  impl.vec = impl.coeff_allocator.allocate(impl.capacity);

  const dimension_type n = std::min(sz, y.size());
  while (impl.size != n) {
    new(&impl.vec[impl.size]) Coefficient(y[impl.size]);
    ++impl.size;
  }
  while (impl.size != sz) {
    new(&impl.vec[impl.size]) Coefficient();
    ++impl.size;
  }

  PPL_ASSERT(size() == sz);
  PPL_ASSERT(impl.capacity == capacity);
  PPL_ASSERT(OK());
}

inline
Dense_Row::~Dense_Row() {
  // The `impl' field will be destroyed automatically.
}

inline void
Dense_Row::destroy() {
  resize(0);
  impl.coeff_allocator.deallocate(impl.vec, impl.capacity);
}

inline void
Dense_Row::m_swap(Dense_Row& y) {
  using std::swap;
  swap(impl.size, y.impl.size);
  swap(impl.capacity, y.impl.capacity);
  swap(impl.coeff_allocator, y.impl.coeff_allocator);
  swap(impl.vec, y.impl.vec);
  PPL_ASSERT(OK());
  PPL_ASSERT(y.OK());
}

inline Dense_Row&
Dense_Row::operator=(const Dense_Row& y) {

  if (this != &y && size() == y.size()) {
    // Avoid reallocation.

    for (dimension_type i = size(); i-- > 0; ) {
      (*this)[i] = y[i];
    }

    return *this;
  }

  Dense_Row x(y);
  swap(*this, x);

  return *this;
}

inline Coefficient&
Dense_Row::operator[](const dimension_type k) {
  PPL_ASSERT(impl.vec != 0);
  PPL_ASSERT(k < size());
  return impl.vec[k];
}

inline Coefficient_traits::const_reference
Dense_Row::operator[](const dimension_type k) const {
  PPL_ASSERT(impl.vec != 0);
  PPL_ASSERT(k < size());
  return impl.vec[k];
}

inline void
Dense_Row::swap_coefficients(dimension_type i, dimension_type j) {
  std::swap((*this)[i], (*this)[j]);
}

inline void
Dense_Row::swap_coefficients(iterator i, iterator j) {
  std::swap(*i, *j);
}

inline void
Dense_Row::reset(dimension_type i) {
  (*this)[i] = 0;
}

inline Dense_Row::iterator
Dense_Row::reset(iterator itr) {
  *itr = 0;
  ++itr;
  return itr;
}

inline Dense_Row::iterator
Dense_Row::begin() {
  return iterator(*this, 0);
}

inline Dense_Row::const_iterator
Dense_Row::begin() const {
  return const_iterator(*this, 0);
}

inline Dense_Row::iterator
Dense_Row::end() {
  return iterator(*this, size());
}

inline Dense_Row::const_iterator
Dense_Row::end() const {
  return const_iterator(*this, size());
}

inline Coefficient_traits::const_reference
Dense_Row::get(dimension_type i) const {
  return (*this)[i];
}

inline Dense_Row::iterator
Dense_Row::find(dimension_type i) {
  return iterator(*this, i);
}

inline Dense_Row::const_iterator
Dense_Row::find(dimension_type i) const {
  return const_iterator(*this, i);
}

inline Dense_Row::iterator
Dense_Row::find(iterator itr, dimension_type i) {
  (void)itr;
  return iterator(*this, i);
}

inline Dense_Row::const_iterator
Dense_Row::find(const_iterator itr, dimension_type i) const {
  (void)itr;
  return const_iterator(*this, i);
}

inline Dense_Row::iterator
Dense_Row::lower_bound(dimension_type i) {
  return find(i);
}

inline Dense_Row::const_iterator
Dense_Row::lower_bound(dimension_type i) const {
  return find(i);
}

inline Dense_Row::iterator
Dense_Row::lower_bound(iterator itr, dimension_type i) {
  return find(itr, i);
}

inline Dense_Row::const_iterator
Dense_Row::lower_bound(const_iterator itr, dimension_type i) const {
  return find(itr, i);
}

inline Dense_Row::iterator
Dense_Row::insert(dimension_type i,
                  Coefficient_traits::const_reference x) {
  (*this)[i] = x;
  return find(i);
}

inline Dense_Row::iterator
Dense_Row::insert(dimension_type i) {
  return find(i);
}

inline Dense_Row::iterator
Dense_Row::insert(iterator itr, dimension_type i,
                  Coefficient_traits::const_reference x) {
  (void)itr;
  (*this)[i] = x;
  return find(i);
}

inline Dense_Row::iterator
Dense_Row::insert(iterator itr, dimension_type i) {
  (void)itr;
  return find(i);
}

inline memory_size_type
Dense_Row::total_memory_in_bytes() const {
  return sizeof(*this) + external_memory_in_bytes();
}

inline memory_size_type
Dense_Row::total_memory_in_bytes(dimension_type capacity) const {
  return sizeof(*this) + external_memory_in_bytes(capacity);
}

/*! \relates Dense_Row */
inline bool
operator!=(const Dense_Row& x, const Dense_Row& y) {
  return !(x == y);
}


inline
Dense_Row::iterator::iterator()
  : row(NULL), idx(0) {
  PPL_ASSERT(OK());
}

inline
Dense_Row::iterator::iterator(Dense_Row& r, dimension_type i)
  : row(&r), idx(i) {
  PPL_ASSERT(OK());
}

inline Coefficient&
Dense_Row::iterator::operator*() {
  PPL_ASSERT(idx < row->size());
  return (*row)[idx];
}

inline Coefficient_traits::const_reference
Dense_Row::iterator::operator*() const {
  PPL_ASSERT(idx < row->size());
  return (*row)[idx];
}

inline dimension_type
Dense_Row::iterator::index() const {
  return idx;
}

inline Dense_Row::iterator&
Dense_Row::iterator::operator++() {
  PPL_ASSERT(idx < row->size());
  ++idx;
  PPL_ASSERT(OK());
  return *this;
}

inline Dense_Row::iterator
Dense_Row::iterator::operator++(int) {
  iterator tmp(*this);
  ++(*this);
  return tmp;
}

inline Dense_Row::iterator&
Dense_Row::iterator::operator--() {
  PPL_ASSERT(idx > 0);
  --idx;
  PPL_ASSERT(OK());
  return *this;
}

inline Dense_Row::iterator
Dense_Row::iterator::operator--(int) {
  iterator tmp(*this);
  --(*this);
  return tmp;
}

inline bool
Dense_Row::iterator::operator==(const iterator& x) const {
  return (row == x.row) && (idx == x.idx);
}

inline bool
Dense_Row::iterator::operator!=(const iterator& x) const {
  return !(*this == x);
}

inline
Dense_Row::iterator::operator const_iterator() const {
  return const_iterator(*row, idx);
}

inline bool
Dense_Row::iterator::OK() const {
  if (row == NULL) {
    return true;
  }
  // i can be equal to row.size() for past-the-end iterators
  return (idx <= row->size());
}


inline
Dense_Row::const_iterator::const_iterator()
  : row(NULL), idx(0) {
  PPL_ASSERT(OK());
}

inline
Dense_Row::const_iterator::const_iterator(const Dense_Row& r,
                                          dimension_type i)
  : row(&r), idx(i) {
  PPL_ASSERT(OK());
}

inline Coefficient_traits::const_reference
Dense_Row::const_iterator::operator*() const {
  PPL_ASSERT(idx < row->size());
  return (*row)[idx];
}

inline dimension_type
Dense_Row::const_iterator::index() const {
  return idx;
}

inline Dense_Row::const_iterator&
Dense_Row::const_iterator::operator++() {
  PPL_ASSERT(idx < row->size());
  ++idx;
  PPL_ASSERT(OK());
  return *this;
}

inline Dense_Row::const_iterator
Dense_Row::const_iterator::operator++(int) {
  const_iterator tmp(*this);
  ++(*this);
  return tmp;
}

inline Dense_Row::const_iterator&
Dense_Row::const_iterator::operator--() {
  PPL_ASSERT(idx > 0);
  --idx;
  PPL_ASSERT(OK());
  return *this;
}

inline Dense_Row::const_iterator
Dense_Row::const_iterator::operator--(int) {
  const_iterator tmp(*this);
  --(*this);
  return tmp;
}

inline bool
Dense_Row::const_iterator::operator==(const const_iterator& x) const {
  return (row == x.row) && (idx == x.idx);
}

inline bool
Dense_Row::const_iterator::operator!=(const const_iterator& x) const {
  return !(*this == x);
}

inline bool
Dense_Row::const_iterator::OK() const {
  if (row == NULL) {
    return true;
  }
  // i can be equal to row.size() for past-the-end iterators
  return (idx <= row->size());
}

inline void
linear_combine(Dense_Row& x, const Dense_Row& y,
               Coefficient_traits::const_reference coeff1,
               Coefficient_traits::const_reference coeff2) {
  x.linear_combine(y, coeff1, coeff2);
}

inline void
linear_combine(Dense_Row& x, const Dense_Row& y,
               Coefficient_traits::const_reference c1,
               Coefficient_traits::const_reference c2,
               dimension_type start, dimension_type end) {
  x.linear_combine(y, c1, c2, start, end);
}

/*! \relates Dense_Row */
inline void
swap(Dense_Row& x, Dense_Row& y) {
  x.m_swap(y);
}

/*! \relates Dense_Row */
inline void
iter_swap(std::vector<Dense_Row>::iterator x,
          std::vector<Dense_Row>::iterator y) {
  swap(*x, *y);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Dense_Row_templates.hh line 1. */
/* Dense_Row class implementation: non-inline template functions.
*/


namespace Parma_Polyhedra_Library {


template <typename Func1, typename Func2>
void
Dense_Row::combine_needs_first(const Dense_Row& y, const Func1& /* f */,
                               const Func2& g) {
  for (dimension_type i = size(); i-- > 0; ) {
    g((*this)[i], y[i]);
  }
}

template <typename Func1, typename Func2>
void
Dense_Row::combine_needs_second(const Dense_Row& y, const Func1& g,
                                const Func2& /* h */) {
  for (dimension_type i = size(); i-- > 0; ) {
    g((*this)[i], y[i]);
  }
}

template <typename Func1, typename Func2, typename Func3>
void
Dense_Row::combine(const Dense_Row& y, const Func1& /* f */, const Func2& g,
                   const Func3& /* h */) {
  for (dimension_type i = size(); i-- > 0; ) {
    g((*this)[i], y[i]);
  }
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Dense_Row_defs.hh line 561. */

/* Automatically generated from PPL source file ../src/Sparse_Row_defs.hh line 1. */
/* Sparse_Row class declaration.
*/


/* Automatically generated from PPL source file ../src/Sparse_Row_defs.hh line 28. */

/* Automatically generated from PPL source file ../src/CO_Tree_defs.hh line 1. */
/* CO_Tree class declaration.
*/


/* Automatically generated from PPL source file ../src/CO_Tree_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class CO_Tree;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/CO_Tree_defs.hh line 28. */

/* Automatically generated from PPL source file ../src/CO_Tree_defs.hh line 30. */
#include <memory>
#include <cstddef>

#ifndef PPL_CO_TREE_EXTRA_DEBUG
#ifdef PPL_ABI_BREAKING_EXTRA_DEBUG
#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*!
  \brief
  Enables extra debugging information for class CO_Tree.

  \ingroup PPL_CXX_interface
  When <CODE>PPL_CO_TREE_EXTRA_DEBUG</CODE> evaluates to <CODE>true</CODE>,
  each CO_Tree iterator and const_iterator carries a pointer to the associated
  tree; this enables extra consistency checks to be performed.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
#define PPL_CO_TREE_EXTRA_DEBUG 1
#else // !defined(PPL_ABI_BREAKING_EXTRA_DEBUG)
#define PPL_CO_TREE_EXTRA_DEBUG 0
#endif // !defined(PPL_ABI_BREAKING_EXTRA_DEBUG)
#endif // !defined(PPL_CO_TREE_EXTRA_DEBUG)


namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! A cache-oblivious binary search tree of pairs.
/*! \ingroup PPL_CXX_interface
  This class implements a binary search tree with keys of dimension_type type
  and data of Coefficient type, laid out in a dynamically-sized array.

  The array-based layout saves calls to new/delete (to insert \f$n\f$ elements
  only \f$O(\log n)\f$ allocations are performed) and, more importantly, is
  much more cache-friendly than a standard (pointer-based) tree, because the
  elements are stored sequentially in memory (leaving some holes to allow
  fast insertion of new elements).
  The downside of this representation is that all iterators are invalidated
  when an element is added or removed, because the array could have been
  enlarged or shrunk. This is partially addressed by providing references to
  internal end iterators that are updated when needed.

  B-trees are cache-friendly too, but the cache size is fixed (usually at
  compile-time). This raises two problems: firstly the cache size must be
  known in advance and those data structures do not perform well with other
  cache sizes and, secondly, even if the cache size is known, the
  optimizations target only one level of cache. This kind of data structures
  are called cache aware. This implementation, instead, is cache oblivious:
  it performs well with every cache size, and thus exploits all of the
  available caches.

  Assuming \p n is the number of elements in the tree and \p B is the number
  of (dimension_type, Coefficient) pairs that fit in a cache line, the
  time and cache misses complexities are the following:

  - Insertions/Queries/Deletions: \f$O(\log^2 n)\f$ time,
                                  \f$O(\log \frac{n}{B}))\f$ cache misses.
  - Tree traversal from begin() to end(), using an %iterator: \f$O(n)\f$ time,
         \f$O(\frac{n}{B})\f$  cache misses.
  - Queries with a hint: \f$O(\log k)\f$ time and \f$O(\log \frac{k}{B})\f$
    cache misses, where k is the distance between the given %iterator and the
    searched element (or the position where it would have been).

  The binary search tree is embedded in a (slightly bigger) complete tree,
  that is enlarged and shrunk when needed. The complete tree is laid out
  in an in-order DFS layout in two arrays: one for the keys and one for the
  associated data.
  The indexes and values are stored in different arrays to reduce
  cache-misses during key queries.

  The tree can store up to \f$(-(dimension_type)1)/100\f$ elements.
  This limit allows faster density computations, but can be removed if needed.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
class CO_Tree {

public:
  class const_iterator;
  class iterator;

private:
  //! This is used for node heights and depths in the tree.
  typedef unsigned height_t;

  PPL_COMPILE_TIME_CHECK(C_Integer<height_t>::max
                         >= sizeof_to_bits(sizeof(dimension_type)),
                         "height_t is too small to store depths.");

  class tree_iterator;

  // This must be declared here, because it is a friend of const_iterator.
  //! Returns the index of the current element in the DFS layout of the
  //! complete tree.
  /*!
    \return the index of the current element in the DFS layout of the complete
            tree.

    \param itr the iterator that points to the desired element.
  */
  dimension_type dfs_index(const_iterator itr) const;

  // This must be declared here, because it is a friend of iterator.
  //! Returns the index of the current element in the DFS layout of the
  //! complete tree.
  /*!
    \return the index of the current element in the DFS layout of the complete
            tree.

    \param itr the iterator that points to the desired element.
  */
  dimension_type dfs_index(iterator itr) const;

public:

  //! The type of the data elements associated with keys.
  /*!
    If this is changed, occurrences of Coefficient_zero() in the CO_Tree
    implementation have to be replaced with constants of the correct type.
  */
  typedef Coefficient data_type;
  typedef Coefficient_traits::const_reference data_type_const_reference;

  //! A const %iterator on the tree elements, ordered by key.
  /*!
    Iterator increment and decrement operations are \f$O(1)\f$ time.
    These iterators are invalidated by operations that add or remove elements
    from the tree.
  */
  class const_iterator {
  private:
  public:

    typedef std::bidirectional_iterator_tag iterator_category;
    typedef const data_type value_type;
    typedef std::ptrdiff_t difference_type;
    typedef value_type* pointer;
    typedef data_type_const_reference reference;

    //! Constructs an invalid const_iterator.
    /*!
      This constructor takes \f$O(1)\f$ time.
    */
    explicit const_iterator();

    //! Constructs an %iterator pointing to the first element of the tree.
    /*!
      \param tree
      The tree that the new %iterator will point to.

      This constructor takes \f$O(1)\f$ time.
    */
    explicit const_iterator(const CO_Tree& tree);

    //! Constructs a const_iterator pointing to the i-th node of the tree.
    /*!
      \param tree
      The tree that the new %iterator will point to.

      \param i
      The index of the element in \p tree to which the %iterator will point
      to.

      The i-th node must be a node with a value or end().

      This constructor takes \f$O(1)\f$ time.
    */
    const_iterator(const CO_Tree& tree, dimension_type i);

    //! The copy constructor.
    /*!
      \param itr
      The %iterator that will be copied.

      This constructor takes \f$O(1)\f$ time.
    */
    const_iterator(const const_iterator& itr);

    //! Converts an iterator into a const_iterator.
    /*!
      \param itr
      The iterator that will be converted into a const_iterator.

      This constructor takes \f$O(1)\f$ time.
    */
    const_iterator(const iterator& itr);

    //! Swaps itr with *this.
    /*!
      \param itr
      The %iterator that will be swapped with *this.

      This method takes \f$O(1)\f$ time.
    */
    void m_swap(const_iterator& itr);

    //! Assigns \p itr to *this .
    /*!
      \param itr
      The %iterator that will be assigned into *this.

      This method takes \f$O(1)\f$ time.
    */
    const_iterator& operator=(const const_iterator& itr);

    //! Assigns \p itr to *this .
    /*!
      \param itr
      The %iterator that will be assigned into *this.

      This method takes \f$O(1)\f$ time.
    */
    const_iterator& operator=(const iterator& itr);

    //! Navigates to the next element.
    /*!
      This method takes \f$O(1)\f$ time.
    */
    const_iterator& operator++();

    //! Navigates to the previous element.
    /*!
      This method takes \f$O(1)\f$ time.
    */
    const_iterator& operator--();

    //! Navigates to the next element.
    /*!
      This method takes \f$O(1)\f$ time.
    */
    const_iterator operator++(int);

    //! Navigates to the previous element.
    /*!
      This method takes \f$O(1)\f$ time.
    */
    const_iterator operator--(int);

    //! Returns the current element.
    data_type_const_reference operator*() const;

    //! Returns the index of the element pointed to by \c *this.
    /*!
      \returns the index of the element pointed to by \c *this.
    */
    dimension_type index() const;

    //! Compares \p *this with x .
    /*!
      \param x
      The %iterator that will be compared with *this.
    */
    bool operator==(const const_iterator& x) const;

    //! Compares \p *this with x .
    /*!
      \param x
      The %iterator that will be compared with *this.
    */
    bool operator!=(const const_iterator& x) const;

  private:
    //! Checks the internal invariants, in debug mode only.
    bool OK() const;

    //! A pointer to the corresponding element of the tree's indexes[] array.
    const dimension_type* current_index;

    //! A pointer to the corresponding element of the tree's data[] array.
    const data_type* current_data;

#if PPL_CO_TREE_EXTRA_DEBUG
    //! A pointer to the corresponding tree, used for debug purposes only.
    const CO_Tree* tree;
#endif

    friend dimension_type CO_Tree::dfs_index(const_iterator itr) const;
  };

  //! An %iterator on the tree elements, ordered by key.
  /*!
    Iterator increment and decrement operations are \f$O(1)\f$ time.
    These iterators are invalidated by operations that add or remove elements
    from the tree.
  */
  class iterator {
  public:

    typedef std::bidirectional_iterator_tag iterator_category;
    typedef data_type value_type;
    typedef std::ptrdiff_t difference_type;
    typedef value_type* pointer;
    typedef value_type& reference;

    //! Constructs an invalid iterator.
    /*!
      This constructor takes \f$O(1)\f$ time.
    */
    iterator();

    //! Constructs an %iterator pointing to first element of the tree.
    /*!
      \param tree
      The tree to which the new %iterator will point to.

      This constructor takes \f$O(1)\f$ time.
    */
    explicit iterator(CO_Tree& tree);

    //! Constructs an %iterator pointing to the i-th node.
    /*!
      \param tree
      The tree to which the new %iterator will point to.

      \param i
      The index of the element in \p tree to which the new %iterator will
      point to.

      The i-th node must be a node with a value or end().

      This constructor takes \f$O(1)\f$ time.
    */
    iterator(CO_Tree& tree, dimension_type i);

    //! The constructor from a tree_iterator.
    /*!
      \param itr
      The tree_iterator that will be converted into an iterator.

      This is meant for use by CO_Tree only.
      This is not private to avoid the friend declaration.

      This constructor takes \f$O(1)\f$ time.
    */
    explicit iterator(const tree_iterator& itr);

    //! The copy constructor.
    /*!
      \param itr
      The %iterator that will be copied.

      This constructor takes \f$O(1)\f$ time.
    */
    iterator(const iterator& itr);

    //! Swaps itr with *this.
    /*!
      \param itr
      The %iterator that will be swapped with *this.

      This method takes \f$O(1)\f$ time.
    */
    void m_swap(iterator& itr);

    //! Assigns \p itr to *this .
    /*!
      \param itr
      The %iterator that will be assigned into *this.

      This method takes \f$O(1)\f$ time.
    */
    iterator& operator=(const iterator& itr);

    //! Assigns \p itr to *this .
    /*!
      \param itr
      The %iterator that will be assigned into *this.

      This method takes \f$O(1)\f$ time.
    */
    iterator& operator=(const tree_iterator& itr);

    //! Navigates to the next element in the tree.
    /*!
      This method takes \f$O(1)\f$ time.
    */
    iterator& operator++();

    //! Navigates to the previous element in the tree.
    /*!
      This method takes \f$O(1)\f$ time.
    */
    iterator& operator--();

    //! Navigates to the next element in the tree.
    /*!
      This method takes \f$O(1)\f$ time.
    */
    iterator operator++(int);

    //! Navigates to the previous element in the tree.
    /*!
      This method takes \f$O(1)\f$ time.
    */
    iterator operator--(int);

    //! Returns the current element.
    data_type& operator*();

    //! Returns the current element.
    data_type_const_reference operator*() const;

    //! Returns the index of the element pointed to by \c *this.
    /*!
      \returns the index of the element pointed to by \c *this.
    */
    dimension_type index() const;

    //! Compares \p *this with x .
    /*!
      \param x
      The %iterator that will be compared with *this.
    */
    bool operator==(const iterator& x) const;

    //! Compares \p *this with x .
    /*!
      \param x
      The %iterator that will be compared with *this.
    */
    bool operator!=(const iterator& x) const;

  private:
    //! Checks the internal invariants, in debug mode only.
    bool OK() const;

    //! A pointer to the corresponding element of the tree's indexes[] array.
    const dimension_type* current_index;

    //! A pointer to the corresponding element of the tree's data[] array.
    data_type* current_data;

#if PPL_CO_TREE_EXTRA_DEBUG
    //! A pointer to the corresponding tree, used for debug purposes only.
    CO_Tree* tree;
#endif

    friend const_iterator& const_iterator::operator=(const iterator&);
    friend dimension_type CO_Tree::dfs_index(iterator itr) const;
  };

  //! Constructs an empty tree.
  /*!
    This constructor takes \f$O(1)\f$ time.
  */
  CO_Tree();

  //! The copy constructor.
  /*!
    \param y
    The tree that will be copied.

    This constructor takes \f$O(n)\f$ time.
  */
  CO_Tree(const CO_Tree& y);

  //! A constructor from a sequence of \p n elements.
  /*!
    \param i
    An iterator that points to the first element of the sequence.

    \param n
    The number of elements in the [i, i_end) sequence.

    i must be an input iterator on a sequence of data_type elements,
    sorted by index.
    Objects of Iterator type must have an index() method that returns the
    index with which the element pointed to by the iterator must be inserted.

    This constructor takes \f$O(n)\f$ time, so it is more efficient than
    the construction of an empty tree followed by n insertions, that would
    take \f$O(n*\log^2 n)\f$ time.
  */
  template <typename Iterator>
  CO_Tree(Iterator i, dimension_type n);

  //! The assignment operator.
  /*!
    \param y
    The tree that will be assigned to *this.

    This method takes \f$O(n)\f$ time.
  */
  CO_Tree& operator=(const CO_Tree& y);

  //! Removes all elements from the tree.
  /*!
    This method takes \f$O(n)\f$ time.
  */
  void clear();

  //! The destructor.
  /*!
    This destructor takes \f$O(n)\f$ time.
  */
  ~CO_Tree();

  //! Returns \p true if the tree has no elements.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  bool empty() const;

  //! Returns the number of elements stored in the tree.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  dimension_type size() const;

  //! Returns the size() of the largest possible CO_Tree.
  static dimension_type max_size();

  //! Dumps the tree to stdout, for debugging purposes.
  void dump_tree() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  /*!
    This method takes \f$O(n)\f$ time.
  */
  dimension_type external_memory_in_bytes() const;

  //! Inserts an element in the tree.
  /*!
    \returns
    An %iterator that points to the inserted pair.

    \param key
    The key that will be inserted into the tree, associated with the default
    data.

    If such a pair already exists, an %iterator pointing to that pair is
    returned.

    This operation invalidates existing iterators.

    This method takes \f$O(\log n)\f$ time if the element already exists, and
    \f$O(\log^2 n)\f$ amortized time otherwise.
  */
  iterator insert(dimension_type key);

  //! Inserts an element in the tree.
  /*!
    \returns
    An %iterator that points to the inserted element.

    \param key
    The key that will be inserted into the tree..

    \param data
    The data that will be inserted into the tree.

    If an element with the specified key already exists, its associated data
    is set to \p data and an %iterator pointing to that pair is returned.

    This operation invalidates existing iterators.

    This method takes \f$O(\log n)\f$ time if the element already exists, and
    \f$O(\log^2 n)\f$ amortized time otherwise.amortized
  */
  iterator insert(dimension_type key, data_type_const_reference data);

  //! Inserts an element in the tree.
  /*!
    \return
    An %iterator that points to the inserted element.

    \param itr
    The %iterator used as hint

    \param key
    The key that will be inserted into the tree, associated with the default
    data.

    This will be faster if \p itr points near to the place where the new
    element will be inserted (or where is already stored).
    However, the value of \p itr does not affect the result of this
    method, as long it is a valid %iterator for this tree. \p itr may even be
    end().

    If an element with the specified key already exists, an %iterator pointing
    to that pair is returned.

    This operation invalidates existing iterators.

    This method takes \f$O(\log n)\f$ time if the element already exists, and
    \f$O(\log^2 n)\f$ amortized time otherwise.
  */
  iterator insert(iterator itr, dimension_type key);

  //! Inserts an element in the tree.
  /*!
    \return
    An iterator that points to the inserted element.

    \param itr
    The iterator used as hint

    \param key
    The key that will be inserted into the tree.

    \param data
    The data that will be inserted into the tree.

    This will be faster if \p itr points near to the place where the new
    element will be inserted (or where is already stored).
    However, the value of \p itr does not affect the result of this
    method, as long it is a valid iterator for this tree. \p itr may even be
    end().

    If an element with the specified key already exists, its associated data
    is set to \p data and an iterator pointing to that pair is returned.

    This operation invalidates existing iterators.

    This method takes \f$O(\log n)\f$ time if the element already exists,
    and \f$O(\log^2 n)\f$ amortized time otherwise.
  */
  iterator insert(iterator itr, dimension_type key,
                  data_type_const_reference data);

  //! Erases the element with key \p key from the tree.
  /*!
    This operation invalidates existing iterators.

    \returns an iterator to the next element (or end() if there are no
             elements with key greater than \p key ).

    \param key
    The key of the element that will be erased from the tree.

    This method takes \f$O(\log n)\f$ time if the element already exists,
    and \f$O(\log^2 n)\f$ amortized time otherwise.
  */
  iterator erase(dimension_type key);

  //! Erases the element pointed to by \p itr from the tree.
  /*!
    This operation invalidates existing iterators.

    \returns an iterator to the next element (or end() if there are no
             elements with key greater than \p key ).

    \param itr
    An iterator pointing to the element that will be erased from the tree.

    This method takes \f$O(\log n)\f$ time if the element already exists, and
    \f$O(\log^2 n)\f$ amortized time otherwise.
  */
  iterator erase(iterator itr);

  /*!
    \brief Removes the element with key \p key (if it exists) and decrements
           by 1 all elements' keys that were greater than \p key.

    \param key
    The key of the element that will be erased from the tree.

    This operation invalidates existing iterators.

    This method takes \f$O(k+\log^2 n)\f$ expected time, where k is the number
    of elements with keys greater than \p key.
  */
  void erase_element_and_shift_left(dimension_type key);

  //! Adds \p n to all keys greater than or equal to \p key.
  /*!
    \param key
    The key of the first element whose key will be increased.

    \param n
    Specifies how much the keys will be increased.

    This method takes \f$O(k+\log n)\f$ expected time, where k is the number
    of elements with keys greater than or equal to \p key.
  */
  void increase_keys_from(dimension_type key, dimension_type n);

  //! Sets to \p i the key of *itr. Assumes that i<=itr.index() and that there
  //! are no elements with keys in [i,itr.index()).
  /*!
    All existing iterators remain valid.

    This method takes \f$O(1)\f$ time.
  */
  void fast_shift(dimension_type i, iterator itr);

  //! Swaps x with *this.
  /*!
    \param x
    The tree that will be swapped with *this.

    This operation invalidates existing iterators.

    This method takes \f$O(1)\f$ time.
  */
  void m_swap(CO_Tree& x);

  //! Returns an iterator that points at the first element.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  iterator begin();

  //! Returns an iterator that points after the last element.
  /*!
    This method always returns a reference to the same internal %iterator,
    that is updated at each operation that modifies the structure.
    Client code can keep a const reference to that %iterator instead of
    keep updating a local %iterator.

    This method takes \f$O(1)\f$ time.
  */
  const iterator& end();

  //! Equivalent to cbegin().
  const_iterator begin() const;

  //! Equivalent to cend().
  const const_iterator& end() const;

  //! Returns a const_iterator that points at the first element.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  const_iterator cbegin() const;

  //! Returns a const_iterator that points after the last element.
  /*!
    This method always returns a reference to the same internal %iterator,
    that is updated at each operation that modifies the structure.
    Client code can keep a const reference to that %iterator instead of
    keep updating a local %iterator.

    This method takes \f$O(1)\f$ time.
  */
  const const_iterator& cend() const;

  //! Searches an element with key \p key using bisection.
  /*!
    \param key
    The key that will be searched for.

    If the element is found, an %iterator pointing to that element is
    returned; otherwise, the returned %iterator refers to the immediately
    preceding or succeeding value.
    If the tree is empty, end() is returned.

    This method takes \f$O(\log n)\f$ time.
  */
  iterator bisect(dimension_type key);

  //! Searches an element with key \p key using bisection.
  /*!
    \param key
    The key that will be searched for.

    If the element is found, an %iterator pointing to that element is
    returned; otherwise, the returned %iterator refers to the immediately
    preceding or succeeding value.
    If the tree is empty, end() is returned.

    This method takes \f$O(\log n)\f$ time.
  */
  const_iterator bisect(dimension_type key) const;

  //! Searches an element with key \p key in [first, last] using bisection.
  /*!
    \param first
    An %iterator pointing to the first element in the range.
    It must not be end().

    \param last
    An %iterator pointing to the last element in the range.
    Note that this is included in the search.
    It must not be end().

    \param key
    The key that will be searched for.

    \return
    If the specified key is found, an %iterator pointing to that element is
    returned; otherwise, the returned %iterator refers to the immediately
    preceding or succeeding value.
    If the tree is empty, end() is returned.

    This method takes \f$O(\log(last - first + 1))\f$ time.
  */
  iterator bisect_in(iterator first, iterator last, dimension_type key);

  //! Searches an element with key \p key in [first, last] using bisection.
  /*!
    \param first
    An %iterator pointing to the first element in the range.
    It must not be end().

    \param last
    An %iterator pointing to the last element in the range.
    Note that this is included in the search.
    It must not be end().

    \param key
    The key that will be searched for.

    \return
    If the specified key is found, an %iterator pointing to that element is
    returned; otherwise, the returned %iterator refers to the immediately
    preceding or succeeding value.
    If the tree is empty, end() is returned.

    This method takes \f$O(\log(last - first + 1))\f$ time.
  */
  const_iterator bisect_in(const_iterator first, const_iterator last,
                           dimension_type key) const;

  //! Searches an element with key \p key near \p hint.
  /*!
    \param hint
    An %iterator used as a hint.

    \param key
    The key that will be searched for.

    If the element is found, the returned %iterator points to that element;
    otherwise, it points to the immediately preceding or succeeding value.
    If the tree is empty, end() is returned.

    The value of \p itr does not affect the result of this method, as long it
    is a valid %iterator for this tree. \p itr may even be end().

    This method takes \f$O(\log n)\f$ time. If the distance between the
    returned position and \p hint is \f$O(1)\f$ it takes \f$O(1)\f$ time.
  */
  iterator bisect_near(iterator hint, dimension_type key);

  //! Searches an element with key \p key near \p hint.
  /*!
    \param hint
    An %iterator used as a hint.

    \param key
    The key that will be searched for.

    If the element is found, the returned %iterator points to that element;
    otherwise, it points to the immediately preceding or succeeding value.
    If the tree is empty, end() is returned.

    The value of \p itr does not affect the result of this method, as long it
    is a valid %iterator for this tree. \p itr may even be end().

    This method takes \f$O(\log n)\f$ time. If the distance between the
    returned position and \p hint is \f$O(1)\f$ it takes \f$O(1)\f$ time.
  */
  const_iterator bisect_near(const_iterator hint, dimension_type key) const;

private:

  //! Searches an element with key \p key in [first, last] using bisection.
  /*!
    \param first
    The index of the first element in the range.
    It must be the index of an element with a value.

    \param last
    The index of the last element in the range.
    It must be the index of an element with a value.
    Note that this is included in the search.

    \param key
    The key that will be searched for.

    \return
    If the element is found, the index of that element is returned; otherwise,
    the returned index refers to the immediately preceding or succeeding
    value.

    This method takes \f$O(\log n)\f$ time.
  */
  dimension_type bisect_in(dimension_type first, dimension_type last,
                           dimension_type key) const;

  //! Searches an element with key \p key near \p hint.
  /*!
    \param hint
    An index used as a hint.
    It must be the index of an element with a value.

    \param key
    The key that will be searched for.

    \return
    If the element is found, the index of that element is returned; otherwise,
    the returned index refers to the immediately preceding or succeeding
    value.

    This uses a binary progression and then a bisection, so this method is
    \f$O(\log n)\f$, and it is \f$O(1)\f$ if the distance between the returned
    position and \p hint is \f$O(1)\f$.

    This method takes \f$O(\log n)\f$ time. If the distance between the
    returned position and \p hint is \f$O(1)\f$ it takes \f$O(1)\f$ time.
  */
  dimension_type bisect_near(dimension_type hint, dimension_type key) const;

  //! Inserts an element in the tree.
  /*!
    If there is already an element with key \p key in the tree, its
    associated data is set to \p data.

    This operation invalidates existing iterators.

    \return
    An %iterator that points to the inserted element.

    \param key
    The key that will be inserted into the tree.

    \param data
    The data that will be associated with \p key.

    \param itr
    It must point to the element in the tree with key \p key or, if no such
    element exists, it must point to the node that would be his parent.

    This method takes \f$O(1)\f$ time if the element already exists, and
    \f$O(\log^2 n)\f$ amortized time otherwise.
  */
  tree_iterator insert_precise(dimension_type key,
                               data_type_const_reference data,
                               tree_iterator itr);

  //! Helper for \c insert_precise.
  /*!
    This helper method takes the same arguments as \c insert_precise,
    but besides assuming that \p itr is a correct hint, it also assumes
    that \p key and \p data are not in the tree; namely, a proper
    insertion has to be done and the insertion can not invalidate \p data.
  */
  tree_iterator insert_precise_aux(dimension_type key,
                                   data_type_const_reference data,
                                   tree_iterator itr);

  //! Inserts an element in the tree.
  /*!

    \param key
    The key that will be inserted into the tree.

    \param data
    The data that will be associated with \p key.

    The tree must be empty.

    This operation invalidates existing iterators.

    This method takes \f$O(1)\f$ time.
  */
  void insert_in_empty_tree(dimension_type key,
                            data_type_const_reference data);

  //! Erases from the tree the element pointed to by \p itr .
  /*!
    This operation invalidates existing iterators.

    \returns
    An %iterator to the next element (or end() if there are no elements with
    key greater than \p key ).

    \param itr
    An %iterator pointing to the element that will be erased.

    This method takes \f$O(\log^2 n)\f$ amortized time.
  */
  iterator erase(tree_iterator itr);

  //! Initializes a tree with reserved size at least \p n .
  /*!
    \param n
    A lower bound on the tree's desired reserved size.

    This method takes \f$O(n)\f$ time.
  */
  void init(dimension_type n);

  //! Deallocates the tree's dynamic arrays.
  /*!
    After this call, the tree fields are uninitialized, so init() must be
    called again before using the tree.

    This method takes \f$O(n)\f$ time.
  */
  void destroy();

  //! Checks the internal invariants, but not the densities.
  bool structure_OK() const;

  //! Checks the internal invariants.
  bool OK() const;

  //! Returns the floor of the base-2 logarithm of \p n .
  /*!
    \param n
    It must be greater than zero.

    This method takes \f$O(\log n)\f$ time.
  */
  static unsigned integer_log2(dimension_type n);

  //! Compares the fractions numer/denom with ratio/100.
  /*!
    \returns Returns true if the fraction numer/denom is less
    than the fraction ratio/100.

    \param ratio
    It must be less than or equal to 100.

    \param numer
    The numerator of the fraction.

    \param denom
    The denominator of the fraction.

    This method takes \f$O(1)\f$ time.
  */
  static bool is_less_than_ratio(dimension_type numer, dimension_type denom,
                                 dimension_type ratio);

  //! Compares the fractions numer/denom with ratio/100.
  /*!
    \returns
    Returns true if the fraction numer/denom is greater than the fraction
    ratio/100.

    \param ratio
    It must be less than or equal to 100.

    \param numer
    The numerator of the fraction.

    \param denom
    The denominator of the fraction.

    This method takes \f$O(1)\f$ time.
  */
  static bool is_greater_than_ratio(dimension_type numer, dimension_type denom,
                                    dimension_type ratio);

  //! Dumps the subtree rooted at \p itr to stdout, for debugging purposes.
  /*!
    \param itr
    A tree_iterator pointing to the root of the desired subtree.
  */
  static void dump_subtree(tree_iterator itr);

  //! Increases the tree's reserved size.
  /*!
    This is called when the density is about to exceed the maximum density
    (specified by max_density_percent).

    This method takes \f$O(n)\f$ time.
  */
  void rebuild_bigger_tree();

  //! Decreases the tree's reserved size.
  /*!
    This is called when the density is about to become less than the minimum
    allowed density (specified by min_density_percent).

    \p reserved_size must be greater than 3 (otherwise the tree can just be
    cleared).

    This method takes \f$O(n)\f$ time.
  */
  void rebuild_smaller_tree();

  //! Re-initializes the cached iterators.
  /*!
    This method must be called when the indexes[] and data[] vector are
    reallocated.

    This method takes \f$O(1)\f$ time.
  */
  void refresh_cached_iterators();

  //! Rebalances the tree.
  /*!
    For insertions, it adds the pair (key, value) in the process.

    This operation invalidates existing iterators that point to nodes in the
    rebalanced subtree.

    \returns an %iterator pointing to the root of the subtree that was
             rebalanced.

    \param itr
    It points to the node where the new element has to be inserted or where an
    element has just been deleted.

    \param key
    The index that will be inserted in the tree (for insertions only).

    \param value
    The value that will be inserted in the tree (for insertions only).

    This method takes \f$O(\log^2 n)\f$ amortized time.
  */
  tree_iterator rebalance(tree_iterator itr, dimension_type key,
                          data_type_const_reference value);

  //! Moves all elements of a subtree to the rightmost end.
  /*!
    \returns
    The index of the rightmost unused node in the subtree after the process.

    \param last_in_subtree
    It is the index of the last element in the subtree.

    \param subtree_size
    It is the number of valid elements in the subtree.
    It must be greater than zero.

    \param key
    The key that may be added to the tree if add_element is \c true.

    \param value
    The value that may be added to the tree if add_element is \c true.

    \param add_element
    If it is true, it tries to add an element with key \p key and value
    \p value in the process (but it may not).

    This method takes \f$O(k)\f$ time, where k is \p subtree_size.
  */
  dimension_type compact_elements_in_the_rightmost_end(
    dimension_type last_in_subtree, dimension_type subtree_size,
    dimension_type key, data_type_const_reference value,
    bool add_element);

  //! Redistributes the elements in the subtree rooted at \p root_index.
  /*!
    The subtree's elements must be compacted to the rightmost end.

    \param root_index
    The index of the subtree's root node.

    \param subtree_size
    It is the number of used elements in the subtree.
    It must be greater than zero.

    \param last_used
    It points to the leftmost element with a value in the subtree.

    \param add_element
    If it is true, this method adds an element with the specified key and
    value in the process.

    \param key
    The key that will be added to the tree if \p add_element is \c true.

    \param value
    The data that will be added to the tree if \p add_element is \c true.

    This method takes \f$O(k)\f$ time, where k is \p subtree_size.
  */
  void redistribute_elements_in_subtree(dimension_type root_index,
                                        dimension_type subtree_size,
                                        dimension_type last_used,
                                        dimension_type key,
                                        data_type_const_reference value,
                                        bool add_element);

  //! Moves all data in the tree \p tree into *this.
  /*!
    \param tree
    The tree from which the element will be moved into *this.

    *this must be empty and big enough to contain all of tree's data without
    exceeding max_density.

    This method takes \f$O(n)\f$ time.
  */
  void move_data_from(CO_Tree& tree);

  //! Copies all data in the tree \p tree into *this.
  /*!
    \param tree
    The tree from which the element will be copied into *this.

    *this must be empty and must have the same reserved size of \p tree.
    this->OK() may return false before this method is called, but
    this->structure_OK() must return true.

    This method takes \f$O(n)\f$ time.
  */
  void copy_data_from(const CO_Tree& tree);

  //! Counts the number of used elements in the subtree rooted at itr.
  /*!
    \param itr
    An %iterator pointing to the root of the desired subtree.

    This method takes \f$O(k)\f$ time, where k is the number of elements in
    the subtree.
  */
  static dimension_type count_used_in_subtree(tree_iterator itr);

  //! Moves the value of \p from in \p to .
  /*!
    \param from
    It must be a valid value.

    \param to
    It must be a non-constructed chunk of memory.

    After the move, \p from becomes a non-constructed chunk of memory and
    \p to gets the value previously stored by \p from.

    The implementation of this method assumes that data_type values do not
    keep pointers to themselves nor to their fields.

    This method takes \f$O(1)\f$ time.
  */
  static void move_data_element(data_type& to, data_type& from);

  //! The maximum density of used nodes.
  /*!
    This must be greater than or equal to 50 and lower than 100.
  */
  static const dimension_type max_density_percent = 91;

  //! The minimum density of used nodes.
  /*!
    Must be strictly lower than the half of max_density_percent.
  */
  static const dimension_type min_density_percent = 38;

  //! The minimum density at the leaves' depth.
  /*!
    Must be greater than zero and strictly lower than min_density_percent.

    Increasing the value is safe but leads to time inefficiencies
    (measured against ppl_lpsol on 24 August 2010), because it forces trees to
    be more balanced, increasing the cost of rebalancing.
  */
  static const dimension_type min_leaf_density_percent = 1;

  //! An index used as a marker for unused nodes in the tree.
  /*!
    This must not be used as a key.
  */
  static const dimension_type unused_index = C_Integer<dimension_type>::max;

  //! The %iterator returned by end().
  /*!
    It is updated when needed, to keep it valid.
  */
  iterator cached_end;

  //! The %iterator returned by the const version of end().
  /*!
    It is updated when needed, to keep it valid.
  */
  const_iterator cached_const_end;

  //! The depth of the leaves in the complete tree.
  height_t max_depth;

  //! The vector that contains the keys in the tree.
  /*!
    If an element of this vector is \p unused_index , it means that that
    element and the corresponding element of data[] are not used.

    Its size is reserved_size + 2, because the first and the last elements
    are used as markers for iterators.
  */
  dimension_type* indexes;

  //! The allocator used to allocate/deallocate data.
  std::allocator<data_type> data_allocator;

  //! The vector that contains the data of the keys in the tree.
  /*!
    If index[i] is \p unused_index, data[i] is unused.
    Otherwise, data[i] contains the data associated to the indexes[i] key.

    Its size is reserved_size + 1, because the first element is not used (to
    allow using the same index in both indexes[] and data[] instead of
    adding 1 to access data[]).
  */
  data_type* data;

  //! The number of nodes in the complete tree.
  /*!
    It is one less than a power of 2.
    If this is 0, data and indexes are set to NULL.
  */
  dimension_type reserved_size;

  //! The number of values stored in the tree.
  dimension_type size_;
};

class CO_Tree::tree_iterator {

public:

  /*!
    \brief Constructs a tree_iterator pointing at the root node of the
           specified tree

    \param tree
    The tree to which the new %iterator will point to.
    It must not be empty.
  */
  explicit tree_iterator(CO_Tree& tree);

  //! Constructs a tree_iterator pointing at the specified node of the tree.
  /*!
    \param tree
    The tree to which the new %iterator will point to.
    It must not be empty.

    \param i
    The index of the element in \p tree to which the new %iterator will point
    to.
  */
  tree_iterator(CO_Tree& tree, dimension_type i);

  //! Constructs a tree_iterator from an iterator.
  /*!
    \param itr
    The iterator that will be converted into a tree_iterator.
    It must not be end().

    \param tree
    The tree to which the new %iterator will point to.
    It must not be empty.
  */
  tree_iterator(const iterator& itr, CO_Tree& tree);

  //! The assignment operator.
  /*!
    \param itr
    The %iterator that will be assigned into *this.
  */
  tree_iterator& operator=(const tree_iterator& itr);

  //! The assignment operator from an iterator.
  /*!
    \param itr
    The iterator that will be assigned into *this.
  */
  tree_iterator& operator=(const iterator& itr);

  //! Compares *this with \p itr.
  /*!
    \param itr
    The %iterator that will compared with *this.
  */
  bool operator==(const tree_iterator& itr) const;

  //! Compares *this with \p itr.
  /*!
    \param itr
    The %iterator that will compared with *this.
  */
  bool operator!=(const tree_iterator& itr) const;

  //! Makes the %iterator point to the root of \p tree.
  /*!
    The values of all fields (beside tree) are overwritten.

    This method takes \f$O(1)\f$ time.
  */
  void get_root();

  //! Makes the %iterator point to the left child of the current node.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  void get_left_child();

  //! Makes the %iterator point to the right child of the current node.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  void get_right_child();

  //! Makes the %iterator point to the parent of the current node.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  void get_parent();

  /*!
    \brief Searches for an element with key \p key in the subtree rooted at
           \p *this.

    \param key
    The searched for key.

    After this method, *this points to the found node (if it exists) or to
    the node that would be his parent (otherwise).

    This method takes \f$O(\log n)\f$ time.
  */
  void go_down_searching_key(dimension_type key);

  /*!
    \brief Follows left children with a value, until it arrives at a leaf or at
           a node with no value.

    This method takes \f$O(1)\f$ time.
  */
  void follow_left_children_with_value();

  /*!
    \brief Follows right children with a value, until it arrives at a leaf or at
           a node with no value.

    This method takes \f$O(1)\f$ time.
  */
  void follow_right_children_with_value();

  //! Returns true if the pointed node is the root node.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  bool is_root() const;

  //! Returns true if the pointed node has a parent and is its right child.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  bool is_right_child() const;

  //! Returns true if the pointed node is a leaf of the complete tree.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  bool is_leaf() const;

  //! Returns the key and value of the current node.
  data_type& operator*();

  //! Returns the key and value of the current node.
  Coefficient_traits::const_reference operator*() const;

  //! Returns a reference to the index of the element pointed to by \c *this.
  /*!
    \returns a reference to the index of the element pointed to by \c *this.
  */
  dimension_type& index();

  //! Returns the index of the element pointed to by \c *this.
  /*!
    \returns the index of the element pointed to by \c *this.
  */
  dimension_type index() const;

  //! Returns the index of the node pointed to by \c *this.
  /*!
    \returns the key of the node pointed to by \c *this, or unused_index if
             the current node does not contain a valid element.
  */
  dimension_type key() const;

  //! The tree containing the element pointed to by this %iterator.
  CO_Tree& tree;

  /*!
    \brief Returns the index of the current node in the DFS layout of the
           complete tree.
  */
  dimension_type dfs_index() const;

  /*!
    \brief Returns 2^h, with h the height of the current node in the tree,
           counting from 0.

    Thus leaves have offset 1.
    This is faster than depth(), so it is useful to compare node depths.

    This method takes \f$O(1)\f$ time.
  */
  dimension_type get_offset() const;

  //! Returns the depth of the current node in the complete tree.
  /*!
    This method takes \f$O(\log n)\f$ time.
  */
  height_t depth() const;

private:
  //! Checks the internal invariant.
  bool OK() const;

  //! The index of the current node in the DFS layout of the complete tree.
  dimension_type i;

  /*!
    \brief This is 2^h, with h the height of the current node in the tree,
           counting from 0.

    Thus leaves have offset 1.
    This is equal to (i & -i), and is only stored to increase performance.
  */
  dimension_type offset;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Swaps \p x with \p y.
/*! \relates CO_Tree */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void swap(CO_Tree& x, CO_Tree& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Swaps \p x with \p y.
/*! \relates CO_Tree::const_iterator */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void swap(CO_Tree::const_iterator& x, CO_Tree::const_iterator& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Swaps \p x with \p y.
/*! \relates CO_Tree::iterator */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void swap(CO_Tree::iterator& x, CO_Tree::iterator& y);

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/CO_Tree_inlines.hh line 1. */
/* CO_Tree class implementation: inline functions.
*/


#include <cstddef>

namespace Parma_Polyhedra_Library {

inline dimension_type
CO_Tree::dfs_index(const_iterator itr) const {
  PPL_ASSERT(itr.current_index != 0);
  PPL_ASSERT(itr.current_index >= indexes + 1);
  PPL_ASSERT(itr.current_index <= indexes + reserved_size);
  const std::ptrdiff_t index = itr.current_index - indexes;
  return static_cast<dimension_type>(index);
}

inline dimension_type
CO_Tree::dfs_index(iterator itr) const {
  PPL_ASSERT(itr.current_index != 0);
  PPL_ASSERT(itr.current_index >= indexes + 1);
  PPL_ASSERT(itr.current_index <= indexes + reserved_size);
  const std::ptrdiff_t index = itr.current_index - indexes;
  return static_cast<dimension_type>(index);
}

inline
CO_Tree::CO_Tree() {
  init(0);
  PPL_ASSERT(OK());
}

inline
CO_Tree::CO_Tree(const CO_Tree& y) {
  PPL_ASSERT(y.OK());
  data_allocator = y.data_allocator;
  init(y.reserved_size);
  copy_data_from(y);
}

inline CO_Tree&
CO_Tree::operator=(const CO_Tree& y) {
  if (this != &y) {
    destroy();
    data_allocator = y.data_allocator;
    init(y.reserved_size);
    copy_data_from(y);
  }
  return *this;
}

inline void
CO_Tree::clear() {
  *this = CO_Tree();
}

inline
CO_Tree::~CO_Tree() {

  destroy();
}

inline bool
CO_Tree::empty() const {
  return size_ == 0;
}

inline dimension_type
CO_Tree::size() const {
  return size_;
}

inline dimension_type
CO_Tree::max_size() {
  return C_Integer<dimension_type>::max/100;
}

inline void
CO_Tree::dump_tree() const {
  if (empty()) {
    std::cout << "(empty tree)" << std::endl;
  }
  else {
    dump_subtree(tree_iterator(*const_cast<CO_Tree*>(this)));
  }
}

inline CO_Tree::iterator
CO_Tree::insert(const dimension_type key) {
  if (empty()) {
    return insert(key, Coefficient_zero());
  }
  else {
    tree_iterator itr(*this);
    itr.go_down_searching_key(key);
    if (itr.index() == key) {
      return iterator(itr);
    }
    else {
      return iterator(insert_precise(key, Coefficient_zero(), itr));
    }
  }
}

inline CO_Tree::iterator
CO_Tree::insert(dimension_type key, data_type_const_reference data1) {
  if (empty()) {
    insert_in_empty_tree(key, data1);
    tree_iterator itr(*this);
    PPL_ASSERT(itr.index() != unused_index);
    return iterator(itr);
  }
  else {
    tree_iterator itr(*this);
    itr.go_down_searching_key(key);
    return iterator(insert_precise(key, data1, itr));
  }
}

inline CO_Tree::iterator
CO_Tree::erase(dimension_type key) {
  PPL_ASSERT(key != unused_index);

  if (empty()) {
    return end();
  }

  tree_iterator itr(*this);
  itr.go_down_searching_key(key);

  if (itr.index() == key) {
    return erase(itr);
  }

  iterator result(itr);
  if (result.index() < key) {
    ++result;
  }

  PPL_ASSERT(result == end() || result.index() > key);
#ifndef NDEBUG
  iterator last = end();
  --last;
  PPL_ASSERT((result == end()) == (last.index() < key));
#endif

  return result;
}

inline CO_Tree::iterator
CO_Tree::erase(iterator itr) {
  PPL_ASSERT(itr != end());
  return erase(tree_iterator(itr, *this));
}

inline void
CO_Tree::m_swap(CO_Tree& x) {
  using std::swap;
  swap(max_depth, x.max_depth);
  swap(indexes, x.indexes);
  swap(data_allocator, x.data_allocator);
  swap(data, x.data);
  swap(reserved_size, x.reserved_size);
  swap(size_, x.size_);
  // Cached iterators have been invalidated by the swap,
  // they must be refreshed here.
  refresh_cached_iterators();
  x.refresh_cached_iterators();
  PPL_ASSERT(structure_OK());
  PPL_ASSERT(x.structure_OK());
}

inline CO_Tree::iterator
CO_Tree::begin() {
  return iterator(*this);
}

inline const CO_Tree::iterator&
CO_Tree::end() {
  return cached_end;
}

inline CO_Tree::const_iterator
CO_Tree::begin() const {
  return const_iterator(*this);
}

inline const CO_Tree::const_iterator&
CO_Tree::end() const {
  return cached_const_end;
}

inline CO_Tree::const_iterator
CO_Tree::cbegin() const {
  return const_iterator(*this);
}

inline const CO_Tree::const_iterator&
CO_Tree::cend() const {
  return cached_const_end;
}

inline CO_Tree::iterator
CO_Tree::bisect(dimension_type key) {
  if (empty()) {
    return end();
  }
  iterator last = end();
  --last;
  return bisect_in(begin(), last, key);
}

inline CO_Tree::const_iterator
CO_Tree::bisect(dimension_type key) const {
  if (empty()) {
    return end();
  }
  const_iterator last = end();
  --last;
  return bisect_in(begin(), last, key);
}

inline CO_Tree::iterator
CO_Tree::bisect_in(iterator first, iterator last, dimension_type key) {
  PPL_ASSERT(first != end());
  PPL_ASSERT(last != end());
  const dimension_type index
    = bisect_in(dfs_index(first), dfs_index(last), key);
  return iterator(*this, index);
}

inline CO_Tree::const_iterator
CO_Tree::bisect_in(const_iterator first, const_iterator last,
                   dimension_type key) const {
  PPL_ASSERT(first != end());
  PPL_ASSERT(last != end());
  const dimension_type index
    = bisect_in(dfs_index(first), dfs_index(last), key);
  return const_iterator(*this, index);
}

inline CO_Tree::iterator
CO_Tree::bisect_near(iterator hint, dimension_type key) {
  if (hint == end()) {
    return bisect(key);
  }
  const dimension_type index
    = bisect_near(dfs_index(hint), key);
  return iterator(*this, index);
}

inline CO_Tree::const_iterator
CO_Tree::bisect_near(const_iterator hint, dimension_type key) const {
  if (hint == end()) {
    return bisect(key);
  }
  const dimension_type index = bisect_near(dfs_index(hint), key);
  return const_iterator(*this, index);
}

inline void
CO_Tree::fast_shift(dimension_type i, iterator itr) {
  PPL_ASSERT(itr != end());
  PPL_ASSERT(i <= itr.index());
  indexes[dfs_index(itr)] = i;
  PPL_ASSERT(OK());
}

inline void
CO_Tree::insert_in_empty_tree(dimension_type key,
                              data_type_const_reference data1) {
  PPL_ASSERT(empty());
  rebuild_bigger_tree();
  tree_iterator itr(*this);
  PPL_ASSERT(itr.index() == unused_index);
  new(&(*itr)) data_type(data1);
  // Set the index afterwards, so that if the constructor above throws
  // the tree's structure is consistent.
  itr.index() = key;
  ++size_;

  PPL_ASSERT(OK());
}

inline bool
CO_Tree::is_less_than_ratio(dimension_type numer, dimension_type denom,
                            dimension_type ratio) {
  PPL_ASSERT(ratio <= 100);
  // If these are true, no overflows are possible.
  PPL_ASSERT(denom <= unused_index/100);
  PPL_ASSERT(numer <= unused_index/100);
  return 100*numer < ratio*denom;
}

inline bool
CO_Tree::is_greater_than_ratio(dimension_type numer, dimension_type denom,
                               dimension_type ratio) {
  PPL_ASSERT(ratio <= 100);
  // If these are true, no overflows are possible.
  PPL_ASSERT(denom <= unused_index/100);
  PPL_ASSERT(numer <= unused_index/100);
  return 100*numer > ratio*denom;
}

inline void
CO_Tree::rebuild_smaller_tree() {
  PPL_ASSERT(reserved_size > 3);
  CO_Tree new_tree;
  new_tree.init(reserved_size / 2);
  new_tree.move_data_from(*this);
  m_swap(new_tree);
  PPL_ASSERT(new_tree.structure_OK());
  PPL_ASSERT(structure_OK());
}

inline void
CO_Tree::refresh_cached_iterators() {
  cached_end = iterator(*this, reserved_size + 1);
  cached_const_end = const_iterator(*this, reserved_size + 1);
}

inline void
CO_Tree::move_data_element(data_type& to, data_type& from) {
  /*
    The following code is equivalent (but slower):

    <CODE>
      new(&to) data_type(from);
      from.~data_type();
    </CODE>
  */
  std::memcpy(&to, &from, sizeof(data_type));
}


inline
CO_Tree::const_iterator::const_iterator()
  : current_index(0), current_data(0) {
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = 0;
#endif
  PPL_ASSERT(OK());
}

inline
CO_Tree::const_iterator::const_iterator(const CO_Tree& tree1)
  : current_index(&(tree1.indexes[1])), current_data(&(tree1.data[1])) {
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = &tree1;
#endif
  if (!tree1.empty()) {
    while (*current_index == unused_index) {
      ++current_index;
      ++current_data;
    }
  }
  PPL_ASSERT(OK());
}

inline
CO_Tree::const_iterator::const_iterator(const CO_Tree& tree1,
                                        dimension_type i)
  : current_index(&(tree1.indexes[i])), current_data(&(tree1.data[i])) {
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = &tree1;
#endif
  PPL_ASSERT(i != 0);
  PPL_ASSERT(i <= tree1.reserved_size + 1);
  PPL_ASSERT(tree1.empty() || tree1.indexes[i] != unused_index);
  PPL_ASSERT(OK());
}

inline
CO_Tree::const_iterator::const_iterator(const const_iterator& itr2) {
  (*this) = itr2;
  PPL_ASSERT(OK());
}

inline
CO_Tree::const_iterator::const_iterator(const iterator& itr2) {
  (*this) = itr2;
  PPL_ASSERT(OK());
}

inline void
CO_Tree::const_iterator::m_swap(const_iterator& itr) {
  using std::swap;
  swap(current_data, itr.current_data);
  swap(current_index, itr.current_index);
#if PPL_CO_TREE_EXTRA_DEBUG
  swap(tree, itr.tree);
#endif
  PPL_ASSERT(OK());
  PPL_ASSERT(itr.OK());
}

inline CO_Tree::const_iterator&
CO_Tree::const_iterator::operator=(const const_iterator& itr2) {
  current_index = itr2.current_index;
  current_data = itr2.current_data;
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = itr2.tree;
#endif
  PPL_ASSERT(OK());
  return *this;
}

inline CO_Tree::const_iterator&
CO_Tree::const_iterator::operator=(const iterator& itr2) {
  current_index = itr2.current_index;
  current_data = itr2.current_data;
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = itr2.tree;
#endif
  PPL_ASSERT(OK());
  return *this;
}

inline CO_Tree::const_iterator&
CO_Tree::const_iterator::operator++() {
  PPL_ASSERT(current_index != 0);
  PPL_ASSERT(current_data != 0);
#if PPL_CO_TREE_EXTRA_DEBUG
  PPL_ASSERT(current_index != &(tree->indexes[tree->reserved_size + 1]));
#endif
  ++current_index;
  ++current_data;
  while (*current_index == unused_index) {
    ++current_index;
    ++current_data;
  }
  PPL_ASSERT(OK());
  return *this;
}

inline CO_Tree::const_iterator&
CO_Tree::const_iterator::operator--() {
  PPL_ASSERT(current_index != 0);
  PPL_ASSERT(current_data != 0);
  --current_index;
  --current_data;
  while (*current_index == unused_index) {
    --current_index;
    --current_data;
  }
  PPL_ASSERT(OK());
  return *this;
}

inline CO_Tree::const_iterator
CO_Tree::const_iterator::operator++(int) {
  const_iterator itr(*this);
  ++(*this);
  return itr;
}

inline CO_Tree::const_iterator
CO_Tree::const_iterator::operator--(int) {
  const_iterator itr(*this);
  --(*this);
  return itr;
}

inline Coefficient_traits::const_reference
CO_Tree::const_iterator::operator*() const {
  PPL_ASSERT(current_index != 0);
  PPL_ASSERT(current_data != 0);
  PPL_ASSERT(OK());
#if PPL_CO_TREE_EXTRA_DEBUG
  PPL_ASSERT(current_index != &(tree->indexes[tree->reserved_size + 1]));
#endif
  return *current_data;
}

inline dimension_type
CO_Tree::const_iterator::index() const {
  PPL_ASSERT(current_index != 0);
  PPL_ASSERT(current_data != 0);
  PPL_ASSERT(OK());
#if PPL_CO_TREE_EXTRA_DEBUG
  PPL_ASSERT(current_index != &(tree->indexes[tree->reserved_size + 1]));
#endif
  return *current_index;
}

inline bool
CO_Tree::const_iterator::operator==(const const_iterator& x) const {
  PPL_ASSERT((current_index == x.current_index)
             == (current_data == x.current_data));
  PPL_ASSERT(OK());
  return (current_index == x.current_index);
}

inline bool
CO_Tree::const_iterator::operator!=(const const_iterator& x) const {
  return !(*this == x);
}


inline
CO_Tree::iterator::iterator()
  : current_index(0), current_data(0) {
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = 0;
#endif
  PPL_ASSERT(OK());
}

inline
CO_Tree::iterator::iterator(CO_Tree& tree1)
  : current_index(&(tree1.indexes[1])), current_data(&(tree1.data[1])) {
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = &tree1;
#endif
  if (!tree1.empty()) {
    while (*current_index == unused_index) {
      ++current_index;
      ++current_data;
    }
  }
  PPL_ASSERT(OK());
}

inline
CO_Tree::iterator::iterator(CO_Tree& tree1, dimension_type i)
  : current_index(&(tree1.indexes[i])), current_data(&(tree1.data[i])) {
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = &tree1;
#endif
  PPL_ASSERT(i != 0);
  PPL_ASSERT(i <= tree1.reserved_size + 1);
  PPL_ASSERT(tree1.empty() || tree1.indexes[i] != unused_index);
  PPL_ASSERT(OK());
}

inline
CO_Tree::iterator::iterator(const tree_iterator& itr) {
  *this = itr;
  PPL_ASSERT(OK());
}

inline
CO_Tree::iterator::iterator(const iterator& itr2) {
  (*this) = itr2;
  PPL_ASSERT(OK());
}

inline void
CO_Tree::iterator::m_swap(iterator& itr) {
  using std::swap;
  swap(current_data, itr.current_data);
  swap(current_index, itr.current_index);
#if PPL_CO_TREE_EXTRA_DEBUG
  swap(tree, itr.tree);
#endif
  PPL_ASSERT(OK());
  PPL_ASSERT(itr.OK());
}

inline CO_Tree::iterator&
CO_Tree::iterator::operator=(const tree_iterator& itr) {
  current_index = &(itr.tree.indexes[itr.dfs_index()]);
  current_data = &(itr.tree.data[itr.dfs_index()]);
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = &(itr.tree);
#endif
  PPL_ASSERT(OK());
  return *this;
}

inline CO_Tree::iterator&
CO_Tree::iterator::operator=(const iterator& itr2) {
  current_index = itr2.current_index;
  current_data = itr2.current_data;
#if PPL_CO_TREE_EXTRA_DEBUG
  tree = itr2.tree;
#endif
  PPL_ASSERT(OK());
  return *this;
}

inline CO_Tree::iterator&
CO_Tree::iterator::operator++() {
  PPL_ASSERT(current_index != 0);
  PPL_ASSERT(current_data != 0);
#if PPL_CO_TREE_EXTRA_DEBUG
  PPL_ASSERT(current_index != &(tree->indexes[tree->reserved_size + 1]));
#endif
  ++current_index;
  ++current_data;
  while (*current_index == unused_index) {
    ++current_index;
    ++current_data;
  }

  PPL_ASSERT(OK());
  return *this;
}

inline CO_Tree::iterator&
CO_Tree::iterator::operator--() {
  PPL_ASSERT(current_index != 0);
  PPL_ASSERT(current_data != 0);
  --current_index;
  --current_data;
  while (*current_index == unused_index) {
    --current_index;
    --current_data;
  }

  PPL_ASSERT(OK());
  return *this;
}

inline CO_Tree::iterator
CO_Tree::iterator::operator++(int) {
  iterator itr(*this);
  ++(*this);
  return itr;
}

inline CO_Tree::iterator
CO_Tree::iterator::operator--(int) {
  iterator itr(*this);
  --(*this);
  return itr;
}

inline CO_Tree::data_type&
CO_Tree::iterator::operator*() {
  PPL_ASSERT(current_index != 0);
  PPL_ASSERT(current_data != 0);
  PPL_ASSERT(OK());
#if PPL_CO_TREE_EXTRA_DEBUG
  PPL_ASSERT(current_index != &(tree->indexes[tree->reserved_size + 1]));
#endif
  return *current_data;
}

inline Coefficient_traits::const_reference
CO_Tree::iterator::operator*() const {
  PPL_ASSERT(current_index != 0);
  PPL_ASSERT(current_data != 0);
  PPL_ASSERT(OK());
#if PPL_CO_TREE_EXTRA_DEBUG
  PPL_ASSERT(current_index != &(tree->indexes[tree->reserved_size + 1]));
#endif
  return *current_data;
}

inline dimension_type
CO_Tree::iterator::index() const {
  PPL_ASSERT(current_index != 0);
  PPL_ASSERT(current_data != 0);
  PPL_ASSERT(OK());
#if PPL_CO_TREE_EXTRA_DEBUG
  PPL_ASSERT(current_index != &(tree->indexes[tree->reserved_size + 1]));
#endif
  return *current_index;
}

inline bool
CO_Tree::iterator::operator==(const iterator& x) const {
  PPL_ASSERT((current_index == x.current_index)
             == (current_data == x.current_data));
  PPL_ASSERT(OK());
  return (current_index == x.current_index);
}

inline bool
CO_Tree::iterator::operator!=(const iterator& x) const {
  return !(*this == x);
}


inline
CO_Tree::tree_iterator::tree_iterator(CO_Tree& tree1)
  : tree(tree1) {
  PPL_ASSERT(tree.reserved_size != 0);
  get_root();
  PPL_ASSERT(OK());
}

inline
CO_Tree::tree_iterator::tree_iterator(CO_Tree& tree1, dimension_type i1)
  : tree(tree1) {
  PPL_ASSERT(tree.reserved_size != 0);
  PPL_ASSERT(i1 <= tree.reserved_size + 1);
  i = i1;
  offset = least_significant_one_mask(i);
  PPL_ASSERT(OK());
}

inline
CO_Tree::tree_iterator::tree_iterator(const iterator& itr, CO_Tree& tree1)
  : tree(tree1) {
  PPL_ASSERT(tree.reserved_size != 0);
  *this = itr;
  PPL_ASSERT(OK());
}

inline CO_Tree::tree_iterator&
CO_Tree::tree_iterator::operator=(const tree_iterator& itr) {
  PPL_ASSERT(&tree == &(itr.tree));
  i = itr.i;
  offset = itr.offset;
  return *this;
}

inline CO_Tree::tree_iterator&
CO_Tree::tree_iterator::operator=(const iterator& itr) {
  PPL_ASSERT(itr != tree.end());
  i = tree.dfs_index(itr);
  offset = least_significant_one_mask(i);
  return *this;
}

inline bool
CO_Tree::tree_iterator::operator==(const tree_iterator& itr) const {
  return i == itr.i;
}

inline bool
CO_Tree::tree_iterator::operator!=(const tree_iterator& itr) const {
  return !(*this == itr);
}

inline void
CO_Tree::tree_iterator::get_root() {
  i = tree.reserved_size / 2 + 1;
  offset = i;
  PPL_ASSERT(OK());
}

inline void
CO_Tree::tree_iterator::get_left_child() {
  PPL_ASSERT(offset != 0);
  PPL_ASSERT(offset != 1);
  offset /= 2;
  i -= offset;
  PPL_ASSERT(OK());
}

inline void
CO_Tree::tree_iterator::get_right_child() {
  PPL_ASSERT(offset != 0);
  PPL_ASSERT(offset != 1);
  offset /= 2;
  i += offset;
  PPL_ASSERT(OK());
}

inline void
CO_Tree::tree_iterator::get_parent() {
  PPL_ASSERT(!is_root());
  PPL_ASSERT(offset != 0);
  i &= ~offset;
  offset *= 2;
  i |= offset;
  PPL_ASSERT(OK());
}

inline void
CO_Tree::tree_iterator::follow_left_children_with_value() {
  PPL_ASSERT(index() != unused_index);
  const dimension_type* p = tree.indexes;
  p += i;
  p -= (offset - 1);
  while (*p == unused_index) {
    ++p;
  }
  const std::ptrdiff_t distance = p - tree.indexes;
  PPL_ASSERT(distance >= 0);
  i = static_cast<dimension_type>(distance);
  offset = least_significant_one_mask(i);
  PPL_ASSERT(OK());
}

inline void
CO_Tree::tree_iterator::follow_right_children_with_value() {
  PPL_ASSERT(index() != unused_index);
  const dimension_type* p = tree.indexes;
  p += i;
  p += (offset - 1);
  while (*p == unused_index) {
    --p;
  }
  const std::ptrdiff_t distance = p - tree.indexes;
  PPL_ASSERT(distance >= 0);
  i = static_cast<dimension_type>(distance);
  offset = least_significant_one_mask(i);
  PPL_ASSERT(OK());
}

inline bool
CO_Tree::tree_iterator::is_root() const {
  // This is implied by OK(), it is here for reference only.
  PPL_ASSERT(offset <= (tree.reserved_size / 2 + 1));
  return offset == (tree.reserved_size / 2 + 1);
}

inline bool
CO_Tree::tree_iterator::is_right_child() const {
  if (is_root()) {
    return false;
  }
  return (i & (2*offset)) != 0;
}

inline bool
CO_Tree::tree_iterator::is_leaf() const {
  return offset == 1;
}

inline CO_Tree::data_type&
CO_Tree::tree_iterator::operator*() {
  return tree.data[i];
}

inline Coefficient_traits::const_reference
CO_Tree::tree_iterator::operator*() const {
  return tree.data[i];
}

inline dimension_type&
CO_Tree::tree_iterator::index() {
  return tree.indexes[i];
}

inline dimension_type
CO_Tree::tree_iterator::index() const {
  return tree.indexes[i];
}

inline dimension_type
CO_Tree::tree_iterator::dfs_index() const {
  return i;
}

inline dimension_type
CO_Tree::tree_iterator::get_offset() const {
  return offset;
}

inline CO_Tree::height_t
CO_Tree::tree_iterator::depth() const {
  return integer_log2((tree.reserved_size + 1) / offset);
}

inline void
swap(CO_Tree& x, CO_Tree& y) {
  x.m_swap(y);
}

inline void
swap(CO_Tree::const_iterator& x, CO_Tree::const_iterator& y) {
  x.m_swap(y);
}

inline void
swap(CO_Tree::iterator& x, CO_Tree::iterator& y) {
  x.m_swap(y);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/CO_Tree_templates.hh line 1. */
/* CO_Tree class implementation: non-inline template functions.
*/


namespace Parma_Polyhedra_Library {

template <typename Iterator>
CO_Tree::CO_Tree(Iterator i, dimension_type n) {

  if (n == 0) {
    init(0);
    PPL_ASSERT(OK());
    return;
  }

  const dimension_type new_max_depth = integer_log2(n) + 1;
  reserved_size = (static_cast<dimension_type>(1) << new_max_depth) - 1;

  if (is_greater_than_ratio(n, reserved_size, max_density_percent)
      && reserved_size != 3) {
    reserved_size = reserved_size*2 + 1;
  }

  init(reserved_size);

  tree_iterator root(*this);

  // This is static and with static allocation, to improve performance.
  // sizeof_to_bits(sizeof(dimension_type)) is the maximum k such that
  // 2^k-1 is a dimension_type, so it is the maximum tree height.
  // For each node level, the stack may contain up to 4 elements: two elements
  // with operation 0, one element with operation 2 and one element
  // with operation 3. An additional element with operation 1 can be at the
  // top of the tree.
  static std::pair<dimension_type, signed char>
    stack[4U * sizeof_to_bits(sizeof(dimension_type)) + 1U];

  dimension_type stack_first_empty = 0;

  // A pair (n, operation) in the stack means:
  //
  // * Go to the parent, if operation is 0.
  // * Go to the left child, then fill the current tree with n elements, if
  //   operation is 1.
  // * Go to the right child, then fill the current tree with n elements, if
  //   operation is 2.
  // * Fill the current tree with n elements, if operation is 3.

  stack[0].first = n;
  stack[0].second = 3;
  ++stack_first_empty;

  while (stack_first_empty != 0) {

    // Implement
    //
    // <CODE>
    //   top_n         = stack.top().first;
    //   top_operation = stack.top().second;
    // </CODE>
    const dimension_type top_n = stack[stack_first_empty - 1].first;
    const signed char top_operation = stack[stack_first_empty - 1].second;

    switch (top_operation) {

    case 0:
      root.get_parent();
      --stack_first_empty;
      continue;

    case 1:
      root.get_left_child();
      break;

    case 2:
      root.get_right_child();
      break;
#ifndef NDEBUG
    case 3:
      break;

    default:
      // We should not be here
      PPL_UNREACHABLE;
#endif
    }

    // We now visit the current tree

    if (top_n == 0) {
      --stack_first_empty;
    }
    else {
      if (top_n == 1) {
        PPL_ASSERT(root.index() == unused_index);
        root.index() = i.index();
        new(&(*root)) data_type(*i);
        ++i;
        --stack_first_empty;
      }
      else {
        PPL_ASSERT(stack_first_empty + 3 < sizeof(stack)/sizeof(stack[0]));

        const dimension_type half = (top_n + 1) / 2;
        stack[stack_first_empty - 1].second = 0;
        stack[stack_first_empty    ] = std::make_pair(top_n - half, 2);
        stack[stack_first_empty + 1] = std::make_pair(1, 3);
        stack[stack_first_empty + 2].second = 0;
        stack[stack_first_empty + 3] = std::make_pair(half - 1, 1);
        stack_first_empty += 4;
      }
    }
  }
  size_ = n;
  PPL_ASSERT(OK());
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/CO_Tree_defs.hh line 1559. */

/* Automatically generated from PPL source file ../src/Sparse_Row_defs.hh line 32. */

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! A finite sparse sequence of coefficients.
/*! \ingroup PPL_CXX_interface
  This class is implemented using a CO_Tree. See the documentation of CO_Tree
  for details on the implementation and the performance.

  This class is a drop-in replacement of Dense_Row, meaning that code
  using Dense_Row can be ported to Sparse_Row changing only the type.
  The resulting code will work, but probably needs more CPU and memory (it
  does not exploit the sparse representation yet).

  To take advantage of the sparse representation, the client code must then be
  modified to use methods which can have a faster implementation on sparse
  data structures.

  The main changes are the replacement of calls to operator[] with calls to
  find(), lower_bound() or insert(), using hint iterators when possible.
  Sequential scanning of rows should probably be implemented using iterators
  rather than indexes, to improve performance.
  reset() should be called to zero elements.

  \see Sparse_Matrix
  \see CO_Tree
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
class Parma_Polyhedra_Library::Sparse_Row {

public:

  //! An %iterator on the row elements
  /*!
    This %iterator skips non-stored zeroes.
    \see CO_Tree::iterator
  */
  typedef CO_Tree::iterator iterator;

  //! A const %iterator on the row elements
  /*!
    This %iterator skips non-stored zeroes.
    \see CO_Tree::const_iterator
  */
  typedef CO_Tree::const_iterator const_iterator;

  //! Constructs a row with the specified size.
  /*!
    \param n
    The size for the new row.

    The row will contain only non-stored zeroes.

    This constructor takes \f$O(1)\f$ time.
  */
  explicit Sparse_Row(dimension_type n = 0);

  //! Constructs a row with the specified size.
  /*!
    \param n
    The size for the new row.

    \param capacity
    It is ignored. This parameter is needed for compatibility with Dense_Row.

    The row will contain only non-stored zeroes.

    This constructor takes \f$O(1)\f$ time.
  */
  Sparse_Row(dimension_type n, dimension_type capacity);

  //! Copy constructor with specified capacity.
  /*!
    It is assumed that \p capacity is greater than or equal to
    the size of \p y.
  */
  Sparse_Row(const Sparse_Row& y, dimension_type capacity);

  //! Copy constructor with specified size and capacity.
  /*!
    It is assumed that \p sz is less than or equal to \p capacity.
  */
  Sparse_Row(const Sparse_Row& y, dimension_type sz, dimension_type capacity);

  //! Constructor from a Dense_Row.
  /*!
    \param row
    The row that will be copied into *this.

    This constructor takes \f$O(n)\f$ time. Note that constructing of a row of
    zeroes and then inserting n elements costs \f$O(n*\log^2 n)\f$ time.
  */
  explicit Sparse_Row(const Dense_Row& row);

  //! Copy constructor from a Dense_Row with specified size and capacity.
  /*!
    It is assumed that \p sz is less than or equal to \p capacity.
  */
  Sparse_Row(const Dense_Row& y, dimension_type sz, dimension_type capacity);

  Sparse_Row& operator=(const Dense_Row& row);

  //! Swaps *this and x.
  /*!
    \param x
    The row that will be swapped with *this.

    This method takes \f$O(1)\f$ time.
  */
  void m_swap(Sparse_Row& x);

  //! Returns the size of the row.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  dimension_type size() const;

  //! Returns the number of elements explicitly stored in the row.
  /*!
    This is equivalent to std::distance(begin(), end()), but it's much faster.

    This method takes \f$O(1)\f$ time.
  */
  dimension_type num_stored_elements() const;

  //! Resizes the row to the specified size.
  /*!
    \param n
    The new size for the row.

    This method takes \f$O(k*\log^2 n)\f$ amortized time when shrinking the
    row and removing the trailing k elements.
    It takes \f$O(1)\f$ time when enlarging the row.
  */
  void resize(dimension_type n);

  //! Resizes the row to size \p n.
  /*!
    \param n
    The new size for the row.

    This method, with this signature, is needed for compatibility with
    Dense_Row.

    This method takes \f$O(1)\f$ time.
  */
  void expand_within_capacity(dimension_type n);

  //! Resizes the row to size \p n.
  /*!
    \param n
    The new size for the row.

    This method, with this signature, is needed for compatibility with
    Dense_Row.

    This method takes \f$O(k*\log^2 n)\f$ amortized time where k is the number
    of removed elements.
  */
  void shrink(dimension_type n);

  /*!
    \brief Deletes the i-th element from the row, shifting the next elements
           to the left.

    \param i
    The index of the element that will be deleted.

    The size of the row is decreased by 1.

    This operation invalidates existing iterators.

    This method takes \f$O(k+\log^2 n)\f$ amortized time, where k is the
    number of elements with index greater than i.
  */
  void delete_element_and_shift(dimension_type i);

  //! Adds \p n zeroes before index \p i.
  /*!
    \param n
    The number of non-stored zeroes that will be added to the row.

    \param i
    The index of the element before which the zeroes will be added.

    Existing elements with index greater than or equal to \p i are shifted to
    the right by \p n positions. The size is increased by \p n.

    Existing iterators are not invalidated, but are shifted to the right
    by \p n if they pointed at or after index \p i (i.e., they point to
    the same, possibly shifted, values as before).

    This method takes \f$O(k + \log m)\f$ expected time, where \f$k\f$ is
    the number of elements with index greater than or equal to \p i and
    \f$m\f$ the number of stored elements.
  */
  void add_zeroes_and_shift(dimension_type n, dimension_type i);

  //! Returns an %iterator that points at the first stored element.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  iterator begin();

  //! Returns an %iterator that points after the last stored element.
  /*!
    This method always returns a reference to the same internal %iterator,
    that is kept valid.
    Client code can keep a const reference to that %iterator instead of
    keep updating a local %iterator.

    This method takes \f$O(1)\f$ time.
  */
  const iterator& end();

  //! Equivalent to <CODE>cbegin()</CODE>.
  const_iterator begin() const;

  //! Equivalent to <CODE>cend()</CODE>.
  const const_iterator& end() const;

  //! Returns an %iterator that points at the first element.
  /*!
    This method takes \f$O(1)\f$ time.
  */
  const_iterator cbegin() const;

  //! Returns an %iterator that points after the last element.
  /*!
    This method always returns a reference to the same internal %iterator,
    that is updated at each operation that modifies the structure.
    Client code can keep a const reference to that %iterator instead of
    keep updating a local %iterator.

    This method takes \f$O(1)\f$ time.
  */
  const const_iterator& cend() const;

  //! Returns the size() of the largest possible Sparse_Row.
  static dimension_type max_size();

  //! Resets all the elements of this row.
  /*!
    This method takes \f$O(n)\f$ time.
  */
  void clear();

  //! Gets a reference to the i-th element.
  /*!
    \param i
    The index of the desired element.

    For read-only access it's better to use get(), that avoids allocating
    space for zeroes.

    If possible, use the insert(), find() or lower_bound() methods with
    a hint instead of this, to improve performance.

    This operation invalidates existing iterators.

    This method takes \f$O(\log n)\f$ amortized time when there is already an
    element with index \p i, and \f$O(\log^2 n)\f$ otherwise.
  */
  Coefficient& operator[](dimension_type i);

  //! Equivalent to <CODE>get(i)</CODE>, provided for convenience.
  /*!
    This method takes \f$O(\log n)\f$ time.
  */
  Coefficient_traits::const_reference operator[](dimension_type i) const;

  //! Gets the i-th element in the sequence.
  /*!
    \param i
    The index of the desired element.

    If possible, use the insert(), find() or lower_bound() methods with
    a hint instead of this, to improve performance.

    This method takes \f$O(\log n)\f$ time.
  */
  Coefficient_traits::const_reference get(dimension_type i) const;

  //! Looks for an element with index i.
  /*!
    \param i
    The index of the desired element.

    If possible, use the find() method that takes a hint %iterator, to improve
    performance.

    This method takes \f$O(\log n)\f$ time.
  */
  iterator find(dimension_type i);

  //! Looks for an element with index i.
  /*!
    \param i
    The index of the desired element.

    \param itr
    It is used as a hint. This method will be faster if the searched element
    is near to \p itr.

    The value of \p itr does not affect the result of this method, as long it
    is a valid %iterator for this row. \p itr may even be end().

    This method takes \f$O(\log n)\f$ time.
    If the distance between \p itr and the searched position is \f$O(1)\f$,
    this method takes \f$O(1)\f$ time.
  */
  iterator find(iterator itr, dimension_type i);

  //! Looks for an element with index i.
  /*!
    \param i
    The index of the desired element.

    If possible, use the find() method that takes a hint %iterator, to improve
    performance.

    This method takes \f$O(\log n)\f$ time.
  */
  const_iterator find(dimension_type i) const;

  //! Looks for an element with index i.
  /*!
    \param i
    The index of the desired element.

    \param itr
    It is used as a hint. This method will be faster if the searched element
    is near to \p itr.

    The value of \p itr does not affect the result of this method, as long it
    is a valid %iterator for this row. \p itr may even be end().

    This method takes \f$O(\log n)\f$ time.
    If the distance between \p itr and the searched position is \f$O(1)\f$,
    this method takes \f$O(1)\f$ time.
  */
  const_iterator find(const_iterator itr, dimension_type i) const;

  //! Lower bound of index i.
  /*!
    \param i
    The index of the desired element.

    \returns an %iterator to the first element with index greater than or
             equal to i.
             If there are no such elements, returns end().

    If possible, use the find() method that takes a hint %iterator, to improve
    performance.

    This method takes \f$O(\log n)\f$ time.
  */
  iterator lower_bound(dimension_type i);

  //! Lower bound of index i.
  /*!
    \param i
    The index of the desired element.

    \param itr
    It is used as a hint. This method will be faster if the searched element
    is near to \p itr.

    \returns an %iterator to the first element with index greater than or
             equal to i.
             If there are no such elements, returns end().

    The value of \p itr does not affect the result of this method, as long it
    is a valid %iterator for this row. \p itr may even be end().

    This method takes \f$O(\log n)\f$ time.
    If the distance between \p itr and the searched position is \f$O(1)\f$,
    this method takes \f$O(1)\f$ time.
  */
  iterator lower_bound(iterator itr, dimension_type i);

  //! Lower bound of index i.
  /*!

    \param i
    The index of the desired element.

    \returns an %iterator to the first element with index greater than or
             equal to i.
             If there are no such elements, returns end().

    If possible, use the find() method that takes a hint %iterator, to improve
    performance.

    This method takes \f$O(\log n)\f$ time.
  */
  const_iterator lower_bound(dimension_type i) const;

  //! Lower bound of index i.
  /*!
    \param i
    The index of the desired element.

    \param itr
    It is used as a hint. This method will be faster if the searched element
    is near to \p itr.

    \returns an %iterator to the first element with index greater than or
             equal to i.
             If there are no such elements, returns end().

    The value of \p itr does not affect the result of this method, as long it
    is a valid %iterator for this row. \p itr may even be end().

    This method takes \f$O(\log n)\f$ time.
    If the distance between \p itr and the searched position is \f$O(1)\f$,
    this method takes \f$O(1)\f$ time.
  */
  const_iterator lower_bound(const_iterator itr, dimension_type i) const;

  //! Equivalent to <CODE>(*this)[i] = x; find(i)</CODE>, but faster.
  /*!
    \param i
    The index of the desired element.

    \param x
    The value that will be associated to the element.

    If possible, use versions of this method that take a hint, to improve
    performance.

    This operation invalidates existing iterators.

    This method takes \f$O(\log^2 n)\f$ amortized time.
  */
  iterator insert(dimension_type i, Coefficient_traits::const_reference x);

  //! Equivalent to <CODE>(*this)[i] = x; find(i)</CODE>, but faster.
  /*!
    \param i
    The index of the desired element.

    \param x
    The value that will be associated to the element.

    \param itr
    It is used as a hint. This method will be faster if the searched element
    is near to \p itr, even faster than <CODE>(*this)[i] = x</CODE>.

    The value of \p itr does not affect the result of this method, as long it
    is a valid %iterator for this row. \p itr may even be end().

    This operation invalidates existing iterators.

    This method takes \f$O(\log^2 n)\f$ amortized time. If the distance
    between \p itr and the searched position is \f$O(1)\f$ and the row already
    contains an element with this index, this method takes \f$O(1)\f$ time.
  */
  iterator insert(iterator itr, dimension_type i,
                  Coefficient_traits::const_reference x);

  //! Equivalent to <CODE>(*this)[i]; find(i)</CODE>, but faster.
  /*!
    \param i
    The index of the desired element.

    If possible, use versions of this method that take a hint, to improve
    performance.

    This operation invalidates existing iterators.

    This method takes \f$O(\log^2 n)\f$ amortized time.
  */
  iterator insert(dimension_type i);

  //! Equivalent to <CODE>(*this)[i]; find(i)</CODE>, but faster.
  /*!
    \param i
    The index of the desired element.

    \param itr
    It is used as a hint. This method will be faster if the searched element
    is near to \p itr, even faster than <CODE>(*this)[i]</CODE>.

    The value of \p itr does not affect the result of this method, as long it
    is a valid %iterator for this row. \p itr may even be end().

    This operation invalidates existing iterators.

    This method takes \f$O(\log^2 n)\f$ amortized time. If the distance
    between \p itr and the searched position is \f$O(1)\f$ and the row already
    contains an element with this index, this method takes \f$O(1)\f$ time.
  */
  iterator insert(iterator itr, dimension_type i);

  //! Swaps the i-th element with the j-th element.
  /*!
    \param i
    The index of an element.

    \param j
    The index of another element.

    This operation invalidates existing iterators.

    This method takes \f$O(\log^2 n)\f$ amortized time.
  */
  void swap_coefficients(dimension_type i, dimension_type j);

  //! Equivalent to swap(i,itr.index()), but it assumes that
  //! lower_bound(i)==itr.
  /*!
    Iterators that pointed to the itr.index()-th element remain valid
    but now point to the i-th element. Other iterators are unaffected.

    This method takes \f$O(1)\f$ time.
  */
  void fast_swap(dimension_type i, iterator itr);

  //! Swaps the element pointed to by i with the element pointed to by j.
  /*!
    \param i
    An %iterator pointing to an element.

    \param j
    An %iterator pointing to another element.

    This method takes \f$O(1)\f$ time.
  */
  void swap_coefficients(iterator i, iterator j);

  //! Resets to zero the value pointed to by i.
  /*!
    \param i
    An %iterator pointing to the element that will be reset (not stored
    anymore).

    By calling this method instead of getting a reference to the value and
    setting it to zero, the element will no longer be stored.

    This operation invalidates existing iterators.

    This method takes \f$O(\log^2 n)\f$ amortized time.
  */
  iterator reset(iterator i);

  //! Resets to zero the values in the range [first,last).
  /*!
    \param first
    An %iterator pointing to the first element to reset.

    \param last
    An %iterator pointing after the last element to reset.

    By calling this method instead of getting a reference to the values and
    setting them to zero, the elements will no longer be stored.

    This operation invalidates existing iterators.

    This method takes \f$O(k*\log^2 n)\f$ amortized time, where k is the
    number of elements in [first,last).
  */
  iterator reset(iterator first, iterator last);

  //! Resets to zero the i-th element.
  /*!
    \param i
    The index of the element to reset.

    By calling this method instead of getting a reference to the value and
    setting it to zero, the element will no longer be stored.

    This operation invalidates existing iterators.

    This method takes \f$O(\log^2 n)\f$ amortized time.
  */
  void reset(dimension_type i);

  //! Resets to zero the elements with index greater than or equal to i.
  /*!
    \param i
    The index of the first element to reset.

    By calling this method instead of getting a reference to the values and
    setting them to zero, the elements will no longer be stored.

    This operation invalidates existing iterators.

    This method takes \f$O(k*\log^2 n)\f$ amortized time, where k is the
    number of elements with index greater than or equal to i.
  */
  void reset_after(dimension_type i);

  //! Normalizes the modulo of coefficients so that they are mutually prime.
  /*!
    Computes the Greatest Common Divisor (GCD) among the elements of the row
    and normalizes them by the GCD itself.

    This method takes \f$O(n)\f$ time.
  */
  void normalize();

  //! Calls g(x[i],y[i]), for each i.
  /*!
    \param y
    The row that will be combined with *this.

    \param f
    A functor that should take a Coefficient&.
    f(c1) must be equivalent to g(c1, 0).

    \param g
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    g(c1, c2) must do nothing when c1 is zero.

    This method takes \f$O(n*\log^2 n)\f$ time.

    \note
    The functors will only be called when necessary, assuming the requested
    properties hold.

    \see combine_needs_second
    \see combine
  */
  template <typename Func1, typename Func2>
  void combine_needs_first(const Sparse_Row& y,
                           const Func1& f, const Func2& g);

  //! Calls g(x[i],y[i]), for each i.
  /*!
    \param y
    The row that will be combined with *this.

    \param g
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    g(c1, 0) must do nothing, for every c1.

    \param h
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    h(c1, c2) must be equivalent to g(c1, c2) when c1 is zero.

    This method takes \f$O(n*\log^2 n)\f$ time.

    \note
    The functors will only be called when necessary, assuming the requested
    properties hold.

    \see combine_needs_first
    \see combine
  */
  template <typename Func1, typename Func2>
  void combine_needs_second(const Sparse_Row& y,
                            const Func1& g, const Func2& h);

  //! Calls g(x[i],y[i]), for each i.
  /*!
    \param y
    The row that will be combined with *this.

    \param f
    A functor that should take a Coefficient&.
    f(c1) must be equivalent to g(c1, 0).

    \param g
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    g(c1, c2) must do nothing when both c1 and c2 are zero.

    \param h
    A functor that should take a Coefficient& and a
    Coefficient_traits::const_reference.
    h(c1, c2) must be equivalent to g(c1, c2) when c1 is zero.

    This method takes \f$O(n*\log^2 n)\f$ time.

    \note
    The functors will only be called when necessary, assuming the requested
    properties hold.

    \see combine_needs_first
    \see combine_needs_second
  */
  template <typename Func1, typename Func2, typename Func3>
  void combine(const Sparse_Row& y,
               const Func1& f, const Func2& g, const Func3& h);

  //! Executes <CODE>(*this)[i] = (*this)[i]*coeff1 + y[i]*coeff2</CODE>, for
  //! each i.
  /*!
    \param y
    The row that will be combined with *this.

    \param coeff1
    The coefficient used for elements of *this.
    This must not be 0.

    \param coeff2
    The coefficient used for elements of y.
    This must not be 0.

    This method takes \f$O(n*\log^2 n)\f$ time.

    \note
    The functors will only be called when necessary.
    This method can be implemented in user code, too. It is provided for
    convenience only.

    \see combine_needs_first
    \see combine_needs_second
    \see combine
  */
  void linear_combine(const Sparse_Row& y,
                      Coefficient_traits::const_reference coeff1,
                      Coefficient_traits::const_reference coeff2);

  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end).
  /*!
    This method, unlike the other linear_combine() method, detects when
    coeff1==1 and/or coeff2==1 or coeff2==-1 in order to save some work.
  */
  void linear_combine(const Sparse_Row& y,
                      Coefficient_traits::const_reference c1,
                      Coefficient_traits::const_reference c2,
                      dimension_type start, dimension_type end);

  PPL_OUTPUT_DECLARATIONS

  //! Loads the row from an ASCII representation generated using ascii_dump().
  /*!
    \param s
    The stream from which the ASCII representation will be loaded.
  */
  bool ascii_load(std::istream& s);

  //! Returns the size in bytes of the memory managed by \p *this.
  /*!
    This method takes \f$O(n)\f$ time.
  */
  memory_size_type external_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  /*!
    This method is provided for compatibility with Dense_Row.

    This method takes \f$O(n)\f$ time.

    \param capacity
    This parameter is ignored.
  */
  memory_size_type external_memory_in_bytes(dimension_type capacity) const;

  //! Returns the size in bytes of the memory managed by \p *this.
  /*!
    This method takes \f$O(n)\f$ time.
  */
  memory_size_type total_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  /*!
    This method is provided for compatibility with Dense_Row.

    This method takes \f$O(n)\f$ time.

    \param capacity
    This parameter is ignored.
  */
  memory_size_type total_memory_in_bytes(dimension_type capacity) const;

  //! Checks the invariant.
  bool OK() const;

  //! Checks the invariant.
  /*!
    This method is provided for compatibility with Dense_Row.

    \param capacity
    This parameter is ignored.
  */
  bool OK(dimension_type capacity) const;

private:
  //! The tree used to store the elements.
  CO_Tree tree;

  //! The size of the row.
  /*!
    The elements contained in this row have indexes that are less than size_.
  */
  dimension_type size_;
};


namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Swaps \p x with \p y.
/*! \relates Sparse_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void swap(Parma_Polyhedra_Library::Sparse_Row& x,
          Parma_Polyhedra_Library::Sparse_Row& y);

void swap(Parma_Polyhedra_Library::Sparse_Row& x,
          Parma_Polyhedra_Library::Dense_Row& y);

void swap(Parma_Polyhedra_Library::Dense_Row& x,
          Parma_Polyhedra_Library::Sparse_Row& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns <CODE>true</CODE> if and only if \p x and \p y are equal.
/*! \relates Sparse_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
bool operator==(const Sparse_Row& x, const Sparse_Row& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns <CODE>true</CODE> if and only if \p x and \p y are different.
/*! \relates Sparse_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
bool operator!=(const Sparse_Row& x, const Sparse_Row& y);

bool operator==(const Dense_Row& x, const Sparse_Row& y);
bool operator!=(const Dense_Row& x, const Sparse_Row& y);

bool operator==(const Sparse_Row& x, const Dense_Row& y);
bool operator!=(const Sparse_Row& x, const Dense_Row& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Equivalent to <CODE>x[i] = x[i] * c1 + y[i] * c2</CODE>,
//! for each i in [start, end).
/*! \relates Sparse_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void linear_combine(Sparse_Row& x, const Dense_Row& y,
                    Coefficient_traits::const_reference coeff1,
                    Coefficient_traits::const_reference coeff2);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Equivalent to <CODE>x[i] = x[i] * c1 + y[i] * c2</CODE>,
//! for each i in [start, end).
/*! \relates Sparse_Row
  This function detects when coeff1==1 and/or coeff2==1 or coeff2==-1 in
  order to save some work.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void linear_combine(Sparse_Row& x, const Dense_Row& y,
                    Coefficient_traits::const_reference c1,
                    Coefficient_traits::const_reference c2,
                    dimension_type start, dimension_type end);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Equivalent to <CODE>x[i] = x[i] * c1 + y[i] * c2</CODE>,
//! for each i in [start, end).
/*! \relates Sparse_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void linear_combine(Dense_Row& x, const Sparse_Row& y,
                    Coefficient_traits::const_reference coeff1,
                    Coefficient_traits::const_reference coeff2);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Equivalent to <CODE>x[i] = x[i] * c1 + y[i] * c2</CODE>,
//! for each i in [start, end).
/*! \relates Sparse_Row
  This function detects when coeff1==1 and/or coeff2==1 or coeff2==-1 in
  order to save some work.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void linear_combine(Dense_Row& x, const Sparse_Row& y,
                    Coefficient_traits::const_reference c1,
                    Coefficient_traits::const_reference c2,
                    dimension_type start, dimension_type end);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Equivalent to <CODE>x[i] = x[i] * c1 + y[i] * c2</CODE>,
//! for each i in [start, end).
/*! \relates Sparse_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void linear_combine(Sparse_Row& x, const Sparse_Row& y,
                    Coefficient_traits::const_reference coeff1,
                    Coefficient_traits::const_reference coeff2);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Equivalent to <CODE>x[i] = x[i] * c1 + y[i] * c2</CODE>,
//! for each i in [start, end).
/*! \relates Sparse_Row
  This function detects when coeff1==1 and/or coeff2==1 or coeff2==-1 in
  order to save some work.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
void linear_combine(Sparse_Row& x, const Sparse_Row& y,
                    Coefficient_traits::const_reference c1,
                    Coefficient_traits::const_reference c2,
                    dimension_type start, dimension_type end);

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Sparse_Row_inlines.hh line 1. */
/* Sparse_Row class implementation: inline functions.
*/


#include <algorithm>

namespace Parma_Polyhedra_Library {

inline
Sparse_Row::Sparse_Row(dimension_type n)
  : size_(n) {
  PPL_ASSERT(OK());
}

inline
Sparse_Row::Sparse_Row(dimension_type n, dimension_type)
  : size_(n) {
  PPL_ASSERT(OK());
}

inline
Sparse_Row::Sparse_Row(const Sparse_Row& y, dimension_type)
  : tree(y.tree), size_(y.size_) {
}

inline
Sparse_Row::Sparse_Row(const Sparse_Row& y, dimension_type sz, dimension_type)
  : tree(y.begin(),
         std::distance(y.begin(), y.lower_bound(std::min(y.size(), sz)))),
    size_(sz) {
  PPL_ASSERT(OK());
}

inline void
Sparse_Row::m_swap(Sparse_Row& x) {
  using std::swap;
  swap(tree, x.tree);
  swap(size_, x.size_);
  PPL_ASSERT(OK());
  PPL_ASSERT(x.OK());
}

inline dimension_type
Sparse_Row::size() const {
  return size_;
}

inline dimension_type
Sparse_Row::num_stored_elements() const {
  return tree.size();
}

inline void
Sparse_Row::resize(dimension_type n) {
  if (n < size_) {
    reset_after(n);
  }
  size_ = n;
  PPL_ASSERT(OK());
}

inline void
Sparse_Row::shrink(dimension_type n) {
  PPL_ASSERT(size() >= n);
  resize(n);
}

inline void
Sparse_Row::expand_within_capacity(dimension_type n) {
  PPL_ASSERT(size() <= n);
  resize(n);
}

inline void
Sparse_Row::delete_element_and_shift(dimension_type i) {
  PPL_ASSERT(i < size_);
  tree.erase_element_and_shift_left(i);
  --size_;
  PPL_ASSERT(OK());
}

inline void
Sparse_Row::add_zeroes_and_shift(dimension_type n, dimension_type i) {
  PPL_ASSERT(i <= size_);
  tree.increase_keys_from(i, n);
  size_ += n;
  PPL_ASSERT(OK());
}

inline Sparse_Row::iterator
Sparse_Row::begin() {
  return tree.begin();
}

inline const Sparse_Row::iterator&
Sparse_Row::end() {
  return tree.end();
}

inline Sparse_Row::const_iterator
Sparse_Row::begin() const {
  return tree.cbegin();
}

inline const Sparse_Row::const_iterator&
Sparse_Row::end() const {
  return tree.cend();
}

inline Sparse_Row::const_iterator
Sparse_Row::cbegin() const {
  return tree.cbegin();
}

inline const Sparse_Row::const_iterator&
Sparse_Row::cend() const {
  return tree.cend();
}

inline dimension_type
Sparse_Row::max_size() {
  return CO_Tree::max_size();
}

inline void
Sparse_Row::clear() {
  tree.clear();
}

inline Coefficient&
Sparse_Row::operator[](dimension_type i) {
  PPL_ASSERT(i < size_);
  iterator itr = insert(i);
  return *itr;
}

inline Coefficient_traits::const_reference
Sparse_Row::operator[](dimension_type i) const {
  return get(i);
}

inline Coefficient_traits::const_reference
Sparse_Row::get(dimension_type i) const {
  PPL_ASSERT(i < size_);
  if (tree.empty()) {
    return Coefficient_zero();
  }
  const_iterator itr = find(i);
  if (itr != end()) {
    return *itr;
  }
  else {
    return Coefficient_zero();
  }
}

inline Sparse_Row::iterator
Sparse_Row::find(dimension_type i) {
  PPL_ASSERT(i < size());

  iterator itr = tree.bisect(i);

  if (itr != end() && itr.index() == i) {
    return itr;
  }
  return end();
}

inline Sparse_Row::iterator
Sparse_Row::find(iterator hint, dimension_type i) {
  PPL_ASSERT(i < size());

  iterator itr = tree.bisect_near(hint, i);

  if (itr != end() && itr.index() == i) {
    return itr;
  }
  return end();
}

inline Sparse_Row::const_iterator
Sparse_Row::find(dimension_type i) const {
  PPL_ASSERT(i < size());

  const_iterator itr = tree.bisect(i);

  if (itr != end() && itr.index() == i) {
    return itr;
  }

  return end();
}

inline Sparse_Row::const_iterator
Sparse_Row::find(const_iterator hint, dimension_type i) const {
  PPL_ASSERT(i < size());

  const_iterator itr = tree.bisect_near(hint, i);

  if (itr != end() && itr.index() == i) {
    return itr;
  }
  return end();
}

inline Sparse_Row::iterator
Sparse_Row::lower_bound(dimension_type i) {
  PPL_ASSERT(i <= size());

  iterator itr = tree.bisect(i);

  if (itr == end()) {
    return end();
  }

  if (itr.index() < i) {
    ++itr;
  }

  PPL_ASSERT(itr == end() || itr.index() >= i);

  return itr;
}

inline Sparse_Row::iterator
Sparse_Row::lower_bound(iterator hint, dimension_type i) {
  PPL_ASSERT(i <= size());

  iterator itr = tree.bisect_near(hint, i);

  if (itr == end()) {
    return end();
  }

  if (itr.index() < i) {
    ++itr;
  }

  PPL_ASSERT(itr == end() || itr.index() >= i);

  return itr;
}

inline Sparse_Row::const_iterator
Sparse_Row::lower_bound(dimension_type i) const {
  PPL_ASSERT(i <= size());

  const_iterator itr = tree.bisect(i);

  if (itr == end()) {
    return end();
  }

  if (itr.index() < i) {
    ++itr;
  }

  PPL_ASSERT(itr == end() || itr.index() >= i);

  return itr;
}

inline Sparse_Row::const_iterator
Sparse_Row::lower_bound(const_iterator hint, dimension_type i) const {
  PPL_ASSERT(i <= size());

  const_iterator itr = tree.bisect_near(hint, i);

  if (itr == end()) {
    return end();
  }

  if (itr.index() < i) {
    ++itr;
  }

  PPL_ASSERT(itr == end() || itr.index() >= i);

  return itr;
}

inline Sparse_Row::iterator
Sparse_Row::insert(dimension_type i, Coefficient_traits::const_reference x) {
  PPL_ASSERT(i < size_);
  return tree.insert(i, x);
}

inline Sparse_Row::iterator
Sparse_Row::insert(iterator itr, dimension_type i,
                   Coefficient_traits::const_reference x) {
  PPL_ASSERT(i < size_);
  return tree.insert(itr, i, x);
}

inline Sparse_Row::iterator
Sparse_Row::insert(dimension_type i) {
  PPL_ASSERT(i < size_);
  return tree.insert(i);
}

inline Sparse_Row::iterator
Sparse_Row::insert(iterator itr, dimension_type i) {
  PPL_ASSERT(i < size_);
  return tree.insert(itr, i);
}

inline void
Sparse_Row::swap_coefficients(iterator i, iterator j) {
  PPL_ASSERT(i != end());
  PPL_ASSERT(j != end());
  using std::swap;
  swap(*i, *j);
  PPL_ASSERT(OK());
}

inline void
Sparse_Row::fast_swap(dimension_type i, iterator itr) {
  PPL_ASSERT(lower_bound(i) == itr);
  PPL_ASSERT(itr != end());
  tree.fast_shift(i, itr);
  PPL_ASSERT(OK());
}

inline Sparse_Row::iterator
Sparse_Row::reset(iterator i) {
  iterator res = tree.erase(i);
  PPL_ASSERT(OK());
  return res;
}

inline void
Sparse_Row::reset(dimension_type i) {
  PPL_ASSERT(i < size());

  tree.erase(i);
  PPL_ASSERT(OK());
}

inline memory_size_type
Sparse_Row::external_memory_in_bytes() const {
  return tree.external_memory_in_bytes();
}

inline memory_size_type
Sparse_Row::external_memory_in_bytes(dimension_type /* capacity */) const {
  return external_memory_in_bytes();
}

inline memory_size_type
Sparse_Row::total_memory_in_bytes() const {
  return external_memory_in_bytes() + sizeof(*this);
}

inline memory_size_type
Sparse_Row::total_memory_in_bytes(dimension_type /* capacity */) const {
  return total_memory_in_bytes();
}

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \relates Sparse_Row */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
inline void
swap(Sparse_Row& x, Sparse_Row& y) {
  x.m_swap(y);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Sparse_Row_templates.hh line 1. */
/* Sparse_Row class implementation: non-inline template functions.
*/


namespace Parma_Polyhedra_Library {


template <typename Func1, typename Func2>
void
Sparse_Row::combine_needs_first(const Sparse_Row& y,
                                const Func1& f, const Func2& g) {
  if (this == &y) {
    for (iterator i = begin(), i_end = end(); i != i_end; ++i) {
      g(*i, *i);
    }
  }
  else {
    iterator i = begin();
    // This is a const reference to an internal iterator, that is kept valid.
    // If we just stored a copy, that would be invalidated by the calls to
    // reset().
    const iterator& i_end = end();
    const_iterator j = y.begin();
    const_iterator j_end = y.end();
    while (i != i_end && j != j_end) {
      if (i.index() == j.index()) {
        g(*i, *j);
        if (*i == 0) {
          i = reset(i);
        }
        else {
          ++i;
        }
        ++j;
      }
      else
        if (i.index() < j.index()) {
          f(*i);
          if (*i == 0) {
            i = reset(i);
          }
          else {
            ++i;
          }
        }
        else {
          j = y.lower_bound(j, i.index());
        }
    }
    while (i != i_end) {
      f(*i);
      if (*i == 0) {
        i = reset(i);
      }
      else {
        ++i;
      }
    }
  }
}

template <typename Func1, typename Func2>
void
Sparse_Row::combine_needs_second(const Sparse_Row& y,
                                 const Func1& g,
                                 const Func2& /* h */) {
  iterator i = begin();
  for (const_iterator j = y.begin(), j_end = y.end(); j != j_end; ++j) {
    i = insert(i, j.index());
    g(*i, *j);
    if (*i == 0) {
      i = reset(i);
    }
  }
}

template <typename Func1, typename Func2, typename Func3>
void
Sparse_Row::combine(const Sparse_Row& y, const Func1& f,
                    const Func2& g, const Func3& h) {
  if (this == &y) {
    for (iterator i = begin(), i_end = end(); i != i_end; ++i) {
      g(*i, *i);
    }
  }
  else {
    iterator i = begin();
    // This is a const reference to an internal iterator, that is kept valid.
    // If we just stored a copy, that would be invalidated by the calls to
    // reset() and insert().
    const iterator& i_end = end();
    const_iterator j = y.begin();
    const_iterator j_end = y.end();
    while (i != i_end && j != j_end) {
      if (i.index() == j.index()) {
        g(*i, *j);
        if (*i == 0) {
          i = reset(i);
        }
        else {
          ++i;
        }
        ++j;
      }
      else
        if (i.index() < j.index()) {
          f(*i);
          if (*i == 0) {
            i = reset(i);
          }
          else {
            ++i;
          }
        }
        else {
          PPL_ASSERT(i.index() > j.index());
          i = insert(i, j.index());
          h(*i, *j);
          if (*i == 0) {
            i = reset(i);
          }
          else {
            ++i;
          }
          ++j;
        }
    }
    PPL_ASSERT(i == i_end || j == j_end);
    while (i != i_end) {
      f(*i);
      if (*i == 0) {
        i = reset(i);
      }
      else {
        ++i;
      }
    }
    while (j != j_end) {
      i = insert(i, j.index());
      h(*i, *j);
      if (*i == 0) {
        i = reset(i);
      }
      ++j;
    }
  }
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Sparse_Row_defs.hh line 929. */

/* Automatically generated from PPL source file ../src/Linear_Expression_Impl_defs.hh line 34. */
#include <cstddef>

namespace Parma_Polyhedra_Library {

namespace IO_Operators {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Output operator.
/*! \relates Parma_Polyhedra_Library::Linear_Expression_Impl */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Row>
std::ostream&
operator<<(std::ostream& s, const Linear_Expression_Impl<Row>& e);

} // namespace IO_Operators

} // namespace Parma_Polyhedra_Library

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! A linear expression.
/*! \ingroup PPL_CXX_interface
  An object of the class Linear_Expression_Impl represents the linear
  expression
  \f[
    \sum_{i=0}^{n-1} a_i x_i + b
  \f]
  where \f$n\f$ is the dimension of the vector space,
  each \f$a_i\f$ is the integer coefficient
  of the \f$i\f$-th variable \f$x_i\f$
  and \f$b\f$ is the integer for the inhomogeneous term.

  \par How to build a linear expression.

  Linear expressions are the basic blocks for defining
  both constraints (i.e., linear equalities or inequalities)
  and generators (i.e., lines, rays, points and closure points).
  A full set of functions is defined to provide a convenient interface
  for building complex linear expressions starting from simpler ones
  and from objects of the classes Variable and Coefficient:
  available operators include unary negation,
  binary addition and subtraction,
  as well as multiplication by a Coefficient.
  The space dimension of a linear expression is defined as the maximum
  space dimension of the arguments used to build it:
  in particular, the space dimension of a Variable <CODE>x</CODE>
  is defined as <CODE>x.id()+1</CODE>,
  whereas all the objects of the class Coefficient have space dimension zero.

  \par Example
  The following code builds the linear expression \f$4x - 2y - z + 14\f$,
  having space dimension \f$3\f$:
  \code
  Linear_Expression_Impl e = 4*x - 2*y - z + 14;
  \endcode
  Another way to build the same linear expression is:
  \code
  Linear_Expression_Impl e1 = 4*x;
  Linear_Expression_Impl e2 = 2*y;
  Linear_Expression_Impl e3 = z;
  Linear_Expression_Impl e = Linear_Expression_Impl(14);
  e += e1 - e2 - e3;
  \endcode
  Note that \p e1, \p e2 and \p e3 have space dimension 1, 2 and 3,
  respectively; also, in the fourth line of code, \p e is created
  with space dimension zero and then extended to space dimension 3
  in the fifth line.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename Row>
class Parma_Polyhedra_Library::Linear_Expression_Impl
  : public Linear_Expression_Interface {
public:
  //! Default constructor: returns a copy of Linear_Expression_Impl::zero().
  Linear_Expression_Impl();

  //! Ordinary copy constructor.
  Linear_Expression_Impl(const Linear_Expression_Impl& e);

  //! Copy constructor for other row types.
  template <typename Row2>
  Linear_Expression_Impl(const Linear_Expression_Impl<Row2>& e);

  //! Copy constructor from any implementation of Linear_Expression_Interface.
  Linear_Expression_Impl(const Linear_Expression_Interface& e);

  //! Destructor.
  virtual ~Linear_Expression_Impl();

  //! Checks if all the invariants are satisfied.
  virtual bool OK() const;

  /*! \brief
    Builds the linear expression corresponding
    to the inhomogeneous term \p n.
  */
  explicit Linear_Expression_Impl(Coefficient_traits::const_reference n);

  //! Builds the linear expression corresponding to the variable \p v.
  /*!
    \exception std::length_error
    Thrown if the space dimension of \p v exceeds
    <CODE>Linear_Expression_Impl::max_space_dimension()</CODE>.
  */
  Linear_Expression_Impl(Variable v);

  //! Returns the current representation of this linear expression.
  virtual Representation representation() const;

  //! An interface for const iterators on the expression (homogeneous)
  //! coefficients that are nonzero.
  /*!
    These iterators are invalidated by operations that modify the expression.
  */
  class const_iterator: public const_iterator_interface {
  public:
    explicit const_iterator(const Row& row, dimension_type i);

    //! Returns a copy of *this.
    //! This returns a pointer to dynamic-allocated memory. The caller has the
    //! duty to free the memory when it's not needed anymore.
    virtual const_iterator_interface* clone() const;

    //! Navigates to the next nonzero coefficient.
    //! Note that this method does *not* return a reference, to increase
    //! efficiency since it's virtual.
    virtual void operator++();

    //! Navigates to the previous nonzero coefficient.
    //! Note that this method does *not* return a reference, to increase
    //! efficiency since it's virtual.
    virtual void operator--();

    //! Returns the current element.
    virtual reference operator*() const;

    //! Returns the variable of the coefficient pointed to by \c *this.
    /*!
      \returns the variable of the coefficient pointed to by \c *this.
    */
    virtual Variable variable() const;

    //! Compares \p *this with x .
    /*!
      \param x
      The %iterator that will be compared with *this.
    */
    virtual bool operator==(const const_iterator_interface& x) const;

  private:

    void skip_zeroes_forward();
    void skip_zeroes_backward();

    const Row* row;
    typename Row::const_iterator itr;
  };

  //! This returns a pointer to dynamic-allocated memory. The caller has the
  //! duty to free the memory when it's not needed anymore.
  virtual const_iterator_interface* begin() const;

  //! This returns a pointer to dynamic-allocated memory. The caller has the
  //! duty to free the memory when it's not needed anymore.
  virtual const_iterator_interface* end() const;

  //! This returns a pointer to dynamic-allocated memory. The caller has the
  //! duty to free the memory when it's not needed anymore.
  //! Returns (a pointer to) an iterator that points to the first nonzero
  //! coefficient of a variable greater than or equal to v, or at end if no
  //! such coefficient exists.
  virtual const_iterator_interface* lower_bound(Variable v) const;

  //! Returns the maximum space dimension a Linear_Expression_Impl can handle.
  static dimension_type max_space_dimension();

  //! Returns the dimension of the vector space enclosing \p *this.
  virtual dimension_type space_dimension() const;

  //! Sets the dimension of the vector space enclosing \p *this to \p n .
  virtual void set_space_dimension(dimension_type n);

  //! Returns the coefficient of \p v in \p *this.
  virtual Coefficient_traits::const_reference coefficient(Variable v) const;

  //! Sets the coefficient of \p v in \p *this to \p n.
  virtual void set_coefficient(Variable v,
                               Coefficient_traits::const_reference n);

  //! Returns the inhomogeneous term of \p *this.
  virtual Coefficient_traits::const_reference inhomogeneous_term() const;

  //! Sets the inhomogeneous term of \p *this to \p n.
  virtual void set_inhomogeneous_term(Coefficient_traits::const_reference n);

  //! Linearly combines \p *this with \p y so that the coefficient of \p v
  //! is 0.
  /*!
    \param y
    The expression that will be combined with \p *this object;

    \param v
    The variable whose coefficient has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the coefficient of variable \p v equal to \f$0\f$. Then it assigns
    the resulting expression to \p *this.

    \p *this and \p y must have the same space dimension.
  */
  virtual void linear_combine(const Linear_Expression_Interface& y, Variable v);

  //! Equivalent to <CODE>*this = *this * c1 + y * c2</CODE>, but assumes that
  //! \p *this and \p y have the same space dimension.
  virtual void linear_combine(const Linear_Expression_Interface& y,
                              Coefficient_traits::const_reference c1,
                              Coefficient_traits::const_reference c2);

  //! Equivalent to <CODE>*this = *this * c1 + y * c2</CODE>.
  //! c1 and c2 may be 0.
  virtual void linear_combine_lax(const Linear_Expression_Interface& y,
                                  Coefficient_traits::const_reference c1,
                                  Coefficient_traits::const_reference c2);

  //! Swaps the coefficients of the variables \p v1 and \p v2 .
  virtual void swap_space_dimensions(Variable v1, Variable v2);

  //! Removes all the specified dimensions from the expression.
  /*!
    The space dimension of the variable with the highest space
    dimension in \p vars must be at most the space dimension
    of \p this.
  */
  virtual void remove_space_dimensions(const Variables_Set& vars);

  //! Shift by \p n positions the coefficients of variables, starting from
  //! the coefficient of \p v. This increases the space dimension by \p n.
  virtual void shift_space_dimensions(Variable v, dimension_type n);

  //! Permutes the space dimensions of the expression.
  /*!
    \param cycle
    A vector representing a cycle of the permutation according to which the
    space dimensions must be rearranged.

    The \p cycle vector represents a cycle of a permutation of space
    dimensions.
    For example, the permutation
    \f$ \{ x_1 \mapsto x_2, x_2 \mapsto x_3, x_3 \mapsto x_1 \}\f$ can be
    represented by the vector containing \f$ x_1, x_2, x_3 \f$.
  */
  virtual void permute_space_dimensions(const std::vector<Variable>& cycle);

  //! Returns <CODE>true</CODE> if and only if \p *this is \f$0\f$.
  virtual bool is_zero() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if all the homogeneous
    terms of \p *this are \f$0\f$.
  */
  virtual bool all_homogeneous_terms_are_zero() const;

  /*! \brief
    Returns a lower bound to the total size in bytes of the memory
    occupied by \p *this.
  */
  virtual memory_size_type total_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  virtual memory_size_type external_memory_in_bytes() const;

  //! Writes to \p s an ASCII representation of \p *this.
  virtual void ascii_dump(std::ostream& s) const;

  /*! \brief
    Loads from \p s an ASCII representation (as produced by
    ascii_dump(std::ostream&) const) and sets \p *this accordingly.
    Returns <CODE>true</CODE> if successful, <CODE>false</CODE> otherwise.
  */
  virtual bool ascii_load(std::istream& s);

  //! Copy constructor with a specified space dimension.
  Linear_Expression_Impl(const Linear_Expression_Interface& e,
                         dimension_type space_dim);

  //! Returns \p true if *this is equal to \p x.
  //! Note that (*this == x) has a completely different meaning.
  virtual bool is_equal_to(const Linear_Expression_Interface& x) const;

  //! Normalizes the modulo of the coefficients and of the inhomogeneous term
  //! so that they are mutually prime.
  /*!
    Computes the Greatest Common Divisor (GCD) among the coefficients
    and the inhomogeneous term and normalizes them by the GCD itself.
  */
  virtual void normalize();

  //! Ensures that the first nonzero homogeneous coefficient is positive,
  //! by negating the row if necessary.
  virtual void sign_normalize();

  /*! \brief
    Negates the elements from index \p first (included)
    to index \p last (excluded).
  */
  virtual void negate(dimension_type first, dimension_type last);

  virtual Linear_Expression_Impl&
  operator+=(Coefficient_traits::const_reference n);
  virtual Linear_Expression_Impl&
  operator-=(Coefficient_traits::const_reference n);

  //! The basic comparison function.
  /*! \relates Linear_Expression_Impl

    \returns
    -1 or -2 if x is less than y, 0 if they are equal and 1 or 2 is y
    is greater. The absolute value of the result is 1 if the difference
    is only in the inhomogeneous terms, 2 otherwise.

    The order is a lexicographic. It starts comparing the variables'
    coefficient, starting from Variable(0), and at the end it compares
    the inhomogeneous terms.
  */
  virtual int compare(const Linear_Expression_Interface& y) const;

  virtual Linear_Expression_Impl&
  operator+=(const Linear_Expression_Interface& e2);
  virtual Linear_Expression_Impl& operator+=(const Variable v);
  virtual Linear_Expression_Impl&
  operator-=(const Linear_Expression_Interface& e2);
  virtual Linear_Expression_Impl& operator-=(const Variable v);
  virtual Linear_Expression_Impl&
  operator*=(Coefficient_traits::const_reference n);
  virtual Linear_Expression_Impl&
  operator/=(Coefficient_traits::const_reference n);

  virtual void negate();

  virtual Linear_Expression_Impl&
  add_mul_assign(Coefficient_traits::const_reference n, const Variable v);

  virtual Linear_Expression_Impl&
  sub_mul_assign(Coefficient_traits::const_reference n, const Variable v);

  virtual void add_mul_assign(Coefficient_traits::const_reference factor,
                              const Linear_Expression_Interface& e2);

  virtual void sub_mul_assign(Coefficient_traits::const_reference factor,
                              const Linear_Expression_Interface& e2);

  virtual void print(std::ostream& s) const;

  /*! \brief
    Returns <CODE>true</CODE> if the coefficient of each variable in
    \p vars[i] is \f$0\f$.
  */
  virtual bool all_zeroes(const Variables_Set& vars) const;

  //! Returns true if there is a variable in [first,last) whose coefficient
  //! is nonzero in both *this and x.
  virtual bool have_a_common_variable(const Linear_Expression_Interface& x,
                                      Variable first, Variable last) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns the i-th coefficient.
  virtual Coefficient_traits::const_reference get(dimension_type i) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Sets the i-th coefficient to n.
  virtual void set(dimension_type i, Coefficient_traits::const_reference n);

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  /*! \brief
    Returns <CODE>true</CODE> if (*this)[i] is \f$0\f$, for each i in
    [start, end).
  */
  virtual bool all_zeroes(dimension_type start, dimension_type end) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  /*! \brief
    Returns the number of zero coefficient in [start, end).
  */
  virtual dimension_type num_zeroes(dimension_type start, dimension_type end) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  /*! \brief
    Returns the gcd of the nonzero coefficients in [start,end). If all the
    coefficients in this range are 0 returns 0.
  */
  virtual Coefficient gcd(dimension_type start, dimension_type end) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  virtual void exact_div_assign(Coefficient_traits::const_reference c,
                                dimension_type start, dimension_type end);

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Equivalent to <CODE>(*this)[i] *= n</CODE>, for each i in [start, end).
  virtual void mul_assign(Coefficient_traits::const_reference n,
                          dimension_type start, dimension_type end);

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Linearly combines \p *this with \p y so that the coefficient of \p v
  //! is 0.
  /*!
    \param y
    The expression that will be combined with \p *this object;

    \param i
    The index of the coefficient that has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the i-th coefficient equal to \f$0\f$. Then it assigns
    the resulting expression to \p *this.

    \p *this and \p y must have the same space dimension.
  */
  virtual void
  linear_combine(const Linear_Expression_Interface& y, dimension_type i);

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end).
  virtual void linear_combine(const Linear_Expression_Interface& y,
                              Coefficient_traits::const_reference c1,
                              Coefficient_traits::const_reference c2,
                              dimension_type start, dimension_type end);

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end). c1 and c2 may be zero.
  virtual void linear_combine_lax(const Linear_Expression_Interface& y,
                                  Coefficient_traits::const_reference c1,
                                  Coefficient_traits::const_reference c2,
                                  dimension_type start, dimension_type end);

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns the index of the last nonzero element, or 0 if there are no
  //! nonzero elements.
  virtual dimension_type last_nonzero() const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  /*! \brief
    Returns <CODE>true</CODE> if each coefficient in [start,end) is *not* in
    \f$0\f$, disregarding coefficients of variables in \p vars.
  */
  virtual bool
  all_zeroes_except(const Variables_Set& vars,
                    dimension_type start, dimension_type end) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Sets results to the sum of (*this)[i]*y[i], for each i in [start,end).
  virtual void
  scalar_product_assign(Coefficient& result,
                        const Linear_Expression_Interface& y,
                        dimension_type start, dimension_type end) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Computes the sign of the sum of (*this)[i]*y[i], for each i in [start,end).
  virtual int
  scalar_product_sign(const Linear_Expression_Interface& y,
                      dimension_type start, dimension_type end) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns the index of the first nonzero element, or \p last if there are no
  //! nonzero elements, considering only elements in [first,last).
  virtual dimension_type
  first_nonzero(dimension_type first, dimension_type last) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns the index of the last nonzero element in [first,last), or last
  //! if there are no nonzero elements.
  virtual dimension_type
  last_nonzero(dimension_type first, dimension_type last) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Removes from the set x all the indexes of nonzero elements of *this.
  virtual void has_a_free_dimension_helper(std::set<dimension_type>& x) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns \p true if (*this)[i] is equal to x[i], for each i in [start,end).
  virtual bool is_equal_to(const Linear_Expression_Interface& x,
                           dimension_type start, dimension_type end) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns \p true if (*this)[i]*c1 is equal to x[i]*c2, for each i in
  //! [start,end).
  virtual bool is_equal_to(const Linear_Expression_Interface& x,
                           Coefficient_traits::const_reference c1,
                           Coefficient_traits::const_reference c2,
                           dimension_type start, dimension_type end) const;

  // NOTE: This method is public, but it is not exposed in
  // Linear_Expression, so that it can be used internally in the PPL,
  // by friends of Linear_Expression.
  //! Sets \p r to a copy of the row that implements \p *this.
  virtual void get_row(Dense_Row& r) const;

  // NOTE: This method is public, but it is not exposed in
  // Linear_Expression, so that it can be used internally in the PPL,
  // by friends of Linear_Expression.
  //! Sets \p r to a copy of the row that implements \p *this.
  virtual void get_row(Sparse_Row& r) const;

  //! Implementation sizing constructor.
  /*!
    The bool parameter is just to avoid problems with the constructor
    Linear_Expression_Impl(Coefficient_traits::const_reference n).
  */
  Linear_Expression_Impl(dimension_type space_dim, bool);

  //! Linearly combines \p *this with \p y so that the coefficient of \p v
  //! is 0.
  /*!
    \param y
    The expression that will be combined with \p *this object;

    \param v
    The variable whose coefficient has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the coefficient of variable \p v equal to \f$0\f$. Then it assigns
    the resulting expression to \p *this.

    \p *this and \p y must have the same space dimension.
  */
  template <typename Row2>
  void linear_combine(const Linear_Expression_Impl<Row2>& y, Variable v);

  //! Equivalent to <CODE>*this = *this * c1 + y * c2</CODE>, but assumes that
  //! \p *this and \p y have the same space dimension.
  template <typename Row2>
  void linear_combine(const Linear_Expression_Impl<Row2>& y,
                      Coefficient_traits::const_reference c1,
                      Coefficient_traits::const_reference c2);

  //! Equivalent to <CODE>*this = *this * c1 + y * c2</CODE>.
  //! c1 and c2 may be 0.
  template <typename Row2>
  void linear_combine_lax(const Linear_Expression_Impl<Row2>& y,
                          Coefficient_traits::const_reference c1,
                          Coefficient_traits::const_reference c2);

  //! Returns \p true if *this is equal to \p x.
  //! Note that (*this == x) has a completely different meaning.
  template <typename Row2>
  bool is_equal_to(const Linear_Expression_Impl<Row2>& x) const;

  template <typename Row2>
  Linear_Expression_Impl& operator+=(const Linear_Expression_Impl<Row2>& e2);
  template <typename Row2>
  Linear_Expression_Impl& operator-=(const Linear_Expression_Impl<Row2>& e2);

  template <typename Row2>
  Linear_Expression_Impl&
  sub_mul_assign(Coefficient_traits::const_reference n,
                 const Linear_Expression_Impl<Row2>& y,
                 dimension_type start, dimension_type end);

  template <typename Row2>
  void add_mul_assign(Coefficient_traits::const_reference factor,
                      const Linear_Expression_Impl<Row2>& e2);

  template <typename Row2>
  void sub_mul_assign(Coefficient_traits::const_reference factor,
                      const Linear_Expression_Impl<Row2>& e2);

  //! Linearly combines \p *this with \p y so that the coefficient of \p v
  //! is 0.
  /*!
    \param y
    The expression that will be combined with \p *this object;

    \param i
    The index of the coefficient that has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the i-th coefficient equal to \f$0\f$. Then it assigns
    the resulting expression to \p *this.

    \p *this and \p y must have the same space dimension.
  */
  template <typename Row2>
  void linear_combine(const Linear_Expression_Impl<Row2>& y, dimension_type i);

  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end).
  template <typename Row2>
  void linear_combine(const Linear_Expression_Impl<Row2>& y,
                      Coefficient_traits::const_reference c1,
                      Coefficient_traits::const_reference c2,
                      dimension_type start, dimension_type end);

  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end). c1 and c2 may be zero.
  template <typename Row2>
  void linear_combine_lax(const Linear_Expression_Impl<Row2>& y,
                          Coefficient_traits::const_reference c1,
                          Coefficient_traits::const_reference c2,
                          dimension_type start, dimension_type end);

  //! The basic comparison function.
  /*! \relates Linear_Expression_Impl

    \returns
    -1 or -2 if x is less than y, 0 if they are equal and 1 or 2 is y
    is greater. The absolute value of the result is 1 if the difference
    is only in the inhomogeneous terms, 2 otherwise.

    The order is a lexicographic. It starts comparing the variables'
    coefficient, starting from Variable(0), and at the end it compares
    the inhomogeneous terms.
  */
  template <typename Row2>
  int compare(const Linear_Expression_Impl<Row2>& y) const;

  //! Sets results to the sum of (*this)[i]*y[i], for each i in [start,end).
  template <typename Row2>
  void
  scalar_product_assign(Coefficient& result,
                        const Linear_Expression_Impl<Row2>& y,
                        dimension_type start, dimension_type end) const;

  //! Computes the sign of the sum of (*this)[i]*y[i],
  //! for each i in [start,end).
  template <typename Row2>
  int scalar_product_sign(const Linear_Expression_Impl<Row2>& y,
                          dimension_type start, dimension_type end) const;

  //! Returns \p true if (*this)[i] is equal to x[i], for each i in [start,end).
  template <typename Row2>
  bool is_equal_to(const Linear_Expression_Impl<Row2>& x,
                   dimension_type start, dimension_type end) const;

  //! Returns \p true if (*this)[i]*c1 is equal to x[i]*c2, for each i in
  //! [start,end).
  template <typename Row2>
  bool is_equal_to(const Linear_Expression_Impl<Row2>& x,
                   Coefficient_traits::const_reference c1,
                   Coefficient_traits::const_reference c2,
                   dimension_type start, dimension_type end) const;

  //! Returns true if there is a variable in [first,last) whose coefficient
  //! is nonzero in both *this and x.
  template <typename Row2>
  bool have_a_common_variable(const Linear_Expression_Impl<Row2>& x,
                              Variable first, Variable last) const;

private:

  void construct(const Linear_Expression_Interface& e);
  void construct(const Linear_Expression_Interface& e,
                 dimension_type space_dim);

  template <typename Row2>
  void construct(const Linear_Expression_Impl<Row2>& e);
  template <typename Row2>
  void construct(const Linear_Expression_Impl<Row2>& e,
                 dimension_type space_dim);

  Row row;

  template <typename Row2>
  friend class Linear_Expression_Impl;

}; // class Parma_Polyhedra_Library::Linear_Expression_Impl


namespace Parma_Polyhedra_Library {

// NOTE: declaring explicit specializations.

template <>
bool
Linear_Expression_Impl<Dense_Row>::OK() const;
template <>
bool
Linear_Expression_Impl<Sparse_Row>::OK() const;

template <>
bool
Linear_Expression_Impl<Dense_Row>::all_homogeneous_terms_are_zero() const;
template <>
bool
Linear_Expression_Impl<Sparse_Row>::all_homogeneous_terms_are_zero() const;

template <>
bool
Linear_Expression_Impl<Dense_Row>::all_zeroes(dimension_type start,
                                              dimension_type end) const;
template <>
bool
Linear_Expression_Impl<Sparse_Row>::all_zeroes(dimension_type start,
                                               dimension_type end) const;

template <>
bool
Linear_Expression_Impl<Dense_Row>
::all_zeroes(const Variables_Set& vars) const;
template <>
bool
Linear_Expression_Impl<Sparse_Row>
::all_zeroes(const Variables_Set& vars) const;

template <>
bool
Linear_Expression_Impl<Dense_Row>
::all_zeroes_except(const Variables_Set& vars,
                    dimension_type start, dimension_type end) const;
template <>
bool
Linear_Expression_Impl<Sparse_Row>
::all_zeroes_except(const Variables_Set& vars,
                    dimension_type start, dimension_type end) const;

template <>
dimension_type
Linear_Expression_Impl<Dense_Row>
::first_nonzero(dimension_type first, dimension_type last) const;
template <>
dimension_type
Linear_Expression_Impl<Sparse_Row>
::first_nonzero(dimension_type first, dimension_type last) const;

template <>
Coefficient
Linear_Expression_Impl<Dense_Row>::gcd(dimension_type start,
                                       dimension_type end) const;
template <>
Coefficient
Linear_Expression_Impl<Sparse_Row>::gcd(dimension_type start,
                                        dimension_type end) const;

template <>
void
Linear_Expression_Impl<Dense_Row>
::has_a_free_dimension_helper(std::set<dimension_type>& x) const;
template <>
void
Linear_Expression_Impl<Sparse_Row>
::has_a_free_dimension_helper(std::set<dimension_type>& x) const;

template <>
template <>
bool
Linear_Expression_Impl<Dense_Row>
::have_a_common_variable(const Linear_Expression_Impl<Dense_Row>& y,
                         Variable first, Variable last) const;
template <>
template <>
bool
Linear_Expression_Impl<Dense_Row>
::have_a_common_variable(const Linear_Expression_Impl<Sparse_Row>& y,
                         Variable first, Variable last) const;
template <>
template <>
bool
Linear_Expression_Impl<Sparse_Row>
::have_a_common_variable(const Linear_Expression_Impl<Dense_Row>& y,
                         Variable first, Variable last) const;
template <>
template <>
bool
Linear_Expression_Impl<Sparse_Row>
::have_a_common_variable(const Linear_Expression_Impl<Sparse_Row>& y,
                         Variable first, Variable last) const;

template <>
bool
Linear_Expression_Impl<Dense_Row>::is_zero() const;
template <>
bool
Linear_Expression_Impl<Sparse_Row>::is_zero() const;

template <>
dimension_type
Linear_Expression_Impl<Dense_Row>::last_nonzero() const;
template <>
dimension_type
Linear_Expression_Impl<Sparse_Row>::last_nonzero() const;

template <>
dimension_type
Linear_Expression_Impl<Dense_Row>
::last_nonzero(dimension_type first, dimension_type last) const;
template <>
dimension_type
Linear_Expression_Impl<Sparse_Row>
::last_nonzero(dimension_type first, dimension_type last) const;

template <>
dimension_type
Linear_Expression_Impl<Dense_Row>::num_zeroes(dimension_type start,
                                              dimension_type end) const;
template <>
dimension_type
Linear_Expression_Impl<Sparse_Row>::num_zeroes(dimension_type start,
                                               dimension_type end) const;

template <>
void
Linear_Expression_Impl<Dense_Row>
::remove_space_dimensions(const Variables_Set& vars);
template <>
void
Linear_Expression_Impl<Sparse_Row>
::remove_space_dimensions(const Variables_Set& vars);

template <>
Representation
Linear_Expression_Impl<Dense_Row>::representation() const;
template <>
Representation
Linear_Expression_Impl<Sparse_Row>::representation() const;

template <>
void
Linear_Expression_Impl<Dense_Row>::const_iterator::skip_zeroes_backward();
template <>
void
Linear_Expression_Impl<Sparse_Row>::const_iterator::skip_zeroes_backward();

template <>
void
Linear_Expression_Impl<Dense_Row>::const_iterator::skip_zeroes_forward();
template <>
void
Linear_Expression_Impl<Sparse_Row>::const_iterator::skip_zeroes_forward();

} // namespace Parma_Polyhedra_Library


/* Automatically generated from PPL source file ../src/Linear_Expression_Impl_inlines.hh line 1. */
/* Linear_Expression_Impl class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/math_utilities_defs.hh line 1. */
/* Declarations of some math utility functions.
*/


/* Automatically generated from PPL source file ../src/math_utilities_defs.hh line 29. */
#include <gmpxx.h>

namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Extract the numerator and denominator components of \p from.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, void>::type
numer_denom(const T& from,
            Coefficient& numer, Coefficient& denom);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Divides \p x by \p y into \p to, rounding the result towards plus infinity.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, void>::type
div_round_up(T& to,
             Coefficient_traits::const_reference x,
             Coefficient_traits::const_reference y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Assigns to \p x the minimum between \p x and \p y.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename N>
void
min_assign(N& x, const N& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Assigns to \p x the maximum between \p x and \p y.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename N>
void
max_assign(N& x, const N& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns <CODE>true</CODE> if and only if \p x is an even number.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_even(const T& x);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns <CODE>true</CODE> if and only if \f$x = -y\f$.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_additive_inverse(const T& x, const T& y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  If \f$g\f$ is the GCD of \p x and \p y, the values of \p x and \p y
  divided by \f$g\f$ are assigned to \p n_x and \p n_y, respectively.

  \note
  \p x and \p n_x may be the same object and likewise for
  \p y and \p n_y.  Any other aliasing results in undefined behavior.
*/
#endif
void
normalize2(Coefficient_traits::const_reference x,
           Coefficient_traits::const_reference y,
           Coefficient& n_x, Coefficient& n_y);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns <CODE>true</CODE> if and only if \p x is in canonical form.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
bool
is_canonical(const mpq_class& x);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Returns a mask for the lowest \p n bits,
#endif
template <typename T>
T
low_bits_mask(unsigned n);

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/math_utilities_inlines.hh line 1. */
/* Implementation of some math utility functions: inline functions.
*/


/* Automatically generated from PPL source file ../src/math_utilities_inlines.hh line 29. */
#include <limits>

namespace Parma_Polyhedra_Library {

inline void
normalize2(Coefficient_traits::const_reference x,
           Coefficient_traits::const_reference y,
           Coefficient& n_x, Coefficient& n_y) {
  PPL_DIRTY_TEMP_COEFFICIENT(gcd);
  gcd_assign(gcd, x, y);
  exact_div_assign(n_x, x, gcd);
  exact_div_assign(n_y, y, gcd);
}

template <typename T>
inline T
low_bits_mask(const unsigned n) {
  PPL_ASSERT(n < unsigned(std::numeric_limits<T>::digits));
  return ~((~static_cast<T>(0)) << n);
}

template <typename T>
inline typename Enable_If<Is_Native_Or_Checked<T>::value, void>::type
numer_denom(const T& from,
            Coefficient& numer, Coefficient& denom) {
  PPL_ASSERT(!is_not_a_number(from)
         && !is_minus_infinity(from)
         && !is_plus_infinity(from));
  PPL_DIRTY_TEMP(mpq_class, q);
  assign_r(q, from, ROUND_NOT_NEEDED);
  numer = q.get_num();
  denom = q.get_den();
}

template <typename T>
inline typename Enable_If<Is_Native_Or_Checked<T>::value, void>::type
div_round_up(T& to,
             Coefficient_traits::const_reference x,
             Coefficient_traits::const_reference y) {
  PPL_DIRTY_TEMP(mpq_class, q_x);
  PPL_DIRTY_TEMP(mpq_class, q_y);
  // Note: this code assumes that a Coefficient is always convertible
  // to an mpq_class without loss of precision.
  assign_r(q_x, x, ROUND_NOT_NEEDED);
  assign_r(q_y, y, ROUND_NOT_NEEDED);
  div_assign_r(q_x, q_x, q_y, ROUND_NOT_NEEDED);
  assign_r(to, q_x, ROUND_UP);
}

template <typename N>
inline void
min_assign(N& x, const N& y) {
  if (x > y) {
    x = y;
  }
}

template <typename N>
inline void
max_assign(N& x, const N& y) {
  if (x < y) {
    x = y;
  }
}

template <typename T>
inline typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_even(const T& x) {
  T mod;
  return umod_2exp_assign_r(mod, x, 1, ROUND_DIRECT | ROUND_STRICT_RELATION) == V_EQ
    && mod == 0;
}

template <typename T>
inline typename Enable_If<Is_Native_Or_Checked<T>::value, bool>::type
is_additive_inverse(const T& x, const T& y) {
  T negated_x;
  return neg_assign_r(negated_x, x, ROUND_DIRECT | ROUND_STRICT_RELATION) == V_EQ
    && negated_x == y;
}

inline bool
is_canonical(const mpq_class& x) {
  if (x.get_den() <= 0) {
    return false;
  }
  PPL_DIRTY_TEMP(mpq_class, temp);
  temp = x;
  temp.canonicalize();
  return temp.get_num() == x.get_num();
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/math_utilities_defs.hh line 109. */

/* Automatically generated from PPL source file ../src/Linear_Expression_Impl_inlines.hh line 28. */
#include <stdexcept>

namespace Parma_Polyhedra_Library {

template <typename Row>
inline dimension_type
Linear_Expression_Impl<Row>::max_space_dimension() {
  return Row::max_size() - 1;
}

template <typename Row>
inline
Linear_Expression_Impl<Row>::Linear_Expression_Impl()
  : row(1) {
  PPL_ASSERT(OK());
}

template <typename Row>
inline
Linear_Expression_Impl<Row>
::Linear_Expression_Impl(dimension_type space_dim, bool)
  : row(space_dim + 1) {
  PPL_ASSERT(OK());
}

template <typename Row>
inline
Linear_Expression_Impl<Row>::~Linear_Expression_Impl() {
}

template <typename Row>
inline
Linear_Expression_Impl<Row>
::Linear_Expression_Impl(Coefficient_traits::const_reference n)
  : row(1) {
  if (n != 0) {
    row.insert(0, n);
  }
  PPL_ASSERT(OK());
}

template <typename Row>
inline dimension_type
Linear_Expression_Impl<Row>::space_dimension() const {
  return row.size() - 1;
}

template <typename Row>
inline void
Linear_Expression_Impl<Row>::set_space_dimension(dimension_type n) {
  row.resize(n + 1);
  PPL_ASSERT(OK());
}

template <typename Row>
inline Coefficient_traits::const_reference
Linear_Expression_Impl<Row>::coefficient(Variable v) const {
  if (v.space_dimension() > space_dimension()) {
    return Coefficient_zero();
  }
  return row.get(v.id() + 1);
}

template <typename Row>
inline void
Linear_Expression_Impl<Row>
::set_coefficient(Variable v, Coefficient_traits::const_reference n) {
  PPL_ASSERT(v.space_dimension() <= space_dimension());
  const dimension_type i = v.space_dimension();
  if (n == 0) {
    row.reset(i);
  }
  else {
    row.insert(i, n);
  }
  PPL_ASSERT(OK());
}

template <typename Row>
inline Coefficient_traits::const_reference
Linear_Expression_Impl<Row>::inhomogeneous_term() const {
  return row.get(0);
}

template <typename Row>
inline void
Linear_Expression_Impl<Row>
::set_inhomogeneous_term(Coefficient_traits::const_reference n) {
  if (n == 0) {
    row.reset(0);
  }
  else {
    row.insert(0, n);
  }
  PPL_ASSERT(OK());
}

template <typename Row>
inline void
Linear_Expression_Impl<Row>::swap_space_dimensions(Variable v1, Variable v2) {
  row.swap_coefficients(v1.space_dimension(), v2.space_dimension());
  PPL_ASSERT(OK());
}

template <typename Row>
inline void
Linear_Expression_Impl<Row>::shift_space_dimensions(Variable v,
                                                    dimension_type n) {
  row.add_zeroes_and_shift(n, v.space_dimension());
  PPL_ASSERT(OK());
}

template <typename Row>
inline memory_size_type
Linear_Expression_Impl<Row>::external_memory_in_bytes() const {
  return row.external_memory_in_bytes();
}

template <typename Row>
inline memory_size_type
Linear_Expression_Impl<Row>::total_memory_in_bytes() const {
  return external_memory_in_bytes() + sizeof(*this);
}

template <typename Row>
inline Linear_Expression_Impl<Row>&
Linear_Expression_Impl<Row>::operator+=(Coefficient_traits::const_reference n) {
  typename Row::iterator itr = row.insert(0);
  (*itr) += n;
  if (*itr == 0) {
    row.reset(itr);
  }
  PPL_ASSERT(OK());
  return *this;
}

template <typename Row>
inline Linear_Expression_Impl<Row>&
Linear_Expression_Impl<Row>::operator-=(Coefficient_traits::const_reference n) {
  typename Row::iterator itr = row.insert(0);
  (*itr) -= n;
  if (*itr == 0) {
    row.reset(itr);
  }
  PPL_ASSERT(OK());
  return *this;
}

template <typename Row>
inline void
Linear_Expression_Impl<Row>::normalize() {
  row.normalize();
  PPL_ASSERT(OK());
}

template <>
inline bool
Linear_Expression_Impl<Sparse_Row>::is_zero() const {
  return row.num_stored_elements() == 0;
}

template <>
inline bool
Linear_Expression_Impl<Sparse_Row>::all_homogeneous_terms_are_zero() const {
  return row.lower_bound(1) == row.end();
}

template <>
inline bool
Linear_Expression_Impl<Sparse_Row>::all_zeroes(dimension_type start,
                                               dimension_type end) const {
  return row.lower_bound(start) == row.lower_bound(end);
}

template <>
inline dimension_type
Linear_Expression_Impl<Sparse_Row>::num_zeroes(dimension_type start,
                                               dimension_type end) const {
  PPL_ASSERT(start <= end);
  return (end - start)
    - std::distance(row.lower_bound(start), row.lower_bound(end));
}

template <>
inline dimension_type
Linear_Expression_Impl<Sparse_Row>::last_nonzero() const {
  if (row.num_stored_elements() == 0) {
    return 0;
  }
  Sparse_Row::const_iterator i = row.end();
  --i;
  return i.index();
}

template <>
inline dimension_type
Linear_Expression_Impl<Sparse_Row>
::first_nonzero(dimension_type first, dimension_type last) const {
  PPL_ASSERT(first <= last);
  PPL_ASSERT(last <= row.size());
  Sparse_Row::const_iterator i = row.lower_bound(first);

  if (i != row.end() && i.index() < last) {
    return i.index();
  }
  else {
    return last;
  }
}

template <>
inline dimension_type
Linear_Expression_Impl<Sparse_Row>
::last_nonzero(dimension_type first, dimension_type last) const {
  PPL_ASSERT(first <= last);
  PPL_ASSERT(last <= row.size());
  Sparse_Row::const_iterator itr1 = row.lower_bound(first);
  Sparse_Row::const_iterator itr2 = row.lower_bound(last);

  if (itr1 == itr2) {
    return last;
  }

  --itr2;
  return itr2.index();
}

template <>
inline Representation
Linear_Expression_Impl<Dense_Row>::representation() const {
  return DENSE;
}

template <>
inline Representation
Linear_Expression_Impl<Sparse_Row>::representation() const {
  return SPARSE;
}

template <>
inline void
Linear_Expression_Impl<Sparse_Row>::const_iterator
::skip_zeroes_forward() {
  // Nothing to do.
}

template <>
inline void
Linear_Expression_Impl<Sparse_Row>::const_iterator
::skip_zeroes_backward() {
  // Nothing to do.
}

namespace IO_Operators {

template <typename Row>
inline std::ostream&
operator<<(std::ostream& s, const Linear_Expression_Impl<Row>& e) {
  e.print(s);
  return s;
}

} // namespace IO_Operators

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Expression_Impl_templates.hh line 1. */
/* Linear_Expression_Impl class implementation: non-inline template functions.
*/


/* Automatically generated from PPL source file ../src/Linear_Expression_Impl_templates.hh line 29. */

/* Automatically generated from PPL source file ../src/Constraint_defs.hh line 1. */
/* Constraint class declaration.
*/


/* Automatically generated from PPL source file ../src/Constraint_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Constraint;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Constraint_defs.hh line 28. */

/* Automatically generated from PPL source file ../src/Congruence_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Congruence;

}

/* Automatically generated from PPL source file ../src/Polyhedron_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Polyhedron;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/termination_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Termination_Helpers;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Octagonal_Shape_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename T>
class Octagonal_Shape;

class Octagonal_Shape_Helper;

}

/* Automatically generated from PPL source file ../src/Grid_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Grid;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Constraint_defs.hh line 35. */

/* Automatically generated from PPL source file ../src/Linear_Expression_defs.hh line 1. */
/* Linear_Expression class declaration.
*/


/* Automatically generated from PPL source file ../src/Linear_Expression_defs.hh line 28. */

/* Automatically generated from PPL source file ../src/Generator_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Generator;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Grid_Generator_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Grid_Generator;

}

/* Automatically generated from PPL source file ../src/Linear_System_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename Row>
class Linear_System;

template <typename Row>
class Linear_System_With_Bit_Matrix_iterator;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Constraint_System_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Constraint_System;
class Constraint_System_const_iterator;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Congruence_System_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Congruence_System;

}

/* Automatically generated from PPL source file ../src/PIP_Problem_types.hh line 1. */


namespace Parma_Polyhedra_Library {

//! Possible outcomes of the PIP_Problem solver.
/*! \ingroup PPL_CXX_interface */
enum PIP_Problem_Status {
  //! The problem is unfeasible.
  UNFEASIBLE_PIP_PROBLEM,
  //! The problem has an optimal solution.
  OPTIMIZED_PIP_PROBLEM
};

class PIP_Problem;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/BHRZ03_Certificate_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class BHRZ03_Certificate;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Scalar_Products_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Scalar_Products;
class Topology_Adjusted_Scalar_Product_Sign;
class Topology_Adjusted_Scalar_Product_Assign;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/MIP_Problem_types.hh line 1. */


namespace Parma_Polyhedra_Library {

//! Possible outcomes of the MIP_Problem solver.
/*! \ingroup PPL_CXX_interface */
enum MIP_Problem_Status {
  //! The problem is unfeasible.
  UNFEASIBLE_MIP_PROBLEM,
  //! The problem is unbounded.
  UNBOUNDED_MIP_PROBLEM,
  //! The problem has an optimal solution.
  OPTIMIZED_MIP_PROBLEM
};

class MIP_Problem;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/BD_Shape_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename T>
class BD_Shape;

class BD_Shape_Helpers;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Expression_defs.hh line 47. */

/* Automatically generated from PPL source file ../src/Expression_Adapter_defs.hh line 1. */
/* Expression_Adapter class declaration.
*/


/* Automatically generated from PPL source file ../src/Expression_Adapter_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Expression_Adapter_Base;

template <typename T>
class Expression_Adapter;

template <typename T>
class Expression_Adapter_Transparent;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Expression_Adapter_defs.hh line 32. */

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Adapters' base type (for template meta-programming).
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
class Parma_Polyhedra_Library::Expression_Adapter_Base {
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! An adapter for Linear_Expression objects.
/*!
  The adapters are meant to provide read-only, customized access to the
  Linear_Expression members in Constraint, Generator, Congruence and
  Grid_Generator objects. They typically implement the user-level view
  of these expressions.

  \note
  A few methods implement low-level access routines and will take
  bare indexes as arguments (rather than Variable objects):
  when such a bare index \c i is zero, the inhomogeneous term is meant;
  when the bare index \c i is greater than zero, the coefficient of the
  variable having id <CODE>i - 1</CODE> is meant.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Parma_Polyhedra_Library::Expression_Adapter
  : public Expression_Adapter_Base {
public:
  //! The type of this object.
  typedef Expression_Adapter<T> const_reference;
  //! The type obtained by one-level unwrapping.
  typedef typename T::const_reference inner_type;
  //! The raw, completely unwrapped type.
  typedef typename T::raw_type raw_type;

  //! Returns an adapter after one-level unwrapping.
  inner_type inner() const;

  //! The type of const iterators on coefficients.
  typedef typename raw_type::const_iterator const_iterator;

  //! Returns the current representation of \p *this.
  Representation representation() const;

  //! Iterator pointing to the first nonzero variable coefficient.
  const_iterator begin() const;

  //! Iterator pointing after the last nonzero variable coefficient.
  const_iterator end() const;

  //! Iterator pointing to the first nonzero variable coefficient
  //! of a variable bigger than or equal to \p v.
  const_iterator lower_bound(Variable v) const;

  //! Returns the dimension of the vector space enclosing \p *this.
  dimension_type space_dimension() const;

  //! Returns the coefficient of \p v in \p *this.
  Coefficient_traits::const_reference coefficient(Variable v) const;

  //! Returns the inhomogeneous term of \p *this.
  Coefficient_traits::const_reference inhomogeneous_term() const;

  //! Returns <CODE>true</CODE> if and only if \p *this is zero.
  bool is_zero() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if all the homogeneous
    terms of \p *this are zero.
  */
  bool all_homogeneous_terms_are_zero() const;

  /*! \brief Returns \p true if \p *this is equal to \p y.

    Note that <CODE>(*this == y)</CODE> has a completely different meaning.
  */
  template <typename Expression>
  bool is_equal_to(const Expression& y) const;

  /*! \brief
    Returns <CODE>true</CODE> if the coefficient of each variable in
    \p vars is zero.
  */
  bool all_zeroes(const Variables_Set& vars) const;

  //! Returns the \p i -th coefficient.
  Coefficient_traits::const_reference get(dimension_type i) const;

  //! Returns the coefficient of variable \p v.
  Coefficient_traits::const_reference get(Variable v) const;

  /*! \brief
    Returns <CODE>true</CODE> if (*this)[i] is zero,
    for each i in [start, end).
  */
  bool all_zeroes(dimension_type start, dimension_type end) const;

  //! Returns the number of zero coefficient in [start, end).
  dimension_type num_zeroes(dimension_type start, dimension_type end) const;

  /*! \brief
    Returns the gcd of the nonzero coefficients in [start,end).
    Returns zero if all the coefficients in the range are zero.
  */
  Coefficient gcd(dimension_type start, dimension_type end) const;

  //! Returns the index of the last nonzero element, or zero if there are no
  //! nonzero elements.
  dimension_type last_nonzero() const;

  //! Returns the index of the last nonzero element in [first,last),
  //! or \p last if there are no nonzero elements.
  dimension_type last_nonzero(dimension_type first, dimension_type last) const;

  //! Returns the index of the first nonzero element, or \p last if there
  //! are no nonzero elements, considering only elements in [first,last).
  dimension_type first_nonzero(dimension_type first, dimension_type last) const;

  /*! \brief
    Returns <CODE>true</CODE> if all coefficients in [start,end),
    except those corresponding to variables in \p vars, are zero.
  */
  bool all_zeroes_except(const Variables_Set& vars,
                         dimension_type start, dimension_type end) const;

  //! Removes from set \p x all the indexes of nonzero elements in \p *this.
  void has_a_free_dimension_helper(std::set<dimension_type>& x) const;

  //! Returns \c true if <CODE>(*this)[i]</CODE> is equal to <CODE>y[i]</CODE>,
  //! for each i in [start,end).
  template <typename Expression>
  bool is_equal_to(const Expression& y,
                   dimension_type start, dimension_type end) const;

  //! Returns \c true if <CODE>(*this)[i]*c1</CODE> is equal to
  //! <CODE>y[i]*c2</CODE>, for each i in [start,end).
  template <typename Expression>
  bool is_equal_to(const Expression& y,
                   Coefficient_traits::const_reference c1,
                   Coefficient_traits::const_reference c2,
                   dimension_type start, dimension_type end) const;

  //! Sets \p r to a copy of the row as adapted by \p *this.
  void get_row(Dense_Row& r) const;

  //! Sets \p r to a copy of the row as adapted by \p *this.
  void get_row(Sparse_Row& r) const;

  //! Returns \c true if there is a variable in [first,last) whose coefficient
  //! is nonzero in both \p *this and \p y.
  template <typename Expression>
  bool have_a_common_variable(const Expression& y,
                              Variable first, Variable last) const;

protected:
  //! Constructor.
  explicit Expression_Adapter(const raw_type& expr);
  //! The raw, completely unwrapped object subject to adaptation.
  const raw_type& raw_;
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! A transparent adapter for Linear_Expression objects.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Parma_Polyhedra_Library::Expression_Adapter_Transparent
  : public Expression_Adapter<T> {
  typedef Expression_Adapter<T> base_type;
public:
  //! The type of this object.
  typedef Expression_Adapter_Transparent<T> const_reference;
  //! The type obtained by one-level unwrapping.
  typedef typename base_type::inner_type inner_type;
  //! The raw, completely unwrapped type.
  typedef typename base_type::raw_type raw_type;

  //! The type of const iterators on coefficients.
  typedef typename base_type::const_iterator const_iterator;

  //! Constructor.
  explicit Expression_Adapter_Transparent(const raw_type& expr);
};

/* Automatically generated from PPL source file ../src/Expression_Adapter_inlines.hh line 1. */
/* Expression_Adapter class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Expression_Adapter_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

template <typename T>
inline
Expression_Adapter<T>::Expression_Adapter(const raw_type& expr)
  : raw_(expr) {
}

template <typename T>
inline typename Expression_Adapter<T>::inner_type
Expression_Adapter<T>::inner() const {
  return inner_type(raw_);
}

template <typename T>
inline Representation
Expression_Adapter<T>::representation() const {
  return inner().representation();
}

template <typename T>
inline typename Expression_Adapter<T>::const_iterator
Expression_Adapter<T>::begin() const {
  return inner().begin();
}

template <typename T>
inline typename Expression_Adapter<T>::const_iterator
Expression_Adapter<T>::end() const {
  return inner().end();
}

template <typename T>
inline typename Expression_Adapter<T>::const_iterator
Expression_Adapter<T>::lower_bound(Variable v) const {
  return inner().lower_bound(v);
}

template <typename T>
inline dimension_type
Expression_Adapter<T>::space_dimension() const {
  return inner().space_dimension();
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Adapter<T>::coefficient(Variable v) const {
  return inner().coefficient(v);
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Adapter<T>::inhomogeneous_term() const {
  return inner().inhomogeneous_term();
}

template <typename T>
inline bool
Expression_Adapter<T>::is_zero() const {
  return inner().is_zero();
}

template <typename T>
inline bool
Expression_Adapter<T>::all_homogeneous_terms_are_zero() const {
  return inner().all_homogeneous_terms_are_zero();
}

template <typename T>
template <typename Expression>
inline bool
Expression_Adapter<T>::is_equal_to(const Expression& y) const {
  return inner().is_equal_to(y);
}

template <typename T>
inline bool
Expression_Adapter<T>
::all_zeroes(const Variables_Set& vars) const {
  return inner().all_zeroes(vars);
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Adapter<T>::get(dimension_type i) const {
  return inner().get(i);
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Adapter<T>::get(Variable v) const {
  return inner().get(v);
}

template <typename T>
inline bool
Expression_Adapter<T>::all_zeroes(dimension_type start,
                                  dimension_type end) const {
  return inner().all_zeroes(start, end);
}

template <typename T>
inline dimension_type
Expression_Adapter<T>::num_zeroes(dimension_type start,
                                  dimension_type end) const {
  return inner().num_zeroes(start, end);
}

template <typename T>
inline Coefficient
Expression_Adapter<T>::gcd(dimension_type start,
                           dimension_type end) const {
  return inner().gcd(start, end);
}

template <typename T>
inline dimension_type
Expression_Adapter<T>::last_nonzero() const {
  return inner().last_nonzero();
}

template <typename T>
inline dimension_type
Expression_Adapter<T>::last_nonzero(dimension_type first,
                                    dimension_type last) const {
  return inner().last_nonzero(first, last);
}

template <typename T>
inline dimension_type
Expression_Adapter<T>::first_nonzero(dimension_type first,
                                     dimension_type last) const {
  return inner().first_nonzero(first, last);
}

template <typename T>
inline bool
Expression_Adapter<T>
::all_zeroes_except(const Variables_Set& vars,
                    dimension_type start, dimension_type end) const {
  return inner().all_zeroes_except(vars, start, end);
}

template <typename T>
inline void
Expression_Adapter<T>
::has_a_free_dimension_helper(std::set<dimension_type>& x) const {
  inner().has_a_free_dimension_helper(x);
}

template <typename T>
template <typename Expression>
inline bool
Expression_Adapter<T>
::is_equal_to(const Expression& y,
              dimension_type start, dimension_type end) const {
  return inner().is_equal_to(y, start, end);
}

template <typename T>
template <typename Expression>
inline bool
Expression_Adapter<T>
::is_equal_to(const Expression& y,
              Coefficient_traits::const_reference c1,
              Coefficient_traits::const_reference c2,
              dimension_type start, dimension_type end) const {
  return inner().is_equal_to(y, c1, c2, start, end);
}

template <typename T>
inline void
Expression_Adapter<T>::get_row(Dense_Row& r) const {
  inner().get_row(r);
}

template <typename T>
inline void
Expression_Adapter<T>::get_row(Sparse_Row& r) const {
  inner().get_row(r);
}

template <typename T>
template <typename Expression>
inline bool
Expression_Adapter<T>
::have_a_common_variable(const Expression& y,
                         Variable first, Variable last) const {
  return inner().have_a_common_variable(y, first, last);
}

template <typename T>
inline
Expression_Adapter_Transparent<T>
::Expression_Adapter_Transparent(const raw_type& expr)
  : base_type(expr) {
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Expression_Adapter_defs.hh line 215. */

/* Automatically generated from PPL source file ../src/Expression_Hide_Inhomo_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename T>
class Expression_Hide_Inhomo;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Expression_Hide_Last_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename T>
class Expression_Hide_Last;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Expression_defs.hh line 51. */

/* Automatically generated from PPL source file ../src/Linear_Expression_defs.hh line 54. */
#include <cstddef>

namespace Parma_Polyhedra_Library {

// Put them in the namespace here to declare them friend later.

//! Returns the linear expression \p e1 + \p e2.
/*! \relates Linear_Expression */
Linear_Expression
operator+(const Linear_Expression& e1, const Linear_Expression& e2);

//! Returns the linear expression \p v + \p w.
/*! \relates Linear_Expression */
Linear_Expression
operator+(Variable v, Variable w);

//! Returns the linear expression \p v + \p e.
/*! \relates Linear_Expression */
Linear_Expression
operator+(Variable v, const Linear_Expression& e);

//! Returns the linear expression \p e + \p v.
/*! \relates Linear_Expression */
Linear_Expression
operator+(const Linear_Expression& e, Variable v);

//! Returns the linear expression \p n + \p e.
/*! \relates Linear_Expression */
Linear_Expression
operator+(Coefficient_traits::const_reference n, const Linear_Expression& e);

//! Returns the linear expression \p e + \p n.
/*! \relates Linear_Expression */
Linear_Expression
operator+(const Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the linear expression \p e.
/*! \relates Linear_Expression */
Linear_Expression
operator+(const Linear_Expression& e);

//! Returns the linear expression - \p e.
/*! \relates Linear_Expression */
Linear_Expression
operator-(const Linear_Expression& e);

//! Returns the linear expression \p e1 - \p e2.
/*! \relates Linear_Expression */
Linear_Expression
operator-(const Linear_Expression& e1, const Linear_Expression& e2);

//! Returns the linear expression \p v - \p w.
/*! \relates Linear_Expression */
Linear_Expression
operator-(Variable v, Variable w);

//! Returns the linear expression \p v - \p e.
/*! \relates Linear_Expression */
Linear_Expression
operator-(Variable v, const Linear_Expression& e);

//! Returns the linear expression \p e - \p v.
/*! \relates Linear_Expression */
Linear_Expression
operator-(const Linear_Expression& e, Variable v);

//! Returns the linear expression \p n - \p e.
/*! \relates Linear_Expression */
Linear_Expression
operator-(Coefficient_traits::const_reference n, const Linear_Expression& e);

//! Returns the linear expression \p e - \p n.
/*! \relates Linear_Expression */
Linear_Expression
operator-(const Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the linear expression \p n * \p e.
/*! \relates Linear_Expression */
Linear_Expression
operator*(Coefficient_traits::const_reference n, const Linear_Expression& e);

//! Returns the linear expression \p e * \p n.
/*! \relates Linear_Expression */
Linear_Expression
operator*(const Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the linear expression \p e1 + \p e2 and assigns it to \p e1.
/*! \relates Linear_Expression */
Linear_Expression&
operator+=(Linear_Expression& e1, const Linear_Expression& e2);

//! Returns the linear expression \p e + \p v and assigns it to \p e.
/*! \relates Linear_Expression
  \exception std::length_error
  Thrown if the space dimension of \p v exceeds
  <CODE>Linear_Expression::max_space_dimension()</CODE>.
 */
Linear_Expression&
operator+=(Linear_Expression& e, Variable v);

//! Returns the linear expression \p e + \p n and assigns it to \p e.
/*! \relates Linear_Expression */
Linear_Expression&
operator+=(Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the linear expression \p e1 - \p e2 and assigns it to \p e1.
/*! \relates Linear_Expression */
Linear_Expression&
operator-=(Linear_Expression& e1, const Linear_Expression& e2);

//! Returns the linear expression \p e - \p v and assigns it to \p e.
/*! \relates Linear_Expression
  \exception std::length_error
  Thrown if the space dimension of \p v exceeds
  <CODE>Linear_Expression::max_space_dimension()</CODE>.
 */
Linear_Expression&
operator-=(Linear_Expression& e, Variable v);

//! Returns the linear expression \p e - \p n and assigns it to \p e.
/*! \relates Linear_Expression */
Linear_Expression&
operator-=(Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the linear expression \p n * \p e and assigns it to \p e.
/*! \relates Linear_Expression */
Linear_Expression&
operator*=(Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the linear expression \p n / \p e and assigns it to \p e.
/*! \relates Linear_Expression */
Linear_Expression&
operator/=(Linear_Expression& e, Coefficient_traits::const_reference n);

//! Assigns to \p e its own negation.
/*! \relates Linear_Expression */
void
neg_assign(Linear_Expression& e);

//! Returns the linear expression \p e + \p n * \p v and assigns it to \p e.
/*! \relates Linear_Expression */
Linear_Expression&
add_mul_assign(Linear_Expression& e,
               Coefficient_traits::const_reference n, Variable v);

//! Sums \p e2 multiplied by \p factor into \p e1.
/*! \relates Linear_Expression */
void add_mul_assign(Linear_Expression& e1,
                    Coefficient_traits::const_reference factor,
                    const Linear_Expression& e2);

//! Subtracts \p e2 multiplied by \p factor from \p e1.
/*! \relates Linear_Expression */
void sub_mul_assign(Linear_Expression& e1,
                    Coefficient_traits::const_reference factor,
                    const Linear_Expression& e2);

//! Returns the linear expression \p e - \p n * \p v and assigns it to \p e.
/*! \relates Linear_Expression */
Linear_Expression&
sub_mul_assign(Linear_Expression& e,
               Coefficient_traits::const_reference n, Variable v);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! The basic comparison function.
/*! \relates Linear_Expression

  \returns -1 or -2 if x is less than y, 0 if they are equal and 1 or 2 is y
           is greater. The absolute value of the result is 1 if the difference
           is only in the inhomogeneous terms, 2 otherwise

  The order is a lexicographic. It starts comparing the variables' coefficient,
  starting from Variable(0), and at the end it compares the inhomogeneous
  terms.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
int compare(const Linear_Expression& x, const Linear_Expression& y);

namespace IO_Operators {

//! Output operator.
/*! \relates Parma_Polyhedra_Library::Linear_Expression */
std::ostream& operator<<(std::ostream& s, const Linear_Expression& e);

} // namespace IO_Operators

} // namespace Parma_Polyhedra_Library

//! A linear expression.
/*! \ingroup PPL_CXX_interface
  An object of the class Linear_Expression represents the linear expression
  \f[
    \sum_{i=0}^{n-1} a_i x_i + b
  \f]
  where \f$n\f$ is the dimension of the vector space,
  each \f$a_i\f$ is the integer coefficient
  of the \f$i\f$-th variable \f$x_i\f$
  and \f$b\f$ is the integer for the inhomogeneous term.

  \par How to build a linear expression.

  Linear expressions are the basic blocks for defining
  both constraints (i.e., linear equalities or inequalities)
  and generators (i.e., lines, rays, points and closure points).
  A full set of functions is defined to provide a convenient interface
  for building complex linear expressions starting from simpler ones
  and from objects of the classes Variable and Coefficient:
  available operators include unary negation,
  binary addition and subtraction,
  as well as multiplication by a Coefficient.
  The space dimension of a linear expression is defined as the maximum
  space dimension of the arguments used to build it:
  in particular, the space dimension of a Variable <CODE>x</CODE>
  is defined as <CODE>x.id()+1</CODE>,
  whereas all the objects of the class Coefficient have space dimension zero.

  \par Example
  The following code builds the linear expression \f$4x - 2y - z + 14\f$,
  having space dimension \f$3\f$:
  \code
  Linear_Expression e = 4*x - 2*y - z + 14;
  \endcode
  Another way to build the same linear expression is:
  \code
  Linear_Expression e1 = 4*x;
  Linear_Expression e2 = 2*y;
  Linear_Expression e3 = z;
  Linear_Expression e = Linear_Expression(14);
  e += e1 - e2 - e3;
  \endcode
  Note that \p e1, \p e2 and \p e3 have space dimension 1, 2 and 3,
  respectively; also, in the fourth line of code, \p e is created
  with space dimension zero and then extended to space dimension 3
  in the fifth line.
*/
class Parma_Polyhedra_Library::Linear_Expression {
public:
  static const Representation default_representation = SPARSE;

  //! Default constructor: returns a copy of Linear_Expression::zero().
  explicit Linear_Expression(Representation r = default_representation);

  /*! \brief Ordinary copy constructor.
    \note
    The new expression will have the same representation as \p e
    (not necessarily the default_representation).
  */
  Linear_Expression(const Linear_Expression& e);

  //! Copy constructor that takes also a Representation.
  Linear_Expression(const Linear_Expression& e, Representation r);

  // Queried by expression adapters.
  typedef const Linear_Expression& const_reference;
  typedef Linear_Expression raw_type;

  /*! \brief Copy constructor from a linear expression adapter.
    \note
    The new expression will have the same representation as \p e
    (not necessarily the default_representation).
  */
  template <typename LE_Adapter>
  explicit
  Linear_Expression(const LE_Adapter& e,
                    typename
                    Enable_If<Is_Same_Or_Derived<Expression_Adapter_Base,
                                                 LE_Adapter>::value,
                              void*>::type = 0);

  /*! \brief Copy constructor from a linear expression adapter that takes a
    Representation.
  */
  template <typename LE_Adapter>
  Linear_Expression(const LE_Adapter& e,
                    Representation r,
                    typename
                    Enable_If<Is_Same_Or_Derived<Expression_Adapter_Base,
                                                 LE_Adapter>::value,
                              void*>::type = 0);

  /*! \brief
    Copy constructor from a linear expression adapter that takes a
    space dimension.
    \note
    The new expression will have the same representation as \p e
    (not necessarily default_representation).
  */
  template <typename LE_Adapter>
  explicit
  Linear_Expression(const LE_Adapter& e,
                    dimension_type space_dim,
                    typename
                    Enable_If<Is_Same_Or_Derived<Expression_Adapter_Base,
                                                 LE_Adapter>::value,
                              void*>::type = 0);

  /*! \brief
    Copy constructor from a linear expression adapter that takes a
    space dimension and a Representation.
  */
  template <typename LE_Adapter>
  Linear_Expression(const LE_Adapter& e,
                    dimension_type space_dim,
                    Representation r,
                    typename
                    Enable_If<Is_Same_Or_Derived<Expression_Adapter_Base,
                                                 LE_Adapter>::value,
                              void*>::type = 0);

  //! Assignment operator.
  Linear_Expression& operator=(const Linear_Expression& e);

  //! Destructor.
  ~Linear_Expression();

  /*! \brief
    Builds the linear expression corresponding
    to the inhomogeneous term \p n.
  */
  explicit Linear_Expression(Coefficient_traits::const_reference n,
                             Representation r = default_representation);

  //! Builds the linear expression corresponding to the variable \p v.
  /*!
    \exception std::length_error
    Thrown if the space dimension of \p v exceeds
    <CODE>Linear_Expression::max_space_dimension()</CODE>.
  */
  Linear_Expression(Variable v, Representation r = default_representation);

  //! Returns the current representation of *this.
  Representation representation() const;

  //! Converts *this to the specified representation.
  void set_representation(Representation r);

  //! A const %iterator on the expression (homogeneous) coefficient that are
  //! nonzero.
  /*!
    These iterators are invalidated by operations that modify the expression.
  */
  class const_iterator {
  private:
  public:
    typedef std::bidirectional_iterator_tag iterator_category;
    typedef const Coefficient value_type;
    typedef std::ptrdiff_t difference_type;
    typedef value_type* pointer;
    typedef Coefficient_traits::const_reference reference;

    //! Constructs an invalid const_iterator.
    /*!
      This constructor takes \f$O(1)\f$ time.
    */
    explicit const_iterator();

    //! The copy constructor.
    /*!
      \param i
      The %iterator that will be copied.

      This constructor takes \f$O(1)\f$ time.
    */
    const_iterator(const const_iterator& i);

    ~const_iterator();

    //! Swaps \p i with \p *this.
    /*!
      \param i
      The %iterator that will be swapped with \p *this.

      This method takes \f$O(1)\f$ time.
    */
    void m_swap(const_iterator& i);

    //! Assigns \p i to *this .
    /*!
      \param i
      The %iterator that will be assigned into *this.

      This method takes \f$O(1)\f$ time.
    */
    const_iterator& operator=(const const_iterator& i);

    //! Navigates to the next nonzero coefficient.
    /*!
      This method takes \f$O(n)\f$ time for dense expressions, and
      \f$O(1)\f$ time for sparse expressions.
    */
    const_iterator& operator++();

    //! Navigates to the previous nonzero coefficient.
    /*!
      This method takes \f$O(n)\f$ time for dense expressions, and
      \f$O(1)\f$ time for sparse expressions.
    */
    const_iterator& operator--();

    //! Returns the current element.
    reference operator*() const;

    //! Returns the variable of the coefficient pointed to by \c *this.
    /*!
      \returns the variable of the coefficient pointed to by \c *this.
    */
    Variable variable() const;

    //! Compares \p *this with \p i.
    /*!
      \param i
      The %iterator that will be compared with *this.
    */
    bool operator==(const const_iterator& i) const;

    //! Compares \p *this with \p i .
    /*!
      \param i
      The %iterator that will be compared with *this.
    */
    bool operator!=(const const_iterator& i) const;

  private:
    //! Constructor from a const_iterator_interface*.
    //! The new object takes ownership of the dynamic object.
    const_iterator(Linear_Expression_Interface::const_iterator_interface* i);

    Linear_Expression_Interface::const_iterator_interface* itr;

    friend class Linear_Expression;
  };

  //! Returns an iterator that points to the first nonzero coefficient in the
  //! expression.
  const_iterator begin() const;

  //! Returns an iterator that points to the last nonzero coefficient in the
  //! expression.
  const_iterator end() const;

  //! Returns an iterator that points to the first nonzero coefficient of a
  //! variable bigger than or equal to v.
  const_iterator lower_bound(Variable v) const;

  //! Returns the maximum space dimension a Linear_Expression can handle.
  static dimension_type max_space_dimension();

  //! Returns the dimension of the vector space enclosing \p *this.
  dimension_type space_dimension() const;

  //! Sets the dimension of the vector space enclosing \p *this to \p n .
  void set_space_dimension(dimension_type n);

  //! Returns the coefficient of \p v in \p *this.
  Coefficient_traits::const_reference coefficient(Variable v) const;

  //! Sets the coefficient of \p v in \p *this to \p n.
  void set_coefficient(Variable v,
                       Coefficient_traits::const_reference n);

  //! Returns the inhomogeneous term of \p *this.
  Coefficient_traits::const_reference inhomogeneous_term() const;

  //! Sets the inhomogeneous term of \p *this to \p n.
  void set_inhomogeneous_term(Coefficient_traits::const_reference n);

  //! Linearly combines \p *this with \p y so that the coefficient of \p v
  //! is 0.
  /*!
    \param y
    The expression that will be combined with \p *this object;

    \param v
    The variable whose coefficient has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the coefficient of variable \p v equal to \f$0\f$. Then it assigns
    the resulting expression to \p *this.

    \p *this and \p y must have the same space dimension.
  */
  void linear_combine(const Linear_Expression& y, Variable v);

  //! Equivalent to <CODE>*this = *this * c1 + y * c2</CODE>, but assumes that
  //! c1 and c2 are not 0.
  void linear_combine(const Linear_Expression& y,
                      Coefficient_traits::const_reference c1,
                      Coefficient_traits::const_reference c2);

  //! Equivalent to <CODE>*this = *this * c1 + y * c2</CODE>.
  //! c1 and c2 may be 0.
  void linear_combine_lax(const Linear_Expression& y,
                          Coefficient_traits::const_reference c1,
                          Coefficient_traits::const_reference c2);

  //! Swaps the coefficients of the variables \p v1 and \p v2 .
  void swap_space_dimensions(Variable v1, Variable v2);

  //! Removes all the specified dimensions from the expression.
  /*!
    The space dimension of the variable with the highest space
    dimension in \p vars must be at most the space dimension
    of \p this.
  */
  void remove_space_dimensions(const Variables_Set& vars);

  //! Shift by \p n positions the coefficients of variables, starting from
  //! the coefficient of \p v. This increases the space dimension by \p n.
  void shift_space_dimensions(Variable v, dimension_type n);

  //! Permutes the space dimensions of the expression.
  /*!
    \param cycle
    A vector representing a cycle of the permutation according to which the
    space dimensions must be rearranged.

    The \p cycle vector represents a cycle of a permutation of space
    dimensions.
    For example, the permutation
    \f$ \{ x_1 \mapsto x_2, x_2 \mapsto x_3, x_3 \mapsto x_1 \}\f$ can be
    represented by the vector containing \f$ x_1, x_2, x_3 \f$.
  */
  void permute_space_dimensions(const std::vector<Variable>& cycle);

  //! Returns <CODE>true</CODE> if and only if \p *this is \f$0\f$.
  bool is_zero() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if all the homogeneous
    terms of \p *this are \f$0\f$.
  */
  bool all_homogeneous_terms_are_zero() const;

  //! Initializes the class.
  static void initialize();

  //! Finalizes the class.
  static void finalize();

  //! Returns the (zero-dimension space) constant 0.
  static const Linear_Expression& zero();

  /*! \brief
    Returns a lower bound to the total size in bytes of the memory
    occupied by \p *this.
  */
  memory_size_type total_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  memory_size_type external_memory_in_bytes() const;

  //! Checks if all the invariants are satisfied.
  bool OK() const;

  PPL_OUTPUT_DECLARATIONS

  /*! \brief
    Loads from \p s an ASCII representation (as produced by
    ascii_dump(std::ostream&) const) and sets \p *this accordingly.
    Returns <CODE>true</CODE> if successful, <CODE>false</CODE> otherwise.
  */
  bool ascii_load(std::istream& s);

  //! Swaps \p *this with \p y.
  void m_swap(Linear_Expression& y);

  //! Copy constructor with a specified space dimension.
  Linear_Expression(const Linear_Expression& e, dimension_type space_dim);

  //! Copy constructor with a specified space dimension and representation.
  Linear_Expression(const Linear_Expression& e, dimension_type space_dim,
                    Representation r);

  //! Returns \p true if *this is equal to \p x.
  //! Note that (*this == x) has a completely different meaning.
  bool is_equal_to(const Linear_Expression& x) const;

  //! Normalizes the modulo of the coefficients and of the inhomogeneous term
  //! so that they are mutually prime.
  /*!
    Computes the Greatest Common Divisor (GCD) among the coefficients
    and the inhomogeneous term and normalizes them by the GCD itself.
  */
  void normalize();

  //! Ensures that the first nonzero homogeneous coefficient is positive,
  //! by negating the row if necessary.
  void sign_normalize();

  /*! \brief
    Returns <CODE>true</CODE> if the coefficient of each variable in
    \p vars[i] is \f$0\f$.
  */
  bool all_zeroes(const Variables_Set& vars) const;

private:
  /*! \brief
    Holds (between class initialization and finalization) a pointer to
    the (zero-dimension space) constant 0.
  */
  static const Linear_Expression* zero_p;

  Linear_Expression_Interface* impl;

  //! Implementation sizing constructor.
  /*!
    The bool parameter is just to avoid problems with
    the constructor Linear_Expression(Coefficient_traits::const_reference n).
  */
  Linear_Expression(dimension_type space_dim, bool,
                    Representation r = default_representation);

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns the i-th coefficient.
  Coefficient_traits::const_reference get(dimension_type i) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Sets the i-th coefficient to n.
  void set(dimension_type i, Coefficient_traits::const_reference n);

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Returns the coefficient of v.
  Coefficient_traits::const_reference get(Variable v) const;

  // NOTE: This method is public, but it's not exposed in Linear_Expression,
  // so that it can be used internally in the PPL, by friends of
  // Linear_Expression.
  //! Sets the coefficient of v to n.
  void set(Variable v, Coefficient_traits::const_reference n);

  /*! \brief
    Returns <CODE>true</CODE> if (*this)[i] is \f$0\f$, for each i in
    [start, end).
  */
  bool all_zeroes(dimension_type start, dimension_type end) const;

  /*! \brief
    Returns the number of zero coefficient in [start, end).
  */
  dimension_type num_zeroes(dimension_type start, dimension_type end) const;

  /*! \brief
    Returns the gcd of the nonzero coefficients in [start,end). If all the
    coefficients in this range are 0 returns 0.
  */
  Coefficient gcd(dimension_type start, dimension_type end) const;

  void exact_div_assign(Coefficient_traits::const_reference c,
                        dimension_type start, dimension_type end);

  //! Linearly combines \p *this with \p y so that the coefficient of \p v
  //! is 0.
  /*!
    \param y
    The expression that will be combined with \p *this object;

    \param i
    The index of the coefficient that has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the i-th coefficient equal to \f$0\f$. Then it assigns
    the resulting expression to \p *this.

    \p *this and \p y must have the same space dimension.
  */
  void linear_combine(const Linear_Expression& y, dimension_type i);

  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end). It assumes that c1 and c2 are nonzero.
  void linear_combine(const Linear_Expression& y,
                      Coefficient_traits::const_reference c1,
                      Coefficient_traits::const_reference c2,
                      dimension_type start, dimension_type end);

  //! Equivalent to <CODE>(*this)[i] = (*this)[i] * c1 + y[i] * c2</CODE>,
  //! for each i in [start, end). c1 and c2 may be zero.
  void linear_combine_lax(const Linear_Expression& y,
                          Coefficient_traits::const_reference c1,
                          Coefficient_traits::const_reference c2,
                          dimension_type start, dimension_type end);

  //! Equivalent to <CODE>(*this)[i] *= n</CODE>, for each i in [start, end).
  void mul_assign(Coefficient_traits::const_reference n,
                  dimension_type start, dimension_type end);

  //! Returns the index of the last nonzero element, or 0 if there are no
  //! nonzero elements.
  dimension_type last_nonzero() const;

  //! Returns the index of the last nonzero element in [first,last), or last
  //! if there are no nonzero elements.
  dimension_type last_nonzero(dimension_type first, dimension_type last) const;

  //! Returns the index of the first nonzero element, or \p last if there are no
  //! nonzero elements, considering only elements in [first,last).
  dimension_type first_nonzero(dimension_type first, dimension_type last) const;

  /*! \brief
    Returns <CODE>true</CODE> if all coefficients in [start,end),
    except those corresponding to variables in \p vars, are zero.
  */
  bool all_zeroes_except(const Variables_Set& vars,
                         dimension_type start, dimension_type end) const;

  //! Sets results to the sum of (*this)[i]*y[i], for each i.
  void scalar_product_assign(Coefficient& result,
                             const Linear_Expression& y) const;

  //! Sets results to the sum of (*this)[i]*y[i], for each i in [start,end).
  void scalar_product_assign(Coefficient& result, const Linear_Expression& y,
                             dimension_type start, dimension_type end) const;

  //! Computes the sign of the sum of (*this)[i]*y[i], for each i.
  int scalar_product_sign(const Linear_Expression& y) const;

  //! Computes the sign of the sum of (*this)[i]*y[i],
  //! for each i in [start,end).
  int scalar_product_sign(const Linear_Expression& y,
                          dimension_type start, dimension_type end) const;

  //! Removes from the set x all the indexes of nonzero elements of *this.
  void has_a_free_dimension_helper(std::set<dimension_type>& x) const;

  //! Returns \p true if (*this)[i] is equal to x[i], for each i in [start,end).
  bool is_equal_to(const Linear_Expression& x,
                   dimension_type start, dimension_type end) const;

  //! Returns \p true if (*this)[i]*c1 is equal to x[i]*c2, for each i in
  //! [start,end).
  bool is_equal_to(const Linear_Expression& x,
                   Coefficient_traits::const_reference c1,
                   Coefficient_traits::const_reference c2,
                   dimension_type start, dimension_type end) const;

  //! Sets \p r to a copy of the row that implements \p *this.
  void get_row(Dense_Row& r) const;

  //! Sets \p r to a copy of the row that implements \p *this.
  void get_row(Sparse_Row& r) const;

  /*! \brief
    Returns \p true if there is a variable from index \p first (included)
    to index \p last (excluded) whose coefficient is nonzero in both
    \p *this and \p x.
  */
  bool have_a_common_variable(const Linear_Expression& x,
                              Variable first, Variable last) const;

  /*! \brief
    Negates the elements from index \p first (included)
    to index \p last (excluded).
  */
  void negate(dimension_type first, dimension_type last);

  template <typename Row>
  friend class Linear_Expression_Impl;

  // NOTE: The following classes are friends of Linear_Expression in order
  // to access its private methods.
  // Since they are *not* friend of Linear_Expression_Impl, they can only
  // access its public methods so they cannot break the class invariant of
  // Linear_Expression_Impl.
  friend class Grid;
  friend class Congruence;
  friend class Polyhedron;
  friend class PIP_Tree_Node;
  friend class Grid_Generator;
  friend class Generator;
  friend class Constraint;
  friend class Constraint_System;
  friend class PIP_Problem;
  friend class BHRZ03_Certificate;
  friend class Scalar_Products;
  friend class MIP_Problem;
  friend class Box_Helpers;
  friend class Congruence_System;
  friend class BD_Shape_Helpers;
  friend class Octagonal_Shape_Helper;
  friend class Termination_Helpers;
  template <typename T>
  friend class BD_Shape;
  template <typename T>
  friend class Octagonal_Shape;
  template <typename T>
  friend class Linear_System;
  template <typename T>
  friend class Box;
  template <typename T>
  friend class Expression_Adapter;
  template <typename T>
  friend class Expression_Hide_Inhomo;
  template <typename T>
  friend class Expression_Hide_Last;

  friend Linear_Expression
  operator+(const Linear_Expression& e1, const Linear_Expression& e2);
  friend Linear_Expression
  operator+(Coefficient_traits::const_reference n, const Linear_Expression& e);
  friend Linear_Expression
  operator+(const Linear_Expression& e, Coefficient_traits::const_reference n);
  friend Linear_Expression
  operator+(Variable v, const Linear_Expression& e);
  friend Linear_Expression
  operator+(Variable v, Variable w);

  friend Linear_Expression
  operator-(const Linear_Expression& e);

  friend Linear_Expression
  operator-(const Linear_Expression& e1, const Linear_Expression& e2);
  friend Linear_Expression
  operator-(Variable v, Variable w);
  friend Linear_Expression
  operator-(Coefficient_traits::const_reference n, const Linear_Expression& e);
  friend Linear_Expression
  operator-(const Linear_Expression& e, Coefficient_traits::const_reference n);
  friend Linear_Expression
  operator-(Variable v, const Linear_Expression& e);
  friend Linear_Expression
  operator-(const Linear_Expression& e, Variable v);

  friend Linear_Expression
  operator*(Coefficient_traits::const_reference n, const Linear_Expression& e);
  friend Linear_Expression
  operator*(const Linear_Expression& e, Coefficient_traits::const_reference n);

  friend Linear_Expression&
  operator+=(Linear_Expression& e1, const Linear_Expression& e2);
  friend Linear_Expression&
  operator+=(Linear_Expression& e, Variable v);
  friend Linear_Expression&
  operator+=(Linear_Expression& e, Coefficient_traits::const_reference n);

  friend Linear_Expression&
  operator-=(Linear_Expression& e1, const Linear_Expression& e2);
  friend Linear_Expression&
  operator-=(Linear_Expression& e, Variable v);
  friend Linear_Expression&
  operator-=(Linear_Expression& e, Coefficient_traits::const_reference n);

  friend Linear_Expression&
  operator*=(Linear_Expression& e, Coefficient_traits::const_reference n);
  friend Linear_Expression&
  operator/=(Linear_Expression& e, Coefficient_traits::const_reference n);

  friend void
  neg_assign(Linear_Expression& e);

  friend Linear_Expression&
  add_mul_assign(Linear_Expression& e,
                 Coefficient_traits::const_reference n, Variable v);
  friend Linear_Expression&
  sub_mul_assign(Linear_Expression& e,
                 Coefficient_traits::const_reference n, Variable v);

  friend void
  add_mul_assign(Linear_Expression& e1,
                 Coefficient_traits::const_reference factor,
                 const Linear_Expression& e2);
  friend void
  sub_mul_assign(Linear_Expression& e1,
                 Coefficient_traits::const_reference factor,
                 const Linear_Expression& e2);

  friend int
  compare(const Linear_Expression& x, const Linear_Expression& y);

  friend std::ostream&
  Parma_Polyhedra_Library::IO_Operators
  ::operator<<(std::ostream& s, const Linear_Expression& e);
};

namespace Parma_Polyhedra_Library {

//! Swaps \p x with \p y.
/*! \relates Linear_Expression */
void swap(Linear_Expression& x, Linear_Expression& y);

//! Swaps \p x with \p y.
/*! \relates Linear_Expression::const_iterator */
void swap(Linear_Expression::const_iterator& x,
          Linear_Expression::const_iterator& y);

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Expression_inlines.hh line 1. */
/* Linear_Expression class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Linear_Expression_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

inline Linear_Expression&
Linear_Expression::operator=(const Linear_Expression& e) {
  Linear_Expression tmp = e;
  swap(*this, tmp);
  return *this;
}

inline
Linear_Expression::~Linear_Expression() {
  delete impl;
}

inline Representation
Linear_Expression::representation() const {
  return impl->representation();
}

inline dimension_type
Linear_Expression::space_dimension() const {
  return impl->space_dimension();
}

inline void
Linear_Expression::set_space_dimension(dimension_type n) {
  impl->set_space_dimension(n);
}

inline Coefficient_traits::const_reference
Linear_Expression::coefficient(Variable v) const {
  return impl->coefficient(v);
}

inline void
Linear_Expression
::set_coefficient(Variable v, Coefficient_traits::const_reference n) {
  impl->set_coefficient(v, n);
}

inline Coefficient_traits::const_reference
Linear_Expression::inhomogeneous_term() const {
  return impl->inhomogeneous_term();
}

inline void
Linear_Expression
::set_inhomogeneous_term(Coefficient_traits::const_reference n) {
  impl->set_inhomogeneous_term(n);
}

inline void
Linear_Expression::swap_space_dimensions(Variable v1, Variable v2) {
  impl->swap_space_dimensions(v1, v2);
}

inline void
Linear_Expression::shift_space_dimensions(Variable v, dimension_type n) {
  impl->shift_space_dimensions(v, n);
}

inline bool
Linear_Expression::is_zero() const {
  return impl->is_zero();
}

inline bool
Linear_Expression::all_homogeneous_terms_are_zero() const {
  return impl->all_homogeneous_terms_are_zero();
}

inline const Linear_Expression&
Linear_Expression::zero() {
  PPL_ASSERT(zero_p != 0);
  return *zero_p;
}

inline memory_size_type
Linear_Expression::external_memory_in_bytes() const {
  return impl->total_memory_in_bytes();
}

inline memory_size_type
Linear_Expression::total_memory_in_bytes() const {
  return external_memory_in_bytes() + sizeof(*this);
}

/*! \relates Linear_Expression */
inline Linear_Expression
operator+(const Linear_Expression& e) {
  return e;
}

/*! \relates Linear_Expression */
inline Linear_Expression
operator+(const Linear_Expression& e, Coefficient_traits::const_reference n) {
  Linear_Expression x = e;
  x += n;
  return x;
}

/*! \relates Linear_Expression */
inline Linear_Expression
operator+(const Linear_Expression& e, const Variable v) {
  Linear_Expression x = e;
  x += v;
  return x;
}

/*! \relates Linear_Expression */
inline Linear_Expression
operator-(const Linear_Expression& e, Coefficient_traits::const_reference n) {
  Linear_Expression x = e;
  x -= n;
  return x;
}

/*! \relates Linear_Expression */
inline Linear_Expression
operator-(const Variable v, const Variable w) {
  const dimension_type v_space_dim = v.space_dimension();
  const dimension_type w_space_dim = w.space_dimension();
  const dimension_type space_dim = std::max(v_space_dim, w_space_dim);
  if (space_dim > Linear_Expression::max_space_dimension()) {
    throw std::length_error("Linear_Expression "
                            "PPL::operator+(v, w):\n"
                            "v or w exceed the maximum allowed "
                            "space dimension.");
  }
  if (v_space_dim >= w_space_dim) {
    Linear_Expression e(v);
    e -= w;
    return e;
  }
  else {
    Linear_Expression e(w.space_dimension(), true);
    e -= w;
    e += v;
    return e;
  }
}

/*! \relates Linear_Expression */
inline Linear_Expression
operator*(const Linear_Expression& e, Coefficient_traits::const_reference n) {
  Linear_Expression x = e;
  x *= n;
  return x;
}

/*! \relates Linear_Expression */
inline Linear_Expression&
operator+=(Linear_Expression& e, Coefficient_traits::const_reference n) {
  *e.impl += n;
  return e;
}

/*! \relates Linear_Expression */
inline Linear_Expression&
operator-=(Linear_Expression& e, Coefficient_traits::const_reference n) {
  *e.impl -= n;
  return e;
}

inline void
Linear_Expression::m_swap(Linear_Expression& y) {
  using std::swap;
  swap(impl, y.impl);
}

inline void
Linear_Expression::normalize() {
  impl->normalize();
}

inline void
Linear_Expression::ascii_dump(std::ostream& s) const {
  impl->ascii_dump(s);
}

inline bool
Linear_Expression::ascii_load(std::istream& s) {
  return impl->ascii_load(s);
}

inline void
Linear_Expression::remove_space_dimensions(const Variables_Set& vars) {
  impl->remove_space_dimensions(vars);
}

inline void
Linear_Expression::permute_space_dimensions(const std::vector<Variable>& cycle) {
  impl->permute_space_dimensions(cycle);
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression
operator+(const Linear_Expression& e1, const Linear_Expression& e2) {
  if (e1.space_dimension() >= e2.space_dimension()) {
    Linear_Expression e = e1;
    e += e2;
    return e;
  }
  else {
    Linear_Expression e = e2;
    e += e1;
    return e;
  }
}

/*! \relates Linear_Expression */
inline Linear_Expression
operator+(const Variable v, const Linear_Expression& e) {
  return e + v;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression
operator+(Coefficient_traits::const_reference n,
               const Linear_Expression& e) {
  return e + n;
}

/*! \relates Linear_Expression */
inline Linear_Expression
operator+(const Variable v, const Variable w) {
  const dimension_type v_space_dim = v.space_dimension();
  const dimension_type w_space_dim = w.space_dimension();
  const dimension_type space_dim = std::max(v_space_dim, w_space_dim);
  if (space_dim > Linear_Expression::max_space_dimension()) {
    throw std::length_error("Linear_Expression "
                            "PPL::operator+(v, w):\n"
                            "v or w exceed the maximum allowed "
                            "space dimension.");
  }
  if (v_space_dim >= w_space_dim) {
    Linear_Expression e(v);
    e += w;
    return e;
  }
  else {
    Linear_Expression e(w);
    e += v;
    return e;
  }
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression
operator-(const Linear_Expression& e) {
  Linear_Expression r(e);
  neg_assign(r);
  return r;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression
operator-(const Linear_Expression& e1, const Linear_Expression& e2) {
  if (e1.space_dimension() >= e2.space_dimension()) {
    Linear_Expression e = e1;
    e -= e2;
    return e;
  }
  else {
    Linear_Expression e = e2;
    neg_assign(e);
    e += e1;
    return e;
  }
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression
operator-(const Variable v, const Linear_Expression& e) {
  Linear_Expression result(e, std::max(v.space_dimension(), e.space_dimension()));
  result.negate(0, e.space_dimension() + 1);
  result += v;
  return result;
}

/*! \relates Linear_Expression */
inline Linear_Expression
operator-(const Linear_Expression& e, const Variable v) {
  Linear_Expression result(e, std::max(v.space_dimension(), e.space_dimension()));
  result -= v;
  return result;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression
operator-(Coefficient_traits::const_reference n,
               const Linear_Expression& e) {
  Linear_Expression result(e);
  neg_assign(result);
  result += n;
  return result;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression
operator*(Coefficient_traits::const_reference n,
               const Linear_Expression& e) {
  return e * n;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression&
operator+=(Linear_Expression& e1, const Linear_Expression& e2) {
  *e1.impl += *e2.impl;
  return e1;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression&
operator+=(Linear_Expression& e, const Variable v) {
  *e.impl += v;
  return e;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression&
operator-=(Linear_Expression& e1, const Linear_Expression& e2) {
  *e1.impl -= *e2.impl;
  return e1;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression&
operator-=(Linear_Expression& e, const Variable v) {
  *e.impl -= v;
  return e;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression&
operator*=(Linear_Expression& e, Coefficient_traits::const_reference n) {
  *e.impl *= n;
  return e;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression&
operator/=(Linear_Expression& e, Coefficient_traits::const_reference n) {
  *e.impl /= n;
  return e;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline void
neg_assign(Linear_Expression& e) {
  e.impl->negate();
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression&
add_mul_assign(Linear_Expression& e,
               Coefficient_traits::const_reference n,
               const Variable v) {
  e.impl->add_mul_assign(n, v);
  return e;
}

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline Linear_Expression&
sub_mul_assign(Linear_Expression& e,
                    Coefficient_traits::const_reference n,
                    const Variable v) {
  e.impl->sub_mul_assign(n, v);
  return e;
}

inline void
add_mul_assign(Linear_Expression& e1,
               Coefficient_traits::const_reference factor,
               const Linear_Expression& e2) {
  e1.impl->add_mul_assign(factor, *e2.impl);
}

inline void
sub_mul_assign(Linear_Expression& e1,
                    Coefficient_traits::const_reference factor,
                    const Linear_Expression& e2) {
  e1.impl->sub_mul_assign(factor, *e2.impl);
}

inline Coefficient_traits::const_reference
Linear_Expression::get(dimension_type i) const {
  return impl->get(i);
}

inline void
Linear_Expression::set(dimension_type i,
                       Coefficient_traits::const_reference n) {
  impl->set(i, n);
}

inline Coefficient_traits::const_reference
Linear_Expression::get(Variable v) const {
  return impl->get(v.space_dimension());
}

inline void
Linear_Expression::set(Variable v,
                       Coefficient_traits::const_reference n) {
  impl->set(v.space_dimension(), n);
}

inline bool
Linear_Expression::all_zeroes(dimension_type start, dimension_type end) const {
  return impl->all_zeroes(start, end);
}

inline dimension_type
Linear_Expression::num_zeroes(dimension_type start, dimension_type end) const {
  return impl->num_zeroes(start, end);
}

inline Coefficient
Linear_Expression::gcd(dimension_type start, dimension_type end) const {
  return impl->gcd(start, end);
}

inline void
Linear_Expression
::exact_div_assign(Coefficient_traits::const_reference c,
                   dimension_type start, dimension_type end) {
  impl->exact_div_assign(c, start, end);
}

inline void
Linear_Expression
::mul_assign(Coefficient_traits::const_reference c,
             dimension_type start, dimension_type end) {
  impl->mul_assign(c, start, end);
}

inline void
Linear_Expression::sign_normalize() {
  impl->sign_normalize();
}

inline void
Linear_Expression::negate(dimension_type first, dimension_type last) {
  impl->negate(first, last);
}

inline bool
Linear_Expression::all_zeroes(const Variables_Set& vars) const {
  return impl->all_zeroes(vars);
}

inline bool
Linear_Expression::all_zeroes_except(const Variables_Set& vars,
                                     dimension_type start,
                                     dimension_type end) const {
  return impl->all_zeroes_except(vars, start, end);
}

inline dimension_type
Linear_Expression::last_nonzero() const {
  return impl->last_nonzero();
}

inline void
Linear_Expression
::scalar_product_assign(Coefficient& result, const Linear_Expression& y) const {
  scalar_product_assign(result, y, 0, space_dimension() + 1);
}

inline void
Linear_Expression
::scalar_product_assign(Coefficient& result, const Linear_Expression& y,
                        dimension_type start, dimension_type end) const {
  impl->scalar_product_assign(result, *(y.impl), start, end);
}

inline int
Linear_Expression
::scalar_product_sign(const Linear_Expression& y) const {
  return scalar_product_sign(y, 0, space_dimension() + 1);
}

inline int
Linear_Expression
::scalar_product_sign(const Linear_Expression& y,
                      dimension_type start, dimension_type end) const {
  return impl->scalar_product_sign(*(y.impl), start, end);
}

inline dimension_type
Linear_Expression
::first_nonzero(dimension_type first, dimension_type last) const {
  return impl->first_nonzero(first, last);
}

inline dimension_type
Linear_Expression
::last_nonzero(dimension_type first, dimension_type last) const {
  return impl->last_nonzero(first, last);
}

inline void
Linear_Expression
::has_a_free_dimension_helper(std::set<dimension_type>& x) const {
  return impl->has_a_free_dimension_helper(x);
}

inline bool
Linear_Expression
::is_equal_to(const Linear_Expression& x,
              dimension_type start, dimension_type end) const {
  return impl->is_equal_to(*(x.impl), start, end);
}

inline bool
Linear_Expression
::is_equal_to(const Linear_Expression& x,
              Coefficient_traits::const_reference c1,
              Coefficient_traits::const_reference c2,
              dimension_type start, dimension_type end) const {
  return impl->is_equal_to(*(x.impl), c1, c2, start, end);
}

inline void
Linear_Expression
::get_row(Dense_Row& r) const {
  return impl->get_row(r);
}

inline void
Linear_Expression
::get_row(Sparse_Row& r) const {
  return impl->get_row(r);
}

inline void
Linear_Expression
::linear_combine(const Linear_Expression& y, dimension_type i) {
  impl->linear_combine(*y.impl, i);
}

inline void
Linear_Expression
::linear_combine(const Linear_Expression& y,
                 Coefficient_traits::const_reference c1,
                 Coefficient_traits::const_reference c2) {
  impl->linear_combine(*y.impl, c1, c2);
}

inline void
Linear_Expression
::linear_combine_lax(const Linear_Expression& y,
                     Coefficient_traits::const_reference c1,
                     Coefficient_traits::const_reference c2) {
  impl->linear_combine_lax(*y.impl, c1, c2);
}

inline int
compare(const Linear_Expression& x, const Linear_Expression& y) {
  return x.impl->compare(*y.impl);
}

inline bool
Linear_Expression::is_equal_to(const Linear_Expression& x) const {
  return impl->is_equal_to(*x.impl);
}

inline void
Linear_Expression::linear_combine(const Linear_Expression& y,
                                  Coefficient_traits::const_reference c1,
                                  Coefficient_traits::const_reference c2,
                                  dimension_type start,
                                  dimension_type end) {
  impl->linear_combine(*y.impl, c1, c2, start, end);
}

inline void
Linear_Expression::linear_combine_lax(const Linear_Expression& y,
                                      Coefficient_traits::const_reference c1,
                                      Coefficient_traits::const_reference c2,
                                      dimension_type start,
                                      dimension_type end) {
  impl->linear_combine_lax(*y.impl, c1, c2, start, end);
}

inline bool
Linear_Expression
::have_a_common_variable(const Linear_Expression& x,
                         Variable first, Variable last) const {
  return impl->have_a_common_variable(*(x.impl), first, last);
}

inline
Linear_Expression::const_iterator
::const_iterator()
  : itr(NULL) {
}

inline
Linear_Expression::const_iterator
::const_iterator(const const_iterator& i)
  : itr(i.itr->clone()) {
}

inline
Linear_Expression::const_iterator
::~const_iterator() {
  // Note that this does nothing if itr == NULL.
  delete itr;
}

inline void
Linear_Expression::const_iterator::m_swap(const_iterator& i) {
  using std::swap;
  swap(itr, i.itr);
}

inline Linear_Expression::const_iterator&
Linear_Expression::const_iterator
::operator=(const const_iterator& i) {
  const_iterator tmp = i;
  using std::swap;
  swap(*this, tmp);
  return *this;
}

inline Linear_Expression::const_iterator&
Linear_Expression::const_iterator
::operator++() {
  PPL_ASSERT(itr != NULL);
  ++(*itr);
  return *this;
}

inline Linear_Expression::const_iterator&
Linear_Expression::const_iterator
::operator--() {
  PPL_ASSERT(itr != NULL);
  --(*itr);
  return *this;
}

inline Linear_Expression::const_iterator::reference
Linear_Expression::const_iterator
::operator*() const {
  PPL_ASSERT(itr != NULL);
  return *(*itr);
}

inline Variable
Linear_Expression::const_iterator
::variable() const {
  PPL_ASSERT(itr != NULL);
  return itr->variable();
}

inline bool
Linear_Expression::const_iterator
::operator==(const const_iterator& i) const {
  PPL_ASSERT(itr != NULL);
  PPL_ASSERT(i.itr != NULL);
  return *itr == *(i.itr);
}

inline bool
Linear_Expression::const_iterator
::operator!=(const const_iterator& i) const {
  return !(*this == i);
}

inline
Linear_Expression::const_iterator
::const_iterator(Linear_Expression_Interface::const_iterator_interface* i)
  : itr(i) {
  PPL_ASSERT(i != NULL);
}

inline Linear_Expression::const_iterator
Linear_Expression
::begin() const {
  return const_iterator(impl->begin());
}

inline Linear_Expression::const_iterator
Linear_Expression
::end() const {
  return const_iterator(impl->end());
}

inline Linear_Expression::const_iterator
Linear_Expression
::lower_bound(Variable v) const {
  return const_iterator(impl->lower_bound(v));
}

template <typename LE_Adapter>
inline
Linear_Expression
::Linear_Expression(const LE_Adapter& e,
                    typename Enable_If<Is_Same_Or_Derived<Expression_Adapter_Base,
                                                          LE_Adapter>::value,
                                       void*>::type)
  : impl(NULL) {
  Linear_Expression tmp(e.representation());
  tmp.set_space_dimension(e.space_dimension());
  tmp.set_inhomogeneous_term(e.inhomogeneous_term());
  for (typename LE_Adapter::const_iterator i = e.begin(),
         i_end = e.end(); i != i_end; ++i) {
    add_mul_assign(tmp, *i, i.variable());
  }
  using std::swap;
  swap(impl, tmp.impl);
}

template <typename LE_Adapter>
inline
Linear_Expression
::Linear_Expression(const LE_Adapter& e,
                    Representation r,
                    typename Enable_If<Is_Same_Or_Derived<Expression_Adapter_Base,
                                                          LE_Adapter>::value,
                                       void*>::type)
  : impl(NULL) {
  Linear_Expression tmp(r);
  tmp.set_space_dimension(e.space_dimension());
  tmp.set_inhomogeneous_term(e.inhomogeneous_term());
  for (typename LE_Adapter::const_iterator i = e.begin(),
         i_end = e.end(); i != i_end; ++i) {
    add_mul_assign(tmp, *i, i.variable());
  }
  using std::swap;
  swap(impl, tmp.impl);
}

template <typename LE_Adapter>
inline
Linear_Expression
::Linear_Expression(const LE_Adapter& e,
                    dimension_type space_dim,
                    typename Enable_If<Is_Same_Or_Derived<Expression_Adapter_Base,
                                                          LE_Adapter>::value,
                                       void*>::type)
  : impl(NULL) {
  Linear_Expression tmp(e.representation());
  tmp.set_space_dimension(space_dim);
  tmp.set_inhomogeneous_term(e.inhomogeneous_term());
  typedef typename LE_Adapter::const_iterator itr_t;
  itr_t i_end;
  if (space_dim <= e.space_dimension()) {
    i_end = e.lower_bound(Variable(space_dim));
  }
  else {
    i_end = e.end();
  }
  for (itr_t i = e.begin(); i != i_end; ++i) {
    add_mul_assign(tmp, *i, i.variable());
  }
  using std::swap;
  swap(impl, tmp.impl);
}

template <typename LE_Adapter>
inline
Linear_Expression
::Linear_Expression(const LE_Adapter& e,
                    dimension_type space_dim,
                    Representation r,
                    typename Enable_If<Is_Same_Or_Derived<Expression_Adapter_Base,
                                                          LE_Adapter>::value,
                                       void*>::type)
  : impl(NULL) {
  Linear_Expression tmp(r);
  tmp.set_space_dimension(space_dim);
  tmp.set_inhomogeneous_term(e.inhomogeneous_term());
  typedef typename LE_Adapter::const_iterator itr_t;
  itr_t i_end;
  if (space_dim <= e.space_dimension()) {
    i_end = e.lower_bound(Variable(space_dim));
  }
  else {
    i_end = e.end();
  }
  for (itr_t i = e.begin(); i != i_end; ++i) {
    add_mul_assign(tmp, *i, i.variable());
  }
  using std::swap;
  swap(impl, tmp.impl);
}

namespace IO_Operators {

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline std::ostream&
operator<<(std::ostream& s, const Linear_Expression& e) {
  e.impl->print(s);
  return s;
}

} // namespace IO_Operators

/*! \relates Parma_Polyhedra_Library::Linear_Expression */
inline void
swap(Linear_Expression& x, Linear_Expression& y) {
  x.m_swap(y);
}

/*! \relates Linear_Expression::const_iterator */
inline void
swap(Linear_Expression::const_iterator& x,
     Linear_Expression::const_iterator& y) {
  x.m_swap(y);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Linear_Expression_defs.hh line 946. */

/* Automatically generated from PPL source file ../src/Topology_types.hh line 1. */


namespace Parma_Polyhedra_Library {

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! Kinds of polyhedra domains.
/*! \ingroup PPL_CXX_interface */
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
enum Topology {
  NECESSARILY_CLOSED = 0,
  NOT_NECESSARILY_CLOSED = 1
};

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Expression_Hide_Last_defs.hh line 1. */
/* Expression_Hide_Last class declaration.
*/


/* Automatically generated from PPL source file ../src/Expression_Hide_Last_defs.hh line 28. */

/* Automatically generated from PPL source file ../src/Expression_Hide_Last_defs.hh line 32. */

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! An adapter for Linear_Expression that maybe hides the last coefficient.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Parma_Polyhedra_Library::Expression_Hide_Last
  : public Expression_Adapter<T> {
  typedef Expression_Adapter<T> base_type;
public:
  //! The type of this object.
  typedef Expression_Hide_Last<T> const_reference;
  //! The type obtained by one-level unwrapping.
  typedef typename base_type::inner_type inner_type;
  //! The raw, completely unwrapped type.
  typedef typename base_type::raw_type raw_type;

  //! The type of const iterators on coefficients.
  typedef typename base_type::const_iterator const_iterator;

  //! Constructor.
  explicit Expression_Hide_Last(const raw_type& expr, bool hide_last);

  //! Iterator pointing after the last nonzero variable coefficient.
  const_iterator end() const;

  //! Iterator pointing to the first nonzero variable coefficient
  //! of a variable bigger than or equal to \p v.
  const_iterator lower_bound(Variable v) const;

  //! Returns the dimension of the vector space enclosing \p *this.
  dimension_type space_dimension() const;

  //! Returns the coefficient of \p v in \p *this.
  Coefficient_traits::const_reference coefficient(Variable v) const;

  //! Returns <CODE>true</CODE> if and only if \p *this is zero.
  bool is_zero() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if all the homogeneous
    terms of \p *this are zero.
  */
  bool all_homogeneous_terms_are_zero() const;

  /*! \brief Returns \p true if \p *this is equal to \p y.

    Note that <CODE>(*this == y)</CODE> has a completely different meaning.
  */
  template <typename Expression>
  bool is_equal_to(const Expression& y) const;

  /*! \brief
    Returns <CODE>true</CODE> if the coefficient of each variable in
    \p vars is zero.
  */
  bool all_zeroes(const Variables_Set& vars) const;

  //! Returns the \p i -th coefficient.
  Coefficient_traits::const_reference get(dimension_type i) const;

  //! Returns the coefficient of variable \p v.
  Coefficient_traits::const_reference get(Variable v) const;

  /*! \brief
    Returns <CODE>true</CODE> if (*this)[i] is zero,
    for each i in [start, end).
  */
  bool all_zeroes(dimension_type start, dimension_type end) const;

  //! Returns the number of zero coefficient in [start, end).
  dimension_type num_zeroes(dimension_type start, dimension_type end) const;

  /*! \brief
    Returns the gcd of the nonzero coefficients in [start,end).
    Returns zero if all the coefficients in the range are zero.
  */
  Coefficient gcd(dimension_type start, dimension_type end) const;

  //! Returns the index of the last nonzero element, or zero if there are no
  //! nonzero elements.
  dimension_type last_nonzero() const;

  //! Returns the index of the last nonzero element in [first,last),
  //! or \p last if there are no nonzero elements.
  dimension_type last_nonzero(dimension_type first, dimension_type last) const;

  //! Returns the index of the first nonzero element, or \p last if there are no
  //! nonzero elements, considering only elements in [first,last).
  dimension_type first_nonzero(dimension_type first, dimension_type last) const;

  /*! \brief
    Returns <CODE>true</CODE> if all coefficients in [start,end),
    except those corresponding to variables in \p vars, are zero.
  */
  bool all_zeroes_except(const Variables_Set& vars,
                         dimension_type start, dimension_type end) const;

  //! Removes from set \p x all the indexes of nonzero elements in \p *this.
  void has_a_free_dimension_helper(std::set<dimension_type>& x) const;

  //! Returns \c true if <CODE>(*this)[i]</CODE> is equal to <CODE>y[i]</CODE>,
  //! for each i in [start,end).
  template <typename Expression>
  bool is_equal_to(const Expression& y,
                   dimension_type start, dimension_type end) const;

  //! Returns \c true if <CODE>(*this)[i]*c1</CODE> is equal to
  //! <CODE>y[i]*c2</CODE>, for each i in [start,end).
  template <typename Expression>
  bool is_equal_to(const Expression& y,
                   Coefficient_traits::const_reference c1,
                   Coefficient_traits::const_reference c2,
                   dimension_type start, dimension_type end) const;

  //! Sets \p r to a copy of the row as adapted by \p *this.
  void get_row(Dense_Row& r) const;

  //! Sets \p r to a copy of the row as adapted by \p *this.
  void get_row(Sparse_Row& r) const;

  //! Returns \c true if there is a variable in [first,last) whose coefficient
  //! is nonzero in both \p *this and \p y.
  template <typename Expression>
  bool have_a_common_variable(const Expression& y,
                              Variable first, Variable last) const;

private:
  //! Whether or not the last coefficient is hidden.
  const bool hide_last_;
};

/* Automatically generated from PPL source file ../src/Expression_Hide_Last_inlines.hh line 1. */
/* Expression_Hide_Last class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Expression_Hide_Last_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

template <typename T>
inline
Expression_Hide_Last<T>::Expression_Hide_Last(const raw_type& expr,
                                              const bool hide_last)
  : base_type(expr), hide_last_(hide_last) {
}

template <typename T>
inline dimension_type
Expression_Hide_Last<T>::space_dimension() const {
  dimension_type dim = this->inner().space_dimension();
  if (hide_last_) {
    PPL_ASSERT(dim > 0);
    --dim;
  }
  return dim;
}

template <typename T>
inline typename Expression_Hide_Last<T>::const_iterator
Expression_Hide_Last<T>::end() const {
  if (hide_last_) {
    return this->inner().lower_bound(Variable(space_dimension()));
  }
  else {
    return this->inner().end();
  }
}

template <typename T>
inline typename Expression_Hide_Last<T>::const_iterator
Expression_Hide_Last<T>::lower_bound(Variable v) const {
  PPL_ASSERT(v.space_dimension() <= space_dimension() + 1);
  return this->inner().lower_bound(v);
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Hide_Last<T>::coefficient(Variable v) const {
  PPL_ASSERT(v.space_dimension() <= space_dimension());
  return this->inner().coefficient(v);
}

template <typename T>
inline bool
Expression_Hide_Last<T>::is_zero() const {
  return this->inner().all_zeroes(0, space_dimension() + 1);
}

template <typename T>
inline bool
Expression_Hide_Last<T>::all_homogeneous_terms_are_zero() const {
  return this->inner().all_zeroes(1, space_dimension() + 1);
}

template <typename T>
template <typename Expression>
inline bool
Expression_Hide_Last<T>
::is_equal_to(const Expression& y) const {
  const dimension_type x_dim = space_dimension();
  const dimension_type y_dim = y.space_dimension();
  if (x_dim != y_dim) {
    return false;
  }
  return is_equal_to(y, 0, x_dim + 1);
}

template <typename T>
inline bool
Expression_Hide_Last<T>::all_zeroes(const Variables_Set& vars) const {
  PPL_ASSERT(vars.space_dimension() <= space_dimension());
  return this->inner().all_zeroes(vars);
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Hide_Last<T>::get(dimension_type i) const {
  PPL_ASSERT(i <= space_dimension());
  return this->inner().get(i);
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Hide_Last<T>::get(Variable v) const {
  PPL_ASSERT(v.space_dimension() <= space_dimension());
  return this->inner().get(v);
}

template <typename T>
inline bool
Expression_Hide_Last<T>::all_zeroes(dimension_type start,
                                    dimension_type end) const {
  PPL_ASSERT(end <= space_dimension() + 1);
  return this->inner().all_zeroes(start, end);
}

template <typename T>
inline dimension_type
Expression_Hide_Last<T>::num_zeroes(dimension_type start,
                                    dimension_type end) const {
  PPL_ASSERT(end <= space_dimension() + 1);
  return this->inner().num_zeroes(start, end);
}

template <typename T>
inline Coefficient
Expression_Hide_Last<T>::gcd(dimension_type start,
                             dimension_type end) const {
  PPL_ASSERT(end <= space_dimension() + 1);
  return this->inner().gcd(start, end);
}

template <typename T>
inline dimension_type
Expression_Hide_Last<T>::last_nonzero() const {
  return this->inner().last_nonzero(0, space_dimension() + 1);
}

template <typename T>
inline dimension_type
Expression_Hide_Last<T>::last_nonzero(dimension_type first,
                                      dimension_type last) const {
  PPL_ASSERT(last <= space_dimension() + 1);
  return this->inner().last_nonzero(first, last);
}

template <typename T>
inline dimension_type
Expression_Hide_Last<T>::first_nonzero(dimension_type first,
                                       dimension_type last) const {
  PPL_ASSERT(last <= space_dimension() + 1);
  return this->inner().first_nonzero(first, last);
}

template <typename T>
inline bool
Expression_Hide_Last<T>
::all_zeroes_except(const Variables_Set& vars,
                    dimension_type start, dimension_type end) const {
  PPL_ASSERT(end <= space_dimension() + 1);
  return this->inner().all_zeroes_except(vars, start, end);
}

template <typename T>
inline void
Expression_Hide_Last<T>
::has_a_free_dimension_helper(std::set<dimension_type>& x) const {
  if (x.empty()) {
    return;
  }
  PPL_ASSERT(*(--x.end()) <= space_dimension());
  this->inner().has_a_free_dimension_helper(x);
}

template <typename T>
template <typename Expression>
inline bool
Expression_Hide_Last<T>
::is_equal_to(const Expression& y,
              dimension_type start, dimension_type end) const {
  PPL_ASSERT(end <= space_dimension() + 1);
  PPL_ASSERT(end <= y.space_dimension() + 1);
  return this->inner().is_equal_to(y, start, end);
}

template <typename T>
template <typename Expression>
inline bool
Expression_Hide_Last<T>
::is_equal_to(const Expression& y,
              Coefficient_traits::const_reference c1,
              Coefficient_traits::const_reference c2,
              dimension_type start, dimension_type end) const {
  PPL_ASSERT(end <= space_dimension() + 1);
  PPL_ASSERT(end <= y.space_dimension() + 1);
  return this->inner().is_equal_to(y, c1, c2, start, end);
}

template <typename T>
inline void
Expression_Hide_Last<T>::get_row(Dense_Row& r) const {
  this->inner().get_row(r);
  if (hide_last_) {
    PPL_ASSERT(r.size() != 0);
    r.resize(r.size() - 1);
  }
}

template <typename T>
inline void
Expression_Hide_Last<T>::get_row(Sparse_Row& r) const {
  this->inner().get_row(r);
  if (hide_last_) {
    PPL_ASSERT(r.size() != 0);
    r.resize(r.size() - 1);
  }
}

template <typename T>
template <typename Expression>
inline bool
Expression_Hide_Last<T>
::have_a_common_variable(const Expression& y,
                         Variable first, Variable last) const {
  PPL_ASSERT(last.space_dimension() <= space_dimension() + 1);
  PPL_ASSERT(last.space_dimension() <= y.space_dimension() + 1);
  return this->inner().have_a_common_variable(y, first, last);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Expression_Hide_Last_defs.hh line 164. */

/* Automatically generated from PPL source file ../src/Constraint_defs.hh line 40. */

#include <iosfwd>

namespace Parma_Polyhedra_Library {

//! Returns the constraint \p e1 \< \p e2.
/*! \relates Constraint */
Constraint
operator<(const Linear_Expression& e1, const Linear_Expression& e2);

//! Returns the constraint \p v1 \< \p v2.
/*! \relates Constraint */
Constraint
operator<(Variable v1, Variable v2);

//! Returns the constraint \p e \< \p n.
/*! \relates Constraint */
Constraint
operator<(const Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the constraint \p n \< \p e.
/*! \relates Constraint */
Constraint
operator<(Coefficient_traits::const_reference n, const Linear_Expression& e);

//! Returns the constraint \p e1 \> \p e2.
/*! \relates Constraint */
Constraint
operator>(const Linear_Expression& e1, const Linear_Expression& e2);

//! Returns the constraint \p v1 \> \p v2.
/*! \relates Constraint */
Constraint
operator>(Variable v1, Variable v2);

//! Returns the constraint \p e \> \p n.
/*! \relates Constraint */
Constraint
operator>(const Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the constraint \p n \> \p e.
/*! \relates Constraint */
Constraint
operator>(Coefficient_traits::const_reference n, const Linear_Expression& e);

//! Returns the constraint \p e1 = \p e2.
/*! \relates Constraint */
Constraint
operator==(const Linear_Expression& e1, const Linear_Expression& e2);

//! Returns the constraint \p v1 = \p v2.
/*! \relates Constraint */
Constraint
operator==(Variable v1, Variable v2);

//! Returns the constraint \p e = \p n.
/*! \relates Constraint */
Constraint
operator==(const Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the constraint \p n = \p e.
/*! \relates Constraint */
Constraint
operator==(Coefficient_traits::const_reference n, const Linear_Expression& e);

//! Returns the constraint \p e1 \<= \p e2.
/*! \relates Constraint */
Constraint
operator<=(const Linear_Expression& e1, const Linear_Expression& e2);

//! Returns the constraint \p v1 \<= \p v2.
/*! \relates Constraint */
Constraint
operator<=(Variable v1, Variable v2);

//! Returns the constraint \p e \<= \p n.
/*! \relates Constraint */
Constraint
operator<=(const Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the constraint \p n \<= \p e.
/*! \relates Constraint */
Constraint
operator<=(Coefficient_traits::const_reference n, const Linear_Expression& e);

//! Returns the constraint \p e1 \>= \p e2.
/*! \relates Constraint */
Constraint
operator>=(const Linear_Expression& e1, const Linear_Expression& e2);

//! Returns the constraint \p v1 \>= \p v2.
/*! \relates Constraint */
Constraint
operator>=(Variable v1, Variable v2);

//! Returns the constraint \p e \>= \p n.
/*! \relates Constraint */
Constraint
operator>=(const Linear_Expression& e, Coefficient_traits::const_reference n);

//! Returns the constraint \p n \>= \p e.
/*! \relates Constraint */
Constraint
operator>=(Coefficient_traits::const_reference n, const Linear_Expression& e);

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! The basic comparison function.
/*! \relates Constraint
  \return
  The returned absolute value can be \f$0\f$, \f$1\f$ or \f$2\f$.

  \param x
  A row of coefficients;

  \param y
  Another row.

  Compares \p x and \p y, where \p x and \p y may be of different size,
  in which case the "missing" coefficients are assumed to be zero.
  The comparison is such that:
  -# equalities are smaller than inequalities;
  -# lines are smaller than points and rays;
  -# the ordering is lexicographic;
  -# the positions compared are, in decreasing order of significance,
     1, 2, ..., \p size(), 0;
  -# the result is negative, zero, or positive if x is smaller than,
     equal to, or greater than y, respectively;
  -# when \p x and \p y are different, the absolute value of the
     result is 1 if the difference is due to the coefficient in
     position 0; it is 2 otherwise.

  When \p x and \p y represent the hyper-planes associated
  to two equality or inequality constraints, the coefficient
  at 0 is the known term.
  In this case, the return value can be characterized as follows:
  - -2, if \p x is smaller than \p y and they are \e not parallel;
  - -1, if \p x is smaller than \p y and they \e are parallel;
  -  0, if \p x and y are equal;
  - +1, if \p y is smaller than \p x and they \e are parallel;
  - +2, if \p y is smaller than \p x and they are \e not parallel.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
int compare(const Constraint& x, const Constraint& y);

}

//! A linear equality or inequality.
/*! \ingroup PPL_CXX_interface
  An object of the class Constraint is either:
  - an equality: \f$\sum_{i=0}^{n-1} a_i x_i + b = 0\f$;
  - a non-strict inequality: \f$\sum_{i=0}^{n-1} a_i x_i + b \geq 0\f$; or
  - a strict inequality: \f$\sum_{i=0}^{n-1} a_i x_i + b > 0\f$;

  where \f$n\f$ is the dimension of the space,
  \f$a_i\f$ is the integer coefficient of variable \f$x_i\f$
  and \f$b\f$ is the integer inhomogeneous term.

  \par How to build a constraint
  Constraints are typically built by applying a relation symbol
  to a pair of linear expressions.
  Available relation symbols are equality (<CODE>==</CODE>),
  non-strict inequalities (<CODE>\>=</CODE> and <CODE>\<=</CODE>) and
  strict inequalities (<CODE>\<</CODE> and <CODE>\></CODE>).
  The space dimension of a constraint is defined as the maximum
  space dimension of the arguments of its constructor.

  \par
  In the following examples it is assumed that variables
  <CODE>x</CODE>, <CODE>y</CODE> and <CODE>z</CODE>
  are defined as follows:
  \code
  Variable x(0);
  Variable y(1);
  Variable z(2);
  \endcode

  \par Example 1
  The following code builds the equality constraint
  \f$3x + 5y - z = 0\f$, having space dimension \f$3\f$:
  \code
  Constraint eq_c(3*x + 5*y - z == 0);
  \endcode
  The following code builds the (non-strict) inequality constraint
  \f$4x \geq 2y - 13\f$, having space dimension \f$2\f$:
  \code
  Constraint ineq_c(4*x >= 2*y - 13);
  \endcode
  The corresponding strict inequality constraint
  \f$4x > 2y - 13\f$ is obtained as follows:
  \code
  Constraint strict_ineq_c(4*x > 2*y - 13);
  \endcode
  An unsatisfiable constraint on the zero-dimension space \f$\Rset^0\f$
  can be specified as follows:
  \code
  Constraint false_c = Constraint::zero_dim_false();
  \endcode
  Equivalent, but more involved ways are the following:
  \code
  Constraint false_c1(Linear_Expression::zero() == 1);
  Constraint false_c2(Linear_Expression::zero() >= 1);
  Constraint false_c3(Linear_Expression::zero() > 0);
  \endcode
  In contrast, the following code defines an unsatisfiable constraint
  having space dimension \f$3\f$:
  \code
  Constraint false_c(0*z == 1);
  \endcode

  \par How to inspect a constraint
  Several methods are provided to examine a constraint and extract
  all the encoded information: its space dimension, its type
  (equality, non-strict inequality, strict inequality) and
  the value of its integer coefficients.

  \par Example 2
  The following code shows how it is possible to access each single
  coefficient of a constraint. Given an inequality constraint
  (in this case \f$x - 5y + 3z \leq 4\f$), we construct a new constraint
  corresponding to its complement (thus, in this case we want to obtain
  the strict inequality constraint \f$x - 5y + 3z > 4\f$).
  \code
  Constraint c1(x - 5*y + 3*z <= 4);
  cout << "Constraint c1: " << c1 << endl;
  if (c1.is_equality())
    cout << "Constraint c1 is not an inequality." << endl;
  else {
    Linear_Expression e;
    for (dimension_type i = c1.space_dimension(); i-- > 0; )
      e += c1.coefficient(Variable(i)) * Variable(i);
    e += c1.inhomogeneous_term();
    Constraint c2 = c1.is_strict_inequality() ? (e <= 0) : (e < 0);
    cout << "Complement c2: " << c2 << endl;
  }
  \endcode
  The actual output is the following:
  \code
  Constraint c1: -A + 5*B - 3*C >= -4
  Complement c2: A - 5*B + 3*C > 4
  \endcode
  Note that, in general, the particular output obtained can be
  syntactically different from the (semantically equivalent)
  constraint considered.
*/
class Parma_Polyhedra_Library::Constraint {
public:

  //! The constraint type.
  enum Type {
    /*! The constraint is an equality. */
    EQUALITY,
    /*! The constraint is a non-strict inequality. */
    NONSTRICT_INEQUALITY,
    /*! The constraint is a strict inequality. */
    STRICT_INEQUALITY
  };

  //! The representation used for new Constraints.
  /*!
    \note The copy constructor and the copy constructor with specified size
          use the representation of the original object, so that it is
          indistinguishable from the original object.
  */
  static const Representation default_representation = SPARSE;

  //! Constructs the \f$0<=0\f$ constraint.
  explicit Constraint(Representation r = default_representation);

  //! Ordinary copy constructor.
  /*!
    \note The new Constraint will have the same representation as `c',
          not default_representation, so that they are indistinguishable.
  */
  Constraint(const Constraint& c);

  //! Copy constructor with given size.
  /*!
    \note The new Constraint will have the same representation as `c',
          not default_representation, so that they are indistinguishable.
  */
  Constraint(const Constraint& c, dimension_type space_dim);

  //! Copy constructor with given representation.
  Constraint(const Constraint& c, Representation r);

  //! Copy constructor with given size and representation.
  Constraint(const Constraint& c, dimension_type space_dim,
             Representation r);

  //! Copy-constructs from equality congruence \p cg.
  /*!
    \exception std::invalid_argument
    Thrown if \p cg is a proper congruence.
  */
  explicit Constraint(const Congruence& cg,
                      Representation r = default_representation);

  //! Destructor.
  ~Constraint();

  //! Returns the current representation of *this.
  Representation representation() const;

  //! Converts *this to the specified representation.
  void set_representation(Representation r);

  //! Assignment operator.
  Constraint& operator=(const Constraint& c);

  //! Returns the maximum space dimension a Constraint can handle.
  static dimension_type max_space_dimension();

  //! Returns the dimension of the vector space enclosing \p *this.
  dimension_type space_dimension() const;

  //! Sets the dimension of the vector space enclosing \p *this to
  //! \p space_dim .
  void set_space_dimension(dimension_type space_dim);

  //! Swaps the coefficients of the variables \p v1 and \p v2 .
  void swap_space_dimensions(Variable v1, Variable v2);

  //! Removes all the specified dimensions from the constraint.
  /*!
    The space dimension of the variable with the highest space
    dimension in \p vars must be at most the space dimension
    of \p this.

    Always returns \p true. The return value is needed for compatibility with
    the Generator class.
  */
  bool remove_space_dimensions(const Variables_Set& vars);

  //! Permutes the space dimensions of the constraint.
  /*
    \param cycle
    A vector representing a cycle of the permutation according to which the
    space dimensions must be rearranged.

    The \p cycle vector represents a cycle of a permutation of space
    dimensions.
    For example, the permutation
    \f$ \{ x_1 \mapsto x_2, x_2 \mapsto x_3, x_3 \mapsto x_1 \}\f$ can be
    represented by the vector containing \f$ x_1, x_2, x_3 \f$.
  */
  void permute_space_dimensions(const std::vector<Variable>& cycle);

  //! Shift by \p n positions the coefficients of variables, starting from
  //! the coefficient of \p v. This increases the space dimension by \p n.
  void shift_space_dimensions(Variable v, dimension_type n);

  //! Returns the constraint type of \p *this.
  Type type() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if
    \p *this is an equality constraint.
  */
  bool is_equality() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if
    \p *this is an inequality constraint (either strict or non-strict).
  */
  bool is_inequality() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if
    \p *this is a non-strict inequality constraint.
  */
  bool is_nonstrict_inequality() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if
    \p *this is a strict inequality constraint.
  */
  bool is_strict_inequality() const;

  //! Returns the coefficient of \p v in \p *this.
  /*!
    \exception std::invalid_argument thrown if the index of \p v
    is greater than or equal to the space dimension of \p *this.
  */
  Coefficient_traits::const_reference coefficient(Variable v) const;

  //! Returns the inhomogeneous term of \p *this.
  Coefficient_traits::const_reference inhomogeneous_term() const;

  //! Initializes the class.
  static void initialize();

  //! Finalizes the class.
  static void finalize();

  //! The unsatisfiable (zero-dimension space) constraint \f$0 = 1\f$.
  static const Constraint& zero_dim_false();

  /*! \brief
    The true (zero-dimension space) constraint \f$0 \leq 1\f$,
    also known as <EM>positivity constraint</EM>.
  */
  static const Constraint& zero_dim_positivity();

  /*! \brief
    Returns a lower bound to the total size in bytes of the memory
    occupied by \p *this.
  */
  memory_size_type total_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  memory_size_type external_memory_in_bytes() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if
    \p *this is a tautology (i.e., an always true constraint).

    A tautology can have either one of the following forms:
    - an equality: \f$\sum_{i=0}^{n-1} 0 x_i + 0 = 0\f$; or
    - a non-strict inequality: \f$\sum_{i=0}^{n-1} 0 x_i + b \geq 0\f$,
      where \f$b \geq 0\f$; or
    - a strict inequality: \f$\sum_{i=0}^{n-1} 0 x_i + b > 0\f$,
      where \f$b > 0\f$.
  */
  bool is_tautological() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if
    \p *this is inconsistent (i.e., an always false constraint).

    An inconsistent constraint can have either one of the following forms:
    - an equality: \f$\sum_{i=0}^{n-1} 0 x_i + b = 0\f$,
      where \f$b \neq 0\f$; or
    - a non-strict inequality: \f$\sum_{i=0}^{n-1} 0 x_i + b \geq 0\f$,
      where \f$b < 0\f$; or
    - a strict inequality: \f$\sum_{i=0}^{n-1} 0 x_i + b > 0\f$,
      where \f$b \leq 0\f$.
  */
  bool is_inconsistent() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if \p *this and \p y
    are equivalent constraints.

    Constraints having different space dimensions are not equivalent.
    Note that constraints having different types may nonetheless be
    equivalent, if they both are tautologies or inconsistent.
  */
  bool is_equivalent_to(const Constraint& y) const;

  //! Returns <CODE>true</CODE> if \p *this is identical to \p y.
  /*!
    This is faster than is_equivalent_to(), but it may return `false' even
    for equivalent constraints.
  */
  bool is_equal_to(const Constraint& y) const;

  //! Checks if all the invariants are satisfied.
  bool OK() const;

  PPL_OUTPUT_DECLARATIONS

  /*! \brief
    Loads from \p s an ASCII representation (as produced by
    ascii_dump(std::ostream&) const) and sets \p *this accordingly.
    Returns <CODE>true</CODE> if successful, <CODE>false</CODE> otherwise.
  */
  bool ascii_load(std::istream& s);

  //! Swaps \p *this with \p y.
  void m_swap(Constraint& y);

  //! Returns the zero-dimension space constraint \f$\epsilon \geq 0\f$.
  static const Constraint& epsilon_geq_zero();

  /*! \brief
    The zero-dimension space constraint \f$\epsilon \leq 1\f$
    (used to implement NNC polyhedra).
  */
  static const Constraint& epsilon_leq_one();

  //! The type of the (adapted) internal expression.
  typedef Expression_Hide_Last<Linear_Expression> expr_type;
  //! Partial read access to the (adapted) internal expression.
  expr_type expression() const;

private:

  //! The possible kinds of Constraint objects.
  enum Kind {
    LINE_OR_EQUALITY = 0,
    RAY_OR_POINT_OR_INEQUALITY = 1
  };

  Linear_Expression expr;

  Kind kind_;

  Topology topology_;

  /*! \brief
    Holds (between class initialization and finalization) a pointer to
    the unsatisfiable (zero-dimension space) constraint \f$0 = 1\f$.
  */
  static const Constraint* zero_dim_false_p;

  /*! \brief
    Holds (between class initialization and finalization) a pointer to
    the true (zero-dimension space) constraint \f$0 \leq 1\f$, also
    known as <EM>positivity constraint</EM>.
  */
  static const Constraint* zero_dim_positivity_p;

  /*! \brief
    Holds (between class initialization and finalization) a pointer to
    the zero-dimension space constraint \f$\epsilon \geq 0\f$.
  */
  static const Constraint* epsilon_geq_zero_p;

  /*! \brief
    Holds (between class initialization and finalization) a pointer to
    the zero-dimension space constraint \f$\epsilon \leq 1\f$
    (used to implement NNC polyhedra).
  */
  static const Constraint* epsilon_leq_one_p;

  //! Constructs the \f$0<0\f$ constraint.
  Constraint(dimension_type space_dim, Kind kind, Topology topology,
             Representation r = default_representation);

  /*! \brief
    Builds a constraint of kind \p kind and topology \p topology,
    stealing the coefficients from \p e.

    \note The new Constraint will have the same representation as `e'.
  */
  Constraint(Linear_Expression& e, Kind kind, Topology topology);

  /*! \brief
    Builds a constraint of type \p type and topology \p topology,
    stealing the coefficients from \p e.

    \note The new Constraint will have the same representation as `e'.
  */
  Constraint(Linear_Expression& e, Type type, Topology topology);

  /*! \brief
    Returns <CODE>true</CODE> if and only if \p *this row
    represents a line or an equality.
  */
  bool is_line_or_equality() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if \p *this row
    represents a ray, a point or an inequality.
  */
  bool is_ray_or_point_or_inequality() const;

  //! Sets to \p LINE_OR_EQUALITY the kind of \p *this row.
  void set_is_line_or_equality();

  //! Sets to \p RAY_OR_POINT_OR_INEQUALITY the kind of \p *this row.
  void set_is_ray_or_point_or_inequality();

  //! \name Flags inspection methods
  //@{
  //! Returns the topological kind of \p *this.
  Topology topology() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if the topology
    of \p *this row is not necessarily closed.
  */
  bool is_not_necessarily_closed() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if the topology
    of \p *this row is necessarily closed.
  */
  bool is_necessarily_closed() const;
  //@} // Flags inspection methods

  //! \name Flags coercion methods
  //@{

  // TODO: Consider setting the epsilon dimension in this method.
  //! Sets to \p x the topological kind of \p *this row.
  void set_topology(Topology x);

  //! Sets to \p NECESSARILY_CLOSED the topological kind of \p *this row.
  void set_necessarily_closed();

  //! Sets to \p NOT_NECESSARILY_CLOSED the topological kind of \p *this row.
  void set_not_necessarily_closed();
  //@} // Flags coercion methods

  //! Sets the dimension of the vector space enclosing \p *this to
  //! \p space_dim .
  //! Sets the space dimension of the rows in the system to \p space_dim .
  /*!
    This method is for internal use, it does *not* assert OK() at the end,
    so it can be used for invalid objects.
  */
  void set_space_dimension_no_ok(dimension_type space_dim);

  /*! \brief
    Throws a <CODE>std::invalid_argument</CODE> exception containing
    error message \p message.
  */
  void
  throw_invalid_argument(const char* method, const char* message) const;

  /*! \brief
    Throws a <CODE>std::invalid_argument</CODE> exception
    containing the appropriate error message.
  */
  void
  throw_dimension_incompatible(const char* method,
                               const char* name_var,
                               Variable v) const;

  //! Returns the epsilon coefficient. The constraint must be NNC.
  Coefficient_traits::const_reference epsilon_coefficient() const;

  //! Sets the epsilon coefficient to \p n. The constraint must be NNC.
  void set_epsilon_coefficient(Coefficient_traits::const_reference n);

  //! Marks the epsilon dimension as a standard dimension.
  /*!
    The row topology is changed to <CODE>NOT_NECESSARILY_CLOSED</CODE>, and
    the number of space dimensions is increased by 1.
  */
  void mark_as_necessarily_closed();

  //! Marks the last dimension as the epsilon dimension.
  /*!
    The row topology is changed to <CODE>NECESSARILY_CLOSED</CODE>, and
    the number of space dimensions is decreased by 1.
  */
  void mark_as_not_necessarily_closed();

  //! Sets the constraint type to <CODE>EQUALITY</CODE>.
  void set_is_equality();

  //! Sets the constraint to be an inequality.
  /*!
    Whether the constraint type will become <CODE>NONSTRICT_INEQUALITY</CODE>
    or <CODE>STRICT_INEQUALITY</CODE> depends on the topology and the value
    of the low-level coefficients of the constraint.
  */
  void set_is_inequality();

  //! Linearly combines \p *this with \p y so that i-th coefficient is 0.
  /*!
    \param y
    The Constraint that will be combined with \p *this object;

    \param i
    The index of the coefficient that has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the i-th coefficient equal to \f$0\f$. Then it assigns
    the resulting Constraint to \p *this and normalizes it.
  */
  void linear_combine(const Constraint& y, dimension_type i);

  /*! \brief
    Normalizes the sign of the coefficients so that the first non-zero
    (homogeneous) coefficient of a line-or-equality is positive.
  */
  void sign_normalize();

  /*! \brief
    Strong normalization: ensures that different Constraint objects
    represent different hyperplanes or hyperspaces.

    Applies both Constraint::normalize() and Constraint::sign_normalize().
  */
  void strong_normalize();

  /*! \brief
    Returns <CODE>true</CODE> if and only if the coefficients are
    strongly normalized.
  */
  bool check_strong_normalized() const;

  /*! \brief
    Builds a new copy of the zero-dimension space constraint
    \f$\epsilon \geq 0\f$ (used to implement NNC polyhedra).
  */
  static Constraint construct_epsilon_geq_zero();

  friend int
  compare(const Constraint& x, const Constraint& y);

  friend class Linear_System<Constraint>;
  friend class Constraint_System;
  friend class Polyhedron;
  friend class Scalar_Products;
  friend class Topology_Adjusted_Scalar_Product_Sign;
  friend class Termination_Helpers;
  friend class Grid;
  template <typename T>
  friend class Octagonal_Shape;

  friend Constraint
  operator<(const Linear_Expression& e1, const Linear_Expression& e2);

  friend Constraint
  operator<(Variable v1, Variable v2);

  friend Constraint
  operator<(const Linear_Expression& e, Coefficient_traits::const_reference n);

  friend Constraint
  operator<(Coefficient_traits::const_reference n, const Linear_Expression& e);

  friend Constraint
  operator>(const Linear_Expression& e1, const Linear_Expression& e2);

  friend Constraint
  operator>(Variable v1, Variable v2);

  friend Constraint
  operator>(const Linear_Expression& e, Coefficient_traits::const_reference n);

  friend Constraint
  operator>(Coefficient_traits::const_reference n, const Linear_Expression& e);

  friend Constraint
  operator==(const Linear_Expression& e1, const Linear_Expression& e2);

  friend Constraint
  operator==(Variable v1, Variable v2);

  friend Constraint
  operator==(const Linear_Expression& e, Coefficient_traits::const_reference n);

  friend Constraint
  operator==(Coefficient_traits::const_reference n, const Linear_Expression& e);

  friend Constraint
  operator<=(const Linear_Expression& e1, const Linear_Expression& e2);

  friend Constraint
  operator<=(Variable v1, Variable v2);

  friend Constraint
  operator<=(const Linear_Expression& e, Coefficient_traits::const_reference n);

  friend Constraint
  operator<=(Coefficient_traits::const_reference n, const Linear_Expression& e);

  friend Constraint
  operator>=(const Linear_Expression& e1, const Linear_Expression& e2);

  friend Constraint
  operator>=(Variable v1, Variable v2);

  friend Constraint
  operator>=(const Linear_Expression& e, Coefficient_traits::const_reference n);

  friend Constraint
  operator>=(Coefficient_traits::const_reference n, const Linear_Expression& e);
};

namespace Parma_Polyhedra_Library {

namespace IO_Operators {

//! Output operator.
/*! \relates Parma_Polyhedra_Library::Constraint */
std::ostream& operator<<(std::ostream& s, const Constraint& c);

//! Output operator.
/*! \relates Parma_Polyhedra_Library::Constraint */
std::ostream& operator<<(std::ostream& s, const Constraint::Type& t);

} // namespace IO_Operators

//! Returns <CODE>true</CODE> if and only if \p x is equivalent to \p y.
/*! \relates Constraint */
bool
operator==(const Constraint& x, const Constraint& y);

//! Returns <CODE>true</CODE> if and only if \p x is not equivalent to \p y.
/*! \relates Constraint */
bool
operator!=(const Constraint& x, const Constraint& y);

/*! \relates Constraint */
void swap(Constraint& x, Constraint& y);

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Constraint_inlines.hh line 1. */
/* Constraint class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Constraint_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

inline bool
Constraint::is_necessarily_closed() const {
  return (topology_ == NECESSARILY_CLOSED);
}

inline bool
Constraint::is_not_necessarily_closed() const {
  return !is_necessarily_closed();
}

inline Constraint::expr_type
Constraint::expression() const {
  return expr_type(expr, is_not_necessarily_closed());
}

inline dimension_type
Constraint::space_dimension() const {
  return expression().space_dimension();
}

inline void
Constraint::shift_space_dimensions(Variable v, dimension_type n) {
  expr.shift_space_dimensions(v, n);
}

inline bool
Constraint::is_line_or_equality() const {
  return (kind_ == LINE_OR_EQUALITY);
}

inline bool
Constraint::is_ray_or_point_or_inequality() const {
  return (kind_ == RAY_OR_POINT_OR_INEQUALITY);
}

inline Topology
Constraint::topology() const {
  return topology_;
}

inline void
Constraint::set_is_line_or_equality() {
  kind_ = LINE_OR_EQUALITY;
}

inline void
Constraint::set_is_ray_or_point_or_inequality() {
  kind_ = RAY_OR_POINT_OR_INEQUALITY;
}

inline void
Constraint::set_topology(Topology x) {
  if (topology() == x) {
    return;
  }
  if (topology() == NECESSARILY_CLOSED) {
    // Add a column for the epsilon dimension.
    expr.set_space_dimension(expr.space_dimension() + 1);
  }
  else {
    PPL_ASSERT(expr.space_dimension() != 0);
    expr.set_space_dimension(expr.space_dimension() - 1);
  }
  topology_ = x;
}

inline void
Constraint::mark_as_necessarily_closed() {
  PPL_ASSERT(is_not_necessarily_closed());
  topology_ = NECESSARILY_CLOSED;
}

inline void
Constraint::mark_as_not_necessarily_closed() {
  PPL_ASSERT(is_necessarily_closed());
  topology_ = NOT_NECESSARILY_CLOSED;
}

inline void
Constraint::set_necessarily_closed() {
  set_topology(NECESSARILY_CLOSED);
}

inline void
Constraint::set_not_necessarily_closed() {
  set_topology(NOT_NECESSARILY_CLOSED);
}

inline
Constraint::Constraint(Representation r)
  : expr(r),
    kind_(RAY_OR_POINT_OR_INEQUALITY),
    topology_(NECESSARILY_CLOSED) {
  PPL_ASSERT(OK());
}

inline
Constraint::Constraint(dimension_type space_dim, Kind kind, Topology topology,
                       Representation r)
  : expr(r),
    kind_(kind),
    topology_(topology) {
  expr.set_space_dimension(space_dim + 1);
  PPL_ASSERT(space_dimension() == space_dim);
  PPL_ASSERT(OK());
}

inline
Constraint::Constraint(Linear_Expression& e, Kind kind, Topology topology)
  : kind_(kind),
    topology_(topology) {
  PPL_ASSERT(kind != RAY_OR_POINT_OR_INEQUALITY || topology == NOT_NECESSARILY_CLOSED);
  swap(expr, e);
  if (topology == NOT_NECESSARILY_CLOSED) {
    // Add the epsilon dimension.
    expr.set_space_dimension(expr.space_dimension() + 1);
  }
  strong_normalize();
  PPL_ASSERT(OK());
}

inline
Constraint::Constraint(Linear_Expression& e, Type type, Topology topology)
  : topology_(topology) {
  PPL_ASSERT(type != STRICT_INEQUALITY || topology == NOT_NECESSARILY_CLOSED);
  swap(expr, e);
  if (topology == NOT_NECESSARILY_CLOSED) {
    expr.set_space_dimension(expr.space_dimension() + 1);
  }
  if (type == EQUALITY) {
    kind_ = LINE_OR_EQUALITY;
  }
  else {
    kind_ = RAY_OR_POINT_OR_INEQUALITY;
  }
  strong_normalize();
  PPL_ASSERT(OK());
}

inline
Constraint::Constraint(const Constraint& c)
  : expr(c.expr),
    kind_(c.kind_),
    topology_(c.topology_) {
  // NOTE: This does not call PPL_ASSERT(OK()) because this is called by OK().
}

inline
Constraint::Constraint(const Constraint& c, Representation r)
  : expr(c.expr, r),
    kind_(c.kind_),
    topology_(c.topology_) {
  PPL_ASSERT(OK());
}

inline
Constraint::Constraint(const Constraint& c, const dimension_type space_dim)
  : expr(c.expr, c.is_necessarily_closed() ? space_dim : (space_dim + 1)),
    kind_(c.kind_), topology_(c.topology_) {
  PPL_ASSERT(space_dimension() == space_dim);
  PPL_ASSERT(OK());
}

inline
Constraint::Constraint(const Constraint& c, const dimension_type space_dim,
                       Representation r)
  : expr(c.expr, c.is_necessarily_closed() ? space_dim : (space_dim + 1), r),
    kind_(c.kind_), topology_(c.topology_) {
  PPL_ASSERT(space_dimension() == space_dim);
  PPL_ASSERT(OK());
}

inline
Constraint::~Constraint() {
}

inline Constraint&
Constraint::operator=(const Constraint& c) {
  Constraint tmp = c;
  swap(*this, tmp);

  return *this;
}

inline Representation
Constraint::representation() const {
  return expr.representation();
}

inline void
Constraint::set_representation(Representation r) {
  expr.set_representation(r);
}

inline dimension_type
Constraint::max_space_dimension() {
  return Linear_Expression::max_space_dimension();
}

inline void
Constraint::set_space_dimension_no_ok(dimension_type space_dim) {
  const dimension_type old_expr_space_dim = expr.space_dimension();
  if (topology() == NECESSARILY_CLOSED) {
    expr.set_space_dimension(space_dim);
  }
  else {
    const dimension_type old_space_dim = space_dimension();
    if (space_dim > old_space_dim) {
      expr.set_space_dimension(space_dim + 1);
      expr.swap_space_dimensions(Variable(space_dim), Variable(old_space_dim));
    }
    else {
      expr.swap_space_dimensions(Variable(space_dim), Variable(old_space_dim));
      expr.set_space_dimension(space_dim + 1);
    }
  }
  PPL_ASSERT(space_dimension() == space_dim);
  if (expr.space_dimension() < old_expr_space_dim) {
    strong_normalize();
  }
}

inline void
Constraint::set_space_dimension(dimension_type space_dim) {
  set_space_dimension_no_ok(space_dim);
  PPL_ASSERT(OK());
}

inline bool
Constraint::remove_space_dimensions(const Variables_Set& vars) {
  expr.remove_space_dimensions(vars);
  return true;
}

inline bool
Constraint::is_equality() const {
  return is_line_or_equality();
}

inline bool
Constraint::is_inequality() const {
  return is_ray_or_point_or_inequality();
}

inline Constraint::Type
Constraint::type() const {
  if (is_equality()) {
    return EQUALITY;
  }
  if (is_necessarily_closed()) {
    return NONSTRICT_INEQUALITY;
  }
  if (epsilon_coefficient() < 0) {
    return STRICT_INEQUALITY;
  }
  else {
    return NONSTRICT_INEQUALITY;
  }
}

inline bool
Constraint::is_nonstrict_inequality() const {
  return type() == NONSTRICT_INEQUALITY;
}

inline bool
Constraint::is_strict_inequality() const {
  return type() == STRICT_INEQUALITY;
}

inline void
Constraint::set_is_equality() {
  set_is_line_or_equality();
}

inline void
Constraint::set_is_inequality() {
  set_is_ray_or_point_or_inequality();
}

inline Coefficient_traits::const_reference
Constraint::coefficient(const Variable v) const {
  if (v.space_dimension() > space_dimension()) {
    throw_dimension_incompatible("coefficient(v)", "v", v);
  }
  return expr.coefficient(v);
}

inline Coefficient_traits::const_reference
Constraint::inhomogeneous_term() const {
  return expr.inhomogeneous_term();
}

inline memory_size_type
Constraint::external_memory_in_bytes() const {
  return expr.external_memory_in_bytes();
}

inline memory_size_type
Constraint::total_memory_in_bytes() const {
  return sizeof(*this) + external_memory_in_bytes();
}

inline void
Constraint::strong_normalize() {
  expr.normalize();
  sign_normalize();
}

/*! \relates Constraint */
inline bool
operator==(const Constraint& x, const Constraint& y) {
  return x.is_equivalent_to(y);
}

/*! \relates Constraint */
inline bool
operator!=(const Constraint& x, const Constraint& y) {
  return !x.is_equivalent_to(y);
}

/*! \relates Constraint */
inline Constraint
operator==(const Linear_Expression& e1, const Linear_Expression& e2) {
  Linear_Expression diff(e1,
                         std::max(e1.space_dimension(), e2.space_dimension()),
                         Constraint::default_representation);
  diff -= e2;
  return Constraint(diff, Constraint::EQUALITY, NECESSARILY_CLOSED);
}

/*! \relates Constraint */
inline Constraint
operator==(Variable v1, Variable v2) {
  if (v1.space_dimension() > v2.space_dimension()) {
    swap(v1, v2);
  }
  PPL_ASSERT(v1.space_dimension() <= v2.space_dimension());

  Linear_Expression diff(v1, Constraint::default_representation);
  diff -= v2;
  return Constraint(diff, Constraint::EQUALITY, NECESSARILY_CLOSED);
}

/*! \relates Constraint */
inline Constraint
operator>=(const Linear_Expression& e1, const Linear_Expression& e2) {
  Linear_Expression diff(e1,
                         std::max(e1.space_dimension(), e2.space_dimension()),
                         Constraint::default_representation);
  diff -= e2;
  return Constraint(diff, Constraint::NONSTRICT_INEQUALITY, NECESSARILY_CLOSED);
}

/*! \relates Constraint */
inline Constraint
operator>=(const Variable v1, const Variable v2) {
  Linear_Expression diff(Constraint::default_representation);
  diff.set_space_dimension(std::max(v1.space_dimension(),
                                    v2.space_dimension()));
  diff += v1;
  diff -= v2;
  return Constraint(diff, Constraint::NONSTRICT_INEQUALITY, NECESSARILY_CLOSED);
}

/*! \relates Constraint */
inline Constraint
operator>(const Linear_Expression& e1, const Linear_Expression& e2) {
  Linear_Expression diff(e1, Constraint::default_representation);
  diff -= e2;
  Constraint c(diff, Constraint::STRICT_INEQUALITY, NOT_NECESSARILY_CLOSED);

  // NOTE: this also enforces normalization.
  c.set_epsilon_coefficient(-1);
  PPL_ASSERT(c.OK());

  return c;
}

/*! \relates Constraint */
inline Constraint
operator>(const Variable v1, const Variable v2) {
  Linear_Expression diff(Constraint::default_representation);
  diff.set_space_dimension(std::max(v1.space_dimension(),
                                    v2.space_dimension()));
  diff += v1;
  diff -= v2;
  Constraint c(diff, Constraint::STRICT_INEQUALITY, NOT_NECESSARILY_CLOSED);

  c.set_epsilon_coefficient(-1);
  PPL_ASSERT(c.OK());

  return c;
}

/*! \relates Constraint */
inline Constraint
operator==(Coefficient_traits::const_reference n, const Linear_Expression& e) {
  Linear_Expression diff(e, Constraint::default_representation);
  neg_assign(diff);
  diff += n;
  return Constraint(diff, Constraint::EQUALITY, NECESSARILY_CLOSED);
}

/*! \relates Constraint */
inline Constraint
operator>=(Coefficient_traits::const_reference n, const Linear_Expression& e) {
  Linear_Expression diff(e, Constraint::default_representation);
  neg_assign(diff);
  diff += n;
  return Constraint(diff, Constraint::NONSTRICT_INEQUALITY, NECESSARILY_CLOSED);
}

/*! \relates Constraint */
inline Constraint
operator>(Coefficient_traits::const_reference n, const Linear_Expression& e) {
  Linear_Expression diff(e, Constraint::default_representation);
  neg_assign(diff);
  diff += n;
  Constraint c(diff, Constraint::STRICT_INEQUALITY, NOT_NECESSARILY_CLOSED);

  // NOTE: this also enforces normalization.
  c.set_epsilon_coefficient(-1);
  PPL_ASSERT(c.OK());

  return c;
}

/*! \relates Constraint */
inline Constraint
operator==(const Linear_Expression& e, Coefficient_traits::const_reference n) {
  Linear_Expression diff(e, Constraint::default_representation);
  diff -= n;
  return Constraint(diff, Constraint::EQUALITY, NECESSARILY_CLOSED);
}

/*! \relates Constraint */
inline Constraint
operator>=(const Linear_Expression& e, Coefficient_traits::const_reference n) {
  Linear_Expression diff(e, Constraint::default_representation);
  diff -= n;
  return Constraint(diff, Constraint::NONSTRICT_INEQUALITY, NECESSARILY_CLOSED);
}

/*! \relates Constraint */
inline Constraint
operator>(const Linear_Expression& e, Coefficient_traits::const_reference n) {
  Linear_Expression diff(e, Constraint::default_representation);
  diff -= n;
  Constraint c(diff, Constraint::STRICT_INEQUALITY, NOT_NECESSARILY_CLOSED);

  // NOTE: this also enforces normalization.
  c.set_epsilon_coefficient(-1);
  PPL_ASSERT(c.OK());

  return c;
}

/*! \relates Constraint */
inline Constraint
operator<=(const Linear_Expression& e1, const Linear_Expression& e2) {
  return e2 >= e1;
}

/*! \relates Constraint */
inline Constraint
operator<=(const Variable v1, const Variable v2) {
  return v2 >= v1;
}

/*! \relates Constraint */
inline Constraint
operator<=(Coefficient_traits::const_reference n, const Linear_Expression& e) {
  return e >= n;
}

/*! \relates Constraint */
inline Constraint
operator<=(const Linear_Expression& e, Coefficient_traits::const_reference n) {
  return n >= e;
}

/*! \relates Constraint */
inline Constraint
operator<(const Linear_Expression& e1, const Linear_Expression& e2) {
  return e2 > e1;
}

/*! \relates Constraint */
inline Constraint
operator<(const Variable v1, const Variable v2) {
  return v2 > v1;
}

/*! \relates Constraint */
inline Constraint
operator<(Coefficient_traits::const_reference n, const Linear_Expression& e) {
  return e > n;
}

/*! \relates Constraint */
inline Constraint
operator<(const Linear_Expression& e, Coefficient_traits::const_reference n) {
  return n > e;
}

inline const Constraint&
Constraint::zero_dim_false() {
  PPL_ASSERT(zero_dim_false_p != 0);
  return *zero_dim_false_p;
}

inline const Constraint&
Constraint::zero_dim_positivity() {
  PPL_ASSERT(zero_dim_positivity_p != 0);
  return *zero_dim_positivity_p;
}

inline const Constraint&
Constraint::epsilon_geq_zero() {
  PPL_ASSERT(epsilon_geq_zero_p != 0);
  return *epsilon_geq_zero_p;
}

inline const Constraint&
Constraint::epsilon_leq_one() {
  PPL_ASSERT(epsilon_leq_one_p != 0);
  return *epsilon_leq_one_p;
}

inline void
Constraint::m_swap(Constraint& y) {
  using std::swap;
  swap(expr, y.expr);
  swap(kind_, y.kind_);
  swap(topology_, y.topology_);
}

inline Coefficient_traits::const_reference
Constraint::epsilon_coefficient() const {
  PPL_ASSERT(is_not_necessarily_closed());
  return expr.coefficient(Variable(expr.space_dimension() - 1));
}

inline void
Constraint::set_epsilon_coefficient(Coefficient_traits::const_reference n) {
  PPL_ASSERT(is_not_necessarily_closed());
  expr.set_coefficient(Variable(expr.space_dimension() - 1), n);
}

/*! \relates Constraint */
inline void
swap(Constraint& x, Constraint& y) {
  x.m_swap(y);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Constraint_defs.hh line 835. */

/* Automatically generated from PPL source file ../src/Generator_defs.hh line 1. */
/* Generator class declaration.
*/


/* Automatically generated from PPL source file ../src/Generator_System_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Generator_System;
class Generator_System_const_iterator;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Grid_Generator_System_types.hh line 1. */


namespace Parma_Polyhedra_Library {

class Grid_Generator_System;

}

/* Automatically generated from PPL source file ../src/Generator_defs.hh line 38. */

/* Automatically generated from PPL source file ../src/distances_defs.hh line 1. */
/* Class declarations for several distances.
*/


/* Automatically generated from PPL source file ../src/distances_types.hh line 1. */


namespace Parma_Polyhedra_Library {

template <typename Temp>
struct Rectilinear_Distance_Specialization;

template <typename Temp>
struct Euclidean_Distance_Specialization;

template <typename Temp>
struct L_Infinity_Distance_Specialization;

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/distances_defs.hh line 29. */

template <typename Temp>
struct Parma_Polyhedra_Library::Rectilinear_Distance_Specialization {
  static void combine(Temp& running, const Temp& current, Rounding_Dir dir);

  static void finalize(Temp&, Rounding_Dir);
};

template <typename Temp>
struct Parma_Polyhedra_Library::Euclidean_Distance_Specialization {
  static void combine(Temp& running, Temp& current, Rounding_Dir dir);

  static void finalize(Temp& running, Rounding_Dir dir);
};


template <typename Temp>
struct Parma_Polyhedra_Library::L_Infinity_Distance_Specialization {
  static void combine(Temp& running, const Temp& current, Rounding_Dir);

  static void finalize(Temp&, Rounding_Dir);
};

/* Automatically generated from PPL source file ../src/distances_inlines.hh line 1. */
/* Inline functions implementing distances.
*/


/* Automatically generated from PPL source file ../src/distances_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

// A struct to work around the lack of partial specialization
// of function templates in C++.
template <typename To, typename From>
struct maybe_assign_struct {
  static inline Result
  function(const To*& top, To& tmp, const From& from, Rounding_Dir dir) {
    // When `To' and `From' are different types, we make the conversion
    // and use `tmp'.
    top = &tmp;
    return assign_r(tmp, from, dir);
  }
};

template <typename Type>
struct maybe_assign_struct<Type, Type> {
  static inline Result
  function(const Type*& top, Type&, const Type& from, Rounding_Dir) {
    // When the types are the same, conversion is unnecessary.
    top = &from;
    return V_EQ;
  }
};

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  Assigns to \p top a pointer to a location that holds the
  conversion, according to \p dir, of \p from to type \p To.  When
  necessary, and only when necessary, the variable \p tmp is used to
  hold the result of conversion.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename To, typename From>
inline Result
maybe_assign(const To*& top, To& tmp, const From& from, Rounding_Dir dir) {
  return maybe_assign_struct<To, From>::function(top, tmp, from, dir);
}

template <typename Temp>
inline void
Rectilinear_Distance_Specialization<Temp>::combine(Temp& running,
                                                   const Temp& current,
                                                   Rounding_Dir dir) {
  add_assign_r(running, running, current, dir);
}

template <typename Temp>
inline void
Rectilinear_Distance_Specialization<Temp>::finalize(Temp&, Rounding_Dir) {
}

template <typename Temp>
inline void
Euclidean_Distance_Specialization<Temp>::combine(Temp& running,
                                                 Temp& current,
                                                 Rounding_Dir dir) {
  mul_assign_r(current, current, current, dir);
  add_assign_r(running, running, current, dir);
}

template <typename Temp>
inline void
Euclidean_Distance_Specialization<Temp>::finalize(Temp& running,
                                                  Rounding_Dir dir) {
  sqrt_assign_r(running, running, dir);
}

template <typename Temp>
inline void
L_Infinity_Distance_Specialization<Temp>::combine(Temp& running,
                                                  const Temp& current,
                                                  Rounding_Dir) {
  if (current > running) {
    running = current;
  }
}

template <typename Temp>
inline void
L_Infinity_Distance_Specialization<Temp>::finalize(Temp&, Rounding_Dir) {
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/distances_defs.hh line 53. */

/* Automatically generated from PPL source file ../src/Expression_Hide_Inhomo_defs.hh line 1. */
/* Expression_Hide_Inhomo class declaration.
*/


/* Automatically generated from PPL source file ../src/Expression_Hide_Inhomo_defs.hh line 28. */

/* Automatically generated from PPL source file ../src/Expression_Hide_Inhomo_defs.hh line 32. */

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
/*! \brief
  An adapter for Linear_Expression that hides the inhomogeneous term.

  The methods of this class always pretend that the value of the
  inhomogeneous term is zero.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
template <typename T>
class Parma_Polyhedra_Library::Expression_Hide_Inhomo
  : public Expression_Adapter<T> {
  typedef Expression_Adapter<T> base_type;
public:
  //! The type of this object.
  typedef Expression_Hide_Inhomo<T> const_reference;
  //! The type obtained by one-level unwrapping.
  typedef typename base_type::inner_type inner_type;
  //! The raw, completely unwrapped type.
  typedef typename base_type::raw_type raw_type;

  //! Constructor.
  explicit Expression_Hide_Inhomo(const raw_type& expr);

public:
  //! The type of const iterators on coefficients.
  typedef typename base_type::const_iterator const_iterator;

  //! Returns the constant zero.
  Coefficient_traits::const_reference inhomogeneous_term() const;

  //! Returns <CODE>true</CODE> if and only if \p *this is zero.
  bool is_zero() const;

  /*! \brief Returns \p true if \p *this is equal to \p y.

    Note that <CODE>(*this == y)</CODE> has a completely different meaning.
  */
  template <typename Expression>
  bool is_equal_to(const Expression& y) const;

  //! Returns the i-th coefficient.
  Coefficient_traits::const_reference get(dimension_type i) const;

  //! Returns the coefficient of v.
  Coefficient_traits::const_reference get(Variable v) const;

  /*! \brief
    Returns <CODE>true</CODE> if the coefficient of each variable in
    \p vars is zero.
  */
  bool all_zeroes(const Variables_Set& vars) const;

  /*! \brief
    Returns <CODE>true</CODE> if (*this)[i] is zero,
    for each i in [start, end).
  */
  bool all_zeroes(dimension_type start, dimension_type end) const;

  /*! \brief
    Returns the number of zero coefficient in [start, end).
  */
  dimension_type num_zeroes(dimension_type start, dimension_type end) const;

  /*! \brief
    Returns the gcd of the nonzero coefficients in [start,end). If all the
    coefficients in this range are zero, returns zero.
  */
  Coefficient gcd(dimension_type start, dimension_type end) const;

  //! Returns the index of the last nonzero element, or zero if there are no
  //! nonzero elements.
  dimension_type last_nonzero() const;

  //! Returns the index of the last nonzero element in [first,last), or last
  //! if there are no nonzero elements.
  dimension_type last_nonzero(dimension_type first, dimension_type last) const;

  //! Returns the index of the first nonzero element, or \p last if there
  //! are no nonzero elements, considering only elements in [first,last).
  dimension_type first_nonzero(dimension_type first, dimension_type last) const;

  /*! \brief
    Returns <CODE>true</CODE> if all coefficients in [start,end),
    except those corresponding to variables in \p vars, are zero.
  */
  bool all_zeroes_except(const Variables_Set& vars,
                         dimension_type start, dimension_type end) const;

  //! Removes from set \p x all the indexes of nonzero elements in \p *this.
  void has_a_free_dimension_helper(std::set<dimension_type>& x) const;

  //! Returns \c true if <CODE>(*this)[i]</CODE> is equal to <CODE>y[i]</CODE>,
  //! for each i in [start,end).
  template <typename Expression>
  bool is_equal_to(const Expression& y,
                   dimension_type start, dimension_type end) const;

  //! Returns \c true if <CODE>(*this)[i]*c1</CODE> is equal to
  //! <CODE>y[i]*c2</CODE>, for each i in [start,end).
  template <typename Expression>
  bool is_equal_to(const Expression& y,
                   Coefficient_traits::const_reference c1,
                   Coefficient_traits::const_reference c2,
                   dimension_type start, dimension_type end) const;

  //! Sets \p r to a copy of the row as adapted by \p *this.
  void get_row(Dense_Row& r) const;

  //! Sets \p r to a copy of the row as adapted by \p *this.
  void get_row(Sparse_Row& r) const;
};

/* Automatically generated from PPL source file ../src/Expression_Hide_Inhomo_inlines.hh line 1. */
/* Expression_Hide_Inhomo class implementation: inline functions.
*/


/* Automatically generated from PPL source file ../src/Expression_Hide_Inhomo_inlines.hh line 28. */

namespace Parma_Polyhedra_Library {

template <typename T>
Expression_Hide_Inhomo<T>::Expression_Hide_Inhomo(const raw_type& expr)
  : base_type(expr) {
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Hide_Inhomo<T>::inhomogeneous_term() const {
  // Pretend it is zero.
  return Coefficient_zero();
}

template <typename T>
inline bool
Expression_Hide_Inhomo<T>::is_zero() const {
  // Don't check the inhomogeneous_term (i.e., pretend it is zero).
  return this->inner().all_homogeneous_terms_are_zero();
}

template <typename T>
template <typename Expression>
inline bool
Expression_Hide_Inhomo<T>
::is_equal_to(const Expression& y) const {
  const dimension_type x_dim = this->space_dimension();
  const dimension_type y_dim = y.space_dimension();
  if (x_dim != y_dim) {
    return false;
  }
  if (y.inhomogeneous_term() != 0) {
    return false;
  }
  // Note that the inhomogeneous term is not compared.
  return this->inner().is_equal_to(y, 1, x_dim + 1);
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Hide_Inhomo<T>::get(dimension_type i) const {
  if (i == 0) {
    return Coefficient_zero();
  }
  else {
    return this->inner().get(i);
  }
}

template <typename T>
inline Coefficient_traits::const_reference
Expression_Hide_Inhomo<T>::get(Variable v) const {
  return this->inner().get(v);
}

template <typename T>
inline bool
Expression_Hide_Inhomo<T>
::all_zeroes(const Variables_Set& vars) const {
  return this->inner().all_zeroes(vars);
}

template <typename T>
inline bool
Expression_Hide_Inhomo<T>::all_zeroes(dimension_type start,
                                      dimension_type end) const {
  if (start == end) {
    return true;
  }
  if (start == 0) {
    ++start;
  }
  return this->inner().all_zeroes(start, end);
}

template <typename T>
inline dimension_type
Expression_Hide_Inhomo<T>::num_zeroes(dimension_type start,
                                      dimension_type end) const {
  if (start == end) {
    return 0;
  }
  dimension_type nz = 0;
  if (start == 0) {
    ++start;
    ++nz;
  }
  nz += this->inner().num_zeroes(start, end);
  return nz;
}

template <typename T>
inline Coefficient
Expression_Hide_Inhomo<T>::gcd(dimension_type start,
                               dimension_type end) const {
  if (start == end) {
    return Coefficient_zero();
  }
  if (start == 0) {
    ++start;
  }
  return this->inner().gcd(start, end);
}

template <typename T>
inline dimension_type
Expression_Hide_Inhomo<T>::last_nonzero() const {
  return this->inner().last_nonzero();
}

template <typename T>
inline dimension_type
Expression_Hide_Inhomo<T>::last_nonzero(dimension_type first,
                                        dimension_type last) const {
  if (first == last) {
    return last;
  }
  if (first == 0) {
    ++first;
  }
  return this->inner().last_nonzero(first, last);
}

template <typename T>
inline dimension_type
Expression_Hide_Inhomo<T>::first_nonzero(dimension_type first,
                                         dimension_type last) const {
  if (first == last) {
    return last;
  }
  if (first == 0) {
    ++first;
  }
  return this->inner().first_nonzero(first, last);
}

template <typename T>
inline bool
Expression_Hide_Inhomo<T>
::all_zeroes_except(const Variables_Set& vars,
                    dimension_type start, dimension_type end) const {
  if (start == end) {
    return true;
  }
  if (start == 0) {
    ++start;
  }
  return this->inner().all_zeroes_except(vars, start, end);
}

template <typename T>
inline void
Expression_Hide_Inhomo<T>
::has_a_free_dimension_helper(std::set<dimension_type>& y) const {
  bool had_0 = (y.count(0) == 1);
  this->inner().has_a_free_dimension_helper(y);
  if (had_0) {
    y.insert(0);
  }
}

template <typename T>
template <typename Expression>
inline bool
Expression_Hide_Inhomo<T>
::is_equal_to(const Expression& y,
              dimension_type start, dimension_type end) const {
  if (start == end) {
    return true;
  }
  if (start == 0) {
    ++start;
  }
  return this->inner().is_equal_to(y, start, end);
}

template <typename T>
template <typename Expression>
inline bool
Expression_Hide_Inhomo<T>
::is_equal_to(const Expression& y,
              Coefficient_traits::const_reference c1,
              Coefficient_traits::const_reference c2,
              dimension_type start, dimension_type end) const {
  if (start == end) {
    return true;
  }
  if (start == 0) {
    ++start;
  }
  return this->inner().is_equal_to(y, c1, c2, start, end);
}

template <typename T>
inline void
Expression_Hide_Inhomo<T>::get_row(Dense_Row& r) const {
  this->inner().get_row(r);
  r.reset(0);
}

template <typename T>
inline void
Expression_Hide_Inhomo<T>::get_row(Sparse_Row& r) const {
  this->inner().get_row(r);
  r.reset(0);
}

} // namespace Parma_Polyhedra_Library

/* Automatically generated from PPL source file ../src/Expression_Hide_Inhomo_defs.hh line 146. */

/* Automatically generated from PPL source file ../src/Generator_defs.hh line 46. */

#include <iosfwd>

namespace Parma_Polyhedra_Library {

// Put them in the namespace here to declare them friend later.

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
//! The basic comparison function.
/*! \relates Generator
  \return
  The returned absolute value can be \f$0\f$, \f$1\f$ or \f$2\f$.

  \param x
  A row of coefficients;

  \param y
  Another row.

  Compares \p x and \p y, where \p x and \p y may be of different size,
  in which case the "missing" coefficients are assumed to be zero.
  The comparison is such that:
  -# equalities are smaller than inequalities;
  -# lines are smaller than points and rays;
  -# the ordering is lexicographic;
  -# the positions compared are, in decreasing order of significance,
     1, 2, ..., \p size(), 0;
  -# the result is negative, zero, or positive if x is smaller than,
     equal to, or greater than y, respectively;
  -# when \p x and \p y are different, the absolute value of the
     result is 1 if the difference is due to the coefficient in
     position 0; it is 2 otherwise.

  When \p x and \p y represent the hyper-planes associated
  to two equality or inequality constraints, the coefficient
  at 0 is the known term.
  In this case, the return value can be characterized as follows:
  - -2, if \p x is smaller than \p y and they are \e not parallel;
  - -1, if \p x is smaller than \p y and they \e are parallel;
  -  0, if \p x and y are equal;
  - +1, if \p y is smaller than \p x and they \e are parallel;
  - +2, if \p y is smaller than \p x and they are \e not parallel.
*/
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
int compare(const Generator& x, const Generator& y);

namespace IO_Operators {

//! Output operator.
/*! \relates Parma_Polyhedra_Library::Generator */
std::ostream& operator<<(std::ostream& s, const Generator& g);

} // namespace IO_Operators

//! Swaps \p x with \p y.
/*! \relates Generator */
void swap(Generator& x, Generator& y);

} // namespace Parma_Polyhedra_Library


//! A line, ray, point or closure point.
/*! \ingroup PPL_CXX_interface
  An object of the class Generator is one of the following:

  - a line \f$\vect{l} = (a_0, \ldots, a_{n-1})^\transpose\f$;

  - a ray \f$\vect{r} = (a_0, \ldots, a_{n-1})^\transpose\f$;

  - a point
    \f$\vect{p} = (\frac{a_0}{d}, \ldots, \frac{a_{n-1}}{d})^\transpose\f$;

  - a closure point
    \f$\vect{c} = (\frac{a_0}{d}, \ldots, \frac{a_{n-1}}{d})^\transpose\f$;

  where \f$n\f$ is the dimension of the space
  and, for points and closure points, \f$d > 0\f$ is the divisor.

  \par A note on terminology.
  As observed in Section \ref representation, there are cases when,
  in order to represent a polyhedron \f$\cP\f$ using the generator system
  \f$\cG = (L, R, P, C)\f$, we need to include in the finite set
  \f$P\f$ even points of \f$\cP\f$ that are <EM>not</EM> vertices
  of \f$\cP\f$.
  This situation is even more frequent when working with NNC polyhedra
  and it is the reason why we prefer to use the word `point'
  where other libraries use the word `vertex'.

  \par How to build a generator.
  Each type of generator is built by applying the corresponding
  function (<CODE>line</CODE>, <CODE>ray</CODE>, <CODE>point</CODE>
  or <CODE>closure_point</CODE>) to a linear expression,
  representing a direction in the space;
  the space dimension of the generator is defined as the space dimension
  of the corresponding linear expression.
  Linear expressions used to define a generator should be homogeneous
  (any constant term will be simply ignored).
  When defining points and closure points, an optional Coefficient argument
  can be used as a common <EM>divisor</EM> for all the coefficients
  occurring in the provided linear expression;
  the default value for this argument is 1.

  \par
  In all the following examples it is assumed that variables
  <CODE>x</CODE>, <CODE>y</CODE> and <CODE>z</CODE>
  are defined as follows:
  \code
  Variable x(0);
  Variable y(1);
  Variable z(2);
  \endcode

  \par Example 1
  The following code builds a line with direction \f$x-y-z\f$
  and having space dimension \f$3\f$:
  \code
  Generator l = line(x - y - z);
  \endcode
  As mentioned above, the constant term of the linear expression
  is not relevant. Thus, the following code has the same effect:
  \code
  Generator l = line(x - y - z + 15);
  \endcode
  By definition, the origin of the space is not a line, so that
  the following code throws an exception:
  \code
  Generator l = line(0*x);
  \endcode

  \par Example 2
  The following code builds a ray with the same direction as the
  line in Example 1:
  \code
  Generator r = ray(x - y - z);
  \endcode
  As is the case for lines, when specifying a ray the constant term
  of the linear expression is not relevant; also, an exception is thrown
  when trying to build a ray from the origin of the space.

  \par Example 3
  The following code builds the point
  \f$\vect{p} = (1, 0, 2)^\transpose \in \Rset^3\f$:
  \code
  Generator p = point(1*x + 0*y + 2*z);
  \endcode
  The same effect can be obtained by using the following code:
  \code
  Generator p = point(x + 2*z);
  \endcode
  Similarly, the origin \f$\vect{0} \in \Rset^3\f$ can be defined
  using either one of the following lines of code:
  \code
  Generator origin3 = point(0*x + 0*y + 0*z);
  Generator origin3_alt = point(0*z);
  \endcode
  Note however that the following code would have defined
  a different point, namely \f$\vect{0} \in \Rset^2\f$:
  \code
  Generator origin2 = point(0*y);
  \endcode
  The following two lines of code both define the only point
  having space dimension zero, namely \f$\vect{0} \in \Rset^0\f$.
  In the second case we exploit the fact that the first argument
  of the function <CODE>point</CODE> is optional.
  \code
  Generator origin0 = Generator::zero_dim_point();
  Generator origin0_alt = point();
  \endcode

  \par Example 4
  The point \f$\vect{p}\f$ specified in Example 3 above
  can also be obtained with the following code,
  where we provide a non-default value for the second argument
  of the function <CODE>point</CODE> (the divisor):
  \code
  Generator p = point(2*x + 0*y + 4*z, 2);
  \endcode
  Obviously, the divisor can be usefully exploited to specify
  points having some non-integer (but rational) coordinates.
  For instance, the point
  \f$\vect{q} = (-1.5, 3.2, 2.1)^\transpose \in \Rset^3\f$
  can be specified by the following code:
  \code
  Generator q = point(-15*x + 32*y + 21*z, 10);
  \endcode
  If a zero divisor is provided, an exception is thrown.

  \par Example 5
  Closure points are specified in the same way we defined points,
  but invoking their specific constructor function.
  For instance, the closure point
  \f$\vect{c} = (1, 0, 2)^\transpose \in \Rset^3\f$ is defined by
  \code
  Generator c = closure_point(1*x + 0*y + 2*z);
  \endcode
  For the particular case of the (only) closure point
  having space dimension zero, we can use any of the following:
  \code
  Generator closure_origin0 = Generator::zero_dim_closure_point();
  Generator closure_origin0_alt = closure_point();
  \endcode

  \par How to inspect a generator
  Several methods are provided to examine a generator and extract
  all the encoded information: its space dimension, its type and
  the value of its integer coefficients.

  \par Example 6
  The following code shows how it is possible to access each single
  coefficient of a generator.
  If <CODE>g1</CODE> is a point having coordinates
  \f$(a_0, \ldots, a_{n-1})^\transpose\f$,
  we construct the closure point <CODE>g2</CODE> having coordinates
  \f$(a_0, 2 a_1, \ldots, (i+1)a_i, \ldots, n a_{n-1})^\transpose\f$.
  \code
  if (g1.is_point()) {
    cout << "Point g1: " << g1 << endl;
    Linear_Expression e;
    for (dimension_type i = g1.space_dimension(); i-- > 0; )
      e += (i + 1) * g1.coefficient(Variable(i)) * Variable(i);
    Generator g2 = closure_point(e, g1.divisor());
    cout << "Closure point g2: " << g2 << endl;
  }
  else
    cout << "Generator g1 is not a point." << endl;
  \endcode
  Therefore, for the point
  \code
  Generator g1 = point(2*x - y + 3*z, 2);
  \endcode
  we would obtain the following output:
  \code
  Point g1: p((2*A - B + 3*C)/2)
  Closure point g2: cp((2*A - 2*B + 9*C)/2)
  \endcode
  When working with (closure) points, be careful not to confuse
  the notion of <EM>coefficient</EM> with the notion of <EM>coordinate</EM>:
  these are equivalent only when the divisor of the (closure) point is 1.
*/
class Parma_Polyhedra_Library::Generator {
public:

  //! The representation used for new Generators.
  /*!
    \note The copy constructor and the copy constructor with specified size
          use the representation of the original object, so that it is
          indistinguishable from the original object.
  */
  static const Representation default_representation = SPARSE;

  //! Returns the line of direction \p e.
  /*!
    \exception std::invalid_argument
    Thrown if the homogeneous part of \p e represents the origin of
    the vector space.
  */
  static Generator line(const Linear_Expression& e,
                        Representation r = default_representation);

  //! Returns the ray of direction \p e.
  /*!
    \exception std::invalid_argument
    Thrown if the homogeneous part of \p e represents the origin of
    the vector space.
  */
  static Generator ray(const Linear_Expression& e,
                       Representation r = default_representation);

  //! Returns the point at \p e / \p d.
  /*!
    Both \p e and \p d are optional arguments, with default values
    Linear_Expression::zero() and Coefficient_one(), respectively.

    \exception std::invalid_argument
    Thrown if \p d is zero.
  */
  static Generator point(const Linear_Expression& e
                         = Linear_Expression::zero(),
                         Coefficient_traits::const_reference d
                         = Coefficient_one(),
                         Representation r = default_representation);

  //! Returns the origin.
  static Generator point(Representation r);

  //! Returns the point at \p e.
  static Generator point(const Linear_Expression& e,
                         Representation r);

  //! Constructs the point at the origin.
  explicit Generator(Representation r = default_representation);

  //! Returns the closure point at \p e / \p d.
  /*!
    Both \p e and \p d are optional arguments, with default values
    Linear_Expression::zero() and Coefficient_one(), respectively.

    \exception std::invalid_argument
    Thrown if \p d is zero.
  */
  static Generator
  closure_point(const Linear_Expression& e = Linear_Expression::zero(),
                Coefficient_traits::const_reference d = Coefficient_one(),
                Representation r = default_representation);

  //! Returns the closure point at the origin.
  static Generator
  closure_point(Representation r);

  //! Returns the closure point at \p e.
  static Generator
  closure_point(const Linear_Expression& e, Representation r);

  //! Ordinary copy constructor.
  //! The representation of the new Generator will be the same as g.
  Generator(const Generator& g);

  //! Copy constructor with given representation.
  Generator(const Generator& g, Representation r);

  //! Copy constructor with given space dimension.
  //! The representation of the new Generator will be the same as g.
  Generator(const Generator& g, dimension_type space_dim);

  //! Copy constructor with given representation and space dimension.
  Generator(const Generator& g, dimension_type space_dim, Representation r);

  //! Destructor.
  ~Generator();

  //! Assignment operator.
  Generator& operator=(const Generator& g);

  //! Returns the current representation of *this.
  Representation representation() const;

  //! Converts *this to the specified representation.
  void set_representation(Representation r);

  //! Returns the maximum space dimension a Generator can handle.
  static dimension_type max_space_dimension();

  //! Returns the dimension of the vector space enclosing \p *this.
  dimension_type space_dimension() const;

  //! Sets the dimension of the vector space enclosing \p *this to
  //! \p space_dim .
  void set_space_dimension(dimension_type space_dim);

  //! Swaps the coefficients of the variables \p v1 and \p v2 .
  void swap_space_dimensions(Variable v1, Variable v2);

  //! Removes all the specified dimensions from the generator.
  /*!
    The space dimension of the variable with the highest space
    dimension in \p vars must be at most the space dimension
    of \p this.

    If all dimensions with nonzero coefficients are removed from a ray or a
    line, it is changed into a point and this method returns \p false .
    Otherwise, it returns \p true .
  */
  bool remove_space_dimensions(const Variables_Set& vars);

  //! Permutes the space dimensions of the generator.
  /*!
    \param cycle
    A vector representing a cycle of the permutation according to which the
    space dimensions must be rearranged.

    The \p cycle vector represents a cycle of a permutation of space
    dimensions.
    For example, the permutation
    \f$ \{ x_1 \mapsto x_2, x_2 \mapsto x_3, x_3 \mapsto x_1 \}\f$ can be
    represented by the vector containing \f$ x_1, x_2, x_3 \f$.
  */
  void permute_space_dimensions(const std::vector<Variable>& cycle);

  //! Shift by \p n positions the coefficients of variables, starting from
  //! the coefficient of \p v. This increases the space dimension by \p n.
  void shift_space_dimensions(Variable v, dimension_type n);

  //! The generator type.
  enum Type {
    /*! The generator is a line. */
    LINE,
    /*! The generator is a ray. */
    RAY,
    /*! The generator is a point. */
    POINT,
    /*! The generator is a closure point. */
    CLOSURE_POINT
  };

  //! Returns the generator type of \p *this.
  Type type() const;

  //! Returns <CODE>true</CODE> if and only if \p *this is a line.
  bool is_line() const;

  //! Returns <CODE>true</CODE> if and only if \p *this is a ray.
  bool is_ray() const;

#ifdef PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS
  //! Returns <CODE>true</CODE> if and only if \p *this is a line or a ray.
#endif // defined(PPL_DOXYGEN_INCLUDE_IMPLEMENTATION_DETAILS)
  bool is_line_or_ray() const;

  //! Returns <CODE>true</CODE> if and only if \p *this is a point.
  bool is_point() const;

  //! Returns <CODE>true</CODE> if and only if \p *this is a closure point.
  bool is_closure_point() const;

  //! Returns the coefficient of \p v in \p *this.
  /*!
    \exception std::invalid_argument
    Thrown if the index of \p v is greater than or equal to the
    space dimension of \p *this.
  */
  Coefficient_traits::const_reference coefficient(Variable v) const;

  //! If \p *this is either a point or a closure point, returns its divisor.
  /*!
    \exception std::invalid_argument
    Thrown if \p *this is neither a point nor a closure point.
  */
  Coefficient_traits::const_reference divisor() const;

  //! Initializes the class.
  static void initialize();

  //! Finalizes the class.
  static void finalize();

  //! Returns the origin of the zero-dimensional space \f$\Rset^0\f$.
  static const Generator& zero_dim_point();

  /*! \brief
    Returns, as a closure point,
    the origin of the zero-dimensional space \f$\Rset^0\f$.
  */
  static const Generator& zero_dim_closure_point();

  /*! \brief
    Returns a lower bound to the total size in bytes of the memory
    occupied by \p *this.
  */
  memory_size_type total_memory_in_bytes() const;

  //! Returns the size in bytes of the memory managed by \p *this.
  memory_size_type external_memory_in_bytes() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if \p *this and \p y
    are equivalent generators.

    Generators having different space dimensions are not equivalent.
  */
  bool is_equivalent_to(const Generator& y) const;

  //! Returns <CODE>true</CODE> if \p *this is identical to \p y.
  /*!
    This is faster than is_equivalent_to(), but it may return `false' even
    for equivalent generators.
  */
  bool is_equal_to(const Generator& y) const;

  //! Checks if all the invariants are satisfied.
  bool OK() const;

  PPL_OUTPUT_DECLARATIONS

  /*! \brief
    Loads from \p s an ASCII representation (as produced by
    ascii_dump(std::ostream&) const) and sets \p *this accordingly.
    Returns <CODE>true</CODE> if successful, <CODE>false</CODE> otherwise.
  */
  bool ascii_load(std::istream& s);

  //! Swaps \p *this with \p y.
  void m_swap(Generator& y);

  //! The type of the (adapted) internal expression.
  typedef Expression_Hide_Last<Expression_Hide_Inhomo<Linear_Expression> >
  expr_type;
  //! Partial read access to the (adapted) internal expression.
  expr_type expression() const;

private:
  //! The possible kinds of Generator objects.
  enum Kind {
    LINE_OR_EQUALITY = 0,
    RAY_OR_POINT_OR_INEQUALITY = 1
  };

  //! The linear expression encoding \p *this.
  Linear_Expression expr;

  //! The kind of \p *this.
  Kind kind_;

  //! The topology of \p *this.
  Topology topology_;

  /*! \brief
    Holds (between class initialization and finalization) a pointer to
    the origin of the zero-dimensional space \f$\Rset^0\f$.
  */
  static const Generator* zero_dim_point_p;

  /*! \brief
    Holds (between class initialization and finalization) a pointer to
    the origin of the zero-dimensional space \f$\Rset^0\f$, as a closure point.
  */
  static const Generator* zero_dim_closure_point_p;

  /*! \brief
    Builds a generator of type \p type and topology \p topology,
    stealing the coefficients from \p e.

    If the topology is NNC, the last dimension of \p e is used as the epsilon
    coefficient.
  */
  Generator(Linear_Expression& e, Type type, Topology topology);

  Generator(Linear_Expression& e, Kind kind, Topology topology);

  Generator(dimension_type space_dim, Kind kind, Topology topology,
            Representation r = default_representation);

  /*! \brief
    Returns <CODE>true</CODE> if and only if \p *this row
    represents a line or an equality.
  */
  bool is_line_or_equality() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if \p *this row
    represents a ray, a point or an inequality.
  */
  bool is_ray_or_point_or_inequality() const;

  //! Sets to \p LINE_OR_EQUALITY the kind of \p *this row.
  void set_is_line_or_equality();

  //! Sets to \p RAY_OR_POINT_OR_INEQUALITY the kind of \p *this row.
  void set_is_ray_or_point_or_inequality();

  //! \name Flags inspection methods
  //@{
  //! Returns the topological kind of \p *this.
  Topology topology() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if the topology
    of \p *this row is not necessarily closed.
  */
  bool is_not_necessarily_closed() const;

  /*! \brief
    Returns <CODE>true</CODE> if and only if the topology
    of \p *this row is necessarily closed.
  */
  bool is_necessarily_closed() const;
  //@} // Flags inspection methods

  //! \name Flags coercion methods
  //@{

  //! Sets to \p x the topological kind of \p *this row.
  void set_topology(Topology x);

  //! Sets to \p NECESSARILY_CLOSED the topological kind of \p *this row.
  void set_necessarily_closed();

  //! Sets to \p NOT_NECESSARILY_CLOSED the topological kind of \p *this row.
  void set_not_necessarily_closed();
  //@} // Flags coercion methods

  //! Marks the epsilon dimension as a standard dimension.
  /*!
    The row topology is changed to <CODE>NECESSARILY_CLOSED</CODE>, and
    the number of space dimensions is increased by 1.
  */
  void mark_as_necessarily_closed();

  //! Marks the last dimension as the epsilon dimension.
  /*!
    The row topology is changed to <CODE>NOT_NECESSARILY_CLOSED</CODE>, and
    the number of space dimensions is decreased by 1.
  */
  void mark_as_not_necessarily_closed();

  //! Linearly combines \p *this with \p y so that i-th coefficient is 0.
  /*!
    \param y
    The Generator that will be combined with \p *this object;

    \param i
    The index of the coefficient that has to become \f$0\f$.

    Computes a linear combination of \p *this and \p y having
    the i-th coefficient equal to \f$0\f$. Then it assigns
    the resulting Generator to \p *this and normalizes it.
  */
  void linear_combine(const Generator& y, dimension_type i);

  //! Sets the dimension of the vector space enclosing \p *this to
  //! \p space_dim .
  //! Sets the space dimension of the rows in the system to \p space_dim .
  /*!
    This method is for internal use, it does *not* assert OK() at the end,
    so it can be used for invalid objects.
  */
  void set_space_dimension_no_ok(dimension_type space_dim);

  /*! \brief
    Throw a <CODE>std::invalid_argument</CODE> exception
    containing the appropriate error message.
  */
  void
  throw_dimension_incompatible(const char* method,
                               const char* v_name,
                               Variable v) const;

  /*! \brief
    Throw a <CODE>std::invalid_argument</CODE> exception
    containing the appropriate error message.
  */
  void
  throw_invalid_argument(const char* method, const char* reason) const;

  //! Returns <CODE>true</CODE> if and only if \p *this is not a line.
  bool is_ray_or_point() const;

  //! Sets the Generator kind to <CODE>LINE_OR_EQUALITY</CODE>.
  void set_is_line();

  //! Sets the Generator kind to <CODE>RAY_OR_POINT_OR_INEQUALITY</CODE>.
  void set_is_ray_or_point();

  /*! \brief
    Returns <CODE>true</CODE> if and only if the closure point
    \p *this has the same \e coordinates of the point \p p.

    It is \e assumed that \p *this is a closure point, \p p is a point
    and both topologies and space dimensions agree.
  */
  bool is_matching_closure_point(const Generator& p) const;

  //! Returns the epsilon coefficient. The generator must be NNC.
  Coefficient_traits::const_reference epsilon_coefficient() const;

  //! Sets the epsilon coefficient to \p n. The generator must be NNC.
  void set_epsilon_coefficient(Coefficient_traits::const_reference n);

  /*! \brief
    Normalizes the sign of the coefficients s